

#---------------------------
# Constant blocks
#---------------------------

#---------------------------
# Platform Parameters for versal_extensible_platform_base
#---------------------------
set axi_smc_vip_hier_icn_ctrl [get_bd_cell /axi_smc_vip_hier/icn_ctrl]
    
set_property -dict [ list \
  CONFIG.NUM_SI 1 \
  CONFIG.NUM_MI 8 \
  CONFIG.NUM_CLKS 1 \
  ] $axi_smc_vip_hier_icn_ctrl
set axi_smc_vip_hier_icn_ctrl_0 [get_bd_cell /axi_smc_vip_hier/icn_ctrl_0]
    
set_property -dict [ list \
  CONFIG.NUM_SI 1 \
  CONFIG.NUM_MI 1 \
  CONFIG.NUM_CLKS 1 \
  ] $axi_smc_vip_hier_icn_ctrl_0
set axi_smc_vip_hier_icn_ctrl_1 [get_bd_cell /axi_smc_vip_hier/icn_ctrl_1]
    
set_property -dict [ list \
  CONFIG.NUM_SI 1 \
  CONFIG.NUM_MI 1 \
  CONFIG.NUM_CLKS 1 \
  ] $axi_smc_vip_hier_icn_ctrl_1
set axi_smc_vip_hier_icn_ctrl_2 [get_bd_cell /axi_smc_vip_hier/icn_ctrl_2]
    
set_property -dict [ list \
  CONFIG.NUM_SI 1 \
  CONFIG.NUM_MI 1 \
  CONFIG.NUM_CLKS 1 \
  ] $axi_smc_vip_hier_icn_ctrl_2
set axi_smc_vip_hier_icn_ctrl_3 [get_bd_cell /axi_smc_vip_hier/icn_ctrl_3]
    
set_property -dict [ list \
  CONFIG.NUM_SI 1 \
  CONFIG.NUM_MI 1 \
  CONFIG.NUM_CLKS 1 \
  ] $axi_smc_vip_hier_icn_ctrl_3
set noc_ddr4 [get_bd_cell /noc_ddr4]
    
set_property -dict [ list \
  CONFIG.NUM_SI 2 \
  CONFIG.NUM_HBM_BLI 0 \
  CONFIG.NUM_MI 0 \
  ] $noc_ddr4
set noc_lpddr4 [get_bd_cell /noc_lpddr4]
    
set_property -dict [ list \
  CONFIG.NUM_SI 0 \
  CONFIG.NUM_HBM_BLI 0 \
  CONFIG.NUM_MI 0 \
  ] $noc_lpddr4

#---------------------------
# Registering ai_engine_0
#---------------------------
set ai_engine_0 [get_bd_cells /ai_engine_0]
  
set_property -dict [ list  \
  CONFIG.NUM_MI_AXIS {1} \
  CONFIG.NUM_SI_AXIS {1} \
  CONFIG.NUM_MI_AXI {0} \
  CONFIG.C_EN_EXT_RST {1}  ] $ai_engine_0

set_property -dict [ list  \
  CONFIG.TDATA_NUM_BYTES {4} \
  CONFIG.IS_REGISTERED {true} \
  HDL_ATTRIBUTE.ME_ANNOTATION {DataIn1} ] [ get_bd_intf_pins $ai_engine_0/S00_AXIS]

set_property -dict [ list  \
  CONFIG.TDATA_NUM_BYTES {4} \
  CONFIG.IS_REGISTERED {true} \
  HDL_ATTRIBUTE.ME_ANNOTATION {DataOut1} ] [ get_bd_intf_pins $ai_engine_0/M00_AXIS]


#---------------------------
# Instantiating mm2s
#---------------------------
set mm2s [create_bd_cell -type ip -vlnv xilinx.com:hls:mm2s:1.0 mm2s]
  


#---------------------------
# Instantiating s2mm
#---------------------------
set s2mm [create_bd_cell -type ip -vlnv xilinx.com:hls:s2mm:1.0 s2mm]
  


#---------------------------
# Instantiating axi_intc_cascaded_1_intr_1_interrupt_concat
#---------------------------
set axi_intc_cascaded_1_intr_1_interrupt_concat [create_bd_cell -type ip -vlnv xilinx.com:ip:xlconcat:2.1 axi_intc_cascaded_1_intr_1_interrupt_concat]
  
set_property -dict [ list  \
  CONFIG.NUM_PORTS {32}  ] $axi_intc_cascaded_1_intr_1_interrupt_concat

#---------------------------
# Instantiating irq_const_tieoff
#---------------------------
set irq_const_tieoff [create_bd_cell -type ip -vlnv xilinx.com:ip:xlconstant:1.1 irq_const_tieoff]
  
set_property -dict [ list  \
  CONFIG.CONST_WIDTH {1} \
  CONFIG.CONST_VAL {0}  ] $irq_const_tieoff

#---------------------------
# Enable NoC automation
#---------------------------

set v_enable_auto_connections_in_noc_state [get_param bd.enableAutoConnectionsInNoc]
set_param bd.enableAutoConnectionsInNoc 1

#---------------------------
# Clock/Reset Annotation Registration
#---------------------------

::sdsoc::mark_pfm_border


#---------------------------
# Connectivity Phase 1
#---------------------------
connect_bd_intf_net \
  [get_bd_intf_pins -auto_enable /axi_smc_vip_hier/icn_ctrl/M06_AXI] \
  [get_bd_intf_pins -auto_enable /mm2s/s_axi_control] \

connect_bd_intf_net \
  [get_bd_intf_pins -auto_enable /mm2s/m_axi_gmem] \
  [get_bd_intf_pins -auto_enable /noc_ddr4/S00_AXI] \

connect_bd_intf_net \
  [get_bd_intf_pins -auto_enable /axi_smc_vip_hier/icn_ctrl/M07_AXI] \
  [get_bd_intf_pins -auto_enable /s2mm/s_axi_control] \

connect_bd_intf_net \
  [get_bd_intf_pins -auto_enable /s2mm/m_axi_gmem] \
  [get_bd_intf_pins -auto_enable /noc_ddr4/S01_AXI] \

connect_bd_intf_net \
  [get_bd_intf_pins -auto_enable /ai_engine_0/M00_AXIS] \
  [get_bd_intf_pins -auto_enable /s2mm/s] \

connect_bd_intf_net \
  [get_bd_intf_pins -auto_enable /mm2s/s] \
  [get_bd_intf_pins -auto_enable /ai_engine_0/S00_AXIS] \

connect_bd_net  \
  [get_bd_pins -auto_enable /axi_intc_cascaded_1_intr_1_interrupt_concat/dout] \
  [get_bd_pins -auto_enable /axi_intc_cascaded_1/intr] \

connect_bd_net  \
  [get_bd_pins -auto_enable /mm2s/interrupt] \
  [get_bd_pins -auto_enable /axi_intc_cascaded_1_intr_1_interrupt_concat/In1] \

connect_bd_net  \
  [get_bd_pins -auto_enable /s2mm/interrupt] \
  [get_bd_pins -auto_enable /axi_intc_cascaded_1_intr_1_interrupt_concat/In0] \

connect_bd_net  \
  [get_bd_pins -auto_enable /irq_const_tieoff/dout] \
  [get_bd_pins -auto_enable /axi_intc_cascaded_1_intr_1_interrupt_concat/In2] \
  [get_bd_pins -auto_enable /axi_intc_cascaded_1_intr_1_interrupt_concat/In3] \
  [get_bd_pins -auto_enable /axi_intc_cascaded_1_intr_1_interrupt_concat/In4] \
  [get_bd_pins -auto_enable /axi_intc_cascaded_1_intr_1_interrupt_concat/In5] \
  [get_bd_pins -auto_enable /axi_intc_cascaded_1_intr_1_interrupt_concat/In6] \
  [get_bd_pins -auto_enable /axi_intc_cascaded_1_intr_1_interrupt_concat/In7] \
  [get_bd_pins -auto_enable /axi_intc_cascaded_1_intr_1_interrupt_concat/In8] \
  [get_bd_pins -auto_enable /axi_intc_cascaded_1_intr_1_interrupt_concat/In9] \
  [get_bd_pins -auto_enable /axi_intc_cascaded_1_intr_1_interrupt_concat/In10] \
  [get_bd_pins -auto_enable /axi_intc_cascaded_1_intr_1_interrupt_concat/In11] \
  [get_bd_pins -auto_enable /axi_intc_cascaded_1_intr_1_interrupt_concat/In12] \
  [get_bd_pins -auto_enable /axi_intc_cascaded_1_intr_1_interrupt_concat/In13] \
  [get_bd_pins -auto_enable /axi_intc_cascaded_1_intr_1_interrupt_concat/In14] \
  [get_bd_pins -auto_enable /axi_intc_cascaded_1_intr_1_interrupt_concat/In15] \
  [get_bd_pins -auto_enable /axi_intc_cascaded_1_intr_1_interrupt_concat/In16] \
  [get_bd_pins -auto_enable /axi_intc_cascaded_1_intr_1_interrupt_concat/In17] \
  [get_bd_pins -auto_enable /axi_intc_cascaded_1_intr_1_interrupt_concat/In18] \
  [get_bd_pins -auto_enable /axi_intc_cascaded_1_intr_1_interrupt_concat/In19] \
  [get_bd_pins -auto_enable /axi_intc_cascaded_1_intr_1_interrupt_concat/In20] \
  [get_bd_pins -auto_enable /axi_intc_cascaded_1_intr_1_interrupt_concat/In21] \
  [get_bd_pins -auto_enable /axi_intc_cascaded_1_intr_1_interrupt_concat/In22] \
  [get_bd_pins -auto_enable /axi_intc_cascaded_1_intr_1_interrupt_concat/In23] \
  [get_bd_pins -auto_enable /axi_intc_cascaded_1_intr_1_interrupt_concat/In24] \
  [get_bd_pins -auto_enable /axi_intc_cascaded_1_intr_1_interrupt_concat/In25] \
  [get_bd_pins -auto_enable /axi_intc_cascaded_1_intr_1_interrupt_concat/In26] \
  [get_bd_pins -auto_enable /axi_intc_cascaded_1_intr_1_interrupt_concat/In27] \
  [get_bd_pins -auto_enable /axi_intc_cascaded_1_intr_1_interrupt_concat/In28] \
  [get_bd_pins -auto_enable /axi_intc_cascaded_1_intr_1_interrupt_concat/In29] \
  [get_bd_pins -auto_enable /axi_intc_cascaded_1_intr_1_interrupt_concat/In30] \
  [get_bd_pins -auto_enable /axi_intc_cascaded_1_intr_1_interrupt_concat/In31] \
  [get_bd_pins -auto_enable /xlconcat_0/In0] \
  [get_bd_pins -auto_enable /xlconcat_0/In1] \
  [get_bd_pins -auto_enable /xlconcat_0/In2] \
  [get_bd_pins -auto_enable /xlconcat_0/In3] \
  [get_bd_pins -auto_enable /xlconcat_0/In4] \
  [get_bd_pins -auto_enable /xlconcat_0/In5] \
  [get_bd_pins -auto_enable /xlconcat_0/In6] \
  [get_bd_pins -auto_enable /xlconcat_0/In7] \
  [get_bd_pins -auto_enable /xlconcat_0/In8] \
  [get_bd_pins -auto_enable /xlconcat_0/In9] \
  [get_bd_pins -auto_enable /xlconcat_0/In10] \
  [get_bd_pins -auto_enable /xlconcat_0/In11] \
  [get_bd_pins -auto_enable /xlconcat_0/In12] \
  [get_bd_pins -auto_enable /xlconcat_0/In13] \
  [get_bd_pins -auto_enable /xlconcat_0/In14] \
  [get_bd_pins -auto_enable /xlconcat_0/In15] \
  [get_bd_pins -auto_enable /xlconcat_0/In16] \
  [get_bd_pins -auto_enable /xlconcat_0/In17] \
  [get_bd_pins -auto_enable /xlconcat_0/In18] \
  [get_bd_pins -auto_enable /xlconcat_0/In19] \
  [get_bd_pins -auto_enable /xlconcat_0/In20] \
  [get_bd_pins -auto_enable /xlconcat_0/In21] \
  [get_bd_pins -auto_enable /xlconcat_0/In22] \
  [get_bd_pins -auto_enable /xlconcat_0/In23] \
  [get_bd_pins -auto_enable /xlconcat_0/In24] \
  [get_bd_pins -auto_enable /xlconcat_0/In25] \
  [get_bd_pins -auto_enable /xlconcat_0/In26] \
  [get_bd_pins -auto_enable /xlconcat_0/In27] \
  [get_bd_pins -auto_enable /xlconcat_0/In28] \
  [get_bd_pins -auto_enable /xlconcat_0/In29] \
  [get_bd_pins -auto_enable /xlconcat_0/In30] \


#---------------------------
# Platform Interface Parameters for versal_extensible_platform_base
#---------------------------
set_property -dict [ list  \
  CONFIG.CONNECTIONS [dict create MC_1 [concat read_bw \{1192\} write_bw \{1192\} read_avg_burst \{8\} write_avg_burst \{8\}]] ] [ get_bd_intf_pins noc_ddr4/S00_AXI]

set_property -dict [ list  \
  CONFIG.CONNECTIONS [dict create MC_2 [concat read_bw \{1192\} write_bw \{1192\} read_avg_burst \{8\} write_avg_burst \{8\}]] ] [ get_bd_intf_pins noc_ddr4/S01_AXI]


#---------------------------
# Disable NoC automation
#---------------------------

set_param bd.enableAutoConnectionsInNoc $v_enable_auto_connections_in_noc_state


#---------------------------
# Clock/Reset Annotation
#---------------------------

set_property HDL_ATTRIBUTE.CLOCK_AUTOMATION true $mm2s
set_property HDL_ATTRIBUTE.ap_clk.refClockId {2} $mm2s
set_property HDL_ATTRIBUTE.ap_clk.FREQ_HZ {312500000} $mm2s
set_property HDL_ATTRIBUTE.ap_clk.FREQ_HZ_TOLERANCE {15625000} $mm2s

set_property HDL_ATTRIBUTE.CLOCK_AUTOMATION true $s2mm
set_property HDL_ATTRIBUTE.ap_clk.refClockId {2} $s2mm
set_property HDL_ATTRIBUTE.ap_clk.FREQ_HZ {312500000} $s2mm
set_property HDL_ATTRIBUTE.ap_clk.FREQ_HZ_TOLERANCE {15625000} $s2mm


#---------------------------
# Invoke clock automation
#---------------------------

::sdsoc::run_clock_reset_automation
::sdsoc::erase_clock_properties


#---------------------------
# Connectivity Phase 2
#---------------------------

#---------------------------
# Import AI Engine archive
#---------------------------


if {${uses_pr}} {
  set _reconfig_module_ [get_reconfig_modules -filter "MODULE_NAME == [current_bd_design]"]
  add_files -norecurse ${aie_archive} -of_objects ${_reconfig_module_}
  set _aie_file_local_ [get_files -all -of_objects ${_reconfig_module_} ${aie_archive}]
} else {
  add_files -norecurse ${aie_archive}
  set _aie_file_local_ [get_files -all -of_objects [get_fileset sources_1] ${aie_archive}]
}
set_property SCOPED_TO_REF [current_bd_design] ${_aie_file_local_}
set_property SCOPED_TO_CELLS { ai_engine_0 } ${_aie_file_local_}
set_property USED_IN_IMPLEMENTATION true ${_aie_file_local_}


#---------------------------
# Create Stream Map file
#---------------------------
set stream_subsystems [get_bd_cells * -hierarchical -quiet -filter {VLNV =~ "*:*:sdx_stream_subsystem:*"}]
if {[string length $stream_subsystems] > 0} {    
  set xmlFile $vpl_output_dir/qdma_stream_map.xml
  set fp [open ${xmlFile} w]
  puts $fp "<?xml version=\"1.0\" encoding=\"UTF-8\"?>"
  puts $fp "<xd:streamMap xmlns:xd=\"http://www.xilinx.com/xd\">"
  foreach streamSS [get_bd_cells * -hierarchical -quiet -filter {VLNV =~ "*:*:sdx_stream_subsystem:*"}] {
    set ssInstance [string trimleft $streamSS /]
    set ssRegion [get_property CONFIG.SLR_ASSIGNMENTS $streamSS]
    foreach ssIntf [get_bd_intf_pins $streamSS/* -quiet -filter {NAME=~"S??_AXIS"}] {
      set pinName [get_property NAME $ssIntf]
      set routeId [sdx_stream_subsystem::get_routeid $ssIntf]
      set flowId [sdx_stream_subsystem::get_flowid $ssIntf]
      puts $fp "  <xd:streamRoute xd:instanceRef=\"$ssInstance\" xd:portRef=\"$pinName\" xd:route=\"$routeId\" xd:flow=\"$flowId\" xd:region=\"$ssRegion\">"
      foreach connection [find_bd_objs -relation connected_to $ssIntf -thru_hier] {
        set connectedRegion [get_property CONFIG.SLR_ASSIGNMENTS [bd::utils::get_parent $connection]]
        set connectedPort [bd::utils::get_short_name $connection]
        set connectedInst [string trimleft [bd::utils::get_parent $connection] /]
        puts $fp "    <xd:connection xd:instanceRef=\"$connectedInst\" xd:portRef=\"$connectedPort\" xd:region=\"$connectedRegion\"/>"
      }
      puts $fp "  </xd:streamRoute>"
    }
    foreach ssIntf [get_bd_intf_pins $streamSS/* -quiet -filter {NAME=~"M??_AXIS"}] {
      set pinName [get_property NAME $ssIntf]
      set routeId [sdx_stream_subsystem::get_routeid $ssIntf]
      set flowId [sdx_stream_subsystem::get_flowid $ssIntf]
      puts $fp "  <xd:streamRoute xd:instanceRef=\"$ssInstance\" xd:portRef=\"$pinName\" xd:route=\"$routeId\" xd:flow=\"$flowId\" xd:region=\"$ssRegion\">"
      foreach connection [find_bd_objs -relation connected_to $ssIntf -thru_hier] {
        set connectedRegion [get_property CONFIG.SLR_ASSIGNMENTS [bd::utils::get_parent $connection]]
        set connectedPort [bd::utils::get_short_name $connection]
        set connectedInst [string trimleft [bd::utils::get_parent $connection] /]
        puts $fp "    <xd:connection xd:instanceRef=\"$connectedInst\" xd:portRef=\"$connectedPort\" xd:region=\"$connectedRegion\"/>"
      }
      puts $fp "  </xd:streamRoute>"
    }
  }
  puts $fp "</xd:streamMap>"
  close $fp
}


