/////////////// wires assignment ///////////////
// PIPE CDC
assign pipe1_tx_cdcfifo_din = { 
  pipe1_commands_out_cdcfifo,
  pipe1_tx_0_cdcfifo,
  pipe1_tx_1_cdcfifo,
  pipe1_tx_2_cdcfifo,
  pipe1_tx_3_cdcfifo,
  pipe1_tx_4_cdcfifo,
  pipe1_tx_5_cdcfifo,
  pipe1_tx_6_cdcfifo,
  pipe1_tx_7_cdcfifo,
  pipe1_tx_8_cdcfifo,
  pipe1_tx_9_cdcfifo,
  pipe1_tx_10_cdcfifo,
  pipe1_tx_11_cdcfifo,
  pipe1_tx_12_cdcfifo,
  pipe1_tx_13_cdcfifo,
  pipe1_tx_14_cdcfifo,
  pipe1_tx_15_cdcfifo
};

assign { 
  pcie1_pipe_tx_0,
  pcie1_pipe_tx_1,
  pcie1_pipe_tx_2,
  pcie1_pipe_tx_3,
  pcie1_pipe_tx_4,
  pcie1_pipe_tx_5,
  pcie1_pipe_tx_6,
  pcie1_pipe_tx_7,
  pcie1_pipe_tx_8,
  pcie1_pipe_tx_9,
  pcie1_pipe_tx_10,
  pcie1_pipe_tx_11,
  pcie1_pipe_tx_12,
  pcie1_pipe_tx_13,
  pcie1_pipe_tx_14,
  pcie1_pipe_tx_15
} = pipe1_tx_cdcfifo_dout[0+:(16*C_CPM_PIPE_SIGS_WIDTH)];

// Exclude pipe_commands_out since some of the pins are clock pins
// Only assign the ones that are not clock pins
assign pcie1_pipe_commands_out[2:1] = pipe1_commands_out_cdcfifo[2:1];
assign pcie1_pipe_commands_out[3]   = pipe1_commands_out_cdcfifo[3];
assign pcie1_pipe_commands_out[6:4] = pipe1_commands_out_cdcfifo[6:4];
assign pcie1_pipe_commands_out[7]   = pipe1_commands_out_cdcfifo[7];
assign pcie1_pipe_commands_out[8]   = pipe1_commands_out_cdcfifo[8];
assign pcie1_pipe_commands_out[9]   = pipe1_commands_out_cdcfifo[9];
assign pcie1_pipe_commands_out[10]  = pipe1_commands_out_cdcfifo[10];

assign pipe1_rx_cdcfifo_din = { 
  pcie1_pipe_commands_in,
  pcie1_pipe_rx_0,
  pcie1_pipe_rx_1,
  pcie1_pipe_rx_2,
  pcie1_pipe_rx_3,
  pcie1_pipe_rx_4,
  pcie1_pipe_rx_5,
  pcie1_pipe_rx_6,
  pcie1_pipe_rx_7,
  pcie1_pipe_rx_8,
  pcie1_pipe_rx_9,
  pcie1_pipe_rx_10,
  pcie1_pipe_rx_11,
  pcie1_pipe_rx_12,
  pcie1_pipe_rx_13,
  pcie1_pipe_rx_14,
  pcie1_pipe_rx_15
};
assign { 
  pipe1_commands_in_cdcfifo,
  pipe1_rx_0_cdcfifo,
  pipe1_rx_1_cdcfifo,
  pipe1_rx_2_cdcfifo,
  pipe1_rx_3_cdcfifo,
  pipe1_rx_4_cdcfifo,
  pipe1_rx_5_cdcfifo,
  pipe1_rx_6_cdcfifo,
  pipe1_rx_7_cdcfifo,
  pipe1_rx_8_cdcfifo,
  pipe1_rx_9_cdcfifo,
  pipe1_rx_10_cdcfifo,
  pipe1_rx_11_cdcfifo,
  pipe1_rx_12_cdcfifo,
  pipe1_rx_13_cdcfifo,
  pipe1_rx_14_cdcfifo,
  pipe1_rx_15_cdcfifo
} = pipe1_rx_cdcfifo_dout;

// Global I/O
assign gt0_refclk0_pdint = 1'b1;
assign gt1_refclk0_pdint = 1'b1;
assign gt2_refclk0_pdint = 1'b1;
assign gt3_refclk0_pdint = 1'b1;
assign gt0_refclk1_pdint = 1'b1;
assign gt1_refclk1_pdint = 1'b1;
assign gt2_refclk1_pdint = 1'b1;
assign gt3_refclk1_pdint = 1'b1;


wire q2q3_xpipe_gt_outclk_m; //move it to wires file
wire [2:0] q2q3_xpipe_pcie_rate_m;
wire q2q3_xpipe_pipe_ch0_txdetectrxloopback_m ; 

assign pipe1_clk = q1q2_xpipe_gt_outclk_m ;
assign tx_rate_curr1 = q1q2_xpipe_pcie_rate_m[1:0];
assign pipe_tx1_rcvr_det  = q1q2_xpipe_pipe_ch0_txdetectrxloopback_m;


// The clock pins goes directly out, only data pins are through CDC
assign pipe1_commands_out_cdcfifo[2:1] = tx_rate_curr1[1:0];    // Upper bits split to maintain compatibility with US+
assign pipe1_commands_out_cdcfifo[3]   = pipe_tx1_rcvr_det;
assign pipe1_commands_out_cdcfifo[6:4] = q1q2_xpipe_pipe_ch0_txmargin_m[2:0];
assign pipe1_commands_out_cdcfifo[7]   = q1q2_xpipe_pipe_ch0_txswing_m;
assign pipe1_commands_out_cdcfifo[8]   = ch8_gttxreset_m;      // No direct replacement out of CPM - not used
assign pipe1_commands_out_cdcfifo[9]   = q1q2_xpipe_pipe_ch0_txdeemph_m;
assign pipe1_commands_out_cdcfifo[10]  = 1'b0; // Reserved (for CPM5 Gen5 Support)

assign pcie1_pipe_commands_out[0]  = pipe1_clk; // If EP, use the clk from RP
assign pcie1_pipe_commands_out[11] = 1'b0; // Not used
assign pcie1_pipe_commands_out[12] = 1'b0; // Not used
assign pcie1_pipe_commands_out[13] = 1'b0; // Not used

assign xpipe_lnk1_phy_ready = phy_rdy1;
assign q1q2_xpipe_bufgtce_m = bufggt_ce1;
assign q1q2_xpipe_bufgtrst_m = bufggt_rst1;
assign xpipe_lnk0_gt_outclk = txout_clk1;
assign xpipe_lnk0_bufgtce_mask = bufggt_ce_mask1;
assign xpipe_lnk0_bufgtrst_mask = bufggt_rst_mask1;
assign xpipe_lnk0_bufgtdiv  = {userclk2_div1,userclk_div1,coreclk_div1,pipeclk_div1};

assign q1q2_xpipe_bufgtce_m = xpipe_lnk0_bufgtce1;
assign q1q2_xpipe_bufgtdiv_m = xpipe_lnk0_bufgtdiv1;
assign q1q2_xpipe_bufgtrst_m = xpipe_lnk0_bufgtrst1;
assign q1q2_xpipe_gt_outclk_m = xpipe_lnk0_gt_outclk1;
assign xpipe_lnk1_phy_ready = xpipe_lnk0_phy_ready1;
assign q1q2_xpipe_bufgtce_mask_m  = xpipe_lnk0_bufgtce_mask1;
assign q1q2_xpipe_bufgtrst_mask_m = xpipe_lnk0_bufgtrst_mask1;



// ch0
// Channel controls
// RX side
assign q1q2_xpipe_pipe_ch0_phystatus_m    = phy_status1;
assign q1q2_xpipe_pipe_ch0_rxdata_m       = pipe1_rx_0_cdcfifo[31:0];
assign q1q2_xpipe_pipe_ch0_rxelecidle_m   = pipe1_rx_0_cdcfifo[34];
assign q1q2_xpipe_pipe_ch0_rxstatus_m     = rx_status1;
assign q1q2_xpipe_pipe_ch0_rxvalid_m      = ~pipe1_rx_0_cdcfifo[34];
assign q1q2_xpipe_pipe_ch0_rxcharisk_m    = pipe1_rx_0_cdcfifo[33:32]; // rx_charisk[1:0]
assign q1q2_xpipe_pipe_ch0_rxdatavalid_m  = pipe1_rx_0_cdcfifo[35];    // rx_datavalid
assign q1q2_xpipe_pipe_ch0_rxstartblock_m = pipe1_rx_0_cdcfifo[36];    // rx_startblock
assign q1q2_xpipe_pipe_ch0_rxsyncheader_m = pipe1_rx_0_cdcfifo[38:37]; // rx_syncheader[1:0]
// TX Side
assign pipe1_tx_0_cdcfifo[31:0]  = q1q2_xpipe_pipe_ch0_txdata_m;
assign pipe1_tx_0_cdcfifo[34]    = q1q2_xpipe_pipe_ch0_txelecidle_m;
assign pipe1_tx_0_cdcfifo[39]    = q1q2_xpipe_pipe_ch0_rxpolarity_m;
assign pipe1_tx_0_cdcfifo[41:40] = q1q2_xpipe_pipe_ch0_powerdown_m;
assign pipe1_tx_0_cdcfifo[33:32] = q1q2_xpipe_pipe_ch0_txcharisk_m;    // tx_charisk[1:0]
assign pipe1_tx_0_cdcfifo[35]    = q1q2_xpipe_pipe_ch0_txdatavalid_m;  // tx_datavalid
assign pipe1_tx_0_cdcfifo[36]    = q1q2_xpipe_pipe_ch0_txstartblock_m; // tx_startblock
assign pipe1_tx_0_cdcfifo[38:37] = q1q2_xpipe_pipe_ch0_txsyncheader_m; // tx_syncheader[1:0]

//-----------------------------------------------------------------------
// ch1
// Channel controls
// RX side
assign q1q2_xpipe_pipe_ch1_phystatus_m    = phy_status1;
assign q1q2_xpipe_pipe_ch1_rxdata_m       = pipe1_rx_1_cdcfifo[31:0];
assign q1q2_xpipe_pipe_ch1_rxelecidle_m   = pipe1_rx_1_cdcfifo[34];
assign q1q2_xpipe_pipe_ch1_rxstatus_m     = rx_status1;
assign q1q2_xpipe_pipe_ch1_rxvalid_m      = ~pipe1_rx_1_cdcfifo[34];
assign q1q2_xpipe_pipe_ch1_rxcharisk_m    = pipe1_rx_1_cdcfifo[33:32]; // rx_charisk[1:0]
assign q1q2_xpipe_pipe_ch1_rxdatavalid_m  = pipe1_rx_1_cdcfifo[35];    // rx_datavalid
assign q1q2_xpipe_pipe_ch1_rxstartblock_m = pipe1_rx_1_cdcfifo[36];    // rx_startblock
assign q1q2_xpipe_pipe_ch1_rxsyncheader_m = pipe1_rx_1_cdcfifo[38:37]; // rx_syncheader[1:0]
// TX Side
assign pipe1_tx_1_cdcfifo[31:0]  = q1q2_xpipe_pipe_ch1_txdata_m;
assign pipe1_tx_1_cdcfifo[34]    = q1q2_xpipe_pipe_ch1_txelecidle_m;
assign pipe1_tx_1_cdcfifo[39]    = q1q2_xpipe_pipe_ch1_rxpolarity_m;
assign pipe1_tx_1_cdcfifo[41:40] = q1q2_xpipe_pipe_ch1_powerdown_m;
assign pipe1_tx_1_cdcfifo[33:32] = q1q2_xpipe_pipe_ch1_txcharisk_m;    // tx_charisk[1:0]
assign pipe1_tx_1_cdcfifo[35]    = q1q2_xpipe_pipe_ch1_txdatavalid_m;  // tx_datavalid
assign pipe1_tx_1_cdcfifo[36]    = q1q2_xpipe_pipe_ch1_txstartblock_m; // tx_startblock
assign pipe1_tx_1_cdcfifo[38:37] = q1q2_xpipe_pipe_ch1_txsyncheader_m; // tx_syncheader[1:0]

//-----------------------------------------------------------------------
// ch2
// Channel controls
// RX side_m
assign q1q2_xpipe_pipe_ch2_phystatus_m    = phy_status1;
assign q1q2_xpipe_pipe_ch2_rxdata_m       = pipe1_rx_2_cdcfifo[31:0];
assign q1q2_xpipe_pipe_ch2_rxelecidle_m   = pipe1_rx_2_cdcfifo[34];
assign q1q2_xpipe_pipe_ch2_rxstatus_m     = rx_status1;
assign q1q2_xpipe_pipe_ch2_rxvalid_m      = ~pipe1_rx_2_cdcfifo[34];
assign q1q2_xpipe_pipe_ch2_rxcharisk_m    = pipe1_rx_2_cdcfifo[33:32]; // rx_charisk[1:0]
assign q1q2_xpipe_pipe_ch2_rxdatavalid_m  = pipe1_rx_2_cdcfifo[35];    // rx_datavalid
assign q1q2_xpipe_pipe_ch2_rxstartblock_m = pipe1_rx_2_cdcfifo[36];    // rx_startblock
assign q1q2_xpipe_pipe_ch2_rxsyncheader_m = pipe1_rx_2_cdcfifo[38:37]; // rx_syncheader[1:0]
// TX Side
assign pipe1_tx_2_cdcfifo[31:0]  = q1q2_xpipe_pipe_ch2_txdata_m;
assign pipe1_tx_2_cdcfifo[34]    = q1q2_xpipe_pipe_ch2_txelecidle_m;
assign pipe1_tx_2_cdcfifo[39]    = q1q2_xpipe_pipe_ch2_rxpolarity_m;
assign pipe1_tx_2_cdcfifo[41:40] = q1q2_xpipe_pipe_ch2_powerdown_m;
assign pipe1_tx_2_cdcfifo[33:32] = q1q2_xpipe_pipe_ch2_txcharisk_m;    // tx_charisk[1:0]
assign pipe1_tx_2_cdcfifo[35]    = q1q2_xpipe_pipe_ch2_txdatavalid_m;  // tx_datavalid
assign pipe1_tx_2_cdcfifo[36]    = q1q2_xpipe_pipe_ch2_txstartblock_m; // tx_startblock
assign pipe1_tx_2_cdcfifo[38:37] = q1q2_xpipe_pipe_ch2_txsyncheader_m; // tx_syncheader[1:0]

//-----------------------------------------------------------------------
// ch3
// Channel controls
// RX side
assign cpm_xpipe_ch3_phystatus_m    = phy_status1;
assign cpm_xpipe_ch3_rxdata_m       = pipe1_rx_3_cdcfifo[31:0];
assign cpm_xpipe_ch3_rxelecidle_m   = pipe1_rx_3_cdcfifo[34];
assign cpm_xpipe_ch3_rxstatus_m     = rx_status1;
assign cpm_xpipe_ch3_rxvalid_m      = ~pipe1_rx_3_cdcfifo[34];
assign cpm_xpipe_ch3_rxcharisk_m    = pipe1_rx_3_cdcfifo[33:32]; // rx_charisk[1:0]
assign cpm_xpipe_ch3_rxdatavalid_m  = pipe1_rx_3_cdcfifo[35];    // rx_datavalid
assign cpm_xpipe_ch3_rxstartblock_m = pipe1_rx_3_cdcfifo[36];    // rx_startblock
assign cpm_xpipe_ch3_rxsyncheader_m = pipe1_rx_3_cdcfifo[38:37]; // rx_syncheader[1:0]
// TX Side
assign pipe1_tx_3_cdcfifo[31:0]  = q1q2_xpipe_pipe_ch3_txdata_m;
assign pipe1_tx_3_cdcfifo[34]    = q1q2_xpipe_pipe_ch3_txelecidle_m;
assign pipe1_tx_3_cdcfifo[39]    = q1q2_xpipe_pipe_ch3_rxpolarity_m;
assign pipe1_tx_3_cdcfifo[41:40] = q1q2_xpipe_pipe_ch3_powerdown_m;
assign pipe1_tx_3_cdcfifo[33:32] = q1q2_xpipe_pipe_ch3_txcharisk_m;    // tx_charisk[1:0]
assign pipe1_tx_3_cdcfifo[35]    = q1q2_xpipe_pipe_ch3_txdatavalid_m;  // tx_datavalid
assign pipe1_tx_3_cdcfifo[36]    = q1q2_xpipe_pipe_ch3_txstartblock_m; // tx_startblock
assign pipe1_tx_3_cdcfifo[38:37] = q1q2_xpipe_pipe_ch3_txsyncheader_m; // tx_syncheader[1:0]

//-----------------------------------------------------------------------
// ch4
// Channel controls
// RX side
assign q1q2_xpipe_pipe_ch4_phystatus_m    = phy_status1;
assign q1q2_xpipe_pipe_ch4_rxdata_m       = pipe1_rx_4_cdcfifo[31:0];
assign q1q2_xpipe_pipe_ch4_rxelecidle_m   = pipe1_rx_4_cdcfifo[34];
assign q1q2_xpipe_pipe_ch4_rxstatus_m     = rx_status1;
assign q1q2_xpipe_pipe_ch4_rxvalid_m      = ~pipe1_rx_4_cdcfifo[34];
assign q1q2_xpipe_pipe_ch4_rxcharisk_m    = pipe1_rx_4_cdcfifo[33:32]; // rx_charisk[1:0]
assign q1q2_xpipe_pipe_ch4_rxdatavalid_m  = pipe1_rx_4_cdcfifo[35];    // rx_datavalid
assign q1q2_xpipe_pipe_ch4_rxstartblock_m = pipe1_rx_4_cdcfifo[36];    // rx_startblock
assign q1q2_xpipe_pipe_ch4_rxsyncheader_m = pipe1_rx_4_cdcfifo[38:37]; // rx_syncheader[1:0]
// TX Side
assign pipe1_tx_4_cdcfifo[31:0]     = q1q2_xpipe_pipe_ch4_txdata_m;
assign pipe1_tx_4_cdcfifo[34]       = q1q2_xpipe_pipe_ch4_txelecidle_m;
assign pipe1_tx_4_cdcfifo[39]       = q1q2_xpipe_pipe_ch4_rxpolarity_m;
assign pipe1_tx_4_cdcfifo[41:40]    = q1q2_xpipe_pipe_ch4_powerdown_m;
assign pipe1_tx_4_cdcfifo[33:32]    = q1q2_xpipe_pipe_ch4_txcharisk_m;    // tx_charisk[1:0]
assign pipe1_tx_4_cdcfifo[35]       = q1q2_xpipe_pipe_ch4_txdatavalid_m;  // tx_datavalid
assign pipe1_tx_4_cdcfifo[36]       = q1q2_xpipe_pipe_ch4_txstartblock_m; // tx_startblock
assign pipe1_tx_4_cdcfifo[38:37]    = q1q2_xpipe_pipe_ch4_txsyncheader_m; // tx_syncheader[1:0]

//-----------------------------------------------------------------------
// ch5
// Channel controls
// RX side
assign q1q2_xpipe_pipe_ch5_phystatus_m    = phy_status1;
assign q1q2_xpipe_pipe_ch5_rxdata_m       = pipe1_rx_5_cdcfifo[31:0];
assign q1q2_xpipe_pipe_ch5_rxelecidle_m   = pipe1_rx_5_cdcfifo[34];
assign q1q2_xpipe_pipe_ch5_rxstatus_m     = rx_status1;
assign q1q2_xpipe_pipe_ch5_rxvalid_m      = ~pipe1_rx_5_cdcfifo[34];
assign q1q2_xpipe_pipe_ch5_rxcharisk_m    = pipe1_rx_5_cdcfifo[33:32]; // rx_charisk[1:0]
assign q1q2_xpipe_pipe_ch5_rxdatavalid_m  = pipe1_rx_5_cdcfifo[35];    // rx_datavalid
assign q1q2_xpipe_pipe_ch5_rxstartblock_m = pipe1_rx_5_cdcfifo[36];    // rx_startblock
assign q1q2_xpipe_pipe_ch5_rxsyncheader_m = pipe1_rx_5_cdcfifo[38:37]; // rx_syncheader[1:0]
// TX Side
assign pipe1_tx_5_cdcfifo[31:0]     = q1q2_xpipe_pipe_ch5_txdata_m;
assign pipe1_tx_5_cdcfifo[34]       = q1q2_xpipe_pipe_ch5_txelecidle_m;
assign pipe1_tx_5_cdcfifo[39]       = q1q2_xpipe_pipe_ch5_rxpolarity_m;
assign pipe1_tx_5_cdcfifo[41:40]    = q1q2_xpipe_pipe_ch5_powerdown_m;
assign pipe1_tx_5_cdcfifo[33:32]    = q1q2_xpipe_pipe_ch5_txcharisk_m;    // tx_charisk[1:0]
assign pipe1_tx_5_cdcfifo[35]       = q1q2_xpipe_pipe_ch5_txdatavalid_m;  // tx_datavalid
assign pipe1_tx_5_cdcfifo[36]       = q1q2_xpipe_pipe_ch5_txstartblock_m; // tx_startblock
assign pipe1_tx_5_cdcfifo[38:37]    = q1q2_xpipe_pipe_ch5_txsyncheader_m; // tx_syncheader[1:0]

//-----------------------------------------------------------------------
// ch6
// Channel controls
// RX side
assign q1q2_xpipe_pipe_ch6_phystatus_m    = phy_status1;
assign q1q2_xpipe_pipe_ch6_rxdata_m       = pipe1_rx_6_cdcfifo[31:0];
assign q1q2_xpipe_pipe_ch6_rxelecidle_m   = pipe1_rx_6_cdcfifo[34];
assign q1q2_xpipe_pipe_ch6_rxstatus_m     = rx_status1;
assign q1q2_xpipe_pipe_ch6_rxvalid_m      = ~pipe1_rx_6_cdcfifo[34];
assign q1q2_xpipe_pipe_ch6_rxcharisk_m    = pipe1_rx_6_cdcfifo[33:32]; // rx_charisk[1:0]
assign q1q2_xpipe_pipe_ch6_rxdatavalid_m  = pipe1_rx_6_cdcfifo[35];    // rx_datavalid
assign q1q2_xpipe_pipe_ch6_rxstartblock_m = pipe1_rx_6_cdcfifo[36];    // rx_startblock
assign q1q2_xpipe_pipe_ch6_rxsyncheader_m = pipe1_rx_6_cdcfifo[38:37]; // rx_syncheader[1:0]

// TX Side
assign pipe1_tx_6_cdcfifo[31:0]  = q1q2_xpipe_pipe_ch6_txdata_m;
assign pipe1_tx_6_cdcfifo[34]    = q1q2_xpipe_pipe_ch6_txelecidle_m;
assign pipe1_tx_6_cdcfifo[39]    = q1q2_xpipe_pipe_ch6_rxpolarity_m;
assign pipe1_tx_6_cdcfifo[41:40] = q1q2_xpipe_pipe_ch6_powerdown_m;
assign pipe1_tx_6_cdcfifo[33:32] = q1q2_xpipe_pipe_ch6_txcharisk_m;    // tx_charisk[1:0]
assign pipe1_tx_6_cdcfifo[35]    = q1q2_xpipe_pipe_ch6_txdatavalid_m;  // tx_datavalid
assign pipe1_tx_6_cdcfifo[36]    = q1q2_xpipe_pipe_ch6_txstartblock_m; // tx_startblock
assign pipe1_tx_6_cdcfifo[38:37] = q1q2_xpipe_pipe_ch6_txsyncheader_m; // tx_syncheader[1:0]

//-----------------------------------------------------------------------
// ch7
// Channel controls
// RX side
assign q1q2_xpipe_pipe_ch7_phystatus_m    = phy_status1;
assign q1q2_xpipe_pipe_ch7_rxdata_m       = pipe1_rx_7_cdcfifo[31:0];
assign q1q2_xpipe_pipe_ch7_rxelecidle_m   = pipe1_rx_7_cdcfifo[34];
assign q1q2_xpipe_pipe_ch7_rxstatus_m     = rx_status1;
assign q1q2_xpipe_pipe_ch7_rxvalid_m      = ~pipe1_rx_7_cdcfifo[34];
assign q1q2_xpipe_pipe_ch7_rxcharisk_m    = pipe1_rx_7_cdcfifo[33:32]; // rx_charisk[1:0]
assign q1q2_xpipe_pipe_ch7_rxdatavalid_m  = pipe1_rx_7_cdcfifo[35];    // rx_datavalid
assign q1q2_xpipe_pipe_ch7_rxstartblock_m = pipe1_rx_7_cdcfifo[36];    // rx_startblock
assign q1q2_xpipe_pipe_ch7_rxsyncheader_m = pipe1_rx_7_cdcfifo[38:37]; // rx_syncheader[1:0]
// TX Side
assign pipe1_tx_7_cdcfifo[31:0]  = q1q2_xpipe_pipe_ch7_txdata_m;
assign pipe1_tx_7_cdcfifo[34]    = q1q2_xpipe_pipe_ch7_txelecidle_m;
assign pipe1_tx_7_cdcfifo[39]    = q1q2_xpipe_pipe_ch7_rxpolarity_m;
assign pipe1_tx_7_cdcfifo[41:40] = q1q2_xpipe_pipe_ch7_powerdown_m;
assign pipe1_tx_7_cdcfifo[33:32] = q1q2_xpipe_pipe_ch7_txcharisk_m;    // tx_charisk[1:0]
assign pipe1_tx_7_cdcfifo[35]    = q1q2_xpipe_pipe_ch7_txdatavalid_m;  // tx_datavalid
assign pipe1_tx_7_cdcfifo[36]    = q1q2_xpipe_pipe_ch7_txstartblock_m; // tx_startblock
assign pipe1_tx_7_cdcfifo[38:37] = q1q2_xpipe_pipe_ch7_txsyncheader_m; // tx_syncheader[1:0]

