// (c) Copyright 2017-2018, 2023 Advanced Micro Devices, Inc. All rights reserved.
//
// This file contains confidential and proprietary information
// of AMD and is protected under U.S. and international copyright
// and other intellectual property laws.
//
// DISCLAIMER
// This disclaimer is not a license and does not grant any
// rights to the materials distributed herewith. Except as
// otherwise provided in a valid license issued to you by
// AMD, and to the maximum extent permitted by applicable
// law: (1) THESE MATERIALS ARE MADE AVAILABLE "AS IS" AND
// WITH ALL FAULTS, AND AMD HEREBY DISCLAIMS ALL WARRANTIES
// AND CONDITIONS, EXPRESS, IMPLIED, OR STATUTORY, INCLUDING
// BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, NON-
// INFRINGEMENT, OR FITNESS FOR ANY PARTICULAR PURPOSE; and
// (2) AMD shall not be liable (whether in contract or tort,
// including negligence, or under any other theory of
// liability) for any loss or damage of any kind or nature
// related to, arising under or in connection with these
// materials, including for any direct, or any indirect,
// special, incidental, or consequential loss or damage
// (including loss of data, profits, goodwill, or any type of
// loss or damage suffered as a result of any action brought
// by a third party) even if such damage or loss was
// reasonably foreseeable or AMD had been advised of the
// possibility of the same.
//
// CRITICAL APPLICATIONS
// AMD products are not designed or intended to be fail-
// safe, or for use in any application requiring fail-safe
// performance, such as life-support or safety devices or
// systems, Class III medical devices, nuclear facilities,
// applications related to the deployment of airbags, or any
// other applications that could lead to death, personal
// injury, or severe property or environmental damage
// (individually and collectively, "Critical
// Applications"). Customer assumes the sole risk and
// liability of any use of AMD products in Critical
// Applications, subject only to applicable laws and
// regulations governing limitations on product liability.
//
// THIS COPYRIGHT NOTICE AND DISCLAIMER MUST BE RETAINED AS
// PART OF THIS FILE AT ALL TIMES.

`timescale 1ps/1ps
module vitis_design_clk_wizard_0_0_clk_wiz_top #(
   parameter  C_USER_CLK_FREQ0                            =  100.0,
   parameter  C_USER_CLK_FREQ1                            =  100.0,
   parameter  C_USER_CLK_FREQ2                            =  100.0,
   parameter  C_USER_CLK_FREQ3                            =  100.0,
   parameter  C_CLKIN1_IBUF                               =  1,
   parameter  C_CLKIN1_BUFG                               =  0,
   parameter  C_CLKIN1_IBUFDS                             =  0,
   parameter  C_CLKIN2_IBUF                               =  1,
   parameter  C_CLKIN2_BUFG                               =  0,
   parameter  C_CLKIN2_IBUFDS                             =  0,
   parameter  C_SIM_DEVICE                                =  0,
   parameter  C_CLKFB_BUFG                                =  0,
   parameter  C_CLKFBIN_IBUF                              =  0,
   parameter  C_CLKFBIN_IBUFDS                            =  0,
   parameter  C_CLKFBOUT_BUFG                             =  0,
   parameter  C_CLKFBOUT_ODDR                             =  0,
   parameter  C_CLKFBIN_OBUFDS                            =  0,
   parameter  C_CLKFBIN_OBUF                              =  0,
   parameter  C_ENABLE_CLOCK_MONITOR                      =  0,
   parameter  C_ENABLE_USER_CLOCK0                        =  0,
   parameter  C_ENABLE_USER_CLOCK1                        =  0,
   parameter  C_ENABLE_USER_CLOCK2                        =  0,
   parameter  C_ENABLE_USER_CLOCK3                        =  0,
   parameter  C_Enable_PLL0                               =  0,
   parameter  C_Enable_PLL1                               =  0,
   parameter  C_REF_CLK_FREQ                              =  100.0,
   parameter  C_PRECISION                                 =  1,
   parameter  C_CLKOUT1_USED                              =  1,
   parameter  C_CLKOUT2_USED                              =  1,
   parameter  C_CLKOUT3_USED                              =  1,
   parameter  C_CLKOUT4_USED                              =  1,
   parameter  C_CLKOUT5_USED                              =  1,
   parameter  C_CLKOUT6_USED                              =  0,
   parameter  C_CLKOUT7_USED                              =  0,
   parameter  C_USE_FREQ_SYNTH                            =  1,
   parameter  C_USE_PHASE_ALIGNMENT                       =  0,
   parameter  C_JITTER_SEL                                =  "No_Jitter",
   parameter  C_USE_MIN_POWER                             =  0,
   parameter  C_USE_DYN_PHASE_SHIFT                       =  0,
   parameter  C_USE_INCLK_SWITCHOVER                      =  0,
   parameter  C_USE_DYN_RECONFIG                          =  0,
   parameter  C_USE_SPREAD_SPECTRUM                       =  0,
   parameter  C_PRIM_IN_FREQ                              =  100.000,
   parameter  C_SECONDARY_IN_FREQ                         =  100.000,
   parameter  C_FEEDBACK_SOURCE                           =  "FDBK_AUTO",
   parameter  C_PRIM_SOURCE                               =  "Single_ended_clock_capable_pin",
   parameter  C_PHASESHIFT_MODE                           =  "WAVEFORM",
   parameter  C_CE_TYPE                                   =  "HARDSYNC",
   parameter  C_BUFGCE_DIV_CE_TYPE                        =  "HARDSYNC",
   parameter  C_CE_SYNC_EXT                               =  0,
   parameter  C_SAFECLOCK_STARTUP_MODE                        =  "DESKEW_MODE",
   parameter  C_SECONDARY_SOURCE                          =  "Single_ended_clock_capable_pin",
   parameter  C_CLKFB_IN_SIGNALING                        =  "SINGLE",
   parameter  C_USE_RESET                                 =  0,
   parameter  C_RESET_TYPE                                =  "ACTIVE_HIGH",
   parameter  C_USE_LOCKED                                =  0,
   parameter  C_USE_LOCKED_FB                             =  0,
   parameter  C_USE_LOCKED_DESKEW1                        =  0,
   parameter  C_USE_LOCKED_DESKEW2                        =  0,
   parameter  C_USE_INCLK_STOPPED                         =  0,
   parameter  C_USE_CLKFB_STOPPED                         =  0,
   parameter  C_USE_POWER_DOWN                            =  0,
   parameter  C_NUM_OUT_CLKS                              =  1,
   parameter  C_CLKOUT1_DRIVES                            =  "BUFG",
   parameter  C_CLKOUT2_DRIVES                            =  "BUFGCE",
   parameter  C_CLKOUT3_DRIVES                            =  "BUFGCE",
   parameter  C_CLKOUT4_DRIVES                            =  "BUFGCE_DIV",
   parameter  C_CLKOUT5_DRIVES                            =  "BUFGCE",
   parameter  C_CLKOUT6_DRIVES                            =  "BUFG",
   parameter  C_CLKOUT7_DRIVES                            =  "BUFG",
   parameter  C_CLKOUT1_GROUPING                          =  "NONE",
   parameter  C_CLKOUT2_GROUPING                          =  "NONE",
   parameter  C_CLKOUT3_GROUPING                          =  "NONE",
   parameter  C_CLKOUT4_GROUPING                          =  "NONE",
   parameter  C_CLKOUT5_GROUPING                          =  "NONE",
   parameter  C_CLKOUT6_GROUPING                          =  "NONE",
   parameter  C_CLKOUT7_GROUPING                          =  "NONE",
   parameter  C_CLKOUT1_MBUFGCE_MODE                      =  "PERFORMANCE",
   parameter  C_CLKOUT2_MBUFGCE_MODE                      =  "PERFORMANCE",
   parameter  C_CLKOUT3_MBUFGCE_MODE                      =  "PERFORMANCE",
   parameter  C_CLKOUT4_MBUFGCE_MODE                      =  "PERFORMANCE",
   parameter  C_CLKOUT5_MBUFGCE_MODE                      =  "PERFORMANCE",
   parameter  C_CLKOUT6_MBUFGCE_MODE                      =  "PERFORMANCE",
   parameter  C_CLKOUT7_MBUFGCE_MODE                      =  "PERFORMANCE",
   parameter  C_CLKOUTFB_PHASE_CTRL                       =  "00",
   parameter  C_CLKOUT1_DYN_PS                            =  "00",
   parameter  C_CLKOUT2_DYN_PS                            =  "00",
   parameter  C_CLKOUT3_DYN_PS                            =  "00",
   parameter  C_CLKOUT4_DYN_PS                            =  "00",
   parameter  C_CLKOUT5_DYN_PS                            =  "00",
   parameter  C_CLKOUT6_DYN_PS                            =  "00",
   parameter  C_CLKOUT7_DYN_PS                            =  "00",
   parameter  C_INCLK_SUM_ROW0                            =  "Input Clock   Freq                             =  MHz)    Input Jitter                             =  UI)",
   parameter  C_INCLK_SUM_ROW1                            =  "primary       100.000        0.010",
   parameter  C_INCLK_SUM_ROW2                            =  "secondary      100.000        0.010",
   parameter  C_OUTCLK_SUM_ROW0A                          =  "Output    Output      Phase     Duty      Pk-to-Pk        Phase",
   parameter  C_OUTCLK_SUM_ROW0B                          =  "Clock    Freq                             =  MHz)                             =  degrees) Cycle                             =  ) Jitter                             =  ps)  Error                             =  ps)",
   parameter  C_OUTCLK_SUM_ROW1                           =  "no clk_out1 output",
   parameter  C_OUTCLK_SUM_ROW2                           =  "no clk_out2 output",
   parameter  C_OUTCLK_SUM_ROW3                           =  "no clk_out3 output",
   parameter  C_OUTCLK_SUM_ROW4                           =  "no clk_out4 output",
   parameter  C_OUTCLK_SUM_ROW5                           =  "no clk_out5 output",
   parameter  C_OUTCLK_SUM_ROW6                           =  "no clk_out6 output",
   parameter  C_OUTCLK_SUM_ROW7                           =  "no clk_out7 output",
   parameter  C_CLKOUT1_REQUESTED_OUT_FREQ                =  100.000,
   parameter  C_CLKOUT2_REQUESTED_OUT_FREQ                =  100.000,
   parameter  C_CLKOUT3_REQUESTED_OUT_FREQ                =  100.000,
   parameter  C_CLKOUT4_REQUESTED_OUT_FREQ                =  100.000,
   parameter  C_CLKOUT5_REQUESTED_OUT_FREQ                =  100.000,
   parameter  C_CLKOUT6_REQUESTED_OUT_FREQ                =  100.000,
   parameter  C_CLKOUT7_REQUESTED_OUT_FREQ                =  100.000,
   parameter  C_CLKOUT1_REQUESTED_PHASE                   =  0.000,
   parameter  C_CLKOUT2_REQUESTED_PHASE                   =  0.000,
   parameter  C_CLKOUT3_REQUESTED_PHASE                   =  0.000,
   parameter  C_CLKOUT4_REQUESTED_PHASE                   =  0.000,
   parameter  C_CLKOUT5_REQUESTED_PHASE                   =  0.000,
   parameter  C_CLKOUT6_REQUESTED_PHASE                   =  0.000,
   parameter  C_CLKOUT7_REQUESTED_PHASE                   =  0.000,
   parameter  C_CLKOUT1_REQUESTED_DUTY_CYCLE              =  50.000,
   parameter  C_CLKOUT2_REQUESTED_DUTY_CYCLE              =  50.000,
   parameter  C_CLKOUT3_REQUESTED_DUTY_CYCLE              =  50.000,
   parameter  C_CLKOUT4_REQUESTED_DUTY_CYCLE              =  50.000,
   parameter  C_CLKOUT5_REQUESTED_DUTY_CYCLE              =  50.000,
   parameter  C_CLKOUT6_REQUESTED_DUTY_CYCLE              =  50.000,
   parameter  C_CLKOUT7_REQUESTED_DUTY_CYCLE              =  50.000,
   parameter  C_CLKOUT1_ACTUAL_OUT_FREQ                   =  100,
   parameter  C_CLKOUT2_ACTUAL_OUT_FREQ                   =  100,
   parameter  C_CLKOUT3_ACTUAL_OUT_FREQ                   =  100,
   parameter  C_CLKOUT4_ACTUAL_OUT_FREQ                   =  100,
   parameter  C_CLKOUT5_ACTUAL_OUT_FREQ                   =  100,
   parameter  C_CLKOUT6_ACTUAL_OUT_FREQ                   =  100.0,
   parameter  C_CLKOUT7_ACTUAL_OUT_FREQ                   =  100.0,
   parameter  C_CLKFBOUT_PHASE                             =  0,
   parameter  C_CLKOUT1_ACTUAL_PHASE                      =  0,
   parameter  C_CLKOUT2_ACTUAL_PHASE                      =  0,
   parameter  C_CLKOUT3_ACTUAL_PHASE                      =  0,
   parameter  C_CLKOUT4_ACTUAL_PHASE                      =  0,
   parameter  C_CLKOUT5_ACTUAL_PHASE                      =  0,
   parameter  C_CLKOUT6_ACTUAL_PHASE                      =  0.000,
   parameter  C_CLKOUT7_ACTUAL_PHASE                      =  0.000,
   parameter  C_CLKOUT1_ACTUAL_DUTY_CYCLE                 =  50.000,
   parameter  C_CLKOUT2_ACTUAL_DUTY_CYCLE                 =  50.000,
   parameter  C_CLKOUT3_ACTUAL_DUTY_CYCLE                 =  50.000,
   parameter  C_CLKOUT4_ACTUAL_DUTY_CYCLE                 =  50.000,
   parameter  C_CLKOUT5_ACTUAL_DUTY_CYCLE                 =  50.000,
   parameter  C_CLKOUT6_ACTUAL_DUTY_CYCLE                 =  50.000,
   parameter  C_CLKOUT7_ACTUAL_DUTY_CYCLE                 =  50.000,
   parameter  C_USE_SAFE_CLOCK_STARTUP                    =  0,
   parameter  C_USE_CLOCK_SEQUENCING                      =  0,
   parameter  C_CLKOUT1_SEQUENCE_NUMBER                   =  1,
   parameter  C_CLKOUT2_SEQUENCE_NUMBER                   =  1,
   parameter  C_CLKOUT3_SEQUENCE_NUMBER                   =  1,
   parameter  C_CLKOUT4_SEQUENCE_NUMBER                   =  1,
   parameter  C_CLKOUT5_SEQUENCE_NUMBER                   =  1,
   parameter  C_CLKOUT6_SEQUENCE_NUMBER                   =  1,
   parameter  C_CLKOUT7_SEQUENCE_NUMBER                   =  1,
   parameter  C_BANDWIDTH                                 =  "OPTIMIZED",
   parameter  C_CLKFBOUT_MULT                             =  1.000,
   parameter  C_CLKFBOUT_FRACT                            =  0.000,
   parameter  C_CLKIN1_PERIOD                             =  10.000,
   parameter  C_CLKIN2_PERIOD                             =  1.000,
   parameter  C_COMPENSATION                              =  "INTERNAL",
   parameter  C_DESKEW_DELAY1                             =  0,
   parameter  C_DESKEW_IN1                                =  0,
   parameter  C_DESKEW_FB1                                =  0,
   parameter  C_DESKEW_DELAY2                             =  0,
   parameter  C_DESKEW_IN2                                =  0,
   parameter  C_DESKEW_FB2                                =  0,
   parameter  C_DESKEW_DELAY_EN1                          =  "FALSE",
   parameter  C_DESKEW_DELAY_EN2                          =  "FALSE",
   parameter  C_DESKEW_DELAY_PATH1                        =  "FALSE",
   parameter  C_DESKEW_DELAY_PATH2                        =  "FALSE",
   parameter  C_DESKEW_LOCK_CIRCUIT_EN1                   =  0,
   parameter  C_DESKEW_LOCK_CIRCUIT_EN2                   =  0,
   parameter  C_ZHOLD                                     =  "FALSE",
   parameter  C_DIVCLK_DIVIDE                             =  1,
   parameter  C_REF_JITTER1                               =  0.010,
   parameter  C_REF_JITTER2                               =  0.010,
   parameter  C_CLKOUT1_DIVIDE                            =  22,
   parameter  C_CLKOUT2_DIVIDE                            =  22,
   parameter  C_CLKOUT3_DIVIDE                            =  22,
   parameter  C_CLKOUT4_DIVIDE                            =  22,
   parameter  C_CLKOUT5_DIVIDE                            =  22,
   parameter  C_CLKOUT6_DIVIDE                            =  12,
   parameter  C_CLKOUT7_DIVIDE                            =  12,
   parameter  C_OVERRIDE_PRIMITIVE                        =  0,
   parameter  C_PRIMARY_PORT                              =  "clk_in1",
   parameter  C_SECONDARY_PORT                            =  "clk_in2",
   parameter  C_CLK_OUT1_PORT                             =  "clk_out1",
   parameter  C_CLK_OUT2_PORT                             =  "clk_out2",
   parameter  C_CLK_OUT3_PORT                             =  "clk_out3",
   parameter  C_CLK_OUT4_PORT                             =  "clk_out4",
   parameter  C_CLK_OUT5_PORT                             =  "clk_out5",
   parameter  C_CLK_OUT6_PORT                             =  "clk_out6",
   parameter  C_CLK_OUT7_PORT                             =  "clk_out7",
   parameter  C_RESET_PORT                                =  "reset",
   parameter  C_LOCKED_FB_PORT                            =  "locked_fb",
   parameter  C_CLKIN_DESKEW_PORT                         =  "clkin_deskew",
   parameter  C_CLKFB_DESKEW_PORT                         =  "clkfb_deskew",
   parameter  C_CLKIN1_DESKEW_PORT                        =  "clkin1_deskew",
   parameter  C_CLKFB1_DESKEW_PORT                        =  "clkfb1_deskew",
   parameter  C_CLKIN2_DESKEW_PORT                        =  "clkin2_deskew",
   parameter  C_CLKFB2_DESKEW_PORT                        =  "clkfb2_deskew",
   parameter  C_LOCKED_DESKEW1_PORT                       =  "locked_deskew1",
   parameter  C_LOCKED_DESKEW2_PORT                       =  "locked_deskew2",
   parameter  C_LOCKED_PORT                               =  "locked",
   parameter  C_CLKFB_IN_PORT                             =  "clkfb_in",
   parameter  C_CLKFB_OUT_PORT                            =  "clkfb_out",
   parameter  C_POWER_DOWN_PORT                           =  "power_down",
   parameter  C_DADDR_PORT                                =  "daddr",
   parameter  C_DCLK_PORT                                 =  "dclk",
   parameter  C_DRDY_PORT                                 =  "drdy",
   parameter  C_DWE_PORT                                  =  "dwe",
   parameter  C_DIN_PORT                                  =  "din",
   parameter  C_DOUT_PORT                                 =  "dout",
   parameter  C_DEN_PORT                                  =  "den",
   parameter  C_PSCLK_PORT                                =  "psclk",
   parameter  C_PSEN_PORT                                 =  "psen",
   parameter  C_PSINCDEC_PORT                             =  "psincdec",
   parameter  C_PSDONE_PORT                               =  "psdone",
   parameter  C_CLK_IN_SEL_PORT                           =  "clk_in_sel",
   parameter  C_INPUT_CLK_STOPPED_PORT                    =  "input_clk_stopped",
   parameter  C_CLKFB_STOPPED_PORT                        =  "clkfb_stopped",
   parameter  C_CLKIN1_JITTER_PS                          =  100.0,
   parameter  C_CLKIN2_JITTER_PS                          =  100.0,
   parameter  C_PRIMITIVE                                 =  "MMCM",
   parameter  C_SS_MODE                                   =  "CENTER_HIGH",
   parameter  C_SS_MOD_PERIOD                             =  4.0,
   parameter  C_SS_MOD_TIME                               =  0.004,
   parameter  C_CDDCDONE_PORT                             =  "cddcdone",
   parameter  C_CDDCREQ_PORT                              =  "cddcreq",
   parameter  C_INTERFACE_SELECTION                       =  1,
   parameter  C_S_AXI_ADDR_WIDTH                          =  11,
   parameter  C_S_AXI_DATA_WIDTH                          =  32,
   parameter  C_NUMMBUFGCE                                =  0,
   parameter  C_AUTO_NUMMBUFGCE                           =  0,
   parameter  C_NUMBUFG                                   =  0,
   parameter  C_NUMBUFGCE                                 =  0,
   parameter  C_DIVIDE1_AUTO                              =  1,
   parameter  C_DIVIDE2_AUTO                              =  1,
   parameter  C_DIVIDE3_AUTO                              =  1,
   parameter  C_DIVIDE4_AUTO                              =  1,
   parameter  C_DIVIDE5_AUTO                              =  1,
   parameter  C_DIVIDE6_AUTO                              =  1,
   parameter  C_DIVIDE7_AUTO                              =  1,
   parameter  C_CLK_TREE1                                 =  0,
   parameter  C_CLK_TREE2                                 =  0,
   parameter  C_CLK_TREE3                                 =  0,
   parameter  C_CLK_TREE4                                 =  0,
   parameter  C_CLK_TREE5                                 =  0,
   parameter  C_CLK_TREE6                                 =  0,
   parameter  C_CLK_TREE7                                 =  0,
   parameter  C_MAXCOUNT_DESKEW1                          =  0,
   parameter  C_MAXCOUNT_DESKEW2                          =  0,
   parameter  C_PLLBUFGCEDIV                              =  0,
   parameter  C_MMCMBUFGCEDIV                             =  0,
   parameter  C_PLLBUFGCEDIV1                             =  0,
   parameter  C_PLLBUFGCEDIV2                             =  0,
   parameter  C_PLLBUFGCEDIV3                             =  0,
   parameter  C_PLLBUFGCEDIV4                             =  0,
   parameter  C_MMCMBUFGCEDIV1                            =  0,
   parameter  C_MMCMBUFGCEDIV2                            =  0,
   parameter  C_MMCMBUFGCEDIV3                            =  0,
   parameter  C_MMCMBUFGCEDIV4                            =  0,
   parameter  C_MMCMBUFGCEDIV5                            =  0,
   parameter  C_MMCMBUFGCEDIV6                            =  0,
   parameter  C_MMCMBUFGCEDIV7                            =  0,
   parameter  C_CLKOUT1_MATCHED_ROUTING                   =  0,
   parameter  C_CLKOUT2_MATCHED_ROUTING                   =  0,
   parameter  C_CLKOUT3_MATCHED_ROUTING                   =  0,
   parameter  C_CLKOUT4_MATCHED_ROUTING                   =  0,
   parameter  C_CLKOUT5_MATCHED_ROUTING                   =  0,
   parameter  C_CLKOUT6_MATCHED_ROUTING                   =  0,
   parameter  C_CLKOUT7_MATCHED_ROUTING                   =  0,
   parameter  C_M_MAX                                     = 128,
   parameter  C_M_MIN                                     = 2,
   parameter  C_D_MAX                                     = 80,
   parameter  C_D_MIN                                     = 1,
   parameter  C_O_MAX                                     = 128,
   parameter  C_O_MIN                                     = 1,
   parameter  C_VCO_MIN                                   = 800,
   parameter  C_VCO_MAX                                   = 1600,
   parameter  C_ACTUAL_VCO                                = 800,
   parameter  C_ACTUAL_PFD                                = 100,
   parameter  C_AUTO_PRIMITIVE                            = "MMCM",
   parameter  C_DRP_ADDR_SET1                             = "0000 0000 0000 0000",
   parameter  C_DRP_DATA_SET1                             = "0000 0000 0000 0000",
   parameter  C_DRP_ADDR_SET3                             = "0000 0000 0000 0000",
   parameter  C_DRP_DATA_SET3                             = "0000 0000 0000 0000",
   parameter  C_DRP_ADDR_SET2                             = "0000 0000 0000 0000",
   parameter  C_DRP_DATA_SET2                             = "0000 0000 0000 0000"
  )
  (
  // Output ports
  output s_axi_awready,
  output s_axi_wready,
  output [1:0]s_axi_bresp,
  output s_axi_bvalid,
  output s_axi_arready,
  output [31:0]s_axi_rdata,
  output [1:0]s_axi_rresp,
  output s_axi_rvalid,
  
  // Input ports
  input s_axi_aclk,
  input s_axi_aresetn,
  input [10:0]s_axi_awaddr,
  input s_axi_awvalid,
  input [31:0]s_axi_wdata,
  input [3:0]s_axi_wstrb,
  input s_axi_wvalid,
  input s_axi_bready,
  input [10:0]s_axi_araddr,
  input s_axi_arvalid,
  input s_axi_rready,
  input reset,
  input resetn,
  // input clkfb_deskew,
  // input clkin_deskew,
  // input clkin1_deskew,
  // input clkin2_deskew,
  input clkin1_deskew,
  input clkin2_deskew,
  input clkfb1_deskew,
  input clkfb2_deskew,
  input user_clk0,
  input user_clk1,
  input user_clk2,
  input user_clk3,
  input ref_clk,
  output [3:0] clk_stop,
  output [3:0] clk_glitch,
  output [3:0] clk_oor,
  output interrupt,
  output         clk_out1_o1,
  output         clk_out1_o2,
  output         clk_out1_o3,
  output         clk_out1_o4,
  input         clk_out1_ce,
  input         clk_out1_clr_n,

 output  clk_out1_clrb_leaf ,



  input         clk1_clr_n,
  input         clk2_clr_n,
  input         clk3_clr_n,
  input         clk4_clr_n,
  input         clk5_clr_n,
  input         clk6_clr_n,
  input         clk7_clr_n,
  input         clk1_ce,
  input         clk2_ce,
  input         clk3_ce,
  input         clk4_ce,
  input         clk5_ce,
  input         clk6_ce,
  input         clk7_ce,
  output         clk_out2,
  output         locked,
  output         locked_fb,
  input         clk_in2_p,
  input         clk_in2_n,
  input         clkfb_in_p,
  input         clkfb_in_n,
  output        clkfb_out_p,
  output        clkfb_out_n,
  input         power_down,
  input         clk_in1_p,
  input         clk_in1_n,
  input         clk_in1
  );
  wire locked_int; 
  wire RST_MMCM_PLL;
  wire [6:0] DADDR;
  wire DWE;
  wire DEN;
  wire [15:0] DI;
  wire DCLK;
  wire [15:0] DO;
  wire DRDY;
  
vitis_design_clk_wizard_0_0_clocking_structure #(
   .C_PRIMITIVE                            (C_PRIMITIVE),
   .C_BANDWIDTH                            (C_BANDWIDTH),
   .C_CLKFBOUT_MULT                        (C_CLKFBOUT_MULT),
   .C_CLKFBOUT_FRACT                       (C_CLKFBOUT_FRACT),
   .C_CLKFBOUT_PHASE                       (C_CLKFBOUT_PHASE),      
   .C_CLKIN1_PERIOD                        (C_CLKIN1_PERIOD),
   .C_CLKIN2_PERIOD                        (C_CLKIN2_PERIOD),   
   .C_CLKOUT1_DIVIDE                       (C_CLKOUT1_DIVIDE),   
   .C_CLKOUT1_ACTUAL_DUTY_CYCLE            (C_CLKOUT1_ACTUAL_DUTY_CYCLE),
   .C_CLKOUT1_ACTUAL_PHASE                 (C_CLKOUT1_ACTUAL_PHASE),
   .C_CLKOUT2_DIVIDE                       (C_CLKOUT2_DIVIDE),  
   .C_CLKOUT2_ACTUAL_DUTY_CYCLE            (C_CLKOUT2_ACTUAL_DUTY_CYCLE),
   .C_CLKOUT2_ACTUAL_PHASE                 (C_CLKOUT2_ACTUAL_PHASE), 
   .C_CLKOUT3_DIVIDE                       (C_CLKOUT3_DIVIDE),  
   .C_CLKOUT3_ACTUAL_DUTY_CYCLE            (C_CLKOUT3_ACTUAL_DUTY_CYCLE),
   .C_CLKOUT3_ACTUAL_PHASE                 (C_CLKOUT3_ACTUAL_PHASE),
   .C_CLKOUT4_DIVIDE                       (C_CLKOUT4_DIVIDE),  
   .C_CLKOUT4_ACTUAL_DUTY_CYCLE            (C_CLKOUT4_ACTUAL_DUTY_CYCLE),
   .C_CLKOUT4_ACTUAL_PHASE                 (C_CLKOUT4_ACTUAL_PHASE),
   .C_CLKOUT5_DIVIDE                       (C_CLKOUT5_DIVIDE),   
   .C_CLKOUT5_ACTUAL_DUTY_CYCLE            (C_CLKOUT5_ACTUAL_DUTY_CYCLE),
   .C_CLKOUT5_ACTUAL_PHASE                 (C_CLKOUT5_ACTUAL_PHASE), 
   .C_CLKOUT6_DIVIDE                       (C_CLKOUT6_DIVIDE),   
   .C_CLKOUT6_ACTUAL_DUTY_CYCLE            (C_CLKOUT6_ACTUAL_DUTY_CYCLE),
   .C_CLKOUT6_ACTUAL_PHASE                 (C_CLKOUT6_ACTUAL_PHASE),
   .C_CLKOUT7_DIVIDE                       (C_CLKOUT7_DIVIDE),   
   .C_CLKOUT7_ACTUAL_DUTY_CYCLE            (C_CLKOUT7_ACTUAL_DUTY_CYCLE),
   .C_CLKOUT7_ACTUAL_PHASE                 (C_CLKOUT7_ACTUAL_PHASE),
   .C_COMPENSATION                         (C_COMPENSATION),
   .C_DESKEW_DELAY1                        (C_DESKEW_DELAY1),
   .C_DESKEW_IN1                           (C_DESKEW_IN1),
   .C_DESKEW_FB1                           (C_DESKEW_FB1),
   .C_DESKEW_DELAY2                        (C_DESKEW_DELAY2),
   .C_DESKEW_IN2                           (C_DESKEW_IN2),
   .C_DESKEW_FB2                           (C_DESKEW_FB2),
   .C_DESKEW_DELAY_EN1                     (C_DESKEW_DELAY_EN1),
   .C_DESKEW_DELAY_EN2                     (C_DESKEW_DELAY_EN2),
   .C_DESKEW_DELAY_PATH1                   (C_DESKEW_DELAY_PATH1),
   .C_DESKEW_DELAY_PATH2                   (C_DESKEW_DELAY_PATH2),
   .C_DESKEW_LOCK_CIRCUIT_EN1              (C_DESKEW_LOCK_CIRCUIT_EN1),
   .C_DESKEW_LOCK_CIRCUIT_EN2              (C_DESKEW_LOCK_CIRCUIT_EN2),
   .C_ZHOLD                                (C_ZHOLD),
   .C_CE_TYPE                              (C_CE_TYPE),
   .C_BUFGCE_DIV_CE_TYPE                   (C_BUFGCE_DIV_CE_TYPE),
   .C_CE_SYNC_EXT                          (C_CE_SYNC_EXT),
   .C_SAFECLOCK_STARTUP_MODE               (C_SAFECLOCK_STARTUP_MODE),
   .C_NUMMBUFGCE                           (C_NUMMBUFGCE),
   .C_AUTO_NUMMBUFGCE                      (C_AUTO_NUMMBUFGCE),
   .C_AUTO_PRIMITIVE                       (C_AUTO_PRIMITIVE),
   .C_NUMBUFG                              (C_NUMBUFG),
   .C_NUMBUFGCE                            (C_NUMBUFGCE),
   .C_DIVIDE1_AUTO                         (C_DIVIDE1_AUTO),
   .C_DIVIDE2_AUTO                         (C_DIVIDE2_AUTO),
   .C_DIVIDE3_AUTO                         (C_DIVIDE3_AUTO),
   .C_DIVIDE4_AUTO                         (C_DIVIDE4_AUTO),
   .C_DIVIDE5_AUTO                         (C_DIVIDE5_AUTO),
   .C_DIVIDE6_AUTO                         (C_DIVIDE6_AUTO),
   .C_DIVIDE7_AUTO                         (C_DIVIDE7_AUTO),
   .C_CLK_TREE1                            (C_CLK_TREE1),
   .C_CLK_TREE2                            (C_CLK_TREE2),
   .C_CLK_TREE3                            (C_CLK_TREE3),
   .C_CLK_TREE4                            (C_CLK_TREE4),
   .C_CLK_TREE5                            (C_CLK_TREE5),
   .C_CLK_TREE6                            (C_CLK_TREE6),
   .C_CLK_TREE7                            (C_CLK_TREE7),
   .C_MAXCOUNT_DESKEW1                     (832),
   .C_MAXCOUNT_DESKEW2                     (832),
   .C_DIVCLK_DIVIDE                        (C_DIVCLK_DIVIDE),
   .C_CLKOUT1_DYN_PS                       (C_CLKOUT1_DYN_PS),
   .C_CLKOUT2_DYN_PS                       (C_CLKOUT2_DYN_PS),
   .C_CLKOUT3_DYN_PS                       (C_CLKOUT3_DYN_PS), 
   .C_CLKOUT4_DYN_PS                       (C_CLKOUT4_DYN_PS), 
   .C_CLKOUT5_DYN_PS                       (C_CLKOUT5_DYN_PS), 
   .C_CLKOUT6_DYN_PS                       (C_CLKOUT6_DYN_PS),   
   .C_CLKOUT7_DYN_PS                       (C_CLKOUT7_DYN_PS),   
   .C_CLKOUT1_USED                         (C_CLKOUT1_USED),
   .C_CLKOUT2_USED                         (C_CLKOUT2_USED),
   .C_CLKOUT3_USED                         (C_CLKOUT3_USED),
   .C_CLKOUT4_USED                         (C_CLKOUT4_USED),
   .C_CLKOUT5_USED                         (C_CLKOUT5_USED),
   .C_CLKOUT6_USED                         (C_CLKOUT6_USED),   
   .C_CLKOUT7_USED                         (C_CLKOUT7_USED),  
   .C_CLKOUT1_DRIVES                       (C_CLKOUT1_DRIVES),
   .C_CLKOUT2_DRIVES                       (C_CLKOUT2_DRIVES),
   .C_CLKOUT3_DRIVES                       (C_CLKOUT3_DRIVES),
   .C_CLKOUT4_DRIVES                       (C_CLKOUT4_DRIVES),
   .C_CLKOUT5_DRIVES                       (C_CLKOUT5_DRIVES), 
   .C_CLKOUT6_DRIVES                       (C_CLKOUT6_DRIVES),    
   .C_CLKOUT7_DRIVES                       (C_CLKOUT7_DRIVES),   
   .C_CLK_OUT1_PORT                        (C_CLK_OUT1_PORT),
   .C_CLK_OUT2_PORT                        (C_CLK_OUT2_PORT),
   .C_CLK_OUT3_PORT                        (C_CLK_OUT3_PORT),
   .C_CLK_OUT4_PORT                        (C_CLK_OUT4_PORT),
   .C_CLK_OUT5_PORT                        (C_CLK_OUT5_PORT),
   .C_CLK_OUT6_PORT                        (C_CLK_OUT6_PORT),   
   .C_CLK_OUT7_PORT                        (C_CLK_OUT7_PORT), 
   .C_CLKOUTFB_PHASE_CTRL                         (C_CLKOUTFB_PHASE_CTRL), 
   .C_REF_JITTER1                          (C_REF_JITTER1),  
   .C_REF_JITTER2                          (C_REF_JITTER2),
   .C_USE_SPREAD_SPECTRUM                  (C_USE_SPREAD_SPECTRUM),
   .C_CLKIN1_IBUF                          (C_CLKIN1_IBUF),
   .C_CLKIN1_BUFG                          (C_CLKIN1_BUFG),
   .C_CLKIN1_IBUFDS                        (C_CLKIN1_IBUFDS),
   .C_CLKIN2_IBUF                          (C_CLKIN2_IBUF),
   .C_CLKIN2_BUFG                          (C_CLKIN2_BUFG),
   .C_CLKIN2_IBUFDS                        (C_CLKIN2_IBUFDS),
   .C_SIM_DEVICE                           (C_SIM_DEVICE),
   .C_CLKFBIN_IBUF                         (C_CLKFBIN_IBUF),
   .C_CLKFBIN_IBUFDS                       (C_CLKFBIN_IBUFDS),
   .C_CLKFBOUT_BUFG                        (C_CLKFBOUT_BUFG),
   .C_CLKFBOUT_ODDR                        (C_CLKFBOUT_ODDR),
   .C_CLKFBIN_OBUFDS                       (C_CLKFBIN_OBUFDS),
   .C_CLKFBIN_OBUF                         (C_CLKFBIN_OBUF),
   .C_SS_MOD_PERIOD                        (C_SS_MOD_PERIOD),
   .C_SS_MODE                              (C_SS_MODE)
 ) clock_primitive_inst (
  // Output ports
  .clk_out1_o1   (clk_out1_o1),
  .clk_out1_o2   (clk_out1_o2),
  .clk_out1_o3   (clk_out1_o3),
  .clk_out1_o4   (clk_out1_o4),

  . clk_out1_clrb_leaf  ( clk_out1_clrb_leaf) ,






  .clk_out1_ce    (clk_out1_ce),
  .clk_out1_clr    (clk_out1_clr_n),
  .clk_out2      (clk_out2),
  .locked    (locked_int),
  .resetn    (resetn),
  .clkin1_deskew  (clkin1_deskew),
  .clkin2_deskew  (clkin2_deskew),
  .clkfb1_deskew  (clkfb1_deskew),
  .clkfb2_deskew  (clkfb2_deskew),
   //.C_CLKIN1_DESKEW_PORT                   (C_CLKIN1_DESKEW_PORT),
   //.C_CLKFB1_DESKEW_PORT                   (C_CLKFB1_DESKEW_PORT),
   //.C_CLKIN2_DESKEW_PORT                   (C_CLKIN2_DESKEW_PORT),
   //.C_CLKFB2_DESKEW_PORT                   (C_CLKFB2_DESKEW_PORT),
   
   

  .clk_in1    (clk_in1)
 );
 assign locked = locked_int;
endmodule  
