//////////////////////////////////////////////////////////////////////////////
// Proprietary Note:
// XILINX CONFIDENTIAL
//
// Copyright 2012 Xilinx, Inc. All rights reserved.
// This file contains confidential and proprietary information of Xilinx, Inc.
// and is protected under U.S. and international copyright and other
// intellectual property laws.
//
// DISCLAIMER
// This disclaimer is not a license and does not grant any
// rights to the materials distributed herewith. Except as
// otherwise provided in a valid license issued to you by
// Xilinx, and to the maximum extent permitted by applicable
// law: (1) THESE MATERIALS ARE MADE AVAILABLE "AS IS" AND
// WITH ALL FAULTS, AND XILINX HEREBY DISCLAIMS ALL WARRANTIES
// AND CONDITIONS, EXPRESS, IMPLIED, OR STATUTORY, INCLUDING
// BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, NON-
// INFRINGEMENT, OR FITNESS FOR ANY PARTICULAR PURPOSE; and
// (2) Xilinx shall not be liable (whether in contract or tort,
// including negligence, or under any other theory of
// liability) for any loss or damage of any kind or nature
// related to, arising under or in connection with these
// materials, including for any direct, or any indirect,
// special, incidental, or consequential loss or damage
// (including loss of data, profits, goodwill, or any type of
// loss or damage suffered as a result of any action brought
// by a third party) even if such damage or loss was
// reasonably foreseeable or Xilinx had been advised of the
// possibility of the same.
//
// CRITICAL APPLICATIONS
// Xilinx products are not designed or intended to be fail-
// safe, or for use in any application requiring fail-safe
// performance, such as life-support or safety devices or
// systems, Class III medical devices, nuclear facilities,
// applications related to the deployment of airbags, or any
// other applications that could lead to death, personal
// injury, or severe property or environmental damage
// (individually and collectively, "Critical
// Applications"). Customer assumes the sole risk and
// liability of any use of Xilinx products in Critical
// Applications, subject only to applicable laws and
// regulations governing limitations on product liability.
//
// THIS COPYRIGHT NOTICE AND DISCLAIMER MUST BE RETAINED AS
// PART OF THIS FILE AT ALL TIMES.
//
// 
//
//       Owner:
//       Revision:       $Id: //depot/icm/proj/everest_7t_n1/rtl/noc_7t_n1/include/noc_common_define.vh $
//                       $Author: kins $
//                       $DateTime: 2016/04/12 15:30:13 $
//                       $Change: 1234567 $
//       Description: 
///////////////////////////////////////////////////////////////////////////////
`ifndef _ref_hbm_common_define_vh_
`define _ref_hbm_common_define_vh_

// ********************************************************
// REF AXI Interface Common Define
// ********************************************************
// AXI
//`define REF_AXID_WIDTH  16
//`define REF_AXADDR_WIDTH  64
`define REF_HBM_AXID_WIDTH  7
`define REF_HBM_AXADDR_WIDTH  48
`define REF_HBM_AXADDR_UPPER_WIDTH  52
`define REF_HBM_AXADDR_LOWER_WIDTH  12
`define REF_HBM_AXLEN_WIDTH  8
`define REF_HBM_AXSIZE_WIDTH  3
`define REF_HBM_AXBURST_WIDTH  2
`define REF_HBM_AXLOCK_WIDTH  1  // Only support exclusive, no legacy LOCK support
`define REF_HBM_AXCACHE_WIDTH  4
`define REF_HBM_AXPROT_WIDTH  3
`define REF_HBM_AXQOS_WIDTH  4
`define REF_HBM_AXREGION_WIDTH  4
//`define REF_AXUSER_WIDTH  16
`define REF_HBM_AXUSER_WIDTH  11
`define REF_HBM_AXDATA512_WIDTH  512 // Max. AxWidth is 512 for PL
`define REF_HBM_AXSTRB64_WIDTH  64
`define REF_HBM_AXDATA256_WIDTH  256 // Max. AxWidth is 256 for HBM
`define REF_HBM_AXSTRB32_WIDTH  32
`define REF_HBM_AXDATA128_WIDTH  128 // Max. AxWidth is 128 for non-PL
`define REF_HBM_AXSTRB16_WIDTH  16
`define REF_HBM_AXDATA64_WIDTH  64 // Max. AxWidth is 64
`define REF_HBM_AXSTRB8_WIDTH  8
`define REF_HBM_AXDATA32_WIDTH  32 // Max. AxWidth is 32 for NPI
`define REF_HBM_AXSTRB4_WIDTH  4
`define REF_HBM_AXRESP_WIDTH  2
`define REF_HBM_AXLAST_WIDTH 1

`define REF_HBM_AXADDR_PAR_WIDTH 8
`define REF_HBM_AXCTRL_PAR_WIDTH 1
`define REF_HBM_AXDATA512_PAR_WIDTH 64
`define REF_HBM_AXDATA256_PAR_WIDTH 32
`define REF_HBM_AXDATA128_PAR_WIDTH 16
`define REF_HBM_AXDATA64_PAR_WIDTH 8
`define REF_HBM_AXDATA32_PAR_WIDTH 4
`define REF_HBM_AXSTRB64_PAR_WIDTH 8
`define REF_HBM_AXSTRB32_PAR_WIDTH 4
`define REF_HBM_AXSTRB16_PAR_WIDTH 2
`define REF_HBM_AXSTRB8_PAR_WIDTH 1
`define REF_HBM_AXSTRB4_PAR_WIDTH 1
`define REF_HBM_AXCID_WIDTH 2 // Compressed AXI-ID
`define REF_HBM_SRCID_WIDTH 12 // Source-ID - MUST MATCH NOC-ID WIDTH
`define REF_HBM_AXPOISON_WIDTH 1
`define REF_HBM_AXWCID_WIDTH 4   //compressed AXI-ID - specific for PS
`define REF_HBM_SMID_WIDTH  10
`define REF_HBM_TDEST_WIDTH  10
`define REF_HBM_TID_WIDTH   6   //TID or compressed AXI-ID for PL/ME

// AR
`define REF_HBM_ARID_WIDTH     `REF_HBM_AXID_WIDTH
`define REF_HBM_ARADDR_WIDTH   `REF_HBM_AXADDR_WIDTH
`define REF_HBM_ARLEN_WIDTH    `REF_HBM_AXLEN_WIDTH
`define REF_HBM_ARSIZE_WIDTH   `REF_HBM_AXSIZE_WIDTH
`define REF_HBM_ARBURST_WIDTH  `REF_HBM_AXBURST_WIDTH
`define REF_HBM_ARLOCK_WIDTH   `REF_HBM_AXLOCK_WIDTH
`define REF_HBM_ARCACHE_WIDTH  `REF_HBM_AXCACHE_WIDTH
`define REF_HBM_ARPROT_WIDTH   `REF_HBM_AXPROT_WIDTH
`define REF_HBM_ARQOS_WIDTH    `REF_HBM_AXQOS_WIDTH
`define REF_HBM_ARREGION_WIDTH  `REF_HBM_AXREGION_WIDTH
`define REF_HBM_ARUSER_WIDTH   `REF_HBM_AXUSER_WIDTH
`define REF_HBM_AR_WIDTH  (`REF_HBM_ARID_WIDTH + `REF_HBM_ARADDR_WIDTH + `REF_HBM_ARLEN_WIDTH + `REF_HBM_ARSIZE_WIDTH + `REF_HBM_ARBURST_WIDTH + `REF_HBM_ARLOCK_WIDTH + `REF_HBM_ARCACHE_WIDTH + `REF_HBM_ARPROT_WIDTH + `REF_HBM_ARQOS_WIDTH + `REF_HBM_ARREGION_WIDTH + `REF_HBM_ARUSER_WIDTH)

`define REF_HBM_ARCID_WIDTH      `REF_HBM_AXCID_WIDTH
`define REF_HBM_ARADDR_PAR_WIDTH `REF_HBM_AXADDR_PAR_WIDTH
`define REF_HBM_ARCTRL_PAR_WIDTH `REF_HBM_AXCTRL_PAR_WIDTH
`define REF_HBM_AR_PAR_WIDTH  (`REF_HBM_ARID_WIDTH + `REF_HBM_ARADDR_WIDTH + `REF_HBM_ARLEN_WIDTH + `REF_HBM_ARSIZE_WIDTH + `REF_HBM_ARBURST_WIDTH + `REF_HBM_ARLOCK_WIDTH + `REF_HBM_ARCACHE_WIDTH + `REF_HBM_ARPROT_WIDTH + `REF_HBM_ARQOS_WIDTH + `REF_HBM_ARREGION_WIDTH + `REF_HBM_ARUSER_WIDTH + `REF_HBM_ARADDR_PAR_WIDTH)
`define REF_HBM_AR_PAR_CID_WIDTH  (`REF_HBM_ARID_WIDTH + `REF_HBM_ARADDR_WIDTH + `REF_HBM_ARLEN_WIDTH + `REF_HBM_ARSIZE_WIDTH + `REF_HBM_ARBURST_WIDTH + `REF_HBM_ARLOCK_WIDTH + `REF_HBM_ARCACHE_WIDTH + `REF_HBM_ARPROT_WIDTH + `REF_HBM_ARQOS_WIDTH + `REF_HBM_ARREGION_WIDTH + `REF_HBM_ARUSER_WIDTH + `REF_HBM_ARADDR_PAR_WIDTH + `REF_HBM_ARCID_WIDTH + `REF_SRCID_WIDTH)

// AW
`define REF_HBM_AWID_WIDTH     `REF_HBM_AXID_WIDTH
`define REF_HBM_AWADDR_WIDTH   `REF_HBM_AXADDR_WIDTH
`define REF_HBM_AWLEN_WIDTH    `REF_HBM_AXLEN_WIDTH
`define REF_HBM_AWSIZE_WIDTH   `REF_HBM_AXSIZE_WIDTH
`define REF_HBM_AWBURST_WIDTH  `REF_HBM_AXBURST_WIDTH
`define REF_HBM_AWLOCK_WIDTH   `REF_HBM_AXLOCK_WIDTH
`define REF_HBM_AWCACHE_WIDTH  `REF_HBM_AXCACHE_WIDTH
`define REF_HBM_AWPROT_WIDTH   `REF_HBM_AXPROT_WIDTH
`define REF_HBM_AWQOS_WIDTH    `REF_HBM_AXQOS_WIDTH
`define REF_HBM_AWREGION_WIDTH  `REF_HBM_AXREGION_WIDTH
`define REF_HBM_AWUSER_WIDTH   `REF_HBM_AXUSER_WIDTH
`define REF_HBM_AW_WIDTH  (`REF_HBM_AWID_WIDTH + `REF_HBM_AWADDR_WIDTH + `REF_HBM_AWLEN_WIDTH + `REF_HBM_AWSIZE_WIDTH + `REF_HBM_AWBURST_WIDTH + `REF_HBM_AWLOCK_WIDTH + `REF_HBM_AWCACHE_WIDTH + `REF_HBM_AWPROT_WIDTH + `REF_HBM_AWQOS_WIDTH + `REF_HBM_AWREGION_WIDTH + `REF_HBM_AWUSER_WIDTH)

`define REF_HBM_AWCID_WIDTH `REF_HBM_AXCID_WIDTH
`define REF_HBM_AWADDR_PAR_WIDTH `REF_HBM_AXADDR_PAR_WIDTH
`define REF_HBM_AWCTRL_PAR_WIDTH `REF_HBM_AXCTRL_PAR_WIDTH
`define REF_HBM_AW_PAR_WIDTH  (`REF_HBM_AWID_WIDTH + `REF_HBM_AWADDR_WIDTH + `REF_HBM_AWLEN_WIDTH + `REF_HBM_AWSIZE_WIDTH + `REF_HBM_AWBURST_WIDTH + `REF_HBM_AWLOCK_WIDTH + `REF_HBM_AWCACHE_WIDTH + `REF_HBM_AWPROT_WIDTH + `REF_HBM_AWQOS_WIDTH + `REF_HBM_AWREGION_WIDTH + `REF_HBM_AWUSER_WIDTH + `REF_HBM_AWADDR_PAR_WIDTH)
`define REF_HBM_AW_PAR_CID_WIDTH  (`REF_HBM_AWID_WIDTH + `REF_HBM_AWADDR_WIDTH + `REF_HBM_AWLEN_WIDTH + `REF_HBM_AWSIZE_WIDTH + `REF_HBM_AWBURST_WIDTH + `REF_HBM_AWLOCK_WIDTH + `REF_HBM_AWCACHE_WIDTH + `REF_HBM_AWPROT_WIDTH + `REF_HBM_AWQOS_WIDTH + `REF_HBM_AWREGION_WIDTH + `REF_HBM_AWUSER_WIDTH + `REF_HBM_AWADDR_PAR_WIDTH + `REF_HBM_AWCID_WIDTH + `REF_SRCID_WIDTH)

// W
`define REF_HBM_WLAST_WIDTH   `REF_HBM_AXLAST_WIDTH
`define REF_HBM_WID_WIDTH     `REF_HBM_AXID_WIDTH
`define REF_HBM_WPOISON_WIDTH `REF_HBM_AXPOISON_WIDTH
`define REF_HBM_WDATA512_WIDTH   `REF_HBM_AXDATA512_WIDTH
`define REF_HBM_WSTRB64_WIDTH   `REF_HBM_AXSTRB64_WIDTH
`define REF_HBM_WDATA256_WIDTH   `REF_HBM_AXDATA256_WIDTH
`define REF_HBM_WSTRB32_WIDTH   `REF_HBM_AXSTRB32_WIDTH
`define REF_HBM_WDATA128_WIDTH   `REF_HBM_AXDATA128_WIDTH
`define REF_HBM_WSTRB16_WIDTH   `REF_HBM_AXSTRB16_WIDTH
`define REF_HBM_WDATA64_WIDTH   `REF_HBM_AXDATA64_WIDTH
`define REF_HBM_WSTRB8_WIDTH   `REF_HBM_AXSTRB8_WIDTH
`define REF_HBM_WDATA32_WIDTH   `REF_HBM_AXDATA32_WIDTH
`define REF_HBM_WSTRB4_WIDTH   `REF_HBM_AXSTRB4_WIDTH
`define REF_HBM_WUSER_WIDTH   `REF_HBM_AXUSER_WIDTH // Dont have space in NPP to support
`define REF_HBM_W512_WIDTH  (`REF_HBM_WLAST_WIDTH + `REF_HBM_WID_WIDTH + `REF_HBM_WDATA512_WIDTH + `REF_HBM_WSTRB64_WIDTH + `REF_HBM_WUSER_WIDTH)
`define REF_HBM_W256_WIDTH  (`REF_HBM_WLAST_WIDTH + `REF_HBM_WID_WIDTH + `REF_HBM_WDATA256_WIDTH + `REF_HBM_WSTRB32_WIDTH + `REF_HBM_WUSER_WIDTH)
`define REF_HBM_W128_WIDTH  (`REF_HBM_WLAST_WIDTH + `REF_HBM_WID_WIDTH + `REF_HBM_WDATA128_WIDTH + `REF_HBM_WSTRB16_WIDTH + `REF_HBM_WUSER_WIDTH)
`define REF_HBM_W64_WIDTH  (`REF_HBM_WLAST_WIDTH + `REF_HBM_WID_WIDTH + `REF_HBM_WDATA64_WIDTH + `REF_HBM_WSTRB8_WIDTH + `REF_HBM_WUSER_WIDTH)
`define REF_HBM_W32_WIDTH  (`REF_HBM_WLAST_WIDTH + `REF_HBM_WID_WIDTH + `REF_HBM_WDATA32_WIDTH + `REF_HBM_WSTRB4_WIDTH + `REF_HBM_WUSER_WIDTH)

`define REF_HBM_WCID_WIDTH `REF_HBM_AXWCID_WIDTH
`define REF_HBM_WDATA512_PAR_WIDTH `REF_HBM_AXDATA512_PAR_WIDTH
`define REF_HBM_WDATA256_PAR_WIDTH `REF_HBM_AXDATA256_PAR_WIDTH
`define REF_HBM_WDATA128_PAR_WIDTH `REF_HBM_AXDATA128_PAR_WIDTH
`define REF_HBM_WDATA64_PAR_WIDTH `REF_HBM_AXDATA64_PAR_WIDTH
`define REF_HBM_WDATA32_PAR_WIDTH `REF_HBM_AXDATA32_PAR_WIDTH
`define REF_HBM_WSTRB64_PAR_WIDTH `REF_HBM_AXSTRB64_PAR_WIDTH
`define REF_HBM_WSTRB32_PAR_WIDTH `REF_HBM_AXSTRB32_PAR_WIDTH
`define REF_HBM_WSTRB16_PAR_WIDTH `REF_HBM_AXSTRB16_PAR_WIDTH
`define REF_HBM_WSTRB8_PAR_WIDTH `REF_HBM_AXSTRB8_PAR_WIDTH
`define REF_HBM_WSTRB4_PAR_WIDTH `REF_HBM_AXSTRB4_PAR_WIDTH
`define REF_HBM_WCTRL_PAR_WIDTH `REF_HBM_AXCTRL_PAR_WIDTH
`define REF_HBM_W512_PAR_WIDTH  (`REF_HBM_WLAST_WIDTH + `REF_HBM_WID_WIDTH + `REF_HBM_WDATA512_WIDTH + `REF_HBM_WSTRB64_WIDTH + `REF_HBM_WUSER_WIDTH + `REF_HBM_WDATA512_PAR_WIDTH /*+ `REF_HBM_WSTRB64_PAR_WIDTH*/ + `REF_HBM_WPOISON_WIDTH)
`define REF_HBM_W512_PAR_CID_WIDTH  (`REF_HBM_WLAST_WIDTH + `REF_HBM_WID_WIDTH + `REF_HBM_WDATA512_WIDTH + `REF_HBM_WSTRB64_WIDTH + `REF_HBM_WUSER_WIDTH + `REF_HBM_WCID_WIDTH + `REF_HBM_WDATA512_PAR_WIDTH /*+ `REF_HBM_WSTRB64_PAR_WIDTH*/ + `REF_HBM_WID_WIDTH + `REF_SRCID_WIDTH + `REF_HBM_WPOISON_WIDTH)
`define REF_HBM_W512_PAR_TID_WIDTH  (`REF_HBM_WLAST_WIDTH + `REF_HBM_WID_WIDTH + `REF_HBM_WDATA512_WIDTH + `REF_HBM_WSTRB64_WIDTH + `REF_HBM_WUSER_WIDTH + `REF_HBM_TID_WIDTH + `REF_HBM_WDATA512_PAR_WIDTH /*+ `REF_HBM_WSTRB64_PAR_WIDTH*/ + `REF_HBM_WID_WIDTH + `REF_SRCID_WIDTH + `REF_HBM_WPOISON_WIDTH)
`define REF_HBM_W256_PAR_WIDTH  (`REF_HBM_WLAST_WIDTH + `REF_HBM_WID_WIDTH + `REF_HBM_WDATA256_WIDTH + `REF_HBM_WSTRB32_WIDTH + `REF_HBM_WUSER_WIDTH + `REF_HBM_WDATA256_PAR_WIDTH /*+ `REF_HBM_WSTRB32_PAR_WIDTH*/ + `REF_HBM_WCTRL_PAR_WIDTH + `REF_HBM_WPOISON_WIDTH)
`define REF_HBM_W256_PAR_CID_WIDTH  (`REF_HBM_WLAST_WIDTH + `REF_HBM_WID_WIDTH + `REF_HBM_WDATA256_WIDTH + `REF_HBM_WSTRB32_WIDTH + `REF_HBM_WUSER_WIDTH + `REF_HBM_WCID_WIDTH + `REF_HBM_WDATA256_PAR_WIDTH /*+ `REF_HBM_WSTRB32_PAR_WIDTH*/ + `REF_HBM_WID_WIDTH + `REF_SRCID_WIDTH + `REF_HBM_WPOISON_WIDTH)
`define REF_HBM_W256_PAR_TID_WIDTH  (`REF_HBM_WLAST_WIDTH + `REF_HBM_WID_WIDTH + `REF_HBM_WDATA256_WIDTH + `REF_HBM_WSTRB32_WIDTH + `REF_HBM_WUSER_WIDTH + `REF_HBM_TID_WIDTH + `REF_HBM_WDATA256_PAR_WIDTH /*+ `REF_HBM_WSTRB32_PAR_WIDTH*/ + `REF_HBM_WID_WIDTH + `REF_SRCID_WIDTH + `REF_HBM_WPOISON_WIDTH)
`define REF_HBM_W128_PAR_WIDTH  (`REF_HBM_WLAST_WIDTH + `REF_HBM_WID_WIDTH + `REF_HBM_WDATA128_WIDTH + `REF_HBM_WSTRB16_WIDTH + `REF_HBM_WUSER_WIDTH + `REF_HBM_WDATA128_PAR_WIDTH /*+ `REF_HBM_WSTRB16_PAR_WIDTH*/ + `REF_HBM_WCTRL_PAR_WIDTH + `REF_HBM_WPOISON_WIDTH)
`define REF_HBM_W128_PAR_CID_WIDTH  (`REF_HBM_WLAST_WIDTH + `REF_HBM_WID_WIDTH + `REF_HBM_WDATA128_WIDTH + `REF_HBM_WSTRB16_WIDTH + `REF_HBM_WUSER_WIDTH + `REF_HBM_WCID_WIDTH + `REF_HBM_WDATA128_PAR_WIDTH /*+ `REF_HBM_WSTRB16_PAR_WIDTH*/ + `REF_HBM_WID_WIDTH + `REF_SRCID_WIDTH + `REF_HBM_WPOISON_WIDTH)
`define REF_HBM_W128_PAR_TID_WIDTH  (`REF_HBM_WLAST_WIDTH + `REF_HBM_WID_WIDTH + `REF_HBM_WDATA128_WIDTH + `REF_HBM_WSTRB16_WIDTH + `REF_HBM_WUSER_WIDTH + `REF_HBM_TID_WIDTH + `REF_HBM_WDATA128_PAR_WIDTH /*+ `REF_HBM_WSTRB16_PAR_WIDTH*/ + `REF_HBM_WID_WIDTH + `REF_SRCID_WIDTH + `REF_HBM_WPOISON_WIDTH)
`define REF_HBM_W64_PAR_WIDTH  (`REF_HBM_WLAST_WIDTH + `REF_HBM_WID_WIDTH + `REF_HBM_WDATA64_WIDTH + `REF_HBM_WSTRB8_WIDTH + `REF_HBM_WUSER_WIDTH + `REF_HBM_WDATA64_PAR_WIDTH /*+ `REF_HBM_WSTRB8_PAR_WIDTH*/ + `REF_HBM_WCTRL_PAR_WIDTH + `REF_HBM_WPOISON_WIDTH)
`define REF_HBM_W64_PAR_CID_WIDTH  (`REF_HBM_WLAST_WIDTH + `REF_HBM_WID_WIDTH + `REF_HBM_WDATA64_WIDTH + `REF_HBM_WSTRB8_WIDTH + `REF_HBM_WUSER_WIDTH + `REF_HBM_WCID_WIDTH + `REF_HBM_WDATA64_PAR_WIDTH /*+ `REF_HBM_WSTRB8_PAR_WIDTH*/ + `REF_HBM_WID_WIDTH + `REF_SRCID_WIDTH + `REF_HBM_WPOISON_WIDTH)
`define REF_HBM_W64_PAR_TID_WIDTH  (`REF_HBM_WLAST_WIDTH + `REF_HBM_WID_WIDTH + `REF_HBM_WDATA64_WIDTH + `REF_HBM_WSTRB8_WIDTH + `REF_HBM_WUSER_WIDTH + `REF_HBM_TID_WIDTH + `REF_HBM_WDATA64_PAR_WIDTH /*+ `REF_HBM_WSTRB8_PAR_WIDTH*/ + `REF_HBM_WID_WIDTH + `REF_SRCID_WIDTH + `REF_HBM_WPOISON_WIDTH)
`define REF_HBM_W32_PAR_WIDTH  (`REF_HBM_WLAST_WIDTH + `REF_HBM_WID_WIDTH + `REF_HBM_WDATA32_WIDTH + `REF_HBM_WSTRB4_WIDTH + `REF_HBM_WUSER_WIDTH + `REF_HBM_WDATA32_PAR_WIDTH /*+ `REF_HBM_WSTRB4_PAR_WIDTH*/ + `REF_HBM_WCTRL_PAR_WIDTH + `REF_HBM_WPOISON_WIDTH)
`define REF_HBM_W32_PAR_CID_WIDTH  (`REF_HBM_WLAST_WIDTH + `REF_HBM_WID_WIDTH + `REF_HBM_WDATA32_WIDTH + `REF_HBM_WSTRB4_WIDTH + `REF_HBM_WUSER_WIDTH + `REF_HBM_WCID_WIDTH + `REF_HBM_WDATA32_PAR_WIDTH /*+ `REF_HBM_WSTRB4_PAR_WIDTH*/ + `REF_HBM_WID_WIDTH + `REF_SRCID_WIDTH + `REF_HBM_WPOISON_WIDTH)
`define REF_HBM_W32_PAR_TID_WIDTH  (`REF_HBM_WLAST_WIDTH + `REF_HBM_WID_WIDTH + `REF_HBM_WDATA32_WIDTH + `REF_HBM_WSTRB4_WIDTH + `REF_HBM_WUSER_WIDTH + `REF_HBM_TID_WIDTH + `REF_HBM_WDATA32_PAR_WIDTH /*+ `REF_HBM_WSTRB4_PAR_WIDTH*/ + `REF_HBM_WID_WIDTH + `REF_SRCID_WIDTH + `REF_HBM_WPOISON_WIDTH)

// R
`define REF_HBM_RLAST_WIDTH   `REF_HBM_AXLAST_WIDTH
`define REF_HBM_RID_WIDTH     `REF_HBM_AXID_WIDTH
`define REF_HBM_RRESP_WIDTH   `REF_HBM_AXRESP_WIDTH
`define REF_HBM_RDATA512_WIDTH   `REF_HBM_AXDATA512_WIDTH
`define REF_HBM_RDATA256_WIDTH   `REF_HBM_AXDATA256_WIDTH
`define REF_HBM_RDATA128_WIDTH   `REF_HBM_AXDATA128_WIDTH
`define REF_HBM_RDATA64_WIDTH   `REF_HBM_AXDATA64_WIDTH
`define REF_HBM_RDATA32_WIDTH   `REF_HBM_AXDATA32_WIDTH
`define REF_HBM_RUSER_WIDTH   `REF_HBM_AXUSER_WIDTH // Dont have space in NPP to support
`define REF_HBM_R512_WIDTH  (`REF_HBM_RLAST_WIDTH + `REF_HBM_RID_WIDTH + `REF_HBM_RRESP_WIDTH + `REF_HBM_RDATA512_WIDTH + `REF_HBM_RUSER_WIDTH)
`define REF_HBM_R256_WIDTH  (`REF_HBM_RLAST_WIDTH + `REF_HBM_RID_WIDTH + `REF_HBM_RRESP_WIDTH + `REF_HBM_RDATA256_WIDTH + `REF_HBM_RUSER_WIDTH)
`define REF_HBM_R128_WIDTH  (`REF_HBM_RLAST_WIDTH + `REF_HBM_RID_WIDTH + `REF_HBM_RRESP_WIDTH + `REF_HBM_RDATA128_WIDTH + `REF_HBM_RUSER_WIDTH)
`define REF_HBM_R64_WIDTH  (`REF_HBM_RLAST_WIDTH + `REF_HBM_RID_WIDTH + `REF_HBM_RRESP_WIDTH + `REF_HBM_RDATA64_WIDTH + `REF_HBM_RUSER_WIDTH)
`define REF_HBM_R32_WIDTH  (`REF_HBM_RLAST_WIDTH + `REF_HBM_RID_WIDTH + `REF_HBM_RRESP_WIDTH + `REF_HBM_RDATA32_WIDTH + `REF_HBM_RUSER_WIDTH)

`define REF_HBM_RCID_WIDTH `REF_HBM_AXCID_WIDTH
`define REF_HBM_RPOISON_WIDTH `REF_HBM_AXPOISON_WIDTH 
`define REF_HBM_RDATA512_PAR_WIDTH `REF_HBM_AXDATA512_PAR_WIDTH
`define REF_HBM_RDATA256_PAR_WIDTH `REF_HBM_AXDATA256_PAR_WIDTH
`define REF_HBM_RDATA128_PAR_WIDTH `REF_HBM_AXDATA128_PAR_WIDTH
`define REF_HBM_RDATA64_PAR_WIDTH `REF_HBM_AXDATA64_PAR_WIDTH
`define REF_HBM_RDATA32_PAR_WIDTH `REF_HBM_AXDATA32_PAR_WIDTH
`define REF_HBM_RCTRL_PAR_WIDTH `REF_HBM_AXCTRL_PAR_WIDTH
`define REF_HBM_R512_PAR_WIDTH  (`REF_HBM_RLAST_WIDTH + `REF_HBM_RID_WIDTH + `REF_HBM_RRESP_WIDTH + `REF_HBM_RDATA512_WIDTH + `REF_HBM_RUSER_WIDTH + `REF_HBM_RDATA512_PAR_WIDTH + `REF_HBM_RPOISON_WIDTH)
`define REF_HBM_R512_PAR_CID_WIDTH  (`REF_HBM_RLAST_WIDTH + `REF_HBM_RRESP_WIDTH + `REF_HBM_RDATA512_WIDTH + `REF_HBM_RUSER_WIDTH + `REF_HBM_RCID_WIDTH + `REF_HBM_RDATA512_PAR_WIDTH + `REF_HBM_RPOISON_WIDTH)
`define REF_HBM_R256_PAR_WIDTH  (`REF_HBM_RLAST_WIDTH + `REF_HBM_RID_WIDTH + `REF_HBM_RRESP_WIDTH + `REF_HBM_RDATA256_WIDTH + `REF_HBM_RUSER_WIDTH + `REF_HBM_RDATA256_PAR_WIDTH + `REF_HBM_RPOISON_WIDTH)
`define REF_HBM_R256_PAR_CID_WIDTH  (`REF_HBM_RLAST_WIDTH + `REF_HBM_RRESP_WIDTH + `REF_HBM_RDATA256_WIDTH + `REF_HBM_RUSER_WIDTH + `REF_HBM_RCID_WIDTH + `REF_HBM_RDATA256_PAR_WIDTH + `REF_HBM_RPOISON_WIDTH)
`define REF_HBM_R128_PAR_WIDTH  (`REF_HBM_RLAST_WIDTH + `REF_HBM_RID_WIDTH + `REF_HBM_RRESP_WIDTH + `REF_HBM_RDATA128_WIDTH + `REF_HBM_RUSER_WIDTH + `REF_HBM_RDATA128_PAR_WIDTH + `REF_HBM_RPOISON_WIDTH)
`define REF_HBM_R128_PAR_CID_WIDTH  (`REF_HBM_RLAST_WIDTH + `REF_HBM_RRESP_WIDTH + `REF_HBM_RDATA128_WIDTH + `REF_HBM_RUSER_WIDTH + `REF_HBM_RCID_WIDTH + `REF_HBM_RDATA128_PAR_WIDTH + `REF_HBM_RPOISON_WIDTH)
`define REF_HBM_R64_PAR_WIDTH  (`REF_HBM_RLAST_WIDTH + `REF_HBM_RID_WIDTH + `REF_HBM_RRESP_WIDTH + `REF_HBM_RDATA64_WIDTH + `REF_HBM_RUSER_WIDTH + `REF_HBM_RDATA64_PAR_WIDTH + `REF_HBM_RPOISON_WIDTH)
`define REF_HBM_R64_PAR_CID_WIDTH  (`REF_HBM_RLAST_WIDTH + `REF_HBM_RRESP_WIDTH + `REF_HBM_RDATA64_WIDTH + `REF_HBM_RUSER_WIDTH + `REF_HBM_RCID_WIDTH + `REF_HBM_RDATA64_PAR_WIDTH + `REF_HBM_RPOISON_WIDTH)
`define REF_HBM_R32_PAR_WIDTH  (`REF_HBM_RLAST_WIDTH + `REF_HBM_RID_WIDTH + `REF_HBM_RRESP_WIDTH + `REF_HBM_RDATA32_WIDTH + `REF_HBM_RUSER_WIDTH + `REF_HBM_RDATA32_PAR_WIDTH + `REF_HBM_RPOISON_WIDTH)
`define REF_HBM_R32_PAR_CID_WIDTH  (`REF_HBM_RLAST_WIDTH + `REF_HBM_RRESP_WIDTH + `REF_HBM_RDATA32_WIDTH + `REF_HBM_RUSER_WIDTH + `REF_HBM_RCID_WIDTH + `REF_HBM_RDATA32_PAR_WIDTH + `REF_HBM_RPOISON_WIDTH)

// B
`define REF_HBM_BID_WIDTH     `REF_HBM_AXID_WIDTH
`define REF_HBM_BRESP_WIDTH   `REF_HBM_AXRESP_WIDTH
`define REF_HBM_BUSER_WIDTH   `REF_HBM_AXUSER_WIDTH
`define REF_HBM_B_WIDTH  (`REF_HBM_BID_WIDTH + `REF_HBM_BRESP_WIDTH + `REF_HBM_BUSER_WIDTH)
   
`define REF_HBM_BCID_WIDTH `REF_HBM_AXCID_WIDTH
`define REF_HBM_BCTRL_PAR_WIDTH `REF_HBM_AXCTRL_PAR_WIDTH
`define REF_HBM_B_PAR_WIDTH  (`REF_HBM_BID_WIDTH + `REF_HBM_BRESP_WIDTH + `REF_HBM_BUSER_WIDTH)
`define REF_HBM_B_PAR_CID_WIDTH  (`REF_HBM_BCID_WIDTH + `REF_HBM_BRESP_WIDTH + `REF_HBM_BUSER_WIDTH)

// ********************************************************
// NoC AXI protocol Define
// ********************************************************
`define REF_HBM_AXSIZE_8    3'b000
`define REF_HBM_AXSIZE_16   3'b001  
`define REF_HBM_AXSIZE_32   3'b010  
`define REF_HBM_AXSIZE_64   3'b011  
`define REF_HBM_AXSIZE_128  3'b100
`define REF_HBM_AXSIZE_256  3'b101  
`define REF_HBM_AXSIZE_512  3'b110  
   
`define REF_HBM_AXBURST_FIXED   2'b00
`define REF_HBM_AXBURST_INCR    2'b01
`define REF_HBM_AXBURST_WRAP    2'b10
   
`define REF_HBM_AXLOCK_NORMAL     2'b00
`define REF_HBM_AXLOCK_EXCLUSIVE  2'b01
`define REF_HBM_AXLOCK_LOCKED     2'b10
   
`define REF_HBM_AXI_RESP_OKAY   2'b00
`define REF_HBM_AXI_RESP_EXOKAY 2'b01
`define REF_HBM_AXI_RESP_SLVERR 2'b10
`define REF_HBM_AXI_RESP_DECERR 2'b11

// ********************************************************
// Enable SIDEFILE for VIVADO 
// ********************************************************
// `ifndef BFM_SIMULATION
// `ifndef NMU_HBM_BFM_SIMULATION
// `ifndef EN_AXI_PERF_MON
// `define SIDEFILE_EN 
// `endif
// `endif
// `endif

`endif
