# Monitor points

# Platform options
set_property HDL_ATTRIBUTE.DPA_AXILITE_MASTER true [get_bd_intf_pins /axi_smc_vip_hier/icn_ctrl/M08_AXI]
set_property HDL_ATTRIBUTE.DPA_TRACE_MASTER true [get_bd_intf_pins /axi_smc_vip_hier/icn_ctrl/M09_AXI]

#Trace Dictionaries
set default_trace [dict create \
  DEPTH 8192 \
  MEM_SPACE FIFO \
  MEM_INDEX 0 \
  MASTER /axi_smc_vip_hier/icn_ctrl/M09_AXI \
  CLK_SRC /mm2s/ap_clk \
  RST_SRC /mm2s/ap_rst_n \
  SLR SLR0 \
  DEDICATED 1 \
];


# Call debug/profiling automation
set dpa_dict [list \
              [get_bd_intf_pins s2mm/s]  {TYPE data DETAIL all CLK_SRC /s2mm/ap_clk RST_SRC /s2mm/ap_rst_n MEMORY Stream PRINTABLE_KEY {[get_bd_intf_pins s2mm/s]} INS_MODE auto} \
              [get_bd_intf_pins mm2s/m_axi_gmem]  {TYPE data DETAIL all CLK_SRC /mm2s/ap_clk RST_SRC /mm2s/ap_rst_n MEMORY DDR PRINTABLE_KEY {[get_bd_intf_pins mm2s/m_axi_gmem]} INS_MODE auto} \
              [get_bd_intf_pins mm2s/s]  {TYPE data DETAIL all CLK_SRC /mm2s/ap_clk RST_SRC /mm2s/ap_rst_n MEMORY Stream PRINTABLE_KEY {[get_bd_intf_pins mm2s/s]} INS_MODE auto} \
              [get_bd_intf_pins s2mm/m_axi_gmem]  {TYPE data DETAIL all CLK_SRC /s2mm/ap_clk RST_SRC /s2mm/ap_rst_n MEMORY DDR PRINTABLE_KEY {[get_bd_intf_pins s2mm/m_axi_gmem]} INS_MODE auto} \
             ]
set dpa_opts [list \
              SETTINGS  {HW_EMU true IS_EMBEDDED true IS_CMA false VERSAL_DFX 0} \
              AIE_TRACE  {FIFO_DEPTH 4096 PACKET_RATE 100 CLK_SELECT default PROFILE_STREAMS false MEM_TYPE DDR MEM_SPACE DDR MEM_INDEX 0} \
              SYSTEM_DEADLOCK  {DEADLOCK_OPTION disable} \
              AXILITE  {MASTER /axi_smc_vip_hier/icn_ctrl/M08_AXI CLK_SRC /mm2s/ap_clk RST_SRC /mm2s/ap_rst_n} \
              TRACE_OFFLOAD  $default_trace \
             ]

set_param bd.enable_dpa 1
set_param bd.debug_profile.script /home/amd/training/system_simulation/lab/sys_project/system_project/build/hw_emu/hw_link/binary_container_1/binary_container_1/vivado/vpl/.local/debug_profile_automation.tcl
apply_bd_automation -rule xilinx.com:bd_rule:debug_profile -opts $dpa_opts -dict $dpa_dict

# Write debug_ip_layout
debug_profile::write_debug_ip_layout true "xilinx.com:vck190:versal_extensible_platform_base:1.0" "/home/amd/training/system_simulation/lab/sys_project/system_project/build/hw_emu/hw_link/binary_container_1/binary_container_1/int"
