//-----------------------------------------------------------------------------
//
// (c) Copyright 2022-2026 Advanced Micro Devices, Inc. All rights reserved.
//
// This file contains confidential and proprietary information
// of AMD and is protected under U.S. and international copyright
// and other intellectual property laws.
//
// DISCLAIMER
// This disclaimer is not a license and does not grant any
// rights to the materials distributed herewith. Except as
// otherwise provided in a valid license issued to you by
// AMD, and to the maximum extent permitted by applicable
// law: (1) THESE MATERIALS ARE MADE AVAILABLE "AS IS" AND
// WITH ALL FAULTS, AND AMD HEREBY DISCLAIMS ALL WARRANTIES
// AND CONDITIONS, EXPRESS, IMPLIED, OR STATUTORY, INCLUDING
// BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, NON-
// INFRINGEMENT, OR FITNESS FOR ANY PARTICULAR PURPOSE; and
// (2) AMD shall not be liable (whether in contract or tort,
// including negligence, or under any other theory of
// liability) for any loss or damage of any kind or nature
// related to, arising under or in connection with these
// materials, including for any direct, or any indirect,
// special, incidental, or consequential loss or damage
// (including loss of data, profits, goodwill, or any type of
// loss or damage suffered as a result of any action brought
// by a third party) even if such damage or loss was
// reasonably foreseeable or AMD had been advised of the
// possibility of the same.
//
// CRITICAL APPLICATIONS
// AMD products are not designed or intended to be fail-
// safe, or for use in any application requiring fail-safe
// performance, such as life-support or safety devices or
// systems, Class III medical devices, nuclear facilities,
// applications related to the deployment of airbags, or any
// other applications that could lead to death, personal
// injury, or severe property or environmental damage
// (individually and collectively, "Critical
// Applications"). Customer assumes the sole risk and
// liability of any use of AMD products in Critical
// Applications, subject only to applicable laws and
// regulations governing limitations on product liability.
//
// THIS COPYRIGHT NOTICE AND DISCLAIMER MUST BE RETAINED AS
// PART OF THIS FILE AT ALL TIMES.
//
//-----------------------------------------------------------------------------
//
// Project : AMD Versal Adaptive SoC CPM 4
// File    : bd_57a1_cpm_0_0_core_top.sv
// Version : 1.0
//-----------------------------------------------------------------------------


`timescale 1ps/1ps

(* HW_HANDOFF = "bd_57a1_cpm_0_0.hwdef" *)
(* DONT_TOUCH = "TRUE" *)
module bd_57a1_cpm_0_0_core_top
  #(
  parameter TCQ = 100,
  // PCIe Controller 0 core parameters
  parameter C_CPM_PCIE0_MODES = "PCIE",
  parameter C_CPM_PCIE0_ARI_CAP_ENABLE = 0,
  parameter C_CPM_PCIE0_PF0_MSI_ENABLED = 0,
  parameter C_CPM_PCIE0_PF0_PASID_CAP_ON = 0,
  parameter C_CPM_PCIE0_CONTROLLER_ENABLE = 0,
  parameter C_CPM_PCIE0_PL_UPSTREAM_FACING = 1,
  parameter C_CPM_PCIE0_AXISTEN_IF_WIDTH = 256,
  parameter C_CPM_PCIE0_MODE_FOR_POWER = "NONE",
  parameter C_CPM_PCIE0_LINK_WIDTH_FOR_POWER = 0,
  parameter C_CPM_PCIE0_USER_CLK_FREQ = "250_MHz",
  parameter C_CPM_PCIE0_AXIS_CC_TUSER_WIDTH = 81,
  parameter C_CPM_PCIE0_AXIS_RC_TUSER_WIDTH = 161,
  parameter C_CPM_PCIE0_AXIS_RQ_TUSER_WIDTH = 183,
  parameter C_CPM_PCIE0_AXIS_CQ_TUSER_WIDTH = 229,
  parameter C_CPM_PCIE0_LINK_SPEED_FOR_POWER = "GEN1",
  parameter [3:0] C_CPM_PCIE0_TL_PF_ENABLE_REG = 4'h0,
  parameter [3:0] C_CPM_PCIE0_SRIOV_CAP_ENABLE = 4'h0,
  parameter C_CPM_PCIE0_PL_LINK_CAP_MAX_LINK_WIDTH = 8,

  // PCIe Controller 0 SRIOV parameters
  parameter [15:0]  C_CPM_PCIE0_PF0_SRIOV_CAP_TOTAL_VF = 16'h0,
  parameter [15:0]  C_CPM_PCIE0_PF0_SRIOV_FIRST_VF_OFFSET = 16'h0,
  parameter [15:0]  C_CPM_PCIE0_PF1_SRIOV_CAP_TOTAL_VF = 16'h0,
  parameter [15:0]  C_CPM_PCIE0_PF1_SRIOV_FIRST_VF_OFFSET = 16'h0,
  parameter [15:0]  C_CPM_PCIE0_PF2_SRIOV_CAP_TOTAL_VF = 16'h0,
  parameter [15:0]  C_CPM_PCIE0_PF2_SRIOV_FIRST_VF_OFFSET = 16'h0,
  parameter [15:0]  C_CPM_PCIE0_PF3_SRIOV_CAP_TOTAL_VF = 16'h0,
  parameter [15:0]  C_CPM_PCIE0_PF3_SRIOV_FIRST_VF_OFFSET = 16'h0,

  //PCIe Controller 0 ATS/PRI Capability enable
  parameter C_CPM_PCIE0_PF0_ATS_CAP_ON = 0,
  parameter C_CPM_PCIE0_VFG0_ATS_CAP_ON = 0,
  parameter C_CPM_PCIE0_PF1_ATS_CAP_ON = 0,
  parameter C_CPM_PCIE0_VFG1_ATS_CAP_ON = 0,
  parameter C_CPM_PCIE0_PF2_ATS_CAP_ON = 0,
  parameter C_CPM_PCIE0_VFG2_ATS_CAP_ON = 0,
  parameter C_CPM_PCIE0_PF3_ATS_CAP_ON = 0,
  parameter C_CPM_PCIE0_VFG3_ATS_CAP_ON = 0,
  parameter C_CPM_PCIE0_PF0_PRI_CAP_ON = 0,
  parameter C_CPM_PCIE0_VFG0_PRI_CAP_ON = 0,
  parameter C_CPM_PCIE0_PF1_PRI_CAP_ON = 0,
  parameter C_CPM_PCIE0_VFG1_PRI_CAP_ON = 0,
  parameter C_CPM_PCIE0_PF2_PRI_CAP_ON = 0,
  parameter C_CPM_PCIE0_VFG2_PRI_CAP_ON = 0,
  parameter C_CPM_PCIE0_PF3_PRI_CAP_ON = 0,
  parameter C_CPM_PCIE0_VFG3_PRI_CAP_ON = 0,

  // PCIe Controller 1 core parameters
  parameter C_CPM_PCIE1_MODES = "PCIE",
  parameter C_CPM_PCIE1_ARI_CAP_ENABLE = 0,
  parameter C_CPM_PCIE1_PF0_MSI_ENABLED = 0,
  parameter C_CPM_PCIE1_PF0_PASID_CAP_ON = 0,
  parameter C_CPM_PCIE1_CONTROLLER_ENABLE = 0,
  parameter C_CPM_PCIE1_PL_UPSTREAM_FACING = 1,
  parameter C_CPM_PCIE1_AXISTEN_IF_WIDTH = 256,
  parameter C_CPM_PCIE1_MODE_FOR_POWER = "NONE",
  parameter C_CPM_PCIE1_LINK_WIDTH_FOR_POWER = 0,
  parameter C_CPM_PCIE1_USER_CLK_FREQ = "250_MHz",
  parameter C_CPM_PCIE1_AXIS_CC_TUSER_WIDTH = 81,
  parameter C_CPM_PCIE1_AXIS_RC_TUSER_WIDTH = 161,
  parameter C_CPM_PCIE1_AXIS_RQ_TUSER_WIDTH = 183,
  parameter C_CPM_PCIE1_AXIS_CQ_TUSER_WIDTH = 229,
  parameter C_CPM_PCIE1_LINK_SPEED_FOR_POWER = "GEN1",
  parameter [3:0] C_CPM_PCIE1_TL_PF_ENABLE_REG = 4'h0,
  parameter [3:0] C_CPM_PCIE1_SRIOV_CAP_ENABLE = 4'h0,
  parameter C_CPM_PCIE1_PL_LINK_CAP_MAX_LINK_WIDTH = 8,

  // PCIe Controller 1 SRIOV parameters
  parameter [15:0]  C_CPM_PCIE1_PF0_SRIOV_CAP_TOTAL_VF = 16'h0,
  parameter [15:0]  C_CPM_PCIE1_PF0_SRIOV_FIRST_VF_OFFSET = 16'h0,
  parameter [15:0]  C_CPM_PCIE1_PF1_SRIOV_CAP_TOTAL_VF = 16'h0,
  parameter [15:0]  C_CPM_PCIE1_PF1_SRIOV_FIRST_VF_OFFSET = 16'h0,
  parameter [15:0]  C_CPM_PCIE1_PF2_SRIOV_CAP_TOTAL_VF = 16'h0,
  parameter [15:0]  C_CPM_PCIE1_PF2_SRIOV_FIRST_VF_OFFSET = 16'h0,
  parameter [15:0]  C_CPM_PCIE1_PF3_SRIOV_CAP_TOTAL_VF = 16'h0,
  parameter [15:0]  C_CPM_PCIE1_PF3_SRIOV_FIRST_VF_OFFSET = 16'h0,

  //PCIe Controller 1 ATS/PRI Capability enable
  parameter C_CPM_PCIE1_PF0_ATS_CAP_ON = 0,
  parameter C_CPM_PCIE1_VFG0_ATS_CAP_ON = 0,
  parameter C_CPM_PCIE1_PF1_ATS_CAP_ON = 0,
  parameter C_CPM_PCIE1_VFG1_ATS_CAP_ON = 0,
  parameter C_CPM_PCIE1_PF2_ATS_CAP_ON = 0,
  parameter C_CPM_PCIE1_VFG2_ATS_CAP_ON = 0,
  parameter C_CPM_PCIE1_PF3_ATS_CAP_ON = 0,
  parameter C_CPM_PCIE1_VFG3_ATS_CAP_ON = 0,
  parameter C_CPM_PCIE1_PF0_PRI_CAP_ON = 0,
  parameter C_CPM_PCIE1_VFG0_PRI_CAP_ON = 0,
  parameter C_CPM_PCIE1_PF1_PRI_CAP_ON = 0,
  parameter C_CPM_PCIE1_VFG1_PRI_CAP_ON = 0,
  parameter C_CPM_PCIE1_PF2_PRI_CAP_ON = 0,
  parameter C_CPM_PCIE1_VFG2_PRI_CAP_ON = 0,
  parameter C_CPM_PCIE1_PF3_PRI_CAP_ON = 0,
  parameter C_CPM_PCIE1_VFG3_PRI_CAP_ON = 0,


  // XPIPE 0 parameters
  parameter [1:0]  C_XPIPE_0_MODE = 2'b00,
  parameter        C_XPIPE_0_LOC = "QUAD0",
  parameter [15:0] C_XPIPE_0_REG_CFG = 16'h0000,
  parameter [0:0]  C_XPIPE_0_INSTANTIATED = 1'b1,
  parameter [31:0] C_XPIPE_0_RSVD = 32'h00000000,
  parameter        C_XPIPE_0_LINK0_CFG = "DISABLE",
  parameter        C_XPIPE_0_LINK1_CFG = "DISABLE",
  parameter [31:0] C_XPIPE_0_CLK_CFG = 32'h00000000,
  parameter [31:0] C_XPIPE_0_CLKDLY_CFG = 32'h00000000,

  // XPIPE 1 parameters
  parameter [1:0]  C_XPIPE_1_MODE = 2'b00,
  parameter        C_XPIPE_1_LOC = "QUAD0",
  parameter [15:0] C_XPIPE_1_REG_CFG = 16'h0000,
  parameter [0:0]  C_XPIPE_1_INSTANTIATED = 1'b1,
  parameter [31:0] C_XPIPE_1_RSVD = 32'h00000000,
  parameter        C_XPIPE_1_LINK0_CFG = "DISABLE",
  parameter        C_XPIPE_1_LINK1_CFG = "DISABLE",
  parameter [31:0] C_XPIPE_1_CLK_CFG = 32'h00000000,
  parameter [31:0] C_XPIPE_1_CLKDLY_CFG = 32'h00000000,

  // XPIPE 2 parameters
  parameter [1:0]  C_XPIPE_2_MODE = 2'b00,
  parameter        C_XPIPE_2_LOC = "QUAD0",
  parameter [15:0] C_XPIPE_2_REG_CFG = 16'h0000,
  parameter [0:0]  C_XPIPE_2_INSTANTIATED = 1'b1,
  parameter [31:0] C_XPIPE_2_RSVD = 32'h00000000,
  parameter        C_XPIPE_2_LINK0_CFG = "DISABLE",
  parameter        C_XPIPE_2_LINK1_CFG = "DISABLE",
  parameter [31:0] C_XPIPE_2_CLK_CFG = 32'h00000000,
  parameter [31:0] C_XPIPE_2_CLKDLY_CFG = 32'h00000000,

  // XPIPE 3 parameters
  parameter [1:0]  C_XPIPE_3_MODE = 2'b00,
  parameter        C_XPIPE_3_LOC = "QUAD0",
  parameter [15:0] C_XPIPE_3_REG_CFG = 16'h0000,
  parameter [0:0]  C_XPIPE_3_INSTANTIATED = 1'b1,
  parameter [31:0] C_XPIPE_3_RSVD = 32'h00000000,
  parameter        C_XPIPE_3_LINK0_CFG = "DISABLE",
  parameter        C_XPIPE_3_LINK1_CFG = "DISABLE",
  parameter [31:0] C_XPIPE_3_CLK_CFG = 32'h00000000,
  parameter [31:0] C_XPIPE_3_CLKDLY_CFG = 32'h00000000,


  parameter C_CPM_PCIE0_NUM_USR_IRQ = 1,
  parameter [6:0] C_CPM_PCIE0_USE_MODE = 7'h4,
  parameter C_CPM_PCIE_CHANNELS_FOR_POWER = 0,
  parameter C_CPM_PCIE0_XDMA_EDGE_INTERRUPT = 0,
  parameter C_CPM_PCIE0_FUNCTIONAL_MODE = "DMA",

  parameter C_PS_HSDP_MODE = "NONE",
  parameter C_PS_HSDP_INGRESS_TRAFFIC = "JTAG",

  parameter C_CPM_DMA_IS_MM_ONLY = 0,
  parameter C_CPM_CCIX_IS_MM_ONLY = 0,
  
  parameter MDMA_H2C_TUSER_WIDTH = 128,
  parameter MDMA_DSC_IN_NUM_MM_CHNL = 2,
  parameter MDMA_TM_DSC_STS_NUM_CHNL = 1,
  parameter MDMA_C2H_DSC_IN_NUM_ST_CHNL = 2,
  parameter MDMA_H2C_DSC_IN_NUM_ST_CHNL = 1,

  parameter XDMA_2PF_INTERRUPT_ENABLE = "FALSE",
  
  parameter C_CPM_PIPESIM = "FALSE",
  parameter C_CPM_PIPE_SIGS_WIDTH = 42,
  parameter C_CPM_COMM_SIGS_WIDTH = 14,
  parameter C_CPM_PIPESIM_CLK_MASTER ="FALSE",  

  parameter C_CPM_PCIE0_CORE_CLK_FREQ  = "500_MHz",
  parameter C_CPM_PCIE0_USER_CLK2_FREQ = "250_MHz",
  parameter C_CPM_PCIE1_CORE_CLK_FREQ  = "500_MHz",
  parameter C_CPM_PCIE1_USER_CLK2_FREQ = "250_MHz"
) (

  // DMA Resets
  output dma0_axi_aresetn,
  input  dma0_soft_resetn,

  // CPM IRQs
  input  cpm_irq0,
  input  cpm_irq1,
  output cpm_cor_irq,
  output cpm_misc_irq,
  output cpm_uncor_irq,

  // DMA IRQ
  output  dma0_irq,

  // PCIe Controller 0 clk/reset
  output pcie0_user_clk,
  output pcie0_user_reset,
  output pcie0_user_lnk_up,

  // PCIe Controller 0 extended configuration interface
  input  [31:0] pcie0_cfg_ext_read_data,
  output [31:0] pcie0_cfg_ext_write_data,
  output        pcie0_cfg_ext_read_received,
  output        pcie0_cfg_ext_write_received,
  output [7:0]  pcie0_cfg_ext_function_number,
  input         pcie0_cfg_ext_read_data_valid,
  output [9:0]  pcie0_cfg_ext_register_number,
  output [3:0]  pcie0_cfg_ext_write_byte_enable,

  // PCIe Controller 0 extended data rate
  output pcie0_edr_enable,
  output pcie0_edr_datarate_change_req,
  input  pcie0_edr_datarate_change_ack,

  // PCIe Controller 0 error reporting
  input  pcie0_cfg_err_cor_in,
  output pcie0_cfg_err_cor_out,
  input  pcie0_cfg_err_uncor_in,
  output pcie0_cfg_err_fatal_out,
  output pcie0_cfg_err_nonfatal_out,
  output pcie0_cfg_local_error_valid,
  output [4:0] pcie0_cfg_local_error_out,

  // PCIe Controller 0 configuration management interface
  input  [9:0]  pcie0_cfg_mgmt_addr,
  input  [3:0]  pcie0_cfg_mgmt_byte_en,
  input         pcie0_cfg_mgmt_read_en,
  input         pcie0_cfg_mgmt_write_en,
  output [31:0] pcie0_cfg_mgmt_read_data,
  input  [31:0] pcie0_cfg_mgmt_write_data,
  input         pcie0_cfg_mgmt_debug_access,
  input  [7:0]  pcie0_cfg_mgmt_function_number,
  output        pcie0_cfg_mgmt_read_write_done,

 // PCIe Controller 0 PASID interface
  output [3:0]  pcie0_cfg_pasid_enable,
  output [11:0] pcie0_cfg_pasid_control,
  output [19:0] pcie0_cfg_max_pasid_width_control,
  output [3:0]  pcie0_cfg_pasid_privil_mode_enable,
  output [3:0]  pcie0_cfg_pasid_exec_permission_enable,

  // PCIe Controller 0 interrupt interface
  input  [3:0]  pcie0_cfg_interrupt_int,
  output        pcie0_cfg_interrupt_sent,
  input  [3:0]  pcie0_cfg_interrupt_pending,

  // PCIe Controller 0 header/packet statistics
  output [9:0]  pcie0_rq_tag0,
  output [9:0]  pcie0_rq_tag1,
  output [3:0]  pcie0_rq_tag_av,
  input  [1:0]  pcie0_cq_np_req,
  output [3:0]  pcie0_tfc_npd_av,
  output [3:0]  pcie0_tfc_nph_av,
  output        pcie0_rq_tag_vld0,
  output        pcie0_rq_tag_vld1,
  output [5:0]  pcie0_rq_seq_num0,
  output [5:0]  pcie0_rq_seq_num1,
  output [5:0]  pcie0_cq_np_req_count,
  output        pcie0_rq_seq_num_vld0,
  output        pcie0_rq_seq_num_vld1,
  // PCIe Controller 1 clk/reset
  output pcie1_user_clk,
  output pcie1_user_reset,
  output pcie1_user_lnk_up,

  // PCIe Controller 1 extended configuration interface
  input  [31:0] pcie1_cfg_ext_read_data,
  output [31:0] pcie1_cfg_ext_write_data,
  output        pcie1_cfg_ext_read_received,
  output        pcie1_cfg_ext_write_received,
  output [7:0]  pcie1_cfg_ext_function_number,
  input         pcie1_cfg_ext_read_data_valid,
  output [9:0]  pcie1_cfg_ext_register_number,
  output [3:0]  pcie1_cfg_ext_write_byte_enable,

  // PCIe Controller 1 extended data rate
  output pcie1_edr_enable,
  output pcie1_edr_datarate_change_req,
  input  pcie1_edr_datarate_change_ack,

  // PCIe Controller 1 error reporting
  input  pcie1_cfg_err_cor_in,
  output pcie1_cfg_err_cor_out,
  input  pcie1_cfg_err_uncor_in,
  output pcie1_cfg_err_fatal_out,
  output pcie1_cfg_err_nonfatal_out,
  output pcie1_cfg_local_error_valid,
  output [4:0] pcie1_cfg_local_error_out,

  // PCIe Controller 1 configuration management interface
  input  [9:0]  pcie1_cfg_mgmt_addr,
  input  [3:0]  pcie1_cfg_mgmt_byte_en,
  input         pcie1_cfg_mgmt_read_en,
  input         pcie1_cfg_mgmt_write_en,
  output [31:0] pcie1_cfg_mgmt_read_data,
  input  [31:0] pcie1_cfg_mgmt_write_data,
  input         pcie1_cfg_mgmt_debug_access,
  input  [7:0]  pcie1_cfg_mgmt_function_number,
  output        pcie1_cfg_mgmt_read_write_done,

 // PCIe Controller 1 PASID interface
  output [3:0]  pcie1_cfg_pasid_enable,
  output [11:0] pcie1_cfg_pasid_control,
  output [19:0] pcie1_cfg_max_pasid_width_control,
  output [3:0]  pcie1_cfg_pasid_privil_mode_enable,
  output [3:0]  pcie1_cfg_pasid_exec_permission_enable,

  // PCIe Controller 1 interrupt interface
  input  [3:0]  pcie1_cfg_interrupt_int,
  output        pcie1_cfg_interrupt_sent,
  input  [3:0]  pcie1_cfg_interrupt_pending,

  // PCIe Controller 1 header/packet statistics
  output [9:0]  pcie1_rq_tag0,
  output [9:0]  pcie1_rq_tag1,
  output [3:0]  pcie1_rq_tag_av,
  input  [1:0]  pcie1_cq_np_req,
  output [3:0]  pcie1_tfc_npd_av,
  output [3:0]  pcie1_tfc_nph_av,
  output        pcie1_rq_tag_vld0,
  output        pcie1_rq_tag_vld1,
  output [5:0]  pcie1_rq_seq_num0,
  output [5:0]  pcie1_rq_seq_num1,
  output [5:0]  pcie1_cq_np_req_count,
  output        pcie1_rq_seq_num_vld0,
  output        pcie1_rq_seq_num_vld1,


  // PCIe Controller 0 flow control interface
  output [11:0] pcie0_cfg_fc_pd,
  output [7:0]  pcie0_cfg_fc_ph,
  input  [2:0]  pcie0_cfg_fc_sel,
  output [11:0] pcie0_cfg_fc_npd,
  output [7:0]  pcie0_cfg_fc_nph,
  output [11:0] pcie0_cfg_fc_cpld,
  output [7:0]  pcie0_cfg_fc_cplh,
  input         pcie0_cfg_fc_vc_sel,
  output [1:0]  pcie0_cfg_fc_pd_scale,
  output [1:0]  pcie0_cfg_fc_ph_scale,
  output [1:0]  pcie0_cfg_fc_npd_scale,
  output [1:0]  pcie0_cfg_fc_nph_scale,
  output [1:0]  pcie0_cfg_fc_cpld_scale,
  output [1:0]  pcie0_cfg_fc_cplh_scale,

  // PCIe Controller 0 config message rx/tx interface
  output        pcie0_cfg_msg_received,
  output [7:0]  pcie0_cfg_msg_received_data,
  output [4:0]  pcie0_cfg_msg_received_type,
  input         pcie0_cfg_msg_transmit,
  input  [31:0] pcie0_cfg_msg_transmit_data,
  output        pcie0_cfg_msg_transmit_done,
  input  [2:0]  pcie0_cfg_msg_transmit_type,

  // PCIe Controller 0 Configuration Control/Status interface
  output [3:0]  pcie0_cfg_10b_tag_requester_enable,
  output [3:0]  pcie0_cfg_atomic_requester_enable,
  input  [3:0]  pcie0_cfg_flr_done,
  output [1:0]  pcie0_cfg_current_speed,
  output        pcie0_cfg_ext_tag_enable,
  output [3:0]  pcie0_cfg_flr_in_process,
  output [3:0]  pcie0_cfg_ats_control_enable,
  output [11:0] pcie0_cfg_function_power_state,
  output [3:0]  pcie0_cfg_rcb_status,
  output [5:0]  pcie0_cfg_ltssm_state,
  output [1:0]  pcie0_cfg_max_payload,
  output [7:0]  pcie0_cfg_pri_control,
  output [1:0]  pcie0_cfg_rx_pm_state,
  output [11:0] pcie0_cfg_tph_st_mode,
  output [1:0]  pcie0_cfg_tx_pm_state,
  output [2:0]  pcie0_cfg_max_read_req,
  input         pcie0_cfg_hot_reset_in,
  output        pcie0_cfg_hot_reset_out,
  output        pcie0_cfg_phy_link_down,
  output [1:0]  pcie0_cfg_phy_link_status,
  output [15:0] pcie0_cfg_function_status,
  output [1:0]  pcie0_cfg_link_power_state,
  output [2:0]  pcie0_cfg_negotiated_width,
  output        pcie0_cfg_pl_status_change,
  output [3:0]  pcie0_cfg_tph_requester_enable,
  input         pcie0_cfg_power_state_change_ack,
  output        pcie0_cfg_power_state_change_interrupt,
  output        pcie0_cfg_vc1_enable,
  output        pcie0_cfg_vc1_negotiation_pending,

  // PCIe Controller 0 SRIOV Configuration status interface
  output [2*252-1:0]  pcie0_cfg_vf_status,
  input               pcie0_cfg_vf_flr_done,
  output [3*252-1:0]  pcie0_cfg_vf_power_state,
  output [3*252-1:0]  pcie0_cfg_vf_tph_st_mode,
  input  [7:0]        pcie0_cfg_vf_flr_func_num,
  output [251:0]      pcie0_cfg_vf_flr_in_process,
  output [251:0]      pcie0_cfg_vf_ats_control_enable,
  output [251:0]      pcie0_cfg_vf_tph_requester_enable,

  // PCIe Controller 0 MSIX interface
  input  [2:0]    pcie0_cfg_msix_attr,
  input  [31:0]   pcie0_cfg_msix_data,
  output [3:0]    pcie0_cfg_msix_mask,
  output [3:0]    pcie0_cfg_msix_enable,
  input  [63:0]   pcie0_cfg_msix_address,
  input  [1:0]    pcie0_cfg_msix_tph_type,
  input  [7:0]    pcie0_cfg_msix_tph_st_tag,
  input           pcie0_cfg_msix_int_vector,
  input  [31:0]   pcie0_cfg_msix_mint_vector,
  input           pcie0_cfg_msix_tph_present,
  input  [1:0]    pcie0_cfg_msix_vec_pending,
  input  [7:0]    pcie0_cfg_msix_function_number,
  output          pcie0_cfg_msix_fail,
  output          pcie0_cfg_msix_sent,
  output          pcie0_cfg_msix_vec_pending_status,
  output [251:0]  pcie0_cfg_msix_vf_mask,
  output [251:0]  pcie0_cfg_msix_vf_enable,

  // PCIe0 MSI interface
  input  [2:0]  pcie0_cfg_msi_attr,
  output [31:0] pcie0_cfg_msi_data,
  output [3:0]  pcie0_cfg_msi_enable,
  input  [1:0]  pcie0_cfg_msi_select,
  output [11:0] pcie0_cfg_msi_mmenable,
  input  [1:0]  pcie0_cfg_msi_tph_type,
  input  [31:0] pcie0_cfg_msi_int_vector,
  input  [7:0]  pcie0_cfg_msi_tph_st_tag,
  input         pcie0_cfg_msi_tph_present,
  input  [31:0] pcie0_cfg_msi_pending_status,
  input  [7:0]  pcie0_cfg_msi_function_number,
  input         pcie0_cfg_msi_pending_status_data_enable,
  input  [1:0]  pcie0_cfg_msi_pending_status_function_number,
  output pcie0_cfg_msi_fail,
  output pcie0_cfg_msi_sent,
  output pcie0_cfg_msi_mask_update,

  // PCIe Controller 0 CQ AXI-Streaming interface
  output pcie0_m_axis_cq_tlast,
  output pcie0_m_axis_cq_tvalid,
  input  pcie0_m_axis_cq_tready,
  output [C_CPM_PCIE0_AXIS_CQ_TUSER_WIDTH-1:0] pcie0_m_axis_cq_tuser,
  output [C_CPM_PCIE0_AXISTEN_IF_WIDTH-1:0] pcie0_m_axis_cq_tdata,
  output [(C_CPM_PCIE0_AXISTEN_IF_WIDTH/32)-1:0]  pcie0_m_axis_cq_tkeep,

  // PCIe Controller 0 RC AXI-Streaming interface
  output pcie0_m_axis_rc_tlast,
  output pcie0_m_axis_rc_tvalid,
  input  pcie0_m_axis_rc_tready,
  output [C_CPM_PCIE0_AXIS_RC_TUSER_WIDTH-1:0] pcie0_m_axis_rc_tuser,
  output [C_CPM_PCIE0_AXISTEN_IF_WIDTH-1:0] pcie0_m_axis_rc_tdata,
  output [(C_CPM_PCIE0_AXISTEN_IF_WIDTH/32)-1:0]  pcie0_m_axis_rc_tkeep,

  // PCIe Controller 0 RQ AXI-Streaming interface
  input  pcie0_s_axis_rq_tlast,
  input  pcie0_s_axis_rq_tvalid,
  output pcie0_s_axis_rq_tready,
  input  [C_CPM_PCIE0_AXIS_RQ_TUSER_WIDTH-1:0] pcie0_s_axis_rq_tuser,
  input  [C_CPM_PCIE0_AXISTEN_IF_WIDTH-1:0] pcie0_s_axis_rq_tdata,
  input  [(C_CPM_PCIE0_AXISTEN_IF_WIDTH/32)-1:0]  pcie0_s_axis_rq_tkeep,

  // PCIe Controller 0 CC AXI-Streaming interface
  input  pcie0_s_axis_cc_tlast,
  input  pcie0_s_axis_cc_tvalid,
  output pcie0_s_axis_cc_tready,
  input  [C_CPM_PCIE0_AXIS_CC_TUSER_WIDTH-1:0] pcie0_s_axis_cc_tuser,
  input  [C_CPM_PCIE0_AXISTEN_IF_WIDTH-1:0] pcie0_s_axis_cc_tdata,
  input  [(C_CPM_PCIE0_AXISTEN_IF_WIDTH/32)-1:0]  pcie0_s_axis_cc_tkeep,

  // PCIe Controller 1 flow control interface
  output [11:0] pcie1_cfg_fc_pd,
  output [7:0]  pcie1_cfg_fc_ph,
  input  [2:0]  pcie1_cfg_fc_sel,
  output [11:0] pcie1_cfg_fc_npd,
  output [7:0]  pcie1_cfg_fc_nph,
  input         pcie1_cfg_fc_vc_sel,
  output [1:0]  pcie1_cfg_fc_pd_scale,
  output [1:0]  pcie1_cfg_fc_ph_scale,
  output [1:0]  pcie1_cfg_fc_npd_scale,
  output [1:0]  pcie1_cfg_fc_nph_scale,

  // PCIe Controller 1 config message rx/tx interface
  input         pcie1_cfg_msg_transmit,
  input  [31:0] pcie1_cfg_msg_transmit_data,
  output        pcie1_cfg_msg_transmit_done,
  input  [2:0]  pcie1_cfg_msg_transmit_type,

  // PCIe Controller 1 Configuration Control/Status interface
  output [3:0]  pcie1_cfg_10b_tag_requester_enable,
  input  [3:0]  pcie1_cfg_flr_done,
  output [1:0]  pcie1_cfg_current_speed,
  output        pcie1_cfg_ext_tag_enable,
  output [3:0]  pcie1_cfg_flr_in_process,
  output [3:0]  pcie1_cfg_ats_control_enable,
  output [3:0]  pcie1_cfg_rcb_status,
  output [5:0]  pcie1_cfg_ltssm_state,
  output [1:0]  pcie1_cfg_max_payload,
  output [7:0]  pcie1_cfg_pri_control,
  output [1:0]  pcie1_cfg_rx_pm_state,
  output [11:0] pcie1_cfg_tph_st_mode,
  output [1:0]  pcie1_cfg_tx_pm_state,
  output [2:0]  pcie1_cfg_max_read_req,
  input         pcie1_cfg_hot_reset_in,
  output        pcie1_cfg_hot_reset_out,
  output        pcie1_cfg_phy_link_down,
  output [1:0]  pcie1_cfg_phy_link_status,
  output [15:0] pcie1_cfg_function_status,
  output [1:0]  pcie1_cfg_link_power_state,
  output [2:0]  pcie1_cfg_negotiated_width,
  output        pcie1_cfg_pl_status_change,
  output [3:0]  pcie1_cfg_tph_requester_enable,
  input         pcie1_cfg_power_state_change_ack,
  output        pcie1_cfg_power_state_change_interrupt,

  // PCIe Controller 1 SRIOV Configuration status interface
  output [2*252-1:0]  pcie1_cfg_vf_status,
  input               pcie1_cfg_vf_flr_done,
  output [3*252-1:0]  pcie1_cfg_vf_power_state,
  output [3*252-1:0]  pcie1_cfg_vf_tph_st_mode,
  input  [7:0]        pcie1_cfg_vf_flr_func_num,
  output [251:0]      pcie1_cfg_vf_flr_in_process,
  output [251:0]      pcie1_cfg_vf_ats_control_enable,
  output [251:0]      pcie1_cfg_vf_tph_requester_enable,

  // PCIe Controller 1 MSIX interface
  input  [2:0]    pcie1_cfg_msix_attr,
  input  [31:0]   pcie1_cfg_msix_data,
  output [3:0]    pcie1_cfg_msix_mask,
  output [3:0]    pcie1_cfg_msix_enable,
  input  [63:0]   pcie1_cfg_msix_address,
  input  [1:0]    pcie1_cfg_msix_tph_type,
  input  [7:0]    pcie1_cfg_msix_tph_st_tag,
  input           pcie1_cfg_msix_int_vector,
  input  [31:0]   pcie1_cfg_msix_mint_vector,
  input           pcie1_cfg_msix_tph_present,
  input  [1:0]    pcie1_cfg_msix_vec_pending,
  input  [7:0]    pcie1_cfg_msix_function_number,
  output [251:0]  pcie1_cfg_msix_vf_mask,
  output [251:0]  pcie1_cfg_msix_vf_enable,

  // PCIe0 MSI interface
  input  [2:0]  pcie1_cfg_msi_attr,
  output [31:0] pcie1_cfg_msi_data,
  output [3:0]  pcie1_cfg_msi_enable,
  input  [1:0]  pcie1_cfg_msi_select,
  output [11:0] pcie1_cfg_msi_mmenable,
  input  [1:0]  pcie1_cfg_msi_tph_type,
  input  [31:0] pcie1_cfg_msi_int_vector,
  input  [7:0]  pcie1_cfg_msi_tph_st_tag,
  input         pcie1_cfg_msi_tph_present,
  input  [31:0] pcie1_cfg_msi_pending_status,
  input  [7:0]  pcie1_cfg_msi_function_number,
  input         pcie1_cfg_msi_pending_status_data_enable,
  input  [1:0]  pcie1_cfg_msi_pending_status_function_number,

  // PCIe Controller 1 CQ AXI-Streaming interface
  output pcie1_m_axis_cq_tlast,
  output pcie1_m_axis_cq_tvalid,
  input  pcie1_m_axis_cq_tready,
  output [C_CPM_PCIE1_AXIS_CQ_TUSER_WIDTH-1:0] pcie1_m_axis_cq_tuser,
  output [C_CPM_PCIE1_AXISTEN_IF_WIDTH-1:0] pcie1_m_axis_cq_tdata,
  output [(C_CPM_PCIE1_AXISTEN_IF_WIDTH/32)-1:0]  pcie1_m_axis_cq_tkeep,

  // PCIe Controller 1 RC AXI-Streaming interface
  output pcie1_m_axis_rc_tlast,
  output pcie1_m_axis_rc_tvalid,
  input  pcie1_m_axis_rc_tready,
  output [C_CPM_PCIE1_AXIS_RC_TUSER_WIDTH-1:0] pcie1_m_axis_rc_tuser,
  output [C_CPM_PCIE1_AXISTEN_IF_WIDTH-1:0] pcie1_m_axis_rc_tdata,
  output [(C_CPM_PCIE1_AXISTEN_IF_WIDTH/32)-1:0]  pcie1_m_axis_rc_tkeep,

  // PCIe Controller 1 RQ AXI-Streaming interface
  input  pcie1_s_axis_rq_tlast,
  input  pcie1_s_axis_rq_tvalid,
  output pcie1_s_axis_rq_tready,
  input  [C_CPM_PCIE1_AXIS_RQ_TUSER_WIDTH-1:0] pcie1_s_axis_rq_tuser,
  input  [C_CPM_PCIE1_AXISTEN_IF_WIDTH-1:0] pcie1_s_axis_rq_tdata,
  input  [(C_CPM_PCIE1_AXISTEN_IF_WIDTH/32)-1:0]  pcie1_s_axis_rq_tkeep,

  // PCIe Controller 1 CC AXI-Streaming interface
  input  pcie1_s_axis_cc_tlast,
  input  pcie1_s_axis_cc_tvalid,
  output pcie1_s_axis_cc_tready,
  input  [C_CPM_PCIE1_AXIS_CC_TUSER_WIDTH-1:0] pcie1_s_axis_cc_tuser,
  input  [C_CPM_PCIE1_AXISTEN_IF_WIDTH-1:0] pcie1_s_axis_cc_tdata,
  input  [(C_CPM_PCIE1_AXISTEN_IF_WIDTH/32)-1:0]  pcie1_s_axis_cc_tkeep,

  // XDMA C2H streaming interface channel 0
  input  dma0_s_axis_c2h_0_tlast,
  input  dma0_s_axis_c2h_0_tvalid,
  output dma0_s_axis_c2h_0_tready,
  input  [(C_CPM_PCIE0_AXISTEN_IF_WIDTH/8)-1:0] dma0_s_axis_c2h_0_tkeep,
  input  [(C_CPM_PCIE0_AXISTEN_IF_WIDTH/8)-1:0] dma0_s_axis_c2h_0_tuser,
  input  [C_CPM_PCIE0_AXISTEN_IF_WIDTH-1:0] dma0_s_axis_c2h_0_tdata,

  // XDMA C2H streaming interface channel 1
  input  dma0_s_axis_c2h_1_tlast,
  input  dma0_s_axis_c2h_1_tvalid,
  output dma0_s_axis_c2h_1_tready,
  input  [(C_CPM_PCIE0_AXISTEN_IF_WIDTH/8)-1:0] dma0_s_axis_c2h_1_tkeep,
  input  [(C_CPM_PCIE0_AXISTEN_IF_WIDTH/8)-1:0] dma0_s_axis_c2h_1_tuser,
  input  [C_CPM_PCIE0_AXISTEN_IF_WIDTH-1:0] dma0_s_axis_c2h_1_tdata,

  // XDMA C2H streaming interface channel 2
  input  dma0_s_axis_c2h_2_tlast,
  input  dma0_s_axis_c2h_2_tvalid,
  output dma0_s_axis_c2h_2_tready,
  input  [(C_CPM_PCIE0_AXISTEN_IF_WIDTH/8)-1:0] dma0_s_axis_c2h_2_tkeep,
  input  [(C_CPM_PCIE0_AXISTEN_IF_WIDTH/8)-1:0] dma0_s_axis_c2h_2_tuser,
  input  [C_CPM_PCIE0_AXISTEN_IF_WIDTH-1:0] dma0_s_axis_c2h_2_tdata,

  // XDMA C2H streaming interface channel 3
  input  dma0_s_axis_c2h_3_tlast,
  input  dma0_s_axis_c2h_3_tvalid,
  output dma0_s_axis_c2h_3_tready,
  input  [(C_CPM_PCIE0_AXISTEN_IF_WIDTH/8)-1:0] dma0_s_axis_c2h_3_tkeep,
  input  [(C_CPM_PCIE0_AXISTEN_IF_WIDTH/8)-1:0] dma0_s_axis_c2h_3_tuser,
  input  [C_CPM_PCIE0_AXISTEN_IF_WIDTH-1:0] dma0_s_axis_c2h_3_tdata,

  // XDMA H2C streaming interface channel 0
  output dma0_m_axis_h2c_0_tlast,
  output dma0_m_axis_h2c_0_tvalid,
  input  dma0_m_axis_h2c_0_tready,
  output [(C_CPM_PCIE0_AXISTEN_IF_WIDTH/8)-1:0] dma0_m_axis_h2c_0_tkeep,
  output [(C_CPM_PCIE0_AXISTEN_IF_WIDTH/8)-1:0] dma0_m_axis_h2c_0_tuser,
  output [C_CPM_PCIE0_AXISTEN_IF_WIDTH-1:0] dma0_m_axis_h2c_0_tdata,

  // XDMA H2C streaming interface channel 1
  output dma0_m_axis_h2c_1_tlast,
  output dma0_m_axis_h2c_1_tvalid,
  input  dma0_m_axis_h2c_1_tready,
  output [(C_CPM_PCIE0_AXISTEN_IF_WIDTH/8)-1:0] dma0_m_axis_h2c_1_tkeep,
  output [(C_CPM_PCIE0_AXISTEN_IF_WIDTH/8)-1:0] dma0_m_axis_h2c_1_tuser,
  output [C_CPM_PCIE0_AXISTEN_IF_WIDTH-1:0] dma0_m_axis_h2c_1_tdata,

  // XDMA H2C streaming interface channel 2
  output dma0_m_axis_h2c_2_tlast,
  output dma0_m_axis_h2c_2_tvalid,
  input  dma0_m_axis_h2c_2_tready,
  output [(C_CPM_PCIE0_AXISTEN_IF_WIDTH/8)-1:0] dma0_m_axis_h2c_2_tkeep,
  output [(C_CPM_PCIE0_AXISTEN_IF_WIDTH/8)-1:0] dma0_m_axis_h2c_2_tuser,
  output [C_CPM_PCIE0_AXISTEN_IF_WIDTH-1:0] dma0_m_axis_h2c_2_tdata,

  // XDMA H2C streaming interface channel 3
  output dma0_m_axis_h2c_3_tlast,
  output dma0_m_axis_h2c_3_tvalid,
  input  dma0_m_axis_h2c_3_tready,
  output [(C_CPM_PCIE0_AXISTEN_IF_WIDTH/8)-1:0] dma0_m_axis_h2c_3_tkeep,
  output [(C_CPM_PCIE0_AXISTEN_IF_WIDTH/8)-1:0] dma0_m_axis_h2c_3_tuser,
  output [C_CPM_PCIE0_AXISTEN_IF_WIDTH-1:0] dma0_m_axis_h2c_3_tdata,

  input  [C_CPM_COMM_SIGS_WIDTH-1:0]  pcie0_pipe_commands_in,
  output [C_CPM_COMM_SIGS_WIDTH-1:0]  pcie0_pipe_commands_out,
  input  [C_CPM_COMM_SIGS_WIDTH-1:0]  pcie1_pipe_commands_in,
  output [C_CPM_COMM_SIGS_WIDTH-1:0]  pcie1_pipe_commands_out, 
  input  [C_CPM_PIPE_SIGS_WIDTH-1:0]  pcie0_pipe_rx_0,
  output [C_CPM_PIPE_SIGS_WIDTH-1:0]  pcie0_pipe_tx_0,
  input  [C_CPM_PIPE_SIGS_WIDTH-1:0]  pcie0_pipe_rx_1,
  output [C_CPM_PIPE_SIGS_WIDTH-1:0]  pcie0_pipe_tx_1,
  input  [C_CPM_PIPE_SIGS_WIDTH-1:0]  pcie0_pipe_rx_2,
  output [C_CPM_PIPE_SIGS_WIDTH-1:0]  pcie0_pipe_tx_2,
  input  [C_CPM_PIPE_SIGS_WIDTH-1:0]  pcie0_pipe_rx_3,
  output [C_CPM_PIPE_SIGS_WIDTH-1:0]  pcie0_pipe_tx_3,
  input  [C_CPM_PIPE_SIGS_WIDTH-1:0]  pcie0_pipe_rx_4,
  output [C_CPM_PIPE_SIGS_WIDTH-1:0]  pcie0_pipe_tx_4,
  input  [C_CPM_PIPE_SIGS_WIDTH-1:0]  pcie0_pipe_rx_5,
  output [C_CPM_PIPE_SIGS_WIDTH-1:0]  pcie0_pipe_tx_5,
  input  [C_CPM_PIPE_SIGS_WIDTH-1:0]  pcie0_pipe_rx_6,
  output [C_CPM_PIPE_SIGS_WIDTH-1:0]  pcie0_pipe_tx_6,
  input  [C_CPM_PIPE_SIGS_WIDTH-1:0]  pcie0_pipe_rx_7,
  output [C_CPM_PIPE_SIGS_WIDTH-1:0]  pcie0_pipe_tx_7,
  input  [C_CPM_PIPE_SIGS_WIDTH-1:0]  pcie0_pipe_rx_8,
  output [C_CPM_PIPE_SIGS_WIDTH-1:0]  pcie0_pipe_tx_8,
  input  [C_CPM_PIPE_SIGS_WIDTH-1:0]  pcie0_pipe_rx_9,
  output [C_CPM_PIPE_SIGS_WIDTH-1:0]  pcie0_pipe_tx_9,
  input  [C_CPM_PIPE_SIGS_WIDTH-1:0]  pcie0_pipe_rx_10,
  output [C_CPM_PIPE_SIGS_WIDTH-1:0]  pcie0_pipe_tx_10,
  input  [C_CPM_PIPE_SIGS_WIDTH-1:0]  pcie0_pipe_rx_11,
  output [C_CPM_PIPE_SIGS_WIDTH-1:0]  pcie0_pipe_tx_11,
  input  [C_CPM_PIPE_SIGS_WIDTH-1:0]  pcie0_pipe_rx_12,
  output [C_CPM_PIPE_SIGS_WIDTH-1:0]  pcie0_pipe_tx_12,
  input  [C_CPM_PIPE_SIGS_WIDTH-1:0]  pcie0_pipe_rx_13,
  output [C_CPM_PIPE_SIGS_WIDTH-1:0]  pcie0_pipe_tx_13,
  input  [C_CPM_PIPE_SIGS_WIDTH-1:0]  pcie0_pipe_rx_14,
  output [C_CPM_PIPE_SIGS_WIDTH-1:0]  pcie0_pipe_tx_14,
  input  [C_CPM_PIPE_SIGS_WIDTH-1:0]  pcie0_pipe_rx_15,
  output [C_CPM_PIPE_SIGS_WIDTH-1:0]  pcie0_pipe_tx_15,

  input  [C_CPM_PIPE_SIGS_WIDTH-1:0]  pcie1_pipe_rx_0,
  output [C_CPM_PIPE_SIGS_WIDTH-1:0]  pcie1_pipe_tx_0,
  input  [C_CPM_PIPE_SIGS_WIDTH-1:0]  pcie1_pipe_rx_1,
  output [C_CPM_PIPE_SIGS_WIDTH-1:0]  pcie1_pipe_tx_1,
  input  [C_CPM_PIPE_SIGS_WIDTH-1:0]  pcie1_pipe_rx_2,
  output [C_CPM_PIPE_SIGS_WIDTH-1:0]  pcie1_pipe_tx_2,
  input  [C_CPM_PIPE_SIGS_WIDTH-1:0]  pcie1_pipe_rx_3,
  output [C_CPM_PIPE_SIGS_WIDTH-1:0]  pcie1_pipe_tx_3,
  input  [C_CPM_PIPE_SIGS_WIDTH-1:0]  pcie1_pipe_rx_4,
  output [C_CPM_PIPE_SIGS_WIDTH-1:0]  pcie1_pipe_tx_4,
  input  [C_CPM_PIPE_SIGS_WIDTH-1:0]  pcie1_pipe_rx_5,
  output [C_CPM_PIPE_SIGS_WIDTH-1:0]  pcie1_pipe_tx_5,
  input  [C_CPM_PIPE_SIGS_WIDTH-1:0]  pcie1_pipe_rx_6,
  output [C_CPM_PIPE_SIGS_WIDTH-1:0]  pcie1_pipe_tx_6,
  input  [C_CPM_PIPE_SIGS_WIDTH-1:0]  pcie1_pipe_rx_7,
  output [C_CPM_PIPE_SIGS_WIDTH-1:0]  pcie1_pipe_tx_7,
  input  [C_CPM_PIPE_SIGS_WIDTH-1:0]  pcie1_pipe_rx_8,
  output [C_CPM_PIPE_SIGS_WIDTH-1:0]  pcie1_pipe_tx_8,
  input  [C_CPM_PIPE_SIGS_WIDTH-1:0]  pcie1_pipe_rx_9,
  output [C_CPM_PIPE_SIGS_WIDTH-1:0]  pcie1_pipe_tx_9,
  input  [C_CPM_PIPE_SIGS_WIDTH-1:0]  pcie1_pipe_rx_10,
  output [C_CPM_PIPE_SIGS_WIDTH-1:0]  pcie1_pipe_tx_10,
  input  [C_CPM_PIPE_SIGS_WIDTH-1:0]  pcie1_pipe_rx_11,
  output [C_CPM_PIPE_SIGS_WIDTH-1:0]  pcie1_pipe_tx_11,
  input  [C_CPM_PIPE_SIGS_WIDTH-1:0]  pcie1_pipe_rx_12,
  output [C_CPM_PIPE_SIGS_WIDTH-1:0]  pcie1_pipe_tx_12,
  input  [C_CPM_PIPE_SIGS_WIDTH-1:0]  pcie1_pipe_rx_13,
  output [C_CPM_PIPE_SIGS_WIDTH-1:0]  pcie1_pipe_tx_13,
  input  [C_CPM_PIPE_SIGS_WIDTH-1:0]  pcie1_pipe_rx_14,
  output [C_CPM_PIPE_SIGS_WIDTH-1:0]  pcie1_pipe_tx_14,
  input  [C_CPM_PIPE_SIGS_WIDTH-1:0]  pcie1_pipe_rx_15,
  output [C_CPM_PIPE_SIGS_WIDTH-1:0]  pcie1_pipe_tx_15,


  // PCIe 0 Link debug ports
  input pcie0_dbg_aclk,
  input pcie0_dbg_aresetn,

  output pcie0_m_axis_dbg_tlast,
  input  pcie0_m_axis_dbg_tready,
  output pcie0_m_axis_dbg_tvalid,
  input  pcie0_s_axis_dbg_tlast,
  output pcie0_s_axis_dbg_tready,
  input  pcie0_s_axis_dbg_tvalid,
  output [31:0] pcie0_m_axis_dbg_tdata,
  input  [31:0] pcie0_s_axis_dbg_tdata,

  // PCIe 1 Link debug ports
  input pcie1_dbg_aclk,
  input pcie1_dbg_aresetn,

  output pcie1_m_axis_dbg_tlast,
  input  pcie1_m_axis_dbg_tready,
  output pcie1_m_axis_dbg_tvalid,
  input  pcie1_s_axis_dbg_tlast,
  output pcie1_s_axis_dbg_tready,
  input  pcie1_s_axis_dbg_tvalid,
  output [31:0] pcie1_m_axis_dbg_tdata,
  input  [31:0] pcie1_s_axis_dbg_tdata,


  input pl_ref_clk,
  
  // CHI 0 clock
  input chi0_clk,
  // CHI 0 interface
  input  chi0_msactive,
  input  chi0_reqflitv,
  input  chi0_snplcrdv,
  input  chi0_syscoreq,
  output chi0_reqlcrdv,
  output chi0_snpflitv,
  output chi0_ssactive,
  output chi0_syscoack,
  input  chi0_crsplcrdv,
  input  chi0_rdatlcrdv,
  input  chi0_srspflitv,
  input  chi0_wdatflitv,
  output chi0_crspflitv,
  output chi0_rdatflitv,
  output chi0_srsplcrdv,
  output chi0_wdatlcrdv,
  input  chi0_reqflitpend,
  output chi0_snpflitpend,
  input  chi0_srspflitpend,
  input  chi0_wdatflitpend,
  output chi0_crspflitpend,
  output chi0_rdatflitpend,
  input  chi0_mlinkactivereq,
  input  chi0_slinkactiveack,
  output chi0_mlinkactiveack,
  output chi0_slinkactivereq,
  output [87:0] chi0_snpflit,
  input [120:0] chi0_reqflit,
  output [50:0] chi0_crspflit,
  input  [50:0] chi0_srspflit,
  output[704:0] chi0_rdatflit,
  input [704:0] chi0_wdatflit,

  // CHI 1 clock
  input chi1_clk,
  // CHI 1 interface
  input  chi1_msactive,
  input  chi1_reqflitv,
  input  chi1_snplcrdv,
  input  chi1_syscoreq,
  output chi1_reqlcrdv,
  output chi1_snpflitv,
  output chi1_ssactive,
  output chi1_syscoack,
  input  chi1_crsplcrdv,
  input  chi1_rdatlcrdv,
  input  chi1_srspflitv,
  input  chi1_wdatflitv,
  output chi1_crspflitv,
  output chi1_rdatflitv,
  output chi1_srsplcrdv,
  output chi1_wdatlcrdv,
  input  chi1_reqflitpend,
  output chi1_snpflitpend,
  input  chi1_srspflitpend,
  input  chi1_wdatflitpend,
  output chi1_crspflitpend,
  output chi1_rdatflitpend,
  input  chi1_mlinkactivereq,
  input  chi1_slinkactiveack,
  output chi1_mlinkactiveack,
  output chi1_slinkactivereq,
  output [87:0] chi1_snpflit,
  input [120:0] chi1_reqflit,
  output [50:0] chi1_crspflit,
  input  [50:0] chi1_srspflit,
  output[704:0] chi1_rdatflit,
  input [704:0] chi1_wdatflit,



  // DMA Management interface
  input  dma0_mgmt_cpl_rdy,
  output dma0_mgmt_cpl_vld,
  output dma0_mgmt_req_rdy,
  input  dma0_mgmt_req_vld,
  output [1:0] dma0_mgmt_cpl_sts,
  input  [1:0] dma0_mgmt_req_cmd,
  output[31:0] dma0_mgmt_cpl_dat,
  input [31:0] dma0_mgmt_req_adr,
  input [31:0] dma0_mgmt_req_dat,
  input  [5:0] dma0_mgmt_req_msc,
  input  [7:0] dma0_mgmt_req_fnc,

  input  [7:0] xdma0_usr_irq_fnc,
  input  [C_CPM_PCIE0_NUM_USR_IRQ-1:0] xdma0_usr_irq_in,
  input  [C_CPM_PCIE0_NUM_USR_IRQ-1:0] bridge0_usr_irq_in,
  input  [C_CPM_PCIE0_NUM_USR_IRQ-1:0] xdma0_usr_irq_req,
  input  [C_CPM_PCIE0_NUM_USR_IRQ-1:0] bridge0_usr_irq_req,

  output [C_CPM_PCIE0_NUM_USR_IRQ-1:0] xdma0_usr_irq_ack,  
  output [C_CPM_PCIE0_NUM_USR_IRQ-1:0] bridge0_usr_irq_ack, 

  // XDMA C2H descriptor bypass interface channel 0
  input  dma0_c2h_dsc_byp_0_load,
  output dma0_c2h_dsc_byp_0_ready,
  input  [27:0] dma0_c2h_dsc_byp_0_len,
  input  [15:0] dma0_c2h_dsc_byp_0_ctl,
  input  [63:0] dma0_c2h_dsc_byp_0_src_addr,
  input  [63:0] dma0_c2h_dsc_byp_0_dst_addr,

  // XDMA H2C descriptor bypass interface channel 0
  input  dma0_h2c_dsc_byp_0_load,
  output dma0_h2c_dsc_byp_0_ready,
  input  [27:0] dma0_h2c_dsc_byp_0_len,
  input  [15:0] dma0_h2c_dsc_byp_0_ctl,
  input  [63:0] dma0_h2c_dsc_byp_0_src_addr,
  input  [63:0] dma0_h2c_dsc_byp_0_dst_addr,

  // XDMA C2H descriptor bypass interface channel 1
  input  dma0_c2h_dsc_byp_1_load,
  output dma0_c2h_dsc_byp_1_ready,
  input  [27:0] dma0_c2h_dsc_byp_1_len,
  input  [15:0] dma0_c2h_dsc_byp_1_ctl,
  input  [63:0] dma0_c2h_dsc_byp_1_src_addr,
  input  [63:0] dma0_c2h_dsc_byp_1_dst_addr,

  // XDMA H2C descriptor bypass interface channel 1
  input  dma0_h2c_dsc_byp_1_load,
  output dma0_h2c_dsc_byp_1_ready,
  input  [27:0] dma0_h2c_dsc_byp_1_len,
  input  [15:0] dma0_h2c_dsc_byp_1_ctl,
  input  [63:0] dma0_h2c_dsc_byp_1_src_addr,
  input  [63:0] dma0_h2c_dsc_byp_1_dst_addr,

  // XDMA C2H descriptor bypass interface channel 2
  input  dma0_c2h_dsc_byp_2_load,
  output dma0_c2h_dsc_byp_2_ready,
  input  [27:0] dma0_c2h_dsc_byp_2_len,
  input  [15:0] dma0_c2h_dsc_byp_2_ctl,
  input  [63:0] dma0_c2h_dsc_byp_2_src_addr,
  input  [63:0] dma0_c2h_dsc_byp_2_dst_addr,

  // XDMA H2C descriptor bypass interface channel 2
  input  dma0_h2c_dsc_byp_2_load,
  output dma0_h2c_dsc_byp_2_ready,
  input  [27:0] dma0_h2c_dsc_byp_2_len,
  input  [15:0] dma0_h2c_dsc_byp_2_ctl,
  input  [63:0] dma0_h2c_dsc_byp_2_src_addr,
  input  [63:0] dma0_h2c_dsc_byp_2_dst_addr,

  // XDMA C2H descriptor bypass interface channel 3
  input  dma0_c2h_dsc_byp_3_load,
  output dma0_c2h_dsc_byp_3_ready,
  input  [27:0] dma0_c2h_dsc_byp_3_len,
  input  [15:0] dma0_c2h_dsc_byp_3_ctl,
  input  [63:0] dma0_c2h_dsc_byp_3_src_addr,
  input  [63:0] dma0_c2h_dsc_byp_3_dst_addr,

  // XDMA H2C descriptor bypass interface channel 3
  input  dma0_h2c_dsc_byp_3_load,
  output dma0_h2c_dsc_byp_3_ready,
  input  [27:0] dma0_h2c_dsc_byp_3_len,
  input  [15:0] dma0_h2c_dsc_byp_3_ctl,
  input  [63:0] dma0_h2c_dsc_byp_3_src_addr,
  input  [63:0] dma0_h2c_dsc_byp_3_dst_addr,



  // XDMA C2H/H2C Status
  output [7:0] dma0_c2h_sts_0,
  output [7:0] dma0_h2c_sts_0,
  output [7:0] dma0_c2h_sts_1,
  output [7:0] dma0_h2c_sts_1,
  output [7:0] dma0_c2h_sts_2,
  output [7:0] dma0_h2c_sts_2,
  output [7:0] dma0_c2h_sts_3,
  output [7:0] dma0_h2c_sts_3,


  // QDMA User function level reset
  output dma0_usr_flr_set,
  output dma0_usr_flr_clr,
  input  dma0_usr_flr_done_vld,
  output [7:0] dma0_usr_flr_fnc,
  input  [7:0] dma0_usr_flr_done_fnc,

  // ------------- QDMA ports ----------
  input  dma0_st_rx_msg_rdy,
  output dma0_st_rx_msg_last,
  output dma0_st_rx_msg_valid,
  output [31:0] dma0_st_rx_msg_data,

  // QDMA C2H Streaming
  input  dma0_s_axis_c2h_tlast,
  output dma0_s_axis_c2h_tready,
  input  dma0_s_axis_c2h_tvalid,
  input  dma0_s_axis_c2h_ctrl_marker,
  input  dma0_s_axis_c2h_ctrl_imm_data,
  input  dma0_s_axis_c2h_ctrl_dis_cmpt,
  input  dma0_s_axis_c2h_ctrl_user_trig,
  
  input  [5:0] dma0_s_axis_c2h_mty,
  input [10:0] dma0_s_axis_c2h_ctrl_qid,
  input [15:0] dma0_s_axis_c2h_ctrl_len,
  input  [2:0] dma0_s_axis_c2h_ctrl_port_id,
  input  [C_CPM_PCIE0_AXISTEN_IF_WIDTH-1:0] dma0_s_axis_c2h_tdata,
  input  [(C_CPM_PCIE0_AXISTEN_IF_WIDTH/8)-1:0] dma0_s_axis_c2h_dpar,

  // QDMA C2H Completion streaming interface
  input  dma0_s_axis_c2h_cmpt_tlast,
  input  dma0_s_axis_c2h_cmpt_tvalid,
  output dma0_s_axis_c2h_cmpt_tready,
  input  [1:0] dma0_s_axis_c2h_cmpt_size,
  input  [3:0] dma0_s_axis_c2h_cmpt_dpar,
  input[127:0] dma0_s_axis_c2h_cmpt_tdata,

  // QDMA H2C Streaming interface
  output dma0_m_axis_h2c_tlast,
  output dma0_m_axis_h2c_tvalid,
  input  dma0_m_axis_h2c_tready,
  output dma0_m_axis_h2c_tuser_err,
  output dma0_m_axis_h2c_tuser_zero_byte,
  output[10:0] dma0_m_axis_h2c_tuser_qid,
  output [5:0] dma0_m_axis_h2c_tuser_mty,
  output[31:0] dma0_m_axis_h2c_tuser_mdata,
  output [2:0] dma0_m_axis_h2c_tuser_port_id,  
  output [C_CPM_PCIE0_AXISTEN_IF_WIDTH-1:0] dma0_m_axis_h2c_tdata,
  output [(C_CPM_PCIE0_AXISTEN_IF_WIDTH/8)-1:0] dma0_m_axis_h2c_dpar,

  // QDMA H2C Descriptor Bypass Out Interface
  input  dma0_h2c_byp_out_rdy,
  output dma0_h2c_byp_out_vld,
  output dma0_h2c_byp_out_error,
  output dma0_h2c_byp_out_st_mm,
  output dma0_h2c_byp_out_mrkr_rsp,
  output [10:0] dma0_h2c_byp_out_qid,
  output[255:0] dma0_h2c_byp_out_dsc,
  output [15:0] dma0_h2c_byp_out_cidx,
  output [7:0]  dma0_h2c_byp_out_func,
  output [1:0]  dma0_h2c_byp_out_dsc_sz,
  output [2:0]  dma0_h2c_byp_out_port_id,

  // QDMA C2H Descriptor Bypass Out Interface
  input  dma0_c2h_byp_out_rdy,
  output dma0_c2h_byp_out_vld,
  output dma0_c2h_byp_out_error,
  output dma0_c2h_byp_out_st_mm,
  output dma0_c2h_byp_out_mrkr_rsp,
  output[255:0] dma0_c2h_byp_out_dsc,
  output [10:0] dma0_c2h_byp_out_qid,
  output [15:0] dma0_c2h_byp_out_cidx,
  output [7:0]  dma0_c2h_byp_out_func,
  output [1:0]  dma0_c2h_byp_out_dsc_sz,
  output [2:0]  dma0_c2h_byp_out_port_id,

  // QDMA H2C Desciptor Bypass Input Memory Mapped Interface
  output dma0_h2c_byp_in_mm_rdy,
  input  dma0_h2c_byp_in_mm_sdi,
  input  dma0_h2c_byp_in_mm_vld,
  input  dma0_h2c_byp_in_mm_error,
  input  dma0_h2c_byp_in_mm_mrkr_req,
  input [10:0] dma0_h2c_byp_in_mm_qid,
  input [27:0] dma0_h2c_byp_in_mm_len,
  input  [7:0] dma0_h2c_byp_in_mm_func,
  input [15:0] dma0_h2c_byp_in_mm_cidx,
  input [63:0] dma0_h2c_byp_in_mm_radr,
  input [63:0] dma0_h2c_byp_in_mm_wadr,
  input  [2:0] dma0_h2c_byp_in_mm_port_id,

  // QDMA H2C Desciptor Bypass Input Streaming Interface
  input  dma0_h2c_byp_in_st_eop,
  input  dma0_h2c_byp_in_st_sop,
  input  dma0_h2c_byp_in_st_sdi,
  input  dma0_h2c_byp_in_st_vld,
  output dma0_h2c_byp_in_st_rdy,
  input  dma0_h2c_byp_in_st_error,
  input  dma0_h2c_byp_in_st_no_dma,
  input  dma0_h2c_byp_in_st_mrkr_req,
  input [15:0] dma0_h2c_byp_in_st_len,
  input [10:0] dma0_h2c_byp_in_st_qid,
  input [63:0] dma0_h2c_byp_in_st_addr,
  input  [7:0] dma0_h2c_byp_in_st_func,
  input [15:0] dma0_h2c_byp_in_st_cidx,
  input  [2:0] dma0_h2c_byp_in_st_port_id,

  // QDMA C2H Desciptor Bypass Input MM Interface
  output dma0_c2h_byp_in_mm_rdy,
  input  dma0_c2h_byp_in_mm_sdi,
  input  dma0_c2h_byp_in_mm_vld,
  input  dma0_c2h_byp_in_mm_error,
  input  dma0_c2h_byp_in_mm_mrkr_req,
  input [10:0] dma0_c2h_byp_in_mm_qid,
  input [15:0] dma0_c2h_byp_in_mm_cidx,
  input [27:0] dma0_c2h_byp_in_mm_len,
  input [63:0] dma0_c2h_byp_in_mm_radr,
  input [63:0] dma0_c2h_byp_in_mm_wadr,
  input  [7:0] dma0_c2h_byp_in_mm_func,
  input  [2:0] dma0_c2h_byp_in_mm_port_id,

  // QDMA C2H Desciptor Bypass Input Memory Mapped Interface
  output dma0_c2h_byp_in_st_csh_rdy,
  input  dma0_c2h_byp_in_st_csh_vld,
  input  dma0_c2h_byp_in_st_csh_error,
  input [10:0] dma0_c2h_byp_in_st_csh_qid,
  input [63:0] dma0_c2h_byp_in_st_csh_addr,
  input  [7:0] dma0_c2h_byp_in_st_csh_func,
  input  [2:0] dma0_c2h_byp_in_st_csh_port_id,

  //QDMA C2H Desciptor Bypass Input Simple Streaming Interface
  output dma0_c2h_byp_in_st_sim_rdy,
  input  dma0_c2h_byp_in_st_sim_vld,
  input  dma0_c2h_byp_in_st_sim_error,
  input [10:0] dma0_c2h_byp_in_st_sim_qid,
  input [63:0] dma0_c2h_byp_in_st_sim_addr,
  input  [7:0] dma0_c2h_byp_in_st_sim_func,
  input  [2:0] dma0_c2h_byp_in_st_sim_port_id,

  // Descriptor Fetch Engine Out
  output dma0_tm_dsc_sts_mm,
  input  dma0_tm_dsc_sts_rdy,
  output dma0_tm_dsc_sts_byp,
  output dma0_tm_dsc_sts_dir,
  output dma0_tm_dsc_sts_err,
  output dma0_tm_dsc_sts_qen,
  output dma0_tm_dsc_sts_vld,
  output dma0_tm_dsc_sts_qinv,
  output dma0_tm_dsc_sts_irq_arm,
  output[11:0] dma0_tm_dsc_sts_qid,
  output[15:0] dma0_tm_dsc_sts_avl,
  output [2:0] dma0_tm_dsc_sts_port_id,

  // Descriptor credit In
  input  dma0_dsc_crdt_in_vld,
  output dma0_dsc_crdt_in_rdy,
  input  dma0_dsc_crdt_in_sel,
  input [10:0] dma0_dsc_crdt_in_qid,
  input [15:0] dma0_dsc_crdt_in_crdt,

  // User interrupt
  input  dma0_usr_irq_vld,
  output dma0_usr_irq_ack,
  output dma0_usr_irq_fail,
  input [4:0] dma0_usr_irq_vec,
  input [7:0] dma0_usr_irq_fnc,

  output dma0_axis_c2h_status_drop,
  output dma0_axis_c2h_status_valid,
  output [10:0] dma0_axis_c2h_status_qid,

  // PCIE0 GT Ports
  input  [C_CPM_PCIE0_PL_LINK_CAP_MAX_LINK_WIDTH-1:0]  pcie0_gt_rxn,
  output [C_CPM_PCIE0_PL_LINK_CAP_MAX_LINK_WIDTH-1:0]  pcie0_gt_txn,
  input  [C_CPM_PCIE0_PL_LINK_CAP_MAX_LINK_WIDTH-1:0]  pcie0_gt_rxp,
  output [C_CPM_PCIE0_PL_LINK_CAP_MAX_LINK_WIDTH-1:0]  pcie0_gt_txp,


  // HSDP0 GT Ports
  input  hsdp0_gt_rxn,
  output hsdp0_gt_txn,
  input  hsdp0_gt_rxp,
  output hsdp0_gt_txp,

  // PCIE1 GT Ports
  input  [C_CPM_PCIE1_PL_LINK_CAP_MAX_LINK_WIDTH-1:0]  pcie1_gt_rxn,
  output [C_CPM_PCIE1_PL_LINK_CAP_MAX_LINK_WIDTH-1:0]  pcie1_gt_txn,
  input  [C_CPM_PCIE1_PL_LINK_CAP_MAX_LINK_WIDTH-1:0]  pcie1_gt_rxp,
  output [C_CPM_PCIE1_PL_LINK_CAP_MAX_LINK_WIDTH-1:0]  pcie1_gt_txp,


  // HSDP1 GT Ports
  input  hsdp1_gt_rxn,
  output hsdp1_gt_txn,
  input  hsdp1_gt_rxp,
  output hsdp1_gt_txp,


  // GT0 Reference clock
  input gt_refclk0_p,
  input gt_refclk0_n,

  // GT1 Reference clock
  input gt_refclk1_p,
  input gt_refclk1_n,



  output gt_refclk0_out,
  output gt_refclk1_out,
  output gt_refclk0_div2,
  output gt_refclk1_div2,


  output gt0_refclk0_pdint,
  output gt1_refclk0_pdint,
  output gt2_refclk0_pdint,
  output gt3_refclk0_pdint,
  output gt0_refclk1_pdint,
  output gt1_refclk1_pdint,
  output gt2_refclk1_pdint,
  output gt3_refclk1_pdint,

  input hsdp_refclk_pdint,

  // PS-CPM ports
  input cpm_osc_clk_div2,

  input  m_axi0_ps_buser,
  input  m_axi0_ps_rlast,
  output m_axi0_ps_wlast,
  input  m_axi0_ps_bvalid,
  input  m_axi0_ps_rvalid,
  input  m_axi0_ps_wready,
  output m_axi0_ps_arlock,
  output m_axi0_ps_awlock,
  output m_axi0_ps_bready,
  output m_axi0_ps_rready,
  output m_axi0_ps_wvalid,
  input  m_axi0_ps_arready,
  input  m_axi0_ps_awready,
  output m_axi0_ps_arvalid,
  output m_axi0_ps_awvalid,
  input  [15:0] m_axi0_ps_bid,
  input  [15:0] m_axi0_ps_rid,
  output [15:0] m_axi0_ps_wid,
  output [15:0] m_axi0_ps_arid,
  output [15:0] m_axi0_ps_awid,
  input  [1:0]  m_axi0_ps_bresp,
  input  [1:0]  m_axi0_ps_rresp,
  input  [17:0] m_axi0_ps_ruser,
  input [127:0] m_axi0_ps_rdata,
  output [15:0] m_axi0_ps_wstrb,
  output [17:0] m_axi0_ps_wuser,
  output [3:0]  m_axi0_ps_arqos,
  output [3:0]  m_axi0_ps_awqos,
  output [7:0]  m_axi0_ps_arlen,
  output [7:0]  m_axi0_ps_awlen,
  output[127:0] m_axi0_ps_wdata,
  output [2:0]  m_axi0_ps_arprot,
  output [2:0]  m_axi0_ps_arsize,
  output [2:0]  m_axi0_ps_awprot,
  output [2:0]  m_axi0_ps_awsize,
  output [31:0] m_axi0_ps_aruser,
  output [31:0] m_axi0_ps_awuser,
  output [63:0] m_axi0_ps_araddr,
  output [63:0] m_axi0_ps_awaddr,
  output [1:0]  m_axi0_ps_arburst,
  output [1:0]  m_axi0_ps_awburst,
  output [3:0]  m_axi0_ps_arcache,
  output [3:0]  m_axi0_ps_awcache,
  output [3:0]  m_axi0_ps_arregion,
  output [3:0]  m_axi0_ps_awregion,

  input  m_axi1_ps_rlast,
  output m_axi1_ps_wlast,
  input  m_axi1_ps_bvalid,
  input  m_axi1_ps_rvalid,
  input  m_axi1_ps_wready,
  output m_axi1_ps_arlock,
  output m_axi1_ps_awlock,
  output m_axi1_ps_bready,
  output m_axi1_ps_rready,
  output m_axi1_ps_wvalid,
  input  m_axi1_ps_arready,
  input  m_axi1_ps_awready,
  output m_axi1_ps_arvalid,
  output m_axi1_ps_awvalid,
  input  [15:0] m_axi1_ps_bid,
  input  [15:0] m_axi1_ps_rid,
  output [15:0] m_axi1_ps_wid,
  output [15:0] m_axi1_ps_arid,
  output [15:0] m_axi1_ps_awid,
  input  [1:0]  m_axi1_ps_bresp,
  input  [1:0]  m_axi1_ps_rresp,
  input  [15:0] m_axi1_ps_buser,
  input  [16:0] m_axi1_ps_ruser,
  input [127:0] m_axi1_ps_rdata,
  output [15:0] m_axi1_ps_wstrb,
  output [16:0] m_axi1_ps_wuser,
  output [3:0]  m_axi1_ps_arqos,
  output [3:0]  m_axi1_ps_awqos,
  output [7:0]  m_axi1_ps_arlen,
  output [7:0]  m_axi1_ps_awlen,
  output[127:0] m_axi1_ps_wdata,
  output [17:0] m_axi1_ps_aruser,
  output [17:0] m_axi1_ps_awuser,
  output [2:0]  m_axi1_ps_arprot,
  output [2:0]  m_axi1_ps_arsize,
  output [2:0]  m_axi1_ps_awprot,
  output [2:0]  m_axi1_ps_awsize,
  output [63:0] m_axi1_ps_araddr,
  output [63:0] m_axi1_ps_awaddr,
  output [1:0]  m_axi1_ps_arburst,
  output [1:0]  m_axi1_ps_awburst,
  output [3:0]  m_axi1_ps_arcache,
  output [3:0]  m_axi1_ps_awcache,
  output [3:0]  m_axi1_ps_arregion,
  output [3:0]  m_axi1_ps_awregion,

  output cpmps_corr_irq,
  output cpmps_misc_irq,
  output cpmps_uncorr_irq,

  input  s_axi_cfg_wlast,
  output s_axi_cfg_buser,
  output s_axi_cfg_rlast,
  input  s_axi_cfg_arlock,
  input  s_axi_cfg_awlock,
  input  s_axi_cfg_bready,
  input  s_axi_cfg_rready,
  input  s_axi_cfg_wvalid,
  output s_axi_cfg_bvalid,
  output s_axi_cfg_rvalid,
  output s_axi_cfg_wready,
  input  s_axi_cfg_arvalid,
  input  s_axi_cfg_awvalid,
  output s_axi_cfg_arready,
  output s_axi_cfg_awready,
  input [15:0] s_axi_cfg_wid,
  output[15:0] s_axi_cfg_bid,
  output[15:0] s_axi_cfg_rid,
  input [15:0] s_axi_cfg_arid,
  input [15:0] s_axi_cfg_awid,
  input  [3:0] s_axi_cfg_arqos,
  input  [3:0] s_axi_cfg_awqos,
  input  [3:0] s_axi_cfg_wstrb,
  input  [5:0] s_axi_cfg_wuser,
  input  [7:0] s_axi_cfg_arlen,
  input  [7:0] s_axi_cfg_awlen,
  input [31:0] s_axi_cfg_wdata,
  output [1:0] s_axi_cfg_bresp,
  output [1:0] s_axi_cfg_rresp,
  output [5:0] s_axi_cfg_ruser,
  output[31:0] s_axi_cfg_rdata,
  input  [2:0] s_axi_cfg_arprot,
  input  [2:0] s_axi_cfg_arsize,
  input  [2:0] s_axi_cfg_awprot,
  input  [2:0] s_axi_cfg_awsize,
  input [15:0] s_axi_cfg_aruser,
  input [15:0] s_axi_cfg_awuser,
  input [63:0] s_axi_cfg_araddr,
  input [63:0] s_axi_cfg_awaddr,
  input  [1:0] s_axi_cfg_arburst,
  input  [1:0] s_axi_cfg_awburst,
  input  [3:0] s_axi_cfg_arcache,
  input  [3:0] s_axi_cfg_awcache,
  input  [3:0] s_axi_cfg_arregion,
  input  [3:0] s_axi_cfg_awregion,

  // XPIPE0 PS<->CPM interface
  input  xpipe0_tx_swing,
  output xpipe0_rx_valid,
  input  xpipe0_tx_deemph,
  output xpipe0_phystatus,
  input  xpipe0_rx_polarity,
  input  xpipe0_tx_elecidle,
  output xpipe0_rx_elecidle,
  input  xpipe0_tx_datavalid,
  output xpipe0_rx_datavalid,
  input  xpipe0_tx_compliance,
  input  xpipe0_tx_startblock,
  output xpipe0_rx_startblock,
  input  xpipe0_rx_termination,
  input  xpipe0_tx_detectrxloopback,
  input [31:0] xpipe0_tx_data,
  output[31:0] xpipe0_rx_data,
  input  [1:0] xpipe0_powerdown,
  input  [2:0] xpipe0_tx_margin,
  output [2:0] xpipe0_rx_status,
  input  [1:0] xpipe0_tx_charisk,
  output [1:0] xpipe0_rx_charisk,
  input  [4:0] xpipe0_tx_precursor,
  input  [1:0] xpipe0_tx_syncheader,
  input  [4:0] xpipe0_tx_postcursor,
  input  [6:0] xpipe0_tx_maincursor,
  output [1:0] xpipe0_rx_syncheader,

  // XPIPE1 PS<->CPM interface
  input  xpipe1_tx_swing,
  output xpipe1_rx_valid,
  input  xpipe1_tx_deemph,
  output xpipe1_phystatus,
  input  xpipe1_rx_polarity,
  input  xpipe1_tx_elecidle,
  output xpipe1_rx_elecidle,
  input  xpipe1_tx_datavalid,
  output xpipe1_rx_datavalid,
  input  xpipe1_tx_compliance,
  input  xpipe1_tx_startblock,
  output xpipe1_rx_startblock,
  input  xpipe1_rx_termination,
  input  xpipe1_tx_detectrxloopback,
  input [31:0] xpipe1_tx_data,
  output[31:0] xpipe1_rx_data,
  input  [1:0] xpipe1_powerdown,
  input  [2:0] xpipe1_tx_margin,
  output [2:0] xpipe1_rx_status,
  input  [1:0] xpipe1_tx_charisk,
  output [1:0] xpipe1_rx_charisk,
  input  [4:0] xpipe1_tx_precursor,
  input  [1:0] xpipe1_tx_syncheader,
  input  [4:0] xpipe1_tx_postcursor,
  input  [6:0] xpipe1_tx_maincursor,
  output [1:0] xpipe1_rx_syncheader,

  // XPIPE2 PS<->CPM interface
  input  xpipe2_tx_swing,
  output xpipe2_rx_valid,
  input  xpipe2_tx_deemph,
  output xpipe2_phystatus,
  input  xpipe2_rx_polarity,
  input  xpipe2_tx_elecidle,
  output xpipe2_rx_elecidle,
  input  xpipe2_tx_datavalid,
  output xpipe2_rx_datavalid,
  input  xpipe2_tx_compliance,
  input  xpipe2_tx_startblock,
  output xpipe2_rx_startblock,
  input  xpipe2_rx_termination,
  input  xpipe2_tx_detectrxloopback,
  input [31:0] xpipe2_tx_data,
  output[31:0] xpipe2_rx_data,
  input  [1:0] xpipe2_powerdown,
  input  [2:0] xpipe2_tx_margin,
  output [2:0] xpipe2_rx_status,
  input  [1:0] xpipe2_tx_charisk,
  output [1:0] xpipe2_rx_charisk,
  input  [4:0] xpipe2_tx_precursor,
  input  [1:0] xpipe2_tx_syncheader,
  input  [4:0] xpipe2_tx_postcursor,
  input  [6:0] xpipe2_tx_maincursor,
  output [1:0] xpipe2_rx_syncheader,

  // XPIPE3 PS<->CPM interface
  input  xpipe3_tx_swing,
  output xpipe3_rx_valid,
  input  xpipe3_tx_deemph,
  output xpipe3_phystatus,
  input  xpipe3_rx_polarity,
  input  xpipe3_tx_elecidle,
  output xpipe3_rx_elecidle,
  input  xpipe3_tx_datavalid,
  output xpipe3_rx_datavalid,
  input  xpipe3_tx_compliance,
  input  xpipe3_tx_startblock,
  output xpipe3_rx_startblock,
  input  xpipe3_rx_termination,
  input  xpipe3_tx_detectrxloopback,
  input [31:0] xpipe3_tx_data,
  output[31:0] xpipe3_rx_data,
  input  [1:0] xpipe3_powerdown,
  input  [2:0] xpipe3_tx_margin,
  output [2:0] xpipe3_rx_status,
  input  [1:0] xpipe3_tx_charisk,
  output [1:0] xpipe3_rx_charisk,
  input  [4:0] xpipe3_tx_precursor,
  input  [1:0] xpipe3_tx_syncheader,
  input  [4:0] xpipe3_tx_postcursor,
  input  [6:0] xpipe3_tx_maincursor,
  output [1:0] xpipe3_rx_syncheader,

  // XPIPE4 PS<->CPM interface
  input  xpipe4_tx_swing,
  output xpipe4_rx_valid,
  input  xpipe4_tx_deemph,
  output xpipe4_phystatus,
  input  xpipe4_rx_polarity,
  input  xpipe4_tx_elecidle,
  output xpipe4_rx_elecidle,
  input  xpipe4_tx_datavalid,
  output xpipe4_rx_datavalid,
  input  xpipe4_tx_compliance,
  input  xpipe4_tx_startblock,
  output xpipe4_rx_startblock,
  input  xpipe4_rx_termination,
  input  xpipe4_tx_detectrxloopback,
  input [31:0] xpipe4_tx_data,
  output[31:0] xpipe4_rx_data,
  input  [1:0] xpipe4_powerdown,
  input  [2:0] xpipe4_tx_margin,
  output [2:0] xpipe4_rx_status,
  input  [1:0] xpipe4_tx_charisk,
  output [1:0] xpipe4_rx_charisk,
  input  [4:0] xpipe4_tx_precursor,
  input  [1:0] xpipe4_tx_syncheader,
  input  [4:0] xpipe4_tx_postcursor,
  input  [6:0] xpipe4_tx_maincursor,
  output [1:0] xpipe4_rx_syncheader,

  // XPIPE5 PS<->CPM interface
  input  xpipe5_tx_swing,
  output xpipe5_rx_valid,
  input  xpipe5_tx_deemph,
  output xpipe5_phystatus,
  input  xpipe5_rx_polarity,
  input  xpipe5_tx_elecidle,
  output xpipe5_rx_elecidle,
  input  xpipe5_tx_datavalid,
  output xpipe5_rx_datavalid,
  input  xpipe5_tx_compliance,
  input  xpipe5_tx_startblock,
  output xpipe5_rx_startblock,
  input  xpipe5_rx_termination,
  input  xpipe5_tx_detectrxloopback,
  input [31:0] xpipe5_tx_data,
  output[31:0] xpipe5_rx_data,
  input  [1:0] xpipe5_powerdown,
  input  [2:0] xpipe5_tx_margin,
  output [2:0] xpipe5_rx_status,
  input  [1:0] xpipe5_tx_charisk,
  output [1:0] xpipe5_rx_charisk,
  input  [4:0] xpipe5_tx_precursor,
  input  [1:0] xpipe5_tx_syncheader,
  input  [4:0] xpipe5_tx_postcursor,
  input  [6:0] xpipe5_tx_maincursor,
  output [1:0] xpipe5_rx_syncheader,

  // XPIPE6 PS<->CPM interface
  input  xpipe6_tx_swing,
  output xpipe6_rx_valid,
  input  xpipe6_tx_deemph,
  output xpipe6_phystatus,
  input  xpipe6_rx_polarity,
  input  xpipe6_tx_elecidle,
  output xpipe6_rx_elecidle,
  input  xpipe6_tx_datavalid,
  output xpipe6_rx_datavalid,
  input  xpipe6_tx_compliance,
  input  xpipe6_tx_startblock,
  output xpipe6_rx_startblock,
  input  xpipe6_rx_termination,
  input  xpipe6_tx_detectrxloopback,
  input [31:0] xpipe6_tx_data,
  output[31:0] xpipe6_rx_data,
  input  [1:0] xpipe6_powerdown,
  input  [2:0] xpipe6_tx_margin,
  output [2:0] xpipe6_rx_status,
  input  [1:0] xpipe6_tx_charisk,
  output [1:0] xpipe6_rx_charisk,
  input  [4:0] xpipe6_tx_precursor,
  input  [1:0] xpipe6_tx_syncheader,
  input  [4:0] xpipe6_tx_postcursor,
  input  [6:0] xpipe6_tx_maincursor,
  output [1:0] xpipe6_rx_syncheader,

  // XPIPE7 PS<->CPM interface
  input  xpipe7_tx_swing,
  output xpipe7_rx_valid,
  input  xpipe7_tx_deemph,
  output xpipe7_phystatus,
  input  xpipe7_rx_polarity,
  input  xpipe7_tx_elecidle,
  output xpipe7_rx_elecidle,
  input  xpipe7_tx_datavalid,
  output xpipe7_rx_datavalid,
  input  xpipe7_tx_compliance,
  input  xpipe7_tx_startblock,
  output xpipe7_rx_startblock,
  input  xpipe7_rx_termination,
  input  xpipe7_tx_detectrxloopback,
  input [31:0] xpipe7_tx_data,
  output[31:0] xpipe7_rx_data,
  input  [1:0] xpipe7_powerdown,
  input  [2:0] xpipe7_tx_margin,
  output [2:0] xpipe7_rx_status,
  input  [1:0] xpipe7_tx_charisk,
  output [1:0] xpipe7_rx_charisk,
  input  [4:0] xpipe7_tx_precursor,
  input  [1:0] xpipe7_tx_syncheader,
  input  [4:0] xpipe7_tx_postcursor,
  input  [6:0] xpipe7_tx_maincursor,
  output [1:0] xpipe7_rx_syncheader,

  // XPIPE8 PS<->CPM interface
  input  xpipe8_tx_swing,
  output xpipe8_rx_valid,
  input  xpipe8_tx_deemph,
  output xpipe8_phystatus,
  input  xpipe8_rx_polarity,
  input  xpipe8_tx_elecidle,
  output xpipe8_rx_elecidle,
  input  xpipe8_tx_datavalid,
  output xpipe8_rx_datavalid,
  input  xpipe8_tx_compliance,
  input  xpipe8_tx_startblock,
  output xpipe8_rx_startblock,
  input  xpipe8_rx_termination,
  input  xpipe8_tx_detectrxloopback,
  input [31:0] xpipe8_tx_data,
  output[31:0] xpipe8_rx_data,
  input  [1:0] xpipe8_powerdown,
  input  [2:0] xpipe8_tx_margin,
  output [2:0] xpipe8_rx_status,
  input  [1:0] xpipe8_tx_charisk,
  output [1:0] xpipe8_rx_charisk,
  input  [4:0] xpipe8_tx_precursor,
  input  [1:0] xpipe8_tx_syncheader,
  input  [4:0] xpipe8_tx_postcursor,
  input  [6:0] xpipe8_tx_maincursor,
  output [1:0] xpipe8_rx_syncheader,

  // XPIPE9 PS<->CPM interface
  input  xpipe9_tx_swing,
  output xpipe9_rx_valid,
  input  xpipe9_tx_deemph,
  output xpipe9_phystatus,
  input  xpipe9_rx_polarity,
  input  xpipe9_tx_elecidle,
  output xpipe9_rx_elecidle,
  input  xpipe9_tx_datavalid,
  output xpipe9_rx_datavalid,
  input  xpipe9_tx_compliance,
  input  xpipe9_tx_startblock,
  output xpipe9_rx_startblock,
  input  xpipe9_rx_termination,
  input  xpipe9_tx_detectrxloopback,
  input [31:0] xpipe9_tx_data,
  output[31:0] xpipe9_rx_data,
  input  [1:0] xpipe9_powerdown,
  input  [2:0] xpipe9_tx_margin,
  output [2:0] xpipe9_rx_status,
  input  [1:0] xpipe9_tx_charisk,
  output [1:0] xpipe9_rx_charisk,
  input  [4:0] xpipe9_tx_precursor,
  input  [1:0] xpipe9_tx_syncheader,
  input  [4:0] xpipe9_tx_postcursor,
  input  [6:0] xpipe9_tx_maincursor,
  output [1:0] xpipe9_rx_syncheader,

  // XPIPE10 PS<->CPM interface
  input  xpipe10_tx_swing,
  output xpipe10_rx_valid,
  input  xpipe10_tx_deemph,
  output xpipe10_phystatus,
  input  xpipe10_rx_polarity,
  input  xpipe10_tx_elecidle,
  output xpipe10_rx_elecidle,
  input  xpipe10_tx_datavalid,
  output xpipe10_rx_datavalid,
  input  xpipe10_tx_compliance,
  input  xpipe10_tx_startblock,
  output xpipe10_rx_startblock,
  input  xpipe10_rx_termination,
  input  xpipe10_tx_detectrxloopback,
  input [31:0] xpipe10_tx_data,
  output[31:0] xpipe10_rx_data,
  input  [1:0] xpipe10_powerdown,
  input  [2:0] xpipe10_tx_margin,
  output [2:0] xpipe10_rx_status,
  input  [1:0] xpipe10_tx_charisk,
  output [1:0] xpipe10_rx_charisk,
  input  [4:0] xpipe10_tx_precursor,
  input  [1:0] xpipe10_tx_syncheader,
  input  [4:0] xpipe10_tx_postcursor,
  input  [6:0] xpipe10_tx_maincursor,
  output [1:0] xpipe10_rx_syncheader,

  // XPIPE11 PS<->CPM interface
  input  xpipe11_tx_swing,
  output xpipe11_rx_valid,
  input  xpipe11_tx_deemph,
  output xpipe11_phystatus,
  input  xpipe11_rx_polarity,
  input  xpipe11_tx_elecidle,
  output xpipe11_rx_elecidle,
  input  xpipe11_tx_datavalid,
  output xpipe11_rx_datavalid,
  input  xpipe11_tx_compliance,
  input  xpipe11_tx_startblock,
  output xpipe11_rx_startblock,
  input  xpipe11_rx_termination,
  input  xpipe11_tx_detectrxloopback,
  input [31:0] xpipe11_tx_data,
  output[31:0] xpipe11_rx_data,
  input  [1:0] xpipe11_powerdown,
  input  [2:0] xpipe11_tx_margin,
  output [2:0] xpipe11_rx_status,
  input  [1:0] xpipe11_tx_charisk,
  output [1:0] xpipe11_rx_charisk,
  input  [4:0] xpipe11_tx_precursor,
  input  [1:0] xpipe11_tx_syncheader,
  input  [4:0] xpipe11_tx_postcursor,
  input  [6:0] xpipe11_tx_maincursor,
  output [1:0] xpipe11_rx_syncheader,

  // XPIPE12 PS<->CPM interface
  input  xpipe12_tx_swing,
  output xpipe12_rx_valid,
  input  xpipe12_tx_deemph,
  output xpipe12_phystatus,
  input  xpipe12_rx_polarity,
  input  xpipe12_tx_elecidle,
  output xpipe12_rx_elecidle,
  input  xpipe12_tx_datavalid,
  output xpipe12_rx_datavalid,
  input  xpipe12_tx_compliance,
  input  xpipe12_tx_startblock,
  output xpipe12_rx_startblock,
  input  xpipe12_rx_termination,
  input  xpipe12_tx_detectrxloopback,
  input [31:0] xpipe12_tx_data,
  output[31:0] xpipe12_rx_data,
  input  [1:0] xpipe12_powerdown,
  input  [2:0] xpipe12_tx_margin,
  output [2:0] xpipe12_rx_status,
  input  [1:0] xpipe12_tx_charisk,
  output [1:0] xpipe12_rx_charisk,
  input  [4:0] xpipe12_tx_precursor,
  input  [1:0] xpipe12_tx_syncheader,
  input  [4:0] xpipe12_tx_postcursor,
  input  [6:0] xpipe12_tx_maincursor,
  output [1:0] xpipe12_rx_syncheader,

  // XPIPE13 PS<->CPM interface
  input  xpipe13_tx_swing,
  output xpipe13_rx_valid,
  input  xpipe13_tx_deemph,
  output xpipe13_phystatus,
  input  xpipe13_rx_polarity,
  input  xpipe13_tx_elecidle,
  output xpipe13_rx_elecidle,
  input  xpipe13_tx_datavalid,
  output xpipe13_rx_datavalid,
  input  xpipe13_tx_compliance,
  input  xpipe13_tx_startblock,
  output xpipe13_rx_startblock,
  input  xpipe13_rx_termination,
  input  xpipe13_tx_detectrxloopback,
  input [31:0] xpipe13_tx_data,
  output[31:0] xpipe13_rx_data,
  input  [1:0] xpipe13_powerdown,
  input  [2:0] xpipe13_tx_margin,
  output [2:0] xpipe13_rx_status,
  input  [1:0] xpipe13_tx_charisk,
  output [1:0] xpipe13_rx_charisk,
  input  [4:0] xpipe13_tx_precursor,
  input  [1:0] xpipe13_tx_syncheader,
  input  [4:0] xpipe13_tx_postcursor,
  input  [6:0] xpipe13_tx_maincursor,
  output [1:0] xpipe13_rx_syncheader,

  // XPIPE14 PS<->CPM interface
  input  xpipe14_tx_swing,
  output xpipe14_rx_valid,
  input  xpipe14_tx_deemph,
  output xpipe14_phystatus,
  input  xpipe14_rx_polarity,
  input  xpipe14_tx_elecidle,
  output xpipe14_rx_elecidle,
  input  xpipe14_tx_datavalid,
  output xpipe14_rx_datavalid,
  input  xpipe14_tx_compliance,
  input  xpipe14_tx_startblock,
  output xpipe14_rx_startblock,
  input  xpipe14_rx_termination,
  input  xpipe14_tx_detectrxloopback,
  input [31:0] xpipe14_tx_data,
  output[31:0] xpipe14_rx_data,
  input  [1:0] xpipe14_powerdown,
  input  [2:0] xpipe14_tx_margin,
  output [2:0] xpipe14_rx_status,
  input  [1:0] xpipe14_tx_charisk,
  output [1:0] xpipe14_rx_charisk,
  input  [4:0] xpipe14_tx_precursor,
  input  [1:0] xpipe14_tx_syncheader,
  input  [4:0] xpipe14_tx_postcursor,
  input  [6:0] xpipe14_tx_maincursor,
  output [1:0] xpipe14_rx_syncheader,

  // XPIPE15 PS<->CPM interface
  input  xpipe15_tx_swing,
  output xpipe15_rx_valid,
  input  xpipe15_tx_deemph,
  output xpipe15_phystatus,
  input  xpipe15_rx_polarity,
  input  xpipe15_tx_elecidle,
  output xpipe15_rx_elecidle,
  input  xpipe15_tx_datavalid,
  output xpipe15_rx_datavalid,
  input  xpipe15_tx_compliance,
  input  xpipe15_tx_startblock,
  output xpipe15_rx_startblock,
  input  xpipe15_rx_termination,
  input  xpipe15_tx_detectrxloopback,
  input [31:0] xpipe15_tx_data,
  output[31:0] xpipe15_rx_data,
  input  [1:0] xpipe15_powerdown,
  input  [2:0] xpipe15_tx_margin,
  output [2:0] xpipe15_rx_status,
  input  [1:0] xpipe15_tx_charisk,
  output [1:0] xpipe15_rx_charisk,
  input  [4:0] xpipe15_tx_precursor,
  input  [1:0] xpipe15_tx_syncheader,
  input  [4:0] xpipe15_tx_postcursor,
  input  [6:0] xpipe15_tx_maincursor,
  output [1:0] xpipe15_rx_syncheader,


  // HSDP XPIPE0 PS<->CPM interface
  input  hsdp_xpipe0_rx_pcsreset,
  output hsdp_xpipe0_rx_datavalid,
  output hsdp_xpipe0_rx_resetdone,
  output hsdp_xpipe0_tx_resetdone,
  input  hsdp_xpipe0_rx_gearboxslip,
  output hsdp_xpipe0_rx_headervalid,
  output [1:0] hsdp_xpipe0_rx_header,
  input  [1:0] hsdp_xpipe0_tx_header,
  input  [6:0] hsdp_xpipe0_tx_sequence,

  // HSDP XPIPE1 PS<->CPM interface
  input  hsdp_xpipe1_rx_pcsreset,
  output hsdp_xpipe1_rx_datavalid,
  output hsdp_xpipe1_rx_resetdone,
  output hsdp_xpipe1_tx_resetdone,
  input  hsdp_xpipe1_rx_gearboxslip,
  output hsdp_xpipe1_rx_headervalid,
  output [1:0] hsdp_xpipe1_rx_header,
  input  [1:0] hsdp_xpipe1_tx_header,
  input  [6:0] hsdp_xpipe1_tx_sequence,

  // HSDP XPIPE2 PS<->CPM interface
  input  hsdp_xpipe2_rx_pcsreset,
  output hsdp_xpipe2_rx_datavalid,
  output hsdp_xpipe2_rx_resetdone,
  output hsdp_xpipe2_tx_resetdone,
  input  hsdp_xpipe2_rx_gearboxslip,
  output hsdp_xpipe2_rx_headervalid,
  output [1:0] hsdp_xpipe2_rx_header,
  input  [1:0] hsdp_xpipe2_tx_header,
  input  [6:0] hsdp_xpipe2_tx_sequence,



  input  phy_ready_frbot,
  output phy_ready_tobot,
  output hsdp_gt_rxoutclk,
  input  hsdp_gt_txusrclk,

  output link0_xpipe_bufgtce,
  output link0_xpipe_bufgtrst,
  output link0_xpipe_gtoutclk,
  output link0_xpipe_phyready,
  input  link0_xpipe_gtpipeclk,
  input  link0_xpipe_pcieperstn,
  input  link0_xpipe_pcielinkreachtarget,
  input  link0_xpipe_phyesmadaptationsave,
  output[11:0] link0_xpipe_bufgtdiv,
  input  [2:0] link0_xpipe_piperate,
  output [3:0] link0_xpipe_bufgtcemask,
  output [3:0] link0_xpipe_bufgtrstmask,
  input  [5:0] link0_xpipe_pcieltssmstate,

  output link1_xpipe_bufgtce,
  output link1_xpipe_bufgtrst,
  output link1_xpipe_gtoutclk,
  output link1_xpipe_phyready,
  input  link1_xpipe_gtpipeclk,
  input  link1_xpipe_pcieperstn,
  input  link1_xpipe_pcielinkreachtarget,
  input  link1_xpipe_phyesmadaptationsave,
  output[11:0] link1_xpipe_bufgtdiv,
  input  [2:0] link1_xpipe_piperate,
  output [3:0] link1_xpipe_bufgtcemask,
  output [3:0] link1_xpipe_bufgtrstmask,
  input  [5:0] link1_xpipe_pcieltssmstate,


  input  s_axi_pcie_wlast,
  output s_axi_pcie_rlast,
  input  s_axi_pcie_arlock,
  input  s_axi_pcie_awlock,
  input  s_axi_pcie_bready,
  input  s_axi_pcie_rready,
  input  s_axi_pcie_wvalid,
  output s_axi_pcie_bvalid,
  output s_axi_pcie_rvalid,
  output s_axi_pcie_wready,
  input  s_axi_pcie_arvalid,
  input  s_axi_pcie_awvalid,
  output s_axi_pcie_arready,
  output s_axi_pcie_awready,
  input  [15:0] s_axi_pcie_wid,
  output [15:0] s_axi_pcie_bid,
  output [15:0] s_axi_pcie_rid,
  input  [15:0] s_axi_pcie_arid,
  input  [15:0] s_axi_pcie_awid,
  input  [15:0] s_axi_pcie_wstrb,
  input  [16:0] s_axi_pcie_wuser,
  input  [3:0]  s_axi_pcie_arqos,
  input  [3:0]  s_axi_pcie_awqos,
  input  [7:0]  s_axi_pcie_arlen,
  input  [7:0]  s_axi_pcie_awlen,
  input [127:0] s_axi_pcie_wdata,
  output [1:0]  s_axi_pcie_bresp,
  output [1:0]  s_axi_pcie_rresp,
  output [15:0] s_axi_pcie_buser,
  output [16:0] s_axi_pcie_ruser,
  output[127:0] s_axi_pcie_rdata,
  input  [17:0] s_axi_pcie_aruser,
  input  [17:0] s_axi_pcie_awuser,
  input  [2:0]  s_axi_pcie_arprot,
  input  [2:0]  s_axi_pcie_arsize,
  input  [2:0]  s_axi_pcie_awprot,
  input  [2:0]  s_axi_pcie_awsize,
  input  [63:0] s_axi_pcie_araddr,
  input  [63:0] s_axi_pcie_awaddr,
  input  [1:0]  s_axi_pcie_arburst,
  input  [1:0]  s_axi_pcie_awburst,
  input  [3:0]  s_axi_pcie_arcache,
  input  [3:0]  s_axi_pcie_awcache,
  input  [3:0]  s_axi_pcie_arregion,
  input  [3:0]  s_axi_pcie_awregion,

  input  cpm_pcr_apb_en,
  input  cpm_pcr_pwr_dn,
  input  cpm_pcr_mem_clr,
  input  cpm_pcr_gate_reg,
  input  cpm_pcr_scan_clr,
  input  cpm_pcr_tristate,
  input  cpm_pcr_fabric_en,
  input  cpm_pcr_pcomplete,
  input  cpm_pcr_start_cal,
  input  cpm_pcr_hold_state,
  input  cpm_pcr_init_state,
  input  cpm_pcr_start_bisr,
  input  cpm_pcr_dis_npi_clk,
  input [3:0] cpm_pcr_o_disable,

  output cpm_psr_in_cal,
  output cpm_psr_bisr_err,
  output cpm_psr_cal_done,
  output cpm_psr_bisr_done,
  output cpm_psr_cal_error,
  output cpm_psr_mem_clr_done,
  output cpm_psr_mem_clr_pass,
  output cpm_psr_scan_clr_done,
  output cpm_psr_scan_clr_pass,

  output xpipe_q0_rxmargin_req_ack,
  input  xpipe_q0_rxmargin_req_req,
  input  xpipe_q0_rxmargin_res_ack,
  output xpipe_q0_rxmargin_res_req,
  input  [3:0] xpipe_q0_rxmargin_req_cmd,
  output [3:0] xpipe_q0_rxmargin_res_cmd,
  input  [1:0] xpipe_q0_rxmargin_req_lanenum,
  input  [7:0] xpipe_q0_rxmargin_req_payload,
  output [1:0] xpipe_q0_rxmargin_res_lanenum,
  output [7:0] xpipe_q0_rxmargin_res_payload,

  output xpipe_q1_rxmargin_req_ack,
  input  xpipe_q1_rxmargin_req_req,
  input  xpipe_q1_rxmargin_res_ack,
  output xpipe_q1_rxmargin_res_req,
  input  [3:0] xpipe_q1_rxmargin_req_cmd,
  output [3:0] xpipe_q1_rxmargin_res_cmd,
  input  [1:0] xpipe_q1_rxmargin_req_lanenum,
  input  [7:0] xpipe_q1_rxmargin_req_payload,
  output [1:0] xpipe_q1_rxmargin_res_lanenum,
  output [7:0] xpipe_q1_rxmargin_res_payload,

  output xpipe_q2_rxmargin_req_ack,
  input  xpipe_q2_rxmargin_req_req,
  input  xpipe_q2_rxmargin_res_ack,
  output xpipe_q2_rxmargin_res_req,
  input  [3:0] xpipe_q2_rxmargin_req_cmd,
  output [3:0] xpipe_q2_rxmargin_res_cmd,
  input  [1:0] xpipe_q2_rxmargin_req_lanenum,
  input  [7:0] xpipe_q2_rxmargin_req_payload,
  output [1:0] xpipe_q2_rxmargin_res_lanenum,
  output [7:0] xpipe_q2_rxmargin_res_payload,

  output xpipe_q3_rxmargin_req_ack,
  input  xpipe_q3_rxmargin_req_req,
  input  xpipe_q3_rxmargin_res_ack,
  output xpipe_q3_rxmargin_res_req,
  input  [3:0] xpipe_q3_rxmargin_req_cmd,
  output [3:0] xpipe_q3_rxmargin_res_cmd,
  input  [1:0] xpipe_q3_rxmargin_req_lanenum,
  input  [7:0] xpipe_q3_rxmargin_req_payload,
  output [1:0] xpipe_q3_rxmargin_res_lanenum,
  output [7:0] xpipe_q3_rxmargin_res_payload,



  input   perst0n,
  input   perst1n,
  input   lpd_swclk,
  input   lpd_refclk_in,
  input   lpd_switch_timeout_cnt
);

  localparam C_SIM_DEVICE = "VERSAL_AI_CORE";

  wire [3:0] gt0_serial_rxn; 
  wire [3:0] gt1_serial_rxn; 
  wire [3:0] gt2_serial_rxn; 
  wire [3:0] gt3_serial_rxn; 
  wire [3:0] gt0_serial_txn; 
  wire [3:0] gt1_serial_txn; 
  wire [3:0] gt2_serial_txn; 
  wire [3:0] gt3_serial_txn; 
  wire [3:0] gt0_serial_rxp; 
  wire [3:0] gt1_serial_rxp; 
  wire [3:0] gt2_serial_rxp; 
  wire [3:0] gt3_serial_rxp; 
  wire [3:0] gt0_serial_txp; 
  wire [3:0] gt1_serial_txp; 
  wire [3:0] gt2_serial_txp; 
  wire [3:0] gt3_serial_txp; 


`include "cpm4_v1_0_18_xpipe_wires.vh"

  `include "cpm4_v1_0_18_xpipe0_wires.vh"
  bd_57a1_cpm_0_0_gt_quad_0  gt_quad_inst0 (
    `include "cpm4_v1_0_18_gt_quad0_inst.vh"
  );

  assign hsdp0_gt_txn = gt0_serial_txn[0];
  assign hsdp0_gt_txp = gt0_serial_txp[0];
  assign gt0_serial_rxn[0] = hsdp0_gt_rxn;
  assign gt0_serial_rxp[0] = hsdp0_gt_rxp;


  IBUFDS_GTE5 IBUFDS_GTE5_PCIeA0_inst (
    .I(gt_refclk0_p),
    .IB(gt_refclk0_n),
    .O(gt_refclk0_out),
    .ODIV2(gt_refclk0_div2_ibuf),
    .CEB(gt0_refclk0_pdint)
  );

  wire s_pcie0_cfg_msi_fail;
  wire s_pcie0_cfg_msi_sent;

  wire pcie0_cfg_hot_reset_in_int; 
  wire pcie1_cfg_hot_reset_in_int; 

  wire [2:0]  s_pcie0_cfg_msi_attr; 
  wire [1:0]  s_pcie0_cfg_msi_tph_type; 
  wire [31:0] s_pcie0_cfg_msi_int_vector; 
  wire [7:0]  s_pcie0_cfg_msi_tph_st_tag; 
  wire        s_pcie0_cfg_msi_tph_present; 
  wire [7:0]  s_pcie0_cfg_msi_function_number; 

  wire        s_pcie0_cfg_err_cor_in; 
  wire        s_pcie0_cfg_err_uncor_in; 
  wire [3:0]  s_pcie0_cfg_interrupt_int; 
  wire        s_pcie0_cfg_msg_transmit; 
  wire [31:0] s_pcie0_cfg_msg_transmit_data; 
  wire [2:0]  s_pcie0_cfg_msg_transmit_type; 
  wire [3:0]  s_pcie0_cfg_interrupt_pending; 
  wire [2:0]  s_pcie1_cfg_msi_attr; 
  wire [1:0]  s_pcie1_cfg_msi_tph_type; 
  wire [31:0] s_pcie1_cfg_msi_int_vector; 
  wire [7:0]  s_pcie1_cfg_msi_tph_st_tag; 
  wire        s_pcie1_cfg_msi_tph_present; 
  wire [7:0]  s_pcie1_cfg_msi_function_number; 

  wire        s_pcie1_cfg_err_cor_in; 
  wire        s_pcie1_cfg_err_uncor_in; 
  wire [3:0]  s_pcie1_cfg_interrupt_int; 
  wire        s_pcie1_cfg_msg_transmit; 
  wire [31:0] s_pcie1_cfg_msg_transmit_data; 
  wire [2:0]  s_pcie1_cfg_msg_transmit_type; 
  wire [3:0]  s_pcie1_cfg_interrupt_pending; 


  wire pcie0_user_clk_loc; 

  wire pcie0_cq_pipeline_empty; 
  wire pcie0_posted_req_delivered; 
  wire pcie0_compl_credit_released; 
  wire pcie0_posted_credit_released; 
  wire pcie0_cq_np_user_credit_rcvd; 
  wire pcie0_nonposted_credit_released; 
  wire [1:0] pcie0_compl_delivered; 
  wire [7:0] pcie0_compl_delivered_tag0; 
  wire [7:0] pcie0_compl_delivered_tag1; 
  wire [1:0] pcie0_compl_header_credit_released_value; 
  wire [6:0] pcie0_compl_payload_credit_released_value; 
  wire [6:0] pcie0_posted_payload_credit_released_value; 
  wire [1:0] pcie0_nonposted_payload_credit_released_value; 

  wire pcie0_unified_axis_cq_vld; 
  wire pcie0_unified_axis_rc_vld; 
  wire pcie0_unified_axis_cq_crdt; 
  wire pcie0_unified_axis_cq1_vld; 
  wire pcie0_unified_axis_rc_crdt; 
  wire pcie0_unified_axis_rc1_vld; 
  wire pcie0_unified_axis_cq_tlast; 
  wire pcie0_unified_axis_cq1_crdt; 
  wire pcie0_unified_axis_rc_tlast; 
  wire pcie0_unified_axis_rc1_crdt; 
  wire pcie0_unified_axis_cq1_tlast; 
  wire pcie0_unified_axis_rc1_tlast; 
  wire[511:0] pcie0_unified_axis_cq_tdata; 
  wire [15:0] pcie0_unified_axis_cq_tkeep; 
  wire[228:0] pcie0_unified_axis_cq_tuser; 

  wire dpll0_rstn; 
  wire dpll0_stable; 
  wire dpll0_locked; 
  wire pcie1_user_clk_loc; 

  wire pcie1_cq_pipeline_empty; 
  wire pcie1_posted_req_delivered; 
  wire pcie1_compl_credit_released; 
  wire pcie1_posted_credit_released; 
  wire pcie1_cq_np_user_credit_rcvd; 
  wire pcie1_nonposted_credit_released; 
  wire [1:0] pcie1_compl_delivered; 
  wire [7:0] pcie1_compl_delivered_tag0; 
  wire [7:0] pcie1_compl_delivered_tag1; 
  wire [1:0] pcie1_compl_header_credit_released_value; 
  wire [6:0] pcie1_compl_payload_credit_released_value; 
  wire [6:0] pcie1_posted_payload_credit_released_value; 
  wire [1:0] pcie1_nonposted_payload_credit_released_value; 

  wire pcie1_unified_axis_cq_vld; 
  wire pcie1_unified_axis_rc_vld; 
  wire pcie1_unified_axis_cq_crdt; 
  wire pcie1_unified_axis_cq1_vld; 
  wire pcie1_unified_axis_rc_crdt; 
  wire pcie1_unified_axis_rc1_vld; 
  wire pcie1_unified_axis_cq_tlast; 
  wire pcie1_unified_axis_cq1_crdt; 
  wire pcie1_unified_axis_rc_tlast; 
  wire pcie1_unified_axis_rc1_crdt; 
  wire pcie1_unified_axis_cq1_tlast; 
  wire pcie1_unified_axis_rc1_tlast; 
  wire[511:0] pcie1_unified_axis_cq_tdata; 
  wire [15:0] pcie1_unified_axis_cq_tkeep; 
  wire[228:0] pcie1_unified_axis_cq_tuser; 

  wire dpll1_rstn; 
  wire dpll1_stable; 
  wire dpll1_locked; 


  // DMA AXI-ST wires
  wire          dma0_s_axis_rq_tvalid; 
  wire [511:0]  dma0_s_axis_rq_tdata; 
  wire [15:0]   dma0_s_axis_rq_tkeep; 
  wire          dma0_s_axis_rq_tlast; 
  wire [136:0]  dma0_s_axis_rq_tuser; 
  wire [3:0]    dma0_s_axis_rq_tready; 
  wire          dma0_s_axis_cc_tvalid; 
  wire [511:0]  dma0_s_axis_cc_tdata; 
  wire [15:0]   dma0_s_axis_cc_tkeep; 
  wire          dma0_s_axis_cc_tlast; 
  wire [136:0]  dma0_s_axis_cc_tuser; 
  wire [3:0]    dma0_s_axis_cc_tready; 


  // Output Ports
  assign pcie0_cfg_msi_fail = s_pcie0_cfg_msi_fail;
  assign pcie0_cfg_msi_sent = s_pcie0_cfg_msi_sent;
  assign pcie0_cfg_msix_fail = s_pcie0_cfg_msi_fail;
  assign pcie0_cfg_msix_sent = s_pcie0_cfg_msi_sent;

  generate
    // Controller 0 MSI/MSIX ports
    if (C_CPM_PCIE0_PF0_MSI_ENABLED == 0) begin:C_CPM_PCIE0_MSIX_PORTS
      assign s_pcie0_cfg_msi_attr = pcie0_cfg_msix_attr; 
      assign s_pcie0_cfg_msi_tph_type = pcie0_cfg_msix_tph_type; 
      assign s_pcie0_cfg_msi_tph_st_tag = pcie0_cfg_msix_tph_st_tag; 
      assign s_pcie0_cfg_msi_int_vector = pcie0_cfg_msix_mint_vector; 
      assign s_pcie0_cfg_msi_tph_present = pcie0_cfg_msix_tph_present; 
      assign s_pcie0_cfg_msi_function_number = pcie0_cfg_msix_function_number; 
    end
    else
    begin:C_CPM_PCIE0_MSI_PORTS
      assign s_pcie0_cfg_msi_attr = pcie0_cfg_msi_attr; 
      assign s_pcie0_cfg_msi_tph_type = pcie0_cfg_msi_tph_type; 
      assign s_pcie0_cfg_msi_tph_st_tag = pcie0_cfg_msi_tph_st_tag; 
      assign s_pcie0_cfg_msi_int_vector = pcie0_cfg_msi_int_vector; 
      assign s_pcie0_cfg_msi_tph_present = pcie0_cfg_msi_tph_present; 
      assign s_pcie0_cfg_msi_function_number = pcie0_cfg_msi_function_number; 
    end

    assign pcie0_compl_header_credit_released_value = pcie0_cfg_interrupt_int[1:0]; 
    assign pcie0_compl_payload_credit_released_value = {1'b0,pcie0_cfg_interrupt_pending,pcie0_cfg_interrupt_int[3:2]}; 

    // Controller 0 signals assignment when AXI ST data width is 512 and PASID capability is enabled
    if ( C_CPM_PCIE0_AXISTEN_IF_WIDTH == 512) begin
      if ( C_CPM_PCIE0_PF0_PASID_CAP_ON == 1 ) begin
        assign s_pcie0_cfg_msg_transmit_data[30:29] = pcie0_s_axis_rq_tuser[182:181] ; // pasid_pmode_req[1:0]
        assign s_pcie0_cfg_msg_transmit_data[14:13] = pcie0_s_axis_rq_tuser[180:179] ; // pasid_exe_req[1:0]
        assign s_pcie0_cfg_err_cor_in               = pcie0_s_axis_rq_tuser[178]     ; // pasid[39]
        assign s_pcie0_cfg_interrupt_pending[3:0]   = pcie0_s_axis_rq_tuser[177:174] ; // pasid[38:35]
        assign s_pcie0_cfg_interrupt_int[3:2]       = pcie0_s_axis_rq_tuser[173:172] ; // pasid[34:33]
        assign s_pcie0_cfg_interrupt_int[1:0]       = pcie0_s_axis_rq_tuser[171:170] ; // pasid[32:31]
        assign s_pcie0_cfg_err_uncor_in             = pcie0_s_axis_rq_tuser[169]     ; // pasid[30]
        assign s_pcie0_cfg_msg_transmit_data[12:11] = pcie0_s_axis_rq_tuser[168:167] ; // pasid[29:26]
        assign s_pcie0_cfg_msg_transmit_data[10]    = pcie0_s_axis_rq_tuser[166]     ; // pasid[25]
        assign s_pcie0_cfg_msg_transmit_data[31]    = pcie0_s_axis_rq_tuser[165]     ; // pasid[24]
        assign s_pcie0_cfg_msg_transmit_data[28:23] = pcie0_s_axis_rq_tuser[164:159] ; // pasid[23:20]
        assign s_pcie0_cfg_msg_transmit_type[2]     = pcie0_s_axis_rq_tuser[158]     ; // pasid[19]
        assign s_pcie0_cfg_msg_transmit_data[22:15] = pcie0_s_axis_rq_tuser[157:150] ; // pasid[18:11]
        assign s_pcie0_cfg_msg_transmit_data[9:2]   = pcie0_s_axis_rq_tuser[149:142] ; // pasid[10:3]
        assign s_pcie0_cfg_msg_transmit_data[1:0]   = pcie0_s_axis_rq_tuser[141:140] ; // pasid[2:1]
        assign s_pcie0_cfg_msg_transmit_type[1]     = pcie0_s_axis_rq_tuser[139]     ; // pasid[0]
        assign s_pcie0_cfg_msg_transmit_type[0]     = pcie0_s_axis_rq_tuser[138]     ; // pasid_valid[1]
        assign s_pcie0_cfg_msg_transmit             = pcie0_s_axis_rq_tuser[137]     ; // pasid_valid[0]

        assign pcie0_compl_delivered = 'd0; 
        assign pcie0_cq_pipeline_empty = 'd0; 
        assign pcie0_posted_req_delivered = 'd0; 
        assign pcie0_compl_delivered_tag0 = 'd0; 
        assign pcie0_compl_delivered_tag1 = 'd0; 
        assign pcie0_compl_credit_released = 'd0; 
        assign pcie0_cq_np_user_credit_rcvd = 'd0; 
        assign pcie0_posted_credit_released = 'd0; 
        assign pcie0_nonposted_credit_released = 'd0; 
        assign pcie0_posted_payload_credit_released_value = 'd0; 
        assign pcie0_nonposted_payload_credit_released_value = 'd0; 

      end else begin

        assign s_pcie0_cfg_err_cor_in = pcie0_cfg_err_cor_in; 
        assign s_pcie0_cfg_err_uncor_in = pcie0_cfg_err_uncor_in; 
        assign s_pcie0_cfg_msg_transmit = pcie0_cfg_msg_transmit; 
        assign s_pcie0_cfg_interrupt_int = pcie0_cfg_interrupt_int; 
        assign s_pcie0_cfg_msg_transmit_data = pcie0_cfg_msg_transmit_data; 
        assign s_pcie0_cfg_msg_transmit_type = pcie0_cfg_msg_transmit_type; 
        assign s_pcie0_cfg_interrupt_pending = pcie0_cfg_interrupt_pending; 

        assign pcie0_cq_pipeline_empty = pcie0_s_axis_rq_tuser[138]; 
        assign pcie0_compl_delivered = pcie0_s_axis_rq_tuser[141:140]; 
        assign pcie0_posted_req_delivered = pcie0_s_axis_rq_tuser[137]; 
        assign pcie0_compl_credit_released = pcie0_s_axis_rq_tuser[169]; 
        assign pcie0_cq_np_user_credit_rcvd = pcie0_s_axis_rq_tuser[139]; 
        assign pcie0_posted_credit_released = pcie0_s_axis_rq_tuser[158]; 
        assign pcie0_compl_delivered_tag0 = pcie0_s_axis_rq_tuser[149:142]; 
        assign pcie0_compl_delivered_tag1 = pcie0_s_axis_rq_tuser[157:150]; 
        assign pcie0_nonposted_credit_released = pcie0_s_axis_rq_tuser[166]; 
        assign pcie0_posted_payload_credit_released_value = pcie0_s_axis_rq_tuser[165:159]; 
        assign pcie0_nonposted_payload_credit_released_value = pcie0_s_axis_rq_tuser[168:167]; 

      end
    end
    // Controller 1 MSI/MSIX ports
    if (C_CPM_PCIE1_PF0_MSI_ENABLED == 0) begin:C_CPM_PCIE1_MSIX_PORTS
      assign s_pcie1_cfg_msi_attr = pcie1_cfg_msix_attr; 
      assign s_pcie1_cfg_msi_tph_type = pcie1_cfg_msix_tph_type; 
      assign s_pcie1_cfg_msi_tph_st_tag = pcie1_cfg_msix_tph_st_tag; 
      assign s_pcie1_cfg_msi_int_vector = pcie1_cfg_msix_mint_vector; 
      assign s_pcie1_cfg_msi_tph_present = pcie1_cfg_msix_tph_present; 
      assign s_pcie1_cfg_msi_function_number = pcie1_cfg_msix_function_number; 
    end
    else
    begin:C_CPM_PCIE1_MSI_PORTS
      assign s_pcie1_cfg_msi_attr = pcie1_cfg_msi_attr; 
      assign s_pcie1_cfg_msi_tph_type = pcie1_cfg_msi_tph_type; 
      assign s_pcie1_cfg_msi_tph_st_tag = pcie1_cfg_msi_tph_st_tag; 
      assign s_pcie1_cfg_msi_int_vector = pcie1_cfg_msi_int_vector; 
      assign s_pcie1_cfg_msi_tph_present = pcie1_cfg_msi_tph_present; 
      assign s_pcie1_cfg_msi_function_number = pcie1_cfg_msi_function_number; 
    end

    assign pcie1_compl_header_credit_released_value = pcie1_cfg_interrupt_int[1:0]; 
    assign pcie1_compl_payload_credit_released_value = {1'b0,pcie1_cfg_interrupt_pending,pcie1_cfg_interrupt_int[3:2]}; 

    // Controller 1 signals assignment when AXI ST data width is 512 and PASID capability is enabled
    if ( C_CPM_PCIE1_AXISTEN_IF_WIDTH == 512) begin
      if ( C_CPM_PCIE1_PF0_PASID_CAP_ON == 1 ) begin
        assign s_pcie1_cfg_msg_transmit_data[30:29] = pcie1_s_axis_rq_tuser[182:181] ; // pasid_pmode_req[1:0]
        assign s_pcie1_cfg_msg_transmit_data[14:13] = pcie1_s_axis_rq_tuser[180:179] ; // pasid_exe_req[1:0]
        assign s_pcie1_cfg_err_cor_in               = pcie1_s_axis_rq_tuser[178]     ; // pasid[39]
        assign s_pcie1_cfg_interrupt_pending[3:0]   = pcie1_s_axis_rq_tuser[177:174] ; // pasid[38:35]
        assign s_pcie1_cfg_interrupt_int[3:2]       = pcie1_s_axis_rq_tuser[173:172] ; // pasid[34:33]
        assign s_pcie1_cfg_interrupt_int[1:0]       = pcie1_s_axis_rq_tuser[171:170] ; // pasid[32:31]
        assign s_pcie1_cfg_err_uncor_in             = pcie1_s_axis_rq_tuser[169]     ; // pasid[30]
        assign s_pcie1_cfg_msg_transmit_data[12:11] = pcie1_s_axis_rq_tuser[168:167] ; // pasid[29:26]
        assign s_pcie1_cfg_msg_transmit_data[10]    = pcie1_s_axis_rq_tuser[166]     ; // pasid[25]
        assign s_pcie1_cfg_msg_transmit_data[31]    = pcie1_s_axis_rq_tuser[165]     ; // pasid[24]
        assign s_pcie1_cfg_msg_transmit_data[28:23] = pcie1_s_axis_rq_tuser[164:159] ; // pasid[23:20]
        assign s_pcie1_cfg_msg_transmit_type[2]     = pcie1_s_axis_rq_tuser[158]     ; // pasid[19]
        assign s_pcie1_cfg_msg_transmit_data[22:15] = pcie1_s_axis_rq_tuser[157:150] ; // pasid[18:11]
        assign s_pcie1_cfg_msg_transmit_data[9:2]   = pcie1_s_axis_rq_tuser[149:142] ; // pasid[10:3]
        assign s_pcie1_cfg_msg_transmit_data[1:0]   = pcie1_s_axis_rq_tuser[141:140] ; // pasid[2:1]
        assign s_pcie1_cfg_msg_transmit_type[1]     = pcie1_s_axis_rq_tuser[139]     ; // pasid[0]
        assign s_pcie1_cfg_msg_transmit_type[0]     = pcie1_s_axis_rq_tuser[138]     ; // pasid_valid[1]
        assign s_pcie1_cfg_msg_transmit             = pcie1_s_axis_rq_tuser[137]     ; // pasid_valid[0]

        assign pcie1_compl_delivered = 'd0; 
        assign pcie1_cq_pipeline_empty = 'd0; 
        assign pcie1_posted_req_delivered = 'd0; 
        assign pcie1_compl_delivered_tag0 = 'd0; 
        assign pcie1_compl_delivered_tag1 = 'd0; 
        assign pcie1_compl_credit_released = 'd0; 
        assign pcie1_cq_np_user_credit_rcvd = 'd0; 
        assign pcie1_posted_credit_released = 'd0; 
        assign pcie1_nonposted_credit_released = 'd0; 
        assign pcie1_posted_payload_credit_released_value = 'd0; 
        assign pcie1_nonposted_payload_credit_released_value = 'd0; 

      end else begin

        assign s_pcie1_cfg_err_cor_in = pcie1_cfg_err_cor_in; 
        assign s_pcie1_cfg_err_uncor_in = pcie1_cfg_err_uncor_in; 
        assign s_pcie1_cfg_msg_transmit = pcie1_cfg_msg_transmit; 
        assign s_pcie1_cfg_interrupt_int = pcie1_cfg_interrupt_int; 
        assign s_pcie1_cfg_msg_transmit_data = pcie1_cfg_msg_transmit_data; 
        assign s_pcie1_cfg_msg_transmit_type = pcie1_cfg_msg_transmit_type; 
        assign s_pcie1_cfg_interrupt_pending = pcie1_cfg_interrupt_pending; 

        assign pcie1_cq_pipeline_empty = pcie1_s_axis_rq_tuser[138]; 
        assign pcie1_compl_delivered = pcie1_s_axis_rq_tuser[141:140]; 
        assign pcie1_posted_req_delivered = pcie1_s_axis_rq_tuser[137]; 
        assign pcie1_compl_credit_released = pcie1_s_axis_rq_tuser[169]; 
        assign pcie1_cq_np_user_credit_rcvd = pcie1_s_axis_rq_tuser[139]; 
        assign pcie1_posted_credit_released = pcie1_s_axis_rq_tuser[158]; 
        assign pcie1_compl_delivered_tag0 = pcie1_s_axis_rq_tuser[149:142]; 
        assign pcie1_compl_delivered_tag1 = pcie1_s_axis_rq_tuser[157:150]; 
        assign pcie1_nonposted_credit_released = pcie1_s_axis_rq_tuser[166]; 
        assign pcie1_posted_payload_credit_released_value = pcie1_s_axis_rq_tuser[165:159]; 
        assign pcie1_nonposted_payload_credit_released_value = pcie1_s_axis_rq_tuser[168:167]; 

      end
    end

  endgenerate


  assign pcie0_cfg_hot_reset_in_int = pcie0_cfg_hot_reset_in;

  assign pcie1_cfg_hot_reset_in_int = pcie1_cfg_hot_reset_in;

// --------------------------- CPM instance starts ------------------------------------

  CPM #(
    .CPM_MODE_0(C_CPM_PCIE0_MODE_FOR_POWER),
    .LINK_SPEED_0(C_CPM_PCIE0_LINK_SPEED_FOR_POWER),
    .LINK_WIDTH_0(C_CPM_PCIE0_LINK_WIDTH_FOR_POWER),

    .CPM_MODE_1(C_CPM_PCIE1_MODE_FOR_POWER),
    .LINK_SPEED_1(C_CPM_PCIE1_LINK_SPEED_FOR_POWER),
    .LINK_WIDTH_1(C_CPM_PCIE1_LINK_WIDTH_FOR_POWER),


    .PCI_CHANNELS(C_CPM_PCIE_CHANNELS_FOR_POWER),
    .SIM_CPM_CDO_FILE_NAME("bd_57a1_cpm_0_0_sim.cdo")
  ) CPM_INST (
    .CPMDPLLPCIE0USERCLK(),
    .IFCPMPCIEADPLLCPMDPLL0RSTN(),
    .IFCPMPCIEADPLLDPLL0CPMLOCKED(),
    
    .IFCPMPCIEA0CFGHPICFGEXTREADDATA(),
    .IFEXTPLPCIE0CFGHPOCFGEXTWRITEDATA(),
    .IFEXTPLPCIE0CFGHPOCFGEXTREADRECEIVED(),
    .IFCPMPCIEA0CFGHPICFGEXTREADDATAVALID(),
    .IFEXTPLPCIE0CFGHPOCFGEXTWRITERECEIVED(),
    .IFEXTPLPCIE0CFGHPOCFGEXTFUNCTIONNUMBER(),
    .IFEXTPLPCIE0CFGHPOCFGEXTREGISTERNUMBER(),
    .IFEXTPLPCIE0CFGHPOCFGEXTWRITEBYTEENABLE(),

    .IFPLEXTPCIE0AXIPCIECOMPLDELIVERED(),
    .IFPLEXTPCIE0AXIPCIECOMPLDELIVEREDTAG0(),
    .IFPLEXTPCIE0AXIPCIECOMPLDELIVEREDTAG1(),
    .IFPLEXTPCIE0AXIPCIEPOSTEDREQDELIVERED(),
    
    .IFPLEXTPCIE0AXITLRXCOMPLCREDITRELEASED(),
    .IFPLEXTPCIE0AXITLRXPOSTEDCREDITRELEASED(),
    .IFPLEXTPCIE0AXITLRXNONPOSTEDCREDITRELEASED(),
    .IFPLEXTPCIE0AXITLRXCOMPLHEADERCREDITRELEASEDVALUE(),
    .IFPLEXTPCIE0AXITLRXCOMPLPAYLOADCREDITRELEASEDVALUE(),
    .IFPLEXTPCIE0AXITLRXPOSTEDPAYLOADCREDITRELEASEDVALUE(),
    .IFPLEXTPCIE0AXITLRXNONPOSTEDPAYLOADCREDITRELEASEDVALUE(),
    
    .IFPLEXTPCIE0AXIPCIECQPIPELINEEMPTY(),
    .IFPLEXTPCIE0AXIPCIECQNPUSERCREDITRCVD(),

    .IFCPMPCIEA0CFGHPICFGERRCORIN(),
    .IFEXTPLPCIE0CFGHPOCFGERRCOROUT(),
    .IFCPMPCIEA0CFGHPICFGERRUNCORIN(),
    .IFEXTPLPCIE0CFGHPOCFGERRFATALOUT(),
    .IFEXTPLPCIE0CFGHPOCFGLOCALERROROUT(),
    .IFEXTPLPCIE0CFGHPOCFGERRNONFATALOUT(),
    .IFEXTPLPCIE0CFGHPOCFGLOCALERRORVALID(),

    .IFEXTPLPCIE0CFGHPOCFGFCPD(),
    .IFEXTPLPCIE0CFGHPOCFGFCPH(),
    .IFCPMPCIEA0CFGHPICFGFCSEL(),
    .IFEXTPLPCIE0CFGHPOCFGFCNPD(),
    .IFEXTPLPCIE0CFGHPOCFGFCNPH(),
    .IFEXTPLPCIE0CFGLPOCFGFCCPLD(),
    .IFEXTPLPCIE0CFGLPOCFGFCCPLH(),
    .IFCPMPCIEA0CFGHPICFGFCVCSEL(),
    .IFEXTPLPCIE0CFGHPOCFGFCPDSCALE(),
    .IFEXTPLPCIE0CFGHPOCFGFCPHSCALE(),
    .IFEXTPLPCIE0CFGHPOCFGFCNPDSCALE(),
    .IFEXTPLPCIE0CFGHPOCFGFCNPHSCALE(),
    .IFEXTPLPCIE0CFGLPOCFGFCCPLDSCALE(),
    .IFEXTPLPCIE0CFGLPOCFGFCCPLHSCALE(),

    .IFCPMPCIEA0CFGHPICFGMGMTADDR(),
    .IFCPMPCIEA0CFGHPICFGMGMTREAD(),
    .IFCPMPCIEA0CFGHPICFGMGMTWRITE(),
    .IFEXTPLPCIE0CFGHPOCFGMGMTREADDATA(),
    .IFCPMPCIEA0CFGHPICFGMGMTWRITEDATA(),
    .IFCPMPCIEA0CFGHPICFGMGMTBYTEENABLE(),
    .IFCPMPCIEA0CFGHPICFGMGMTDEBUGACCESS(),
    .IFCPMPCIEA0CFGHPICFGMGMTFUNCTIONNUMBER(),
    .IFEXTPLPCIE0CFGHPOCFGMGMTREADWRITEDONE(),

    .IFEXTPLPCIE0CFGLPOCFGMSGRECEIVED(),
    .IFEXTPLPCIE0CFGLPOCFGMSGRECEIVEDDATA(),
    .IFEXTPLPCIE0CFGLPOCFGMSGRECEIVEDTYPE(),
    
    .IFCPMPCIEA0CFGHPICFGMSGTRANSMIT(),
    .IFCPMPCIEA0CFGHPICFGMSGTRANSMITDATA(),
    .IFCPMPCIEA0CFGHPICFGMSGTRANSMITTYPE(),
    .IFEXTPLPCIE0CFGLPOCFGMSGTRANSMITDONE(),

    .IFCPMPCIEA0CFGHPICFGINTERRUPTMSIXINT(),
    .IFCPMPCIEA0CFGHPICFGINTERRUPTMSIXDATA(),
    .IFEXTPLPCIE0CFGLPOCFGINTERRUPTMSIXMASK(),
    .IFEXTPLPCIE0CFGLPOCFGINTERRUPTMSIXENABLE(),
    .IFCPMPCIEA0CFGHPICFGINTERRUPTMSIXADDRESS(),
    .IFCPMPCIEA0CFGHPICFGINTERRUPTMSIXVECPENDING(),
    .IFEXTPLPCIE0CFGLPOCFGINTERRUPTMSIXVECPENDINGSTATUS(),

    .IFCPMPCIEA0CFGHPICFGINTERRUPTMSIINT(),
    .IFCPMPCIEA0CFGHPICFGINTERRUPTMSIATTR(),
    .IFEXTPLPCIE0CFGLPOCFGINTERRUPTMSIDATA(),
    .IFEXTPLPCIE0CFGLPOCFGINTERRUPTMSIFAIL(),
    .IFEXTPLPCIE0CFGLPOCFGINTERRUPTMSISENT(),
    .IFCPMPCIEA0CFGHPICFGINTERRUPTMSISELECT(),
    .IFEXTPLPCIE0CFGLPOCFGINTERRUPTMSIENABLE(),
    .IFCPMPCIEA0CFGHPICFGINTERRUPTMSITPHTYPE(),
    .IFCPMPCIEA0CFGHPICFGINTERRUPTMSITPHSTTAG(),
    .IFEXTPLPCIE0CFGLPOCFGINTERRUPTMSIMMENABLE(),
    .IFCPMPCIEA0CFGHPICFGINTERRUPTMSITPHPRESENT(),
    .IFEXTPLPCIE0CFGLPOCFGINTERRUPTMSIMASKUPDATE(),
    .IFCPMPCIEA0CFGHPICFGINTERRUPTMSIPENDINGSTATUS(),
    .IFCPMPCIEA0CFGHPICFGINTERRUPTMSIFUNCTIONNUMBER(),
    .IFCPMPCIEA0CFGHPICFGINTERRUPTMSIPENDINGSTATUSDATAENABLE(),
    .IFCPMPCIEA0CFGHPICFGINTERRUPTMSIPENDINGSTATUSFUNCTIONNUM(),

    .IFEXTPLPCIE0CFGHPOCFGEDRENABLE(),
    .IFCPMPCIEA0CFGHPICFGCCIXEDRDATARATECHANGEACK(),
    .IFEXTPLPCIE0CFGHPOCFGCCIXEDRDATARATECHANGEREQ(),

    .IFPLEXTPCIE0AXIPCIECQNPREQ(),
    .IFCPMPCIEA0CFGHPICFGFLRDONE(),
    .IFEXTPLPCIE0CFGLPOCFGRCBSTATUS(),
    .IFEXTPLPCIE0CFGLPOCFGVC1ENABLE(),
    .IFEXTPLPCIE0CFGLPOCFGTPHSTMODE(),
    .IFCPMPCIEA0CFGHPICFGVFFLRDONE(),
    .IFCPMPCIEA0CFGHPICFGHOTRESETIN(),
    .IFEXTPLPCIE0CFGHPOCFGTXPMSTATE(),
    .IFEXTPLPCIE0CFGHPOCFGRXPMSTATE(),
    .IFPLEXTPCIE0AXIPCIECQNPREQCOUNT(),
    .IFEXTPLPCIE0CFGHPOCFGLTSSMSTATE(),
    .IFEXTPLPCIE0CFGLPOCFGMAXPAYLOAD(),
    .IFEXTPLPCIE0CFGLPOCFGMAXREADREQ(),
    .IFEXTPLPCIE0CFGHPOCFGPASIDENABLE(),
    .IFEXTPLPCIE0CFGHPOCFGHOTRESETOUT(),
    .IFCPMPCIEA0CFGHPICFGINTERRUPTINT(),
    .IFEXTPLPCIE0CFGHPOCFGPHYLINKDOWN(),
    .IFEXTPLPCIE0CFGHPOCFGCURRENTSPEED(),
    .IFCPMPCIEA0CFGHPICFGVFFLRFUNCNUM(),
    .IFEXTPLPCIE0CFGLPOCFGFLRINPROCESS(),
    .IFEXTPLPCIE0CFGLPOCFGEXTTAGENABLE(),
    .IFEXTPLPCIE0CFGHPOCFGINTERRUPTSENT(),
    .IFEXTPLPCIE0CFGHPOCFGPHYLINKSTATUS(),
    .IFEXTPLPCIE0CFGLPOCFGFUNCTIONSTATUS(),
    .IFEXTPLPCIE0CFGHPOCFGPLSTATUSCHANGE(),
    .IFEXTPLPCIE0CFGHPOCFGLINKPOWERSTATE(),
    .IFEXTPLPCIE0CFGHPOCFGNEGOTIATEDWIDTH(),
    .IFCPMPCIEA0CFGHPICFGINTERRUPTPENDING(),
    .IFEXTPLPCIE0CFGLPOCFGFUNCTIONPOWERSTATE(),
    .IFEXTPLPCIE0CFGLPOCFGTPHREQUESTERENABLE(),
    .IFCPMPCIEA0CFGHPICFGPOWERSTATECHANGEACK(),
    .IFEXTPLPCIE0CFGLPOCFGATOMICREQUESTERENABLE(),
    .IFEXTPLPCIE0CFGLPOCFGVC1NEGOTIATIONPENDING(),
    .IFEXTPLPCIE0CFGLPOCFG10BTAGREQUESTERENABLE(),
    .IFEXTPLPCIE0CFGHPOCFGPASIDPRIVILMODEENABLE(),
    .IFEXTPLPCIE0CFGHPOCFGPASIDEXECPERMISSIONENABLE(),
    .IFEXTPLPCIE0CFGHPOCFGPOWERSTATECHANGEINTERRUPT(),

    .IFPLEXTPCIE0AXIPCIERQTAG0(),
    .IFPLEXTPCIE0AXIPCIERQTAG1(),
    .IFPLEXTPCIE0AXIPCIERQTAGAV(),
    .IFPLEXTPCIE0AXIPCIETFCNPDAV(),
    .IFPLEXTPCIE0AXIPCIETFCNPHAV(),
    .IFPLEXTPCIE0AXIPCIERQSEQNUM0(),
    .IFPLEXTPCIE0AXIPCIERQSEQNUM1(),
    .IFPLEXTPCIE0AXIPCIERQTAGVLD0(),
    .IFPLEXTPCIE0AXIPCIERQTAGVLD1(),
    .IFPLEXTPCIE0AXIPCIERQSEQNUMVLD0(),
    .IFPLEXTPCIE0AXIPCIERQSEQNUMVLD1(),

    .IFEXTPLPCIE0UNIFIEDCQAXISAXISCQTDATA(),
    .IFEXTPLPCIE0UNIFIEDCQAXISAXISCQTKEEP(),
    .IFEXTPLPCIE0UNIFIEDCQAXISAXISCQTUSER(),
    .IFEXTPLPCIE0UNIFIEDCQAXISAXISPORT0CQTLAST(),
    .IFEXTPLPCIE0UNIFIEDCQAXISAXISPORT0RCTLAST(),
    .IFEXTPLPCIE0UNIFIEDCQAXISAXISPORT1CQTLAST(),
    .IFEXTPLPCIE0UNIFIEDCQAXISAXISPORT1RCTLAST(),
    .IFEXTPLPCIE0UNIFIEDCQAXISPCIEAXISPORT0CQVLD(),
    .IFEXTPLPCIE0UNIFIEDCQAXISPCIEAXISPORT0RCVLD(),
    .IFEXTPLPCIE0UNIFIEDCQAXISPCIEAXISPORT1CQVLD(),
    .IFEXTPLPCIE0UNIFIEDCQAXISPCIEAXISPORT1RCVLD(),
    .IFEXTPLPCIE0UNIFIEDCQAXISPCIEAXISPORT0CQCRDT(),
    .IFEXTPLPCIE0UNIFIEDCQAXISPCIEAXISPORT0RCCRDT(),
    .IFEXTPLPCIE0UNIFIEDCQAXISPCIEAXISPORT1CQCRDT(),
    .IFEXTPLPCIE0UNIFIEDCQAXISPCIEAXISPORT1RCCRDT(),

    .IFPCIE0PLCCAXISAXISCCTDATA(),
    .IFPCIE0PLCCAXISAXISCCTKEEP(),
    .IFPCIE0PLCCAXISAXISCCTLAST(),
    .IFPCIE0PLCCAXISAXISCCTUSER(),
    .IFPCIE0PLCCAXISAXISCCTVALID(),
    .IFPCIE0PLCCAXISAXISCCTREADY(),

    .IFPCIE0PLRQAXISAXISRQTDATA(),
    .IFPCIE0PLRQAXISAXISRQTKEEP(),
    .IFPCIE0PLRQAXISAXISRQTLAST(),
    .IFPCIE0PLRQAXISAXISRQTUSER(),
    .IFPCIE0PLRQAXISAXISRQTVALID(),
    .IFPCIE0PLRQAXISAXISRQTREADY(),

    .CPMDPLLPCIE1USERCLK(),
    .IFCPMPCIEADPLLCPMDPLL1RSTN(),
    .IFCPMPCIEADPLLDPLL1CPMLOCKED(),

    .IFPLEXTPCIE1AXIPCIECOMPLDELIVERED(),
    .IFPLEXTPCIE1AXIPCIECQPIPELINEEMPTY(),
    .IFPLEXTPCIE1AXIPCIECOMPLDELIVEREDTAG0(),
    .IFPLEXTPCIE1AXIPCIECOMPLDELIVEREDTAG1(),
    .IFPLEXTPCIE1AXIPCIEPOSTEDREQDELIVERED(),
    .IFPLEXTPCIE1AXIPCIECQNPUSERCREDITRCVD(),

    .IFCPMPCIEA1CFGHPICFGERRCORIN(),
    .IFEXTPLPCIE1CFGHPOCFGERRCOROUT(),
    .IFCPMPCIEA1CFGHPICFGERRUNCORIN(),
    .IFEXTPLPCIE1CFGHPOCFGERRFATALOUT(),
    .IFEXTPLPCIE1CFGHPOCFGLOCALERROROUT(),
    .IFEXTPLPCIE1CFGHPOCFGERRNONFATALOUT(),
    .IFEXTPLPCIE1CFGHPOCFGLOCALERRORVALID(),

    .IFCPMPCIEA1CFGHPICFGEXTREADDATA(),
    .IFEXTPLPCIE1CFGHPOCFGEXTWRITEDATA(),
    .IFEXTPLPCIE1CFGHPOCFGEXTREADRECEIVED(),
    .IFCPMPCIEA1CFGHPICFGEXTREADDATAVALID(),
    .IFEXTPLPCIE1CFGHPOCFGEXTWRITERECEIVED(),
    .IFEXTPLPCIE1CFGHPOCFGEXTREGISTERNUMBER(),
    .IFEXTPLPCIE1CFGHPOCFGEXTFUNCTIONNUMBER(),
    .IFEXTPLPCIE1CFGHPOCFGEXTWRITEBYTEENABLE(),

    .IFEXTPLPCIE1CFGHPOCFGFCPD(),
    .IFEXTPLPCIE1CFGHPOCFGFCPH(),
    .IFCPMPCIEA1CFGHPICFGFCSEL(),
    .IFEXTPLPCIE1CFGHPOCFGFCNPD(),
    .IFEXTPLPCIE1CFGHPOCFGFCNPH(),
    .IFCPMPCIEA1CFGHPICFGFCVCSEL(),
    .IFEXTPLPCIE1CFGHPOCFGFCPDSCALE(),
    .IFEXTPLPCIE1CFGHPOCFGFCPHSCALE(),
    .IFEXTPLPCIE1CFGHPOCFGFCNPDSCALE(),
    .IFEXTPLPCIE1CFGHPOCFGFCNPHSCALE(),

    .IFCPMPCIEA1CFGHPICFGMGMTADDR(),
    .IFCPMPCIEA1CFGHPICFGMGMTREAD(),
    .IFCPMPCIEA1CFGHPICFGMGMTWRITE(),
    .IFEXTPLPCIE1CFGHPOCFGMGMTREADDATA(),
    .IFCPMPCIEA1CFGHPICFGMGMTWRITEDATA(),
    .IFCPMPCIEA1CFGHPICFGMGMTBYTEENABLE(),
    .IFCPMPCIEA1CFGHPICFGMGMTDEBUGACCESS(),
    .IFCPMPCIEA1CFGHPICFGMGMTFUNCTIONNUMBER(),
    .IFEXTPLPCIE1CFGHPOCFGMGMTREADWRITEDONE(),

    .IFCPMPCIEA1CFGHPICFGMSGTRANSMIT(),
    .IFCPMPCIEA1CFGHPICFGMSGTRANSMITDATA(),
    .IFCPMPCIEA1CFGHPICFGMSGTRANSMITTYPE(),

    .IFCPMPCIEA1CFGHPICFGINTERRUPTMSIXDATA(),
    .IFCPMPCIEA1CFGHPICFGINTERRUPTMSIXINT(),
    .IFCPMPCIEA1CFGHPICFGINTERRUPTMSIXADDRESS(),
    .IFCPMPCIEA1CFGHPICFGINTERRUPTMSIXVECPENDING(),

    .IFCPMPCIEA1CFGHPICFGINTERRUPTMSIINT(),
    .IFCPMPCIEA1CFGHPICFGINTERRUPTMSIATTR(),
    .IFCPMPCIEA1CFGHPICFGINTERRUPTMSISELECT(),
    .IFCPMPCIEA1CFGHPICFGINTERRUPTMSITPHTYPE(),
    .IFCPMPCIEA1CFGHPICFGINTERRUPTMSITPHSTTAG(),
    .IFCPMPCIEA1CFGHPICFGINTERRUPTMSITPHPRESENT(),
    .IFCPMPCIEA1CFGHPICFGINTERRUPTMSIPENDINGSTATUS(),
    .IFCPMPCIEA1CFGHPICFGINTERRUPTMSIFUNCTIONNUMBER(),
    .IFCPMPCIEA1CFGHPICFGINTERRUPTMSIPENDINGSTATUSDATAENABLE(),
    .IFCPMPCIEA1CFGHPICFGINTERRUPTMSIPENDINGSTATUSFUNCTIONNUM(),

    .IFPLEXTPCIE1AXIPCIECQNPREQ(),
    .IFCPMPCIEA1CFGHPICFGFLRDONE(),
    .IFCPMPCIEA1CFGHPICFGVFFLRDONE(),
    .IFEXTPLPCIE1CFGHPOCFGRXPMSTATE(),
    .IFEXTPLPCIE1CFGHPOCFGTXPMSTATE(),
    .IFCPMPCIEA1CFGHPICFGHOTRESETIN(),
    .IFPLEXTPCIE1AXIPCIECQNPREQCOUNT(),
    .IFEXTPLPCIE1CFGHPOCFGLTSSMSTATE(),
    .IFEXTPLPCIE1CFGHPOCFGPASIDENABLE(),
    .IFEXTPLPCIE1CFGHPOCFGHOTRESETOUT(),
    .IFEXTPLPCIE1CFGHPOCFGPHYLINKDOWN(),
    .IFCPMPCIEA1CFGHPICFGVFFLRFUNCNUM(),
    .IFCPMPCIEA1CFGHPICFGINTERRUPTINT(),
    .IFEXTPLPCIE1CFGHPOCFGCURRENTSPEED(),
    .IFEXTPLPCIE1CFGHPOCFGINTERRUPTSENT(),
    .IFEXTPLPCIE1CFGHPOCFGPHYLINKSTATUS(),
    .IFEXTPLPCIE1CFGHPOCFGLINKPOWERSTATE(),
    .IFEXTPLPCIE1CFGHPOCFGPLSTATUSCHANGE(),
    .IFEXTPLPCIE1CFGHPOCFGNEGOTIATEDWIDTH(),
    .IFCPMPCIEA1CFGHPICFGINTERRUPTPENDING(),
    .IFCPMPCIEA1CFGHPICFGPOWERSTATECHANGEACK(),
    .IFEXTPLPCIE1CFGHPOCFGPASIDPRIVILMODEENABLE(),
    .IFEXTPLPCIE1CFGHPOCFGPASIDEXECPERMISSIONENABLE(),
    .IFEXTPLPCIE1CFGHPOCFGPOWERSTATECHANGEINTERRUPT(),

    .IFPLEXTPCIE1AXITLRXCOMPLCREDITRELEASED(),
    .IFPLEXTPCIE1AXITLRXCOMPLHEADERCREDITRELEASEDVALUE(),
    .IFPLEXTPCIE1AXITLRXCOMPLPAYLOADCREDITRELEASEDVALUE(),

    .IFEXTPLPCIE1CFGHPOCFGEDRENABLE(),
    .IFCPMPCIEA1CFGHPICFGCCIXEDRDATARATECHANGEACK(),
    .IFEXTPLPCIE1CFGHPOCFGCCIXEDRDATARATECHANGEREQ(),

    .IFPLEXTPCIE1AXITLRXPOSTEDCREDITRELEASED(),
    .IFPLEXTPCIE1AXITLRXNONPOSTEDCREDITRELEASED(),
    .IFPLEXTPCIE1AXITLRXPOSTEDPAYLOADCREDITRELEASEDVALUE(),
    .IFPLEXTPCIE1AXITLRXNONPOSTEDPAYLOADCREDITRELEASEDVALUE(),
    
    .IFPLEXTPCIE1AXIPCIERQTAG0(),
    .IFPLEXTPCIE1AXIPCIERQTAG1(),
    .IFPLEXTPCIE1AXIPCIERQTAGAV(),
    .IFPLEXTPCIE1AXIPCIETFCNPDAV(),
    .IFPLEXTPCIE1AXIPCIETFCNPHAV(),
    .IFPLEXTPCIE1AXIPCIERQTAGVLD0(),
    .IFPLEXTPCIE1AXIPCIERQTAGVLD1(),
    .IFPLEXTPCIE1AXIPCIERQSEQNUM0(),
    .IFPLEXTPCIE1AXIPCIERQSEQNUM1(),
    .IFPLEXTPCIE1AXIPCIERQSEQNUMVLD0(),
    .IFPLEXTPCIE1AXIPCIERQSEQNUMVLD1(),

    .IFEXTPLPCIE1UNIFIEDCQAXISAXISCQTDATA(),
    .IFEXTPLPCIE1UNIFIEDCQAXISAXISCQTKEEP(),
    .IFEXTPLPCIE1UNIFIEDCQAXISAXISCQTUSER(),
    .IFEXTPLPCIE1UNIFIEDCQAXISAXISPORT0CQTLAST(),
    .IFEXTPLPCIE1UNIFIEDCQAXISAXISPORT0RCTLAST(),
    .IFEXTPLPCIE1UNIFIEDCQAXISAXISPORT1CQTLAST(),
    .IFEXTPLPCIE1UNIFIEDCQAXISAXISPORT1RCTLAST(),
    .IFEXTPLPCIE1UNIFIEDCQAXISPCIEAXISPORT0CQVLD(),
    .IFEXTPLPCIE1UNIFIEDCQAXISPCIEAXISPORT0RCVLD(),
    .IFEXTPLPCIE1UNIFIEDCQAXISPCIEAXISPORT1CQVLD(),
    .IFEXTPLPCIE1UNIFIEDCQAXISPCIEAXISPORT1RCVLD(),
    .IFEXTPLPCIE1UNIFIEDCQAXISPCIEAXISPORT0CQCRDT(),
    .IFEXTPLPCIE1UNIFIEDCQAXISPCIEAXISPORT0RCCRDT(),
    .IFEXTPLPCIE1UNIFIEDCQAXISPCIEAXISPORT1CQCRDT(),
    .IFEXTPLPCIE1UNIFIEDCQAXISPCIEAXISPORT1RCCRDT(),

    .IFPCIE1PLCCAXISAXISCCTDATA(),
    .IFPCIE1PLCCAXISAXISCCTKEEP(),
    .IFPCIE1PLCCAXISAXISCCTLAST(),
    .IFPCIE1PLCCAXISAXISCCTUSER(),
    .IFPCIE1PLCCAXISAXISCCTVALID(),
    .IFPCIE1PLCCAXISAXISCCTREADY(),

    .IFPCIE1PLRQAXISAXISRQTDATA(),
    .IFPCIE1PLRQAXISAXISRQTKEEP(),
    .IFPCIE1PLRQAXISAXISRQTLAST(),
    .IFPCIE1PLRQAXISAXISRQTUSER(),
    .IFPCIE1PLRQAXISAXISRQTVALID(),
    .IFPCIE1PLRQAXISAXISRQTREADY(),

    .PLCHI0CLK(),
    .IFPLCPMP0CHIREQFLIT(),
    .IFPLCPMP0CHISNPFLIT(),
    .IFPLCPMP0CHICRSPFLIT(),
    .IFPLCPMP0CHIMSACTIVE(),
    .IFPLCPMP0CHIRDATFLIT(),
    .IFPLCPMP0CHIREQFLITV(),
    .IFPLCPMP0CHIREQLCRDV(),
    .IFPLCPMP0CHISNPFLITV(),
    .IFPLCPMP0CHISNPLCRDV(),
    .IFPLCPMP0CHISRSPFLIT(),
    .IFPLCPMP0CHISSACTIVE(),
    .IFPLCPMP0CHISYSCOACK(),
    .IFPLCPMP0CHISYSCOREQ(),
    .IFPLCPMP0CHIWDATFLIT(),
    .IFPLCPMP0CHICRSPFLITV(),
    .IFPLCPMP0CHICRSPLCRDV(),
    .IFPLCPMP0CHIRDATFLITV(),
    .IFPLCPMP0CHIRDATLCRDV(),
    .IFPLCPMP0CHISRSPFLITV(),
    .IFPLCPMP0CHISRSPLCRDV(),
    .IFPLCPMP0CHIWDATFLITV(),
    .IFPLCPMP0CHIWDATLCRDV(),
    .IFPLCPMP0CHIREQFLITPEND(),
    .IFPLCPMP0CHISNPFLITPEND(),
    .IFPLCPMP0CHICRSPFLITPEND(),
    .IFPLCPMP0CHIRDATFLITPEND(),
    .IFPLCPMP0CHISRSPFLITPEND(),
    .IFPLCPMP0CHIWDATFLITPEND(),
    .IFPLCPMP0CHIMLINKACTIVEACK(),
    .IFPLCPMP0CHIMLINKACTIVEREQ(),
    .IFPLCPMP0CHISLINKACTIVEACK(),
    .IFPLCPMP0CHISLINKACTIVEREQ(),

    .PLCHI1CLK(),
    .IFPLCPMP1CHIREQFLIT(),
    .IFPLCPMP1CHISNPFLIT(),
    .IFPLCPMP1CHICRSPFLIT(),
    .IFPLCPMP1CHIMSACTIVE(),
    .IFPLCPMP1CHIRDATFLIT(),
    .IFPLCPMP1CHIREQFLITV(),
    .IFPLCPMP1CHIREQLCRDV(),
    .IFPLCPMP1CHISNPFLITV(),
    .IFPLCPMP1CHISNPLCRDV(),
    .IFPLCPMP1CHISRSPFLIT(),
    .IFPLCPMP1CHISSACTIVE(),
    .IFPLCPMP1CHISYSCOACK(),
    .IFPLCPMP1CHISYSCOREQ(),
    .IFPLCPMP1CHIWDATFLIT(),
    .IFPLCPMP1CHICRSPFLITV(),
    .IFPLCPMP1CHICRSPLCRDV(),
    .IFPLCPMP1CHIRDATFLITV(),
    .IFPLCPMP1CHIRDATLCRDV(),
    .IFPLCPMP1CHISRSPFLITV(),
    .IFPLCPMP1CHISRSPLCRDV(),
    .IFPLCPMP1CHIWDATFLITV(),
    .IFPLCPMP1CHIWDATLCRDV(),
    .IFPLCPMP1CHIREQFLITPEND(),
    .IFPLCPMP1CHISNPFLITPEND(),
    .IFPLCPMP1CHICRSPFLITPEND(),
    .IFPLCPMP1CHIRDATFLITPEND(),
    .IFPLCPMP1CHISRSPFLITPEND(),
    .IFPLCPMP1CHIWDATFLITPEND(),
    .IFPLCPMP1CHIMLINKACTIVEACK(),
    .IFPLCPMP1CHIMLINKACTIVEREQ(),
    .IFPLCPMP1CHISLINKACTIVEACK(),
    .IFPLCPMP1CHISLINKACTIVEREQ(),
     // CPM XPIPE channel 0
    .IFCPMXPIPECHANNEL0XPIPERXDATA(cpm_xpipe_ch0_rxdata),
    .IFCPMXPIPECHANNEL0XPIPETXDATA(cpm_xpipe_ch0_txdata),
    .IFCPMXPIPECHANNEL0XPIPERXVALID(cpm_xpipe_ch0_rxvalid),
    .IFCPMXPIPECHANNEL0XPIPETXSWING(cpm_xpipe_ch0_txswing),
    .IFCPMXPIPECHANNEL0XPIPERXSTATUS(cpm_xpipe_ch0_rxstatus),
    .IFCPMXPIPECHANNEL0XPIPETXDEEMPH(cpm_xpipe_ch0_txdeemph),
    .IFCPMXPIPECHANNEL0XPIPETXMARGIN(cpm_xpipe_ch0_txmargin),
    .IFCPMXPIPECHANNEL0XPIPEPHYSTATUS(cpm_xpipe_ch0_phystatus),
    .IFCPMXPIPECHANNEL0XPIPEPOWERDOWN(cpm_xpipe_ch0_powerdown),
    .IFCPMXPIPECHANNEL0XPIPERXCHARISK(cpm_xpipe_ch0_rxcharisk),
    .IFCPMXPIPECHANNEL0XPIPETXCHARISK(cpm_xpipe_ch0_txcharisk),
    .IFCPMXPIPECHANNEL0XPIPERXELECIDLE(cpm_xpipe_ch0_rxelecidle),
    .IFCPMXPIPECHANNEL0XPIPERXPOLARITY(cpm_xpipe_ch0_rxpolarity),
    .IFCPMXPIPECHANNEL0XPIPETXELECIDLE(cpm_xpipe_ch0_txelecidle),
    .IFCPMXPIPECHANNEL0XPIPERXDATAVALID(cpm_xpipe_ch0_rxdatavalid),
    .IFCPMXPIPECHANNEL0XPIPETXDATAVALID(cpm_xpipe_ch0_txdatavalid),
    .IFCPMXPIPECHANNEL0XPIPETXPRECURSOR(cpm_xpipe_ch0_txprecursor),
    .IFCPMXPIPECHANNEL0XPIPERXSTARTBLOCK(cpm_xpipe_ch0_rxstartblock),
    .IFCPMXPIPECHANNEL0XPIPERXSYNCHEADER(cpm_xpipe_ch0_rxsyncheader),
    .IFCPMXPIPECHANNEL0XPIPETXCOMPLIANCE(cpm_xpipe_ch0_txcompliance),
    .IFCPMXPIPECHANNEL0XPIPETXMAINCURSOR(cpm_xpipe_ch0_txmaincursor),
    .IFCPMXPIPECHANNEL0XPIPETXPOSTCURSOR(cpm_xpipe_ch0_txpostcursor),
    .IFCPMXPIPECHANNEL0XPIPETXSTARTBLOCK(cpm_xpipe_ch0_txstartblock),
    .IFCPMXPIPECHANNEL0XPIPETXSYNCHEADER(cpm_xpipe_ch0_txsyncheader),
    .IFCPMXPIPECHANNEL0XPIPERXTERMINATION(cpm_xpipe_ch0_rxtermination),
    .IFCPMXPIPECHANNEL0XPIPETXDETECTRXLOOPBACK(cpm_xpipe_ch0_txdetectrxloopback),

     // PS XPIPE channel 0
    .IFPSCPMCHANNEL0XPIPERXDATA(xpipe0_rx_data),
    .IFPSCPMCHANNEL0XPIPETXDATA(xpipe0_tx_data),
    .IFPSCPMCHANNEL0XPIPERXVALID(xpipe0_rx_valid),
    .IFPSCPMCHANNEL0XPIPETXSWING(xpipe0_tx_swing),
    .IFPSCPMCHANNEL0XPIPERXSTATUS(xpipe0_rx_status),
    .IFPSCPMCHANNEL0XPIPETXDEEMPH(xpipe0_tx_deemph),
    .IFPSCPMCHANNEL0XPIPETXMARGIN(xpipe0_tx_margin),
    .IFPSCPMCHANNEL0XPIPEPHYSTATUS(xpipe0_phystatus),
    .IFPSCPMCHANNEL0XPIPEPOWERDOWN(xpipe0_powerdown),
    .IFPSCPMCHANNEL0XPIPERXCHARISK(xpipe0_rx_charisk),
    .IFPSCPMCHANNEL0XPIPETXCHARISK(xpipe0_tx_charisk),
    .IFPSCPMCHANNEL0XPIPERXELECIDLE(xpipe0_rx_elecidle),
    .IFPSCPMCHANNEL0XPIPERXPOLARITY(xpipe0_rx_polarity),
    .IFPSCPMCHANNEL0XPIPETXELECIDLE(xpipe0_tx_elecidle),
    .IFPSCPMCHANNEL0XPIPERXDATAVALID(xpipe0_rx_datavalid),
    .IFPSCPMCHANNEL0XPIPETXDATAVALID(xpipe0_tx_datavalid),
    .IFPSCPMCHANNEL0XPIPETXPRECURSOR(xpipe0_tx_precursor),
    .IFPSCPMCHANNEL0XPIPERXSTARTBLOCK(xpipe0_rx_startblock),
    .IFPSCPMCHANNEL0XPIPERXSYNCHEADER(xpipe0_rx_syncheader),
    .IFPSCPMCHANNEL0XPIPETXCOMPLIANCE(xpipe0_tx_compliance),
    .IFPSCPMCHANNEL0XPIPETXMAINCURSOR(xpipe0_tx_maincursor),
    .IFPSCPMCHANNEL0XPIPETXPOSTCURSOR(xpipe0_tx_postcursor),
    .IFPSCPMCHANNEL0XPIPETXSTARTBLOCK(xpipe0_tx_startblock),
    .IFPSCPMCHANNEL0XPIPETXSYNCHEADER(xpipe0_tx_syncheader),
    .IFPSCPMCHANNEL0XPIPERXTERMINATION(xpipe0_rx_termination),
    .IFPSCPMCHANNEL0XPIPETXDETECTRXLOOPBACK(xpipe0_tx_detectrxloopback),
     // CPM XPIPE channel 1
    .IFCPMXPIPECHANNEL1XPIPERXDATA(cpm_xpipe_ch1_rxdata),
    .IFCPMXPIPECHANNEL1XPIPETXDATA(cpm_xpipe_ch1_txdata),
    .IFCPMXPIPECHANNEL1XPIPERXVALID(cpm_xpipe_ch1_rxvalid),
    .IFCPMXPIPECHANNEL1XPIPETXSWING(cpm_xpipe_ch1_txswing),
    .IFCPMXPIPECHANNEL1XPIPERXSTATUS(cpm_xpipe_ch1_rxstatus),
    .IFCPMXPIPECHANNEL1XPIPETXDEEMPH(cpm_xpipe_ch1_txdeemph),
    .IFCPMXPIPECHANNEL1XPIPETXMARGIN(cpm_xpipe_ch1_txmargin),
    .IFCPMXPIPECHANNEL1XPIPEPHYSTATUS(cpm_xpipe_ch1_phystatus),
    .IFCPMXPIPECHANNEL1XPIPEPOWERDOWN(cpm_xpipe_ch1_powerdown),
    .IFCPMXPIPECHANNEL1XPIPERXCHARISK(cpm_xpipe_ch1_rxcharisk),
    .IFCPMXPIPECHANNEL1XPIPETXCHARISK(cpm_xpipe_ch1_txcharisk),
    .IFCPMXPIPECHANNEL1XPIPERXELECIDLE(cpm_xpipe_ch1_rxelecidle),
    .IFCPMXPIPECHANNEL1XPIPERXPOLARITY(cpm_xpipe_ch1_rxpolarity),
    .IFCPMXPIPECHANNEL1XPIPETXELECIDLE(cpm_xpipe_ch1_txelecidle),
    .IFCPMXPIPECHANNEL1XPIPERXDATAVALID(cpm_xpipe_ch1_rxdatavalid),
    .IFCPMXPIPECHANNEL1XPIPETXDATAVALID(cpm_xpipe_ch1_txdatavalid),
    .IFCPMXPIPECHANNEL1XPIPETXPRECURSOR(cpm_xpipe_ch1_txprecursor),
    .IFCPMXPIPECHANNEL1XPIPERXSTARTBLOCK(cpm_xpipe_ch1_rxstartblock),
    .IFCPMXPIPECHANNEL1XPIPERXSYNCHEADER(cpm_xpipe_ch1_rxsyncheader),
    .IFCPMXPIPECHANNEL1XPIPETXCOMPLIANCE(cpm_xpipe_ch1_txcompliance),
    .IFCPMXPIPECHANNEL1XPIPETXMAINCURSOR(cpm_xpipe_ch1_txmaincursor),
    .IFCPMXPIPECHANNEL1XPIPETXPOSTCURSOR(cpm_xpipe_ch1_txpostcursor),
    .IFCPMXPIPECHANNEL1XPIPETXSTARTBLOCK(cpm_xpipe_ch1_txstartblock),
    .IFCPMXPIPECHANNEL1XPIPETXSYNCHEADER(cpm_xpipe_ch1_txsyncheader),
    .IFCPMXPIPECHANNEL1XPIPERXTERMINATION(cpm_xpipe_ch1_rxtermination),
    .IFCPMXPIPECHANNEL1XPIPETXDETECTRXLOOPBACK(cpm_xpipe_ch1_txdetectrxloopback),

     // PS XPIPE channel 1
    .IFPSCPMCHANNEL1XPIPERXDATA(xpipe1_rx_data),
    .IFPSCPMCHANNEL1XPIPETXDATA(xpipe1_tx_data),
    .IFPSCPMCHANNEL1XPIPERXVALID(xpipe1_rx_valid),
    .IFPSCPMCHANNEL1XPIPETXSWING(xpipe1_tx_swing),
    .IFPSCPMCHANNEL1XPIPERXSTATUS(xpipe1_rx_status),
    .IFPSCPMCHANNEL1XPIPETXDEEMPH(xpipe1_tx_deemph),
    .IFPSCPMCHANNEL1XPIPETXMARGIN(xpipe1_tx_margin),
    .IFPSCPMCHANNEL1XPIPEPHYSTATUS(xpipe1_phystatus),
    .IFPSCPMCHANNEL1XPIPEPOWERDOWN(xpipe1_powerdown),
    .IFPSCPMCHANNEL1XPIPERXCHARISK(xpipe1_rx_charisk),
    .IFPSCPMCHANNEL1XPIPETXCHARISK(xpipe1_tx_charisk),
    .IFPSCPMCHANNEL1XPIPERXELECIDLE(xpipe1_rx_elecidle),
    .IFPSCPMCHANNEL1XPIPERXPOLARITY(xpipe1_rx_polarity),
    .IFPSCPMCHANNEL1XPIPETXELECIDLE(xpipe1_tx_elecidle),
    .IFPSCPMCHANNEL1XPIPERXDATAVALID(xpipe1_rx_datavalid),
    .IFPSCPMCHANNEL1XPIPETXDATAVALID(xpipe1_tx_datavalid),
    .IFPSCPMCHANNEL1XPIPETXPRECURSOR(xpipe1_tx_precursor),
    .IFPSCPMCHANNEL1XPIPERXSTARTBLOCK(xpipe1_rx_startblock),
    .IFPSCPMCHANNEL1XPIPERXSYNCHEADER(xpipe1_rx_syncheader),
    .IFPSCPMCHANNEL1XPIPETXCOMPLIANCE(xpipe1_tx_compliance),
    .IFPSCPMCHANNEL1XPIPETXMAINCURSOR(xpipe1_tx_maincursor),
    .IFPSCPMCHANNEL1XPIPETXPOSTCURSOR(xpipe1_tx_postcursor),
    .IFPSCPMCHANNEL1XPIPETXSTARTBLOCK(xpipe1_tx_startblock),
    .IFPSCPMCHANNEL1XPIPETXSYNCHEADER(xpipe1_tx_syncheader),
    .IFPSCPMCHANNEL1XPIPERXTERMINATION(xpipe1_rx_termination),
    .IFPSCPMCHANNEL1XPIPETXDETECTRXLOOPBACK(xpipe1_tx_detectrxloopback),
     // CPM XPIPE channel 2
    .IFCPMXPIPECHANNEL2XPIPERXDATA(cpm_xpipe_ch2_rxdata),
    .IFCPMXPIPECHANNEL2XPIPETXDATA(cpm_xpipe_ch2_txdata),
    .IFCPMXPIPECHANNEL2XPIPERXVALID(cpm_xpipe_ch2_rxvalid),
    .IFCPMXPIPECHANNEL2XPIPETXSWING(cpm_xpipe_ch2_txswing),
    .IFCPMXPIPECHANNEL2XPIPERXSTATUS(cpm_xpipe_ch2_rxstatus),
    .IFCPMXPIPECHANNEL2XPIPETXDEEMPH(cpm_xpipe_ch2_txdeemph),
    .IFCPMXPIPECHANNEL2XPIPETXMARGIN(cpm_xpipe_ch2_txmargin),
    .IFCPMXPIPECHANNEL2XPIPEPHYSTATUS(cpm_xpipe_ch2_phystatus),
    .IFCPMXPIPECHANNEL2XPIPEPOWERDOWN(cpm_xpipe_ch2_powerdown),
    .IFCPMXPIPECHANNEL2XPIPERXCHARISK(cpm_xpipe_ch2_rxcharisk),
    .IFCPMXPIPECHANNEL2XPIPETXCHARISK(cpm_xpipe_ch2_txcharisk),
    .IFCPMXPIPECHANNEL2XPIPERXELECIDLE(cpm_xpipe_ch2_rxelecidle),
    .IFCPMXPIPECHANNEL2XPIPERXPOLARITY(cpm_xpipe_ch2_rxpolarity),
    .IFCPMXPIPECHANNEL2XPIPETXELECIDLE(cpm_xpipe_ch2_txelecidle),
    .IFCPMXPIPECHANNEL2XPIPERXDATAVALID(cpm_xpipe_ch2_rxdatavalid),
    .IFCPMXPIPECHANNEL2XPIPETXDATAVALID(cpm_xpipe_ch2_txdatavalid),
    .IFCPMXPIPECHANNEL2XPIPETXPRECURSOR(cpm_xpipe_ch2_txprecursor),
    .IFCPMXPIPECHANNEL2XPIPERXSTARTBLOCK(cpm_xpipe_ch2_rxstartblock),
    .IFCPMXPIPECHANNEL2XPIPERXSYNCHEADER(cpm_xpipe_ch2_rxsyncheader),
    .IFCPMXPIPECHANNEL2XPIPETXCOMPLIANCE(cpm_xpipe_ch2_txcompliance),
    .IFCPMXPIPECHANNEL2XPIPETXMAINCURSOR(cpm_xpipe_ch2_txmaincursor),
    .IFCPMXPIPECHANNEL2XPIPETXPOSTCURSOR(cpm_xpipe_ch2_txpostcursor),
    .IFCPMXPIPECHANNEL2XPIPETXSTARTBLOCK(cpm_xpipe_ch2_txstartblock),
    .IFCPMXPIPECHANNEL2XPIPETXSYNCHEADER(cpm_xpipe_ch2_txsyncheader),
    .IFCPMXPIPECHANNEL2XPIPERXTERMINATION(cpm_xpipe_ch2_rxtermination),
    .IFCPMXPIPECHANNEL2XPIPETXDETECTRXLOOPBACK(cpm_xpipe_ch2_txdetectrxloopback),

     // PS XPIPE channel 2
    .IFPSCPMCHANNEL2XPIPERXDATA(xpipe2_rx_data),
    .IFPSCPMCHANNEL2XPIPETXDATA(xpipe2_tx_data),
    .IFPSCPMCHANNEL2XPIPERXVALID(xpipe2_rx_valid),
    .IFPSCPMCHANNEL2XPIPETXSWING(xpipe2_tx_swing),
    .IFPSCPMCHANNEL2XPIPERXSTATUS(xpipe2_rx_status),
    .IFPSCPMCHANNEL2XPIPETXDEEMPH(xpipe2_tx_deemph),
    .IFPSCPMCHANNEL2XPIPETXMARGIN(xpipe2_tx_margin),
    .IFPSCPMCHANNEL2XPIPEPHYSTATUS(xpipe2_phystatus),
    .IFPSCPMCHANNEL2XPIPEPOWERDOWN(xpipe2_powerdown),
    .IFPSCPMCHANNEL2XPIPERXCHARISK(xpipe2_rx_charisk),
    .IFPSCPMCHANNEL2XPIPETXCHARISK(xpipe2_tx_charisk),
    .IFPSCPMCHANNEL2XPIPERXELECIDLE(xpipe2_rx_elecidle),
    .IFPSCPMCHANNEL2XPIPERXPOLARITY(xpipe2_rx_polarity),
    .IFPSCPMCHANNEL2XPIPETXELECIDLE(xpipe2_tx_elecidle),
    .IFPSCPMCHANNEL2XPIPERXDATAVALID(xpipe2_rx_datavalid),
    .IFPSCPMCHANNEL2XPIPETXDATAVALID(xpipe2_tx_datavalid),
    .IFPSCPMCHANNEL2XPIPETXPRECURSOR(xpipe2_tx_precursor),
    .IFPSCPMCHANNEL2XPIPERXSTARTBLOCK(xpipe2_rx_startblock),
    .IFPSCPMCHANNEL2XPIPERXSYNCHEADER(xpipe2_rx_syncheader),
    .IFPSCPMCHANNEL2XPIPETXCOMPLIANCE(xpipe2_tx_compliance),
    .IFPSCPMCHANNEL2XPIPETXMAINCURSOR(xpipe2_tx_maincursor),
    .IFPSCPMCHANNEL2XPIPETXPOSTCURSOR(xpipe2_tx_postcursor),
    .IFPSCPMCHANNEL2XPIPETXSTARTBLOCK(xpipe2_tx_startblock),
    .IFPSCPMCHANNEL2XPIPETXSYNCHEADER(xpipe2_tx_syncheader),
    .IFPSCPMCHANNEL2XPIPERXTERMINATION(xpipe2_rx_termination),
    .IFPSCPMCHANNEL2XPIPETXDETECTRXLOOPBACK(xpipe2_tx_detectrxloopback),
     // CPM XPIPE channel 3
    .IFCPMXPIPECHANNEL3XPIPERXDATA(cpm_xpipe_ch3_rxdata),
    .IFCPMXPIPECHANNEL3XPIPETXDATA(cpm_xpipe_ch3_txdata),
    .IFCPMXPIPECHANNEL3XPIPERXVALID(cpm_xpipe_ch3_rxvalid),
    .IFCPMXPIPECHANNEL3XPIPETXSWING(cpm_xpipe_ch3_txswing),
    .IFCPMXPIPECHANNEL3XPIPERXSTATUS(cpm_xpipe_ch3_rxstatus),
    .IFCPMXPIPECHANNEL3XPIPETXDEEMPH(cpm_xpipe_ch3_txdeemph),
    .IFCPMXPIPECHANNEL3XPIPETXMARGIN(cpm_xpipe_ch3_txmargin),
    .IFCPMXPIPECHANNEL3XPIPEPHYSTATUS(cpm_xpipe_ch3_phystatus),
    .IFCPMXPIPECHANNEL3XPIPEPOWERDOWN(cpm_xpipe_ch3_powerdown),
    .IFCPMXPIPECHANNEL3XPIPERXCHARISK(cpm_xpipe_ch3_rxcharisk),
    .IFCPMXPIPECHANNEL3XPIPETXCHARISK(cpm_xpipe_ch3_txcharisk),
    .IFCPMXPIPECHANNEL3XPIPERXELECIDLE(cpm_xpipe_ch3_rxelecidle),
    .IFCPMXPIPECHANNEL3XPIPERXPOLARITY(cpm_xpipe_ch3_rxpolarity),
    .IFCPMXPIPECHANNEL3XPIPETXELECIDLE(cpm_xpipe_ch3_txelecidle),
    .IFCPMXPIPECHANNEL3XPIPERXDATAVALID(cpm_xpipe_ch3_rxdatavalid),
    .IFCPMXPIPECHANNEL3XPIPETXDATAVALID(cpm_xpipe_ch3_txdatavalid),
    .IFCPMXPIPECHANNEL3XPIPETXPRECURSOR(cpm_xpipe_ch3_txprecursor),
    .IFCPMXPIPECHANNEL3XPIPERXSTARTBLOCK(cpm_xpipe_ch3_rxstartblock),
    .IFCPMXPIPECHANNEL3XPIPERXSYNCHEADER(cpm_xpipe_ch3_rxsyncheader),
    .IFCPMXPIPECHANNEL3XPIPETXCOMPLIANCE(cpm_xpipe_ch3_txcompliance),
    .IFCPMXPIPECHANNEL3XPIPETXMAINCURSOR(cpm_xpipe_ch3_txmaincursor),
    .IFCPMXPIPECHANNEL3XPIPETXPOSTCURSOR(cpm_xpipe_ch3_txpostcursor),
    .IFCPMXPIPECHANNEL3XPIPETXSTARTBLOCK(cpm_xpipe_ch3_txstartblock),
    .IFCPMXPIPECHANNEL3XPIPETXSYNCHEADER(cpm_xpipe_ch3_txsyncheader),
    .IFCPMXPIPECHANNEL3XPIPERXTERMINATION(cpm_xpipe_ch3_rxtermination),
    .IFCPMXPIPECHANNEL3XPIPETXDETECTRXLOOPBACK(cpm_xpipe_ch3_txdetectrxloopback),

     // PS XPIPE channel 3
    .IFPSCPMCHANNEL3XPIPERXDATA(xpipe3_rx_data),
    .IFPSCPMCHANNEL3XPIPETXDATA(xpipe3_tx_data),
    .IFPSCPMCHANNEL3XPIPERXVALID(xpipe3_rx_valid),
    .IFPSCPMCHANNEL3XPIPETXSWING(xpipe3_tx_swing),
    .IFPSCPMCHANNEL3XPIPERXSTATUS(xpipe3_rx_status),
    .IFPSCPMCHANNEL3XPIPETXDEEMPH(xpipe3_tx_deemph),
    .IFPSCPMCHANNEL3XPIPETXMARGIN(xpipe3_tx_margin),
    .IFPSCPMCHANNEL3XPIPEPHYSTATUS(xpipe3_phystatus),
    .IFPSCPMCHANNEL3XPIPEPOWERDOWN(xpipe3_powerdown),
    .IFPSCPMCHANNEL3XPIPERXCHARISK(xpipe3_rx_charisk),
    .IFPSCPMCHANNEL3XPIPETXCHARISK(xpipe3_tx_charisk),
    .IFPSCPMCHANNEL3XPIPERXELECIDLE(xpipe3_rx_elecidle),
    .IFPSCPMCHANNEL3XPIPERXPOLARITY(xpipe3_rx_polarity),
    .IFPSCPMCHANNEL3XPIPETXELECIDLE(xpipe3_tx_elecidle),
    .IFPSCPMCHANNEL3XPIPERXDATAVALID(xpipe3_rx_datavalid),
    .IFPSCPMCHANNEL3XPIPETXDATAVALID(xpipe3_tx_datavalid),
    .IFPSCPMCHANNEL3XPIPETXPRECURSOR(xpipe3_tx_precursor),
    .IFPSCPMCHANNEL3XPIPERXSTARTBLOCK(xpipe3_rx_startblock),
    .IFPSCPMCHANNEL3XPIPERXSYNCHEADER(xpipe3_rx_syncheader),
    .IFPSCPMCHANNEL3XPIPETXCOMPLIANCE(xpipe3_tx_compliance),
    .IFPSCPMCHANNEL3XPIPETXMAINCURSOR(xpipe3_tx_maincursor),
    .IFPSCPMCHANNEL3XPIPETXPOSTCURSOR(xpipe3_tx_postcursor),
    .IFPSCPMCHANNEL3XPIPETXSTARTBLOCK(xpipe3_tx_startblock),
    .IFPSCPMCHANNEL3XPIPETXSYNCHEADER(xpipe3_tx_syncheader),
    .IFPSCPMCHANNEL3XPIPERXTERMINATION(xpipe3_rx_termination),
    .IFPSCPMCHANNEL3XPIPETXDETECTRXLOOPBACK(xpipe3_tx_detectrxloopback),
     // CPM XPIPE channel 4
    .IFCPMXPIPECHANNEL4XPIPERXDATA(cpm_xpipe_ch4_rxdata),
    .IFCPMXPIPECHANNEL4XPIPETXDATA(cpm_xpipe_ch4_txdata),
    .IFCPMXPIPECHANNEL4XPIPERXVALID(cpm_xpipe_ch4_rxvalid),
    .IFCPMXPIPECHANNEL4XPIPETXSWING(cpm_xpipe_ch4_txswing),
    .IFCPMXPIPECHANNEL4XPIPERXSTATUS(cpm_xpipe_ch4_rxstatus),
    .IFCPMXPIPECHANNEL4XPIPETXDEEMPH(cpm_xpipe_ch4_txdeemph),
    .IFCPMXPIPECHANNEL4XPIPETXMARGIN(cpm_xpipe_ch4_txmargin),
    .IFCPMXPIPECHANNEL4XPIPEPHYSTATUS(cpm_xpipe_ch4_phystatus),
    .IFCPMXPIPECHANNEL4XPIPEPOWERDOWN(cpm_xpipe_ch4_powerdown),
    .IFCPMXPIPECHANNEL4XPIPERXCHARISK(cpm_xpipe_ch4_rxcharisk),
    .IFCPMXPIPECHANNEL4XPIPETXCHARISK(cpm_xpipe_ch4_txcharisk),
    .IFCPMXPIPECHANNEL4XPIPERXELECIDLE(cpm_xpipe_ch4_rxelecidle),
    .IFCPMXPIPECHANNEL4XPIPERXPOLARITY(cpm_xpipe_ch4_rxpolarity),
    .IFCPMXPIPECHANNEL4XPIPETXELECIDLE(cpm_xpipe_ch4_txelecidle),
    .IFCPMXPIPECHANNEL4XPIPERXDATAVALID(cpm_xpipe_ch4_rxdatavalid),
    .IFCPMXPIPECHANNEL4XPIPETXDATAVALID(cpm_xpipe_ch4_txdatavalid),
    .IFCPMXPIPECHANNEL4XPIPETXPRECURSOR(cpm_xpipe_ch4_txprecursor),
    .IFCPMXPIPECHANNEL4XPIPERXSTARTBLOCK(cpm_xpipe_ch4_rxstartblock),
    .IFCPMXPIPECHANNEL4XPIPERXSYNCHEADER(cpm_xpipe_ch4_rxsyncheader),
    .IFCPMXPIPECHANNEL4XPIPETXCOMPLIANCE(cpm_xpipe_ch4_txcompliance),
    .IFCPMXPIPECHANNEL4XPIPETXMAINCURSOR(cpm_xpipe_ch4_txmaincursor),
    .IFCPMXPIPECHANNEL4XPIPETXPOSTCURSOR(cpm_xpipe_ch4_txpostcursor),
    .IFCPMXPIPECHANNEL4XPIPETXSTARTBLOCK(cpm_xpipe_ch4_txstartblock),
    .IFCPMXPIPECHANNEL4XPIPETXSYNCHEADER(cpm_xpipe_ch4_txsyncheader),
    .IFCPMXPIPECHANNEL4XPIPERXTERMINATION(cpm_xpipe_ch4_rxtermination),
    .IFCPMXPIPECHANNEL4XPIPETXDETECTRXLOOPBACK(cpm_xpipe_ch4_txdetectrxloopback),

     // PS XPIPE channel 4
    .IFPSCPMCHANNEL4XPIPERXDATA(xpipe4_rx_data),
    .IFPSCPMCHANNEL4XPIPETXDATA(xpipe4_tx_data),
    .IFPSCPMCHANNEL4XPIPERXVALID(xpipe4_rx_valid),
    .IFPSCPMCHANNEL4XPIPETXSWING(xpipe4_tx_swing),
    .IFPSCPMCHANNEL4XPIPERXSTATUS(xpipe4_rx_status),
    .IFPSCPMCHANNEL4XPIPETXDEEMPH(xpipe4_tx_deemph),
    .IFPSCPMCHANNEL4XPIPETXMARGIN(xpipe4_tx_margin),
    .IFPSCPMCHANNEL4XPIPEPHYSTATUS(xpipe4_phystatus),
    .IFPSCPMCHANNEL4XPIPEPOWERDOWN(xpipe4_powerdown),
    .IFPSCPMCHANNEL4XPIPERXCHARISK(xpipe4_rx_charisk),
    .IFPSCPMCHANNEL4XPIPETXCHARISK(xpipe4_tx_charisk),
    .IFPSCPMCHANNEL4XPIPERXELECIDLE(xpipe4_rx_elecidle),
    .IFPSCPMCHANNEL4XPIPERXPOLARITY(xpipe4_rx_polarity),
    .IFPSCPMCHANNEL4XPIPETXELECIDLE(xpipe4_tx_elecidle),
    .IFPSCPMCHANNEL4XPIPERXDATAVALID(xpipe4_rx_datavalid),
    .IFPSCPMCHANNEL4XPIPETXDATAVALID(xpipe4_tx_datavalid),
    .IFPSCPMCHANNEL4XPIPETXPRECURSOR(xpipe4_tx_precursor),
    .IFPSCPMCHANNEL4XPIPERXSTARTBLOCK(xpipe4_rx_startblock),
    .IFPSCPMCHANNEL4XPIPERXSYNCHEADER(xpipe4_rx_syncheader),
    .IFPSCPMCHANNEL4XPIPETXCOMPLIANCE(xpipe4_tx_compliance),
    .IFPSCPMCHANNEL4XPIPETXMAINCURSOR(xpipe4_tx_maincursor),
    .IFPSCPMCHANNEL4XPIPETXPOSTCURSOR(xpipe4_tx_postcursor),
    .IFPSCPMCHANNEL4XPIPETXSTARTBLOCK(xpipe4_tx_startblock),
    .IFPSCPMCHANNEL4XPIPETXSYNCHEADER(xpipe4_tx_syncheader),
    .IFPSCPMCHANNEL4XPIPERXTERMINATION(xpipe4_rx_termination),
    .IFPSCPMCHANNEL4XPIPETXDETECTRXLOOPBACK(xpipe4_tx_detectrxloopback),
     // CPM XPIPE channel 5
    .IFCPMXPIPECHANNEL5XPIPERXDATA(cpm_xpipe_ch5_rxdata),
    .IFCPMXPIPECHANNEL5XPIPETXDATA(cpm_xpipe_ch5_txdata),
    .IFCPMXPIPECHANNEL5XPIPERXVALID(cpm_xpipe_ch5_rxvalid),
    .IFCPMXPIPECHANNEL5XPIPETXSWING(cpm_xpipe_ch5_txswing),
    .IFCPMXPIPECHANNEL5XPIPERXSTATUS(cpm_xpipe_ch5_rxstatus),
    .IFCPMXPIPECHANNEL5XPIPETXDEEMPH(cpm_xpipe_ch5_txdeemph),
    .IFCPMXPIPECHANNEL5XPIPETXMARGIN(cpm_xpipe_ch5_txmargin),
    .IFCPMXPIPECHANNEL5XPIPEPHYSTATUS(cpm_xpipe_ch5_phystatus),
    .IFCPMXPIPECHANNEL5XPIPEPOWERDOWN(cpm_xpipe_ch5_powerdown),
    .IFCPMXPIPECHANNEL5XPIPERXCHARISK(cpm_xpipe_ch5_rxcharisk),
    .IFCPMXPIPECHANNEL5XPIPETXCHARISK(cpm_xpipe_ch5_txcharisk),
    .IFCPMXPIPECHANNEL5XPIPERXELECIDLE(cpm_xpipe_ch5_rxelecidle),
    .IFCPMXPIPECHANNEL5XPIPERXPOLARITY(cpm_xpipe_ch5_rxpolarity),
    .IFCPMXPIPECHANNEL5XPIPETXELECIDLE(cpm_xpipe_ch5_txelecidle),
    .IFCPMXPIPECHANNEL5XPIPERXDATAVALID(cpm_xpipe_ch5_rxdatavalid),
    .IFCPMXPIPECHANNEL5XPIPETXDATAVALID(cpm_xpipe_ch5_txdatavalid),
    .IFCPMXPIPECHANNEL5XPIPETXPRECURSOR(cpm_xpipe_ch5_txprecursor),
    .IFCPMXPIPECHANNEL5XPIPERXSTARTBLOCK(cpm_xpipe_ch5_rxstartblock),
    .IFCPMXPIPECHANNEL5XPIPERXSYNCHEADER(cpm_xpipe_ch5_rxsyncheader),
    .IFCPMXPIPECHANNEL5XPIPETXCOMPLIANCE(cpm_xpipe_ch5_txcompliance),
    .IFCPMXPIPECHANNEL5XPIPETXMAINCURSOR(cpm_xpipe_ch5_txmaincursor),
    .IFCPMXPIPECHANNEL5XPIPETXPOSTCURSOR(cpm_xpipe_ch5_txpostcursor),
    .IFCPMXPIPECHANNEL5XPIPETXSTARTBLOCK(cpm_xpipe_ch5_txstartblock),
    .IFCPMXPIPECHANNEL5XPIPETXSYNCHEADER(cpm_xpipe_ch5_txsyncheader),
    .IFCPMXPIPECHANNEL5XPIPERXTERMINATION(cpm_xpipe_ch5_rxtermination),
    .IFCPMXPIPECHANNEL5XPIPETXDETECTRXLOOPBACK(cpm_xpipe_ch5_txdetectrxloopback),

     // PS XPIPE channel 5
    .IFPSCPMCHANNEL5XPIPERXDATA(xpipe5_rx_data),
    .IFPSCPMCHANNEL5XPIPETXDATA(xpipe5_tx_data),
    .IFPSCPMCHANNEL5XPIPERXVALID(xpipe5_rx_valid),
    .IFPSCPMCHANNEL5XPIPETXSWING(xpipe5_tx_swing),
    .IFPSCPMCHANNEL5XPIPERXSTATUS(xpipe5_rx_status),
    .IFPSCPMCHANNEL5XPIPETXDEEMPH(xpipe5_tx_deemph),
    .IFPSCPMCHANNEL5XPIPETXMARGIN(xpipe5_tx_margin),
    .IFPSCPMCHANNEL5XPIPEPHYSTATUS(xpipe5_phystatus),
    .IFPSCPMCHANNEL5XPIPEPOWERDOWN(xpipe5_powerdown),
    .IFPSCPMCHANNEL5XPIPERXCHARISK(xpipe5_rx_charisk),
    .IFPSCPMCHANNEL5XPIPETXCHARISK(xpipe5_tx_charisk),
    .IFPSCPMCHANNEL5XPIPERXELECIDLE(xpipe5_rx_elecidle),
    .IFPSCPMCHANNEL5XPIPERXPOLARITY(xpipe5_rx_polarity),
    .IFPSCPMCHANNEL5XPIPETXELECIDLE(xpipe5_tx_elecidle),
    .IFPSCPMCHANNEL5XPIPERXDATAVALID(xpipe5_rx_datavalid),
    .IFPSCPMCHANNEL5XPIPETXDATAVALID(xpipe5_tx_datavalid),
    .IFPSCPMCHANNEL5XPIPETXPRECURSOR(xpipe5_tx_precursor),
    .IFPSCPMCHANNEL5XPIPERXSTARTBLOCK(xpipe5_rx_startblock),
    .IFPSCPMCHANNEL5XPIPERXSYNCHEADER(xpipe5_rx_syncheader),
    .IFPSCPMCHANNEL5XPIPETXCOMPLIANCE(xpipe5_tx_compliance),
    .IFPSCPMCHANNEL5XPIPETXMAINCURSOR(xpipe5_tx_maincursor),
    .IFPSCPMCHANNEL5XPIPETXPOSTCURSOR(xpipe5_tx_postcursor),
    .IFPSCPMCHANNEL5XPIPETXSTARTBLOCK(xpipe5_tx_startblock),
    .IFPSCPMCHANNEL5XPIPETXSYNCHEADER(xpipe5_tx_syncheader),
    .IFPSCPMCHANNEL5XPIPERXTERMINATION(xpipe5_rx_termination),
    .IFPSCPMCHANNEL5XPIPETXDETECTRXLOOPBACK(xpipe5_tx_detectrxloopback),
     // CPM XPIPE channel 6
    .IFCPMXPIPECHANNEL6XPIPERXDATA(cpm_xpipe_ch6_rxdata),
    .IFCPMXPIPECHANNEL6XPIPETXDATA(cpm_xpipe_ch6_txdata),
    .IFCPMXPIPECHANNEL6XPIPERXVALID(cpm_xpipe_ch6_rxvalid),
    .IFCPMXPIPECHANNEL6XPIPETXSWING(cpm_xpipe_ch6_txswing),
    .IFCPMXPIPECHANNEL6XPIPERXSTATUS(cpm_xpipe_ch6_rxstatus),
    .IFCPMXPIPECHANNEL6XPIPETXDEEMPH(cpm_xpipe_ch6_txdeemph),
    .IFCPMXPIPECHANNEL6XPIPETXMARGIN(cpm_xpipe_ch6_txmargin),
    .IFCPMXPIPECHANNEL6XPIPEPHYSTATUS(cpm_xpipe_ch6_phystatus),
    .IFCPMXPIPECHANNEL6XPIPEPOWERDOWN(cpm_xpipe_ch6_powerdown),
    .IFCPMXPIPECHANNEL6XPIPERXCHARISK(cpm_xpipe_ch6_rxcharisk),
    .IFCPMXPIPECHANNEL6XPIPETXCHARISK(cpm_xpipe_ch6_txcharisk),
    .IFCPMXPIPECHANNEL6XPIPERXELECIDLE(cpm_xpipe_ch6_rxelecidle),
    .IFCPMXPIPECHANNEL6XPIPERXPOLARITY(cpm_xpipe_ch6_rxpolarity),
    .IFCPMXPIPECHANNEL6XPIPETXELECIDLE(cpm_xpipe_ch6_txelecidle),
    .IFCPMXPIPECHANNEL6XPIPERXDATAVALID(cpm_xpipe_ch6_rxdatavalid),
    .IFCPMXPIPECHANNEL6XPIPETXDATAVALID(cpm_xpipe_ch6_txdatavalid),
    .IFCPMXPIPECHANNEL6XPIPETXPRECURSOR(cpm_xpipe_ch6_txprecursor),
    .IFCPMXPIPECHANNEL6XPIPERXSTARTBLOCK(cpm_xpipe_ch6_rxstartblock),
    .IFCPMXPIPECHANNEL6XPIPERXSYNCHEADER(cpm_xpipe_ch6_rxsyncheader),
    .IFCPMXPIPECHANNEL6XPIPETXCOMPLIANCE(cpm_xpipe_ch6_txcompliance),
    .IFCPMXPIPECHANNEL6XPIPETXMAINCURSOR(cpm_xpipe_ch6_txmaincursor),
    .IFCPMXPIPECHANNEL6XPIPETXPOSTCURSOR(cpm_xpipe_ch6_txpostcursor),
    .IFCPMXPIPECHANNEL6XPIPETXSTARTBLOCK(cpm_xpipe_ch6_txstartblock),
    .IFCPMXPIPECHANNEL6XPIPETXSYNCHEADER(cpm_xpipe_ch6_txsyncheader),
    .IFCPMXPIPECHANNEL6XPIPERXTERMINATION(cpm_xpipe_ch6_rxtermination),
    .IFCPMXPIPECHANNEL6XPIPETXDETECTRXLOOPBACK(cpm_xpipe_ch6_txdetectrxloopback),

     // PS XPIPE channel 6
    .IFPSCPMCHANNEL6XPIPERXDATA(xpipe6_rx_data),
    .IFPSCPMCHANNEL6XPIPETXDATA(xpipe6_tx_data),
    .IFPSCPMCHANNEL6XPIPERXVALID(xpipe6_rx_valid),
    .IFPSCPMCHANNEL6XPIPETXSWING(xpipe6_tx_swing),
    .IFPSCPMCHANNEL6XPIPERXSTATUS(xpipe6_rx_status),
    .IFPSCPMCHANNEL6XPIPETXDEEMPH(xpipe6_tx_deemph),
    .IFPSCPMCHANNEL6XPIPETXMARGIN(xpipe6_tx_margin),
    .IFPSCPMCHANNEL6XPIPEPHYSTATUS(xpipe6_phystatus),
    .IFPSCPMCHANNEL6XPIPEPOWERDOWN(xpipe6_powerdown),
    .IFPSCPMCHANNEL6XPIPERXCHARISK(xpipe6_rx_charisk),
    .IFPSCPMCHANNEL6XPIPETXCHARISK(xpipe6_tx_charisk),
    .IFPSCPMCHANNEL6XPIPERXELECIDLE(xpipe6_rx_elecidle),
    .IFPSCPMCHANNEL6XPIPERXPOLARITY(xpipe6_rx_polarity),
    .IFPSCPMCHANNEL6XPIPETXELECIDLE(xpipe6_tx_elecidle),
    .IFPSCPMCHANNEL6XPIPERXDATAVALID(xpipe6_rx_datavalid),
    .IFPSCPMCHANNEL6XPIPETXDATAVALID(xpipe6_tx_datavalid),
    .IFPSCPMCHANNEL6XPIPETXPRECURSOR(xpipe6_tx_precursor),
    .IFPSCPMCHANNEL6XPIPERXSTARTBLOCK(xpipe6_rx_startblock),
    .IFPSCPMCHANNEL6XPIPERXSYNCHEADER(xpipe6_rx_syncheader),
    .IFPSCPMCHANNEL6XPIPETXCOMPLIANCE(xpipe6_tx_compliance),
    .IFPSCPMCHANNEL6XPIPETXMAINCURSOR(xpipe6_tx_maincursor),
    .IFPSCPMCHANNEL6XPIPETXPOSTCURSOR(xpipe6_tx_postcursor),
    .IFPSCPMCHANNEL6XPIPETXSTARTBLOCK(xpipe6_tx_startblock),
    .IFPSCPMCHANNEL6XPIPETXSYNCHEADER(xpipe6_tx_syncheader),
    .IFPSCPMCHANNEL6XPIPERXTERMINATION(xpipe6_rx_termination),
    .IFPSCPMCHANNEL6XPIPETXDETECTRXLOOPBACK(xpipe6_tx_detectrxloopback),
     // CPM XPIPE channel 7
    .IFCPMXPIPECHANNEL7XPIPERXDATA(cpm_xpipe_ch7_rxdata),
    .IFCPMXPIPECHANNEL7XPIPETXDATA(cpm_xpipe_ch7_txdata),
    .IFCPMXPIPECHANNEL7XPIPERXVALID(cpm_xpipe_ch7_rxvalid),
    .IFCPMXPIPECHANNEL7XPIPETXSWING(cpm_xpipe_ch7_txswing),
    .IFCPMXPIPECHANNEL7XPIPERXSTATUS(cpm_xpipe_ch7_rxstatus),
    .IFCPMXPIPECHANNEL7XPIPETXDEEMPH(cpm_xpipe_ch7_txdeemph),
    .IFCPMXPIPECHANNEL7XPIPETXMARGIN(cpm_xpipe_ch7_txmargin),
    .IFCPMXPIPECHANNEL7XPIPEPHYSTATUS(cpm_xpipe_ch7_phystatus),
    .IFCPMXPIPECHANNEL7XPIPEPOWERDOWN(cpm_xpipe_ch7_powerdown),
    .IFCPMXPIPECHANNEL7XPIPERXCHARISK(cpm_xpipe_ch7_rxcharisk),
    .IFCPMXPIPECHANNEL7XPIPETXCHARISK(cpm_xpipe_ch7_txcharisk),
    .IFCPMXPIPECHANNEL7XPIPERXELECIDLE(cpm_xpipe_ch7_rxelecidle),
    .IFCPMXPIPECHANNEL7XPIPERXPOLARITY(cpm_xpipe_ch7_rxpolarity),
    .IFCPMXPIPECHANNEL7XPIPETXELECIDLE(cpm_xpipe_ch7_txelecidle),
    .IFCPMXPIPECHANNEL7XPIPERXDATAVALID(cpm_xpipe_ch7_rxdatavalid),
    .IFCPMXPIPECHANNEL7XPIPETXDATAVALID(cpm_xpipe_ch7_txdatavalid),
    .IFCPMXPIPECHANNEL7XPIPETXPRECURSOR(cpm_xpipe_ch7_txprecursor),
    .IFCPMXPIPECHANNEL7XPIPERXSTARTBLOCK(cpm_xpipe_ch7_rxstartblock),
    .IFCPMXPIPECHANNEL7XPIPERXSYNCHEADER(cpm_xpipe_ch7_rxsyncheader),
    .IFCPMXPIPECHANNEL7XPIPETXCOMPLIANCE(cpm_xpipe_ch7_txcompliance),
    .IFCPMXPIPECHANNEL7XPIPETXMAINCURSOR(cpm_xpipe_ch7_txmaincursor),
    .IFCPMXPIPECHANNEL7XPIPETXPOSTCURSOR(cpm_xpipe_ch7_txpostcursor),
    .IFCPMXPIPECHANNEL7XPIPETXSTARTBLOCK(cpm_xpipe_ch7_txstartblock),
    .IFCPMXPIPECHANNEL7XPIPETXSYNCHEADER(cpm_xpipe_ch7_txsyncheader),
    .IFCPMXPIPECHANNEL7XPIPERXTERMINATION(cpm_xpipe_ch7_rxtermination),
    .IFCPMXPIPECHANNEL7XPIPETXDETECTRXLOOPBACK(cpm_xpipe_ch7_txdetectrxloopback),

     // PS XPIPE channel 7
    .IFPSCPMCHANNEL7XPIPERXDATA(xpipe7_rx_data),
    .IFPSCPMCHANNEL7XPIPETXDATA(xpipe7_tx_data),
    .IFPSCPMCHANNEL7XPIPERXVALID(xpipe7_rx_valid),
    .IFPSCPMCHANNEL7XPIPETXSWING(xpipe7_tx_swing),
    .IFPSCPMCHANNEL7XPIPERXSTATUS(xpipe7_rx_status),
    .IFPSCPMCHANNEL7XPIPETXDEEMPH(xpipe7_tx_deemph),
    .IFPSCPMCHANNEL7XPIPETXMARGIN(xpipe7_tx_margin),
    .IFPSCPMCHANNEL7XPIPEPHYSTATUS(xpipe7_phystatus),
    .IFPSCPMCHANNEL7XPIPEPOWERDOWN(xpipe7_powerdown),
    .IFPSCPMCHANNEL7XPIPERXCHARISK(xpipe7_rx_charisk),
    .IFPSCPMCHANNEL7XPIPETXCHARISK(xpipe7_tx_charisk),
    .IFPSCPMCHANNEL7XPIPERXELECIDLE(xpipe7_rx_elecidle),
    .IFPSCPMCHANNEL7XPIPERXPOLARITY(xpipe7_rx_polarity),
    .IFPSCPMCHANNEL7XPIPETXELECIDLE(xpipe7_tx_elecidle),
    .IFPSCPMCHANNEL7XPIPERXDATAVALID(xpipe7_rx_datavalid),
    .IFPSCPMCHANNEL7XPIPETXDATAVALID(xpipe7_tx_datavalid),
    .IFPSCPMCHANNEL7XPIPETXPRECURSOR(xpipe7_tx_precursor),
    .IFPSCPMCHANNEL7XPIPERXSTARTBLOCK(xpipe7_rx_startblock),
    .IFPSCPMCHANNEL7XPIPERXSYNCHEADER(xpipe7_rx_syncheader),
    .IFPSCPMCHANNEL7XPIPETXCOMPLIANCE(xpipe7_tx_compliance),
    .IFPSCPMCHANNEL7XPIPETXMAINCURSOR(xpipe7_tx_maincursor),
    .IFPSCPMCHANNEL7XPIPETXPOSTCURSOR(xpipe7_tx_postcursor),
    .IFPSCPMCHANNEL7XPIPETXSTARTBLOCK(xpipe7_tx_startblock),
    .IFPSCPMCHANNEL7XPIPETXSYNCHEADER(xpipe7_tx_syncheader),
    .IFPSCPMCHANNEL7XPIPERXTERMINATION(xpipe7_rx_termination),
    .IFPSCPMCHANNEL7XPIPETXDETECTRXLOOPBACK(xpipe7_tx_detectrxloopback),
     // CPM XPIPE channel 8
    .IFCPMXPIPECHANNEL8XPIPERXDATA(cpm_xpipe_ch8_rxdata),
    .IFCPMXPIPECHANNEL8XPIPETXDATA(cpm_xpipe_ch8_txdata),
    .IFCPMXPIPECHANNEL8XPIPERXVALID(cpm_xpipe_ch8_rxvalid),
    .IFCPMXPIPECHANNEL8XPIPETXSWING(cpm_xpipe_ch8_txswing),
    .IFCPMXPIPECHANNEL8XPIPERXSTATUS(cpm_xpipe_ch8_rxstatus),
    .IFCPMXPIPECHANNEL8XPIPETXDEEMPH(cpm_xpipe_ch8_txdeemph),
    .IFCPMXPIPECHANNEL8XPIPETXMARGIN(cpm_xpipe_ch8_txmargin),
    .IFCPMXPIPECHANNEL8XPIPEPHYSTATUS(cpm_xpipe_ch8_phystatus),
    .IFCPMXPIPECHANNEL8XPIPEPOWERDOWN(cpm_xpipe_ch8_powerdown),
    .IFCPMXPIPECHANNEL8XPIPERXCHARISK(cpm_xpipe_ch8_rxcharisk),
    .IFCPMXPIPECHANNEL8XPIPETXCHARISK(cpm_xpipe_ch8_txcharisk),
    .IFCPMXPIPECHANNEL8XPIPERXELECIDLE(cpm_xpipe_ch8_rxelecidle),
    .IFCPMXPIPECHANNEL8XPIPERXPOLARITY(cpm_xpipe_ch8_rxpolarity),
    .IFCPMXPIPECHANNEL8XPIPETXELECIDLE(cpm_xpipe_ch8_txelecidle),
    .IFCPMXPIPECHANNEL8XPIPERXDATAVALID(cpm_xpipe_ch8_rxdatavalid),
    .IFCPMXPIPECHANNEL8XPIPETXDATAVALID(cpm_xpipe_ch8_txdatavalid),
    .IFCPMXPIPECHANNEL8XPIPETXPRECURSOR(cpm_xpipe_ch8_txprecursor),
    .IFCPMXPIPECHANNEL8XPIPERXSTARTBLOCK(cpm_xpipe_ch8_rxstartblock),
    .IFCPMXPIPECHANNEL8XPIPERXSYNCHEADER(cpm_xpipe_ch8_rxsyncheader),
    .IFCPMXPIPECHANNEL8XPIPETXCOMPLIANCE(cpm_xpipe_ch8_txcompliance),
    .IFCPMXPIPECHANNEL8XPIPETXMAINCURSOR(cpm_xpipe_ch8_txmaincursor),
    .IFCPMXPIPECHANNEL8XPIPETXPOSTCURSOR(cpm_xpipe_ch8_txpostcursor),
    .IFCPMXPIPECHANNEL8XPIPETXSTARTBLOCK(cpm_xpipe_ch8_txstartblock),
    .IFCPMXPIPECHANNEL8XPIPETXSYNCHEADER(cpm_xpipe_ch8_txsyncheader),
    .IFCPMXPIPECHANNEL8XPIPERXTERMINATION(cpm_xpipe_ch8_rxtermination),
    .IFCPMXPIPECHANNEL8XPIPETXDETECTRXLOOPBACK(cpm_xpipe_ch8_txdetectrxloopback),

     // PS XPIPE channel 8
    .IFPSCPMCHANNEL8XPIPERXDATA(xpipe8_rx_data),
    .IFPSCPMCHANNEL8XPIPETXDATA(xpipe8_tx_data),
    .IFPSCPMCHANNEL8XPIPERXVALID(xpipe8_rx_valid),
    .IFPSCPMCHANNEL8XPIPETXSWING(xpipe8_tx_swing),
    .IFPSCPMCHANNEL8XPIPERXSTATUS(xpipe8_rx_status),
    .IFPSCPMCHANNEL8XPIPETXDEEMPH(xpipe8_tx_deemph),
    .IFPSCPMCHANNEL8XPIPETXMARGIN(xpipe8_tx_margin),
    .IFPSCPMCHANNEL8XPIPEPHYSTATUS(xpipe8_phystatus),
    .IFPSCPMCHANNEL8XPIPEPOWERDOWN(xpipe8_powerdown),
    .IFPSCPMCHANNEL8XPIPERXCHARISK(xpipe8_rx_charisk),
    .IFPSCPMCHANNEL8XPIPETXCHARISK(xpipe8_tx_charisk),
    .IFPSCPMCHANNEL8XPIPERXELECIDLE(xpipe8_rx_elecidle),
    .IFPSCPMCHANNEL8XPIPERXPOLARITY(xpipe8_rx_polarity),
    .IFPSCPMCHANNEL8XPIPETXELECIDLE(xpipe8_tx_elecidle),
    .IFPSCPMCHANNEL8XPIPERXDATAVALID(xpipe8_rx_datavalid),
    .IFPSCPMCHANNEL8XPIPETXDATAVALID(xpipe8_tx_datavalid),
    .IFPSCPMCHANNEL8XPIPETXPRECURSOR(xpipe8_tx_precursor),
    .IFPSCPMCHANNEL8XPIPERXSTARTBLOCK(xpipe8_rx_startblock),
    .IFPSCPMCHANNEL8XPIPERXSYNCHEADER(xpipe8_rx_syncheader),
    .IFPSCPMCHANNEL8XPIPETXCOMPLIANCE(xpipe8_tx_compliance),
    .IFPSCPMCHANNEL8XPIPETXMAINCURSOR(xpipe8_tx_maincursor),
    .IFPSCPMCHANNEL8XPIPETXPOSTCURSOR(xpipe8_tx_postcursor),
    .IFPSCPMCHANNEL8XPIPETXSTARTBLOCK(xpipe8_tx_startblock),
    .IFPSCPMCHANNEL8XPIPETXSYNCHEADER(xpipe8_tx_syncheader),
    .IFPSCPMCHANNEL8XPIPERXTERMINATION(xpipe8_rx_termination),
    .IFPSCPMCHANNEL8XPIPETXDETECTRXLOOPBACK(xpipe8_tx_detectrxloopback),
     // CPM XPIPE channel 9
    .IFCPMXPIPECHANNEL9XPIPERXDATA(cpm_xpipe_ch9_rxdata),
    .IFCPMXPIPECHANNEL9XPIPETXDATA(cpm_xpipe_ch9_txdata),
    .IFCPMXPIPECHANNEL9XPIPERXVALID(cpm_xpipe_ch9_rxvalid),
    .IFCPMXPIPECHANNEL9XPIPETXSWING(cpm_xpipe_ch9_txswing),
    .IFCPMXPIPECHANNEL9XPIPERXSTATUS(cpm_xpipe_ch9_rxstatus),
    .IFCPMXPIPECHANNEL9XPIPETXDEEMPH(cpm_xpipe_ch9_txdeemph),
    .IFCPMXPIPECHANNEL9XPIPETXMARGIN(cpm_xpipe_ch9_txmargin),
    .IFCPMXPIPECHANNEL9XPIPEPHYSTATUS(cpm_xpipe_ch9_phystatus),
    .IFCPMXPIPECHANNEL9XPIPEPOWERDOWN(cpm_xpipe_ch9_powerdown),
    .IFCPMXPIPECHANNEL9XPIPERXCHARISK(cpm_xpipe_ch9_rxcharisk),
    .IFCPMXPIPECHANNEL9XPIPETXCHARISK(cpm_xpipe_ch9_txcharisk),
    .IFCPMXPIPECHANNEL9XPIPERXELECIDLE(cpm_xpipe_ch9_rxelecidle),
    .IFCPMXPIPECHANNEL9XPIPERXPOLARITY(cpm_xpipe_ch9_rxpolarity),
    .IFCPMXPIPECHANNEL9XPIPETXELECIDLE(cpm_xpipe_ch9_txelecidle),
    .IFCPMXPIPECHANNEL9XPIPERXDATAVALID(cpm_xpipe_ch9_rxdatavalid),
    .IFCPMXPIPECHANNEL9XPIPETXDATAVALID(cpm_xpipe_ch9_txdatavalid),
    .IFCPMXPIPECHANNEL9XPIPETXPRECURSOR(cpm_xpipe_ch9_txprecursor),
    .IFCPMXPIPECHANNEL9XPIPERXSTARTBLOCK(cpm_xpipe_ch9_rxstartblock),
    .IFCPMXPIPECHANNEL9XPIPERXSYNCHEADER(cpm_xpipe_ch9_rxsyncheader),
    .IFCPMXPIPECHANNEL9XPIPETXCOMPLIANCE(cpm_xpipe_ch9_txcompliance),
    .IFCPMXPIPECHANNEL9XPIPETXMAINCURSOR(cpm_xpipe_ch9_txmaincursor),
    .IFCPMXPIPECHANNEL9XPIPETXPOSTCURSOR(cpm_xpipe_ch9_txpostcursor),
    .IFCPMXPIPECHANNEL9XPIPETXSTARTBLOCK(cpm_xpipe_ch9_txstartblock),
    .IFCPMXPIPECHANNEL9XPIPETXSYNCHEADER(cpm_xpipe_ch9_txsyncheader),
    .IFCPMXPIPECHANNEL9XPIPERXTERMINATION(cpm_xpipe_ch9_rxtermination),
    .IFCPMXPIPECHANNEL9XPIPETXDETECTRXLOOPBACK(cpm_xpipe_ch9_txdetectrxloopback),

     // PS XPIPE channel 9
    .IFPSCPMCHANNEL9XPIPERXDATA(xpipe9_rx_data),
    .IFPSCPMCHANNEL9XPIPETXDATA(xpipe9_tx_data),
    .IFPSCPMCHANNEL9XPIPERXVALID(xpipe9_rx_valid),
    .IFPSCPMCHANNEL9XPIPETXSWING(xpipe9_tx_swing),
    .IFPSCPMCHANNEL9XPIPERXSTATUS(xpipe9_rx_status),
    .IFPSCPMCHANNEL9XPIPETXDEEMPH(xpipe9_tx_deemph),
    .IFPSCPMCHANNEL9XPIPETXMARGIN(xpipe9_tx_margin),
    .IFPSCPMCHANNEL9XPIPEPHYSTATUS(xpipe9_phystatus),
    .IFPSCPMCHANNEL9XPIPEPOWERDOWN(xpipe9_powerdown),
    .IFPSCPMCHANNEL9XPIPERXCHARISK(xpipe9_rx_charisk),
    .IFPSCPMCHANNEL9XPIPETXCHARISK(xpipe9_tx_charisk),
    .IFPSCPMCHANNEL9XPIPERXELECIDLE(xpipe9_rx_elecidle),
    .IFPSCPMCHANNEL9XPIPERXPOLARITY(xpipe9_rx_polarity),
    .IFPSCPMCHANNEL9XPIPETXELECIDLE(xpipe9_tx_elecidle),
    .IFPSCPMCHANNEL9XPIPERXDATAVALID(xpipe9_rx_datavalid),
    .IFPSCPMCHANNEL9XPIPETXDATAVALID(xpipe9_tx_datavalid),
    .IFPSCPMCHANNEL9XPIPETXPRECURSOR(xpipe9_tx_precursor),
    .IFPSCPMCHANNEL9XPIPERXSTARTBLOCK(xpipe9_rx_startblock),
    .IFPSCPMCHANNEL9XPIPERXSYNCHEADER(xpipe9_rx_syncheader),
    .IFPSCPMCHANNEL9XPIPETXCOMPLIANCE(xpipe9_tx_compliance),
    .IFPSCPMCHANNEL9XPIPETXMAINCURSOR(xpipe9_tx_maincursor),
    .IFPSCPMCHANNEL9XPIPETXPOSTCURSOR(xpipe9_tx_postcursor),
    .IFPSCPMCHANNEL9XPIPETXSTARTBLOCK(xpipe9_tx_startblock),
    .IFPSCPMCHANNEL9XPIPETXSYNCHEADER(xpipe9_tx_syncheader),
    .IFPSCPMCHANNEL9XPIPERXTERMINATION(xpipe9_rx_termination),
    .IFPSCPMCHANNEL9XPIPETXDETECTRXLOOPBACK(xpipe9_tx_detectrxloopback),
     // CPM XPIPE channel 10
    .IFCPMXPIPECHANNEL10XPIPERXDATA(cpm_xpipe_ch10_rxdata),
    .IFCPMXPIPECHANNEL10XPIPETXDATA(cpm_xpipe_ch10_txdata),
    .IFCPMXPIPECHANNEL10XPIPERXVALID(cpm_xpipe_ch10_rxvalid),
    .IFCPMXPIPECHANNEL10XPIPETXSWING(cpm_xpipe_ch10_txswing),
    .IFCPMXPIPECHANNEL10XPIPERXSTATUS(cpm_xpipe_ch10_rxstatus),
    .IFCPMXPIPECHANNEL10XPIPETXDEEMPH(cpm_xpipe_ch10_txdeemph),
    .IFCPMXPIPECHANNEL10XPIPETXMARGIN(cpm_xpipe_ch10_txmargin),
    .IFCPMXPIPECHANNEL10XPIPEPHYSTATUS(cpm_xpipe_ch10_phystatus),
    .IFCPMXPIPECHANNEL10XPIPEPOWERDOWN(cpm_xpipe_ch10_powerdown),
    .IFCPMXPIPECHANNEL10XPIPERXCHARISK(cpm_xpipe_ch10_rxcharisk),
    .IFCPMXPIPECHANNEL10XPIPETXCHARISK(cpm_xpipe_ch10_txcharisk),
    .IFCPMXPIPECHANNEL10XPIPERXELECIDLE(cpm_xpipe_ch10_rxelecidle),
    .IFCPMXPIPECHANNEL10XPIPERXPOLARITY(cpm_xpipe_ch10_rxpolarity),
    .IFCPMXPIPECHANNEL10XPIPETXELECIDLE(cpm_xpipe_ch10_txelecidle),
    .IFCPMXPIPECHANNEL10XPIPERXDATAVALID(cpm_xpipe_ch10_rxdatavalid),
    .IFCPMXPIPECHANNEL10XPIPETXDATAVALID(cpm_xpipe_ch10_txdatavalid),
    .IFCPMXPIPECHANNEL10XPIPETXPRECURSOR(cpm_xpipe_ch10_txprecursor),
    .IFCPMXPIPECHANNEL10XPIPERXSTARTBLOCK(cpm_xpipe_ch10_rxstartblock),
    .IFCPMXPIPECHANNEL10XPIPERXSYNCHEADER(cpm_xpipe_ch10_rxsyncheader),
    .IFCPMXPIPECHANNEL10XPIPETXCOMPLIANCE(cpm_xpipe_ch10_txcompliance),
    .IFCPMXPIPECHANNEL10XPIPETXMAINCURSOR(cpm_xpipe_ch10_txmaincursor),
    .IFCPMXPIPECHANNEL10XPIPETXPOSTCURSOR(cpm_xpipe_ch10_txpostcursor),
    .IFCPMXPIPECHANNEL10XPIPETXSTARTBLOCK(cpm_xpipe_ch10_txstartblock),
    .IFCPMXPIPECHANNEL10XPIPETXSYNCHEADER(cpm_xpipe_ch10_txsyncheader),
    .IFCPMXPIPECHANNEL10XPIPERXTERMINATION(cpm_xpipe_ch10_rxtermination),
    .IFCPMXPIPECHANNEL10XPIPETXDETECTRXLOOPBACK(cpm_xpipe_ch10_txdetectrxloopback),

     // PS XPIPE channel 10
    .IFPSCPMCHANNEL10XPIPERXDATA(xpipe10_rx_data),
    .IFPSCPMCHANNEL10XPIPETXDATA(xpipe10_tx_data),
    .IFPSCPMCHANNEL10XPIPERXVALID(xpipe10_rx_valid),
    .IFPSCPMCHANNEL10XPIPETXSWING(xpipe10_tx_swing),
    .IFPSCPMCHANNEL10XPIPERXSTATUS(xpipe10_rx_status),
    .IFPSCPMCHANNEL10XPIPETXDEEMPH(xpipe10_tx_deemph),
    .IFPSCPMCHANNEL10XPIPETXMARGIN(xpipe10_tx_margin),
    .IFPSCPMCHANNEL10XPIPEPHYSTATUS(xpipe10_phystatus),
    .IFPSCPMCHANNEL10XPIPEPOWERDOWN(xpipe10_powerdown),
    .IFPSCPMCHANNEL10XPIPERXCHARISK(xpipe10_rx_charisk),
    .IFPSCPMCHANNEL10XPIPETXCHARISK(xpipe10_tx_charisk),
    .IFPSCPMCHANNEL10XPIPERXELECIDLE(xpipe10_rx_elecidle),
    .IFPSCPMCHANNEL10XPIPERXPOLARITY(xpipe10_rx_polarity),
    .IFPSCPMCHANNEL10XPIPETXELECIDLE(xpipe10_tx_elecidle),
    .IFPSCPMCHANNEL10XPIPERXDATAVALID(xpipe10_rx_datavalid),
    .IFPSCPMCHANNEL10XPIPETXDATAVALID(xpipe10_tx_datavalid),
    .IFPSCPMCHANNEL10XPIPETXPRECURSOR(xpipe10_tx_precursor),
    .IFPSCPMCHANNEL10XPIPERXSTARTBLOCK(xpipe10_rx_startblock),
    .IFPSCPMCHANNEL10XPIPERXSYNCHEADER(xpipe10_rx_syncheader),
    .IFPSCPMCHANNEL10XPIPETXCOMPLIANCE(xpipe10_tx_compliance),
    .IFPSCPMCHANNEL10XPIPETXMAINCURSOR(xpipe10_tx_maincursor),
    .IFPSCPMCHANNEL10XPIPETXPOSTCURSOR(xpipe10_tx_postcursor),
    .IFPSCPMCHANNEL10XPIPETXSTARTBLOCK(xpipe10_tx_startblock),
    .IFPSCPMCHANNEL10XPIPETXSYNCHEADER(xpipe10_tx_syncheader),
    .IFPSCPMCHANNEL10XPIPERXTERMINATION(xpipe10_rx_termination),
    .IFPSCPMCHANNEL10XPIPETXDETECTRXLOOPBACK(xpipe10_tx_detectrxloopback),
     // CPM XPIPE channel 11
    .IFCPMXPIPECHANNEL11XPIPERXDATA(cpm_xpipe_ch11_rxdata),
    .IFCPMXPIPECHANNEL11XPIPETXDATA(cpm_xpipe_ch11_txdata),
    .IFCPMXPIPECHANNEL11XPIPERXVALID(cpm_xpipe_ch11_rxvalid),
    .IFCPMXPIPECHANNEL11XPIPETXSWING(cpm_xpipe_ch11_txswing),
    .IFCPMXPIPECHANNEL11XPIPERXSTATUS(cpm_xpipe_ch11_rxstatus),
    .IFCPMXPIPECHANNEL11XPIPETXDEEMPH(cpm_xpipe_ch11_txdeemph),
    .IFCPMXPIPECHANNEL11XPIPETXMARGIN(cpm_xpipe_ch11_txmargin),
    .IFCPMXPIPECHANNEL11XPIPEPHYSTATUS(cpm_xpipe_ch11_phystatus),
    .IFCPMXPIPECHANNEL11XPIPEPOWERDOWN(cpm_xpipe_ch11_powerdown),
    .IFCPMXPIPECHANNEL11XPIPERXCHARISK(cpm_xpipe_ch11_rxcharisk),
    .IFCPMXPIPECHANNEL11XPIPETXCHARISK(cpm_xpipe_ch11_txcharisk),
    .IFCPMXPIPECHANNEL11XPIPERXELECIDLE(cpm_xpipe_ch11_rxelecidle),
    .IFCPMXPIPECHANNEL11XPIPERXPOLARITY(cpm_xpipe_ch11_rxpolarity),
    .IFCPMXPIPECHANNEL11XPIPETXELECIDLE(cpm_xpipe_ch11_txelecidle),
    .IFCPMXPIPECHANNEL11XPIPERXDATAVALID(cpm_xpipe_ch11_rxdatavalid),
    .IFCPMXPIPECHANNEL11XPIPETXDATAVALID(cpm_xpipe_ch11_txdatavalid),
    .IFCPMXPIPECHANNEL11XPIPETXPRECURSOR(cpm_xpipe_ch11_txprecursor),
    .IFCPMXPIPECHANNEL11XPIPERXSTARTBLOCK(cpm_xpipe_ch11_rxstartblock),
    .IFCPMXPIPECHANNEL11XPIPERXSYNCHEADER(cpm_xpipe_ch11_rxsyncheader),
    .IFCPMXPIPECHANNEL11XPIPETXCOMPLIANCE(cpm_xpipe_ch11_txcompliance),
    .IFCPMXPIPECHANNEL11XPIPETXMAINCURSOR(cpm_xpipe_ch11_txmaincursor),
    .IFCPMXPIPECHANNEL11XPIPETXPOSTCURSOR(cpm_xpipe_ch11_txpostcursor),
    .IFCPMXPIPECHANNEL11XPIPETXSTARTBLOCK(cpm_xpipe_ch11_txstartblock),
    .IFCPMXPIPECHANNEL11XPIPETXSYNCHEADER(cpm_xpipe_ch11_txsyncheader),
    .IFCPMXPIPECHANNEL11XPIPERXTERMINATION(cpm_xpipe_ch11_rxtermination),
    .IFCPMXPIPECHANNEL11XPIPETXDETECTRXLOOPBACK(cpm_xpipe_ch11_txdetectrxloopback),

     // PS XPIPE channel 11
    .IFPSCPMCHANNEL11XPIPERXDATA(xpipe11_rx_data),
    .IFPSCPMCHANNEL11XPIPETXDATA(xpipe11_tx_data),
    .IFPSCPMCHANNEL11XPIPERXVALID(xpipe11_rx_valid),
    .IFPSCPMCHANNEL11XPIPETXSWING(xpipe11_tx_swing),
    .IFPSCPMCHANNEL11XPIPERXSTATUS(xpipe11_rx_status),
    .IFPSCPMCHANNEL11XPIPETXDEEMPH(xpipe11_tx_deemph),
    .IFPSCPMCHANNEL11XPIPETXMARGIN(xpipe11_tx_margin),
    .IFPSCPMCHANNEL11XPIPEPHYSTATUS(xpipe11_phystatus),
    .IFPSCPMCHANNEL11XPIPEPOWERDOWN(xpipe11_powerdown),
    .IFPSCPMCHANNEL11XPIPERXCHARISK(xpipe11_rx_charisk),
    .IFPSCPMCHANNEL11XPIPETXCHARISK(xpipe11_tx_charisk),
    .IFPSCPMCHANNEL11XPIPERXELECIDLE(xpipe11_rx_elecidle),
    .IFPSCPMCHANNEL11XPIPERXPOLARITY(xpipe11_rx_polarity),
    .IFPSCPMCHANNEL11XPIPETXELECIDLE(xpipe11_tx_elecidle),
    .IFPSCPMCHANNEL11XPIPERXDATAVALID(xpipe11_rx_datavalid),
    .IFPSCPMCHANNEL11XPIPETXDATAVALID(xpipe11_tx_datavalid),
    .IFPSCPMCHANNEL11XPIPETXPRECURSOR(xpipe11_tx_precursor),
    .IFPSCPMCHANNEL11XPIPERXSTARTBLOCK(xpipe11_rx_startblock),
    .IFPSCPMCHANNEL11XPIPERXSYNCHEADER(xpipe11_rx_syncheader),
    .IFPSCPMCHANNEL11XPIPETXCOMPLIANCE(xpipe11_tx_compliance),
    .IFPSCPMCHANNEL11XPIPETXMAINCURSOR(xpipe11_tx_maincursor),
    .IFPSCPMCHANNEL11XPIPETXPOSTCURSOR(xpipe11_tx_postcursor),
    .IFPSCPMCHANNEL11XPIPETXSTARTBLOCK(xpipe11_tx_startblock),
    .IFPSCPMCHANNEL11XPIPETXSYNCHEADER(xpipe11_tx_syncheader),
    .IFPSCPMCHANNEL11XPIPERXTERMINATION(xpipe11_rx_termination),
    .IFPSCPMCHANNEL11XPIPETXDETECTRXLOOPBACK(xpipe11_tx_detectrxloopback),
     // CPM XPIPE channel 12
    .IFCPMXPIPECHANNEL12XPIPERXDATA(cpm_xpipe_ch12_rxdata),
    .IFCPMXPIPECHANNEL12XPIPETXDATA(cpm_xpipe_ch12_txdata),
    .IFCPMXPIPECHANNEL12XPIPERXVALID(cpm_xpipe_ch12_rxvalid),
    .IFCPMXPIPECHANNEL12XPIPETXSWING(cpm_xpipe_ch12_txswing),
    .IFCPMXPIPECHANNEL12XPIPERXSTATUS(cpm_xpipe_ch12_rxstatus),
    .IFCPMXPIPECHANNEL12XPIPETXDEEMPH(cpm_xpipe_ch12_txdeemph),
    .IFCPMXPIPECHANNEL12XPIPETXMARGIN(cpm_xpipe_ch12_txmargin),
    .IFCPMXPIPECHANNEL12XPIPEPHYSTATUS(cpm_xpipe_ch12_phystatus),
    .IFCPMXPIPECHANNEL12XPIPEPOWERDOWN(cpm_xpipe_ch12_powerdown),
    .IFCPMXPIPECHANNEL12XPIPERXCHARISK(cpm_xpipe_ch12_rxcharisk),
    .IFCPMXPIPECHANNEL12XPIPETXCHARISK(cpm_xpipe_ch12_txcharisk),
    .IFCPMXPIPECHANNEL12XPIPERXELECIDLE(cpm_xpipe_ch12_rxelecidle),
    .IFCPMXPIPECHANNEL12XPIPERXPOLARITY(cpm_xpipe_ch12_rxpolarity),
    .IFCPMXPIPECHANNEL12XPIPETXELECIDLE(cpm_xpipe_ch12_txelecidle),
    .IFCPMXPIPECHANNEL12XPIPERXDATAVALID(cpm_xpipe_ch12_rxdatavalid),
    .IFCPMXPIPECHANNEL12XPIPETXDATAVALID(cpm_xpipe_ch12_txdatavalid),
    .IFCPMXPIPECHANNEL12XPIPETXPRECURSOR(cpm_xpipe_ch12_txprecursor),
    .IFCPMXPIPECHANNEL12XPIPERXSTARTBLOCK(cpm_xpipe_ch12_rxstartblock),
    .IFCPMXPIPECHANNEL12XPIPERXSYNCHEADER(cpm_xpipe_ch12_rxsyncheader),
    .IFCPMXPIPECHANNEL12XPIPETXCOMPLIANCE(cpm_xpipe_ch12_txcompliance),
    .IFCPMXPIPECHANNEL12XPIPETXMAINCURSOR(cpm_xpipe_ch12_txmaincursor),
    .IFCPMXPIPECHANNEL12XPIPETXPOSTCURSOR(cpm_xpipe_ch12_txpostcursor),
    .IFCPMXPIPECHANNEL12XPIPETXSTARTBLOCK(cpm_xpipe_ch12_txstartblock),
    .IFCPMXPIPECHANNEL12XPIPETXSYNCHEADER(cpm_xpipe_ch12_txsyncheader),
    .IFCPMXPIPECHANNEL12XPIPERXTERMINATION(cpm_xpipe_ch12_rxtermination),
    .IFCPMXPIPECHANNEL12XPIPETXDETECTRXLOOPBACK(cpm_xpipe_ch12_txdetectrxloopback),

     // PS XPIPE channel 12
    .IFPSCPMCHANNEL12XPIPERXDATA(xpipe12_rx_data),
    .IFPSCPMCHANNEL12XPIPETXDATA(xpipe12_tx_data),
    .IFPSCPMCHANNEL12XPIPERXVALID(xpipe12_rx_valid),
    .IFPSCPMCHANNEL12XPIPETXSWING(xpipe12_tx_swing),
    .IFPSCPMCHANNEL12XPIPERXSTATUS(xpipe12_rx_status),
    .IFPSCPMCHANNEL12XPIPETXDEEMPH(xpipe12_tx_deemph),
    .IFPSCPMCHANNEL12XPIPETXMARGIN(xpipe12_tx_margin),
    .IFPSCPMCHANNEL12XPIPEPHYSTATUS(xpipe12_phystatus),
    .IFPSCPMCHANNEL12XPIPEPOWERDOWN(xpipe12_powerdown),
    .IFPSCPMCHANNEL12XPIPERXCHARISK(xpipe12_rx_charisk),
    .IFPSCPMCHANNEL12XPIPETXCHARISK(xpipe12_tx_charisk),
    .IFPSCPMCHANNEL12XPIPERXELECIDLE(xpipe12_rx_elecidle),
    .IFPSCPMCHANNEL12XPIPERXPOLARITY(xpipe12_rx_polarity),
    .IFPSCPMCHANNEL12XPIPETXELECIDLE(xpipe12_tx_elecidle),
    .IFPSCPMCHANNEL12XPIPERXDATAVALID(xpipe12_rx_datavalid),
    .IFPSCPMCHANNEL12XPIPETXDATAVALID(xpipe12_tx_datavalid),
    .IFPSCPMCHANNEL12XPIPETXPRECURSOR(xpipe12_tx_precursor),
    .IFPSCPMCHANNEL12XPIPERXSTARTBLOCK(xpipe12_rx_startblock),
    .IFPSCPMCHANNEL12XPIPERXSYNCHEADER(xpipe12_rx_syncheader),
    .IFPSCPMCHANNEL12XPIPETXCOMPLIANCE(xpipe12_tx_compliance),
    .IFPSCPMCHANNEL12XPIPETXMAINCURSOR(xpipe12_tx_maincursor),
    .IFPSCPMCHANNEL12XPIPETXPOSTCURSOR(xpipe12_tx_postcursor),
    .IFPSCPMCHANNEL12XPIPETXSTARTBLOCK(xpipe12_tx_startblock),
    .IFPSCPMCHANNEL12XPIPETXSYNCHEADER(xpipe12_tx_syncheader),
    .IFPSCPMCHANNEL12XPIPERXTERMINATION(xpipe12_rx_termination),
    .IFPSCPMCHANNEL12XPIPETXDETECTRXLOOPBACK(xpipe12_tx_detectrxloopback),
     // CPM XPIPE channel 13
    .IFCPMXPIPECHANNEL13XPIPERXDATA(cpm_xpipe_ch13_rxdata),
    .IFCPMXPIPECHANNEL13XPIPETXDATA(cpm_xpipe_ch13_txdata),
    .IFCPMXPIPECHANNEL13XPIPERXVALID(cpm_xpipe_ch13_rxvalid),
    .IFCPMXPIPECHANNEL13XPIPETXSWING(cpm_xpipe_ch13_txswing),
    .IFCPMXPIPECHANNEL13XPIPERXSTATUS(cpm_xpipe_ch13_rxstatus),
    .IFCPMXPIPECHANNEL13XPIPETXDEEMPH(cpm_xpipe_ch13_txdeemph),
    .IFCPMXPIPECHANNEL13XPIPETXMARGIN(cpm_xpipe_ch13_txmargin),
    .IFCPMXPIPECHANNEL13XPIPEPHYSTATUS(cpm_xpipe_ch13_phystatus),
    .IFCPMXPIPECHANNEL13XPIPEPOWERDOWN(cpm_xpipe_ch13_powerdown),
    .IFCPMXPIPECHANNEL13XPIPERXCHARISK(cpm_xpipe_ch13_rxcharisk),
    .IFCPMXPIPECHANNEL13XPIPETXCHARISK(cpm_xpipe_ch13_txcharisk),
    .IFCPMXPIPECHANNEL13XPIPERXELECIDLE(cpm_xpipe_ch13_rxelecidle),
    .IFCPMXPIPECHANNEL13XPIPERXPOLARITY(cpm_xpipe_ch13_rxpolarity),
    .IFCPMXPIPECHANNEL13XPIPETXELECIDLE(cpm_xpipe_ch13_txelecidle),
    .IFCPMXPIPECHANNEL13XPIPERXDATAVALID(cpm_xpipe_ch13_rxdatavalid),
    .IFCPMXPIPECHANNEL13XPIPETXDATAVALID(cpm_xpipe_ch13_txdatavalid),
    .IFCPMXPIPECHANNEL13XPIPETXPRECURSOR(cpm_xpipe_ch13_txprecursor),
    .IFCPMXPIPECHANNEL13XPIPERXSTARTBLOCK(cpm_xpipe_ch13_rxstartblock),
    .IFCPMXPIPECHANNEL13XPIPERXSYNCHEADER(cpm_xpipe_ch13_rxsyncheader),
    .IFCPMXPIPECHANNEL13XPIPETXCOMPLIANCE(cpm_xpipe_ch13_txcompliance),
    .IFCPMXPIPECHANNEL13XPIPETXMAINCURSOR(cpm_xpipe_ch13_txmaincursor),
    .IFCPMXPIPECHANNEL13XPIPETXPOSTCURSOR(cpm_xpipe_ch13_txpostcursor),
    .IFCPMXPIPECHANNEL13XPIPETXSTARTBLOCK(cpm_xpipe_ch13_txstartblock),
    .IFCPMXPIPECHANNEL13XPIPETXSYNCHEADER(cpm_xpipe_ch13_txsyncheader),
    .IFCPMXPIPECHANNEL13XPIPERXTERMINATION(cpm_xpipe_ch13_rxtermination),
    .IFCPMXPIPECHANNEL13XPIPETXDETECTRXLOOPBACK(cpm_xpipe_ch13_txdetectrxloopback),

     // PS XPIPE channel 13
    .IFPSCPMCHANNEL13XPIPERXDATA(xpipe13_rx_data),
    .IFPSCPMCHANNEL13XPIPETXDATA(xpipe13_tx_data),
    .IFPSCPMCHANNEL13XPIPERXVALID(xpipe13_rx_valid),
    .IFPSCPMCHANNEL13XPIPETXSWING(xpipe13_tx_swing),
    .IFPSCPMCHANNEL13XPIPERXSTATUS(xpipe13_rx_status),
    .IFPSCPMCHANNEL13XPIPETXDEEMPH(xpipe13_tx_deemph),
    .IFPSCPMCHANNEL13XPIPETXMARGIN(xpipe13_tx_margin),
    .IFPSCPMCHANNEL13XPIPEPHYSTATUS(xpipe13_phystatus),
    .IFPSCPMCHANNEL13XPIPEPOWERDOWN(xpipe13_powerdown),
    .IFPSCPMCHANNEL13XPIPERXCHARISK(xpipe13_rx_charisk),
    .IFPSCPMCHANNEL13XPIPETXCHARISK(xpipe13_tx_charisk),
    .IFPSCPMCHANNEL13XPIPERXELECIDLE(xpipe13_rx_elecidle),
    .IFPSCPMCHANNEL13XPIPERXPOLARITY(xpipe13_rx_polarity),
    .IFPSCPMCHANNEL13XPIPETXELECIDLE(xpipe13_tx_elecidle),
    .IFPSCPMCHANNEL13XPIPERXDATAVALID(xpipe13_rx_datavalid),
    .IFPSCPMCHANNEL13XPIPETXDATAVALID(xpipe13_tx_datavalid),
    .IFPSCPMCHANNEL13XPIPETXPRECURSOR(xpipe13_tx_precursor),
    .IFPSCPMCHANNEL13XPIPERXSTARTBLOCK(xpipe13_rx_startblock),
    .IFPSCPMCHANNEL13XPIPERXSYNCHEADER(xpipe13_rx_syncheader),
    .IFPSCPMCHANNEL13XPIPETXCOMPLIANCE(xpipe13_tx_compliance),
    .IFPSCPMCHANNEL13XPIPETXMAINCURSOR(xpipe13_tx_maincursor),
    .IFPSCPMCHANNEL13XPIPETXPOSTCURSOR(xpipe13_tx_postcursor),
    .IFPSCPMCHANNEL13XPIPETXSTARTBLOCK(xpipe13_tx_startblock),
    .IFPSCPMCHANNEL13XPIPETXSYNCHEADER(xpipe13_tx_syncheader),
    .IFPSCPMCHANNEL13XPIPERXTERMINATION(xpipe13_rx_termination),
    .IFPSCPMCHANNEL13XPIPETXDETECTRXLOOPBACK(xpipe13_tx_detectrxloopback),
     // CPM XPIPE channel 14
    .IFCPMXPIPECHANNEL14XPIPERXDATA(cpm_xpipe_ch14_rxdata),
    .IFCPMXPIPECHANNEL14XPIPETXDATA(cpm_xpipe_ch14_txdata),
    .IFCPMXPIPECHANNEL14XPIPERXVALID(cpm_xpipe_ch14_rxvalid),
    .IFCPMXPIPECHANNEL14XPIPETXSWING(cpm_xpipe_ch14_txswing),
    .IFCPMXPIPECHANNEL14XPIPERXSTATUS(cpm_xpipe_ch14_rxstatus),
    .IFCPMXPIPECHANNEL14XPIPETXDEEMPH(cpm_xpipe_ch14_txdeemph),
    .IFCPMXPIPECHANNEL14XPIPETXMARGIN(cpm_xpipe_ch14_txmargin),
    .IFCPMXPIPECHANNEL14XPIPEPHYSTATUS(cpm_xpipe_ch14_phystatus),
    .IFCPMXPIPECHANNEL14XPIPEPOWERDOWN(cpm_xpipe_ch14_powerdown),
    .IFCPMXPIPECHANNEL14XPIPERXCHARISK(cpm_xpipe_ch14_rxcharisk),
    .IFCPMXPIPECHANNEL14XPIPETXCHARISK(cpm_xpipe_ch14_txcharisk),
    .IFCPMXPIPECHANNEL14XPIPERXELECIDLE(cpm_xpipe_ch14_rxelecidle),
    .IFCPMXPIPECHANNEL14XPIPERXPOLARITY(cpm_xpipe_ch14_rxpolarity),
    .IFCPMXPIPECHANNEL14XPIPETXELECIDLE(cpm_xpipe_ch14_txelecidle),
    .IFCPMXPIPECHANNEL14XPIPERXDATAVALID(cpm_xpipe_ch14_rxdatavalid),
    .IFCPMXPIPECHANNEL14XPIPETXDATAVALID(cpm_xpipe_ch14_txdatavalid),
    .IFCPMXPIPECHANNEL14XPIPETXPRECURSOR(cpm_xpipe_ch14_txprecursor),
    .IFCPMXPIPECHANNEL14XPIPERXSTARTBLOCK(cpm_xpipe_ch14_rxstartblock),
    .IFCPMXPIPECHANNEL14XPIPERXSYNCHEADER(cpm_xpipe_ch14_rxsyncheader),
    .IFCPMXPIPECHANNEL14XPIPETXCOMPLIANCE(cpm_xpipe_ch14_txcompliance),
    .IFCPMXPIPECHANNEL14XPIPETXMAINCURSOR(cpm_xpipe_ch14_txmaincursor),
    .IFCPMXPIPECHANNEL14XPIPETXPOSTCURSOR(cpm_xpipe_ch14_txpostcursor),
    .IFCPMXPIPECHANNEL14XPIPETXSTARTBLOCK(cpm_xpipe_ch14_txstartblock),
    .IFCPMXPIPECHANNEL14XPIPETXSYNCHEADER(cpm_xpipe_ch14_txsyncheader),
    .IFCPMXPIPECHANNEL14XPIPERXTERMINATION(cpm_xpipe_ch14_rxtermination),
    .IFCPMXPIPECHANNEL14XPIPETXDETECTRXLOOPBACK(cpm_xpipe_ch14_txdetectrxloopback),

     // PS XPIPE channel 14
    .IFPSCPMCHANNEL14XPIPERXDATA(xpipe14_rx_data),
    .IFPSCPMCHANNEL14XPIPETXDATA(xpipe14_tx_data),
    .IFPSCPMCHANNEL14XPIPERXVALID(xpipe14_rx_valid),
    .IFPSCPMCHANNEL14XPIPETXSWING(xpipe14_tx_swing),
    .IFPSCPMCHANNEL14XPIPERXSTATUS(xpipe14_rx_status),
    .IFPSCPMCHANNEL14XPIPETXDEEMPH(xpipe14_tx_deemph),
    .IFPSCPMCHANNEL14XPIPETXMARGIN(xpipe14_tx_margin),
    .IFPSCPMCHANNEL14XPIPEPHYSTATUS(xpipe14_phystatus),
    .IFPSCPMCHANNEL14XPIPEPOWERDOWN(xpipe14_powerdown),
    .IFPSCPMCHANNEL14XPIPERXCHARISK(xpipe14_rx_charisk),
    .IFPSCPMCHANNEL14XPIPETXCHARISK(xpipe14_tx_charisk),
    .IFPSCPMCHANNEL14XPIPERXELECIDLE(xpipe14_rx_elecidle),
    .IFPSCPMCHANNEL14XPIPERXPOLARITY(xpipe14_rx_polarity),
    .IFPSCPMCHANNEL14XPIPETXELECIDLE(xpipe14_tx_elecidle),
    .IFPSCPMCHANNEL14XPIPERXDATAVALID(xpipe14_rx_datavalid),
    .IFPSCPMCHANNEL14XPIPETXDATAVALID(xpipe14_tx_datavalid),
    .IFPSCPMCHANNEL14XPIPETXPRECURSOR(xpipe14_tx_precursor),
    .IFPSCPMCHANNEL14XPIPERXSTARTBLOCK(xpipe14_rx_startblock),
    .IFPSCPMCHANNEL14XPIPERXSYNCHEADER(xpipe14_rx_syncheader),
    .IFPSCPMCHANNEL14XPIPETXCOMPLIANCE(xpipe14_tx_compliance),
    .IFPSCPMCHANNEL14XPIPETXMAINCURSOR(xpipe14_tx_maincursor),
    .IFPSCPMCHANNEL14XPIPETXPOSTCURSOR(xpipe14_tx_postcursor),
    .IFPSCPMCHANNEL14XPIPETXSTARTBLOCK(xpipe14_tx_startblock),
    .IFPSCPMCHANNEL14XPIPETXSYNCHEADER(xpipe14_tx_syncheader),
    .IFPSCPMCHANNEL14XPIPERXTERMINATION(xpipe14_rx_termination),
    .IFPSCPMCHANNEL14XPIPETXDETECTRXLOOPBACK(xpipe14_tx_detectrxloopback),
     // CPM XPIPE channel 15
    .IFCPMXPIPECHANNEL15XPIPERXDATA(cpm_xpipe_ch15_rxdata),
    .IFCPMXPIPECHANNEL15XPIPETXDATA(cpm_xpipe_ch15_txdata),
    .IFCPMXPIPECHANNEL15XPIPERXVALID(cpm_xpipe_ch15_rxvalid),
    .IFCPMXPIPECHANNEL15XPIPETXSWING(cpm_xpipe_ch15_txswing),
    .IFCPMXPIPECHANNEL15XPIPERXSTATUS(cpm_xpipe_ch15_rxstatus),
    .IFCPMXPIPECHANNEL15XPIPETXDEEMPH(cpm_xpipe_ch15_txdeemph),
    .IFCPMXPIPECHANNEL15XPIPETXMARGIN(cpm_xpipe_ch15_txmargin),
    .IFCPMXPIPECHANNEL15XPIPEPHYSTATUS(cpm_xpipe_ch15_phystatus),
    .IFCPMXPIPECHANNEL15XPIPEPOWERDOWN(cpm_xpipe_ch15_powerdown),
    .IFCPMXPIPECHANNEL15XPIPERXCHARISK(cpm_xpipe_ch15_rxcharisk),
    .IFCPMXPIPECHANNEL15XPIPETXCHARISK(cpm_xpipe_ch15_txcharisk),
    .IFCPMXPIPECHANNEL15XPIPERXELECIDLE(cpm_xpipe_ch15_rxelecidle),
    .IFCPMXPIPECHANNEL15XPIPERXPOLARITY(cpm_xpipe_ch15_rxpolarity),
    .IFCPMXPIPECHANNEL15XPIPETXELECIDLE(cpm_xpipe_ch15_txelecidle),
    .IFCPMXPIPECHANNEL15XPIPERXDATAVALID(cpm_xpipe_ch15_rxdatavalid),
    .IFCPMXPIPECHANNEL15XPIPETXDATAVALID(cpm_xpipe_ch15_txdatavalid),
    .IFCPMXPIPECHANNEL15XPIPETXPRECURSOR(cpm_xpipe_ch15_txprecursor),
    .IFCPMXPIPECHANNEL15XPIPERXSTARTBLOCK(cpm_xpipe_ch15_rxstartblock),
    .IFCPMXPIPECHANNEL15XPIPERXSYNCHEADER(cpm_xpipe_ch15_rxsyncheader),
    .IFCPMXPIPECHANNEL15XPIPETXCOMPLIANCE(cpm_xpipe_ch15_txcompliance),
    .IFCPMXPIPECHANNEL15XPIPETXMAINCURSOR(cpm_xpipe_ch15_txmaincursor),
    .IFCPMXPIPECHANNEL15XPIPETXPOSTCURSOR(cpm_xpipe_ch15_txpostcursor),
    .IFCPMXPIPECHANNEL15XPIPETXSTARTBLOCK(cpm_xpipe_ch15_txstartblock),
    .IFCPMXPIPECHANNEL15XPIPETXSYNCHEADER(cpm_xpipe_ch15_txsyncheader),
    .IFCPMXPIPECHANNEL15XPIPERXTERMINATION(cpm_xpipe_ch15_rxtermination),
    .IFCPMXPIPECHANNEL15XPIPETXDETECTRXLOOPBACK(cpm_xpipe_ch15_txdetectrxloopback),

     // PS XPIPE channel 15
    .IFPSCPMCHANNEL15XPIPERXDATA(xpipe15_rx_data),
    .IFPSCPMCHANNEL15XPIPETXDATA(xpipe15_tx_data),
    .IFPSCPMCHANNEL15XPIPERXVALID(xpipe15_rx_valid),
    .IFPSCPMCHANNEL15XPIPETXSWING(xpipe15_tx_swing),
    .IFPSCPMCHANNEL15XPIPERXSTATUS(xpipe15_rx_status),
    .IFPSCPMCHANNEL15XPIPETXDEEMPH(xpipe15_tx_deemph),
    .IFPSCPMCHANNEL15XPIPETXMARGIN(xpipe15_tx_margin),
    .IFPSCPMCHANNEL15XPIPEPHYSTATUS(xpipe15_phystatus),
    .IFPSCPMCHANNEL15XPIPEPOWERDOWN(xpipe15_powerdown),
    .IFPSCPMCHANNEL15XPIPERXCHARISK(xpipe15_rx_charisk),
    .IFPSCPMCHANNEL15XPIPETXCHARISK(xpipe15_tx_charisk),
    .IFPSCPMCHANNEL15XPIPERXELECIDLE(xpipe15_rx_elecidle),
    .IFPSCPMCHANNEL15XPIPERXPOLARITY(xpipe15_rx_polarity),
    .IFPSCPMCHANNEL15XPIPETXELECIDLE(xpipe15_tx_elecidle),
    .IFPSCPMCHANNEL15XPIPERXDATAVALID(xpipe15_rx_datavalid),
    .IFPSCPMCHANNEL15XPIPETXDATAVALID(xpipe15_tx_datavalid),
    .IFPSCPMCHANNEL15XPIPETXPRECURSOR(xpipe15_tx_precursor),
    .IFPSCPMCHANNEL15XPIPERXSTARTBLOCK(xpipe15_rx_startblock),
    .IFPSCPMCHANNEL15XPIPERXSYNCHEADER(xpipe15_rx_syncheader),
    .IFPSCPMCHANNEL15XPIPETXCOMPLIANCE(xpipe15_tx_compliance),
    .IFPSCPMCHANNEL15XPIPETXMAINCURSOR(xpipe15_tx_maincursor),
    .IFPSCPMCHANNEL15XPIPETXPOSTCURSOR(xpipe15_tx_postcursor),
    .IFPSCPMCHANNEL15XPIPETXSTARTBLOCK(xpipe15_tx_startblock),
    .IFPSCPMCHANNEL15XPIPETXSYNCHEADER(xpipe15_tx_syncheader),
    .IFPSCPMCHANNEL15XPIPERXTERMINATION(xpipe15_rx_termination),
    .IFPSCPMCHANNEL15XPIPETXDETECTRXLOOPBACK(xpipe15_tx_detectrxloopback),

     // HSDP XPIPE channel 0
    .IFCPMXPIPEHSDPCHANNEL0XPIPERXHEADER(hsdp_xpipe_ch0_rxheader),
    .IFCPMXPIPEHSDPCHANNEL0XPIPETXHEADER(hsdp_xpipe_ch0_txheader),
    .IFCPMXPIPEHSDPCHANNEL0XPIPERXPCSRESET(hsdp_xpipe_ch0_rxpcsreset),
    .IFCPMXPIPEHSDPCHANNEL0XPIPETXSEQUENCE(hsdp_xpipe_ch0_txsequence),
    .IFCPMXPIPEHSDPCHANNEL0XPIPERXDATAVALID(hsdp_xpipe_ch0_rxdatavalid),
    .IFCPMXPIPEHSDPCHANNEL0XPIPERXRESETDONE(hsdp_xpipe_ch0_rxresetdone),
    .IFCPMXPIPEHSDPCHANNEL0XPIPETXRESETDONE(hsdp_xpipe_ch0_txresetdone),
    .IFCPMXPIPEHSDPCHANNEL0XPIPERXGEARBOXSLIP(hsdp_xpipe_ch0_rxgearboxslip),
    .IFCPMXPIPEHSDPCHANNEL0XPIPERXHEADERVALID(hsdp_xpipe_ch0_rxheadervalid),

    .IFPSCPMHSDPCHANNEL0XPIPERXHEADER(hsdp_xpipe0_rx_header),
    .IFPSCPMHSDPCHANNEL0XPIPETXHEADER(hsdp_xpipe0_tx_header),
    .IFPSCPMHSDPCHANNEL0XPIPERXPCSRESET(hsdp_xpipe0_rx_pcsreset),
    .IFPSCPMHSDPCHANNEL0XPIPETXSEQUENCE(hsdp_xpipe0_tx_sequence),
    .IFPSCPMHSDPCHANNEL0XPIPERXDATAVALID(hsdp_xpipe0_rx_datavalid),
    .IFPSCPMHSDPCHANNEL0XPIPERXRESETDONE(hsdp_xpipe0_rx_resetdone),
    .IFPSCPMHSDPCHANNEL0XPIPETXRESETDONE(hsdp_xpipe0_tx_resetdone),
    .IFPSCPMHSDPCHANNEL0XPIPERXGEARBOXSLIP(hsdp_xpipe0_rx_gearboxslip),
    .IFPSCPMHSDPCHANNEL0XPIPERXHEADERVALID(hsdp_xpipe0_rx_headervalid),
     // HSDP XPIPE channel 1
    .IFCPMXPIPEHSDPCHANNEL1XPIPERXHEADER(hsdp_xpipe_ch1_rxheader),
    .IFCPMXPIPEHSDPCHANNEL1XPIPETXHEADER(hsdp_xpipe_ch1_txheader),
    .IFCPMXPIPEHSDPCHANNEL1XPIPERXPCSRESET(hsdp_xpipe_ch1_rxpcsreset),
    .IFCPMXPIPEHSDPCHANNEL1XPIPETXSEQUENCE(hsdp_xpipe_ch1_txsequence),
    .IFCPMXPIPEHSDPCHANNEL1XPIPERXDATAVALID(hsdp_xpipe_ch1_rxdatavalid),
    .IFCPMXPIPEHSDPCHANNEL1XPIPERXRESETDONE(hsdp_xpipe_ch1_rxresetdone),
    .IFCPMXPIPEHSDPCHANNEL1XPIPETXRESETDONE(hsdp_xpipe_ch1_txresetdone),
    .IFCPMXPIPEHSDPCHANNEL1XPIPERXGEARBOXSLIP(hsdp_xpipe_ch1_rxgearboxslip),
    .IFCPMXPIPEHSDPCHANNEL1XPIPERXHEADERVALID(hsdp_xpipe_ch1_rxheadervalid),

    .IFPSCPMHSDPCHANNEL1XPIPERXHEADER(hsdp_xpipe1_rx_header),
    .IFPSCPMHSDPCHANNEL1XPIPETXHEADER(hsdp_xpipe1_tx_header),
    .IFPSCPMHSDPCHANNEL1XPIPERXPCSRESET(hsdp_xpipe1_rx_pcsreset),
    .IFPSCPMHSDPCHANNEL1XPIPETXSEQUENCE(hsdp_xpipe1_tx_sequence),
    .IFPSCPMHSDPCHANNEL1XPIPERXDATAVALID(hsdp_xpipe1_rx_datavalid),
    .IFPSCPMHSDPCHANNEL1XPIPERXRESETDONE(hsdp_xpipe1_rx_resetdone),
    .IFPSCPMHSDPCHANNEL1XPIPETXRESETDONE(hsdp_xpipe1_tx_resetdone),
    .IFPSCPMHSDPCHANNEL1XPIPERXGEARBOXSLIP(hsdp_xpipe1_rx_gearboxslip),
    .IFPSCPMHSDPCHANNEL1XPIPERXHEADERVALID(hsdp_xpipe1_rx_headervalid),
     // HSDP XPIPE channel 2
    .IFCPMXPIPEHSDPCHANNEL2XPIPERXHEADER(hsdp_xpipe_ch2_rxheader),
    .IFCPMXPIPEHSDPCHANNEL2XPIPETXHEADER(hsdp_xpipe_ch2_txheader),
    .IFCPMXPIPEHSDPCHANNEL2XPIPERXPCSRESET(hsdp_xpipe_ch2_rxpcsreset),
    .IFCPMXPIPEHSDPCHANNEL2XPIPETXSEQUENCE(hsdp_xpipe_ch2_txsequence),
    .IFCPMXPIPEHSDPCHANNEL2XPIPERXDATAVALID(hsdp_xpipe_ch2_rxdatavalid),
    .IFCPMXPIPEHSDPCHANNEL2XPIPERXRESETDONE(hsdp_xpipe_ch2_rxresetdone),
    .IFCPMXPIPEHSDPCHANNEL2XPIPETXRESETDONE(hsdp_xpipe_ch2_txresetdone),
    .IFCPMXPIPEHSDPCHANNEL2XPIPERXGEARBOXSLIP(hsdp_xpipe_ch2_rxgearboxslip),
    .IFCPMXPIPEHSDPCHANNEL2XPIPERXHEADERVALID(hsdp_xpipe_ch2_rxheadervalid),

    .IFPSCPMHSDPCHANNEL2XPIPERXHEADER(hsdp_xpipe2_rx_header),
    .IFPSCPMHSDPCHANNEL2XPIPETXHEADER(hsdp_xpipe2_tx_header),
    .IFPSCPMHSDPCHANNEL2XPIPERXPCSRESET(hsdp_xpipe2_rx_pcsreset),
    .IFPSCPMHSDPCHANNEL2XPIPETXSEQUENCE(hsdp_xpipe2_tx_sequence),
    .IFPSCPMHSDPCHANNEL2XPIPERXDATAVALID(hsdp_xpipe2_rx_datavalid),
    .IFPSCPMHSDPCHANNEL2XPIPERXRESETDONE(hsdp_xpipe2_rx_resetdone),
    .IFPSCPMHSDPCHANNEL2XPIPETXRESETDONE(hsdp_xpipe2_tx_resetdone),
    .IFPSCPMHSDPCHANNEL2XPIPERXGEARBOXSLIP(hsdp_xpipe2_rx_gearboxslip),
    .IFPSCPMHSDPCHANNEL2XPIPERXHEADERVALID(hsdp_xpipe2_rx_headervalid),

    // XPIPE Rx Margin interface 0
    .IFCPMXPIPEQUAD0XPIPERXMARGINREQCMD(xpipe_rxmarginreqcmd_0),
    .IFCPMXPIPEQUAD0XPIPERXMARGINRESCMD(xpipe_rxmarginrescmd_0),
    .IFCPMXPIPEQUAD0XPIPERXMARGINREQREQ(xpipe_rxmarginreqreq_0),
    .IFCPMXPIPEQUAD0XPIPERXMARGINRESREQ(xpipe_rxmarginresreq_0),
    .IFCPMXPIPEQUAD0XPIPERXMARGINREQACK(xpipe_rxmarginreqack_0),
    .IFCPMXPIPEQUAD0XPIPERXMARGINRESACK(xpipe_rxmarginresack_0),
    .IFCPMXPIPEQUAD0XPIPERXMARGINREQLANENUM(xpipe_rxmarginreqlanenum_0),
    .IFCPMXPIPEQUAD0XPIPERXMARGINRESLANENUM(xpipe_rxmarginreslanenum_0),
    .IFCPMXPIPEQUAD0XPIPERXMARGINREQPAYLOAD(xpipe_rxmarginreqpayload_0),
    .IFCPMXPIPEQUAD0XPIPERXMARGINRESPAYLOAD(xpipe_rxmarginrespayload_0),

    .IFPSCPMQUAD0XPIPERXMARGINREQACK(xpipe_q0_rxmargin_req_ack),
    .IFPSCPMQUAD0XPIPERXMARGINRESACK(xpipe_q0_rxmargin_res_ack),
    .IFPSCPMQUAD0XPIPERXMARGINREQCMD(xpipe_q0_rxmargin_req_cmd),
    .IFPSCPMQUAD0XPIPERXMARGINRESCMD(xpipe_q0_rxmargin_res_cmd),
    .IFPSCPMQUAD0XPIPERXMARGINREQREQ(xpipe_q0_rxmargin_req_req),
    .IFPSCPMQUAD0XPIPERXMARGINRESREQ(xpipe_q0_rxmargin_res_req),
    .IFPSCPMQUAD0XPIPERXMARGINREQLANENUM(xpipe_q0_rxmargin_req_lanenum),
    .IFPSCPMQUAD0XPIPERXMARGINRESLANENUM(xpipe_q0_rxmargin_res_lanenum),
    .IFPSCPMQUAD0XPIPERXMARGINREQPAYLOAD(xpipe_q0_rxmargin_req_payload),
    .IFPSCPMQUAD0XPIPERXMARGINRESPAYLOAD(xpipe_q0_rxmargin_res_payload),

    // XPIPE Rx Margin interface 1
    .IFCPMXPIPEQUAD1XPIPERXMARGINREQCMD(xpipe_rxmarginreqcmd_1),
    .IFCPMXPIPEQUAD1XPIPERXMARGINRESCMD(xpipe_rxmarginrescmd_1),
    .IFCPMXPIPEQUAD1XPIPERXMARGINREQREQ(xpipe_rxmarginreqreq_1),
    .IFCPMXPIPEQUAD1XPIPERXMARGINRESREQ(xpipe_rxmarginresreq_1),
    .IFCPMXPIPEQUAD1XPIPERXMARGINREQACK(xpipe_rxmarginreqack_1),
    .IFCPMXPIPEQUAD1XPIPERXMARGINRESACK(xpipe_rxmarginresack_1),
    .IFCPMXPIPEQUAD1XPIPERXMARGINREQLANENUM(xpipe_rxmarginreqlanenum_1),
    .IFCPMXPIPEQUAD1XPIPERXMARGINRESLANENUM(xpipe_rxmarginreslanenum_1),
    .IFCPMXPIPEQUAD1XPIPERXMARGINREQPAYLOAD(xpipe_rxmarginreqpayload_1),
    .IFCPMXPIPEQUAD1XPIPERXMARGINRESPAYLOAD(xpipe_rxmarginrespayload_1),

    .IFPSCPMQUAD1XPIPERXMARGINREQACK(xpipe_q1_rxmargin_req_ack),
    .IFPSCPMQUAD1XPIPERXMARGINRESACK(xpipe_q1_rxmargin_res_ack),
    .IFPSCPMQUAD1XPIPERXMARGINREQCMD(xpipe_q1_rxmargin_req_cmd),
    .IFPSCPMQUAD1XPIPERXMARGINRESCMD(xpipe_q1_rxmargin_res_cmd),
    .IFPSCPMQUAD1XPIPERXMARGINREQREQ(xpipe_q1_rxmargin_req_req),
    .IFPSCPMQUAD1XPIPERXMARGINRESREQ(xpipe_q1_rxmargin_res_req),
    .IFPSCPMQUAD1XPIPERXMARGINREQLANENUM(xpipe_q1_rxmargin_req_lanenum),
    .IFPSCPMQUAD1XPIPERXMARGINRESLANENUM(xpipe_q1_rxmargin_res_lanenum),
    .IFPSCPMQUAD1XPIPERXMARGINREQPAYLOAD(xpipe_q1_rxmargin_req_payload),
    .IFPSCPMQUAD1XPIPERXMARGINRESPAYLOAD(xpipe_q1_rxmargin_res_payload),

    // XPIPE Rx Margin interface 2
    .IFCPMXPIPEQUAD2XPIPERXMARGINREQCMD(xpipe_rxmarginreqcmd_2),
    .IFCPMXPIPEQUAD2XPIPERXMARGINRESCMD(xpipe_rxmarginrescmd_2),
    .IFCPMXPIPEQUAD2XPIPERXMARGINREQREQ(xpipe_rxmarginreqreq_2),
    .IFCPMXPIPEQUAD2XPIPERXMARGINRESREQ(xpipe_rxmarginresreq_2),
    .IFCPMXPIPEQUAD2XPIPERXMARGINREQACK(xpipe_rxmarginreqack_2),
    .IFCPMXPIPEQUAD2XPIPERXMARGINRESACK(xpipe_rxmarginresack_2),
    .IFCPMXPIPEQUAD2XPIPERXMARGINREQLANENUM(xpipe_rxmarginreqlanenum_2),
    .IFCPMXPIPEQUAD2XPIPERXMARGINRESLANENUM(xpipe_rxmarginreslanenum_2),
    .IFCPMXPIPEQUAD2XPIPERXMARGINREQPAYLOAD(xpipe_rxmarginreqpayload_2),
    .IFCPMXPIPEQUAD2XPIPERXMARGINRESPAYLOAD(xpipe_rxmarginrespayload_2),

    .IFPSCPMQUAD2XPIPERXMARGINREQACK(xpipe_q2_rxmargin_req_ack),
    .IFPSCPMQUAD2XPIPERXMARGINRESACK(xpipe_q2_rxmargin_res_ack),
    .IFPSCPMQUAD2XPIPERXMARGINREQCMD(xpipe_q2_rxmargin_req_cmd),
    .IFPSCPMQUAD2XPIPERXMARGINRESCMD(xpipe_q2_rxmargin_res_cmd),
    .IFPSCPMQUAD2XPIPERXMARGINREQREQ(xpipe_q2_rxmargin_req_req),
    .IFPSCPMQUAD2XPIPERXMARGINRESREQ(xpipe_q2_rxmargin_res_req),
    .IFPSCPMQUAD2XPIPERXMARGINREQLANENUM(xpipe_q2_rxmargin_req_lanenum),
    .IFPSCPMQUAD2XPIPERXMARGINRESLANENUM(xpipe_q2_rxmargin_res_lanenum),
    .IFPSCPMQUAD2XPIPERXMARGINREQPAYLOAD(xpipe_q2_rxmargin_req_payload),
    .IFPSCPMQUAD2XPIPERXMARGINRESPAYLOAD(xpipe_q2_rxmargin_res_payload),

    // XPIPE Rx Margin interface 3
    .IFCPMXPIPEQUAD3XPIPERXMARGINREQCMD(xpipe_rxmarginreqcmd_3),
    .IFCPMXPIPEQUAD3XPIPERXMARGINRESCMD(xpipe_rxmarginrescmd_3),
    .IFCPMXPIPEQUAD3XPIPERXMARGINREQREQ(xpipe_rxmarginreqreq_3),
    .IFCPMXPIPEQUAD3XPIPERXMARGINRESREQ(xpipe_rxmarginresreq_3),
    .IFCPMXPIPEQUAD3XPIPERXMARGINREQACK(xpipe_rxmarginreqack_3),
    .IFCPMXPIPEQUAD3XPIPERXMARGINRESACK(xpipe_rxmarginresack_3),
    .IFCPMXPIPEQUAD3XPIPERXMARGINREQLANENUM(xpipe_rxmarginreqlanenum_3),
    .IFCPMXPIPEQUAD3XPIPERXMARGINRESLANENUM(xpipe_rxmarginreslanenum_3),
    .IFCPMXPIPEQUAD3XPIPERXMARGINREQPAYLOAD(xpipe_rxmarginreqpayload_3),
    .IFCPMXPIPEQUAD3XPIPERXMARGINRESPAYLOAD(xpipe_rxmarginrespayload_3),

    .IFPSCPMQUAD3XPIPERXMARGINREQACK(xpipe_q3_rxmargin_req_ack),
    .IFPSCPMQUAD3XPIPERXMARGINRESACK(xpipe_q3_rxmargin_res_ack),
    .IFPSCPMQUAD3XPIPERXMARGINREQCMD(xpipe_q3_rxmargin_req_cmd),
    .IFPSCPMQUAD3XPIPERXMARGINRESCMD(xpipe_q3_rxmargin_res_cmd),
    .IFPSCPMQUAD3XPIPERXMARGINREQREQ(xpipe_q3_rxmargin_req_req),
    .IFPSCPMQUAD3XPIPERXMARGINRESREQ(xpipe_q3_rxmargin_res_req),
    .IFPSCPMQUAD3XPIPERXMARGINREQLANENUM(xpipe_q3_rxmargin_req_lanenum),
    .IFPSCPMQUAD3XPIPERXMARGINRESLANENUM(xpipe_q3_rxmargin_res_lanenum),
    .IFPSCPMQUAD3XPIPERXMARGINREQPAYLOAD(xpipe_q3_rxmargin_req_payload),
    .IFPSCPMQUAD3XPIPERXMARGINRESPAYLOAD(xpipe_q3_rxmargin_res_payload),


    // XPIPE Link 0 interface
    .IFCPMXPIPELINK0XPIPEBUFGTCE(xpipe_lnk0_bufgtce),
    .IFCPMXPIPELINK0XPIPEBUFGTDIV(xpipe_lnk0_bufgtdiv),
    .IFCPMXPIPELINK0XPIPEBUFGTRST(xpipe_lnk0_bufgtrst),
    .IFCPMXPIPELINK0XPIPEGTOUTCLK(xpipe_lnk0_gt_outclk),
    .IFCPMXPIPELINK0XPIPEPHYREADY(xpipe_lnk0_phy_ready),
    .IFCPMXPIPELINK0XPIPEPIPERATE(xpipe_lnk0_pcie_rate),
    .IFCPMXPIPELINK0XPIPEGTPIPECLK(xpipe_lnk0_gt_pipeclk),
    .IFCPMXPIPELINK0XPIPEPCIEPERSTN(xpipe_lnk0_pcie_perst_n),
    .IFCPMXPIPELINK0XPIPEBUFGTCEMASK(xpipe_lnk0_bufgtce_mask),
    .IFCPMXPIPELINK0XPIPEBUFGTRSTMASK(xpipe_lnk0_bufgtrst_mask),
    .IFCPMXPIPELINK0XPIPEPCIELTSSMSTATE(xpipe_lnk0_pcieltssmstate),
    .IFCPMXPIPELINK0XPIPEPHYESMADAPTATIONSAVE(xpipe_lnk0_phyesmadaptsave),
    .IFCPMXPIPELINK0XPIPEPCIELINKREACHTARGET(xpipe_lnk0_pcielinkreachtarget),

    .IFPSCPMLINK0XPIPEBUFGTCE(link0_xpipe_bufgtce),
    .IFPSCPMLINK0XPIPEBUFGTDIV(link0_xpipe_bufgtdiv),
    .IFPSCPMLINK0XPIPEBUFGTRST(link0_xpipe_bufgtrst),
    .IFPSCPMLINK0XPIPEGTOUTCLK(link0_xpipe_gtoutclk),
    .IFPSCPMLINK0XPIPEPHYREADY(link0_xpipe_phyready),
    .IFPSCPMLINK0XPIPEPIPERATE(link0_xpipe_piperate),
    .IFPSCPMLINK0XPIPEGTPIPECLK(link0_xpipe_gtpipeclk),
    .IFPSCPMLINK0XPIPEPCIEPERSTN(link0_xpipe_pcieperstn),
    .IFPSCPMLINK0XPIPEBUFGTCEMASK(link0_xpipe_bufgtcemask),
    .IFPSCPMLINK0XPIPEBUFGTRSTMASK(link0_xpipe_bufgtrstmask),
    .IFPSCPMLINK0XPIPEPCIELTSSMSTATE(link0_xpipe_pcieltssmstate),
    .IFPSCPMLINK0XPIPEPCIELINKREACHTARGET(link0_xpipe_pcielinkreachtarget),
    .IFPSCPMLINK0XPIPEPHYESMADAPTATIONSAVE(link0_xpipe_phyesmadaptationsave),

    // XPIPE Link 1 interface
    .IFCPMXPIPELINK1XPIPEBUFGTCE(xpipe_lnk1_bufgtce),
    .IFCPMXPIPELINK1XPIPEBUFGTDIV(xpipe_lnk1_bufgtdiv),
    .IFCPMXPIPELINK1XPIPEBUFGTRST(xpipe_lnk1_bufgtrst),
    .IFCPMXPIPELINK1XPIPEGTOUTCLK(xpipe_lnk1_gt_outclk),
    .IFCPMXPIPELINK1XPIPEPHYREADY(xpipe_lnk1_phy_ready),
    .IFCPMXPIPELINK1XPIPEPIPERATE(xpipe_lnk1_pcie_rate),
    .IFCPMXPIPELINK1XPIPEGTPIPECLK(xpipe_lnk1_gt_pipeclk),
    .IFCPMXPIPELINK1XPIPEPCIEPERSTN(xpipe_lnk1_pcie_perst_n),
    .IFCPMXPIPELINK1XPIPEBUFGTCEMASK(xpipe_lnk1_bufgtce_mask),
    .IFCPMXPIPELINK1XPIPEBUFGTRSTMASK(xpipe_lnk1_bufgtrst_mask),
    .IFCPMXPIPELINK1XPIPEPCIELTSSMSTATE(xpipe_lnk1_pcieltssmstate),
    .IFCPMXPIPELINK1XPIPEPHYESMADAPTATIONSAVE(xpipe_lnk1_phyesmadaptsave),
    .IFCPMXPIPELINK1XPIPEPCIELINKREACHTARGET(xpipe_lnk1_pcielinkreachtarget),

    .IFPSCPMLINK1XPIPEBUFGTCE(link1_xpipe_bufgtce),
    .IFPSCPMLINK1XPIPEBUFGTDIV(link1_xpipe_bufgtdiv),
    .IFPSCPMLINK1XPIPEBUFGTRST(link1_xpipe_bufgtrst),
    .IFPSCPMLINK1XPIPEGTOUTCLK(link1_xpipe_gtoutclk),
    .IFPSCPMLINK1XPIPEPHYREADY(link1_xpipe_phyready),
    .IFPSCPMLINK1XPIPEPIPERATE(link1_xpipe_piperate),
    .IFPSCPMLINK1XPIPEGTPIPECLK(link1_xpipe_gtpipeclk),
    .IFPSCPMLINK1XPIPEPCIEPERSTN(link1_xpipe_pcieperstn),
    .IFPSCPMLINK1XPIPEBUFGTCEMASK(link1_xpipe_bufgtcemask),
    .IFPSCPMLINK1XPIPEBUFGTRSTMASK(link1_xpipe_bufgtrstmask),
    .IFPSCPMLINK1XPIPEPCIELTSSMSTATE(link1_xpipe_pcieltssmstate),
    .IFPSCPMLINK1XPIPEPCIELINKREACHTARGET(link1_xpipe_pcielinkreachtarget),
    .IFPSCPMLINK1XPIPEPHYESMADAPTATIONSAVE(link1_xpipe_phyesmadaptationsave),


    // CPM -> PS AXI0
    .IFCPMPSAXI0BID(m_axi0_ps_bid),
    .IFCPMPSAXI0RID(m_axi0_ps_rid),
    .IFCPMPSAXI0WID(m_axi0_ps_wid),
    .IFCPMPSAXI0ARID(m_axi0_ps_arid),
    .IFCPMPSAXI0AWID(m_axi0_ps_awid),
    .IFCPMPSAXI0ARLEN(m_axi0_ps_arlen),
    .IFCPMPSAXI0ARQOS(m_axi0_ps_arqos),
    .IFCPMPSAXI0AWLEN(m_axi0_ps_awlen),
    .IFCPMPSAXI0AWQOS(m_axi0_ps_awqos),
    .IFCPMPSAXI0BRESP(m_axi0_ps_bresp),
    .IFCPMPSAXI0BUSER(m_axi0_ps_buser),
    .IFCPMPSAXI0RDATA(m_axi0_ps_rdata),
    .IFCPMPSAXI0RLAST(m_axi0_ps_rlast),
    .IFCPMPSAXI0RRESP(m_axi0_ps_rresp),
    .IFCPMPSAXI0RUSER(m_axi0_ps_ruser),
    .IFCPMPSAXI0WDATA(m_axi0_ps_wdata),
    .IFCPMPSAXI0WLAST(m_axi0_ps_wlast),
    .IFCPMPSAXI0WSTRB(m_axi0_ps_wstrb),
    .IFCPMPSAXI0WUSER(m_axi0_ps_wuser),
    .IFCPMPSAXI0ARADDR(m_axi0_ps_araddr),
    .IFCPMPSAXI0ARLOCK(m_axi0_ps_arlock),
    .IFCPMPSAXI0ARPROT(m_axi0_ps_arprot),
    .IFCPMPSAXI0ARSIZE(m_axi0_ps_arsize),
    .IFCPMPSAXI0ARUSER(m_axi0_ps_aruser),
    .IFCPMPSAXI0AWADDR(m_axi0_ps_awaddr),
    .IFCPMPSAXI0AWLOCK(m_axi0_ps_awlock),
    .IFCPMPSAXI0AWPROT(m_axi0_ps_awprot),
    .IFCPMPSAXI0AWSIZE(m_axi0_ps_awsize),
    .IFCPMPSAXI0AWUSER(m_axi0_ps_awuser),
    .IFCPMPSAXI0BREADY(m_axi0_ps_bready),
    .IFCPMPSAXI0BVALID(m_axi0_ps_bvalid),
    .IFCPMPSAXI0RREADY(m_axi0_ps_rready),
    .IFCPMPSAXI0RVALID(m_axi0_ps_rvalid),
    .IFCPMPSAXI0WREADY(m_axi0_ps_wready),
    .IFCPMPSAXI0WVALID(m_axi0_ps_wvalid),
    .IFCPMPSAXI0ARBURST(m_axi0_ps_arburst),
    .IFCPMPSAXI0ARCACHE(m_axi0_ps_arcache),
    .IFCPMPSAXI0ARREADY(m_axi0_ps_arready),
    .IFCPMPSAXI0ARVALID(m_axi0_ps_arvalid),
    .IFCPMPSAXI0AWBURST(m_axi0_ps_awburst),
    .IFCPMPSAXI0AWCACHE(m_axi0_ps_awcache),
    .IFCPMPSAXI0AWREADY(m_axi0_ps_awready),
    .IFCPMPSAXI0AWVALID(m_axi0_ps_awvalid),
    .IFCPMPSAXI0ARREGION(m_axi0_ps_arregion),
    .IFCPMPSAXI0AWREGION(m_axi0_ps_awregion),

    // CPM -> PS AXI1
    .IFCPMPSAXI1BID(m_axi1_ps_bid),
    .IFCPMPSAXI1RID(m_axi1_ps_rid),
    .IFCPMPSAXI1WID(m_axi1_ps_wid),
    .IFCPMPSAXI1ARID(m_axi1_ps_arid),
    .IFCPMPSAXI1AWID(m_axi1_ps_awid),
    .IFCPMPSAXI1ARLEN(m_axi1_ps_arlen),
    .IFCPMPSAXI1ARQOS(m_axi1_ps_arqos),
    .IFCPMPSAXI1AWLEN(m_axi1_ps_awlen),
    .IFCPMPSAXI1AWQOS(m_axi1_ps_awqos),
    .IFCPMPSAXI1BRESP(m_axi1_ps_bresp),
    .IFCPMPSAXI1BUSER(m_axi1_ps_buser),
    .IFCPMPSAXI1RDATA(m_axi1_ps_rdata),
    .IFCPMPSAXI1RLAST(m_axi1_ps_rlast),
    .IFCPMPSAXI1RRESP(m_axi1_ps_rresp),
    .IFCPMPSAXI1RUSER(m_axi1_ps_ruser),
    .IFCPMPSAXI1WDATA(m_axi1_ps_wdata),
    .IFCPMPSAXI1WLAST(m_axi1_ps_wlast),
    .IFCPMPSAXI1WSTRB(m_axi1_ps_wstrb),
    .IFCPMPSAXI1WUSER(m_axi1_ps_wuser),
    .IFCPMPSAXI1ARADDR(m_axi1_ps_araddr),
    .IFCPMPSAXI1ARLOCK(m_axi1_ps_arlock),
    .IFCPMPSAXI1ARPROT(m_axi1_ps_arprot),
    .IFCPMPSAXI1ARSIZE(m_axi1_ps_arsize),
    .IFCPMPSAXI1ARUSER(m_axi1_ps_aruser),
    .IFCPMPSAXI1AWADDR(m_axi1_ps_awaddr),
    .IFCPMPSAXI1AWLOCK(m_axi1_ps_awlock),
    .IFCPMPSAXI1AWPROT(m_axi1_ps_awprot),
    .IFCPMPSAXI1AWSIZE(m_axi1_ps_awsize),
    .IFCPMPSAXI1AWUSER(m_axi1_ps_awuser),
    .IFCPMPSAXI1BREADY(m_axi1_ps_bready),
    .IFCPMPSAXI1BVALID(m_axi1_ps_bvalid),
    .IFCPMPSAXI1RREADY(m_axi1_ps_rready),
    .IFCPMPSAXI1RVALID(m_axi1_ps_rvalid),
    .IFCPMPSAXI1WREADY(m_axi1_ps_wready),
    .IFCPMPSAXI1WVALID(m_axi1_ps_wvalid),
    .IFCPMPSAXI1ARBURST(m_axi1_ps_arburst),
    .IFCPMPSAXI1ARCACHE(m_axi1_ps_arcache),
    .IFCPMPSAXI1ARREADY(m_axi1_ps_arready),
    .IFCPMPSAXI1ARVALID(m_axi1_ps_arvalid),
    .IFCPMPSAXI1AWBURST(m_axi1_ps_awburst),
    .IFCPMPSAXI1AWCACHE(m_axi1_ps_awcache),
    .IFCPMPSAXI1AWREADY(m_axi1_ps_awready),
    .IFCPMPSAXI1AWVALID(m_axi1_ps_awvalid),
    .IFCPMPSAXI1ARREGION(m_axi1_ps_arregion),
    .IFCPMPSAXI1AWREGION(m_axi1_ps_awregion),


    .IFCPMPLISRCORREVENT(cpm_cor_irq),
    .IFCPMPLISRMISCEVENT(cpm_misc_irq),
    .IFCPMPLISRUNCORREVENT(cpm_uncor_irq),

    .IFCPMPSISRCORREVENT(cpmps_corr_irq),
    .IFCPMPSISRMISCEVENT(cpmps_misc_irq),
    .IFCPMPSISRUNCORREVENT(cpmps_uncorr_irq),
    
    .IFPSCPMHSDPLINKXPIPEGTRXOUTCLK(hsdp_gt_rxoutclk),
    .IFPSCPMHSDPLINKXPIPEGTRXUSRCLK(hsdp_gt_txusrclk),
    .IFCPMXPIPEHSDPLINKXPIPEGTRXOUTCLK(xpipe_gt_rxoutclk),
    .IFCPMXPIPEHSDPLINKXPIPEGTRXUSRCLK(xpipe_gt_rxusrclk),

    .IFPSCPMINTQUADXPIPEPHYREADYFRBOT(phy_ready_frbot),
    .IFPSCPMINTQUADXPIPEPHYREADYTOBOT(phy_ready_tobot),
    .IFCPMXPIPEINTQUADXPIPEPHYREADYFRBOT(xpipe_phyready_fr_bot),
    .IFCPMXPIPEINTQUADXPIPEPHYREADYTOBOT(xpipe_phyready_to_bot),


    .CPMOSCCLKDIV2(cpm_osc_clk_div2),

    .IFPSCPMCFGAXIARADDR  (s_axi_cfg_araddr),
    .IFPSCPMCFGAXIARBURST (s_axi_cfg_arburst),
    .IFPSCPMCFGAXIARCACHE (s_axi_cfg_arcache),
    .IFPSCPMCFGAXIARID    (s_axi_cfg_arid),
    .IFPSCPMCFGAXIARLEN   (s_axi_cfg_arlen),
    .IFPSCPMCFGAXIARLOCK  (s_axi_cfg_arlock),
    .IFPSCPMCFGAXIARPROT  (s_axi_cfg_arprot),
    .IFPSCPMCFGAXIARQOS   (s_axi_cfg_arqos),
    .IFPSCPMCFGAXIARREADY (s_axi_cfg_arready),
    .IFPSCPMCFGAXIARREGION(s_axi_cfg_arregion),
    .IFPSCPMCFGAXIARSIZE  (s_axi_cfg_arsize),
    .IFPSCPMCFGAXIARUSER  (s_axi_cfg_aruser),
    .IFPSCPMCFGAXIARVALID (s_axi_cfg_arvalid),
    .IFPSCPMCFGAXIAWADDR  (s_axi_cfg_awaddr),
    .IFPSCPMCFGAXIAWBURST (s_axi_cfg_awburst),
    .IFPSCPMCFGAXIAWCACHE (s_axi_cfg_awcache),
    .IFPSCPMCFGAXIAWID    (s_axi_cfg_awid),
    .IFPSCPMCFGAXIAWLEN   (s_axi_cfg_awlen),
    .IFPSCPMCFGAXIAWLOCK  (s_axi_cfg_awlock),
    .IFPSCPMCFGAXIAWPROT  (s_axi_cfg_awprot),
    .IFPSCPMCFGAXIAWQOS   (s_axi_cfg_awqos),
    .IFPSCPMCFGAXIAWREADY (s_axi_cfg_awready),
    .IFPSCPMCFGAXIAWREGION(s_axi_cfg_awregion),
    .IFPSCPMCFGAXIAWSIZE  (s_axi_cfg_awsize),
    .IFPSCPMCFGAXIAWUSER  (s_axi_cfg_awuser),
    .IFPSCPMCFGAXIAWVALID (s_axi_cfg_awvalid),
    .IFPSCPMCFGAXIBID     (s_axi_cfg_bid),
    .IFPSCPMCFGAXIBREADY  (s_axi_cfg_bready),
    .IFPSCPMCFGAXIBRESP   (s_axi_cfg_bresp),
    .IFPSCPMCFGAXIBUSER   (s_axi_cfg_buser),
    .IFPSCPMCFGAXIBVALID  (s_axi_cfg_bvalid),
    .IFPSCPMCFGAXIRDATA   (s_axi_cfg_rdata),
    .IFPSCPMCFGAXIRID     (s_axi_cfg_rid),
    .IFPSCPMCFGAXIRLAST   (s_axi_cfg_rlast),
    .IFPSCPMCFGAXIRREADY  (s_axi_cfg_rready),
    .IFPSCPMCFGAXIRRESP   (s_axi_cfg_rresp),
    .IFPSCPMCFGAXIRUSER   (s_axi_cfg_ruser),
    .IFPSCPMCFGAXIRVALID  (s_axi_cfg_rvalid),
    .IFPSCPMCFGAXIWDATA   (s_axi_cfg_wdata),
    .IFPSCPMCFGAXIWID     (s_axi_cfg_wid),
    .IFPSCPMCFGAXIWLAST   (s_axi_cfg_wlast),
    .IFPSCPMCFGAXIWREADY  (s_axi_cfg_wready),
    .IFPSCPMCFGAXIWSTRB   (s_axi_cfg_wstrb),
    .IFPSCPMCFGAXIWUSER   (s_axi_cfg_wuser),
    .IFPSCPMCFGAXIWVALID  (s_axi_cfg_wvalid),

    .IFPSCPMPCIEAXIARADDR  (s_axi_pcie_araddr),
    .IFPSCPMPCIEAXIARBURST (s_axi_pcie_arburst),
    .IFPSCPMPCIEAXIARCACHE (s_axi_pcie_arcache),
    .IFPSCPMPCIEAXIARID    (s_axi_pcie_arid),
    .IFPSCPMPCIEAXIARLEN   (s_axi_pcie_arlen),
    .IFPSCPMPCIEAXIARLOCK  (s_axi_pcie_arlock),
    .IFPSCPMPCIEAXIARPROT  (s_axi_pcie_arprot),
    .IFPSCPMPCIEAXIARQOS   (s_axi_pcie_arqos),
    .IFPSCPMPCIEAXIARREADY (s_axi_pcie_arready),
    .IFPSCPMPCIEAXIARREGION(s_axi_pcie_arregion),
    .IFPSCPMPCIEAXIARSIZE  (s_axi_pcie_arsize),
    .IFPSCPMPCIEAXIARUSER  (s_axi_pcie_aruser),
    .IFPSCPMPCIEAXIARVALID (s_axi_pcie_arvalid),
    .IFPSCPMPCIEAXIAWADDR  (s_axi_pcie_awaddr),
    .IFPSCPMPCIEAXIAWBURST (s_axi_pcie_awburst),
    .IFPSCPMPCIEAXIAWCACHE (s_axi_pcie_awcache),
    .IFPSCPMPCIEAXIAWID    (s_axi_pcie_awid),
    .IFPSCPMPCIEAXIAWLEN   (s_axi_pcie_awlen),
    .IFPSCPMPCIEAXIAWLOCK  (s_axi_pcie_awlock),
    .IFPSCPMPCIEAXIAWPROT  (s_axi_pcie_awprot),
    .IFPSCPMPCIEAXIAWQOS   (s_axi_pcie_awqos),
    .IFPSCPMPCIEAXIAWREADY (s_axi_pcie_awready),
    .IFPSCPMPCIEAXIAWREGION(s_axi_pcie_awregion),
    .IFPSCPMPCIEAXIAWSIZE  (s_axi_pcie_awsize),
    .IFPSCPMPCIEAXIAWUSER  (s_axi_pcie_awuser),
    .IFPSCPMPCIEAXIAWVALID (s_axi_pcie_awvalid),
    .IFPSCPMPCIEAXIBID     (s_axi_pcie_bid),
    .IFPSCPMPCIEAXIBREADY  (s_axi_pcie_bready),
    .IFPSCPMPCIEAXIBRESP   (s_axi_pcie_bresp),
    .IFPSCPMPCIEAXIBUSER   (s_axi_pcie_buser),
    .IFPSCPMPCIEAXIBVALID  (s_axi_pcie_bvalid),
    .IFPSCPMPCIEAXIRDATA   (s_axi_pcie_rdata),
    .IFPSCPMPCIEAXIRID     (s_axi_pcie_rid),
    .IFPSCPMPCIEAXIRLAST   (s_axi_pcie_rlast),
    .IFPSCPMPCIEAXIRREADY  (s_axi_pcie_rready),
    .IFPSCPMPCIEAXIRRESP   (s_axi_pcie_rresp),
    .IFPSCPMPCIEAXIRUSER   (s_axi_pcie_ruser),
    .IFPSCPMPCIEAXIRVALID  (s_axi_pcie_rvalid),
    .IFPSCPMPCIEAXIWDATA   (s_axi_pcie_wdata),
    .IFPSCPMPCIEAXIWID     (s_axi_pcie_wid),
    .IFPSCPMPCIEAXIWLAST   (s_axi_pcie_wlast),
    .IFPSCPMPCIEAXIWREADY  (s_axi_pcie_wready),
    .IFPSCPMPCIEAXIWSTRB   (s_axi_pcie_wstrb),
    .IFPSCPMPCIEAXIWUSER   (s_axi_pcie_wuser),
    .IFPSCPMPCIEAXIWVALID  (s_axi_pcie_wvalid),


    .IFPSCPMPCSRPCRPWRDN(cpm_pcr_pwr_dn),
    .IFPSCPMPCSRPCRAPBEN(cpm_pcr_apb_en),
    .IFPSCPMPCSRPCRMEMCLR(cpm_pcr_mem_clr),
    .IFPSCPMPCSRPCRGATEREG(cpm_pcr_gate_reg),
    .IFPSCPMPCSRPCRSCANCLR(cpm_pcr_scan_clr),
    .IFPSCPMPCSRPCRTRISTATE(cpm_pcr_tristate),
    .IFPSCPMPCSRPCRFABRICEN(cpm_pcr_fabric_en),
    .IFPSCPMPCSRPCRODISABLE(cpm_pcr_o_disable),
    .IFPSCPMPCSRPCRSTARTCAL(cpm_pcr_start_cal),
    .IFPSCPMPCSRPCRPCOMPLETE(cpm_pcr_pcomplete),
    .IFPSCPMPCSRPCRHOLDSTATE(cpm_pcr_hold_state),
    .IFPSCPMPCSRPCRINITSTATE(cpm_pcr_init_state),
    .IFPSCPMPCSRPCRSTARTBISR(cpm_pcr_start_bisr),
    .IFPSCPMPCSRPCRDISNPICLK(cpm_pcr_dis_npi_clk),

    .IFPSCPMPCSRPSRINCAL(cpm_psr_in_cal),
    .IFPSCPMPCSRPSRBISRERR(cpm_psr_bisr_err),
    .IFPSCPMPCSRPSRCALDONE(cpm_psr_cal_done),
    .IFPSCPMPCSRPSRBISRDONE(cpm_psr_bisr_done),
    .IFPSCPMPCSRPSRCALERROR(cpm_psr_cal_error),
    .IFPSCPMPCSRPSRMEMCLRDONE(cpm_psr_mem_clr_done),
    .IFPSCPMPCSRPSRMEMCLRPASS(cpm_psr_mem_clr_pass),
    .IFPSCPMPCSRPSRSCANCLRDONE(cpm_psr_scan_clr_done),
    .IFPSCPMPCSRPSRSCANCLRPASS(cpm_psr_scan_clr_pass),

    .LPDCPMTOPSWCLK(lpd_swclk),
    .LPDCPMINREFCLK(lpd_refclk_in),
    .LPDCPMSWITCHTIMEOUTCNT(lpd_switch_timeout_cnt),

    .PERST0N(perst0n),
    .PERST1N(perst1n),

    .PLCPMIRQ0(cpm_irq0),
    .PLCPMIRQ1(cpm_irq1),
    .PLREFCLK(pl_ref_clk)
  );

  // --------------------------- CPM instance end ------------------------------------

// --------------------------------------- XPIPE Instances start-------------------------------
generate
  if ( C_XPIPE_0_INSTANTIATED == 1 ) begin

    XPIPE_QUAD #(
      .XPIPE_LOC        (C_XPIPE_0_LOC),
      .XPIPE_MODE       (C_XPIPE_0_MODE),
      .XPIPE_RSVD       (C_XPIPE_0_RSVD),
      .XPIPE_LINK0_CFG  (C_XPIPE_0_LINK0_CFG),
      .XPIPE_LINK1_CFG  (C_XPIPE_0_LINK1_CFG),
      .XPIPE_CLK_CFG    (C_XPIPE_0_CLK_CFG),
      .XPIPE_CLKDLY_CFG (C_XPIPE_0_CLKDLY_CFG),
      .XPIPE_REG_CFG    (C_XPIPE_0_REG_CFG)
    ) XPIPE_QUAD0_inst (

      .XPIPE_GT_OUTCLK   (xpipe_lnk0_gt_outclk),
      .XPIPE_GT_OUTCLK_1 (xpipe_lnk1_gt_outclk),
      .XPIPE_GT_RXOUTCLK (xpipe_gt_rxoutclk),
      .XPIPE_GT_RXUSRCLK (xpipe_gt_rxusrclk),
      .XPIPE_GT_PIPECLK  (xpipe_lnk0_gt_pipeclk),
      .XPIPE_GT_PIPECLK_1(xpipe_lnk1_gt_pipeclk),

      .XPIPE_PHYESMADAPTSAVE    (xpipe_lnk0_phyesmadaptsave),
      .XPIPE_PHYESMADAPTSAVE_1  (xpipe_lnk1_phyesmadaptsave),
      .XPIPE_PHYESMADAPTSAVE_M  (q0q1_xpipe_phyesmadaptsave_m),
      .XPIPE_PHYESMADAPTSAVE_M_1(q0q1_xpipe_phyesmadaptsave_m_1),

      .XPIPE_BUFGTCE       (xpipe_lnk0_bufgtce),
      .XPIPE_BUFGTCE_1     (xpipe_lnk1_bufgtce),
      .XPIPE_BUFGTCE_MASK  (xpipe_lnk0_bufgtce_mask),
      .XPIPE_BUFGTCE_MASK_1(xpipe_lnk1_bufgtce_mask),
      .XPIPE_BUFGTDIV      (xpipe_lnk0_bufgtdiv),
      .XPIPE_BUFGTDIV_1    (xpipe_lnk1_bufgtdiv),
      .XPIPE_BUFGTRST      (xpipe_lnk0_bufgtrst),
      .XPIPE_BUFGTRST_1    (xpipe_lnk1_bufgtrst),
      .XPIPE_BUFGTRST_MASK (xpipe_lnk0_bufgtrst_mask),
      .XPIPE_BUFGTRST_MASK_1(xpipe_lnk1_bufgtrst_mask),

      .XPIPE_PCIE_PERST_N     (xpipe_lnk0_pcie_perst_n),
      .XPIPE_PCIE_PERST_N_1   (xpipe_lnk1_pcie_perst_n),
      .XPIPE_PCIE_PERST_N_M   (q0q1_xpipe_pcie_perst_n_m),
      .XPIPE_PCIE_PERST_N_M_1 (q0q1_xpipe_pcie_perst_n_m_1),

      .XPIPE_PCIE_RATE    (xpipe_lnk0_pcie_rate),
      .XPIPE_PCIE_RATE_1  (xpipe_lnk1_pcie_rate),
      .XPIPE_PCIE_RATE_M  (q0q1_xpipe_pcie_rate_m),
      .XPIPE_PCIE_RATE_M_1(q0q1_xpipe_pcie_rate_m_1),

      .XPIPE_GT_OUTCLK_M     (q0q1_xpipe_gt_outclk_m),
      .XPIPE_GT_OUTCLK_M_1   (q0q1_xpipe_gt_outclk_m_1),
      .XPIPE_GT_RXOUTCLK_M   (q0q1_xpipe_gt_rxoutclk_m),
      .XPIPE_GT_RXUSRCLK_M   (q0q1_xpipe_gt_rxusrclk_m),
      .XPIPE_GT_PIPECLK_M    (q0q1_xpipe_gt_pipeclk_m),
      .XPIPE_GT_PIPECLK_M_1  (q0q1_xpipe_gt_pipeclk_m_1),
      .XPIPE_BUFGTCE_M       (q0q1_xpipe_bufgtce_m),
      .XPIPE_BUFGTCE_MASK_M  (q0q1_xpipe_bufgtce_mask_m),
      .XPIPE_BUFGTCE_MASK_M_1(q0q1_xpipe_bufgtce_mask_m_1),
      .XPIPE_BUFGTCE_M_1     (q0q1_xpipe_bufgtce_m_1),
      .XPIPE_BUFGTDIV_M      (q0q1_xpipe_bufgtdiv_m),
      .XPIPE_BUFGTDIV_M_1    (q0q1_xpipe_bufgtdiv_m_1),
      .XPIPE_BUFGTRST_M      (q0q1_xpipe_bufgtrst_m),
      .XPIPE_BUFGTRST_MASK_M (q0q1_xpipe_bufgtrst_mask_m),
      .XPIPE_BUFGTRST_MASK_M_1(q0q1_xpipe_bufgtrst_mask_m_1),
      .XPIPE_BUFGTRST_M_1    (q0q1_xpipe_bufgtrst_m_1),

      .XPIPE_PHYREADY_FR_BOT_M(q0q1_xpipe_phyready_fr_bot_m),
      .XPIPE_PHYREADY_TO_BOT(xpipe_phyready_to_bot),
      .XPIPE_PHY_READY(xpipe_phy_ready),
      .XPIPE_PHY_READY_1(xpipe_phy_ready_1),
      .XPIPE_PHYREADY_FR_BOT(xpipe_phyready_fr_bot),
      .XPIPE_PHYREADY_TO_BOT_M(q0q1_xpipe_phyready_to_bot_m),
      .XPIPE_PHY_READY_M(q0q1_xpipe_phy_ready_m),
      .XPIPE_PHY_READY_M_1(q0q1_xpipe_phy_ready_m_1),

      .ALTCLK_M           (altclk_m),
      .APB3PADDR_M        (apb3paddr_m),
      .APB3CLK_M          (apb3clk_m),
      .AXISCLK_M          (axisclk_m),
      .APB3PENABLE_M      (apb3penable_m),
      .APB3PRESETN_M      (apb3presetn_m),
      .APB3PSEL_M         (apb3psel_m),
      .APB3PWDATA_M       (apb3pwdata_m),
      .APB3PWRITE_M       (apb3pwrite_m),
      .BGBYPASSB_M        (bgbypassb_m),
      .BGMONITORENB_M     (bgmonitorenb_m),
      .BGPDB_M            (bgpdb_m),
      .BGRCALOVRDENB_M    (bgrcalovrdenb_m),
      .BGRCALOVRD_M       (bgrcalovrd_m),
      .CH0_RXUSRCLK_M     (ch0_rxusrclk_m),
      .CH0_RXOUTCLK_M     (ch0_rxoutclk_m),
      .CH0_CDRBMCDRREQ_M  (ch0_cdrbmcdrreq_m),
      .CH0_CDRFREQOS_M    (ch0_cdrfreqos_m),
      .CH0_CDRINCPCTRL_M  (ch0_cdrincpctrl_m),
      .CH0_CDRSTEPDIR_M   (ch0_cdrstepdir_m),
      .CH0_CDRSTEPSQ_M    (ch0_cdrstepsq_m),
      .CH0_CDRSTEPSX_M    (ch0_cdrstepsx_m),
    //.CH0_CFOKOVWRFINISH_M (ch0_cfokovwrfinish_m),
    //.CH0_CFOKOVWRPULSE_M  (ch0_cfokovwrpulse_m),
    //.CH0_CFOKOVWRSTART_M  (ch0_cfokovwrstart_m),
      .CH0_CLKRSVD0_M       (ch0_clkrsvd0_m),
      .CH0_CLKRSVD1_M       (ch0_clkrsvd1_m),
      .CH0_DMONFIFORESET_M  (ch0_dmonfiforeset_m),
      .CH0_DMONITORCLK_M    (ch0_dmonitorclk_m),
      .CH0_EYESCANRESET_M   (ch0_eyescanreset_m),
      .CH0_EYESCANTRIGGER_M (ch0_eyescantrigger_m),
      .CH0_GTRSVD_M         (ch0_gtrsvd_m),
      .CH0_GTRXRESET_M      (ch0_gtrxreset_m),
      .CH0_GTTXRESET_M      (ch0_gttxreset_m),
      .CH0_HSDPPCSRESET_M   (ch0_hsdppcsreset_m),
      .CH0_ILORESETMASK_M   (ch0_iloresetmask_m),
      .CH0_ILORESET_M       (ch0_iloreset_m),
      .CH0_LOOPBACK_M       (ch0_loopback_m),
      .CH0_PCIERSTB_M       (ch0_pcierstb_m),
      .CH0_PCSRSVDIN_M      (ch0_pcsrsvdin_m),
      .CH0_PHYESMADAPTSAVE_M(ch0_phyesmadaptsave_m),
      .CH0_RXCDRHOLD_M      (ch0_rxcdrhold_m),
      .CH0_RXCDROVRDEN_M    (ch0_rxcdrovrden_m),
      .CH0_RXCDRRESET_M     (ch0_rxcdrreset_m),
      .CH0_RXCHBONDI_M      (ch0_rxchbondi_m),
      .CH0_RXDAPICODEOVRDEN_M(ch0_rxdapicodeovrden_m),
      .CH0_RXDAPICODERESET_M(ch0_rxdapicodereset_m),
      .CH0_RXDLYALIGNREQ_M  (ch0_rxdlyalignreq_m),
      .CH0_RXEQTRAINING_M   (ch0_rxeqtraining_m),
      .CH0_RXGEARBOXSLIP_M  (ch0_rxgearboxslip_m),
      .CH0_RXLATCLK_M       (ch0_rxlatclk_m),
      .CH0_RXLPMEN_M        (ch0_rxlpmen_m),
      .CH0_RXMLDCHAINDONE_M (ch0_rxmldchaindone_m),
      .CH0_RXMLDCHAINREQ_M  (ch0_rxmldchainreq_m),
      .CH0_RXMLFINEALIGNREQ_M(ch0_rxmlfinealignreq_m),
      .CH0_RXOOBRESET_M     (ch0_rxoobreset_m),
      .CH0_RXPCSRESETMASK_M (ch0_rxpcsresetmask_m),
      .CH0_RXPD_M           (ch0_rxpd_m),
      .CH0_RXPHALIGNREQ_M   (ch0_rxphalignreq_m),
      .CH0_RXPHALIGNRESETMASK_M(ch0_rxphalignresetmask_m),
      .CH0_RXPHDLYPD_M      (ch0_rxphdlypd_m),
      .CH0_RXPHDLYRESET_M   (ch0_rxphdlyreset_m),
      .CH0_RXPHSETINITREQ_M (ch0_rxphsetinitreq_m),
      .CH0_RXPHSHIFT180_M   (ch0_rxphshift180_m),
      .CH0_RXPMARESETMASK_M (ch0_rxpmaresetmask_m),
      .CH0_RXPOLARITY_M     (ch0_rxpolarity_m),
      .CH0_RXPRBSCNTRESET_M (ch0_rxprbscntreset_m),
      .CH0_RXPRBSSEL_M      (ch0_rxprbssel_m),
      .CH0_RXPROGDIVRESET_M (ch0_rxprogdivreset_m),
      .CH0_RXRATE_M         (ch0_rxrate_m),
      .CH0_RXRESETMODE_M    (ch0_rxresetmode_m),
      .CH0_RXSLIDE_M        (ch0_rxslide_m),
      .CH0_RXSYNCALLIN_M    (ch0_rxsyncallin_m),
      .CH0_RXTERMINATION_M  (ch0_rxtermination_m),
      .CH0_RXUSERRDY_M      (ch0_rxuserrdy_m),
      .CH0_TSTIN_M          (ch0_tstin_m),
      .CH0_TXCOMINIT_M      (ch0_txcominit_m),
      .CH0_TXCOMSAS_M       (ch0_txcomsas_m),
      .CH0_TXCOMWAKE_M      (ch0_txcomwake_m),
      .CH0_TXCTRL0_M        (ch0_txctrl0_m),
      .CH0_TXCTRL1_M        (ch0_txctrl1_m),
      .CH0_TXCTRL2_M        (ch0_txctrl2_m),
      .CH0_TXDAPICODEOVRDEN_M(ch0_txdapicodeovrden_m),
      .CH0_TXDAPICODERESET_M(ch0_txdapicodereset_m),
      .CH0_TXDATAEXTENDRSVD_M(ch0_txdataextendrsvd_m),
      .CH0_TXDATA_M         (ch0_txdata_m),
      .CH0_TXDEEMPH_M       (ch0_txdeemph_m),
      .CH0_TXDETECTRX_M     (ch0_txdetectrx_m),
      .CH0_TXDIFFCTRL_M     (ch0_txdiffctrl_m),
      .CH0_TXDLYALIGNREQ_M  (ch0_txdlyalignreq_m),
      .CH0_TXELECIDLE_M     (ch0_txelecidle_m),
      .CH0_TXHEADER_M       (ch0_txheader_m),
      .CH0_TXINHIBIT_M      (ch0_txinhibit_m),
      .CH0_TXLATCLK_M       (ch0_txlatclk_m),
      .CH0_TXMAINCURSOR_M   (ch0_txmaincursor_m),
      .CH0_TXMARGIN_M       (ch0_txmargin_m),
      .CH0_TXMLDCHAINDONE_M (ch0_txmldchaindone_m),
      .CH0_TXMLDCHAINREQ_M  (ch0_txmldchainreq_m),
      .CH0_TXONESZEROS_M    (ch0_txoneszeros_m),
      .CH0_TXPAUSEDELAYALIGN_M(ch0_txpausedelayalign_m),
      .CH0_TXPCSRESETMASK_M (ch0_txpcsresetmask_m),
      .CH0_TXPD_M           (ch0_txpd_m),
      .CH0_TXPHALIGNREQ_M   (ch0_txphalignreq_m),
      .CH0_TXPHALIGNRESETMASK_M(ch0_txphalignresetmask_m),
      .CH0_TXPHDLYPD_M      (ch0_txphdlypd_m),
      .CH0_TXPHDLYRESET_M   (ch0_txphdlyreset_m),
      .CH0_TXPHDLYTSTCLK_M  (ch0_txphdlytstclk_m),
      .CH0_TXPHSETINITREQ_M (ch0_txphsetinitreq_m),
      .CH0_TXPHSHIFT180_M   (ch0_txphshift180_m),
      .CH0_TXPICODEOVRDEN_M (ch0_txpicodeovrden_m),
      .CH0_TXPICODERESET_M  (ch0_txpicodereset_m),
      .CH0_TXPIPPMEN_M      (ch0_txpippmen_m),
      .CH0_TXPIPPMSTEPSIZE_M(ch0_txpippmstepsize_m),
      .CH0_TXPISOPD_M       (ch0_txpisopd_m),
      .CH0_TXPMARESETMASK_M (ch0_txpmaresetmask_m),
      .CH0_TXPOLARITY_M     (ch0_txpolarity_m),
      .CH0_TXPOSTCURSOR_M   (ch0_txpostcursor_m),
      .CH0_TXPRBSFORCEERR_M (ch0_txprbsforceerr_m),
      .CH0_TXPRBSSEL_M      (ch0_txprbssel_m),
      .CH0_TXPRECURSOR_M    (ch0_txprecursor_m),
      .CH0_TXPROGDIVRESET_M (ch0_txprogdivreset_m),
      .CH0_TXRATE_M         (ch0_txrate_m),
      .CH0_TXRESETMODE_M    (ch0_txresetmode_m),
      .CH0_TXSEQUENCE_M     (ch0_txsequence_m),
      .CH0_TXSWING_M        (ch0_txswing_m),
      .CH0_TXSYNCALLIN_M    (ch0_txsyncallin_m),
      .CH0_TXUSERRDY_M      (ch0_txuserrdy_m),
      .CH0_TXUSRCLK_M       (ch0_txusrclk_m),
      .CH1_CDRBMCDRREQ_M    (ch1_cdrbmcdrreq_m),
      .CH1_CDRFREQOS_M      (ch1_cdrfreqos_m),
      .CH1_CDRINCPCTRL_M    (ch1_cdrincpctrl_m),
      .CH1_CDRSTEPDIR_M     (ch1_cdrstepdir_m),
      .CH1_CDRSTEPSQ_M      (ch1_cdrstepsq_m),
      .CH1_CDRSTEPSX_M      (ch1_cdrstepsx_m),
    //.CH1_CFOKOVWRFINISH_M (ch1_cfokovwrfinish_m),
    //.CH1_CFOKOVWRPULSE_M  (ch1_cfokovwrpulse_m),
    //.CH1_CFOKOVWRSTART_M  (ch1_cfokovwrstart_m),
      .CH1_CLKRSVD0_M       (ch1_clkrsvd0_m),
      .CH1_CLKRSVD1_M       (ch1_clkrsvd1_m),
      .CH1_DMONFIFORESET_M  (ch1_dmonfiforeset_m),
      .CH1_DMONITORCLK_M    (ch1_dmonitorclk_m),
      .CH1_EYESCANRESET_M   (ch1_eyescanreset_m),
      .CH1_EYESCANTRIGGER_M (ch1_eyescantrigger_m),
      .CH1_GTRSVD_M         (ch1_gtrsvd_m),
      .CH1_GTRXRESET_M      (ch1_gtrxreset_m),
      .CH1_GTTXRESET_M      (ch1_gttxreset_m),
      .CH1_HSDPPCSRESET_M   (ch1_hsdppcsreset_m),
      .CH1_ILORESETMASK_M   (ch1_iloresetmask_m),
      .CH1_ILORESET_M       (ch1_iloreset_m),
      .CH1_LOOPBACK_M       (ch1_loopback_m),
      .CH1_PCIERSTB_M       (ch1_pcierstb_m),
      .CH1_PCSRSVDIN_M      (ch1_pcsrsvdin_m),
      .CH1_PHYESMADAPTSAVE_M(ch1_phyesmadaptsave_m),
      .CH1_RXCDRHOLD_M      (ch1_rxcdrhold_m),
      .CH1_RXCDROVRDEN_M    (ch1_rxcdrovrden_m),
      .CH1_RXCDRRESET_M     (ch1_rxcdrreset_m),
      .CH1_RXCHBONDI_M      (ch1_rxchbondi_m),
      .CH1_RXDAPICODEOVRDEN_M(ch1_rxdapicodeovrden_m),
      .CH1_RXDAPICODERESET_M(ch1_rxdapicodereset_m),
      .CH1_RXDLYALIGNREQ_M  (ch1_rxdlyalignreq_m),
      .CH1_RXEQTRAINING_M   (ch1_rxeqtraining_m),
      .CH1_RXGEARBOXSLIP_M  (ch1_rxgearboxslip_m),
      .CH1_RXLATCLK_M       (ch1_rxlatclk_m),
      .CH1_RXLPMEN_M        (ch1_rxlpmen_m),
      .CH1_RXMLDCHAINDONE_M (ch1_rxmldchaindone_m),
      .CH1_RXMLDCHAINREQ_M  (ch1_rxmldchainreq_m),
      .CH1_RXMLFINEALIGNREQ_M(ch1_rxmlfinealignreq_m),
      .CH1_RXOOBRESET_M     (ch1_rxoobreset_m),
      .CH1_RXPCSRESETMASK_M (ch1_rxpcsresetmask_m),
      .CH1_RXPD_M           (ch1_rxpd_m),
      .CH1_RXPHALIGNREQ_M   (ch1_rxphalignreq_m),
      .CH1_RXPHALIGNRESETMASK_M(ch1_rxphalignresetmask_m),
      .CH1_RXPHDLYPD_M      (ch1_rxphdlypd_m),
      .CH1_RXPHDLYRESET_M   (ch1_rxphdlyreset_m),
      .CH1_RXPHSETINITREQ_M (ch1_rxphsetinitreq_m),
      .CH1_RXPHSHIFT180_M   (ch1_rxphshift180_m),
      .CH1_RXPMARESETMASK_M (ch1_rxpmaresetmask_m),
      .CH1_RXPOLARITY_M     (ch1_rxpolarity_m),
      .CH1_RXPRBSCNTRESET_M (ch1_rxprbscntreset_m),
      .CH1_RXPRBSSEL_M      (ch1_rxprbssel_m),
      .CH1_RXPROGDIVRESET_M (ch1_rxprogdivreset_m),
      .CH1_RXRATE_M         (ch1_rxrate_m),
      .CH1_RXRESETMODE_M    (ch1_rxresetmode_m),
      .CH1_RXSLIDE_M        (ch1_rxslide_m),
      .CH1_RXSYNCALLIN_M    (ch1_rxsyncallin_m),
      .CH1_RXTERMINATION_M  (ch1_rxtermination_m),
      .CH1_RXUSERRDY_M      (ch1_rxuserrdy_m),
      .CH1_RXUSRCLK_M       (ch1_rxusrclk_m),
      .CH1_TSTIN_M          (ch1_tstin_m),
      .CH1_TXCOMINIT_M      (ch1_txcominit_m),
      .CH1_TXCOMSAS_M       (ch1_txcomsas_m),
      .CH1_TXCOMWAKE_M      (ch1_txcomwake_m),
      .CH1_TXCTRL0_M        (ch1_txctrl0_m),
      .CH1_TXCTRL1_M        (ch1_txctrl1_m),
      .CH1_TXCTRL2_M        (ch1_txctrl2_m),
      .CH1_TXDAPICODEOVRDEN_M(ch1_txdapicodeovrden_m),
      .CH1_TXDAPICODERESET_M(ch1_txdapicodereset_m),
      .CH1_TXDATAEXTENDRSVD_M(ch1_txdataextendrsvd_m),
      .CH1_TXDATA_M         (ch1_txdata_m),
      .CH1_TXDEEMPH_M       (ch1_txdeemph_m),
      .CH1_TXDETECTRX_M     (ch1_txdetectrx_m),
      .CH1_TXDIFFCTRL_M     (ch1_txdiffctrl_m),
      .CH1_TXDLYALIGNREQ_M  (ch1_txdlyalignreq_m),
      .CH1_TXELECIDLE_M     (ch1_txelecidle_m),
      .CH1_TXHEADER_M       (ch1_txheader_m),
      .CH1_TXINHIBIT_M      (ch1_txinhibit_m),
      .CH1_TXLATCLK_M       (ch1_txlatclk_m),
      .CH1_TXMAINCURSOR_M   (ch1_txmaincursor_m),
      .CH1_TXMARGIN_M       (ch1_txmargin_m),
      .CH1_TXMLDCHAINDONE_M (ch1_txmldchaindone_m),
      .CH1_TXMLDCHAINREQ_M  (ch1_txmldchainreq_m),
      .CH1_TXONESZEROS_M    (ch1_txoneszeros_m),
      .CH1_TXPAUSEDELAYALIGN_M(ch1_txpausedelayalign_m),
      .CH1_TXPCSRESETMASK_M (ch1_txpcsresetmask_m),
      .CH1_TXPD_M           (ch1_txpd_m),
      .CH1_TXPHALIGNREQ_M   (ch1_txphalignreq_m),
      .CH1_TXPHALIGNRESETMASK_M(ch1_txphalignresetmask_m),
      .CH1_TXPHDLYPD_M      (ch1_txphdlypd_m),
      .CH1_TXPHDLYRESET_M   (ch1_txphdlyreset_m),
      .CH1_TXPHDLYTSTCLK_M  (ch1_txphdlytstclk_m),
      .CH1_TXPHSETINITREQ_M (ch1_txphsetinitreq_m),
      .CH1_TXPHSHIFT180_M   (ch1_txphshift180_m),
      .CH1_TXPICODEOVRDEN_M (ch1_txpicodeovrden_m),
      .CH1_TXPICODERESET_M  (ch1_txpicodereset_m),
      .CH1_TXPIPPMEN_M      (ch1_txpippmen_m),
      .CH1_TXPIPPMSTEPSIZE_M(ch1_txpippmstepsize_m),
      .CH1_TXPISOPD_M       (ch1_txpisopd_m),
      .CH1_TXPMARESETMASK_M (ch1_txpmaresetmask_m),
      .CH1_TXPOLARITY_M     (ch1_txpolarity_m),
      .CH1_TXPOSTCURSOR_M   (ch1_txpostcursor_m),
      .CH1_TXPRBSFORCEERR_M (ch1_txprbsforceerr_m),
      .CH1_TXPRBSSEL_M      (ch1_txprbssel_m),
      .CH1_TXPRECURSOR_M    (ch1_txprecursor_m),
      .CH1_TXPROGDIVRESET_M (ch1_txprogdivreset_m),
      .CH1_TXRATE_M         (ch1_txrate_m),
      .CH1_TXRESETMODE_M    (ch1_txresetmode_m),
      .CH1_TXSEQUENCE_M     (ch1_txsequence_m),
      .CH1_TXSWING_M        (ch1_txswing_m),
      .CH1_TXSYNCALLIN_M    (ch1_txsyncallin_m),
      .CH1_TXUSERRDY_M      (ch1_txuserrdy_m),
      .CH1_TXUSRCLK_M       (ch1_txusrclk_m),
      .CH2_CDRBMCDRREQ_M    (ch2_cdrbmcdrreq_m),
      .CH2_CDRFREQOS_M      (ch2_cdrfreqos_m),
      .CH2_CDRINCPCTRL_M    (ch2_cdrincpctrl_m),
      .CH2_CDRSTEPDIR_M     (ch2_cdrstepdir_m),
      .CH2_CDRSTEPSQ_M      (ch2_cdrstepsq_m),
      .CH2_CDRSTEPSX_M      (ch2_cdrstepsx_m),
    //.CH2_CFOKOVWRFINISH_M (ch2_cfokovwrfinish_m),
    //.CH2_CFOKOVWRPULSE_M  (ch2_cfokovwrpulse_m),
    //.CH2_CFOKOVWRSTART_M  (ch2_cfokovwrstart_m),
      .CH2_CLKRSVD0_M       (ch2_clkrsvd0_m),
      .CH2_CLKRSVD1_M       (ch2_clkrsvd1_m),
      .CH2_DMONFIFORESET_M  (ch2_dmonfiforeset_m),
      .CH2_DMONITORCLK_M    (ch2_dmonitorclk_m),
      .CH2_EYESCANRESET_M   (ch2_eyescanreset_m),
      .CH2_EYESCANTRIGGER_M (ch2_eyescantrigger_m),
      .CH2_GTRSVD_M         (ch2_gtrsvd_m),
      .CH2_GTRXRESET_M      (ch2_gtrxreset_m),
      .CH2_GTTXRESET_M      (ch2_gttxreset_m),
      .CH2_HSDPPCSRESET_M   (ch2_hsdppcsreset_m),
      .CH2_ILORESETMASK_M   (ch2_iloresetmask_m),
      .CH2_ILORESET_M       (ch2_iloreset_m),
      .CH2_LOOPBACK_M       (ch2_loopback_m),
      .CH2_PCIERSTB_M       (ch2_pcierstb_m),
      .CH2_PCSRSVDIN_M      (ch2_pcsrsvdin_m),
      .CH2_PHYESMADAPTSAVE_M(ch2_phyesmadaptsave_m),
      .CH2_RXCDRHOLD_M      (ch2_rxcdrhold_m),
      .CH2_RXCDROVRDEN_M    (ch2_rxcdrovrden_m),
      .CH2_RXCDRRESET_M     (ch2_rxcdrreset_m),
      .CH2_RXCHBONDI_M      (ch2_rxchbondi_m),
      .CH2_RXDAPICODEOVRDEN_M(ch2_rxdapicodeovrden_m),
      .CH2_RXDAPICODERESET_M(ch2_rxdapicodereset_m),
      .CH2_RXDLYALIGNREQ_M  (ch2_rxdlyalignreq_m),
      .CH2_RXEQTRAINING_M   (ch2_rxeqtraining_m),
      .CH2_RXGEARBOXSLIP_M  (ch2_rxgearboxslip_m),
      .CH2_RXLATCLK_M       (ch2_rxlatclk_m),
      .CH2_RXLPMEN_M        (ch2_rxlpmen_m),
      .CH2_RXMLDCHAINDONE_M (ch2_rxmldchaindone_m),
      .CH2_RXMLDCHAINREQ_M  (ch2_rxmldchainreq_m),
      .CH2_RXMLFINEALIGNREQ_M(ch2_rxmlfinealignreq_m),
      .CH2_RXOOBRESET_M     (ch2_rxoobreset_m),
      .CH2_RXPCSRESETMASK_M (ch2_rxpcsresetmask_m),
      .CH2_RXPD_M           (ch2_rxpd_m),
      .CH2_RXPHALIGNREQ_M   (ch2_rxphalignreq_m),
      .CH2_RXPHALIGNRESETMASK_M(ch2_rxphalignresetmask_m),
      .CH2_RXPHDLYPD_M      (ch2_rxphdlypd_m),
      .CH2_RXPHDLYRESET_M   (ch2_rxphdlyreset_m),
      .CH2_RXPHSETINITREQ_M (ch2_rxphsetinitreq_m),
      .CH2_RXPHSHIFT180_M   (ch2_rxphshift180_m),
      .CH2_RXPMARESETMASK_M (ch2_rxpmaresetmask_m),
      .CH2_RXPOLARITY_M     (ch2_rxpolarity_m),
      .CH2_RXPRBSCNTRESET_M (ch2_rxprbscntreset_m),
      .CH2_RXPRBSSEL_M      (ch2_rxprbssel_m),
      .CH2_RXPROGDIVRESET_M (ch2_rxprogdivreset_m),
      .CH2_RXRATE_M         (ch2_rxrate_m),
      .CH2_RXRESETMODE_M    (ch2_rxresetmode_m),
      .CH2_RXSLIDE_M        (ch2_rxslide_m),
      .CH2_RXSYNCALLIN_M    (ch2_rxsyncallin_m),
      .CH2_RXTERMINATION_M  (ch2_rxtermination_m),
      .CH2_RXUSERRDY_M      (ch2_rxuserrdy_m),
      .CH2_RXUSRCLK_M       (ch2_rxusrclk_m),
      .CH2_TSTIN_M          (ch2_tstin_m),
      .CH2_TXCOMINIT_M      (ch2_txcominit_m),
      .CH2_TXCOMSAS_M       (ch2_txcomsas_m),
      .CH2_TXCOMWAKE_M      (ch2_txcomwake_m),
      .CH2_TXCTRL0_M        (ch2_txctrl0_m),
      .CH2_TXCTRL1_M        (ch2_txctrl1_m),
      .CH2_TXCTRL2_M        (ch2_txctrl2_m),
      .CH2_TXDAPICODEOVRDEN_M(ch2_txdapicodeovrden_m),
      .CH2_TXDAPICODERESET_M(ch2_txdapicodereset_m),
      .CH2_TXDATAEXTENDRSVD_M(ch2_txdataextendrsvd_m),
      .CH2_TXDATA_M         (ch2_txdata_m),
      .CH2_TXDEEMPH_M       (ch2_txdeemph_m),
      .CH2_TXDETECTRX_M     (ch2_txdetectrx_m),
      .CH2_TXDIFFCTRL_M     (ch2_txdiffctrl_m),
      .CH2_TXDLYALIGNREQ_M  (ch2_txdlyalignreq_m),
      .CH2_TXELECIDLE_M     (ch2_txelecidle_m),
      .CH2_TXHEADER_M       (ch2_txheader_m),
      .CH2_TXINHIBIT_M      (ch2_txinhibit_m),
      .CH2_TXLATCLK_M       (ch2_txlatclk_m),
      .CH2_TXMAINCURSOR_M   (ch2_txmaincursor_m),
      .CH2_TXMARGIN_M       (ch2_txmargin_m),
      .CH2_TXMLDCHAINDONE_M (ch2_txmldchaindone_m),
      .CH2_TXMLDCHAINREQ_M  (ch2_txmldchainreq_m),
      .CH2_TXONESZEROS_M    (ch2_txoneszeros_m),
      .CH2_TXPAUSEDELAYALIGN_M(ch2_txpausedelayalign_m),
      .CH2_TXPCSRESETMASK_M (ch2_txpcsresetmask_m),
      .CH2_TXPD_M           (ch2_txpd_m),
      .CH2_TXPHALIGNREQ_M   (ch2_txphalignreq_m),
      .CH2_TXPHALIGNRESETMASK_M(ch2_txphalignresetmask_m),
      .CH2_TXPHDLYPD_M      (ch2_txphdlypd_m),
      .CH2_TXPHDLYRESET_M   (ch2_txphdlyreset_m),
      .CH2_TXPHDLYTSTCLK_M  (ch2_txphdlytstclk_m),
      .CH2_TXPHSETINITREQ_M (ch2_txphsetinitreq_m),
      .CH2_TXPHSHIFT180_M   (ch2_txphshift180_m),
      .CH2_TXPICODEOVRDEN_M (ch2_txpicodeovrden_m),
      .CH2_TXPICODERESET_M  (ch2_txpicodereset_m),
      .CH2_TXPIPPMEN_M      (ch2_txpippmen_m),
      .CH2_TXPIPPMSTEPSIZE_M(ch2_txpippmstepsize_m),
      .CH2_TXPISOPD_M       (ch2_txpisopd_m),
      .CH2_TXPMARESETMASK_M (ch2_txpmaresetmask_m),
      .CH2_TXPOLARITY_M     (ch2_txpolarity_m),
      .CH2_TXPOSTCURSOR_M   (ch2_txpostcursor_m),
      .CH2_TXPRBSFORCEERR_M (ch2_txprbsforceerr_m),
      .CH2_TXPRBSSEL_M      (ch2_txprbssel_m),
      .CH2_TXPRECURSOR_M    (ch2_txprecursor_m),
      .CH2_TXPROGDIVRESET_M (ch2_txprogdivreset_m),
      .CH2_TXRATE_M         (ch2_txrate_m),
      .CH2_TXRESETMODE_M    (ch2_txresetmode_m),
      .CH2_TXSEQUENCE_M     (ch2_txsequence_m),
      .CH2_TXSWING_M        (ch2_txswing_m),
      .CH2_TXSYNCALLIN_M    (ch2_txsyncallin_m),
      .CH2_TXUSERRDY_M      (ch2_txuserrdy_m),
      .CH2_TXUSRCLK_M       (ch2_txusrclk_m),
      .CH3_CDRBMCDRREQ_M    (ch3_cdrbmcdrreq_m),
      .CH3_CDRFREQOS_M      (ch3_cdrfreqos_m),
      .CH3_CDRINCPCTRL_M    (ch3_cdrincpctrl_m),
      .CH3_CDRSTEPDIR_M     (ch3_cdrstepdir_m),
      .CH3_CDRSTEPSQ_M      (ch3_cdrstepsq_m),
      .CH3_CDRSTEPSX_M      (ch3_cdrstepsx_m),
    //.CH3_CFOKOVWRFINISH_M (ch3_cfokovwrfinish_m),
    //.CH3_CFOKOVWRPULSE_M  (ch3_cfokovwrpulse_m),
    //.CH3_CFOKOVWRSTART_M  (ch3_cfokovwrstart_m),
      .CH3_CLKRSVD0_M       (ch3_clkrsvd0_m),
      .CH3_CLKRSVD1_M       (ch3_clkrsvd1_m),
      .CH3_DMONFIFORESET_M  (ch3_dmonfiforeset_m),
      .CH3_DMONITORCLK_M    (ch3_dmonitorclk_m),
      .CH3_EYESCANRESET_M   (ch3_eyescanreset_m),
      .CH3_EYESCANTRIGGER_M (ch3_eyescantrigger_m),
      .CH3_GTRSVD_M         (ch3_gtrsvd_m),
      .CH3_GTRXRESET_M      (ch3_gtrxreset_m),
      .CH3_GTTXRESET_M      (ch3_gttxreset_m),
      .CH3_HSDPPCSRESET_M   (ch3_hsdppcsreset_m),
      .CH3_ILORESETMASK_M   (ch3_iloresetmask_m),
      .CH3_ILORESET_M       (ch3_iloreset_m),
      .CH3_LOOPBACK_M       (ch3_loopback_m),
      .CH3_PCIERSTB_M       (ch3_pcierstb_m),
      .CH3_PCSRSVDIN_M      (ch3_pcsrsvdin_m),
      .CH3_PHYESMADAPTSAVE_M(ch3_phyesmadaptsave_m),
      .CH3_RXCDRHOLD_M      (ch3_rxcdrhold_m),
      .CH3_RXCDROVRDEN_M    (ch3_rxcdrovrden_m),
      .CH3_RXCDRRESET_M     (ch3_rxcdrreset_m),
      .CH3_RXCHBONDI_M      (ch3_rxchbondi_m),
      .CH3_RXDAPICODEOVRDEN_M(ch3_rxdapicodeovrden_m),
      .CH3_RXDAPICODERESET_M(ch3_rxdapicodereset_m),
      .CH3_RXDLYALIGNREQ_M  (ch3_rxdlyalignreq_m),
      .CH3_RXEQTRAINING_M   (ch3_rxeqtraining_m),
      .CH3_RXGEARBOXSLIP_M  (ch3_rxgearboxslip_m),
      .CH3_RXLATCLK_M       (ch3_rxlatclk_m),
      .CH3_RXLPMEN_M        (ch3_rxlpmen_m),
      .CH3_RXMLDCHAINDONE_M (ch3_rxmldchaindone_m),
      .CH3_RXMLDCHAINREQ_M  (ch3_rxmldchainreq_m),
      .CH3_RXMLFINEALIGNREQ_M(ch3_rxmlfinealignreq_m),
      .CH3_RXOOBRESET_M     (ch3_rxoobreset_m),
      .CH3_RXPCSRESETMASK_M (ch3_rxpcsresetmask_m),
      .CH3_RXPD_M           (ch3_rxpd_m),
      .CH3_RXPHALIGNREQ_M   (ch3_rxphalignreq_m),
      .CH3_RXPHALIGNRESETMASK_M(ch3_rxphalignresetmask_m),
      .CH3_RXPHDLYPD_M      (ch3_rxphdlypd_m),
      .CH3_RXPHDLYRESET_M   (ch3_rxphdlyreset_m),
      .CH3_RXPHSETINITREQ_M (ch3_rxphsetinitreq_m),
      .CH3_RXPHSHIFT180_M   (ch3_rxphshift180_m),
      .CH3_RXPMARESETMASK_M (ch3_rxpmaresetmask_m),
      .CH3_RXPOLARITY_M     (ch3_rxpolarity_m),
      .CH3_RXPRBSCNTRESET_M (ch3_rxprbscntreset_m),
      .CH3_RXPRBSSEL_M      (ch3_rxprbssel_m),
      .CH3_RXPROGDIVRESET_M (ch3_rxprogdivreset_m),
      .CH3_RXRATE_M         (ch3_rxrate_m),
      .CH3_RXRESETMODE_M    (ch3_rxresetmode_m),
      .CH3_RXSLIDE_M        (ch3_rxslide_m),
      .CH3_RXSYNCALLIN_M    (ch3_rxsyncallin_m),
      .CH3_RXTERMINATION_M  (ch3_rxtermination_m),
      .CH3_RXUSERRDY_M      (ch3_rxuserrdy_m),
      .CH3_RXUSRCLK_M       (ch3_rxusrclk_m),
      .CH3_TSTIN_M          (ch3_tstin_m),
      .CH3_TXCOMINIT_M      (ch3_txcominit_m),
      .CH3_TXCOMSAS_M       (ch3_txcomsas_m),
      .CH3_TXCOMWAKE_M      (ch3_txcomwake_m),
      .CH3_TXCTRL0_M        (ch3_txctrl0_m),
      .CH3_TXCTRL1_M        (ch3_txctrl1_m),
      .CH3_TXCTRL2_M        (ch3_txctrl2_m),
      .CH3_TXDAPICODEOVRDEN_M(ch3_txdapicodeovrden_m),
      .CH3_TXDAPICODERESET_M(ch3_txdapicodereset_m),
      .CH3_TXDATAEXTENDRSVD_M(ch3_txdataextendrsvd_m),
      .CH3_TXDATA_M         (ch3_txdata_m),
      .CH3_TXDEEMPH_M       (ch3_txdeemph_m),
      .CH3_TXDETECTRX_M     (ch3_txdetectrx_m),
      .CH3_TXDIFFCTRL_M     (ch3_txdiffctrl_m),
      .CH3_TXDLYALIGNREQ_M  (ch3_txdlyalignreq_m),
      .CH3_TXELECIDLE_M     (ch3_txelecidle_m),
      .CH3_TXHEADER_M       (ch3_txheader_m),
      .CH3_TXINHIBIT_M      (ch3_txinhibit_m),
      .CH3_TXLATCLK_M       (ch3_txlatclk_m),
      .CH3_TXMAINCURSOR_M   (ch3_txmaincursor_m),
      .CH3_TXMARGIN_M       (ch3_txmargin_m),
      .CH3_TXMLDCHAINDONE_M (ch3_txmldchaindone_m),
      .CH3_TXMLDCHAINREQ_M  (ch3_txmldchainreq_m),
      .CH3_TXONESZEROS_M    (ch3_txoneszeros_m),
      .CH3_TXPAUSEDELAYALIGN_M(ch3_txpausedelayalign_m),
      .CH3_TXPCSRESETMASK_M (ch3_txpcsresetmask_m),
      .CH3_TXPD_M           (ch3_txpd_m),
      .CH3_TXPHALIGNREQ_M   (ch3_txphalignreq_m),
      .CH3_TXPHALIGNRESETMASK_M(ch3_txphalignresetmask_m),
      .CH3_TXPHDLYPD_M      (ch3_txphdlypd_m),
      .CH3_TXPHDLYRESET_M   (ch3_txphdlyreset_m),
      .CH3_TXPHDLYTSTCLK_M  (ch3_txphdlytstclk_m),
      .CH3_TXPHSETINITREQ_M (ch3_txphsetinitreq_m),
      .CH3_TXPHSHIFT180_M   (ch3_txphshift180_m),
      .CH3_TXPICODEOVRDEN_M (ch3_txpicodeovrden_m),
      .CH3_TXPICODERESET_M  (ch3_txpicodereset_m),
      .CH3_TXPIPPMEN_M      (ch3_txpippmen_m),
      .CH3_TXPIPPMSTEPSIZE_M(ch3_txpippmstepsize_m),
      .CH3_TXPISOPD_M       (ch3_txpisopd_m),
      .CH3_TXPMARESETMASK_M (ch3_txpmaresetmask_m),
      .CH3_TXPOLARITY_M     (ch3_txpolarity_m),
      .CH3_TXPOSTCURSOR_M   (ch3_txpostcursor_m),
      .CH3_TXPRBSFORCEERR_M (ch3_txprbsforceerr_m),
      .CH3_TXPRBSSEL_M      (ch3_txprbssel_m),
      .CH3_TXPRECURSOR_M    (ch3_txprecursor_m),
      .CH3_TXPROGDIVRESET_M (ch3_txprogdivreset_m),
      .CH3_TXRATE_M         (ch3_txrate_m),
      .CH3_TXRESETMODE_M    (ch3_txresetmode_m),
      .CH3_TXSEQUENCE_M     (ch3_txsequence_m),
      .CH3_TXSWING_M        (ch3_txswing_m),
      .CH3_TXSYNCALLIN_M    (ch3_txsyncallin_m),
      .CH3_TXUSERRDY_M      (ch3_txuserrdy_m),
      .CH3_TXUSRCLK_M       (ch3_txusrclk_m),
      .CTRLRSVDIN0_M        (ctrlrsvdin0_m),
      .CTRLRSVDIN1_M        (ctrlrsvdin1_m),
      .DEBUGTRACECLK_M      (debugtraceclk_m),
      .DEBUGTRACEREADY_M    (debugtracetready_m),
      .GPI_M(gpi_m),
    //.HSCLK0_GTGREFCLK2LCPLL_M (hsclk0_gtgrefclk2lcpll_m),
    //.HSCLK0_GTGREFCLK2RPLL_M  (hsclk0_gtgrefclk2rpll_m),
      .HSCLK0_LCPLLCLKRSVD0_M   (hsclk0_lcpllclkrsvd0_m),
      .HSCLK0_LCPLLCLKRSVD1_M   (hsclk0_lcpllclkrsvd1_m),
      .HSCLK0_LCPLLFBDIV_M      (hsclk0_lcpllfbdiv_m),
      .HSCLK0_LCPLLPD_M         (hsclk0_lcpllpd_m),
      .HSCLK0_LCPLLREFCLKSEL_M  (hsclk0_lcpllrefclksel_m),
      .HSCLK0_LCPLLRESETBYPASSMODE_M(hsclk0_lcpllresetbypassmode_m),
      .HSCLK0_LCPLLRESETMASK_M  (hsclk0_lcpllresetmask_m),
      .HSCLK0_LCPLLRESET_M      (hsclk0_lcpllreset_m),
      .HSCLK0_LCPLLRSVD0_M      (hsclk0_lcpllrsvd0_m),
      .HSCLK0_LCPLLRSVD1_M      (hsclk0_lcpllrsvd1_m),
      .HSCLK0_LCPLLSDMDATA_M    (hsclk0_lcpllsdmdata_m),
      .HSCLK0_LCPLLSDMTOGGLE_M  (hsclk0_lcpllsdmtoggle_m),
      .HSCLK0_RPLLCLKRSVD0_M    (hsclk0_rpllclkrsvd0_m),
      .HSCLK0_RPLLCLKRSVD1_M    (hsclk0_rpllclkrsvd1_m),
      .HSCLK0_RPLLFBDIV_M       (hsclk0_rpllfbdiv_m),
      .HSCLK0_RPLLPD_M          (hsclk0_rpllpd_m),
      .HSCLK0_RPLLREFCLKSEL_M   (hsclk0_rpllrefclksel_m),
      .HSCLK0_RPLLRESETBYPASSMODE_M(hsclk0_rpllresetbypassmode_m),
      .HSCLK0_RPLLRESETMASK_M   (hsclk0_rpllresetmask_m),
      .HSCLK0_RPLLRESET_M       (hsclk0_rpllreset_m),
      .HSCLK0_RPLLRSVD0_M       (hsclk0_rpllrsvd0_m),
      .HSCLK0_RPLLRSVD1_M       (hsclk0_rpllrsvd1_m),
      .HSCLK0_RPLLSDMDATA_M     (hsclk0_rpllsdmdata_m),
      .HSCLK0_RPLLSDMTOGGLE_M   (hsclk0_rpllsdmtoggle_m),
    //.HSCLK1_GTGREFCLK2LCPLL_M (hsclk1_gtgrefclk2lcpll_m),
    //.HSCLK1_GTGREFCLK2RPLL_M  (hsclk1_gtgrefclk2rpll_m),
      .HSCLK1_LCPLLCLKRSVD0_M   (hsclk1_lcpllclkrsvd0_m),
      .HSCLK1_LCPLLCLKRSVD1_M   (hsclk1_lcpllclkrsvd1_m),
      .HSCLK1_LCPLLFBDIV_M      (hsclk1_lcpllfbdiv_m),
      .HSCLK1_LCPLLPD_M         (hsclk1_lcpllpd_m),
      .HSCLK1_LCPLLREFCLKSEL_M  (hsclk1_lcpllrefclksel_m),
      .HSCLK1_LCPLLRESETBYPASSMODE_M(hsclk1_lcpllresetbypassmode_m),
      .HSCLK1_LCPLLRESETMASK_M  (hsclk1_lcpllresetmask_m),
      .HSCLK1_LCPLLRESET_M      (hsclk1_lcpllreset_m),
      .HSCLK1_LCPLLRSVD0_M      (hsclk1_lcpllrsvd0_m),
      .HSCLK1_LCPLLRSVD1_M      (hsclk1_lcpllrsvd1_m),
      .HSCLK1_LCPLLSDMDATA_M    (hsclk1_lcpllsdmdata_m),
      .HSCLK1_LCPLLSDMTOGGLE_M  (hsclk1_lcpllsdmtoggle_m),
      .HSCLK1_RPLLCLKRSVD0_M    (hsclk1_rpllclkrsvd0_m),
      .HSCLK1_RPLLCLKRSVD1_M    (hsclk1_rpllclkrsvd1_m),
      .HSCLK1_RPLLFBDIV_M       (hsclk1_rpllfbdiv_m),
      .HSCLK1_RPLLPD_M          (hsclk1_rpllpd_m),
      .HSCLK1_RPLLREFCLKSEL_M   (hsclk1_rpllrefclksel_m),
      .HSCLK1_RPLLRESETBYPASSMODE_M(hsclk1_rpllresetbypassmode_m),
      .HSCLK1_RPLLRESETMASK_M   (hsclk1_rpllresetmask_m),
      .HSCLK1_RPLLRESET_M       (hsclk1_rpllreset_m),
      .HSCLK1_RPLLRSVD0_M       (hsclk1_rpllrsvd0_m),
      .HSCLK1_RPLLRSVD1_M       (hsclk1_rpllrsvd1_m),
      .HSCLK1_RPLLSDMDATA_M     (hsclk1_rpllsdmdata_m),
      .HSCLK1_RPLLSDMTOGGLE_M   (hsclk1_rpllsdmtoggle_m),
      .M0_AXIS_TREADY_M         (s0_axis_tready_m),
      .M1_AXIS_TREADY_M         (s1_axis_tready_m),
      .M2_AXIS_TREADY_M         (s2_axis_tready_m),
      .MSTRXRESET_M             ({ch3_mstrxreset_m,ch2_mstrxreset_m,ch1_mstrxreset_m,ch0_mstrxreset_m}),
      .MSTTXRESET_M             ({ch3_msttxreset_m,ch2_msttxreset_m,ch1_msttxreset_m,ch0_msttxreset_m}),
      .PCIELINKREACHTARGET_M    (pcielinkreachtarget_m),

      .PCIELTSSM_M          (pcieltssm_m),
      .RCALENB_M            (rcalenb_m),
    //.REFCLK0_CEB_M        (refclk0_ceb_m),
      .REFCLK0_CLKTESTSIG_M (refclk0_clktestsig_m),
      .REFCLK0_GTREFCLKPD_M (refclk0_gtrefclkpd_m),
    //.REFCLK0_GTREFCLKPD_M (1'b0),
    //.REFCLK1_CEB_M        (refclk1_ceb_m),
      .REFCLK1_CLKTESTSIG_M (refclk1_clktestsig_m),
      .REFCLK1_GTREFCLKPD_M (refclk1_gtrefclkpd_m),
      .RXMARGINREQCMD_M     (rxmarginreqcmd_m),
      .RXMARGINREQLANENUM_M (rxmarginreqlanenum_m),
      .RXMARGINREQPAYLD_M   (rxmarginreqpayld_m),
      .RXMARGINREQREQ_M     (rxmarginreqreq_m),
      .RXMARGINRESACK_M     (rxmarginresack_m),
      .S0_AXIS_TDATA_M      (m0_axis_tdata_m),
      .S0_AXIS_TLAST_M      (m0_axis_tlast_m),
      .S0_AXIS_TVALID_M     (m0_axis_tvalid_m),
      .S0_AXIS_TREADY_M     (m0_axis_tready_m),
      .S1_AXIS_TDATA_M      (m1_axis_tdata_m),
      .S1_AXIS_TLAST_M      (m1_axis_tlast_m),
      .S1_AXIS_TVALID_M     (m1_axis_tvalid_m),
      .S1_AXIS_TREADY_M     (m1_axis_tready_m),
      .S2_AXIS_TREADY_M     (m2_axis_tready_m),
      .S2_AXIS_TDATA_M      (m2_axis_tdata_m),
      .S2_AXIS_TLAST_M      (m2_axis_tlast_m),
      .S2_AXIS_TVALID_M     (m2_axis_tvalid_m),
      .TRIGACKOUT0_M        (trigackout0_m),
      .TRIGIN0_M            (trigin0_m),
      .UBENABLE_M           (ubenable_m),
      .UBINTR_M             (ubintr_m),
      .UBIOLMBRST_M         (ubiolmbrst_m),
      .UBMBRST_M            (ubmbrst_m),
      .UBRXUART_M           (ubrxuart_m),
      .APB3PRDATA_M         (apb3prdata_m),
      .APB3PREADY_M         (apb3pready_m),
      .APB3PSLVERR_M        (apb3pslverr_m),
      .CH0_BUFGTCEMASK_M    (ch0_bufgtcemask_m),
      .CH0_BUFGTCE_M        (ch0_bufgtce_m),
      .CH0_BUFGTDIV_M       (ch0_bufgtdiv_m),
      .CH0_BUFGTRSTMASK_M   (ch0_bufgtrstmask_m),
      .CH0_BUFGTRST_M       (ch0_bufgtrst_m),
    //.CH0_CFOKOVWRRDY0_M   (ch0_cfokovwrrdy0_m),
    //.CH0_CFOKOVWRRDY1_M   (ch0_cfokovwrrdy1_m),
      .CH0_DMONITOROUT_M    (ch0_dmonitorout_m),
      .CH0_EYESCANDATAERROR_M(ch0_eyescandataerror_m),
      .CH0_ILORESETDONE_M   (ch0_iloresetdone_m),
      .CH0_PCSRSVDOUT_M     (ch0_pcsrsvdout_m),
      .CH0_PINRSVDAS_M      (ch0_pinrsvdas_m),
      .CH0_PHYREADY_M       (ch0_phyready_m),
      .CH0_PHYSTATUS_M      (ch0_phystatus_m),
    //.CH0_PINRSRVDAS_M     (ch0_pinrsrvdas_m),
      .CH0_RESETEXCEPTION_M (ch0_resetexception_m),
      .CH0_RX10GSTAT_M      (ch0_rx10gstat_m),
      .CH0_RXBUFSTATUS_M    (ch0_rxbufstatus_m),
      .CH0_RXBYTEISALIGNED_M(ch0_rxbyteisaligned_m),
      .CH0_RXBYTEREALIGN_M  (ch0_rxbyterealign_m),
      .CH0_RXCDRLOCK_M      (ch0_rxcdrlock_m),
      .CH0_RXCDRPHDONE_M    (ch0_rxcdrphdone_m),
      .CH0_RXCHANBONDSEQ_M  (ch0_rxchanbondseq_m),
      .CH0_RXCHANISALIGNED_M(ch0_rxchanisaligned_m),
      .CH0_RXCHANREALIGN_M  (ch0_rxchanrealign_m),
      .CH0_RXCHBONDO_M      (ch0_rxchbondo_m),
      .CH0_RXCLKCORCNT_M    (ch0_rxclkcorcnt_m),
      .CH0_RXCOMINITDET_M   (ch0_rxcominitdet_m),
      .CH0_RXCOMMADET_M     (ch0_rxcommadet_m),
      .CH0_RXCOMSASDET_M    (ch0_rxcomsasdet_m),
      .CH0_RXCOMWAKEDET_M   (ch0_rxcomwakedet_m),
      .CH0_RXCTRL0_M        (ch0_rxctrl0_m),
      .CH0_RXCTRL1_M        (ch0_rxctrl1_m),
      .CH0_RXCTRL2_M        (ch0_rxctrl2_m),
      .CH0_RXCTRL3_M        (ch0_rxctrl3_m),
      .CH0_RXDATAEXTENDRSVD_M(ch0_rxdataextendrsvd_m),
      .CH0_RXDATAVALID_M    (ch0_rxdatavalid_m),
      .CH0_RXDATA_M         (ch0_rxdata_m),
      .CH0_RXDCCDONE_M      (ch0_rxdccdone_m),
      .CH0_RXDLYALIGNERR_M  (ch0_rxdlyalignerr_m),
      .CH0_RXDLYALIGNPROG_M (ch0_rxdlyalignprog_m),
      .CH0_RXELECIDLE_M     (ch0_rxelecidle_m),
      .CH0_RXFINEALIGNDONE_M(ch0_rxfinealigndone_m),
      .CH0_RXHEADERVALID_M  (ch0_rxheadervalid_m),
      .CH0_RXHEADER_M       (ch0_rxheader_m),
      .CH0_RXOSINTDONE_M    (ch0_rxosintdone_m),
      .CH0_RXOSINTSTARTED_M (ch0_rxosintstarted_m),
      .CH0_RXOSINTSTROBEDONE_M(ch0_rxosintstrobedone_m),
      .CH0_RXOSINTSTROBESTARTED_M(ch0_rxosintstrobestarted_m),
      .CH0_RXPHALIGNDONE_M    (ch0_rxphaligndone_m),
      .CH0_RXPHALIGNERR_M     (ch0_rxphalignerr_m),
      .CH0_RXPHDLYRESETDONE_M (ch0_rxphdlyresetdone_m),
      .CH0_RXPHSETINITDONE_M  (ch0_rxphsetinitdone_m),
      .CH0_RXPHSHIFT180DONE_M (ch0_rxphshift180done_m),
      .CH0_RXPMARESETDONE_M   (ch0_rxpmaresetdone_m),
      .CH0_RXPRBSERR_M        (ch0_rxprbserr_m),
      .CH0_RXPRBSLOCKED_M     (ch0_rxprbslocked_m),
    //.CH0_RXPRGDIVRESETDONE_M(ch0_rxprgdivresetdone_m),
      .CH0_RXRESETDONE_M      (ch0_rxresetdone_m),
      .CH0_RXSLIDERDY_M       (ch0_rxsliderdy_m),
      .CH0_RXSTARTOFSEQ_M     (ch0_rxstartofseq_m),
      .CH0_RXSTATUS_M         (ch0_rxstatus_m),
      .CH0_RXSYNCDONE_M       (ch0_rxsyncdone_m),
      .CH0_RXVALID_M          (ch0_rxvalid_m),

      .CH0_TSTCLK0_M(ch0_tstclk0_m),
      .CH0_TSTCLK1_M(ch0_tstclk1_m),
      .CH1_TSTCLK0_M(ch1_tstclk0_m),
      .CH1_TSTCLK1_M(ch1_tstclk1_m),
      .CH2_TSTCLK0_M(ch2_tstclk0_m),
      .CH2_TSTCLK1_M(ch2_tstclk1_m),
      .CH3_TSTCLK0_M(ch3_tstclk0_m),
      .CH3_TSTCLK1_M(ch3_tstclk1_m),

      .CH0_TX10GSTAT_M      (ch0_tx10gstat_m),
      .CH0_TXBUFSTATUS_M    (ch0_txbufstatus_m),
      .CH0_TXCOMFINISH_M    (ch0_txcomfinish_m),
      .CH0_TXDCCDONE_M      (ch0_txdccdone_m),
      .CH0_TXDLYALIGNERR_M  (ch0_txdlyalignerr_m),
      .CH0_TXDLYALIGNPROG_M (ch0_txdlyalignprog_m),
      .CH0_TXOUTCLK_M       (ch0_txoutclk_m),
      .CH0_TXPHALIGNDONE_M  (ch0_txphaligndone_m),
      .CH0_TXPHALIGNERR_M   (ch0_txphalignerr_m),
      .CH0_TXPHALIGNOUTRSVD_M(ch0_txphalignoutrsvd_m),
      .CH0_TXPHDLYRESETDONE_M(ch0_txphdlyresetdone_m),
      .CH0_TXPHSETINITDONE_M(ch0_txphsetinitdone_m),
      .CH0_CFOKOVRDFINISH_M (ch0_cfokovrdfinish_m),
      .CH1_CFOKOVRDFINISH_M (ch1_cfokovrdfinish_m),
      .CH2_CFOKOVRDFINISH_M (ch2_cfokovrdfinish_m),
      .CH3_CFOKOVRDFINISH_M (ch3_cfokovrdfinish_m),
      .CH0_CFOKOVRDPULSE_M  (ch0_cfokovrdpulse_m),
      .CH1_CFOKOVRDPULSE_M  (ch1_cfokovrdpulse_m),
      .CH2_CFOKOVRDPULSE_M  (ch2_cfokovrdpulse_m),
      .CH3_CFOKOVRDPULSE_M  (ch3_cfokovrdpulse_m),

      .CH0_CFOKOVRDSTART_M  (ch0_cfokovrdstart_m),
      .CH1_CFOKOVRDSTART_M  (ch1_cfokovrdstart_m),
      .CH2_CFOKOVRDSTART_M  (ch2_cfokovrdstart_m),
      .CH3_CFOKOVRDSTART_M  (ch3_cfokovrdstart_m),
      .CH0_CFOKOVRDRDY0_M   (ch0_cfokovrdrdy0_m),
      .CH0_CFOKOVRDRDY1_M   (ch0_cfokovrdrdy1_m),
      .CH1_CFOKOVRDRDY0_M   (ch1_cfokovrdrdy0_m),
      .CH1_CFOKOVRDRDY1_M   (ch1_cfokovrdrdy1_m),
      .CH2_CFOKOVRDRDY0_M   (ch2_cfokovrdrdy0_m),
      .CH2_CFOKOVRDRDY1_M   (ch2_cfokovrdrdy1_m),
      .CH3_CFOKOVRDRDY0_M   (ch3_cfokovrdrdy0_m),
      .CH3_CFOKOVRDRDY1_M   (ch3_cfokovrdrdy1_m),

      .CH0_TXPHSHIFT180DONE_M  (ch0_txphshift180done_m),
      .CH0_TXPMARESETDONE_M    (ch0_txpmaresetdone_m),
    //.CH0_TXPRGDIVRESETDONE_M (ch0_txprgdivresetdone_m),
      .CH0_TXRESETDONE_M       (ch0_txresetdone_m),
      .CH0_TXSYNCDONE_M        (ch0_txsyncdone_m),
      .CH1_BUFGTCEMASK_M       (ch1_bufgtcemask_m),
      .CH1_BUFGTCE_M           (ch1_bufgtce_m),
      .CH1_BUFGTDIV_M          (ch1_bufgtdiv_m),
      .CH1_BUFGTRSTMASK_M      (ch1_bufgtrstmask_m),
      .CH1_BUFGTRST_M          (ch1_bufgtrst_m),
    //.CH1_CFOKOVWRRDY0_M      (ch1_cfokovwrrdy0_m),
    //.CH1_CFOKOVWRRDY1_M      (ch1_cfokovwrrdy1_m),
      .CH1_DMONITOROUT_M       (ch1_dmonitorout_m),
      .CH1_EYESCANDATAERROR_M  (ch1_eyescandataerror_m),
      .CH1_ILORESETDONE_M      (ch1_iloresetdone_m),
      .CH1_PCSRSVDOUT_M        (ch1_pcsrsvdout_m),
      .CH1_PINRSVDAS_M         (ch1_pinrsvdas_m),
      .CH1_PHYREADY_M          (ch1_phyready_m),
      .CH1_PHYSTATUS_M         (ch1_phystatus_m),
    //.CH1_PINRSRVDAS_M        (ch1_pinrsrvdas_m),
      .CH1_RESETEXCEPTION_M    (ch1_resetexception_m),
      .CH1_RX10GSTAT_M         (ch1_rx10gstat_m),
      .CH1_RXBUFSTATUS_M       (ch1_rxbufstatus_m),
      .CH1_RXBYTEISALIGNED_M   (ch1_rxbyteisaligned_m),
      .CH1_RXBYTEREALIGN_M     (ch1_rxbyterealign_m),
      .CH1_RXCDRLOCK_M         (ch1_rxcdrlock_m),
      .CH1_RXCDRPHDONE_M       (ch1_rxcdrphdone_m),
      .CH1_RXCHANBONDSEQ_M     (ch1_rxchanbondseq_m),
      .CH1_RXCHANISALIGNED_M   (ch1_rxchanisaligned_m),
      .CH1_RXCHANREALIGN_M     (ch1_rxchanrealign_m),
      .CH1_RXCHBONDO_M         (ch1_rxchbondo_m),
      .CH1_RXCLKCORCNT_M       (ch1_rxclkcorcnt_m),
      .CH1_RXCOMINITDET_M      (ch1_rxcominitdet_m),
      .CH1_RXCOMMADET_M        (ch1_rxcommadet_m),
      .CH1_RXCOMSASDET_M       (ch1_rxcomsasdet_m),
      .CH1_RXCOMWAKEDET_M      (ch1_rxcomwakedet_m),
      .CH1_RXCTRL0_M           (ch1_rxctrl0_m),
      .CH1_RXCTRL1_M           (ch1_rxctrl1_m),
      .CH1_RXCTRL2_M           (ch1_rxctrl2_m),
      .CH1_RXCTRL3_M           (ch1_rxctrl3_m),
      .CH1_RXDATAEXTENDRSVD_M  (ch1_rxdataextendrsvd_m),
      .CH1_RXDATAVALID_M       (ch1_rxdatavalid_m),
      .CH1_RXDATA_M            (ch1_rxdata_m),
      .CH1_RXDCCDONE_M         (ch1_rxdccdone_m),
      .CH1_RXDLYALIGNERR_M     (ch1_rxdlyalignerr_m),
      .CH1_RXDLYALIGNPROG_M    (ch1_rxdlyalignprog_m),
      .CH1_RXELECIDLE_M        (ch1_rxelecidle_m),
      .CH1_RXFINEALIGNDONE_M   (ch1_rxfinealigndone_m),
      .CH1_RXHEADERVALID_M     (ch1_rxheadervalid_m),
      .CH1_RXHEADER_M          (ch1_rxheader_m),
      .CH1_RXOSINTDONE_M       (ch1_rxosintdone_m),
      .CH1_RXOSINTSTARTED_M    (ch1_rxosintstarted_m),
      .CH1_RXOSINTSTROBEDONE_M (ch1_rxosintstrobedone_m),
      .CH1_RXOSINTSTROBESTARTED_M(ch1_rxosintstrobestarted_m),
      .CH1_RXPHALIGNDONE_M     (ch1_rxphaligndone_m),
      .CH1_RXPHALIGNERR_M      (ch1_rxphalignerr_m),
      .CH1_RXPHDLYRESETDONE_M  (ch1_rxphdlyresetdone_m),
      .CH1_RXPHSETINITDONE_M   (ch1_rxphsetinitdone_m),
      .CH1_RXPHSHIFT180DONE_M  (ch1_rxphshift180done_m),
      .CH1_RXPMARESETDONE_M    (ch1_rxpmaresetdone_m),
      .CH1_RXPRBSERR_M         (ch1_rxprbserr_m),
      .CH1_RXPRBSLOCKED_M      (ch1_rxprbslocked_m),
    //.CH1_RXPRGDIVRESETDONE_M (ch1_rxprgdivresetdone_m),
      .CH1_RXRESETDONE_M       (ch1_rxresetdone_m),
      .CH1_RXSLIDERDY_M        (ch1_rxsliderdy_m),
      .CH1_RXSTARTOFSEQ_M      (ch1_rxstartofseq_m),
      .CH1_RXSTATUS_M          (ch1_rxstatus_m),
      .CH1_RXSYNCDONE_M        (ch1_rxsyncdone_m),
      .CH1_RXVALID_M           (ch1_rxvalid_m),
      .CH1_TX10GSTAT_M         (ch1_tx10gstat_m),
      .CH1_TXBUFSTATUS_M       (ch1_txbufstatus_m),
      .CH1_TXCOMFINISH_M       (ch1_txcomfinish_m),
      .CH1_TXDCCDONE_M         (ch1_txdccdone_m),
      .CH1_TXDLYALIGNERR_M     (ch1_txdlyalignerr_m),
      .CH1_TXDLYALIGNPROG_M    (ch1_txdlyalignprog_m),
      .CH1_TXPHALIGNDONE_M     (ch1_txphaligndone_m),
      .CH1_TXPHALIGNERR_M      (ch1_txphalignerr_m),
      .CH1_TXPHALIGNOUTRSVD_M  (ch1_txphalignoutrsvd_m),
      .CH1_TXPHDLYRESETDONE_M  (ch1_txphdlyresetdone_m),
      .CH1_TXPHSETINITDONE_M   (ch1_txphsetinitdone_m),
      .CH1_TXPHSHIFT180DONE_M  (ch1_txphshift180done_m),
      .CH1_TXPMARESETDONE_M    (ch1_txpmaresetdone_m),
    //.CH1_TXPRGDIVRESETDONE_M (ch1_txprgdivresetdone_m),
      .CH1_TXRESETDONE_M       (ch1_txresetdone_m),
      .CH1_TXSYNCDONE_M        (ch1_txsyncdone_m),
      .CH2_BUFGTCEMASK_M       (ch2_bufgtcemask_m),
      .CH2_BUFGTCE_M           (ch2_bufgtce_m),
      .CH2_BUFGTDIV_M          (ch2_bufgtdiv_m),
      .CH2_BUFGTRSTMASK_M      (ch2_bufgtrstmask_m),
      .CH2_BUFGTRST_M          (ch2_bufgtrst_m),
    //.CH2_CFOKOVWRRDY0_M      (ch2_cfokovwrrdy0_m),
    //.CH2_CFOKOVWRRDY1_M      (ch2_cfokovwrrdy1_m),
      .CH2_DMONITOROUT_M       (ch2_dmonitorout_m),
      .CH2_EYESCANDATAERROR_M  (ch2_eyescandataerror_m),
      .CH2_ILORESETDONE_M      (ch2_iloresetdone_m),
      .CH2_PCSRSVDOUT_M        (ch2_pcsrsvdout_m),
      .CH2_PINRSVDAS_M         (ch2_pinrsvdas_m),
      .CH2_PHYREADY_M          (ch2_phyready_m),
      .CH2_PHYSTATUS_M         (ch2_phystatus_m),
    //.CH2_PINRSRVDAS_M        (ch2_pinrsrvdas_m),
      .CH2_RESETEXCEPTION_M    (ch2_resetexception_m),
      .CH2_RX10GSTAT_M         (ch2_rx10gstat_m),
      .CH2_RXBUFSTATUS_M       (ch2_rxbufstatus_m),
      .CH2_RXBYTEISALIGNED_M   (ch2_rxbyteisaligned_m),
      .CH2_RXBYTEREALIGN_M     (ch2_rxbyterealign_m),
      .CH2_RXCDRLOCK_M         (ch2_rxcdrlock_m),
      .CH2_RXCDRPHDONE_M       (ch2_rxcdrphdone_m),
      .CH2_RXCHANBONDSEQ_M     (ch2_rxchanbondseq_m),
      .CH2_RXCHANISALIGNED_M   (ch2_rxchanisaligned_m),
      .CH2_RXCHANREALIGN_M     (ch2_rxchanrealign_m),
      .CH2_RXCHBONDO_M         (ch2_rxchbondo_m),
      .CH2_RXCLKCORCNT_M       (ch2_rxclkcorcnt_m),
      .CH2_RXCOMINITDET_M      (ch2_rxcominitdet_m),
      .CH2_RXCOMMADET_M        (ch2_rxcommadet_m),
      .CH2_RXCOMSASDET_M       (ch2_rxcomsasdet_m),
      .CH2_RXCOMWAKEDET_M      (ch2_rxcomwakedet_m),
      .CH2_RXCTRL0_M           (ch2_rxctrl0_m),
      .CH2_RXCTRL1_M           (ch2_rxctrl1_m),
      .CH2_RXCTRL2_M           (ch2_rxctrl2_m),
      .CH2_RXCTRL3_M           (ch2_rxctrl3_m),
      .CH2_RXDATAEXTENDRSVD_M  (ch2_rxdataextendrsvd_m),
      .CH2_RXDATAVALID_M       (ch2_rxdatavalid_m),
      .CH2_RXDATA_M            (ch2_rxdata_m),
      .CH2_RXDCCDONE_M         (ch2_rxdccdone_m),
      .CH2_RXDLYALIGNERR_M     (ch2_rxdlyalignerr_m),
      .CH2_RXDLYALIGNPROG_M    (ch2_rxdlyalignprog_m),
      .CH2_RXELECIDLE_M        (ch2_rxelecidle_m),
      .CH2_RXFINEALIGNDONE_M   (ch2_rxfinealigndone_m),
      .CH2_RXHEADERVALID_M     (ch2_rxheadervalid_m),
      .CH2_RXHEADER_M          (ch2_rxheader_m),
      .CH2_RXOSINTDONE_M       (ch2_rxosintdone_m),
      .CH2_RXOSINTSTARTED_M    (ch2_rxosintstarted_m),
      .CH2_RXOSINTSTROBEDONE_M (ch2_rxosintstrobedone_m),
      .CH2_RXOSINTSTROBESTARTED_M(ch2_rxosintstrobestarted_m),
      .CH2_RXPHALIGNDONE_M     (ch2_rxphaligndone_m),
      .CH2_RXPHALIGNERR_M      (ch2_rxphalignerr_m),
      .CH2_RXPHDLYRESETDONE_M  (ch2_rxphdlyresetdone_m),
      .CH2_RXPHSETINITDONE_M   (ch2_rxphsetinitdone_m),
      .CH2_RXPHSHIFT180DONE_M  (ch2_rxphshift180done_m),
      .CH2_RXPMARESETDONE_M    (ch2_rxpmaresetdone_m),
      .CH2_RXPRBSERR_M         (ch2_rxprbserr_m),
      .CH2_RXPRBSLOCKED_M      (ch2_rxprbslocked_m),
    //.CH2_RXPRGDIVRESETDONE_M (ch2_rxprgdivresetdone_m),
      .CH2_RXRESETDONE_M       (ch2_rxresetdone_m),
      .CH2_RXSLIDERDY_M        (ch2_rxsliderdy_m),
      .CH2_RXSTARTOFSEQ_M      (ch2_rxstartofseq_m),
      .CH2_RXSTATUS_M          (ch2_rxstatus_m),
      .CH2_RXSYNCDONE_M        (ch2_rxsyncdone_m),
      .CH2_RXVALID_M           (ch2_rxvalid_m),
      .CH2_TX10GSTAT_M         (ch2_tx10gstat_m),
      .CH2_TXBUFSTATUS_M       (ch2_txbufstatus_m),
      .CH2_TXCOMFINISH_M       (ch2_txcomfinish_m),
      .CH2_TXDCCDONE_M         (ch2_txdccdone_m),
      .CH2_TXDLYALIGNERR_M     (ch2_txdlyalignerr_m),
      .CH2_TXDLYALIGNPROG_M    (ch2_txdlyalignprog_m),
      .CH2_TXPHALIGNDONE_M     (ch2_txphaligndone_m),
      .CH2_TXPHALIGNERR_M      (ch2_txphalignerr_m),
      .CH2_TXPHALIGNOUTRSVD_M  (ch2_txphalignoutrsvd_m),
      .CH2_TXPHDLYRESETDONE_M  (ch2_txphdlyresetdone_m),
      .CH2_TXPHSETINITDONE_M   (ch2_txphsetinitdone_m),
      .CH2_TXPHSHIFT180DONE_M  (ch2_txphshift180done_m),
      .CH2_TXPMARESETDONE_M    (ch2_txpmaresetdone_m),
    //.CH2_TXPRGDIVRESETDONE_M (ch2_txprgdivresetdone_m),
      .CH2_TXRESETDONE_M       (ch2_txresetdone_m),
      .CH2_TXSYNCDONE_M        (ch2_txsyncdone_m),
      .CH3_BUFGTCEMASK_M       (ch3_bufgtcemask_m),
      .CH3_BUFGTCE_M           (ch3_bufgtce_m),
      .CH3_BUFGTDIV_M          (ch3_bufgtdiv_m),
      .CH3_BUFGTRSTMASK_M      (ch3_bufgtrstmask_m),
      .CH3_BUFGTRST_M          (ch3_bufgtrst_m),
    //.CH3_CFOKOVWRRDY0_M      (ch3_cfokovwrrdy0_m),
    //.CH3_CFOKOVWRRDY1_M      (ch3_cfokovwrrdy1_m),
      .CH3_DMONITOROUT_M       (ch3_dmonitorout_m),
      .CH3_EYESCANDATAERROR_M  (ch3_eyescandataerror_m),
      .CH3_ILORESETDONE_M      (ch3_iloresetdone_m),
      .CH3_PCSRSVDOUT_M        (ch3_pcsrsvdout_m),
      .CH3_PINRSVDAS_M         (ch3_pinrsvdas_m),
      .CH3_PHYREADY_M          (ch3_phyready_m),
      .CH3_PHYSTATUS_M         (ch3_phystatus_m),
    //.CH3_PINRSRVDAS_M        (ch3_pinrsrvdas_m),
      .CH3_RESETEXCEPTION_M    (ch3_resetexception_m),
      .CH3_RX10GSTAT_M         (ch3_rx10gstat_m),
      .CH3_RXBUFSTATUS_M       (ch3_rxbufstatus_m),
      .CH3_RXBYTEISALIGNED_M   (ch3_rxbyteisaligned_m),
      .CH3_RXBYTEREALIGN_M     (ch3_rxbyterealign_m),
      .CH3_RXCDRLOCK_M         (ch3_rxcdrlock_m),
      .CH3_RXCDRPHDONE_M       (ch3_rxcdrphdone_m),
      .CH3_RXCHANBONDSEQ_M     (ch3_rxchanbondseq_m),
      .CH3_RXCHANISALIGNED_M   (ch3_rxchanisaligned_m),
      .CH3_RXCHANREALIGN_M     (ch3_rxchanrealign_m),
      .CH3_RXCHBONDO_M         (ch3_rxchbondo_m),
      .CH3_RXCLKCORCNT_M       (ch3_rxclkcorcnt_m),
      .CH3_RXCOMINITDET_M      (ch3_rxcominitdet_m),
      .CH3_RXCOMMADET_M        (ch3_rxcommadet_m),
      .CH3_RXCOMSASDET_M       (ch3_rxcomsasdet_m),
      .CH3_RXCOMWAKEDET_M      (ch3_rxcomwakedet_m),
      .CH3_RXCTRL0_M           (ch3_rxctrl0_m),
      .CH3_RXCTRL1_M           (ch3_rxctrl1_m),
      .CH3_RXCTRL2_M           (ch3_rxctrl2_m),
      .CH3_RXCTRL3_M           (ch3_rxctrl3_m),
      .CH3_RXDATAEXTENDRSVD_M  (ch3_rxdataextendrsvd_m),
      .CH3_RXDATAVALID_M       (ch3_rxdatavalid_m),
      .CH3_RXDATA_M            (ch3_rxdata_m),
      .CH3_RXDCCDONE_M         (ch3_rxdccdone_m),
      .CH3_RXDLYALIGNERR_M     (ch3_rxdlyalignerr_m),
      .CH3_RXDLYALIGNPROG_M    (ch3_rxdlyalignprog_m),
      .CH3_RXELECIDLE_M        (ch3_rxelecidle_m),
      .CH3_RXFINEALIGNDONE_M   (ch3_rxfinealigndone_m),
      .CH3_RXHEADERVALID_M     (ch3_rxheadervalid_m),
      .CH3_RXHEADER_M          (ch3_rxheader_m),
      .CH3_RXOSINTDONE_M       (ch3_rxosintdone_m),
      .CH3_RXOSINTSTARTED_M    (ch3_rxosintstarted_m),
      .CH3_RXOSINTSTROBEDONE_M (ch3_rxosintstrobedone_m),
      .CH3_RXOSINTSTROBESTARTED_M(ch3_rxosintstrobestarted_m),
      .CH3_RXPHALIGNDONE_M     (ch3_rxphaligndone_m),
      .CH3_RXPHALIGNERR_M      (ch3_rxphalignerr_m),
      .CH3_RXPHDLYRESETDONE_M  (ch3_rxphdlyresetdone_m),
      .CH3_RXPHSETINITDONE_M   (ch3_rxphsetinitdone_m),
      .CH3_RXPHSHIFT180DONE_M  (ch3_rxphshift180done_m),
      .CH3_RXPMARESETDONE_M    (ch3_rxpmaresetdone_m),
      .CH3_RXPRBSERR_M         (ch3_rxprbserr_m),
      .CH3_RXPRBSLOCKED_M      (ch3_rxprbslocked_m),
    //.CH3_RXPRGDIVRESETDONE_M (ch3_rxprgdivresetdone_m),
      .CH3_RXRESETDONE_M       (ch3_rxresetdone_m),
      .CH3_RXSLIDERDY_M        (ch3_rxsliderdy_m),
      .CH3_RXSTARTOFSEQ_M      (ch3_rxstartofseq_m),
      .CH3_RXSTATUS_M          (ch3_rxstatus_m),
      .CH3_RXSYNCDONE_M        (ch3_rxsyncdone_m),
      .CH3_RXVALID_M           (ch3_rxvalid_m),

      .CH3_TX10GSTAT_M         (ch3_tx10gstat_m),
      .CH3_TXBUFSTATUS_M       (ch3_txbufstatus_m),
      .CH3_TXCOMFINISH_M       (ch3_txcomfinish_m),
      .CH3_TXDCCDONE_M         (ch3_txdccdone_m),
      .CH3_TXDLYALIGNERR_M     (ch3_txdlyalignerr_m),
      .CH3_TXDLYALIGNPROG_M    (ch3_txdlyalignprog_m),
      .CH3_TXPHALIGNDONE_M     (ch3_txphaligndone_m),
      .CH3_TXPHALIGNERR_M      (ch3_txphalignerr_m),
      .CH3_TXPHALIGNOUTRSVD_M  (ch3_txphalignoutrsvd_m),
      .CH3_TXPHDLYRESETDONE_M  (ch3_txphdlyresetdone_m),
      .CH3_TXPHSETINITDONE_M   (ch3_txphsetinitdone_m),
      .CH3_TXPHSHIFT180DONE_M  (ch3_txphshift180done_m),
      .CH3_TXPMARESETDONE_M    (ch3_txpmaresetdone_m),
    //.CH3_TXPRGDIVRESETDONE_M (ch3_txprgdivresetdone_m),
      .CH3_TXRESETDONE_M       (ch3_txresetdone_m),
      .CH3_TXSYNCDONE_M        (ch3_txsyncdone_m),
      .CORRECTERR_M            (correcterr_m),
      .CTRLRSVDOUT_M           (ctrlrsvdout_m),
      .DEBUGTRACETDATA_M       (debugtracetdata_m),
      .DEBUGTRACETVALID_M      (debugtracetvalid_m),

      .GPO_M(gpo_m),
      .GTPOWERGOOD_M(gtpowergood_m),

      .HSCLK0_LCPLLFBCLKLOST_M  (hsclk0_lcpllfbclklost_m),
      .HSCLK0_LCPLLLOCK_M       (hsclk0_lcplllock_m),
      .HSCLK0_LCPLLREFCLKLOST_M (hsclk0_lcpllrefclklost_m),
      .HSCLK0_LCPLLREFCLKMONITOR_M(hsclk0_lcpllrefclkmonitor_m),
      .HSCLK0_LCPLLRSVDOUT_M    (hsclk0_lcpllrsvdout_m),
      .HSCLK0_RPLLFBCLKLOST_M   (hsclk0_rpllfbclklost_m),
      .HSCLK0_RPLLLOCK_M        (hsclk0_rplllock_m),
      .HSCLK0_RPLLREFCLKLOST_M  (hsclk0_rpllrefclklost_m),
      .HSCLK0_RPLLREFCLKMONITOR_M(hsclk0_rpllrefclkmonitor_m),
      .HSCLK0_RPLLRSVDOUT_M     (hsclk0_rpllrsvdout_m),
      .HSCLK1_LCPLLFBCLKLOST_M  (hsclk1_lcpllfbclklost_m),
      .HSCLK1_LCPLLLOCK_M       (hsclk1_lcplllock_m),
      .HSCLK1_LCPLLREFCLKLOST_M (hsclk1_lcpllrefclklost_m),
      .HSCLK1_LCPLLREFCLKMONITOR_M(hsclk1_lcpllrefclkmonitor_m),
      .HSCLK1_LCPLLRSVDOUT_M    (hsclk1_lcpllrsvdout_m),
      .HSCLK1_RPLLFBCLKLOST_M   (hsclk1_rpllfbclklost_m),
      .HSCLK1_RPLLLOCK_M        (hsclk1_rplllock_m),
      .HSCLK1_RPLLREFCLKLOST_M  (hsclk1_rpllrefclklost_m),
      .HSCLK1_RPLLREFCLKMONITOR_M(hsclk1_rpllrefclkmonitor_m),
      .HSCLK1_RPLLRSVDOUT_M     (hsclk1_rpllrsvdout_m),

      .M0_AXIS_TDATA_M (s0_axis_tdata_m),
      .M0_AXIS_TLAST_M (s0_axis_tlast_m),
      .M0_AXIS_TVALID_M(s0_axis_tvalid_m),
      .M1_AXIS_TDATA_M (s1_axis_tdata_m),
      .M1_AXIS_TLAST_M (s1_axis_tlast_m),
      .M1_AXIS_TVALID_M(s1_axis_tvalid_m),
      .M2_AXIS_TDATA_M (s2_axis_tdata_m),
      .M2_AXIS_TLAST_M (s2_axis_tlast_m),
      .M2_AXIS_TVALID_M(s2_axis_tvalid_m),

      .MSTRXRESETDONE_M ({ch3_mstrxresetdone_m,ch2_mstrxresetdone_m,ch1_mstrxresetdone_m,ch0_mstrxresetdone_m}),
      .MSTTXRESETDONE_M ({ch3_msttxresetdone_m,ch2_msttxresetdone_m,ch1_msttxresetdone_m,ch0_msttxresetdone_m}),
      .CH0_RXPROGDIVRESETDONE_M (ch0_rxprogdivresetdone_m),
      .CH1_RXPROGDIVRESETDONE_M (ch1_rxprogdivresetdone_m),
      .CH2_RXPROGDIVRESETDONE_M (ch2_rxprogdivresetdone_m),
      .CH3_RXPROGDIVRESETDONE_M (ch3_rxprogdivresetdone_m),
      .CH0_TXPROGDIVRESETDONE_M (ch0_txprogdivresetdone_m),
      .CH1_TXPROGDIVRESETDONE_M (ch1_txprogdivresetdone_m),
      .CH2_TXPROGDIVRESETDONE_M (ch2_txprogdivresetdone_m),
      .CH3_TXPROGDIVRESETDONE_M (ch3_txprogdivresetdone_m),

      .RXMARGINREQACK_M     (rxmarginreqack_m),
      .RXMARGINRESCMD_M     (rxmarginrescmd_m),
      .RXMARGINRESLANENUM_M (rxmarginreslanenum_m),
      .RXMARGINRESPAYLD_M   (rxmarginrespayld_m),
      .RXMARGINRESREQ_M     (rxmarginresreq_m),
      .TRIGACKIN0_M         (trigackin0_m),
      .TRIGOUT0_M           (trigout0_m),
      .UBINTERRUPT_M        (ubinterrupt_m),
      .UBTXUART_M           (ubtxuart_m),
      .UNCORRECTERR_M       (uncorrecterr_m),
      .RXMARGINCLK_M        (rxmarginclk_m),

      .XPIPE_HSDP_RXGEARBOXSLIP   (hsdp_xpipe_ch0_rxgearboxslip),
      .XPIPE_HSDP_RXPCSRESET      (hsdp_xpipe_ch0_rxpcsreset),
      .XPIPE_HSDP_TXHEADER        (hsdp_xpipe_ch0_txheader),
      .XPIPE_HSDP_TXSEQUENCE      (hsdp_xpipe_ch0_txsequence),
      .XPIPE_HSDP_RXDATAVALID     (hsdp_xpipe_ch0_rxdatavalid),
      .XPIPE_HSDP_RXHEADER        (hsdp_xpipe_ch0_rxheader),
      .XPIPE_HSDP_RXRESETDONE     (hsdp_xpipe_ch0_rxresetdone),
      .XPIPE_HSDP_TXRESETDONE     (hsdp_xpipe_ch0_txresetdone),
      .XPIPE_HSDP_RXHEADERVALID   (hsdp_xpipe_ch0_rxheadervalid),

      .XPIPE_HSDP_RXGEARBOXSLIP_1 (hsdp_xpipe_ch1_rxgearboxslip),
      .XPIPE_HSDP_RXPCSRESET_1    (hsdp_xpipe_ch1_rxpcsreset),
      .XPIPE_HSDP_TXHEADER_1      (hsdp_xpipe_ch1_txheader),
      .XPIPE_HSDP_TXSEQUENCE_1    (hsdp_xpipe_ch1_txsequence),
      .XPIPE_HSDP_RXDATAVALID_1   (hsdp_xpipe_ch1_rxdatavalid),
      .XPIPE_HSDP_RXHEADER_1      (hsdp_xpipe_ch1_rxheader),
      .XPIPE_HSDP_RXRESETDONE_1   (hsdp_xpipe_ch1_rxresetdone),
      .XPIPE_HSDP_TXRESETDONE_1   (hsdp_xpipe_ch1_txresetdone),
      .XPIPE_HSDP_RXHEADERVALID_1 (hsdp_xpipe_ch1_rxheadervalid),

      .XPIPE_HSDP_RXGEARBOXSLIP_2 (hsdp_xpipe_ch2_rxgearboxslip),
      .XPIPE_HSDP_RXPCSRESET_2    (hsdp_xpipe_ch2_rxpcsreset),
      .XPIPE_HSDP_TXHEADER_2      (hsdp_xpipe_ch2_txheader),
      .XPIPE_HSDP_TXSEQUENCE_2    (hsdp_xpipe_ch2_txsequence),
      .XPIPE_HSDP_RXDATAVALID_2   (hsdp_xpipe_ch2_rxdatavalid),
      .XPIPE_HSDP_RXHEADER_2      (hsdp_xpipe_ch2_rxheader),
      .XPIPE_HSDP_RXRESETDONE_2   (hsdp_xpipe_ch2_rxresetdone),
      .XPIPE_HSDP_TXRESETDONE_2   (hsdp_xpipe_ch2_txresetdone),
      .XPIPE_HSDP_RXHEADERVALID_2 (hsdp_xpipe_ch2_rxheadervalid),

      .XPIPE_HSDP_RXGEARBOXSLIP_M (q0q1_hsdp_xpipe_ch0_rxgearboxslip),
      .XPIPE_HSDP_RXPCSRESET_M    (q0q1_hsdp_xpipe_ch0_rxpcsreset),
      .XPIPE_HSDP_TXHEADER_M      (q0q1_hsdp_xpipe_ch0_txheader),
      .XPIPE_HSDP_TXSEQUENCE_M    (q0q1_hsdp_xpipe_ch0_txsequence),
      .XPIPE_HSDP_RXDATAVALID_M   (q0q1_hsdp_xpipe_ch0_rxdatavalid),
      .XPIPE_HSDP_RXHEADER_M      (q0q1_hsdp_xpipe_ch0_rxheader),
      .XPIPE_HSDP_RXRESETDONE_M   (q0q1_hsdp_xpipe_ch0_rxresetdone),
      .XPIPE_HSDP_TXRESETDONE_M   (q0q1_hsdp_xpipe_ch0_txresetdone),
      .XPIPE_HSDP_RXHEADERVALID_M (q0q1_hsdp_xpipe_ch0_rxheadervalid),

      .XPIPE_HSDP_RXGEARBOXSLIP_M_1 (q0q1_hsdp_xpipe_ch1_rxgearboxslip),
      .XPIPE_HSDP_RXPCSRESET_M_1    (q0q1_hsdp_xpipe_ch1_rxpcsreset),
      .XPIPE_HSDP_TXHEADER_M_1      (q0q1_hsdp_xpipe_ch1_txheader),
      .XPIPE_HSDP_TXSEQUENCE_M_1    (q0q1_hsdp_xpipe_ch1_txsequence),
      .XPIPE_HSDP_RXDATAVALID_M_1   (q0q1_hsdp_xpipe_ch1_rxdatavalid),
      .XPIPE_HSDP_RXHEADER_M_1      (q0q1_hsdp_xpipe_ch1_rxheader),
      .XPIPE_HSDP_RXRESETDONE_M_1   (q0q1_hsdp_xpipe_ch1_rxresetdone),
      .XPIPE_HSDP_TXRESETDONE_M_1   (q0q1_hsdp_xpipe_ch1_txresetdone),
      .XPIPE_HSDP_RXHEADERVALID_M_1 (q0q1_hsdp_xpipe_ch1_rxheadervalid),

      .XPIPE_HSDP_RXGEARBOXSLIP_M_2 (q0q1_hsdp_xpipe_ch2_rxgearboxslip),
      .XPIPE_HSDP_RXPCSRESET_M_2    (q0q1_hsdp_xpipe_ch2_rxpcsreset),
      .XPIPE_HSDP_TXHEADER_M_2      (q0q1_hsdp_xpipe_ch2_txheader),
      .XPIPE_HSDP_TXSEQUENCE_M_2    (q0q1_hsdp_xpipe_ch2_txsequence),
      .XPIPE_HSDP_RXDATAVALID_M_2   (q0q1_hsdp_xpipe_ch2_rxdatavalid),
      .XPIPE_HSDP_RXHEADER_M_2      (q0q1_hsdp_xpipe_ch2_rxheader),
      .XPIPE_HSDP_RXRESETDONE_M_2   (q0q1_hsdp_xpipe_ch2_rxresetdone),
      .XPIPE_HSDP_TXRESETDONE_M_2   (q0q1_hsdp_xpipe_ch2_txresetdone),
      .XPIPE_HSDP_RXHEADERVALID_M_2 (q0q1_hsdp_xpipe_ch2_rxheadervalid),

      .XPIPE_PCIELINKREACHTARGET  (xpipe_lnk0_pcielinkreachtarget),
      .XPIPE_PCIELINKREACHTARGET_1(xpipe_lnk1_pcielinkreachtarget),
      .XPIPE_PCIELTSSMSTATE       (xpipe_lnk0_pcieltssmstate),
      .XPIPE_PCIELTSSMSTATE_1     (xpipe_lnk1_pcieltssmstate),
      
      .XPIPE_RXMARGINREQACK      (xpipe_rxmarginreqack_0),
      .XPIPE_RXMARGINREQACK_1    (xpipe_rxmarginreqack_1),
      .XPIPE_RXMARGINREQACK_2    (xpipe_rxmarginreqack_2),
      .XPIPE_RXMARGINREQACK_3    (xpipe_rxmarginreqack_3),
      .XPIPE_RXMARGINREQCMD      (xpipe_rxmarginreqcmd_0),
      .XPIPE_RXMARGINREQCMD_1    (xpipe_rxmarginreqcmd_1),
      .XPIPE_RXMARGINREQCMD_2    (xpipe_rxmarginreqcmd_2),
      .XPIPE_RXMARGINREQCMD_3    (xpipe_rxmarginreqcmd_3),
      .XPIPE_RXMARGINREQLANENUM  (xpipe_rxmarginreqlanenum_0),
      .XPIPE_RXMARGINREQLANENUM_1(xpipe_rxmarginreqlanenum_1),
      .XPIPE_RXMARGINREQLANENUM_2(xpipe_rxmarginreqlanenum_2),
      .XPIPE_RXMARGINREQLANENUM_3(xpipe_rxmarginreqlanenum_3),
      .XPIPE_RXMARGINREQPAYLOAD  (xpipe_rxmarginreqpayload_0),
      .XPIPE_RXMARGINREQPAYLOAD_1(xpipe_rxmarginreqpayload_1),
      .XPIPE_RXMARGINREQPAYLOAD_2(xpipe_rxmarginreqpayload_2),
      .XPIPE_RXMARGINREQPAYLOAD_3(xpipe_rxmarginreqpayload_3),
      .XPIPE_RXMARGINREQREQ      (xpipe_rxmarginreqreq_0),
      .XPIPE_RXMARGINREQREQ_1    (xpipe_rxmarginreqreq_1),
      .XPIPE_RXMARGINREQREQ_2    (xpipe_rxmarginreqreq_2),
      .XPIPE_RXMARGINREQREQ_3    (xpipe_rxmarginreqreq_3),

      .XPIPE_RXMARGINRESACK      (xpipe_rxmarginresack_0),
      .XPIPE_RXMARGINRESACK_1    (xpipe_rxmarginresack_1),
      .XPIPE_RXMARGINRESACK_2    (xpipe_rxmarginresack_2),
      .XPIPE_RXMARGINRESACK_3    (xpipe_rxmarginresack_3),
      .XPIPE_RXMARGINRESCMD      (xpipe_rxmarginrescmd_0),
      .XPIPE_RXMARGINRESCMD_1    (xpipe_rxmarginrescmd_1),
      .XPIPE_RXMARGINRESCMD_2    (xpipe_rxmarginrescmd_2),
      .XPIPE_RXMARGINRESCMD_3    (xpipe_rxmarginrescmd_3),
      .XPIPE_RXMARGINRESLANENUM  (xpipe_rxmarginreslanenum_0),
      .XPIPE_RXMARGINRESLANENUM_1(xpipe_rxmarginreslanenum_1),
      .XPIPE_RXMARGINRESLANENUM_2(xpipe_rxmarginreslanenum_2),
      .XPIPE_RXMARGINRESLANENUM_3(xpipe_rxmarginreslanenum_3),
      .XPIPE_RXMARGINRESPAYLOAD  (xpipe_rxmarginrespayload_0),
      .XPIPE_RXMARGINRESPAYLOAD_1(xpipe_rxmarginrespayload_1),
      .XPIPE_RXMARGINRESPAYLOAD_2(xpipe_rxmarginrespayload_2),
      .XPIPE_RXMARGINRESPAYLOAD_3(xpipe_rxmarginrespayload_3),
      .XPIPE_RXMARGINRESREQ      (xpipe_rxmarginresreq_0),
      .XPIPE_RXMARGINRESREQ_1    (xpipe_rxmarginresreq_1),
      .XPIPE_RXMARGINRESREQ_2    (xpipe_rxmarginresreq_2),
      .XPIPE_RXMARGINRESREQ_3    (xpipe_rxmarginresreq_3),

      .XPIPE_PCIELINKREACHTARGET_M  (q0q1_xpipe_pcielinkreachtarget_m),
      .XPIPE_PCIELINKREACHTARGET_M_1(q0q1_xpipe_pcielinkreachtarget_m_1),
      .XPIPE_PCIELTSSMSTATE_M       (q0q1_xpipe_pcieltssmstate_m),
      .XPIPE_PCIELTSSMSTATE_M_1     (q0q1_xpipe_pcieltssmstate_m_1),
      .XPIPE_RXMARGINREQCMD_M       (q0q1_xpipe_rxmarginreqcmd_m),
      .XPIPE_RXMARGINREQCMD_M_1     (q0q1_xpipe_rxmarginreqcmd_m_1),
      .XPIPE_RXMARGINREQCMD_M_2     (q0q1_xpipe_rxmarginreqcmd_m_2),
      .XPIPE_RXMARGINREQCMD_M_3     (q0q1_xpipe_rxmarginreqcmd_m_3),
      .XPIPE_RXMARGINREQLANENUM_M   (q0q1_xpipe_rxmarginreqlanenum_m),
      .XPIPE_RXMARGINREQLANENUM_M_1 (q0q1_xpipe_rxmarginreqlanenum_m_1),
      .XPIPE_RXMARGINREQLANENUM_M_2 (q0q1_xpipe_rxmarginreqlanenum_m_2),
      .XPIPE_RXMARGINREQLANENUM_M_3 (q0q1_xpipe_rxmarginreqlanenum_m_3),
      .XPIPE_RXMARGINREQPAYLOAD_M   (q0q1_xpipe_rxmarginreqpayload_m),
      .XPIPE_RXMARGINREQPAYLOAD_M_1 (q0q1_xpipe_rxmarginreqpayload_m_1),
      .XPIPE_RXMARGINREQPAYLOAD_M_2 (q0q1_xpipe_rxmarginreqpayload_m_2),
      .XPIPE_RXMARGINREQPAYLOAD_M_3 (q0q1_xpipe_rxmarginreqpayload_m_3),
      .XPIPE_RXMARGINREQREQ_M       (q0q1_xpipe_rxmarginreqreq_m),
      .XPIPE_RXMARGINREQREQ_M_1     (q0q1_xpipe_rxmarginreqreq_m_1),
      .XPIPE_RXMARGINREQREQ_M_2     (q0q1_xpipe_rxmarginreqreq_m_2),
      .XPIPE_RXMARGINREQREQ_M_3     (q0q1_xpipe_rxmarginreqreq_m_3),
      .XPIPE_RXMARGINRESACK_M       (q0q1_xpipe_rxmarginresack_m),
      .XPIPE_RXMARGINRESACK_M_1     (q0q1_xpipe_rxmarginresack_m_1),
      .XPIPE_RXMARGINRESACK_M_2     (q0q1_xpipe_rxmarginresack_m_2),
      .XPIPE_RXMARGINRESACK_M_3     (q0q1_xpipe_rxmarginresack_m_3),
      .XPIPE_RXMARGINREQACK_M       (q0q1_xpipe_rxmarginreqack_m),
      .XPIPE_RXMARGINREQACK_M_1     (q0q1_xpipe_rxmarginreqack_m_1),
      .XPIPE_RXMARGINREQACK_M_2     (q0q1_xpipe_rxmarginreqack_m_2),
      .XPIPE_RXMARGINREQACK_M_3     (q0q1_xpipe_rxmarginreqack_m_3),
      .XPIPE_RXMARGINRESCMD_M       (q0q1_xpipe_rxmarginrescmd_m),
      .XPIPE_RXMARGINRESCMD_M_1     (q0q1_xpipe_rxmarginrescmd_m_1),
      .XPIPE_RXMARGINRESCMD_M_2     (q0q1_xpipe_rxmarginrescmd_m_2),
      .XPIPE_RXMARGINRESCMD_M_3     (q0q1_xpipe_rxmarginrescmd_m_3),
      .XPIPE_RXMARGINRESLANENUM_M   (q0q1_xpipe_rxmarginreslanenum_m),
      .XPIPE_RXMARGINRESLANENUM_M_1 (q0q1_xpipe_rxmarginreslanenum_m_1),
      .XPIPE_RXMARGINRESLANENUM_M_2 (q0q1_xpipe_rxmarginreslanenum_m_2),
      .XPIPE_RXMARGINRESLANENUM_M_3 (q0q1_xpipe_rxmarginreslanenum_m_3),
      .XPIPE_RXMARGINRESPAYLOAD_M   (q0q1_xpipe_rxmarginrespayload_m),
      .XPIPE_RXMARGINRESPAYLOAD_M_1 (q0q1_xpipe_rxmarginrespayload_m_1),
      .XPIPE_RXMARGINRESPAYLOAD_M_2 (q0q1_xpipe_rxmarginrespayload_m_2),
      .XPIPE_RXMARGINRESPAYLOAD_M_3 (q0q1_xpipe_rxmarginrespayload_m_3),
      .XPIPE_RXMARGINRESREQ_M       (q0q1_xpipe_rxmarginresreq_m),
      .XPIPE_RXMARGINRESREQ_M_1     (q0q1_xpipe_rxmarginresreq_m_1),
      .XPIPE_RXMARGINRESREQ_M_2     (q0q1_xpipe_rxmarginresreq_m_2),
      .XPIPE_RXMARGINRESREQ_M_3     (q0q1_xpipe_rxmarginresreq_m_3),

      .XPIPE_PIPE_CH0_PHYSTATUS     (cpm_xpipe_ch0_phystatus),
      .XPIPE_PIPE_CH0_RXCHARISK     (cpm_xpipe_ch0_rxcharisk),
      .XPIPE_PIPE_CH0_RXDATA        (cpm_xpipe_ch0_rxdata),
      .XPIPE_PIPE_CH0_RXDATAVALID   (cpm_xpipe_ch0_rxdatavalid),
      .XPIPE_PIPE_CH0_RXELECIDLE    (cpm_xpipe_ch0_rxelecidle),
      .XPIPE_PIPE_CH0_RXSTARTBLOCK  (cpm_xpipe_ch0_rxstartblock),
      .XPIPE_PIPE_CH0_RXSTATUS      (cpm_xpipe_ch0_rxstatus),
      .XPIPE_PIPE_CH0_RXSYNCHEADER  (cpm_xpipe_ch0_rxsyncheader),
      .XPIPE_PIPE_CH0_RXVALID       (cpm_xpipe_ch0_rxvalid),
      .XPIPE_PIPE_CH0_POWERDOWN     (cpm_xpipe_ch0_powerdown),
      .XPIPE_PIPE_CH0_RXPOLARITY    (cpm_xpipe_ch0_rxpolarity),
      .XPIPE_PIPE_CH0_RXTERMINATION (cpm_xpipe_ch0_rxtermination),
      .XPIPE_PIPE_CH0_TXCHARISK     (cpm_xpipe_ch0_txcharisk),
      .XPIPE_PIPE_CH0_TXCOMPLIANCE  (cpm_xpipe_ch0_txcompliance),
      .XPIPE_PIPE_CH0_TXDATA        (cpm_xpipe_ch0_txdata),
      .XPIPE_PIPE_CH0_TXDATAVALID   (cpm_xpipe_ch0_txdatavalid),
      .XPIPE_PIPE_CH0_TXDEEMPH      (cpm_xpipe_ch0_txdeemph),
      .XPIPE_PIPE_CH0_TXDETECTRXLOOPBACK(cpm_xpipe_ch0_txdetectrxloopback),
      .XPIPE_PIPE_CH0_TXELECIDLE    (cpm_xpipe_ch0_txelecidle),
      .XPIPE_PIPE_CH0_TXMAINCURSOR  (cpm_xpipe_ch0_txmaincursor),
      .XPIPE_PIPE_CH0_TXMARGIN      (cpm_xpipe_ch0_txmargin),
      .XPIPE_PIPE_CH0_TXPOSTCURSOR  (cpm_xpipe_ch0_txpostcursor),
      .XPIPE_PIPE_CH0_TXPRECURSOR   (cpm_xpipe_ch0_txprecursor),
      .XPIPE_PIPE_CH0_TXSTARTBLOCK  (cpm_xpipe_ch0_txstartblock),
      .XPIPE_PIPE_CH0_TXSWING       (cpm_xpipe_ch0_txswing),
      .XPIPE_PIPE_CH0_TXSYNCHEADER  (cpm_xpipe_ch0_txsyncheader),

      .XPIPE_PIPE_CH0_POWERDOWN_M     (q0q1_xpipe_pipe_ch0_powerdown_m),
      .XPIPE_PIPE_CH0_RXPOLARITY_M    (q0q1_xpipe_pipe_ch0_rxpolarity_m),
      .XPIPE_PIPE_CH0_RXTERMINATION_M (q0q1_xpipe_pipe_ch0_rxtermination_m),
      .XPIPE_PIPE_CH0_TXCHARISK_M     (q0q1_xpipe_pipe_ch0_txcharisk_m),
      .XPIPE_PIPE_CH0_TXCOMPLIANCE_M  (q0q1_xpipe_pipe_ch0_txcompliance_m),
      .XPIPE_PIPE_CH0_TXDATAVALID_M   (q0q1_xpipe_pipe_ch0_txdatavalid_m),
      .XPIPE_PIPE_CH0_TXDATA_M        (q0q1_xpipe_pipe_ch0_txdata_m),
      .XPIPE_PIPE_CH0_TXDEEMPH_M      (q0q1_xpipe_pipe_ch0_txdeemph_m),
      .XPIPE_PIPE_CH0_TXELECIDLE_M    (q0q1_xpipe_pipe_ch0_txelecidle_m),
      .XPIPE_PIPE_CH0_TXMAINCURSOR_M  (q0q1_xpipe_pipe_ch0_txmaincursor_m),
      .XPIPE_PIPE_CH0_TXMARGIN_M      (q0q1_xpipe_pipe_ch0_txmargin_m),
      .XPIPE_PIPE_CH0_TXPOSTCURSOR_M  (q0q1_xpipe_pipe_ch0_txpostcursor_m),
      .XPIPE_PIPE_CH0_TXPRECURSOR_M   (q0q1_xpipe_pipe_ch0_txprecursor_m),
      .XPIPE_PIPE_CH0_TXSTARTBLOCK_M  (q0q1_xpipe_pipe_ch0_txstartblock_m),
      .XPIPE_PIPE_CH0_TXSWING_M       (q0q1_xpipe_pipe_ch0_txswing_m),
      .XPIPE_PIPE_CH0_TXSYNCHEADER_M  (q0q1_xpipe_pipe_ch0_txsyncheader_m),
      .XPIPE_PIPE_CH0_PHYSTATUS_M     (q0q1_xpipe_pipe_ch0_phystatus_m),
      .XPIPE_PIPE_CH0_RXCHARISK_M     (q0q1_xpipe_pipe_ch0_rxcharisk_m),
      .XPIPE_PIPE_CH0_RXDATAVALID_M   (q0q1_xpipe_pipe_ch0_rxdatavalid_m),
      .XPIPE_PIPE_CH0_RXDATA_M        (q0q1_xpipe_pipe_ch0_rxdata_m),
      .XPIPE_PIPE_CH0_RXELECIDLE_M    (q0q1_xpipe_pipe_ch0_rxelecidle_m),
      .XPIPE_PIPE_CH0_RXSTARTBLOCK_M  (q0q1_xpipe_pipe_ch0_rxstartblock_m),
      .XPIPE_PIPE_CH0_RXSTATUS_M      (q0q1_xpipe_pipe_ch0_rxstatus_m),
      .XPIPE_PIPE_CH0_RXSYNCHEADER_M  (q0q1_xpipe_pipe_ch0_rxsyncheader_m),
      .XPIPE_PIPE_CH0_RXVALID_M       (q0q1_xpipe_pipe_ch0_rxvalid_m),
      .XPIPE_PIPE_CH0_TXDETECTRXLOOPBACK_M(q0q1_xpipe_pipe_ch0_txdetectrxloopback_m),

      .XPIPE_PIPE_CH1_PHYSTATUS     (cpm_xpipe_ch1_phystatus),
      .XPIPE_PIPE_CH1_RXCHARISK     (cpm_xpipe_ch1_rxcharisk),
      .XPIPE_PIPE_CH1_RXDATA        (cpm_xpipe_ch1_rxdata), //ifcpmxpipechannel1xpiperxdata
      .XPIPE_PIPE_CH1_RXDATAVALID   (cpm_xpipe_ch1_rxdatavalid),
      .XPIPE_PIPE_CH1_RXELECIDLE    (cpm_xpipe_ch1_rxelecidle),
      .XPIPE_PIPE_CH1_RXSTARTBLOCK  (cpm_xpipe_ch1_rxstartblock),
      .XPIPE_PIPE_CH1_RXSTATUS      (cpm_xpipe_ch1_rxstatus),
      .XPIPE_PIPE_CH1_RXSYNCHEADER  (cpm_xpipe_ch1_rxsyncheader),
      .XPIPE_PIPE_CH1_RXVALID       (cpm_xpipe_ch1_rxvalid),
      .XPIPE_PIPE_CH1_POWERDOWN     (cpm_xpipe_ch1_powerdown),
      .XPIPE_PIPE_CH1_RXPOLARITY    (cpm_xpipe_ch1_rxpolarity),
      .XPIPE_PIPE_CH1_RXTERMINATION (cpm_xpipe_ch1_rxtermination),
      .XPIPE_PIPE_CH1_TXCHARISK     (cpm_xpipe_ch1_txcharisk),
      .XPIPE_PIPE_CH1_TXCOMPLIANCE  (cpm_xpipe_ch1_txcompliance),
      .XPIPE_PIPE_CH1_TXDATA        (cpm_xpipe_ch1_txdata),
      .XPIPE_PIPE_CH1_TXDATAVALID   (cpm_xpipe_ch1_txdatavalid),
      .XPIPE_PIPE_CH1_TXDEEMPH      (cpm_xpipe_ch1_txdeemph),
      .XPIPE_PIPE_CH1_TXDETECTRXLOOPBACK(cpm_xpipe_ch1_txdetectrxloopback),
      .XPIPE_PIPE_CH1_TXELECIDLE    (cpm_xpipe_ch1_txelecidle),
      .XPIPE_PIPE_CH1_TXMAINCURSOR  (cpm_xpipe_ch1_txmaincursor),
      .XPIPE_PIPE_CH1_TXMARGIN      (cpm_xpipe_ch1_txmargin),
      .XPIPE_PIPE_CH1_TXPOSTCURSOR  (cpm_xpipe_ch1_txpostcursor),
      .XPIPE_PIPE_CH1_TXPRECURSOR   (cpm_xpipe_ch1_txprecursor),
      .XPIPE_PIPE_CH1_TXSTARTBLOCK  (cpm_xpipe_ch1_txstartblock),
      .XPIPE_PIPE_CH1_TXSWING       (cpm_xpipe_ch1_txswing),
      .XPIPE_PIPE_CH1_TXSYNCHEADER  (cpm_xpipe_ch1_txsyncheader),

      .XPIPE_PIPE_CH1_POWERDOWN_M     (q0q1_xpipe_pipe_ch1_powerdown_m),
      .XPIPE_PIPE_CH1_RXPOLARITY_M    (q0q1_xpipe_pipe_ch1_rxpolarity_m),
      .XPIPE_PIPE_CH1_RXTERMINATION_M (q0q1_xpipe_pipe_ch1_rxtermination_m),
      .XPIPE_PIPE_CH1_TXCHARISK_M     (q0q1_xpipe_pipe_ch1_txcharisk_m),
      .XPIPE_PIPE_CH1_TXCOMPLIANCE_M  (q0q1_xpipe_pipe_ch1_txcompliance_m),
      .XPIPE_PIPE_CH1_TXDATAVALID_M   (q0q1_xpipe_pipe_ch1_txdatavalid_m),
      .XPIPE_PIPE_CH1_TXDATA_M        (q0q1_xpipe_pipe_ch1_txdata_m),
      .XPIPE_PIPE_CH1_TXDEEMPH_M      (q0q1_xpipe_pipe_ch1_txdeemph_m),
      .XPIPE_PIPE_CH1_TXELECIDLE_M    (q0q1_xpipe_pipe_ch1_txelecidle_m),
      .XPIPE_PIPE_CH1_TXMAINCURSOR_M  (q0q1_xpipe_pipe_ch1_txmaincursor_m),
      .XPIPE_PIPE_CH1_TXMARGIN_M      (q0q1_xpipe_pipe_ch1_txmargin_m),
      .XPIPE_PIPE_CH1_TXPOSTCURSOR_M  (q0q1_xpipe_pipe_ch1_txpostcursor_m),
      .XPIPE_PIPE_CH1_TXPRECURSOR_M   (q0q1_xpipe_pipe_ch1_txprecursor_m),
      .XPIPE_PIPE_CH1_TXSTARTBLOCK_M  (q0q1_xpipe_pipe_ch1_txstartblock_m),
      .XPIPE_PIPE_CH1_TXSWING_M       (q0q1_xpipe_pipe_ch1_txswing_m),
      .XPIPE_PIPE_CH1_TXSYNCHEADER_M  (q0q1_xpipe_pipe_ch1_txsyncheader_m),
      .XPIPE_PIPE_CH1_PHYSTATUS_M     (q0q1_xpipe_pipe_ch1_phystatus_m),
      .XPIPE_PIPE_CH1_RXCHARISK_M     (q0q1_xpipe_pipe_ch1_rxcharisk_m),
      .XPIPE_PIPE_CH1_RXDATAVALID_M   (q0q1_xpipe_pipe_ch1_rxdatavalid_m),
      .XPIPE_PIPE_CH1_RXDATA_M        (q0q1_xpipe_pipe_ch1_rxdata_m),
      .XPIPE_PIPE_CH1_RXELECIDLE_M    (q0q1_xpipe_pipe_ch1_rxelecidle_m),
      .XPIPE_PIPE_CH1_RXSTARTBLOCK_M  (q0q1_xpipe_pipe_ch1_rxstartblock_m),
      .XPIPE_PIPE_CH1_RXSTATUS_M      (q0q1_xpipe_pipe_ch1_rxstatus_m),
      .XPIPE_PIPE_CH1_RXSYNCHEADER_M  (q0q1_xpipe_pipe_ch1_rxsyncheader_m),
      .XPIPE_PIPE_CH1_RXVALID_M       (q0q1_xpipe_pipe_ch1_rxvalid_m),
      .XPIPE_PIPE_CH1_TXDETECTRXLOOPBACK_M(q0q1_xpipe_pipe_ch1_txdetectrxloopback_m),

      .XPIPE_PIPE_CH2_PHYSTATUS     (cpm_xpipe_ch2_phystatus),
      .XPIPE_PIPE_CH2_RXCHARISK     (cpm_xpipe_ch2_rxcharisk),
      .XPIPE_PIPE_CH2_RXDATA        (cpm_xpipe_ch2_rxdata), //ifcpmxpipechannel2xpiperxdata
      .XPIPE_PIPE_CH2_RXDATAVALID   (cpm_xpipe_ch2_rxdatavalid),
      .XPIPE_PIPE_CH2_RXELECIDLE    (cpm_xpipe_ch2_rxelecidle),
      .XPIPE_PIPE_CH2_RXSTARTBLOCK  (cpm_xpipe_ch2_rxstartblock),
      .XPIPE_PIPE_CH2_RXSTATUS      (cpm_xpipe_ch2_rxstatus),
      .XPIPE_PIPE_CH2_RXSYNCHEADER  (cpm_xpipe_ch2_rxsyncheader),
      .XPIPE_PIPE_CH2_RXVALID       (cpm_xpipe_ch2_rxvalid),
      .XPIPE_PIPE_CH2_POWERDOWN     (cpm_xpipe_ch2_powerdown),
      .XPIPE_PIPE_CH2_RXPOLARITY    (cpm_xpipe_ch2_rxpolarity),
      .XPIPE_PIPE_CH2_RXTERMINATION (cpm_xpipe_ch2_rxtermination),
      .XPIPE_PIPE_CH2_TXCHARISK     (cpm_xpipe_ch2_txcharisk),
      .XPIPE_PIPE_CH2_TXCOMPLIANCE  (cpm_xpipe_ch2_txcompliance),
      .XPIPE_PIPE_CH2_TXDATA        (cpm_xpipe_ch2_txdata),
      .XPIPE_PIPE_CH2_TXDATAVALID   (cpm_xpipe_ch2_txdatavalid),
      .XPIPE_PIPE_CH2_TXDEEMPH      (cpm_xpipe_ch2_txdeemph),
      .XPIPE_PIPE_CH2_TXDETECTRXLOOPBACK(cpm_xpipe_ch2_txdetectrxloopback),
      .XPIPE_PIPE_CH2_TXELECIDLE    (cpm_xpipe_ch2_txelecidle),
      .XPIPE_PIPE_CH2_TXMAINCURSOR  (cpm_xpipe_ch2_txmaincursor),
      .XPIPE_PIPE_CH2_TXMARGIN      (cpm_xpipe_ch2_txmargin),
      .XPIPE_PIPE_CH2_TXPOSTCURSOR  (cpm_xpipe_ch2_txpostcursor),
      .XPIPE_PIPE_CH2_TXPRECURSOR   (cpm_xpipe_ch2_txprecursor),
      .XPIPE_PIPE_CH2_TXSTARTBLOCK  (cpm_xpipe_ch2_txstartblock),
      .XPIPE_PIPE_CH2_TXSWING       (cpm_xpipe_ch2_txswing),
      .XPIPE_PIPE_CH2_TXSYNCHEADER  (cpm_xpipe_ch2_txsyncheader),
      .XPIPE_PIPE_CH2_POWERDOWN_M   (q0q1_xpipe_pipe_ch2_powerdown_m),
      .XPIPE_PIPE_CH2_RXPOLARITY_M  (q0q1_xpipe_pipe_ch2_rxpolarity_m),
      .XPIPE_PIPE_CH2_RXTERMINATION_M(q0q1_xpipe_pipe_ch2_rxtermination_m),
      .XPIPE_PIPE_CH2_TXCHARISK_M   (q0q1_xpipe_pipe_ch2_txcharisk_m),
      .XPIPE_PIPE_CH2_TXCOMPLIANCE_M(q0q1_xpipe_pipe_ch2_txcompliance_m),
      .XPIPE_PIPE_CH2_TXDATAVALID_M (q0q1_xpipe_pipe_ch2_txdatavalid_m),
      .XPIPE_PIPE_CH2_TXDATA_M      (q0q1_xpipe_pipe_ch2_txdata_m),
      .XPIPE_PIPE_CH2_TXDEEMPH_M    (q0q1_xpipe_pipe_ch2_txdeemph_m),
      .XPIPE_PIPE_CH2_TXELECIDLE_M  (q0q1_xpipe_pipe_ch2_txelecidle_m),
      .XPIPE_PIPE_CH2_TXMAINCURSOR_M(q0q1_xpipe_pipe_ch2_txmaincursor_m),
      .XPIPE_PIPE_CH2_TXMARGIN_M    (q0q1_xpipe_pipe_ch2_txmargin_m),
      .XPIPE_PIPE_CH2_TXPOSTCURSOR_M(q0q1_xpipe_pipe_ch2_txpostcursor_m),
      .XPIPE_PIPE_CH2_TXPRECURSOR_M (q0q1_xpipe_pipe_ch2_txprecursor_m),
      .XPIPE_PIPE_CH2_TXSTARTBLOCK_M(q0q1_xpipe_pipe_ch2_txstartblock_m),
      .XPIPE_PIPE_CH2_TXSWING_M     (q0q1_xpipe_pipe_ch2_txswing_m),
      .XPIPE_PIPE_CH2_TXSYNCHEADER_M(q0q1_xpipe_pipe_ch2_txsyncheader_m),
      .XPIPE_PIPE_CH2_PHYSTATUS_M   (q0q1_xpipe_pipe_ch2_phystatus_m),
      .XPIPE_PIPE_CH2_RXCHARISK_M   (q0q1_xpipe_pipe_ch2_rxcharisk_m),
      .XPIPE_PIPE_CH2_RXDATAVALID_M (q0q1_xpipe_pipe_ch2_rxdatavalid_m),
      .XPIPE_PIPE_CH2_RXDATA_M      (q0q1_xpipe_pipe_ch2_rxdata_m),
      .XPIPE_PIPE_CH2_RXELECIDLE_M  (q0q1_xpipe_pipe_ch2_rxelecidle_m),
      .XPIPE_PIPE_CH2_RXSTARTBLOCK_M(q0q1_xpipe_pipe_ch2_rxstartblock_m),
      .XPIPE_PIPE_CH2_RXSTATUS_M    (q0q1_xpipe_pipe_ch2_rxstatus_m),
      .XPIPE_PIPE_CH2_RXSYNCHEADER_M(q0q1_xpipe_pipe_ch2_rxsyncheader_m),
      .XPIPE_PIPE_CH2_RXVALID_M     (q0q1_xpipe_pipe_ch2_rxvalid_m),
      .XPIPE_PIPE_CH2_TXDETECTRXLOOPBACK_M(q0q1_xpipe_pipe_ch2_txdetectrxloopback_m),

      .XPIPE_PIPE_CH3_PHYSTATUS     (cpm_xpipe_ch3_phystatus),
      .XPIPE_PIPE_CH3_RXCHARISK     (cpm_xpipe_ch3_rxcharisk),
      .XPIPE_PIPE_CH3_RXDATA        (cpm_xpipe_ch3_rxdata), //ifcpmxpipechannel3xpiperxdata
      .XPIPE_PIPE_CH3_RXDATAVALID   (cpm_xpipe_ch3_rxdatavalid),
      .XPIPE_PIPE_CH3_RXELECIDLE    (cpm_xpipe_ch3_rxelecidle),
      .XPIPE_PIPE_CH3_RXSTARTBLOCK  (cpm_xpipe_ch3_rxstartblock),
      .XPIPE_PIPE_CH3_RXSTATUS      (cpm_xpipe_ch3_rxstatus),
      .XPIPE_PIPE_CH3_RXSYNCHEADER  (cpm_xpipe_ch3_rxsyncheader),
      .XPIPE_PIPE_CH3_RXVALID       (cpm_xpipe_ch3_rxvalid),
      .XPIPE_PIPE_CH3_POWERDOWN     (cpm_xpipe_ch3_powerdown),
      .XPIPE_PIPE_CH3_RXPOLARITY    (cpm_xpipe_ch3_rxpolarity),
      .XPIPE_PIPE_CH3_RXTERMINATION (cpm_xpipe_ch3_rxtermination),
      .XPIPE_PIPE_CH3_TXCHARISK     (cpm_xpipe_ch3_txcharisk),
      .XPIPE_PIPE_CH3_TXCOMPLIANCE  (cpm_xpipe_ch3_txcompliance),
      .XPIPE_PIPE_CH3_TXDATA        (cpm_xpipe_ch3_txdata),
      .XPIPE_PIPE_CH3_TXDATAVALID   (cpm_xpipe_ch3_txdatavalid),
      .XPIPE_PIPE_CH3_TXDEEMPH      (cpm_xpipe_ch3_txdeemph),
      .XPIPE_PIPE_CH3_TXDETECTRXLOOPBACK(cpm_xpipe_ch3_txdetectrxloopback),
      .XPIPE_PIPE_CH3_TXELECIDLE    (cpm_xpipe_ch3_txelecidle),
      .XPIPE_PIPE_CH3_TXMAINCURSOR  (cpm_xpipe_ch3_txmaincursor),
      .XPIPE_PIPE_CH3_TXMARGIN      (cpm_xpipe_ch3_txmargin),
      .XPIPE_PIPE_CH3_TXPOSTCURSOR  (cpm_xpipe_ch3_txpostcursor),
      .XPIPE_PIPE_CH3_TXPRECURSOR   (cpm_xpipe_ch3_txprecursor),
      .XPIPE_PIPE_CH3_TXSTARTBLOCK  (cpm_xpipe_ch3_txstartblock),
      .XPIPE_PIPE_CH3_TXSWING       (cpm_xpipe_ch3_txswing),
      .XPIPE_PIPE_CH3_TXSYNCHEADER  (cpm_xpipe_ch3_txsyncheader),
      .XPIPE_PIPE_CH3_POWERDOWN_M   (q0q1_xpipe_pipe_ch3_powerdown_m),
      .XPIPE_PIPE_CH3_RXPOLARITY_M  (q0q1_xpipe_pipe_ch3_rxpolarity_m),
      .XPIPE_PIPE_CH3_RXTERMINATION_M(q0q1_xpipe_pipe_ch3_rxtermination_m),
      .XPIPE_PIPE_CH3_TXCHARISK_M   (q0q1_xpipe_pipe_ch3_txcharisk_m),
      .XPIPE_PIPE_CH3_TXCOMPLIANCE_M(q0q1_xpipe_pipe_ch3_txcompliance_m),
      .XPIPE_PIPE_CH3_TXDATAVALID_M (q0q1_xpipe_pipe_ch3_txdatavalid_m),
      .XPIPE_PIPE_CH3_TXDATA_M      (q0q1_xpipe_pipe_ch3_txdata_m),
      .XPIPE_PIPE_CH3_TXDEEMPH_M    (q0q1_xpipe_pipe_ch3_txdeemph_m),
      .XPIPE_PIPE_CH3_TXELECIDLE_M  (q0q1_xpipe_pipe_ch3_txelecidle_m),
      .XPIPE_PIPE_CH3_TXMAINCURSOR_M(q0q1_xpipe_pipe_ch3_txmaincursor_m),
      .XPIPE_PIPE_CH3_TXMARGIN_M    (q0q1_xpipe_pipe_ch3_txmargin_m),
      .XPIPE_PIPE_CH3_TXPOSTCURSOR_M(q0q1_xpipe_pipe_ch3_txpostcursor_m),
      .XPIPE_PIPE_CH3_TXPRECURSOR_M (q0q1_xpipe_pipe_ch3_txprecursor_m),
      .XPIPE_PIPE_CH3_TXSTARTBLOCK_M(q0q1_xpipe_pipe_ch3_txstartblock_m),
      .XPIPE_PIPE_CH3_TXSWING_M     (q0q1_xpipe_pipe_ch3_txswing_m),
      .XPIPE_PIPE_CH3_TXSYNCHEADER_M(q0q1_xpipe_pipe_ch3_txsyncheader_m),
      .XPIPE_PIPE_CH3_PHYSTATUS_M   (q0q1_xpipe_pipe_ch3_phystatus_m),
      .XPIPE_PIPE_CH3_RXCHARISK_M   (q0q1_xpipe_pipe_ch3_rxcharisk_m),
      .XPIPE_PIPE_CH3_RXDATAVALID_M (q0q1_xpipe_pipe_ch3_rxdatavalid_m),
      .XPIPE_PIPE_CH3_RXDATA_M      (q0q1_xpipe_pipe_ch3_rxdata_m),
      .XPIPE_PIPE_CH3_RXELECIDLE_M  (q0q1_xpipe_pipe_ch3_rxelecidle_m),
      .XPIPE_PIPE_CH3_RXSTARTBLOCK_M(q0q1_xpipe_pipe_ch3_rxstartblock_m),
      .XPIPE_PIPE_CH3_RXSTATUS_M    (q0q1_xpipe_pipe_ch3_rxstatus_m),
      .XPIPE_PIPE_CH3_RXSYNCHEADER_M(q0q1_xpipe_pipe_ch3_rxsyncheader_m),
      .XPIPE_PIPE_CH3_RXVALID_M     (q0q1_xpipe_pipe_ch3_rxvalid_m),
      .XPIPE_PIPE_CH3_TXDETECTRXLOOPBACK_M(q0q1_xpipe_pipe_ch3_txdetectrxloopback_m),

      .XPIPE_PIPE_CH4_PHYSTATUS     (cpm_xpipe_ch4_phystatus),
      .XPIPE_PIPE_CH4_RXCHARISK     (cpm_xpipe_ch4_rxcharisk),
      .XPIPE_PIPE_CH4_RXDATA        (cpm_xpipe_ch4_rxdata), //ifcpmxpipechannel4xpiperxdata
      .XPIPE_PIPE_CH4_RXDATAVALID   (cpm_xpipe_ch4_rxdatavalid),
      .XPIPE_PIPE_CH4_RXELECIDLE    (cpm_xpipe_ch4_rxelecidle),
      .XPIPE_PIPE_CH4_RXSTARTBLOCK  (cpm_xpipe_ch4_rxstartblock),
      .XPIPE_PIPE_CH4_RXSTATUS      (cpm_xpipe_ch4_rxstatus),
      .XPIPE_PIPE_CH4_RXSYNCHEADER  (cpm_xpipe_ch4_rxsyncheader),
      .XPIPE_PIPE_CH4_RXVALID       (cpm_xpipe_ch4_rxvalid),
      .XPIPE_PIPE_CH4_POWERDOWN     (cpm_xpipe_ch4_powerdown),
      .XPIPE_PIPE_CH4_RXPOLARITY    (cpm_xpipe_ch4_rxpolarity),
      .XPIPE_PIPE_CH4_RXTERMINATION (cpm_xpipe_ch4_rxtermination),
      .XPIPE_PIPE_CH4_TXCHARISK     (cpm_xpipe_ch4_txcharisk),
      .XPIPE_PIPE_CH4_TXCOMPLIANCE  (cpm_xpipe_ch4_txcompliance),
      .XPIPE_PIPE_CH4_TXDATA        (cpm_xpipe_ch4_txdata),
      .XPIPE_PIPE_CH4_TXDATAVALID   (cpm_xpipe_ch4_txdatavalid),
      .XPIPE_PIPE_CH4_TXDEEMPH      (cpm_xpipe_ch4_txdeemph),
      .XPIPE_PIPE_CH4_TXDETECTRXLOOPBACK(cpm_xpipe_ch4_txdetectrxloopback),
      .XPIPE_PIPE_CH4_TXELECIDLE    (cpm_xpipe_ch4_txelecidle),
      .XPIPE_PIPE_CH4_TXMAINCURSOR  (cpm_xpipe_ch4_txmaincursor),
      .XPIPE_PIPE_CH4_TXMARGIN      (cpm_xpipe_ch4_txmargin),
      .XPIPE_PIPE_CH4_TXPOSTCURSOR  (cpm_xpipe_ch4_txpostcursor),
      .XPIPE_PIPE_CH4_TXPRECURSOR   (cpm_xpipe_ch4_txprecursor),
      .XPIPE_PIPE_CH4_TXSTARTBLOCK  (cpm_xpipe_ch4_txstartblock),
      .XPIPE_PIPE_CH4_TXSWING       (cpm_xpipe_ch4_txswing),
      .XPIPE_PIPE_CH4_TXSYNCHEADER  (cpm_xpipe_ch4_txsyncheader),
      .XPIPE_PIPE_CH4_POWERDOWN_M   (q0q1_xpipe_pipe_ch4_powerdown_m),
      .XPIPE_PIPE_CH4_RXPOLARITY_M  (q0q1_xpipe_pipe_ch4_rxpolarity_m),
      .XPIPE_PIPE_CH4_RXTERMINATION_M(q0q1_xpipe_pipe_ch4_rxtermination_m),
      .XPIPE_PIPE_CH4_TXCHARISK_M   (q0q1_xpipe_pipe_ch4_txcharisk_m),
      .XPIPE_PIPE_CH4_TXCOMPLIANCE_M(q0q1_xpipe_pipe_ch4_txcompliance_m),
      .XPIPE_PIPE_CH4_TXDATAVALID_M (q0q1_xpipe_pipe_ch4_txdatavalid_m),
      .XPIPE_PIPE_CH4_TXDATA_M      (q0q1_xpipe_pipe_ch4_txdata_m),
      .XPIPE_PIPE_CH4_TXDEEMPH_M    (q0q1_xpipe_pipe_ch4_txdeemph_m),
      .XPIPE_PIPE_CH4_TXELECIDLE_M  (q0q1_xpipe_pipe_ch4_txelecidle_m),
      .XPIPE_PIPE_CH4_TXMAINCURSOR_M(q0q1_xpipe_pipe_ch4_txmaincursor_m),
      .XPIPE_PIPE_CH4_TXMARGIN_M    (q0q1_xpipe_pipe_ch4_txmargin_m),
      .XPIPE_PIPE_CH4_TXPOSTCURSOR_M(q0q1_xpipe_pipe_ch4_txpostcursor_m),
      .XPIPE_PIPE_CH4_TXPRECURSOR_M (q0q1_xpipe_pipe_ch4_txprecursor_m),
      .XPIPE_PIPE_CH4_TXSTARTBLOCK_M(q0q1_xpipe_pipe_ch4_txstartblock_m),
      .XPIPE_PIPE_CH4_TXSWING_M     (q0q1_xpipe_pipe_ch4_txswing_m),
      .XPIPE_PIPE_CH4_TXSYNCHEADER_M(q0q1_xpipe_pipe_ch4_txsyncheader_m),
      .XPIPE_PIPE_CH4_PHYSTATUS_M   (q0q1_xpipe_pipe_ch4_phystatus_m),
      .XPIPE_PIPE_CH4_RXCHARISK_M   (q0q1_xpipe_pipe_ch4_rxcharisk_m),
      .XPIPE_PIPE_CH4_RXDATAVALID_M (q0q1_xpipe_pipe_ch4_rxdatavalid_m),
      .XPIPE_PIPE_CH4_RXDATA_M      (q0q1_xpipe_pipe_ch4_rxdata_m),
      .XPIPE_PIPE_CH4_RXELECIDLE_M  (q0q1_xpipe_pipe_ch4_rxelecidle_m),
      .XPIPE_PIPE_CH4_RXSTARTBLOCK_M(q0q1_xpipe_pipe_ch4_rxstartblock_m),
      .XPIPE_PIPE_CH4_RXSTATUS_M    (q0q1_xpipe_pipe_ch4_rxstatus_m),
      .XPIPE_PIPE_CH4_RXSYNCHEADER_M(q0q1_xpipe_pipe_ch4_rxsyncheader_m),
      .XPIPE_PIPE_CH4_RXVALID_M     (q0q1_xpipe_pipe_ch4_rxvalid_m),
      .XPIPE_PIPE_CH4_TXDETECTRXLOOPBACK_M(q0q1_xpipe_pipe_ch4_txdetectrxloopback_m),

      .XPIPE_PIPE_CH5_PHYSTATUS     (cpm_xpipe_ch5_phystatus),
      .XPIPE_PIPE_CH5_RXCHARISK     (cpm_xpipe_ch5_rxcharisk),
      .XPIPE_PIPE_CH5_RXDATA        (cpm_xpipe_ch5_rxdata), //ifcpmxpipechannel5xpiperxdata
      .XPIPE_PIPE_CH5_RXDATAVALID   (cpm_xpipe_ch5_rxdatavalid),
      .XPIPE_PIPE_CH5_RXELECIDLE    (cpm_xpipe_ch5_rxelecidle),
      .XPIPE_PIPE_CH5_RXSTARTBLOCK  (cpm_xpipe_ch5_rxstartblock),
      .XPIPE_PIPE_CH5_RXSTATUS      (cpm_xpipe_ch5_rxstatus),
      .XPIPE_PIPE_CH5_RXSYNCHEADER  (cpm_xpipe_ch5_rxsyncheader),
      .XPIPE_PIPE_CH5_RXVALID       (cpm_xpipe_ch5_rxvalid),
      .XPIPE_PIPE_CH5_POWERDOWN     (cpm_xpipe_ch5_powerdown),
      .XPIPE_PIPE_CH5_RXPOLARITY    (cpm_xpipe_ch5_rxpolarity),
      .XPIPE_PIPE_CH5_RXTERMINATION (cpm_xpipe_ch5_rxtermination),
      .XPIPE_PIPE_CH5_TXCHARISK     (cpm_xpipe_ch5_txcharisk),
      .XPIPE_PIPE_CH5_TXCOMPLIANCE  (cpm_xpipe_ch5_txcompliance),
      .XPIPE_PIPE_CH5_TXDATA        (cpm_xpipe_ch5_txdata),
      .XPIPE_PIPE_CH5_TXDATAVALID   (cpm_xpipe_ch5_txdatavalid),
      .XPIPE_PIPE_CH5_TXDEEMPH      (cpm_xpipe_ch5_txdeemph),
      .XPIPE_PIPE_CH5_TXDETECTRXLOOPBACK(cpm_xpipe_ch5_txdetectrxloopback),
      .XPIPE_PIPE_CH5_TXELECIDLE    (cpm_xpipe_ch5_txelecidle),
      .XPIPE_PIPE_CH5_TXMAINCURSOR  (cpm_xpipe_ch5_txmaincursor),
      .XPIPE_PIPE_CH5_TXMARGIN      (cpm_xpipe_ch5_txmargin),
      .XPIPE_PIPE_CH5_TXPOSTCURSOR  (cpm_xpipe_ch5_txpostcursor),
      .XPIPE_PIPE_CH5_TXPRECURSOR   (cpm_xpipe_ch5_txprecursor),
      .XPIPE_PIPE_CH5_TXSTARTBLOCK  (cpm_xpipe_ch5_txstartblock),
      .XPIPE_PIPE_CH5_TXSWING       (cpm_xpipe_ch5_txswing),
      .XPIPE_PIPE_CH5_TXSYNCHEADER  (cpm_xpipe_ch5_txsyncheader),
      .XPIPE_PIPE_CH5_POWERDOWN_M   (q0q1_xpipe_pipe_ch5_powerdown_m),
      .XPIPE_PIPE_CH5_RXPOLARITY_M  (q0q1_xpipe_pipe_ch5_rxpolarity_m),
      .XPIPE_PIPE_CH5_RXTERMINATION_M(q0q1_xpipe_pipe_ch5_rxtermination_m),
      .XPIPE_PIPE_CH5_TXCHARISK_M   (q0q1_xpipe_pipe_ch5_txcharisk_m),
      .XPIPE_PIPE_CH5_TXCOMPLIANCE_M(q0q1_xpipe_pipe_ch5_txcompliance_m),
      .XPIPE_PIPE_CH5_TXDATAVALID_M (q0q1_xpipe_pipe_ch5_txdatavalid_m),
      .XPIPE_PIPE_CH5_TXDATA_M      (q0q1_xpipe_pipe_ch5_txdata_m),
      .XPIPE_PIPE_CH5_TXDEEMPH_M    (q0q1_xpipe_pipe_ch5_txdeemph_m),
      .XPIPE_PIPE_CH5_TXELECIDLE_M  (q0q1_xpipe_pipe_ch5_txelecidle_m),
      .XPIPE_PIPE_CH5_TXMAINCURSOR_M(q0q1_xpipe_pipe_ch5_txmaincursor_m),
      .XPIPE_PIPE_CH5_TXMARGIN_M    (q0q1_xpipe_pipe_ch5_txmargin_m),
      .XPIPE_PIPE_CH5_TXPOSTCURSOR_M(q0q1_xpipe_pipe_ch5_txpostcursor_m),
      .XPIPE_PIPE_CH5_TXPRECURSOR_M (q0q1_xpipe_pipe_ch5_txprecursor_m),
      .XPIPE_PIPE_CH5_TXSTARTBLOCK_M(q0q1_xpipe_pipe_ch5_txstartblock_m),
      .XPIPE_PIPE_CH5_TXSWING_M     (q0q1_xpipe_pipe_ch5_txswing_m),
      .XPIPE_PIPE_CH5_TXSYNCHEADER_M(q0q1_xpipe_pipe_ch5_txsyncheader_m),
      .XPIPE_PIPE_CH5_PHYSTATUS_M   (q0q1_xpipe_pipe_ch5_phystatus_m),
      .XPIPE_PIPE_CH5_RXCHARISK_M   (q0q1_xpipe_pipe_ch5_rxcharisk_m),
      .XPIPE_PIPE_CH5_RXDATAVALID_M (q0q1_xpipe_pipe_ch5_rxdatavalid_m),
      .XPIPE_PIPE_CH5_RXDATA_M      (q0q1_xpipe_pipe_ch5_rxdata_m),
      .XPIPE_PIPE_CH5_RXELECIDLE_M  (q0q1_xpipe_pipe_ch5_rxelecidle_m),
      .XPIPE_PIPE_CH5_RXSTARTBLOCK_M(q0q1_xpipe_pipe_ch5_rxstartblock_m),
      .XPIPE_PIPE_CH5_RXSTATUS_M    (q0q1_xpipe_pipe_ch5_rxstatus_m),
      .XPIPE_PIPE_CH5_RXSYNCHEADER_M(q0q1_xpipe_pipe_ch5_rxsyncheader_m),
      .XPIPE_PIPE_CH5_RXVALID_M     (q0q1_xpipe_pipe_ch5_rxvalid_m),
      .XPIPE_PIPE_CH5_TXDETECTRXLOOPBACK_M(q0q1_xpipe_pipe_ch5_txdetectrxloopback_m),

      .XPIPE_PIPE_CH6_PHYSTATUS     (cpm_xpipe_ch6_phystatus),
      .XPIPE_PIPE_CH6_RXCHARISK     (cpm_xpipe_ch6_rxcharisk),
      .XPIPE_PIPE_CH6_RXDATA        (cpm_xpipe_ch6_rxdata), //ifcpmxpipechannel6xpiperxdata
      .XPIPE_PIPE_CH6_RXDATAVALID   (cpm_xpipe_ch6_rxdatavalid),
      .XPIPE_PIPE_CH6_RXELECIDLE    (cpm_xpipe_ch6_rxelecidle),
      .XPIPE_PIPE_CH6_RXSTARTBLOCK  (cpm_xpipe_ch6_rxstartblock),
      .XPIPE_PIPE_CH6_RXSTATUS      (cpm_xpipe_ch6_rxstatus),
      .XPIPE_PIPE_CH6_RXSYNCHEADER  (cpm_xpipe_ch6_rxsyncheader),
      .XPIPE_PIPE_CH6_RXVALID       (cpm_xpipe_ch6_rxvalid),
      .XPIPE_PIPE_CH6_POWERDOWN     (cpm_xpipe_ch6_powerdown),
      .XPIPE_PIPE_CH6_RXPOLARITY    (cpm_xpipe_ch6_rxpolarity),
      .XPIPE_PIPE_CH6_RXTERMINATION (cpm_xpipe_ch6_rxtermination),
      .XPIPE_PIPE_CH6_TXCHARISK     (cpm_xpipe_ch6_txcharisk),
      .XPIPE_PIPE_CH6_TXCOMPLIANCE  (cpm_xpipe_ch6_txcompliance),
      .XPIPE_PIPE_CH6_TXDATA        (cpm_xpipe_ch6_txdata),
      .XPIPE_PIPE_CH6_TXDATAVALID   (cpm_xpipe_ch6_txdatavalid),
      .XPIPE_PIPE_CH6_TXDEEMPH      (cpm_xpipe_ch6_txdeemph),
      .XPIPE_PIPE_CH6_TXDETECTRXLOOPBACK(cpm_xpipe_ch6_txdetectrxloopback),
      .XPIPE_PIPE_CH6_TXELECIDLE    (cpm_xpipe_ch6_txelecidle),
      .XPIPE_PIPE_CH6_TXMAINCURSOR  (cpm_xpipe_ch6_txmaincursor),
      .XPIPE_PIPE_CH6_TXMARGIN      (cpm_xpipe_ch6_txmargin),
      .XPIPE_PIPE_CH6_TXPOSTCURSOR  (cpm_xpipe_ch6_txpostcursor),
      .XPIPE_PIPE_CH6_TXPRECURSOR   (cpm_xpipe_ch6_txprecursor),
      .XPIPE_PIPE_CH6_TXSTARTBLOCK  (cpm_xpipe_ch6_txstartblock),
      .XPIPE_PIPE_CH6_TXSWING       (cpm_xpipe_ch6_txswing),
      .XPIPE_PIPE_CH6_TXSYNCHEADER  (cpm_xpipe_ch6_txsyncheader),
      .XPIPE_PIPE_CH6_POWERDOWN_M   (q0q1_xpipe_pipe_ch6_powerdown_m),
      .XPIPE_PIPE_CH6_RXPOLARITY_M  (q0q1_xpipe_pipe_ch6_rxpolarity_m),
      .XPIPE_PIPE_CH6_RXTERMINATION_M(q0q1_xpipe_pipe_ch6_rxtermination_m),
      .XPIPE_PIPE_CH6_TXCHARISK_M   (q0q1_xpipe_pipe_ch6_txcharisk_m),
      .XPIPE_PIPE_CH6_TXCOMPLIANCE_M(q0q1_xpipe_pipe_ch6_txcompliance_m),
      .XPIPE_PIPE_CH6_TXDATAVALID_M (q0q1_xpipe_pipe_ch6_txdatavalid_m),
      .XPIPE_PIPE_CH6_TXDATA_M      (q0q1_xpipe_pipe_ch6_txdata_m),
      .XPIPE_PIPE_CH6_TXDEEMPH_M    (q0q1_xpipe_pipe_ch6_txdeemph_m),
      .XPIPE_PIPE_CH6_TXELECIDLE_M  (q0q1_xpipe_pipe_ch6_txelecidle_m),
      .XPIPE_PIPE_CH6_TXMAINCURSOR_M(q0q1_xpipe_pipe_ch6_txmaincursor_m),
      .XPIPE_PIPE_CH6_TXMARGIN_M    (q0q1_xpipe_pipe_ch6_txmargin_m),
      .XPIPE_PIPE_CH6_TXPOSTCURSOR_M(q0q1_xpipe_pipe_ch6_txpostcursor_m),
      .XPIPE_PIPE_CH6_TXPRECURSOR_M (q0q1_xpipe_pipe_ch6_txprecursor_m),
      .XPIPE_PIPE_CH6_TXSTARTBLOCK_M(q0q1_xpipe_pipe_ch6_txstartblock_m),
      .XPIPE_PIPE_CH6_TXSWING_M     (q0q1_xpipe_pipe_ch6_txswing_m),
      .XPIPE_PIPE_CH6_TXSYNCHEADER_M(q0q1_xpipe_pipe_ch6_txsyncheader_m),
      .XPIPE_PIPE_CH6_PHYSTATUS_M   (q0q1_xpipe_pipe_ch6_phystatus_m),
      .XPIPE_PIPE_CH6_RXCHARISK_M   (q0q1_xpipe_pipe_ch6_rxcharisk_m),
      .XPIPE_PIPE_CH6_RXDATAVALID_M (q0q1_xpipe_pipe_ch6_rxdatavalid_m),
      .XPIPE_PIPE_CH6_RXDATA_M      (q0q1_xpipe_pipe_ch6_rxdata_m),
      .XPIPE_PIPE_CH6_RXELECIDLE_M  (q0q1_xpipe_pipe_ch6_rxelecidle_m),
      .XPIPE_PIPE_CH6_RXSTARTBLOCK_M(q0q1_xpipe_pipe_ch6_rxstartblock_m),
      .XPIPE_PIPE_CH6_RXSTATUS_M    (q0q1_xpipe_pipe_ch6_rxstatus_m),
      .XPIPE_PIPE_CH6_RXSYNCHEADER_M(q0q1_xpipe_pipe_ch6_rxsyncheader_m),
      .XPIPE_PIPE_CH6_RXVALID_M     (q0q1_xpipe_pipe_ch6_rxvalid_m),
      .XPIPE_PIPE_CH6_TXDETECTRXLOOPBACK_M(q0q1_xpipe_pipe_ch6_txdetectrxloopback_m),

      .XPIPE_PIPE_CH7_PHYSTATUS     (cpm_xpipe_ch7_phystatus),
      .XPIPE_PIPE_CH7_RXCHARISK     (cpm_xpipe_ch7_rxcharisk),
      .XPIPE_PIPE_CH7_RXDATA        (cpm_xpipe_ch7_rxdata), //ifcpmxpipechannel7xpiperxdata
      .XPIPE_PIPE_CH7_RXDATAVALID   (cpm_xpipe_ch7_rxdatavalid),
      .XPIPE_PIPE_CH7_RXELECIDLE    (cpm_xpipe_ch7_rxelecidle),
      .XPIPE_PIPE_CH7_RXSTARTBLOCK  (cpm_xpipe_ch7_rxstartblock),
      .XPIPE_PIPE_CH7_RXSTATUS      (cpm_xpipe_ch7_rxstatus),
      .XPIPE_PIPE_CH7_RXSYNCHEADER  (cpm_xpipe_ch7_rxsyncheader),
      .XPIPE_PIPE_CH7_RXVALID       (cpm_xpipe_ch7_rxvalid),
      .XPIPE_PIPE_CH7_POWERDOWN     (cpm_xpipe_ch7_powerdown),
      .XPIPE_PIPE_CH7_RXPOLARITY    (cpm_xpipe_ch7_rxpolarity),
      .XPIPE_PIPE_CH7_RXTERMINATION (cpm_xpipe_ch7_rxtermination),
      .XPIPE_PIPE_CH7_TXCHARISK     (cpm_xpipe_ch7_txcharisk),
      .XPIPE_PIPE_CH7_TXCOMPLIANCE  (cpm_xpipe_ch7_txcompliance),
      .XPIPE_PIPE_CH7_TXDATA        (cpm_xpipe_ch7_txdata),
      .XPIPE_PIPE_CH7_TXDATAVALID   (cpm_xpipe_ch7_txdatavalid),
      .XPIPE_PIPE_CH7_TXDEEMPH      (cpm_xpipe_ch7_txdeemph),
      .XPIPE_PIPE_CH7_TXDETECTRXLOOPBACK(cpm_xpipe_ch7_txdetectrxloopback),
      .XPIPE_PIPE_CH7_TXELECIDLE    (cpm_xpipe_ch7_txelecidle),
      .XPIPE_PIPE_CH7_TXMAINCURSOR  (cpm_xpipe_ch7_txmaincursor),
      .XPIPE_PIPE_CH7_TXMARGIN      (cpm_xpipe_ch7_txmargin),
      .XPIPE_PIPE_CH7_TXPOSTCURSOR  (cpm_xpipe_ch7_txpostcursor),
      .XPIPE_PIPE_CH7_TXPRECURSOR   (cpm_xpipe_ch7_txprecursor),
      .XPIPE_PIPE_CH7_TXSTARTBLOCK  (cpm_xpipe_ch7_txstartblock),
      .XPIPE_PIPE_CH7_TXSWING       (cpm_xpipe_ch7_txswing),
      .XPIPE_PIPE_CH7_TXSYNCHEADER  (cpm_xpipe_ch7_txsyncheader),
      .XPIPE_PIPE_CH7_POWERDOWN_M   (q0q1_xpipe_pipe_ch7_powerdown_m),
      .XPIPE_PIPE_CH7_RXPOLARITY_M  (q0q1_xpipe_pipe_ch7_rxpolarity_m),
      .XPIPE_PIPE_CH7_RXTERMINATION_M(q0q1_xpipe_pipe_ch7_rxtermination_m),
      .XPIPE_PIPE_CH7_TXCHARISK_M   (q0q1_xpipe_pipe_ch7_txcharisk_m),
      .XPIPE_PIPE_CH7_TXCOMPLIANCE_M(q0q1_xpipe_pipe_ch7_txcompliance_m),
      .XPIPE_PIPE_CH7_TXDATAVALID_M (q0q1_xpipe_pipe_ch7_txdatavalid_m),
      .XPIPE_PIPE_CH7_TXDATA_M      (q0q1_xpipe_pipe_ch7_txdata_m),
      .XPIPE_PIPE_CH7_TXDEEMPH_M    (q0q1_xpipe_pipe_ch7_txdeemph_m),
      .XPIPE_PIPE_CH7_TXELECIDLE_M  (q0q1_xpipe_pipe_ch7_txelecidle_m),
      .XPIPE_PIPE_CH7_TXMAINCURSOR_M(q0q1_xpipe_pipe_ch7_txmaincursor_m),
      .XPIPE_PIPE_CH7_TXMARGIN_M    (q0q1_xpipe_pipe_ch7_txmargin_m),
      .XPIPE_PIPE_CH7_TXPOSTCURSOR_M(q0q1_xpipe_pipe_ch7_txpostcursor_m),
      .XPIPE_PIPE_CH7_TXPRECURSOR_M (q0q1_xpipe_pipe_ch7_txprecursor_m),
      .XPIPE_PIPE_CH7_TXSTARTBLOCK_M(q0q1_xpipe_pipe_ch7_txstartblock_m),
      .XPIPE_PIPE_CH7_TXSWING_M     (q0q1_xpipe_pipe_ch7_txswing_m),
      .XPIPE_PIPE_CH7_TXSYNCHEADER_M(q0q1_xpipe_pipe_ch7_txsyncheader_m),
      .XPIPE_PIPE_CH7_PHYSTATUS_M   (q0q1_xpipe_pipe_ch7_phystatus_m),
      .XPIPE_PIPE_CH7_RXCHARISK_M   (q0q1_xpipe_pipe_ch7_rxcharisk_m),
      .XPIPE_PIPE_CH7_RXDATAVALID_M (q0q1_xpipe_pipe_ch7_rxdatavalid_m),
      .XPIPE_PIPE_CH7_RXDATA_M      (q0q1_xpipe_pipe_ch7_rxdata_m),
      .XPIPE_PIPE_CH7_RXELECIDLE_M  (q0q1_xpipe_pipe_ch7_rxelecidle_m),
      .XPIPE_PIPE_CH7_RXSTARTBLOCK_M(q0q1_xpipe_pipe_ch7_rxstartblock_m),
      .XPIPE_PIPE_CH7_RXSTATUS_M    (q0q1_xpipe_pipe_ch7_rxstatus_m),
      .XPIPE_PIPE_CH7_RXSYNCHEADER_M(q0q1_xpipe_pipe_ch7_rxsyncheader_m),
      .XPIPE_PIPE_CH7_RXVALID_M     (q0q1_xpipe_pipe_ch7_rxvalid_m),
      .XPIPE_PIPE_CH7_TXDETECTRXLOOPBACK_M(q0q1_xpipe_pipe_ch7_txdetectrxloopback_m),

      .XPIPE_PIPE_CH8_PHYSTATUS     (cpm_xpipe_ch8_phystatus),
      .XPIPE_PIPE_CH8_RXCHARISK     (cpm_xpipe_ch8_rxcharisk),
      .XPIPE_PIPE_CH8_RXDATA        (cpm_xpipe_ch8_rxdata), //ifcpmxpipechannel8xpiperxdata
      .XPIPE_PIPE_CH8_RXDATAVALID   (cpm_xpipe_ch8_rxdatavalid),
      .XPIPE_PIPE_CH8_RXELECIDLE    (cpm_xpipe_ch8_rxelecidle),
      .XPIPE_PIPE_CH8_RXSTARTBLOCK  (cpm_xpipe_ch8_rxstartblock),
      .XPIPE_PIPE_CH8_RXSTATUS      (cpm_xpipe_ch8_rxstatus),
      .XPIPE_PIPE_CH8_RXSYNCHEADER  (cpm_xpipe_ch8_rxsyncheader),
      .XPIPE_PIPE_CH8_RXVALID       (cpm_xpipe_ch8_rxvalid),
      .XPIPE_PIPE_CH8_POWERDOWN     (cpm_xpipe_ch8_powerdown),
      .XPIPE_PIPE_CH8_RXPOLARITY    (cpm_xpipe_ch8_rxpolarity),
      .XPIPE_PIPE_CH8_RXTERMINATION (cpm_xpipe_ch8_rxtermination),
      .XPIPE_PIPE_CH8_TXCHARISK     (cpm_xpipe_ch8_txcharisk),
      .XPIPE_PIPE_CH8_TXCOMPLIANCE  (cpm_xpipe_ch8_txcompliance),
      .XPIPE_PIPE_CH8_TXDATA        (cpm_xpipe_ch8_txdata),
      .XPIPE_PIPE_CH8_TXDATAVALID   (cpm_xpipe_ch8_txdatavalid),
      .XPIPE_PIPE_CH8_TXDEEMPH      (cpm_xpipe_ch8_txdeemph),
      .XPIPE_PIPE_CH8_TXDETECTRXLOOPBACK(cpm_xpipe_ch8_txdetectrxloopback),
      .XPIPE_PIPE_CH8_TXELECIDLE    (cpm_xpipe_ch8_txelecidle),
      .XPIPE_PIPE_CH8_TXMAINCURSOR  (cpm_xpipe_ch8_txmaincursor),
      .XPIPE_PIPE_CH8_TXMARGIN      (cpm_xpipe_ch8_txmargin),
      .XPIPE_PIPE_CH8_TXPOSTCURSOR  (cpm_xpipe_ch8_txpostcursor),
      .XPIPE_PIPE_CH8_TXPRECURSOR   (cpm_xpipe_ch8_txprecursor),
      .XPIPE_PIPE_CH8_TXSTARTBLOCK  (cpm_xpipe_ch8_txstartblock),
      .XPIPE_PIPE_CH8_TXSWING       (cpm_xpipe_ch8_txswing),
      .XPIPE_PIPE_CH8_TXSYNCHEADER  (cpm_xpipe_ch8_txsyncheader),
      .XPIPE_PIPE_CH8_POWERDOWN_M   (q0q1_xpipe_pipe_ch8_powerdown_m),
      .XPIPE_PIPE_CH8_RXPOLARITY_M  (q0q1_xpipe_pipe_ch8_rxpolarity_m),
      .XPIPE_PIPE_CH8_RXTERMINATION_M(q0q1_xpipe_pipe_ch8_rxtermination_m),
      .XPIPE_PIPE_CH8_TXCHARISK_M   (q0q1_xpipe_pipe_ch8_txcharisk_m),
      .XPIPE_PIPE_CH8_TXCOMPLIANCE_M(q0q1_xpipe_pipe_ch8_txcompliance_m),
      .XPIPE_PIPE_CH8_TXDATAVALID_M (q0q1_xpipe_pipe_ch8_txdatavalid_m),
      .XPIPE_PIPE_CH8_TXDATA_M      (q0q1_xpipe_pipe_ch8_txdata_m),
      .XPIPE_PIPE_CH8_TXDEEMPH_M    (q0q1_xpipe_pipe_ch8_txdeemph_m),
      .XPIPE_PIPE_CH8_TXELECIDLE_M  (q0q1_xpipe_pipe_ch8_txelecidle_m),
      .XPIPE_PIPE_CH8_TXMAINCURSOR_M(q0q1_xpipe_pipe_ch8_txmaincursor_m),
      .XPIPE_PIPE_CH8_TXMARGIN_M    (q0q1_xpipe_pipe_ch8_txmargin_m),
      .XPIPE_PIPE_CH8_TXPOSTCURSOR_M(q0q1_xpipe_pipe_ch8_txpostcursor_m),
      .XPIPE_PIPE_CH8_TXPRECURSOR_M (q0q1_xpipe_pipe_ch8_txprecursor_m),
      .XPIPE_PIPE_CH8_TXSTARTBLOCK_M(q0q1_xpipe_pipe_ch8_txstartblock_m),
      .XPIPE_PIPE_CH8_TXSWING_M     (q0q1_xpipe_pipe_ch8_txswing_m),
      .XPIPE_PIPE_CH8_TXSYNCHEADER_M(q0q1_xpipe_pipe_ch8_txsyncheader_m),
      .XPIPE_PIPE_CH8_PHYSTATUS_M   (q0q1_xpipe_pipe_ch8_phystatus_m),
      .XPIPE_PIPE_CH8_RXCHARISK_M   (q0q1_xpipe_pipe_ch8_rxcharisk_m),
      .XPIPE_PIPE_CH8_RXDATAVALID_M (q0q1_xpipe_pipe_ch8_rxdatavalid_m),
      .XPIPE_PIPE_CH8_RXDATA_M      (q0q1_xpipe_pipe_ch8_rxdata_m),
      .XPIPE_PIPE_CH8_RXELECIDLE_M  (q0q1_xpipe_pipe_ch8_rxelecidle_m),
      .XPIPE_PIPE_CH8_RXSTARTBLOCK_M(q0q1_xpipe_pipe_ch8_rxstartblock_m),
      .XPIPE_PIPE_CH8_RXSTATUS_M    (q0q1_xpipe_pipe_ch8_rxstatus_m),
      .XPIPE_PIPE_CH8_RXSYNCHEADER_M(q0q1_xpipe_pipe_ch8_rxsyncheader_m),
      .XPIPE_PIPE_CH8_RXVALID_M     (q0q1_xpipe_pipe_ch8_rxvalid_m),
      .XPIPE_PIPE_CH8_TXDETECTRXLOOPBACK_M(q0q1_xpipe_pipe_ch8_txdetectrxloopback_m),

      .XPIPE_PIPE_CH9_PHYSTATUS     (cpm_xpipe_ch9_phystatus),
      .XPIPE_PIPE_CH9_RXCHARISK     (cpm_xpipe_ch9_rxcharisk),
      .XPIPE_PIPE_CH9_RXDATA        (cpm_xpipe_ch9_rxdata),
      .XPIPE_PIPE_CH9_RXDATAVALID   (cpm_xpipe_ch9_rxdatavalid),
      .XPIPE_PIPE_CH9_RXELECIDLE    (cpm_xpipe_ch9_rxelecidle),
      .XPIPE_PIPE_CH9_RXSTARTBLOCK  (cpm_xpipe_ch9_rxstartblock),
      .XPIPE_PIPE_CH9_RXSTATUS      (cpm_xpipe_ch9_rxstatus),
      .XPIPE_PIPE_CH9_RXSYNCHEADER  (cpm_xpipe_ch9_rxsyncheader),
      .XPIPE_PIPE_CH9_RXVALID       (cpm_xpipe_ch9_rxvalid),
      .XPIPE_PIPE_CH9_POWERDOWN     (cpm_xpipe_ch9_powerdown),
      .XPIPE_PIPE_CH9_RXPOLARITY    (cpm_xpipe_ch9_rxpolarity),
      .XPIPE_PIPE_CH9_RXTERMINATION (cpm_xpipe_ch9_rxtermination),
      .XPIPE_PIPE_CH9_TXCHARISK     (cpm_xpipe_ch9_txcharisk),
      .XPIPE_PIPE_CH9_TXCOMPLIANCE  (cpm_xpipe_ch9_txcompliance),
      .XPIPE_PIPE_CH9_TXDATA        (cpm_xpipe_ch9_txdata),
      .XPIPE_PIPE_CH9_TXDATAVALID   (cpm_xpipe_ch9_txdatavalid),
      .XPIPE_PIPE_CH9_TXDEEMPH      (cpm_xpipe_ch9_txdeemph),
      .XPIPE_PIPE_CH9_TXDETECTRXLOOPBACK(cpm_xpipe_ch9_txdetectrxloopback),
      .XPIPE_PIPE_CH9_TXELECIDLE    (cpm_xpipe_ch9_txelecidle),
      .XPIPE_PIPE_CH9_TXMAINCURSOR  (cpm_xpipe_ch9_txmaincursor),
      .XPIPE_PIPE_CH9_TXMARGIN      (cpm_xpipe_ch9_txmargin),
      .XPIPE_PIPE_CH9_TXPOSTCURSOR  (cpm_xpipe_ch9_txpostcursor),
      .XPIPE_PIPE_CH9_TXPRECURSOR   (cpm_xpipe_ch9_txprecursor),
      .XPIPE_PIPE_CH9_TXSTARTBLOCK  (cpm_xpipe_ch9_txstartblock),
      .XPIPE_PIPE_CH9_TXSWING       (cpm_xpipe_ch9_txswing),
      .XPIPE_PIPE_CH9_TXSYNCHEADER  (cpm_xpipe_ch9_txsyncheader),
      .XPIPE_PIPE_CH9_POWERDOWN_M   (q0q1_xpipe_pipe_ch9_powerdown_m),
      .XPIPE_PIPE_CH9_RXPOLARITY_M  (q0q1_xpipe_pipe_ch9_rxpolarity_m),
      .XPIPE_PIPE_CH9_RXTERMINATION_M(q0q1_xpipe_pipe_ch9_rxtermination_m),
      .XPIPE_PIPE_CH9_TXCHARISK_M   (q0q1_xpipe_pipe_ch9_txcharisk_m),
      .XPIPE_PIPE_CH9_TXCOMPLIANCE_M(q0q1_xpipe_pipe_ch9_txcompliance_m),
      .XPIPE_PIPE_CH9_TXDATAVALID_M (q0q1_xpipe_pipe_ch9_txdatavalid_m),
      .XPIPE_PIPE_CH9_TXDATA_M      (q0q1_xpipe_pipe_ch9_txdata_m),
      .XPIPE_PIPE_CH9_TXDEEMPH_M    (q0q1_xpipe_pipe_ch9_txdeemph_m),
      .XPIPE_PIPE_CH9_TXELECIDLE_M  (q0q1_xpipe_pipe_ch9_txelecidle_m),
      .XPIPE_PIPE_CH9_TXMAINCURSOR_M(q0q1_xpipe_pipe_ch9_txmaincursor_m),
      .XPIPE_PIPE_CH9_TXMARGIN_M    (q0q1_xpipe_pipe_ch9_txmargin_m),
      .XPIPE_PIPE_CH9_TXPOSTCURSOR_M(q0q1_xpipe_pipe_ch9_txpostcursor_m),
      .XPIPE_PIPE_CH9_TXPRECURSOR_M (q0q1_xpipe_pipe_ch9_txprecursor_m),
      .XPIPE_PIPE_CH9_TXSTARTBLOCK_M(q0q1_xpipe_pipe_ch9_txstartblock_m),
      .XPIPE_PIPE_CH9_TXSWING_M     (q0q1_xpipe_pipe_ch9_txswing_m),
      .XPIPE_PIPE_CH9_TXSYNCHEADER_M(q0q1_xpipe_pipe_ch9_txsyncheader_m),
      .XPIPE_PIPE_CH9_PHYSTATUS_M   (q0q1_xpipe_pipe_ch9_phystatus_m),
      .XPIPE_PIPE_CH9_RXCHARISK_M   (q0q1_xpipe_pipe_ch9_rxcharisk_m),
      .XPIPE_PIPE_CH9_RXDATAVALID_M (q0q1_xpipe_pipe_ch9_rxdatavalid_m),
      .XPIPE_PIPE_CH9_RXDATA_M      (q0q1_xpipe_pipe_ch9_rxdata_m),
      .XPIPE_PIPE_CH9_RXELECIDLE_M  (q0q1_xpipe_pipe_ch9_rxelecidle_m),
      .XPIPE_PIPE_CH9_RXSTARTBLOCK_M(q0q1_xpipe_pipe_ch9_rxstartblock_m),
      .XPIPE_PIPE_CH9_RXSTATUS_M    (q0q1_xpipe_pipe_ch9_rxstatus_m),
      .XPIPE_PIPE_CH9_RXSYNCHEADER_M(q0q1_xpipe_pipe_ch9_rxsyncheader_m),
      .XPIPE_PIPE_CH9_RXVALID_M     (q0q1_xpipe_pipe_ch9_rxvalid_m),
      .XPIPE_PIPE_CH9_TXDETECTRXLOOPBACK_M(q0q1_xpipe_pipe_ch9_txdetectrxloopback_m),

      .XPIPE_PIPE_CH10_PHYSTATUS      (cpm_xpipe_ch10_phystatus),
      .XPIPE_PIPE_CH10_RXCHARISK      (cpm_xpipe_ch10_rxcharisk),
      .XPIPE_PIPE_CH10_RXDATA         (cpm_xpipe_ch10_rxdata), //ifcpmxpipechannel10xpiperxdata
      .XPIPE_PIPE_CH10_RXDATAVALID    (cpm_xpipe_ch10_rxdatavalid),
      .XPIPE_PIPE_CH10_RXELECIDLE     (cpm_xpipe_ch10_rxelecidle),
      .XPIPE_PIPE_CH10_RXSTARTBLOCK   (cpm_xpipe_ch10_rxstartblock),
      .XPIPE_PIPE_CH10_RXSTATUS       (cpm_xpipe_ch10_rxstatus),
      .XPIPE_PIPE_CH10_RXSYNCHEADER   (cpm_xpipe_ch10_rxsyncheader),
      .XPIPE_PIPE_CH10_RXVALID        (cpm_xpipe_ch10_rxvalid),
      .XPIPE_PIPE_CH10_POWERDOWN      (cpm_xpipe_ch10_powerdown),
      .XPIPE_PIPE_CH10_RXPOLARITY     (cpm_xpipe_ch10_rxpolarity),
      .XPIPE_PIPE_CH10_RXTERMINATION  (cpm_xpipe_ch10_rxtermination),
      .XPIPE_PIPE_CH10_TXCHARISK      (cpm_xpipe_ch10_txcharisk),
      .XPIPE_PIPE_CH10_TXCOMPLIANCE   (cpm_xpipe_ch10_txcompliance),
      .XPIPE_PIPE_CH10_TXDATA         (cpm_xpipe_ch10_txdata),
      .XPIPE_PIPE_CH10_TXDATAVALID    (cpm_xpipe_ch10_txdatavalid),
      .XPIPE_PIPE_CH10_TXDEEMPH       (cpm_xpipe_ch10_txdeemph),
      .XPIPE_PIPE_CH10_TXDETECTRXLOOPBACK(cpm_xpipe_ch10_txdetectrxloopback),
      .XPIPE_PIPE_CH10_TXELECIDLE     (cpm_xpipe_ch10_txelecidle),
      .XPIPE_PIPE_CH10_TXMAINCURSOR   (cpm_xpipe_ch10_txmaincursor),
      .XPIPE_PIPE_CH10_TXMARGIN       (cpm_xpipe_ch10_txmargin),
      .XPIPE_PIPE_CH10_TXPOSTCURSOR   (cpm_xpipe_ch10_txpostcursor),
      .XPIPE_PIPE_CH10_TXPRECURSOR    (cpm_xpipe_ch10_txprecursor),
      .XPIPE_PIPE_CH10_TXSTARTBLOCK   (cpm_xpipe_ch10_txstartblock),
      .XPIPE_PIPE_CH10_TXSWING        (cpm_xpipe_ch10_txswing),
      .XPIPE_PIPE_CH10_TXSYNCHEADER   (cpm_xpipe_ch10_txsyncheader),
      .XPIPE_PIPE_CH10_POWERDOWN_M    (q0q1_xpipe_pipe_ch10_powerdown_m),
      .XPIPE_PIPE_CH10_RXPOLARITY_M   (q0q1_xpipe_pipe_ch10_rxpolarity_m),
      .XPIPE_PIPE_CH10_RXTERMINATION_M(q0q1_xpipe_pipe_ch10_rxtermination_m),
      .XPIPE_PIPE_CH10_TXCHARISK_M    (q0q1_xpipe_pipe_ch10_txcharisk_m),
      .XPIPE_PIPE_CH10_TXCOMPLIANCE_M (q0q1_xpipe_pipe_ch10_txcompliance_m),
      .XPIPE_PIPE_CH10_TXDATAVALID_M  (q0q1_xpipe_pipe_ch10_txdatavalid_m),
      .XPIPE_PIPE_CH10_TXDATA_M       (q0q1_xpipe_pipe_ch10_txdata_m),
      .XPIPE_PIPE_CH10_TXDEEMPH_M     (q0q1_xpipe_pipe_ch10_txdeemph_m),
      .XPIPE_PIPE_CH10_TXELECIDLE_M   (q0q1_xpipe_pipe_ch10_txelecidle_m),
      .XPIPE_PIPE_CH10_TXMAINCURSOR_M (q0q1_xpipe_pipe_ch10_txmaincursor_m),
      .XPIPE_PIPE_CH10_TXMARGIN_M     (q0q1_xpipe_pipe_ch10_txmargin_m),
      .XPIPE_PIPE_CH10_TXPOSTCURSOR_M (q0q1_xpipe_pipe_ch10_txpostcursor_m),
      .XPIPE_PIPE_CH10_TXPRECURSOR_M  (q0q1_xpipe_pipe_ch10_txprecursor_m),
      .XPIPE_PIPE_CH10_TXSTARTBLOCK_M (q0q1_xpipe_pipe_ch10_txstartblock_m),
      .XPIPE_PIPE_CH10_TXSWING_M      (q0q1_xpipe_pipe_ch10_txswing_m),
      .XPIPE_PIPE_CH10_TXSYNCHEADER_M (q0q1_xpipe_pipe_ch10_txsyncheader_m),
      .XPIPE_PIPE_CH10_PHYSTATUS_M    (q0q1_xpipe_pipe_ch10_phystatus_m),
      .XPIPE_PIPE_CH10_RXCHARISK_M    (q0q1_xpipe_pipe_ch10_rxcharisk_m),
      .XPIPE_PIPE_CH10_RXDATAVALID_M  (q0q1_xpipe_pipe_ch10_rxdatavalid_m),
      .XPIPE_PIPE_CH10_RXDATA_M       (q0q1_xpipe_pipe_ch10_rxdata_m),
      .XPIPE_PIPE_CH10_RXELECIDLE_M   (q0q1_xpipe_pipe_ch10_rxelecidle_m),
      .XPIPE_PIPE_CH10_RXSTARTBLOCK_M (q0q1_xpipe_pipe_ch10_rxstartblock_m),
      .XPIPE_PIPE_CH10_RXSTATUS_M     (q0q1_xpipe_pipe_ch10_rxstatus_m),
      .XPIPE_PIPE_CH10_RXSYNCHEADER_M (q0q1_xpipe_pipe_ch10_rxsyncheader_m),
      .XPIPE_PIPE_CH10_RXVALID_M      (q0q1_xpipe_pipe_ch10_rxvalid_m),
      .XPIPE_PIPE_CH10_TXDETECTRXLOOPBACK_M(q0q1_xpipe_pipe_ch10_txdetectrxloopback_m),

      .XPIPE_PIPE_CH11_PHYSTATUS     (cpm_xpipe_ch11_phystatus),
      .XPIPE_PIPE_CH11_RXCHARISK     (cpm_xpipe_ch11_rxcharisk),
      .XPIPE_PIPE_CH11_RXDATA        (cpm_xpipe_ch11_rxdata), //ifcpmxpipechannel11xpiperxdata
      .XPIPE_PIPE_CH11_RXDATAVALID   (cpm_xpipe_ch11_rxdatavalid),
      .XPIPE_PIPE_CH11_RXELECIDLE    (cpm_xpipe_ch11_rxelecidle),
      .XPIPE_PIPE_CH11_RXSTARTBLOCK  (cpm_xpipe_ch11_rxstartblock),
      .XPIPE_PIPE_CH11_RXSTATUS      (cpm_xpipe_ch11_rxstatus),
      .XPIPE_PIPE_CH11_RXSYNCHEADER  (cpm_xpipe_ch11_rxsyncheader),
      .XPIPE_PIPE_CH11_RXVALID       (cpm_xpipe_ch11_rxvalid),
      .XPIPE_PIPE_CH11_POWERDOWN     (cpm_xpipe_ch11_powerdown),
      .XPIPE_PIPE_CH11_RXPOLARITY    (cpm_xpipe_ch11_rxpolarity),
      .XPIPE_PIPE_CH11_RXTERMINATION (cpm_xpipe_ch11_rxtermination),
      .XPIPE_PIPE_CH11_TXCHARISK     (cpm_xpipe_ch11_txcharisk),
      .XPIPE_PIPE_CH11_TXCOMPLIANCE  (cpm_xpipe_ch11_txcompliance),
      .XPIPE_PIPE_CH11_TXDATA        (cpm_xpipe_ch11_txdata),
      .XPIPE_PIPE_CH11_TXDATAVALID   (cpm_xpipe_ch11_txdatavalid),
      .XPIPE_PIPE_CH11_TXDEEMPH      (cpm_xpipe_ch11_txdeemph),
      .XPIPE_PIPE_CH11_TXDETECTRXLOOPBACK(cpm_xpipe_ch11_txdetectrxloopback),
      .XPIPE_PIPE_CH11_TXELECIDLE    (cpm_xpipe_ch11_txelecidle),
      .XPIPE_PIPE_CH11_TXMAINCURSOR  (cpm_xpipe_ch11_txmaincursor),
      .XPIPE_PIPE_CH11_TXMARGIN      (cpm_xpipe_ch11_txmargin),
      .XPIPE_PIPE_CH11_TXPOSTCURSOR  (cpm_xpipe_ch11_txpostcursor),
      .XPIPE_PIPE_CH11_TXPRECURSOR   (cpm_xpipe_ch11_txprecursor),
      .XPIPE_PIPE_CH11_TXSTARTBLOCK  (cpm_xpipe_ch11_txstartblock),
      .XPIPE_PIPE_CH11_TXSWING       (cpm_xpipe_ch11_txswing),
      .XPIPE_PIPE_CH11_TXSYNCHEADER  (cpm_xpipe_ch11_txsyncheader),

      .XPIPE_PIPE_CH11_POWERDOWN_M   (q0q1_xpipe_pipe_ch11_powerdown_m),
      .XPIPE_PIPE_CH11_RXPOLARITY_M  (q0q1_xpipe_pipe_ch11_rxpolarity_m),
      .XPIPE_PIPE_CH11_RXTERMINATION_M(q0q1_xpipe_pipe_ch11_rxtermination_m),
      .XPIPE_PIPE_CH11_TXCHARISK_M   (q0q1_xpipe_pipe_ch11_txcharisk_m),
      .XPIPE_PIPE_CH11_TXCOMPLIANCE_M(q0q1_xpipe_pipe_ch11_txcompliance_m),
      .XPIPE_PIPE_CH11_TXDATAVALID_M (q0q1_xpipe_pipe_ch11_txdatavalid_m),
      .XPIPE_PIPE_CH11_TXDATA_M      (q0q1_xpipe_pipe_ch11_txdata_m),
      .XPIPE_PIPE_CH11_TXDEEMPH_M    (q0q1_xpipe_pipe_ch11_txdeemph_m),
      .XPIPE_PIPE_CH11_TXELECIDLE_M  (q0q1_xpipe_pipe_ch11_txelecidle_m),
      .XPIPE_PIPE_CH11_TXMAINCURSOR_M(q0q1_xpipe_pipe_ch11_txmaincursor_m),
      .XPIPE_PIPE_CH11_TXMARGIN_M    (q0q1_xpipe_pipe_ch11_txmargin_m),
      .XPIPE_PIPE_CH11_TXPOSTCURSOR_M(q0q1_xpipe_pipe_ch11_txpostcursor_m),
      .XPIPE_PIPE_CH11_TXPRECURSOR_M (q0q1_xpipe_pipe_ch11_txprecursor_m),
      .XPIPE_PIPE_CH11_TXSTARTBLOCK_M(q0q1_xpipe_pipe_ch11_txstartblock_m),
      .XPIPE_PIPE_CH11_TXSWING_M     (q0q1_xpipe_pipe_ch11_txswing_m),
      .XPIPE_PIPE_CH11_TXSYNCHEADER_M(q0q1_xpipe_pipe_ch11_txsyncheader_m),
      .XPIPE_PIPE_CH11_PHYSTATUS_M   (q0q1_xpipe_pipe_ch11_phystatus_m),
      .XPIPE_PIPE_CH11_RXCHARISK_M   (q0q1_xpipe_pipe_ch11_rxcharisk_m),
      .XPIPE_PIPE_CH11_RXDATAVALID_M (q0q1_xpipe_pipe_ch11_rxdatavalid_m),
      .XPIPE_PIPE_CH11_RXDATA_M      (q0q1_xpipe_pipe_ch11_rxdata_m),
      .XPIPE_PIPE_CH11_RXELECIDLE_M  (q0q1_xpipe_pipe_ch11_rxelecidle_m),
      .XPIPE_PIPE_CH11_RXSTARTBLOCK_M(q0q1_xpipe_pipe_ch11_rxstartblock_m),
      .XPIPE_PIPE_CH11_RXSTATUS_M    (q0q1_xpipe_pipe_ch11_rxstatus_m),
      .XPIPE_PIPE_CH11_RXSYNCHEADER_M(q0q1_xpipe_pipe_ch11_rxsyncheader_m),
      .XPIPE_PIPE_CH11_RXVALID_M     (q0q1_xpipe_pipe_ch11_rxvalid_m),
      .XPIPE_PIPE_CH11_TXDETECTRXLOOPBACK_M(q0q1_xpipe_pipe_ch11_txdetectrxloopback_m),

      .XPIPE_PIPE_CH12_PHYSTATUS     (cpm_xpipe_ch12_phystatus),
      .XPIPE_PIPE_CH12_RXCHARISK     (cpm_xpipe_ch12_rxcharisk),
      .XPIPE_PIPE_CH12_RXDATA        (cpm_xpipe_ch12_rxdata), //ifcpmxpipechannel12xpiperxdata
      .XPIPE_PIPE_CH12_RXDATAVALID   (cpm_xpipe_ch12_rxdatavalid),
      .XPIPE_PIPE_CH12_RXELECIDLE    (cpm_xpipe_ch12_rxelecidle),
      .XPIPE_PIPE_CH12_RXSTARTBLOCK  (cpm_xpipe_ch12_rxstartblock),
      .XPIPE_PIPE_CH12_RXSTATUS      (cpm_xpipe_ch12_rxstatus),
      .XPIPE_PIPE_CH12_RXSYNCHEADER  (cpm_xpipe_ch12_rxsyncheader),
      .XPIPE_PIPE_CH12_RXVALID       (cpm_xpipe_ch12_rxvalid),
      .XPIPE_PIPE_CH12_POWERDOWN     (cpm_xpipe_ch12_powerdown),
      .XPIPE_PIPE_CH12_RXPOLARITY    (cpm_xpipe_ch12_rxpolarity),
      .XPIPE_PIPE_CH12_RXTERMINATION (cpm_xpipe_ch12_rxtermination),
      .XPIPE_PIPE_CH12_TXCHARISK     (cpm_xpipe_ch12_txcharisk),
      .XPIPE_PIPE_CH12_TXCOMPLIANCE  (cpm_xpipe_ch12_txcompliance),
      .XPIPE_PIPE_CH12_TXDATA        (cpm_xpipe_ch12_txdata),
      .XPIPE_PIPE_CH12_TXDATAVALID   (cpm_xpipe_ch12_txdatavalid),
      .XPIPE_PIPE_CH12_TXDEEMPH      (cpm_xpipe_ch12_txdeemph),
      .XPIPE_PIPE_CH12_TXDETECTRXLOOPBACK(cpm_xpipe_ch12_txdetectrxloopback),
      .XPIPE_PIPE_CH12_TXELECIDLE    (cpm_xpipe_ch12_txelecidle),
      .XPIPE_PIPE_CH12_TXMAINCURSOR  (cpm_xpipe_ch12_txmaincursor),
      .XPIPE_PIPE_CH12_TXMARGIN      (cpm_xpipe_ch12_txmargin),
      .XPIPE_PIPE_CH12_TXPOSTCURSOR  (cpm_xpipe_ch12_txpostcursor),
      .XPIPE_PIPE_CH12_TXPRECURSOR   (cpm_xpipe_ch12_txprecursor),
      .XPIPE_PIPE_CH12_TXSTARTBLOCK  (cpm_xpipe_ch12_txstartblock),
      .XPIPE_PIPE_CH12_TXSWING       (cpm_xpipe_ch12_txswing),
      .XPIPE_PIPE_CH12_TXSYNCHEADER  (cpm_xpipe_ch12_txsyncheader),

      .XPIPE_PIPE_CH12_POWERDOWN_M   (q0q1_xpipe_pipe_ch12_powerdown_m),
      .XPIPE_PIPE_CH12_RXPOLARITY_M  (q0q1_xpipe_pipe_ch12_rxpolarity_m),
      .XPIPE_PIPE_CH12_RXTERMINATION_M(q0q1_xpipe_pipe_ch12_rxtermination_m),
      .XPIPE_PIPE_CH12_TXCHARISK_M   (q0q1_xpipe_pipe_ch12_txcharisk_m),
      .XPIPE_PIPE_CH12_TXCOMPLIANCE_M(q0q1_xpipe_pipe_ch12_txcompliance_m),
      .XPIPE_PIPE_CH12_TXDATAVALID_M (q0q1_xpipe_pipe_ch12_txdatavalid_m),
      .XPIPE_PIPE_CH12_TXDATA_M      (q0q1_xpipe_pipe_ch12_txdata_m),
      .XPIPE_PIPE_CH12_TXDEEMPH_M    (q0q1_xpipe_pipe_ch12_txdeemph_m),
      .XPIPE_PIPE_CH12_TXELECIDLE_M  (q0q1_xpipe_pipe_ch12_txelecidle_m),
      .XPIPE_PIPE_CH12_TXMAINCURSOR_M(q0q1_xpipe_pipe_ch12_txmaincursor_m),
      .XPIPE_PIPE_CH12_TXMARGIN_M    (q0q1_xpipe_pipe_ch12_txmargin_m),
      .XPIPE_PIPE_CH12_TXPOSTCURSOR_M(q0q1_xpipe_pipe_ch12_txpostcursor_m),
      .XPIPE_PIPE_CH12_TXPRECURSOR_M (q0q1_xpipe_pipe_ch12_txprecursor_m),
      .XPIPE_PIPE_CH12_TXSTARTBLOCK_M(q0q1_xpipe_pipe_ch12_txstartblock_m),
      .XPIPE_PIPE_CH12_TXSWING_M     (q0q1_xpipe_pipe_ch12_txswing_m),
      .XPIPE_PIPE_CH12_TXSYNCHEADER_M(q0q1_xpipe_pipe_ch12_txsyncheader_m),
      .XPIPE_PIPE_CH12_PHYSTATUS_M   (q0q1_xpipe_pipe_ch12_phystatus_m),
      .XPIPE_PIPE_CH12_RXCHARISK_M   (q0q1_xpipe_pipe_ch12_rxcharisk_m),
      .XPIPE_PIPE_CH12_RXDATAVALID_M (q0q1_xpipe_pipe_ch12_rxdatavalid_m),
      .XPIPE_PIPE_CH12_RXDATA_M      (q0q1_xpipe_pipe_ch12_rxdata_m),
      .XPIPE_PIPE_CH12_RXELECIDLE_M  (q0q1_xpipe_pipe_ch12_rxelecidle_m),
      .XPIPE_PIPE_CH12_RXSTARTBLOCK_M(q0q1_xpipe_pipe_ch12_rxstartblock_m),
      .XPIPE_PIPE_CH12_RXSTATUS_M    (q0q1_xpipe_pipe_ch12_rxstatus_m),
      .XPIPE_PIPE_CH12_RXSYNCHEADER_M(q0q1_xpipe_pipe_ch12_rxsyncheader_m),
      .XPIPE_PIPE_CH12_RXVALID_M     (q0q1_xpipe_pipe_ch12_rxvalid_m),
      .XPIPE_PIPE_CH12_TXDETECTRXLOOPBACK_M(q0q1_xpipe_pipe_ch12_txdetectrxloopback_m),

      .XPIPE_PIPE_CH13_PHYSTATUS     (cpm_xpipe_ch13_phystatus),
      .XPIPE_PIPE_CH13_RXCHARISK     (cpm_xpipe_ch13_rxcharisk),
      .XPIPE_PIPE_CH13_RXDATA        (cpm_xpipe_ch13_rxdata), //ifcpmxpipechannel13xpiperxdata
      .XPIPE_PIPE_CH13_RXDATAVALID   (cpm_xpipe_ch13_rxdatavalid),
      .XPIPE_PIPE_CH13_RXELECIDLE    (cpm_xpipe_ch13_rxelecidle),
      .XPIPE_PIPE_CH13_RXSTARTBLOCK  (cpm_xpipe_ch13_rxstartblock),
      .XPIPE_PIPE_CH13_RXSTATUS      (cpm_xpipe_ch13_rxstatus),
      .XPIPE_PIPE_CH13_RXSYNCHEADER  (cpm_xpipe_ch13_rxsyncheader),
      .XPIPE_PIPE_CH13_RXVALID       (cpm_xpipe_ch13_rxvalid),
      .XPIPE_PIPE_CH13_POWERDOWN     (cpm_xpipe_ch13_powerdown),
      .XPIPE_PIPE_CH13_RXPOLARITY    (cpm_xpipe_ch13_rxpolarity),
      .XPIPE_PIPE_CH13_RXTERMINATION (cpm_xpipe_ch13_rxtermination),
      .XPIPE_PIPE_CH13_TXCHARISK     (cpm_xpipe_ch13_txcharisk),
      .XPIPE_PIPE_CH13_TXCOMPLIANCE  (cpm_xpipe_ch13_txcompliance),
      .XPIPE_PIPE_CH13_TXDATA        (cpm_xpipe_ch13_txdata),
      .XPIPE_PIPE_CH13_TXDATAVALID   (cpm_xpipe_ch13_txdatavalid),
      .XPIPE_PIPE_CH13_TXDEEMPH      (cpm_xpipe_ch13_txdeemph),
      .XPIPE_PIPE_CH13_TXDETECTRXLOOPBACK(cpm_xpipe_ch13_txdetectrxloopback),
      .XPIPE_PIPE_CH13_TXELECIDLE    (cpm_xpipe_ch13_txelecidle),
      .XPIPE_PIPE_CH13_TXMAINCURSOR  (cpm_xpipe_ch13_txmaincursor),
      .XPIPE_PIPE_CH13_TXMARGIN      (cpm_xpipe_ch13_txmargin),
      .XPIPE_PIPE_CH13_TXPOSTCURSOR  (cpm_xpipe_ch13_txpostcursor),
      .XPIPE_PIPE_CH13_TXPRECURSOR   (cpm_xpipe_ch13_txprecursor),
      .XPIPE_PIPE_CH13_TXSTARTBLOCK  (cpm_xpipe_ch13_txstartblock),
      .XPIPE_PIPE_CH13_TXSWING       (cpm_xpipe_ch13_txswing),
      .XPIPE_PIPE_CH13_TXSYNCHEADER  (cpm_xpipe_ch13_txsyncheader),
      .XPIPE_PIPE_CH13_POWERDOWN_M   (q0q1_xpipe_pipe_ch13_powerdown_m),
      .XPIPE_PIPE_CH13_RXPOLARITY_M  (q0q1_xpipe_pipe_ch13_rxpolarity_m),
      .XPIPE_PIPE_CH13_RXTERMINATION_M(q0q1_xpipe_pipe_ch13_rxtermination_m),
      .XPIPE_PIPE_CH13_TXCHARISK_M   (q0q1_xpipe_pipe_ch13_txcharisk_m),
      .XPIPE_PIPE_CH13_TXCOMPLIANCE_M(q0q1_xpipe_pipe_ch13_txcompliance_m),
      .XPIPE_PIPE_CH13_TXDATAVALID_M (q0q1_xpipe_pipe_ch13_txdatavalid_m),
      .XPIPE_PIPE_CH13_TXDATA_M      (q0q1_xpipe_pipe_ch13_txdata_m),
      .XPIPE_PIPE_CH13_TXDEEMPH_M    (q0q1_xpipe_pipe_ch13_txdeemph_m),
      .XPIPE_PIPE_CH13_TXELECIDLE_M  (q0q1_xpipe_pipe_ch13_txelecidle_m),
      .XPIPE_PIPE_CH13_TXMAINCURSOR_M(q0q1_xpipe_pipe_ch13_txmaincursor_m),
      .XPIPE_PIPE_CH13_TXMARGIN_M    (q0q1_xpipe_pipe_ch13_txmargin_m),
      .XPIPE_PIPE_CH13_TXPOSTCURSOR_M(q0q1_xpipe_pipe_ch13_txpostcursor_m),
      .XPIPE_PIPE_CH13_TXPRECURSOR_M (q0q1_xpipe_pipe_ch13_txprecursor_m),
      .XPIPE_PIPE_CH13_TXSTARTBLOCK_M(q0q1_xpipe_pipe_ch13_txstartblock_m),
      .XPIPE_PIPE_CH13_TXSWING_M     (q0q1_xpipe_pipe_ch13_txswing_m),
      .XPIPE_PIPE_CH13_TXSYNCHEADER_M(q0q1_xpipe_pipe_ch13_txsyncheader_m),
      .XPIPE_PIPE_CH13_PHYSTATUS_M   (q0q1_xpipe_pipe_ch13_phystatus_m),
      .XPIPE_PIPE_CH13_RXCHARISK_M   (q0q1_xpipe_pipe_ch13_rxcharisk_m),
      .XPIPE_PIPE_CH13_RXDATAVALID_M (q0q1_xpipe_pipe_ch13_rxdatavalid_m),
      .XPIPE_PIPE_CH13_RXDATA_M      (q0q1_xpipe_pipe_ch13_rxdata_m),
      .XPIPE_PIPE_CH13_RXELECIDLE_M  (q0q1_xpipe_pipe_ch13_rxelecidle_m),
      .XPIPE_PIPE_CH13_RXSTARTBLOCK_M(q0q1_xpipe_pipe_ch13_rxstartblock_m),
      .XPIPE_PIPE_CH13_RXSTATUS_M    (q0q1_xpipe_pipe_ch13_rxstatus_m),
      .XPIPE_PIPE_CH13_RXSYNCHEADER_M(q0q1_xpipe_pipe_ch13_rxsyncheader_m),
      .XPIPE_PIPE_CH13_RXVALID_M     (q0q1_xpipe_pipe_ch13_rxvalid_m),
      .XPIPE_PIPE_CH13_TXDETECTRXLOOPBACK_M(q0q1_xpipe_pipe_ch13_txdetectrxloopback_m),

      .XPIPE_PIPE_CH14_PHYSTATUS     (cpm_xpipe_ch14_phystatus),
      .XPIPE_PIPE_CH14_RXCHARISK     (cpm_xpipe_ch14_rxcharisk),
      .XPIPE_PIPE_CH14_RXDATA        (cpm_xpipe_ch14_rxdata), //ifcpmxpipechannel14xpiperxdata
      .XPIPE_PIPE_CH14_RXDATAVALID   (cpm_xpipe_ch14_rxdatavalid),
      .XPIPE_PIPE_CH14_RXELECIDLE    (cpm_xpipe_ch14_rxelecidle),
      .XPIPE_PIPE_CH14_RXSTARTBLOCK  (cpm_xpipe_ch14_rxstartblock),
      .XPIPE_PIPE_CH14_RXSTATUS      (cpm_xpipe_ch14_rxstatus),
      .XPIPE_PIPE_CH14_RXSYNCHEADER  (cpm_xpipe_ch14_rxsyncheader),
      .XPIPE_PIPE_CH14_RXVALID       (cpm_xpipe_ch14_rxvalid),
      .XPIPE_PIPE_CH14_POWERDOWN     (cpm_xpipe_ch14_powerdown),
      .XPIPE_PIPE_CH14_RXPOLARITY    (cpm_xpipe_ch14_rxpolarity),
      .XPIPE_PIPE_CH14_RXTERMINATION (cpm_xpipe_ch14_rxtermination),
      .XPIPE_PIPE_CH14_TXCHARISK     (cpm_xpipe_ch14_txcharisk),
      .XPIPE_PIPE_CH14_TXCOMPLIANCE  (cpm_xpipe_ch14_txcompliance),
      .XPIPE_PIPE_CH14_TXDATA        (cpm_xpipe_ch14_txdata),
      .XPIPE_PIPE_CH14_TXDATAVALID   (cpm_xpipe_ch14_txdatavalid),
      .XPIPE_PIPE_CH14_TXDEEMPH      (cpm_xpipe_ch14_txdeemph),
      .XPIPE_PIPE_CH14_TXDETECTRXLOOPBACK(cpm_xpipe_ch14_txdetectrxloopback),
      .XPIPE_PIPE_CH14_TXELECIDLE    (cpm_xpipe_ch14_txelecidle),
      .XPIPE_PIPE_CH14_TXMAINCURSOR  (cpm_xpipe_ch14_txmaincursor),
      .XPIPE_PIPE_CH14_TXMARGIN      (cpm_xpipe_ch14_txmargin),
      .XPIPE_PIPE_CH14_TXPOSTCURSOR  (cpm_xpipe_ch14_txpostcursor),
      .XPIPE_PIPE_CH14_TXPRECURSOR   (cpm_xpipe_ch14_txprecursor),
      .XPIPE_PIPE_CH14_TXSTARTBLOCK  (cpm_xpipe_ch14_txstartblock),
      .XPIPE_PIPE_CH14_TXSWING       (cpm_xpipe_ch14_txswing),
      .XPIPE_PIPE_CH14_TXSYNCHEADER  (cpm_xpipe_ch14_txsyncheader),
      .XPIPE_PIPE_CH14_POWERDOWN_M   (q0q1_xpipe_pipe_ch14_powerdown_m),
      .XPIPE_PIPE_CH14_RXPOLARITY_M  (q0q1_xpipe_pipe_ch14_rxpolarity_m),
      .XPIPE_PIPE_CH14_RXTERMINATION_M(q0q1_xpipe_pipe_ch14_rxtermination_m),
      .XPIPE_PIPE_CH14_TXCHARISK_M   (q0q1_xpipe_pipe_ch14_txcharisk_m),
      .XPIPE_PIPE_CH14_TXCOMPLIANCE_M(q0q1_xpipe_pipe_ch14_txcompliance_m),
      .XPIPE_PIPE_CH14_TXDATAVALID_M (q0q1_xpipe_pipe_ch14_txdatavalid_m),
      .XPIPE_PIPE_CH14_TXDATA_M      (q0q1_xpipe_pipe_ch14_txdata_m),
      .XPIPE_PIPE_CH14_TXDEEMPH_M    (q0q1_xpipe_pipe_ch14_txdeemph_m),
      .XPIPE_PIPE_CH14_TXELECIDLE_M  (q0q1_xpipe_pipe_ch14_txelecidle_m),
      .XPIPE_PIPE_CH14_TXMAINCURSOR_M(q0q1_xpipe_pipe_ch14_txmaincursor_m),
      .XPIPE_PIPE_CH14_TXMARGIN_M    (q0q1_xpipe_pipe_ch14_txmargin_m),
      .XPIPE_PIPE_CH14_TXPOSTCURSOR_M(q0q1_xpipe_pipe_ch14_txpostcursor_m),
      .XPIPE_PIPE_CH14_TXPRECURSOR_M (q0q1_xpipe_pipe_ch14_txprecursor_m),
      .XPIPE_PIPE_CH14_TXSTARTBLOCK_M(q0q1_xpipe_pipe_ch14_txstartblock_m),
      .XPIPE_PIPE_CH14_TXSWING_M     (q0q1_xpipe_pipe_ch14_txswing_m),
      .XPIPE_PIPE_CH14_TXSYNCHEADER_M(q0q1_xpipe_pipe_ch14_txsyncheader_m),
      .XPIPE_PIPE_CH14_PHYSTATUS_M   (q0q1_xpipe_pipe_ch14_phystatus_m),
      .XPIPE_PIPE_CH14_RXCHARISK_M   (q0q1_xpipe_pipe_ch14_rxcharisk_m),
      .XPIPE_PIPE_CH14_RXDATAVALID_M (q0q1_xpipe_pipe_ch14_rxdatavalid_m),
      .XPIPE_PIPE_CH14_RXDATA_M      (q0q1_xpipe_pipe_ch14_rxdata_m),
      .XPIPE_PIPE_CH14_RXELECIDLE_M  (q0q1_xpipe_pipe_ch14_rxelecidle_m),
      .XPIPE_PIPE_CH14_RXSTARTBLOCK_M(q0q1_xpipe_pipe_ch14_rxstartblock_m),
      .XPIPE_PIPE_CH14_RXSTATUS_M    (q0q1_xpipe_pipe_ch14_rxstatus_m),
      .XPIPE_PIPE_CH14_RXSYNCHEADER_M(q0q1_xpipe_pipe_ch14_rxsyncheader_m),
      .XPIPE_PIPE_CH14_RXVALID_M     (q0q1_xpipe_pipe_ch14_rxvalid_m),
      .XPIPE_PIPE_CH14_TXDETECTRXLOOPBACK_M(q0q1_xpipe_pipe_ch14_txdetectrxloopback_m),

      .XPIPE_PIPE_CH15_PHYSTATUS        (cpm_xpipe_ch15_phystatus),
      .XPIPE_PIPE_CH15_RXCHARISK     (cpm_xpipe_ch15_rxcharisk),
      .XPIPE_PIPE_CH15_RXDATA        (cpm_xpipe_ch15_rxdata), 
      .XPIPE_PIPE_CH15_RXDATAVALID   (cpm_xpipe_ch15_rxdatavalid),
      .XPIPE_PIPE_CH15_RXELECIDLE    (cpm_xpipe_ch15_rxelecidle),
      .XPIPE_PIPE_CH15_RXSTARTBLOCK  (cpm_xpipe_ch15_rxstartblock),
      .XPIPE_PIPE_CH15_RXSTATUS      (cpm_xpipe_ch15_rxstatus),
      .XPIPE_PIPE_CH15_RXSYNCHEADER  (cpm_xpipe_ch15_rxsyncheader),
      .XPIPE_PIPE_CH15_RXVALID       (cpm_xpipe_ch15_rxvalid),
      .XPIPE_PIPE_CH15_POWERDOWN     (cpm_xpipe_ch15_powerdown),
      .XPIPE_PIPE_CH15_RXPOLARITY    (cpm_xpipe_ch15_rxpolarity),
      .XPIPE_PIPE_CH15_RXTERMINATION (cpm_xpipe_ch15_rxtermination),
      .XPIPE_PIPE_CH15_TXCHARISK     (cpm_xpipe_ch15_txcharisk),
      .XPIPE_PIPE_CH15_TXCOMPLIANCE  (cpm_xpipe_ch15_txcompliance),
      .XPIPE_PIPE_CH15_TXDATA        (cpm_xpipe_ch15_txdata),
      .XPIPE_PIPE_CH15_TXDATAVALID   (cpm_xpipe_ch15_txdatavalid),
      .XPIPE_PIPE_CH15_TXDEEMPH      (cpm_xpipe_ch15_txdeemph),
      .XPIPE_PIPE_CH15_TXDETECTRXLOOPBACK(cpm_xpipe_ch15_txdetectrxloopback),
      .XPIPE_PIPE_CH15_TXELECIDLE    (cpm_xpipe_ch15_txelecidle),
      .XPIPE_PIPE_CH15_TXMAINCURSOR  (cpm_xpipe_ch15_txmaincursor),
      .XPIPE_PIPE_CH15_TXMARGIN      (cpm_xpipe_ch15_txmargin),
      .XPIPE_PIPE_CH15_TXPOSTCURSOR  (cpm_xpipe_ch15_txpostcursor),
      .XPIPE_PIPE_CH15_TXPRECURSOR   (cpm_xpipe_ch15_txprecursor),
      .XPIPE_PIPE_CH15_TXSTARTBLOCK  (cpm_xpipe_ch15_txstartblock),
      .XPIPE_PIPE_CH15_TXSWING       (cpm_xpipe_ch15_txswing),
      .XPIPE_PIPE_CH15_TXSYNCHEADER  (cpm_xpipe_ch15_txsyncheader),
      .XPIPE_PIPE_CH15_POWERDOWN_M   (q0q1_xpipe_pipe_ch15_powerdown_m),
      .XPIPE_PIPE_CH15_RXPOLARITY_M  (q0q1_xpipe_pipe_ch15_rxpolarity_m),
      .XPIPE_PIPE_CH15_RXTERMINATION_M(q0q1_xpipe_pipe_ch15_rxtermination_m),
      .XPIPE_PIPE_CH15_TXCHARISK_M   (q0q1_xpipe_pipe_ch15_txcharisk_m),
      .XPIPE_PIPE_CH15_TXCOMPLIANCE_M(q0q1_xpipe_pipe_ch15_txcompliance_m),
      .XPIPE_PIPE_CH15_TXDATAVALID_M (q0q1_xpipe_pipe_ch15_txdatavalid_m),
      .XPIPE_PIPE_CH15_TXDATA_M      (q0q1_xpipe_pipe_ch15_txdata_m),
      .XPIPE_PIPE_CH15_TXDEEMPH_M    (q0q1_xpipe_pipe_ch15_txdeemph_m),
      .XPIPE_PIPE_CH15_TXELECIDLE_M  (q0q1_xpipe_pipe_ch15_txelecidle_m),
      .XPIPE_PIPE_CH15_TXMAINCURSOR_M(q0q1_xpipe_pipe_ch15_txmaincursor_m),
      .XPIPE_PIPE_CH15_TXMARGIN_M    (q0q1_xpipe_pipe_ch15_txmargin_m),
      .XPIPE_PIPE_CH15_TXPOSTCURSOR_M(q0q1_xpipe_pipe_ch15_txpostcursor_m),
      .XPIPE_PIPE_CH15_TXPRECURSOR_M (q0q1_xpipe_pipe_ch15_txprecursor_m),
      .XPIPE_PIPE_CH15_TXSTARTBLOCK_M(q0q1_xpipe_pipe_ch15_txstartblock_m),
      .XPIPE_PIPE_CH15_TXSWING_M     (q0q1_xpipe_pipe_ch15_txswing_m),
      .XPIPE_PIPE_CH15_TXSYNCHEADER_M(q0q1_xpipe_pipe_ch15_txsyncheader_m),
      .XPIPE_PIPE_CH15_PHYSTATUS_M   (q0q1_xpipe_pipe_ch15_phystatus_m),
      .XPIPE_PIPE_CH15_RXCHARISK_M   (q0q1_xpipe_pipe_ch15_rxcharisk_m),
      .XPIPE_PIPE_CH15_RXDATAVALID_M (q0q1_xpipe_pipe_ch15_rxdatavalid_m),
      .XPIPE_PIPE_CH15_RXDATA_M      (q0q1_xpipe_pipe_ch15_rxdata_m),
      .XPIPE_PIPE_CH15_RXELECIDLE_M  (q0q1_xpipe_pipe_ch15_rxelecidle_m),
      .XPIPE_PIPE_CH15_RXSTARTBLOCK_M(q0q1_xpipe_pipe_ch15_rxstartblock_m),
      .XPIPE_PIPE_CH15_RXSTATUS_M    (q0q1_xpipe_pipe_ch15_rxstatus_m),
      .XPIPE_PIPE_CH15_RXSYNCHEADER_M(q0q1_xpipe_pipe_ch15_rxsyncheader_m),
      .XPIPE_PIPE_CH15_RXVALID_M     (q0q1_xpipe_pipe_ch15_rxvalid_m),
      .XPIPE_PIPE_CH15_TXDETECTRXLOOPBACK_M(q0q1_xpipe_pipe_ch15_txdetectrxloopback_m)
    );
  end

  if ( C_XPIPE_1_INSTANTIATED == 1 )  begin

    XPIPE_QUAD #(
      .XPIPE_LOC       (C_XPIPE_1_LOC),
      .XPIPE_MODE      (C_XPIPE_1_MODE),
      .XPIPE_RSVD      (C_XPIPE_1_RSVD),
      .XPIPE_LINK0_CFG (C_XPIPE_1_LINK0_CFG),
      .XPIPE_LINK1_CFG (C_XPIPE_1_LINK1_CFG),
      .XPIPE_CLK_CFG   (C_XPIPE_1_CLK_CFG),
      .XPIPE_CLKDLY_CFG(C_XPIPE_1_CLKDLY_CFG),
      .XPIPE_REG_CFG   (C_XPIPE_1_REG_CFG)
    ) XPIPE_QUAD1_inst (


      .XPIPE_GT_OUTCLK   (q0q1_xpipe_gt_outclk_m),
      .XPIPE_GT_OUTCLK_1 (q0q1_xpipe_gt_outclk_m_1),
      .XPIPE_GT_RXOUTCLK (q0q1_xpipe_gt_rxoutclk_m),
      .XPIPE_GT_RXUSRCLK (q0q1_xpipe_gt_rxusrclk_m),
      .XPIPE_GT_PIPECLK  (q0q1_xpipe_gt_pipeclk_m),
      .XPIPE_GT_PIPECLK_1(q0q1_xpipe_gt_pipeclk_m_1),

      .XPIPE_PHYESMADAPTSAVE    (q0q1_xpipe_phyesmadaptsave_m),
      .XPIPE_PHYESMADAPTSAVE_1  (q0q1_xpipe_phyesmadaptsave_m_1),
      .XPIPE_PHYESMADAPTSAVE_M  (q1q2_xpipe_phyesmadaptsave_m),
      .XPIPE_PHYESMADAPTSAVE_M_1(q1q2_xpipe_phyesmadaptsave_m_1),

      .XPIPE_BUFGTCE       (q0q1_xpipe_bufgtce_m),
      .XPIPE_BUFGTCE_1     (q0q1_xpipe_bufgtce_m_1),
      .XPIPE_BUFGTCE_MASK  (q0q1_xpipe_bufgtce_mask_m),
      .XPIPE_BUFGTCE_MASK_1(q0q1_xpipe_bufgtce_mask_m_1),
      .XPIPE_BUFGTDIV      (q0q1_xpipe_bufgtdiv_m),
      .XPIPE_BUFGTDIV_1    (q0q1_xpipe_bufgtdiv_m_1),
      .XPIPE_BUFGTRST      (q0q1_xpipe_bufgtrst_m),
      .XPIPE_BUFGTRST_1    (q0q1_xpipe_bufgtrst_m_1),
      .XPIPE_BUFGTRST_MASK (q0q1_xpipe_bufgtrst_mask_m),
      .XPIPE_BUFGTRST_MASK_1(q0q1_xpipe_bufgtrst_mask_m_1),

      .XPIPE_PCIE_PERST_N     (q0q1_xpipe_pcie_perst_n_m),
      .XPIPE_PCIE_PERST_N_1   (q0q1_xpipe_pcie_perst_n_m_1),
      .XPIPE_PCIE_PERST_N_M   (q1q2_xpipe_pcie_perst_n_m),
      .XPIPE_PCIE_PERST_N_M_1 (q1q2_xpipe_pcie_perst_n_m_1),

      .XPIPE_PCIE_RATE    (q0q1_xpipe_pcie_rate_m),
      .XPIPE_PCIE_RATE_1  (q0q1_xpipe_pcie_rate_m_1),
      .XPIPE_PCIE_RATE_M  (q1q2_xpipe_pcie_rate_m),
      .XPIPE_PCIE_RATE_M_1(q1q2_xpipe_pcie_rate_m_1),

      .XPIPE_GT_OUTCLK_M     (q1q2_xpipe_gt_outclk_m),
      .XPIPE_GT_OUTCLK_M_1   (q1q2_xpipe_gt_outclk_m_1),
      .XPIPE_GT_RXOUTCLK_M   (q1q2_xpipe_gt_rxoutclk_m),
      .XPIPE_GT_RXUSRCLK_M   (q1q2_xpipe_gt_rxusrclk_m),
      .XPIPE_GT_PIPECLK_M    (q1q2_xpipe_gt_pipeclk_m),
      .XPIPE_GT_PIPECLK_M_1  (q1q2_xpipe_gt_pipeclk_m_1),
      .XPIPE_BUFGTCE_M       (q1q2_xpipe_bufgtce_m),
      .XPIPE_BUFGTCE_MASK_M  (q1q2_xpipe_bufgtce_mask_m),
      .XPIPE_BUFGTCE_MASK_M_1(q1q2_xpipe_bufgtce_mask_m_1),
      .XPIPE_BUFGTCE_M_1     (q1q2_xpipe_bufgtce_m_1),
      .XPIPE_BUFGTDIV_M      (q1q2_xpipe_bufgtdiv_m),
      .XPIPE_BUFGTDIV_M_1    (q1q2_xpipe_bufgtdiv_m_1),
      .XPIPE_BUFGTRST_M      (q1q2_xpipe_bufgtrst_m),
      .XPIPE_BUFGTRST_MASK_M (q1q2_xpipe_bufgtrst_mask_m),
      .XPIPE_BUFGTRST_MASK_M_1(q1q2_xpipe_bufgtrst_mask_m_1),
      .XPIPE_BUFGTRST_M_1    (q1q2_xpipe_bufgtrst_m_1),

      .XPIPE_PHYREADY_FR_BOT_M(q1q2_xpipe_phyready_fr_bot_m),
      .XPIPE_PHYREADY_TO_BOT  (q0q1_xpipe_phyready_to_bot_m),
      .XPIPE_PHY_READY        (q0q1_xpipe_phy_ready_m),
      .XPIPE_PHY_READY_1      (q0q1_xpipe_phy_ready_m_1),
      .XPIPE_PHYREADY_FR_BOT  (q0q1_xpipe_phyready_fr_bot_m),
      .XPIPE_PHYREADY_TO_BOT_M(q1q2_xpipe_phyready_to_bot_m),
      .XPIPE_PHY_READY_M      (q1q2_xpipe_phy_ready_m),
      .XPIPE_PHY_READY_M_1    (q1q2_xpipe_phy_ready_m_1),

      .ALTCLK_M      (q1_altclk_m),
      .APB3PADDR_M   (q1_apb3paddr_m),
      .APB3CLK_M     (q1_apb3clk_m),
      .AXISCLK_M     (q1_axisclk_m),
      .APB3PENABLE_M (q1_apb3penable_m),
      .APB3PRESETN_M (q1_apb3presetn_m),
      .APB3PSEL_M    (q1_apb3psel_m),
      .APB3PWDATA_M  (q1_apb3pwdata_m),
      .APB3PWRITE_M  (q1_apb3pwrite_m),

      .BGBYPASSB_M          (q1_bgbypassb_m),
      .BGMONITORENB_M       (q1_bgmonitorenb_m),
      .BGPDB_M              (q1_bgpdb_m),
      .BGRCALOVRDENB_M      (q1_bgrcalovrdenb_m),
      .BGRCALOVRD_M         (q1_bgrcalovrd_m),
      .CH0_CDRBMCDRREQ_M    (ch4_cdrbmcdrreq_m),
      .CH0_RXUSRCLK_M       (ch4_rxusrclk_m),
      .CH0_RXOUTCLK_M       (ch4_rxoutclk_m),
      .CH0_CDRFREQOS_M      (ch4_cdrfreqos_m),
      .CH0_CDRINCPCTRL_M    (ch4_cdrincpctrl_m),
      .CH0_CDRSTEPDIR_M     (ch4_cdrstepdir_m),
      .CH0_CDRSTEPSQ_M      (ch4_cdrstepsq_m),
      .CH0_CDRSTEPSX_M      (ch4_cdrstepsx_m),
    //.CH0_CFOKOVWRFINISH_M (ch4_cfokovwrfinish_m),
    //.CH0_CFOKOVWRPULSE_M  (ch4_cfokovwrpulse_m),
    //.CH0_CFOKOVWRSTART_M  (ch4_cfokovwrstart_m),
      .CH0_CLKRSVD0_M       (ch4_clkrsvd0_m),
      .CH0_CLKRSVD1_M       (ch4_clkrsvd1_m),
      .CH0_DMONFIFORESET_M  (ch4_dmonfiforeset_m),
      .CH0_DMONITORCLK_M    (ch4_dmonitorclk_m),
      .CH0_EYESCANRESET_M   (ch4_eyescanreset_m),
      .CH0_EYESCANTRIGGER_M (ch4_eyescantrigger_m),
      .CH0_GTRSVD_M         (ch4_gtrsvd_m),
      .CH0_GTRXRESET_M      (ch4_gtrxreset_m),
      .CH0_GTTXRESET_M      (ch4_gttxreset_m),
      .CH0_HSDPPCSRESET_M   (ch4_hsdppcsreset_m),
      .CH0_ILORESETMASK_M   (ch4_iloresetmask_m),
      .CH0_ILORESET_M       (ch4_iloreset_m),
      .CH0_LOOPBACK_M       (ch4_loopback_m),
      .CH0_PCIERSTB_M       (ch4_pcierstb_m),
      .CH0_PCSRSVDIN_M      (ch4_pcsrsvdin_m),
      .CH0_PHYESMADAPTSAVE_M(ch4_phyesmadaptsave_m),
      .CH0_RXCDRHOLD_M      (ch4_rxcdrhold_m),
      .CH0_RXCDROVRDEN_M    (ch4_rxcdrovrden_m),
      .CH0_RXCDRRESET_M     (ch4_rxcdrreset_m),
      .CH0_RXCHBONDI_M      (ch4_rxchbondi_m),
      .CH0_RXDAPICODEOVRDEN_M(ch4_rxdapicodeovrden_m),
      .CH0_RXDAPICODERESET_M(ch4_rxdapicodereset_m),
      .CH0_RXDLYALIGNREQ_M  (ch4_rxdlyalignreq_m),
      .CH0_RXEQTRAINING_M   (ch4_rxeqtraining_m),
      .CH0_RXGEARBOXSLIP_M  (ch4_rxgearboxslip_m),
      .CH0_RXLATCLK_M       (ch4_rxlatclk_m),
      .CH0_RXLPMEN_M        (ch4_rxlpmen_m),
      .CH0_RXMLDCHAINDONE_M (ch4_rxmldchaindone_m),
      .CH0_RXMLDCHAINREQ_M  (ch4_rxmldchainreq_m),
      .CH0_RXMLFINEALIGNREQ_M(ch4_rxmlfinealignreq_m),
      .CH0_RXOOBRESET_M     (ch4_rxoobreset_m),
      .CH0_RXPCSRESETMASK_M (ch4_rxpcsresetmask_m),
      .CH0_RXPD_M           (ch4_rxpd_m),
      .CH0_RXPHALIGNREQ_M   (ch4_rxphalignreq_m),
      .CH0_RXPHALIGNRESETMASK_M(ch4_rxphalignresetmask_m),
      .CH0_RXPHDLYPD_M      (ch4_rxphdlypd_m),
      .CH0_RXPHDLYRESET_M   (ch4_rxphdlyreset_m),
      .CH0_RXPHSETINITREQ_M (ch4_rxphsetinitreq_m),
      .CH0_RXPHSHIFT180_M   (ch4_rxphshift180_m),
      .CH0_RXPMARESETMASK_M (ch4_rxpmaresetmask_m),
      .CH0_RXPOLARITY_M     (ch4_rxpolarity_m),
      .CH0_RXPRBSCNTRESET_M (ch4_rxprbscntreset_m),
      .CH0_RXPRBSSEL_M      (ch4_rxprbssel_m),
      .CH0_RXPROGDIVRESET_M (ch4_rxprogdivreset_m),
      .CH0_RXRATE_M         (ch4_rxrate_m),
      .CH0_RXRESETMODE_M    (ch4_rxresetmode_m),
      .CH0_RXSLIDE_M        (ch4_rxslide_m),
      .CH0_RXSYNCALLIN_M    (ch4_rxsyncallin_m),
      .CH0_RXTERMINATION_M  (ch4_rxtermination_m),
      .CH0_RXUSERRDY_M      (ch4_rxuserrdy_m),
      .CH0_TSTIN_M          (ch4_tstin_m),
      .CH0_TXCOMINIT_M      (ch4_txcominit_m),
      .CH0_TXCOMSAS_M       (ch4_txcomsas_m),
      .CH0_TXCOMWAKE_M      (ch4_txcomwake_m),
      .CH0_TXCTRL0_M        (ch4_txctrl0_m),
      .CH0_TXCTRL1_M        (ch4_txctrl1_m),
      .CH0_TXCTRL2_M        (ch4_txctrl2_m),
      .CH0_TXDAPICODEOVRDEN_M(ch4_txdapicodeovrden_m),
      .CH0_TXDAPICODERESET_M(ch4_txdapicodereset_m),
      .CH0_TXDATAEXTENDRSVD_M(ch4_txdataextendrsvd_m),
      .CH0_TXDATA_M         (ch4_txdata_m),
      .CH0_TXDEEMPH_M       (ch4_txdeemph_m),
      .CH0_TXDETECTRX_M     (ch4_txdetectrx_m),
      .CH0_TXDIFFCTRL_M     (ch4_txdiffctrl_m),
      .CH0_TXDLYALIGNREQ_M  (ch4_txdlyalignreq_m),
      .CH0_TXELECIDLE_M     (ch4_txelecidle_m),
      .CH0_TXHEADER_M       (ch4_txheader_m),
      .CH0_TXINHIBIT_M      (ch4_txinhibit_m),
      .CH0_TXLATCLK_M       (ch4_txlatclk_m),
      .CH0_TXMAINCURSOR_M   (ch4_txmaincursor_m),
      .CH0_TXMARGIN_M       (ch4_txmargin_m),
      .CH0_TXMLDCHAINDONE_M (ch4_txmldchaindone_m),
      .CH0_TXMLDCHAINREQ_M  (ch4_txmldchainreq_m),
      .CH0_TXONESZEROS_M    (ch4_txoneszeros_m),
      .CH0_TXPAUSEDELAYALIGN_M(ch4_txpausedelayalign_m),
      .CH0_TXPCSRESETMASK_M (ch4_txpcsresetmask_m),
      .CH0_TXPD_M           (ch4_txpd_m),
      .CH0_TXPHALIGNREQ_M   (ch4_txphalignreq_m),
      .CH0_TXPHALIGNRESETMASK_M(ch4_txphalignresetmask_m),
      .CH0_TXPHDLYPD_M      (ch4_txphdlypd_m),
      .CH0_TXPHDLYRESET_M   (ch4_txphdlyreset_m),
      .CH0_TXPHDLYTSTCLK_M  (ch4_txphdlytstclk_m),
      .CH0_TXPHSETINITREQ_M (ch4_txphsetinitreq_m),
      .CH0_TXPHSHIFT180_M   (ch4_txphshift180_m),
      .CH0_TXPICODEOVRDEN_M (ch4_txpicodeovrden_m),
      .CH0_TXPICODERESET_M  (ch4_txpicodereset_m),
      .CH0_TXPIPPMEN_M      (ch4_txpippmen_m),
      .CH0_TXPIPPMSTEPSIZE_M(ch4_txpippmstepsize_m),
      .CH0_TXPISOPD_M       (ch4_txpisopd_m),
      .CH0_TXPMARESETMASK_M (ch4_txpmaresetmask_m),
      .CH0_TXPOLARITY_M     (ch4_txpolarity_m),
      .CH0_TXPOSTCURSOR_M   (ch4_txpostcursor_m),
      .CH0_TXPRBSFORCEERR_M (ch4_txprbsforceerr_m),
      .CH0_TXPRBSSEL_M      (ch4_txprbssel_m),
      .CH0_TXPRECURSOR_M    (ch4_txprecursor_m),
      .CH0_TXPROGDIVRESET_M (ch4_txprogdivreset_m),
      .CH0_TXRATE_M         (ch4_txrate_m),
      .CH0_TXRESETMODE_M    (ch4_txresetmode_m),
      .CH0_TXSEQUENCE_M     (ch4_txsequence_m),
      .CH0_TXSWING_M        (ch4_txswing_m),
      .CH0_TXSYNCALLIN_M    (ch4_txsyncallin_m),
      .CH0_TXUSERRDY_M      (ch4_txuserrdy_m),
      .CH0_TXUSRCLK_M       (ch4_txusrclk_m),
      .CH1_CDRBMCDRREQ_M    (ch5_cdrbmcdrreq_m),
      .CH1_CDRFREQOS_M      (ch5_cdrfreqos_m),
      .CH1_CDRINCPCTRL_M    (ch5_cdrincpctrl_m),
      .CH1_CDRSTEPDIR_M     (ch5_cdrstepdir_m),
      .CH1_CDRSTEPSQ_M      (ch5_cdrstepsq_m),
      .CH1_CDRSTEPSX_M      (ch5_cdrstepsx_m),
    //.CH1_CFOKOVWRFINISH_M (ch5_cfokovwrfinish_m),
    //.CH1_CFOKOVWRPULSE_M  (ch5_cfokovwrpulse_m),
    //.CH1_CFOKOVWRSTART_M  (ch5_cfokovwrstart_m),
      .CH1_CLKRSVD0_M       (ch5_clkrsvd0_m),
      .CH1_CLKRSVD1_M       (ch5_clkrsvd1_m),
      .CH1_DMONFIFORESET_M  (ch5_dmonfiforeset_m),
      .CH1_DMONITORCLK_M    (ch5_dmonitorclk_m),
      .CH1_EYESCANRESET_M   (ch5_eyescanreset_m),
      .CH1_EYESCANTRIGGER_M (ch5_eyescantrigger_m),
      .CH1_GTRSVD_M         (ch5_gtrsvd_m),
      .CH1_GTRXRESET_M      (ch5_gtrxreset_m),
      .CH1_GTTXRESET_M      (ch5_gttxreset_m),
      .CH1_HSDPPCSRESET_M   (ch5_hsdppcsreset_m),
      .CH1_ILORESETMASK_M   (ch5_iloresetmask_m),
      .CH1_ILORESET_M       (ch5_iloreset_m),
      .CH1_LOOPBACK_M       (ch5_loopback_m),
      .CH1_PCIERSTB_M       (ch5_pcierstb_m),
      .CH1_PCSRSVDIN_M      (ch5_pcsrsvdin_m),
      .CH1_PHYESMADAPTSAVE_M(ch5_phyesmadaptsave_m),
      .CH1_RXCDRHOLD_M      (ch5_rxcdrhold_m),
      .CH1_RXCDROVRDEN_M    (ch5_rxcdrovrden_m),
      .CH1_RXCDRRESET_M     (ch5_rxcdrreset_m),
      .CH1_RXCHBONDI_M      (ch5_rxchbondi_m),
      .CH1_RXDAPICODEOVRDEN_M(ch5_rxdapicodeovrden_m),
      .CH1_RXDAPICODERESET_M(ch5_rxdapicodereset_m),
      .CH1_RXDLYALIGNREQ_M  (ch5_rxdlyalignreq_m),
      .CH1_RXEQTRAINING_M   (ch5_rxeqtraining_m),
      .CH1_RXGEARBOXSLIP_M  (ch5_rxgearboxslip_m),
      .CH1_RXLATCLK_M       (ch5_rxlatclk_m),
      .CH1_RXLPMEN_M        (ch5_rxlpmen_m),
      .CH1_RXMLDCHAINDONE_M (ch5_rxmldchaindone_m),
      .CH1_RXMLDCHAINREQ_M  (ch5_rxmldchainreq_m),
      .CH1_RXMLFINEALIGNREQ_M(ch5_rxmlfinealignreq_m),
      .CH1_RXOOBRESET_M     (ch5_rxoobreset_m),
      .CH1_RXPCSRESETMASK_M (ch5_rxpcsresetmask_m),
      .CH1_RXPD_M           (ch5_rxpd_m),
      .CH1_RXPHALIGNREQ_M   (ch5_rxphalignreq_m),
      .CH1_RXPHALIGNRESETMASK_M(ch5_rxphalignresetmask_m),
      .CH1_RXPHDLYPD_M      (ch5_rxphdlypd_m),
      .CH1_RXPHDLYRESET_M   (ch5_rxphdlyreset_m),
      .CH1_RXPHSETINITREQ_M (ch5_rxphsetinitreq_m),
      .CH1_RXPHSHIFT180_M   (ch5_rxphshift180_m),
      .CH1_RXPMARESETMASK_M (ch5_rxpmaresetmask_m),
      .CH1_RXPOLARITY_M     (ch5_rxpolarity_m),
      .CH1_RXPRBSCNTRESET_M (ch5_rxprbscntreset_m),
      .CH1_RXPRBSSEL_M      (ch5_rxprbssel_m),
      .CH1_RXPROGDIVRESET_M (ch5_rxprogdivreset_m),
      .CH1_RXRATE_M         (ch5_rxrate_m),
      .CH1_RXRESETMODE_M    (ch5_rxresetmode_m),
      .CH1_RXSLIDE_M        (ch5_rxslide_m),
      .CH1_RXSYNCALLIN_M    (ch5_rxsyncallin_m),
      .CH1_RXTERMINATION_M  (ch5_rxtermination_m),
      .CH1_RXUSERRDY_M      (ch5_rxuserrdy_m),
      .CH1_RXUSRCLK_M       (ch5_rxusrclk_m),
      .CH1_TSTIN_M          (ch5_tstin_m),
      .CH1_TXCOMINIT_M      (ch5_txcominit_m),
      .CH1_TXCOMSAS_M       (ch5_txcomsas_m),
      .CH1_TXCOMWAKE_M      (ch5_txcomwake_m),
      .CH1_TXCTRL0_M        (ch5_txctrl0_m),
      .CH1_TXCTRL1_M        (ch5_txctrl1_m),
      .CH1_TXCTRL2_M        (ch5_txctrl2_m),
      .CH1_TXDAPICODEOVRDEN_M(ch5_txdapicodeovrden_m),
      .CH1_TXDAPICODERESET_M(ch5_txdapicodereset_m),
      .CH1_TXDATAEXTENDRSVD_M(ch5_txdataextendrsvd_m),
      .CH1_TXDATA_M         (ch5_txdata_m),
      .CH1_TXDEEMPH_M       (ch5_txdeemph_m),
      .CH1_TXDETECTRX_M     (ch5_txdetectrx_m),
      .CH1_TXDIFFCTRL_M     (ch5_txdiffctrl_m),
      .CH1_TXDLYALIGNREQ_M  (ch5_txdlyalignreq_m),
      .CH1_TXELECIDLE_M     (ch5_txelecidle_m),
      .CH1_TXHEADER_M       (ch5_txheader_m),
      .CH1_TXINHIBIT_M      (ch5_txinhibit_m),
      .CH1_TXLATCLK_M       (ch5_txlatclk_m),
      .CH1_TXMAINCURSOR_M   (ch5_txmaincursor_m),
      .CH1_TXMARGIN_M       (ch5_txmargin_m),
      .CH1_TXMLDCHAINDONE_M (ch5_txmldchaindone_m),
      .CH1_TXMLDCHAINREQ_M  (ch5_txmldchainreq_m),
      .CH1_TXONESZEROS_M    (ch5_txoneszeros_m),
      .CH1_TXPAUSEDELAYALIGN_M(ch5_txpausedelayalign_m),
      .CH1_TXPCSRESETMASK_M (ch5_txpcsresetmask_m),
      .CH1_TXPD_M           (ch5_txpd_m),
      .CH1_TXPHALIGNREQ_M   (ch5_txphalignreq_m),
      .CH1_TXPHALIGNRESETMASK_M(ch5_txphalignresetmask_m),
      .CH1_TXPHDLYPD_M      (ch5_txphdlypd_m),
      .CH1_TXPHDLYRESET_M   (ch5_txphdlyreset_m),
      .CH1_TXPHDLYTSTCLK_M  (ch5_txphdlytstclk_m),
      .CH1_TXPHSETINITREQ_M (ch5_txphsetinitreq_m),
      .CH1_TXPHSHIFT180_M   (ch5_txphshift180_m),
      .CH1_TXPICODEOVRDEN_M (ch5_txpicodeovrden_m),
      .CH1_TXPICODERESET_M  (ch5_txpicodereset_m),
      .CH1_TXPIPPMEN_M      (ch5_txpippmen_m),
      .CH1_TXPIPPMSTEPSIZE_M(ch5_txpippmstepsize_m),
      .CH1_TXPISOPD_M       (ch5_txpisopd_m),
      .CH1_TXPMARESETMASK_M (ch5_txpmaresetmask_m),
      .CH1_TXPOLARITY_M     (ch5_txpolarity_m),
      .CH1_TXPOSTCURSOR_M   (ch5_txpostcursor_m),
      .CH1_TXPRBSFORCEERR_M (ch5_txprbsforceerr_m),
      .CH1_TXPRBSSEL_M      (ch5_txprbssel_m),
      .CH1_TXPRECURSOR_M    (ch5_txprecursor_m),
      .CH1_TXPROGDIVRESET_M (ch5_txprogdivreset_m),
      .CH1_TXRATE_M         (ch5_txrate_m),
      .CH1_TXRESETMODE_M    (ch5_txresetmode_m),
      .CH1_TXSEQUENCE_M     (ch5_txsequence_m),
      .CH1_TXSWING_M        (ch5_txswing_m),
      .CH1_TXSYNCALLIN_M    (ch5_txsyncallin_m),
      .CH1_TXUSERRDY_M      (ch5_txuserrdy_m),
      .CH1_TXUSRCLK_M       (ch5_txusrclk_m),
      .CH2_CDRBMCDRREQ_M    (ch6_cdrbmcdrreq_m),
      .CH2_CDRFREQOS_M      (ch6_cdrfreqos_m),
      .CH2_CDRINCPCTRL_M    (ch6_cdrincpctrl_m),
      .CH2_CDRSTEPDIR_M     (ch6_cdrstepdir_m),
      .CH2_CDRSTEPSQ_M      (ch6_cdrstepsq_m),
      .CH2_CDRSTEPSX_M      (ch6_cdrstepsx_m),
    //.CH2_CFOKOVWRFINISH_M (ch6_cfokovwrfinish_m),
    //.CH2_CFOKOVWRPULSE_M  (ch6_cfokovwrpulse_m),
    //.CH2_CFOKOVWRSTART_M  (ch6_cfokovwrstart_m),
      .CH2_CLKRSVD0_M       (ch6_clkrsvd0_m),
      .CH2_CLKRSVD1_M       (ch6_clkrsvd1_m),
      .CH2_DMONFIFORESET_M  (ch6_dmonfiforeset_m),
      .CH2_DMONITORCLK_M    (ch6_dmonitorclk_m),
      .CH2_EYESCANRESET_M   (ch6_eyescanreset_m),
      .CH2_EYESCANTRIGGER_M (ch6_eyescantrigger_m),
      .CH2_GTRSVD_M         (ch6_gtrsvd_m),
      .CH2_GTRXRESET_M      (ch6_gtrxreset_m),
      .CH2_GTTXRESET_M      (ch6_gttxreset_m),
      .CH2_HSDPPCSRESET_M   (ch6_hsdppcsreset_m),
      .CH2_ILORESETMASK_M   (ch6_iloresetmask_m),
      .CH2_ILORESET_M       (ch6_iloreset_m),
      .CH2_LOOPBACK_M       (ch6_loopback_m),
      .CH2_PCIERSTB_M       (ch6_pcierstb_m),
      .CH2_PCSRSVDIN_M      (ch6_pcsrsvdin_m),
      .CH2_PHYESMADAPTSAVE_M(ch6_phyesmadaptsave_m),
      .CH2_RXCDRHOLD_M      (ch6_rxcdrhold_m),
      .CH2_RXCDROVRDEN_M    (ch6_rxcdrovrden_m),
      .CH2_RXCDRRESET_M     (ch6_rxcdrreset_m),
      .CH2_RXCHBONDI_M      (ch6_rxchbondi_m),
      .CH2_RXDAPICODEOVRDEN_M(ch6_rxdapicodeovrden_m),
      .CH2_RXDAPICODERESET_M(ch6_rxdapicodereset_m),
      .CH2_RXDLYALIGNREQ_M  (ch6_rxdlyalignreq_m),
      .CH2_RXEQTRAINING_M   (ch6_rxeqtraining_m),
      .CH2_RXGEARBOXSLIP_M  (ch6_rxgearboxslip_m),
      .CH2_RXLATCLK_M       (ch6_rxlatclk_m),
      .CH2_RXLPMEN_M        (ch6_rxlpmen_m),
      .CH2_RXMLDCHAINDONE_M (ch6_rxmldchaindone_m),
      .CH2_RXMLDCHAINREQ_M  (ch6_rxmldchainreq_m),
      .CH2_RXMLFINEALIGNREQ_M(ch6_rxmlfinealignreq_m),
      .CH2_RXOOBRESET_M     (ch6_rxoobreset_m),
      .CH2_RXPCSRESETMASK_M (ch6_rxpcsresetmask_m),
      .CH2_RXPD_M           (ch6_rxpd_m),
      .CH2_RXPHALIGNREQ_M   (ch6_rxphalignreq_m),
      .CH2_RXPHALIGNRESETMASK_M(ch6_rxphalignresetmask_m),
      .CH2_RXPHDLYPD_M      (ch6_rxphdlypd_m),
      .CH2_RXPHDLYRESET_M   (ch6_rxphdlyreset_m),
      .CH2_RXPHSETINITREQ_M (ch6_rxphsetinitreq_m),
      .CH2_RXPHSHIFT180_M   (ch6_rxphshift180_m),
      .CH2_RXPMARESETMASK_M (ch6_rxpmaresetmask_m),
      .CH2_RXPOLARITY_M     (ch6_rxpolarity_m),
      .CH2_RXPRBSCNTRESET_M (ch6_rxprbscntreset_m),
      .CH2_RXPRBSSEL_M      (ch6_rxprbssel_m),
      .CH2_RXPROGDIVRESET_M (ch6_rxprogdivreset_m),
      .CH2_RXRATE_M         (ch6_rxrate_m),
      .CH2_RXRESETMODE_M    (ch6_rxresetmode_m),
      .CH2_RXSLIDE_M        (ch6_rxslide_m),
      .CH2_RXSYNCALLIN_M    (ch6_rxsyncallin_m),
      .CH2_RXTERMINATION_M  (ch6_rxtermination_m),
      .CH2_RXUSERRDY_M      (ch6_rxuserrdy_m),
      .CH2_RXUSRCLK_M       (ch6_rxusrclk_m),
      .CH2_TSTIN_M          (ch6_tstin_m),
      .CH2_TXCOMINIT_M      (ch6_txcominit_m),
      .CH2_TXCOMSAS_M       (ch6_txcomsas_m),
      .CH2_TXCOMWAKE_M      (ch6_txcomwake_m),
      .CH2_TXCTRL0_M        (ch6_txctrl0_m),
      .CH2_TXCTRL1_M        (ch6_txctrl1_m),
      .CH2_TXCTRL2_M        (ch6_txctrl2_m),
      .CH2_TXDAPICODEOVRDEN_M(ch6_txdapicodeovrden_m),
      .CH2_TXDAPICODERESET_M(ch6_txdapicodereset_m),
      .CH2_TXDATAEXTENDRSVD_M(ch6_txdataextendrsvd_m),
      .CH2_TXDATA_M         (ch6_txdata_m),
      .CH2_TXDEEMPH_M       (ch6_txdeemph_m),
      .CH2_TXDETECTRX_M     (ch6_txdetectrx_m),
      .CH2_TXDIFFCTRL_M     (ch6_txdiffctrl_m),
      .CH2_TXDLYALIGNREQ_M  (ch6_txdlyalignreq_m),
      .CH2_TXELECIDLE_M     (ch6_txelecidle_m),
      .CH2_TXHEADER_M       (ch6_txheader_m),
      .CH2_TXINHIBIT_M      (ch6_txinhibit_m),
      .CH2_TXLATCLK_M       (ch6_txlatclk_m),
      .CH2_TXMAINCURSOR_M   (ch6_txmaincursor_m),
      .CH2_TXMARGIN_M       (ch6_txmargin_m),
      .CH2_TXMLDCHAINDONE_M (ch6_txmldchaindone_m),
      .CH2_TXMLDCHAINREQ_M  (ch6_txmldchainreq_m),
      .CH2_TXONESZEROS_M    (ch6_txoneszeros_m),
      .CH2_TXPAUSEDELAYALIGN_M(ch6_txpausedelayalign_m),
      .CH2_TXPCSRESETMASK_M (ch6_txpcsresetmask_m),
      .CH2_TXPD_M           (ch6_txpd_m),
      .CH2_TXPHALIGNREQ_M   (ch6_txphalignreq_m),
      .CH2_TXPHALIGNRESETMASK_M(ch6_txphalignresetmask_m),
      .CH2_TXPHDLYPD_M      (ch6_txphdlypd_m),
      .CH2_TXPHDLYRESET_M   (ch6_txphdlyreset_m),
      .CH2_TXPHDLYTSTCLK_M  (ch6_txphdlytstclk_m),
      .CH2_TXPHSETINITREQ_M (ch6_txphsetinitreq_m),
      .CH2_TXPHSHIFT180_M   (ch6_txphshift180_m),
      .CH2_TXPICODEOVRDEN_M (ch6_txpicodeovrden_m),
      .CH2_TXPICODERESET_M  (ch6_txpicodereset_m),
      .CH2_TXPIPPMEN_M      (ch6_txpippmen_m),
      .CH2_TXPIPPMSTEPSIZE_M(ch6_txpippmstepsize_m),
      .CH2_TXPISOPD_M       (ch6_txpisopd_m),
      .CH2_TXPMARESETMASK_M (ch6_txpmaresetmask_m),
      .CH2_TXPOLARITY_M     (ch6_txpolarity_m),
      .CH2_TXPOSTCURSOR_M   (ch6_txpostcursor_m),
      .CH2_TXPRBSFORCEERR_M (ch6_txprbsforceerr_m),
      .CH2_TXPRBSSEL_M      (ch6_txprbssel_m),
      .CH2_TXPRECURSOR_M    (ch6_txprecursor_m),
      .CH2_TXPROGDIVRESET_M (ch6_txprogdivreset_m),
      .CH2_TXRATE_M         (ch6_txrate_m),
      .CH2_TXRESETMODE_M    (ch6_txresetmode_m),
      .CH2_TXSEQUENCE_M     (ch6_txsequence_m),
      .CH2_TXSWING_M        (ch6_txswing_m),
      .CH2_TXSYNCALLIN_M    (ch6_txsyncallin_m),
      .CH2_TXUSERRDY_M      (ch6_txuserrdy_m),
      .CH2_TXUSRCLK_M       (ch6_txusrclk_m),
      .CH3_CDRBMCDRREQ_M    (ch7_cdrbmcdrreq_m),
      .CH3_CDRFREQOS_M      (ch7_cdrfreqos_m),
      .CH3_CDRINCPCTRL_M    (ch7_cdrincpctrl_m),
      .CH3_CDRSTEPDIR_M     (ch7_cdrstepdir_m),
      .CH3_CDRSTEPSQ_M      (ch7_cdrstepsq_m),
      .CH3_CDRSTEPSX_M      (ch7_cdrstepsx_m),
    //.CH3_CFOKOVWRFINISH_M (ch7_cfokovwrfinish_m),
    //.CH3_CFOKOVWRPULSE_M  (ch7_cfokovwrpulse_m),
    //.CH3_CFOKOVWRSTART_M  (ch7_cfokovwrstart_m),
      .CH3_CLKRSVD0_M       (ch7_clkrsvd0_m),
      .CH3_CLKRSVD1_M       (ch7_clkrsvd1_m),
      .CH3_DMONFIFORESET_M  (ch7_dmonfiforeset_m),
      .CH3_DMONITORCLK_M    (ch7_dmonitorclk_m),
      .CH3_EYESCANRESET_M   (ch7_eyescanreset_m),
      .CH3_EYESCANTRIGGER_M (ch7_eyescantrigger_m),
      .CH3_GTRSVD_M         (ch7_gtrsvd_m),
      .CH3_GTRXRESET_M      (ch7_gtrxreset_m),
      .CH3_GTTXRESET_M      (ch7_gttxreset_m),
      .CH3_HSDPPCSRESET_M   (ch7_hsdppcsreset_m),
      .CH3_ILORESETMASK_M   (ch7_iloresetmask_m),
      .CH3_ILORESET_M       (ch7_iloreset_m),
      .CH3_LOOPBACK_M       (ch7_loopback_m),
      .CH3_PCIERSTB_M       (ch7_pcierstb_m),
      .CH3_PCSRSVDIN_M      (ch7_pcsrsvdin_m),
      .CH3_PHYESMADAPTSAVE_M(ch7_phyesmadaptsave_m),
      .CH3_RXCDRHOLD_M      (ch7_rxcdrhold_m),
      .CH3_RXCDROVRDEN_M    (ch7_rxcdrovrden_m),
      .CH3_RXCDRRESET_M     (ch7_rxcdrreset_m),
      .CH3_RXCHBONDI_M      (ch7_rxchbondi_m),
      .CH3_RXDAPICODEOVRDEN_M(ch7_rxdapicodeovrden_m),
      .CH3_RXDAPICODERESET_M(ch7_rxdapicodereset_m),
      .CH3_RXDLYALIGNREQ_M  (ch7_rxdlyalignreq_m),
      .CH3_RXEQTRAINING_M   (ch7_rxeqtraining_m),
      .CH3_RXGEARBOXSLIP_M  (ch7_rxgearboxslip_m),
      .CH3_RXLATCLK_M       (ch7_rxlatclk_m),
      .CH3_RXLPMEN_M        (ch7_rxlpmen_m),
      .CH3_RXMLDCHAINDONE_M (ch7_rxmldchaindone_m),
      .CH3_RXMLDCHAINREQ_M  (ch7_rxmldchainreq_m),
      .CH3_RXMLFINEALIGNREQ_M(ch7_rxmlfinealignreq_m),
      .CH3_RXOOBRESET_M     (ch7_rxoobreset_m),
      .CH3_RXPCSRESETMASK_M (ch7_rxpcsresetmask_m),
      .CH3_RXPD_M           (ch7_rxpd_m),
      .CH3_RXPHALIGNREQ_M   (ch7_rxphalignreq_m),
      .CH3_RXPHALIGNRESETMASK_M(ch7_rxphalignresetmask_m),
      .CH3_RXPHDLYPD_M      (ch7_rxphdlypd_m),
      .CH3_RXPHDLYRESET_M   (ch7_rxphdlyreset_m),
      .CH3_RXPHSETINITREQ_M (ch7_rxphsetinitreq_m),
      .CH3_RXPHSHIFT180_M   (ch7_rxphshift180_m),
      .CH3_RXPMARESETMASK_M (ch7_rxpmaresetmask_m),
      .CH3_RXPOLARITY_M     (ch7_rxpolarity_m),
      .CH3_RXPRBSCNTRESET_M (ch7_rxprbscntreset_m),
      .CH3_RXPRBSSEL_M      (ch7_rxprbssel_m),
      .CH3_RXPROGDIVRESET_M (ch7_rxprogdivreset_m),
      .CH3_RXRATE_M         (ch7_rxrate_m),
      .CH3_RXRESETMODE_M    (ch7_rxresetmode_m),
      .CH3_RXSLIDE_M        (ch7_rxslide_m),
      .CH3_RXSYNCALLIN_M    (ch7_rxsyncallin_m),
      .CH3_RXTERMINATION_M  (ch7_rxtermination_m),
      .CH3_RXUSERRDY_M      (ch7_rxuserrdy_m),
      .CH3_RXUSRCLK_M       (ch7_rxusrclk_m),
      .CH3_TSTIN_M          (ch7_tstin_m),
      .CH3_TXCOMINIT_M      (ch7_txcominit_m),
      .CH3_TXCOMSAS_M       (ch7_txcomsas_m),
      .CH3_TXCOMWAKE_M      (ch7_txcomwake_m),
      .CH3_TXCTRL0_M        (ch7_txctrl0_m),
      .CH3_TXCTRL1_M        (ch7_txctrl1_m),
      .CH3_TXCTRL2_M        (ch7_txctrl2_m),
      .CH3_TXDAPICODEOVRDEN_M(ch7_txdapicodeovrden_m),
      .CH3_TXDAPICODERESET_M(ch7_txdapicodereset_m),
      .CH3_TXDATAEXTENDRSVD_M(ch7_txdataextendrsvd_m),
      .CH3_TXDATA_M         (ch7_txdata_m),
      .CH3_TXDEEMPH_M       (ch7_txdeemph_m),
      .CH3_TXDETECTRX_M     (ch7_txdetectrx_m),
      .CH3_TXDIFFCTRL_M     (ch7_txdiffctrl_m),
      .CH3_TXDLYALIGNREQ_M  (ch7_txdlyalignreq_m),
      .CH3_TXELECIDLE_M     (ch7_txelecidle_m),
      .CH3_TXHEADER_M       (ch7_txheader_m),
      .CH3_TXINHIBIT_M      (ch7_txinhibit_m),
      .CH3_TXLATCLK_M       (ch7_txlatclk_m),
      .CH3_TXMAINCURSOR_M   (ch7_txmaincursor_m),
      .CH3_TXMARGIN_M       (ch7_txmargin_m),
      .CH3_TXMLDCHAINDONE_M (ch7_txmldchaindone_m),
      .CH3_TXMLDCHAINREQ_M  (ch7_txmldchainreq_m),
      .CH3_TXONESZEROS_M    (ch7_txoneszeros_m),
      .CH3_TXPAUSEDELAYALIGN_M(ch7_txpausedelayalign_m),
      .CH3_TXPCSRESETMASK_M (ch7_txpcsresetmask_m),
      .CH3_TXPD_M           (ch7_txpd_m),
      .CH3_TXPHALIGNREQ_M   (ch7_txphalignreq_m),
      .CH3_TXPHALIGNRESETMASK_M(ch7_txphalignresetmask_m),
      .CH3_TXPHDLYPD_M      (ch7_txphdlypd_m),
      .CH3_TXPHDLYRESET_M   (ch7_txphdlyreset_m),
      .CH3_TXPHDLYTSTCLK_M  (ch7_txphdlytstclk_m),
      .CH3_TXPHSETINITREQ_M (ch7_txphsetinitreq_m),
      .CH3_TXPHSHIFT180_M   (ch7_txphshift180_m),
      .CH3_TXPICODEOVRDEN_M (ch7_txpicodeovrden_m),
      .CH3_TXPICODERESET_M  (ch7_txpicodereset_m),
      .CH3_TXPIPPMEN_M      (ch7_txpippmen_m),
      .CH3_TXPIPPMSTEPSIZE_M(ch7_txpippmstepsize_m),
      .CH3_TXPISOPD_M       (ch7_txpisopd_m),
      .CH3_TXPMARESETMASK_M (ch7_txpmaresetmask_m),
      .CH3_TXPOLARITY_M     (ch7_txpolarity_m),
      .CH3_TXPOSTCURSOR_M   (ch7_txpostcursor_m),
      .CH3_TXPRBSFORCEERR_M (ch7_txprbsforceerr_m),
      .CH3_TXPRBSSEL_M      (ch7_txprbssel_m),
      .CH3_TXPRECURSOR_M    (ch7_txprecursor_m),
      .CH3_TXPROGDIVRESET_M (ch7_txprogdivreset_m),
      .CH3_TXRATE_M         (ch7_txrate_m),
      .CH3_TXRESETMODE_M    (ch7_txresetmode_m),
      .CH3_TXSEQUENCE_M     (ch7_txsequence_m),
      .CH3_TXSWING_M        (ch7_txswing_m),
      .CH3_TXSYNCALLIN_M    (ch7_txsyncallin_m),
      .CH3_TXUSERRDY_M      (ch7_txuserrdy_m),
      .CH3_TXUSRCLK_M       (ch7_txusrclk_m),

      .CTRLRSVDIN0_M(q1_ctrlrsvdin0_m),
      .CTRLRSVDIN1_M(q1_ctrlrsvdin1_m),

      .DEBUGTRACECLK_M  (q1_debugtraceclk_m),
      .DEBUGTRACEREADY_M(q1_debugtracetready_m),
      .GPI_M(q1_gpi_m),
    //.HSCLK0_GTGREFCLK2LCPLL_M  (q1_hsclk0_gtgrefclk2lcpll_m),
    //.HSCLK0_GTGREFCLK2RPLL_M   (q1_hsclk0_gtgrefclk2rpll_m),
      .HSCLK0_LCPLLCLKRSVD0_M    (q1_hsclk0_lcpllclkrsvd0_m),
      .HSCLK0_LCPLLCLKRSVD1_M    (q1_hsclk0_lcpllclkrsvd1_m),
      .HSCLK0_LCPLLFBDIV_M       (q1_hsclk0_lcpllfbdiv_m),
      .HSCLK0_LCPLLPD_M          (q1_hsclk0_lcpllpd_m),
      .HSCLK0_LCPLLREFCLKSEL_M   (q1_hsclk0_lcpllrefclksel_m),
      .HSCLK0_LCPLLRESETBYPASSMODE_M(q1_hsclk0_lcpllresetbypassmode_m),
      .HSCLK0_LCPLLRESETMASK_M   (q1_hsclk0_lcpllresetmask_m),
      .HSCLK0_LCPLLRESET_M       (q1_hsclk0_lcpllreset_m),
      .HSCLK0_LCPLLRSVD0_M       (q1_hsclk0_lcpllrsvd0_m),
      .HSCLK0_LCPLLRSVD1_M       (q1_hsclk0_lcpllrsvd1_m),
      .HSCLK0_LCPLLSDMDATA_M     (q1_hsclk0_lcpllsdmdata_m),
      .HSCLK0_LCPLLSDMTOGGLE_M   (q1_hsclk0_lcpllsdmtoggle_m),
      .HSCLK0_RPLLCLKRSVD0_M     (q1_hsclk0_rpllclkrsvd0_m),
      .HSCLK0_RPLLCLKRSVD1_M     (q1_hsclk0_rpllclkrsvd1_m),
      .HSCLK0_RPLLFBDIV_M        (q1_hsclk0_rpllfbdiv_m),
      .HSCLK0_RPLLPD_M           (q1_hsclk0_rpllpd_m),
      .HSCLK0_RPLLREFCLKSEL_M    (q1_hsclk0_rpllrefclksel_m),
      .HSCLK0_RPLLRESETBYPASSMODE_M(q1_hsclk0_rpllresetbypassmode_m),
      .HSCLK0_RPLLRESETMASK_M    (q1_hsclk0_rpllresetmask_m),
      .HSCLK0_RPLLRESET_M        (q1_hsclk0_rpllreset_m),
      .HSCLK0_RPLLRSVD0_M        (q1_hsclk0_rpllrsvd0_m),
      .HSCLK0_RPLLRSVD1_M        (q1_hsclk0_rpllrsvd1_m),
      .HSCLK0_RPLLSDMDATA_M      (q1_hsclk0_rpllsdmdata_m),
      .HSCLK0_RPLLSDMTOGGLE_M    (q1_hsclk0_rpllsdmtoggle_m),
    //.HSCLK1_GTGREFCLK2LCPLL_M  (q1_hsclk1_gtgrefclk2lcpll_m),
    //.HSCLK1_GTGREFCLK2RPLL_M   (q1_hsclk1_gtgrefclk2rpll_m),
      .HSCLK1_LCPLLCLKRSVD0_M    (q1_hsclk1_lcpllclkrsvd0_m),
      .HSCLK1_LCPLLCLKRSVD1_M    (q1_hsclk1_lcpllclkrsvd1_m),
      .HSCLK1_LCPLLFBDIV_M       (q1_hsclk1_lcpllfbdiv_m),
      .HSCLK1_LCPLLPD_M          (q1_hsclk1_lcpllpd_m),
      .HSCLK1_LCPLLREFCLKSEL_M   (q1_hsclk1_lcpllrefclksel_m),
      .HSCLK1_LCPLLRESETBYPASSMODE_M(q1_hsclk1_lcpllresetbypassmode_m),
      .HSCLK1_LCPLLRESETMASK_M   (q1_hsclk1_lcpllresetmask_m),
      .HSCLK1_LCPLLRESET_M       (q1_hsclk1_lcpllreset_m),
      .HSCLK1_LCPLLRSVD0_M       (q1_hsclk1_lcpllrsvd0_m),
      .HSCLK1_LCPLLRSVD1_M       (q1_hsclk1_lcpllrsvd1_m),
      .HSCLK1_LCPLLSDMDATA_M     (q1_hsclk1_lcpllsdmdata_m),
      .HSCLK1_LCPLLSDMTOGGLE_M   (q1_hsclk1_lcpllsdmtoggle_m),
      .HSCLK1_RPLLCLKRSVD0_M     (q1_hsclk1_rpllclkrsvd0_m),
      .HSCLK1_RPLLCLKRSVD1_M     (q1_hsclk1_rpllclkrsvd1_m),
      .HSCLK1_RPLLFBDIV_M        (q1_hsclk1_rpllfbdiv_m),
      .HSCLK1_RPLLPD_M           (q1_hsclk1_rpllpd_m),
      .HSCLK1_RPLLREFCLKSEL_M    (q1_hsclk1_rpllrefclksel_m),
      .HSCLK1_RPLLRESETBYPASSMODE_M(q1_hsclk1_rpllresetbypassmode_m),
      .HSCLK1_RPLLRESETMASK_M    (q1_hsclk1_rpllresetmask_m),
      .HSCLK1_RPLLRESET_M        (q1_hsclk1_rpllreset_m),
      .HSCLK1_RPLLRSVD0_M        (q1_hsclk1_rpllrsvd0_m),
      .HSCLK1_RPLLRSVD1_M        (q1_hsclk1_rpllrsvd1_m),
      .HSCLK1_RPLLSDMDATA_M      (q1_hsclk1_rpllsdmdata_m),
      .HSCLK1_RPLLSDMTOGGLE_M    (q1_hsclk1_rpllsdmtoggle_m),

      .M0_AXIS_TREADY_M (s3_axis_tready_m),
      .M1_AXIS_TREADY_M (s4_axis_tready_m),
      .M2_AXIS_TREADY_M (s5_axis_tready_m),

      .MSTRXRESET_M         ({ch7_mstrxreset_m,ch6_mstrxreset_m,ch5_mstrxreset_m,ch4_mstrxreset_m}),
      .MSTTXRESET_M         ({ch7_msttxreset_m,ch6_msttxreset_m,ch5_msttxreset_m,ch4_msttxreset_m}),
      .PCIELINKREACHTARGET_M(q1_pcielinkreachtarget_m),
      .PCIELTSSM_M          (q1_pcieltssm_m),
      .RCALENB_M            (q1_rcalenb_m),
    //.REFCLK0_CEB_M        (q1_refclk0_ceb_m),
      .REFCLK0_CLKTESTSIG_M (q1_refclk0_clktestsig_m),
      .REFCLK0_GTREFCLKPD_M (q1_refclk0_gtrefclkpd_m),
    //.REFCLK1_CEB_M        (q1_refclk1_ceb_m),
      .REFCLK1_CLKTESTSIG_M (q1_refclk1_clktestsig_m),
      .REFCLK1_GTREFCLKPD_M (q1_refclk1_gtrefclkpd_m),
      .RXMARGINREQCMD_M     (q1_rxmarginreqcmd_m),
      .RXMARGINREQLANENUM_M (q1_rxmarginreqlanenum_m),
      .RXMARGINREQPAYLD_M   (q1_rxmarginreqpayld_m),
      .RXMARGINREQREQ_M     (q1_rxmarginreqreq_m),
      .RXMARGINRESACK_M     (q1_rxmarginresack_m),

      .S0_AXIS_TDATA_M  (m3_axis_tdata_m),
      .S0_AXIS_TLAST_M  (m3_axis_tlast_m),
      .S0_AXIS_TVALID_M (m3_axis_tvalid_m),
      .S1_AXIS_TDATA_M  (m4_axis_tdata_m),
      .S1_AXIS_TLAST_M  (m4_axis_tlast_m),
      .S1_AXIS_TVALID_M (m4_axis_tvalid_m),
      .S2_AXIS_TDATA_M  (m5_axis_tdata_m),
      .S2_AXIS_TLAST_M  (m5_axis_tlast_m),
      .S2_AXIS_TVALID_M (m5_axis_tvalid_m),

      .TRIGACKOUT0_M           (q1_trigackout0_m),
      .TRIGIN0_M               (q1_trigin0_m),
      .UBENABLE_M              (q1_ubenable_m),
      .UBINTR_M                (q1_ubintr_m),
      .UBIOLMBRST_M            (q1_ubiolmbrst_m),
      .UBMBRST_M               (q1_ubmbrst_m),
      .UBRXUART_M              (q1_ubrxuart_m),
      .APB3PRDATA_M            (q1_apb3prdata_m),
      .APB3PREADY_M            (q1_apb3pready_m),
      .APB3PSLVERR_M           (q1_apb3pslverr_m),
      .CH0_BUFGTCEMASK_M       (ch4_bufgtcemask_m),
      .CH0_BUFGTCE_M           (ch4_bufgtce_m),
      .CH0_BUFGTDIV_M          (ch4_bufgtdiv_m),
      .CH0_BUFGTRSTMASK_M      (ch4_bufgtrstmask_m),
      .CH0_BUFGTRST_M          (ch4_bufgtrst_m),
    //.CH0_CFOKOVWRRDY0_M      (ch4_cfokovwrrdy0_m),
    //.CH0_CFOKOVWRRDY1_M      (ch4_cfokovwrrdy1_m),
      .CH0_DMONITOROUT_M       (ch4_dmonitorout_m),
      .CH0_EYESCANDATAERROR_M  (ch4_eyescandataerror_m),
      .CH0_ILORESETDONE_M      (ch4_iloresetdone_m),
      .CH0_PCSRSVDOUT_M        (ch4_pcsrsvdout_m),
      .CH0_PINRSVDAS_M         (ch4_pinrsvdas_m),
      .CH0_PHYREADY_M          (ch4_phyready_m),
      .CH0_PHYSTATUS_M         (ch4_phystatus_m),
    //.CH0_PINRSRVDAS_M        (ch4_pinrsrvdas_m),
      .CH0_RESETEXCEPTION_M    (ch4_resetexception_m),
      .CH0_RX10GSTAT_M         (ch4_rx10gstat_m),
      .CH0_RXBUFSTATUS_M       (ch4_rxbufstatus_m),
      .CH0_RXBYTEISALIGNED_M   (ch4_rxbyteisaligned_m),
      .CH0_RXBYTEREALIGN_M     (ch4_rxbyterealign_m),
      .CH0_RXCDRLOCK_M         (ch4_rxcdrlock_m),
      .CH0_RXCDRPHDONE_M       (ch4_rxcdrphdone_m),
      .CH0_RXCHANBONDSEQ_M     (ch4_rxchanbondseq_m),
      .CH0_RXCHANISALIGNED_M   (ch4_rxchanisaligned_m),
      .CH0_RXCHANREALIGN_M     (ch4_rxchanrealign_m),
      .CH0_RXCHBONDO_M         (ch4_rxchbondo_m),
      .CH0_RXCLKCORCNT_M       (ch4_rxclkcorcnt_m),
      .CH0_RXCOMINITDET_M      (ch4_rxcominitdet_m),
      .CH0_RXCOMMADET_M        (ch4_rxcommadet_m),
      .CH0_RXCOMSASDET_M       (ch4_rxcomsasdet_m),
      .CH0_RXCOMWAKEDET_M      (ch4_rxcomwakedet_m),
      .CH0_RXCTRL0_M           (ch4_rxctrl0_m),
      .CH0_RXCTRL1_M           (ch4_rxctrl1_m),
      .CH0_RXCTRL2_M           (ch4_rxctrl2_m),
      .CH0_RXCTRL3_M           (ch4_rxctrl3_m),
      .CH0_RXDATAEXTENDRSVD_M  (ch4_rxdataextendrsvd_m),
      .CH0_RXDATAVALID_M       (ch4_rxdatavalid_m),
      .CH0_RXDATA_M            (ch4_rxdata_m),
      .CH0_RXDCCDONE_M         (ch4_rxdccdone_m),
      .CH0_RXDLYALIGNERR_M     (ch4_rxdlyalignerr_m),
      .CH0_RXDLYALIGNPROG_M    (ch4_rxdlyalignprog_m),
      .CH0_RXELECIDLE_M        (ch4_rxelecidle_m),
      .CH0_RXFINEALIGNDONE_M   (ch4_rxfinealigndone_m),
      .CH0_RXHEADERVALID_M     (ch4_rxheadervalid_m),
      .CH0_RXHEADER_M          (ch4_rxheader_m),
      .CH0_RXOSINTDONE_M       (ch4_rxosintdone_m),
      .CH0_RXOSINTSTARTED_M    (ch4_rxosintstarted_m),
      .CH0_RXOSINTSTROBEDONE_M (ch4_rxosintstrobedone_m),
      .CH0_RXOSINTSTROBESTARTED_M(ch4_rxosintstrobestarted_m),
      .CH0_RXPHALIGNDONE_M     (ch4_rxphaligndone_m),
      .CH0_RXPHALIGNERR_M      (ch4_rxphalignerr_m),
      .CH0_RXPHDLYRESETDONE_M  (ch4_rxphdlyresetdone_m),
      .CH0_RXPHSETINITDONE_M   (ch4_rxphsetinitdone_m),
      .CH0_RXPHSHIFT180DONE_M  (ch4_rxphshift180done_m),
      .CH0_RXPMARESETDONE_M    (ch4_rxpmaresetdone_m),
      .CH0_RXPRBSERR_M         (ch4_rxprbserr_m),
      .CH0_RXPRBSLOCKED_M      (ch4_rxprbslocked_m),
    //.CH0_RXPRGDIVRESETDONE_M (ch4_rxprgdivresetdone_m),
      .CH0_RXRESETDONE_M       (ch4_rxresetdone_m),
      .CH0_RXSLIDERDY_M        (ch4_rxsliderdy_m),
      .CH0_RXSTARTOFSEQ_M      (ch4_rxstartofseq_m),
      .CH0_RXSTATUS_M          (ch4_rxstatus_m),
      .CH0_RXSYNCDONE_M        (ch4_rxsyncdone_m),
      .CH0_RXVALID_M           (ch4_rxvalid_m),

      .CH0_TSTCLK0_M(ch4_tstclk0_m),
      .CH0_TSTCLK1_M(ch4_tstclk1_m),
      .CH1_TSTCLK0_M(ch5_tstclk0_m),
      .CH1_TSTCLK1_M(ch5_tstclk1_m),
      .CH2_TSTCLK0_M(ch6_tstclk0_m),
      .CH2_TSTCLK1_M(ch6_tstclk1_m),
      .CH3_TSTCLK0_M(ch7_tstclk0_m),
      .CH3_TSTCLK1_M(ch7_tstclk1_m),

      .CH0_TX10GSTAT_M        (ch4_tx10gstat_m),
      .CH0_TXBUFSTATUS_M      (ch4_txbufstatus_m),
      .CH0_TXCOMFINISH_M      (ch4_txcomfinish_m),
      .CH0_TXDCCDONE_M        (ch4_txdccdone_m),
      .CH0_TXDLYALIGNERR_M    (ch4_txdlyalignerr_m),
      .CH0_TXDLYALIGNPROG_M   (ch4_txdlyalignprog_m),
      .CH0_TXOUTCLK_M         (ch4_txoutclk_m),
      .CH0_TXPHALIGNDONE_M    (ch4_txphaligndone_m),
      .CH0_TXPHALIGNERR_M     (ch4_txphalignerr_m),
      .CH0_TXPHALIGNOUTRSVD_M (ch4_txphalignoutrsvd_m),
      .CH0_TXPHDLYRESETDONE_M (ch4_txphdlyresetdone_m),
      .CH0_TXPHSETINITDONE_M  (ch4_txphsetinitdone_m),
      .CH0_CFOKOVRDFINISH_M   (ch4_cfokovrdfinish_m),

      .CH0_CFOKOVRDSTART_M  (ch4_cfokovrdstart_m),
      .CH1_CFOKOVRDSTART_M  (ch5_cfokovrdstart_m),
      .CH2_CFOKOVRDSTART_M  (ch6_cfokovrdstart_m),
      .CH3_CFOKOVRDSTART_M  (ch7_cfokovrdstart_m),
      .CH1_CFOKOVRDFINISH_M (ch5_cfokovrdfinish_m),
      .CH2_CFOKOVRDFINISH_M (ch6_cfokovrdfinish_m),
      .CH3_CFOKOVRDFINISH_M (ch7_cfokovrdfinish_m),
      .CH0_CFOKOVRDPULSE_M  (ch4_cfokovrdpulse_m),
      .CH1_CFOKOVRDPULSE_M  (ch5_cfokovrdpulse_m),
      .CH2_CFOKOVRDPULSE_M  (ch6_cfokovrdpulse_m),
      .CH3_CFOKOVRDPULSE_M  (ch7_cfokovrdpulse_m),
      .CH0_CFOKOVRDRDY0_M   (ch4_cfokovrdrdy0_m),
      .CH0_CFOKOVRDRDY1_M   (ch4_cfokovrdrdy1_m),
      .CH1_CFOKOVRDRDY0_M   (ch5_cfokovrdrdy0_m),
      .CH1_CFOKOVRDRDY1_M   (ch5_cfokovrdrdy1_m),
      .CH2_CFOKOVRDRDY0_M   (ch6_cfokovrdrdy0_m),
      .CH2_CFOKOVRDRDY1_M   (ch6_cfokovrdrdy1_m),
      .CH3_CFOKOVRDRDY0_M   (ch7_cfokovrdrdy0_m),
      .CH3_CFOKOVRDRDY1_M   (ch7_cfokovrdrdy1_m),
      .CH0_TXPHSHIFT180DONE_M(ch4_txphshift180done_m),
      .CH0_TXPMARESETDONE_M (ch4_txpmaresetdone_m),
    //.CH0_TXPRGDIVRESETDONE_M(ch4_txprgdivresetdone_m),
      .CH0_TXRESETDONE_M    (ch4_txresetdone_m),
      .CH0_TXSYNCDONE_M     (ch4_txsyncdone_m),
      .CH1_BUFGTCEMASK_M    (ch5_bufgtcemask_m),
      .CH1_BUFGTCE_M        (ch5_bufgtce_m),
      .CH1_BUFGTDIV_M       (ch5_bufgtdiv_m),
      .CH1_BUFGTRSTMASK_M   (ch5_bufgtrstmask_m),
      .CH1_BUFGTRST_M       (ch5_bufgtrst_m),
    //.CH1_CFOKOVWRRDY0_M   (ch5_cfokovwrrdy0_m),
    //.CH1_CFOKOVWRRDY1_M   (ch5_cfokovwrrdy1_m),
      .CH1_DMONITOROUT_M    (ch5_dmonitorout_m),
      .CH1_EYESCANDATAERROR_M(ch5_eyescandataerror_m),
      .CH1_ILORESETDONE_M   (ch5_iloresetdone_m),
      .CH1_PCSRSVDOUT_M     (ch5_pcsrsvdout_m),
      .CH1_PINRSVDAS_M      (ch5_pinrsvdas_m),
      .CH1_PHYREADY_M       (ch5_phyready_m),
      .CH1_PHYSTATUS_M      (ch5_phystatus_m),
    //.CH1_PINRSRVDAS_M     (ch5_pinrsrvdas_m),
      .CH1_RESETEXCEPTION_M (ch5_resetexception_m),
      .CH1_RX10GSTAT_M      (ch5_rx10gstat_m),
      .CH1_RXBUFSTATUS_M    (ch5_rxbufstatus_m),
      .CH1_RXBYTEISALIGNED_M(ch5_rxbyteisaligned_m),
      .CH1_RXBYTEREALIGN_M  (ch5_rxbyterealign_m),
      .CH1_RXCDRLOCK_M      (ch5_rxcdrlock_m),
      .CH1_RXCDRPHDONE_M    (ch5_rxcdrphdone_m),
      .CH1_RXCHANBONDSEQ_M  (ch5_rxchanbondseq_m),
      .CH1_RXCHANISALIGNED_M(ch5_rxchanisaligned_m),
      .CH1_RXCHANREALIGN_M  (ch5_rxchanrealign_m),
      .CH1_RXCHBONDO_M      (ch5_rxchbondo_m),
      .CH1_RXCLKCORCNT_M    (ch5_rxclkcorcnt_m),
      .CH1_RXCOMINITDET_M   (ch5_rxcominitdet_m),
      .CH1_RXCOMMADET_M     (ch5_rxcommadet_m),
      .CH1_RXCOMSASDET_M    (ch5_rxcomsasdet_m),
      .CH1_RXCOMWAKEDET_M   (ch5_rxcomwakedet_m),
      .CH1_RXCTRL0_M        (ch5_rxctrl0_m),
      .CH1_RXCTRL1_M        (ch5_rxctrl1_m),
      .CH1_RXCTRL2_M        (ch5_rxctrl2_m),
      .CH1_RXCTRL3_M        (ch5_rxctrl3_m),
      .CH1_RXDATAEXTENDRSVD_M(ch5_rxdataextendrsvd_m),
      .CH1_RXDATAVALID_M    (ch5_rxdatavalid_m),
      .CH1_RXDATA_M         (ch5_rxdata_m),
      .CH1_RXDCCDONE_M      (ch5_rxdccdone_m),
      .CH1_RXDLYALIGNERR_M  (ch5_rxdlyalignerr_m),
      .CH1_RXDLYALIGNPROG_M (ch5_rxdlyalignprog_m),
      .CH1_RXELECIDLE_M     (ch5_rxelecidle_m),
      .CH1_RXFINEALIGNDONE_M(ch5_rxfinealigndone_m),
      .CH1_RXHEADERVALID_M  (ch5_rxheadervalid_m),
      .CH1_RXHEADER_M       (ch5_rxheader_m),
      .CH1_RXOSINTDONE_M    (ch5_rxosintdone_m),
      .CH1_RXOSINTSTARTED_M (ch5_rxosintstarted_m),
      .CH1_RXOSINTSTROBEDONE_M(ch5_rxosintstrobedone_m),
      .CH1_RXOSINTSTROBESTARTED_M(ch5_rxosintstrobestarted_m),
      .CH1_RXPHALIGNDONE_M  (ch5_rxphaligndone_m),
      .CH1_RXPHALIGNERR_M   (ch5_rxphalignerr_m),
      .CH1_RXPHDLYRESETDONE_M(ch5_rxphdlyresetdone_m),
      .CH1_RXPHSETINITDONE_M(ch5_rxphsetinitdone_m),
      .CH1_RXPHSHIFT180DONE_M(ch5_rxphshift180done_m),
      .CH1_RXPMARESETDONE_M (ch5_rxpmaresetdone_m),
      .CH1_RXPRBSERR_M      (ch5_rxprbserr_m),
      .CH1_RXPRBSLOCKED_M   (ch5_rxprbslocked_m),
    //.CH1_RXPRGDIVRESETDONE_M(ch5_rxprgdivresetdone_m),
      .CH1_RXRESETDONE_M    (ch5_rxresetdone_m),
      .CH1_RXSLIDERDY_M     (ch5_rxsliderdy_m),
      .CH1_RXSTARTOFSEQ_M   (ch5_rxstartofseq_m),
      .CH1_RXSTATUS_M       (ch5_rxstatus_m),
      .CH1_RXSYNCDONE_M     (ch5_rxsyncdone_m),
      .CH1_RXVALID_M        (ch5_rxvalid_m),
      .CH1_TX10GSTAT_M      (ch5_tx10gstat_m),
      .CH1_TXBUFSTATUS_M    (ch5_txbufstatus_m),
      .CH1_TXCOMFINISH_M    (ch5_txcomfinish_m),
      .CH1_TXDCCDONE_M      (ch5_txdccdone_m),
      .CH1_TXDLYALIGNERR_M  (ch5_txdlyalignerr_m),
      .CH1_TXDLYALIGNPROG_M (ch5_txdlyalignprog_m),
      .CH1_TXPHALIGNDONE_M  (ch5_txphaligndone_m),
      .CH1_TXPHALIGNERR_M   (ch5_txphalignerr_m),
      .CH1_TXPHALIGNOUTRSVD_M(ch5_txphalignoutrsvd_m),
      .CH1_TXPHDLYRESETDONE_M(ch5_txphdlyresetdone_m),
      .CH1_TXPHSETINITDONE_M(ch5_txphsetinitdone_m),
      .CH1_TXPHSHIFT180DONE_M(ch5_txphshift180done_m),
      .CH1_TXPMARESETDONE_M (ch5_txpmaresetdone_m),
    //.CH1_TXPRGDIVRESETDONE_M(ch5_txprgdivresetdone_m),
      .CH1_TXRESETDONE_M    (ch5_txresetdone_m),
      .CH1_TXSYNCDONE_M     (ch5_txsyncdone_m),
      .CH2_BUFGTCEMASK_M    (ch6_bufgtcemask_m),
      .CH2_BUFGTCE_M        (ch6_bufgtce_m),
      .CH2_BUFGTDIV_M       (ch6_bufgtdiv_m),
      .CH2_BUFGTRSTMASK_M   (ch6_bufgtrstmask_m),
      .CH2_BUFGTRST_M       (ch6_bufgtrst_m),
    //.CH2_CFOKOVWRRDY0_M   (ch6_cfokovwrrdy0_m),
    //.CH2_CFOKOVWRRDY1_M   (ch6_cfokovwrrdy1_m),
      .CH2_DMONITOROUT_M    (ch6_dmonitorout_m),
      .CH2_EYESCANDATAERROR_M(ch6_eyescandataerror_m),
      .CH2_ILORESETDONE_M   (ch6_iloresetdone_m),
      .CH2_PCSRSVDOUT_M     (ch6_pcsrsvdout_m),
      .CH2_PINRSVDAS_M      (ch6_pinrsvdas_m),
      .CH2_PHYREADY_M       (ch6_phyready_m),
      .CH2_PHYSTATUS_M      (ch6_phystatus_m),
    //.CH2_PINRSRVDAS_M     (ch6_pinrsrvdas_m),
      .CH2_RESETEXCEPTION_M (ch6_resetexception_m),
      .CH2_RX10GSTAT_M      (ch6_rx10gstat_m),
      .CH2_RXBUFSTATUS_M    (ch6_rxbufstatus_m),
      .CH2_RXBYTEISALIGNED_M(ch6_rxbyteisaligned_m),
      .CH2_RXBYTEREALIGN_M  (ch6_rxbyterealign_m),
      .CH2_RXCDRLOCK_M      (ch6_rxcdrlock_m),
      .CH2_RXCDRPHDONE_M    (ch6_rxcdrphdone_m),
      .CH2_RXCHANBONDSEQ_M  (ch6_rxchanbondseq_m),
      .CH2_RXCHANISALIGNED_M(ch6_rxchanisaligned_m),
      .CH2_RXCHANREALIGN_M  (ch6_rxchanrealign_m),
      .CH2_RXCHBONDO_M      (ch6_rxchbondo_m),
      .CH2_RXCLKCORCNT_M    (ch6_rxclkcorcnt_m),
      .CH2_RXCOMINITDET_M   (ch6_rxcominitdet_m),
      .CH2_RXCOMMADET_M     (ch6_rxcommadet_m),
      .CH2_RXCOMSASDET_M    (ch6_rxcomsasdet_m),
      .CH2_RXCOMWAKEDET_M   (ch6_rxcomwakedet_m),
      .CH2_RXCTRL0_M        (ch6_rxctrl0_m),
      .CH2_RXCTRL1_M        (ch6_rxctrl1_m),
      .CH2_RXCTRL2_M        (ch6_rxctrl2_m),
      .CH2_RXCTRL3_M        (ch6_rxctrl3_m),
      .CH2_RXDATAEXTENDRSVD_M(ch6_rxdataextendrsvd_m),
      .CH2_RXDATAVALID_M    (ch6_rxdatavalid_m),
      .CH2_RXDATA_M         (ch6_rxdata_m),
      .CH2_RXDCCDONE_M      (ch6_rxdccdone_m),
      .CH2_RXDLYALIGNERR_M  (ch6_rxdlyalignerr_m),
      .CH2_RXDLYALIGNPROG_M (ch6_rxdlyalignprog_m),
      .CH2_RXELECIDLE_M     (ch6_rxelecidle_m),
      .CH2_RXFINEALIGNDONE_M(ch6_rxfinealigndone_m),
      .CH2_RXHEADERVALID_M  (ch6_rxheadervalid_m),
      .CH2_RXHEADER_M       (ch6_rxheader_m),
      .CH2_RXOSINTDONE_M    (ch6_rxosintdone_m),
      .CH2_RXOSINTSTARTED_M (ch6_rxosintstarted_m),
      .CH2_RXOSINTSTROBEDONE_M(ch6_rxosintstrobedone_m),
      .CH2_RXOSINTSTROBESTARTED_M(ch6_rxosintstrobestarted_m),
      .CH2_RXPHALIGNDONE_M  (ch6_rxphaligndone_m),
      .CH2_RXPHALIGNERR_M   (ch6_rxphalignerr_m),
      .CH2_RXPHDLYRESETDONE_M(ch6_rxphdlyresetdone_m),
      .CH2_RXPHSETINITDONE_M(ch6_rxphsetinitdone_m),
      .CH2_RXPHSHIFT180DONE_M(ch6_rxphshift180done_m),
      .CH2_RXPMARESETDONE_M (ch6_rxpmaresetdone_m),
      .CH2_RXPRBSERR_M      (ch6_rxprbserr_m),
      .CH2_RXPRBSLOCKED_M   (ch6_rxprbslocked_m),
    //.CH2_RXPRGDIVRESETDONE_M(ch6_rxprgdivresetdone_m),
      .CH2_RXRESETDONE_M    (ch6_rxresetdone_m),
      .CH2_RXSLIDERDY_M     (ch6_rxsliderdy_m),
      .CH2_RXSTARTOFSEQ_M   (ch6_rxstartofseq_m),
      .CH2_RXSTATUS_M       (ch6_rxstatus_m),
      .CH2_RXSYNCDONE_M     (ch6_rxsyncdone_m),
      .CH2_RXVALID_M        (ch6_rxvalid_m),
      .CH2_TX10GSTAT_M      (ch6_tx10gstat_m),
      .CH2_TXBUFSTATUS_M    (ch6_txbufstatus_m),
      .CH2_TXCOMFINISH_M    (ch6_txcomfinish_m),
      .CH2_TXDCCDONE_M      (ch6_txdccdone_m),
      .CH2_TXDLYALIGNERR_M  (ch6_txdlyalignerr_m),
      .CH2_TXDLYALIGNPROG_M (ch6_txdlyalignprog_m),
      .CH2_TXPHALIGNDONE_M  (ch6_txphaligndone_m),
      .CH2_TXPHALIGNERR_M   (ch6_txphalignerr_m),
      .CH2_TXPHALIGNOUTRSVD_M(ch6_txphalignoutrsvd_m),
      .CH2_TXPHDLYRESETDONE_M(ch6_txphdlyresetdone_m),
      .CH2_TXPHSETINITDONE_M(ch6_txphsetinitdone_m),
      .CH2_TXPHSHIFT180DONE_M(ch6_txphshift180done_m),
      .CH2_TXPMARESETDONE_M (ch6_txpmaresetdone_m),
    //.CH2_TXPRGDIVRESETDONE_M(ch6_txprgdivresetdone_m),
      .CH2_TXRESETDONE_M    (ch6_txresetdone_m),
      .CH2_TXSYNCDONE_M     (ch6_txsyncdone_m),
      .CH3_BUFGTCEMASK_M    (ch7_bufgtcemask_m),
      .CH3_BUFGTCE_M        (ch7_bufgtce_m),
      .CH3_BUFGTDIV_M       (ch7_bufgtdiv_m),
      .CH3_BUFGTRSTMASK_M   (ch7_bufgtrstmask_m),
      .CH3_BUFGTRST_M       (ch7_bufgtrst_m),
    //.CH3_CFOKOVWRRDY0_M   (ch7_cfokovwrrdy0_m),
    //.CH3_CFOKOVWRRDY1_M   (ch7_cfokovwrrdy1_m),
      .CH3_DMONITOROUT_M    (ch7_dmonitorout_m),
      .CH3_EYESCANDATAERROR_M(ch7_eyescandataerror_m),
      .CH3_ILORESETDONE_M   (ch7_iloresetdone_m),
      .CH3_PCSRSVDOUT_M     (ch7_pcsrsvdout_m),
      .CH3_PINRSVDAS_M      (ch7_pinrsvdas_m),
      .CH3_PHYREADY_M       (ch7_phyready_m),
      .CH3_PHYSTATUS_M      (ch7_phystatus_m),
    //.CH3_PINRSRVDAS_M     (ch7_pinrsrvdas_m),
      .CH3_RESETEXCEPTION_M (ch7_resetexception_m),
      .CH3_RX10GSTAT_M      (ch7_rx10gstat_m),
      .CH3_RXBUFSTATUS_M    (ch7_rxbufstatus_m),
      .CH3_RXBYTEISALIGNED_M(ch7_rxbyteisaligned_m),
      .CH3_RXBYTEREALIGN_M  (ch7_rxbyterealign_m),
      .CH3_RXCDRLOCK_M      (ch7_rxcdrlock_m),
      .CH3_RXCDRPHDONE_M    (ch7_rxcdrphdone_m),
      .CH3_RXCHANBONDSEQ_M  (ch7_rxchanbondseq_m),
      .CH3_RXCHANISALIGNED_M(ch7_rxchanisaligned_m),
      .CH3_RXCHANREALIGN_M  (ch7_rxchanrealign_m),
      .CH3_RXCHBONDO_M      (ch7_rxchbondo_m),
      .CH3_RXCLKCORCNT_M    (ch7_rxclkcorcnt_m),
      .CH3_RXCOMINITDET_M   (ch7_rxcominitdet_m),
      .CH3_RXCOMMADET_M     (ch7_rxcommadet_m),
      .CH3_RXCOMSASDET_M    (ch7_rxcomsasdet_m),
      .CH3_RXCOMWAKEDET_M   (ch7_rxcomwakedet_m),
      .CH3_RXCTRL0_M        (ch7_rxctrl0_m),
      .CH3_RXCTRL1_M        (ch7_rxctrl1_m),
      .CH3_RXCTRL2_M        (ch7_rxctrl2_m),
      .CH3_RXCTRL3_M        (ch7_rxctrl3_m),
      .CH3_RXDATAEXTENDRSVD_M(ch7_rxdataextendrsvd_m),
      .CH3_RXDATAVALID_M    (ch7_rxdatavalid_m),
      .CH3_RXDATA_M         (ch7_rxdata_m),
      .CH3_RXDCCDONE_M      (ch7_rxdccdone_m),
      .CH3_RXDLYALIGNERR_M  (ch7_rxdlyalignerr_m),
      .CH3_RXDLYALIGNPROG_M (ch7_rxdlyalignprog_m),
      .CH3_RXELECIDLE_M     (ch7_rxelecidle_m),
      .CH3_RXFINEALIGNDONE_M(ch7_rxfinealigndone_m),
      .CH3_RXHEADERVALID_M  (ch7_rxheadervalid_m),
      .CH3_RXHEADER_M       (ch7_rxheader_m),
      .CH3_RXOSINTDONE_M    (ch7_rxosintdone_m),
      .CH3_RXOSINTSTARTED_M (ch7_rxosintstarted_m),
      .CH3_RXOSINTSTROBEDONE_M(ch7_rxosintstrobedone_m),
      .CH3_RXOSINTSTROBESTARTED_M(ch7_rxosintstrobestarted_m),
      .CH3_RXPHALIGNDONE_M  (ch7_rxphaligndone_m),
      .CH3_RXPHALIGNERR_M   (ch7_rxphalignerr_m),
      .CH3_RXPHDLYRESETDONE_M(ch7_rxphdlyresetdone_m),
      .CH3_RXPHSETINITDONE_M(ch7_rxphsetinitdone_m),
      .CH3_RXPHSHIFT180DONE_M(ch7_rxphshift180done_m),
      .CH3_RXPMARESETDONE_M (ch7_rxpmaresetdone_m),
      .CH3_RXPRBSERR_M      (ch7_rxprbserr_m),
      .CH3_RXPRBSLOCKED_M   (ch7_rxprbslocked_m),
    //.CH3_RXPRGDIVRESETDONE_M(ch7_rxprgdivresetdone_m),
      .CH3_RXRESETDONE_M    (ch7_rxresetdone_m),
      .CH3_RXSLIDERDY_M     (ch7_rxsliderdy_m),
      .CH3_RXSTARTOFSEQ_M   (ch7_rxstartofseq_m),
      .CH3_RXSTATUS_M       (ch7_rxstatus_m),
      .CH3_RXSYNCDONE_M     (ch7_rxsyncdone_m),
      .CH3_RXVALID_M        (ch7_rxvalid_m),
      .CH3_TX10GSTAT_M      (ch7_tx10gstat_m),
      .CH3_TXBUFSTATUS_M    (ch7_txbufstatus_m),
      .CH3_TXCOMFINISH_M    (ch7_txcomfinish_m),
      .CH3_TXDCCDONE_M      (ch7_txdccdone_m),
      .CH3_TXDLYALIGNERR_M  (ch7_txdlyalignerr_m),
      .CH3_TXDLYALIGNPROG_M (ch7_txdlyalignprog_m),
      .CH3_TXPHALIGNDONE_M  (ch7_txphaligndone_m),
      .CH3_TXPHALIGNERR_M   (ch7_txphalignerr_m),
      .CH3_TXPHALIGNOUTRSVD_M(ch7_txphalignoutrsvd_m),
      .CH3_TXPHDLYRESETDONE_M(ch7_txphdlyresetdone_m),
      .CH3_TXPHSETINITDONE_M(ch7_txphsetinitdone_m),
      .CH3_TXPHSHIFT180DONE_M(ch7_txphshift180done_m),
      .CH3_TXPMARESETDONE_M (ch7_txpmaresetdone_m),
    //.CH3_TXPRGDIVRESETDONE_M(ch7_txprgdivresetdone_m),
      .CH3_TXRESETDONE_M    (ch7_txresetdone_m),
      .CH3_TXSYNCDONE_M     (ch7_txsyncdone_m),

      .CORRECTERR_M(q1_correcterr_m),
      .CTRLRSVDOUT_M(q1_ctrlrsvdout_m),
      .DEBUGTRACETDATA_M(q1_debugtracetdata_m),
      .DEBUGTRACETVALID_M(q1_debugtracetvalid_m),
      .GPO_M(q1_gpo_m),
      .GTPOWERGOOD_M(q1_gtpowergood_m),

      .HSCLK0_LCPLLFBCLKLOST_M    (q1_hsclk0_lcpllfbclklost_m),
      .HSCLK0_LCPLLLOCK_M         (q1_hsclk0_lcplllock_m),
      .HSCLK0_LCPLLREFCLKLOST_M   (q1_hsclk0_lcpllrefclklost_m),
      .HSCLK0_LCPLLREFCLKMONITOR_M(q1_hsclk0_lcpllrefclkmonitor_m),
      .HSCLK0_LCPLLRSVDOUT_M      (q1_hsclk0_lcpllrsvdout_m),
      .HSCLK0_RPLLFBCLKLOST_M     (q1_hsclk0_rpllfbclklost_m),
      .HSCLK0_RPLLLOCK_M          (q1_hsclk0_rplllock_m),
      .HSCLK0_RPLLREFCLKLOST_M    (q1_hsclk0_rpllrefclklost_m),
      .HSCLK0_RPLLREFCLKMONITOR_M (q1_hsclk0_rpllrefclkmonitor_m),
      .HSCLK0_RPLLRSVDOUT_M       (q1_hsclk0_rpllrsvdout_m),

      .HSCLK1_LCPLLFBCLKLOST_M    (q1_hsclk1_lcpllfbclklost_m),
      .HSCLK1_LCPLLLOCK_M         (q1_hsclk1_lcplllock_m),
      .HSCLK1_LCPLLREFCLKLOST_M   (q1_hsclk1_lcpllrefclklost_m),
      .HSCLK1_LCPLLREFCLKMONITOR_M(q1_hsclk1_lcpllrefclkmonitor_m),
      .HSCLK1_LCPLLRSVDOUT_M      (q1_hsclk1_lcpllrsvdout_m),
      .HSCLK1_RPLLFBCLKLOST_M     (q1_hsclk1_rpllfbclklost_m),
      .HSCLK1_RPLLLOCK_M          (q1_hsclk1_rplllock_m),
      .HSCLK1_RPLLREFCLKLOST_M    (q1_hsclk1_rpllrefclklost_m),
      .HSCLK1_RPLLREFCLKMONITOR_M (q1_hsclk1_rpllrefclkmonitor_m),
      .HSCLK1_RPLLRSVDOUT_M       (q1_hsclk1_rpllrsvdout_m),

      .M0_AXIS_TDATA_M  (s3_axis_tdata_m),
      .M0_AXIS_TLAST_M  (s3_axis_tlast_m),
      .M0_AXIS_TVALID_M (s3_axis_tvalid_m),

      .M1_AXIS_TDATA_M  (s4_axis_tdata_m),
      .M1_AXIS_TLAST_M  (s4_axis_tlast_m),
      .M1_AXIS_TVALID_M (s4_axis_tvalid_m),

      .M2_AXIS_TDATA_M  (s5_axis_tdata_m),
      .M2_AXIS_TLAST_M  (s5_axis_tlast_m),
      .M2_AXIS_TVALID_M (s5_axis_tvalid_m),

      .MSTRXRESETDONE_M ({ch7_mstrxresetdone_m,ch6_mstrxresetdone_m,ch5_mstrxresetdone_m,ch4_mstrxresetdone_m}),
      .MSTTXRESETDONE_M ({ch7_msttxresetdone_m,ch6_msttxresetdone_m,ch5_msttxresetdone_m,ch4_msttxresetdone_m}),

      .CH0_RXPROGDIVRESETDONE_M(ch4_rxprogdivresetdone_m),
      .CH1_RXPROGDIVRESETDONE_M(ch5_rxprogdivresetdone_m),
      .CH2_RXPROGDIVRESETDONE_M(ch6_rxprogdivresetdone_m),
      .CH3_RXPROGDIVRESETDONE_M(ch7_rxprogdivresetdone_m),
      .CH0_TXPROGDIVRESETDONE_M(ch4_txprogdivresetdone_m),
      .CH1_TXPROGDIVRESETDONE_M(ch5_txprogdivresetdone_m),
      .CH2_TXPROGDIVRESETDONE_M(ch6_txprogdivresetdone_m),
      .CH3_TXPROGDIVRESETDONE_M(ch7_txprogdivresetdone_m),

      .RXMARGINREQACK_M   (q1_rxmarginreqack_m),
      .RXMARGINRESCMD_M   (q1_rxmarginrescmd_m),
      .RXMARGINRESLANENUM_M(q1_rxmarginreslanenum_m),
      .RXMARGINRESPAYLD_M (q1_rxmarginrespayld_m),
      .RXMARGINRESREQ_M   (q1_rxmarginresreq_m),
      .S0_AXIS_TREADY_M   (m3_axis_tready_m),
      .S1_AXIS_TREADY_M   (m4_axis_tready_m),
      .S2_AXIS_TREADY_M   (m5_axis_tready_m),
      .TRIGACKIN0_M   (q1_trigackin0_m),
      .TRIGOUT0_M     (q1_trigout0_m),
      .UBINTERRUPT_M  (q1_ubinterrupt_m),
      .UBTXUART_M     (q1_ubtxuart_m),
      .UNCORRECTERR_M (q1_uncorrecterr_m),
      .RXMARGINCLK_M  (q1_rxmarginclk_m),

      .XPIPE_HSDP_RXGEARBOXSLIP   (q0q1_hsdp_xpipe_ch0_rxgearboxslip),
      .XPIPE_HSDP_RXPCSRESET      (q0q1_hsdp_xpipe_ch0_rxpcsreset),
      .XPIPE_HSDP_TXHEADER        (q0q1_hsdp_xpipe_ch0_txheader),
      .XPIPE_HSDP_TXSEQUENCE      (q0q1_hsdp_xpipe_ch0_txsequence),
      .XPIPE_HSDP_RXDATAVALID     (q0q1_hsdp_xpipe_ch0_rxdatavalid),
      .XPIPE_HSDP_RXHEADER        (q0q1_hsdp_xpipe_ch0_rxheader),
      .XPIPE_HSDP_RXRESETDONE     (q0q1_hsdp_xpipe_ch0_rxresetdone),
      .XPIPE_HSDP_TXRESETDONE     (q0q1_hsdp_xpipe_ch0_txresetdone),
      .XPIPE_HSDP_RXHEADERVALID   (q0q1_hsdp_xpipe_ch0_rxheadervalid),

      .XPIPE_HSDP_RXGEARBOXSLIP_1 (q0q1_hsdp_xpipe_ch1_rxgearboxslip),
      .XPIPE_HSDP_RXPCSRESET_1    (q0q1_hsdp_xpipe_ch1_rxpcsreset),
      .XPIPE_HSDP_TXHEADER_1      (q0q1_hsdp_xpipe_ch1_txheader),
      .XPIPE_HSDP_TXSEQUENCE_1    (q0q1_hsdp_xpipe_ch1_txsequence),
      .XPIPE_HSDP_RXDATAVALID_1   (q0q1_hsdp_xpipe_ch1_rxdatavalid),
      .XPIPE_HSDP_RXHEADER_1      (q0q1_hsdp_xpipe_ch1_rxheader),
      .XPIPE_HSDP_RXRESETDONE_1   (q0q1_hsdp_xpipe_ch1_rxresetdone),
      .XPIPE_HSDP_TXRESETDONE_1   (q0q1_hsdp_xpipe_ch1_txresetdone),
      .XPIPE_HSDP_RXHEADERVALID_1 (q0q1_hsdp_xpipe_ch1_rxheadervalid),

      .XPIPE_HSDP_RXGEARBOXSLIP_2 (q0q1_hsdp_xpipe_ch2_rxgearboxslip),
      .XPIPE_HSDP_RXPCSRESET_2    (q0q1_hsdp_xpipe_ch2_rxpcsreset),
      .XPIPE_HSDP_TXHEADER_2      (q0q1_hsdp_xpipe_ch2_txheader),
      .XPIPE_HSDP_TXSEQUENCE_2    (q0q1_hsdp_xpipe_ch2_txsequence),
      .XPIPE_HSDP_RXDATAVALID_2   (q0q1_hsdp_xpipe_ch2_rxdatavalid),
      .XPIPE_HSDP_RXHEADER_2      (q0q1_hsdp_xpipe_ch2_rxheader),
      .XPIPE_HSDP_RXRESETDONE_2   (q0q1_hsdp_xpipe_ch2_rxresetdone),
      .XPIPE_HSDP_TXRESETDONE_2   (q0q1_hsdp_xpipe_ch2_txresetdone),
      .XPIPE_HSDP_RXHEADERVALID_2 (q0q1_hsdp_xpipe_ch2_rxheadervalid),

      .XPIPE_HSDP_RXGEARBOXSLIP_M (q1q2_hsdp_xpipe_ch0_rxgearboxslip),
      .XPIPE_HSDP_RXPCSRESET_M    (q1q2_hsdp_xpipe_ch0_rxpcsreset),
      .XPIPE_HSDP_TXHEADER_M      (q1q2_hsdp_xpipe_ch0_txheader),
      .XPIPE_HSDP_TXSEQUENCE_M    (q1q2_hsdp_xpipe_ch0_txsequence),
      .XPIPE_HSDP_RXDATAVALID_M   (q1q2_hsdp_xpipe_ch0_rxdatavalid),
      .XPIPE_HSDP_RXHEADER_M      (q1q2_hsdp_xpipe_ch0_rxheader),
      .XPIPE_HSDP_RXRESETDONE_M   (q1q2_hsdp_xpipe_ch0_rxresetdone),
      .XPIPE_HSDP_TXRESETDONE_M   (q1q2_hsdp_xpipe_ch0_txresetdone),
      .XPIPE_HSDP_RXHEADERVALID_M (q1q2_hsdp_xpipe_ch0_rxheadervalid),

      .XPIPE_HSDP_RXGEARBOXSLIP_M_1(q1q2_hsdp_xpipe_ch1_rxgearboxslip),
      .XPIPE_HSDP_RXPCSRESET_M_1  (q1q2_hsdp_xpipe_ch1_rxpcsreset),
      .XPIPE_HSDP_TXHEADER_M_1    (q1q2_hsdp_xpipe_ch1_txheader),
      .XPIPE_HSDP_TXSEQUENCE_M_1  (q1q2_hsdp_xpipe_ch1_txsequence),
      .XPIPE_HSDP_RXDATAVALID_M_1 (q1q2_hsdp_xpipe_ch1_rxdatavalid),
      .XPIPE_HSDP_RXHEADER_M_1    (q1q2_hsdp_xpipe_ch1_rxheader),
      .XPIPE_HSDP_RXRESETDONE_M_1 (q1q2_hsdp_xpipe_ch1_rxresetdone),
      .XPIPE_HSDP_TXRESETDONE_M_1 (q1q2_hsdp_xpipe_ch1_txresetdone),
      .XPIPE_HSDP_RXHEADERVALID_M_1(q1q2_hsdp_xpipe_ch1_rxheadervalid),

      .XPIPE_HSDP_RXGEARBOXSLIP_M_2(q1q2_hsdp_xpipe_ch2_rxgearboxslip),
      .XPIPE_HSDP_RXPCSRESET_M_2  (q1q2_hsdp_xpipe_ch2_rxpcsreset),
      .XPIPE_HSDP_TXHEADER_M_2    (q1q2_hsdp_xpipe_ch2_txheader),
      .XPIPE_HSDP_TXSEQUENCE_M_2  (q1q2_hsdp_xpipe_ch2_txsequence),
      .XPIPE_HSDP_RXDATAVALID_M_2 (q1q2_hsdp_xpipe_ch2_rxdatavalid),
      .XPIPE_HSDP_RXHEADER_M_2    (q1q2_hsdp_xpipe_ch2_rxheader),
      .XPIPE_HSDP_RXRESETDONE_M_2 (q1q2_hsdp_xpipe_ch2_rxresetdone),
      .XPIPE_HSDP_TXRESETDONE_M_2 (q1q2_hsdp_xpipe_ch2_txresetdone),
      .XPIPE_HSDP_RXHEADERVALID_M_2(q1q2_hsdp_xpipe_ch2_rxheadervalid),

      .XPIPE_PCIELINKREACHTARGET  (q0q1_xpipe_pcielinkreachtarget_m),
      .XPIPE_PCIELTSSMSTATE       (q0q1_xpipe_pcieltssmstate_m),
      .XPIPE_PCIELINKREACHTARGET_1(q0q1_xpipe_pcielinkreachtarget_m_1),
      .XPIPE_PCIELTSSMSTATE_1     (q0q1_xpipe_pcieltssmstate_m_1),
      .XPIPE_RXMARGINREQCMD       (q0q1_xpipe_rxmarginreqcmd_m),
      .XPIPE_RXMARGINREQLANENUM   (q0q1_xpipe_rxmarginreqlanenum_m),
      .XPIPE_RXMARGINREQPAYLOAD   (q0q1_xpipe_rxmarginreqpayload_m),
      .XPIPE_RXMARGINREQREQ       (q0q1_xpipe_rxmarginreqreq_m),
      .XPIPE_RXMARGINRESACK       (q0q1_xpipe_rxmarginresack_m),
      .XPIPE_RXMARGINREQCMD_1     (q0q1_xpipe_rxmarginreqcmd_m_1),
      .XPIPE_RXMARGINREQLANENUM_1 (q0q1_xpipe_rxmarginreqlanenum_m_1),
      .XPIPE_RXMARGINREQPAYLOAD_1 (q0q1_xpipe_rxmarginreqpayload_m_1),
      .XPIPE_RXMARGINREQREQ_1     (q0q1_xpipe_rxmarginreqreq_m_1),
      .XPIPE_RXMARGINRESACK_1     (q0q1_xpipe_rxmarginresack_m_1),
      .XPIPE_RXMARGINREQCMD_2     (q0q1_xpipe_rxmarginreqcmd_m_2),
      .XPIPE_RXMARGINREQLANENUM_2 (q0q1_xpipe_rxmarginreqlanenum_m_2),
      .XPIPE_RXMARGINREQPAYLOAD_2 (q0q1_xpipe_rxmarginreqpayload_m_2),
      .XPIPE_RXMARGINREQREQ_2     (q0q1_xpipe_rxmarginreqreq_m_2),
      .XPIPE_RXMARGINRESACK_2     (q0q1_xpipe_rxmarginresack_m_2),
      .XPIPE_RXMARGINREQCMD_3     (q0q1_xpipe_rxmarginreqcmd_m_3),
      .XPIPE_RXMARGINREQLANENUM_3 (q0q1_xpipe_rxmarginreqlanenum_m_3),
      .XPIPE_RXMARGINREQPAYLOAD_3 (q0q1_xpipe_rxmarginreqpayload_m_3),
      .XPIPE_RXMARGINREQREQ_3     (q0q1_xpipe_rxmarginreqreq_m_3),
      .XPIPE_RXMARGINRESACK_3     (q0q1_xpipe_rxmarginresack_m_3),
      .XPIPE_RXMARGINREQACK       (q0q1_xpipe_rxmarginreqack_m),
      .XPIPE_RXMARGINREQACK_1     (q0q1_xpipe_rxmarginreqack_m_1),
      .XPIPE_RXMARGINREQACK_2     (q0q1_xpipe_rxmarginreqack_m_2),
      .XPIPE_RXMARGINREQACK_3     (q0q1_xpipe_rxmarginreqack_m_3),
      .XPIPE_RXMARGINRESCMD       (q0q1_xpipe_rxmarginrescmd_m),
      .XPIPE_RXMARGINRESCMD_1     (q0q1_xpipe_rxmarginrescmd_m_1),
      .XPIPE_RXMARGINRESCMD_2     (q0q1_xpipe_rxmarginrescmd_m_2),
      .XPIPE_RXMARGINRESCMD_3     (q0q1_xpipe_rxmarginrescmd_m_3),
      .XPIPE_RXMARGINRESLANENUM   (q0q1_xpipe_rxmarginreslanenum_m),
      .XPIPE_RXMARGINRESLANENUM_1 (q0q1_xpipe_rxmarginreslanenum_m_1),
      .XPIPE_RXMARGINRESLANENUM_2 (q0q1_xpipe_rxmarginreslanenum_m_2),
      .XPIPE_RXMARGINRESLANENUM_3 (q0q1_xpipe_rxmarginreslanenum_m_3),
      .XPIPE_RXMARGINRESPAYLOAD   (q0q1_xpipe_rxmarginrespayload_m),
      .XPIPE_RXMARGINRESPAYLOAD_1 (q0q1_xpipe_rxmarginrespayload_m_1),
      .XPIPE_RXMARGINRESPAYLOAD_2 (q0q1_xpipe_rxmarginrespayload_m_2),
      .XPIPE_RXMARGINRESPAYLOAD_3 (q0q1_xpipe_rxmarginrespayload_m_3),
      .XPIPE_RXMARGINRESREQ       (q0q1_xpipe_rxmarginresreq_m),
      .XPIPE_RXMARGINRESREQ_1     (q0q1_xpipe_rxmarginresreq_m_1),
      .XPIPE_RXMARGINRESREQ_2     (q0q1_xpipe_rxmarginresreq_m_2),
      .XPIPE_RXMARGINRESREQ_3     (q0q1_xpipe_rxmarginresreq_m_3),

      .XPIPE_PCIELINKREACHTARGET_M  (q1q2_xpipe_pcielinkreachtarget_m),
      .XPIPE_PCIELINKREACHTARGET_M_1(q1q2_xpipe_pcielinkreachtarget_m_1),
      .XPIPE_PCIELTSSMSTATE_M       (q1q2_xpipe_pcieltssmstate_m),
      .XPIPE_PCIELTSSMSTATE_M_1     (q1q2_xpipe_pcieltssmstate_m_1),
      .XPIPE_RXMARGINREQCMD_M       (q1q2_xpipe_rxmarginreqcmd_m),
      .XPIPE_RXMARGINREQCMD_M_1     (q1q2_xpipe_rxmarginreqcmd_m_1),
      .XPIPE_RXMARGINREQCMD_M_2     (q1q2_xpipe_rxmarginreqcmd_m_2),
      .XPIPE_RXMARGINREQCMD_M_3     (q1q2_xpipe_rxmarginreqcmd_m_3),
      .XPIPE_RXMARGINREQLANENUM_M   (q1q2_xpipe_rxmarginreqlanenum_m),
      .XPIPE_RXMARGINREQLANENUM_M_1 (q1q2_xpipe_rxmarginreqlanenum_m_1),
      .XPIPE_RXMARGINREQLANENUM_M_2 (q1q2_xpipe_rxmarginreqlanenum_m_2),
      .XPIPE_RXMARGINREQLANENUM_M_3 (q1q2_xpipe_rxmarginreqlanenum_m_3),
      .XPIPE_RXMARGINREQPAYLOAD_M   (q1q2_xpipe_rxmarginreqpayload_m),
      .XPIPE_RXMARGINREQPAYLOAD_M_1 (q1q2_xpipe_rxmarginreqpayload_m_1),
      .XPIPE_RXMARGINREQPAYLOAD_M_2 (q1q2_xpipe_rxmarginreqpayload_m_2),
      .XPIPE_RXMARGINREQPAYLOAD_M_3 (q1q2_xpipe_rxmarginreqpayload_m_3),
      .XPIPE_RXMARGINREQREQ_M       (q1q2_xpipe_rxmarginreqreq_m),
      .XPIPE_RXMARGINREQREQ_M_1     (q1q2_xpipe_rxmarginreqreq_m_1),
      .XPIPE_RXMARGINREQREQ_M_2     (q1q2_xpipe_rxmarginreqreq_m_2),
      .XPIPE_RXMARGINREQREQ_M_3     (q1q2_xpipe_rxmarginreqreq_m_3),
      .XPIPE_RXMARGINRESACK_M       (q1q2_xpipe_rxmarginresack_m),
      .XPIPE_RXMARGINRESACK_M_1     (q1q2_xpipe_rxmarginresack_m_1),
      .XPIPE_RXMARGINRESACK_M_2     (q1q2_xpipe_rxmarginresack_m_2),
      .XPIPE_RXMARGINRESACK_M_3     (q1q2_xpipe_rxmarginresack_m_3),
      .XPIPE_RXMARGINREQACK_M       (q1q2_xpipe_rxmarginreqack_m),
      .XPIPE_RXMARGINREQACK_M_1     (q1q2_xpipe_rxmarginreqack_m_1),
      .XPIPE_RXMARGINREQACK_M_2     (q1q2_xpipe_rxmarginreqack_m_2),
      .XPIPE_RXMARGINREQACK_M_3     (q1q2_xpipe_rxmarginreqack_m_3),
      .XPIPE_RXMARGINRESCMD_M       (q1q2_xpipe_rxmarginrescmd_m),
      .XPIPE_RXMARGINRESCMD_M_1     (q1q2_xpipe_rxmarginrescmd_m_1),
      .XPIPE_RXMARGINRESCMD_M_2     (q1q2_xpipe_rxmarginrescmd_m_2),
      .XPIPE_RXMARGINRESCMD_M_3     (q1q2_xpipe_rxmarginrescmd_m_3),
      .XPIPE_RXMARGINRESLANENUM_M   (q1q2_xpipe_rxmarginreslanenum_m),
      .XPIPE_RXMARGINRESLANENUM_M_1 (q1q2_xpipe_rxmarginreslanenum_m_1),
      .XPIPE_RXMARGINRESLANENUM_M_2 (q1q2_xpipe_rxmarginreslanenum_m_2),
      .XPIPE_RXMARGINRESLANENUM_M_3 (q1q2_xpipe_rxmarginreslanenum_m_3),
      .XPIPE_RXMARGINRESPAYLOAD_M   (q1q2_xpipe_rxmarginrespayload_m),
      .XPIPE_RXMARGINRESPAYLOAD_M_1 (q1q2_xpipe_rxmarginrespayload_m_1),
      .XPIPE_RXMARGINRESPAYLOAD_M_2 (q1q2_xpipe_rxmarginrespayload_m_2),
      .XPIPE_RXMARGINRESPAYLOAD_M_3 (q1q2_xpipe_rxmarginrespayload_m_3),
      .XPIPE_RXMARGINRESREQ_M       (q1q2_xpipe_rxmarginresreq_m),
      .XPIPE_RXMARGINRESREQ_M_1     (q1q2_xpipe_rxmarginresreq_m_1),
      .XPIPE_RXMARGINRESREQ_M_2     (q1q2_xpipe_rxmarginresreq_m_2),
      .XPIPE_RXMARGINRESREQ_M_3     (q1q2_xpipe_rxmarginresreq_m_3),

      .XPIPE_PIPE_CH0_PHYSTATUS      (q0q1_xpipe_pipe_ch0_phystatus_m),
      .XPIPE_PIPE_CH0_RXCHARISK      (q0q1_xpipe_pipe_ch0_rxcharisk_m),
      .XPIPE_PIPE_CH0_RXDATA         (q0q1_xpipe_pipe_ch0_rxdata_m),
      .XPIPE_PIPE_CH0_RXDATAVALID    (q0q1_xpipe_pipe_ch0_rxdatavalid_m),
      .XPIPE_PIPE_CH0_RXELECIDLE     (q0q1_xpipe_pipe_ch0_rxelecidle_m),
      .XPIPE_PIPE_CH0_RXSTARTBLOCK   (q0q1_xpipe_pipe_ch0_rxstartblock_m),
      .XPIPE_PIPE_CH0_RXSTATUS       (q0q1_xpipe_pipe_ch0_rxstatus_m),
      .XPIPE_PIPE_CH0_RXSYNCHEADER   (q0q1_xpipe_pipe_ch0_rxsyncheader_m),
      .XPIPE_PIPE_CH0_RXVALID        (q0q1_xpipe_pipe_ch0_rxvalid_m),
      .XPIPE_PIPE_CH0_POWERDOWN      (q0q1_xpipe_pipe_ch0_powerdown_m),
      .XPIPE_PIPE_CH0_RXPOLARITY     (q0q1_xpipe_pipe_ch0_rxpolarity_m),
      .XPIPE_PIPE_CH0_RXTERMINATION  (q0q1_xpipe_pipe_ch0_rxtermination_m),
      .XPIPE_PIPE_CH0_TXCHARISK      (q0q1_xpipe_pipe_ch0_txcharisk_m),
      .XPIPE_PIPE_CH0_TXCOMPLIANCE   (q0q1_xpipe_pipe_ch0_txcompliance_m),
      .XPIPE_PIPE_CH0_TXDATA         (q0q1_xpipe_pipe_ch0_txdata_m),
      .XPIPE_PIPE_CH0_TXDATAVALID    (q0q1_xpipe_pipe_ch0_txdatavalid_m),
      .XPIPE_PIPE_CH0_TXDEEMPH       (q0q1_xpipe_pipe_ch0_txdeemph_m),
      .XPIPE_PIPE_CH0_TXDETECTRXLOOPBACK(q0q1_xpipe_pipe_ch0_txdetectrxloopback_m),
      .XPIPE_PIPE_CH0_TXELECIDLE     (q0q1_xpipe_pipe_ch0_txelecidle_m),
      .XPIPE_PIPE_CH0_TXMAINCURSOR   (q0q1_xpipe_pipe_ch0_txmaincursor_m),
      .XPIPE_PIPE_CH0_TXMARGIN       (q0q1_xpipe_pipe_ch0_txmargin_m),
      .XPIPE_PIPE_CH0_TXPOSTCURSOR   (q0q1_xpipe_pipe_ch0_txpostcursor_m),
      .XPIPE_PIPE_CH0_TXPRECURSOR    (q0q1_xpipe_pipe_ch0_txprecursor_m),
      .XPIPE_PIPE_CH0_TXSTARTBLOCK   (q0q1_xpipe_pipe_ch0_txstartblock_m),
      .XPIPE_PIPE_CH0_TXSWING        (q0q1_xpipe_pipe_ch0_txswing_m),
      .XPIPE_PIPE_CH0_TXSYNCHEADER   (q0q1_xpipe_pipe_ch0_txsyncheader_m),

      .XPIPE_PIPE_CH0_POWERDOWN_M    (q1q2_xpipe_pipe_ch0_powerdown_m),
      .XPIPE_PIPE_CH0_RXPOLARITY_M   (q1q2_xpipe_pipe_ch0_rxpolarity_m),
      .XPIPE_PIPE_CH0_RXTERMINATION_M(q1q2_xpipe_pipe_ch0_rxtermination_m),
      .XPIPE_PIPE_CH0_TXCHARISK_M    (q1q2_xpipe_pipe_ch0_txcharisk_m),
      .XPIPE_PIPE_CH0_TXCOMPLIANCE_M (q1q2_xpipe_pipe_ch0_txcompliance_m),
      .XPIPE_PIPE_CH0_TXDATAVALID_M  (q1q2_xpipe_pipe_ch0_txdatavalid_m),
      .XPIPE_PIPE_CH0_TXDATA_M       (q1q2_xpipe_pipe_ch0_txdata_m),
      .XPIPE_PIPE_CH0_TXDEEMPH_M     (q1q2_xpipe_pipe_ch0_txdeemph_m),
      .XPIPE_PIPE_CH0_TXELECIDLE_M   (q1q2_xpipe_pipe_ch0_txelecidle_m),
      .XPIPE_PIPE_CH0_TXMAINCURSOR_M (q1q2_xpipe_pipe_ch0_txmaincursor_m),
      .XPIPE_PIPE_CH0_TXMARGIN_M     (q1q2_xpipe_pipe_ch0_txmargin_m),
      .XPIPE_PIPE_CH0_TXPOSTCURSOR_M (q1q2_xpipe_pipe_ch0_txpostcursor_m),
      .XPIPE_PIPE_CH0_TXPRECURSOR_M  (q1q2_xpipe_pipe_ch0_txprecursor_m),
      .XPIPE_PIPE_CH0_TXSTARTBLOCK_M (q1q2_xpipe_pipe_ch0_txstartblock_m),
      .XPIPE_PIPE_CH0_TXSWING_M      (q1q2_xpipe_pipe_ch0_txswing_m),
      .XPIPE_PIPE_CH0_TXSYNCHEADER_M (q1q2_xpipe_pipe_ch0_txsyncheader_m),
      .XPIPE_PIPE_CH0_PHYSTATUS_M    (q1q2_xpipe_pipe_ch0_phystatus_m),
      .XPIPE_PIPE_CH0_RXCHARISK_M    (q1q2_xpipe_pipe_ch0_rxcharisk_m),
      .XPIPE_PIPE_CH0_RXDATAVALID_M  (q1q2_xpipe_pipe_ch0_rxdatavalid_m),
      .XPIPE_PIPE_CH0_RXDATA_M       (q1q2_xpipe_pipe_ch0_rxdata_m),
      .XPIPE_PIPE_CH0_RXELECIDLE_M   (q1q2_xpipe_pipe_ch0_rxelecidle_m),
      .XPIPE_PIPE_CH0_RXSTARTBLOCK_M (q1q2_xpipe_pipe_ch0_rxstartblock_m),
      .XPIPE_PIPE_CH0_RXSTATUS_M     (q1q2_xpipe_pipe_ch0_rxstatus_m),
      .XPIPE_PIPE_CH0_RXSYNCHEADER_M (q1q2_xpipe_pipe_ch0_rxsyncheader_m),
      .XPIPE_PIPE_CH0_RXVALID_M      (q1q2_xpipe_pipe_ch0_rxvalid_m),
      .XPIPE_PIPE_CH0_TXDETECTRXLOOPBACK_M(q1q2_xpipe_pipe_ch0_txdetectrxloopback_m),

      .XPIPE_PIPE_CH1_PHYSTATUS      (q0q1_xpipe_pipe_ch1_phystatus_m),
      .XPIPE_PIPE_CH1_RXCHARISK      (q0q1_xpipe_pipe_ch1_rxcharisk_m),
      .XPIPE_PIPE_CH1_RXDATA         (q0q1_xpipe_pipe_ch1_rxdata_m), //ifcpmxpipechannel1xpiperxdata
      .XPIPE_PIPE_CH1_RXDATAVALID    (q0q1_xpipe_pipe_ch1_rxdatavalid_m),
      .XPIPE_PIPE_CH1_RXELECIDLE     (q0q1_xpipe_pipe_ch1_rxelecidle_m),
      .XPIPE_PIPE_CH1_RXSTARTBLOCK   (q0q1_xpipe_pipe_ch1_rxstartblock_m),
      .XPIPE_PIPE_CH1_RXSTATUS       (q0q1_xpipe_pipe_ch1_rxstatus_m),
      .XPIPE_PIPE_CH1_RXSYNCHEADER   (q0q1_xpipe_pipe_ch1_rxsyncheader_m),
      .XPIPE_PIPE_CH1_RXVALID        (q0q1_xpipe_pipe_ch1_rxvalid_m),
      .XPIPE_PIPE_CH1_POWERDOWN      (q0q1_xpipe_pipe_ch1_powerdown_m),
      .XPIPE_PIPE_CH1_RXPOLARITY     (q0q1_xpipe_pipe_ch1_rxpolarity_m),
      .XPIPE_PIPE_CH1_RXTERMINATION  (q0q1_xpipe_pipe_ch1_rxtermination_m),
      .XPIPE_PIPE_CH1_TXCHARISK      (q0q1_xpipe_pipe_ch1_txcharisk_m),
      .XPIPE_PIPE_CH1_TXCOMPLIANCE   (q0q1_xpipe_pipe_ch1_txcompliance_m),
      .XPIPE_PIPE_CH1_TXDATA         (q0q1_xpipe_pipe_ch1_txdata_m),
      .XPIPE_PIPE_CH1_TXDATAVALID    (q0q1_xpipe_pipe_ch1_txdatavalid_m),
      .XPIPE_PIPE_CH1_TXDEEMPH       (q0q1_xpipe_pipe_ch1_txdeemph_m),
      .XPIPE_PIPE_CH1_TXDETECTRXLOOPBACK(q0q1_xpipe_pipe_ch1_txdetectrxloopback_m),
      .XPIPE_PIPE_CH1_TXELECIDLE     (q0q1_xpipe_pipe_ch1_txelecidle_m),
      .XPIPE_PIPE_CH1_TXMAINCURSOR   (q0q1_xpipe_pipe_ch1_txmaincursor_m),
      .XPIPE_PIPE_CH1_TXMARGIN       (q0q1_xpipe_pipe_ch1_txmargin_m),
      .XPIPE_PIPE_CH1_TXPOSTCURSOR   (q0q1_xpipe_pipe_ch1_txpostcursor_m),
      .XPIPE_PIPE_CH1_TXPRECURSOR    (q0q1_xpipe_pipe_ch1_txprecursor_m),
      .XPIPE_PIPE_CH1_TXSTARTBLOCK   (q0q1_xpipe_pipe_ch1_txstartblock_m),
      .XPIPE_PIPE_CH1_TXSWING        (q0q1_xpipe_pipe_ch1_txswing_m),
      .XPIPE_PIPE_CH1_TXSYNCHEADER   (q0q1_xpipe_pipe_ch1_txsyncheader_m),

      .XPIPE_PIPE_CH1_POWERDOWN_M    (q1q2_xpipe_pipe_ch1_powerdown_m),
      .XPIPE_PIPE_CH1_RXPOLARITY_M   (q1q2_xpipe_pipe_ch1_rxpolarity_m),
      .XPIPE_PIPE_CH1_RXTERMINATION_M(q1q2_xpipe_pipe_ch1_rxtermination_m),
      .XPIPE_PIPE_CH1_TXCHARISK_M    (q1q2_xpipe_pipe_ch1_txcharisk_m),
      .XPIPE_PIPE_CH1_TXCOMPLIANCE_M (q1q2_xpipe_pipe_ch1_txcompliance_m),
      .XPIPE_PIPE_CH1_TXDATAVALID_M  (q1q2_xpipe_pipe_ch1_txdatavalid_m),
      .XPIPE_PIPE_CH1_TXDATA_M       (q1q2_xpipe_pipe_ch1_txdata_m),
      .XPIPE_PIPE_CH1_TXDEEMPH_M     (q1q2_xpipe_pipe_ch1_txdeemph_m),
      .XPIPE_PIPE_CH1_TXELECIDLE_M   (q1q2_xpipe_pipe_ch1_txelecidle_m),
      .XPIPE_PIPE_CH1_TXMAINCURSOR_M (q1q2_xpipe_pipe_ch1_txmaincursor_m),
      .XPIPE_PIPE_CH1_TXMARGIN_M     (q1q2_xpipe_pipe_ch1_txmargin_m),
      .XPIPE_PIPE_CH1_TXPOSTCURSOR_M (q1q2_xpipe_pipe_ch1_txpostcursor_m),
      .XPIPE_PIPE_CH1_TXPRECURSOR_M  (q1q2_xpipe_pipe_ch1_txprecursor_m),
      .XPIPE_PIPE_CH1_TXSTARTBLOCK_M (q1q2_xpipe_pipe_ch1_txstartblock_m),
      .XPIPE_PIPE_CH1_TXSWING_M      (q1q2_xpipe_pipe_ch1_txswing_m),
      .XPIPE_PIPE_CH1_TXSYNCHEADER_M (q1q2_xpipe_pipe_ch1_txsyncheader_m),
      .XPIPE_PIPE_CH1_PHYSTATUS_M    (q1q2_xpipe_pipe_ch1_phystatus_m),
      .XPIPE_PIPE_CH1_RXCHARISK_M    (q1q2_xpipe_pipe_ch1_rxcharisk_m),
      .XPIPE_PIPE_CH1_RXDATAVALID_M  (q1q2_xpipe_pipe_ch1_rxdatavalid_m),
      .XPIPE_PIPE_CH1_RXDATA_M       (q1q2_xpipe_pipe_ch1_rxdata_m),
      .XPIPE_PIPE_CH1_RXELECIDLE_M   (q1q2_xpipe_pipe_ch1_rxelecidle_m),
      .XPIPE_PIPE_CH1_RXSTARTBLOCK_M (q1q2_xpipe_pipe_ch1_rxstartblock_m),
      .XPIPE_PIPE_CH1_RXSTATUS_M     (q1q2_xpipe_pipe_ch1_rxstatus_m),
      .XPIPE_PIPE_CH1_RXSYNCHEADER_M (q1q2_xpipe_pipe_ch1_rxsyncheader_m),
      .XPIPE_PIPE_CH1_RXVALID_M      (q1q2_xpipe_pipe_ch1_rxvalid_m),
      .XPIPE_PIPE_CH1_TXDETECTRXLOOPBACK_M(q1q2_xpipe_pipe_ch1_txdetectrxloopback_m),

      .XPIPE_PIPE_CH2_PHYSTATUS      (q0q1_xpipe_pipe_ch2_phystatus_m),
      .XPIPE_PIPE_CH2_RXCHARISK      (q0q1_xpipe_pipe_ch2_rxcharisk_m),
      .XPIPE_PIPE_CH2_RXDATA         (q0q1_xpipe_pipe_ch2_rxdata_m), //ifcpmxpipechannel2xpiperxdata
      .XPIPE_PIPE_CH2_RXDATAVALID    (q0q1_xpipe_pipe_ch2_rxdatavalid_m),
      .XPIPE_PIPE_CH2_RXELECIDLE     (q0q1_xpipe_pipe_ch2_rxelecidle_m),
      .XPIPE_PIPE_CH2_RXSTARTBLOCK   (q0q1_xpipe_pipe_ch2_rxstartblock_m),
      .XPIPE_PIPE_CH2_RXSTATUS       (q0q1_xpipe_pipe_ch2_rxstatus_m),
      .XPIPE_PIPE_CH2_RXSYNCHEADER   (q0q1_xpipe_pipe_ch2_rxsyncheader_m),
      .XPIPE_PIPE_CH2_RXVALID        (q0q1_xpipe_pipe_ch2_rxvalid_m),
      .XPIPE_PIPE_CH2_POWERDOWN      (q0q1_xpipe_pipe_ch2_powerdown_m),
      .XPIPE_PIPE_CH2_RXPOLARITY     (q0q1_xpipe_pipe_ch2_rxpolarity_m),
      .XPIPE_PIPE_CH2_RXTERMINATION  (q0q1_xpipe_pipe_ch2_rxtermination_m),
      .XPIPE_PIPE_CH2_TXCHARISK      (q0q1_xpipe_pipe_ch2_txcharisk_m),
      .XPIPE_PIPE_CH2_TXCOMPLIANCE   (q0q1_xpipe_pipe_ch2_txcompliance_m),
      .XPIPE_PIPE_CH2_TXDATA         (q0q1_xpipe_pipe_ch2_txdata_m),
      .XPIPE_PIPE_CH2_TXDATAVALID    (q0q1_xpipe_pipe_ch2_txdatavalid_m),
      .XPIPE_PIPE_CH2_TXDEEMPH       (q0q1_xpipe_pipe_ch2_txdeemph_m),
      .XPIPE_PIPE_CH2_TXDETECTRXLOOPBACK(q0q1_xpipe_pipe_ch2_txdetectrxloopback_m),
      .XPIPE_PIPE_CH2_TXELECIDLE     (q0q1_xpipe_pipe_ch2_txelecidle_m),
      .XPIPE_PIPE_CH2_TXMAINCURSOR   (q0q1_xpipe_pipe_ch2_txmaincursor_m),
      .XPIPE_PIPE_CH2_TXMARGIN       (q0q1_xpipe_pipe_ch2_txmargin_m),
      .XPIPE_PIPE_CH2_TXPOSTCURSOR   (q0q1_xpipe_pipe_ch2_txpostcursor_m),
      .XPIPE_PIPE_CH2_TXPRECURSOR    (q0q1_xpipe_pipe_ch2_txprecursor_m),
      .XPIPE_PIPE_CH2_TXSTARTBLOCK   (q0q1_xpipe_pipe_ch2_txstartblock_m),
      .XPIPE_PIPE_CH2_TXSWING        (q0q1_xpipe_pipe_ch2_txswing_m),
      .XPIPE_PIPE_CH2_TXSYNCHEADER   (q0q1_xpipe_pipe_ch2_txsyncheader_m),

      .XPIPE_PIPE_CH2_POWERDOWN_M    (q1q2_xpipe_pipe_ch2_powerdown_m),
      .XPIPE_PIPE_CH2_RXPOLARITY_M   (q1q2_xpipe_pipe_ch2_rxpolarity_m),
      .XPIPE_PIPE_CH2_RXTERMINATION_M(q1q2_xpipe_pipe_ch2_rxtermination_m),
      .XPIPE_PIPE_CH2_TXCHARISK_M    (q1q2_xpipe_pipe_ch2_txcharisk_m),
      .XPIPE_PIPE_CH2_TXCOMPLIANCE_M (q1q2_xpipe_pipe_ch2_txcompliance_m),
      .XPIPE_PIPE_CH2_TXDATAVALID_M  (q1q2_xpipe_pipe_ch2_txdatavalid_m),
      .XPIPE_PIPE_CH2_TXDATA_M       (q1q2_xpipe_pipe_ch2_txdata_m),
      .XPIPE_PIPE_CH2_TXDEEMPH_M     (q1q2_xpipe_pipe_ch2_txdeemph_m),
      .XPIPE_PIPE_CH2_TXELECIDLE_M   (q1q2_xpipe_pipe_ch2_txelecidle_m),
      .XPIPE_PIPE_CH2_TXMAINCURSOR_M (q1q2_xpipe_pipe_ch2_txmaincursor_m),
      .XPIPE_PIPE_CH2_TXMARGIN_M     (q1q2_xpipe_pipe_ch2_txmargin_m),
      .XPIPE_PIPE_CH2_TXPOSTCURSOR_M (q1q2_xpipe_pipe_ch2_txpostcursor_m),
      .XPIPE_PIPE_CH2_TXPRECURSOR_M  (q1q2_xpipe_pipe_ch2_txprecursor_m),
      .XPIPE_PIPE_CH2_TXSTARTBLOCK_M (q1q2_xpipe_pipe_ch2_txstartblock_m),
      .XPIPE_PIPE_CH2_TXSWING_M      (q1q2_xpipe_pipe_ch2_txswing_m),
      .XPIPE_PIPE_CH2_TXSYNCHEADER_M (q1q2_xpipe_pipe_ch2_txsyncheader_m),
      .XPIPE_PIPE_CH2_PHYSTATUS_M    (q1q2_xpipe_pipe_ch2_phystatus_m),
      .XPIPE_PIPE_CH2_RXCHARISK_M    (q1q2_xpipe_pipe_ch2_rxcharisk_m),
      .XPIPE_PIPE_CH2_RXDATAVALID_M  (q1q2_xpipe_pipe_ch2_rxdatavalid_m),
      .XPIPE_PIPE_CH2_RXDATA_M       (q1q2_xpipe_pipe_ch2_rxdata_m),
      .XPIPE_PIPE_CH2_RXELECIDLE_M   (q1q2_xpipe_pipe_ch2_rxelecidle_m),
      .XPIPE_PIPE_CH2_RXSTARTBLOCK_M (q1q2_xpipe_pipe_ch2_rxstartblock_m),
      .XPIPE_PIPE_CH2_RXSTATUS_M     (q1q2_xpipe_pipe_ch2_rxstatus_m),
      .XPIPE_PIPE_CH2_RXSYNCHEADER_M (q1q2_xpipe_pipe_ch2_rxsyncheader_m),
      .XPIPE_PIPE_CH2_RXVALID_M      (q1q2_xpipe_pipe_ch2_rxvalid_m),
      .XPIPE_PIPE_CH2_TXDETECTRXLOOPBACK_M(q1q2_xpipe_pipe_ch2_txdetectrxloopback_m),

      .XPIPE_PIPE_CH3_PHYSTATUS      (q0q1_xpipe_pipe_ch3_phystatus_m),
      .XPIPE_PIPE_CH3_RXCHARISK      (q0q1_xpipe_pipe_ch3_rxcharisk_m),
      .XPIPE_PIPE_CH3_RXDATA         (q0q1_xpipe_pipe_ch3_rxdata_m), //ifcpmxpipechannel3xpiperxdata
      .XPIPE_PIPE_CH3_RXDATAVALID    (q0q1_xpipe_pipe_ch3_rxdatavalid_m),
      .XPIPE_PIPE_CH3_RXELECIDLE     (q0q1_xpipe_pipe_ch3_rxelecidle_m),
      .XPIPE_PIPE_CH3_RXSTARTBLOCK   (q0q1_xpipe_pipe_ch3_rxstartblock_m),
      .XPIPE_PIPE_CH3_RXSTATUS       (q0q1_xpipe_pipe_ch3_rxstatus_m),
      .XPIPE_PIPE_CH3_RXSYNCHEADER   (q0q1_xpipe_pipe_ch3_rxsyncheader_m),
      .XPIPE_PIPE_CH3_RXVALID        (q0q1_xpipe_pipe_ch3_rxvalid_m),
      .XPIPE_PIPE_CH3_POWERDOWN      (q0q1_xpipe_pipe_ch3_powerdown_m),
      .XPIPE_PIPE_CH3_RXPOLARITY     (q0q1_xpipe_pipe_ch3_rxpolarity_m),
      .XPIPE_PIPE_CH3_RXTERMINATION  (q0q1_xpipe_pipe_ch3_rxtermination_m),
      .XPIPE_PIPE_CH3_TXCHARISK      (q0q1_xpipe_pipe_ch3_txcharisk_m),
      .XPIPE_PIPE_CH3_TXCOMPLIANCE   (q0q1_xpipe_pipe_ch3_txcompliance_m),
      .XPIPE_PIPE_CH3_TXDATA         (q0q1_xpipe_pipe_ch3_txdata_m),
      .XPIPE_PIPE_CH3_TXDATAVALID    (q0q1_xpipe_pipe_ch3_txdatavalid_m),
      .XPIPE_PIPE_CH3_TXDEEMPH       (q0q1_xpipe_pipe_ch3_txdeemph_m),
      .XPIPE_PIPE_CH3_TXDETECTRXLOOPBACK(q0q1_xpipe_pipe_ch3_txdetectrxloopback_m),
      .XPIPE_PIPE_CH3_TXELECIDLE     (q0q1_xpipe_pipe_ch3_txelecidle_m),
      .XPIPE_PIPE_CH3_TXMAINCURSOR   (q0q1_xpipe_pipe_ch3_txmaincursor_m),
      .XPIPE_PIPE_CH3_TXMARGIN       (q0q1_xpipe_pipe_ch3_txmargin_m),
      .XPIPE_PIPE_CH3_TXPOSTCURSOR   (q0q1_xpipe_pipe_ch3_txpostcursor_m),
      .XPIPE_PIPE_CH3_TXPRECURSOR    (q0q1_xpipe_pipe_ch3_txprecursor_m),
      .XPIPE_PIPE_CH3_TXSTARTBLOCK   (q0q1_xpipe_pipe_ch3_txstartblock_m),
      .XPIPE_PIPE_CH3_TXSWING        (q0q1_xpipe_pipe_ch3_txswing_m),
      .XPIPE_PIPE_CH3_TXSYNCHEADER   (q0q1_xpipe_pipe_ch3_txsyncheader_m),

      .XPIPE_PIPE_CH3_POWERDOWN_M    (q1q2_xpipe_pipe_ch3_powerdown_m),
      .XPIPE_PIPE_CH3_RXPOLARITY_M   (q1q2_xpipe_pipe_ch3_rxpolarity_m),
      .XPIPE_PIPE_CH3_RXTERMINATION_M(q1q2_xpipe_pipe_ch3_rxtermination_m),
      .XPIPE_PIPE_CH3_TXCHARISK_M    (q1q2_xpipe_pipe_ch3_txcharisk_m),
      .XPIPE_PIPE_CH3_TXCOMPLIANCE_M (q1q2_xpipe_pipe_ch3_txcompliance_m),
      .XPIPE_PIPE_CH3_TXDATAVALID_M  (q1q2_xpipe_pipe_ch3_txdatavalid_m),
      .XPIPE_PIPE_CH3_TXDATA_M       (q1q2_xpipe_pipe_ch3_txdata_m),
      .XPIPE_PIPE_CH3_TXDEEMPH_M     (q1q2_xpipe_pipe_ch3_txdeemph_m),
      .XPIPE_PIPE_CH3_TXELECIDLE_M   (q1q2_xpipe_pipe_ch3_txelecidle_m),
      .XPIPE_PIPE_CH3_TXMAINCURSOR_M (q1q2_xpipe_pipe_ch3_txmaincursor_m),
      .XPIPE_PIPE_CH3_TXMARGIN_M     (q1q2_xpipe_pipe_ch3_txmargin_m),
      .XPIPE_PIPE_CH3_TXPOSTCURSOR_M (q1q2_xpipe_pipe_ch3_txpostcursor_m),
      .XPIPE_PIPE_CH3_TXPRECURSOR_M  (q1q2_xpipe_pipe_ch3_txprecursor_m),
      .XPIPE_PIPE_CH3_TXSTARTBLOCK_M (q1q2_xpipe_pipe_ch3_txstartblock_m),
      .XPIPE_PIPE_CH3_TXSWING_M      (q1q2_xpipe_pipe_ch3_txswing_m),
      .XPIPE_PIPE_CH3_TXSYNCHEADER_M (q1q2_xpipe_pipe_ch3_txsyncheader_m),
      .XPIPE_PIPE_CH3_PHYSTATUS_M    (q1q2_xpipe_pipe_ch3_phystatus_m),
      .XPIPE_PIPE_CH3_RXCHARISK_M    (q1q2_xpipe_pipe_ch3_rxcharisk_m),
      .XPIPE_PIPE_CH3_RXDATAVALID_M  (q1q2_xpipe_pipe_ch3_rxdatavalid_m),
      .XPIPE_PIPE_CH3_RXDATA_M       (q1q2_xpipe_pipe_ch3_rxdata_m),
      .XPIPE_PIPE_CH3_RXELECIDLE_M   (q1q2_xpipe_pipe_ch3_rxelecidle_m),
      .XPIPE_PIPE_CH3_RXSTARTBLOCK_M (q1q2_xpipe_pipe_ch3_rxstartblock_m),
      .XPIPE_PIPE_CH3_RXSTATUS_M     (q1q2_xpipe_pipe_ch3_rxstatus_m),
      .XPIPE_PIPE_CH3_RXSYNCHEADER_M (q1q2_xpipe_pipe_ch3_rxsyncheader_m),
      .XPIPE_PIPE_CH3_RXVALID_M      (q1q2_xpipe_pipe_ch3_rxvalid_m),
      .XPIPE_PIPE_CH3_TXDETECTRXLOOPBACK_M(q1q2_xpipe_pipe_ch3_txdetectrxloopback_m),

      .XPIPE_PIPE_CH4_PHYSTATUS      (q0q1_xpipe_pipe_ch4_phystatus_m),
      .XPIPE_PIPE_CH4_RXCHARISK      (q0q1_xpipe_pipe_ch4_rxcharisk_m),
      .XPIPE_PIPE_CH4_RXDATA         (q0q1_xpipe_pipe_ch4_rxdata_m), //ifcpmxpipechannel4xpiperxdata
      .XPIPE_PIPE_CH4_RXDATAVALID    (q0q1_xpipe_pipe_ch4_rxdatavalid_m),
      .XPIPE_PIPE_CH4_RXELECIDLE     (q0q1_xpipe_pipe_ch4_rxelecidle_m),
      .XPIPE_PIPE_CH4_RXSTARTBLOCK   (q0q1_xpipe_pipe_ch4_rxstartblock_m),
      .XPIPE_PIPE_CH4_RXSTATUS       (q0q1_xpipe_pipe_ch4_rxstatus_m),
      .XPIPE_PIPE_CH4_RXSYNCHEADER   (q0q1_xpipe_pipe_ch4_rxsyncheader_m),
      .XPIPE_PIPE_CH4_RXVALID        (q0q1_xpipe_pipe_ch4_rxvalid_m),
      .XPIPE_PIPE_CH4_POWERDOWN      (q0q1_xpipe_pipe_ch4_powerdown_m),
      .XPIPE_PIPE_CH4_RXPOLARITY     (q0q1_xpipe_pipe_ch4_rxpolarity_m),
      .XPIPE_PIPE_CH4_RXTERMINATION  (q0q1_xpipe_pipe_ch4_rxtermination_m),
      .XPIPE_PIPE_CH4_TXCHARISK      (q0q1_xpipe_pipe_ch4_txcharisk_m),
      .XPIPE_PIPE_CH4_TXCOMPLIANCE   (q0q1_xpipe_pipe_ch4_txcompliance_m),
      .XPIPE_PIPE_CH4_TXDATA         (q0q1_xpipe_pipe_ch4_txdata_m),
      .XPIPE_PIPE_CH4_TXDATAVALID    (q0q1_xpipe_pipe_ch4_txdatavalid_m),
      .XPIPE_PIPE_CH4_TXDEEMPH       (q0q1_xpipe_pipe_ch4_txdeemph_m),
      .XPIPE_PIPE_CH4_TXDETECTRXLOOPBACK(q0q1_xpipe_pipe_ch4_txdetectrxloopback_m),
      .XPIPE_PIPE_CH4_TXELECIDLE     (q0q1_xpipe_pipe_ch4_txelecidle_m),
      .XPIPE_PIPE_CH4_TXMAINCURSOR   (q0q1_xpipe_pipe_ch4_txmaincursor_m),
      .XPIPE_PIPE_CH4_TXMARGIN       (q0q1_xpipe_pipe_ch4_txmargin_m),
      .XPIPE_PIPE_CH4_TXPOSTCURSOR   (q0q1_xpipe_pipe_ch4_txpostcursor_m),
      .XPIPE_PIPE_CH4_TXPRECURSOR    (q0q1_xpipe_pipe_ch4_txprecursor_m),
      .XPIPE_PIPE_CH4_TXSTARTBLOCK   (q0q1_xpipe_pipe_ch4_txstartblock_m),
      .XPIPE_PIPE_CH4_TXSWING        (q0q1_xpipe_pipe_ch4_txswing_m),
      .XPIPE_PIPE_CH4_TXSYNCHEADER   (q0q1_xpipe_pipe_ch4_txsyncheader_m),

      .XPIPE_PIPE_CH4_POWERDOWN_M    (q1q2_xpipe_pipe_ch4_powerdown_m),
      .XPIPE_PIPE_CH4_RXPOLARITY_M   (q1q2_xpipe_pipe_ch4_rxpolarity_m),
      .XPIPE_PIPE_CH4_RXTERMINATION_M(q1q2_xpipe_pipe_ch4_rxtermination_m),
      .XPIPE_PIPE_CH4_TXCHARISK_M    (q1q2_xpipe_pipe_ch4_txcharisk_m),
      .XPIPE_PIPE_CH4_TXCOMPLIANCE_M (q1q2_xpipe_pipe_ch4_txcompliance_m),
      .XPIPE_PIPE_CH4_TXDATAVALID_M  (q1q2_xpipe_pipe_ch4_txdatavalid_m),
      .XPIPE_PIPE_CH4_TXDATA_M       (q1q2_xpipe_pipe_ch4_txdata_m),
      .XPIPE_PIPE_CH4_TXDEEMPH_M     (q1q2_xpipe_pipe_ch4_txdeemph_m),
      .XPIPE_PIPE_CH4_TXELECIDLE_M   (q1q2_xpipe_pipe_ch4_txelecidle_m),
      .XPIPE_PIPE_CH4_TXMAINCURSOR_M (q1q2_xpipe_pipe_ch4_txmaincursor_m),
      .XPIPE_PIPE_CH4_TXMARGIN_M     (q1q2_xpipe_pipe_ch4_txmargin_m),
      .XPIPE_PIPE_CH4_TXPOSTCURSOR_M (q1q2_xpipe_pipe_ch4_txpostcursor_m),
      .XPIPE_PIPE_CH4_TXPRECURSOR_M  (q1q2_xpipe_pipe_ch4_txprecursor_m),
      .XPIPE_PIPE_CH4_TXSTARTBLOCK_M (q1q2_xpipe_pipe_ch4_txstartblock_m),
      .XPIPE_PIPE_CH4_TXSWING_M      (q1q2_xpipe_pipe_ch4_txswing_m),
      .XPIPE_PIPE_CH4_TXSYNCHEADER_M (q1q2_xpipe_pipe_ch4_txsyncheader_m),
      .XPIPE_PIPE_CH4_PHYSTATUS_M    (q1q2_xpipe_pipe_ch4_phystatus_m),
      .XPIPE_PIPE_CH4_RXCHARISK_M    (q1q2_xpipe_pipe_ch4_rxcharisk_m),
      .XPIPE_PIPE_CH4_RXDATAVALID_M  (q1q2_xpipe_pipe_ch4_rxdatavalid_m),
      .XPIPE_PIPE_CH4_RXDATA_M       (q1q2_xpipe_pipe_ch4_rxdata_m),
      .XPIPE_PIPE_CH4_RXELECIDLE_M   (q1q2_xpipe_pipe_ch4_rxelecidle_m),
      .XPIPE_PIPE_CH4_RXSTARTBLOCK_M (q1q2_xpipe_pipe_ch4_rxstartblock_m),
      .XPIPE_PIPE_CH4_RXSTATUS_M     (q1q2_xpipe_pipe_ch4_rxstatus_m),
      .XPIPE_PIPE_CH4_RXSYNCHEADER_M (q1q2_xpipe_pipe_ch4_rxsyncheader_m),
      .XPIPE_PIPE_CH4_RXVALID_M      (q1q2_xpipe_pipe_ch4_rxvalid_m),
      .XPIPE_PIPE_CH4_TXDETECTRXLOOPBACK_M(q1q2_xpipe_pipe_ch4_txdetectrxloopback_m),

      .XPIPE_PIPE_CH5_PHYSTATUS      (q0q1_xpipe_pipe_ch5_phystatus_m),
      .XPIPE_PIPE_CH5_RXCHARISK      (q0q1_xpipe_pipe_ch5_rxcharisk_m),
      .XPIPE_PIPE_CH5_RXDATA         (q0q1_xpipe_pipe_ch5_rxdata_m), //ifcpmxpipechannel5xpiperxdata
      .XPIPE_PIPE_CH5_RXDATAVALID    (q0q1_xpipe_pipe_ch5_rxdatavalid_m),
      .XPIPE_PIPE_CH5_RXELECIDLE     (q0q1_xpipe_pipe_ch5_rxelecidle_m),
      .XPIPE_PIPE_CH5_RXSTARTBLOCK   (q0q1_xpipe_pipe_ch5_rxstartblock_m),
      .XPIPE_PIPE_CH5_RXSTATUS       (q0q1_xpipe_pipe_ch5_rxstatus_m),
      .XPIPE_PIPE_CH5_RXSYNCHEADER   (q0q1_xpipe_pipe_ch5_rxsyncheader_m),
      .XPIPE_PIPE_CH5_RXVALID        (q0q1_xpipe_pipe_ch5_rxvalid_m),
      .XPIPE_PIPE_CH5_POWERDOWN      (q0q1_xpipe_pipe_ch5_powerdown_m),
      .XPIPE_PIPE_CH5_RXPOLARITY     (q0q1_xpipe_pipe_ch5_rxpolarity_m),
      .XPIPE_PIPE_CH5_RXTERMINATION  (q0q1_xpipe_pipe_ch5_rxtermination_m),
      .XPIPE_PIPE_CH5_TXCHARISK      (q0q1_xpipe_pipe_ch5_txcharisk_m),
      .XPIPE_PIPE_CH5_TXCOMPLIANCE   (q0q1_xpipe_pipe_ch5_txcompliance_m),
      .XPIPE_PIPE_CH5_TXDATA         (q0q1_xpipe_pipe_ch5_txdata_m),
      .XPIPE_PIPE_CH5_TXDATAVALID    (q0q1_xpipe_pipe_ch5_txdatavalid_m),
      .XPIPE_PIPE_CH5_TXDEEMPH       (q0q1_xpipe_pipe_ch5_txdeemph_m),
      .XPIPE_PIPE_CH5_TXDETECTRXLOOPBACK(q0q1_xpipe_pipe_ch5_txdetectrxloopback_m),
      .XPIPE_PIPE_CH5_TXELECIDLE     (q0q1_xpipe_pipe_ch5_txelecidle_m),
      .XPIPE_PIPE_CH5_TXMAINCURSOR   (q0q1_xpipe_pipe_ch5_txmaincursor_m),
      .XPIPE_PIPE_CH5_TXMARGIN       (q0q1_xpipe_pipe_ch5_txmargin_m),
      .XPIPE_PIPE_CH5_TXPOSTCURSOR   (q0q1_xpipe_pipe_ch5_txpostcursor_m),
      .XPIPE_PIPE_CH5_TXPRECURSOR    (q0q1_xpipe_pipe_ch5_txprecursor_m),
      .XPIPE_PIPE_CH5_TXSTARTBLOCK   (q0q1_xpipe_pipe_ch5_txstartblock_m),
      .XPIPE_PIPE_CH5_TXSWING        (q0q1_xpipe_pipe_ch5_txswing_m),
      .XPIPE_PIPE_CH5_TXSYNCHEADER   (q0q1_xpipe_pipe_ch5_txsyncheader_m),

      .XPIPE_PIPE_CH5_POWERDOWN_M    (q1q2_xpipe_pipe_ch5_powerdown_m),
      .XPIPE_PIPE_CH5_RXPOLARITY_M   (q1q2_xpipe_pipe_ch5_rxpolarity_m),
      .XPIPE_PIPE_CH5_RXTERMINATION_M(q1q2_xpipe_pipe_ch5_rxtermination_m),
      .XPIPE_PIPE_CH5_TXCHARISK_M    (q1q2_xpipe_pipe_ch5_txcharisk_m),
      .XPIPE_PIPE_CH5_TXCOMPLIANCE_M (q1q2_xpipe_pipe_ch5_txcompliance_m),
      .XPIPE_PIPE_CH5_TXDATAVALID_M  (q1q2_xpipe_pipe_ch5_txdatavalid_m),
      .XPIPE_PIPE_CH5_TXDATA_M       (q1q2_xpipe_pipe_ch5_txdata_m),
      .XPIPE_PIPE_CH5_TXDEEMPH_M     (q1q2_xpipe_pipe_ch5_txdeemph_m),
      .XPIPE_PIPE_CH5_TXELECIDLE_M   (q1q2_xpipe_pipe_ch5_txelecidle_m),
      .XPIPE_PIPE_CH5_TXMAINCURSOR_M (q1q2_xpipe_pipe_ch5_txmaincursor_m),
      .XPIPE_PIPE_CH5_TXMARGIN_M     (q1q2_xpipe_pipe_ch5_txmargin_m),
      .XPIPE_PIPE_CH5_TXPOSTCURSOR_M (q1q2_xpipe_pipe_ch5_txpostcursor_m),
      .XPIPE_PIPE_CH5_TXPRECURSOR_M  (q1q2_xpipe_pipe_ch5_txprecursor_m),
      .XPIPE_PIPE_CH5_TXSTARTBLOCK_M (q1q2_xpipe_pipe_ch5_txstartblock_m),
      .XPIPE_PIPE_CH5_TXSWING_M      (q1q2_xpipe_pipe_ch5_txswing_m),
      .XPIPE_PIPE_CH5_TXSYNCHEADER_M (q1q2_xpipe_pipe_ch5_txsyncheader_m),
      .XPIPE_PIPE_CH5_PHYSTATUS_M    (q1q2_xpipe_pipe_ch5_phystatus_m),
      .XPIPE_PIPE_CH5_RXCHARISK_M    (q1q2_xpipe_pipe_ch5_rxcharisk_m),
      .XPIPE_PIPE_CH5_RXDATAVALID_M  (q1q2_xpipe_pipe_ch5_rxdatavalid_m),
      .XPIPE_PIPE_CH5_RXDATA_M       (q1q2_xpipe_pipe_ch5_rxdata_m),
      .XPIPE_PIPE_CH5_RXELECIDLE_M   (q1q2_xpipe_pipe_ch5_rxelecidle_m),
      .XPIPE_PIPE_CH5_RXSTARTBLOCK_M (q1q2_xpipe_pipe_ch5_rxstartblock_m),
      .XPIPE_PIPE_CH5_RXSTATUS_M     (q1q2_xpipe_pipe_ch5_rxstatus_m),
      .XPIPE_PIPE_CH5_RXSYNCHEADER_M (q1q2_xpipe_pipe_ch5_rxsyncheader_m),
      .XPIPE_PIPE_CH5_RXVALID_M      (q1q2_xpipe_pipe_ch5_rxvalid_m),
      .XPIPE_PIPE_CH5_TXDETECTRXLOOPBACK_M(q1q2_xpipe_pipe_ch5_txdetectrxloopback_m),

      .XPIPE_PIPE_CH6_PHYSTATUS      (q0q1_xpipe_pipe_ch6_phystatus_m),
      .XPIPE_PIPE_CH6_RXCHARISK      (q0q1_xpipe_pipe_ch6_rxcharisk_m),
      .XPIPE_PIPE_CH6_RXDATA         (q0q1_xpipe_pipe_ch6_rxdata_m), //ifcpmxpipechannel6xpiperxdata
      .XPIPE_PIPE_CH6_RXDATAVALID    (q0q1_xpipe_pipe_ch6_rxdatavalid_m),
      .XPIPE_PIPE_CH6_RXELECIDLE     (q0q1_xpipe_pipe_ch6_rxelecidle_m),
      .XPIPE_PIPE_CH6_RXSTARTBLOCK   (q0q1_xpipe_pipe_ch6_rxstartblock_m),
      .XPIPE_PIPE_CH6_RXSTATUS       (q0q1_xpipe_pipe_ch6_rxstatus_m),
      .XPIPE_PIPE_CH6_RXSYNCHEADER   (q0q1_xpipe_pipe_ch6_rxsyncheader_m),
      .XPIPE_PIPE_CH6_RXVALID        (q0q1_xpipe_pipe_ch6_rxvalid_m),
      .XPIPE_PIPE_CH6_POWERDOWN      (q0q1_xpipe_pipe_ch6_powerdown_m),
      .XPIPE_PIPE_CH6_RXPOLARITY     (q0q1_xpipe_pipe_ch6_rxpolarity_m),
      .XPIPE_PIPE_CH6_RXTERMINATION  (q0q1_xpipe_pipe_ch6_rxtermination_m),
      .XPIPE_PIPE_CH6_TXCHARISK      (q0q1_xpipe_pipe_ch6_txcharisk_m),
      .XPIPE_PIPE_CH6_TXCOMPLIANCE   (q0q1_xpipe_pipe_ch6_txcompliance_m),
      .XPIPE_PIPE_CH6_TXDATA         (q0q1_xpipe_pipe_ch6_txdata_m),
      .XPIPE_PIPE_CH6_TXDATAVALID    (q0q1_xpipe_pipe_ch6_txdatavalid_m),
      .XPIPE_PIPE_CH6_TXDEEMPH       (q0q1_xpipe_pipe_ch6_txdeemph_m),
      .XPIPE_PIPE_CH6_TXDETECTRXLOOPBACK(q0q1_xpipe_pipe_ch6_txdetectrxloopback_m),
      .XPIPE_PIPE_CH6_TXELECIDLE     (q0q1_xpipe_pipe_ch6_txelecidle_m),
      .XPIPE_PIPE_CH6_TXMAINCURSOR   (q0q1_xpipe_pipe_ch6_txmaincursor_m),
      .XPIPE_PIPE_CH6_TXMARGIN       (q0q1_xpipe_pipe_ch6_txmargin_m),
      .XPIPE_PIPE_CH6_TXPOSTCURSOR   (q0q1_xpipe_pipe_ch6_txpostcursor_m),
      .XPIPE_PIPE_CH6_TXPRECURSOR    (q0q1_xpipe_pipe_ch6_txprecursor_m),
      .XPIPE_PIPE_CH6_TXSTARTBLOCK   (q0q1_xpipe_pipe_ch6_txstartblock_m),
      .XPIPE_PIPE_CH6_TXSWING        (q0q1_xpipe_pipe_ch6_txswing_m),
      .XPIPE_PIPE_CH6_TXSYNCHEADER   (q0q1_xpipe_pipe_ch6_txsyncheader_m),

      .XPIPE_PIPE_CH6_POWERDOWN_M    (q1q2_xpipe_pipe_ch6_powerdown_m),
      .XPIPE_PIPE_CH6_RXPOLARITY_M   (q1q2_xpipe_pipe_ch6_rxpolarity_m),
      .XPIPE_PIPE_CH6_RXTERMINATION_M(q1q2_xpipe_pipe_ch6_rxtermination_m),
      .XPIPE_PIPE_CH6_TXCHARISK_M    (q1q2_xpipe_pipe_ch6_txcharisk_m),
      .XPIPE_PIPE_CH6_TXCOMPLIANCE_M (q1q2_xpipe_pipe_ch6_txcompliance_m),
      .XPIPE_PIPE_CH6_TXDATAVALID_M  (q1q2_xpipe_pipe_ch6_txdatavalid_m),
      .XPIPE_PIPE_CH6_TXDATA_M       (q1q2_xpipe_pipe_ch6_txdata_m),
      .XPIPE_PIPE_CH6_TXDEEMPH_M     (q1q2_xpipe_pipe_ch6_txdeemph_m),
      .XPIPE_PIPE_CH6_TXELECIDLE_M   (q1q2_xpipe_pipe_ch6_txelecidle_m),
      .XPIPE_PIPE_CH6_TXMAINCURSOR_M (q1q2_xpipe_pipe_ch6_txmaincursor_m),
      .XPIPE_PIPE_CH6_TXMARGIN_M     (q1q2_xpipe_pipe_ch6_txmargin_m),
      .XPIPE_PIPE_CH6_TXPOSTCURSOR_M (q1q2_xpipe_pipe_ch6_txpostcursor_m),
      .XPIPE_PIPE_CH6_TXPRECURSOR_M  (q1q2_xpipe_pipe_ch6_txprecursor_m),
      .XPIPE_PIPE_CH6_TXSTARTBLOCK_M (q1q2_xpipe_pipe_ch6_txstartblock_m),
      .XPIPE_PIPE_CH6_TXSWING_M      (q1q2_xpipe_pipe_ch6_txswing_m),
      .XPIPE_PIPE_CH6_TXSYNCHEADER_M (q1q2_xpipe_pipe_ch6_txsyncheader_m),
      .XPIPE_PIPE_CH6_PHYSTATUS_M    (q1q2_xpipe_pipe_ch6_phystatus_m),
      .XPIPE_PIPE_CH6_RXCHARISK_M    (q1q2_xpipe_pipe_ch6_rxcharisk_m),
      .XPIPE_PIPE_CH6_RXDATAVALID_M  (q1q2_xpipe_pipe_ch6_rxdatavalid_m),
      .XPIPE_PIPE_CH6_RXDATA_M       (q1q2_xpipe_pipe_ch6_rxdata_m),
      .XPIPE_PIPE_CH6_RXELECIDLE_M   (q1q2_xpipe_pipe_ch6_rxelecidle_m),
      .XPIPE_PIPE_CH6_RXSTARTBLOCK_M (q1q2_xpipe_pipe_ch6_rxstartblock_m),
      .XPIPE_PIPE_CH6_RXSTATUS_M     (q1q2_xpipe_pipe_ch6_rxstatus_m),
      .XPIPE_PIPE_CH6_RXSYNCHEADER_M (q1q2_xpipe_pipe_ch6_rxsyncheader_m),
      .XPIPE_PIPE_CH6_RXVALID_M      (q1q2_xpipe_pipe_ch6_rxvalid_m),
      .XPIPE_PIPE_CH6_TXDETECTRXLOOPBACK_M(q1q2_xpipe_pipe_ch6_txdetectrxloopback_m),

      .XPIPE_PIPE_CH7_PHYSTATUS      (q0q1_xpipe_pipe_ch7_phystatus_m),
      .XPIPE_PIPE_CH7_RXCHARISK      (q0q1_xpipe_pipe_ch7_rxcharisk_m),
      .XPIPE_PIPE_CH7_RXDATA         (q0q1_xpipe_pipe_ch7_rxdata_m), //ifcpmxpipechannel7xpiperxdata
      .XPIPE_PIPE_CH7_RXDATAVALID    (q0q1_xpipe_pipe_ch7_rxdatavalid_m),
      .XPIPE_PIPE_CH7_RXELECIDLE     (q0q1_xpipe_pipe_ch7_rxelecidle_m),
      .XPIPE_PIPE_CH7_RXSTARTBLOCK   (q0q1_xpipe_pipe_ch7_rxstartblock_m),
      .XPIPE_PIPE_CH7_RXSTATUS       (q0q1_xpipe_pipe_ch7_rxstatus_m),
      .XPIPE_PIPE_CH7_RXSYNCHEADER   (q0q1_xpipe_pipe_ch7_rxsyncheader_m),
      .XPIPE_PIPE_CH7_RXVALID        (q0q1_xpipe_pipe_ch7_rxvalid_m),
      .XPIPE_PIPE_CH7_POWERDOWN      (q0q1_xpipe_pipe_ch7_powerdown_m),
      .XPIPE_PIPE_CH7_RXPOLARITY     (q0q1_xpipe_pipe_ch7_rxpolarity_m),
      .XPIPE_PIPE_CH7_RXTERMINATION  (q0q1_xpipe_pipe_ch7_rxtermination_m),
      .XPIPE_PIPE_CH7_TXCHARISK      (q0q1_xpipe_pipe_ch7_txcharisk_m),
      .XPIPE_PIPE_CH7_TXCOMPLIANCE   (q0q1_xpipe_pipe_ch7_txcompliance_m),
      .XPIPE_PIPE_CH7_TXDATA         (q0q1_xpipe_pipe_ch7_txdata_m),
      .XPIPE_PIPE_CH7_TXDATAVALID    (q0q1_xpipe_pipe_ch7_txdatavalid_m),
      .XPIPE_PIPE_CH7_TXDEEMPH       (q0q1_xpipe_pipe_ch7_txdeemph_m),
      .XPIPE_PIPE_CH7_TXDETECTRXLOOPBACK(q0q1_xpipe_pipe_ch7_txdetectrxloopback_m),
      .XPIPE_PIPE_CH7_TXELECIDLE     (q0q1_xpipe_pipe_ch7_txelecidle_m),
      .XPIPE_PIPE_CH7_TXMAINCURSOR   (q0q1_xpipe_pipe_ch7_txmaincursor_m),
      .XPIPE_PIPE_CH7_TXMARGIN       (q0q1_xpipe_pipe_ch7_txmargin_m),
      .XPIPE_PIPE_CH7_TXPOSTCURSOR   (q0q1_xpipe_pipe_ch7_txpostcursor_m),
      .XPIPE_PIPE_CH7_TXPRECURSOR    (q0q1_xpipe_pipe_ch7_txprecursor_m),
      .XPIPE_PIPE_CH7_TXSTARTBLOCK   (q0q1_xpipe_pipe_ch7_txstartblock_m),
      .XPIPE_PIPE_CH7_TXSWING        (q0q1_xpipe_pipe_ch7_txswing_m),
      .XPIPE_PIPE_CH7_TXSYNCHEADER   (q0q1_xpipe_pipe_ch7_txsyncheader_m),

      .XPIPE_PIPE_CH7_POWERDOWN_M    (q1q2_xpipe_pipe_ch7_powerdown_m),
      .XPIPE_PIPE_CH7_RXPOLARITY_M   (q1q2_xpipe_pipe_ch7_rxpolarity_m),
      .XPIPE_PIPE_CH7_RXTERMINATION_M(q1q2_xpipe_pipe_ch7_rxtermination_m),
      .XPIPE_PIPE_CH7_TXCHARISK_M    (q1q2_xpipe_pipe_ch7_txcharisk_m),
      .XPIPE_PIPE_CH7_TXCOMPLIANCE_M (q1q2_xpipe_pipe_ch7_txcompliance_m),
      .XPIPE_PIPE_CH7_TXDATAVALID_M  (q1q2_xpipe_pipe_ch7_txdatavalid_m),
      .XPIPE_PIPE_CH7_TXDATA_M       (q1q2_xpipe_pipe_ch7_txdata_m),
      .XPIPE_PIPE_CH7_TXDEEMPH_M     (q1q2_xpipe_pipe_ch7_txdeemph_m),
      .XPIPE_PIPE_CH7_TXELECIDLE_M   (q1q2_xpipe_pipe_ch7_txelecidle_m),
      .XPIPE_PIPE_CH7_TXMAINCURSOR_M (q1q2_xpipe_pipe_ch7_txmaincursor_m),
      .XPIPE_PIPE_CH7_TXMARGIN_M     (q1q2_xpipe_pipe_ch7_txmargin_m),
      .XPIPE_PIPE_CH7_TXPOSTCURSOR_M (q1q2_xpipe_pipe_ch7_txpostcursor_m),
      .XPIPE_PIPE_CH7_TXPRECURSOR_M  (q1q2_xpipe_pipe_ch7_txprecursor_m),
      .XPIPE_PIPE_CH7_TXSTARTBLOCK_M (q1q2_xpipe_pipe_ch7_txstartblock_m),
      .XPIPE_PIPE_CH7_TXSWING_M      (q1q2_xpipe_pipe_ch7_txswing_m),
      .XPIPE_PIPE_CH7_TXSYNCHEADER_M (q1q2_xpipe_pipe_ch7_txsyncheader_m),
      .XPIPE_PIPE_CH7_PHYSTATUS_M    (q1q2_xpipe_pipe_ch7_phystatus_m),
      .XPIPE_PIPE_CH7_RXCHARISK_M    (q1q2_xpipe_pipe_ch7_rxcharisk_m),
      .XPIPE_PIPE_CH7_RXDATAVALID_M  (q1q2_xpipe_pipe_ch7_rxdatavalid_m),
      .XPIPE_PIPE_CH7_RXDATA_M       (q1q2_xpipe_pipe_ch7_rxdata_m),
      .XPIPE_PIPE_CH7_RXELECIDLE_M   (q1q2_xpipe_pipe_ch7_rxelecidle_m),
      .XPIPE_PIPE_CH7_RXSTARTBLOCK_M (q1q2_xpipe_pipe_ch7_rxstartblock_m),
      .XPIPE_PIPE_CH7_RXSTATUS_M     (q1q2_xpipe_pipe_ch7_rxstatus_m),
      .XPIPE_PIPE_CH7_RXSYNCHEADER_M (q1q2_xpipe_pipe_ch7_rxsyncheader_m),
      .XPIPE_PIPE_CH7_RXVALID_M      (q1q2_xpipe_pipe_ch7_rxvalid_m),
      .XPIPE_PIPE_CH7_TXDETECTRXLOOPBACK_M(q1q2_xpipe_pipe_ch7_txdetectrxloopback_m),

      .XPIPE_PIPE_CH8_PHYSTATUS      (q0q1_xpipe_pipe_ch8_phystatus_m),
      .XPIPE_PIPE_CH8_RXCHARISK      (q0q1_xpipe_pipe_ch8_rxcharisk_m),
      .XPIPE_PIPE_CH8_RXDATA         (q0q1_xpipe_pipe_ch8_rxdata_m), //ifcpmxpipechannel8xpiperxdata
      .XPIPE_PIPE_CH8_RXDATAVALID    (q0q1_xpipe_pipe_ch8_rxdatavalid_m),
      .XPIPE_PIPE_CH8_RXELECIDLE     (q0q1_xpipe_pipe_ch8_rxelecidle_m),
      .XPIPE_PIPE_CH8_RXSTARTBLOCK   (q0q1_xpipe_pipe_ch8_rxstartblock_m),
      .XPIPE_PIPE_CH8_RXSTATUS       (q0q1_xpipe_pipe_ch8_rxstatus_m),
      .XPIPE_PIPE_CH8_RXSYNCHEADER   (q0q1_xpipe_pipe_ch8_rxsyncheader_m),
      .XPIPE_PIPE_CH8_RXVALID        (q0q1_xpipe_pipe_ch8_rxvalid_m),
      .XPIPE_PIPE_CH8_POWERDOWN      (q0q1_xpipe_pipe_ch8_powerdown_m),
      .XPIPE_PIPE_CH8_RXPOLARITY     (q0q1_xpipe_pipe_ch8_rxpolarity_m),
      .XPIPE_PIPE_CH8_RXTERMINATION  (q0q1_xpipe_pipe_ch8_rxtermination_m),
      .XPIPE_PIPE_CH8_TXCHARISK      (q0q1_xpipe_pipe_ch8_txcharisk_m),
      .XPIPE_PIPE_CH8_TXCOMPLIANCE   (q0q1_xpipe_pipe_ch8_txcompliance_m),
      .XPIPE_PIPE_CH8_TXDATA         (q0q1_xpipe_pipe_ch8_txdata_m),
      .XPIPE_PIPE_CH8_TXDATAVALID    (q0q1_xpipe_pipe_ch8_txdatavalid_m),
      .XPIPE_PIPE_CH8_TXDEEMPH       (q0q1_xpipe_pipe_ch8_txdeemph_m),
      .XPIPE_PIPE_CH8_TXDETECTRXLOOPBACK(q0q1_xpipe_pipe_ch8_txdetectrxloopback_m),
      .XPIPE_PIPE_CH8_TXELECIDLE     (q0q1_xpipe_pipe_ch8_txelecidle_m),
      .XPIPE_PIPE_CH8_TXMAINCURSOR   (q0q1_xpipe_pipe_ch8_txmaincursor_m),
      .XPIPE_PIPE_CH8_TXMARGIN       (q0q1_xpipe_pipe_ch8_txmargin_m),
      .XPIPE_PIPE_CH8_TXPOSTCURSOR   (q0q1_xpipe_pipe_ch8_txpostcursor_m),
      .XPIPE_PIPE_CH8_TXPRECURSOR    (q0q1_xpipe_pipe_ch8_txprecursor_m),
      .XPIPE_PIPE_CH8_TXSTARTBLOCK   (q0q1_xpipe_pipe_ch8_txstartblock_m),
      .XPIPE_PIPE_CH8_TXSWING        (q0q1_xpipe_pipe_ch8_txswing_m),
      .XPIPE_PIPE_CH8_TXSYNCHEADER   (q0q1_xpipe_pipe_ch8_txsyncheader_m),

      .XPIPE_PIPE_CH8_POWERDOWN_M    (q1q2_xpipe_pipe_ch8_powerdown_m),
      .XPIPE_PIPE_CH8_RXPOLARITY_M   (q1q2_xpipe_pipe_ch8_rxpolarity_m),
      .XPIPE_PIPE_CH8_RXTERMINATION_M(q1q2_xpipe_pipe_ch8_rxtermination_m),
      .XPIPE_PIPE_CH8_TXCHARISK_M    (q1q2_xpipe_pipe_ch8_txcharisk_m),
      .XPIPE_PIPE_CH8_TXCOMPLIANCE_M (q1q2_xpipe_pipe_ch8_txcompliance_m),
      .XPIPE_PIPE_CH8_TXDATAVALID_M  (q1q2_xpipe_pipe_ch8_txdatavalid_m),
      .XPIPE_PIPE_CH8_TXDATA_M       (q1q2_xpipe_pipe_ch8_txdata_m),
      .XPIPE_PIPE_CH8_TXDEEMPH_M     (q1q2_xpipe_pipe_ch8_txdeemph_m),
      .XPIPE_PIPE_CH8_TXELECIDLE_M   (q1q2_xpipe_pipe_ch8_txelecidle_m),
      .XPIPE_PIPE_CH8_TXMAINCURSOR_M (q1q2_xpipe_pipe_ch8_txmaincursor_m),
      .XPIPE_PIPE_CH8_TXMARGIN_M     (q1q2_xpipe_pipe_ch8_txmargin_m),
      .XPIPE_PIPE_CH8_TXPOSTCURSOR_M (q1q2_xpipe_pipe_ch8_txpostcursor_m),
      .XPIPE_PIPE_CH8_TXPRECURSOR_M  (q1q2_xpipe_pipe_ch8_txprecursor_m),
      .XPIPE_PIPE_CH8_TXSTARTBLOCK_M (q1q2_xpipe_pipe_ch8_txstartblock_m),
      .XPIPE_PIPE_CH8_TXSWING_M      (q1q2_xpipe_pipe_ch8_txswing_m),
      .XPIPE_PIPE_CH8_TXSYNCHEADER_M (q1q2_xpipe_pipe_ch8_txsyncheader_m),
      .XPIPE_PIPE_CH8_PHYSTATUS_M    (q1q2_xpipe_pipe_ch8_phystatus_m),
      .XPIPE_PIPE_CH8_RXCHARISK_M    (q1q2_xpipe_pipe_ch8_rxcharisk_m),
      .XPIPE_PIPE_CH8_RXDATAVALID_M  (q1q2_xpipe_pipe_ch8_rxdatavalid_m),
      .XPIPE_PIPE_CH8_RXDATA_M       (q1q2_xpipe_pipe_ch8_rxdata_m),
      .XPIPE_PIPE_CH8_RXELECIDLE_M   (q1q2_xpipe_pipe_ch8_rxelecidle_m),
      .XPIPE_PIPE_CH8_RXSTARTBLOCK_M (q1q2_xpipe_pipe_ch8_rxstartblock_m),
      .XPIPE_PIPE_CH8_RXSTATUS_M     (q1q2_xpipe_pipe_ch8_rxstatus_m),
      .XPIPE_PIPE_CH8_RXSYNCHEADER_M (q1q2_xpipe_pipe_ch8_rxsyncheader_m),
      .XPIPE_PIPE_CH8_RXVALID_M      (q1q2_xpipe_pipe_ch8_rxvalid_m),
      .XPIPE_PIPE_CH8_TXDETECTRXLOOPBACK_M(q1q2_xpipe_pipe_ch8_txdetectrxloopback_m),

      .XPIPE_PIPE_CH9_PHYSTATUS      (q0q1_xpipe_pipe_ch9_phystatus_m),
      .XPIPE_PIPE_CH9_RXCHARISK      (q0q1_xpipe_pipe_ch9_rxcharisk_m),
      .XPIPE_PIPE_CH9_RXDATA         (q0q1_xpipe_pipe_ch9_rxdata_m),
      .XPIPE_PIPE_CH9_RXDATAVALID    (q0q1_xpipe_pipe_ch9_rxdatavalid_m),
      .XPIPE_PIPE_CH9_RXELECIDLE     (q0q1_xpipe_pipe_ch9_rxelecidle_m),
      .XPIPE_PIPE_CH9_RXSTARTBLOCK   (q0q1_xpipe_pipe_ch9_rxstartblock_m),
      .XPIPE_PIPE_CH9_RXSTATUS       (q0q1_xpipe_pipe_ch9_rxstatus_m),
      .XPIPE_PIPE_CH9_RXSYNCHEADER   (q0q1_xpipe_pipe_ch9_rxsyncheader_m),
      .XPIPE_PIPE_CH9_RXVALID        (q0q1_xpipe_pipe_ch9_rxvalid_m),
      .XPIPE_PIPE_CH9_POWERDOWN      (q0q1_xpipe_pipe_ch9_powerdown_m),
      .XPIPE_PIPE_CH9_RXPOLARITY     (q0q1_xpipe_pipe_ch9_rxpolarity_m),
      .XPIPE_PIPE_CH9_RXTERMINATION  (q0q1_xpipe_pipe_ch9_rxtermination_m),
      .XPIPE_PIPE_CH9_TXCHARISK      (q0q1_xpipe_pipe_ch9_txcharisk_m),
      .XPIPE_PIPE_CH9_TXCOMPLIANCE   (q0q1_xpipe_pipe_ch9_txcompliance_m),
      .XPIPE_PIPE_CH9_TXDATA         (q0q1_xpipe_pipe_ch9_txdata_m),
      .XPIPE_PIPE_CH9_TXDATAVALID    (q0q1_xpipe_pipe_ch9_txdatavalid_m),
      .XPIPE_PIPE_CH9_TXDEEMPH       (q0q1_xpipe_pipe_ch9_txdeemph_m),
      .XPIPE_PIPE_CH9_TXDETECTRXLOOPBACK(q0q1_xpipe_pipe_ch9_txdetectrxloopback_m),
      .XPIPE_PIPE_CH9_TXELECIDLE     (q0q1_xpipe_pipe_ch9_txelecidle_m),
      .XPIPE_PIPE_CH9_TXMAINCURSOR   (q0q1_xpipe_pipe_ch9_txmaincursor_m),
      .XPIPE_PIPE_CH9_TXMARGIN       (q0q1_xpipe_pipe_ch9_txmargin_m),
      .XPIPE_PIPE_CH9_TXPOSTCURSOR   (q0q1_xpipe_pipe_ch9_txpostcursor_m),
      .XPIPE_PIPE_CH9_TXPRECURSOR    (q0q1_xpipe_pipe_ch9_txprecursor_m),
      .XPIPE_PIPE_CH9_TXSTARTBLOCK   (q0q1_xpipe_pipe_ch9_txstartblock_m),
      .XPIPE_PIPE_CH9_TXSWING        (q0q1_xpipe_pipe_ch9_txswing_m),
      .XPIPE_PIPE_CH9_TXSYNCHEADER   (q0q1_xpipe_pipe_ch9_txsyncheader_m),

      .XPIPE_PIPE_CH9_POWERDOWN_M    (q1q2_xpipe_pipe_ch9_powerdown_m),
      .XPIPE_PIPE_CH9_RXPOLARITY_M   (q1q2_xpipe_pipe_ch9_rxpolarity_m),
      .XPIPE_PIPE_CH9_RXTERMINATION_M(q1q2_xpipe_pipe_ch9_rxtermination_m),
      .XPIPE_PIPE_CH9_TXCHARISK_M    (q1q2_xpipe_pipe_ch9_txcharisk_m),
      .XPIPE_PIPE_CH9_TXCOMPLIANCE_M (q1q2_xpipe_pipe_ch9_txcompliance_m),
      .XPIPE_PIPE_CH9_TXDATAVALID_M  (q1q2_xpipe_pipe_ch9_txdatavalid_m),
      .XPIPE_PIPE_CH9_TXDATA_M       (q1q2_xpipe_pipe_ch9_txdata_m),
      .XPIPE_PIPE_CH9_TXDEEMPH_M     (q1q2_xpipe_pipe_ch9_txdeemph_m),
      .XPIPE_PIPE_CH9_TXELECIDLE_M   (q1q2_xpipe_pipe_ch9_txelecidle_m),
      .XPIPE_PIPE_CH9_TXMAINCURSOR_M (q1q2_xpipe_pipe_ch9_txmaincursor_m),
      .XPIPE_PIPE_CH9_TXMARGIN_M     (q1q2_xpipe_pipe_ch9_txmargin_m),
      .XPIPE_PIPE_CH9_TXPOSTCURSOR_M (q1q2_xpipe_pipe_ch9_txpostcursor_m),
      .XPIPE_PIPE_CH9_TXPRECURSOR_M  (q1q2_xpipe_pipe_ch9_txprecursor_m),
      .XPIPE_PIPE_CH9_TXSTARTBLOCK_M (q1q2_xpipe_pipe_ch9_txstartblock_m),
      .XPIPE_PIPE_CH9_TXSWING_M      (q1q2_xpipe_pipe_ch9_txswing_m),
      .XPIPE_PIPE_CH9_TXSYNCHEADER_M (q1q2_xpipe_pipe_ch9_txsyncheader_m),
      .XPIPE_PIPE_CH9_PHYSTATUS_M    (q1q2_xpipe_pipe_ch9_phystatus_m),
      .XPIPE_PIPE_CH9_RXCHARISK_M    (q1q2_xpipe_pipe_ch9_rxcharisk_m),
      .XPIPE_PIPE_CH9_RXDATAVALID_M  (q1q2_xpipe_pipe_ch9_rxdatavalid_m),
      .XPIPE_PIPE_CH9_RXDATA_M       (q1q2_xpipe_pipe_ch9_rxdata_m),
      .XPIPE_PIPE_CH9_RXELECIDLE_M   (q1q2_xpipe_pipe_ch9_rxelecidle_m),
      .XPIPE_PIPE_CH9_RXSTARTBLOCK_M (q1q2_xpipe_pipe_ch9_rxstartblock_m),
      .XPIPE_PIPE_CH9_RXSTATUS_M     (q1q2_xpipe_pipe_ch9_rxstatus_m),
      .XPIPE_PIPE_CH9_RXSYNCHEADER_M (q1q2_xpipe_pipe_ch9_rxsyncheader_m),
      .XPIPE_PIPE_CH9_RXVALID_M      (q1q2_xpipe_pipe_ch9_rxvalid_m),
      .XPIPE_PIPE_CH9_TXDETECTRXLOOPBACK_M(q1q2_xpipe_pipe_ch9_txdetectrxloopback_m),

      .XPIPE_PIPE_CH10_PHYSTATUS     (q0q1_xpipe_pipe_ch10_phystatus_m),
      .XPIPE_PIPE_CH10_RXCHARISK     (q0q1_xpipe_pipe_ch10_rxcharisk_m),
      .XPIPE_PIPE_CH10_RXDATA        (q0q1_xpipe_pipe_ch10_rxdata_m), //ifcpmxpipechannel10xpiperxdata
      .XPIPE_PIPE_CH10_RXDATAVALID   (q0q1_xpipe_pipe_ch10_rxdatavalid_m),
      .XPIPE_PIPE_CH10_RXELECIDLE    (q0q1_xpipe_pipe_ch10_rxelecidle_m),
      .XPIPE_PIPE_CH10_RXSTARTBLOCK  (q0q1_xpipe_pipe_ch10_rxstartblock_m),
      .XPIPE_PIPE_CH10_RXSTATUS      (q0q1_xpipe_pipe_ch10_rxstatus_m),
      .XPIPE_PIPE_CH10_RXSYNCHEADER  (q0q1_xpipe_pipe_ch10_rxsyncheader_m),
      .XPIPE_PIPE_CH10_RXVALID       (q0q1_xpipe_pipe_ch10_rxvalid_m),
      .XPIPE_PIPE_CH10_POWERDOWN     (q0q1_xpipe_pipe_ch10_powerdown_m),
      .XPIPE_PIPE_CH10_RXPOLARITY    (q0q1_xpipe_pipe_ch10_rxpolarity_m),
      .XPIPE_PIPE_CH10_RXTERMINATION (q0q1_xpipe_pipe_ch10_rxtermination_m),
      .XPIPE_PIPE_CH10_TXCHARISK     (q0q1_xpipe_pipe_ch10_txcharisk_m),
      .XPIPE_PIPE_CH10_TXCOMPLIANCE  (q0q1_xpipe_pipe_ch10_txcompliance_m),
      .XPIPE_PIPE_CH10_TXDATA        (q0q1_xpipe_pipe_ch10_txdata_m),
      .XPIPE_PIPE_CH10_TXDATAVALID   (q0q1_xpipe_pipe_ch10_txdatavalid_m),
      .XPIPE_PIPE_CH10_TXDEEMPH      (q0q1_xpipe_pipe_ch10_txdeemph_m),
      .XPIPE_PIPE_CH10_TXDETECTRXLOOPBACK(q0q1_xpipe_pipe_ch10_txdetectrxloopback_m),
      .XPIPE_PIPE_CH10_TXELECIDLE    (q0q1_xpipe_pipe_ch10_txelecidle_m),
      .XPIPE_PIPE_CH10_TXMAINCURSOR  (q0q1_xpipe_pipe_ch10_txmaincursor_m),
      .XPIPE_PIPE_CH10_TXMARGIN      (q0q1_xpipe_pipe_ch10_txmargin_m),
      .XPIPE_PIPE_CH10_TXPOSTCURSOR  (q0q1_xpipe_pipe_ch10_txpostcursor_m),
      .XPIPE_PIPE_CH10_TXPRECURSOR   (q0q1_xpipe_pipe_ch10_txprecursor_m),
      .XPIPE_PIPE_CH10_TXSTARTBLOCK  (q0q1_xpipe_pipe_ch10_txstartblock_m),
      .XPIPE_PIPE_CH10_TXSWING       (q0q1_xpipe_pipe_ch10_txswing_m),
      .XPIPE_PIPE_CH10_TXSYNCHEADER  (q0q1_xpipe_pipe_ch10_txsyncheader_m),

      .XPIPE_PIPE_CH10_POWERDOWN_M   (q1q2_xpipe_pipe_ch10_powerdown_m),
      .XPIPE_PIPE_CH10_RXPOLARITY_M  (q1q2_xpipe_pipe_ch10_rxpolarity_m),
      .XPIPE_PIPE_CH10_RXTERMINATION_M(q1q2_xpipe_pipe_ch10_rxtermination_m),
      .XPIPE_PIPE_CH10_TXCHARISK_M   (q1q2_xpipe_pipe_ch10_txcharisk_m),
      .XPIPE_PIPE_CH10_TXCOMPLIANCE_M(q1q2_xpipe_pipe_ch10_txcompliance_m),
      .XPIPE_PIPE_CH10_TXDATAVALID_M (q1q2_xpipe_pipe_ch10_txdatavalid_m),
      .XPIPE_PIPE_CH10_TXDATA_M      (q1q2_xpipe_pipe_ch10_txdata_m),
      .XPIPE_PIPE_CH10_TXDEEMPH_M    (q1q2_xpipe_pipe_ch10_txdeemph_m),
      .XPIPE_PIPE_CH10_TXELECIDLE_M  (q1q2_xpipe_pipe_ch10_txelecidle_m),
      .XPIPE_PIPE_CH10_TXMAINCURSOR_M(q1q2_xpipe_pipe_ch10_txmaincursor_m),
      .XPIPE_PIPE_CH10_TXMARGIN_M    (q1q2_xpipe_pipe_ch10_txmargin_m),
      .XPIPE_PIPE_CH10_TXPOSTCURSOR_M(q1q2_xpipe_pipe_ch10_txpostcursor_m),
      .XPIPE_PIPE_CH10_TXPRECURSOR_M (q1q2_xpipe_pipe_ch10_txprecursor_m),
      .XPIPE_PIPE_CH10_TXSTARTBLOCK_M(q1q2_xpipe_pipe_ch10_txstartblock_m),
      .XPIPE_PIPE_CH10_TXSWING_M     (q1q2_xpipe_pipe_ch10_txswing_m),
      .XPIPE_PIPE_CH10_TXSYNCHEADER_M(q1q2_xpipe_pipe_ch10_txsyncheader_m),
      .XPIPE_PIPE_CH10_PHYSTATUS_M   (q1q2_xpipe_pipe_ch10_phystatus_m),
      .XPIPE_PIPE_CH10_RXCHARISK_M   (q1q2_xpipe_pipe_ch10_rxcharisk_m),
      .XPIPE_PIPE_CH10_RXDATAVALID_M (q1q2_xpipe_pipe_ch10_rxdatavalid_m),
      .XPIPE_PIPE_CH10_RXDATA_M      (q1q2_xpipe_pipe_ch10_rxdata_m),
      .XPIPE_PIPE_CH10_RXELECIDLE_M  (q1q2_xpipe_pipe_ch10_rxelecidle_m),
      .XPIPE_PIPE_CH10_RXSTARTBLOCK_M(q1q2_xpipe_pipe_ch10_rxstartblock_m),
      .XPIPE_PIPE_CH10_RXSTATUS_M    (q1q2_xpipe_pipe_ch10_rxstatus_m),
      .XPIPE_PIPE_CH10_RXSYNCHEADER_M(q1q2_xpipe_pipe_ch10_rxsyncheader_m),
      .XPIPE_PIPE_CH10_RXVALID_M     (q1q2_xpipe_pipe_ch10_rxvalid_m),
      .XPIPE_PIPE_CH10_TXDETECTRXLOOPBACK_M(q1q2_xpipe_pipe_ch10_txdetectrxloopback_m),

      .XPIPE_PIPE_CH11_PHYSTATUS     (q0q1_xpipe_pipe_ch11_phystatus_m),
      .XPIPE_PIPE_CH11_RXCHARISK     (q0q1_xpipe_pipe_ch11_rxcharisk_m),
      .XPIPE_PIPE_CH11_RXDATA        (q0q1_xpipe_pipe_ch11_rxdata_m), //ifcpmxpipechannel11xpiperxdata
      .XPIPE_PIPE_CH11_RXDATAVALID   (q0q1_xpipe_pipe_ch11_rxdatavalid_m),
      .XPIPE_PIPE_CH11_RXELECIDLE    (q0q1_xpipe_pipe_ch11_rxelecidle_m),
      .XPIPE_PIPE_CH11_RXSTARTBLOCK  (q0q1_xpipe_pipe_ch11_rxstartblock_m),
      .XPIPE_PIPE_CH11_RXSTATUS      (q0q1_xpipe_pipe_ch11_rxstatus_m),
      .XPIPE_PIPE_CH11_RXSYNCHEADER  (q0q1_xpipe_pipe_ch11_rxsyncheader_m),
      .XPIPE_PIPE_CH11_RXVALID       (q0q1_xpipe_pipe_ch11_rxvalid_m),
      .XPIPE_PIPE_CH11_POWERDOWN     (q0q1_xpipe_pipe_ch11_powerdown_m),
      .XPIPE_PIPE_CH11_RXPOLARITY    (q0q1_xpipe_pipe_ch11_rxpolarity_m),
      .XPIPE_PIPE_CH11_RXTERMINATION (q0q1_xpipe_pipe_ch11_rxtermination_m),
      .XPIPE_PIPE_CH11_TXCHARISK     (q0q1_xpipe_pipe_ch11_txcharisk_m),
      .XPIPE_PIPE_CH11_TXCOMPLIANCE  (q0q1_xpipe_pipe_ch11_txcompliance_m),
      .XPIPE_PIPE_CH11_TXDATA        (q0q1_xpipe_pipe_ch11_txdata_m),
      .XPIPE_PIPE_CH11_TXDATAVALID   (q0q1_xpipe_pipe_ch11_txdatavalid_m),
      .XPIPE_PIPE_CH11_TXDEEMPH      (q0q1_xpipe_pipe_ch11_txdeemph_m),
      .XPIPE_PIPE_CH11_TXDETECTRXLOOPBACK(q0q1_xpipe_pipe_ch11_txdetectrxloopback_m),
      .XPIPE_PIPE_CH11_TXELECIDLE    (q0q1_xpipe_pipe_ch11_txelecidle_m),
      .XPIPE_PIPE_CH11_TXMAINCURSOR  (q0q1_xpipe_pipe_ch11_txmaincursor_m),
      .XPIPE_PIPE_CH11_TXMARGIN      (q0q1_xpipe_pipe_ch11_txmargin_m),
      .XPIPE_PIPE_CH11_TXPOSTCURSOR  (q0q1_xpipe_pipe_ch11_txpostcursor_m),
      .XPIPE_PIPE_CH11_TXPRECURSOR   (q0q1_xpipe_pipe_ch11_txprecursor_m),
      .XPIPE_PIPE_CH11_TXSTARTBLOCK  (q0q1_xpipe_pipe_ch11_txstartblock_m),
      .XPIPE_PIPE_CH11_TXSWING       (q0q1_xpipe_pipe_ch11_txswing_m),
      .XPIPE_PIPE_CH11_TXSYNCHEADER  (q0q1_xpipe_pipe_ch11_txsyncheader_m),

      .XPIPE_PIPE_CH11_POWERDOWN_M   (q1q2_xpipe_pipe_ch11_powerdown_m),
      .XPIPE_PIPE_CH11_RXPOLARITY_M  (q1q2_xpipe_pipe_ch11_rxpolarity_m),
      .XPIPE_PIPE_CH11_RXTERMINATION_M(q1q2_xpipe_pipe_ch11_rxtermination_m),
      .XPIPE_PIPE_CH11_TXCHARISK_M   (q1q2_xpipe_pipe_ch11_txcharisk_m),
      .XPIPE_PIPE_CH11_TXCOMPLIANCE_M(q1q2_xpipe_pipe_ch11_txcompliance_m),
      .XPIPE_PIPE_CH11_TXDATAVALID_M (q1q2_xpipe_pipe_ch11_txdatavalid_m),
      .XPIPE_PIPE_CH11_TXDATA_M      (q1q2_xpipe_pipe_ch11_txdata_m),
      .XPIPE_PIPE_CH11_TXDEEMPH_M    (q1q2_xpipe_pipe_ch11_txdeemph_m),
      .XPIPE_PIPE_CH11_TXELECIDLE_M  (q1q2_xpipe_pipe_ch11_txelecidle_m),
      .XPIPE_PIPE_CH11_TXMAINCURSOR_M(q1q2_xpipe_pipe_ch11_txmaincursor_m),
      .XPIPE_PIPE_CH11_TXMARGIN_M    (q1q2_xpipe_pipe_ch11_txmargin_m),
      .XPIPE_PIPE_CH11_TXPOSTCURSOR_M(q1q2_xpipe_pipe_ch11_txpostcursor_m),
      .XPIPE_PIPE_CH11_TXPRECURSOR_M (q1q2_xpipe_pipe_ch11_txprecursor_m),
      .XPIPE_PIPE_CH11_TXSTARTBLOCK_M(q1q2_xpipe_pipe_ch11_txstartblock_m),
      .XPIPE_PIPE_CH11_TXSWING_M     (q1q2_xpipe_pipe_ch11_txswing_m),
      .XPIPE_PIPE_CH11_TXSYNCHEADER_M(q1q2_xpipe_pipe_ch11_txsyncheader_m),
      .XPIPE_PIPE_CH11_PHYSTATUS_M   (q1q2_xpipe_pipe_ch11_phystatus_m),
      .XPIPE_PIPE_CH11_RXCHARISK_M   (q1q2_xpipe_pipe_ch11_rxcharisk_m),
      .XPIPE_PIPE_CH11_RXDATAVALID_M (q1q2_xpipe_pipe_ch11_rxdatavalid_m),
      .XPIPE_PIPE_CH11_RXDATA_M      (q1q2_xpipe_pipe_ch11_rxdata_m),
      .XPIPE_PIPE_CH11_RXELECIDLE_M  (q1q2_xpipe_pipe_ch11_rxelecidle_m),
      .XPIPE_PIPE_CH11_RXSTARTBLOCK_M(q1q2_xpipe_pipe_ch11_rxstartblock_m),
      .XPIPE_PIPE_CH11_RXSTATUS_M    (q1q2_xpipe_pipe_ch11_rxstatus_m),
      .XPIPE_PIPE_CH11_RXSYNCHEADER_M(q1q2_xpipe_pipe_ch11_rxsyncheader_m),
      .XPIPE_PIPE_CH11_RXVALID_M     (q1q2_xpipe_pipe_ch11_rxvalid_m),
      .XPIPE_PIPE_CH11_TXDETECTRXLOOPBACK_M(q1q2_xpipe_pipe_ch11_txdetectrxloopback_m),

      .XPIPE_PIPE_CH12_PHYSTATUS     (q0q1_xpipe_pipe_ch12_phystatus_m),
      .XPIPE_PIPE_CH12_RXCHARISK     (q0q1_xpipe_pipe_ch12_rxcharisk_m),
      .XPIPE_PIPE_CH12_RXDATA        (q0q1_xpipe_pipe_ch12_rxdata_m), //ifcpmxpipechannel12xpiperxdata
      .XPIPE_PIPE_CH12_RXDATAVALID   (q0q1_xpipe_pipe_ch12_rxdatavalid_m),
      .XPIPE_PIPE_CH12_RXELECIDLE    (q0q1_xpipe_pipe_ch12_rxelecidle_m),
      .XPIPE_PIPE_CH12_RXSTARTBLOCK  (q0q1_xpipe_pipe_ch12_rxstartblock_m),
      .XPIPE_PIPE_CH12_RXSTATUS      (q0q1_xpipe_pipe_ch12_rxstatus_m),
      .XPIPE_PIPE_CH12_RXSYNCHEADER  (q0q1_xpipe_pipe_ch12_rxsyncheader_m),
      .XPIPE_PIPE_CH12_RXVALID       (q0q1_xpipe_pipe_ch12_rxvalid_m),
      .XPIPE_PIPE_CH12_POWERDOWN     (q0q1_xpipe_pipe_ch12_powerdown_m),
      .XPIPE_PIPE_CH12_RXPOLARITY    (q0q1_xpipe_pipe_ch12_rxpolarity_m),
      .XPIPE_PIPE_CH12_RXTERMINATION (q0q1_xpipe_pipe_ch12_rxtermination_m),
      .XPIPE_PIPE_CH12_TXCHARISK     (q0q1_xpipe_pipe_ch12_txcharisk_m),
      .XPIPE_PIPE_CH12_TXCOMPLIANCE  (q0q1_xpipe_pipe_ch12_txcompliance_m),
      .XPIPE_PIPE_CH12_TXDATA        (q0q1_xpipe_pipe_ch12_txdata_m),
      .XPIPE_PIPE_CH12_TXDATAVALID   (q0q1_xpipe_pipe_ch12_txdatavalid_m),
      .XPIPE_PIPE_CH12_TXDEEMPH      (q0q1_xpipe_pipe_ch12_txdeemph_m),
      .XPIPE_PIPE_CH12_TXDETECTRXLOOPBACK(q0q1_xpipe_pipe_ch12_txdetectrxloopback_m),
      .XPIPE_PIPE_CH12_TXELECIDLE    (q0q1_xpipe_pipe_ch12_txelecidle_m),
      .XPIPE_PIPE_CH12_TXMAINCURSOR  (q0q1_xpipe_pipe_ch12_txmaincursor_m),
      .XPIPE_PIPE_CH12_TXMARGIN      (q0q1_xpipe_pipe_ch12_txmargin_m),
      .XPIPE_PIPE_CH12_TXPOSTCURSOR  (q0q1_xpipe_pipe_ch12_txpostcursor_m),
      .XPIPE_PIPE_CH12_TXPRECURSOR   (q0q1_xpipe_pipe_ch12_txprecursor_m),
      .XPIPE_PIPE_CH12_TXSTARTBLOCK  (q0q1_xpipe_pipe_ch12_txstartblock_m),
      .XPIPE_PIPE_CH12_TXSWING       (q0q1_xpipe_pipe_ch12_txswing_m),
      .XPIPE_PIPE_CH12_TXSYNCHEADER  (q0q1_xpipe_pipe_ch12_txsyncheader_m),

      .XPIPE_PIPE_CH12_POWERDOWN_M   (q1q2_xpipe_pipe_ch12_powerdown_m),
      .XPIPE_PIPE_CH12_RXPOLARITY_M  (q1q2_xpipe_pipe_ch12_rxpolarity_m),
      .XPIPE_PIPE_CH12_RXTERMINATION_M(q1q2_xpipe_pipe_ch12_rxtermination_m),
      .XPIPE_PIPE_CH12_TXCHARISK_M   (q1q2_xpipe_pipe_ch12_txcharisk_m),
      .XPIPE_PIPE_CH12_TXCOMPLIANCE_M(q1q2_xpipe_pipe_ch12_txcompliance_m),
      .XPIPE_PIPE_CH12_TXDATAVALID_M (q1q2_xpipe_pipe_ch12_txdatavalid_m),
      .XPIPE_PIPE_CH12_TXDATA_M      (q1q2_xpipe_pipe_ch12_txdata_m),
      .XPIPE_PIPE_CH12_TXDEEMPH_M    (q1q2_xpipe_pipe_ch12_txdeemph_m),
      .XPIPE_PIPE_CH12_TXELECIDLE_M  (q1q2_xpipe_pipe_ch12_txelecidle_m),
      .XPIPE_PIPE_CH12_TXMAINCURSOR_M(q1q2_xpipe_pipe_ch12_txmaincursor_m),
      .XPIPE_PIPE_CH12_TXMARGIN_M    (q1q2_xpipe_pipe_ch12_txmargin_m),
      .XPIPE_PIPE_CH12_TXPOSTCURSOR_M(q1q2_xpipe_pipe_ch12_txpostcursor_m),
      .XPIPE_PIPE_CH12_TXPRECURSOR_M (q1q2_xpipe_pipe_ch12_txprecursor_m),
      .XPIPE_PIPE_CH12_TXSTARTBLOCK_M(q1q2_xpipe_pipe_ch12_txstartblock_m),
      .XPIPE_PIPE_CH12_TXSWING_M     (q1q2_xpipe_pipe_ch12_txswing_m),
      .XPIPE_PIPE_CH12_TXSYNCHEADER_M(q1q2_xpipe_pipe_ch12_txsyncheader_m),
      .XPIPE_PIPE_CH12_PHYSTATUS_M   (q1q2_xpipe_pipe_ch12_phystatus_m),
      .XPIPE_PIPE_CH12_RXCHARISK_M   (q1q2_xpipe_pipe_ch12_rxcharisk_m),
      .XPIPE_PIPE_CH12_RXDATAVALID_M (q1q2_xpipe_pipe_ch12_rxdatavalid_m),
      .XPIPE_PIPE_CH12_RXDATA_M      (q1q2_xpipe_pipe_ch12_rxdata_m),
      .XPIPE_PIPE_CH12_RXELECIDLE_M  (q1q2_xpipe_pipe_ch12_rxelecidle_m),
      .XPIPE_PIPE_CH12_RXSTARTBLOCK_M(q1q2_xpipe_pipe_ch12_rxstartblock_m),
      .XPIPE_PIPE_CH12_RXSTATUS_M    (q1q2_xpipe_pipe_ch12_rxstatus_m),
      .XPIPE_PIPE_CH12_RXSYNCHEADER_M(q1q2_xpipe_pipe_ch12_rxsyncheader_m),
      .XPIPE_PIPE_CH12_RXVALID_M     (q1q2_xpipe_pipe_ch12_rxvalid_m),
      .XPIPE_PIPE_CH12_TXDETECTRXLOOPBACK_M(q1q2_xpipe_pipe_ch12_txdetectrxloopback_m),

      .XPIPE_PIPE_CH13_PHYSTATUS     (q0q1_xpipe_pipe_ch13_phystatus_m),
      .XPIPE_PIPE_CH13_RXCHARISK     (q0q1_xpipe_pipe_ch13_rxcharisk_m),
      .XPIPE_PIPE_CH13_RXDATA        (q0q1_xpipe_pipe_ch13_rxdata_m), //ifcpmxpipechannel13xpiperxdata
      .XPIPE_PIPE_CH13_RXDATAVALID   (q0q1_xpipe_pipe_ch13_rxdatavalid_m),
      .XPIPE_PIPE_CH13_RXELECIDLE    (q0q1_xpipe_pipe_ch13_rxelecidle_m),
      .XPIPE_PIPE_CH13_RXSTARTBLOCK  (q0q1_xpipe_pipe_ch13_rxstartblock_m),
      .XPIPE_PIPE_CH13_RXSTATUS      (q0q1_xpipe_pipe_ch13_rxstatus_m),
      .XPIPE_PIPE_CH13_RXSYNCHEADER  (q0q1_xpipe_pipe_ch13_rxsyncheader_m),
      .XPIPE_PIPE_CH13_RXVALID       (q0q1_xpipe_pipe_ch13_rxvalid_m),
      .XPIPE_PIPE_CH13_POWERDOWN     (q0q1_xpipe_pipe_ch13_powerdown_m),
      .XPIPE_PIPE_CH13_RXPOLARITY    (q0q1_xpipe_pipe_ch13_rxpolarity_m),
      .XPIPE_PIPE_CH13_RXTERMINATION (q0q1_xpipe_pipe_ch13_rxtermination_m),
      .XPIPE_PIPE_CH13_TXCHARISK     (q0q1_xpipe_pipe_ch13_txcharisk_m),
      .XPIPE_PIPE_CH13_TXCOMPLIANCE  (q0q1_xpipe_pipe_ch13_txcompliance_m),
      .XPIPE_PIPE_CH13_TXDATA        (q0q1_xpipe_pipe_ch13_txdata_m),
      .XPIPE_PIPE_CH13_TXDATAVALID   (q0q1_xpipe_pipe_ch13_txdatavalid_m),
      .XPIPE_PIPE_CH13_TXDEEMPH      (q0q1_xpipe_pipe_ch13_txdeemph_m),
      .XPIPE_PIPE_CH13_TXDETECTRXLOOPBACK(q0q1_xpipe_pipe_ch13_txdetectrxloopback_m),
      .XPIPE_PIPE_CH13_TXELECIDLE    (q0q1_xpipe_pipe_ch13_txelecidle_m),
      .XPIPE_PIPE_CH13_TXMAINCURSOR  (q0q1_xpipe_pipe_ch13_txmaincursor_m),
      .XPIPE_PIPE_CH13_TXMARGIN      (q0q1_xpipe_pipe_ch13_txmargin_m),
      .XPIPE_PIPE_CH13_TXPOSTCURSOR  (q0q1_xpipe_pipe_ch13_txpostcursor_m),
      .XPIPE_PIPE_CH13_TXPRECURSOR   (q0q1_xpipe_pipe_ch13_txprecursor_m),
      .XPIPE_PIPE_CH13_TXSTARTBLOCK  (q0q1_xpipe_pipe_ch13_txstartblock_m),
      .XPIPE_PIPE_CH13_TXSWING       (q0q1_xpipe_pipe_ch13_txswing_m),
      .XPIPE_PIPE_CH13_TXSYNCHEADER  (q0q1_xpipe_pipe_ch13_txsyncheader_m),

      .XPIPE_PIPE_CH13_POWERDOWN_M   (q1q2_xpipe_pipe_ch13_powerdown_m),
      .XPIPE_PIPE_CH13_RXPOLARITY_M  (q1q2_xpipe_pipe_ch13_rxpolarity_m),
      .XPIPE_PIPE_CH13_RXTERMINATION_M(q1q2_xpipe_pipe_ch13_rxtermination_m),
      .XPIPE_PIPE_CH13_TXCHARISK_M   (q1q2_xpipe_pipe_ch13_txcharisk_m),
      .XPIPE_PIPE_CH13_TXCOMPLIANCE_M(q1q2_xpipe_pipe_ch13_txcompliance_m),
      .XPIPE_PIPE_CH13_TXDATAVALID_M (q1q2_xpipe_pipe_ch13_txdatavalid_m),
      .XPIPE_PIPE_CH13_TXDATA_M      (q1q2_xpipe_pipe_ch13_txdata_m),
      .XPIPE_PIPE_CH13_TXDEEMPH_M    (q1q2_xpipe_pipe_ch13_txdeemph_m),
      .XPIPE_PIPE_CH13_TXELECIDLE_M  (q1q2_xpipe_pipe_ch13_txelecidle_m),
      .XPIPE_PIPE_CH13_TXMAINCURSOR_M(q1q2_xpipe_pipe_ch13_txmaincursor_m),
      .XPIPE_PIPE_CH13_TXMARGIN_M    (q1q2_xpipe_pipe_ch13_txmargin_m),
      .XPIPE_PIPE_CH13_TXPOSTCURSOR_M(q1q2_xpipe_pipe_ch13_txpostcursor_m),
      .XPIPE_PIPE_CH13_TXPRECURSOR_M (q1q2_xpipe_pipe_ch13_txprecursor_m),
      .XPIPE_PIPE_CH13_TXSTARTBLOCK_M(q1q2_xpipe_pipe_ch13_txstartblock_m),
      .XPIPE_PIPE_CH13_TXSWING_M     (q1q2_xpipe_pipe_ch13_txswing_m),
      .XPIPE_PIPE_CH13_TXSYNCHEADER_M(q1q2_xpipe_pipe_ch13_txsyncheader_m),
      .XPIPE_PIPE_CH13_PHYSTATUS_M   (q1q2_xpipe_pipe_ch13_phystatus_m),
      .XPIPE_PIPE_CH13_RXCHARISK_M   (q1q2_xpipe_pipe_ch13_rxcharisk_m),
      .XPIPE_PIPE_CH13_RXDATAVALID_M (q1q2_xpipe_pipe_ch13_rxdatavalid_m),
      .XPIPE_PIPE_CH13_RXDATA_M      (q1q2_xpipe_pipe_ch13_rxdata_m),
      .XPIPE_PIPE_CH13_RXELECIDLE_M  (q1q2_xpipe_pipe_ch13_rxelecidle_m),
      .XPIPE_PIPE_CH13_RXSTARTBLOCK_M(q1q2_xpipe_pipe_ch13_rxstartblock_m),
      .XPIPE_PIPE_CH13_RXSTATUS_M    (q1q2_xpipe_pipe_ch13_rxstatus_m),
      .XPIPE_PIPE_CH13_RXSYNCHEADER_M(q1q2_xpipe_pipe_ch13_rxsyncheader_m),
      .XPIPE_PIPE_CH13_RXVALID_M     (q1q2_xpipe_pipe_ch13_rxvalid_m),
      .XPIPE_PIPE_CH13_TXDETECTRXLOOPBACK_M(q1q2_xpipe_pipe_ch13_txdetectrxloopback_m),

      .XPIPE_PIPE_CH14_PHYSTATUS     (q0q1_xpipe_pipe_ch14_phystatus_m),
      .XPIPE_PIPE_CH14_RXCHARISK     (q0q1_xpipe_pipe_ch14_rxcharisk_m),
      .XPIPE_PIPE_CH14_RXDATA        (q0q1_xpipe_pipe_ch14_rxdata_m), //ifcpmxpipechannel14xpiperxdata
      .XPIPE_PIPE_CH14_RXDATAVALID   (q0q1_xpipe_pipe_ch14_rxdatavalid_m),
      .XPIPE_PIPE_CH14_RXELECIDLE    (q0q1_xpipe_pipe_ch14_rxelecidle_m),
      .XPIPE_PIPE_CH14_RXSTARTBLOCK  (q0q1_xpipe_pipe_ch14_rxstartblock_m),
      .XPIPE_PIPE_CH14_RXSTATUS      (q0q1_xpipe_pipe_ch14_rxstatus_m),
      .XPIPE_PIPE_CH14_RXSYNCHEADER  (q0q1_xpipe_pipe_ch14_rxsyncheader_m),
      .XPIPE_PIPE_CH14_RXVALID       (q0q1_xpipe_pipe_ch14_rxvalid_m),
      .XPIPE_PIPE_CH14_POWERDOWN     (q0q1_xpipe_pipe_ch14_powerdown_m),
      .XPIPE_PIPE_CH14_RXPOLARITY    (q0q1_xpipe_pipe_ch14_rxpolarity_m),
      .XPIPE_PIPE_CH14_RXTERMINATION (q0q1_xpipe_pipe_ch14_rxtermination_m),
      .XPIPE_PIPE_CH14_TXCHARISK     (q0q1_xpipe_pipe_ch14_txcharisk_m),
      .XPIPE_PIPE_CH14_TXCOMPLIANCE  (q0q1_xpipe_pipe_ch14_txcompliance_m),
      .XPIPE_PIPE_CH14_TXDATA        (q0q1_xpipe_pipe_ch14_txdata_m),
      .XPIPE_PIPE_CH14_TXDATAVALID   (q0q1_xpipe_pipe_ch14_txdatavalid_m),
      .XPIPE_PIPE_CH14_TXDEEMPH      (q0q1_xpipe_pipe_ch14_txdeemph_m),
      .XPIPE_PIPE_CH14_TXDETECTRXLOOPBACK(q0q1_xpipe_pipe_ch14_txdetectrxloopback_m),
      .XPIPE_PIPE_CH14_TXELECIDLE    (q0q1_xpipe_pipe_ch14_txelecidle_m),
      .XPIPE_PIPE_CH14_TXMAINCURSOR  (q0q1_xpipe_pipe_ch14_txmaincursor_m),
      .XPIPE_PIPE_CH14_TXMARGIN      (q0q1_xpipe_pipe_ch14_txmargin_m),
      .XPIPE_PIPE_CH14_TXPOSTCURSOR  (q0q1_xpipe_pipe_ch14_txpostcursor_m),
      .XPIPE_PIPE_CH14_TXPRECURSOR   (q0q1_xpipe_pipe_ch14_txprecursor_m),
      .XPIPE_PIPE_CH14_TXSTARTBLOCK  (q0q1_xpipe_pipe_ch14_txstartblock_m),
      .XPIPE_PIPE_CH14_TXSWING       (q0q1_xpipe_pipe_ch14_txswing_m),
      .XPIPE_PIPE_CH14_TXSYNCHEADER  (q0q1_xpipe_pipe_ch14_txsyncheader_m),

      .XPIPE_PIPE_CH14_POWERDOWN_M   (q1q2_xpipe_pipe_ch14_powerdown_m),
      .XPIPE_PIPE_CH14_RXPOLARITY_M  (q1q2_xpipe_pipe_ch14_rxpolarity_m),
      .XPIPE_PIPE_CH14_RXTERMINATION_M(q1q2_xpipe_pipe_ch14_rxtermination_m),
      .XPIPE_PIPE_CH14_TXCHARISK_M   (q1q2_xpipe_pipe_ch14_txcharisk_m),
      .XPIPE_PIPE_CH14_TXCOMPLIANCE_M(q1q2_xpipe_pipe_ch14_txcompliance_m),
      .XPIPE_PIPE_CH14_TXDATAVALID_M (q1q2_xpipe_pipe_ch14_txdatavalid_m),
      .XPIPE_PIPE_CH14_TXDATA_M      (q1q2_xpipe_pipe_ch14_txdata_m),
      .XPIPE_PIPE_CH14_TXDEEMPH_M    (q1q2_xpipe_pipe_ch14_txdeemph_m),
      .XPIPE_PIPE_CH14_TXELECIDLE_M  (q1q2_xpipe_pipe_ch14_txelecidle_m),
      .XPIPE_PIPE_CH14_TXMAINCURSOR_M(q1q2_xpipe_pipe_ch14_txmaincursor_m),
      .XPIPE_PIPE_CH14_TXMARGIN_M    (q1q2_xpipe_pipe_ch14_txmargin_m),
      .XPIPE_PIPE_CH14_TXPOSTCURSOR_M(q1q2_xpipe_pipe_ch14_txpostcursor_m),
      .XPIPE_PIPE_CH14_TXPRECURSOR_M (q1q2_xpipe_pipe_ch14_txprecursor_m),
      .XPIPE_PIPE_CH14_TXSTARTBLOCK_M(q1q2_xpipe_pipe_ch14_txstartblock_m),
      .XPIPE_PIPE_CH14_TXSWING_M     (q1q2_xpipe_pipe_ch14_txswing_m),
      .XPIPE_PIPE_CH14_TXSYNCHEADER_M(q1q2_xpipe_pipe_ch14_txsyncheader_m),
      .XPIPE_PIPE_CH14_PHYSTATUS_M   (q1q2_xpipe_pipe_ch14_phystatus_m),
      .XPIPE_PIPE_CH14_RXCHARISK_M   (q1q2_xpipe_pipe_ch14_rxcharisk_m),
      .XPIPE_PIPE_CH14_RXDATAVALID_M (q1q2_xpipe_pipe_ch14_rxdatavalid_m),
      .XPIPE_PIPE_CH14_RXDATA_M      (q1q2_xpipe_pipe_ch14_rxdata_m),
      .XPIPE_PIPE_CH14_RXELECIDLE_M  (q1q2_xpipe_pipe_ch14_rxelecidle_m),
      .XPIPE_PIPE_CH14_RXSTARTBLOCK_M(q1q2_xpipe_pipe_ch14_rxstartblock_m),
      .XPIPE_PIPE_CH14_RXSTATUS_M    (q1q2_xpipe_pipe_ch14_rxstatus_m),
      .XPIPE_PIPE_CH14_RXSYNCHEADER_M(q1q2_xpipe_pipe_ch14_rxsyncheader_m),
      .XPIPE_PIPE_CH14_RXVALID_M     (q1q2_xpipe_pipe_ch14_rxvalid_m),
      .XPIPE_PIPE_CH14_TXDETECTRXLOOPBACK_M(q1q2_xpipe_pipe_ch14_txdetectrxloopback_m),

      .XPIPE_PIPE_CH15_PHYSTATUS     (q0q1_xpipe_pipe_ch15_phystatus_m),
      .XPIPE_PIPE_CH15_RXCHARISK     (q0q1_xpipe_pipe_ch15_rxcharisk_m),
      .XPIPE_PIPE_CH15_RXDATA        (q0q1_xpipe_pipe_ch15_rxdata_m), 
      .XPIPE_PIPE_CH15_RXDATAVALID   (q0q1_xpipe_pipe_ch15_rxdatavalid_m),
      .XPIPE_PIPE_CH15_RXELECIDLE    (q0q1_xpipe_pipe_ch15_rxelecidle_m),
      .XPIPE_PIPE_CH15_RXSTARTBLOCK  (q0q1_xpipe_pipe_ch15_rxstartblock_m),
      .XPIPE_PIPE_CH15_RXSTATUS      (q0q1_xpipe_pipe_ch15_rxstatus_m),
      .XPIPE_PIPE_CH15_RXSYNCHEADER  (q0q1_xpipe_pipe_ch15_rxsyncheader_m),
      .XPIPE_PIPE_CH15_RXVALID       (q0q1_xpipe_pipe_ch15_rxvalid_m),
      .XPIPE_PIPE_CH15_POWERDOWN     (q0q1_xpipe_pipe_ch15_powerdown_m),
      .XPIPE_PIPE_CH15_RXPOLARITY    (q0q1_xpipe_pipe_ch15_rxpolarity_m),
      .XPIPE_PIPE_CH15_RXTERMINATION (q0q1_xpipe_pipe_ch15_rxtermination_m),
      .XPIPE_PIPE_CH15_TXCHARISK     (q0q1_xpipe_pipe_ch15_txcharisk_m),
      .XPIPE_PIPE_CH15_TXCOMPLIANCE  (q0q1_xpipe_pipe_ch15_txcompliance_m),
      .XPIPE_PIPE_CH15_TXDATA        (q0q1_xpipe_pipe_ch15_txdata_m),
      .XPIPE_PIPE_CH15_TXDATAVALID   (q0q1_xpipe_pipe_ch15_txdatavalid_m),
      .XPIPE_PIPE_CH15_TXDEEMPH      (q0q1_xpipe_pipe_ch15_txdeemph_m),
      .XPIPE_PIPE_CH15_TXDETECTRXLOOPBACK(q0q1_xpipe_pipe_ch15_txdetectrxloopback_m),
      .XPIPE_PIPE_CH15_TXELECIDLE    (q0q1_xpipe_pipe_ch15_txelecidle_m),
      .XPIPE_PIPE_CH15_TXMAINCURSOR  (q0q1_xpipe_pipe_ch15_txmaincursor_m),
      .XPIPE_PIPE_CH15_TXMARGIN      (q0q1_xpipe_pipe_ch15_txmargin_m),
      .XPIPE_PIPE_CH15_TXPOSTCURSOR  (q0q1_xpipe_pipe_ch15_txpostcursor_m),
      .XPIPE_PIPE_CH15_TXPRECURSOR   (q0q1_xpipe_pipe_ch15_txprecursor_m),
      .XPIPE_PIPE_CH15_TXSTARTBLOCK  (q0q1_xpipe_pipe_ch15_txstartblock_m),
      .XPIPE_PIPE_CH15_TXSWING       (q0q1_xpipe_pipe_ch15_txswing_m),
      .XPIPE_PIPE_CH15_TXSYNCHEADER  (q0q1_xpipe_pipe_ch15_txsyncheader_m),

      .XPIPE_PIPE_CH15_POWERDOWN_M   (q1q2_xpipe_pipe_ch15_powerdown_m),
      .XPIPE_PIPE_CH15_RXPOLARITY_M  (q1q2_xpipe_pipe_ch15_rxpolarity_m),
      .XPIPE_PIPE_CH15_RXTERMINATION_M(q1q2_xpipe_pipe_ch15_rxtermination_m),
      .XPIPE_PIPE_CH15_TXCHARISK_M   (q1q2_xpipe_pipe_ch15_txcharisk_m),
      .XPIPE_PIPE_CH15_TXCOMPLIANCE_M(q1q2_xpipe_pipe_ch15_txcompliance_m),
      .XPIPE_PIPE_CH15_TXDATAVALID_M (q1q2_xpipe_pipe_ch15_txdatavalid_m),
      .XPIPE_PIPE_CH15_TXDATA_M      (q1q2_xpipe_pipe_ch15_txdata_m),
      .XPIPE_PIPE_CH15_TXDEEMPH_M    (q1q2_xpipe_pipe_ch15_txdeemph_m),
      .XPIPE_PIPE_CH15_TXELECIDLE_M  (q1q2_xpipe_pipe_ch15_txelecidle_m),
      .XPIPE_PIPE_CH15_TXMAINCURSOR_M(q1q2_xpipe_pipe_ch15_txmaincursor_m),
      .XPIPE_PIPE_CH15_TXMARGIN_M    (q1q2_xpipe_pipe_ch15_txmargin_m),
      .XPIPE_PIPE_CH15_TXPOSTCURSOR_M(q1q2_xpipe_pipe_ch15_txpostcursor_m),
      .XPIPE_PIPE_CH15_TXPRECURSOR_M (q1q2_xpipe_pipe_ch15_txprecursor_m),
      .XPIPE_PIPE_CH15_TXSTARTBLOCK_M(q1q2_xpipe_pipe_ch15_txstartblock_m),
      .XPIPE_PIPE_CH15_TXSWING_M     (q1q2_xpipe_pipe_ch15_txswing_m),
      .XPIPE_PIPE_CH15_TXSYNCHEADER_M(q1q2_xpipe_pipe_ch15_txsyncheader_m),
      .XPIPE_PIPE_CH15_PHYSTATUS_M   (q1q2_xpipe_pipe_ch15_phystatus_m),
      .XPIPE_PIPE_CH15_RXCHARISK_M   (q1q2_xpipe_pipe_ch15_rxcharisk_m),
      .XPIPE_PIPE_CH15_RXDATAVALID_M (q1q2_xpipe_pipe_ch15_rxdatavalid_m),
      .XPIPE_PIPE_CH15_RXDATA_M      (q1q2_xpipe_pipe_ch15_rxdata_m),
      .XPIPE_PIPE_CH15_RXELECIDLE_M  (q1q2_xpipe_pipe_ch15_rxelecidle_m),
      .XPIPE_PIPE_CH15_RXSTARTBLOCK_M(q1q2_xpipe_pipe_ch15_rxstartblock_m),
      .XPIPE_PIPE_CH15_RXSTATUS_M    (q1q2_xpipe_pipe_ch15_rxstatus_m),
      .XPIPE_PIPE_CH15_RXSYNCHEADER_M(q1q2_xpipe_pipe_ch15_rxsyncheader_m),
      .XPIPE_PIPE_CH15_RXVALID_M     (q1q2_xpipe_pipe_ch15_rxvalid_m),
      .XPIPE_PIPE_CH15_TXDETECTRXLOOPBACK_M(q1q2_xpipe_pipe_ch15_txdetectrxloopback_m)
    );
  end

  if ( C_XPIPE_2_INSTANTIATED == 1) begin

    XPIPE_QUAD #(
      .XPIPE_LOC        (C_XPIPE_2_LOC),
      .XPIPE_MODE       (C_XPIPE_2_MODE),
      .XPIPE_RSVD       (C_XPIPE_2_RSVD),
      .XPIPE_LINK0_CFG  (C_XPIPE_2_LINK0_CFG),
      .XPIPE_LINK1_CFG  (C_XPIPE_2_LINK1_CFG),
      .XPIPE_CLK_CFG    (C_XPIPE_2_CLK_CFG),
      .XPIPE_CLKDLY_CFG (C_XPIPE_2_CLKDLY_CFG),
      .XPIPE_REG_CFG    (C_XPIPE_2_REG_CFG)
    )
    XPIPE_QUAD2_inst (

      .XPIPE_GT_OUTCLK   (q1q2_xpipe_gt_outclk_m),
      .XPIPE_GT_OUTCLK_1 (q1q2_xpipe_gt_outclk_m_1),
      .XPIPE_GT_RXOUTCLK (q1q2_xpipe_gt_rxoutclk_m),
      .XPIPE_GT_RXUSRCLK (q1q2_xpipe_gt_rxusrclk_m),
      .XPIPE_GT_PIPECLK  (q1q2_xpipe_gt_pipeclk_m),
      .XPIPE_GT_PIPECLK_1(q1q2_xpipe_gt_pipeclk_m_1),

      .XPIPE_PHYESMADAPTSAVE    (q1q2_xpipe_phyesmadaptsave_m),
      .XPIPE_PHYESMADAPTSAVE_1  (q1q2_xpipe_phyesmadaptsave_m_1),
      .XPIPE_PHYESMADAPTSAVE_M  (q2q3_xpipe_phyesmadaptsave_m),
      .XPIPE_PHYESMADAPTSAVE_M_1(q2q3_xpipe_phyesmadaptsave_m_1),

      .XPIPE_BUFGTCE        (q1q2_xpipe_bufgtce_m),
      .XPIPE_BUFGTCE_1      (q1q2_xpipe_bufgtce_m_1),
      .XPIPE_BUFGTCE_MASK   (q1q2_xpipe_bufgtce_mask_m),
      .XPIPE_BUFGTCE_MASK_1 (q1q2_xpipe_bufgtce_mask_m_1),
      .XPIPE_BUFGTDIV       (q1q2_xpipe_bufgtdiv_m),
      .XPIPE_BUFGTDIV_1     (q1q2_xpipe_bufgtdiv_m_1),
      .XPIPE_BUFGTRST       (q1q2_xpipe_bufgtrst_m),
      .XPIPE_BUFGTRST_1     (q1q2_xpipe_bufgtrst_m_1),
      .XPIPE_BUFGTRST_MASK  (q1q2_xpipe_bufgtrst_mask_m),
      .XPIPE_BUFGTRST_MASK_1(q1q2_xpipe_bufgtrst_mask_m_1),

      .XPIPE_PCIE_PERST_N     (q1q2_xpipe_pcie_perst_n_m),
      .XPIPE_PCIE_PERST_N_1   (q1q2_xpipe_pcie_perst_n_m_1),
      .XPIPE_PCIE_PERST_N_M   (q2q3_xpipe_pcie_perst_n_m),
      .XPIPE_PCIE_PERST_N_M_1 (q2q3_xpipe_pcie_perst_n_m_1),

      .XPIPE_PCIE_RATE    (q1q2_xpipe_pcie_rate_m),
      .XPIPE_PCIE_RATE_1  (q1q2_xpipe_pcie_rate_m_1),
      .XPIPE_PCIE_RATE_M  (q2q3_xpipe_pcie_rate_m),
      .XPIPE_PCIE_RATE_M_1(q2q3_xpipe_pcie_rate_m_1),

      .XPIPE_GT_OUTCLK_M   (q2q3_xpipe_gt_outclk_m),
      .XPIPE_GT_OUTCLK_M_1 (q2q3_xpipe_gt_outclk_m_1),
      .XPIPE_GT_RXOUTCLK_M (q2q3_xpipe_gt_rxoutclk_m),
      .XPIPE_GT_RXUSRCLK_M (q2q3_xpipe_gt_rxusrclk_m),
      .XPIPE_GT_PIPECLK_M  (q2q3_xpipe_gt_pipeclk_m),
      .XPIPE_GT_PIPECLK_M_1(q2q3_xpipe_gt_pipeclk_m_1),
      .XPIPE_BUFGTCE_M     (q2q3_xpipe_bufgtce_m),
      .XPIPE_BUFGTCE_MASK_M(q2q3_xpipe_bufgtce_mask_m),
      .XPIPE_BUFGTCE_MASK_M_1(q2q3_xpipe_bufgtce_mask_m_1),
      .XPIPE_BUFGTCE_M_1   (q2q3_xpipe_bufgtce_m_1),
      .XPIPE_BUFGTDIV_M    (q2q3_xpipe_bufgtdiv_m),
      .XPIPE_BUFGTDIV_M_1  (q2q3_xpipe_bufgtdiv_m_1),
      .XPIPE_BUFGTRST_M    (q2q3_xpipe_bufgtrst_m),
      .XPIPE_BUFGTRST_MASK_M (q2q3_xpipe_bufgtrst_mask_m),
      .XPIPE_BUFGTRST_MASK_M_1(q2q3_xpipe_bufgtrst_mask_m_1),
      .XPIPE_BUFGTRST_M_1  (q2q3_xpipe_bufgtrst_m_1),

      .XPIPE_PHYREADY_FR_BOT_M(q2q3_xpipe_phyready_fr_bot_m),
      .XPIPE_PHYREADY_TO_BOT  (q1q2_xpipe_phyready_to_bot_m),
      .XPIPE_PHY_READY        (q1q2_xpipe_phy_ready_m),
      .XPIPE_PHY_READY_1      (q1q2_xpipe_phy_ready_m_1),
      .XPIPE_PHYREADY_FR_BOT  (q1q2_xpipe_phyready_fr_bot_m),
      .XPIPE_PHYREADY_TO_BOT_M(q2q3_xpipe_phyready_to_bot_m),
      .XPIPE_PHY_READY_M      (q2q3_xpipe_phy_ready_m),
      .XPIPE_PHY_READY_M_1    (q2q3_xpipe_phy_ready_m_1),

      .ALTCLK_M     (q2_altclk_m),
      .APB3PADDR_M  (q2_apb3paddr_m),
      .APB3CLK_M    (q2_apb3clk_m),
      .AXISCLK_M    (q2_axisclk_m),
      .APB3PENABLE_M(q2_apb3penable_m),
      .APB3PRESETN_M(q2_apb3presetn_m),
      .APB3PSEL_M   (q2_apb3psel_m),
      .APB3PWDATA_M (q2_apb3pwdata_m),
      .APB3PWRITE_M (q2_apb3pwrite_m),
      .BGBYPASSB_M  (q2_bgbypassb_m),

      .BGMONITORENB_M (q2_bgmonitorenb_m),
      .BGPDB_M        (q2_bgpdb_m),
      .BGRCALOVRDENB_M(q2_bgrcalovrdenb_m),
      .BGRCALOVRD_M   (q2_bgrcalovrd_m),

      .CH0_CDRBMCDRREQ_M             (ch8_cdrbmcdrreq_m),
      .CH0_RXUSRCLK_M      (ch8_rxusrclk_m),
      .CH0_RXOUTCLK_M      (ch8_rxoutclk_m),
      .CH0_CDRFREQOS_M     (ch8_cdrfreqos_m),
      .CH0_CDRINCPCTRL_M   (ch8_cdrincpctrl_m),
      .CH0_CDRSTEPDIR_M    (ch8_cdrstepdir_m),
      .CH0_CDRSTEPSQ_M     (ch8_cdrstepsq_m),
      .CH0_CDRSTEPSX_M     (ch8_cdrstepsx_m),
    //.CH0_CFOKOVWRFINISH_M(ch8_cfokovwrfinish_m),
    //.CH0_CFOKOVWRPULSE_M (ch8_cfokovwrpulse_m),
    //.CH0_CFOKOVWRSTART_M (ch8_cfokovwrstart_m),
      .CH0_CLKRSVD0_M      (ch8_clkrsvd0_m),
      .CH0_CLKRSVD1_M      (ch8_clkrsvd1_m),
      .CH0_DMONFIFORESET_M (ch8_dmonfiforeset_m),
      .CH0_DMONITORCLK_M   (ch8_dmonitorclk_m),
      .CH0_EYESCANRESET_M  (ch8_eyescanreset_m),
      .CH0_EYESCANTRIGGER_M(ch8_eyescantrigger_m),
      .CH0_GTRSVD_M        (ch8_gtrsvd_m),
      .CH0_GTRXRESET_M     (ch8_gtrxreset_m),
      .CH0_GTTXRESET_M     (ch8_gttxreset_m),
      .CH0_HSDPPCSRESET_M  (ch8_hsdppcsreset_m),
      .CH0_ILORESETMASK_M  (ch8_iloresetmask_m),
      .CH0_ILORESET_M      (ch8_iloreset_m),
      .CH0_LOOPBACK_M      (ch8_loopback_m),
      .CH0_PCIERSTB_M      (ch8_pcierstb_m),
      .CH0_PCSRSVDIN_M     (ch8_pcsrsvdin_m),
      .CH0_PHYESMADAPTSAVE_M(ch8_phyesmadaptsave_m),
      .CH0_RXCDRHOLD_M     (ch8_rxcdrhold_m),
      .CH0_RXCDROVRDEN_M   (ch8_rxcdrovrden_m),
      .CH0_RXCDRRESET_M    (ch8_rxcdrreset_m),
      .CH0_RXCHBONDI_M     (ch8_rxchbondi_m),
      .CH0_RXDAPICODEOVRDEN_M(ch8_rxdapicodeovrden_m),
      .CH0_RXDAPICODERESET_M(ch8_rxdapicodereset_m),
      .CH0_RXDLYALIGNREQ_M (ch8_rxdlyalignreq_m),
      .CH0_RXEQTRAINING_M  (ch8_rxeqtraining_m),
      .CH0_RXGEARBOXSLIP_M (ch8_rxgearboxslip_m),
      .CH0_RXLATCLK_M      (ch8_rxlatclk_m),
      .CH0_RXLPMEN_M       (ch8_rxlpmen_m),
      .CH0_RXMLDCHAINDONE_M(ch8_rxmldchaindone_m),
      .CH0_RXMLDCHAINREQ_M (ch8_rxmldchainreq_m),
      .CH0_RXMLFINEALIGNREQ_M(ch8_rxmlfinealignreq_m),
      .CH0_RXOOBRESET_M    (ch8_rxoobreset_m),
      .CH0_RXPCSRESETMASK_M(ch8_rxpcsresetmask_m),
      .CH0_RXPD_M          (ch8_rxpd_m),
      .CH0_RXPHALIGNREQ_M  (ch8_rxphalignreq_m),
      .CH0_RXPHALIGNRESETMASK_M(ch8_rxphalignresetmask_m),
      .CH0_RXPHDLYPD_M     (ch8_rxphdlypd_m),
      .CH0_RXPHDLYRESET_M  (ch8_rxphdlyreset_m),
      .CH0_RXPHSETINITREQ_M(ch8_rxphsetinitreq_m),
      .CH0_RXPHSHIFT180_M  (ch8_rxphshift180_m),
      .CH0_RXPMARESETMASK_M(ch8_rxpmaresetmask_m),
      .CH0_RXPOLARITY_M    (ch8_rxpolarity_m),
      .CH0_RXPRBSCNTRESET_M(ch8_rxprbscntreset_m),
      .CH0_RXPRBSSEL_M     (ch8_rxprbssel_m),
      .CH0_RXPROGDIVRESET_M(ch8_rxprogdivreset_m),
      .CH0_RXRATE_M        (ch8_rxrate_m),
      .CH0_RXRESETMODE_M   (ch8_rxresetmode_m),
      .CH0_RXSLIDE_M       (ch8_rxslide_m),
      .CH0_RXSYNCALLIN_M   (ch8_rxsyncallin_m),
      .CH0_RXTERMINATION_M (ch8_rxtermination_m),
      .CH0_RXUSERRDY_M     (ch8_rxuserrdy_m),
      .CH0_TSTIN_M         (ch8_tstin_m),
      .CH0_TXCOMINIT_M     (ch8_txcominit_m),
      .CH0_TXCOMSAS_M      (ch8_txcomsas_m),
      .CH0_TXCOMWAKE_M     (ch8_txcomwake_m),
      .CH0_TXCTRL0_M       (ch8_txctrl0_m),
      .CH0_TXCTRL1_M       (ch8_txctrl1_m),
      .CH0_TXCTRL2_M       (ch8_txctrl2_m),
      .CH0_TXDAPICODEOVRDEN_M(ch8_txdapicodeovrden_m),
      .CH0_TXDAPICODERESET_M(ch8_txdapicodereset_m),
      .CH0_TXDATAEXTENDRSVD_M(ch8_txdataextendrsvd_m),
      .CH0_TXDATA_M        (ch8_txdata_m),
      .CH0_TXDEEMPH_M      (ch8_txdeemph_m),
      .CH0_TXDETECTRX_M    (ch8_txdetectrx_m),
      .CH0_TXDIFFCTRL_M    (ch8_txdiffctrl_m),
      .CH0_TXDLYALIGNREQ_M (ch8_txdlyalignreq_m),
      .CH0_TXELECIDLE_M    (ch8_txelecidle_m),
      .CH0_TXHEADER_M      (ch8_txheader_m),
      .CH0_TXINHIBIT_M     (ch8_txinhibit_m),
      .CH0_TXLATCLK_M      (ch8_txlatclk_m),
      .CH0_TXMAINCURSOR_M  (ch8_txmaincursor_m),
      .CH0_TXMARGIN_M      (ch8_txmargin_m),
      .CH0_TXMLDCHAINDONE_M(ch8_txmldchaindone_m),
      .CH0_TXMLDCHAINREQ_M (ch8_txmldchainreq_m),
      .CH0_TXONESZEROS_M   (ch8_txoneszeros_m),
      .CH0_TXPAUSEDELAYALIGN_M(ch8_txpausedelayalign_m),
      .CH0_TXPCSRESETMASK_M(ch8_txpcsresetmask_m),
      .CH0_TXPD_M          (ch8_txpd_m),
      .CH0_TXPHALIGNREQ_M  (ch8_txphalignreq_m),
      .CH0_TXPHALIGNRESETMASK_M(ch8_txphalignresetmask_m),
      .CH0_TXPHDLYPD_M     (ch8_txphdlypd_m),
      .CH0_TXPHDLYRESET_M  (ch8_txphdlyreset_m),
      .CH0_TXPHDLYTSTCLK_M (ch8_txphdlytstclk_m),
      .CH0_TXPHSETINITREQ_M(ch8_txphsetinitreq_m),
      .CH0_TXPHSHIFT180_M  (ch8_txphshift180_m),
      .CH0_TXPICODEOVRDEN_M(ch8_txpicodeovrden_m),
      .CH0_TXPICODERESET_M (ch8_txpicodereset_m),
      .CH0_TXPIPPMEN_M     (ch8_txpippmen_m),
      .CH0_TXPIPPMSTEPSIZE_M(ch8_txpippmstepsize_m),
      .CH0_TXPISOPD_M      (ch8_txpisopd_m),
      .CH0_TXPMARESETMASK_M(ch8_txpmaresetmask_m),
      .CH0_TXPOLARITY_M    (ch8_txpolarity_m),
      .CH0_TXPOSTCURSOR_M  (ch8_txpostcursor_m),
      .CH0_TXPRBSFORCEERR_M(ch8_txprbsforceerr_m),
      .CH0_TXPRBSSEL_M     (ch8_txprbssel_m),
      .CH0_TXPRECURSOR_M   (ch8_txprecursor_m),
      .CH0_TXPROGDIVRESET_M(ch8_txprogdivreset_m),
      .CH0_TXRATE_M        (ch8_txrate_m),
      .CH0_TXRESETMODE_M   (ch8_txresetmode_m),
      .CH0_TXSEQUENCE_M    (ch8_txsequence_m),
      .CH0_TXSWING_M       (ch8_txswing_m),
      .CH0_TXSYNCALLIN_M   (ch8_txsyncallin_m),
      .CH0_TXUSERRDY_M     (ch8_txuserrdy_m),
      .CH0_TXUSRCLK_M      (ch8_txusrclk_m),
      .CH1_CDRBMCDRREQ_M   (ch9_cdrbmcdrreq_m),
      .CH1_CDRFREQOS_M     (ch9_cdrfreqos_m),
      .CH1_CDRINCPCTRL_M   (ch9_cdrincpctrl_m),
      .CH1_CDRSTEPDIR_M    (ch9_cdrstepdir_m),
      .CH1_CDRSTEPSQ_M     (ch9_cdrstepsq_m),
      .CH1_CDRSTEPSX_M     (ch9_cdrstepsx_m),
    //.CH1_CFOKOVWRFINISH_M(ch9_cfokovwrfinish_m),
    //.CH1_CFOKOVWRPULSE_M (ch9_cfokovwrpulse_m),
    //.CH1_CFOKOVWRSTART_M (ch9_cfokovwrstart_m),
      .CH1_CLKRSVD0_M      (ch9_clkrsvd0_m),
      .CH1_CLKRSVD1_M      (ch9_clkrsvd1_m),
      .CH1_DMONFIFORESET_M (ch9_dmonfiforeset_m),
      .CH1_DMONITORCLK_M   (ch9_dmonitorclk_m),
      .CH1_EYESCANRESET_M  (ch9_eyescanreset_m),
      .CH1_EYESCANTRIGGER_M(ch9_eyescantrigger_m),
      .CH1_GTRSVD_M        (ch9_gtrsvd_m),
      .CH1_GTRXRESET_M     (ch9_gtrxreset_m),
      .CH1_GTTXRESET_M     (ch9_gttxreset_m),
      .CH1_HSDPPCSRESET_M  (ch9_hsdppcsreset_m),
      .CH1_ILORESETMASK_M  (ch9_iloresetmask_m),
      .CH1_ILORESET_M      (ch9_iloreset_m),
      .CH1_LOOPBACK_M      (ch9_loopback_m),
      .CH1_PCIERSTB_M      (ch9_pcierstb_m),
      .CH1_PCSRSVDIN_M     (ch9_pcsrsvdin_m),
      .CH1_PHYESMADAPTSAVE_M(ch9_phyesmadaptsave_m),
      .CH1_RXCDRHOLD_M     (ch9_rxcdrhold_m),
      .CH1_RXCDROVRDEN_M   (ch9_rxcdrovrden_m),
      .CH1_RXCDRRESET_M    (ch9_rxcdrreset_m),
      .CH1_RXCHBONDI_M     (ch9_rxchbondi_m),
      .CH1_RXDAPICODEOVRDEN_M(ch9_rxdapicodeovrden_m),
      .CH1_RXDAPICODERESET_M(ch9_rxdapicodereset_m),
      .CH1_RXDLYALIGNREQ_M (ch9_rxdlyalignreq_m),
      .CH1_RXEQTRAINING_M  (ch9_rxeqtraining_m),
      .CH1_RXGEARBOXSLIP_M (ch9_rxgearboxslip_m),
      .CH1_RXLATCLK_M      (ch9_rxlatclk_m),
      .CH1_RXLPMEN_M       (ch9_rxlpmen_m),
      .CH1_RXMLDCHAINDONE_M(ch9_rxmldchaindone_m),
      .CH1_RXMLDCHAINREQ_M (ch9_rxmldchainreq_m),
      .CH1_RXMLFINEALIGNREQ_M(ch9_rxmlfinealignreq_m),
      .CH1_RXOOBRESET_M    (ch9_rxoobreset_m),
      .CH1_RXPCSRESETMASK_M(ch9_rxpcsresetmask_m),
      .CH1_RXPD_M          (ch9_rxpd_m),
      .CH1_RXPHALIGNREQ_M  (ch9_rxphalignreq_m),
      .CH1_RXPHALIGNRESETMASK_M(ch9_rxphalignresetmask_m),
      .CH1_RXPHDLYPD_M     (ch9_rxphdlypd_m),
      .CH1_RXPHDLYRESET_M  (ch9_rxphdlyreset_m),
      .CH1_RXPHSETINITREQ_M(ch9_rxphsetinitreq_m),
      .CH1_RXPHSHIFT180_M  (ch9_rxphshift180_m),
      .CH1_RXPMARESETMASK_M(ch9_rxpmaresetmask_m),
      .CH1_RXPOLARITY_M    (ch9_rxpolarity_m),
      .CH1_RXPRBSCNTRESET_M(ch9_rxprbscntreset_m),
      .CH1_RXPRBSSEL_M     (ch9_rxprbssel_m),
      .CH1_RXPROGDIVRESET_M(ch9_rxprogdivreset_m),
      .CH1_RXRATE_M        (ch9_rxrate_m),
      .CH1_RXRESETMODE_M   (ch9_rxresetmode_m),
      .CH1_RXSLIDE_M       (ch9_rxslide_m),
      .CH1_RXSYNCALLIN_M   (ch9_rxsyncallin_m),
      .CH1_RXTERMINATION_M (ch9_rxtermination_m),
      .CH1_RXUSERRDY_M     (ch9_rxuserrdy_m),
      .CH1_RXUSRCLK_M      (ch9_rxusrclk_m),
      .CH1_TSTIN_M         (ch9_tstin_m),
      .CH1_TXCOMINIT_M     (ch9_txcominit_m),
      .CH1_TXCOMSAS_M      (ch9_txcomsas_m),
      .CH1_TXCOMWAKE_M     (ch9_txcomwake_m),
      .CH1_TXCTRL0_M       (ch9_txctrl0_m),
      .CH1_TXCTRL1_M       (ch9_txctrl1_m),
      .CH1_TXCTRL2_M       (ch9_txctrl2_m),
      .CH1_TXDAPICODEOVRDEN_M(ch9_txdapicodeovrden_m),
      .CH1_TXDAPICODERESET_M(ch9_txdapicodereset_m),
      .CH1_TXDATAEXTENDRSVD_M(ch9_txdataextendrsvd_m),
      .CH1_TXDATA_M        (ch9_txdata_m),
      .CH1_TXDEEMPH_M      (ch9_txdeemph_m),
      .CH1_TXDETECTRX_M    (ch9_txdetectrx_m),
      .CH1_TXDIFFCTRL_M    (ch9_txdiffctrl_m),
      .CH1_TXDLYALIGNREQ_M (ch9_txdlyalignreq_m),
      .CH1_TXELECIDLE_M    (ch9_txelecidle_m),
      .CH1_TXHEADER_M      (ch9_txheader_m),
      .CH1_TXINHIBIT_M     (ch9_txinhibit_m),
      .CH1_TXLATCLK_M      (ch9_txlatclk_m),
      .CH1_TXMAINCURSOR_M  (ch9_txmaincursor_m),
      .CH1_TXMARGIN_M      (ch9_txmargin_m),
      .CH1_TXMLDCHAINDONE_M(ch9_txmldchaindone_m),
      .CH1_TXMLDCHAINREQ_M (ch9_txmldchainreq_m),
      .CH1_TXONESZEROS_M   (ch9_txoneszeros_m),
      .CH1_TXPAUSEDELAYALIGN_M(ch9_txpausedelayalign_m),
      .CH1_TXPCSRESETMASK_M(ch9_txpcsresetmask_m),
      .CH1_TXPD_M          (ch9_txpd_m),
      .CH1_TXPHALIGNREQ_M  (ch9_txphalignreq_m),
      .CH1_TXPHALIGNRESETMASK_M(ch9_txphalignresetmask_m),
      .CH1_TXPHDLYPD_M     (ch9_txphdlypd_m),
      .CH1_TXPHDLYRESET_M  (ch9_txphdlyreset_m),
      .CH1_TXPHDLYTSTCLK_M (ch9_txphdlytstclk_m),
      .CH1_TXPHSETINITREQ_M(ch9_txphsetinitreq_m),
      .CH1_TXPHSHIFT180_M  (ch9_txphshift180_m),
      .CH1_TXPICODEOVRDEN_M(ch9_txpicodeovrden_m),
      .CH1_TXPICODERESET_M (ch9_txpicodereset_m),
      .CH1_TXPIPPMEN_M     (ch9_txpippmen_m),
      .CH1_TXPIPPMSTEPSIZE_M(ch9_txpippmstepsize_m),
      .CH1_TXPISOPD_M      (ch9_txpisopd_m),
      .CH1_TXPMARESETMASK_M(ch9_txpmaresetmask_m),
      .CH1_TXPOLARITY_M    (ch9_txpolarity_m),
      .CH1_TXPOSTCURSOR_M  (ch9_txpostcursor_m),
      .CH1_TXPRBSFORCEERR_M(ch9_txprbsforceerr_m),
      .CH1_TXPRBSSEL_M     (ch9_txprbssel_m),
      .CH1_TXPRECURSOR_M   (ch9_txprecursor_m),
      .CH1_TXPROGDIVRESET_M(ch9_txprogdivreset_m),
      .CH1_TXRATE_M        (ch9_txrate_m),
      .CH1_TXRESETMODE_M   (ch9_txresetmode_m),
      .CH1_TXSEQUENCE_M    (ch9_txsequence_m),
      .CH1_TXSWING_M       (ch9_txswing_m),
      .CH1_TXSYNCALLIN_M   (ch9_txsyncallin_m),
      .CH1_TXUSERRDY_M     (ch9_txuserrdy_m),
      .CH1_TXUSRCLK_M      (ch9_txusrclk_m),
      .CH2_CDRBMCDRREQ_M   (ch10_cdrbmcdrreq_m),
      .CH2_CDRFREQOS_M     (ch10_cdrfreqos_m),
      .CH2_CDRINCPCTRL_M   (ch10_cdrincpctrl_m),
      .CH2_CDRSTEPDIR_M    (ch10_cdrstepdir_m),
      .CH2_CDRSTEPSQ_M     (ch10_cdrstepsq_m),
      .CH2_CDRSTEPSX_M     (ch10_cdrstepsx_m),
    //.CH2_CFOKOVWRFINISH_M(ch10_cfokovwrfinish_m),
    //.CH2_CFOKOVWRPULSE_M (ch10_cfokovwrpulse_m),
    //.CH2_CFOKOVWRSTART_M (ch10_cfokovwrstart_m),
      .CH2_CLKRSVD0_M      (ch10_clkrsvd0_m),
      .CH2_CLKRSVD1_M      (ch10_clkrsvd1_m),
      .CH2_DMONFIFORESET_M (ch10_dmonfiforeset_m),
      .CH2_DMONITORCLK_M   (ch10_dmonitorclk_m),
      .CH2_EYESCANRESET_M  (ch10_eyescanreset_m),
      .CH2_EYESCANTRIGGER_M(ch10_eyescantrigger_m),
      .CH2_GTRSVD_M        (ch10_gtrsvd_m),
      .CH2_GTRXRESET_M     (ch10_gtrxreset_m),
      .CH2_GTTXRESET_M     (ch10_gttxreset_m),
      .CH2_HSDPPCSRESET_M  (ch10_hsdppcsreset_m),
      .CH2_ILORESETMASK_M  (ch10_iloresetmask_m),
      .CH2_ILORESET_M      (ch10_iloreset_m),
      .CH2_LOOPBACK_M      (ch10_loopback_m),
      .CH2_PCIERSTB_M      (ch10_pcierstb_m),
      .CH2_PCSRSVDIN_M     (ch10_pcsrsvdin_m),
      .CH2_PHYESMADAPTSAVE_M(ch10_phyesmadaptsave_m),
      .CH2_RXCDRHOLD_M     (ch10_rxcdrhold_m),
      .CH2_RXCDROVRDEN_M   (ch10_rxcdrovrden_m),
      .CH2_RXCDRRESET_M    (ch10_rxcdrreset_m),
      .CH2_RXCHBONDI_M     (ch10_rxchbondi_m),
      .CH2_RXDAPICODEOVRDEN_M(ch10_rxdapicodeovrden_m),
      .CH2_RXDAPICODERESET_M(ch10_rxdapicodereset_m),
      .CH2_RXDLYALIGNREQ_M (ch10_rxdlyalignreq_m),
      .CH2_RXEQTRAINING_M  (ch10_rxeqtraining_m),
      .CH2_RXGEARBOXSLIP_M (ch10_rxgearboxslip_m),
      .CH2_RXLATCLK_M      (ch10_rxlatclk_m),
      .CH2_RXLPMEN_M       (ch10_rxlpmen_m),
      .CH2_RXMLDCHAINDONE_M(ch10_rxmldchaindone_m),
      .CH2_RXMLDCHAINREQ_M (ch10_rxmldchainreq_m),
      .CH2_RXMLFINEALIGNREQ_M(ch10_rxmlfinealignreq_m),
      .CH2_RXOOBRESET_M    (ch10_rxoobreset_m),
      .CH2_RXPCSRESETMASK_M(ch10_rxpcsresetmask_m),
      .CH2_RXPD_M          (ch10_rxpd_m),
      .CH2_RXPHALIGNREQ_M  (ch10_rxphalignreq_m),
      .CH2_RXPHALIGNRESETMASK_M(ch10_rxphalignresetmask_m),
      .CH2_RXPHDLYPD_M     (ch10_rxphdlypd_m),
      .CH2_RXPHDLYRESET_M  (ch10_rxphdlyreset_m),
      .CH2_RXPHSETINITREQ_M(ch10_rxphsetinitreq_m),
      .CH2_RXPHSHIFT180_M  (ch10_rxphshift180_m),
      .CH2_RXPMARESETMASK_M(ch10_rxpmaresetmask_m),
      .CH2_RXPOLARITY_M    (ch10_rxpolarity_m),
      .CH2_RXPRBSCNTRESET_M(ch10_rxprbscntreset_m),
      .CH2_RXPRBSSEL_M     (ch10_rxprbssel_m),
      .CH2_RXPROGDIVRESET_M(ch10_rxprogdivreset_m),
      .CH2_RXRATE_M        (ch10_rxrate_m),
      .CH2_RXRESETMODE_M   (ch10_rxresetmode_m),
      .CH2_RXSLIDE_M       (ch10_rxslide_m),
      .CH2_RXSYNCALLIN_M   (ch10_rxsyncallin_m),
      .CH2_RXTERMINATION_M (ch10_rxtermination_m),
      .CH2_RXUSERRDY_M     (ch10_rxuserrdy_m),
      .CH2_RXUSRCLK_M      (ch10_rxusrclk_m),
      .CH2_TSTIN_M         (ch10_tstin_m),
      .CH2_TXCOMINIT_M     (ch10_txcominit_m),
      .CH2_TXCOMSAS_M      (ch10_txcomsas_m),
      .CH2_TXCOMWAKE_M     (ch10_txcomwake_m),
      .CH2_TXCTRL0_M       (ch10_txctrl0_m),
      .CH2_TXCTRL1_M       (ch10_txctrl1_m),
      .CH2_TXCTRL2_M       (ch10_txctrl2_m),
      .CH2_TXDAPICODEOVRDEN_M(ch10_txdapicodeovrden_m),
      .CH2_TXDAPICODERESET_M(ch10_txdapicodereset_m),
      .CH2_TXDATAEXTENDRSVD_M(ch10_txdataextendrsvd_m),
      .CH2_TXDATA_M        (ch10_txdata_m),
      .CH2_TXDEEMPH_M      (ch10_txdeemph_m),
      .CH2_TXDETECTRX_M    (ch10_txdetectrx_m),
      .CH2_TXDIFFCTRL_M    (ch10_txdiffctrl_m),
      .CH2_TXDLYALIGNREQ_M (ch10_txdlyalignreq_m),
      .CH2_TXELECIDLE_M    (ch10_txelecidle_m),
      .CH2_TXHEADER_M      (ch10_txheader_m),
      .CH2_TXINHIBIT_M     (ch10_txinhibit_m),
      .CH2_TXLATCLK_M      (ch10_txlatclk_m),
      .CH2_TXMAINCURSOR_M  (ch10_txmaincursor_m),
      .CH2_TXMARGIN_M      (ch10_txmargin_m),
      .CH2_TXMLDCHAINDONE_M(ch10_txmldchaindone_m),
      .CH2_TXMLDCHAINREQ_M (ch10_txmldchainreq_m),
      .CH2_TXONESZEROS_M   (ch10_txoneszeros_m),
      .CH2_TXPAUSEDELAYALIGN_M(ch10_txpausedelayalign_m),
      .CH2_TXPCSRESETMASK_M(ch10_txpcsresetmask_m),
      .CH2_TXPD_M          (ch10_txpd_m),
      .CH2_TXPHALIGNREQ_M  (ch10_txphalignreq_m),
      .CH2_TXPHALIGNRESETMASK_M(ch10_txphalignresetmask_m),
      .CH2_TXPHDLYPD_M     (ch10_txphdlypd_m),
      .CH2_TXPHDLYRESET_M  (ch10_txphdlyreset_m),
      .CH2_TXPHDLYTSTCLK_M (ch10_txphdlytstclk_m),
      .CH2_TXPHSETINITREQ_M(ch10_txphsetinitreq_m),
      .CH2_TXPHSHIFT180_M  (ch10_txphshift180_m),
      .CH2_TXPICODEOVRDEN_M(ch10_txpicodeovrden_m),
      .CH2_TXPICODERESET_M (ch10_txpicodereset_m),
      .CH2_TXPIPPMEN_M     (ch10_txpippmen_m),
      .CH2_TXPIPPMSTEPSIZE_M(ch10_txpippmstepsize_m),
      .CH2_TXPISOPD_M      (ch10_txpisopd_m),
      .CH2_TXPMARESETMASK_M(ch10_txpmaresetmask_m),
      .CH2_TXPOLARITY_M    (ch10_txpolarity_m),
      .CH2_TXPOSTCURSOR_M  (ch10_txpostcursor_m),
      .CH2_TXPRBSFORCEERR_M(ch10_txprbsforceerr_m),
      .CH2_TXPRBSSEL_M     (ch10_txprbssel_m),
      .CH2_TXPRECURSOR_M   (ch10_txprecursor_m),
      .CH2_TXPROGDIVRESET_M(ch10_txprogdivreset_m),
      .CH2_TXRATE_M        (ch10_txrate_m),
      .CH2_TXRESETMODE_M   (ch10_txresetmode_m),
      .CH2_TXSEQUENCE_M    (ch10_txsequence_m),
      .CH2_TXSWING_M       (ch10_txswing_m),
      .CH2_TXSYNCALLIN_M   (ch10_txsyncallin_m),
      .CH2_TXUSERRDY_M     (ch10_txuserrdy_m),
      .CH2_TXUSRCLK_M      (ch10_txusrclk_m),
      .CH3_CDRBMCDRREQ_M   (ch11_cdrbmcdrreq_m),
      .CH3_CDRFREQOS_M     (ch11_cdrfreqos_m),
      .CH3_CDRINCPCTRL_M   (ch11_cdrincpctrl_m),
      .CH3_CDRSTEPDIR_M    (ch11_cdrstepdir_m),
      .CH3_CDRSTEPSQ_M     (ch11_cdrstepsq_m),
      .CH3_CDRSTEPSX_M     (ch11_cdrstepsx_m),
    //.CH3_CFOKOVWRFINISH_M(ch11_cfokovwrfinish_m),
    //.CH3_CFOKOVWRPULSE_M (ch11_cfokovwrpulse_m),
    //.CH3_CFOKOVWRSTART_M (ch11_cfokovwrstart_m),
      .CH3_CLKRSVD0_M      (ch11_clkrsvd0_m),
      .CH3_CLKRSVD1_M      (ch11_clkrsvd1_m),
      .CH3_DMONFIFORESET_M (ch11_dmonfiforeset_m),
      .CH3_DMONITORCLK_M   (ch11_dmonitorclk_m),
      .CH3_EYESCANRESET_M  (ch11_eyescanreset_m),
      .CH3_EYESCANTRIGGER_M(ch11_eyescantrigger_m),
      .CH3_GTRSVD_M        (ch11_gtrsvd_m),
      .CH3_GTRXRESET_M     (ch11_gtrxreset_m),
      .CH3_GTTXRESET_M     (ch11_gttxreset_m),
      .CH3_HSDPPCSRESET_M  (ch11_hsdppcsreset_m),
      .CH3_ILORESETMASK_M  (ch11_iloresetmask_m),
      .CH3_ILORESET_M      (ch11_iloreset_m),
      .CH3_LOOPBACK_M      (ch11_loopback_m),
      .CH3_PCIERSTB_M      (ch11_pcierstb_m),
      .CH3_PCSRSVDIN_M     (ch11_pcsrsvdin_m),
      .CH3_PHYESMADAPTSAVE_M(ch11_phyesmadaptsave_m),
      .CH3_RXCDRHOLD_M     (ch11_rxcdrhold_m),
      .CH3_RXCDROVRDEN_M   (ch11_rxcdrovrden_m),
      .CH3_RXCDRRESET_M    (ch11_rxcdrreset_m),
      .CH3_RXCHBONDI_M     (ch11_rxchbondi_m),
      .CH3_RXDAPICODEOVRDEN_M(ch11_rxdapicodeovrden_m),
      .CH3_RXDAPICODERESET_M(ch11_rxdapicodereset_m),
      .CH3_RXDLYALIGNREQ_M (ch11_rxdlyalignreq_m),
      .CH3_RXEQTRAINING_M  (ch11_rxeqtraining_m),
      .CH3_RXGEARBOXSLIP_M (ch11_rxgearboxslip_m),
      .CH3_RXLATCLK_M      (ch11_rxlatclk_m),
      .CH3_RXLPMEN_M       (ch11_rxlpmen_m),
      .CH3_RXMLDCHAINDONE_M(ch11_rxmldchaindone_m),
      .CH3_RXMLDCHAINREQ_M (ch11_rxmldchainreq_m),
      .CH3_RXMLFINEALIGNREQ_M(ch11_rxmlfinealignreq_m),
      .CH3_RXOOBRESET_M    (ch11_rxoobreset_m),
      .CH3_RXPCSRESETMASK_M(ch11_rxpcsresetmask_m),
      .CH3_RXPD_M          (ch11_rxpd_m),
      .CH3_RXPHALIGNREQ_M  (ch11_rxphalignreq_m),
      .CH3_RXPHALIGNRESETMASK_M(ch11_rxphalignresetmask_m),
      .CH3_RXPHDLYPD_M     (ch11_rxphdlypd_m),
      .CH3_RXPHDLYRESET_M  (ch11_rxphdlyreset_m),
      .CH3_RXPHSETINITREQ_M(ch11_rxphsetinitreq_m),
      .CH3_RXPHSHIFT180_M  (ch11_rxphshift180_m),
      .CH3_RXPMARESETMASK_M(ch11_rxpmaresetmask_m),
      .CH3_RXPOLARITY_M    (ch11_rxpolarity_m),
      .CH3_RXPRBSCNTRESET_M(ch11_rxprbscntreset_m),
      .CH3_RXPRBSSEL_M     (ch11_rxprbssel_m),
      .CH3_RXPROGDIVRESET_M(ch11_rxprogdivreset_m),
      .CH3_RXRATE_M        (ch11_rxrate_m),
      .CH3_RXRESETMODE_M   (ch11_rxresetmode_m),
      .CH3_RXSLIDE_M       (ch11_rxslide_m),
      .CH3_RXSYNCALLIN_M   (ch11_rxsyncallin_m),
      .CH3_RXTERMINATION_M (ch11_rxtermination_m),
      .CH3_RXUSERRDY_M     (ch11_rxuserrdy_m),
      .CH3_RXUSRCLK_M      (ch11_rxusrclk_m),
      .CH3_TSTIN_M         (ch11_tstin_m),
      .CH3_TXCOMINIT_M     (ch11_txcominit_m),
      .CH3_TXCOMSAS_M      (ch11_txcomsas_m),
      .CH3_TXCOMWAKE_M     (ch11_txcomwake_m),
      .CH3_TXCTRL0_M       (ch11_txctrl0_m),
      .CH3_TXCTRL1_M       (ch11_txctrl1_m),
      .CH3_TXCTRL2_M       (ch11_txctrl2_m),
      .CH3_TXDAPICODEOVRDEN_M(ch11_txdapicodeovrden_m),
      .CH3_TXDAPICODERESET_M(ch11_txdapicodereset_m),
      .CH3_TXDATAEXTENDRSVD_M(ch11_txdataextendrsvd_m),
      .CH3_TXDATA_M        (ch11_txdata_m),
      .CH3_TXDEEMPH_M      (ch11_txdeemph_m),
      .CH3_TXDETECTRX_M    (ch11_txdetectrx_m),
      .CH3_TXDIFFCTRL_M    (ch11_txdiffctrl_m),
      .CH3_TXDLYALIGNREQ_M (ch11_txdlyalignreq_m),
      .CH3_TXELECIDLE_M    (ch11_txelecidle_m),
      .CH3_TXHEADER_M      (ch11_txheader_m),
      .CH3_TXINHIBIT_M     (ch11_txinhibit_m),
      .CH3_TXLATCLK_M      (ch11_txlatclk_m),
      .CH3_TXMAINCURSOR_M  (ch11_txmaincursor_m),
      .CH3_TXMARGIN_M      (ch11_txmargin_m),
      .CH3_TXMLDCHAINDONE_M(ch11_txmldchaindone_m),
      .CH3_TXMLDCHAINREQ_M (ch11_txmldchainreq_m),
      .CH3_TXONESZEROS_M   (ch11_txoneszeros_m),
      .CH3_TXPAUSEDELAYALIGN_M(ch11_txpausedelayalign_m),
      .CH3_TXPCSRESETMASK_M(ch11_txpcsresetmask_m),
      .CH3_TXPD_M          (ch11_txpd_m),
      .CH3_TXPHALIGNREQ_M  (ch11_txphalignreq_m),
      .CH3_TXPHALIGNRESETMASK_M(ch11_txphalignresetmask_m),
      .CH3_TXPHDLYPD_M     (ch11_txphdlypd_m),
      .CH3_TXPHDLYRESET_M  (ch11_txphdlyreset_m),
      .CH3_TXPHDLYTSTCLK_M (ch11_txphdlytstclk_m),
      .CH3_TXPHSETINITREQ_M(ch11_txphsetinitreq_m),
      .CH3_TXPHSHIFT180_M  (ch11_txphshift180_m),
      .CH3_TXPICODEOVRDEN_M(ch11_txpicodeovrden_m),
      .CH3_TXPICODERESET_M (ch11_txpicodereset_m),
      .CH3_TXPIPPMEN_M     (ch11_txpippmen_m),
      .CH3_TXPIPPMSTEPSIZE_M(ch11_txpippmstepsize_m),
      .CH3_TXPISOPD_M      (ch11_txpisopd_m),
      .CH3_TXPMARESETMASK_M(ch11_txpmaresetmask_m),
      .CH3_TXPOLARITY_M    (ch11_txpolarity_m),
      .CH3_TXPOSTCURSOR_M  (ch11_txpostcursor_m),
      .CH3_TXPRBSFORCEERR_M(ch11_txprbsforceerr_m),
      .CH3_TXPRBSSEL_M     (ch11_txprbssel_m),
      .CH3_TXPRECURSOR_M   (ch11_txprecursor_m),
      .CH3_TXPROGDIVRESET_M(ch11_txprogdivreset_m),
      .CH3_TXRATE_M        (ch11_txrate_m),
      .CH3_TXRESETMODE_M   (ch11_txresetmode_m),
      .CH3_TXSEQUENCE_M    (ch11_txsequence_m),
      .CH3_TXSWING_M       (ch11_txswing_m),
      .CH3_TXSYNCALLIN_M   (ch11_txsyncallin_m),
      .CH3_TXUSERRDY_M     (ch11_txuserrdy_m),
      .CH3_TXUSRCLK_M      (ch11_txusrclk_m),

      .CTRLRSVDIN0_M(q2_ctrlrsvdin0_m),
      .CTRLRSVDIN1_M(q2_ctrlrsvdin1_m),

      .DEBUGTRACECLK_M  (q2_debugtraceclk_m),
      .DEBUGTRACEREADY_M(q2_debugtracetready_m),
      .GPI_M(q2_gpi_m),

    //.HSCLK0_GTGREFCLK2LCPLL_M(q2_hsclk0_gtgrefclk2lcpll_m),
    //.HSCLK0_GTGREFCLK2RPLL_M (q2_hsclk0_gtgrefclk2rpll_m),
      .HSCLK0_LCPLLCLKRSVD0_M  (q2_hsclk0_lcpllclkrsvd0_m),
      .HSCLK0_LCPLLCLKRSVD1_M  (q2_hsclk0_lcpllclkrsvd1_m),
      .HSCLK0_LCPLLFBDIV_M     (q2_hsclk0_lcpllfbdiv_m),
      .HSCLK0_LCPLLPD_M        (q2_hsclk0_lcpllpd_m),
      .HSCLK0_LCPLLREFCLKSEL_M (q2_hsclk0_lcpllrefclksel_m),
      .HSCLK0_LCPLLRESETBYPASSMODE_M(q2_hsclk0_lcpllresetbypassmode_m),
      .HSCLK0_LCPLLRESETMASK_M (q2_hsclk0_lcpllresetmask_m),
      .HSCLK0_LCPLLRESET_M     (q2_hsclk0_lcpllreset_m),
      .HSCLK0_LCPLLRSVD0_M     (q2_hsclk0_lcpllrsvd0_m),
      .HSCLK0_LCPLLRSVD1_M     (q2_hsclk0_lcpllrsvd1_m),
      .HSCLK0_LCPLLSDMDATA_M   (q2_hsclk0_lcpllsdmdata_m),
      .HSCLK0_LCPLLSDMTOGGLE_M (q2_hsclk0_lcpllsdmtoggle_m),
      .HSCLK0_RPLLCLKRSVD0_M   (q2_hsclk0_rpllclkrsvd0_m),
      .HSCLK0_RPLLCLKRSVD1_M   (q2_hsclk0_rpllclkrsvd1_m),
      .HSCLK0_RPLLFBDIV_M      (q2_hsclk0_rpllfbdiv_m),
      .HSCLK0_RPLLPD_M         (q2_hsclk0_rpllpd_m),
      .HSCLK0_RPLLREFCLKSEL_M  (q2_hsclk0_rpllrefclksel_m),
      .HSCLK0_RPLLRESETBYPASSMODE_M(q2_hsclk0_rpllresetbypassmode_m),
      .HSCLK0_RPLLRESETMASK_M  (q2_hsclk0_rpllresetmask_m),
      .HSCLK0_RPLLRESET_M      (q2_hsclk0_rpllreset_m),
      .HSCLK0_RPLLRSVD0_M      (q2_hsclk0_rpllrsvd0_m),
      .HSCLK0_RPLLRSVD1_M      (q2_hsclk0_rpllrsvd1_m),
      .HSCLK0_RPLLSDMDATA_M    (q2_hsclk0_rpllsdmdata_m),
      .HSCLK0_RPLLSDMTOGGLE_M  (q2_hsclk0_rpllsdmtoggle_m),
    //.HSCLK1_GTGREFCLK2LCPLL_M(q2_hsclk1_gtgrefclk2lcpll_m),
    //.HSCLK1_GTGREFCLK2RPLL_M (q2_hsclk1_gtgrefclk2rpll_m),
      .HSCLK1_LCPLLCLKRSVD0_M  (q2_hsclk1_lcpllclkrsvd0_m),
      .HSCLK1_LCPLLCLKRSVD1_M  (q2_hsclk1_lcpllclkrsvd1_m),
      .HSCLK1_LCPLLFBDIV_M     (q2_hsclk1_lcpllfbdiv_m),
      .HSCLK1_LCPLLPD_M        (q2_hsclk1_lcpllpd_m),
      .HSCLK1_LCPLLREFCLKSEL_M (q2_hsclk1_lcpllrefclksel_m),
      .HSCLK1_LCPLLRESETBYPASSMODE_M(q2_hsclk1_lcpllresetbypassmode_m),
      .HSCLK1_LCPLLRESETMASK_M (q2_hsclk1_lcpllresetmask_m),
      .HSCLK1_LCPLLRESET_M     (q2_hsclk1_lcpllreset_m),
      .HSCLK1_LCPLLRSVD0_M     (q2_hsclk1_lcpllrsvd0_m),
      .HSCLK1_LCPLLRSVD1_M     (q2_hsclk1_lcpllrsvd1_m),
      .HSCLK1_LCPLLSDMDATA_M   (q2_hsclk1_lcpllsdmdata_m),
      .HSCLK1_LCPLLSDMTOGGLE_M (q2_hsclk1_lcpllsdmtoggle_m),
      .HSCLK1_RPLLCLKRSVD0_M   (q2_hsclk1_rpllclkrsvd0_m),
      .HSCLK1_RPLLCLKRSVD1_M   (q2_hsclk1_rpllclkrsvd1_m),
      .HSCLK1_RPLLFBDIV_M      (q2_hsclk1_rpllfbdiv_m),
      .HSCLK1_RPLLPD_M         (q2_hsclk1_rpllpd_m),
      .HSCLK1_RPLLREFCLKSEL_M  (q2_hsclk1_rpllrefclksel_m),
      .HSCLK1_RPLLRESETBYPASSMODE_M(q2_hsclk1_rpllresetbypassmode_m),
      .HSCLK1_RPLLRESETMASK_M  (q2_hsclk1_rpllresetmask_m),
      .HSCLK1_RPLLRESET_M      (q2_hsclk1_rpllreset_m),
      .HSCLK1_RPLLRSVD0_M      (q2_hsclk1_rpllrsvd0_m),
      .HSCLK1_RPLLRSVD1_M      (q2_hsclk1_rpllrsvd1_m),
      .HSCLK1_RPLLSDMDATA_M    (q2_hsclk1_rpllsdmdata_m),
      .HSCLK1_RPLLSDMTOGGLE_M  (q2_hsclk1_rpllsdmtoggle_m),

      .M0_AXIS_TREADY_M(s6_axis_tready_m),
      .M1_AXIS_TREADY_M(s7_axis_tready_m),
      .M2_AXIS_TREADY_M(s8_axis_tready_m),

      .MSTRXRESET_M({ch11_mstrxreset_m,ch10_mstrxreset_m,ch9_mstrxreset_m,ch8_mstrxreset_m}),
      .MSTTXRESET_M({ch11_msttxreset_m,ch10_msttxreset_m,ch9_msttxreset_m,ch8_msttxreset_m}),

      .PCIELINKREACHTARGET_M(q2_pcielinkreachtarget_m),
      .PCIELTSSM_M          (q2_pcieltssm_m),
      .RCALENB_M            (q2_rcalenb_m),
    //.REFCLK0_CEB_M        (q2_refclk0_ceb_m),
      .REFCLK0_CLKTESTSIG_M (q2_refclk0_clktestsig_m),
      .REFCLK0_GTREFCLKPD_M (q2_refclk0_gtrefclkpd_m),
    //.REFCLK1_CEB_M        (q2_refclk1_ceb_m),
      .REFCLK1_CLKTESTSIG_M (q2_refclk1_clktestsig_m),
      .REFCLK1_GTREFCLKPD_M (q2_refclk1_gtrefclkpd_m),
      .RXMARGINREQCMD_M     (q2_rxmarginreqcmd_m),
      .RXMARGINREQLANENUM_M (q2_rxmarginreqlanenum_m),
      .RXMARGINREQPAYLD_M   (q2_rxmarginreqpayld_m),
      .RXMARGINREQREQ_M     (q2_rxmarginreqreq_m),
      .RXMARGINRESACK_M     (q2_rxmarginresack_m),

      .S0_AXIS_TDATA_M  (m6_axis_tdata_m),
      .S0_AXIS_TLAST_M  (m6_axis_tlast_m),
      .S0_AXIS_TVALID_M (m6_axis_tvalid_m),
      .S1_AXIS_TDATA_M  (m7_axis_tdata_m),
      .S1_AXIS_TLAST_M  (m7_axis_tlast_m),
      .S1_AXIS_TVALID_M (m7_axis_tvalid_m),
      .S2_AXIS_TDATA_M  (m8_axis_tdata_m),
      .S2_AXIS_TLAST_M  (m8_axis_tlast_m),
      .S2_AXIS_TVALID_M (m8_axis_tvalid_m),
      .S0_AXIS_TREADY_M (m6_axis_tready_m),
      .S1_AXIS_TREADY_M (m7_axis_tready_m),
      .S2_AXIS_TREADY_M (m8_axis_tready_m),

      .TRIGACKOUT0_M(q2_trigackout0_m),
      .TRIGIN0_M    (q2_trigin0_m),
      .UBENABLE_M   (q2_ubenable_m),
      .UBINTR_M     (q2_ubintr_m),
      .UBIOLMBRST_M (q2_ubiolmbrst_m),
      .UBMBRST_M    (q2_ubmbrst_m),
      .UBRXUART_M   (q2_ubrxuart_m),
      .APB3PRDATA_M (q2_apb3prdata_m),
      .APB3PREADY_M (q2_apb3pready_m),
      .APB3PSLVERR_M(q2_apb3pslverr_m),

      .CH0_BUFGTCEMASK_M   (ch8_bufgtcemask_m),
      .CH0_BUFGTCE_M       (ch8_bufgtce_m),
      .CH0_BUFGTDIV_M      (ch8_bufgtdiv_m),
      .CH0_BUFGTRSTMASK_M  (ch8_bufgtrstmask_m),
      .CH0_BUFGTRST_M      (ch8_bufgtrst_m),
    //.CH0_CFOKOVWRRDY0_M  (ch8_cfokovwrrdy0_m),
    //.CH0_CFOKOVWRRDY1_M  (ch8_cfokovwrrdy1_m),
      .CH0_DMONITOROUT_M   (ch8_dmonitorout_m),
      .CH0_EYESCANDATAERROR_M(ch8_eyescandataerror_m),
      .CH0_ILORESETDONE_M  (ch8_iloresetdone_m),
      .CH0_PCSRSVDOUT_M    (ch8_pcsrsvdout_m),
      .CH0_PINRSVDAS_M     (ch8_pinrsvdas_m),
      .CH0_PHYREADY_M      (ch8_phyready_m),
      .CH0_PHYSTATUS_M     (ch8_phystatus_m),
    //.CH0_PINRSRVDAS_M    (ch8_pinrsrvdas_m),
      .CH0_RESETEXCEPTION_M(ch8_resetexception_m),
      .CH0_RX10GSTAT_M     (ch8_rx10gstat_m),
      .CH0_RXBUFSTATUS_M   (ch8_rxbufstatus_m),
      .CH0_RXBYTEISALIGNED_M(ch8_rxbyteisaligned_m),
      .CH0_RXBYTEREALIGN_M (ch8_rxbyterealign_m),
      .CH0_RXCDRLOCK_M     (ch8_rxcdrlock_m),
      .CH0_RXCDRPHDONE_M   (ch8_rxcdrphdone_m),
      .CH0_RXCHANBONDSEQ_M (ch8_rxchanbondseq_m),
      .CH0_RXCHANISALIGNED_M(ch8_rxchanisaligned_m),
      .CH0_RXCHANREALIGN_M (ch8_rxchanrealign_m),
      .CH0_RXCHBONDO_M     (ch8_rxchbondo_m),
      .CH0_RXCLKCORCNT_M   (ch8_rxclkcorcnt_m),
      .CH0_RXCOMINITDET_M  (ch8_rxcominitdet_m),
      .CH0_RXCOMMADET_M    (ch8_rxcommadet_m),
      .CH0_RXCOMSASDET_M   (ch8_rxcomsasdet_m),
      .CH0_RXCOMWAKEDET_M  (ch8_rxcomwakedet_m),
      .CH0_RXCTRL0_M       (ch8_rxctrl0_m),
      .CH0_RXCTRL1_M       (ch8_rxctrl1_m),
      .CH0_RXCTRL2_M       (ch8_rxctrl2_m),
      .CH0_RXCTRL3_M       (ch8_rxctrl3_m),
      .CH0_RXDATAEXTENDRSVD_M(ch8_rxdataextendrsvd_m),
      .CH0_RXDATAVALID_M   (ch8_rxdatavalid_m),
      .CH0_RXDATA_M        (ch8_rxdata_m),
      .CH0_RXDCCDONE_M     (ch8_rxdccdone_m),
      .CH0_RXDLYALIGNERR_M (ch8_rxdlyalignerr_m),
      .CH0_RXDLYALIGNPROG_M(ch8_rxdlyalignprog_m),
      .CH0_RXELECIDLE_M    (ch8_rxelecidle_m),
      .CH0_RXFINEALIGNDONE_M(ch8_rxfinealigndone_m),
      .CH0_RXHEADERVALID_M (ch8_rxheadervalid_m),
      .CH0_RXHEADER_M      (ch8_rxheader_m),
      .CH0_RXOSINTDONE_M   (ch8_rxosintdone_m),
      .CH0_RXOSINTSTARTED_M(ch8_rxosintstarted_m),
      .CH0_RXOSINTSTROBEDONE_M(ch8_rxosintstrobedone_m),
      .CH0_RXOSINTSTROBESTARTED_M(ch8_rxosintstrobestarted_m),
      .CH0_RXPHALIGNDONE_M (ch8_rxphaligndone_m),
      .CH0_RXPHALIGNERR_M  (ch8_rxphalignerr_m),
      .CH0_RXPHDLYRESETDONE_M(ch8_rxphdlyresetdone_m),
      .CH0_RXPHSETINITDONE_M(ch8_rxphsetinitdone_m),
      .CH0_RXPHSHIFT180DONE_M(ch8_rxphshift180done_m),
      .CH0_RXPMARESETDONE_M(ch8_rxpmaresetdone_m),
      .CH0_RXPRBSERR_M     (ch8_rxprbserr_m),
      .CH0_RXPRBSLOCKED_M  (ch8_rxprbslocked_m),
    //.CH0_RXPRGDIVRESETDONE_M(ch8_rxprgdivresetdone_m),
      .CH0_RXRESETDONE_M   (ch8_rxresetdone_m),
      .CH0_RXSLIDERDY_M    (ch8_rxsliderdy_m),
      .CH0_RXSTARTOFSEQ_M  (ch8_rxstartofseq_m),
      .CH0_RXSTATUS_M      (ch8_rxstatus_m),
      .CH0_RXSYNCDONE_M    (ch8_rxsyncdone_m),
      .CH0_RXVALID_M       (ch8_rxvalid_m),

      .CH0_TSTCLK0_M(ch8_tstclk0_m),
      .CH0_TSTCLK1_M(ch8_tstclk1_m),
      .CH1_TSTCLK0_M(ch9_tstclk0_m),
      .CH1_TSTCLK1_M(ch9_tstclk1_m),
      .CH2_TSTCLK0_M(ch10_tstclk0_m),
      .CH2_TSTCLK1_M(ch10_tstclk1_m),
      .CH3_TSTCLK0_M(ch11_tstclk0_m),
      .CH3_TSTCLK1_M(ch11_tstclk1_m),

      .CH0_TX10GSTAT_M       (ch8_tx10gstat_m),
      .CH0_TXBUFSTATUS_M     (ch8_txbufstatus_m),
      .CH0_TXCOMFINISH_M     (ch8_txcomfinish_m),
      .CH0_TXDCCDONE_M       (ch8_txdccdone_m),
      .CH0_TXDLYALIGNERR_M   (ch8_txdlyalignerr_m),
      .CH0_TXDLYALIGNPROG_M  (ch8_txdlyalignprog_m),
      .CH0_TXOUTCLK_M        (ch8_txoutclk_m),
      .CH0_TXPHALIGNDONE_M   (ch8_txphaligndone_m),
      .CH0_TXPHALIGNERR_M    (ch8_txphalignerr_m),
      .CH0_TXPHALIGNOUTRSVD_M(ch8_txphalignoutrsvd_m),
      .CH0_TXPHDLYRESETDONE_M(ch8_txphdlyresetdone_m),
      .CH0_TXPHSETINITDONE_M (ch8_txphsetinitdone_m),
      .CH0_CFOKOVRDFINISH_M  (ch8_cfokovrdfinish_m),
      .CH0_CFOKOVRDSTART_M   (ch8_cfokovrdstart_m),
      .CH1_CFOKOVRDSTART_M   (ch9_cfokovrdstart_m),
      .CH2_CFOKOVRDSTART_M   (ch10_cfokovrdstart_m),
      .CH3_CFOKOVRDSTART_M   (ch11_cfokovrdstart_m),
      .CH1_CFOKOVRDFINISH_M  (ch9_cfokovrdfinish_m),
      .CH2_CFOKOVRDFINISH_M  (ch10_cfokovrdfinish_m),
      .CH3_CFOKOVRDFINISH_M  (ch11_cfokovrdfinish_m),
      .CH0_CFOKOVRDPULSE_M   (ch8_cfokovrdpulse_m),
      .CH1_CFOKOVRDPULSE_M   (ch9_cfokovrdpulse_m),
      .CH2_CFOKOVRDPULSE_M   (ch10_cfokovrdpulse_m),
      .CH3_CFOKOVRDPULSE_M   (ch11_cfokovrdpulse_m),
      .CH0_CFOKOVRDRDY0_M    (ch8_cfokovrdrdy0_m),
      .CH0_CFOKOVRDRDY1_M    (ch8_cfokovrdrdy1_m),
      .CH1_CFOKOVRDRDY0_M    (ch9_cfokovrdrdy0_m),
      .CH1_CFOKOVRDRDY1_M    (ch9_cfokovrdrdy1_m),
      .CH2_CFOKOVRDRDY0_M    (ch10_cfokovrdrdy0_m),
      .CH2_CFOKOVRDRDY1_M    (ch10_cfokovrdrdy1_m),
      .CH3_CFOKOVRDRDY0_M    (ch11_cfokovrdrdy0_m),
      .CH3_CFOKOVRDRDY1_M    (ch11_cfokovrdrdy1_m),
      .CH0_TXPHSHIFT180DONE_M(ch8_txphshift180done_m),
      .CH0_TXPMARESETDONE_M  (ch8_txpmaresetdone_m),
    //.CH0_TXPRGDIVRESETDONE_M(ch8_txprgdivresetdone_m),
      .CH0_TXRESETDONE_M     (ch8_txresetdone_m),
      .CH0_TXSYNCDONE_M      (ch8_txsyncdone_m),
      .CH1_BUFGTCEMASK_M     (ch9_bufgtcemask_m),
      .CH1_BUFGTCE_M         (ch9_bufgtce_m),
      .CH1_BUFGTDIV_M        (ch9_bufgtdiv_m),
      .CH1_BUFGTRSTMASK_M    (ch9_bufgtrstmask_m),
      .CH1_BUFGTRST_M        (ch9_bufgtrst_m),
    //.CH1_CFOKOVWRRDY0_M    (ch9_cfokovwrrdy0_m),
    //.CH1_CFOKOVWRRDY1_M    (ch9_cfokovwrrdy1_m),
      .CH1_DMONITOROUT_M     (ch9_dmonitorout_m),
      .CH1_EYESCANDATAERROR_M(ch9_eyescandataerror_m),
      .CH1_ILORESETDONE_M    (ch9_iloresetdone_m),
      .CH1_PCSRSVDOUT_M      (ch9_pcsrsvdout_m),
      .CH1_PINRSVDAS_M       (ch9_pinrsvdas_m),
      .CH1_PHYREADY_M        (ch9_phyready_m),
      .CH1_PHYSTATUS_M       (ch9_phystatus_m),
    //.CH1_PINRSRVDAS_M      (ch9_pinrsrvdas_m),
      .CH1_RESETEXCEPTION_M  (ch9_resetexception_m),
      .CH1_RX10GSTAT_M       (ch9_rx10gstat_m),
      .CH1_RXBUFSTATUS_M     (ch9_rxbufstatus_m),
      .CH1_RXBYTEISALIGNED_M (ch9_rxbyteisaligned_m),
      .CH1_RXBYTEREALIGN_M   (ch9_rxbyterealign_m),
      .CH1_RXCDRLOCK_M       (ch9_rxcdrlock_m),
      .CH1_RXCDRPHDONE_M     (ch9_rxcdrphdone_m),
      .CH1_RXCHANBONDSEQ_M   (ch9_rxchanbondseq_m),
      .CH1_RXCHANISALIGNED_M (ch9_rxchanisaligned_m),
      .CH1_RXCHANREALIGN_M   (ch9_rxchanrealign_m),
      .CH1_RXCHBONDO_M       (ch9_rxchbondo_m),
      .CH1_RXCLKCORCNT_M     (ch9_rxclkcorcnt_m),
      .CH1_RXCOMINITDET_M    (ch9_rxcominitdet_m),
      .CH1_RXCOMMADET_M      (ch9_rxcommadet_m),
      .CH1_RXCOMSASDET_M     (ch9_rxcomsasdet_m),
      .CH1_RXCOMWAKEDET_M    (ch9_rxcomwakedet_m),
      .CH1_RXCTRL0_M         (ch9_rxctrl0_m),
      .CH1_RXCTRL1_M         (ch9_rxctrl1_m),
      .CH1_RXCTRL2_M         (ch9_rxctrl2_m),
      .CH1_RXCTRL3_M         (ch9_rxctrl3_m),
      .CH1_RXDATAEXTENDRSVD_M(ch9_rxdataextendrsvd_m),
      .CH1_RXDATAVALID_M     (ch9_rxdatavalid_m),
      .CH1_RXDATA_M          (ch9_rxdata_m),
      .CH1_RXDCCDONE_M       (ch9_rxdccdone_m),
      .CH1_RXDLYALIGNERR_M   (ch9_rxdlyalignerr_m),
      .CH1_RXDLYALIGNPROG_M  (ch9_rxdlyalignprog_m),
      .CH1_RXELECIDLE_M      (ch9_rxelecidle_m),
      .CH1_RXFINEALIGNDONE_M (ch9_rxfinealigndone_m),
      .CH1_RXHEADERVALID_M   (ch9_rxheadervalid_m),
      .CH1_RXHEADER_M        (ch9_rxheader_m),
      .CH1_RXOSINTDONE_M     (ch9_rxosintdone_m),
      .CH1_RXOSINTSTARTED_M  (ch9_rxosintstarted_m),
      .CH1_RXOSINTSTROBEDONE_M(ch9_rxosintstrobedone_m),
      .CH1_RXOSINTSTROBESTARTED_M(ch9_rxosintstrobestarted_m),
      .CH1_RXPHALIGNDONE_M   (ch9_rxphaligndone_m),
      .CH1_RXPHALIGNERR_M    (ch9_rxphalignerr_m),
      .CH1_RXPHDLYRESETDONE_M(ch9_rxphdlyresetdone_m),
      .CH1_RXPHSETINITDONE_M (ch9_rxphsetinitdone_m),
      .CH1_RXPHSHIFT180DONE_M(ch9_rxphshift180done_m),
      .CH1_RXPMARESETDONE_M  (ch9_rxpmaresetdone_m),
      .CH1_RXPRBSERR_M       (ch9_rxprbserr_m),
      .CH1_RXPRBSLOCKED_M    (ch9_rxprbslocked_m),
    //.CH1_RXPRGDIVRESETDONE_M(ch9_rxprgdivresetdone_m),
      .CH1_RXRESETDONE_M     (ch9_rxresetdone_m),
      .CH1_RXSLIDERDY_M      (ch9_rxsliderdy_m),
      .CH1_RXSTARTOFSEQ_M    (ch9_rxstartofseq_m),
      .CH1_RXSTATUS_M        (ch9_rxstatus_m),
      .CH1_RXSYNCDONE_M      (ch9_rxsyncdone_m),
      .CH1_RXVALID_M         (ch9_rxvalid_m),
      .CH1_TX10GSTAT_M       (ch9_tx10gstat_m),
      .CH1_TXBUFSTATUS_M     (ch9_txbufstatus_m),
      .CH1_TXCOMFINISH_M     (ch9_txcomfinish_m),
      .CH1_TXDCCDONE_M       (ch9_txdccdone_m),
      .CH1_TXDLYALIGNERR_M   (ch9_txdlyalignerr_m),
      .CH1_TXDLYALIGNPROG_M  (ch9_txdlyalignprog_m),
      .CH1_TXPHALIGNDONE_M   (ch9_txphaligndone_m),
      .CH1_TXPHALIGNERR_M    (ch9_txphalignerr_m),
      .CH1_TXPHALIGNOUTRSVD_M(ch9_txphalignoutrsvd_m),
      .CH1_TXPHDLYRESETDONE_M(ch9_txphdlyresetdone_m),
      .CH1_TXPHSETINITDONE_M (ch9_txphsetinitdone_m),
      .CH1_TXPHSHIFT180DONE_M(ch9_txphshift180done_m),
      .CH1_TXPMARESETDONE_M  (ch9_txpmaresetdone_m),
    //.CH1_TXPRGDIVRESETDONE_M(ch9_txprgdivresetdone_m),
      .CH1_TXRESETDONE_M     (ch9_txresetdone_m),
      .CH1_TXSYNCDONE_M      (ch9_txsyncdone_m),
      .CH2_BUFGTCEMASK_M     (ch10_bufgtcemask_m),
      .CH2_BUFGTCE_M         (ch10_bufgtce_m),
      .CH2_BUFGTDIV_M        (ch10_bufgtdiv_m),
      .CH2_BUFGTRSTMASK_M    (ch10_bufgtrstmask_m),
      .CH2_BUFGTRST_M        (ch10_bufgtrst_m),
    //.CH2_CFOKOVWRRDY0_M    (ch10_cfokovwrrdy0_m),
    //.CH2_CFOKOVWRRDY1_M    (ch10_cfokovwrrdy1_m),
      .CH2_DMONITOROUT_M     (ch10_dmonitorout_m),
      .CH2_EYESCANDATAERROR_M(ch10_eyescandataerror_m),
      .CH2_ILORESETDONE_M    (ch10_iloresetdone_m),
      .CH2_PCSRSVDOUT_M      (ch10_pcsrsvdout_m),
      .CH2_PINRSVDAS_M       (ch10_pinrsvdas_m),
      .CH2_PHYREADY_M        (ch10_phyready_m),
      .CH2_PHYSTATUS_M       (ch10_phystatus_m),
    //.CH2_PINRSRVDAS_M      (ch10_pinrsrvdas_m),
      .CH2_RESETEXCEPTION_M  (ch10_resetexception_m),
      .CH2_RX10GSTAT_M       (ch10_rx10gstat_m),
      .CH2_RXBUFSTATUS_M     (ch10_rxbufstatus_m),
      .CH2_RXBYTEISALIGNED_M (ch10_rxbyteisaligned_m),
      .CH2_RXBYTEREALIGN_M   (ch10_rxbyterealign_m),
      .CH2_RXCDRLOCK_M       (ch10_rxcdrlock_m),
      .CH2_RXCDRPHDONE_M     (ch10_rxcdrphdone_m),
      .CH2_RXCHANBONDSEQ_M   (ch10_rxchanbondseq_m),
      .CH2_RXCHANISALIGNED_M (ch10_rxchanisaligned_m),
      .CH2_RXCHANREALIGN_M   (ch10_rxchanrealign_m),
      .CH2_RXCHBONDO_M       (ch10_rxchbondo_m),
      .CH2_RXCLKCORCNT_M     (ch10_rxclkcorcnt_m),
      .CH2_RXCOMINITDET_M    (ch10_rxcominitdet_m),
      .CH2_RXCOMMADET_M      (ch10_rxcommadet_m),
      .CH2_RXCOMSASDET_M     (ch10_rxcomsasdet_m),
      .CH2_RXCOMWAKEDET_M    (ch10_rxcomwakedet_m),
      .CH2_RXCTRL0_M         (ch10_rxctrl0_m),
      .CH2_RXCTRL1_M         (ch10_rxctrl1_m),
      .CH2_RXCTRL2_M         (ch10_rxctrl2_m),
      .CH2_RXCTRL3_M         (ch10_rxctrl3_m),
      .CH2_RXDATAEXTENDRSVD_M(ch10_rxdataextendrsvd_m),
      .CH2_RXDATAVALID_M     (ch10_rxdatavalid_m),
      .CH2_RXDATA_M          (ch10_rxdata_m),
      .CH2_RXDCCDONE_M       (ch10_rxdccdone_m),
      .CH2_RXDLYALIGNERR_M   (ch10_rxdlyalignerr_m),
      .CH2_RXDLYALIGNPROG_M  (ch10_rxdlyalignprog_m),
      .CH2_RXELECIDLE_M      (ch10_rxelecidle_m),
      .CH2_RXFINEALIGNDONE_M (ch10_rxfinealigndone_m),
      .CH2_RXHEADERVALID_M   (ch10_rxheadervalid_m),
      .CH2_RXHEADER_M        (ch10_rxheader_m),
      .CH2_RXOSINTDONE_M     (ch10_rxosintdone_m),
      .CH2_RXOSINTSTARTED_M  (ch10_rxosintstarted_m),
      .CH2_RXOSINTSTROBEDONE_M(ch10_rxosintstrobedone_m),
      .CH2_RXOSINTSTROBESTARTED_M(ch10_rxosintstrobestarted_m),
      .CH2_RXPHALIGNDONE_M   (ch10_rxphaligndone_m),
      .CH2_RXPHALIGNERR_M    (ch10_rxphalignerr_m),
      .CH2_RXPHDLYRESETDONE_M(ch10_rxphdlyresetdone_m),
      .CH2_RXPHSETINITDONE_M (ch10_rxphsetinitdone_m),
      .CH2_RXPHSHIFT180DONE_M(ch10_rxphshift180done_m),
      .CH2_RXPMARESETDONE_M  (ch10_rxpmaresetdone_m),
      .CH2_RXPRBSERR_M       (ch10_rxprbserr_m),
      .CH2_RXPRBSLOCKED_M    (ch10_rxprbslocked_m),
    //.CH2_RXPRGDIVRESETDONE_M(ch10_rxprgdivresetdone_m),
      .CH2_RXRESETDONE_M     (ch10_rxresetdone_m),
      .CH2_RXSLIDERDY_M      (ch10_rxsliderdy_m),
      .CH2_RXSTARTOFSEQ_M    (ch10_rxstartofseq_m),
      .CH2_RXSTATUS_M        (ch10_rxstatus_m),
      .CH2_RXSYNCDONE_M      (ch10_rxsyncdone_m),
      .CH2_RXVALID_M         (ch10_rxvalid_m),
      .CH2_TX10GSTAT_M       (ch10_tx10gstat_m),
      .CH2_TXBUFSTATUS_M     (ch10_txbufstatus_m),
      .CH2_TXCOMFINISH_M     (ch10_txcomfinish_m),
      .CH2_TXDCCDONE_M       (ch10_txdccdone_m),
      .CH2_TXDLYALIGNERR_M   (ch10_txdlyalignerr_m),
      .CH2_TXDLYALIGNPROG_M  (ch10_txdlyalignprog_m),
      .CH2_TXPHALIGNDONE_M   (ch10_txphaligndone_m),
      .CH2_TXPHALIGNERR_M    (ch10_txphalignerr_m),
      .CH2_TXPHALIGNOUTRSVD_M(ch10_txphalignoutrsvd_m),
      .CH2_TXPHDLYRESETDONE_M(ch10_txphdlyresetdone_m),
      .CH2_TXPHSETINITDONE_M (ch10_txphsetinitdone_m),
      .CH2_TXPHSHIFT180DONE_M(ch10_txphshift180done_m),
      .CH2_TXPMARESETDONE_M  (ch10_txpmaresetdone_m),
    //.CH2_TXPRGDIVRESETDONE_M(ch10_txprgdivresetdone_m),
      .CH2_TXRESETDONE_M     (ch10_txresetdone_m),
      .CH2_TXSYNCDONE_M      (ch10_txsyncdone_m),
      .CH3_BUFGTCEMASK_M     (ch11_bufgtcemask_m),
      .CH3_BUFGTCE_M         (ch11_bufgtce_m),
      .CH3_BUFGTDIV_M        (ch11_bufgtdiv_m),
      .CH3_BUFGTRSTMASK_M    (ch11_bufgtrstmask_m),
      .CH3_BUFGTRST_M        (ch11_bufgtrst_m),
    //.CH3_CFOKOVWRRDY0_M    (ch11_cfokovwrrdy0_m),
    //.CH3_CFOKOVWRRDY1_M    (ch11_cfokovwrrdy1_m),
      .CH3_DMONITOROUT_M     (ch11_dmonitorout_m),
      .CH3_EYESCANDATAERROR_M(ch11_eyescandataerror_m),
      .CH3_ILORESETDONE_M    (ch11_iloresetdone_m),
      .CH3_PCSRSVDOUT_M      (ch11_pcsrsvdout_m),
      .CH3_PINRSVDAS_M       (ch11_pinrsvdas_m),
      .CH3_PHYREADY_M        (ch11_phyready_m),
      .CH3_PHYSTATUS_M       (ch11_phystatus_m),
    //.CH3_PINRSRVDAS_M      (ch11_pinrsrvdas_m),
      .CH3_RESETEXCEPTION_M  (ch11_resetexception_m),
      .CH3_RX10GSTAT_M       (ch11_rx10gstat_m),
      .CH3_RXBUFSTATUS_M     (ch11_rxbufstatus_m),
      .CH3_RXBYTEISALIGNED_M (ch11_rxbyteisaligned_m),
      .CH3_RXBYTEREALIGN_M   (ch11_rxbyterealign_m),
      .CH3_RXCDRLOCK_M       (ch11_rxcdrlock_m),
      .CH3_RXCDRPHDONE_M     (ch11_rxcdrphdone_m),
      .CH3_RXCHANBONDSEQ_M   (ch11_rxchanbondseq_m),
      .CH3_RXCHANISALIGNED_M (ch11_rxchanisaligned_m),
      .CH3_RXCHANREALIGN_M   (ch11_rxchanrealign_m),
      .CH3_RXCHBONDO_M       (ch11_rxchbondo_m),
      .CH3_RXCLKCORCNT_M     (ch11_rxclkcorcnt_m),
      .CH3_RXCOMINITDET_M    (ch11_rxcominitdet_m),
      .CH3_RXCOMMADET_M      (ch11_rxcommadet_m),
      .CH3_RXCOMSASDET_M     (ch11_rxcomsasdet_m),
      .CH3_RXCOMWAKEDET_M    (ch11_rxcomwakedet_m),
      .CH3_RXCTRL0_M         (ch11_rxctrl0_m),
      .CH3_RXCTRL1_M         (ch11_rxctrl1_m),
      .CH3_RXCTRL2_M         (ch11_rxctrl2_m),
      .CH3_RXCTRL3_M         (ch11_rxctrl3_m),
      .CH3_RXDATAEXTENDRSVD_M(ch11_rxdataextendrsvd_m),
      .CH3_RXDATAVALID_M     (ch11_rxdatavalid_m),
      .CH3_RXDATA_M          (ch11_rxdata_m),
      .CH3_RXDCCDONE_M       (ch11_rxdccdone_m),
      .CH3_RXDLYALIGNERR_M   (ch11_rxdlyalignerr_m),
      .CH3_RXDLYALIGNPROG_M  (ch11_rxdlyalignprog_m),
      .CH3_RXELECIDLE_M      (ch11_rxelecidle_m),
      .CH3_RXFINEALIGNDONE_M (ch11_rxfinealigndone_m),
      .CH3_RXHEADERVALID_M   (ch11_rxheadervalid_m),
      .CH3_RXHEADER_M        (ch11_rxheader_m),
      .CH3_RXOSINTDONE_M     (ch11_rxosintdone_m),
      .CH3_RXOSINTSTARTED_M  (ch11_rxosintstarted_m),
      .CH3_RXOSINTSTROBEDONE_M(ch11_rxosintstrobedone_m),
      .CH3_RXOSINTSTROBESTARTED_M(ch11_rxosintstrobestarted_m),
      .CH3_RXPHALIGNDONE_M   (ch11_rxphaligndone_m),
      .CH3_RXPHALIGNERR_M    (ch11_rxphalignerr_m),
      .CH3_RXPHDLYRESETDONE_M(ch11_rxphdlyresetdone_m),
      .CH3_RXPHSETINITDONE_M (ch11_rxphsetinitdone_m),
      .CH3_RXPHSHIFT180DONE_M(ch11_rxphshift180done_m),
      .CH3_RXPMARESETDONE_M  (ch11_rxpmaresetdone_m),
      .CH3_RXPRBSERR_M       (ch11_rxprbserr_m),
      .CH3_RXPRBSLOCKED_M    (ch11_rxprbslocked_m),
    //.CH3_RXPRGDIVRESETDONE_M(ch11_rxprgdivresetdone_m),
      .CH3_RXRESETDONE_M     (ch11_rxresetdone_m),
      .CH3_RXSLIDERDY_M      (ch11_rxsliderdy_m),
      .CH3_RXSTARTOFSEQ_M    (ch11_rxstartofseq_m),
      .CH3_RXSTATUS_M        (ch11_rxstatus_m),
      .CH3_RXSYNCDONE_M      (ch11_rxsyncdone_m),
      .CH3_RXVALID_M         (ch11_rxvalid_m),
      .CH3_TX10GSTAT_M       (ch11_tx10gstat_m),
      .CH3_TXBUFSTATUS_M     (ch11_txbufstatus_m),
      .CH3_TXCOMFINISH_M     (ch11_txcomfinish_m),
      .CH3_TXDCCDONE_M       (ch11_txdccdone_m),
      .CH3_TXDLYALIGNERR_M   (ch11_txdlyalignerr_m),
      .CH3_TXDLYALIGNPROG_M  (ch11_txdlyalignprog_m),
      .CH3_TXPHALIGNDONE_M   (ch11_txphaligndone_m),
      .CH3_TXPHALIGNERR_M    (ch11_txphalignerr_m),
      .CH3_TXPHALIGNOUTRSVD_M(ch11_txphalignoutrsvd_m),
      .CH3_TXPHDLYRESETDONE_M(ch11_txphdlyresetdone_m),
      .CH3_TXPHSETINITDONE_M (ch11_txphsetinitdone_m),
      .CH3_TXPHSHIFT180DONE_M(ch11_txphshift180done_m),
      .CH3_TXPMARESETDONE_M  (ch11_txpmaresetdone_m),
    //.CH3_TXPRGDIVRESETDONE_M(ch11_txprgdivresetdone_m),
      .CH3_TXRESETDONE_M     (ch11_txresetdone_m),
      .CH3_TXSYNCDONE_M      (ch11_txsyncdone_m),

      .CORRECTERR_M (q2_correcterr_m),
      .CTRLRSVDOUT_M(q2_ctrlrsvdout_m),

      .DEBUGTRACETDATA_M (q2_debugtracetdata_m),
      .DEBUGTRACETVALID_M(q2_debugtracetvalid_m),

      .GPO_M(q2_gpo_m),
      .GTPOWERGOOD_M(q2_gtpowergood_m),

      .HSCLK0_LCPLLFBCLKLOST_M (q2_hsclk0_lcpllfbclklost_m),
      .HSCLK0_LCPLLLOCK_M      (q2_hsclk0_lcplllock_m),
      .HSCLK0_LCPLLREFCLKLOST_M(q2_hsclk0_lcpllrefclklost_m),
      .HSCLK0_LCPLLREFCLKMONITOR_M(q2_hsclk0_lcpllrefclkmonitor_m),
      .HSCLK0_LCPLLRSVDOUT_M   (q2_hsclk0_lcpllrsvdout_m),
      .HSCLK0_RPLLFBCLKLOST_M  (q2_hsclk0_rpllfbclklost_m),
      .HSCLK0_RPLLLOCK_M       (q2_hsclk0_rplllock_m),
      .HSCLK0_RPLLREFCLKLOST_M (q2_hsclk0_rpllrefclklost_m),
      .HSCLK0_RPLLREFCLKMONITOR_M(q2_hsclk0_rpllrefclkmonitor_m),
      .HSCLK0_RPLLRSVDOUT_M    (q2_hsclk0_rpllrsvdout_m),
      .HSCLK1_LCPLLFBCLKLOST_M (q2_hsclk1_lcpllfbclklost_m),
      .HSCLK1_LCPLLLOCK_M      (q2_hsclk1_lcplllock_m),
      .HSCLK1_LCPLLREFCLKLOST_M(q2_hsclk1_lcpllrefclklost_m),
      .HSCLK1_LCPLLREFCLKMONITOR_M(q2_hsclk1_lcpllrefclkmonitor_m),
      .HSCLK1_LCPLLRSVDOUT_M   (q2_hsclk1_lcpllrsvdout_m),
      .HSCLK1_RPLLFBCLKLOST_M  (q2_hsclk1_rpllfbclklost_m),
      .HSCLK1_RPLLLOCK_M       (q2_hsclk1_rplllock_m),
      .HSCLK1_RPLLREFCLKLOST_M (q2_hsclk1_rpllrefclklost_m),
      .HSCLK1_RPLLREFCLKMONITOR_M(q2_hsclk1_rpllrefclkmonitor_m),
      .HSCLK1_RPLLRSVDOUT_M    (q2_hsclk1_rpllrsvdout_m),

      .M0_AXIS_TDATA_M  (s6_axis_tdata_m),
      .M0_AXIS_TLAST_M  (s6_axis_tlast_m),
      .M0_AXIS_TVALID_M (s6_axis_tvalid_m),
      .M1_AXIS_TDATA_M  (s7_axis_tdata_m),
      .M1_AXIS_TLAST_M  (s7_axis_tlast_m),
      .M1_AXIS_TVALID_M (s7_axis_tvalid_m),
      .M2_AXIS_TDATA_M  (s8_axis_tdata_m),
      .M2_AXIS_TLAST_M  (s8_axis_tlast_m),
      .M2_AXIS_TVALID_M (s8_axis_tvalid_m),

      .MSTRXRESETDONE_M({ch11_mstrxresetdone_m,ch10_mstrxresetdone_m,ch9_mstrxresetdone_m,ch8_mstrxresetdone_m}),
      .MSTTXRESETDONE_M({ch11_msttxresetdone_m,ch10_msttxresetdone_m,ch9_msttxresetdone_m,ch8_msttxresetdone_m}),

      .CH0_RXPROGDIVRESETDONE_M(ch8_rxprogdivresetdone_m),
      .CH1_RXPROGDIVRESETDONE_M(ch9_rxprogdivresetdone_m),
      .CH2_RXPROGDIVRESETDONE_M(ch10_rxprogdivresetdone_m),
      .CH3_RXPROGDIVRESETDONE_M(ch11_rxprogdivresetdone_m),
      .CH0_TXPROGDIVRESETDONE_M(ch8_txprogdivresetdone_m),
      .CH1_TXPROGDIVRESETDONE_M(ch9_txprogdivresetdone_m),
      .CH2_TXPROGDIVRESETDONE_M(ch10_txprogdivresetdone_m),
      .CH3_TXPROGDIVRESETDONE_M(ch11_txprogdivresetdone_m),

      .RXMARGINREQACK_M  (q2_rxmarginreqack_m),
      .RXMARGINRESCMD_M  (q2_rxmarginrescmd_m),
      .RXMARGINRESLANENUM_M(q2_rxmarginreslanenum_m),
      .RXMARGINRESPAYLD_M(q2_rxmarginrespayld_m),
      .RXMARGINRESREQ_M  (q2_rxmarginresreq_m),
      .TRIGACKIN0_M      (q2_trigackin0_m),
      .TRIGOUT0_M        (q2_trigout0_m),
      .UBINTERRUPT_M     (q2_ubinterrupt_m),
      .UBTXUART_M        (q2_ubtxuart_m),
      .UNCORRECTERR_M    (q2_uncorrecterr_m),
      .RXMARGINCLK_M     (q2_rxmarginclk_m),

      .XPIPE_HSDP_RXGEARBOXSLIP (q1q2_hsdp_xpipe_ch0_rxgearboxslip),
      .XPIPE_HSDP_RXPCSRESET    (q1q2_hsdp_xpipe_ch0_rxpcsreset),
      .XPIPE_HSDP_TXHEADER      (q1q2_hsdp_xpipe_ch0_txheader),
      .XPIPE_HSDP_TXSEQUENCE    (q1q2_hsdp_xpipe_ch0_txsequence),
      .XPIPE_HSDP_RXDATAVALID   (q1q2_hsdp_xpipe_ch0_rxdatavalid),
      .XPIPE_HSDP_RXHEADER      (q1q2_hsdp_xpipe_ch0_rxheader),
      .XPIPE_HSDP_RXRESETDONE   (q1q2_hsdp_xpipe_ch0_rxresetdone),
      .XPIPE_HSDP_TXRESETDONE   (q1q2_hsdp_xpipe_ch0_txresetdone),
      .XPIPE_HSDP_RXHEADERVALID (q1q2_hsdp_xpipe_ch0_rxheadervalid),

      .XPIPE_HSDP_RXGEARBOXSLIP_1 (q1q2_hsdp_xpipe_ch1_rxgearboxslip),
      .XPIPE_HSDP_RXPCSRESET_1    (q1q2_hsdp_xpipe_ch1_rxpcsreset),
      .XPIPE_HSDP_TXHEADER_1      (q1q2_hsdp_xpipe_ch1_txheader),
      .XPIPE_HSDP_TXSEQUENCE_1    (q1q2_hsdp_xpipe_ch1_txsequence),
      .XPIPE_HSDP_RXDATAVALID_1   (q1q2_hsdp_xpipe_ch1_rxdatavalid),
      .XPIPE_HSDP_RXHEADER_1      (q1q2_hsdp_xpipe_ch1_rxheader),
      .XPIPE_HSDP_RXRESETDONE_1   (q1q2_hsdp_xpipe_ch1_rxresetdone),
      .XPIPE_HSDP_TXRESETDONE_1   (q1q2_hsdp_xpipe_ch1_txresetdone),
      .XPIPE_HSDP_RXHEADERVALID_1 (q1q2_hsdp_xpipe_ch1_rxheadervalid),

      .XPIPE_HSDP_RXGEARBOXSLIP_2 (q1q2_hsdp_xpipe_ch2_rxgearboxslip),
      .XPIPE_HSDP_RXPCSRESET_2    (q1q2_hsdp_xpipe_ch2_rxpcsreset),
      .XPIPE_HSDP_TXHEADER_2      (q1q2_hsdp_xpipe_ch2_txheader),
      .XPIPE_HSDP_TXSEQUENCE_2    (q1q2_hsdp_xpipe_ch2_txsequence),
      .XPIPE_HSDP_RXDATAVALID_2   (q1q2_hsdp_xpipe_ch2_rxdatavalid),
      .XPIPE_HSDP_RXHEADER_2      (q1q2_hsdp_xpipe_ch2_rxheader),
      .XPIPE_HSDP_RXRESETDONE_2   (q1q2_hsdp_xpipe_ch2_rxresetdone),
      .XPIPE_HSDP_TXRESETDONE_2   (q1q2_hsdp_xpipe_ch2_txresetdone),
      .XPIPE_HSDP_RXHEADERVALID_2 (q1q2_hsdp_xpipe_ch2_rxheadervalid),

      .XPIPE_HSDP_RXGEARBOXSLIP_M (q2q3_hsdp_xpipe_ch0_rxgearboxslip),
      .XPIPE_HSDP_RXPCSRESET_M    (q2q3_hsdp_xpipe_ch0_rxpcsreset),
      .XPIPE_HSDP_TXHEADER_M      (q2q3_hsdp_xpipe_ch0_txheader),
      .XPIPE_HSDP_TXSEQUENCE_M    (q2q3_hsdp_xpipe_ch0_txsequence),
      .XPIPE_HSDP_RXDATAVALID_M   (q2q3_hsdp_xpipe_ch0_rxdatavalid),
      .XPIPE_HSDP_RXHEADER_M      (q2q3_hsdp_xpipe_ch0_rxheader),
      .XPIPE_HSDP_RXRESETDONE_M   (q2q3_hsdp_xpipe_ch0_rxresetdone),
      .XPIPE_HSDP_TXRESETDONE_M   (q2q3_hsdp_xpipe_ch0_txresetdone),
      .XPIPE_HSDP_RXHEADERVALID_M (q2q3_hsdp_xpipe_ch0_rxheadervalid),

      .XPIPE_HSDP_RXGEARBOXSLIP_M_1 (q2q3_hsdp_xpipe_ch1_rxgearboxslip),
      .XPIPE_HSDP_RXPCSRESET_M_1    (q2q3_hsdp_xpipe_ch1_rxpcsreset),
      .XPIPE_HSDP_TXHEADER_M_1      (q2q3_hsdp_xpipe_ch1_txheader),
      .XPIPE_HSDP_TXSEQUENCE_M_1    (q2q3_hsdp_xpipe_ch1_txsequence),
      .XPIPE_HSDP_RXDATAVALID_M_1   (q2q3_hsdp_xpipe_ch1_rxdatavalid),
      .XPIPE_HSDP_RXHEADER_M_1      (q2q3_hsdp_xpipe_ch1_rxheader),
      .XPIPE_HSDP_RXRESETDONE_M_1   (q2q3_hsdp_xpipe_ch1_rxresetdone),
      .XPIPE_HSDP_TXRESETDONE_M_1   (q2q3_hsdp_xpipe_ch1_txresetdone),
      .XPIPE_HSDP_RXHEADERVALID_M_1 (q2q3_hsdp_xpipe_ch1_rxheadervalid),

      .XPIPE_HSDP_RXGEARBOXSLIP_M_2 (q2q3_hsdp_xpipe_ch2_rxgearboxslip),
      .XPIPE_HSDP_RXPCSRESET_M_2    (q2q3_hsdp_xpipe_ch2_rxpcsreset),
      .XPIPE_HSDP_TXHEADER_M_2      (q2q3_hsdp_xpipe_ch2_txheader),
      .XPIPE_HSDP_TXSEQUENCE_M_2    (q2q3_hsdp_xpipe_ch2_txsequence),
      .XPIPE_HSDP_RXDATAVALID_M_2   (q2q3_hsdp_xpipe_ch2_rxdatavalid),
      .XPIPE_HSDP_RXHEADER_M_2      (q2q3_hsdp_xpipe_ch2_rxheader),
      .XPIPE_HSDP_RXRESETDONE_M_2   (q2q3_hsdp_xpipe_ch2_rxresetdone),
      .XPIPE_HSDP_TXRESETDONE_M_2   (q2q3_hsdp_xpipe_ch2_txresetdone),
      .XPIPE_HSDP_RXHEADERVALID_M_2 (q2q3_hsdp_xpipe_ch2_rxheadervalid),

      .XPIPE_PCIELINKREACHTARGET (q1q2_xpipe_pcielinkreachtarget_m),
      .XPIPE_PCIELTSSMSTATE      (q1q2_xpipe_pcieltssmstate_m),
      .XPIPE_PCIELINKREACHTARGET_1(q1q2_xpipe_pcielinkreachtarget_m_1),
      .XPIPE_PCIELTSSMSTATE_1    (q1q2_xpipe_pcieltssmstate_m_1),
      .XPIPE_RXMARGINREQCMD      (q1q2_xpipe_rxmarginreqcmd_m),
      .XPIPE_RXMARGINREQLANENUM  (q1q2_xpipe_rxmarginreqlanenum_m),
      .XPIPE_RXMARGINREQPAYLOAD  (q1q2_xpipe_rxmarginreqpayload_m),
      .XPIPE_RXMARGINREQREQ      (q1q2_xpipe_rxmarginreqreq_m),
      .XPIPE_RXMARGINRESACK      (q1q2_xpipe_rxmarginresack_m),
      .XPIPE_RXMARGINREQCMD_1    (q1q2_xpipe_rxmarginreqcmd_m_1),
      .XPIPE_RXMARGINREQLANENUM_1(q1q2_xpipe_rxmarginreqlanenum_m_1),
      .XPIPE_RXMARGINREQPAYLOAD_1(q1q2_xpipe_rxmarginreqpayload_m_1),
      .XPIPE_RXMARGINREQREQ_1    (q1q2_xpipe_rxmarginreqreq_m_1),
      .XPIPE_RXMARGINRESACK_1    (q1q2_xpipe_rxmarginresack_m_1),
      .XPIPE_RXMARGINREQCMD_2    (q1q2_xpipe_rxmarginreqcmd_m_2),
      .XPIPE_RXMARGINREQLANENUM_2(q1q2_xpipe_rxmarginreqlanenum_m_2),
      .XPIPE_RXMARGINREQPAYLOAD_2(q1q2_xpipe_rxmarginreqpayload_m_2),
      .XPIPE_RXMARGINREQREQ_2    (q1q2_xpipe_rxmarginreqreq_m_2),
      .XPIPE_RXMARGINRESACK_2    (q1q2_xpipe_rxmarginresack_m_2),
      .XPIPE_RXMARGINREQCMD_3    (q1q2_xpipe_rxmarginreqcmd_m_3),
      .XPIPE_RXMARGINREQLANENUM_3(q1q2_xpipe_rxmarginreqlanenum_m_3),
      .XPIPE_RXMARGINREQPAYLOAD_3(q1q2_xpipe_rxmarginreqpayload_m_3),
      .XPIPE_RXMARGINREQREQ_3    (q1q2_xpipe_rxmarginreqreq_m_3),
      .XPIPE_RXMARGINRESACK_3    (q1q2_xpipe_rxmarginresack_m_3),
      .XPIPE_RXMARGINREQACK      (q1q2_xpipe_rxmarginreqack_m),
      .XPIPE_RXMARGINREQACK_1    (q1q2_xpipe_rxmarginreqack_m_1),
      .XPIPE_RXMARGINREQACK_2    (q1q2_xpipe_rxmarginreqack_m_2),
      .XPIPE_RXMARGINREQACK_3    (q1q2_xpipe_rxmarginreqack_m_3),
      .XPIPE_RXMARGINRESCMD      (q1q2_xpipe_rxmarginrescmd_m),
      .XPIPE_RXMARGINRESCMD_1    (q1q2_xpipe_rxmarginrescmd_m_1),
      .XPIPE_RXMARGINRESCMD_2    (q1q2_xpipe_rxmarginrescmd_m_2),
      .XPIPE_RXMARGINRESCMD_3    (q1q2_xpipe_rxmarginrescmd_m_3),
      .XPIPE_RXMARGINRESLANENUM  (q1q2_xpipe_rxmarginreslanenum_m),
      .XPIPE_RXMARGINRESLANENUM_1(q1q2_xpipe_rxmarginreslanenum_m_1),
      .XPIPE_RXMARGINRESLANENUM_2(q1q2_xpipe_rxmarginreslanenum_m_2),
      .XPIPE_RXMARGINRESLANENUM_3(q1q2_xpipe_rxmarginreslanenum_m_3),
      .XPIPE_RXMARGINRESPAYLOAD  (q1q2_xpipe_rxmarginrespayload_m),
      .XPIPE_RXMARGINRESPAYLOAD_1(q1q2_xpipe_rxmarginrespayload_m_1),
      .XPIPE_RXMARGINRESPAYLOAD_2(q1q2_xpipe_rxmarginrespayload_m_2),
      .XPIPE_RXMARGINRESPAYLOAD_3(q1q2_xpipe_rxmarginrespayload_m_3),
      .XPIPE_RXMARGINRESREQ      (q1q2_xpipe_rxmarginresreq_m),
      .XPIPE_RXMARGINRESREQ_1    (q1q2_xpipe_rxmarginresreq_m_1),
      .XPIPE_RXMARGINRESREQ_2    (q1q2_xpipe_rxmarginresreq_m_2),
      .XPIPE_RXMARGINRESREQ_3    (q1q2_xpipe_rxmarginresreq_m_3),

      .XPIPE_PCIELINKREACHTARGET_M  (q2q3_xpipe_pcielinkreachtarget_m),
      .XPIPE_PCIELINKREACHTARGET_M_1(q2q3_xpipe_pcielinkreachtarget_m_1),
      .XPIPE_PCIELTSSMSTATE_M       (q2q3_xpipe_pcieltssmstate_m),
      .XPIPE_PCIELTSSMSTATE_M_1     (q2q3_xpipe_pcieltssmstate_m_1),
      .XPIPE_RXMARGINREQCMD_M       (q2q3_xpipe_rxmarginreqcmd_m),
      .XPIPE_RXMARGINREQCMD_M_1     (q2q3_xpipe_rxmarginreqcmd_m_1),
      .XPIPE_RXMARGINREQCMD_M_2     (q2q3_xpipe_rxmarginreqcmd_m_2),
      .XPIPE_RXMARGINREQCMD_M_3     (q2q3_xpipe_rxmarginreqcmd_m_3),
      .XPIPE_RXMARGINREQLANENUM_M   (q2q3_xpipe_rxmarginreqlanenum_m),
      .XPIPE_RXMARGINREQLANENUM_M_1 (q2q3_xpipe_rxmarginreqlanenum_m_1),
      .XPIPE_RXMARGINREQLANENUM_M_2 (q2q3_xpipe_rxmarginreqlanenum_m_2),
      .XPIPE_RXMARGINREQLANENUM_M_3 (q2q3_xpipe_rxmarginreqlanenum_m_3),
      .XPIPE_RXMARGINREQPAYLOAD_M   (q2q3_xpipe_rxmarginreqpayload_m),
      .XPIPE_RXMARGINREQPAYLOAD_M_1 (q2q3_xpipe_rxmarginreqpayload_m_1),
      .XPIPE_RXMARGINREQPAYLOAD_M_2 (q2q3_xpipe_rxmarginreqpayload_m_2),
      .XPIPE_RXMARGINREQPAYLOAD_M_3 (q2q3_xpipe_rxmarginreqpayload_m_3),
      .XPIPE_RXMARGINREQREQ_M       (q2q3_xpipe_rxmarginreqreq_m),
      .XPIPE_RXMARGINREQREQ_M_1     (q2q3_xpipe_rxmarginreqreq_m_1),
      .XPIPE_RXMARGINREQREQ_M_2     (q2q3_xpipe_rxmarginreqreq_m_2),
      .XPIPE_RXMARGINREQREQ_M_3     (q2q3_xpipe_rxmarginreqreq_m_3),
      .XPIPE_RXMARGINRESACK_M       (q2q3_xpipe_rxmarginresack_m),
      .XPIPE_RXMARGINRESACK_M_1     (q2q3_xpipe_rxmarginresack_m_1),
      .XPIPE_RXMARGINRESACK_M_2     (q2q3_xpipe_rxmarginresack_m_2),
      .XPIPE_RXMARGINRESACK_M_3     (q2q3_xpipe_rxmarginresack_m_3),
      .XPIPE_RXMARGINREQACK_M       (q2q3_xpipe_rxmarginreqack_m),
      .XPIPE_RXMARGINREQACK_M_1     (q2q3_xpipe_rxmarginreqack_m_1),
      .XPIPE_RXMARGINREQACK_M_2     (q2q3_xpipe_rxmarginreqack_m_2),
      .XPIPE_RXMARGINREQACK_M_3     (q2q3_xpipe_rxmarginreqack_m_3),
      .XPIPE_RXMARGINRESCMD_M       (q2q3_xpipe_rxmarginrescmd_m),
      .XPIPE_RXMARGINRESCMD_M_1     (q2q3_xpipe_rxmarginrescmd_m_1),
      .XPIPE_RXMARGINRESCMD_M_2     (q2q3_xpipe_rxmarginrescmd_m_2),
      .XPIPE_RXMARGINRESCMD_M_3     (q2q3_xpipe_rxmarginrescmd_m_3),
      .XPIPE_RXMARGINRESLANENUM_M   (q2q3_xpipe_rxmarginreslanenum_m),
      .XPIPE_RXMARGINRESLANENUM_M_1 (q2q3_xpipe_rxmarginreslanenum_m_1),
      .XPIPE_RXMARGINRESLANENUM_M_2 (q2q3_xpipe_rxmarginreslanenum_m_2),
      .XPIPE_RXMARGINRESLANENUM_M_3 (q2q3_xpipe_rxmarginreslanenum_m_3),
      .XPIPE_RXMARGINRESPAYLOAD_M   (q2q3_xpipe_rxmarginrespayload_m),
      .XPIPE_RXMARGINRESPAYLOAD_M_1 (q2q3_xpipe_rxmarginrespayload_m_1),
      .XPIPE_RXMARGINRESPAYLOAD_M_2 (q2q3_xpipe_rxmarginrespayload_m_2),
      .XPIPE_RXMARGINRESPAYLOAD_M_3 (q2q3_xpipe_rxmarginrespayload_m_3),
      .XPIPE_RXMARGINRESREQ_M       (q2q3_xpipe_rxmarginresreq_m),
      .XPIPE_RXMARGINRESREQ_M_1     (q2q3_xpipe_rxmarginresreq_m_1),
      .XPIPE_RXMARGINRESREQ_M_2     (q2q3_xpipe_rxmarginresreq_m_2),
      .XPIPE_RXMARGINRESREQ_M_3     (q2q3_xpipe_rxmarginresreq_m_3),

      .XPIPE_PIPE_CH0_PHYSTATUS      (q1q2_xpipe_pipe_ch0_phystatus_m),
      .XPIPE_PIPE_CH0_RXCHARISK      (q1q2_xpipe_pipe_ch0_rxcharisk_m),
      .XPIPE_PIPE_CH0_RXDATA         (q1q2_xpipe_pipe_ch0_rxdata_m),
      .XPIPE_PIPE_CH0_RXDATAVALID    (q1q2_xpipe_pipe_ch0_rxdatavalid_m),
      .XPIPE_PIPE_CH0_RXELECIDLE     (q1q2_xpipe_pipe_ch0_rxelecidle_m),
      .XPIPE_PIPE_CH0_RXSTARTBLOCK   (q1q2_xpipe_pipe_ch0_rxstartblock_m),
      .XPIPE_PIPE_CH0_RXSTATUS       (q1q2_xpipe_pipe_ch0_rxstatus_m),
      .XPIPE_PIPE_CH0_RXSYNCHEADER   (q1q2_xpipe_pipe_ch0_rxsyncheader_m),
      .XPIPE_PIPE_CH0_RXVALID        (q1q2_xpipe_pipe_ch0_rxvalid_m),
      .XPIPE_PIPE_CH0_POWERDOWN      (q1q2_xpipe_pipe_ch0_powerdown_m),
      .XPIPE_PIPE_CH0_RXPOLARITY     (q1q2_xpipe_pipe_ch0_rxpolarity_m),
      .XPIPE_PIPE_CH0_RXTERMINATION  (q1q2_xpipe_pipe_ch0_rxtermination_m),
      .XPIPE_PIPE_CH0_TXCHARISK      (q1q2_xpipe_pipe_ch0_txcharisk_m),
      .XPIPE_PIPE_CH0_TXCOMPLIANCE   (q1q2_xpipe_pipe_ch0_txcompliance_m),
      .XPIPE_PIPE_CH0_TXDATA         (q1q2_xpipe_pipe_ch0_txdata_m),
      .XPIPE_PIPE_CH0_TXDATAVALID    (q1q2_xpipe_pipe_ch0_txdatavalid_m),
      .XPIPE_PIPE_CH0_TXDEEMPH       (q1q2_xpipe_pipe_ch0_txdeemph_m),
      .XPIPE_PIPE_CH0_TXDETECTRXLOOPBACK(q1q2_xpipe_pipe_ch0_txdetectrxloopback_m),
      .XPIPE_PIPE_CH0_TXELECIDLE     (q1q2_xpipe_pipe_ch0_txelecidle_m),
      .XPIPE_PIPE_CH0_TXMAINCURSOR   (q1q2_xpipe_pipe_ch0_txmaincursor_m),
      .XPIPE_PIPE_CH0_TXMARGIN       (q1q2_xpipe_pipe_ch0_txmargin_m),
      .XPIPE_PIPE_CH0_TXPOSTCURSOR   (q1q2_xpipe_pipe_ch0_txpostcursor_m),
      .XPIPE_PIPE_CH0_TXPRECURSOR    (q1q2_xpipe_pipe_ch0_txprecursor_m),
      .XPIPE_PIPE_CH0_TXSTARTBLOCK   (q1q2_xpipe_pipe_ch0_txstartblock_m),
      .XPIPE_PIPE_CH0_TXSWING        (q1q2_xpipe_pipe_ch0_txswing_m),
      .XPIPE_PIPE_CH0_TXSYNCHEADER   (q1q2_xpipe_pipe_ch0_txsyncheader_m),

      .XPIPE_PIPE_CH0_POWERDOWN_M    (q2q3_xpipe_pipe_ch0_powerdown_m),
      .XPIPE_PIPE_CH0_RXPOLARITY_M   (q2q3_xpipe_pipe_ch0_rxpolarity_m),
      .XPIPE_PIPE_CH0_RXTERMINATION_M(q2q3_xpipe_pipe_ch0_rxtermination_m),
      .XPIPE_PIPE_CH0_TXCHARISK_M    (q2q3_xpipe_pipe_ch0_txcharisk_m),
      .XPIPE_PIPE_CH0_TXCOMPLIANCE_M (q2q3_xpipe_pipe_ch0_txcompliance_m),
      .XPIPE_PIPE_CH0_TXDATAVALID_M  (q2q3_xpipe_pipe_ch0_txdatavalid_m),
      .XPIPE_PIPE_CH0_TXDATA_M       (q2q3_xpipe_pipe_ch0_txdata_m),
      .XPIPE_PIPE_CH0_TXDEEMPH_M     (q2q3_xpipe_pipe_ch0_txdeemph_m),
      .XPIPE_PIPE_CH0_TXELECIDLE_M   (q2q3_xpipe_pipe_ch0_txelecidle_m),
      .XPIPE_PIPE_CH0_TXMAINCURSOR_M (q2q3_xpipe_pipe_ch0_txmaincursor_m),
      .XPIPE_PIPE_CH0_TXMARGIN_M     (q2q3_xpipe_pipe_ch0_txmargin_m),
      .XPIPE_PIPE_CH0_TXPOSTCURSOR_M (q2q3_xpipe_pipe_ch0_txpostcursor_m),
      .XPIPE_PIPE_CH0_TXPRECURSOR_M  (q2q3_xpipe_pipe_ch0_txprecursor_m),
      .XPIPE_PIPE_CH0_TXSTARTBLOCK_M (q2q3_xpipe_pipe_ch0_txstartblock_m),
      .XPIPE_PIPE_CH0_TXSWING_M      (q2q3_xpipe_pipe_ch0_txswing_m),
      .XPIPE_PIPE_CH0_TXSYNCHEADER_M (q2q3_xpipe_pipe_ch0_txsyncheader_m),
      .XPIPE_PIPE_CH0_PHYSTATUS_M    (q2q3_xpipe_pipe_ch0_phystatus_m),
      .XPIPE_PIPE_CH0_RXCHARISK_M    (q2q3_xpipe_pipe_ch0_rxcharisk_m),
      .XPIPE_PIPE_CH0_RXDATAVALID_M  (q2q3_xpipe_pipe_ch0_rxdatavalid_m),
      .XPIPE_PIPE_CH0_RXDATA_M       (q2q3_xpipe_pipe_ch0_rxdata_m),
      .XPIPE_PIPE_CH0_RXELECIDLE_M   (q2q3_xpipe_pipe_ch0_rxelecidle_m),
      .XPIPE_PIPE_CH0_RXSTARTBLOCK_M (q2q3_xpipe_pipe_ch0_rxstartblock_m),
      .XPIPE_PIPE_CH0_RXSTATUS_M     (q2q3_xpipe_pipe_ch0_rxstatus_m),
      .XPIPE_PIPE_CH0_RXSYNCHEADER_M (q2q3_xpipe_pipe_ch0_rxsyncheader_m),
      .XPIPE_PIPE_CH0_RXVALID_M      (q2q3_xpipe_pipe_ch0_rxvalid_m),
      .XPIPE_PIPE_CH0_TXDETECTRXLOOPBACK_M(q2q3_xpipe_pipe_ch0_txdetectrxloopback_m),

      .XPIPE_PIPE_CH1_PHYSTATUS      (q1q2_xpipe_pipe_ch1_phystatus_m),
      .XPIPE_PIPE_CH1_RXCHARISK      (q1q2_xpipe_pipe_ch1_rxcharisk_m),
      .XPIPE_PIPE_CH1_RXDATA         (q1q2_xpipe_pipe_ch1_rxdata_m), //ifcpmxpipechannel1xpiperxdata
      .XPIPE_PIPE_CH1_RXDATAVALID    (q1q2_xpipe_pipe_ch1_rxdatavalid_m),
      .XPIPE_PIPE_CH1_RXELECIDLE     (q1q2_xpipe_pipe_ch1_rxelecidle_m),
      .XPIPE_PIPE_CH1_RXSTARTBLOCK   (q1q2_xpipe_pipe_ch1_rxstartblock_m),
      .XPIPE_PIPE_CH1_RXSTATUS       (q1q2_xpipe_pipe_ch1_rxstatus_m),
      .XPIPE_PIPE_CH1_RXSYNCHEADER   (q1q2_xpipe_pipe_ch1_rxsyncheader_m),
      .XPIPE_PIPE_CH1_RXVALID        (q1q2_xpipe_pipe_ch1_rxvalid_m),
      .XPIPE_PIPE_CH1_POWERDOWN      (q1q2_xpipe_pipe_ch1_powerdown_m),
      .XPIPE_PIPE_CH1_RXPOLARITY     (q1q2_xpipe_pipe_ch1_rxpolarity_m),
      .XPIPE_PIPE_CH1_RXTERMINATION  (q1q2_xpipe_pipe_ch1_rxtermination_m),
      .XPIPE_PIPE_CH1_TXCHARISK      (q1q2_xpipe_pipe_ch1_txcharisk_m),
      .XPIPE_PIPE_CH1_TXCOMPLIANCE   (q1q2_xpipe_pipe_ch1_txcompliance_m),
      .XPIPE_PIPE_CH1_TXDATA         (q1q2_xpipe_pipe_ch1_txdata_m),
      .XPIPE_PIPE_CH1_TXDATAVALID    (q1q2_xpipe_pipe_ch1_txdatavalid_m),
      .XPIPE_PIPE_CH1_TXDEEMPH       (q1q2_xpipe_pipe_ch1_txdeemph_m),
      .XPIPE_PIPE_CH1_TXDETECTRXLOOPBACK(q1q2_xpipe_pipe_ch1_txdetectrxloopback_m),
      .XPIPE_PIPE_CH1_TXELECIDLE     (q1q2_xpipe_pipe_ch1_txelecidle_m),
      .XPIPE_PIPE_CH1_TXMAINCURSOR   (q1q2_xpipe_pipe_ch1_txmaincursor_m),
      .XPIPE_PIPE_CH1_TXMARGIN       (q1q2_xpipe_pipe_ch1_txmargin_m),
      .XPIPE_PIPE_CH1_TXPOSTCURSOR   (q1q2_xpipe_pipe_ch1_txpostcursor_m),
      .XPIPE_PIPE_CH1_TXPRECURSOR    (q1q2_xpipe_pipe_ch1_txprecursor_m),
      .XPIPE_PIPE_CH1_TXSTARTBLOCK   (q1q2_xpipe_pipe_ch1_txstartblock_m),
      .XPIPE_PIPE_CH1_TXSWING        (q1q2_xpipe_pipe_ch1_txswing_m),
      .XPIPE_PIPE_CH1_TXSYNCHEADER   (q1q2_xpipe_pipe_ch1_txsyncheader_m),

      .XPIPE_PIPE_CH1_POWERDOWN_M    (q2q3_xpipe_pipe_ch1_powerdown_m),
      .XPIPE_PIPE_CH1_RXPOLARITY_M   (q2q3_xpipe_pipe_ch1_rxpolarity_m),
      .XPIPE_PIPE_CH1_RXTERMINATION_M(q2q3_xpipe_pipe_ch1_rxtermination_m),
      .XPIPE_PIPE_CH1_TXCHARISK_M    (q2q3_xpipe_pipe_ch1_txcharisk_m),
      .XPIPE_PIPE_CH1_TXCOMPLIANCE_M (q2q3_xpipe_pipe_ch1_txcompliance_m),
      .XPIPE_PIPE_CH1_TXDATAVALID_M  (q2q3_xpipe_pipe_ch1_txdatavalid_m),
      .XPIPE_PIPE_CH1_TXDATA_M       (q2q3_xpipe_pipe_ch1_txdata_m),
      .XPIPE_PIPE_CH1_TXDEEMPH_M     (q2q3_xpipe_pipe_ch1_txdeemph_m),
      .XPIPE_PIPE_CH1_TXELECIDLE_M   (q2q3_xpipe_pipe_ch1_txelecidle_m),
      .XPIPE_PIPE_CH1_TXMAINCURSOR_M (q2q3_xpipe_pipe_ch1_txmaincursor_m),
      .XPIPE_PIPE_CH1_TXMARGIN_M     (q2q3_xpipe_pipe_ch1_txmargin_m),
      .XPIPE_PIPE_CH1_TXPOSTCURSOR_M (q2q3_xpipe_pipe_ch1_txpostcursor_m),
      .XPIPE_PIPE_CH1_TXPRECURSOR_M  (q2q3_xpipe_pipe_ch1_txprecursor_m),
      .XPIPE_PIPE_CH1_TXSTARTBLOCK_M (q2q3_xpipe_pipe_ch1_txstartblock_m),
      .XPIPE_PIPE_CH1_TXSWING_M      (q2q3_xpipe_pipe_ch1_txswing_m),
      .XPIPE_PIPE_CH1_TXSYNCHEADER_M (q2q3_xpipe_pipe_ch1_txsyncheader_m),
      .XPIPE_PIPE_CH1_PHYSTATUS_M    (q2q3_xpipe_pipe_ch1_phystatus_m),
      .XPIPE_PIPE_CH1_RXCHARISK_M    (q2q3_xpipe_pipe_ch1_rxcharisk_m),
      .XPIPE_PIPE_CH1_RXDATAVALID_M  (q2q3_xpipe_pipe_ch1_rxdatavalid_m),
      .XPIPE_PIPE_CH1_RXDATA_M       (q2q3_xpipe_pipe_ch1_rxdata_m),
      .XPIPE_PIPE_CH1_RXELECIDLE_M   (q2q3_xpipe_pipe_ch1_rxelecidle_m),
      .XPIPE_PIPE_CH1_RXSTARTBLOCK_M (q2q3_xpipe_pipe_ch1_rxstartblock_m),
      .XPIPE_PIPE_CH1_RXSTATUS_M     (q2q3_xpipe_pipe_ch1_rxstatus_m),
      .XPIPE_PIPE_CH1_RXSYNCHEADER_M (q2q3_xpipe_pipe_ch1_rxsyncheader_m),
      .XPIPE_PIPE_CH1_RXVALID_M      (q2q3_xpipe_pipe_ch1_rxvalid_m),
      .XPIPE_PIPE_CH1_TXDETECTRXLOOPBACK_M(q2q3_xpipe_pipe_ch1_txdetectrxloopback_m),

      .XPIPE_PIPE_CH2_PHYSTATUS      (q1q2_xpipe_pipe_ch2_phystatus_m),
      .XPIPE_PIPE_CH2_RXCHARISK      (q1q2_xpipe_pipe_ch2_rxcharisk_m),
      .XPIPE_PIPE_CH2_RXDATA         (q1q2_xpipe_pipe_ch2_rxdata_m), //ifcpmxpipechannel2xpiperxdata
      .XPIPE_PIPE_CH2_RXDATAVALID    (q1q2_xpipe_pipe_ch2_rxdatavalid_m),
      .XPIPE_PIPE_CH2_RXELECIDLE     (q1q2_xpipe_pipe_ch2_rxelecidle_m),
      .XPIPE_PIPE_CH2_RXSTARTBLOCK   (q1q2_xpipe_pipe_ch2_rxstartblock_m),
      .XPIPE_PIPE_CH2_RXSTATUS       (q1q2_xpipe_pipe_ch2_rxstatus_m),
      .XPIPE_PIPE_CH2_RXSYNCHEADER   (q1q2_xpipe_pipe_ch2_rxsyncheader_m),
      .XPIPE_PIPE_CH2_RXVALID        (q1q2_xpipe_pipe_ch2_rxvalid_m),
      .XPIPE_PIPE_CH2_POWERDOWN      (q1q2_xpipe_pipe_ch2_powerdown_m),
      .XPIPE_PIPE_CH2_RXPOLARITY     (q1q2_xpipe_pipe_ch2_rxpolarity_m),
      .XPIPE_PIPE_CH2_RXTERMINATION  (q1q2_xpipe_pipe_ch2_rxtermination_m),
      .XPIPE_PIPE_CH2_TXCHARISK      (q1q2_xpipe_pipe_ch2_txcharisk_m),
      .XPIPE_PIPE_CH2_TXCOMPLIANCE   (q1q2_xpipe_pipe_ch2_txcompliance_m),
      .XPIPE_PIPE_CH2_TXDATA         (q1q2_xpipe_pipe_ch2_txdata_m),
      .XPIPE_PIPE_CH2_TXDATAVALID    (q1q2_xpipe_pipe_ch2_txdatavalid_m),
      .XPIPE_PIPE_CH2_TXDEEMPH       (q1q2_xpipe_pipe_ch2_txdeemph_m),
      .XPIPE_PIPE_CH2_TXDETECTRXLOOPBACK(q1q2_xpipe_pipe_ch2_txdetectrxloopback_m),
      .XPIPE_PIPE_CH2_TXELECIDLE     (q1q2_xpipe_pipe_ch2_txelecidle_m),
      .XPIPE_PIPE_CH2_TXMAINCURSOR   (q1q2_xpipe_pipe_ch2_txmaincursor_m),
      .XPIPE_PIPE_CH2_TXMARGIN       (q1q2_xpipe_pipe_ch2_txmargin_m),
      .XPIPE_PIPE_CH2_TXPOSTCURSOR   (q1q2_xpipe_pipe_ch2_txpostcursor_m),
      .XPIPE_PIPE_CH2_TXPRECURSOR    (q1q2_xpipe_pipe_ch2_txprecursor_m),
      .XPIPE_PIPE_CH2_TXSTARTBLOCK   (q1q2_xpipe_pipe_ch2_txstartblock_m),
      .XPIPE_PIPE_CH2_TXSWING        (q1q2_xpipe_pipe_ch2_txswing_m),
      .XPIPE_PIPE_CH2_TXSYNCHEADER   (q1q2_xpipe_pipe_ch2_txsyncheader_m),

      .XPIPE_PIPE_CH2_POWERDOWN_M    (q2q3_xpipe_pipe_ch2_powerdown_m),
      .XPIPE_PIPE_CH2_RXPOLARITY_M   (q2q3_xpipe_pipe_ch2_rxpolarity_m),
      .XPIPE_PIPE_CH2_RXTERMINATION_M(q2q3_xpipe_pipe_ch2_rxtermination_m),
      .XPIPE_PIPE_CH2_TXCHARISK_M    (q2q3_xpipe_pipe_ch2_txcharisk_m),
      .XPIPE_PIPE_CH2_TXCOMPLIANCE_M (q2q3_xpipe_pipe_ch2_txcompliance_m),
      .XPIPE_PIPE_CH2_TXDATAVALID_M  (q2q3_xpipe_pipe_ch2_txdatavalid_m),
      .XPIPE_PIPE_CH2_TXDATA_M       (q2q3_xpipe_pipe_ch2_txdata_m),
      .XPIPE_PIPE_CH2_TXDEEMPH_M     (q2q3_xpipe_pipe_ch2_txdeemph_m),
      .XPIPE_PIPE_CH2_TXELECIDLE_M   (q2q3_xpipe_pipe_ch2_txelecidle_m),
      .XPIPE_PIPE_CH2_TXMAINCURSOR_M (q2q3_xpipe_pipe_ch2_txmaincursor_m),
      .XPIPE_PIPE_CH2_TXMARGIN_M     (q2q3_xpipe_pipe_ch2_txmargin_m),
      .XPIPE_PIPE_CH2_TXPOSTCURSOR_M (q2q3_xpipe_pipe_ch2_txpostcursor_m),
      .XPIPE_PIPE_CH2_TXPRECURSOR_M  (q2q3_xpipe_pipe_ch2_txprecursor_m),
      .XPIPE_PIPE_CH2_TXSTARTBLOCK_M (q2q3_xpipe_pipe_ch2_txstartblock_m),
      .XPIPE_PIPE_CH2_TXSWING_M      (q2q3_xpipe_pipe_ch2_txswing_m),
      .XPIPE_PIPE_CH2_TXSYNCHEADER_M (q2q3_xpipe_pipe_ch2_txsyncheader_m),
      .XPIPE_PIPE_CH2_PHYSTATUS_M    (q2q3_xpipe_pipe_ch2_phystatus_m),
      .XPIPE_PIPE_CH2_RXCHARISK_M    (q2q3_xpipe_pipe_ch2_rxcharisk_m),
      .XPIPE_PIPE_CH2_RXDATAVALID_M  (q2q3_xpipe_pipe_ch2_rxdatavalid_m),
      .XPIPE_PIPE_CH2_RXDATA_M       (q2q3_xpipe_pipe_ch2_rxdata_m),
      .XPIPE_PIPE_CH2_RXELECIDLE_M   (q2q3_xpipe_pipe_ch2_rxelecidle_m),
      .XPIPE_PIPE_CH2_RXSTARTBLOCK_M (q2q3_xpipe_pipe_ch2_rxstartblock_m),
      .XPIPE_PIPE_CH2_RXSTATUS_M     (q2q3_xpipe_pipe_ch2_rxstatus_m),
      .XPIPE_PIPE_CH2_RXSYNCHEADER_M (q2q3_xpipe_pipe_ch2_rxsyncheader_m),
      .XPIPE_PIPE_CH2_RXVALID_M      (q2q3_xpipe_pipe_ch2_rxvalid_m),
      .XPIPE_PIPE_CH2_TXDETECTRXLOOPBACK_M(q2q3_xpipe_pipe_ch2_txdetectrxloopback_m),

      .XPIPE_PIPE_CH3_PHYSTATUS      (q1q2_xpipe_pipe_ch3_phystatus_m),
      .XPIPE_PIPE_CH3_RXCHARISK      (q1q2_xpipe_pipe_ch3_rxcharisk_m),
      .XPIPE_PIPE_CH3_RXDATA         (q1q2_xpipe_pipe_ch3_rxdata_m), //ifcpmxpipechannel3xpiperxdata
      .XPIPE_PIPE_CH3_RXDATAVALID    (q1q2_xpipe_pipe_ch3_rxdatavalid_m),
      .XPIPE_PIPE_CH3_RXELECIDLE     (q1q2_xpipe_pipe_ch3_rxelecidle_m),
      .XPIPE_PIPE_CH3_RXSTARTBLOCK   (q1q2_xpipe_pipe_ch3_rxstartblock_m),
      .XPIPE_PIPE_CH3_RXSTATUS       (q1q2_xpipe_pipe_ch3_rxstatus_m),
      .XPIPE_PIPE_CH3_RXSYNCHEADER   (q1q2_xpipe_pipe_ch3_rxsyncheader_m),
      .XPIPE_PIPE_CH3_RXVALID        (q1q2_xpipe_pipe_ch3_rxvalid_m),
      .XPIPE_PIPE_CH3_POWERDOWN      (q1q2_xpipe_pipe_ch3_powerdown_m),
      .XPIPE_PIPE_CH3_RXPOLARITY     (q1q2_xpipe_pipe_ch3_rxpolarity_m),
      .XPIPE_PIPE_CH3_RXTERMINATION  (q1q2_xpipe_pipe_ch3_rxtermination_m),
      .XPIPE_PIPE_CH3_TXCHARISK      (q1q2_xpipe_pipe_ch3_txcharisk_m),
      .XPIPE_PIPE_CH3_TXCOMPLIANCE   (q1q2_xpipe_pipe_ch3_txcompliance_m),
      .XPIPE_PIPE_CH3_TXDATA         (q1q2_xpipe_pipe_ch3_txdata_m),
      .XPIPE_PIPE_CH3_TXDATAVALID    (q1q2_xpipe_pipe_ch3_txdatavalid_m),
      .XPIPE_PIPE_CH3_TXDEEMPH       (q1q2_xpipe_pipe_ch3_txdeemph_m),
      .XPIPE_PIPE_CH3_TXDETECTRXLOOPBACK(q1q2_xpipe_pipe_ch3_txdetectrxloopback_m),
      .XPIPE_PIPE_CH3_TXELECIDLE     (q1q2_xpipe_pipe_ch3_txelecidle_m),
      .XPIPE_PIPE_CH3_TXMAINCURSOR   (q1q2_xpipe_pipe_ch3_txmaincursor_m),
      .XPIPE_PIPE_CH3_TXMARGIN       (q1q2_xpipe_pipe_ch3_txmargin_m),
      .XPIPE_PIPE_CH3_TXPOSTCURSOR   (q1q2_xpipe_pipe_ch3_txpostcursor_m),
      .XPIPE_PIPE_CH3_TXPRECURSOR    (q1q2_xpipe_pipe_ch3_txprecursor_m),
      .XPIPE_PIPE_CH3_TXSTARTBLOCK   (q1q2_xpipe_pipe_ch3_txstartblock_m),
      .XPIPE_PIPE_CH3_TXSWING        (q1q2_xpipe_pipe_ch3_txswing_m),
      .XPIPE_PIPE_CH3_TXSYNCHEADER   (q1q2_xpipe_pipe_ch3_txsyncheader_m),

      .XPIPE_PIPE_CH3_POWERDOWN_M    (q2q3_xpipe_pipe_ch3_powerdown_m),
      .XPIPE_PIPE_CH3_RXPOLARITY_M   (q2q3_xpipe_pipe_ch3_rxpolarity_m),
      .XPIPE_PIPE_CH3_RXTERMINATION_M(q2q3_xpipe_pipe_ch3_rxtermination_m),
      .XPIPE_PIPE_CH3_TXCHARISK_M    (q2q3_xpipe_pipe_ch3_txcharisk_m),
      .XPIPE_PIPE_CH3_TXCOMPLIANCE_M (q2q3_xpipe_pipe_ch3_txcompliance_m),
      .XPIPE_PIPE_CH3_TXDATAVALID_M  (q2q3_xpipe_pipe_ch3_txdatavalid_m),
      .XPIPE_PIPE_CH3_TXDATA_M       (q2q3_xpipe_pipe_ch3_txdata_m),
      .XPIPE_PIPE_CH3_TXDEEMPH_M     (q2q3_xpipe_pipe_ch3_txdeemph_m),
      .XPIPE_PIPE_CH3_TXELECIDLE_M   (q2q3_xpipe_pipe_ch3_txelecidle_m),
      .XPIPE_PIPE_CH3_TXMAINCURSOR_M (q2q3_xpipe_pipe_ch3_txmaincursor_m),
      .XPIPE_PIPE_CH3_TXMARGIN_M     (q2q3_xpipe_pipe_ch3_txmargin_m),
      .XPIPE_PIPE_CH3_TXPOSTCURSOR_M (q2q3_xpipe_pipe_ch3_txpostcursor_m),
      .XPIPE_PIPE_CH3_TXPRECURSOR_M  (q2q3_xpipe_pipe_ch3_txprecursor_m),
      .XPIPE_PIPE_CH3_TXSTARTBLOCK_M (q2q3_xpipe_pipe_ch3_txstartblock_m),
      .XPIPE_PIPE_CH3_TXSWING_M      (q2q3_xpipe_pipe_ch3_txswing_m),
      .XPIPE_PIPE_CH3_TXSYNCHEADER_M (q2q3_xpipe_pipe_ch3_txsyncheader_m),
      .XPIPE_PIPE_CH3_PHYSTATUS_M    (q2q3_xpipe_pipe_ch3_phystatus_m),
      .XPIPE_PIPE_CH3_RXCHARISK_M    (q2q3_xpipe_pipe_ch3_rxcharisk_m),
      .XPIPE_PIPE_CH3_RXDATAVALID_M  (q2q3_xpipe_pipe_ch3_rxdatavalid_m),
      .XPIPE_PIPE_CH3_RXDATA_M       (q2q3_xpipe_pipe_ch3_rxdata_m),
      .XPIPE_PIPE_CH3_RXELECIDLE_M   (q2q3_xpipe_pipe_ch3_rxelecidle_m),
      .XPIPE_PIPE_CH3_RXSTARTBLOCK_M (q2q3_xpipe_pipe_ch3_rxstartblock_m),
      .XPIPE_PIPE_CH3_RXSTATUS_M     (q2q3_xpipe_pipe_ch3_rxstatus_m),
      .XPIPE_PIPE_CH3_RXSYNCHEADER_M (q2q3_xpipe_pipe_ch3_rxsyncheader_m),
      .XPIPE_PIPE_CH3_RXVALID_M      (q2q3_xpipe_pipe_ch3_rxvalid_m),
      .XPIPE_PIPE_CH3_TXDETECTRXLOOPBACK_M(q2q3_xpipe_pipe_ch3_txdetectrxloopback_m),

      .XPIPE_PIPE_CH4_PHYSTATUS      (q1q2_xpipe_pipe_ch4_phystatus_m),
      .XPIPE_PIPE_CH4_RXCHARISK      (q1q2_xpipe_pipe_ch4_rxcharisk_m),
      .XPIPE_PIPE_CH4_RXDATA         (q1q2_xpipe_pipe_ch4_rxdata_m), //ifcpmxpipechannel4xpiperxdata
      .XPIPE_PIPE_CH4_RXDATAVALID    (q1q2_xpipe_pipe_ch4_rxdatavalid_m),
      .XPIPE_PIPE_CH4_RXELECIDLE     (q1q2_xpipe_pipe_ch4_rxelecidle_m),
      .XPIPE_PIPE_CH4_RXSTARTBLOCK   (q1q2_xpipe_pipe_ch4_rxstartblock_m),
      .XPIPE_PIPE_CH4_RXSTATUS       (q1q2_xpipe_pipe_ch4_rxstatus_m),
      .XPIPE_PIPE_CH4_RXSYNCHEADER   (q1q2_xpipe_pipe_ch4_rxsyncheader_m),
      .XPIPE_PIPE_CH4_RXVALID        (q1q2_xpipe_pipe_ch4_rxvalid_m),
      .XPIPE_PIPE_CH4_POWERDOWN      (q1q2_xpipe_pipe_ch4_powerdown_m),
      .XPIPE_PIPE_CH4_RXPOLARITY     (q1q2_xpipe_pipe_ch4_rxpolarity_m),
      .XPIPE_PIPE_CH4_RXTERMINATION  (q1q2_xpipe_pipe_ch4_rxtermination_m),
      .XPIPE_PIPE_CH4_TXCHARISK      (q1q2_xpipe_pipe_ch4_txcharisk_m),
      .XPIPE_PIPE_CH4_TXCOMPLIANCE   (q1q2_xpipe_pipe_ch4_txcompliance_m),
      .XPIPE_PIPE_CH4_TXDATA         (q1q2_xpipe_pipe_ch4_txdata_m),
      .XPIPE_PIPE_CH4_TXDATAVALID    (q1q2_xpipe_pipe_ch4_txdatavalid_m),
      .XPIPE_PIPE_CH4_TXDEEMPH       (q1q2_xpipe_pipe_ch4_txdeemph_m),
      .XPIPE_PIPE_CH4_TXDETECTRXLOOPBACK(q1q2_xpipe_pipe_ch4_txdetectrxloopback_m),
      .XPIPE_PIPE_CH4_TXELECIDLE     (q1q2_xpipe_pipe_ch4_txelecidle_m),
      .XPIPE_PIPE_CH4_TXMAINCURSOR   (q1q2_xpipe_pipe_ch4_txmaincursor_m),
      .XPIPE_PIPE_CH4_TXMARGIN       (q1q2_xpipe_pipe_ch4_txmargin_m),
      .XPIPE_PIPE_CH4_TXPOSTCURSOR   (q1q2_xpipe_pipe_ch4_txpostcursor_m),
      .XPIPE_PIPE_CH4_TXPRECURSOR    (q1q2_xpipe_pipe_ch4_txprecursor_m),
      .XPIPE_PIPE_CH4_TXSTARTBLOCK   (q1q2_xpipe_pipe_ch4_txstartblock_m),
      .XPIPE_PIPE_CH4_TXSWING        (q1q2_xpipe_pipe_ch4_txswing_m),
      .XPIPE_PIPE_CH4_TXSYNCHEADER   (q1q2_xpipe_pipe_ch4_txsyncheader_m),

      .XPIPE_PIPE_CH4_POWERDOWN_M    (q2q3_xpipe_pipe_ch4_powerdown_m),
      .XPIPE_PIPE_CH4_RXPOLARITY_M   (q2q3_xpipe_pipe_ch4_rxpolarity_m),
      .XPIPE_PIPE_CH4_RXTERMINATION_M(q2q3_xpipe_pipe_ch4_rxtermination_m),
      .XPIPE_PIPE_CH4_TXCHARISK_M    (q2q3_xpipe_pipe_ch4_txcharisk_m),
      .XPIPE_PIPE_CH4_TXCOMPLIANCE_M (q2q3_xpipe_pipe_ch4_txcompliance_m),
      .XPIPE_PIPE_CH4_TXDATAVALID_M  (q2q3_xpipe_pipe_ch4_txdatavalid_m),
      .XPIPE_PIPE_CH4_TXDATA_M       (q2q3_xpipe_pipe_ch4_txdata_m),
      .XPIPE_PIPE_CH4_TXDEEMPH_M     (q2q3_xpipe_pipe_ch4_txdeemph_m),
      .XPIPE_PIPE_CH4_TXELECIDLE_M   (q2q3_xpipe_pipe_ch4_txelecidle_m),
      .XPIPE_PIPE_CH4_TXMAINCURSOR_M (q2q3_xpipe_pipe_ch4_txmaincursor_m),
      .XPIPE_PIPE_CH4_TXMARGIN_M     (q2q3_xpipe_pipe_ch4_txmargin_m),
      .XPIPE_PIPE_CH4_TXPOSTCURSOR_M (q2q3_xpipe_pipe_ch4_txpostcursor_m),
      .XPIPE_PIPE_CH4_TXPRECURSOR_M  (q2q3_xpipe_pipe_ch4_txprecursor_m),
      .XPIPE_PIPE_CH4_TXSTARTBLOCK_M (q2q3_xpipe_pipe_ch4_txstartblock_m),
      .XPIPE_PIPE_CH4_TXSWING_M      (q2q3_xpipe_pipe_ch4_txswing_m),
      .XPIPE_PIPE_CH4_TXSYNCHEADER_M (q2q3_xpipe_pipe_ch4_txsyncheader_m),
      .XPIPE_PIPE_CH4_PHYSTATUS_M    (q2q3_xpipe_pipe_ch4_phystatus_m),
      .XPIPE_PIPE_CH4_RXCHARISK_M    (q2q3_xpipe_pipe_ch4_rxcharisk_m),
      .XPIPE_PIPE_CH4_RXDATAVALID_M  (q2q3_xpipe_pipe_ch4_rxdatavalid_m),
      .XPIPE_PIPE_CH4_RXDATA_M       (q2q3_xpipe_pipe_ch4_rxdata_m),
      .XPIPE_PIPE_CH4_RXELECIDLE_M   (q2q3_xpipe_pipe_ch4_rxelecidle_m),
      .XPIPE_PIPE_CH4_RXSTARTBLOCK_M (q2q3_xpipe_pipe_ch4_rxstartblock_m),
      .XPIPE_PIPE_CH4_RXSTATUS_M     (q2q3_xpipe_pipe_ch4_rxstatus_m),
      .XPIPE_PIPE_CH4_RXSYNCHEADER_M (q2q3_xpipe_pipe_ch4_rxsyncheader_m),
      .XPIPE_PIPE_CH4_RXVALID_M      (q2q3_xpipe_pipe_ch4_rxvalid_m),
      .XPIPE_PIPE_CH4_TXDETECTRXLOOPBACK_M(q2q3_xpipe_pipe_ch4_txdetectrxloopback_m),

      .XPIPE_PIPE_CH5_PHYSTATUS      (q1q2_xpipe_pipe_ch5_phystatus_m),
      .XPIPE_PIPE_CH5_RXCHARISK      (q1q2_xpipe_pipe_ch5_rxcharisk_m),
      .XPIPE_PIPE_CH5_RXDATA         (q1q2_xpipe_pipe_ch5_rxdata_m), //ifcpmxpipechannel5xpiperxdata
      .XPIPE_PIPE_CH5_RXDATAVALID    (q1q2_xpipe_pipe_ch5_rxdatavalid_m),
      .XPIPE_PIPE_CH5_RXELECIDLE     (q1q2_xpipe_pipe_ch5_rxelecidle_m),
      .XPIPE_PIPE_CH5_RXSTARTBLOCK   (q1q2_xpipe_pipe_ch5_rxstartblock_m),
      .XPIPE_PIPE_CH5_RXSTATUS       (q1q2_xpipe_pipe_ch5_rxstatus_m),
      .XPIPE_PIPE_CH5_RXSYNCHEADER   (q1q2_xpipe_pipe_ch5_rxsyncheader_m),
      .XPIPE_PIPE_CH5_RXVALID        (q1q2_xpipe_pipe_ch5_rxvalid_m),
      .XPIPE_PIPE_CH5_POWERDOWN      (q1q2_xpipe_pipe_ch5_powerdown_m),
      .XPIPE_PIPE_CH5_RXPOLARITY     (q1q2_xpipe_pipe_ch5_rxpolarity_m),
      .XPIPE_PIPE_CH5_RXTERMINATION  (q1q2_xpipe_pipe_ch5_rxtermination_m),
      .XPIPE_PIPE_CH5_TXCHARISK      (q1q2_xpipe_pipe_ch5_txcharisk_m),
      .XPIPE_PIPE_CH5_TXCOMPLIANCE   (q1q2_xpipe_pipe_ch5_txcompliance_m),
      .XPIPE_PIPE_CH5_TXDATA         (q1q2_xpipe_pipe_ch5_txdata_m),
      .XPIPE_PIPE_CH5_TXDATAVALID    (q1q2_xpipe_pipe_ch5_txdatavalid_m),
      .XPIPE_PIPE_CH5_TXDEEMPH       (q1q2_xpipe_pipe_ch5_txdeemph_m),
      .XPIPE_PIPE_CH5_TXDETECTRXLOOPBACK(q1q2_xpipe_pipe_ch5_txdetectrxloopback_m),
      .XPIPE_PIPE_CH5_TXELECIDLE     (q1q2_xpipe_pipe_ch5_txelecidle_m),
      .XPIPE_PIPE_CH5_TXMAINCURSOR   (q1q2_xpipe_pipe_ch5_txmaincursor_m),
      .XPIPE_PIPE_CH5_TXMARGIN       (q1q2_xpipe_pipe_ch5_txmargin_m),
      .XPIPE_PIPE_CH5_TXPOSTCURSOR   (q1q2_xpipe_pipe_ch5_txpostcursor_m),
      .XPIPE_PIPE_CH5_TXPRECURSOR    (q1q2_xpipe_pipe_ch5_txprecursor_m),
      .XPIPE_PIPE_CH5_TXSTARTBLOCK   (q1q2_xpipe_pipe_ch5_txstartblock_m),
      .XPIPE_PIPE_CH5_TXSWING        (q1q2_xpipe_pipe_ch5_txswing_m),
      .XPIPE_PIPE_CH5_TXSYNCHEADER   (q1q2_xpipe_pipe_ch5_txsyncheader_m),

      .XPIPE_PIPE_CH5_POWERDOWN_M    (q2q3_xpipe_pipe_ch5_powerdown_m),
      .XPIPE_PIPE_CH5_RXPOLARITY_M   (q2q3_xpipe_pipe_ch5_rxpolarity_m),
      .XPIPE_PIPE_CH5_RXTERMINATION_M(q2q3_xpipe_pipe_ch5_rxtermination_m),
      .XPIPE_PIPE_CH5_TXCHARISK_M    (q2q3_xpipe_pipe_ch5_txcharisk_m),
      .XPIPE_PIPE_CH5_TXCOMPLIANCE_M (q2q3_xpipe_pipe_ch5_txcompliance_m),
      .XPIPE_PIPE_CH5_TXDATAVALID_M  (q2q3_xpipe_pipe_ch5_txdatavalid_m),
      .XPIPE_PIPE_CH5_TXDATA_M       (q2q3_xpipe_pipe_ch5_txdata_m),
      .XPIPE_PIPE_CH5_TXDEEMPH_M     (q2q3_xpipe_pipe_ch5_txdeemph_m),
      .XPIPE_PIPE_CH5_TXELECIDLE_M   (q2q3_xpipe_pipe_ch5_txelecidle_m),
      .XPIPE_PIPE_CH5_TXMAINCURSOR_M (q2q3_xpipe_pipe_ch5_txmaincursor_m),
      .XPIPE_PIPE_CH5_TXMARGIN_M     (q2q3_xpipe_pipe_ch5_txmargin_m),
      .XPIPE_PIPE_CH5_TXPOSTCURSOR_M (q2q3_xpipe_pipe_ch5_txpostcursor_m),
      .XPIPE_PIPE_CH5_TXPRECURSOR_M  (q2q3_xpipe_pipe_ch5_txprecursor_m),
      .XPIPE_PIPE_CH5_TXSTARTBLOCK_M (q2q3_xpipe_pipe_ch5_txstartblock_m),
      .XPIPE_PIPE_CH5_TXSWING_M      (q2q3_xpipe_pipe_ch5_txswing_m),
      .XPIPE_PIPE_CH5_TXSYNCHEADER_M (q2q3_xpipe_pipe_ch5_txsyncheader_m),
      .XPIPE_PIPE_CH5_PHYSTATUS_M    (q2q3_xpipe_pipe_ch5_phystatus_m),
      .XPIPE_PIPE_CH5_RXCHARISK_M    (q2q3_xpipe_pipe_ch5_rxcharisk_m),
      .XPIPE_PIPE_CH5_RXDATAVALID_M  (q2q3_xpipe_pipe_ch5_rxdatavalid_m),
      .XPIPE_PIPE_CH5_RXDATA_M       (q2q3_xpipe_pipe_ch5_rxdata_m),
      .XPIPE_PIPE_CH5_RXELECIDLE_M   (q2q3_xpipe_pipe_ch5_rxelecidle_m),
      .XPIPE_PIPE_CH5_RXSTARTBLOCK_M (q2q3_xpipe_pipe_ch5_rxstartblock_m),
      .XPIPE_PIPE_CH5_RXSTATUS_M     (q2q3_xpipe_pipe_ch5_rxstatus_m),
      .XPIPE_PIPE_CH5_RXSYNCHEADER_M (q2q3_xpipe_pipe_ch5_rxsyncheader_m),
      .XPIPE_PIPE_CH5_RXVALID_M      (q2q3_xpipe_pipe_ch5_rxvalid_m),
      .XPIPE_PIPE_CH5_TXDETECTRXLOOPBACK_M(q2q3_xpipe_pipe_ch5_txdetectrxloopback_m),

      .XPIPE_PIPE_CH6_PHYSTATUS      (q1q2_xpipe_pipe_ch6_phystatus_m),
      .XPIPE_PIPE_CH6_RXCHARISK      (q1q2_xpipe_pipe_ch6_rxcharisk_m),
      .XPIPE_PIPE_CH6_RXDATA         (q1q2_xpipe_pipe_ch6_rxdata_m), //ifcpmxpipechannel6xpiperxdata
      .XPIPE_PIPE_CH6_RXDATAVALID    (q1q2_xpipe_pipe_ch6_rxdatavalid_m),
      .XPIPE_PIPE_CH6_RXELECIDLE     (q1q2_xpipe_pipe_ch6_rxelecidle_m),
      .XPIPE_PIPE_CH6_RXSTARTBLOCK   (q1q2_xpipe_pipe_ch6_rxstartblock_m),
      .XPIPE_PIPE_CH6_RXSTATUS       (q1q2_xpipe_pipe_ch6_rxstatus_m),
      .XPIPE_PIPE_CH6_RXSYNCHEADER   (q1q2_xpipe_pipe_ch6_rxsyncheader_m),
      .XPIPE_PIPE_CH6_RXVALID        (q1q2_xpipe_pipe_ch6_rxvalid_m),
      .XPIPE_PIPE_CH6_POWERDOWN      (q1q2_xpipe_pipe_ch6_powerdown_m),
      .XPIPE_PIPE_CH6_RXPOLARITY     (q1q2_xpipe_pipe_ch6_rxpolarity_m),
      .XPIPE_PIPE_CH6_RXTERMINATION  (q1q2_xpipe_pipe_ch6_rxtermination_m),
      .XPIPE_PIPE_CH6_TXCHARISK      (q1q2_xpipe_pipe_ch6_txcharisk_m),
      .XPIPE_PIPE_CH6_TXCOMPLIANCE   (q1q2_xpipe_pipe_ch6_txcompliance_m),
      .XPIPE_PIPE_CH6_TXDATA         (q1q2_xpipe_pipe_ch6_txdata_m),
      .XPIPE_PIPE_CH6_TXDATAVALID    (q1q2_xpipe_pipe_ch6_txdatavalid_m),
      .XPIPE_PIPE_CH6_TXDEEMPH       (q1q2_xpipe_pipe_ch6_txdeemph_m),
      .XPIPE_PIPE_CH6_TXDETECTRXLOOPBACK(q1q2_xpipe_pipe_ch6_txdetectrxloopback_m),
      .XPIPE_PIPE_CH6_TXELECIDLE     (q1q2_xpipe_pipe_ch6_txelecidle_m),
      .XPIPE_PIPE_CH6_TXMAINCURSOR   (q1q2_xpipe_pipe_ch6_txmaincursor_m),
      .XPIPE_PIPE_CH6_TXMARGIN       (q1q2_xpipe_pipe_ch6_txmargin_m),
      .XPIPE_PIPE_CH6_TXPOSTCURSOR   (q1q2_xpipe_pipe_ch6_txpostcursor_m),
      .XPIPE_PIPE_CH6_TXPRECURSOR    (q1q2_xpipe_pipe_ch6_txprecursor_m),
      .XPIPE_PIPE_CH6_TXSTARTBLOCK   (q1q2_xpipe_pipe_ch6_txstartblock_m),
      .XPIPE_PIPE_CH6_TXSWING        (q1q2_xpipe_pipe_ch6_txswing_m),
      .XPIPE_PIPE_CH6_TXSYNCHEADER   (q1q2_xpipe_pipe_ch6_txsyncheader_m),

      .XPIPE_PIPE_CH6_POWERDOWN_M    (q2q3_xpipe_pipe_ch6_powerdown_m),
      .XPIPE_PIPE_CH6_RXPOLARITY_M   (q2q3_xpipe_pipe_ch6_rxpolarity_m),
      .XPIPE_PIPE_CH6_RXTERMINATION_M(q2q3_xpipe_pipe_ch6_rxtermination_m),
      .XPIPE_PIPE_CH6_TXCHARISK_M    (q2q3_xpipe_pipe_ch6_txcharisk_m),
      .XPIPE_PIPE_CH6_TXCOMPLIANCE_M (q2q3_xpipe_pipe_ch6_txcompliance_m),
      .XPIPE_PIPE_CH6_TXDATAVALID_M  (q2q3_xpipe_pipe_ch6_txdatavalid_m),
      .XPIPE_PIPE_CH6_TXDATA_M       (q2q3_xpipe_pipe_ch6_txdata_m),
      .XPIPE_PIPE_CH6_TXDEEMPH_M     (q2q3_xpipe_pipe_ch6_txdeemph_m),
      .XPIPE_PIPE_CH6_TXELECIDLE_M   (q2q3_xpipe_pipe_ch6_txelecidle_m),
      .XPIPE_PIPE_CH6_TXMAINCURSOR_M (q2q3_xpipe_pipe_ch6_txmaincursor_m),
      .XPIPE_PIPE_CH6_TXMARGIN_M     (q2q3_xpipe_pipe_ch6_txmargin_m),
      .XPIPE_PIPE_CH6_TXPOSTCURSOR_M (q2q3_xpipe_pipe_ch6_txpostcursor_m),
      .XPIPE_PIPE_CH6_TXPRECURSOR_M  (q2q3_xpipe_pipe_ch6_txprecursor_m),
      .XPIPE_PIPE_CH6_TXSTARTBLOCK_M (q2q3_xpipe_pipe_ch6_txstartblock_m),
      .XPIPE_PIPE_CH6_TXSWING_M      (q2q3_xpipe_pipe_ch6_txswing_m),
      .XPIPE_PIPE_CH6_TXSYNCHEADER_M (q2q3_xpipe_pipe_ch6_txsyncheader_m),
      .XPIPE_PIPE_CH6_PHYSTATUS_M    (q2q3_xpipe_pipe_ch6_phystatus_m),
      .XPIPE_PIPE_CH6_RXCHARISK_M    (q2q3_xpipe_pipe_ch6_rxcharisk_m),
      .XPIPE_PIPE_CH6_RXDATAVALID_M  (q2q3_xpipe_pipe_ch6_rxdatavalid_m),
      .XPIPE_PIPE_CH6_RXDATA_M       (q2q3_xpipe_pipe_ch6_rxdata_m),
      .XPIPE_PIPE_CH6_RXELECIDLE_M   (q2q3_xpipe_pipe_ch6_rxelecidle_m),
      .XPIPE_PIPE_CH6_RXSTARTBLOCK_M (q2q3_xpipe_pipe_ch6_rxstartblock_m),
      .XPIPE_PIPE_CH6_RXSTATUS_M     (q2q3_xpipe_pipe_ch6_rxstatus_m),
      .XPIPE_PIPE_CH6_RXSYNCHEADER_M (q2q3_xpipe_pipe_ch6_rxsyncheader_m),
      .XPIPE_PIPE_CH6_RXVALID_M      (q2q3_xpipe_pipe_ch6_rxvalid_m),
      .XPIPE_PIPE_CH6_TXDETECTRXLOOPBACK_M(q2q3_xpipe_pipe_ch6_txdetectrxloopback_m),

      .XPIPE_PIPE_CH7_PHYSTATUS      (q1q2_xpipe_pipe_ch7_phystatus_m),
      .XPIPE_PIPE_CH7_RXCHARISK      (q1q2_xpipe_pipe_ch7_rxcharisk_m),
      .XPIPE_PIPE_CH7_RXDATA         (q1q2_xpipe_pipe_ch7_rxdata_m), //ifcpmxpipechannel7xpiperxdata
      .XPIPE_PIPE_CH7_RXDATAVALID    (q1q2_xpipe_pipe_ch7_rxdatavalid_m),
      .XPIPE_PIPE_CH7_RXELECIDLE     (q1q2_xpipe_pipe_ch7_rxelecidle_m),
      .XPIPE_PIPE_CH7_RXSTARTBLOCK   (q1q2_xpipe_pipe_ch7_rxstartblock_m),
      .XPIPE_PIPE_CH7_RXSTATUS       (q1q2_xpipe_pipe_ch7_rxstatus_m),
      .XPIPE_PIPE_CH7_RXSYNCHEADER   (q1q2_xpipe_pipe_ch7_rxsyncheader_m),
      .XPIPE_PIPE_CH7_RXVALID        (q1q2_xpipe_pipe_ch7_rxvalid_m),
      .XPIPE_PIPE_CH7_POWERDOWN      (q1q2_xpipe_pipe_ch7_powerdown_m),
      .XPIPE_PIPE_CH7_RXPOLARITY     (q1q2_xpipe_pipe_ch7_rxpolarity_m),
      .XPIPE_PIPE_CH7_RXTERMINATION  (q1q2_xpipe_pipe_ch7_rxtermination_m),
      .XPIPE_PIPE_CH7_TXCHARISK      (q1q2_xpipe_pipe_ch7_txcharisk_m),
      .XPIPE_PIPE_CH7_TXCOMPLIANCE   (q1q2_xpipe_pipe_ch7_txcompliance_m),
      .XPIPE_PIPE_CH7_TXDATA         (q1q2_xpipe_pipe_ch7_txdata_m),
      .XPIPE_PIPE_CH7_TXDATAVALID    (q1q2_xpipe_pipe_ch7_txdatavalid_m),
      .XPIPE_PIPE_CH7_TXDEEMPH       (q1q2_xpipe_pipe_ch7_txdeemph_m),
      .XPIPE_PIPE_CH7_TXDETECTRXLOOPBACK(q1q2_xpipe_pipe_ch7_txdetectrxloopback_m),
      .XPIPE_PIPE_CH7_TXELECIDLE     (q1q2_xpipe_pipe_ch7_txelecidle_m),
      .XPIPE_PIPE_CH7_TXMAINCURSOR   (q1q2_xpipe_pipe_ch7_txmaincursor_m),
      .XPIPE_PIPE_CH7_TXMARGIN       (q1q2_xpipe_pipe_ch7_txmargin_m),
      .XPIPE_PIPE_CH7_TXPOSTCURSOR   (q1q2_xpipe_pipe_ch7_txpostcursor_m),
      .XPIPE_PIPE_CH7_TXPRECURSOR    (q1q2_xpipe_pipe_ch7_txprecursor_m),
      .XPIPE_PIPE_CH7_TXSTARTBLOCK   (q1q2_xpipe_pipe_ch7_txstartblock_m),
      .XPIPE_PIPE_CH7_TXSWING        (q1q2_xpipe_pipe_ch7_txswing_m),
      .XPIPE_PIPE_CH7_TXSYNCHEADER   (q1q2_xpipe_pipe_ch7_txsyncheader_m),

      .XPIPE_PIPE_CH7_POWERDOWN_M    (q2q3_xpipe_pipe_ch7_powerdown_m),
      .XPIPE_PIPE_CH7_RXPOLARITY_M   (q2q3_xpipe_pipe_ch7_rxpolarity_m),
      .XPIPE_PIPE_CH7_RXTERMINATION_M(q2q3_xpipe_pipe_ch7_rxtermination_m),
      .XPIPE_PIPE_CH7_TXCHARISK_M    (q2q3_xpipe_pipe_ch7_txcharisk_m),
      .XPIPE_PIPE_CH7_TXCOMPLIANCE_M (q2q3_xpipe_pipe_ch7_txcompliance_m),
      .XPIPE_PIPE_CH7_TXDATAVALID_M  (q2q3_xpipe_pipe_ch7_txdatavalid_m),
      .XPIPE_PIPE_CH7_TXDATA_M       (q2q3_xpipe_pipe_ch7_txdata_m),
      .XPIPE_PIPE_CH7_TXDEEMPH_M     (q2q3_xpipe_pipe_ch7_txdeemph_m),
      .XPIPE_PIPE_CH7_TXELECIDLE_M   (q2q3_xpipe_pipe_ch7_txelecidle_m),
      .XPIPE_PIPE_CH7_TXMAINCURSOR_M (q2q3_xpipe_pipe_ch7_txmaincursor_m),
      .XPIPE_PIPE_CH7_TXMARGIN_M     (q2q3_xpipe_pipe_ch7_txmargin_m),
      .XPIPE_PIPE_CH7_TXPOSTCURSOR_M (q2q3_xpipe_pipe_ch7_txpostcursor_m),
      .XPIPE_PIPE_CH7_TXPRECURSOR_M  (q2q3_xpipe_pipe_ch7_txprecursor_m),
      .XPIPE_PIPE_CH7_TXSTARTBLOCK_M (q2q3_xpipe_pipe_ch7_txstartblock_m),
      .XPIPE_PIPE_CH7_TXSWING_M      (q2q3_xpipe_pipe_ch7_txswing_m),
      .XPIPE_PIPE_CH7_TXSYNCHEADER_M (q2q3_xpipe_pipe_ch7_txsyncheader_m),
      .XPIPE_PIPE_CH7_PHYSTATUS_M    (q2q3_xpipe_pipe_ch7_phystatus_m),
      .XPIPE_PIPE_CH7_RXCHARISK_M    (q2q3_xpipe_pipe_ch7_rxcharisk_m),
      .XPIPE_PIPE_CH7_RXDATAVALID_M  (q2q3_xpipe_pipe_ch7_rxdatavalid_m),
      .XPIPE_PIPE_CH7_RXDATA_M       (q2q3_xpipe_pipe_ch7_rxdata_m),
      .XPIPE_PIPE_CH7_RXELECIDLE_M   (q2q3_xpipe_pipe_ch7_rxelecidle_m),
      .XPIPE_PIPE_CH7_RXSTARTBLOCK_M (q2q3_xpipe_pipe_ch7_rxstartblock_m),
      .XPIPE_PIPE_CH7_RXSTATUS_M     (q2q3_xpipe_pipe_ch7_rxstatus_m),
      .XPIPE_PIPE_CH7_RXSYNCHEADER_M (q2q3_xpipe_pipe_ch7_rxsyncheader_m),
      .XPIPE_PIPE_CH7_RXVALID_M      (q2q3_xpipe_pipe_ch7_rxvalid_m),
      .XPIPE_PIPE_CH7_TXDETECTRXLOOPBACK_M(q2q3_xpipe_pipe_ch7_txdetectrxloopback_m),

      .XPIPE_PIPE_CH8_PHYSTATUS      (q1q2_xpipe_pipe_ch8_phystatus_m),
      .XPIPE_PIPE_CH8_RXCHARISK      (q1q2_xpipe_pipe_ch8_rxcharisk_m),
      .XPIPE_PIPE_CH8_RXDATA         (q1q2_xpipe_pipe_ch8_rxdata_m), //ifcpmxpipechannel8xpiperxdata
      .XPIPE_PIPE_CH8_RXDATAVALID    (q1q2_xpipe_pipe_ch8_rxdatavalid_m),
      .XPIPE_PIPE_CH8_RXELECIDLE     (q1q2_xpipe_pipe_ch8_rxelecidle_m),
      .XPIPE_PIPE_CH8_RXSTARTBLOCK   (q1q2_xpipe_pipe_ch8_rxstartblock_m),
      .XPIPE_PIPE_CH8_RXSTATUS       (q1q2_xpipe_pipe_ch8_rxstatus_m),
      .XPIPE_PIPE_CH8_RXSYNCHEADER   (q1q2_xpipe_pipe_ch8_rxsyncheader_m),
      .XPIPE_PIPE_CH8_RXVALID        (q1q2_xpipe_pipe_ch8_rxvalid_m),
      .XPIPE_PIPE_CH8_POWERDOWN      (q1q2_xpipe_pipe_ch8_powerdown_m),
      .XPIPE_PIPE_CH8_RXPOLARITY     (q1q2_xpipe_pipe_ch8_rxpolarity_m),
      .XPIPE_PIPE_CH8_RXTERMINATION  (q1q2_xpipe_pipe_ch8_rxtermination_m),
      .XPIPE_PIPE_CH8_TXCHARISK      (q1q2_xpipe_pipe_ch8_txcharisk_m),
      .XPIPE_PIPE_CH8_TXCOMPLIANCE   (q1q2_xpipe_pipe_ch8_txcompliance_m),
      .XPIPE_PIPE_CH8_TXDATA         (q1q2_xpipe_pipe_ch8_txdata_m),
      .XPIPE_PIPE_CH8_TXDATAVALID    (q1q2_xpipe_pipe_ch8_txdatavalid_m),
      .XPIPE_PIPE_CH8_TXDEEMPH       (q1q2_xpipe_pipe_ch8_txdeemph_m),
      .XPIPE_PIPE_CH8_TXDETECTRXLOOPBACK(q1q2_xpipe_pipe_ch8_txdetectrxloopback_m),
      .XPIPE_PIPE_CH8_TXELECIDLE     (q1q2_xpipe_pipe_ch8_txelecidle_m),
      .XPIPE_PIPE_CH8_TXMAINCURSOR   (q1q2_xpipe_pipe_ch8_txmaincursor_m),
      .XPIPE_PIPE_CH8_TXMARGIN       (q1q2_xpipe_pipe_ch8_txmargin_m),
      .XPIPE_PIPE_CH8_TXPOSTCURSOR   (q1q2_xpipe_pipe_ch8_txpostcursor_m),
      .XPIPE_PIPE_CH8_TXPRECURSOR    (q1q2_xpipe_pipe_ch8_txprecursor_m),
      .XPIPE_PIPE_CH8_TXSTARTBLOCK   (q1q2_xpipe_pipe_ch8_txstartblock_m),
      .XPIPE_PIPE_CH8_TXSWING        (q1q2_xpipe_pipe_ch8_txswing_m),
      .XPIPE_PIPE_CH8_TXSYNCHEADER   (q1q2_xpipe_pipe_ch8_txsyncheader_m),

      .XPIPE_PIPE_CH8_POWERDOWN_M    (q2q3_xpipe_pipe_ch8_powerdown_m),
      .XPIPE_PIPE_CH8_RXPOLARITY_M   (q2q3_xpipe_pipe_ch8_rxpolarity_m),
      .XPIPE_PIPE_CH8_RXTERMINATION_M(q2q3_xpipe_pipe_ch8_rxtermination_m),
      .XPIPE_PIPE_CH8_TXCHARISK_M    (q2q3_xpipe_pipe_ch8_txcharisk_m),
      .XPIPE_PIPE_CH8_TXCOMPLIANCE_M (q2q3_xpipe_pipe_ch8_txcompliance_m),
      .XPIPE_PIPE_CH8_TXDATAVALID_M  (q2q3_xpipe_pipe_ch8_txdatavalid_m),
      .XPIPE_PIPE_CH8_TXDATA_M       (q2q3_xpipe_pipe_ch8_txdata_m),
      .XPIPE_PIPE_CH8_TXDEEMPH_M     (q2q3_xpipe_pipe_ch8_txdeemph_m),
      .XPIPE_PIPE_CH8_TXELECIDLE_M   (q2q3_xpipe_pipe_ch8_txelecidle_m),
      .XPIPE_PIPE_CH8_TXMAINCURSOR_M (q2q3_xpipe_pipe_ch8_txmaincursor_m),
      .XPIPE_PIPE_CH8_TXMARGIN_M     (q2q3_xpipe_pipe_ch8_txmargin_m),
      .XPIPE_PIPE_CH8_TXPOSTCURSOR_M (q2q3_xpipe_pipe_ch8_txpostcursor_m),
      .XPIPE_PIPE_CH8_TXPRECURSOR_M  (q2q3_xpipe_pipe_ch8_txprecursor_m),
      .XPIPE_PIPE_CH8_TXSTARTBLOCK_M (q2q3_xpipe_pipe_ch8_txstartblock_m),
      .XPIPE_PIPE_CH8_TXSWING_M      (q2q3_xpipe_pipe_ch8_txswing_m),
      .XPIPE_PIPE_CH8_TXSYNCHEADER_M (q2q3_xpipe_pipe_ch8_txsyncheader_m),
      .XPIPE_PIPE_CH8_PHYSTATUS_M    (q2q3_xpipe_pipe_ch8_phystatus_m),
      .XPIPE_PIPE_CH8_RXCHARISK_M    (q2q3_xpipe_pipe_ch8_rxcharisk_m),
      .XPIPE_PIPE_CH8_RXDATAVALID_M  (q2q3_xpipe_pipe_ch8_rxdatavalid_m),
      .XPIPE_PIPE_CH8_RXDATA_M       (q2q3_xpipe_pipe_ch8_rxdata_m),
      .XPIPE_PIPE_CH8_RXELECIDLE_M   (q2q3_xpipe_pipe_ch8_rxelecidle_m),
      .XPIPE_PIPE_CH8_RXSTARTBLOCK_M (q2q3_xpipe_pipe_ch8_rxstartblock_m),
      .XPIPE_PIPE_CH8_RXSTATUS_M     (q2q3_xpipe_pipe_ch8_rxstatus_m),
      .XPIPE_PIPE_CH8_RXSYNCHEADER_M (q2q3_xpipe_pipe_ch8_rxsyncheader_m),
      .XPIPE_PIPE_CH8_RXVALID_M      (q2q3_xpipe_pipe_ch8_rxvalid_m),
      .XPIPE_PIPE_CH8_TXDETECTRXLOOPBACK_M(q2q3_xpipe_pipe_ch8_txdetectrxloopback_m),

      .XPIPE_PIPE_CH9_PHYSTATUS      (q1q2_xpipe_pipe_ch9_phystatus_m),
      .XPIPE_PIPE_CH9_RXCHARISK      (q1q2_xpipe_pipe_ch9_rxcharisk_m),
      .XPIPE_PIPE_CH9_RXDATA         (q1q2_xpipe_pipe_ch9_rxdata_m),
      .XPIPE_PIPE_CH9_RXDATAVALID    (q1q2_xpipe_pipe_ch9_rxdatavalid_m),
      .XPIPE_PIPE_CH9_RXELECIDLE     (q1q2_xpipe_pipe_ch9_rxelecidle_m),
      .XPIPE_PIPE_CH9_RXSTARTBLOCK   (q1q2_xpipe_pipe_ch9_rxstartblock_m),
      .XPIPE_PIPE_CH9_RXSTATUS       (q1q2_xpipe_pipe_ch9_rxstatus_m),
      .XPIPE_PIPE_CH9_RXSYNCHEADER   (q1q2_xpipe_pipe_ch9_rxsyncheader_m),
      .XPIPE_PIPE_CH9_RXVALID        (q1q2_xpipe_pipe_ch9_rxvalid_m),
      .XPIPE_PIPE_CH9_POWERDOWN      (q1q2_xpipe_pipe_ch9_powerdown_m),
      .XPIPE_PIPE_CH9_RXPOLARITY     (q1q2_xpipe_pipe_ch9_rxpolarity_m),
      .XPIPE_PIPE_CH9_RXTERMINATION  (q1q2_xpipe_pipe_ch9_rxtermination_m),
      .XPIPE_PIPE_CH9_TXCHARISK      (q1q2_xpipe_pipe_ch9_txcharisk_m),
      .XPIPE_PIPE_CH9_TXCOMPLIANCE   (q1q2_xpipe_pipe_ch9_txcompliance_m),
      .XPIPE_PIPE_CH9_TXDATA         (q1q2_xpipe_pipe_ch9_txdata_m),
      .XPIPE_PIPE_CH9_TXDATAVALID    (q1q2_xpipe_pipe_ch9_txdatavalid_m),
      .XPIPE_PIPE_CH9_TXDEEMPH       (q1q2_xpipe_pipe_ch9_txdeemph_m),
      .XPIPE_PIPE_CH9_TXDETECTRXLOOPBACK(q1q2_xpipe_pipe_ch9_txdetectrxloopback_m),
      .XPIPE_PIPE_CH9_TXELECIDLE     (q1q2_xpipe_pipe_ch9_txelecidle_m),
      .XPIPE_PIPE_CH9_TXMAINCURSOR   (q1q2_xpipe_pipe_ch9_txmaincursor_m),
      .XPIPE_PIPE_CH9_TXMARGIN       (q1q2_xpipe_pipe_ch9_txmargin_m),
      .XPIPE_PIPE_CH9_TXPOSTCURSOR   (q1q2_xpipe_pipe_ch9_txpostcursor_m),
      .XPIPE_PIPE_CH9_TXPRECURSOR    (q1q2_xpipe_pipe_ch9_txprecursor_m),
      .XPIPE_PIPE_CH9_TXSTARTBLOCK   (q1q2_xpipe_pipe_ch9_txstartblock_m),
      .XPIPE_PIPE_CH9_TXSWING        (q1q2_xpipe_pipe_ch9_txswing_m),
      .XPIPE_PIPE_CH9_TXSYNCHEADER   (q1q2_xpipe_pipe_ch9_txsyncheader_m),

      .XPIPE_PIPE_CH9_POWERDOWN_M    (q2q3_xpipe_pipe_ch9_powerdown_m),
      .XPIPE_PIPE_CH9_RXPOLARITY_M   (q2q3_xpipe_pipe_ch9_rxpolarity_m),
      .XPIPE_PIPE_CH9_RXTERMINATION_M(q2q3_xpipe_pipe_ch9_rxtermination_m),
      .XPIPE_PIPE_CH9_TXCHARISK_M    (q2q3_xpipe_pipe_ch9_txcharisk_m),
      .XPIPE_PIPE_CH9_TXCOMPLIANCE_M (q2q3_xpipe_pipe_ch9_txcompliance_m),
      .XPIPE_PIPE_CH9_TXDATAVALID_M  (q2q3_xpipe_pipe_ch9_txdatavalid_m),
      .XPIPE_PIPE_CH9_TXDATA_M       (q2q3_xpipe_pipe_ch9_txdata_m),
      .XPIPE_PIPE_CH9_TXDEEMPH_M     (q2q3_xpipe_pipe_ch9_txdeemph_m),
      .XPIPE_PIPE_CH9_TXELECIDLE_M   (q2q3_xpipe_pipe_ch9_txelecidle_m),
      .XPIPE_PIPE_CH9_TXMAINCURSOR_M (q2q3_xpipe_pipe_ch9_txmaincursor_m),
      .XPIPE_PIPE_CH9_TXMARGIN_M     (q2q3_xpipe_pipe_ch9_txmargin_m),
      .XPIPE_PIPE_CH9_TXPOSTCURSOR_M (q2q3_xpipe_pipe_ch9_txpostcursor_m),
      .XPIPE_PIPE_CH9_TXPRECURSOR_M  (q2q3_xpipe_pipe_ch9_txprecursor_m),
      .XPIPE_PIPE_CH9_TXSTARTBLOCK_M (q2q3_xpipe_pipe_ch9_txstartblock_m),
      .XPIPE_PIPE_CH9_TXSWING_M      (q2q3_xpipe_pipe_ch9_txswing_m),
      .XPIPE_PIPE_CH9_TXSYNCHEADER_M (q2q3_xpipe_pipe_ch9_txsyncheader_m),
      .XPIPE_PIPE_CH9_PHYSTATUS_M    (q2q3_xpipe_pipe_ch9_phystatus_m),
      .XPIPE_PIPE_CH9_RXCHARISK_M    (q2q3_xpipe_pipe_ch9_rxcharisk_m),
      .XPIPE_PIPE_CH9_RXDATAVALID_M  (q2q3_xpipe_pipe_ch9_rxdatavalid_m),
      .XPIPE_PIPE_CH9_RXDATA_M       (q2q3_xpipe_pipe_ch9_rxdata_m),
      .XPIPE_PIPE_CH9_RXELECIDLE_M   (q2q3_xpipe_pipe_ch9_rxelecidle_m),
      .XPIPE_PIPE_CH9_RXSTARTBLOCK_M (q2q3_xpipe_pipe_ch9_rxstartblock_m),
      .XPIPE_PIPE_CH9_RXSTATUS_M     (q2q3_xpipe_pipe_ch9_rxstatus_m),
      .XPIPE_PIPE_CH9_RXSYNCHEADER_M (q2q3_xpipe_pipe_ch9_rxsyncheader_m),
      .XPIPE_PIPE_CH9_RXVALID_M      (q2q3_xpipe_pipe_ch9_rxvalid_m),
      .XPIPE_PIPE_CH9_TXDETECTRXLOOPBACK_M(q2q3_xpipe_pipe_ch9_txdetectrxloopback_m),

      .XPIPE_PIPE_CH10_PHYSTATUS     (q1q2_xpipe_pipe_ch10_phystatus_m),
      .XPIPE_PIPE_CH10_RXCHARISK     (q1q2_xpipe_pipe_ch10_rxcharisk_m),
      .XPIPE_PIPE_CH10_RXDATA        (q1q2_xpipe_pipe_ch10_rxdata_m), 
      .XPIPE_PIPE_CH10_RXDATAVALID   (q1q2_xpipe_pipe_ch10_rxdatavalid_m),
      .XPIPE_PIPE_CH10_RXELECIDLE    (q1q2_xpipe_pipe_ch10_rxelecidle_m),
      .XPIPE_PIPE_CH10_RXSTARTBLOCK  (q1q2_xpipe_pipe_ch10_rxstartblock_m),
      .XPIPE_PIPE_CH10_RXSTATUS      (q1q2_xpipe_pipe_ch10_rxstatus_m),
      .XPIPE_PIPE_CH10_RXSYNCHEADER  (q1q2_xpipe_pipe_ch10_rxsyncheader_m),
      .XPIPE_PIPE_CH10_RXVALID       (q1q2_xpipe_pipe_ch10_rxvalid_m),
      .XPIPE_PIPE_CH10_POWERDOWN     (q1q2_xpipe_pipe_ch10_powerdown_m),
      .XPIPE_PIPE_CH10_RXPOLARITY    (q1q2_xpipe_pipe_ch10_rxpolarity_m),
      .XPIPE_PIPE_CH10_RXTERMINATION (q1q2_xpipe_pipe_ch10_rxtermination_m),
      .XPIPE_PIPE_CH10_TXCHARISK     (q1q2_xpipe_pipe_ch10_txcharisk_m),
      .XPIPE_PIPE_CH10_TXCOMPLIANCE  (q1q2_xpipe_pipe_ch10_txcompliance_m),
      .XPIPE_PIPE_CH10_TXDATA        (q1q2_xpipe_pipe_ch10_txdata_m),
      .XPIPE_PIPE_CH10_TXDATAVALID   (q1q2_xpipe_pipe_ch10_txdatavalid_m),
      .XPIPE_PIPE_CH10_TXDEEMPH      (q1q2_xpipe_pipe_ch10_txdeemph_m),
      .XPIPE_PIPE_CH10_TXDETECTRXLOOPBACK(q1q2_xpipe_pipe_ch10_txdetectrxloopback_m),
      .XPIPE_PIPE_CH10_TXELECIDLE    (q1q2_xpipe_pipe_ch10_txelecidle_m),
      .XPIPE_PIPE_CH10_TXMAINCURSOR  (q1q2_xpipe_pipe_ch10_txmaincursor_m),
      .XPIPE_PIPE_CH10_TXMARGIN      (q1q2_xpipe_pipe_ch10_txmargin_m),
      .XPIPE_PIPE_CH10_TXPOSTCURSOR  (q1q2_xpipe_pipe_ch10_txpostcursor_m),
      .XPIPE_PIPE_CH10_TXPRECURSOR   (q1q2_xpipe_pipe_ch10_txprecursor_m),
      .XPIPE_PIPE_CH10_TXSTARTBLOCK  (q1q2_xpipe_pipe_ch10_txstartblock_m),
      .XPIPE_PIPE_CH10_TXSWING       (q1q2_xpipe_pipe_ch10_txswing_m),
      .XPIPE_PIPE_CH10_TXSYNCHEADER  (q1q2_xpipe_pipe_ch10_txsyncheader_m),

      .XPIPE_PIPE_CH10_POWERDOWN_M   (q2q3_xpipe_pipe_ch10_powerdown_m),
      .XPIPE_PIPE_CH10_RXPOLARITY_M  (q2q3_xpipe_pipe_ch10_rxpolarity_m),
      .XPIPE_PIPE_CH10_RXTERMINATION_M(q2q3_xpipe_pipe_ch10_rxtermination_m),
      .XPIPE_PIPE_CH10_TXCHARISK_M   (q2q3_xpipe_pipe_ch10_txcharisk_m),
      .XPIPE_PIPE_CH10_TXCOMPLIANCE_M(q2q3_xpipe_pipe_ch10_txcompliance_m),
      .XPIPE_PIPE_CH10_TXDATAVALID_M (q2q3_xpipe_pipe_ch10_txdatavalid_m),
      .XPIPE_PIPE_CH10_TXDATA_M      (q2q3_xpipe_pipe_ch10_txdata_m),
      .XPIPE_PIPE_CH10_TXDEEMPH_M    (q2q3_xpipe_pipe_ch10_txdeemph_m),
      .XPIPE_PIPE_CH10_TXELECIDLE_M  (q2q3_xpipe_pipe_ch10_txelecidle_m),
      .XPIPE_PIPE_CH10_TXMAINCURSOR_M(q2q3_xpipe_pipe_ch10_txmaincursor_m),
      .XPIPE_PIPE_CH10_TXMARGIN_M    (q2q3_xpipe_pipe_ch10_txmargin_m),
      .XPIPE_PIPE_CH10_TXPOSTCURSOR_M(q2q3_xpipe_pipe_ch10_txpostcursor_m),
      .XPIPE_PIPE_CH10_TXPRECURSOR_M (q2q3_xpipe_pipe_ch10_txprecursor_m),
      .XPIPE_PIPE_CH10_TXSTARTBLOCK_M(q2q3_xpipe_pipe_ch10_txstartblock_m),
      .XPIPE_PIPE_CH10_TXSWING_M     (q2q3_xpipe_pipe_ch10_txswing_m),
      .XPIPE_PIPE_CH10_TXSYNCHEADER_M(q2q3_xpipe_pipe_ch10_txsyncheader_m),
      .XPIPE_PIPE_CH10_PHYSTATUS_M   (q2q3_xpipe_pipe_ch10_phystatus_m),
      .XPIPE_PIPE_CH10_RXCHARISK_M   (q2q3_xpipe_pipe_ch10_rxcharisk_m),
      .XPIPE_PIPE_CH10_RXDATAVALID_M (q2q3_xpipe_pipe_ch10_rxdatavalid_m),
      .XPIPE_PIPE_CH10_RXDATA_M      (q2q3_xpipe_pipe_ch10_rxdata_m),
      .XPIPE_PIPE_CH10_RXELECIDLE_M  (q2q3_xpipe_pipe_ch10_rxelecidle_m),
      .XPIPE_PIPE_CH10_RXSTARTBLOCK_M(q2q3_xpipe_pipe_ch10_rxstartblock_m),
      .XPIPE_PIPE_CH10_RXSTATUS_M    (q2q3_xpipe_pipe_ch10_rxstatus_m),
      .XPIPE_PIPE_CH10_RXSYNCHEADER_M(q2q3_xpipe_pipe_ch10_rxsyncheader_m),
      .XPIPE_PIPE_CH10_RXVALID_M     (q2q3_xpipe_pipe_ch10_rxvalid_m),
      .XPIPE_PIPE_CH10_TXDETECTRXLOOPBACK_M(q2q3_xpipe_pipe_ch10_txdetectrxloopback_m),

      .XPIPE_PIPE_CH11_PHYSTATUS     (q1q2_xpipe_pipe_ch11_phystatus_m),
      .XPIPE_PIPE_CH11_RXCHARISK     (q1q2_xpipe_pipe_ch11_rxcharisk_m),
      .XPIPE_PIPE_CH11_RXDATA        (q1q2_xpipe_pipe_ch11_rxdata_m), 
      .XPIPE_PIPE_CH11_RXDATAVALID   (q1q2_xpipe_pipe_ch11_rxdatavalid_m),
      .XPIPE_PIPE_CH11_RXELECIDLE    (q1q2_xpipe_pipe_ch11_rxelecidle_m),
      .XPIPE_PIPE_CH11_RXSTARTBLOCK  (q1q2_xpipe_pipe_ch11_rxstartblock_m),
      .XPIPE_PIPE_CH11_RXSTATUS      (q1q2_xpipe_pipe_ch11_rxstatus_m),
      .XPIPE_PIPE_CH11_RXSYNCHEADER  (q1q2_xpipe_pipe_ch11_rxsyncheader_m),
      .XPIPE_PIPE_CH11_RXVALID       (q1q2_xpipe_pipe_ch11_rxvalid_m),
      .XPIPE_PIPE_CH11_POWERDOWN     (q1q2_xpipe_pipe_ch11_powerdown_m),
      .XPIPE_PIPE_CH11_RXPOLARITY    (q1q2_xpipe_pipe_ch11_rxpolarity_m),
      .XPIPE_PIPE_CH11_RXTERMINATION (q1q2_xpipe_pipe_ch11_rxtermination_m),
      .XPIPE_PIPE_CH11_TXCHARISK     (q1q2_xpipe_pipe_ch11_txcharisk_m),
      .XPIPE_PIPE_CH11_TXCOMPLIANCE  (q1q2_xpipe_pipe_ch11_txcompliance_m),
      .XPIPE_PIPE_CH11_TXDATA        (q1q2_xpipe_pipe_ch11_txdata_m),
      .XPIPE_PIPE_CH11_TXDATAVALID   (q1q2_xpipe_pipe_ch11_txdatavalid_m),
      .XPIPE_PIPE_CH11_TXDEEMPH      (q1q2_xpipe_pipe_ch11_txdeemph_m),
      .XPIPE_PIPE_CH11_TXDETECTRXLOOPBACK(q1q2_xpipe_pipe_ch11_txdetectrxloopback_m),
      .XPIPE_PIPE_CH11_TXELECIDLE    (q1q2_xpipe_pipe_ch11_txelecidle_m),
      .XPIPE_PIPE_CH11_TXMAINCURSOR  (q1q2_xpipe_pipe_ch11_txmaincursor_m),
      .XPIPE_PIPE_CH11_TXMARGIN      (q1q2_xpipe_pipe_ch11_txmargin_m),
      .XPIPE_PIPE_CH11_TXPOSTCURSOR  (q1q2_xpipe_pipe_ch11_txpostcursor_m),
      .XPIPE_PIPE_CH11_TXPRECURSOR   (q1q2_xpipe_pipe_ch11_txprecursor_m),
      .XPIPE_PIPE_CH11_TXSTARTBLOCK  (q1q2_xpipe_pipe_ch11_txstartblock_m),
      .XPIPE_PIPE_CH11_TXSWING       (q1q2_xpipe_pipe_ch11_txswing_m),
      .XPIPE_PIPE_CH11_TXSYNCHEADER  (q1q2_xpipe_pipe_ch11_txsyncheader_m),

      .XPIPE_PIPE_CH11_POWERDOWN_M   (q2q3_xpipe_pipe_ch11_powerdown_m),
      .XPIPE_PIPE_CH11_RXPOLARITY_M  (q2q3_xpipe_pipe_ch11_rxpolarity_m),
      .XPIPE_PIPE_CH11_RXTERMINATION_M(q2q3_xpipe_pipe_ch11_rxtermination_m),
      .XPIPE_PIPE_CH11_TXCHARISK_M   (q2q3_xpipe_pipe_ch11_txcharisk_m),
      .XPIPE_PIPE_CH11_TXCOMPLIANCE_M(q2q3_xpipe_pipe_ch11_txcompliance_m),
      .XPIPE_PIPE_CH11_TXDATAVALID_M (q2q3_xpipe_pipe_ch11_txdatavalid_m),
      .XPIPE_PIPE_CH11_TXDATA_M      (q2q3_xpipe_pipe_ch11_txdata_m),
      .XPIPE_PIPE_CH11_TXDEEMPH_M    (q2q3_xpipe_pipe_ch11_txdeemph_m),
      .XPIPE_PIPE_CH11_TXELECIDLE_M  (q2q3_xpipe_pipe_ch11_txelecidle_m),
      .XPIPE_PIPE_CH11_TXMAINCURSOR_M(q2q3_xpipe_pipe_ch11_txmaincursor_m),
      .XPIPE_PIPE_CH11_TXMARGIN_M    (q2q3_xpipe_pipe_ch11_txmargin_m),
      .XPIPE_PIPE_CH11_TXPOSTCURSOR_M(q2q3_xpipe_pipe_ch11_txpostcursor_m),
      .XPIPE_PIPE_CH11_TXPRECURSOR_M (q2q3_xpipe_pipe_ch11_txprecursor_m),
      .XPIPE_PIPE_CH11_TXSTARTBLOCK_M(q2q3_xpipe_pipe_ch11_txstartblock_m),
      .XPIPE_PIPE_CH11_TXSWING_M     (q2q3_xpipe_pipe_ch11_txswing_m),
      .XPIPE_PIPE_CH11_TXSYNCHEADER_M(q2q3_xpipe_pipe_ch11_txsyncheader_m),
      .XPIPE_PIPE_CH11_PHYSTATUS_M   (q2q3_xpipe_pipe_ch11_phystatus_m),
      .XPIPE_PIPE_CH11_RXCHARISK_M   (q2q3_xpipe_pipe_ch11_rxcharisk_m),
      .XPIPE_PIPE_CH11_RXDATAVALID_M (q2q3_xpipe_pipe_ch11_rxdatavalid_m),
      .XPIPE_PIPE_CH11_RXDATA_M      (q2q3_xpipe_pipe_ch11_rxdata_m),
      .XPIPE_PIPE_CH11_RXELECIDLE_M  (q2q3_xpipe_pipe_ch11_rxelecidle_m),
      .XPIPE_PIPE_CH11_RXSTARTBLOCK_M(q2q3_xpipe_pipe_ch11_rxstartblock_m),
      .XPIPE_PIPE_CH11_RXSTATUS_M    (q2q3_xpipe_pipe_ch11_rxstatus_m),
      .XPIPE_PIPE_CH11_RXSYNCHEADER_M(q2q3_xpipe_pipe_ch11_rxsyncheader_m),
      .XPIPE_PIPE_CH11_RXVALID_M     (q2q3_xpipe_pipe_ch11_rxvalid_m),
      .XPIPE_PIPE_CH11_TXDETECTRXLOOPBACK_M(q2q3_xpipe_pipe_ch11_txdetectrxloopback_m),

      .XPIPE_PIPE_CH12_PHYSTATUS     (q1q2_xpipe_pipe_ch12_phystatus_m),
      .XPIPE_PIPE_CH12_RXCHARISK     (q1q2_xpipe_pipe_ch12_rxcharisk_m),
      .XPIPE_PIPE_CH12_RXDATA        (q1q2_xpipe_pipe_ch12_rxdata_m), //ifcpmxpipechannel12xpiperxdata
      .XPIPE_PIPE_CH12_RXDATAVALID   (q1q2_xpipe_pipe_ch12_rxdatavalid_m),
      .XPIPE_PIPE_CH12_RXELECIDLE    (q1q2_xpipe_pipe_ch12_rxelecidle_m),
      .XPIPE_PIPE_CH12_RXSTARTBLOCK  (q1q2_xpipe_pipe_ch12_rxstartblock_m),
      .XPIPE_PIPE_CH12_RXSTATUS      (q1q2_xpipe_pipe_ch12_rxstatus_m),
      .XPIPE_PIPE_CH12_RXSYNCHEADER  (q1q2_xpipe_pipe_ch12_rxsyncheader_m),
      .XPIPE_PIPE_CH12_RXVALID       (q1q2_xpipe_pipe_ch12_rxvalid_m),
      .XPIPE_PIPE_CH12_POWERDOWN     (q1q2_xpipe_pipe_ch12_powerdown_m),
      .XPIPE_PIPE_CH12_RXPOLARITY    (q1q2_xpipe_pipe_ch12_rxpolarity_m),
      .XPIPE_PIPE_CH12_RXTERMINATION (q1q2_xpipe_pipe_ch12_rxtermination_m),
      .XPIPE_PIPE_CH12_TXCHARISK     (q1q2_xpipe_pipe_ch12_txcharisk_m),
      .XPIPE_PIPE_CH12_TXCOMPLIANCE  (q1q2_xpipe_pipe_ch12_txcompliance_m),
      .XPIPE_PIPE_CH12_TXDATA        (q1q2_xpipe_pipe_ch12_txdata_m),
      .XPIPE_PIPE_CH12_TXDATAVALID   (q1q2_xpipe_pipe_ch12_txdatavalid_m),
      .XPIPE_PIPE_CH12_TXDEEMPH      (q1q2_xpipe_pipe_ch12_txdeemph_m),
      .XPIPE_PIPE_CH12_TXDETECTRXLOOPBACK(q1q2_xpipe_pipe_ch12_txdetectrxloopback_m),
      .XPIPE_PIPE_CH12_TXELECIDLE    (q1q2_xpipe_pipe_ch12_txelecidle_m),
      .XPIPE_PIPE_CH12_TXMAINCURSOR  (q1q2_xpipe_pipe_ch12_txmaincursor_m),
      .XPIPE_PIPE_CH12_TXMARGIN      (q1q2_xpipe_pipe_ch12_txmargin_m),
      .XPIPE_PIPE_CH12_TXPOSTCURSOR  (q1q2_xpipe_pipe_ch12_txpostcursor_m),
      .XPIPE_PIPE_CH12_TXPRECURSOR   (q1q2_xpipe_pipe_ch12_txprecursor_m),
      .XPIPE_PIPE_CH12_TXSTARTBLOCK  (q1q2_xpipe_pipe_ch12_txstartblock_m),
      .XPIPE_PIPE_CH12_TXSWING       (q1q2_xpipe_pipe_ch12_txswing_m),
      .XPIPE_PIPE_CH12_TXSYNCHEADER  (q1q2_xpipe_pipe_ch12_txsyncheader_m),

      .XPIPE_PIPE_CH12_POWERDOWN_M   (q2q3_xpipe_pipe_ch12_powerdown_m),
      .XPIPE_PIPE_CH12_RXPOLARITY_M  (q2q3_xpipe_pipe_ch12_rxpolarity_m),
      .XPIPE_PIPE_CH12_RXTERMINATION_M(q2q3_xpipe_pipe_ch12_rxtermination_m),
      .XPIPE_PIPE_CH12_TXCHARISK_M   (q2q3_xpipe_pipe_ch12_txcharisk_m),
      .XPIPE_PIPE_CH12_TXCOMPLIANCE_M(q2q3_xpipe_pipe_ch12_txcompliance_m),
      .XPIPE_PIPE_CH12_TXDATAVALID_M (q2q3_xpipe_pipe_ch12_txdatavalid_m),
      .XPIPE_PIPE_CH12_TXDATA_M      (q2q3_xpipe_pipe_ch12_txdata_m),
      .XPIPE_PIPE_CH12_TXDEEMPH_M    (q2q3_xpipe_pipe_ch12_txdeemph_m),
      .XPIPE_PIPE_CH12_TXELECIDLE_M  (q2q3_xpipe_pipe_ch12_txelecidle_m),
      .XPIPE_PIPE_CH12_TXMAINCURSOR_M(q2q3_xpipe_pipe_ch12_txmaincursor_m),
      .XPIPE_PIPE_CH12_TXMARGIN_M    (q2q3_xpipe_pipe_ch12_txmargin_m),
      .XPIPE_PIPE_CH12_TXPOSTCURSOR_M(q2q3_xpipe_pipe_ch12_txpostcursor_m),
      .XPIPE_PIPE_CH12_TXPRECURSOR_M (q2q3_xpipe_pipe_ch12_txprecursor_m),
      .XPIPE_PIPE_CH12_TXSTARTBLOCK_M(q2q3_xpipe_pipe_ch12_txstartblock_m),
      .XPIPE_PIPE_CH12_TXSWING_M     (q2q3_xpipe_pipe_ch12_txswing_m),
      .XPIPE_PIPE_CH12_TXSYNCHEADER_M(q2q3_xpipe_pipe_ch12_txsyncheader_m),
      .XPIPE_PIPE_CH12_PHYSTATUS_M   (q2q3_xpipe_pipe_ch12_phystatus_m),
      .XPIPE_PIPE_CH12_RXCHARISK_M   (q2q3_xpipe_pipe_ch12_rxcharisk_m),
      .XPIPE_PIPE_CH12_RXDATAVALID_M (q2q3_xpipe_pipe_ch12_rxdatavalid_m),
      .XPIPE_PIPE_CH12_RXDATA_M      (q2q3_xpipe_pipe_ch12_rxdata_m),
      .XPIPE_PIPE_CH12_RXELECIDLE_M  (q2q3_xpipe_pipe_ch12_rxelecidle_m),
      .XPIPE_PIPE_CH12_RXSTARTBLOCK_M(q2q3_xpipe_pipe_ch12_rxstartblock_m),
      .XPIPE_PIPE_CH12_RXSTATUS_M    (q2q3_xpipe_pipe_ch12_rxstatus_m),
      .XPIPE_PIPE_CH12_RXSYNCHEADER_M(q2q3_xpipe_pipe_ch12_rxsyncheader_m),
      .XPIPE_PIPE_CH12_RXVALID_M     (q2q3_xpipe_pipe_ch12_rxvalid_m),
      .XPIPE_PIPE_CH12_TXDETECTRXLOOPBACK_M(q2q3_xpipe_pipe_ch12_txdetectrxloopback_m),

      .XPIPE_PIPE_CH13_PHYSTATUS     (q1q2_xpipe_pipe_ch13_phystatus_m),
      .XPIPE_PIPE_CH13_RXCHARISK     (q1q2_xpipe_pipe_ch13_rxcharisk_m),
      .XPIPE_PIPE_CH13_RXDATA        (q1q2_xpipe_pipe_ch13_rxdata_m), 
      .XPIPE_PIPE_CH13_RXDATAVALID   (q1q2_xpipe_pipe_ch13_rxdatavalid_m),
      .XPIPE_PIPE_CH13_RXELECIDLE    (q1q2_xpipe_pipe_ch13_rxelecidle_m),
      .XPIPE_PIPE_CH13_RXSTARTBLOCK  (q1q2_xpipe_pipe_ch13_rxstartblock_m),
      .XPIPE_PIPE_CH13_RXSTATUS      (q1q2_xpipe_pipe_ch13_rxstatus_m),
      .XPIPE_PIPE_CH13_RXSYNCHEADER  (q1q2_xpipe_pipe_ch13_rxsyncheader_m),
      .XPIPE_PIPE_CH13_RXVALID       (q1q2_xpipe_pipe_ch13_rxvalid_m),
      .XPIPE_PIPE_CH13_POWERDOWN     (q1q2_xpipe_pipe_ch13_powerdown_m),
      .XPIPE_PIPE_CH13_RXPOLARITY    (q1q2_xpipe_pipe_ch13_rxpolarity_m),
      .XPIPE_PIPE_CH13_RXTERMINATION (q1q2_xpipe_pipe_ch13_rxtermination_m),
      .XPIPE_PIPE_CH13_TXCHARISK     (q1q2_xpipe_pipe_ch13_txcharisk_m),
      .XPIPE_PIPE_CH13_TXCOMPLIANCE  (q1q2_xpipe_pipe_ch13_txcompliance_m),
      .XPIPE_PIPE_CH13_TXDATA        (q1q2_xpipe_pipe_ch13_txdata_m),
      .XPIPE_PIPE_CH13_TXDATAVALID   (q1q2_xpipe_pipe_ch13_txdatavalid_m),
      .XPIPE_PIPE_CH13_TXDEEMPH      (q1q2_xpipe_pipe_ch13_txdeemph_m),
      .XPIPE_PIPE_CH13_TXDETECTRXLOOPBACK(q1q2_xpipe_pipe_ch13_txdetectrxloopback_m),
      .XPIPE_PIPE_CH13_TXELECIDLE    (q1q2_xpipe_pipe_ch13_txelecidle_m),
      .XPIPE_PIPE_CH13_TXMAINCURSOR  (q1q2_xpipe_pipe_ch13_txmaincursor_m),
      .XPIPE_PIPE_CH13_TXMARGIN      (q1q2_xpipe_pipe_ch13_txmargin_m),
      .XPIPE_PIPE_CH13_TXPOSTCURSOR  (q1q2_xpipe_pipe_ch13_txpostcursor_m),
      .XPIPE_PIPE_CH13_TXPRECURSOR   (q1q2_xpipe_pipe_ch13_txprecursor_m),
      .XPIPE_PIPE_CH13_TXSTARTBLOCK  (q1q2_xpipe_pipe_ch13_txstartblock_m),
      .XPIPE_PIPE_CH13_TXSWING       (q1q2_xpipe_pipe_ch13_txswing_m),
      .XPIPE_PIPE_CH13_TXSYNCHEADER  (q1q2_xpipe_pipe_ch13_txsyncheader_m),

      .XPIPE_PIPE_CH13_POWERDOWN_M   (q2q3_xpipe_pipe_ch13_powerdown_m),
      .XPIPE_PIPE_CH13_RXPOLARITY_M  (q2q3_xpipe_pipe_ch13_rxpolarity_m),
      .XPIPE_PIPE_CH13_RXTERMINATION_M(q2q3_xpipe_pipe_ch13_rxtermination_m),
      .XPIPE_PIPE_CH13_TXCHARISK_M   (q2q3_xpipe_pipe_ch13_txcharisk_m),
      .XPIPE_PIPE_CH13_TXCOMPLIANCE_M(q2q3_xpipe_pipe_ch13_txcompliance_m),
      .XPIPE_PIPE_CH13_TXDATAVALID_M (q2q3_xpipe_pipe_ch13_txdatavalid_m),
      .XPIPE_PIPE_CH13_TXDATA_M      (q2q3_xpipe_pipe_ch13_txdata_m),
      .XPIPE_PIPE_CH13_TXDEEMPH_M    (q2q3_xpipe_pipe_ch13_txdeemph_m),
      .XPIPE_PIPE_CH13_TXELECIDLE_M  (q2q3_xpipe_pipe_ch13_txelecidle_m),
      .XPIPE_PIPE_CH13_TXMAINCURSOR_M(q2q3_xpipe_pipe_ch13_txmaincursor_m),
      .XPIPE_PIPE_CH13_TXMARGIN_M    (q2q3_xpipe_pipe_ch13_txmargin_m),
      .XPIPE_PIPE_CH13_TXPOSTCURSOR_M(q2q3_xpipe_pipe_ch13_txpostcursor_m),
      .XPIPE_PIPE_CH13_TXPRECURSOR_M (q2q3_xpipe_pipe_ch13_txprecursor_m),
      .XPIPE_PIPE_CH13_TXSTARTBLOCK_M(q2q3_xpipe_pipe_ch13_txstartblock_m),
      .XPIPE_PIPE_CH13_TXSWING_M     (q2q3_xpipe_pipe_ch13_txswing_m),
      .XPIPE_PIPE_CH13_TXSYNCHEADER_M(q2q3_xpipe_pipe_ch13_txsyncheader_m),
      .XPIPE_PIPE_CH13_PHYSTATUS_M   (q2q3_xpipe_pipe_ch13_phystatus_m),
      .XPIPE_PIPE_CH13_RXCHARISK_M   (q2q3_xpipe_pipe_ch13_rxcharisk_m),
      .XPIPE_PIPE_CH13_RXDATAVALID_M (q2q3_xpipe_pipe_ch13_rxdatavalid_m),
      .XPIPE_PIPE_CH13_RXDATA_M      (q2q3_xpipe_pipe_ch13_rxdata_m),
      .XPIPE_PIPE_CH13_RXELECIDLE_M  (q2q3_xpipe_pipe_ch13_rxelecidle_m),
      .XPIPE_PIPE_CH13_RXSTARTBLOCK_M(q2q3_xpipe_pipe_ch13_rxstartblock_m),
      .XPIPE_PIPE_CH13_RXSTATUS_M    (q2q3_xpipe_pipe_ch13_rxstatus_m),
      .XPIPE_PIPE_CH13_RXSYNCHEADER_M(q2q3_xpipe_pipe_ch13_rxsyncheader_m),
      .XPIPE_PIPE_CH13_RXVALID_M     (q2q3_xpipe_pipe_ch13_rxvalid_m),
      .XPIPE_PIPE_CH13_TXDETECTRXLOOPBACK_M(q2q3_xpipe_pipe_ch13_txdetectrxloopback_m),

      .XPIPE_PIPE_CH14_PHYSTATUS     (q1q2_xpipe_pipe_ch14_phystatus_m),
      .XPIPE_PIPE_CH14_RXCHARISK     (q1q2_xpipe_pipe_ch14_rxcharisk_m),
      .XPIPE_PIPE_CH14_RXDATA        (q1q2_xpipe_pipe_ch14_rxdata_m), 
      .XPIPE_PIPE_CH14_RXDATAVALID   (q1q2_xpipe_pipe_ch14_rxdatavalid_m),
      .XPIPE_PIPE_CH14_RXELECIDLE    (q1q2_xpipe_pipe_ch14_rxelecidle_m),
      .XPIPE_PIPE_CH14_RXSTARTBLOCK  (q1q2_xpipe_pipe_ch14_rxstartblock_m),
      .XPIPE_PIPE_CH14_RXSTATUS      (q1q2_xpipe_pipe_ch14_rxstatus_m),
      .XPIPE_PIPE_CH14_RXSYNCHEADER  (q1q2_xpipe_pipe_ch14_rxsyncheader_m),
      .XPIPE_PIPE_CH14_RXVALID       (q1q2_xpipe_pipe_ch14_rxvalid_m),
      .XPIPE_PIPE_CH14_POWERDOWN     (q1q2_xpipe_pipe_ch14_powerdown_m),
      .XPIPE_PIPE_CH14_RXPOLARITY    (q1q2_xpipe_pipe_ch14_rxpolarity_m),
      .XPIPE_PIPE_CH14_RXTERMINATION (q1q2_xpipe_pipe_ch14_rxtermination_m),
      .XPIPE_PIPE_CH14_TXCHARISK     (q1q2_xpipe_pipe_ch14_txcharisk_m),
      .XPIPE_PIPE_CH14_TXCOMPLIANCE  (q1q2_xpipe_pipe_ch14_txcompliance_m),
      .XPIPE_PIPE_CH14_TXDATA        (q1q2_xpipe_pipe_ch14_txdata_m),
      .XPIPE_PIPE_CH14_TXDATAVALID   (q1q2_xpipe_pipe_ch14_txdatavalid_m),
      .XPIPE_PIPE_CH14_TXDEEMPH      (q1q2_xpipe_pipe_ch14_txdeemph_m),
      .XPIPE_PIPE_CH14_TXDETECTRXLOOPBACK(q1q2_xpipe_pipe_ch14_txdetectrxloopback_m),
      .XPIPE_PIPE_CH14_TXELECIDLE    (q1q2_xpipe_pipe_ch14_txelecidle_m),
      .XPIPE_PIPE_CH14_TXMAINCURSOR  (q1q2_xpipe_pipe_ch14_txmaincursor_m),
      .XPIPE_PIPE_CH14_TXMARGIN      (q1q2_xpipe_pipe_ch14_txmargin_m),
      .XPIPE_PIPE_CH14_TXPOSTCURSOR  (q1q2_xpipe_pipe_ch14_txpostcursor_m),
      .XPIPE_PIPE_CH14_TXPRECURSOR   (q1q2_xpipe_pipe_ch14_txprecursor_m),
      .XPIPE_PIPE_CH14_TXSTARTBLOCK  (q1q2_xpipe_pipe_ch14_txstartblock_m),
      .XPIPE_PIPE_CH14_TXSWING       (q1q2_xpipe_pipe_ch14_txswing_m),
      .XPIPE_PIPE_CH14_TXSYNCHEADER  (q1q2_xpipe_pipe_ch14_txsyncheader_m),

      .XPIPE_PIPE_CH14_POWERDOWN_M   (q2q3_xpipe_pipe_ch14_powerdown_m),
      .XPIPE_PIPE_CH14_RXPOLARITY_M  (q2q3_xpipe_pipe_ch14_rxpolarity_m),
      .XPIPE_PIPE_CH14_RXTERMINATION_M(q2q3_xpipe_pipe_ch14_rxtermination_m),
      .XPIPE_PIPE_CH14_TXCHARISK_M   (q2q3_xpipe_pipe_ch14_txcharisk_m),
      .XPIPE_PIPE_CH14_TXCOMPLIANCE_M(q2q3_xpipe_pipe_ch14_txcompliance_m),
      .XPIPE_PIPE_CH14_TXDATAVALID_M (q2q3_xpipe_pipe_ch14_txdatavalid_m),
      .XPIPE_PIPE_CH14_TXDATA_M      (q2q3_xpipe_pipe_ch14_txdata_m),
      .XPIPE_PIPE_CH14_TXDEEMPH_M    (q2q3_xpipe_pipe_ch14_txdeemph_m),
      .XPIPE_PIPE_CH14_TXELECIDLE_M  (q2q3_xpipe_pipe_ch14_txelecidle_m),
      .XPIPE_PIPE_CH14_TXMAINCURSOR_M(q2q3_xpipe_pipe_ch14_txmaincursor_m),
      .XPIPE_PIPE_CH14_TXMARGIN_M    (q2q3_xpipe_pipe_ch14_txmargin_m),
      .XPIPE_PIPE_CH14_TXPOSTCURSOR_M(q2q3_xpipe_pipe_ch14_txpostcursor_m),
      .XPIPE_PIPE_CH14_TXPRECURSOR_M (q2q3_xpipe_pipe_ch14_txprecursor_m),
      .XPIPE_PIPE_CH14_TXSTARTBLOCK_M(q2q3_xpipe_pipe_ch14_txstartblock_m),
      .XPIPE_PIPE_CH14_TXSWING_M     (q2q3_xpipe_pipe_ch14_txswing_m),
      .XPIPE_PIPE_CH14_TXSYNCHEADER_M(q2q3_xpipe_pipe_ch14_txsyncheader_m),
      .XPIPE_PIPE_CH14_PHYSTATUS_M   (q2q3_xpipe_pipe_ch14_phystatus_m),
      .XPIPE_PIPE_CH14_RXCHARISK_M   (q2q3_xpipe_pipe_ch14_rxcharisk_m),
      .XPIPE_PIPE_CH14_RXDATAVALID_M (q2q3_xpipe_pipe_ch14_rxdatavalid_m),
      .XPIPE_PIPE_CH14_RXDATA_M      (q2q3_xpipe_pipe_ch14_rxdata_m),
      .XPIPE_PIPE_CH14_RXELECIDLE_M  (q2q3_xpipe_pipe_ch14_rxelecidle_m),
      .XPIPE_PIPE_CH14_RXSTARTBLOCK_M(q2q3_xpipe_pipe_ch14_rxstartblock_m),
      .XPIPE_PIPE_CH14_RXSTATUS_M    (q2q3_xpipe_pipe_ch14_rxstatus_m),
      .XPIPE_PIPE_CH14_RXSYNCHEADER_M(q2q3_xpipe_pipe_ch14_rxsyncheader_m),
      .XPIPE_PIPE_CH14_RXVALID_M     (q2q3_xpipe_pipe_ch14_rxvalid_m),
      .XPIPE_PIPE_CH14_TXDETECTRXLOOPBACK_M(q2q3_xpipe_pipe_ch14_txdetectrxloopback_m),

      .XPIPE_PIPE_CH15_PHYSTATUS     (q1q2_xpipe_pipe_ch15_phystatus_m),
      .XPIPE_PIPE_CH15_RXCHARISK     (q1q2_xpipe_pipe_ch15_rxcharisk_m),
      .XPIPE_PIPE_CH15_RXDATA        (q1q2_xpipe_pipe_ch15_rxdata_m), 
      .XPIPE_PIPE_CH15_RXDATAVALID   (q1q2_xpipe_pipe_ch15_rxdatavalid_m),
      .XPIPE_PIPE_CH15_RXELECIDLE    (q1q2_xpipe_pipe_ch15_rxelecidle_m),
      .XPIPE_PIPE_CH15_RXSTARTBLOCK  (q1q2_xpipe_pipe_ch15_rxstartblock_m),
      .XPIPE_PIPE_CH15_RXSTATUS      (q1q2_xpipe_pipe_ch15_rxstatus_m),
      .XPIPE_PIPE_CH15_RXSYNCHEADER  (q1q2_xpipe_pipe_ch15_rxsyncheader_m),
      .XPIPE_PIPE_CH15_RXVALID       (q1q2_xpipe_pipe_ch15_rxvalid_m),
      .XPIPE_PIPE_CH15_POWERDOWN     (q1q2_xpipe_pipe_ch15_powerdown_m),
      .XPIPE_PIPE_CH15_RXPOLARITY    (q1q2_xpipe_pipe_ch15_rxpolarity_m),
      .XPIPE_PIPE_CH15_RXTERMINATION (q1q2_xpipe_pipe_ch15_rxtermination_m),
      .XPIPE_PIPE_CH15_TXCHARISK     (q1q2_xpipe_pipe_ch15_txcharisk_m),
      .XPIPE_PIPE_CH15_TXCOMPLIANCE  (q1q2_xpipe_pipe_ch15_txcompliance_m),
      .XPIPE_PIPE_CH15_TXDATA        (q1q2_xpipe_pipe_ch15_txdata_m),
      .XPIPE_PIPE_CH15_TXDATAVALID   (q1q2_xpipe_pipe_ch15_txdatavalid_m),
      .XPIPE_PIPE_CH15_TXDEEMPH      (q1q2_xpipe_pipe_ch15_txdeemph_m),
      .XPIPE_PIPE_CH15_TXDETECTRXLOOPBACK(q1q2_xpipe_pipe_ch15_txdetectrxloopback_m),
      .XPIPE_PIPE_CH15_TXELECIDLE    (q1q2_xpipe_pipe_ch15_txelecidle_m),
      .XPIPE_PIPE_CH15_TXMAINCURSOR  (q1q2_xpipe_pipe_ch15_txmaincursor_m),
      .XPIPE_PIPE_CH15_TXMARGIN      (q1q2_xpipe_pipe_ch15_txmargin_m),
      .XPIPE_PIPE_CH15_TXPOSTCURSOR  (q1q2_xpipe_pipe_ch15_txpostcursor_m),
      .XPIPE_PIPE_CH15_TXPRECURSOR   (q1q2_xpipe_pipe_ch15_txprecursor_m),
      .XPIPE_PIPE_CH15_TXSTARTBLOCK  (q1q2_xpipe_pipe_ch15_txstartblock_m),
      .XPIPE_PIPE_CH15_TXSWING       (q1q2_xpipe_pipe_ch15_txswing_m),
      .XPIPE_PIPE_CH15_TXSYNCHEADER  (q1q2_xpipe_pipe_ch15_txsyncheader_m),

      .XPIPE_PIPE_CH15_POWERDOWN_M   (q2q3_xpipe_pipe_ch15_powerdown_m),
      .XPIPE_PIPE_CH15_RXPOLARITY_M  (q2q3_xpipe_pipe_ch15_rxpolarity_m),
      .XPIPE_PIPE_CH15_RXTERMINATION_M(q2q3_xpipe_pipe_ch15_rxtermination_m),
      .XPIPE_PIPE_CH15_TXCHARISK_M   (q2q3_xpipe_pipe_ch15_txcharisk_m),
      .XPIPE_PIPE_CH15_TXCOMPLIANCE_M(q2q3_xpipe_pipe_ch15_txcompliance_m),
      .XPIPE_PIPE_CH15_TXDATAVALID_M (q2q3_xpipe_pipe_ch15_txdatavalid_m),
      .XPIPE_PIPE_CH15_TXDATA_M      (q2q3_xpipe_pipe_ch15_txdata_m),
      .XPIPE_PIPE_CH15_TXDEEMPH_M    (q2q3_xpipe_pipe_ch15_txdeemph_m),
      .XPIPE_PIPE_CH15_TXELECIDLE_M  (q2q3_xpipe_pipe_ch15_txelecidle_m),
      .XPIPE_PIPE_CH15_TXMAINCURSOR_M(q2q3_xpipe_pipe_ch15_txmaincursor_m),
      .XPIPE_PIPE_CH15_TXMARGIN_M    (q2q3_xpipe_pipe_ch15_txmargin_m),
      .XPIPE_PIPE_CH15_TXPOSTCURSOR_M(q2q3_xpipe_pipe_ch15_txpostcursor_m),
      .XPIPE_PIPE_CH15_TXPRECURSOR_M (q2q3_xpipe_pipe_ch15_txprecursor_m),
      .XPIPE_PIPE_CH15_TXSTARTBLOCK_M(q2q3_xpipe_pipe_ch15_txstartblock_m),
      .XPIPE_PIPE_CH15_TXSWING_M     (q2q3_xpipe_pipe_ch15_txswing_m),
      .XPIPE_PIPE_CH15_TXSYNCHEADER_M(q2q3_xpipe_pipe_ch15_txsyncheader_m),
      .XPIPE_PIPE_CH15_PHYSTATUS_M   (q2q3_xpipe_pipe_ch15_phystatus_m),
      .XPIPE_PIPE_CH15_RXCHARISK_M   (q2q3_xpipe_pipe_ch15_rxcharisk_m),
      .XPIPE_PIPE_CH15_RXDATAVALID_M (q2q3_xpipe_pipe_ch15_rxdatavalid_m),
      .XPIPE_PIPE_CH15_RXDATA_M      (q2q3_xpipe_pipe_ch15_rxdata_m),
      .XPIPE_PIPE_CH15_RXELECIDLE_M  (q2q3_xpipe_pipe_ch15_rxelecidle_m),
      .XPIPE_PIPE_CH15_RXSTARTBLOCK_M(q2q3_xpipe_pipe_ch15_rxstartblock_m),
      .XPIPE_PIPE_CH15_RXSTATUS_M    (q2q3_xpipe_pipe_ch15_rxstatus_m),
      .XPIPE_PIPE_CH15_RXSYNCHEADER_M(q2q3_xpipe_pipe_ch15_rxsyncheader_m),
      .XPIPE_PIPE_CH15_RXVALID_M     (q2q3_xpipe_pipe_ch15_rxvalid_m),
      .XPIPE_PIPE_CH15_TXDETECTRXLOOPBACK_M(q2q3_xpipe_pipe_ch15_txdetectrxloopback_m)
    );
  end

  if ( C_XPIPE_3_INSTANTIATED == 1 ) begin

    XPIPE_QUAD #(
      .XPIPE_LOC       (C_XPIPE_3_LOC),
      .XPIPE_MODE      (C_XPIPE_3_MODE),
      .XPIPE_RSVD      (C_XPIPE_3_RSVD),
      .XPIPE_LINK0_CFG (C_XPIPE_3_LINK0_CFG),
      .XPIPE_LINK1_CFG (C_XPIPE_3_LINK1_CFG),
      .XPIPE_CLK_CFG   (C_XPIPE_3_CLK_CFG),
      .XPIPE_CLKDLY_CFG(C_XPIPE_3_CLKDLY_CFG),
      .XPIPE_REG_CFG   (C_XPIPE_3_REG_CFG)
    ) XPIPE_QUAD3_inst (
      .XPIPE_GT_OUTCLK   (q2q3_xpipe_gt_outclk_m),
      .XPIPE_GT_OUTCLK_1 (q2q3_xpipe_gt_outclk_m_1),
      .XPIPE_GT_RXOUTCLK (q2q3_xpipe_gt_rxoutclk_m),
      .XPIPE_GT_RXUSRCLK (q2q3_xpipe_gt_rxusrclk_m),
      .XPIPE_GT_PIPECLK  (q2q3_xpipe_gt_pipeclk_m),
      .XPIPE_GT_PIPECLK_1(q2q3_xpipe_gt_pipeclk_m_1),

      .XPIPE_PHYESMADAPTSAVE    (q2q3_xpipe_phyesmadaptsave_m),
      .XPIPE_PHYESMADAPTSAVE_1  (q2q3_xpipe_phyesmadaptsave_m_1),
      .XPIPE_PHYESMADAPTSAVE_M  (q3q4_xpipe_phyesmadaptsave_m),
      .XPIPE_PHYESMADAPTSAVE_M_1(q3q4_xpipe_phyesmadaptsave_m_1),

      .XPIPE_BUFGTCE     (q2q3_xpipe_bufgtce_m),
      .XPIPE_BUFGTCE_1   (q2q3_xpipe_bufgtce_m_1),
      .XPIPE_BUFGTCE_MASK(q2q3_xpipe_bufgtce_mask_m),
      .XPIPE_BUFGTCE_MASK_1(q2q3_xpipe_bufgtce_mask_m_1),
      .XPIPE_BUFGTDIV    (q2q3_xpipe_bufgtdiv_m),
      .XPIPE_BUFGTDIV_1  (q2q3_xpipe_bufgtdiv_m_1),
      .XPIPE_BUFGTRST    (q2q3_xpipe_bufgtrst_m),
      .XPIPE_BUFGTRST_1  (q2q3_xpipe_bufgtrst_m_1),
      .XPIPE_BUFGTRST_MASK(q2q3_xpipe_bufgtrst_mask_m),
      .XPIPE_BUFGTRST_MASK_1(q2q3_xpipe_bufgtrst_mask_m_1),

      .XPIPE_PCIE_PERST_N     (q2q3_xpipe_pcie_perst_n_m),
      .XPIPE_PCIE_PERST_N_1   (q2q3_xpipe_pcie_perst_n_m_1),
      .XPIPE_PCIE_PERST_N_M   (q3q4_xpipe_pcie_perst_n_m),
      .XPIPE_PCIE_PERST_N_M_1 (q3q4_xpipe_pcie_perst_n_m_1),

      .XPIPE_PCIE_RATE    (q2q3_xpipe_pcie_rate_m),
      .XPIPE_PCIE_RATE_1  (q2q3_xpipe_pcie_rate_m_1),
      .XPIPE_PCIE_RATE_M  (q3q4_xpipe_pcie_rate_m),
      .XPIPE_PCIE_RATE_M_1(q3q4_xpipe_pcie_rate_m_1),

      .XPIPE_GT_OUTCLK_M     (q3q4_xpipe_gt_outclk_m),
      .XPIPE_GT_OUTCLK_M_1   (q3q4_xpipe_gt_outclk_m_1),
      .XPIPE_GT_RXOUTCLK_M   (q3q4_xpipe_gt_rxoutclk_m),
      .XPIPE_GT_RXUSRCLK_M   (q3q4_xpipe_gt_rxusrclk_m),
      .XPIPE_GT_PIPECLK_M    (q3q4_xpipe_gt_pipeclk_m),
      .XPIPE_GT_PIPECLK_M_1  (q3q4_xpipe_gt_pipeclk_m_1),
      .XPIPE_BUFGTCE_M       (q3q4_xpipe_bufgtce_m),
      .XPIPE_BUFGTCE_MASK_M  (q3q4_xpipe_bufgtce_mask_m),
      .XPIPE_BUFGTCE_MASK_M_1(q3q4_xpipe_bufgtce_mask_m_1),
      .XPIPE_BUFGTCE_M_1     (q3q4_xpipe_bufgtce_m_1),
      .XPIPE_BUFGTDIV_M      (q3q4_xpipe_bufgtdiv_m),
      .XPIPE_BUFGTDIV_M_1    (q3q4_xpipe_bufgtdiv_m_1),
      .XPIPE_BUFGTRST_M      (q3q4_xpipe_bufgtrst_m),
      .XPIPE_BUFGTRST_MASK_M (q3q4_xpipe_bufgtrst_mask_m),
      .XPIPE_BUFGTRST_MASK_M_1(q3q4_xpipe_bufgtrst_mask_m_1),
      .XPIPE_BUFGTRST_M_1    (q3q4_xpipe_bufgtrst_m_1),

      .XPIPE_PHYREADY_FR_BOT_M(q3q4_xpipe_phyready_fr_bot_m),
      .XPIPE_PHYREADY_TO_BOT (q2q3_xpipe_phyready_to_bot_m),
      .XPIPE_PHY_READY       (q2q3_xpipe_phy_ready_m),
      .XPIPE_PHY_READY_1     (q2q3_xpipe_phy_ready_m_1),
      .XPIPE_PHYREADY_FR_BOT (q2q3_xpipe_phyready_fr_bot_m),
      .XPIPE_PHYREADY_TO_BOT_M(q3q4_xpipe_phyready_to_bot_m),
      .XPIPE_PHY_READY_M     (q3q4_xpipe_phy_ready_m),
      .XPIPE_PHY_READY_M_1   (q3q4_xpipe_phy_ready_m_1),

      .ALTCLK_M      (q3_altclk_m),
      .APB3PADDR_M   (q3_apb3paddr_m),
      .APB3CLK_M     (q3_apb3clk_m),
      .AXISCLK_M     (q3_axisclk_m),
      .APB3PENABLE_M (q3_apb3penable_m),
      .APB3PRESETN_M (q3_apb3presetn_m),
      .APB3PSEL_M    (q3_apb3psel_m),
      .APB3PWDATA_M  (q3_apb3pwdata_m),
      .APB3PWRITE_M  (q3_apb3pwrite_m),

      .BGBYPASSB_M   (q3_bgbypassb_m),
      .BGMONITORENB_M(q3_bgmonitorenb_m),
      .BGPDB_M       (q3_bgpdb_m),
      .BGRCALOVRDENB_M(q3_bgrcalovrdenb_m),
      .BGRCALOVRD_M  (q3_bgrcalovrd_m),

      .CH0_CDRBMCDRREQ_M     (ch12_cdrbmcdrreq_m),
      .CH0_RXUSRCLK_M        (ch12_rxusrclk_m),
      .CH0_RXOUTCLK_M        (ch12_rxoutclk_m),
      .CH0_CDRFREQOS_M       (ch12_cdrfreqos_m),
      .CH0_CDRINCPCTRL_M     (ch12_cdrincpctrl_m),
      .CH0_CDRSTEPDIR_M      (ch12_cdrstepdir_m),
      .CH0_CDRSTEPSQ_M       (ch12_cdrstepsq_m),
      .CH0_CDRSTEPSX_M       (ch12_cdrstepsx_m),
    //.CH0_CFOKOVWRFINISH_M  (ch12_cfokovwrfinish_m),
    //.CH0_CFOKOVWRPULSE_M   (ch12_cfokovwrpulse_m),
    //.CH0_CFOKOVWRSTART_M   (ch12_cfokovwrstart_m),
      .CH0_CLKRSVD0_M        (ch12_clkrsvd0_m),
      .CH0_CLKRSVD1_M        (ch12_clkrsvd1_m),
      .CH0_DMONFIFORESET_M   (ch12_dmonfiforeset_m),
      .CH0_DMONITORCLK_M     (ch12_dmonitorclk_m),
      .CH0_EYESCANRESET_M    (ch12_eyescanreset_m),
      .CH0_EYESCANTRIGGER_M  (ch12_eyescantrigger_m),
      .CH0_GTRSVD_M          (ch12_gtrsvd_m),
      .CH0_GTRXRESET_M       (ch12_gtrxreset_m),
      .CH0_GTTXRESET_M       (ch12_gttxreset_m),
      .CH0_HSDPPCSRESET_M    (ch12_hsdppcsreset_m),
      .CH0_ILORESETMASK_M    (ch12_iloresetmask_m),
      .CH0_ILORESET_M        (ch12_iloreset_m),
      .CH0_LOOPBACK_M        (ch12_loopback_m),
      .CH0_PCIERSTB_M        (ch12_pcierstb_m),
      .CH0_PCSRSVDIN_M       (ch12_pcsrsvdin_m),
      .CH0_PHYESMADAPTSAVE_M (ch12_phyesmadaptsave_m),
      .CH0_RXCDRHOLD_M       (ch12_rxcdrhold_m),
      .CH0_RXCDROVRDEN_M     (ch12_rxcdrovrden_m),
      .CH0_RXCDRRESET_M      (ch12_rxcdrreset_m),
      .CH0_RXCHBONDI_M       (ch12_rxchbondi_m),
      .CH0_RXDAPICODEOVRDEN_M(ch12_rxdapicodeovrden_m),
      .CH0_RXDAPICODERESET_M (ch12_rxdapicodereset_m),
      .CH0_RXDLYALIGNREQ_M   (ch12_rxdlyalignreq_m),
      .CH0_RXEQTRAINING_M    (ch12_rxeqtraining_m),
      .CH0_RXGEARBOXSLIP_M   (ch12_rxgearboxslip_m),
      .CH0_RXLATCLK_M        (ch12_rxlatclk_m),
      .CH0_RXLPMEN_M         (ch12_rxlpmen_m),
      .CH0_RXMLDCHAINDONE_M  (ch12_rxmldchaindone_m),
      .CH0_RXMLDCHAINREQ_M   (ch12_rxmldchainreq_m),
      .CH0_RXMLFINEALIGNREQ_M(ch12_rxmlfinealignreq_m),
      .CH0_RXOOBRESET_M      (ch12_rxoobreset_m),
      .CH0_RXPCSRESETMASK_M  (ch12_rxpcsresetmask_m),
      .CH0_RXPD_M            (ch12_rxpd_m),
      .CH0_RXPHALIGNREQ_M    (ch12_rxphalignreq_m),
      .CH0_RXPHALIGNRESETMASK_M(ch12_rxphalignresetmask_m),
      .CH0_RXPHDLYPD_M       (ch12_rxphdlypd_m),
      .CH0_RXPHDLYRESET_M    (ch12_rxphdlyreset_m),
      .CH0_RXPHSETINITREQ_M  (ch12_rxphsetinitreq_m),
      .CH0_RXPHSHIFT180_M    (ch12_rxphshift180_m),
      .CH0_RXPMARESETMASK_M  (ch12_rxpmaresetmask_m),
      .CH0_RXPOLARITY_M      (ch12_rxpolarity_m),
      .CH0_RXPRBSCNTRESET_M  (ch12_rxprbscntreset_m),
      .CH0_RXPRBSSEL_M       (ch12_rxprbssel_m),
      .CH0_RXPROGDIVRESET_M  (ch12_rxprogdivreset_m),
      .CH0_RXRATE_M          (ch12_rxrate_m),
      .CH0_RXRESETMODE_M     (ch12_rxresetmode_m),
      .CH0_RXSLIDE_M         (ch12_rxslide_m),
      .CH0_RXSYNCALLIN_M     (ch12_rxsyncallin_m),
      .CH0_RXTERMINATION_M   (ch12_rxtermination_m),
      .CH0_RXUSERRDY_M       (ch12_rxuserrdy_m),
      .CH0_TSTIN_M           (ch12_tstin_m),
      .CH0_TXCOMINIT_M       (ch12_txcominit_m),
      .CH0_TXCOMSAS_M        (ch12_txcomsas_m),
      .CH0_TXCOMWAKE_M       (ch12_txcomwake_m),
      .CH0_TXCTRL0_M         (ch12_txctrl0_m),
      .CH0_TXCTRL1_M         (ch12_txctrl1_m),
      .CH0_TXCTRL2_M         (ch12_txctrl2_m),
      .CH0_TXDAPICODEOVRDEN_M(ch12_txdapicodeovrden_m),
      .CH0_TXDAPICODERESET_M (ch12_txdapicodereset_m),
      .CH0_TXDATAEXTENDRSVD_M(ch12_txdataextendrsvd_m),
      .CH0_TXDATA_M          (ch12_txdata_m),
      .CH0_TXDEEMPH_M        (ch12_txdeemph_m),
      .CH0_TXDETECTRX_M      (ch12_txdetectrx_m),
      .CH0_TXDIFFCTRL_M      (ch12_txdiffctrl_m),
      .CH0_TXDLYALIGNREQ_M   (ch12_txdlyalignreq_m),
      .CH0_TXELECIDLE_M      (ch12_txelecidle_m),
      .CH0_TXHEADER_M        (ch12_txheader_m),
      .CH0_TXINHIBIT_M       (ch12_txinhibit_m),
      .CH0_TXLATCLK_M        (ch12_txlatclk_m),
      .CH0_TXMAINCURSOR_M    (ch12_txmaincursor_m),
      .CH0_TXMARGIN_M        (ch12_txmargin_m),
      .CH0_TXMLDCHAINDONE_M  (ch12_txmldchaindone_m),
      .CH0_TXMLDCHAINREQ_M   (ch12_txmldchainreq_m),
      .CH0_TXONESZEROS_M     (ch12_txoneszeros_m),
      .CH0_TXPAUSEDELAYALIGN_M(ch12_txpausedelayalign_m),
      .CH0_TXPCSRESETMASK_M  (ch12_txpcsresetmask_m),
      .CH0_TXPD_M            (ch12_txpd_m),
      .CH0_TXPHALIGNREQ_M    (ch12_txphalignreq_m),
      .CH0_TXPHALIGNRESETMASK_M(ch12_txphalignresetmask_m),
      .CH0_TXPHDLYPD_M       (ch12_txphdlypd_m),
      .CH0_TXPHDLYRESET_M    (ch12_txphdlyreset_m),
      .CH0_TXPHDLYTSTCLK_M   (ch12_txphdlytstclk_m),
      .CH0_TXPHSETINITREQ_M  (ch12_txphsetinitreq_m),
      .CH0_TXPHSHIFT180_M    (ch12_txphshift180_m),
      .CH0_TXPICODEOVRDEN_M  (ch12_txpicodeovrden_m),
      .CH0_TXPICODERESET_M   (ch12_txpicodereset_m),
      .CH0_TXPIPPMEN_M       (ch12_txpippmen_m),
      .CH0_TXPIPPMSTEPSIZE_M (ch12_txpippmstepsize_m),
      .CH0_TXPISOPD_M        (ch12_txpisopd_m),
      .CH0_TXPMARESETMASK_M  (ch12_txpmaresetmask_m),
      .CH0_TXPOLARITY_M      (ch12_txpolarity_m),
      .CH0_TXPOSTCURSOR_M    (ch12_txpostcursor_m),
      .CH0_TXPRBSFORCEERR_M  (ch12_txprbsforceerr_m),
      .CH0_TXPRBSSEL_M       (ch12_txprbssel_m),
      .CH0_TXPRECURSOR_M     (ch12_txprecursor_m),
      .CH0_TXPROGDIVRESET_M  (ch12_txprogdivreset_m),
      .CH0_TXRATE_M          (ch12_txrate_m),
      .CH0_TXRESETMODE_M     (ch12_txresetmode_m),
      .CH0_TXSEQUENCE_M      (ch12_txsequence_m),
      .CH0_TXSWING_M         (ch12_txswing_m),
      .CH0_TXSYNCALLIN_M     (ch12_txsyncallin_m),
      .CH0_TXUSERRDY_M       (ch12_txuserrdy_m),
      .CH0_TXUSRCLK_M        (ch12_txusrclk_m),
      .CH1_CDRBMCDRREQ_M     (ch13_cdrbmcdrreq_m),
      .CH1_CDRFREQOS_M       (ch13_cdrfreqos_m),
      .CH1_CDRINCPCTRL_M     (ch13_cdrincpctrl_m),
      .CH1_CDRSTEPDIR_M      (ch13_cdrstepdir_m),
      .CH1_CDRSTEPSQ_M       (ch13_cdrstepsq_m),
      .CH1_CDRSTEPSX_M       (ch13_cdrstepsx_m),
    //.CH1_CFOKOVWRFINISH_M  (ch13_cfokovwrfinish_m),
    //.CH1_CFOKOVWRPULSE_M   (ch13_cfokovwrpulse_m),
    //.CH1_CFOKOVWRSTART_M   (ch13_cfokovwrstart_m),
      .CH1_CLKRSVD0_M        (ch13_clkrsvd0_m),
      .CH1_CLKRSVD1_M        (ch13_clkrsvd1_m),
      .CH1_DMONFIFORESET_M   (ch13_dmonfiforeset_m),
      .CH1_DMONITORCLK_M     (ch13_dmonitorclk_m),
      .CH1_EYESCANRESET_M    (ch13_eyescanreset_m),
      .CH1_EYESCANTRIGGER_M  (ch13_eyescantrigger_m),
      .CH1_GTRSVD_M          (ch13_gtrsvd_m),
      .CH1_GTRXRESET_M       (ch13_gtrxreset_m),
      .CH1_GTTXRESET_M       (ch13_gttxreset_m),
      .CH1_HSDPPCSRESET_M    (ch13_hsdppcsreset_m),
      .CH1_ILORESETMASK_M    (ch13_iloresetmask_m),
      .CH1_ILORESET_M        (ch13_iloreset_m),
      .CH1_LOOPBACK_M        (ch13_loopback_m),
      .CH1_PCIERSTB_M        (ch13_pcierstb_m),
      .CH1_PCSRSVDIN_M       (ch13_pcsrsvdin_m),
      .CH1_PHYESMADAPTSAVE_M (ch13_phyesmadaptsave_m),
      .CH1_RXCDRHOLD_M       (ch13_rxcdrhold_m),
      .CH1_RXCDROVRDEN_M     (ch13_rxcdrovrden_m),
      .CH1_RXCDRRESET_M      (ch13_rxcdrreset_m),
      .CH1_RXCHBONDI_M       (ch13_rxchbondi_m),
      .CH1_RXDAPICODEOVRDEN_M(ch13_rxdapicodeovrden_m),
      .CH1_RXDAPICODERESET_M (ch13_rxdapicodereset_m),
      .CH1_RXDLYALIGNREQ_M   (ch13_rxdlyalignreq_m),
      .CH1_RXEQTRAINING_M    (ch13_rxeqtraining_m),
      .CH1_RXGEARBOXSLIP_M   (ch13_rxgearboxslip_m),
      .CH1_RXLATCLK_M        (ch13_rxlatclk_m),
      .CH1_RXLPMEN_M         (ch13_rxlpmen_m),
      .CH1_RXMLDCHAINDONE_M  (ch13_rxmldchaindone_m),
      .CH1_RXMLDCHAINREQ_M   (ch13_rxmldchainreq_m),
      .CH1_RXMLFINEALIGNREQ_M(ch13_rxmlfinealignreq_m),
      .CH1_RXOOBRESET_M      (ch13_rxoobreset_m),
      .CH1_RXPCSRESETMASK_M  (ch13_rxpcsresetmask_m),
      .CH1_RXPD_M            (ch13_rxpd_m),
      .CH1_RXPHALIGNREQ_M    (ch13_rxphalignreq_m),
      .CH1_RXPHALIGNRESETMASK_M(ch13_rxphalignresetmask_m),
      .CH1_RXPHDLYPD_M       (ch13_rxphdlypd_m),
      .CH1_RXPHDLYRESET_M    (ch13_rxphdlyreset_m),
      .CH1_RXPHSETINITREQ_M  (ch13_rxphsetinitreq_m),
      .CH1_RXPHSHIFT180_M    (ch13_rxphshift180_m),
      .CH1_RXPMARESETMASK_M  (ch13_rxpmaresetmask_m),
      .CH1_RXPOLARITY_M      (ch13_rxpolarity_m),
      .CH1_RXPRBSCNTRESET_M  (ch13_rxprbscntreset_m),
      .CH1_RXPRBSSEL_M       (ch13_rxprbssel_m),
      .CH1_RXPROGDIVRESET_M  (ch13_rxprogdivreset_m),
      .CH1_RXRATE_M          (ch13_rxrate_m),
      .CH1_RXRESETMODE_M     (ch13_rxresetmode_m),
      .CH1_RXSLIDE_M         (ch13_rxslide_m),
      .CH1_RXSYNCALLIN_M     (ch13_rxsyncallin_m),
      .CH1_RXTERMINATION_M   (ch13_rxtermination_m),
      .CH1_RXUSERRDY_M       (ch13_rxuserrdy_m),
      .CH1_RXUSRCLK_M        (ch13_rxusrclk_m),
      .CH1_TSTIN_M           (ch13_tstin_m),
      .CH1_TXCOMINIT_M       (ch13_txcominit_m),
      .CH1_TXCOMSAS_M        (ch13_txcomsas_m),
      .CH1_TXCOMWAKE_M       (ch13_txcomwake_m),
      .CH1_TXCTRL0_M         (ch13_txctrl0_m),
      .CH1_TXCTRL1_M         (ch13_txctrl1_m),
      .CH1_TXCTRL2_M         (ch13_txctrl2_m),
      .CH1_TXDAPICODEOVRDEN_M(ch13_txdapicodeovrden_m),
      .CH1_TXDAPICODERESET_M (ch13_txdapicodereset_m),
      .CH1_TXDATAEXTENDRSVD_M(ch13_txdataextendrsvd_m),
      .CH1_TXDATA_M          (ch13_txdata_m),
      .CH1_TXDEEMPH_M        (ch13_txdeemph_m),
      .CH1_TXDETECTRX_M      (ch13_txdetectrx_m),
      .CH1_TXDIFFCTRL_M      (ch13_txdiffctrl_m),
      .CH1_TXDLYALIGNREQ_M   (ch13_txdlyalignreq_m),
      .CH1_TXELECIDLE_M      (ch13_txelecidle_m),
      .CH1_TXHEADER_M        (ch13_txheader_m),
      .CH1_TXINHIBIT_M       (ch13_txinhibit_m),
      .CH1_TXLATCLK_M        (ch13_txlatclk_m),
      .CH1_TXMAINCURSOR_M    (ch13_txmaincursor_m),
      .CH1_TXMARGIN_M        (ch13_txmargin_m),
      .CH1_TXMLDCHAINDONE_M  (ch13_txmldchaindone_m),
      .CH1_TXMLDCHAINREQ_M   (ch13_txmldchainreq_m),
      .CH1_TXONESZEROS_M     (ch13_txoneszeros_m),
      .CH1_TXPAUSEDELAYALIGN_M(ch13_txpausedelayalign_m),
      .CH1_TXPCSRESETMASK_M  (ch13_txpcsresetmask_m),
      .CH1_TXPD_M            (ch13_txpd_m),
      .CH1_TXPHALIGNREQ_M    (ch13_txphalignreq_m),
      .CH1_TXPHALIGNRESETMASK_M(ch13_txphalignresetmask_m),
      .CH1_TXPHDLYPD_M       (ch13_txphdlypd_m),
      .CH1_TXPHDLYRESET_M    (ch13_txphdlyreset_m),
      .CH1_TXPHDLYTSTCLK_M   (ch13_txphdlytstclk_m),
      .CH1_TXPHSETINITREQ_M  (ch13_txphsetinitreq_m),
      .CH1_TXPHSHIFT180_M    (ch13_txphshift180_m),
      .CH1_TXPICODEOVRDEN_M  (ch13_txpicodeovrden_m),
      .CH1_TXPICODERESET_M   (ch13_txpicodereset_m),
      .CH1_TXPIPPMEN_M       (ch13_txpippmen_m),
      .CH1_TXPIPPMSTEPSIZE_M (ch13_txpippmstepsize_m),
      .CH1_TXPISOPD_M        (ch13_txpisopd_m),
      .CH1_TXPMARESETMASK_M  (ch13_txpmaresetmask_m),
      .CH1_TXPOLARITY_M      (ch13_txpolarity_m),
      .CH1_TXPOSTCURSOR_M    (ch13_txpostcursor_m),
      .CH1_TXPRBSFORCEERR_M  (ch13_txprbsforceerr_m),
      .CH1_TXPRBSSEL_M       (ch13_txprbssel_m),
      .CH1_TXPRECURSOR_M     (ch13_txprecursor_m),
      .CH1_TXPROGDIVRESET_M  (ch13_txprogdivreset_m),
      .CH1_TXRATE_M          (ch13_txrate_m),
      .CH1_TXRESETMODE_M     (ch13_txresetmode_m),
      .CH1_TXSEQUENCE_M      (ch13_txsequence_m),
      .CH1_TXSWING_M         (ch13_txswing_m),
      .CH1_TXSYNCALLIN_M     (ch13_txsyncallin_m),
      .CH1_TXUSERRDY_M       (ch13_txuserrdy_m),
      .CH1_TXUSRCLK_M        (ch13_txusrclk_m),
      .CH2_CDRBMCDRREQ_M     (ch14_cdrbmcdrreq_m),
      .CH2_CDRFREQOS_M       (ch14_cdrfreqos_m),
      .CH2_CDRINCPCTRL_M     (ch14_cdrincpctrl_m),
      .CH2_CDRSTEPDIR_M      (ch14_cdrstepdir_m),
      .CH2_CDRSTEPSQ_M       (ch14_cdrstepsq_m),
      .CH2_CDRSTEPSX_M       (ch14_cdrstepsx_m),
    //.CH2_CFOKOVWRFINISH_M  (ch14_cfokovwrfinish_m),
    //.CH2_CFOKOVWRPULSE_M   (ch14_cfokovwrpulse_m),
    //.CH2_CFOKOVWRSTART_M   (ch14_cfokovwrstart_m),
      .CH2_CLKRSVD0_M        (ch14_clkrsvd0_m),
      .CH2_CLKRSVD1_M        (ch14_clkrsvd1_m),
      .CH2_DMONFIFORESET_M   (ch14_dmonfiforeset_m),
      .CH2_DMONITORCLK_M     (ch14_dmonitorclk_m),
      .CH2_EYESCANRESET_M    (ch14_eyescanreset_m),
      .CH2_EYESCANTRIGGER_M  (ch14_eyescantrigger_m),
      .CH2_GTRSVD_M          (ch14_gtrsvd_m),
      .CH2_GTRXRESET_M       (ch14_gtrxreset_m),
      .CH2_GTTXRESET_M       (ch14_gttxreset_m),
      .CH2_HSDPPCSRESET_M    (ch14_hsdppcsreset_m),
      .CH2_ILORESETMASK_M    (ch14_iloresetmask_m),
      .CH2_ILORESET_M        (ch14_iloreset_m),
      .CH2_LOOPBACK_M        (ch14_loopback_m),
      .CH2_PCIERSTB_M        (ch14_pcierstb_m),
      .CH2_PCSRSVDIN_M       (ch14_pcsrsvdin_m),
      .CH2_PHYESMADAPTSAVE_M (ch14_phyesmadaptsave_m),
      .CH2_RXCDRHOLD_M       (ch14_rxcdrhold_m),
      .CH2_RXCDROVRDEN_M     (ch14_rxcdrovrden_m),
      .CH2_RXCDRRESET_M      (ch14_rxcdrreset_m),
      .CH2_RXCHBONDI_M       (ch14_rxchbondi_m),
      .CH2_RXDAPICODEOVRDEN_M(ch14_rxdapicodeovrden_m),
      .CH2_RXDAPICODERESET_M (ch14_rxdapicodereset_m),
      .CH2_RXDLYALIGNREQ_M   (ch14_rxdlyalignreq_m),
      .CH2_RXEQTRAINING_M    (ch14_rxeqtraining_m),
      .CH2_RXGEARBOXSLIP_M   (ch14_rxgearboxslip_m),
      .CH2_RXLATCLK_M        (ch14_rxlatclk_m),
      .CH2_RXLPMEN_M         (ch14_rxlpmen_m),
      .CH2_RXMLDCHAINDONE_M  (ch14_rxmldchaindone_m),
      .CH2_RXMLDCHAINREQ_M   (ch14_rxmldchainreq_m),
      .CH2_RXMLFINEALIGNREQ_M(ch14_rxmlfinealignreq_m),
      .CH2_RXOOBRESET_M      (ch14_rxoobreset_m),
      .CH2_RXPCSRESETMASK_M  (ch14_rxpcsresetmask_m),
      .CH2_RXPD_M            (ch14_rxpd_m),
      .CH2_RXPHALIGNREQ_M    (ch14_rxphalignreq_m),
      .CH2_RXPHALIGNRESETMASK_M(ch14_rxphalignresetmask_m),
      .CH2_RXPHDLYPD_M       (ch14_rxphdlypd_m),
      .CH2_RXPHDLYRESET_M    (ch14_rxphdlyreset_m),
      .CH2_RXPHSETINITREQ_M  (ch14_rxphsetinitreq_m),
      .CH2_RXPHSHIFT180_M    (ch14_rxphshift180_m),
      .CH2_RXPMARESETMASK_M  (ch14_rxpmaresetmask_m),
      .CH2_RXPOLARITY_M      (ch14_rxpolarity_m),
      .CH2_RXPRBSCNTRESET_M  (ch14_rxprbscntreset_m),
      .CH2_RXPRBSSEL_M       (ch14_rxprbssel_m),
      .CH2_RXPROGDIVRESET_M  (ch14_rxprogdivreset_m),
      .CH2_RXRATE_M          (ch14_rxrate_m),
      .CH2_RXRESETMODE_M     (ch14_rxresetmode_m),
      .CH2_RXSLIDE_M         (ch14_rxslide_m),
      .CH2_RXSYNCALLIN_M     (ch14_rxsyncallin_m),
      .CH2_RXTERMINATION_M   (ch14_rxtermination_m),
      .CH2_RXUSERRDY_M       (ch14_rxuserrdy_m),
      .CH2_RXUSRCLK_M        (ch14_rxusrclk_m),
      .CH2_TSTIN_M           (ch14_tstin_m),
      .CH2_TXCOMINIT_M       (ch14_txcominit_m),
      .CH2_TXCOMSAS_M        (ch14_txcomsas_m),
      .CH2_TXCOMWAKE_M       (ch14_txcomwake_m),
      .CH2_TXCTRL0_M         (ch14_txctrl0_m),
      .CH2_TXCTRL1_M         (ch14_txctrl1_m),
      .CH2_TXCTRL2_M         (ch14_txctrl2_m),
      .CH2_TXDAPICODEOVRDEN_M(ch14_txdapicodeovrden_m),
      .CH2_TXDAPICODERESET_M (ch14_txdapicodereset_m),
      .CH2_TXDATAEXTENDRSVD_M(ch14_txdataextendrsvd_m),
      .CH2_TXDATA_M          (ch14_txdata_m),
      .CH2_TXDEEMPH_M        (ch14_txdeemph_m),
      .CH2_TXDETECTRX_M      (ch14_txdetectrx_m),
      .CH2_TXDIFFCTRL_M      (ch14_txdiffctrl_m),
      .CH2_TXDLYALIGNREQ_M   (ch14_txdlyalignreq_m),
      .CH2_TXELECIDLE_M      (ch14_txelecidle_m),
      .CH2_TXHEADER_M        (ch14_txheader_m),
      .CH2_TXINHIBIT_M       (ch14_txinhibit_m),
      .CH2_TXLATCLK_M        (ch14_txlatclk_m),
      .CH2_TXMAINCURSOR_M    (ch14_txmaincursor_m),
      .CH2_TXMARGIN_M        (ch14_txmargin_m),
      .CH2_TXMLDCHAINDONE_M  (ch14_txmldchaindone_m),
      .CH2_TXMLDCHAINREQ_M   (ch14_txmldchainreq_m),
      .CH2_TXONESZEROS_M     (ch14_txoneszeros_m),
      .CH2_TXPAUSEDELAYALIGN_M(ch14_txpausedelayalign_m),
      .CH2_TXPCSRESETMASK_M  (ch14_txpcsresetmask_m),
      .CH2_TXPD_M            (ch14_txpd_m),
      .CH2_TXPHALIGNREQ_M    (ch14_txphalignreq_m),
      .CH2_TXPHALIGNRESETMASK_M(ch14_txphalignresetmask_m),
      .CH2_TXPHDLYPD_M       (ch14_txphdlypd_m),
      .CH2_TXPHDLYRESET_M    (ch14_txphdlyreset_m),
      .CH2_TXPHDLYTSTCLK_M   (ch14_txphdlytstclk_m),
      .CH2_TXPHSETINITREQ_M  (ch14_txphsetinitreq_m),
      .CH2_TXPHSHIFT180_M    (ch14_txphshift180_m),
      .CH2_TXPICODEOVRDEN_M  (ch14_txpicodeovrden_m),
      .CH2_TXPICODERESET_M   (ch14_txpicodereset_m),
      .CH2_TXPIPPMEN_M       (ch14_txpippmen_m),
      .CH2_TXPIPPMSTEPSIZE_M (ch14_txpippmstepsize_m),
      .CH2_TXPISOPD_M        (ch14_txpisopd_m),
      .CH2_TXPMARESETMASK_M  (ch14_txpmaresetmask_m),
      .CH2_TXPOLARITY_M      (ch14_txpolarity_m),
      .CH2_TXPOSTCURSOR_M    (ch14_txpostcursor_m),
      .CH2_TXPRBSFORCEERR_M  (ch14_txprbsforceerr_m),
      .CH2_TXPRBSSEL_M       (ch14_txprbssel_m),
      .CH2_TXPRECURSOR_M     (ch14_txprecursor_m),
      .CH2_TXPROGDIVRESET_M  (ch14_txprogdivreset_m),
      .CH2_TXRATE_M          (ch14_txrate_m),
      .CH2_TXRESETMODE_M     (ch14_txresetmode_m),
      .CH2_TXSEQUENCE_M      (ch14_txsequence_m),
      .CH2_TXSWING_M         (ch14_txswing_m),
      .CH2_TXSYNCALLIN_M     (ch14_txsyncallin_m),
      .CH2_TXUSERRDY_M       (ch14_txuserrdy_m),
      .CH2_TXUSRCLK_M        (ch14_txusrclk_m),
      .CH3_CDRBMCDRREQ_M     (ch15_cdrbmcdrreq_m),
      .CH3_CDRFREQOS_M       (ch15_cdrfreqos_m),
      .CH3_CDRINCPCTRL_M     (ch15_cdrincpctrl_m),
      .CH3_CDRSTEPDIR_M      (ch15_cdrstepdir_m),
      .CH3_CDRSTEPSQ_M       (ch15_cdrstepsq_m),
      .CH3_CDRSTEPSX_M       (ch15_cdrstepsx_m),
    //.CH3_CFOKOVWRFINISH_M  (ch15_cfokovwrfinish_m),
    //.CH3_CFOKOVWRPULSE_M   (ch15_cfokovwrpulse_m),
    //.CH3_CFOKOVWRSTART_M   (ch15_cfokovwrstart_m),
      .CH3_CLKRSVD0_M        (ch15_clkrsvd0_m),
      .CH3_CLKRSVD1_M        (ch15_clkrsvd1_m),
      .CH3_DMONFIFORESET_M   (ch15_dmonfiforeset_m),
      .CH3_DMONITORCLK_M     (ch15_dmonitorclk_m),
      .CH3_EYESCANRESET_M    (ch15_eyescanreset_m),
      .CH3_EYESCANTRIGGER_M  (ch15_eyescantrigger_m),
      .CH3_GTRSVD_M          (ch15_gtrsvd_m),
      .CH3_GTRXRESET_M       (ch15_gtrxreset_m),
      .CH3_GTTXRESET_M       (ch15_gttxreset_m),
      .CH3_HSDPPCSRESET_M    (ch15_hsdppcsreset_m),
      .CH3_ILORESETMASK_M    (ch15_iloresetmask_m),
      .CH3_ILORESET_M        (ch15_iloreset_m),
      .CH3_LOOPBACK_M        (ch15_loopback_m),
      .CH3_PCIERSTB_M        (ch15_pcierstb_m),
      .CH3_PCSRSVDIN_M       (ch15_pcsrsvdin_m),
      .CH3_PHYESMADAPTSAVE_M (ch15_phyesmadaptsave_m),
      .CH3_RXCDRHOLD_M       (ch15_rxcdrhold_m),
      .CH3_RXCDROVRDEN_M     (ch15_rxcdrovrden_m),
      .CH3_RXCDRRESET_M      (ch15_rxcdrreset_m),
      .CH3_RXCHBONDI_M       (ch15_rxchbondi_m),
      .CH3_RXDAPICODEOVRDEN_M(ch15_rxdapicodeovrden_m),
      .CH3_RXDAPICODERESET_M (ch15_rxdapicodereset_m),
      .CH3_RXDLYALIGNREQ_M   (ch15_rxdlyalignreq_m),
      .CH3_RXEQTRAINING_M    (ch15_rxeqtraining_m),
      .CH3_RXGEARBOXSLIP_M   (ch15_rxgearboxslip_m),
      .CH3_RXLATCLK_M        (ch15_rxlatclk_m),
      .CH3_RXLPMEN_M         (ch15_rxlpmen_m),
      .CH3_RXMLDCHAINDONE_M  (ch15_rxmldchaindone_m),
      .CH3_RXMLDCHAINREQ_M   (ch15_rxmldchainreq_m),
      .CH3_RXMLFINEALIGNREQ_M(ch15_rxmlfinealignreq_m),
      .CH3_RXOOBRESET_M      (ch15_rxoobreset_m),
      .CH3_RXPCSRESETMASK_M  (ch15_rxpcsresetmask_m),
      .CH3_RXPD_M            (ch15_rxpd_m),
      .CH3_RXPHALIGNREQ_M    (ch15_rxphalignreq_m),
      .CH3_RXPHALIGNRESETMASK_M(ch15_rxphalignresetmask_m),
      .CH3_RXPHDLYPD_M       (ch15_rxphdlypd_m),
      .CH3_RXPHDLYRESET_M    (ch15_rxphdlyreset_m),
      .CH3_RXPHSETINITREQ_M  (ch15_rxphsetinitreq_m),
      .CH3_RXPHSHIFT180_M    (ch15_rxphshift180_m),
      .CH3_RXPMARESETMASK_M  (ch15_rxpmaresetmask_m),
      .CH3_RXPOLARITY_M      (ch15_rxpolarity_m),
      .CH3_RXPRBSCNTRESET_M  (ch15_rxprbscntreset_m),
      .CH3_RXPRBSSEL_M       (ch15_rxprbssel_m),
      .CH3_RXPROGDIVRESET_M  (ch15_rxprogdivreset_m),
      .CH3_RXRATE_M          (ch15_rxrate_m),
      .CH3_RXRESETMODE_M     (ch15_rxresetmode_m),
      .CH3_RXSLIDE_M         (ch15_rxslide_m),
      .CH3_RXSYNCALLIN_M     (ch15_rxsyncallin_m),
      .CH3_RXTERMINATION_M   (ch15_rxtermination_m),
      .CH3_RXUSERRDY_M       (ch15_rxuserrdy_m),
      .CH3_RXUSRCLK_M        (ch15_rxusrclk_m),
      .CH3_TSTIN_M           (ch15_tstin_m),
      .CH3_TXCOMINIT_M       (ch15_txcominit_m),
      .CH3_TXCOMSAS_M        (ch15_txcomsas_m),
      .CH3_TXCOMWAKE_M       (ch15_txcomwake_m),
      .CH3_TXCTRL0_M         (ch15_txctrl0_m),
      .CH3_TXCTRL1_M         (ch15_txctrl1_m),
      .CH3_TXCTRL2_M         (ch15_txctrl2_m),
      .CH3_TXDAPICODEOVRDEN_M(ch15_txdapicodeovrden_m),
      .CH3_TXDAPICODERESET_M (ch15_txdapicodereset_m),
      .CH3_TXDATAEXTENDRSVD_M(ch15_txdataextendrsvd_m),
      .CH3_TXDATA_M          (ch15_txdata_m),
      .CH3_TXDEEMPH_M        (ch15_txdeemph_m),
      .CH3_TXDETECTRX_M      (ch15_txdetectrx_m),
      .CH3_TXDIFFCTRL_M      (ch15_txdiffctrl_m),
      .CH3_TXDLYALIGNREQ_M   (ch15_txdlyalignreq_m),
      .CH3_TXELECIDLE_M      (ch15_txelecidle_m),
      .CH3_TXHEADER_M        (ch15_txheader_m),
      .CH3_TXINHIBIT_M       (ch15_txinhibit_m),
      .CH3_TXLATCLK_M        (ch15_txlatclk_m),
      .CH3_TXMAINCURSOR_M    (ch15_txmaincursor_m),
      .CH3_TXMARGIN_M        (ch15_txmargin_m),
      .CH3_TXMLDCHAINDONE_M  (ch15_txmldchaindone_m),
      .CH3_TXMLDCHAINREQ_M   (ch15_txmldchainreq_m),
      .CH3_TXONESZEROS_M     (ch15_txoneszeros_m),
      .CH3_TXPAUSEDELAYALIGN_M(ch15_txpausedelayalign_m),
      .CH3_TXPCSRESETMASK_M  (ch15_txpcsresetmask_m),
      .CH3_TXPD_M            (ch15_txpd_m),
      .CH3_TXPHALIGNREQ_M    (ch15_txphalignreq_m),
      .CH3_TXPHALIGNRESETMASK_M(ch15_txphalignresetmask_m),
      .CH3_TXPHDLYPD_M       (ch15_txphdlypd_m),
      .CH3_TXPHDLYRESET_M    (ch15_txphdlyreset_m),
      .CH3_TXPHDLYTSTCLK_M   (ch15_txphdlytstclk_m),
      .CH3_TXPHSETINITREQ_M  (ch15_txphsetinitreq_m),
      .CH3_TXPHSHIFT180_M    (ch15_txphshift180_m),
      .CH3_TXPICODEOVRDEN_M  (ch15_txpicodeovrden_m),
      .CH3_TXPICODERESET_M   (ch15_txpicodereset_m),
      .CH3_TXPIPPMEN_M       (ch15_txpippmen_m),
      .CH3_TXPIPPMSTEPSIZE_M (ch15_txpippmstepsize_m),
      .CH3_TXPISOPD_M        (ch15_txpisopd_m),
      .CH3_TXPMARESETMASK_M  (ch15_txpmaresetmask_m),
      .CH3_TXPOLARITY_M      (ch15_txpolarity_m),
      .CH3_TXPOSTCURSOR_M    (ch15_txpostcursor_m),
      .CH3_TXPRBSFORCEERR_M  (ch15_txprbsforceerr_m),
      .CH3_TXPRBSSEL_M       (ch15_txprbssel_m),
      .CH3_TXPRECURSOR_M     (ch15_txprecursor_m),
      .CH3_TXPROGDIVRESET_M  (ch15_txprogdivreset_m),
      .CH3_TXRATE_M          (ch15_txrate_m),
      .CH3_TXRESETMODE_M     (ch15_txresetmode_m),
      .CH3_TXSEQUENCE_M      (ch15_txsequence_m),
      .CH3_TXSWING_M         (ch15_txswing_m),
      .CH3_TXSYNCALLIN_M     (ch15_txsyncallin_m),
      .CH3_TXUSERRDY_M       (ch15_txuserrdy_m),
      .CH3_TXUSRCLK_M        (ch15_txusrclk_m),

      .CTRLRSVDIN0_M(q3_ctrlrsvdin0_m),
      .CTRLRSVDIN1_M(q3_ctrlrsvdin1_m),

      .DEBUGTRACECLK_M(q3_debugtraceclk_m),
      .DEBUGTRACEREADY_M(q3_debugtracetready_m),

      .GPI_M(q3_gpi_m),

    //.HSCLK0_GTGREFCLK2LCPLL_M(q3_hsclk0_gtgrefclk2lcpll_m),
    //.HSCLK0_GTGREFCLK2RPLL_M (q3_hsclk0_gtgrefclk2rpll_m),
      .HSCLK0_LCPLLCLKRSVD0_M  (q3_hsclk0_lcpllclkrsvd0_m),
      .HSCLK0_LCPLLCLKRSVD1_M  (q3_hsclk0_lcpllclkrsvd1_m),
      .HSCLK0_LCPLLFBDIV_M     (q3_hsclk0_lcpllfbdiv_m),
      .HSCLK0_LCPLLPD_M        (q3_hsclk0_lcpllpd_m),
      .HSCLK0_LCPLLREFCLKSEL_M (q3_hsclk0_lcpllrefclksel_m),
      .HSCLK0_LCPLLRESETBYPASSMODE_M(q3_hsclk0_lcpllresetbypassmode_m),
      .HSCLK0_LCPLLRESETMASK_M (q3_hsclk0_lcpllresetmask_m),
      .HSCLK0_LCPLLRESET_M     (q3_hsclk0_lcpllreset_m),
      .HSCLK0_LCPLLRSVD0_M     (q3_hsclk0_lcpllrsvd0_m),
      .HSCLK0_LCPLLRSVD1_M     (q3_hsclk0_lcpllrsvd1_m),
      .HSCLK0_LCPLLSDMDATA_M   (q3_hsclk0_lcpllsdmdata_m),
      .HSCLK0_LCPLLSDMTOGGLE_M (q3_hsclk0_lcpllsdmtoggle_m),
      .HSCLK0_RPLLCLKRSVD0_M   (q3_hsclk0_rpllclkrsvd0_m),
      .HSCLK0_RPLLCLKRSVD1_M   (q3_hsclk0_rpllclkrsvd1_m),
      .HSCLK0_RPLLFBDIV_M      (q3_hsclk0_rpllfbdiv_m),
      .HSCLK0_RPLLPD_M         (q3_hsclk0_rpllpd_m),
      .HSCLK0_RPLLREFCLKSEL_M  (q3_hsclk0_rpllrefclksel_m),
      .HSCLK0_RPLLRESETBYPASSMODE_M(q3_hsclk0_rpllresetbypassmode_m),
      .HSCLK0_RPLLRESETMASK_M  (q3_hsclk0_rpllresetmask_m),
      .HSCLK0_RPLLRESET_M      (q3_hsclk0_rpllreset_m),
      .HSCLK0_RPLLRSVD0_M      (q3_hsclk0_rpllrsvd0_m),
      .HSCLK0_RPLLRSVD1_M      (q3_hsclk0_rpllrsvd1_m),
      .HSCLK0_RPLLSDMDATA_M    (q3_hsclk0_rpllsdmdata_m),
      .HSCLK0_RPLLSDMTOGGLE_M  (q3_hsclk0_rpllsdmtoggle_m),
    //.HSCLK1_GTGREFCLK2LCPLL_M(q3_hsclk1_gtgrefclk2lcpll_m),
    //.HSCLK1_GTGREFCLK2RPLL_M (q3_hsclk1_gtgrefclk2rpll_m),
      .HSCLK1_LCPLLCLKRSVD0_M  (q3_hsclk1_lcpllclkrsvd0_m),
      .HSCLK1_LCPLLCLKRSVD1_M  (q3_hsclk1_lcpllclkrsvd1_m),
      .HSCLK1_LCPLLFBDIV_M     (q3_hsclk1_lcpllfbdiv_m),
      .HSCLK1_LCPLLPD_M        (q3_hsclk1_lcpllpd_m),
      .HSCLK1_LCPLLREFCLKSEL_M (q3_hsclk1_lcpllrefclksel_m),
      .HSCLK1_LCPLLRESETBYPASSMODE_M(q3_hsclk1_lcpllresetbypassmode_m),
      .HSCLK1_LCPLLRESETMASK_M (q3_hsclk1_lcpllresetmask_m),
      .HSCLK1_LCPLLRESET_M     (q3_hsclk1_lcpllreset_m),
      .HSCLK1_LCPLLRSVD0_M     (q3_hsclk1_lcpllrsvd0_m),
      .HSCLK1_LCPLLRSVD1_M     (q3_hsclk1_lcpllrsvd1_m),
      .HSCLK1_LCPLLSDMDATA_M   (q3_hsclk1_lcpllsdmdata_m),
      .HSCLK1_LCPLLSDMTOGGLE_M (q3_hsclk1_lcpllsdmtoggle_m),
      .HSCLK1_RPLLCLKRSVD0_M   (q3_hsclk1_rpllclkrsvd0_m),
      .HSCLK1_RPLLCLKRSVD1_M   (q3_hsclk1_rpllclkrsvd1_m),
      .HSCLK1_RPLLFBDIV_M      (q3_hsclk1_rpllfbdiv_m),
      .HSCLK1_RPLLPD_M         (q3_hsclk1_rpllpd_m),
      .HSCLK1_RPLLREFCLKSEL_M  (q3_hsclk1_rpllrefclksel_m),
      .HSCLK1_RPLLRESETBYPASSMODE_M(q3_hsclk1_rpllresetbypassmode_m),
      .HSCLK1_RPLLRESETMASK_M  (q3_hsclk1_rpllresetmask_m),
      .HSCLK1_RPLLRESET_M      (q3_hsclk1_rpllreset_m),
      .HSCLK1_RPLLRSVD0_M      (q3_hsclk1_rpllrsvd0_m),
      .HSCLK1_RPLLRSVD1_M      (q3_hsclk1_rpllrsvd1_m),
      .HSCLK1_RPLLSDMDATA_M    (q3_hsclk1_rpllsdmdata_m),
      .HSCLK1_RPLLSDMTOGGLE_M  (q3_hsclk1_rpllsdmtoggle_m),

      .M0_AXIS_TREADY_M(s9_axis_tready_m),
      .M1_AXIS_TREADY_M(s10_axis_tready_m),
      .M2_AXIS_TREADY_M(s11_axis_tready_m),

      .MSTRXRESET_M({ch15_mstrxreset_m,ch14_mstrxreset_m,ch13_mstrxreset_m,ch12_mstrxreset_m}),
      .MSTTXRESET_M({ch15_msttxreset_m,ch14_msttxreset_m,ch13_msttxreset_m,ch12_msttxreset_m}),

      .MSTRXRESETDONE_M({ch15_mstrxresetdone_m,ch14_mstrxresetdone_m,ch13_mstrxresetdone_m,ch12_mstrxresetdone_m}),
      .MSTTXRESETDONE_M({ch15_msttxresetdone_m,ch14_msttxresetdone_m,ch13_msttxresetdone_m,ch12_msttxresetdone_m}),

      .CH0_RXPROGDIVRESETDONE_M(ch12_rxprogdivresetdone_m),
      .CH1_RXPROGDIVRESETDONE_M(ch13_rxprogdivresetdone_m),
      .CH2_RXPROGDIVRESETDONE_M(ch14_rxprogdivresetdone_m),
      .CH3_RXPROGDIVRESETDONE_M(ch15_rxprogdivresetdone_m),
      .CH0_TXPROGDIVRESETDONE_M(ch12_txprogdivresetdone_m),
      .CH1_TXPROGDIVRESETDONE_M(ch13_txprogdivresetdone_m),
      .CH2_TXPROGDIVRESETDONE_M(ch14_txprogdivresetdone_m),
      .CH3_TXPROGDIVRESETDONE_M(ch15_txprogdivresetdone_m),

      .PCIELINKREACHTARGET_M(q3_pcielinkreachtarget_m),
      .PCIELTSSM_M          (q3_pcieltssm_m),
      .RCALENB_M            (q3_rcalenb_m),
    //.REFCLK0_CEB_M        (q3_refclk0_ceb_m),
      .REFCLK0_CLKTESTSIG_M (q3_refclk0_clktestsig_m),
      .REFCLK0_GTREFCLKPD_M (q3_refclk0_gtrefclkpd_m),
    //.REFCLK1_CEB_M        (q3_refclk1_ceb_m),
      .REFCLK1_CLKTESTSIG_M (q3_refclk1_clktestsig_m),
      .REFCLK1_GTREFCLKPD_M (q3_refclk1_gtrefclkpd_m),
      .RXMARGINREQCMD_M     (q3_rxmarginreqcmd_m),
      .RXMARGINREQLANENUM_M (q3_rxmarginreqlanenum_m),
      .RXMARGINREQPAYLD_M   (q3_rxmarginreqpayld_m),
      .RXMARGINREQREQ_M     (q3_rxmarginreqreq_m),
      .RXMARGINRESACK_M     (q3_rxmarginresack_m),

      .S0_AXIS_TDATA_M  (m9_axis_tdata_m),
      .S0_AXIS_TLAST_M  (m9_axis_tlast_m),
      .S0_AXIS_TVALID_M (m9_axis_tvalid_m),
      .S1_AXIS_TDATA_M  (m10_axis_tdata_m),
      .S1_AXIS_TLAST_M  (m10_axis_tlast_m),
      .S1_AXIS_TVALID_M (m10_axis_tvalid_m),
      .S2_AXIS_TDATA_M  (m11_axis_tdata_m),
      .S2_AXIS_TLAST_M  (m11_axis_tlast_m),
      .S2_AXIS_TVALID_M (m11_axis_tvalid_m),

      .TRIGACKOUT0_M(q3_trigackout0_m),
      .TRIGIN0_M    (q3_trigin0_m),
      .UBENABLE_M   (q3_ubenable_m),
      .UBINTR_M     (q3_ubintr_m),
      .UBIOLMBRST_M (q3_ubiolmbrst_m),
      .UBMBRST_M    (q3_ubmbrst_m),
      .UBRXUART_M   (q3_ubrxuart_m),
      .APB3PRDATA_M (q3_apb3prdata_m),
      .APB3PREADY_M (q3_apb3pready_m),
      .APB3PSLVERR_M(q3_apb3pslverr_m),

      .CH0_BUFGTCEMASK_M   (ch12_bufgtcemask_m),
      .CH0_BUFGTCE_M       (ch12_bufgtce_m),
      .CH0_BUFGTDIV_M      (ch12_bufgtdiv_m),
      .CH0_BUFGTRSTMASK_M  (ch12_bufgtrstmask_m),
      .CH0_BUFGTRST_M      (ch12_bufgtrst_m),
    //.CH0_CFOKOVWRRDY0_M  (ch12_cfokovwrrdy0_m),
    //.CH0_CFOKOVWRRDY1_M  (ch12_cfokovwrrdy1_m),
      .CH0_DMONITOROUT_M   (ch12_dmonitorout_m),
      .CH0_EYESCANDATAERROR_M(ch12_eyescandataerror_m),
      .CH0_ILORESETDONE_M  (ch12_iloresetdone_m),
      .CH0_PCSRSVDOUT_M    (ch12_pcsrsvdout_m),
      .CH0_PINRSVDAS_M     (ch12_pinrsvdas_m),
      .CH0_PHYREADY_M      (ch12_phyready_m),
      .CH0_PHYSTATUS_M     (ch12_phystatus_m),
    //.CH0_PINRSRVDAS_M    (ch12_pinrsrvdas_m),
      .CH0_RESETEXCEPTION_M(ch12_resetexception_m),
      .CH0_RX10GSTAT_M     (ch12_rx10gstat_m),
      .CH0_RXBUFSTATUS_M   (ch12_rxbufstatus_m),
      .CH0_RXBYTEISALIGNED_M(ch12_rxbyteisaligned_m),
      .CH0_RXBYTEREALIGN_M (ch12_rxbyterealign_m),
      .CH0_RXCDRLOCK_M     (ch12_rxcdrlock_m),
      .CH0_RXCDRPHDONE_M   (ch12_rxcdrphdone_m),
      .CH0_RXCHANBONDSEQ_M (ch12_rxchanbondseq_m),
      .CH0_RXCHANISALIGNED_M(ch12_rxchanisaligned_m),
      .CH0_RXCHANREALIGN_M (ch12_rxchanrealign_m),
      .CH0_RXCHBONDO_M     (ch12_rxchbondo_m),
      .CH0_RXCLKCORCNT_M   (ch12_rxclkcorcnt_m),
      .CH0_RXCOMINITDET_M  (ch12_rxcominitdet_m),
      .CH0_RXCOMMADET_M    (ch12_rxcommadet_m),
      .CH0_RXCOMSASDET_M   (ch12_rxcomsasdet_m),
      .CH0_RXCOMWAKEDET_M  (ch12_rxcomwakedet_m),
      .CH0_RXCTRL0_M       (ch12_rxctrl0_m),
      .CH0_RXCTRL1_M       (ch12_rxctrl1_m),
      .CH0_RXCTRL2_M       (ch12_rxctrl2_m),
      .CH0_RXCTRL3_M       (ch12_rxctrl3_m),
      .CH0_RXDATAEXTENDRSVD_M(ch12_rxdataextendrsvd_m),
      .CH0_RXDATAVALID_M   (ch12_rxdatavalid_m),
      .CH0_RXDATA_M        (ch12_rxdata_m),
      .CH0_RXDCCDONE_M     (ch12_rxdccdone_m),
      .CH0_RXDLYALIGNERR_M (ch12_rxdlyalignerr_m),
      .CH0_RXDLYALIGNPROG_M(ch12_rxdlyalignprog_m),
      .CH0_RXELECIDLE_M    (ch12_rxelecidle_m),
      .CH0_RXFINEALIGNDONE_M(ch12_rxfinealigndone_m),
      .CH0_RXHEADERVALID_M (ch12_rxheadervalid_m),
      .CH0_RXHEADER_M      (ch12_rxheader_m),
      .CH0_RXOSINTDONE_M   (ch12_rxosintdone_m),
      .CH0_RXOSINTSTARTED_M(ch12_rxosintstarted_m),
      .CH0_RXOSINTSTROBEDONE_M(ch12_rxosintstrobedone_m),
      .CH0_RXOSINTSTROBESTARTED_M(ch12_rxosintstrobestarted_m),
      .CH0_RXPHALIGNDONE_M (ch12_rxphaligndone_m),
      .CH0_RXPHALIGNERR_M  (ch12_rxphalignerr_m),
      .CH0_RXPHDLYRESETDONE_M(ch12_rxphdlyresetdone_m),
      .CH0_RXPHSETINITDONE_M(ch12_rxphsetinitdone_m),
      .CH0_RXPHSHIFT180DONE_M(ch12_rxphshift180done_m),
      .CH0_RXPMARESETDONE_M(ch12_rxpmaresetdone_m),
      .CH0_RXPRBSERR_M     (ch12_rxprbserr_m),
      .CH0_RXPRBSLOCKED_M  (ch12_rxprbslocked_m),
    //.CH0_RXPRGDIVRESETDONE_M(ch12_rxprgdivresetdone_m),
      .CH0_RXRESETDONE_M   (ch12_rxresetdone_m),
      .CH0_RXSLIDERDY_M    (ch12_rxsliderdy_m),
      .CH0_RXSTARTOFSEQ_M  (ch12_rxstartofseq_m),
      .CH0_RXSTATUS_M      (ch12_rxstatus_m),
      .CH0_RXSYNCDONE_M    (ch12_rxsyncdone_m),
      .CH0_RXVALID_M       (ch12_rxvalid_m),

      .CH0_TSTCLK0_M(ch12_tstclk0_m),
      .CH0_TSTCLK1_M(ch12_tstclk1_m),
      .CH1_TSTCLK0_M(ch13_tstclk0_m),
      .CH1_TSTCLK1_M(ch13_tstclk1_m),
      .CH2_TSTCLK0_M(ch14_tstclk0_m),
      .CH2_TSTCLK1_M(ch14_tstclk1_m),
      .CH3_TSTCLK0_M(ch15_tstclk0_m),
      .CH3_TSTCLK1_M(ch15_tstclk1_m),

      .CH0_TX10GSTAT_M       (ch12_tx10gstat_m),
      .CH0_TXBUFSTATUS_M     (ch12_txbufstatus_m),
      .CH0_TXCOMFINISH_M     (ch12_txcomfinish_m),
      .CH0_TXDCCDONE_M       (ch12_txdccdone_m),
      .CH0_TXDLYALIGNERR_M   (ch12_txdlyalignerr_m),
      .CH0_TXDLYALIGNPROG_M  (ch12_txdlyalignprog_m),
      .CH0_TXOUTCLK_M        (ch12_txoutclk_m),
      .CH0_TXPHALIGNDONE_M   (ch12_txphaligndone_m),
      .CH0_TXPHALIGNERR_M    (ch12_txphalignerr_m),
      .CH0_TXPHALIGNOUTRSVD_M(ch12_txphalignoutrsvd_m),
      .CH0_TXPHDLYRESETDONE_M(ch12_txphdlyresetdone_m),
      .CH0_TXPHSETINITDONE_M (ch12_txphsetinitdone_m),
      .CH0_CFOKOVRDFINISH_M  (ch12_cfokovrdfinish_m),
      .CH1_CFOKOVRDFINISH_M  (ch13_cfokovrdfinish_m),
      .CH2_CFOKOVRDFINISH_M  (ch14_cfokovrdfinish_m),
      .CH3_CFOKOVRDFINISH_M  (ch15_cfokovrdfinish_m),
      .CH0_CFOKOVRDSTART_M   (ch12_cfokovrdstart_m),
      .CH1_CFOKOVRDSTART_M   (ch13_cfokovrdstart_m),
      .CH2_CFOKOVRDSTART_M   (ch14_cfokovrdstart_m),
      .CH3_CFOKOVRDSTART_M   (ch15_cfokovrdstart_m),
      .CH0_CFOKOVRDPULSE_M   (ch12_cfokovrdpulse_m),
      .CH1_CFOKOVRDPULSE_M   (ch13_cfokovrdpulse_m),
      .CH2_CFOKOVRDPULSE_M   (ch14_cfokovrdpulse_m),
      .CH3_CFOKOVRDPULSE_M   (ch15_cfokovrdpulse_m),
      .CH0_CFOKOVRDRDY0_M    (ch12_cfokovrdrdy0_m),
      .CH0_CFOKOVRDRDY1_M    (ch12_cfokovrdrdy1_m),
      .CH1_CFOKOVRDRDY0_M    (ch13_cfokovrdrdy0_m),
      .CH1_CFOKOVRDRDY1_M    (ch13_cfokovrdrdy1_m),
      .CH2_CFOKOVRDRDY0_M    (ch14_cfokovrdrdy0_m),
      .CH2_CFOKOVRDRDY1_M    (ch14_cfokovrdrdy1_m),
      .CH3_CFOKOVRDRDY0_M    (ch15_cfokovrdrdy0_m),
      .CH3_CFOKOVRDRDY1_M    (ch15_cfokovrdrdy1_m),
      .CH0_TXPHSHIFT180DONE_M(ch12_txphshift180done_m),
      .CH0_TXPMARESETDONE_M  (ch12_txpmaresetdone_m),
    //.CH0_TXPRGDIVRESETDONE_M(ch12_txprgdivresetdone_m),
      .CH0_TXRESETDONE_M     (ch12_txresetdone_m),
      .CH0_TXSYNCDONE_M      (ch12_txsyncdone_m),
      .CH1_BUFGTCEMASK_M     (ch13_bufgtcemask_m),
      .CH1_BUFGTCE_M         (ch13_bufgtce_m),
      .CH1_BUFGTDIV_M        (ch13_bufgtdiv_m),
      .CH1_BUFGTRSTMASK_M    (ch13_bufgtrstmask_m),
      .CH1_BUFGTRST_M        (ch13_bufgtrst_m),
    //.CH1_CFOKOVWRRDY0_M    (ch13_cfokovwrrdy0_m),
    //.CH1_CFOKOVWRRDY1_M    (ch13_cfokovwrrdy1_m),
      .CH1_DMONITOROUT_M     (ch13_dmonitorout_m),
      .CH1_EYESCANDATAERROR_M(ch13_eyescandataerror_m),
      .CH1_ILORESETDONE_M    (ch13_iloresetdone_m),
      .CH1_PCSRSVDOUT_M      (ch13_pcsrsvdout_m),
      .CH1_PINRSVDAS_M       (ch13_pinrsvdas_m),
      .CH1_PHYREADY_M        (ch13_phyready_m),
      .CH1_PHYSTATUS_M       (ch13_phystatus_m),
    //.CH1_PINRSRVDAS_M      (ch13_pinrsrvdas_m),
      .CH1_RESETEXCEPTION_M  (ch13_resetexception_m),
      .CH1_RX10GSTAT_M       (ch13_rx10gstat_m),
      .CH1_RXBUFSTATUS_M     (ch13_rxbufstatus_m),
      .CH1_RXBYTEISALIGNED_M (ch13_rxbyteisaligned_m),
      .CH1_RXBYTEREALIGN_M   (ch13_rxbyterealign_m),
      .CH1_RXCDRLOCK_M       (ch13_rxcdrlock_m),
      .CH1_RXCDRPHDONE_M     (ch13_rxcdrphdone_m),
      .CH1_RXCHANBONDSEQ_M   (ch13_rxchanbondseq_m),
      .CH1_RXCHANISALIGNED_M (ch13_rxchanisaligned_m),
      .CH1_RXCHANREALIGN_M   (ch13_rxchanrealign_m),
      .CH1_RXCHBONDO_M       (ch13_rxchbondo_m),
      .CH1_RXCLKCORCNT_M     (ch13_rxclkcorcnt_m),
      .CH1_RXCOMINITDET_M    (ch13_rxcominitdet_m),
      .CH1_RXCOMMADET_M      (ch13_rxcommadet_m),
      .CH1_RXCOMSASDET_M     (ch13_rxcomsasdet_m),
      .CH1_RXCOMWAKEDET_M    (ch13_rxcomwakedet_m),
      .CH1_RXCTRL0_M         (ch13_rxctrl0_m),
      .CH1_RXCTRL1_M         (ch13_rxctrl1_m),
      .CH1_RXCTRL2_M         (ch13_rxctrl2_m),
      .CH1_RXCTRL3_M         (ch13_rxctrl3_m),
      .CH1_RXDATAEXTENDRSVD_M(ch13_rxdataextendrsvd_m),
      .CH1_RXDATAVALID_M     (ch13_rxdatavalid_m),
      .CH1_RXDATA_M          (ch13_rxdata_m),
      .CH1_RXDCCDONE_M       (ch13_rxdccdone_m),
      .CH1_RXDLYALIGNERR_M   (ch13_rxdlyalignerr_m),
      .CH1_RXDLYALIGNPROG_M  (ch13_rxdlyalignprog_m),
      .CH1_RXELECIDLE_M      (ch13_rxelecidle_m),
      .CH1_RXFINEALIGNDONE_M (ch13_rxfinealigndone_m),
      .CH1_RXHEADERVALID_M   (ch13_rxheadervalid_m),
      .CH1_RXHEADER_M        (ch13_rxheader_m),
      .CH1_RXOSINTDONE_M     (ch13_rxosintdone_m),
      .CH1_RXOSINTSTARTED_M  (ch13_rxosintstarted_m),
      .CH1_RXOSINTSTROBEDONE_M(ch13_rxosintstrobedone_m),
      .CH1_RXOSINTSTROBESTARTED_M(ch13_rxosintstrobestarted_m),
      .CH1_RXPHALIGNDONE_M   (ch13_rxphaligndone_m),
      .CH1_RXPHALIGNERR_M    (ch13_rxphalignerr_m),
      .CH1_RXPHDLYRESETDONE_M(ch13_rxphdlyresetdone_m),
      .CH1_RXPHSETINITDONE_M (ch13_rxphsetinitdone_m),
      .CH1_RXPHSHIFT180DONE_M(ch13_rxphshift180done_m),
      .CH1_RXPMARESETDONE_M  (ch13_rxpmaresetdone_m),
      .CH1_RXPRBSERR_M       (ch13_rxprbserr_m),
      .CH1_RXPRBSLOCKED_M    (ch13_rxprbslocked_m),
    //.CH1_RXPRGDIVRESETDONE_M(ch13_rxprgdivresetdone_m),
      .CH1_RXRESETDONE_M     (ch13_rxresetdone_m),
      .CH1_RXSLIDERDY_M      (ch13_rxsliderdy_m),
      .CH1_RXSTARTOFSEQ_M    (ch13_rxstartofseq_m),
      .CH1_RXSTATUS_M        (ch13_rxstatus_m),
      .CH1_RXSYNCDONE_M      (ch13_rxsyncdone_m),
      .CH1_RXVALID_M         (ch13_rxvalid_m),
      .CH1_TX10GSTAT_M       (ch13_tx10gstat_m),
      .CH1_TXBUFSTATUS_M     (ch13_txbufstatus_m),
      .CH1_TXCOMFINISH_M     (ch13_txcomfinish_m),
      .CH1_TXDCCDONE_M       (ch13_txdccdone_m),
      .CH1_TXDLYALIGNERR_M   (ch13_txdlyalignerr_m),
      .CH1_TXDLYALIGNPROG_M  (ch13_txdlyalignprog_m),
      .CH1_TXPHALIGNDONE_M   (ch13_txphaligndone_m),
      .CH1_TXPHALIGNERR_M    (ch13_txphalignerr_m),
      .CH1_TXPHALIGNOUTRSVD_M(ch13_txphalignoutrsvd_m),
      .CH1_TXPHDLYRESETDONE_M(ch13_txphdlyresetdone_m),
      .CH1_TXPHSETINITDONE_M (ch13_txphsetinitdone_m),
      .CH1_TXPHSHIFT180DONE_M(ch13_txphshift180done_m),
      .CH1_TXPMARESETDONE_M  (ch13_txpmaresetdone_m),
    //.CH1_TXPRGDIVRESETDONE_M(ch13_txprgdivresetdone_m),
      .CH1_TXRESETDONE_M     (ch13_txresetdone_m),
      .CH1_TXSYNCDONE_M      (ch13_txsyncdone_m),
      .CH2_BUFGTCEMASK_M     (ch14_bufgtcemask_m),
      .CH2_BUFGTCE_M         (ch14_bufgtce_m),
      .CH2_BUFGTDIV_M        (ch14_bufgtdiv_m),
      .CH2_BUFGTRSTMASK_M    (ch14_bufgtrstmask_m),
      .CH2_BUFGTRST_M        (ch14_bufgtrst_m),
    //.CH2_CFOKOVWRRDY0_M    (ch14_cfokovwrrdy0_m),
    //.CH2_CFOKOVWRRDY1_M    (ch14_cfokovwrrdy1_m),
      .CH2_DMONITOROUT_M     (ch14_dmonitorout_m),
      .CH2_EYESCANDATAERROR_M(ch14_eyescandataerror_m),
      .CH2_ILORESETDONE_M    (ch14_iloresetdone_m),
      .CH2_PCSRSVDOUT_M      (ch14_pcsrsvdout_m),
      .CH2_PINRSVDAS_M       (ch14_pinrsvdas_m),
      .CH2_PHYREADY_M        (ch14_phyready_m),
      .CH2_PHYSTATUS_M       (ch14_phystatus_m),
    //.CH2_PINRSRVDAS_M      (ch14_pinrsrvdas_m),
      .CH2_RESETEXCEPTION_M  (ch14_resetexception_m),
      .CH2_RX10GSTAT_M       (ch14_rx10gstat_m),
      .CH2_RXBUFSTATUS_M     (ch14_rxbufstatus_m),
      .CH2_RXBYTEISALIGNED_M (ch14_rxbyteisaligned_m),
      .CH2_RXBYTEREALIGN_M   (ch14_rxbyterealign_m),
      .CH2_RXCDRLOCK_M       (ch14_rxcdrlock_m),
      .CH2_RXCDRPHDONE_M     (ch14_rxcdrphdone_m),
      .CH2_RXCHANBONDSEQ_M   (ch14_rxchanbondseq_m),
      .CH2_RXCHANISALIGNED_M (ch14_rxchanisaligned_m),
      .CH2_RXCHANREALIGN_M   (ch14_rxchanrealign_m),
      .CH2_RXCHBONDO_M       (ch14_rxchbondo_m),
      .CH2_RXCLKCORCNT_M     (ch14_rxclkcorcnt_m),
      .CH2_RXCOMINITDET_M    (ch14_rxcominitdet_m),
      .CH2_RXCOMMADET_M      (ch14_rxcommadet_m),
      .CH2_RXCOMSASDET_M     (ch14_rxcomsasdet_m),
      .CH2_RXCOMWAKEDET_M    (ch14_rxcomwakedet_m),
      .CH2_RXCTRL0_M         (ch14_rxctrl0_m),
      .CH2_RXCTRL1_M         (ch14_rxctrl1_m),
      .CH2_RXCTRL2_M         (ch14_rxctrl2_m),
      .CH2_RXCTRL3_M         (ch14_rxctrl3_m),
      .CH2_RXDATAEXTENDRSVD_M(ch14_rxdataextendrsvd_m),
      .CH2_RXDATAVALID_M     (ch14_rxdatavalid_m),
      .CH2_RXDATA_M          (ch14_rxdata_m),
      .CH2_RXDCCDONE_M       (ch14_rxdccdone_m),
      .CH2_RXDLYALIGNERR_M   (ch14_rxdlyalignerr_m),
      .CH2_RXDLYALIGNPROG_M  (ch14_rxdlyalignprog_m),
      .CH2_RXELECIDLE_M      (ch14_rxelecidle_m),
      .CH2_RXFINEALIGNDONE_M (ch14_rxfinealigndone_m),
      .CH2_RXHEADERVALID_M   (ch14_rxheadervalid_m),
      .CH2_RXHEADER_M        (ch14_rxheader_m),
      .CH2_RXOSINTDONE_M     (ch14_rxosintdone_m),
      .CH2_RXOSINTSTARTED_M  (ch14_rxosintstarted_m),
      .CH2_RXOSINTSTROBEDONE_M(ch14_rxosintstrobedone_m),
      .CH2_RXOSINTSTROBESTARTED_M(ch14_rxosintstrobestarted_m),
      .CH2_RXPHALIGNDONE_M   (ch14_rxphaligndone_m),
      .CH2_RXPHALIGNERR_M    (ch14_rxphalignerr_m),
      .CH2_RXPHDLYRESETDONE_M(ch14_rxphdlyresetdone_m),
      .CH2_RXPHSETINITDONE_M (ch14_rxphsetinitdone_m),
      .CH2_RXPHSHIFT180DONE_M(ch14_rxphshift180done_m),
      .CH2_RXPMARESETDONE_M  (ch14_rxpmaresetdone_m),
      .CH2_RXPRBSERR_M       (ch14_rxprbserr_m),
      .CH2_RXPRBSLOCKED_M    (ch14_rxprbslocked_m),
    //.CH2_RXPRGDIVRESETDONE_M(ch14_rxprgdivresetdone_m),
      .CH2_RXRESETDONE_M     (ch14_rxresetdone_m),
      .CH2_RXSLIDERDY_M      (ch14_rxsliderdy_m),
      .CH2_RXSTARTOFSEQ_M    (ch14_rxstartofseq_m),
      .CH2_RXSTATUS_M        (ch14_rxstatus_m),
      .CH2_RXSYNCDONE_M      (ch14_rxsyncdone_m),
      .CH2_RXVALID_M         (ch14_rxvalid_m),
      .CH2_TX10GSTAT_M       (ch14_tx10gstat_m),
      .CH2_TXBUFSTATUS_M     (ch14_txbufstatus_m),
      .CH2_TXCOMFINISH_M     (ch14_txcomfinish_m),
      .CH2_TXDCCDONE_M       (ch14_txdccdone_m),
      .CH2_TXDLYALIGNERR_M   (ch14_txdlyalignerr_m),
      .CH2_TXDLYALIGNPROG_M  (ch14_txdlyalignprog_m),
      .CH2_TXPHALIGNDONE_M   (ch14_txphaligndone_m),
      .CH2_TXPHALIGNERR_M    (ch14_txphalignerr_m),
      .CH2_TXPHALIGNOUTRSVD_M(ch14_txphalignoutrsvd_m),
      .CH2_TXPHDLYRESETDONE_M(ch14_txphdlyresetdone_m),
      .CH2_TXPHSETINITDONE_M (ch14_txphsetinitdone_m),
      .CH2_TXPHSHIFT180DONE_M(ch14_txphshift180done_m),
      .CH2_TXPMARESETDONE_M  (ch14_txpmaresetdone_m),
    //.CH2_TXPRGDIVRESETDONE_M(ch14_txprgdivresetdone_m),
      .CH2_TXRESETDONE_M     (ch14_txresetdone_m),
      .CH2_TXSYNCDONE_M      (ch14_txsyncdone_m),
      .CH3_BUFGTCEMASK_M     (ch15_bufgtcemask_m),
      .CH3_BUFGTCE_M         (ch15_bufgtce_m),
      .CH3_BUFGTDIV_M        (ch15_bufgtdiv_m),
      .CH3_BUFGTRSTMASK_M    (ch15_bufgtrstmask_m),
      .CH3_BUFGTRST_M        (ch15_bufgtrst_m),
    //.CH3_CFOKOVWRRDY0_M    (ch15_cfokovwrrdy0_m),
    //.CH3_CFOKOVWRRDY1_M    (ch15_cfokovwrrdy1_m),
      .CH3_DMONITOROUT_M     (ch15_dmonitorout_m),
      .CH3_EYESCANDATAERROR_M(ch15_eyescandataerror_m),
      .CH3_ILORESETDONE_M    (ch15_iloresetdone_m),
      .CH3_PCSRSVDOUT_M      (ch15_pcsrsvdout_m),
      .CH3_PINRSVDAS_M       (ch15_pinrsvdas_m),
      .CH3_PHYREADY_M        (ch15_phyready_m),
      .CH3_PHYSTATUS_M       (ch15_phystatus_m),
    //.CH3_PINRSRVDAS_M      (ch15_pinrsrvdas_m),
      .CH3_RESETEXCEPTION_M  (ch15_resetexception_m),
      .CH3_RX10GSTAT_M       (ch15_rx10gstat_m),
      .CH3_RXBUFSTATUS_M     (ch15_rxbufstatus_m),
      .CH3_RXBYTEISALIGNED_M (ch15_rxbyteisaligned_m),
      .CH3_RXBYTEREALIGN_M   (ch15_rxbyterealign_m),
      .CH3_RXCDRLOCK_M       (ch15_rxcdrlock_m),
      .CH3_RXCDRPHDONE_M     (ch15_rxcdrphdone_m),
      .CH3_RXCHANBONDSEQ_M   (ch15_rxchanbondseq_m),
      .CH3_RXCHANISALIGNED_M (ch15_rxchanisaligned_m),
      .CH3_RXCHANREALIGN_M   (ch15_rxchanrealign_m),
      .CH3_RXCHBONDO_M       (ch15_rxchbondo_m),
      .CH3_RXCLKCORCNT_M     (ch15_rxclkcorcnt_m),
      .CH3_RXCOMINITDET_M    (ch15_rxcominitdet_m),
      .CH3_RXCOMMADET_M      (ch15_rxcommadet_m),
      .CH3_RXCOMSASDET_M     (ch15_rxcomsasdet_m),
      .CH3_RXCOMWAKEDET_M    (ch15_rxcomwakedet_m),
      .CH3_RXCTRL0_M         (ch15_rxctrl0_m),
      .CH3_RXCTRL1_M         (ch15_rxctrl1_m),
      .CH3_RXCTRL2_M         (ch15_rxctrl2_m),
      .CH3_RXCTRL3_M         (ch15_rxctrl3_m),
      .CH3_RXDATAEXTENDRSVD_M(ch15_rxdataextendrsvd_m),
      .CH3_RXDATAVALID_M     (ch15_rxdatavalid_m),
      .CH3_RXDATA_M          (ch15_rxdata_m),
      .CH3_RXDCCDONE_M       (ch15_rxdccdone_m),
      .CH3_RXDLYALIGNERR_M   (ch15_rxdlyalignerr_m),
      .CH3_RXDLYALIGNPROG_M  (ch15_rxdlyalignprog_m),
      .CH3_RXELECIDLE_M      (ch15_rxelecidle_m),
      .CH3_RXFINEALIGNDONE_M (ch15_rxfinealigndone_m),
      .CH3_RXHEADERVALID_M   (ch15_rxheadervalid_m),
      .CH3_RXHEADER_M        (ch15_rxheader_m),
      .CH3_RXOSINTDONE_M     (ch15_rxosintdone_m),
      .CH3_RXOSINTSTARTED_M  (ch15_rxosintstarted_m),
      .CH3_RXOSINTSTROBEDONE_M(ch15_rxosintstrobedone_m),
      .CH3_RXOSINTSTROBESTARTED_M(ch15_rxosintstrobestarted_m),
      .CH3_RXPHALIGNDONE_M   (ch15_rxphaligndone_m),
      .CH3_RXPHALIGNERR_M    (ch15_rxphalignerr_m),
      .CH3_RXPHDLYRESETDONE_M(ch15_rxphdlyresetdone_m),
      .CH3_RXPHSETINITDONE_M (ch15_rxphsetinitdone_m),
      .CH3_RXPHSHIFT180DONE_M(ch15_rxphshift180done_m),
      .CH3_RXPMARESETDONE_M  (ch15_rxpmaresetdone_m),
      .CH3_RXPRBSERR_M       (ch15_rxprbserr_m),
      .CH3_RXPRBSLOCKED_M    (ch15_rxprbslocked_m),
    //.CH3_RXPRGDIVRESETDONE_M(ch15_rxprgdivresetdone_m),
      .CH3_RXRESETDONE_M     (ch15_rxresetdone_m),
      .CH3_RXSLIDERDY_M      (ch15_rxsliderdy_m),
      .CH3_RXSTARTOFSEQ_M    (ch15_rxstartofseq_m),
      .CH3_RXSTATUS_M        (ch15_rxstatus_m),
      .CH3_RXSYNCDONE_M      (ch15_rxsyncdone_m),
      .CH3_RXVALID_M         (ch15_rxvalid_m),
      .CH3_TX10GSTAT_M       (ch15_tx10gstat_m),
      .CH3_TXBUFSTATUS_M     (ch15_txbufstatus_m),
      .CH3_TXCOMFINISH_M     (ch15_txcomfinish_m),
      .CH3_TXDCCDONE_M       (ch15_txdccdone_m),
      .CH3_TXDLYALIGNERR_M   (ch15_txdlyalignerr_m),
      .CH3_TXDLYALIGNPROG_M  (ch15_txdlyalignprog_m),
      .CH3_TXPHALIGNDONE_M   (ch15_txphaligndone_m),
      .CH3_TXPHALIGNERR_M    (ch15_txphalignerr_m),
      .CH3_TXPHALIGNOUTRSVD_M(ch15_txphalignoutrsvd_m),
      .CH3_TXPHDLYRESETDONE_M(ch15_txphdlyresetdone_m),
      .CH3_TXPHSETINITDONE_M (ch15_txphsetinitdone_m),
      .CH3_TXPHSHIFT180DONE_M(ch15_txphshift180done_m),
      .CH3_TXPMARESETDONE_M  (ch15_txpmaresetdone_m),
    //.CH3_TXPRGDIVRESETDONE_M(ch15_txprgdivresetdone_m),
      .CH3_TXRESETDONE_M     (ch15_txresetdone_m),
      .CH3_TXSYNCDONE_M      (ch15_txsyncdone_m),

      .CORRECTERR_M      (q3_correcterr_m),
      .CTRLRSVDOUT_M     (q3_ctrlrsvdout_m),
      .DEBUGTRACETDATA_M (q3_debugtracetdata_m),
      .DEBUGTRACETVALID_M(q3_debugtracetvalid_m),

      .GPO_M(q3_gpo_m),
      .GTPOWERGOOD_M(q3_gtpowergood_m),

      .HSCLK0_LCPLLFBCLKLOST_M   (q3_hsclk0_lcpllfbclklost_m),
      .HSCLK0_LCPLLLOCK_M        (q3_hsclk0_lcplllock_m),
      .HSCLK0_LCPLLREFCLKLOST_M  (q3_hsclk0_lcpllrefclklost_m),
      .HSCLK0_LCPLLREFCLKMONITOR_M(q3_hsclk0_lcpllrefclkmonitor_m),
      .HSCLK0_LCPLLRSVDOUT_M     (q3_hsclk0_lcpllrsvdout_m),
      .HSCLK0_RPLLFBCLKLOST_M    (q3_hsclk0_rpllfbclklost_m),
      .HSCLK0_RPLLLOCK_M         (q3_hsclk0_rplllock_m),
      .HSCLK0_RPLLREFCLKLOST_M   (q3_hsclk0_rpllrefclklost_m),
      .HSCLK0_RPLLREFCLKMONITOR_M(q3_hsclk0_rpllrefclkmonitor_m),
      .HSCLK0_RPLLRSVDOUT_M      (q3_hsclk0_rpllrsvdout_m),
      .HSCLK1_LCPLLFBCLKLOST_M   (q3_hsclk1_lcpllfbclklost_m),
      .HSCLK1_LCPLLLOCK_M        (q3_hsclk1_lcplllock_m),
      .HSCLK1_LCPLLREFCLKLOST_M  (q3_hsclk1_lcpllrefclklost_m),
      .HSCLK1_LCPLLREFCLKMONITOR_M(q3_hsclk1_lcpllrefclkmonitor_m),
      .HSCLK1_LCPLLRSVDOUT_M     (q3_hsclk1_lcpllrsvdout_m),
      .HSCLK1_RPLLFBCLKLOST_M    (q3_hsclk1_rpllfbclklost_m),
      .HSCLK1_RPLLLOCK_M         (q3_hsclk1_rplllock_m),
      .HSCLK1_RPLLREFCLKLOST_M   (q3_hsclk1_rpllrefclklost_m),
      .HSCLK1_RPLLREFCLKMONITOR_M(q3_hsclk1_rpllrefclkmonitor_m),
      .HSCLK1_RPLLRSVDOUT_M      (q3_hsclk1_rpllrsvdout_m),

      .M0_AXIS_TDATA_M  (s9_axis_tdata_m),
      .M0_AXIS_TLAST_M  (s9_axis_tlast_m),
      .M0_AXIS_TVALID_M (s9_axis_tvalid_m),
      .M1_AXIS_TDATA_M  (s10_axis_tdata_m),
      .M1_AXIS_TLAST_M  (s10_axis_tlast_m),
      .M1_AXIS_TVALID_M (s10_axis_tvalid_m),
      .M2_AXIS_TDATA_M  (s11_axis_tdata_m),
      .M2_AXIS_TLAST_M  (s11_axis_tlast_m),
      .M2_AXIS_TVALID_M (s11_axis_tvalid_m),

      .RXMARGINREQACK_M  (q3_rxmarginreqack_m),
      .RXMARGINRESCMD_M  (q3_rxmarginrescmd_m),
      .RXMARGINRESLANENUM_M(q3_rxmarginreslanenum_m),
      .RXMARGINRESPAYLD_M(q3_rxmarginrespayld_m),
      .RXMARGINRESREQ_M  (q3_rxmarginresreq_m),
      .S0_AXIS_TREADY_M  (m9_axis_tready_m),
      .S1_AXIS_TREADY_M  (m10_axis_tready_m),
      .S2_AXIS_TREADY_M  (m11_axis_tready_m),
      .TRIGACKIN0_M      (q3_trigackin0_m),
      .TRIGOUT0_M        (q3_trigout0_m),
      .UBINTERRUPT_M     (q3_ubinterrupt_m),
      .UBTXUART_M        (q3_ubtxuart_m),
      .UNCORRECTERR_M    (q3_uncorrecterr_m),
      .RXMARGINCLK_M     (q3_rxmarginclk_m),

      .XPIPE_HSDP_RXGEARBOXSLIP  (q2q3_hsdp_xpipe_ch0_rxgearboxslip),
      .XPIPE_HSDP_RXPCSRESET     (q2q3_hsdp_xpipe_ch0_rxpcsreset),
      .XPIPE_HSDP_TXHEADER       (q2q3_hsdp_xpipe_ch0_txheader),
      .XPIPE_HSDP_TXSEQUENCE     (q2q3_hsdp_xpipe_ch0_txsequence),
      .XPIPE_HSDP_RXDATAVALID    (q2q3_hsdp_xpipe_ch0_rxdatavalid),
      .XPIPE_HSDP_RXHEADER       (q2q3_hsdp_xpipe_ch0_rxheader),
      .XPIPE_HSDP_RXRESETDONE    (q2q3_hsdp_xpipe_ch0_rxresetdone),
      .XPIPE_HSDP_TXRESETDONE    (q2q3_hsdp_xpipe_ch0_txresetdone),
      .XPIPE_HSDP_RXHEADERVALID  (q2q3_hsdp_xpipe_ch0_rxheadervalid),

      .XPIPE_HSDP_RXGEARBOXSLIP_1(q2q3_hsdp_xpipe_ch1_rxgearboxslip),
      .XPIPE_HSDP_RXPCSRESET_1   (q2q3_hsdp_xpipe_ch1_rxpcsreset),
      .XPIPE_HSDP_TXHEADER_1     (q2q3_hsdp_xpipe_ch1_txheader),
      .XPIPE_HSDP_TXSEQUENCE_1   (q2q3_hsdp_xpipe_ch1_txsequence),
      .XPIPE_HSDP_RXDATAVALID_1  (q2q3_hsdp_xpipe_ch1_rxdatavalid),
      .XPIPE_HSDP_RXHEADER_1     (q2q3_hsdp_xpipe_ch1_rxheader),
      .XPIPE_HSDP_RXRESETDONE_1  (q2q3_hsdp_xpipe_ch1_rxresetdone),
      .XPIPE_HSDP_TXRESETDONE_1  (q2q3_hsdp_xpipe_ch1_txresetdone),
      .XPIPE_HSDP_RXHEADERVALID_1(q2q3_hsdp_xpipe_ch1_rxheadervalid),

      .XPIPE_HSDP_RXGEARBOXSLIP_2(q2q3_hsdp_xpipe_ch2_rxgearboxslip),
      .XPIPE_HSDP_RXPCSRESET_2   (q2q3_hsdp_xpipe_ch2_rxpcsreset),
      .XPIPE_HSDP_TXHEADER_2     (q2q3_hsdp_xpipe_ch2_txheader),
      .XPIPE_HSDP_TXSEQUENCE_2   (q2q3_hsdp_xpipe_ch2_txsequence),
      .XPIPE_HSDP_RXDATAVALID_2  (q2q3_hsdp_xpipe_ch2_rxdatavalid),
      .XPIPE_HSDP_RXHEADER_2     (q2q3_hsdp_xpipe_ch2_rxheader),
      .XPIPE_HSDP_RXRESETDONE_2  (q2q3_hsdp_xpipe_ch2_rxresetdone),
      .XPIPE_HSDP_TXRESETDONE_2  (q2q3_hsdp_xpipe_ch2_txresetdone),
      .XPIPE_HSDP_RXHEADERVALID_2(q2q3_hsdp_xpipe_ch2_rxheadervalid),

      .XPIPE_HSDP_RXGEARBOXSLIP_M(q3q4_hsdp_xpipe_ch0_rxgearboxslip),
      .XPIPE_HSDP_RXPCSRESET_M   (q3q4_hsdp_xpipe_ch0_rxpcsreset),
      .XPIPE_HSDP_TXHEADER_M     (q3q4_hsdp_xpipe_ch0_txheader),
      .XPIPE_HSDP_TXSEQUENCE_M   (q3q4_hsdp_xpipe_ch0_txsequence),
      .XPIPE_HSDP_RXDATAVALID_M  (q3q4_hsdp_xpipe_ch0_rxdatavalid),
      .XPIPE_HSDP_RXHEADER_M     (q3q4_hsdp_xpipe_ch0_rxheader),
      .XPIPE_HSDP_RXRESETDONE_M  (q3q4_hsdp_xpipe_ch0_rxresetdone),
      .XPIPE_HSDP_TXRESETDONE_M  (q3q4_hsdp_xpipe_ch0_txresetdone),
      .XPIPE_HSDP_RXHEADERVALID_M(q3q4_hsdp_xpipe_ch0_rxheadervalid),

      .XPIPE_HSDP_RXGEARBOXSLIP_M_1(q3q4_hsdp_xpipe_ch1_rxgearboxslip),
      .XPIPE_HSDP_RXPCSRESET_M_1   (q3q4_hsdp_xpipe_ch1_rxpcsreset),
      .XPIPE_HSDP_TXHEADER_M_1     (q3q4_hsdp_xpipe_ch1_txheader),
      .XPIPE_HSDP_TXSEQUENCE_M_1   (q3q4_hsdp_xpipe_ch1_txsequence),
      .XPIPE_HSDP_RXDATAVALID_M_1  (q3q4_hsdp_xpipe_ch1_rxdatavalid),
      .XPIPE_HSDP_RXHEADER_M_1     (q3q4_hsdp_xpipe_ch1_rxheader),
      .XPIPE_HSDP_RXRESETDONE_M_1  (q3q4_hsdp_xpipe_ch1_rxresetdone),
      .XPIPE_HSDP_TXRESETDONE_M_1  (q3q4_hsdp_xpipe_ch1_txresetdone),
      .XPIPE_HSDP_RXHEADERVALID_M_1(q3q4_hsdp_xpipe_ch1_rxheadervalid),

      .XPIPE_HSDP_RXGEARBOXSLIP_M_2(q3q4_hsdp_xpipe_ch2_rxgearboxslip),
      .XPIPE_HSDP_RXPCSRESET_M_2   (q3q4_hsdp_xpipe_ch2_rxpcsreset),
      .XPIPE_HSDP_TXHEADER_M_2     (q3q4_hsdp_xpipe_ch2_txheader),
      .XPIPE_HSDP_TXSEQUENCE_M_2   (q3q4_hsdp_xpipe_ch2_txsequence),
      .XPIPE_HSDP_RXDATAVALID_M_2  (q3q4_hsdp_xpipe_ch2_rxdatavalid),
      .XPIPE_HSDP_RXHEADER_M_2     (q3q4_hsdp_xpipe_ch2_rxheader),
      .XPIPE_HSDP_RXRESETDONE_M_2  (q3q4_hsdp_xpipe_ch2_rxresetdone),
      .XPIPE_HSDP_TXRESETDONE_M_2  (q3q4_hsdp_xpipe_ch2_txresetdone),
      .XPIPE_HSDP_RXHEADERVALID_M_2(q3q4_hsdp_xpipe_ch2_rxheadervalid),

      .XPIPE_PCIELINKREACHTARGET (q2q3_xpipe_pcielinkreachtarget_m),
      .XPIPE_PCIELTSSMSTATE      (q2q3_xpipe_pcieltssmstate_m),
      .XPIPE_PCIELINKREACHTARGET_1(q2q3_xpipe_pcielinkreachtarget_m_1),
      .XPIPE_PCIELTSSMSTATE_1    (q2q3_xpipe_pcieltssmstate_m_1),
      .XPIPE_RXMARGINREQCMD      (q2q3_xpipe_rxmarginreqcmd_m),
      .XPIPE_RXMARGINREQLANENUM  (q2q3_xpipe_rxmarginreqlanenum_m),
      .XPIPE_RXMARGINREQPAYLOAD  (q2q3_xpipe_rxmarginreqpayload_m),
      .XPIPE_RXMARGINREQREQ      (q2q3_xpipe_rxmarginreqreq_m),
      .XPIPE_RXMARGINRESACK      (q2q3_xpipe_rxmarginresack_m),
      .XPIPE_RXMARGINREQCMD_1    (q2q3_xpipe_rxmarginreqcmd_m_1),
      .XPIPE_RXMARGINREQLANENUM_1(q2q3_xpipe_rxmarginreqlanenum_m_1),
      .XPIPE_RXMARGINREQPAYLOAD_1(q2q3_xpipe_rxmarginreqpayload_m_1),
      .XPIPE_RXMARGINREQREQ_1    (q2q3_xpipe_rxmarginreqreq_m_1),
      .XPIPE_RXMARGINRESACK_1    (q2q3_xpipe_rxmarginresack_m_1),
      .XPIPE_RXMARGINREQCMD_2    (q2q3_xpipe_rxmarginreqcmd_m_2),
      .XPIPE_RXMARGINREQLANENUM_2(q2q3_xpipe_rxmarginreqlanenum_m_2),
      .XPIPE_RXMARGINREQPAYLOAD_2(q2q3_xpipe_rxmarginreqpayload_m_2),
      .XPIPE_RXMARGINREQREQ_2    (q2q3_xpipe_rxmarginreqreq_m_2),
      .XPIPE_RXMARGINRESACK_2    (q2q3_xpipe_rxmarginresack_m_2),
      .XPIPE_RXMARGINREQCMD_3    (q2q3_xpipe_rxmarginreqcmd_m_3),
      .XPIPE_RXMARGINREQLANENUM_3(q2q3_xpipe_rxmarginreqlanenum_m_3),
      .XPIPE_RXMARGINREQPAYLOAD_3(q2q3_xpipe_rxmarginreqpayload_m_3),
      .XPIPE_RXMARGINREQREQ_3    (q2q3_xpipe_rxmarginreqreq_m_3),
      .XPIPE_RXMARGINRESACK_3    (q2q3_xpipe_rxmarginresack_m_3),
      .XPIPE_RXMARGINREQACK      (q2q3_xpipe_rxmarginreqack_m),
      .XPIPE_RXMARGINREQACK_1    (q2q3_xpipe_rxmarginreqack_m_1),
      .XPIPE_RXMARGINREQACK_2    (q2q3_xpipe_rxmarginreqack_m_2),
      .XPIPE_RXMARGINREQACK_3    (q2q3_xpipe_rxmarginreqack_m_3),
      .XPIPE_RXMARGINRESCMD      (q2q3_xpipe_rxmarginrescmd_m),
      .XPIPE_RXMARGINRESCMD_1    (q2q3_xpipe_rxmarginrescmd_m_1),
      .XPIPE_RXMARGINRESCMD_2    (q2q3_xpipe_rxmarginrescmd_m_2),
      .XPIPE_RXMARGINRESCMD_3    (q2q3_xpipe_rxmarginrescmd_m_3),
      .XPIPE_RXMARGINRESLANENUM  (q2q3_xpipe_rxmarginreslanenum_m),
      .XPIPE_RXMARGINRESLANENUM_1(q2q3_xpipe_rxmarginreslanenum_m_1),
      .XPIPE_RXMARGINRESLANENUM_2(q2q3_xpipe_rxmarginreslanenum_m_2),
      .XPIPE_RXMARGINRESLANENUM_3(q2q3_xpipe_rxmarginreslanenum_m_3),
      .XPIPE_RXMARGINRESPAYLOAD  (q2q3_xpipe_rxmarginrespayload_m),
      .XPIPE_RXMARGINRESPAYLOAD_1(q2q3_xpipe_rxmarginrespayload_m_1),
      .XPIPE_RXMARGINRESPAYLOAD_2(q2q3_xpipe_rxmarginrespayload_m_2),
      .XPIPE_RXMARGINRESPAYLOAD_3(q2q3_xpipe_rxmarginrespayload_m_3),
      .XPIPE_RXMARGINRESREQ      (q2q3_xpipe_rxmarginresreq_m),
      .XPIPE_RXMARGINRESREQ_1    (q2q3_xpipe_rxmarginresreq_m_1),
      .XPIPE_RXMARGINRESREQ_2    (q2q3_xpipe_rxmarginresreq_m_2),
      .XPIPE_RXMARGINRESREQ_3    (q2q3_xpipe_rxmarginresreq_m_3),

      .XPIPE_PCIELINKREACHTARGET_M (q3q4_xpipe_pcielinkreachtarget_m),
      .XPIPE_PCIELINKREACHTARGET_M_1(q3q4_xpipe_pcielinkreachtarget_m_1),
      .XPIPE_PCIELTSSMSTATE_M      (q3q4_xpipe_pcieltssmstate_m),
      .XPIPE_PCIELTSSMSTATE_M_1    (q3q4_xpipe_pcieltssmstate_m_1),
      .XPIPE_RXMARGINREQCMD_M      (q3q4_xpipe_rxmarginreqcmd_m),
      .XPIPE_RXMARGINREQCMD_M_1    (q3q4_xpipe_rxmarginreqcmd_m_1),
      .XPIPE_RXMARGINREQCMD_M_2    (q3q4_xpipe_rxmarginreqcmd_m_2),
      .XPIPE_RXMARGINREQCMD_M_3    (q3q4_xpipe_rxmarginreqcmd_m_3),
      .XPIPE_RXMARGINREQLANENUM_M  (q3q4_xpipe_rxmarginreqlanenum_m),
      .XPIPE_RXMARGINREQLANENUM_M_1(q3q4_xpipe_rxmarginreqlanenum_m_1),
      .XPIPE_RXMARGINREQLANENUM_M_2(q3q4_xpipe_rxmarginreqlanenum_m_2),
      .XPIPE_RXMARGINREQLANENUM_M_3(q3q4_xpipe_rxmarginreqlanenum_m_3),
      .XPIPE_RXMARGINREQPAYLOAD_M  (q3q4_xpipe_rxmarginreqpayload_m),
      .XPIPE_RXMARGINREQPAYLOAD_M_1(q3q4_xpipe_rxmarginreqpayload_m_1),
      .XPIPE_RXMARGINREQPAYLOAD_M_2(q3q4_xpipe_rxmarginreqpayload_m_2),
      .XPIPE_RXMARGINREQPAYLOAD_M_3(q3q4_xpipe_rxmarginreqpayload_m_3),
      .XPIPE_RXMARGINREQREQ_M      (q3q4_xpipe_rxmarginreqreq_m),
      .XPIPE_RXMARGINREQREQ_M_1    (q3q4_xpipe_rxmarginreqreq_m_1),
      .XPIPE_RXMARGINREQREQ_M_2    (q3q4_xpipe_rxmarginreqreq_m_2),
      .XPIPE_RXMARGINREQREQ_M_3    (q3q4_xpipe_rxmarginreqreq_m_3),
      .XPIPE_RXMARGINRESACK_M      (q3q4_xpipe_rxmarginresack_m),
      .XPIPE_RXMARGINRESACK_M_1    (q3q4_xpipe_rxmarginresack_m_1),
      .XPIPE_RXMARGINRESACK_M_2    (q3q4_xpipe_rxmarginresack_m_2),
      .XPIPE_RXMARGINRESACK_M_3    (q3q4_xpipe_rxmarginresack_m_3),
      .XPIPE_RXMARGINREQACK_M      (q3q4_xpipe_rxmarginreqack_m),
      .XPIPE_RXMARGINREQACK_M_1    (q3q4_xpipe_rxmarginreqack_m_1),
      .XPIPE_RXMARGINREQACK_M_2    (q3q4_xpipe_rxmarginreqack_m_2),
      .XPIPE_RXMARGINREQACK_M_3    (q3q4_xpipe_rxmarginreqack_m_3),
      .XPIPE_RXMARGINRESCMD_M      (q3q4_xpipe_rxmarginrescmd_m),
      .XPIPE_RXMARGINRESCMD_M_1    (q3q4_xpipe_rxmarginrescmd_m_1),
      .XPIPE_RXMARGINRESCMD_M_2    (q3q4_xpipe_rxmarginrescmd_m_2),
      .XPIPE_RXMARGINRESCMD_M_3    (q3q4_xpipe_rxmarginrescmd_m_3),
      .XPIPE_RXMARGINRESLANENUM_M  (q3q4_xpipe_rxmarginreslanenum_m),
      .XPIPE_RXMARGINRESLANENUM_M_1(q3q4_xpipe_rxmarginreslanenum_m_1),
      .XPIPE_RXMARGINRESLANENUM_M_2(q3q4_xpipe_rxmarginreslanenum_m_2),
      .XPIPE_RXMARGINRESLANENUM_M_3(q3q4_xpipe_rxmarginreslanenum_m_3),
      .XPIPE_RXMARGINRESPAYLOAD_M  (q3q4_xpipe_rxmarginrespayload_m),
      .XPIPE_RXMARGINRESPAYLOAD_M_1(q3q4_xpipe_rxmarginrespayload_m_1),
      .XPIPE_RXMARGINRESPAYLOAD_M_2(q3q4_xpipe_rxmarginrespayload_m_2),
      .XPIPE_RXMARGINRESPAYLOAD_M_3(q3q4_xpipe_rxmarginrespayload_m_3),
      .XPIPE_RXMARGINRESREQ_M      (q3q4_xpipe_rxmarginresreq_m),
      .XPIPE_RXMARGINRESREQ_M_1    (q3q4_xpipe_rxmarginresreq_m_1),
      .XPIPE_RXMARGINRESREQ_M_2    (q3q4_xpipe_rxmarginresreq_m_2),
      .XPIPE_RXMARGINRESREQ_M_3    (q3q4_xpipe_rxmarginresreq_m_3),

      .XPIPE_PIPE_CH0_PHYSTATUS       (q2q3_xpipe_pipe_ch0_phystatus_m),
      .XPIPE_PIPE_CH0_RXCHARISK       (q2q3_xpipe_pipe_ch0_rxcharisk_m),
      .XPIPE_PIPE_CH0_RXDATA          (q2q3_xpipe_pipe_ch0_rxdata_m),
      .XPIPE_PIPE_CH0_RXDATAVALID     (q2q3_xpipe_pipe_ch0_rxdatavalid_m),
      .XPIPE_PIPE_CH0_RXELECIDLE      (q2q3_xpipe_pipe_ch0_rxelecidle_m),
      .XPIPE_PIPE_CH0_RXSTARTBLOCK    (q2q3_xpipe_pipe_ch0_rxstartblock_m),
      .XPIPE_PIPE_CH0_RXSTATUS        (q2q3_xpipe_pipe_ch0_rxstatus_m),
      .XPIPE_PIPE_CH0_RXSYNCHEADER    (q2q3_xpipe_pipe_ch0_rxsyncheader_m),
      .XPIPE_PIPE_CH0_RXVALID         (q2q3_xpipe_pipe_ch0_rxvalid_m),
      .XPIPE_PIPE_CH0_POWERDOWN       (q2q3_xpipe_pipe_ch0_powerdown_m),
      .XPIPE_PIPE_CH0_RXPOLARITY      (q2q3_xpipe_pipe_ch0_rxpolarity_m),
      .XPIPE_PIPE_CH0_RXTERMINATION   (q2q3_xpipe_pipe_ch0_rxtermination_m),
      .XPIPE_PIPE_CH0_TXCHARISK       (q2q3_xpipe_pipe_ch0_txcharisk_m),
      .XPIPE_PIPE_CH0_TXCOMPLIANCE    (q2q3_xpipe_pipe_ch0_txcompliance_m),
      .XPIPE_PIPE_CH0_TXDATA          (q2q3_xpipe_pipe_ch0_txdata_m),
      .XPIPE_PIPE_CH0_TXDATAVALID     (q2q3_xpipe_pipe_ch0_txdatavalid_m),
      .XPIPE_PIPE_CH0_TXDEEMPH        (q2q3_xpipe_pipe_ch0_txdeemph_m),
      .XPIPE_PIPE_CH0_TXDETECTRXLOOPBACK(q2q3_xpipe_pipe_ch0_txdetectrxloopback_m),
      .XPIPE_PIPE_CH0_TXELECIDLE      (q2q3_xpipe_pipe_ch0_txelecidle_m),
      .XPIPE_PIPE_CH0_TXMAINCURSOR    (q2q3_xpipe_pipe_ch0_txmaincursor_m),
      .XPIPE_PIPE_CH0_TXMARGIN        (q2q3_xpipe_pipe_ch0_txmargin_m),
      .XPIPE_PIPE_CH0_TXPOSTCURSOR    (q2q3_xpipe_pipe_ch0_txpostcursor_m),
      .XPIPE_PIPE_CH0_TXPRECURSOR     (q2q3_xpipe_pipe_ch0_txprecursor_m),
      .XPIPE_PIPE_CH0_TXSTARTBLOCK    (q2q3_xpipe_pipe_ch0_txstartblock_m),
      .XPIPE_PIPE_CH0_TXSWING         (q2q3_xpipe_pipe_ch0_txswing_m),
      .XPIPE_PIPE_CH0_TXSYNCHEADER    (q2q3_xpipe_pipe_ch0_txsyncheader_m),

      .XPIPE_PIPE_CH0_POWERDOWN_M     (q3q4_xpipe_pipe_ch0_powerdown_m),
      .XPIPE_PIPE_CH0_RXPOLARITY_M    (q3q4_xpipe_pipe_ch0_rxpolarity_m),
      .XPIPE_PIPE_CH0_RXTERMINATION_M (q3q4_xpipe_pipe_ch0_rxtermination_m),
      .XPIPE_PIPE_CH0_TXCHARISK_M     (q3q4_xpipe_pipe_ch0_txcharisk_m),
      .XPIPE_PIPE_CH0_TXCOMPLIANCE_M  (q3q4_xpipe_pipe_ch0_txcompliance_m),
      .XPIPE_PIPE_CH0_TXDATAVALID_M   (q3q4_xpipe_pipe_ch0_txdatavalid_m),
      .XPIPE_PIPE_CH0_TXDATA_M        (q3q4_xpipe_pipe_ch0_txdata_m),
      .XPIPE_PIPE_CH0_TXDEEMPH_M      (q3q4_xpipe_pipe_ch0_txdeemph_m),
      .XPIPE_PIPE_CH0_TXELECIDLE_M    (q3q4_xpipe_pipe_ch0_txelecidle_m),
      .XPIPE_PIPE_CH0_TXMAINCURSOR_M  (q3q4_xpipe_pipe_ch0_txmaincursor_m),
      .XPIPE_PIPE_CH0_TXMARGIN_M      (q3q4_xpipe_pipe_ch0_txmargin_m),
      .XPIPE_PIPE_CH0_TXPOSTCURSOR_M  (q3q4_xpipe_pipe_ch0_txpostcursor_m),
      .XPIPE_PIPE_CH0_TXPRECURSOR_M   (q3q4_xpipe_pipe_ch0_txprecursor_m),
      .XPIPE_PIPE_CH0_TXSTARTBLOCK_M  (q3q4_xpipe_pipe_ch0_txstartblock_m),
      .XPIPE_PIPE_CH0_TXSWING_M       (q3q4_xpipe_pipe_ch0_txswing_m),
      .XPIPE_PIPE_CH0_TXSYNCHEADER_M  (q3q4_xpipe_pipe_ch0_txsyncheader_m),
      .XPIPE_PIPE_CH0_PHYSTATUS_M     (q3q4_xpipe_pipe_ch0_phystatus_m),
      .XPIPE_PIPE_CH0_RXCHARISK_M     (q3q4_xpipe_pipe_ch0_rxcharisk_m),
      .XPIPE_PIPE_CH0_RXDATAVALID_M   (q3q4_xpipe_pipe_ch0_rxdatavalid_m),
      .XPIPE_PIPE_CH0_RXDATA_M        (q3q4_xpipe_pipe_ch0_rxdata_m),
      .XPIPE_PIPE_CH0_RXELECIDLE_M    (q3q4_xpipe_pipe_ch0_rxelecidle_m),
      .XPIPE_PIPE_CH0_RXSTARTBLOCK_M  (q3q4_xpipe_pipe_ch0_rxstartblock_m),
      .XPIPE_PIPE_CH0_RXSTATUS_M      (q3q4_xpipe_pipe_ch0_rxstatus_m),
      .XPIPE_PIPE_CH0_RXSYNCHEADER_M  (q3q4_xpipe_pipe_ch0_rxsyncheader_m),
      .XPIPE_PIPE_CH0_RXVALID_M       (q3q4_xpipe_pipe_ch0_rxvalid_m),
      .XPIPE_PIPE_CH0_TXDETECTRXLOOPBACK_M(q3q4_xpipe_pipe_ch0_txdetectrxloopback_m),

      .XPIPE_PIPE_CH1_PHYSTATUS       (q2q3_xpipe_pipe_ch1_phystatus_m),
      .XPIPE_PIPE_CH1_RXCHARISK       (q2q3_xpipe_pipe_ch1_rxcharisk_m),
      .XPIPE_PIPE_CH1_RXDATA          (q2q3_xpipe_pipe_ch1_rxdata_m), //ifcpmxpipechannel1xpiperxdata
      .XPIPE_PIPE_CH1_RXDATAVALID     (q2q3_xpipe_pipe_ch1_rxdatavalid_m),
      .XPIPE_PIPE_CH1_RXELECIDLE      (q2q3_xpipe_pipe_ch1_rxelecidle_m),
      .XPIPE_PIPE_CH1_RXSTARTBLOCK    (q2q3_xpipe_pipe_ch1_rxstartblock_m),
      .XPIPE_PIPE_CH1_RXSTATUS        (q2q3_xpipe_pipe_ch1_rxstatus_m),
      .XPIPE_PIPE_CH1_RXSYNCHEADER    (q2q3_xpipe_pipe_ch1_rxsyncheader_m),
      .XPIPE_PIPE_CH1_RXVALID         (q2q3_xpipe_pipe_ch1_rxvalid_m),
      .XPIPE_PIPE_CH1_POWERDOWN       (q2q3_xpipe_pipe_ch1_powerdown_m),
      .XPIPE_PIPE_CH1_RXPOLARITY      (q2q3_xpipe_pipe_ch1_rxpolarity_m),
      .XPIPE_PIPE_CH1_RXTERMINATION   (q2q3_xpipe_pipe_ch1_rxtermination_m),
      .XPIPE_PIPE_CH1_TXCHARISK       (q2q3_xpipe_pipe_ch1_txcharisk_m),
      .XPIPE_PIPE_CH1_TXCOMPLIANCE    (q2q3_xpipe_pipe_ch1_txcompliance_m),
      .XPIPE_PIPE_CH1_TXDATA          (q2q3_xpipe_pipe_ch1_txdata_m),
      .XPIPE_PIPE_CH1_TXDATAVALID     (q2q3_xpipe_pipe_ch1_txdatavalid_m),
      .XPIPE_PIPE_CH1_TXDEEMPH        (q2q3_xpipe_pipe_ch1_txdeemph_m),
      .XPIPE_PIPE_CH1_TXDETECTRXLOOPBACK(q2q3_xpipe_pipe_ch1_txdetectrxloopback_m),
      .XPIPE_PIPE_CH1_TXELECIDLE      (q2q3_xpipe_pipe_ch1_txelecidle_m),
      .XPIPE_PIPE_CH1_TXMAINCURSOR    (q2q3_xpipe_pipe_ch1_txmaincursor_m),
      .XPIPE_PIPE_CH1_TXMARGIN        (q2q3_xpipe_pipe_ch1_txmargin_m),
      .XPIPE_PIPE_CH1_TXPOSTCURSOR    (q2q3_xpipe_pipe_ch1_txpostcursor_m),
      .XPIPE_PIPE_CH1_TXPRECURSOR     (q2q3_xpipe_pipe_ch1_txprecursor_m),
      .XPIPE_PIPE_CH1_TXSTARTBLOCK    (q2q3_xpipe_pipe_ch1_txstartblock_m),
      .XPIPE_PIPE_CH1_TXSWING         (q2q3_xpipe_pipe_ch1_txswing_m),
      .XPIPE_PIPE_CH1_TXSYNCHEADER    (q2q3_xpipe_pipe_ch1_txsyncheader_m),

      .XPIPE_PIPE_CH1_POWERDOWN_M     (q3q4_xpipe_pipe_ch1_powerdown_m),
      .XPIPE_PIPE_CH1_RXPOLARITY_M    (q3q4_xpipe_pipe_ch1_rxpolarity_m),
      .XPIPE_PIPE_CH1_RXTERMINATION_M (q3q4_xpipe_pipe_ch1_rxtermination_m),
      .XPIPE_PIPE_CH1_TXCHARISK_M     (q3q4_xpipe_pipe_ch1_txcharisk_m),
      .XPIPE_PIPE_CH1_TXCOMPLIANCE_M  (q3q4_xpipe_pipe_ch1_txcompliance_m),
      .XPIPE_PIPE_CH1_TXDATAVALID_M   (q3q4_xpipe_pipe_ch1_txdatavalid_m),
      .XPIPE_PIPE_CH1_TXDATA_M        (q3q4_xpipe_pipe_ch1_txdata_m),
      .XPIPE_PIPE_CH1_TXDEEMPH_M      (q3q4_xpipe_pipe_ch1_txdeemph_m),
      .XPIPE_PIPE_CH1_TXELECIDLE_M    (q3q4_xpipe_pipe_ch1_txelecidle_m),
      .XPIPE_PIPE_CH1_TXMAINCURSOR_M  (q3q4_xpipe_pipe_ch1_txmaincursor_m),
      .XPIPE_PIPE_CH1_TXMARGIN_M      (q3q4_xpipe_pipe_ch1_txmargin_m),
      .XPIPE_PIPE_CH1_TXPOSTCURSOR_M  (q3q4_xpipe_pipe_ch1_txpostcursor_m),
      .XPIPE_PIPE_CH1_TXPRECURSOR_M   (q3q4_xpipe_pipe_ch1_txprecursor_m),
      .XPIPE_PIPE_CH1_TXSTARTBLOCK_M  (q3q4_xpipe_pipe_ch1_txstartblock_m),
      .XPIPE_PIPE_CH1_TXSWING_M       (q3q4_xpipe_pipe_ch1_txswing_m),
      .XPIPE_PIPE_CH1_TXSYNCHEADER_M  (q3q4_xpipe_pipe_ch1_txsyncheader_m),
      .XPIPE_PIPE_CH1_PHYSTATUS_M     (q3q4_xpipe_pipe_ch1_phystatus_m),
      .XPIPE_PIPE_CH1_RXCHARISK_M     (q3q4_xpipe_pipe_ch1_rxcharisk_m),
      .XPIPE_PIPE_CH1_RXDATAVALID_M   (q3q4_xpipe_pipe_ch1_rxdatavalid_m),
      .XPIPE_PIPE_CH1_RXDATA_M        (q3q4_xpipe_pipe_ch1_rxdata_m),
      .XPIPE_PIPE_CH1_RXELECIDLE_M    (q3q4_xpipe_pipe_ch1_rxelecidle_m),
      .XPIPE_PIPE_CH1_RXSTARTBLOCK_M  (q3q4_xpipe_pipe_ch1_rxstartblock_m),
      .XPIPE_PIPE_CH1_RXSTATUS_M      (q3q4_xpipe_pipe_ch1_rxstatus_m),
      .XPIPE_PIPE_CH1_RXSYNCHEADER_M  (q3q4_xpipe_pipe_ch1_rxsyncheader_m),
      .XPIPE_PIPE_CH1_RXVALID_M       (q3q4_xpipe_pipe_ch1_rxvalid_m),
      .XPIPE_PIPE_CH1_TXDETECTRXLOOPBACK_M(q3q4_xpipe_pipe_ch1_txdetectrxloopback_m),

      .XPIPE_PIPE_CH2_PHYSTATUS       (q2q3_xpipe_pipe_ch2_phystatus_m),
      .XPIPE_PIPE_CH2_RXCHARISK       (q2q3_xpipe_pipe_ch2_rxcharisk_m),
      .XPIPE_PIPE_CH2_RXDATA          (q2q3_xpipe_pipe_ch2_rxdata_m), //ifcpmxpipechannel2xpiperxdata
      .XPIPE_PIPE_CH2_RXDATAVALID     (q2q3_xpipe_pipe_ch2_rxdatavalid_m),
      .XPIPE_PIPE_CH2_RXELECIDLE      (q2q3_xpipe_pipe_ch2_rxelecidle_m),
      .XPIPE_PIPE_CH2_RXSTARTBLOCK    (q2q3_xpipe_pipe_ch2_rxstartblock_m),
      .XPIPE_PIPE_CH2_RXSTATUS        (q2q3_xpipe_pipe_ch2_rxstatus_m),
      .XPIPE_PIPE_CH2_RXSYNCHEADER    (q2q3_xpipe_pipe_ch2_rxsyncheader_m),
      .XPIPE_PIPE_CH2_RXVALID         (q2q3_xpipe_pipe_ch2_rxvalid_m),
      .XPIPE_PIPE_CH2_POWERDOWN       (q2q3_xpipe_pipe_ch2_powerdown_m),
      .XPIPE_PIPE_CH2_RXPOLARITY      (q2q3_xpipe_pipe_ch2_rxpolarity_m),
      .XPIPE_PIPE_CH2_RXTERMINATION   (q2q3_xpipe_pipe_ch2_rxtermination_m),
      .XPIPE_PIPE_CH2_TXCHARISK       (q2q3_xpipe_pipe_ch2_txcharisk_m),
      .XPIPE_PIPE_CH2_TXCOMPLIANCE    (q2q3_xpipe_pipe_ch2_txcompliance_m),
      .XPIPE_PIPE_CH2_TXDATA          (q2q3_xpipe_pipe_ch2_txdata_m),
      .XPIPE_PIPE_CH2_TXDATAVALID     (q2q3_xpipe_pipe_ch2_txdatavalid_m),
      .XPIPE_PIPE_CH2_TXDEEMPH        (q2q3_xpipe_pipe_ch2_txdeemph_m),
      .XPIPE_PIPE_CH2_TXDETECTRXLOOPBACK(q2q3_xpipe_pipe_ch2_txdetectrxloopback_m),
      .XPIPE_PIPE_CH2_TXELECIDLE      (q2q3_xpipe_pipe_ch2_txelecidle_m),
      .XPIPE_PIPE_CH2_TXMAINCURSOR    (q2q3_xpipe_pipe_ch2_txmaincursor_m),
      .XPIPE_PIPE_CH2_TXMARGIN        (q2q3_xpipe_pipe_ch2_txmargin_m),
      .XPIPE_PIPE_CH2_TXPOSTCURSOR    (q2q3_xpipe_pipe_ch2_txpostcursor_m),
      .XPIPE_PIPE_CH2_TXPRECURSOR     (q2q3_xpipe_pipe_ch2_txprecursor_m),
      .XPIPE_PIPE_CH2_TXSTARTBLOCK    (q2q3_xpipe_pipe_ch2_txstartblock_m),
      .XPIPE_PIPE_CH2_TXSWING         (q2q3_xpipe_pipe_ch2_txswing_m),
      .XPIPE_PIPE_CH2_TXSYNCHEADER    (q2q3_xpipe_pipe_ch2_txsyncheader_m),

      .XPIPE_PIPE_CH2_POWERDOWN_M     (q3q4_xpipe_pipe_ch2_powerdown_m),
      .XPIPE_PIPE_CH2_RXPOLARITY_M    (q3q4_xpipe_pipe_ch2_rxpolarity_m),
      .XPIPE_PIPE_CH2_RXTERMINATION_M (q3q4_xpipe_pipe_ch2_rxtermination_m),
      .XPIPE_PIPE_CH2_TXCHARISK_M     (q3q4_xpipe_pipe_ch2_txcharisk_m),
      .XPIPE_PIPE_CH2_TXCOMPLIANCE_M  (q3q4_xpipe_pipe_ch2_txcompliance_m),
      .XPIPE_PIPE_CH2_TXDATAVALID_M   (q3q4_xpipe_pipe_ch2_txdatavalid_m),
      .XPIPE_PIPE_CH2_TXDATA_M        (q3q4_xpipe_pipe_ch2_txdata_m),
      .XPIPE_PIPE_CH2_TXDEEMPH_M      (q3q4_xpipe_pipe_ch2_txdeemph_m),
      .XPIPE_PIPE_CH2_TXELECIDLE_M    (q3q4_xpipe_pipe_ch2_txelecidle_m),
      .XPIPE_PIPE_CH2_TXMAINCURSOR_M  (q3q4_xpipe_pipe_ch2_txmaincursor_m),
      .XPIPE_PIPE_CH2_TXMARGIN_M      (q3q4_xpipe_pipe_ch2_txmargin_m),
      .XPIPE_PIPE_CH2_TXPOSTCURSOR_M  (q3q4_xpipe_pipe_ch2_txpostcursor_m),
      .XPIPE_PIPE_CH2_TXPRECURSOR_M   (q3q4_xpipe_pipe_ch2_txprecursor_m),
      .XPIPE_PIPE_CH2_TXSTARTBLOCK_M  (q3q4_xpipe_pipe_ch2_txstartblock_m),
      .XPIPE_PIPE_CH2_TXSWING_M       (q3q4_xpipe_pipe_ch2_txswing_m),
      .XPIPE_PIPE_CH2_TXSYNCHEADER_M  (q3q4_xpipe_pipe_ch2_txsyncheader_m),
      .XPIPE_PIPE_CH2_PHYSTATUS_M     (q3q4_xpipe_pipe_ch2_phystatus_m),
      .XPIPE_PIPE_CH2_RXCHARISK_M     (q3q4_xpipe_pipe_ch2_rxcharisk_m),
      .XPIPE_PIPE_CH2_RXDATAVALID_M   (q3q4_xpipe_pipe_ch2_rxdatavalid_m),
      .XPIPE_PIPE_CH2_RXDATA_M        (q3q4_xpipe_pipe_ch2_rxdata_m),
      .XPIPE_PIPE_CH2_RXELECIDLE_M    (q3q4_xpipe_pipe_ch2_rxelecidle_m),
      .XPIPE_PIPE_CH2_RXSTARTBLOCK_M  (q3q4_xpipe_pipe_ch2_rxstartblock_m),
      .XPIPE_PIPE_CH2_RXSTATUS_M      (q3q4_xpipe_pipe_ch2_rxstatus_m),
      .XPIPE_PIPE_CH2_RXSYNCHEADER_M  (q3q4_xpipe_pipe_ch2_rxsyncheader_m),
      .XPIPE_PIPE_CH2_RXVALID_M       (q3q4_xpipe_pipe_ch2_rxvalid_m),
      .XPIPE_PIPE_CH2_TXDETECTRXLOOPBACK_M(q3q4_xpipe_pipe_ch2_txdetectrxloopback_m),

      .XPIPE_PIPE_CH3_PHYSTATUS       (q2q3_xpipe_pipe_ch3_phystatus_m),
      .XPIPE_PIPE_CH3_RXCHARISK       (q2q3_xpipe_pipe_ch3_rxcharisk_m),
      .XPIPE_PIPE_CH3_RXDATA          (q2q3_xpipe_pipe_ch3_rxdata_m), //ifcpmxpipechannel3xpiperxdata
      .XPIPE_PIPE_CH3_RXDATAVALID     (q2q3_xpipe_pipe_ch3_rxdatavalid_m),
      .XPIPE_PIPE_CH3_RXELECIDLE      (q2q3_xpipe_pipe_ch3_rxelecidle_m),
      .XPIPE_PIPE_CH3_RXSTARTBLOCK    (q2q3_xpipe_pipe_ch3_rxstartblock_m),
      .XPIPE_PIPE_CH3_RXSTATUS        (q2q3_xpipe_pipe_ch3_rxstatus_m),
      .XPIPE_PIPE_CH3_RXSYNCHEADER    (q2q3_xpipe_pipe_ch3_rxsyncheader_m),
      .XPIPE_PIPE_CH3_RXVALID         (q2q3_xpipe_pipe_ch3_rxvalid_m),
      .XPIPE_PIPE_CH3_POWERDOWN       (q2q3_xpipe_pipe_ch3_powerdown_m),
      .XPIPE_PIPE_CH3_RXPOLARITY      (q2q3_xpipe_pipe_ch3_rxpolarity_m),
      .XPIPE_PIPE_CH3_RXTERMINATION   (q2q3_xpipe_pipe_ch3_rxtermination_m),
      .XPIPE_PIPE_CH3_TXCHARISK       (q2q3_xpipe_pipe_ch3_txcharisk_m),
      .XPIPE_PIPE_CH3_TXCOMPLIANCE    (q2q3_xpipe_pipe_ch3_txcompliance_m),
      .XPIPE_PIPE_CH3_TXDATA          (q2q3_xpipe_pipe_ch3_txdata_m),
      .XPIPE_PIPE_CH3_TXDATAVALID     (q2q3_xpipe_pipe_ch3_txdatavalid_m),
      .XPIPE_PIPE_CH3_TXDEEMPH        (q2q3_xpipe_pipe_ch3_txdeemph_m),
      .XPIPE_PIPE_CH3_TXDETECTRXLOOPBACK(q2q3_xpipe_pipe_ch3_txdetectrxloopback_m),
      .XPIPE_PIPE_CH3_TXELECIDLE      (q2q3_xpipe_pipe_ch3_txelecidle_m),
      .XPIPE_PIPE_CH3_TXMAINCURSOR    (q2q3_xpipe_pipe_ch3_txmaincursor_m),
      .XPIPE_PIPE_CH3_TXMARGIN        (q2q3_xpipe_pipe_ch3_txmargin_m),
      .XPIPE_PIPE_CH3_TXPOSTCURSOR    (q2q3_xpipe_pipe_ch3_txpostcursor_m),
      .XPIPE_PIPE_CH3_TXPRECURSOR     (q2q3_xpipe_pipe_ch3_txprecursor_m),
      .XPIPE_PIPE_CH3_TXSTARTBLOCK    (q2q3_xpipe_pipe_ch3_txstartblock_m),
      .XPIPE_PIPE_CH3_TXSWING         (q2q3_xpipe_pipe_ch3_txswing_m),
      .XPIPE_PIPE_CH3_TXSYNCHEADER    (q2q3_xpipe_pipe_ch3_txsyncheader_m),

      .XPIPE_PIPE_CH3_POWERDOWN_M     (q3q4_xpipe_pipe_ch3_powerdown_m),
      .XPIPE_PIPE_CH3_RXPOLARITY_M    (q3q4_xpipe_pipe_ch3_rxpolarity_m),
      .XPIPE_PIPE_CH3_RXTERMINATION_M (q3q4_xpipe_pipe_ch3_rxtermination_m),
      .XPIPE_PIPE_CH3_TXCHARISK_M     (q3q4_xpipe_pipe_ch3_txcharisk_m),
      .XPIPE_PIPE_CH3_TXCOMPLIANCE_M  (q3q4_xpipe_pipe_ch3_txcompliance_m),
      .XPIPE_PIPE_CH3_TXDATAVALID_M   (q3q4_xpipe_pipe_ch3_txdatavalid_m),
      .XPIPE_PIPE_CH3_TXDATA_M        (q3q4_xpipe_pipe_ch3_txdata_m),
      .XPIPE_PIPE_CH3_TXDEEMPH_M      (q3q4_xpipe_pipe_ch3_txdeemph_m),
      .XPIPE_PIPE_CH3_TXELECIDLE_M    (q3q4_xpipe_pipe_ch3_txelecidle_m),
      .XPIPE_PIPE_CH3_TXMAINCURSOR_M  (q3q4_xpipe_pipe_ch3_txmaincursor_m),
      .XPIPE_PIPE_CH3_TXMARGIN_M      (q3q4_xpipe_pipe_ch3_txmargin_m),
      .XPIPE_PIPE_CH3_TXPOSTCURSOR_M  (q3q4_xpipe_pipe_ch3_txpostcursor_m),
      .XPIPE_PIPE_CH3_TXPRECURSOR_M   (q3q4_xpipe_pipe_ch3_txprecursor_m),
      .XPIPE_PIPE_CH3_TXSTARTBLOCK_M  (q3q4_xpipe_pipe_ch3_txstartblock_m),
      .XPIPE_PIPE_CH3_TXSWING_M       (q3q4_xpipe_pipe_ch3_txswing_m),
      .XPIPE_PIPE_CH3_TXSYNCHEADER_M  (q3q4_xpipe_pipe_ch3_txsyncheader_m),
      .XPIPE_PIPE_CH3_PHYSTATUS_M     (q3q4_xpipe_pipe_ch3_phystatus_m),
      .XPIPE_PIPE_CH3_RXCHARISK_M     (q3q4_xpipe_pipe_ch3_rxcharisk_m),
      .XPIPE_PIPE_CH3_RXDATAVALID_M   (q3q4_xpipe_pipe_ch3_rxdatavalid_m),
      .XPIPE_PIPE_CH3_RXDATA_M        (q3q4_xpipe_pipe_ch3_rxdata_m),
      .XPIPE_PIPE_CH3_RXELECIDLE_M    (q3q4_xpipe_pipe_ch3_rxelecidle_m),
      .XPIPE_PIPE_CH3_RXSTARTBLOCK_M  (q3q4_xpipe_pipe_ch3_rxstartblock_m),
      .XPIPE_PIPE_CH3_RXSTATUS_M      (q3q4_xpipe_pipe_ch3_rxstatus_m),
      .XPIPE_PIPE_CH3_RXSYNCHEADER_M  (q3q4_xpipe_pipe_ch3_rxsyncheader_m),
      .XPIPE_PIPE_CH3_RXVALID_M       (q3q4_xpipe_pipe_ch3_rxvalid_m),
      .XPIPE_PIPE_CH3_TXDETECTRXLOOPBACK_M(q3q4_xpipe_pipe_ch3_txdetectrxloopback_m),

      .XPIPE_PIPE_CH4_PHYSTATUS       (q2q3_xpipe_pipe_ch4_phystatus_m),
      .XPIPE_PIPE_CH4_RXCHARISK       (q2q3_xpipe_pipe_ch4_rxcharisk_m),
      .XPIPE_PIPE_CH4_RXDATA          (q2q3_xpipe_pipe_ch4_rxdata_m), //ifcpmxpipechannel4xpiperxdata
      .XPIPE_PIPE_CH4_RXDATAVALID     (q2q3_xpipe_pipe_ch4_rxdatavalid_m),
      .XPIPE_PIPE_CH4_RXELECIDLE      (q2q3_xpipe_pipe_ch4_rxelecidle_m),
      .XPIPE_PIPE_CH4_RXSTARTBLOCK    (q2q3_xpipe_pipe_ch4_rxstartblock_m),
      .XPIPE_PIPE_CH4_RXSTATUS        (q2q3_xpipe_pipe_ch4_rxstatus_m),
      .XPIPE_PIPE_CH4_RXSYNCHEADER    (q2q3_xpipe_pipe_ch4_rxsyncheader_m),
      .XPIPE_PIPE_CH4_RXVALID         (q2q3_xpipe_pipe_ch4_rxvalid_m),
      .XPIPE_PIPE_CH4_POWERDOWN       (q2q3_xpipe_pipe_ch4_powerdown_m),
      .XPIPE_PIPE_CH4_RXPOLARITY      (q2q3_xpipe_pipe_ch4_rxpolarity_m),
      .XPIPE_PIPE_CH4_RXTERMINATION   (q2q3_xpipe_pipe_ch4_rxtermination_m),
      .XPIPE_PIPE_CH4_TXCHARISK       (q2q3_xpipe_pipe_ch4_txcharisk_m),
      .XPIPE_PIPE_CH4_TXCOMPLIANCE    (q2q3_xpipe_pipe_ch4_txcompliance_m),
      .XPIPE_PIPE_CH4_TXDATA          (q2q3_xpipe_pipe_ch4_txdata_m),
      .XPIPE_PIPE_CH4_TXDATAVALID     (q2q3_xpipe_pipe_ch4_txdatavalid_m),
      .XPIPE_PIPE_CH4_TXDEEMPH        (q2q3_xpipe_pipe_ch4_txdeemph_m),
      .XPIPE_PIPE_CH4_TXDETECTRXLOOPBACK(q2q3_xpipe_pipe_ch4_txdetectrxloopback_m),
      .XPIPE_PIPE_CH4_TXELECIDLE      (q2q3_xpipe_pipe_ch4_txelecidle_m),
      .XPIPE_PIPE_CH4_TXMAINCURSOR    (q2q3_xpipe_pipe_ch4_txmaincursor_m),
      .XPIPE_PIPE_CH4_TXMARGIN        (q2q3_xpipe_pipe_ch4_txmargin_m),
      .XPIPE_PIPE_CH4_TXPOSTCURSOR    (q2q3_xpipe_pipe_ch4_txpostcursor_m),
      .XPIPE_PIPE_CH4_TXPRECURSOR     (q2q3_xpipe_pipe_ch4_txprecursor_m),
      .XPIPE_PIPE_CH4_TXSTARTBLOCK    (q2q3_xpipe_pipe_ch4_txstartblock_m),
      .XPIPE_PIPE_CH4_TXSWING         (q2q3_xpipe_pipe_ch4_txswing_m),
      .XPIPE_PIPE_CH4_TXSYNCHEADER    (q2q3_xpipe_pipe_ch4_txsyncheader_m),

      .XPIPE_PIPE_CH4_POWERDOWN_M     (q3q4_xpipe_pipe_ch4_powerdown_m),
      .XPIPE_PIPE_CH4_RXPOLARITY_M    (q3q4_xpipe_pipe_ch4_rxpolarity_m),
      .XPIPE_PIPE_CH4_RXTERMINATION_M (q3q4_xpipe_pipe_ch4_rxtermination_m),
      .XPIPE_PIPE_CH4_TXCHARISK_M     (q3q4_xpipe_pipe_ch4_txcharisk_m),
      .XPIPE_PIPE_CH4_TXCOMPLIANCE_M  (q3q4_xpipe_pipe_ch4_txcompliance_m),
      .XPIPE_PIPE_CH4_TXDATAVALID_M   (q3q4_xpipe_pipe_ch4_txdatavalid_m),
      .XPIPE_PIPE_CH4_TXDATA_M        (q3q4_xpipe_pipe_ch4_txdata_m),
      .XPIPE_PIPE_CH4_TXDEEMPH_M      (q3q4_xpipe_pipe_ch4_txdeemph_m),
      .XPIPE_PIPE_CH4_TXELECIDLE_M    (q3q4_xpipe_pipe_ch4_txelecidle_m),
      .XPIPE_PIPE_CH4_TXMAINCURSOR_M  (q3q4_xpipe_pipe_ch4_txmaincursor_m),
      .XPIPE_PIPE_CH4_TXMARGIN_M      (q3q4_xpipe_pipe_ch4_txmargin_m),
      .XPIPE_PIPE_CH4_TXPOSTCURSOR_M  (q3q4_xpipe_pipe_ch4_txpostcursor_m),
      .XPIPE_PIPE_CH4_TXPRECURSOR_M   (q3q4_xpipe_pipe_ch4_txprecursor_m),
      .XPIPE_PIPE_CH4_TXSTARTBLOCK_M  (q3q4_xpipe_pipe_ch4_txstartblock_m),
      .XPIPE_PIPE_CH4_TXSWING_M       (q3q4_xpipe_pipe_ch4_txswing_m),
      .XPIPE_PIPE_CH4_TXSYNCHEADER_M  (q3q4_xpipe_pipe_ch4_txsyncheader_m),
      .XPIPE_PIPE_CH4_PHYSTATUS_M     (q3q4_xpipe_pipe_ch4_phystatus_m),
      .XPIPE_PIPE_CH4_RXCHARISK_M     (q3q4_xpipe_pipe_ch4_rxcharisk_m),
      .XPIPE_PIPE_CH4_RXDATAVALID_M   (q3q4_xpipe_pipe_ch4_rxdatavalid_m),
      .XPIPE_PIPE_CH4_RXDATA_M        (q3q4_xpipe_pipe_ch4_rxdata_m),
      .XPIPE_PIPE_CH4_RXELECIDLE_M    (q3q4_xpipe_pipe_ch4_rxelecidle_m),
      .XPIPE_PIPE_CH4_RXSTARTBLOCK_M  (q3q4_xpipe_pipe_ch4_rxstartblock_m),
      .XPIPE_PIPE_CH4_RXSTATUS_M      (q3q4_xpipe_pipe_ch4_rxstatus_m),
      .XPIPE_PIPE_CH4_RXSYNCHEADER_M  (q3q4_xpipe_pipe_ch4_rxsyncheader_m),
      .XPIPE_PIPE_CH4_RXVALID_M       (q3q4_xpipe_pipe_ch4_rxvalid_m),
      .XPIPE_PIPE_CH4_TXDETECTRXLOOPBACK_M(q3q4_xpipe_pipe_ch4_txdetectrxloopback_m),

      .XPIPE_PIPE_CH5_PHYSTATUS       (q2q3_xpipe_pipe_ch5_phystatus_m),
      .XPIPE_PIPE_CH5_RXCHARISK       (q2q3_xpipe_pipe_ch5_rxcharisk_m),
      .XPIPE_PIPE_CH5_RXDATA          (q2q3_xpipe_pipe_ch5_rxdata_m), //ifcpmxpipechannel5xpiperxdata
      .XPIPE_PIPE_CH5_RXDATAVALID     (q2q3_xpipe_pipe_ch5_rxdatavalid_m),
      .XPIPE_PIPE_CH5_RXELECIDLE      (q2q3_xpipe_pipe_ch5_rxelecidle_m),
      .XPIPE_PIPE_CH5_RXSTARTBLOCK    (q2q3_xpipe_pipe_ch5_rxstartblock_m),
      .XPIPE_PIPE_CH5_RXSTATUS        (q2q3_xpipe_pipe_ch5_rxstatus_m),
      .XPIPE_PIPE_CH5_RXSYNCHEADER    (q2q3_xpipe_pipe_ch5_rxsyncheader_m),
      .XPIPE_PIPE_CH5_RXVALID         (q2q3_xpipe_pipe_ch5_rxvalid_m),
      .XPIPE_PIPE_CH5_POWERDOWN       (q2q3_xpipe_pipe_ch5_powerdown_m),
      .XPIPE_PIPE_CH5_RXPOLARITY      (q2q3_xpipe_pipe_ch5_rxpolarity_m),
      .XPIPE_PIPE_CH5_RXTERMINATION   (q2q3_xpipe_pipe_ch5_rxtermination_m),
      .XPIPE_PIPE_CH5_TXCHARISK       (q2q3_xpipe_pipe_ch5_txcharisk_m),
      .XPIPE_PIPE_CH5_TXCOMPLIANCE    (q2q3_xpipe_pipe_ch5_txcompliance_m),
      .XPIPE_PIPE_CH5_TXDATA          (q2q3_xpipe_pipe_ch5_txdata_m),
      .XPIPE_PIPE_CH5_TXDATAVALID     (q2q3_xpipe_pipe_ch5_txdatavalid_m),
      .XPIPE_PIPE_CH5_TXDEEMPH        (q2q3_xpipe_pipe_ch5_txdeemph_m),
      .XPIPE_PIPE_CH5_TXDETECTRXLOOPBACK(q2q3_xpipe_pipe_ch5_txdetectrxloopback_m),
      .XPIPE_PIPE_CH5_TXELECIDLE      (q2q3_xpipe_pipe_ch5_txelecidle_m),
      .XPIPE_PIPE_CH5_TXMAINCURSOR    (q2q3_xpipe_pipe_ch5_txmaincursor_m),
      .XPIPE_PIPE_CH5_TXMARGIN        (q2q3_xpipe_pipe_ch5_txmargin_m),
      .XPIPE_PIPE_CH5_TXPOSTCURSOR    (q2q3_xpipe_pipe_ch5_txpostcursor_m),
      .XPIPE_PIPE_CH5_TXPRECURSOR     (q2q3_xpipe_pipe_ch5_txprecursor_m),
      .XPIPE_PIPE_CH5_TXSTARTBLOCK    (q2q3_xpipe_pipe_ch5_txstartblock_m),
      .XPIPE_PIPE_CH5_TXSWING         (q2q3_xpipe_pipe_ch5_txswing_m),
      .XPIPE_PIPE_CH5_TXSYNCHEADER    (q2q3_xpipe_pipe_ch5_txsyncheader_m),

      .XPIPE_PIPE_CH5_POWERDOWN_M     (q3q4_xpipe_pipe_ch5_powerdown_m),
      .XPIPE_PIPE_CH5_RXPOLARITY_M    (q3q4_xpipe_pipe_ch5_rxpolarity_m),
      .XPIPE_PIPE_CH5_RXTERMINATION_M (q3q4_xpipe_pipe_ch5_rxtermination_m),
      .XPIPE_PIPE_CH5_TXCHARISK_M     (q3q4_xpipe_pipe_ch5_txcharisk_m),
      .XPIPE_PIPE_CH5_TXCOMPLIANCE_M  (q3q4_xpipe_pipe_ch5_txcompliance_m),
      .XPIPE_PIPE_CH5_TXDATAVALID_M   (q3q4_xpipe_pipe_ch5_txdatavalid_m),
      .XPIPE_PIPE_CH5_TXDATA_M        (q3q4_xpipe_pipe_ch5_txdata_m),
      .XPIPE_PIPE_CH5_TXDEEMPH_M      (q3q4_xpipe_pipe_ch5_txdeemph_m),
      .XPIPE_PIPE_CH5_TXELECIDLE_M    (q3q4_xpipe_pipe_ch5_txelecidle_m),
      .XPIPE_PIPE_CH5_TXMAINCURSOR_M  (q3q4_xpipe_pipe_ch5_txmaincursor_m),
      .XPIPE_PIPE_CH5_TXMARGIN_M      (q3q4_xpipe_pipe_ch5_txmargin_m),
      .XPIPE_PIPE_CH5_TXPOSTCURSOR_M  (q3q4_xpipe_pipe_ch5_txpostcursor_m),
      .XPIPE_PIPE_CH5_TXPRECURSOR_M   (q3q4_xpipe_pipe_ch5_txprecursor_m),
      .XPIPE_PIPE_CH5_TXSTARTBLOCK_M  (q3q4_xpipe_pipe_ch5_txstartblock_m),
      .XPIPE_PIPE_CH5_TXSWING_M       (q3q4_xpipe_pipe_ch5_txswing_m),
      .XPIPE_PIPE_CH5_TXSYNCHEADER_M  (q3q4_xpipe_pipe_ch5_txsyncheader_m),
      .XPIPE_PIPE_CH5_PHYSTATUS_M     (q3q4_xpipe_pipe_ch5_phystatus_m),
      .XPIPE_PIPE_CH5_RXCHARISK_M     (q3q4_xpipe_pipe_ch5_rxcharisk_m),
      .XPIPE_PIPE_CH5_RXDATAVALID_M   (q3q4_xpipe_pipe_ch5_rxdatavalid_m),
      .XPIPE_PIPE_CH5_RXDATA_M        (q3q4_xpipe_pipe_ch5_rxdata_m),
      .XPIPE_PIPE_CH5_RXELECIDLE_M    (q3q4_xpipe_pipe_ch5_rxelecidle_m),
      .XPIPE_PIPE_CH5_RXSTARTBLOCK_M  (q3q4_xpipe_pipe_ch5_rxstartblock_m),
      .XPIPE_PIPE_CH5_RXSTATUS_M      (q3q4_xpipe_pipe_ch5_rxstatus_m),
      .XPIPE_PIPE_CH5_RXSYNCHEADER_M  (q3q4_xpipe_pipe_ch5_rxsyncheader_m),
      .XPIPE_PIPE_CH5_RXVALID_M       (q3q4_xpipe_pipe_ch5_rxvalid_m),
      .XPIPE_PIPE_CH5_TXDETECTRXLOOPBACK_M(q3q4_xpipe_pipe_ch5_txdetectrxloopback_m),

      .XPIPE_PIPE_CH6_PHYSTATUS       (q2q3_xpipe_pipe_ch6_phystatus_m),
      .XPIPE_PIPE_CH6_RXCHARISK       (q2q3_xpipe_pipe_ch6_rxcharisk_m),
      .XPIPE_PIPE_CH6_RXDATA          (q2q3_xpipe_pipe_ch6_rxdata_m), //ifcpmxpipechannel6xpiperxdata
      .XPIPE_PIPE_CH6_RXDATAVALID     (q2q3_xpipe_pipe_ch6_rxdatavalid_m),
      .XPIPE_PIPE_CH6_RXELECIDLE      (q2q3_xpipe_pipe_ch6_rxelecidle_m),
      .XPIPE_PIPE_CH6_RXSTARTBLOCK    (q2q3_xpipe_pipe_ch6_rxstartblock_m),
      .XPIPE_PIPE_CH6_RXSTATUS        (q2q3_xpipe_pipe_ch6_rxstatus_m),
      .XPIPE_PIPE_CH6_RXSYNCHEADER    (q2q3_xpipe_pipe_ch6_rxsyncheader_m),
      .XPIPE_PIPE_CH6_RXVALID         (q2q3_xpipe_pipe_ch6_rxvalid_m),
      .XPIPE_PIPE_CH6_POWERDOWN       (q2q3_xpipe_pipe_ch6_powerdown_m),
      .XPIPE_PIPE_CH6_RXPOLARITY      (q2q3_xpipe_pipe_ch6_rxpolarity_m),
      .XPIPE_PIPE_CH6_RXTERMINATION   (q2q3_xpipe_pipe_ch6_rxtermination_m),
      .XPIPE_PIPE_CH6_TXCHARISK       (q2q3_xpipe_pipe_ch6_txcharisk_m),
      .XPIPE_PIPE_CH6_TXCOMPLIANCE    (q2q3_xpipe_pipe_ch6_txcompliance_m),
      .XPIPE_PIPE_CH6_TXDATA          (q2q3_xpipe_pipe_ch6_txdata_m),
      .XPIPE_PIPE_CH6_TXDATAVALID     (q2q3_xpipe_pipe_ch6_txdatavalid_m),
      .XPIPE_PIPE_CH6_TXDEEMPH        (q2q3_xpipe_pipe_ch6_txdeemph_m),
      .XPIPE_PIPE_CH6_TXDETECTRXLOOPBACK(q2q3_xpipe_pipe_ch6_txdetectrxloopback_m),
      .XPIPE_PIPE_CH6_TXELECIDLE      (q2q3_xpipe_pipe_ch6_txelecidle_m),
      .XPIPE_PIPE_CH6_TXMAINCURSOR    (q2q3_xpipe_pipe_ch6_txmaincursor_m),
      .XPIPE_PIPE_CH6_TXMARGIN        (q2q3_xpipe_pipe_ch6_txmargin_m),
      .XPIPE_PIPE_CH6_TXPOSTCURSOR    (q2q3_xpipe_pipe_ch6_txpostcursor_m),
      .XPIPE_PIPE_CH6_TXPRECURSOR     (q2q3_xpipe_pipe_ch6_txprecursor_m),
      .XPIPE_PIPE_CH6_TXSTARTBLOCK    (q2q3_xpipe_pipe_ch6_txstartblock_m),
      .XPIPE_PIPE_CH6_TXSWING         (q2q3_xpipe_pipe_ch6_txswing_m),
      .XPIPE_PIPE_CH6_TXSYNCHEADER    (q2q3_xpipe_pipe_ch6_txsyncheader_m),

      .XPIPE_PIPE_CH6_POWERDOWN_M     (q3q4_xpipe_pipe_ch6_powerdown_m),
      .XPIPE_PIPE_CH6_RXPOLARITY_M    (q3q4_xpipe_pipe_ch6_rxpolarity_m),
      .XPIPE_PIPE_CH6_RXTERMINATION_M (q3q4_xpipe_pipe_ch6_rxtermination_m),
      .XPIPE_PIPE_CH6_TXCHARISK_M     (q3q4_xpipe_pipe_ch6_txcharisk_m),
      .XPIPE_PIPE_CH6_TXCOMPLIANCE_M  (q3q4_xpipe_pipe_ch6_txcompliance_m),
      .XPIPE_PIPE_CH6_TXDATAVALID_M   (q3q4_xpipe_pipe_ch6_txdatavalid_m),
      .XPIPE_PIPE_CH6_TXDATA_M        (q3q4_xpipe_pipe_ch6_txdata_m),
      .XPIPE_PIPE_CH6_TXDEEMPH_M      (q3q4_xpipe_pipe_ch6_txdeemph_m),
      .XPIPE_PIPE_CH6_TXELECIDLE_M    (q3q4_xpipe_pipe_ch6_txelecidle_m),
      .XPIPE_PIPE_CH6_TXMAINCURSOR_M  (q3q4_xpipe_pipe_ch6_txmaincursor_m),
      .XPIPE_PIPE_CH6_TXMARGIN_M      (q3q4_xpipe_pipe_ch6_txmargin_m),
      .XPIPE_PIPE_CH6_TXPOSTCURSOR_M  (q3q4_xpipe_pipe_ch6_txpostcursor_m),
      .XPIPE_PIPE_CH6_TXPRECURSOR_M   (q3q4_xpipe_pipe_ch6_txprecursor_m),
      .XPIPE_PIPE_CH6_TXSTARTBLOCK_M  (q3q4_xpipe_pipe_ch6_txstartblock_m),
      .XPIPE_PIPE_CH6_TXSWING_M       (q3q4_xpipe_pipe_ch6_txswing_m),
      .XPIPE_PIPE_CH6_TXSYNCHEADER_M  (q3q4_xpipe_pipe_ch6_txsyncheader_m),
      .XPIPE_PIPE_CH6_PHYSTATUS_M     (q3q4_xpipe_pipe_ch6_phystatus_m),
      .XPIPE_PIPE_CH6_RXCHARISK_M     (q3q4_xpipe_pipe_ch6_rxcharisk_m),
      .XPIPE_PIPE_CH6_RXDATAVALID_M   (q3q4_xpipe_pipe_ch6_rxdatavalid_m),
      .XPIPE_PIPE_CH6_RXDATA_M        (q3q4_xpipe_pipe_ch6_rxdata_m),
      .XPIPE_PIPE_CH6_RXELECIDLE_M    (q3q4_xpipe_pipe_ch6_rxelecidle_m),
      .XPIPE_PIPE_CH6_RXSTARTBLOCK_M  (q3q4_xpipe_pipe_ch6_rxstartblock_m),
      .XPIPE_PIPE_CH6_RXSTATUS_M      (q3q4_xpipe_pipe_ch6_rxstatus_m),
      .XPIPE_PIPE_CH6_RXSYNCHEADER_M  (q3q4_xpipe_pipe_ch6_rxsyncheader_m),
      .XPIPE_PIPE_CH6_RXVALID_M       (q3q4_xpipe_pipe_ch6_rxvalid_m),
      .XPIPE_PIPE_CH6_TXDETECTRXLOOPBACK_M(q3q4_xpipe_pipe_ch6_txdetectrxloopback_m),

      .XPIPE_PIPE_CH7_PHYSTATUS       (q2q3_xpipe_pipe_ch7_phystatus_m),
      .XPIPE_PIPE_CH7_RXCHARISK       (q2q3_xpipe_pipe_ch7_rxcharisk_m),
      .XPIPE_PIPE_CH7_RXDATA          (q2q3_xpipe_pipe_ch7_rxdata_m), //ifcpmxpipechannel7xpiperxdata
      .XPIPE_PIPE_CH7_RXDATAVALID     (q2q3_xpipe_pipe_ch7_rxdatavalid_m),
      .XPIPE_PIPE_CH7_RXELECIDLE      (q2q3_xpipe_pipe_ch7_rxelecidle_m),
      .XPIPE_PIPE_CH7_RXSTARTBLOCK    (q2q3_xpipe_pipe_ch7_rxstartblock_m),
      .XPIPE_PIPE_CH7_RXSTATUS        (q2q3_xpipe_pipe_ch7_rxstatus_m),
      .XPIPE_PIPE_CH7_RXSYNCHEADER    (q2q3_xpipe_pipe_ch7_rxsyncheader_m),
      .XPIPE_PIPE_CH7_RXVALID         (q2q3_xpipe_pipe_ch7_rxvalid_m),
      .XPIPE_PIPE_CH7_POWERDOWN       (q2q3_xpipe_pipe_ch7_powerdown_m),
      .XPIPE_PIPE_CH7_RXPOLARITY      (q2q3_xpipe_pipe_ch7_rxpolarity_m),
      .XPIPE_PIPE_CH7_RXTERMINATION   (q2q3_xpipe_pipe_ch7_rxtermination_m),
      .XPIPE_PIPE_CH7_TXCHARISK       (q2q3_xpipe_pipe_ch7_txcharisk_m),
      .XPIPE_PIPE_CH7_TXCOMPLIANCE    (q2q3_xpipe_pipe_ch7_txcompliance_m),
      .XPIPE_PIPE_CH7_TXDATA          (q2q3_xpipe_pipe_ch7_txdata_m),
      .XPIPE_PIPE_CH7_TXDATAVALID     (q2q3_xpipe_pipe_ch7_txdatavalid_m),
      .XPIPE_PIPE_CH7_TXDEEMPH        (q2q3_xpipe_pipe_ch7_txdeemph_m),
      .XPIPE_PIPE_CH7_TXDETECTRXLOOPBACK(q2q3_xpipe_pipe_ch7_txdetectrxloopback_m),
      .XPIPE_PIPE_CH7_TXELECIDLE      (q2q3_xpipe_pipe_ch7_txelecidle_m),
      .XPIPE_PIPE_CH7_TXMAINCURSOR    (q2q3_xpipe_pipe_ch7_txmaincursor_m),
      .XPIPE_PIPE_CH7_TXMARGIN        (q2q3_xpipe_pipe_ch7_txmargin_m),
      .XPIPE_PIPE_CH7_TXPOSTCURSOR    (q2q3_xpipe_pipe_ch7_txpostcursor_m),
      .XPIPE_PIPE_CH7_TXPRECURSOR     (q2q3_xpipe_pipe_ch7_txprecursor_m),
      .XPIPE_PIPE_CH7_TXSTARTBLOCK    (q2q3_xpipe_pipe_ch7_txstartblock_m),
      .XPIPE_PIPE_CH7_TXSWING         (q2q3_xpipe_pipe_ch7_txswing_m),
      .XPIPE_PIPE_CH7_TXSYNCHEADER    (q2q3_xpipe_pipe_ch7_txsyncheader_m),

      .XPIPE_PIPE_CH7_POWERDOWN_M     (q3q4_xpipe_pipe_ch7_powerdown_m),
      .XPIPE_PIPE_CH7_RXPOLARITY_M    (q3q4_xpipe_pipe_ch7_rxpolarity_m),
      .XPIPE_PIPE_CH7_RXTERMINATION_M (q3q4_xpipe_pipe_ch7_rxtermination_m),
      .XPIPE_PIPE_CH7_TXCHARISK_M     (q3q4_xpipe_pipe_ch7_txcharisk_m),
      .XPIPE_PIPE_CH7_TXCOMPLIANCE_M  (q3q4_xpipe_pipe_ch7_txcompliance_m),
      .XPIPE_PIPE_CH7_TXDATAVALID_M   (q3q4_xpipe_pipe_ch7_txdatavalid_m),
      .XPIPE_PIPE_CH7_TXDATA_M        (q3q4_xpipe_pipe_ch7_txdata_m),
      .XPIPE_PIPE_CH7_TXDEEMPH_M      (q3q4_xpipe_pipe_ch7_txdeemph_m),
      .XPIPE_PIPE_CH7_TXELECIDLE_M    (q3q4_xpipe_pipe_ch7_txelecidle_m),
      .XPIPE_PIPE_CH7_TXMAINCURSOR_M  (q3q4_xpipe_pipe_ch7_txmaincursor_m),
      .XPIPE_PIPE_CH7_TXMARGIN_M      (q3q4_xpipe_pipe_ch7_txmargin_m),
      .XPIPE_PIPE_CH7_TXPOSTCURSOR_M  (q3q4_xpipe_pipe_ch7_txpostcursor_m),
      .XPIPE_PIPE_CH7_TXPRECURSOR_M   (q3q4_xpipe_pipe_ch7_txprecursor_m),
      .XPIPE_PIPE_CH7_TXSTARTBLOCK_M  (q3q4_xpipe_pipe_ch7_txstartblock_m),
      .XPIPE_PIPE_CH7_TXSWING_M       (q3q4_xpipe_pipe_ch7_txswing_m),
      .XPIPE_PIPE_CH7_TXSYNCHEADER_M  (q3q4_xpipe_pipe_ch7_txsyncheader_m),
      .XPIPE_PIPE_CH7_PHYSTATUS_M     (q3q4_xpipe_pipe_ch7_phystatus_m),
      .XPIPE_PIPE_CH7_RXCHARISK_M     (q3q4_xpipe_pipe_ch7_rxcharisk_m),
      .XPIPE_PIPE_CH7_RXDATAVALID_M   (q3q4_xpipe_pipe_ch7_rxdatavalid_m),
      .XPIPE_PIPE_CH7_RXDATA_M        (q3q4_xpipe_pipe_ch7_rxdata_m),
      .XPIPE_PIPE_CH7_RXELECIDLE_M    (q3q4_xpipe_pipe_ch7_rxelecidle_m),
      .XPIPE_PIPE_CH7_RXSTARTBLOCK_M  (q3q4_xpipe_pipe_ch7_rxstartblock_m),
      .XPIPE_PIPE_CH7_RXSTATUS_M      (q3q4_xpipe_pipe_ch7_rxstatus_m),
      .XPIPE_PIPE_CH7_RXSYNCHEADER_M  (q3q4_xpipe_pipe_ch7_rxsyncheader_m),
      .XPIPE_PIPE_CH7_RXVALID_M       (q3q4_xpipe_pipe_ch7_rxvalid_m),
      .XPIPE_PIPE_CH7_TXDETECTRXLOOPBACK_M(q3q4_xpipe_pipe_ch7_txdetectrxloopback_m),

      .XPIPE_PIPE_CH8_PHYSTATUS       (q2q3_xpipe_pipe_ch8_phystatus_m),
      .XPIPE_PIPE_CH8_RXCHARISK       (q2q3_xpipe_pipe_ch8_rxcharisk_m),
      .XPIPE_PIPE_CH8_RXDATA          (q2q3_xpipe_pipe_ch8_rxdata_m), //ifcpmxpipechannel8xpiperxdata
      .XPIPE_PIPE_CH8_RXDATAVALID     (q2q3_xpipe_pipe_ch8_rxdatavalid_m),
      .XPIPE_PIPE_CH8_RXELECIDLE      (q2q3_xpipe_pipe_ch8_rxelecidle_m),
      .XPIPE_PIPE_CH8_RXSTARTBLOCK    (q2q3_xpipe_pipe_ch8_rxstartblock_m),
      .XPIPE_PIPE_CH8_RXSTATUS        (q2q3_xpipe_pipe_ch8_rxstatus_m),
      .XPIPE_PIPE_CH8_RXSYNCHEADER    (q2q3_xpipe_pipe_ch8_rxsyncheader_m),
      .XPIPE_PIPE_CH8_RXVALID         (q2q3_xpipe_pipe_ch8_rxvalid_m),
      .XPIPE_PIPE_CH8_POWERDOWN       (q2q3_xpipe_pipe_ch8_powerdown_m),
      .XPIPE_PIPE_CH8_RXPOLARITY      (q2q3_xpipe_pipe_ch8_rxpolarity_m),
      .XPIPE_PIPE_CH8_RXTERMINATION   (q2q3_xpipe_pipe_ch8_rxtermination_m),
      .XPIPE_PIPE_CH8_TXCHARISK       (q2q3_xpipe_pipe_ch8_txcharisk_m),
      .XPIPE_PIPE_CH8_TXCOMPLIANCE    (q2q3_xpipe_pipe_ch8_txcompliance_m),
      .XPIPE_PIPE_CH8_TXDATA          (q2q3_xpipe_pipe_ch8_txdata_m),
      .XPIPE_PIPE_CH8_TXDATAVALID     (q2q3_xpipe_pipe_ch8_txdatavalid_m),
      .XPIPE_PIPE_CH8_TXDEEMPH        (q2q3_xpipe_pipe_ch8_txdeemph_m),
      .XPIPE_PIPE_CH8_TXDETECTRXLOOPBACK(q2q3_xpipe_pipe_ch8_txdetectrxloopback_m),
      .XPIPE_PIPE_CH8_TXELECIDLE      (q2q3_xpipe_pipe_ch8_txelecidle_m),
      .XPIPE_PIPE_CH8_TXMAINCURSOR    (q2q3_xpipe_pipe_ch8_txmaincursor_m),
      .XPIPE_PIPE_CH8_TXMARGIN        (q2q3_xpipe_pipe_ch8_txmargin_m),
      .XPIPE_PIPE_CH8_TXPOSTCURSOR    (q2q3_xpipe_pipe_ch8_txpostcursor_m),
      .XPIPE_PIPE_CH8_TXPRECURSOR     (q2q3_xpipe_pipe_ch8_txprecursor_m),
      .XPIPE_PIPE_CH8_TXSTARTBLOCK    (q2q3_xpipe_pipe_ch8_txstartblock_m),
      .XPIPE_PIPE_CH8_TXSWING         (q2q3_xpipe_pipe_ch8_txswing_m),
      .XPIPE_PIPE_CH8_TXSYNCHEADER    (q2q3_xpipe_pipe_ch8_txsyncheader_m),

      .XPIPE_PIPE_CH8_POWERDOWN_M     (q3q4_xpipe_pipe_ch8_powerdown_m),
      .XPIPE_PIPE_CH8_RXPOLARITY_M    (q3q4_xpipe_pipe_ch8_rxpolarity_m),
      .XPIPE_PIPE_CH8_RXTERMINATION_M (q3q4_xpipe_pipe_ch8_rxtermination_m),
      .XPIPE_PIPE_CH8_TXCHARISK_M     (q3q4_xpipe_pipe_ch8_txcharisk_m),
      .XPIPE_PIPE_CH8_TXCOMPLIANCE_M  (q3q4_xpipe_pipe_ch8_txcompliance_m),
      .XPIPE_PIPE_CH8_TXDATAVALID_M   (q3q4_xpipe_pipe_ch8_txdatavalid_m),
      .XPIPE_PIPE_CH8_TXDATA_M        (q3q4_xpipe_pipe_ch8_txdata_m),
      .XPIPE_PIPE_CH8_TXDEEMPH_M      (q3q4_xpipe_pipe_ch8_txdeemph_m),
      .XPIPE_PIPE_CH8_TXELECIDLE_M    (q3q4_xpipe_pipe_ch8_txelecidle_m),
      .XPIPE_PIPE_CH8_TXMAINCURSOR_M  (q3q4_xpipe_pipe_ch8_txmaincursor_m),
      .XPIPE_PIPE_CH8_TXMARGIN_M      (q3q4_xpipe_pipe_ch8_txmargin_m),
      .XPIPE_PIPE_CH8_TXPOSTCURSOR_M  (q3q4_xpipe_pipe_ch8_txpostcursor_m),
      .XPIPE_PIPE_CH8_TXPRECURSOR_M   (q3q4_xpipe_pipe_ch8_txprecursor_m),
      .XPIPE_PIPE_CH8_TXSTARTBLOCK_M  (q3q4_xpipe_pipe_ch8_txstartblock_m),
      .XPIPE_PIPE_CH8_TXSWING_M       (q3q4_xpipe_pipe_ch8_txswing_m),
      .XPIPE_PIPE_CH8_TXSYNCHEADER_M  (q3q4_xpipe_pipe_ch8_txsyncheader_m),
      .XPIPE_PIPE_CH8_PHYSTATUS_M     (q3q4_xpipe_pipe_ch8_phystatus_m),
      .XPIPE_PIPE_CH8_RXCHARISK_M     (q3q4_xpipe_pipe_ch8_rxcharisk_m),
      .XPIPE_PIPE_CH8_RXDATAVALID_M   (q3q4_xpipe_pipe_ch8_rxdatavalid_m),
      .XPIPE_PIPE_CH8_RXDATA_M        (q3q4_xpipe_pipe_ch8_rxdata_m),
      .XPIPE_PIPE_CH8_RXELECIDLE_M    (q3q4_xpipe_pipe_ch8_rxelecidle_m),
      .XPIPE_PIPE_CH8_RXSTARTBLOCK_M  (q3q4_xpipe_pipe_ch8_rxstartblock_m),
      .XPIPE_PIPE_CH8_RXSTATUS_M      (q3q4_xpipe_pipe_ch8_rxstatus_m),
      .XPIPE_PIPE_CH8_RXSYNCHEADER_M  (q3q4_xpipe_pipe_ch8_rxsyncheader_m),
      .XPIPE_PIPE_CH8_RXVALID_M       (q3q4_xpipe_pipe_ch8_rxvalid_m),
      .XPIPE_PIPE_CH8_TXDETECTRXLOOPBACK_M(q3q4_xpipe_pipe_ch8_txdetectrxloopback_m),

      .XPIPE_PIPE_CH9_PHYSTATUS       (q2q3_xpipe_pipe_ch9_phystatus_m),
      .XPIPE_PIPE_CH9_RXCHARISK       (q2q3_xpipe_pipe_ch9_rxcharisk_m),
      .XPIPE_PIPE_CH9_RXDATA          (q2q3_xpipe_pipe_ch9_rxdata_m),
      .XPIPE_PIPE_CH9_RXDATAVALID     (q2q3_xpipe_pipe_ch9_rxdatavalid_m),
      .XPIPE_PIPE_CH9_RXELECIDLE      (q2q3_xpipe_pipe_ch9_rxelecidle_m),
      .XPIPE_PIPE_CH9_RXSTARTBLOCK    (q2q3_xpipe_pipe_ch9_rxstartblock_m),
      .XPIPE_PIPE_CH9_RXSTATUS        (q2q3_xpipe_pipe_ch9_rxstatus_m),
      .XPIPE_PIPE_CH9_RXSYNCHEADER    (q2q3_xpipe_pipe_ch9_rxsyncheader_m),
      .XPIPE_PIPE_CH9_RXVALID         (q2q3_xpipe_pipe_ch9_rxvalid_m),
      .XPIPE_PIPE_CH9_POWERDOWN       (q2q3_xpipe_pipe_ch9_powerdown_m),
      .XPIPE_PIPE_CH9_RXPOLARITY      (q2q3_xpipe_pipe_ch9_rxpolarity_m),
      .XPIPE_PIPE_CH9_RXTERMINATION   (q2q3_xpipe_pipe_ch9_rxtermination_m),
      .XPIPE_PIPE_CH9_TXCHARISK       (q2q3_xpipe_pipe_ch9_txcharisk_m),
      .XPIPE_PIPE_CH9_TXCOMPLIANCE    (q2q3_xpipe_pipe_ch9_txcompliance_m),
      .XPIPE_PIPE_CH9_TXDATA          (q2q3_xpipe_pipe_ch9_txdata_m),
      .XPIPE_PIPE_CH9_TXDATAVALID     (q2q3_xpipe_pipe_ch9_txdatavalid_m),
      .XPIPE_PIPE_CH9_TXDEEMPH        (q2q3_xpipe_pipe_ch9_txdeemph_m),
      .XPIPE_PIPE_CH9_TXDETECTRXLOOPBACK(q2q3_xpipe_pipe_ch9_txdetectrxloopback_m),
      .XPIPE_PIPE_CH9_TXELECIDLE      (q2q3_xpipe_pipe_ch9_txelecidle_m),
      .XPIPE_PIPE_CH9_TXMAINCURSOR    (q2q3_xpipe_pipe_ch9_txmaincursor_m),
      .XPIPE_PIPE_CH9_TXMARGIN        (q2q3_xpipe_pipe_ch9_txmargin_m),
      .XPIPE_PIPE_CH9_TXPOSTCURSOR    (q2q3_xpipe_pipe_ch9_txpostcursor_m),
      .XPIPE_PIPE_CH9_TXPRECURSOR     (q2q3_xpipe_pipe_ch9_txprecursor_m),
      .XPIPE_PIPE_CH9_TXSTARTBLOCK    (q2q3_xpipe_pipe_ch9_txstartblock_m),
      .XPIPE_PIPE_CH9_TXSWING         (q2q3_xpipe_pipe_ch9_txswing_m),
      .XPIPE_PIPE_CH9_TXSYNCHEADER    (q2q3_xpipe_pipe_ch9_txsyncheader_m),

      .XPIPE_PIPE_CH9_POWERDOWN_M     (q3q4_xpipe_pipe_ch9_powerdown_m),
      .XPIPE_PIPE_CH9_RXPOLARITY_M    (q3q4_xpipe_pipe_ch9_rxpolarity_m),
      .XPIPE_PIPE_CH9_RXTERMINATION_M (q3q4_xpipe_pipe_ch9_rxtermination_m),
      .XPIPE_PIPE_CH9_TXCHARISK_M     (q3q4_xpipe_pipe_ch9_txcharisk_m),
      .XPIPE_PIPE_CH9_TXCOMPLIANCE_M  (q3q4_xpipe_pipe_ch9_txcompliance_m),
      .XPIPE_PIPE_CH9_TXDATAVALID_M   (q3q4_xpipe_pipe_ch9_txdatavalid_m),
      .XPIPE_PIPE_CH9_TXDATA_M        (q3q4_xpipe_pipe_ch9_txdata_m),
      .XPIPE_PIPE_CH9_TXDEEMPH_M      (q3q4_xpipe_pipe_ch9_txdeemph_m),
      .XPIPE_PIPE_CH9_TXELECIDLE_M    (q3q4_xpipe_pipe_ch9_txelecidle_m),
      .XPIPE_PIPE_CH9_TXMAINCURSOR_M  (q3q4_xpipe_pipe_ch9_txmaincursor_m),
      .XPIPE_PIPE_CH9_TXMARGIN_M      (q3q4_xpipe_pipe_ch9_txmargin_m),
      .XPIPE_PIPE_CH9_TXPOSTCURSOR_M  (q3q4_xpipe_pipe_ch9_txpostcursor_m),
      .XPIPE_PIPE_CH9_TXPRECURSOR_M   (q3q4_xpipe_pipe_ch9_txprecursor_m),
      .XPIPE_PIPE_CH9_TXSTARTBLOCK_M  (q3q4_xpipe_pipe_ch9_txstartblock_m),
      .XPIPE_PIPE_CH9_TXSWING_M       (q3q4_xpipe_pipe_ch9_txswing_m),
      .XPIPE_PIPE_CH9_TXSYNCHEADER_M  (q3q4_xpipe_pipe_ch9_txsyncheader_m),
      .XPIPE_PIPE_CH9_PHYSTATUS_M     (q3q4_xpipe_pipe_ch9_phystatus_m),
      .XPIPE_PIPE_CH9_RXCHARISK_M     (q3q4_xpipe_pipe_ch9_rxcharisk_m),
      .XPIPE_PIPE_CH9_RXDATAVALID_M   (q3q4_xpipe_pipe_ch9_rxdatavalid_m),
      .XPIPE_PIPE_CH9_RXDATA_M        (q3q4_xpipe_pipe_ch9_rxdata_m),
      .XPIPE_PIPE_CH9_RXELECIDLE_M    (q3q4_xpipe_pipe_ch9_rxelecidle_m),
      .XPIPE_PIPE_CH9_RXSTARTBLOCK_M  (q3q4_xpipe_pipe_ch9_rxstartblock_m),
      .XPIPE_PIPE_CH9_RXSTATUS_M      (q3q4_xpipe_pipe_ch9_rxstatus_m),
      .XPIPE_PIPE_CH9_RXSYNCHEADER_M  (q3q4_xpipe_pipe_ch9_rxsyncheader_m),
      .XPIPE_PIPE_CH9_RXVALID_M       (q3q4_xpipe_pipe_ch9_rxvalid_m),
      .XPIPE_PIPE_CH9_TXDETECTRXLOOPBACK_M(q3q4_xpipe_pipe_ch9_txdetectrxloopback_m),

      .XPIPE_PIPE_CH10_PHYSTATUS      (q2q3_xpipe_pipe_ch10_phystatus_m),
      .XPIPE_PIPE_CH10_RXCHARISK      (q2q3_xpipe_pipe_ch10_rxcharisk_m),
      .XPIPE_PIPE_CH10_RXDATA         (q2q3_xpipe_pipe_ch10_rxdata_m), 
      .XPIPE_PIPE_CH10_RXDATAVALID    (q2q3_xpipe_pipe_ch10_rxdatavalid_m),
      .XPIPE_PIPE_CH10_RXELECIDLE     (q2q3_xpipe_pipe_ch10_rxelecidle_m),
      .XPIPE_PIPE_CH10_RXSTARTBLOCK   (q2q3_xpipe_pipe_ch10_rxstartblock_m),
      .XPIPE_PIPE_CH10_RXSTATUS       (q2q3_xpipe_pipe_ch10_rxstatus_m),
      .XPIPE_PIPE_CH10_RXSYNCHEADER   (q2q3_xpipe_pipe_ch10_rxsyncheader_m),
      .XPIPE_PIPE_CH10_RXVALID        (q2q3_xpipe_pipe_ch10_rxvalid_m),
      .XPIPE_PIPE_CH10_POWERDOWN      (q2q3_xpipe_pipe_ch10_powerdown_m),
      .XPIPE_PIPE_CH10_RXPOLARITY     (q2q3_xpipe_pipe_ch10_rxpolarity_m),
      .XPIPE_PIPE_CH10_RXTERMINATION  (q2q3_xpipe_pipe_ch10_rxtermination_m),
      .XPIPE_PIPE_CH10_TXCHARISK      (q2q3_xpipe_pipe_ch10_txcharisk_m),
      .XPIPE_PIPE_CH10_TXCOMPLIANCE   (q2q3_xpipe_pipe_ch10_txcompliance_m),
      .XPIPE_PIPE_CH10_TXDATA         (q2q3_xpipe_pipe_ch10_txdata_m),
      .XPIPE_PIPE_CH10_TXDATAVALID    (q2q3_xpipe_pipe_ch10_txdatavalid_m),
      .XPIPE_PIPE_CH10_TXDEEMPH       (q2q3_xpipe_pipe_ch10_txdeemph_m),
      .XPIPE_PIPE_CH10_TXDETECTRXLOOPBACK(q2q3_xpipe_pipe_ch10_txdetectrxloopback_m),
      .XPIPE_PIPE_CH10_TXELECIDLE     (q2q3_xpipe_pipe_ch10_txelecidle_m),
      .XPIPE_PIPE_CH10_TXMAINCURSOR   (q2q3_xpipe_pipe_ch10_txmaincursor_m),
      .XPIPE_PIPE_CH10_TXMARGIN       (q2q3_xpipe_pipe_ch10_txmargin_m),
      .XPIPE_PIPE_CH10_TXPOSTCURSOR   (q2q3_xpipe_pipe_ch10_txpostcursor_m),
      .XPIPE_PIPE_CH10_TXPRECURSOR    (q2q3_xpipe_pipe_ch10_txprecursor_m),
      .XPIPE_PIPE_CH10_TXSTARTBLOCK   (q2q3_xpipe_pipe_ch10_txstartblock_m),
      .XPIPE_PIPE_CH10_TXSWING        (q2q3_xpipe_pipe_ch10_txswing_m),
      .XPIPE_PIPE_CH10_TXSYNCHEADER   (q2q3_xpipe_pipe_ch10_txsyncheader_m),

      .XPIPE_PIPE_CH10_POWERDOWN_M    (q3q4_xpipe_pipe_ch10_powerdown_m),
      .XPIPE_PIPE_CH10_RXPOLARITY_M   (q3q4_xpipe_pipe_ch10_rxpolarity_m),
      .XPIPE_PIPE_CH10_RXTERMINATION_M(q3q4_xpipe_pipe_ch10_rxtermination_m),
      .XPIPE_PIPE_CH10_TXCHARISK_M    (q3q4_xpipe_pipe_ch10_txcharisk_m),
      .XPIPE_PIPE_CH10_TXCOMPLIANCE_M (q3q4_xpipe_pipe_ch10_txcompliance_m),
      .XPIPE_PIPE_CH10_TXDATAVALID_M  (q3q4_xpipe_pipe_ch10_txdatavalid_m),
      .XPIPE_PIPE_CH10_TXDATA_M       (q3q4_xpipe_pipe_ch10_txdata_m),
      .XPIPE_PIPE_CH10_TXDEEMPH_M     (q3q4_xpipe_pipe_ch10_txdeemph_m),
      .XPIPE_PIPE_CH10_TXELECIDLE_M   (q3q4_xpipe_pipe_ch10_txelecidle_m),
      .XPIPE_PIPE_CH10_TXMAINCURSOR_M (q3q4_xpipe_pipe_ch10_txmaincursor_m),
      .XPIPE_PIPE_CH10_TXMARGIN_M     (q3q4_xpipe_pipe_ch10_txmargin_m),
      .XPIPE_PIPE_CH10_TXPOSTCURSOR_M (q3q4_xpipe_pipe_ch10_txpostcursor_m),
      .XPIPE_PIPE_CH10_TXPRECURSOR_M  (q3q4_xpipe_pipe_ch10_txprecursor_m),
      .XPIPE_PIPE_CH10_TXSTARTBLOCK_M (q3q4_xpipe_pipe_ch10_txstartblock_m),
      .XPIPE_PIPE_CH10_TXSWING_M      (q3q4_xpipe_pipe_ch10_txswing_m),
      .XPIPE_PIPE_CH10_TXSYNCHEADER_M (q3q4_xpipe_pipe_ch10_txsyncheader_m),
      .XPIPE_PIPE_CH10_PHYSTATUS_M    (q3q4_xpipe_pipe_ch10_phystatus_m),
      .XPIPE_PIPE_CH10_RXCHARISK_M    (q3q4_xpipe_pipe_ch10_rxcharisk_m),
      .XPIPE_PIPE_CH10_RXDATAVALID_M  (q3q4_xpipe_pipe_ch10_rxdatavalid_m),
      .XPIPE_PIPE_CH10_RXDATA_M       (q3q4_xpipe_pipe_ch10_rxdata_m),
      .XPIPE_PIPE_CH10_RXELECIDLE_M   (q3q4_xpipe_pipe_ch10_rxelecidle_m),
      .XPIPE_PIPE_CH10_RXSTARTBLOCK_M (q3q4_xpipe_pipe_ch10_rxstartblock_m),
      .XPIPE_PIPE_CH10_RXSTATUS_M     (q3q4_xpipe_pipe_ch10_rxstatus_m),
      .XPIPE_PIPE_CH10_RXSYNCHEADER_M (q3q4_xpipe_pipe_ch10_rxsyncheader_m),
      .XPIPE_PIPE_CH10_RXVALID_M      (q3q4_xpipe_pipe_ch10_rxvalid_m),
      .XPIPE_PIPE_CH10_TXDETECTRXLOOPBACK_M(q3q4_xpipe_pipe_ch10_txdetectrxloopback_m),

      .XPIPE_PIPE_CH11_PHYSTATUS      (q2q3_xpipe_pipe_ch11_phystatus_m),
      .XPIPE_PIPE_CH11_RXCHARISK      (q2q3_xpipe_pipe_ch11_rxcharisk_m),
      .XPIPE_PIPE_CH11_RXDATA         (q2q3_xpipe_pipe_ch11_rxdata_m), //ifcpmxpipechannel11xpiperxdata
      .XPIPE_PIPE_CH11_RXDATAVALID    (q2q3_xpipe_pipe_ch11_rxdatavalid_m),
      .XPIPE_PIPE_CH11_RXELECIDLE     (q2q3_xpipe_pipe_ch11_rxelecidle_m),
      .XPIPE_PIPE_CH11_RXSTARTBLOCK   (q2q3_xpipe_pipe_ch11_rxstartblock_m),
      .XPIPE_PIPE_CH11_RXSTATUS       (q2q3_xpipe_pipe_ch11_rxstatus_m),
      .XPIPE_PIPE_CH11_RXSYNCHEADER   (q2q3_xpipe_pipe_ch11_rxsyncheader_m),
      .XPIPE_PIPE_CH11_RXVALID        (q2q3_xpipe_pipe_ch11_rxvalid_m),
      .XPIPE_PIPE_CH11_POWERDOWN      (q2q3_xpipe_pipe_ch11_powerdown_m),
      .XPIPE_PIPE_CH11_RXPOLARITY     (q2q3_xpipe_pipe_ch11_rxpolarity_m),
      .XPIPE_PIPE_CH11_RXTERMINATION  (q2q3_xpipe_pipe_ch11_rxtermination_m),
      .XPIPE_PIPE_CH11_TXCHARISK      (q2q3_xpipe_pipe_ch11_txcharisk_m),
      .XPIPE_PIPE_CH11_TXCOMPLIANCE   (q2q3_xpipe_pipe_ch11_txcompliance_m),
      .XPIPE_PIPE_CH11_TXDATA         (q2q3_xpipe_pipe_ch11_txdata_m),
      .XPIPE_PIPE_CH11_TXDATAVALID    (q2q3_xpipe_pipe_ch11_txdatavalid_m),
      .XPIPE_PIPE_CH11_TXDEEMPH       (q2q3_xpipe_pipe_ch11_txdeemph_m),
      .XPIPE_PIPE_CH11_TXDETECTRXLOOPBACK(q2q3_xpipe_pipe_ch11_txdetectrxloopback_m),
      .XPIPE_PIPE_CH11_TXELECIDLE     (q2q3_xpipe_pipe_ch11_txelecidle_m),
      .XPIPE_PIPE_CH11_TXMAINCURSOR   (q2q3_xpipe_pipe_ch11_txmaincursor_m),
      .XPIPE_PIPE_CH11_TXMARGIN       (q2q3_xpipe_pipe_ch11_txmargin_m),
      .XPIPE_PIPE_CH11_TXPOSTCURSOR   (q2q3_xpipe_pipe_ch11_txpostcursor_m),
      .XPIPE_PIPE_CH11_TXPRECURSOR    (q2q3_xpipe_pipe_ch11_txprecursor_m),
      .XPIPE_PIPE_CH11_TXSTARTBLOCK   (q2q3_xpipe_pipe_ch11_txstartblock_m),
      .XPIPE_PIPE_CH11_TXSWING        (q2q3_xpipe_pipe_ch11_txswing_m),
      .XPIPE_PIPE_CH11_TXSYNCHEADER   (q2q3_xpipe_pipe_ch11_txsyncheader_m),

      .XPIPE_PIPE_CH11_POWERDOWN_M    (q3q4_xpipe_pipe_ch11_powerdown_m),
      .XPIPE_PIPE_CH11_RXPOLARITY_M   (q3q4_xpipe_pipe_ch11_rxpolarity_m),
      .XPIPE_PIPE_CH11_RXTERMINATION_M(q3q4_xpipe_pipe_ch11_rxtermination_m),
      .XPIPE_PIPE_CH11_TXCHARISK_M    (q3q4_xpipe_pipe_ch11_txcharisk_m),
      .XPIPE_PIPE_CH11_TXCOMPLIANCE_M (q3q4_xpipe_pipe_ch11_txcompliance_m),
      .XPIPE_PIPE_CH11_TXDATAVALID_M  (q3q4_xpipe_pipe_ch11_txdatavalid_m),
      .XPIPE_PIPE_CH11_TXDATA_M       (q3q4_xpipe_pipe_ch11_txdata_m),
      .XPIPE_PIPE_CH11_TXDEEMPH_M     (q3q4_xpipe_pipe_ch11_txdeemph_m),
      .XPIPE_PIPE_CH11_TXELECIDLE_M   (q3q4_xpipe_pipe_ch11_txelecidle_m),
      .XPIPE_PIPE_CH11_TXMAINCURSOR_M (q3q4_xpipe_pipe_ch11_txmaincursor_m),
      .XPIPE_PIPE_CH11_TXMARGIN_M     (q3q4_xpipe_pipe_ch11_txmargin_m),
      .XPIPE_PIPE_CH11_TXPOSTCURSOR_M (q3q4_xpipe_pipe_ch11_txpostcursor_m),
      .XPIPE_PIPE_CH11_TXPRECURSOR_M  (q3q4_xpipe_pipe_ch11_txprecursor_m),
      .XPIPE_PIPE_CH11_TXSTARTBLOCK_M (q3q4_xpipe_pipe_ch11_txstartblock_m),
      .XPIPE_PIPE_CH11_TXSWING_M      (q3q4_xpipe_pipe_ch11_txswing_m),
      .XPIPE_PIPE_CH11_TXSYNCHEADER_M (q3q4_xpipe_pipe_ch11_txsyncheader_m),
      .XPIPE_PIPE_CH11_PHYSTATUS_M    (q3q4_xpipe_pipe_ch11_phystatus_m),
      .XPIPE_PIPE_CH11_RXCHARISK_M    (q3q4_xpipe_pipe_ch11_rxcharisk_m),
      .XPIPE_PIPE_CH11_RXDATAVALID_M  (q3q4_xpipe_pipe_ch11_rxdatavalid_m),
      .XPIPE_PIPE_CH11_RXDATA_M       (q3q4_xpipe_pipe_ch11_rxdata_m),
      .XPIPE_PIPE_CH11_RXELECIDLE_M   (q3q4_xpipe_pipe_ch11_rxelecidle_m),
      .XPIPE_PIPE_CH11_RXSTARTBLOCK_M (q3q4_xpipe_pipe_ch11_rxstartblock_m),
      .XPIPE_PIPE_CH11_RXSTATUS_M     (q3q4_xpipe_pipe_ch11_rxstatus_m),
      .XPIPE_PIPE_CH11_RXSYNCHEADER_M (q3q4_xpipe_pipe_ch11_rxsyncheader_m),
      .XPIPE_PIPE_CH11_RXVALID_M      (q3q4_xpipe_pipe_ch11_rxvalid_m),
      .XPIPE_PIPE_CH11_TXDETECTRXLOOPBACK_M(q3q4_xpipe_pipe_ch11_txdetectrxloopback_m),

      .XPIPE_PIPE_CH12_PHYSTATUS      (q2q3_xpipe_pipe_ch12_phystatus_m),
      .XPIPE_PIPE_CH12_RXCHARISK      (q2q3_xpipe_pipe_ch12_rxcharisk_m),
      .XPIPE_PIPE_CH12_RXDATA         (q2q3_xpipe_pipe_ch12_rxdata_m), //ifcpmxpipechannel12xpiperxdata
      .XPIPE_PIPE_CH12_RXDATAVALID    (q2q3_xpipe_pipe_ch12_rxdatavalid_m),
      .XPIPE_PIPE_CH12_RXELECIDLE     (q2q3_xpipe_pipe_ch12_rxelecidle_m),
      .XPIPE_PIPE_CH12_RXSTARTBLOCK   (q2q3_xpipe_pipe_ch12_rxstartblock_m),
      .XPIPE_PIPE_CH12_RXSTATUS       (q2q3_xpipe_pipe_ch12_rxstatus_m),
      .XPIPE_PIPE_CH12_RXSYNCHEADER   (q2q3_xpipe_pipe_ch12_rxsyncheader_m),
      .XPIPE_PIPE_CH12_RXVALID        (q2q3_xpipe_pipe_ch12_rxvalid_m),
      .XPIPE_PIPE_CH12_POWERDOWN      (q2q3_xpipe_pipe_ch12_powerdown_m),
      .XPIPE_PIPE_CH12_RXPOLARITY     (q2q3_xpipe_pipe_ch12_rxpolarity_m),
      .XPIPE_PIPE_CH12_RXTERMINATION  (q2q3_xpipe_pipe_ch12_rxtermination_m),
      .XPIPE_PIPE_CH12_TXCHARISK      (q2q3_xpipe_pipe_ch12_txcharisk_m),
      .XPIPE_PIPE_CH12_TXCOMPLIANCE   (q2q3_xpipe_pipe_ch12_txcompliance_m),
      .XPIPE_PIPE_CH12_TXDATA         (q2q3_xpipe_pipe_ch12_txdata_m),
      .XPIPE_PIPE_CH12_TXDATAVALID    (q2q3_xpipe_pipe_ch12_txdatavalid_m),
      .XPIPE_PIPE_CH12_TXDEEMPH       (q2q3_xpipe_pipe_ch12_txdeemph_m),
      .XPIPE_PIPE_CH12_TXDETECTRXLOOPBACK(q2q3_xpipe_pipe_ch12_txdetectrxloopback_m),
      .XPIPE_PIPE_CH12_TXELECIDLE     (q2q3_xpipe_pipe_ch12_txelecidle_m),
      .XPIPE_PIPE_CH12_TXMAINCURSOR   (q2q3_xpipe_pipe_ch12_txmaincursor_m),
      .XPIPE_PIPE_CH12_TXMARGIN       (q2q3_xpipe_pipe_ch12_txmargin_m),
      .XPIPE_PIPE_CH12_TXPOSTCURSOR   (q2q3_xpipe_pipe_ch12_txpostcursor_m),
      .XPIPE_PIPE_CH12_TXPRECURSOR    (q2q3_xpipe_pipe_ch12_txprecursor_m),
      .XPIPE_PIPE_CH12_TXSTARTBLOCK   (q2q3_xpipe_pipe_ch12_txstartblock_m),
      .XPIPE_PIPE_CH12_TXSWING        (q2q3_xpipe_pipe_ch12_txswing_m),
      .XPIPE_PIPE_CH12_TXSYNCHEADER   (q2q3_xpipe_pipe_ch12_txsyncheader_m),

      .XPIPE_PIPE_CH12_POWERDOWN_M    (q3q4_xpipe_pipe_ch12_powerdown_m),
      .XPIPE_PIPE_CH12_RXPOLARITY_M   (q3q4_xpipe_pipe_ch12_rxpolarity_m),
      .XPIPE_PIPE_CH12_RXTERMINATION_M(q3q4_xpipe_pipe_ch12_rxtermination_m),
      .XPIPE_PIPE_CH12_TXCHARISK_M    (q3q4_xpipe_pipe_ch12_txcharisk_m),
      .XPIPE_PIPE_CH12_TXCOMPLIANCE_M (q3q4_xpipe_pipe_ch12_txcompliance_m),
      .XPIPE_PIPE_CH12_TXDATAVALID_M  (q3q4_xpipe_pipe_ch12_txdatavalid_m),
      .XPIPE_PIPE_CH12_TXDATA_M       (q3q4_xpipe_pipe_ch12_txdata_m),
      .XPIPE_PIPE_CH12_TXDEEMPH_M     (q3q4_xpipe_pipe_ch12_txdeemph_m),
      .XPIPE_PIPE_CH12_TXELECIDLE_M   (q3q4_xpipe_pipe_ch12_txelecidle_m),
      .XPIPE_PIPE_CH12_TXMAINCURSOR_M (q3q4_xpipe_pipe_ch12_txmaincursor_m),
      .XPIPE_PIPE_CH12_TXMARGIN_M     (q3q4_xpipe_pipe_ch12_txmargin_m),
      .XPIPE_PIPE_CH12_TXPOSTCURSOR_M (q3q4_xpipe_pipe_ch12_txpostcursor_m),
      .XPIPE_PIPE_CH12_TXPRECURSOR_M  (q3q4_xpipe_pipe_ch12_txprecursor_m),
      .XPIPE_PIPE_CH12_TXSTARTBLOCK_M (q3q4_xpipe_pipe_ch12_txstartblock_m),
      .XPIPE_PIPE_CH12_TXSWING_M      (q3q4_xpipe_pipe_ch12_txswing_m),
      .XPIPE_PIPE_CH12_TXSYNCHEADER_M (q3q4_xpipe_pipe_ch12_txsyncheader_m),
      .XPIPE_PIPE_CH12_PHYSTATUS_M    (q3q4_xpipe_pipe_ch12_phystatus_m),
      .XPIPE_PIPE_CH12_RXCHARISK_M    (q3q4_xpipe_pipe_ch12_rxcharisk_m),
      .XPIPE_PIPE_CH12_RXDATAVALID_M  (q3q4_xpipe_pipe_ch12_rxdatavalid_m),
      .XPIPE_PIPE_CH12_RXDATA_M       (q3q4_xpipe_pipe_ch12_rxdata_m),
      .XPIPE_PIPE_CH12_RXELECIDLE_M   (q3q4_xpipe_pipe_ch12_rxelecidle_m),
      .XPIPE_PIPE_CH12_RXSTARTBLOCK_M (q3q4_xpipe_pipe_ch12_rxstartblock_m),
      .XPIPE_PIPE_CH12_RXSTATUS_M     (q3q4_xpipe_pipe_ch12_rxstatus_m),
      .XPIPE_PIPE_CH12_RXSYNCHEADER_M (q3q4_xpipe_pipe_ch12_rxsyncheader_m),
      .XPIPE_PIPE_CH12_RXVALID_M      (q3q4_xpipe_pipe_ch12_rxvalid_m),
      .XPIPE_PIPE_CH12_TXDETECTRXLOOPBACK_M(q3q4_xpipe_pipe_ch12_txdetectrxloopback_m),

      .XPIPE_PIPE_CH13_PHYSTATUS      (q2q3_xpipe_pipe_ch13_phystatus_m),
      .XPIPE_PIPE_CH13_RXCHARISK      (q2q3_xpipe_pipe_ch13_rxcharisk_m),
      .XPIPE_PIPE_CH13_RXDATA         (q2q3_xpipe_pipe_ch13_rxdata_m), //ifcpmxpipechannel13xpiperxdata
      .XPIPE_PIPE_CH13_RXDATAVALID    (q2q3_xpipe_pipe_ch13_rxdatavalid_m),
      .XPIPE_PIPE_CH13_RXELECIDLE     (q2q3_xpipe_pipe_ch13_rxelecidle_m),
      .XPIPE_PIPE_CH13_RXSTARTBLOCK   (q2q3_xpipe_pipe_ch13_rxstartblock_m),
      .XPIPE_PIPE_CH13_RXSTATUS       (q2q3_xpipe_pipe_ch13_rxstatus_m),
      .XPIPE_PIPE_CH13_RXSYNCHEADER   (q2q3_xpipe_pipe_ch13_rxsyncheader_m),
      .XPIPE_PIPE_CH13_RXVALID        (q2q3_xpipe_pipe_ch13_rxvalid_m),
      .XPIPE_PIPE_CH13_POWERDOWN      (q2q3_xpipe_pipe_ch13_powerdown_m),
      .XPIPE_PIPE_CH13_RXPOLARITY     (q2q3_xpipe_pipe_ch13_rxpolarity_m),
      .XPIPE_PIPE_CH13_RXTERMINATION  (q2q3_xpipe_pipe_ch13_rxtermination_m),
      .XPIPE_PIPE_CH13_TXCHARISK      (q2q3_xpipe_pipe_ch13_txcharisk_m),
      .XPIPE_PIPE_CH13_TXCOMPLIANCE   (q2q3_xpipe_pipe_ch13_txcompliance_m),
      .XPIPE_PIPE_CH13_TXDATA         (q2q3_xpipe_pipe_ch13_txdata_m),
      .XPIPE_PIPE_CH13_TXDATAVALID    (q2q3_xpipe_pipe_ch13_txdatavalid_m),
      .XPIPE_PIPE_CH13_TXDEEMPH       (q2q3_xpipe_pipe_ch13_txdeemph_m),
      .XPIPE_PIPE_CH13_TXDETECTRXLOOPBACK(q2q3_xpipe_pipe_ch13_txdetectrxloopback_m),
      .XPIPE_PIPE_CH13_TXELECIDLE     (q2q3_xpipe_pipe_ch13_txelecidle_m),
      .XPIPE_PIPE_CH13_TXMAINCURSOR   (q2q3_xpipe_pipe_ch13_txmaincursor_m),
      .XPIPE_PIPE_CH13_TXMARGIN       (q2q3_xpipe_pipe_ch13_txmargin_m),
      .XPIPE_PIPE_CH13_TXPOSTCURSOR   (q2q3_xpipe_pipe_ch13_txpostcursor_m),
      .XPIPE_PIPE_CH13_TXPRECURSOR    (q2q3_xpipe_pipe_ch13_txprecursor_m),
      .XPIPE_PIPE_CH13_TXSTARTBLOCK   (q2q3_xpipe_pipe_ch13_txstartblock_m),
      .XPIPE_PIPE_CH13_TXSWING        (q2q3_xpipe_pipe_ch13_txswing_m),
      .XPIPE_PIPE_CH13_TXSYNCHEADER   (q2q3_xpipe_pipe_ch13_txsyncheader_m),

      .XPIPE_PIPE_CH13_POWERDOWN_M    (q3q4_xpipe_pipe_ch13_powerdown_m),
      .XPIPE_PIPE_CH13_RXPOLARITY_M   (q3q4_xpipe_pipe_ch13_rxpolarity_m),
      .XPIPE_PIPE_CH13_RXTERMINATION_M(q3q4_xpipe_pipe_ch13_rxtermination_m),
      .XPIPE_PIPE_CH13_TXCHARISK_M    (q3q4_xpipe_pipe_ch13_txcharisk_m),
      .XPIPE_PIPE_CH13_TXCOMPLIANCE_M (q3q4_xpipe_pipe_ch13_txcompliance_m),
      .XPIPE_PIPE_CH13_TXDATAVALID_M  (q3q4_xpipe_pipe_ch13_txdatavalid_m),
      .XPIPE_PIPE_CH13_TXDATA_M       (q3q4_xpipe_pipe_ch13_txdata_m),
      .XPIPE_PIPE_CH13_TXDEEMPH_M     (q3q4_xpipe_pipe_ch13_txdeemph_m),
      .XPIPE_PIPE_CH13_TXELECIDLE_M   (q3q4_xpipe_pipe_ch13_txelecidle_m),
      .XPIPE_PIPE_CH13_TXMAINCURSOR_M (q3q4_xpipe_pipe_ch13_txmaincursor_m),
      .XPIPE_PIPE_CH13_TXMARGIN_M     (q3q4_xpipe_pipe_ch13_txmargin_m),
      .XPIPE_PIPE_CH13_TXPOSTCURSOR_M (q3q4_xpipe_pipe_ch13_txpostcursor_m),
      .XPIPE_PIPE_CH13_TXPRECURSOR_M  (q3q4_xpipe_pipe_ch13_txprecursor_m),
      .XPIPE_PIPE_CH13_TXSTARTBLOCK_M (q3q4_xpipe_pipe_ch13_txstartblock_m),
      .XPIPE_PIPE_CH13_TXSWING_M      (q3q4_xpipe_pipe_ch13_txswing_m),
      .XPIPE_PIPE_CH13_TXSYNCHEADER_M (q3q4_xpipe_pipe_ch13_txsyncheader_m),
      .XPIPE_PIPE_CH13_PHYSTATUS_M    (q3q4_xpipe_pipe_ch13_phystatus_m),
      .XPIPE_PIPE_CH13_RXCHARISK_M    (q3q4_xpipe_pipe_ch13_rxcharisk_m),
      .XPIPE_PIPE_CH13_RXDATAVALID_M  (q3q4_xpipe_pipe_ch13_rxdatavalid_m),
      .XPIPE_PIPE_CH13_RXDATA_M       (q3q4_xpipe_pipe_ch13_rxdata_m),
      .XPIPE_PIPE_CH13_RXELECIDLE_M   (q3q4_xpipe_pipe_ch13_rxelecidle_m),
      .XPIPE_PIPE_CH13_RXSTARTBLOCK_M (q3q4_xpipe_pipe_ch13_rxstartblock_m),
      .XPIPE_PIPE_CH13_RXSTATUS_M     (q3q4_xpipe_pipe_ch13_rxstatus_m),
      .XPIPE_PIPE_CH13_RXSYNCHEADER_M (q3q4_xpipe_pipe_ch13_rxsyncheader_m),
      .XPIPE_PIPE_CH13_RXVALID_M      (q3q4_xpipe_pipe_ch13_rxvalid_m),
      .XPIPE_PIPE_CH13_TXDETECTRXLOOPBACK_M(q3q4_xpipe_pipe_ch13_txdetectrxloopback_m),

      .XPIPE_PIPE_CH14_PHYSTATUS      (q2q3_xpipe_pipe_ch14_phystatus_m),
      .XPIPE_PIPE_CH14_RXCHARISK      (q2q3_xpipe_pipe_ch14_rxcharisk_m),
      .XPIPE_PIPE_CH14_RXDATA         (q2q3_xpipe_pipe_ch14_rxdata_m), 
      .XPIPE_PIPE_CH14_RXDATAVALID    (q2q3_xpipe_pipe_ch14_rxdatavalid_m),
      .XPIPE_PIPE_CH14_RXELECIDLE     (q2q3_xpipe_pipe_ch14_rxelecidle_m),
      .XPIPE_PIPE_CH14_RXSTARTBLOCK   (q2q3_xpipe_pipe_ch14_rxstartblock_m),
      .XPIPE_PIPE_CH14_RXSTATUS       (q2q3_xpipe_pipe_ch14_rxstatus_m),
      .XPIPE_PIPE_CH14_RXSYNCHEADER   (q2q3_xpipe_pipe_ch14_rxsyncheader_m),
      .XPIPE_PIPE_CH14_RXVALID        (q2q3_xpipe_pipe_ch14_rxvalid_m),
      .XPIPE_PIPE_CH14_POWERDOWN      (q2q3_xpipe_pipe_ch14_powerdown_m),
      .XPIPE_PIPE_CH14_RXPOLARITY     (q2q3_xpipe_pipe_ch14_rxpolarity_m),
      .XPIPE_PIPE_CH14_RXTERMINATION  (q2q3_xpipe_pipe_ch14_rxtermination_m),
      .XPIPE_PIPE_CH14_TXCHARISK      (q2q3_xpipe_pipe_ch14_txcharisk_m),
      .XPIPE_PIPE_CH14_TXCOMPLIANCE   (q2q3_xpipe_pipe_ch14_txcompliance_m),
      .XPIPE_PIPE_CH14_TXDATA         (q2q3_xpipe_pipe_ch14_txdata_m),
      .XPIPE_PIPE_CH14_TXDATAVALID    (q2q3_xpipe_pipe_ch14_txdatavalid_m),
      .XPIPE_PIPE_CH14_TXDEEMPH       (q2q3_xpipe_pipe_ch14_txdeemph_m),
      .XPIPE_PIPE_CH14_TXDETECTRXLOOPBACK(q2q3_xpipe_pipe_ch14_txdetectrxloopback_m),
      .XPIPE_PIPE_CH14_TXELECIDLE     (q2q3_xpipe_pipe_ch14_txelecidle_m),
      .XPIPE_PIPE_CH14_TXMAINCURSOR   (q2q3_xpipe_pipe_ch14_txmaincursor_m),
      .XPIPE_PIPE_CH14_TXMARGIN       (q2q3_xpipe_pipe_ch14_txmargin_m),
      .XPIPE_PIPE_CH14_TXPOSTCURSOR   (q2q3_xpipe_pipe_ch14_txpostcursor_m),
      .XPIPE_PIPE_CH14_TXPRECURSOR    (q2q3_xpipe_pipe_ch14_txprecursor_m),
      .XPIPE_PIPE_CH14_TXSTARTBLOCK   (q2q3_xpipe_pipe_ch14_txstartblock_m),
      .XPIPE_PIPE_CH14_TXSWING        (q2q3_xpipe_pipe_ch14_txswing_m),
      .XPIPE_PIPE_CH14_TXSYNCHEADER   (q2q3_xpipe_pipe_ch14_txsyncheader_m),

      .XPIPE_PIPE_CH14_POWERDOWN_M    (q3q4_xpipe_pipe_ch14_powerdown_m),
      .XPIPE_PIPE_CH14_RXPOLARITY_M   (q3q4_xpipe_pipe_ch14_rxpolarity_m),
      .XPIPE_PIPE_CH14_RXTERMINATION_M(q3q4_xpipe_pipe_ch14_rxtermination_m),
      .XPIPE_PIPE_CH14_TXCHARISK_M    (q3q4_xpipe_pipe_ch14_txcharisk_m),
      .XPIPE_PIPE_CH14_TXCOMPLIANCE_M (q3q4_xpipe_pipe_ch14_txcompliance_m),
      .XPIPE_PIPE_CH14_TXDATAVALID_M  (q3q4_xpipe_pipe_ch14_txdatavalid_m),
      .XPIPE_PIPE_CH14_TXDATA_M       (q3q4_xpipe_pipe_ch14_txdata_m),
      .XPIPE_PIPE_CH14_TXDEEMPH_M     (q3q4_xpipe_pipe_ch14_txdeemph_m),
      .XPIPE_PIPE_CH14_TXELECIDLE_M   (q3q4_xpipe_pipe_ch14_txelecidle_m),
      .XPIPE_PIPE_CH14_TXMAINCURSOR_M (q3q4_xpipe_pipe_ch14_txmaincursor_m),
      .XPIPE_PIPE_CH14_TXMARGIN_M     (q3q4_xpipe_pipe_ch14_txmargin_m),
      .XPIPE_PIPE_CH14_TXPOSTCURSOR_M (q3q4_xpipe_pipe_ch14_txpostcursor_m),
      .XPIPE_PIPE_CH14_TXPRECURSOR_M  (q3q4_xpipe_pipe_ch14_txprecursor_m),
      .XPIPE_PIPE_CH14_TXSTARTBLOCK_M (q3q4_xpipe_pipe_ch14_txstartblock_m),
      .XPIPE_PIPE_CH14_TXSWING_M      (q3q4_xpipe_pipe_ch14_txswing_m),
      .XPIPE_PIPE_CH14_TXSYNCHEADER_M (q3q4_xpipe_pipe_ch14_txsyncheader_m),
      .XPIPE_PIPE_CH14_PHYSTATUS_M    (q3q4_xpipe_pipe_ch14_phystatus_m),
      .XPIPE_PIPE_CH14_RXCHARISK_M    (q3q4_xpipe_pipe_ch14_rxcharisk_m),
      .XPIPE_PIPE_CH14_RXDATAVALID_M  (q3q4_xpipe_pipe_ch14_rxdatavalid_m),
      .XPIPE_PIPE_CH14_RXDATA_M       (q3q4_xpipe_pipe_ch14_rxdata_m),
      .XPIPE_PIPE_CH14_RXELECIDLE_M   (q3q4_xpipe_pipe_ch14_rxelecidle_m),
      .XPIPE_PIPE_CH14_RXSTARTBLOCK_M (q3q4_xpipe_pipe_ch14_rxstartblock_m),
      .XPIPE_PIPE_CH14_RXSTATUS_M     (q3q4_xpipe_pipe_ch14_rxstatus_m),
      .XPIPE_PIPE_CH14_RXSYNCHEADER_M (q3q4_xpipe_pipe_ch14_rxsyncheader_m),
      .XPIPE_PIPE_CH14_RXVALID_M      (q3q4_xpipe_pipe_ch14_rxvalid_m),
      .XPIPE_PIPE_CH14_TXDETECTRXLOOPBACK_M(q3q4_xpipe_pipe_ch14_txdetectrxloopback_m),

      .XPIPE_PIPE_CH15_PHYSTATUS      (q2q3_xpipe_pipe_ch15_phystatus_m),
      .XPIPE_PIPE_CH15_RXCHARISK      (q2q3_xpipe_pipe_ch15_rxcharisk_m),
      .XPIPE_PIPE_CH15_RXDATA         (q2q3_xpipe_pipe_ch15_rxdata_m), 
      .XPIPE_PIPE_CH15_RXDATAVALID    (q2q3_xpipe_pipe_ch15_rxdatavalid_m),
      .XPIPE_PIPE_CH15_RXELECIDLE     (q2q3_xpipe_pipe_ch15_rxelecidle_m),
      .XPIPE_PIPE_CH15_RXSTARTBLOCK   (q2q3_xpipe_pipe_ch15_rxstartblock_m),
      .XPIPE_PIPE_CH15_RXSTATUS       (q2q3_xpipe_pipe_ch15_rxstatus_m),
      .XPIPE_PIPE_CH15_RXSYNCHEADER   (q2q3_xpipe_pipe_ch15_rxsyncheader_m),
      .XPIPE_PIPE_CH15_RXVALID        (q2q3_xpipe_pipe_ch15_rxvalid_m),
      .XPIPE_PIPE_CH15_POWERDOWN      (q2q3_xpipe_pipe_ch15_powerdown_m),
      .XPIPE_PIPE_CH15_RXPOLARITY     (q2q3_xpipe_pipe_ch15_rxpolarity_m),
      .XPIPE_PIPE_CH15_RXTERMINATION  (q2q3_xpipe_pipe_ch15_rxtermination_m),
      .XPIPE_PIPE_CH15_TXCHARISK      (q2q3_xpipe_pipe_ch15_txcharisk_m),
      .XPIPE_PIPE_CH15_TXCOMPLIANCE   (q2q3_xpipe_pipe_ch15_txcompliance_m),
      .XPIPE_PIPE_CH15_TXDATA         (q2q3_xpipe_pipe_ch15_txdata_m),
      .XPIPE_PIPE_CH15_TXDATAVALID    (q2q3_xpipe_pipe_ch15_txdatavalid_m),
      .XPIPE_PIPE_CH15_TXDEEMPH       (q2q3_xpipe_pipe_ch15_txdeemph_m),
      .XPIPE_PIPE_CH15_TXDETECTRXLOOPBACK(q2q3_xpipe_pipe_ch15_txdetectrxloopback_m),
      .XPIPE_PIPE_CH15_TXELECIDLE     (q2q3_xpipe_pipe_ch15_txelecidle_m),
      .XPIPE_PIPE_CH15_TXMAINCURSOR   (q2q3_xpipe_pipe_ch15_txmaincursor_m),
      .XPIPE_PIPE_CH15_TXMARGIN       (q2q3_xpipe_pipe_ch15_txmargin_m),
      .XPIPE_PIPE_CH15_TXPOSTCURSOR   (q2q3_xpipe_pipe_ch15_txpostcursor_m),
      .XPIPE_PIPE_CH15_TXPRECURSOR    (q2q3_xpipe_pipe_ch15_txprecursor_m),
      .XPIPE_PIPE_CH15_TXSTARTBLOCK   (q2q3_xpipe_pipe_ch15_txstartblock_m),
      .XPIPE_PIPE_CH15_TXSWING        (q2q3_xpipe_pipe_ch15_txswing_m),
      .XPIPE_PIPE_CH15_TXSYNCHEADER   (q2q3_xpipe_pipe_ch15_txsyncheader_m),

      .XPIPE_PIPE_CH15_POWERDOWN_M    (q3q4_xpipe_pipe_ch15_powerdown_m),
      .XPIPE_PIPE_CH15_RXPOLARITY_M   (q3q4_xpipe_pipe_ch15_rxpolarity_m),
      .XPIPE_PIPE_CH15_RXTERMINATION_M(q3q4_xpipe_pipe_ch15_rxtermination_m),
      .XPIPE_PIPE_CH15_TXCHARISK_M    (q3q4_xpipe_pipe_ch15_txcharisk_m),
      .XPIPE_PIPE_CH15_TXCOMPLIANCE_M (q3q4_xpipe_pipe_ch15_txcompliance_m),
      .XPIPE_PIPE_CH15_TXDATAVALID_M  (q3q4_xpipe_pipe_ch15_txdatavalid_m),
      .XPIPE_PIPE_CH15_TXDATA_M       (q3q4_xpipe_pipe_ch15_txdata_m),
      .XPIPE_PIPE_CH15_TXDEEMPH_M     (q3q4_xpipe_pipe_ch15_txdeemph_m),
      .XPIPE_PIPE_CH15_TXELECIDLE_M   (q3q4_xpipe_pipe_ch15_txelecidle_m),
      .XPIPE_PIPE_CH15_TXMAINCURSOR_M (q3q4_xpipe_pipe_ch15_txmaincursor_m),
      .XPIPE_PIPE_CH15_TXMARGIN_M     (q3q4_xpipe_pipe_ch15_txmargin_m),
      .XPIPE_PIPE_CH15_TXPOSTCURSOR_M (q3q4_xpipe_pipe_ch15_txpostcursor_m),
      .XPIPE_PIPE_CH15_TXPRECURSOR_M  (q3q4_xpipe_pipe_ch15_txprecursor_m),
      .XPIPE_PIPE_CH15_TXSTARTBLOCK_M (q3q4_xpipe_pipe_ch15_txstartblock_m),
      .XPIPE_PIPE_CH15_TXSWING_M      (q3q4_xpipe_pipe_ch15_txswing_m),
      .XPIPE_PIPE_CH15_TXSYNCHEADER_M (q3q4_xpipe_pipe_ch15_txsyncheader_m),
      .XPIPE_PIPE_CH15_PHYSTATUS_M    (q3q4_xpipe_pipe_ch15_phystatus_m),
      .XPIPE_PIPE_CH15_RXCHARISK_M    (q3q4_xpipe_pipe_ch15_rxcharisk_m),
      .XPIPE_PIPE_CH15_RXDATAVALID_M  (q3q4_xpipe_pipe_ch15_rxdatavalid_m),
      .XPIPE_PIPE_CH15_RXDATA_M       (q3q4_xpipe_pipe_ch15_rxdata_m),
      .XPIPE_PIPE_CH15_RXELECIDLE_M   (q3q4_xpipe_pipe_ch15_rxelecidle_m),
      .XPIPE_PIPE_CH15_RXSTARTBLOCK_M (q3q4_xpipe_pipe_ch15_rxstartblock_m),
      .XPIPE_PIPE_CH15_RXSTATUS_M     (q3q4_xpipe_pipe_ch15_rxstatus_m),
      .XPIPE_PIPE_CH15_RXSYNCHEADER_M (q3q4_xpipe_pipe_ch15_rxsyncheader_m),
      .XPIPE_PIPE_CH15_RXVALID_M      (q3q4_xpipe_pipe_ch15_rxvalid_m),
      .XPIPE_PIPE_CH15_TXDETECTRXLOOPBACK_M(q3q4_xpipe_pipe_ch15_txdetectrxloopback_m)
    );
  end
endgenerate
// --------------------------------------- XPIPE Instances End ------------------------------
// -------------------------------------------- DPLL instance starts --------------------------------------
generate
  if (C_CPM_PCIE0_CONTROLLER_ENABLE == 1 ) begin
  
    wire dpll0_rst;
    wire dpll0_drp_den;
    wire dpll0_drp_dwe;
    wire dpll0_drp_drdy;
    wire dpll0_drp_dclk;
    wire dpll0_clkout1;
    wire dpll0_dco_dclk;
    wire dpll0_cal_done;
    wire dpll0_cal_fail;

    wire [6:0]  dpll0_drp_daddr;
    wire [15:0] dpll0_drp_din;
    wire [15:0] dpll0_drp_dout;
  
    cpm4_v1_0_18_dpll_fd_cal #(
      .T_CAL(1280)
    )
    DPLL0_FD_CAL_inst (
      .ref_clk  (dpll0_drp_dclk),  //ref clk to DPLL/CLKIN(tgt freq 600MHz or higher)
      .dco_dclk (dpll0_dco_dclk),  //reference clock from DPLL/clkout0

      .rst      (!dpll0_rstn), // Soft Cal rest
      .rst_o    (dpll0_rst),   // DPLL reset

      .sc_cal_done (dpll0_cal_done),
      .sc_jump_fail(dpll0_cal_fail),

      .daddr(dpll0_drp_daddr), // to DPLL/APB
      .di   (dpll0_drp_din),   // to DPLL/APB
      .den  (dpll0_drp_den),   // to DPLL/APB
      .dwe  (dpll0_drp_dwe),   // to DPLL/APB
      .drdy (dpll0_drp_drdy),  // from DPLL/APB
      .dout (dpll0_drp_dout)   // from DPLL/APB
    );

    xpm_cdc_async_rst #(
      .DEST_SYNC_FF   (2),
      .RST_ACTIVE_HIGH(0)
    ) dpll0_stable_cdc (
      .src_arst  (dpll0_locked & dpll0_cal_done),
      .dest_arst (dpll0_stable),
      .dest_clk  (pcie0_user_clk)
    );

    wire pluserclk0_bufg_in;
    localparam LC_CLKFBOUT_MULT0 = (C_CPM_PCIE0_USER_CLK_FREQ == "62.5_MHz")? 40: 20;
    localparam LC_CLKIN_PERIOD0  = (C_CPM_PCIE0_USER_CLK_FREQ == "500_MHz")? 2 : (C_CPM_PCIE0_USER_CLK_FREQ == "250_MHz"? 4: (C_CPM_PCIE0_USER_CLK_FREQ == "125_MHz"? 8:16 ));
    localparam LC_CLKOUT_DIVIDE0 = (C_CPM_PCIE0_USER_CLK_FREQ == "500_MHz")? 5 : (C_CPM_PCIE0_USER_CLK_FREQ == "250_MHz"? 10: (C_CPM_PCIE0_USER_CLK_FREQ == "125_MHz"? 20:40 ));
    localparam LC_DIVCLK_DIVIDE0 = (C_CPM_PCIE0_USER_CLK_FREQ == "500_MHz")? 4 : (C_CPM_PCIE0_USER_CLK_FREQ == "250_MHz"? 2: 1);

    DPLL #(
      .CLKOUT1_DIVIDE(10), // Divider for CLKOUT1 generates 1.25 GHz / 10 = 125 MHz which is used by DPLL Calibration
      .CLKOUT0_PHASE_CTRL(2'b01),
      .CLKFBOUT_MULT  (LC_CLKFBOUT_MULT0), // Multiply value for all CLKOUT
      .CLKIN_PERIOD   (LC_CLKIN_PERIOD0),  // Input clock period in ns to ps resolution (i.e. 33.333 is 30 MHz).
      .CLKOUT0_DIVIDE (LC_CLKOUT_DIVIDE0), // Divide amount for CLKOUT0
      .DIVCLK_DIVIDE  (LC_DIVCLK_DIVIDE0)  // Master division value
    )
    DPLL_PCIE0_inst (
      .CLKOUT1 (dpll0_clkout1),       // 1-bit output: CLKOUT1
      .CLKOUT0(pluserclk0_bufg_in),   // 1-bit output: CLKOUT0
      .LOCKED (dpll0_locked),         // 1-bit input: Power-down
      .CLKIN  (pcie0_user_clk_loc),   // 1-bit input: Primary clock
      .CLKFB_DESKEW(pcie0_user_clk),  // BUFG output drives this
      .CLKIN_DESKEW(pcie0_user_clk_loc),

      .DO     (dpll0_drp_dout ),  // 16-bit output:DRP data output
      .DRDY   (dpll0_drp_drdy ),  // 1-bit output: DRP ready
      .DADDR  (dpll0_drp_daddr),  // 7-bit input:  DRP address
      .DCLK   (dpll0_drp_dclk ),  // 1-bit input:  DRP clock
      .DEN    (dpll0_drp_den  ),  // 1-bit input:  DRP enable
      .DI     (dpll0_drp_din  ),  // 16-bit input: DRP data input
      .DWE    (dpll0_drp_dwe  ),  // 1-bit input:  DRP data write enable

      .PSCLK  (1'b0),
      .PSEN   (1'b0),
      .PSINCDEC(1'b0),
      .PSDONE (),
      .PWRDWN (1'b0),
      .RST    (dpll0_rst)
    );

    BUFG_GT #(.SIM_DEVICE(C_SIM_DEVICE) ) bufg_pcie_0 (.I(pluserclk0_bufg_in),.O(pcie0_user_clk));
    BUFG_GT #(.SIM_DEVICE(C_SIM_DEVICE) ) bufg_dpll0_clkout1 (.I(dpll0_clkout1),.O(dpll0_dco_dclk));
    BUFG_GT #(.SIM_DEVICE(C_SIM_DEVICE) ) bufg_dpll0_cal (.I(ch0_txoutclk_m),.O(dpll0_drp_dclk),.DIV(3));
  end

  if (C_CPM_PCIE1_CONTROLLER_ENABLE == 1) begin

    wire dpll1_rst;
    wire dpll1_drp_den;
    wire dpll1_drp_dwe;
    wire dpll1_drp_drdy;
    wire dpll1_drp_dclk;
    wire dpll1_clkout1;
    wire dpll1_dco_dclk;
    wire dpll1_cal_done;
    wire dpll1_cal_fail;

    wire [6:0]  dpll1_drp_daddr;
    wire [15:0] dpll1_drp_din;
    wire [15:0] dpll1_drp_dout;

    cpm4_v1_0_18_dpll_fd_cal #(
      .T_CAL(1280)
    )
    DPLL1_FD_CAL_inst (
      .ref_clk  (dpll1_drp_dclk),  //ref clk to DPLL/CLKIN(tgt freq 600MHz or higher)
      .dco_dclk (dpll1_dco_dclk),  //reference clock from DPLL/clkout0

      .rst      (!dpll1_rstn), // Soft Cal rest
      .rst_o    (dpll1_rst),   // DPLL reset

      .sc_cal_done (dpll1_cal_done),
      .sc_jump_fail(dpll1_cal_fail),

      .daddr(dpll1_drp_daddr), // to DPLL/APB
      .di   (dpll1_drp_din),   // to DPLL/APB
      .den  (dpll1_drp_den),   // to DPLL/APB
      .dwe  (dpll1_drp_dwe),   // to DPLL/APB
      .drdy (dpll1_drp_drdy),  // from DPLL/APB
      .dout (dpll1_drp_dout)   // from DPLL/APB
    );

    xpm_cdc_async_rst #(
      .DEST_SYNC_FF   (2),
      .RST_ACTIVE_HIGH(0)
    ) dpll1_stable_cdc (
      .src_arst  (dpll1_locked & dpll1_cal_done),
      .dest_arst (dpll1_stable),
      .dest_clk  (pcie1_user_clk)
    );

    wire pluserclk1_bufg_in;
    localparam LC_CLKFBOUT_MULT1 = (C_CPM_PCIE1_USER_CLK_FREQ == "62.5_MHz") ? 40: 20;
    localparam LC_CLKIN_PERIOD1  = (C_CPM_PCIE1_USER_CLK_FREQ == "500_MHz") ? 2 : (C_CPM_PCIE1_USER_CLK_FREQ == "250_MHz"? 4: (C_CPM_PCIE1_USER_CLK_FREQ == "125_MHz"? 8:16 ));
    localparam LC_CLKOUT_DIVIDE1 = (C_CPM_PCIE1_USER_CLK_FREQ == "500_MHz") ? 5 : (C_CPM_PCIE1_USER_CLK_FREQ == "250_MHz"? 10: (C_CPM_PCIE1_USER_CLK_FREQ == "125_MHz"? 20:40 ));
    localparam LC_DIVCLK_DIVIDE1 = (C_CPM_PCIE1_USER_CLK_FREQ == "500_MHz") ? 4 : (C_CPM_PCIE1_USER_CLK_FREQ == "250_MHz"? 2: 1);

    DPLL #(
      .CLKOUT1_DIVIDE(10), // Divider for CLKOUT1 generates 1.25 GHz / 10 = 125 MHz which is used by DPLL Calibration
      .CLKOUT0_PHASE_CTRL (2'b01),
      .CLKFBOUT_MULT  (LC_CLKFBOUT_MULT1), // Multiply value for all CLKOUT
      .CLKIN_PERIOD   (LC_CLKIN_PERIOD1),  // Input clock period in ns to ps resolution (i.e. 33.333 is 30 MHz).
      .CLKOUT0_DIVIDE (LC_CLKOUT_DIVIDE1), // Divide amount for CLKOUT0
      .DIVCLK_DIVIDE  (LC_DIVCLK_DIVIDE1)  // Master division value
    )
    DPLL_PCIE1_inst (
      .CLKOUT1 (dpll1_clkout1),       // 1-bit output: CLKOUT1
      .CLKOUT0 (pluserclk1_bufg_in),  // 1-bit output: CLKOUT0
      .LOCKED  (dpll1_locked),        // 1-bit input: Power-down
      .CLKIN   (pcie1_user_clk_loc),  // 1-bit input: Primary clock
      .CLKFB_DESKEW(pcie1_user_clk),  // BUFG output drives this
      .CLKIN_DESKEW(pcie1_user_clk_loc),

      .DO     (dpll1_drp_dout ),  // 16-bit output:DRP data output
      .DRDY   (dpll1_drp_drdy ),  // 1-bit output: DRP ready
      .DADDR  (dpll1_drp_daddr),  // 7-bit input:  DRP address
      .DCLK   (dpll1_drp_dclk ),  // 1-bit input:  DRP clock
      .DEN    (dpll1_drp_den  ),  // 1-bit input:  DRP enable
      .DI     (dpll1_drp_din  ),  // 16-bit input: DRP data input
      .DWE    (dpll1_drp_dwe  ),  // 1-bit input:  DRP data write enable

      .PSCLK  (1'b0),
      .PSEN   (1'b0),
      .PSINCDEC(1'b0),
      .PSDONE (),
      .PWRDWN (1'b0),
      .RST    (dpll1_rst)
    );

    BUFG_GT #(.SIM_DEVICE(C_SIM_DEVICE) ) bufg_pcie_1 (.I(pluserclk1_bufg_in),.O(pcie1_user_clk));
    BUFG_GT #(.SIM_DEVICE(C_SIM_DEVICE) ) bufg_dpll1_clkout1 (.I(dpll1_clkout1),.O(dpll1_dco_dclk));
    BUFG_GT #(.SIM_DEVICE(C_SIM_DEVICE)) bufg_dpll1_cal (.I(ch8_txoutclk_m),.O(dpll1_drp_dclk),.DIV(3));
  end
endgenerate
// --------------------------- DPLL instance end ------------------------------------

endmodule
