//------------------------------------------------------------------------------
//  (c) Copyright 2017-2018 Advanced Micro Devices, Inc. All rights reserved.
//
//  This file contains confidential and proprietary information
//  of Advanced Micro Devices, Inc. and is protected under U.S. and
//  international copyright and other intellectual property
//  laws.
//
//  DISCLAIMER
//  This disclaimer is not a license and does not grant any
//  rights to the materials distributed herewith. Except as
//  otherwise provided in a valid license issued to you by
//  AMD, and to the maximum extent permitted by applicable
//  law: (1) THESE MATERIALS ARE MADE AVAILABLE "AS IS" AND
//  WITH ALL FAULTS, AND AMD HEREBY DISCLAIMS ALL WARRANTIES
//  AND CONDITIONS, EXPRESS, IMPLIED, OR STATUTORY, INCLUDING
//  BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, NON-
//  INFRINGEMENT, OR FITNESS FOR ANY PARTICULAR PURPOSE; and
//  (2) AMD shall not be liable (whether in contract or tort,
//  including negligence, or under any other theory of
//  liability) for any loss or damage of any kind or nature
//  related to, arising under or in connection with these
//  materials, including for any direct, or any indirect,
//  special, incidental, or consequential loss or damage
//  (including loss of data, profits, goodwill, or any type of
//  loss or damage suffered as a result of any action brought
//  by a third party) even if such damage or loss was
//  reasonably foreseeable or AMD had been advised of the
//  possibility of the same.
//
//  CRITICAL APPLICATIONS
//  AMD products are not designed or intended to be fail-
//  safe, or for use in any application requiring fail-safe
//  performance, such as life-support or safety devices or
//  systems, Class III medical devices, nuclear facilities,
//  applications related to the deployment of airbags, or any
//  other applications that could lead to death, personal
//  injury, or severe property or environmental damage
//  (individually and collectively, "Critical
//  Applications"). Customer assumes the sole risk and
//  liability of any use of AMD products in Critical
//  Applications, subject only to applicable laws and
//  regulations governing limitations on product liability.
//
//  THIS COPYRIGHT NOTICE AND DISCLAIMER MUST BE RETAINED AS
//  PART OF THIS FILE AT ALL TIMES.
//------------------------------------------------------------------------------

//------{

`timescale 1ns / 1ps
(* keep_hierarchy = "soft" *)
module bd_57a1_cpm_0_0_gt_quad_0_inst # (
    parameter IS_GTYP                = "false",
    parameter IS_GTYE5               = "true",
    parameter IS_KSB                 = "false",
    parameter IS_GTM2                = "false",
    parameter PROT0_SETTINGS         = " ",
    parameter PROT1_SETTINGS         = " ",
    parameter PROT2_SETTINGS         = " ",
    parameter PROT3_SETTINGS         = " ",
    parameter PROT4_SETTINGS         = " ",
    parameter PROT5_SETTINGS         = " ",
    parameter PROT6_SETTINGS         = " ",
    parameter PROT7_SETTINGS         = " ",
    parameter LANEUSAGE              = " ",
    parameter MSTCLK_SRC_DICT        = " ",
    parameter LANE_SEL_DICT          = " ",
    parameter PROT_DUAL_OCCUPIED     = " ",
    parameter QUAD_COMMON_SETTINGS   = " ",
    parameter QUAD_USAGE             = " ",
    parameter EGW_IS_QUAD            = 0,
    parameter REFCLK_SEL             = " ",
    parameter GT_REFCLK_INFO         = " ",
    parameter LANE_SATISFIED         = " ",
    parameter QUAD_PACK              = " ",
    parameter EGW_COMP_NAME          = "bd_57a1_cpm_0_0_gt_quad_0", 
    parameter EGW_CHANNEL_ORDERING   = "/gt_quad_base/TX0_GT_IP_Interface design_1_versal_cips_0_0_PCIeA0./versal_cips_0/M_TX0_GT.0 /gt_quad_base/RX0_GT_IP_Interface design_1_versal_cips_0_0_PCIeA0./versal_cips_0/M_RX0_GT.0",
    parameter EGW_REFCLK_LIST        = "/CLK_IN_D_0_clk_p[0]",
    parameter PWR_TX_DEF_SETTINGS    = "{LR0_SETTING {tx_data_rate=10.3125,tx_pll_type=LCPLL,tx_user_data_width=32,tx_int_data_width=32,tx_data_encoding=RAW,tx_pam_sel=NRZ,}}",
    parameter PWR_RX_DEF_SETTINGS    = "{LR0_SETTING {rx_data_rate=10.3125,rx_pll_type=LCPLL,rx_user_data_width=32,rx_int_data_width=32,rx_data_encoding=RAW,rx_eq_mode=AUTO,rx_oob_en=false,rx_pam_sel=NRZ,}}",
    parameter PWR_TX0_SETTINGS       = "{LR0_SETTING {tx_data_rate=10.0,tx_pll_type=LCPLL,tx_user_data_width=32,tx_int_data_width=32,tx_data_encoding=64B66B_SYNC,tx_pam_sel=NRZ,}                }",
    parameter PWR_TX1_SETTINGS       = "{}",
    parameter PWR_TX2_SETTINGS       = "{}",
    parameter PWR_TX3_SETTINGS       = "{}",
    parameter PWR_RX0_SETTINGS       = "{LR0_SETTING {rx_data_rate=10.0,rx_pll_type=LCPLL,rx_user_data_width=32,rx_int_data_width=32,rx_data_encoding=64B66B_SYNC,rx_eq_mode=AUTO,rx_oob_en=false,rx_pam_sel=NRZ,}                }",
    parameter PWR_RX1_SETTINGS       = "{}",
    parameter PWR_RX2_SETTINGS       = "{}",
    parameter PWR_RX3_SETTINGS       = "{}",
    parameter ENABLE_APB3            = "true",
    parameter CHANNEL_BONDING_EN     = ""
 
)(
 
output   [31:0]   apb3prdata,
output      apb3pready,
output      apb3pslverr,
output      ch0_bufgtce,
output   [3:0]   ch0_bufgtcemask,
output   [11:0]   ch0_bufgtdiv,
output      ch0_bufgtrst,
output   [3:0]   ch0_bufgtrstmask,
output      ch0_cfokovrdrdy0,
output      ch0_cfokovrdrdy1,
output   [31:0]   ch0_dmonitorout,
output      ch0_dmonitoroutclk,
output      ch0_eyescandataerror,
//output      ch0_gtytxn,
//output      ch0_gtytxp,
output      ch0_iloresetdone,
output   [15:0]   ch0_pcsrsvdout,
output      ch0_phyready,
output      ch0_phystatus,
output   [15:0]   ch0_pinrsvdas,
output      ch0_resetexception,
output   [7:0]   ch0_rx10gstat,
output   [2:0]   ch0_rxbufstatus,
output      ch0_rxbyteisaligned,
output      ch0_rxbyterealign,
output      ch0_rxcdrlock,
output      ch0_rxcdrphdone,
output      ch0_rxchanbondseq,
output      ch0_rxchanisaligned,
output      ch0_rxchanrealign,
output   [4:0]   ch0_rxchbondo,
output   [1:0]   ch0_rxclkcorcnt,
output      ch0_rxcominitdet,
output      ch0_rxcommadet,
output      ch0_rxcomsasdet,
output      ch0_rxcomwakedet,
output   [15:0]   ch0_rxctrl0,
output   [15:0]   ch0_rxctrl1,
output   [7:0]   ch0_rxctrl2,
output   [7:0]   ch0_rxctrl3,
output   [127:0]   ch0_rxdata,
output   [7:0]   ch0_rxdataextendrsvd,
output   [1:0]   ch0_rxdatavalid,
output      ch0_rxdccdone,
output      ch0_rxdlyalignerr,
output      ch0_rxdlyalignprog,
output      ch0_rxelecidle,
output      ch0_rxfinealigndone,
output   [5:0]   ch0_rxheader,
output   [1:0]   ch0_rxheadervalid,
output      ch0_rxosintdone,
output      ch0_rxosintstarted,
output      ch0_rxosintstrobedone,
output      ch0_rxosintstrobestarted,
output      ch0_rxoutclk,
output      ch0_rxphaligndone,
output      ch0_rxphalignerr,
output      ch0_rxphdlyresetdone,
output      ch0_rxphsetinitdone,
output      ch0_rxphshift180done,
output      ch0_rxpmaresetdone,
output      ch0_rxprbserr,
output      ch0_rxprbslocked,
output      ch0_rxprogdivresetdone,
output      ch0_rxresetdone,
output      ch0_rxsliderdy,
output   [1:0]   ch0_rxstartofseq,
output   [2:0]   ch0_rxstatus,
output      ch0_rxsyncdone,
output      ch0_rxvalid,
output      ch0_tx10gstat,
output   [1:0]   ch0_txbufstatus,
output      ch0_txcomfinish,
output      ch0_txdccdone,
output      ch0_txdlyalignerr,
output      ch0_txdlyalignprog,
output      ch0_txoutclk,
output      ch0_txphaligndone,
output      ch0_txphalignerr,
output      ch0_txphalignoutrsvd,
output      ch0_txphdlyresetdone,
output      ch0_txphsetinitdone,
output      ch0_txphshift180done,
output      ch0_txpmaresetdone,
output      ch0_txprogdivresetdone,
output      ch0_txresetdone,
output      ch0_txsyncdone,
output      ch1_bufgtce,
output   [3:0]   ch1_bufgtcemask,
output   [11:0]   ch1_bufgtdiv,
output      ch1_bufgtrst,
output   [3:0]   ch1_bufgtrstmask,
output      ch1_cfokovrdrdy0,
output      ch1_cfokovrdrdy1,
output   [31:0]   ch1_dmonitorout,
output      ch1_dmonitoroutclk,
output      ch1_eyescandataerror,
//output      ch1_gtytxn,
//output      ch1_gtytxp,
output      ch1_iloresetdone,
output   [15:0]   ch1_pcsrsvdout,
output      ch1_phyready,
output      ch1_phystatus,
output   [15:0]   ch1_pinrsvdas,
output      ch1_resetexception,
output   [7:0]   ch1_rx10gstat,
output   [2:0]   ch1_rxbufstatus,
output      ch1_rxbyteisaligned,
output      ch1_rxbyterealign,
output      ch1_rxcdrlock,
output      ch1_rxcdrphdone,
output      ch1_rxchanbondseq,
output      ch1_rxchanisaligned,
output      ch1_rxchanrealign,
output   [4:0]   ch1_rxchbondo,
output   [1:0]   ch1_rxclkcorcnt,
output      ch1_rxcominitdet,
output      ch1_rxcommadet,
output      ch1_rxcomsasdet,
output      ch1_rxcomwakedet,
output   [15:0]   ch1_rxctrl0,
output   [15:0]   ch1_rxctrl1,
output   [7:0]   ch1_rxctrl2,
output   [7:0]   ch1_rxctrl3,
output   [127:0]   ch1_rxdata,
output   [7:0]   ch1_rxdataextendrsvd,
output   [1:0]   ch1_rxdatavalid,
output      ch1_rxdccdone,
output      ch1_rxdlyalignerr,
output      ch1_rxdlyalignprog,
output      ch1_rxelecidle,
output      ch1_rxfinealigndone,
output   [5:0]   ch1_rxheader,
output   [1:0]   ch1_rxheadervalid,
output      ch1_rxosintdone,
output      ch1_rxosintstarted,
output      ch1_rxosintstrobedone,
output      ch1_rxosintstrobestarted,
output      ch1_rxoutclk,
output      ch1_rxphaligndone,
output      ch1_rxphalignerr,
output      ch1_rxphdlyresetdone,
output      ch1_rxphsetinitdone,
output      ch1_rxphshift180done,
output      ch1_rxpmaresetdone,
output      ch1_rxprbserr,
output      ch1_rxprbslocked,
output      ch1_rxprogdivresetdone,
output      ch1_rxresetdone,
output      ch1_rxsliderdy,
output   [1:0]   ch1_rxstartofseq,
output   [2:0]   ch1_rxstatus,
output      ch1_rxsyncdone,
output      ch1_rxvalid,
output      ch1_tx10gstat,
output   [1:0]   ch1_txbufstatus,
output      ch1_txcomfinish,
output      ch1_txdccdone,
output      ch1_txdlyalignerr,
output      ch1_txdlyalignprog,
output      ch1_txoutclk,
output      ch1_txphaligndone,
output      ch1_txphalignerr,
output      ch1_txphalignoutrsvd,
output      ch1_txphdlyresetdone,
output      ch1_txphsetinitdone,
output      ch1_txphshift180done,
output      ch1_txpmaresetdone,
output      ch1_txprogdivresetdone,
output      ch1_txresetdone,
output      ch1_txsyncdone,
output      ch2_bufgtce,
output   [3:0]   ch2_bufgtcemask,
output   [11:0]   ch2_bufgtdiv,
output      ch2_bufgtrst,
output   [3:0]   ch2_bufgtrstmask,
output      ch2_cfokovrdrdy0,
output      ch2_cfokovrdrdy1,
output   [31:0]   ch2_dmonitorout,
output      ch2_dmonitoroutclk,
output      ch2_eyescandataerror,
//output      ch2_gtytxn,
//output      ch2_gtytxp,
output      ch2_iloresetdone,
output   [15:0]   ch2_pcsrsvdout,
output      ch2_phyready,
output      ch2_phystatus,
output   [15:0]   ch2_pinrsvdas,
output      ch2_resetexception,
output   [7:0]   ch2_rx10gstat,
output   [2:0]   ch2_rxbufstatus,
output      ch2_rxbyteisaligned,
output      ch2_rxbyterealign,
output      ch2_rxcdrlock,
output      ch2_rxcdrphdone,
output      ch2_rxchanbondseq,
output      ch2_rxchanisaligned,
output      ch2_rxchanrealign,
output   [4:0]   ch2_rxchbondo,
output   [1:0]   ch2_rxclkcorcnt,
output      ch2_rxcominitdet,
output      ch2_rxcommadet,
output      ch2_rxcomsasdet,
output      ch2_rxcomwakedet,
output   [15:0]   ch2_rxctrl0,
output   [15:0]   ch2_rxctrl1,
output   [7:0]   ch2_rxctrl2,
output   [7:0]   ch2_rxctrl3,
output   [127:0]   ch2_rxdata,
output   [7:0]   ch2_rxdataextendrsvd,
output   [1:0]   ch2_rxdatavalid,
output      ch2_rxdccdone,
output      ch2_rxdlyalignerr,
output      ch2_rxdlyalignprog,
output      ch2_rxelecidle,
output      ch2_rxfinealigndone,
output   [5:0]   ch2_rxheader,
output   [1:0]   ch2_rxheadervalid,
output      ch2_rxosintdone,
output      ch2_rxosintstarted,
output      ch2_rxosintstrobedone,
output      ch2_rxosintstrobestarted,
output      ch2_rxoutclk,
output      ch2_rxphaligndone,
output      ch2_rxphalignerr,
output      ch2_rxphdlyresetdone,
output      ch2_rxphsetinitdone,
output      ch2_rxphshift180done,
output      ch2_rxpmaresetdone,
output      ch2_rxprbserr,
output      ch2_rxprbslocked,
output      ch2_rxprogdivresetdone,
output      ch2_rxresetdone,
output      ch2_rxsliderdy,
output   [1:0]   ch2_rxstartofseq,
output   [2:0]   ch2_rxstatus,
output      ch2_rxsyncdone,
output      ch2_rxvalid,
output      ch2_tx10gstat,
output   [1:0]   ch2_txbufstatus,
output      ch2_txcomfinish,
output      ch2_txdccdone,
output      ch2_txdlyalignerr,
output      ch2_txdlyalignprog,
output      ch2_txoutclk,
output      ch2_txphaligndone,
output      ch2_txphalignerr,
output      ch2_txphalignoutrsvd,
output      ch2_txphdlyresetdone,
output      ch2_txphsetinitdone,
output      ch2_txphshift180done,
output      ch2_txpmaresetdone,
output      ch2_txprogdivresetdone,
output      ch2_txresetdone,
output      ch2_txsyncdone,
output      ch3_bufgtce,
output   [3:0]   ch3_bufgtcemask,
output   [11:0]   ch3_bufgtdiv,
output      ch3_bufgtrst,
output   [3:0]   ch3_bufgtrstmask,
output      ch3_cfokovrdrdy0,
output      ch3_cfokovrdrdy1,
output   [31:0]   ch3_dmonitorout,
output      ch3_dmonitoroutclk,
output      ch3_eyescandataerror,
//output      ch3_gtytxn,
//output      ch3_gtytxp,
output      ch3_iloresetdone,
output   [15:0]   ch3_pcsrsvdout,
output      ch3_phyready,
output      ch3_phystatus,
output   [15:0]   ch3_pinrsvdas,
output      ch3_resetexception,
output   [7:0]   ch3_rx10gstat,
output   [2:0]   ch3_rxbufstatus,
output      ch3_rxbyteisaligned,
output      ch3_rxbyterealign,
output      ch3_rxcdrlock,
output      ch3_rxcdrphdone,
output      ch3_rxchanbondseq,
output      ch3_rxchanisaligned,
output      ch3_rxchanrealign,
output   [4:0]   ch3_rxchbondo,
output   [1:0]   ch3_rxclkcorcnt,
output      ch3_rxcominitdet,
output      ch3_rxcommadet,
output      ch3_rxcomsasdet,
output      ch3_rxcomwakedet,
output   [15:0]   ch3_rxctrl0,
output   [15:0]   ch3_rxctrl1,
output   [7:0]   ch3_rxctrl2,
output   [7:0]   ch3_rxctrl3,
output   [127:0]   ch3_rxdata,
output   [7:0]   ch3_rxdataextendrsvd,
output   [1:0]   ch3_rxdatavalid,
output      ch3_rxdccdone,
output      ch3_rxdlyalignerr,
output      ch3_rxdlyalignprog,
output      ch3_rxelecidle,
output      ch3_rxfinealigndone,
output   [5:0]   ch3_rxheader,
output   [1:0]   ch3_rxheadervalid,
output      ch3_rxosintdone,
output      ch3_rxosintstarted,
output      ch3_rxosintstrobedone,
output      ch3_rxosintstrobestarted,
output      ch3_rxoutclk,
output      ch3_rxphaligndone,
output      ch3_rxphalignerr,
output      ch3_rxphdlyresetdone,
output      ch3_rxphsetinitdone,
output      ch3_rxphshift180done,
output      ch3_rxpmaresetdone,
output      ch3_rxprbserr,
output      ch3_rxprbslocked,
output      ch3_rxprogdivresetdone,
output      ch3_rxresetdone,
output      ch3_rxsliderdy,
output   [1:0]   ch3_rxstartofseq,
output   [2:0]   ch3_rxstatus,
output      ch3_rxsyncdone,
output      ch3_rxvalid,
output      ch3_tx10gstat,
output   [1:0]   ch3_txbufstatus,
output      ch3_txcomfinish,
output      ch3_txdccdone,
output      ch3_txdlyalignerr,
output      ch3_txdlyalignprog,
output      ch3_txoutclk,
output      ch3_txphaligndone,
output      ch3_txphalignerr,
output      ch3_txphalignoutrsvd,
output      ch3_txphdlyresetdone,
output      ch3_txphsetinitdone,
output      ch3_txphshift180done,
output      ch3_txpmaresetdone,
output      ch3_txprogdivresetdone,
output      ch3_txresetdone,
output      ch3_txsyncdone,
output      correcterr,
output   [31:0]   ctrlrsvdout,
output   [15:0]   debugtracetdata,
output      debugtracetvalid,
output   [15:0]   gpo,
output      gtpowergood,
output      hsclk0_lcpllfbclklost,
output      hsclk0_lcplllock,
output      hsclk0_lcpllrefclklost,
output      hsclk0_lcpllrefclkmonitor,
output   [7:0]   hsclk0_lcpllrsvdout,
output      hsclk0_rpllfbclklost,
output      hsclk0_rplllock,
output      hsclk0_rpllrefclklost,
output      hsclk0_rpllrefclkmonitor,
output   [7:0]   hsclk0_rpllrsvdout,
output      hsclk0_rxrecclkout0,
output      hsclk0_rxrecclkout1,
output [1:0] hsclk0_rxrecclksel,
output      hsclk1_lcpllfbclklost,
output      hsclk1_lcplllock,
output      hsclk1_lcpllrefclklost,
output      hsclk1_lcpllrefclkmonitor,
output   [7:0]   hsclk1_lcpllrsvdout,
output      hsclk1_rpllfbclklost,
output      hsclk1_rplllock,
output      hsclk1_rpllrefclklost,
output      hsclk1_rpllrefclkmonitor,
output   [7:0]   hsclk1_rpllrsvdout,
output      hsclk1_rxrecclkout0,
output      hsclk1_rxrecclkout1,
output [1:0] hsclk1_rxrecclksel,
output   [31:0]   m0_axis_tdata,
output      m0_axis_tlast,
output      m0_axis_tvalid,
output   [31:0]   m1_axis_tdata,
output      m1_axis_tlast,
output      m1_axis_tvalid,
output   [31:0]   m2_axis_tdata,
output      m2_axis_tlast,
output      m2_axis_tvalid,
output   [5:0]   pipenorthout,
output   [5:0]   pipesouthout,
output      refclk0_clktestsigint,
output      refclk0_gtrefclkpdint,
output      refclk1_clktestsigint,
output      refclk1_gtrefclkpdint,
output   [1:0]   resetdone_northout,
output   [1:0]   resetdone_southout,
output      rxmarginreqack,
output   [3:0]   rxmarginrescmd,
output   [1:0]   rxmarginreslanenum,
output   [7:0]   rxmarginrespayld,
output      rxmarginresreq,
output   [3:0]   rxpinorthout,
output   [3:0]   rxpisouthout,
output      s0_axis_tready,
output      s1_axis_tready,
output      s2_axis_tready,
output      trigackin0,
output      trigout0,
output   [3:0]   txpinorthout,
output   [3:0]   txpisouthout,
output      ubinterrupt,
output      ubtxuart,
output      uncorrecterr,

input      altclk,
 
input      apb3clk,
input   [15:0]   apb3paddr,
input      apb3penable,
input      apb3presetn,
input      apb3psel,
input   [31:0]   apb3pwdata,
input      apb3pwrite,
input      axisclk,
input      bgbypassb,
input      bgmonitorenb,
input      bgpdb,
input   [4:0]   bgrcalovrd,
input      bgrcalovrdenb,
input      ch0_cdrbmcdrreq,
input      ch0_cdrfreqos,
input      ch0_cdrincpctrl,
input      ch0_cdrstepdir,
input      ch0_cdrstepsq,
input      ch0_cdrstepsx,
input      ch0_cfokovrdfinish,
input      ch0_cfokovrdpulse,
input      ch0_cfokovrdstart,
input      ch0_clkrsvd0,
input      ch0_clkrsvd1,
input      ch0_dmonfiforeset,
input      ch0_dmonitorclk,
input      ch0_eyescanreset,
input      ch0_eyescantrigger,
input   [15:0]   ch0_gtrsvd,
input      ch0_gtrxreset,
input      ch0_gttxreset,
//input      ch0_gtyrxn,
//input      ch0_gtyrxp,
input      ch0_hsdppcsreset,
input      ch0_iloreset,
input      ch0_iloresetmask,
input   [2:0]   ch0_loopback,
input      ch0_pcierstb,
input      ch0_phyesmadaptsave,
input      ch0_rxcdrhold,
input      ch0_rxcdrovrden,
input      ch0_rxcdrreset,
input   [4:0]   ch0_rxchbondi,
input      ch0_rxdapicodeovrden,
input      ch0_rxdapicodereset,
input      ch0_rxdlyalignreq,
input      ch0_rxeqtraining,
input      ch0_rxgearboxslip,
input      ch0_rxlatclk,
input      ch0_rxlpmen,
input      ch0_rxmldchaindone,
input      ch0_rxmldchainreq,
input      ch0_rxmlfinealignreq,
input      ch0_rxoobreset,
input   [4:0]   ch0_rxpcsresetmask,
input   [1:0]   ch0_rxpd,
input      ch0_rxphalignreq,
input   [1:0]   ch0_rxphalignresetmask,
input      ch0_rxphdlypd,
input      ch0_rxphdlyreset,
input      ch0_rxphsetinitreq,
input      ch0_rxphshift180,
input   [6:0]   ch0_rxpmaresetmask,
input      ch0_rxpolarity,
input      ch0_rxprbscntreset,
input   [3:0]   ch0_rxprbssel,
input      ch0_rxprogdivreset,
input   [7:0]   ch0_rxrate,
input   [1:0]   ch0_rxresetmode,
input      ch0_rxslide,
input      ch0_rxsyncallin,
input      ch0_rxtermination,
input      ch0_rxuserrdy,
input      ch0_rxusrclk,
input      ch0_tstclk0,
input      ch0_tstclk1,
input   [19:0]   ch0_tstin,
input      ch0_txcominit,
input      ch0_txcomsas,
input      ch0_txcomwake,
input   [15:0]   ch0_txctrl0,
input   [15:0]   ch0_txctrl1,
input   [7:0]   ch0_txctrl2,
input      ch0_txdapicodeovrden,
input      ch0_txdapicodereset,
input   [127:0]   ch0_txdata,
input   [7:0]   ch0_txdataextendrsvd,
input   [1:0]   ch0_txdeemph,
input      ch0_txdetectrx,
input   [4:0]   ch0_txdiffctrl,
input      ch0_txdlyalignreq,
input      ch0_txelecidle,
input   [5:0]   ch0_txheader,
input      ch0_txinhibit,
input      ch0_txlatclk,
input   [6:0]   ch0_txmaincursor,
input   [2:0]   ch0_txmargin,
input      ch0_txmldchaindone,
input      ch0_txmldchainreq,
input      ch0_txoneszeros,
input      ch0_txpausedelayalign,
input      ch0_txpcsresetmask,
input   [1:0]   ch0_txpd,
input      ch0_txphalignreq,
input   [1:0]   ch0_txphalignresetmask,
input      ch0_txphdlypd,
input      ch0_txphdlyreset,
input      ch0_txphdlytstclk,
input      ch0_txphsetinitreq,
input      ch0_txphshift180,
input      ch0_txpicodeovrden,
input      ch0_txpicodereset,
input      ch0_txpippmen,
input   [4:0]   ch0_txpippmstepsize,
input      ch0_txpisopd,
input   [2:0]   ch0_txpmaresetmask,
input      ch0_txpolarity,
input   [4:0]   ch0_txpostcursor,
input      ch0_txprbsforceerr,
input   [3:0]   ch0_txprbssel,
input   [4:0]   ch0_txprecursor,
input      ch0_txprogdivreset,
input   [7:0]   ch0_txrate,
input   [1:0]   ch0_txresetmode,
input   [6:0]   ch0_txsequence,
input      ch0_txswing,
input      ch0_txsyncallin,
input      ch0_txuserrdy,
input      ch0_txusrclk,
input      ch1_cdrbmcdrreq,
input      ch1_cdrfreqos,
input      ch1_cdrincpctrl,
input      ch1_cdrstepdir,
input      ch1_cdrstepsq,
input      ch1_cdrstepsx,
input      ch1_cfokovrdfinish,
input      ch1_cfokovrdpulse,
input      ch1_cfokovrdstart,
input      ch1_clkrsvd0,
input      ch1_clkrsvd1,
input      ch1_dmonfiforeset,
input      ch1_dmonitorclk,
input      ch1_eyescanreset,
input      ch1_eyescantrigger,
input   [15:0]   ch1_gtrsvd,
input      ch1_gtrxreset,
input      ch1_gttxreset,
//input      ch1_gtyrxn,
//input      ch1_gtyrxp,
input      ch1_hsdppcsreset,
input      ch1_iloreset,
input      ch1_iloresetmask,
input   [2:0]   ch1_loopback,
input      ch1_pcierstb,
input      ch1_phyesmadaptsave,
input      ch1_rxcdrhold,
input      ch1_rxcdrovrden,
input      ch1_rxcdrreset,
input   [4:0]   ch1_rxchbondi,
input      ch1_rxdapicodeovrden,
input      ch1_rxdapicodereset,
input      ch1_rxdlyalignreq,
input      ch1_rxeqtraining,
input      ch1_rxgearboxslip,
input      ch1_rxlatclk,
input      ch1_rxlpmen,
input      ch1_rxmldchaindone,
input      ch1_rxmldchainreq,
input      ch1_rxmlfinealignreq,
input      ch1_rxoobreset,
input   [4:0]   ch1_rxpcsresetmask,
input   [1:0]   ch1_rxpd,
input      ch1_rxphalignreq,
input   [1:0]   ch1_rxphalignresetmask,
input      ch1_rxphdlypd,
input      ch1_rxphdlyreset,
input      ch1_rxphsetinitreq,
input      ch1_rxphshift180,
input   [6:0]   ch1_rxpmaresetmask,
input      ch1_rxpolarity,
input      ch1_rxprbscntreset,
input   [3:0]   ch1_rxprbssel,
input      ch1_rxprogdivreset,
input   [7:0]   ch1_rxrate,
input   [1:0]   ch1_rxresetmode,
input      ch1_rxslide,
input      ch1_rxsyncallin,
input      ch1_rxtermination,
input      ch1_rxuserrdy,
input      ch1_rxusrclk,
input      ch1_tstclk0,
input      ch1_tstclk1,
input   [19:0]   ch1_tstin,
input      ch1_txcominit,
input      ch1_txcomsas,
input      ch1_txcomwake,
input   [15:0]   ch1_txctrl0,
input   [15:0]   ch1_txctrl1,
input   [7:0]   ch1_txctrl2,
input      ch1_txdapicodeovrden,
input      ch1_txdapicodereset,
input   [127:0]   ch1_txdata,
input   [7:0]   ch1_txdataextendrsvd,
input   [1:0]   ch1_txdeemph,
input      ch1_txdetectrx,
input   [4:0]   ch1_txdiffctrl,
input      ch1_txdlyalignreq,
input      ch1_txelecidle,
input   [5:0]   ch1_txheader,
input      ch1_txinhibit,
input      ch1_txlatclk,
input   [6:0]   ch1_txmaincursor,
input   [2:0]   ch1_txmargin,
input      ch1_txmldchaindone,
input      ch1_txmldchainreq,
input      ch1_txoneszeros,
input      ch1_txpausedelayalign,
input      ch1_txpcsresetmask,
input   [1:0]   ch1_txpd,
input      ch1_txphalignreq,
input   [1:0]   ch1_txphalignresetmask,
input      ch1_txphdlypd,
input      ch1_txphdlyreset,
input      ch1_txphdlytstclk,
input      ch1_txphsetinitreq,
input      ch1_txphshift180,
input      ch1_txpicodeovrden,
input      ch1_txpicodereset,
input      ch1_txpippmen,
input   [4:0]   ch1_txpippmstepsize,
input      ch1_txpisopd,
input   [2:0]   ch1_txpmaresetmask,
input      ch1_txpolarity,
input   [4:0]   ch1_txpostcursor,
input      ch1_txprbsforceerr,
input   [3:0]   ch1_txprbssel,
input   [4:0]   ch1_txprecursor,
input      ch1_txprogdivreset,
input   [7:0]   ch1_txrate,
input   [1:0]   ch1_txresetmode,
input   [6:0]   ch1_txsequence,
input      ch1_txswing,
input      ch1_txsyncallin,
input      ch1_txuserrdy,
input      ch1_txusrclk,
input      ch2_cdrbmcdrreq,
input      ch2_cdrfreqos,
input      ch2_cdrincpctrl,
input      ch2_cdrstepdir,
input      ch2_cdrstepsq,
input      ch2_cdrstepsx,
input      ch2_cfokovrdfinish,
input      ch2_cfokovrdpulse,
input      ch2_cfokovrdstart,
input      ch2_clkrsvd0,
input      ch2_clkrsvd1,
input      ch2_dmonfiforeset,
input      ch2_dmonitorclk,
input      ch2_eyescanreset,
input      ch2_eyescantrigger,
input   [15:0]   ch2_gtrsvd,
input      ch2_gtrxreset,
input      ch2_gttxreset,
//input      ch2_gtyrxn,
//input      ch2_gtyrxp,
input      ch2_hsdppcsreset,
input      ch2_iloreset,
input      ch2_iloresetmask,
input   [2:0]   ch2_loopback,
input      ch2_pcierstb,
input      ch2_phyesmadaptsave,
input      ch2_rxcdrhold,
input      ch2_rxcdrovrden,
input      ch2_rxcdrreset,
input   [4:0]   ch2_rxchbondi,
input      ch2_rxdapicodeovrden,
input      ch2_rxdapicodereset,
input      ch2_rxdlyalignreq,
input      ch2_rxeqtraining,
input      ch2_rxgearboxslip,
input      ch2_rxlatclk,
input      ch2_rxlpmen,
input      ch2_rxmldchaindone,
input      ch2_rxmldchainreq,
input      ch2_rxmlfinealignreq,
input      ch2_rxoobreset,
input   [4:0]   ch2_rxpcsresetmask,
input   [1:0]   ch2_rxpd,
input      ch2_rxphalignreq,
input   [1:0]   ch2_rxphalignresetmask,
input      ch2_rxphdlypd,
input      ch2_rxphdlyreset,
input      ch2_rxphsetinitreq,
input      ch2_rxphshift180,
input   [6:0]   ch2_rxpmaresetmask,
input      ch2_rxpolarity,
input      ch2_rxprbscntreset,
input   [3:0]   ch2_rxprbssel,
input      ch2_rxprogdivreset,
input   [7:0]   ch2_rxrate,
input   [1:0]   ch2_rxresetmode,
input      ch2_rxslide,
input      ch2_rxsyncallin,
input      ch2_rxtermination,
input      ch2_rxuserrdy,
input      ch2_rxusrclk,
input      ch2_tstclk0,
input      ch2_tstclk1,
input   [19:0]   ch2_tstin,
input      ch2_txcominit,
input      ch2_txcomsas,
input      ch2_txcomwake,
input   [15:0]   ch2_txctrl0,
input   [15:0]   ch2_txctrl1,
input   [7:0]   ch2_txctrl2,
input      ch2_txdapicodeovrden,
input      ch2_txdapicodereset,
input   [127:0]   ch2_txdata,
input   [7:0]   ch2_txdataextendrsvd,
input   [1:0]   ch2_txdeemph,
input      ch2_txdetectrx,
input   [4:0]   ch2_txdiffctrl,
input      ch2_txdlyalignreq,
input      ch2_txelecidle,
input   [5:0]   ch2_txheader,
input      ch2_txinhibit,
input      ch2_txlatclk,
input   [6:0]   ch2_txmaincursor,
input   [2:0]   ch2_txmargin,
input      ch2_txmldchaindone,
input      ch2_txmldchainreq,
input      ch2_txoneszeros,
input      ch2_txpausedelayalign,
input      ch2_txpcsresetmask,
input   [1:0]   ch2_txpd,
input      ch2_txphalignreq,
input   [1:0]   ch2_txphalignresetmask,
input      ch2_txphdlypd,
input      ch2_txphdlyreset,
input      ch2_txphdlytstclk,
input      ch2_txphsetinitreq,
input      ch2_txphshift180,
input      ch2_txpicodeovrden,
input      ch2_txpicodereset,
input      ch2_txpippmen,
input   [4:0]   ch2_txpippmstepsize,
input      ch2_txpisopd,
input   [2:0]   ch2_txpmaresetmask,
input      ch2_txpolarity,
input   [4:0]   ch2_txpostcursor,
input      ch2_txprbsforceerr,
input   [3:0]   ch2_txprbssel,
input   [4:0]   ch2_txprecursor,
input      ch2_txprogdivreset,
input   [7:0]   ch2_txrate,
input   [1:0]   ch2_txresetmode,
input   [6:0]   ch2_txsequence,
input      ch2_txswing,
input      ch2_txsyncallin,
input      ch2_txuserrdy,
input      ch2_txusrclk,
input      ch3_cdrbmcdrreq,
input      ch3_cdrfreqos,
input      ch3_cdrincpctrl,
input      ch3_cdrstepdir,
input      ch3_cdrstepsq,
input      ch3_cdrstepsx,
input      ch3_cfokovrdfinish,
input      ch3_cfokovrdpulse,
input      ch3_cfokovrdstart,
input      ch3_clkrsvd0,
input      ch3_clkrsvd1,
input      ch3_dmonfiforeset,
input      ch3_dmonitorclk,
input      ch3_eyescanreset,
input      ch3_eyescantrigger,
input   [15:0]   ch3_gtrsvd,
input      ch3_gtrxreset,
input      ch3_gttxreset,
//input      ch3_gtyrxn,
//input      ch3_gtyrxp,
input      ch3_hsdppcsreset,
input      ch3_iloreset,
input      ch3_iloresetmask,
input   [2:0]   ch3_loopback,
input      ch3_pcierstb,
input      ch3_phyesmadaptsave,
input      ch3_rxcdrhold,
input      ch3_rxcdrovrden,
input      ch3_rxcdrreset,
input   [4:0]   ch3_rxchbondi,
input      ch3_rxdapicodeovrden,
input      ch3_rxdapicodereset,
input      ch3_rxdlyalignreq,
input      ch3_rxeqtraining,
input      ch3_rxgearboxslip,
input      ch3_rxlatclk,
input      ch3_rxlpmen,
input      ch3_rxmldchaindone,
input      ch3_rxmldchainreq,
input      ch3_rxmlfinealignreq,
input      ch3_rxoobreset,
input   [4:0]   ch3_rxpcsresetmask,
input   [1:0]   ch3_rxpd,
input      ch3_rxphalignreq,
input   [1:0]   ch3_rxphalignresetmask,
input      ch3_rxphdlypd,
input      ch3_rxphdlyreset,
input      ch3_rxphsetinitreq,
input      ch3_rxphshift180,
input   [6:0]   ch3_rxpmaresetmask,
input      ch3_rxpolarity,
input      ch3_rxprbscntreset,
input   [3:0]   ch3_rxprbssel,
input      ch3_rxprogdivreset,
input   [7:0]   ch3_rxrate,
input   [1:0]   ch3_rxresetmode,
input      ch3_rxslide,
input      ch3_rxsyncallin,
input      ch3_rxtermination,
input      ch3_rxuserrdy,
input      ch3_rxusrclk,
input      ch3_tstclk0,
input      ch3_tstclk1,
input   [19:0]   ch3_tstin,
input      ch3_txcominit,
input      ch3_txcomsas,
input      ch3_txcomwake,
input   [15:0]   ch3_txctrl0,
input   [15:0]   ch3_txctrl1,
input   [7:0]   ch3_txctrl2,
input      ch3_txdapicodeovrden,
input      ch3_txdapicodereset,
input   [127:0]   ch3_txdata,
input   [7:0]   ch3_txdataextendrsvd,
input   [1:0]   ch3_txdeemph,
input      ch3_txdetectrx,
input   [4:0]   ch3_txdiffctrl,
input      ch3_txdlyalignreq,
input      ch3_txelecidle,
input   [5:0]   ch3_txheader,
input      ch3_txinhibit,
input      ch3_txlatclk,
input   [6:0]   ch3_txmaincursor,
input   [2:0]   ch3_txmargin,
input      ch3_txmldchaindone,
input      ch3_txmldchainreq,
input      ch3_txoneszeros,
input      ch3_txpausedelayalign,
input      ch3_txpcsresetmask,
input   [1:0]   ch3_txpd,
input      ch3_txphalignreq,
input   [1:0]   ch3_txphalignresetmask,
input      ch3_txphdlypd,
input      ch3_txphdlyreset,
input      ch3_txphdlytstclk,
input      ch3_txphsetinitreq,
input      ch3_txphshift180,
input      ch3_txpicodeovrden,
input      ch3_txpicodereset,
input      ch3_txpippmen,
input   [4:0]   ch3_txpippmstepsize,
input      ch3_txpisopd,
input   [2:0]   ch3_txpmaresetmask,
input      ch3_txpolarity,
input   [4:0]   ch3_txpostcursor,
input      ch3_txprbsforceerr,
input   [3:0]   ch3_txprbssel,
input   [4:0]   ch3_txprecursor,
input      ch3_txprogdivreset,
input   [7:0]   ch3_txrate,
input   [1:0]   ch3_txresetmode,
input   [6:0]   ch3_txsequence,
input      ch3_txswing,
input      ch3_txsyncallin,
input      ch3_txuserrdy,
input      ch3_txusrclk,
input   [15:0]   ctrlrsvdin0,
input   [13:0]   ctrlrsvdin1,
input      debugtraceclk,
input      debugtraceready,
input   [15:0]   gpi,
input      hsclk0_lcpllclkrsvd0,
input      hsclk0_lcpllclkrsvd1,
input   [7:0]   hsclk0_lcpllfbdiv,
input      hsclk0_lcpllgtgrefclk,
//input      hsclk0_lcpllgtrefclk0,
//input      hsclk0_lcpllgtrefclk1,
//input      hsclk0_lcpllnorthrefclk0,
//input      hsclk0_lcpllnorthrefclk1,
input      hsclk0_lcpllpd,
input   [2:0]   hsclk0_lcpllrefclksel,
input      hsclk0_lcpllreset,
input      hsclk0_lcpllresetbypassmode,
input   [1:0]   hsclk0_lcpllresetmask,
input   [7:0]   hsclk0_lcpllrsvd0,
input   [7:0]   hsclk0_lcpllrsvd1,
input   [25:0]   hsclk0_lcpllsdmdata,
input      hsclk0_lcpllsdmtoggle,
//input      hsclk0_lcpllsouthrefclk0,
//input      hsclk0_lcpllsouthrefclk1,
input      hsclk0_rpllclkrsvd0,
input      hsclk0_rpllclkrsvd1,
input   [7:0]   hsclk0_rpllfbdiv,
input      hsclk0_rpllgtgrefclk,
//input      hsclk0_rpllgtrefclk0,
//input      hsclk0_rpllgtrefclk1,
//input      hsclk0_rpllnorthrefclk0,
//input      hsclk0_rpllnorthrefclk1,
input      hsclk0_rpllpd,
input   [2:0]   hsclk0_rpllrefclksel,
input      hsclk0_rpllreset,
input      hsclk0_rpllresetbypassmode,
input   [1:0]   hsclk0_rpllresetmask,
input   [7:0]   hsclk0_rpllrsvd0,
input   [7:0]   hsclk0_rpllrsvd1,
input   [25:0]   hsclk0_rpllsdmdata,
input      hsclk0_rpllsdmtoggle,
//input      hsclk0_rpllsouthrefclk0,
//input      hsclk0_rpllsouthrefclk1,
input      hsclk1_lcpllclkrsvd0,
input      hsclk1_lcpllclkrsvd1,
input   [7:0]   hsclk1_lcpllfbdiv,
input      hsclk1_lcpllgtgrefclk,
//input      hsclk1_lcpllgtrefclk0,
//input      hsclk1_lcpllgtrefclk1,
//input      hsclk1_lcpllnorthrefclk0,
//input      hsclk1_lcpllnorthrefclk1,
input      hsclk1_lcpllpd,
input   [2:0]   hsclk1_lcpllrefclksel,
input      hsclk1_lcpllreset,
input      hsclk1_lcpllresetbypassmode,
input   [1:0]   hsclk1_lcpllresetmask,
input   [7:0]   hsclk1_lcpllrsvd0,
input   [7:0]   hsclk1_lcpllrsvd1,
input   [25:0]   hsclk1_lcpllsdmdata,
input      hsclk1_lcpllsdmtoggle,
//input      hsclk1_lcpllsouthrefclk0,
//input      hsclk1_lcpllsouthrefclk1,
input      hsclk1_rpllclkrsvd0,
input      hsclk1_rpllclkrsvd1,
input   [7:0]   hsclk1_rpllfbdiv,
input      hsclk1_rpllgtgrefclk,
//input      hsclk1_rpllgtrefclk0,
//input      hsclk1_rpllgtrefclk1,
//input      hsclk1_rpllnorthrefclk0,
//input      hsclk1_rpllnorthrefclk1,
input      hsclk1_rpllpd,
input   [2:0]   hsclk1_rpllrefclksel,
input      hsclk1_rpllreset,
input      hsclk1_rpllresetbypassmode,
input   [1:0]   hsclk1_rpllresetmask,
input   [7:0]   hsclk1_rpllrsvd0,
input   [7:0]   hsclk1_rpllrsvd1,
input   [25:0]   hsclk1_rpllsdmdata,
input      hsclk1_rpllsdmtoggle,
//input      hsclk1_rpllsouthrefclk0,
//input      hsclk1_rpllsouthrefclk1,
input      m0_axis_tready,
input      m1_axis_tready,
input      m2_axis_tready,
input      pcielinkreachtarget,
input   [5:0]   pcieltssm,
input   [5:0]   pipenorthin,
input   [5:0]   pipesouthin,
input      rcalenb,
input      refclk0_clktestsig,
input      refclk0_gtrefclkpd,
input      refclk1_clktestsig,
input      refclk1_gtrefclkpd,
input   [1:0]   resetdone_northin,
input   [1:0]   resetdone_southin,
input      rxmarginclk,
input   [3:0]   rxmarginreqcmd,
input   [1:0]   rxmarginreqlanenum,
input   [7:0]   rxmarginreqpayld,
input      rxmarginreqreq,
input      rxmarginresack,
input   [3:0]   rxpinorthin,
input   [3:0]   rxpisouthin,
input   [31:0]   s0_axis_tdata,
input      s0_axis_tlast,
input      s0_axis_tvalid,
input   [31:0]   s1_axis_tdata,
input      s1_axis_tlast,
input      s1_axis_tvalid,
input   [31:0]   s2_axis_tdata,
input      s2_axis_tlast,
input      s2_axis_tvalid,
input      trigackout0,
input      trigin0,
input   [3:0]   txpinorthin,
input   [3:0]   txpisouthin,
input      ubenable,
input   [11:0]   ubintr,
input      ubiolmbrst,
input      ubmbrst,
input      ubrxuart,

input [15:0] ch0_pcsrsvdin,
input [15:0] ch1_pcsrsvdin,
input [15:0] ch2_pcsrsvdin,
input [15:0] ch3_pcsrsvdin,


input GT_REFCLK0,

input [3:0]      rxp,
input [3:0]      rxn,
output [3:0]     txp,
output [3:0]     txn,
 
//input   [3:0]   mstrxreset,
//input   [3:0]   msttxreset,
//output   [3:0]   mstrxresetdone,
//output   [3:0]   msttxresetdone,

input ch0_rxmstreset,
input ch1_rxmstreset,
input ch2_rxmstreset,
input ch3_rxmstreset,
output ch0_rxmstresetdone,
output ch1_rxmstresetdone,
output ch2_rxmstresetdone,
output ch3_rxmstresetdone,
input ch0_txmstreset,
input ch1_txmstreset,
input ch2_txmstreset,
input ch3_txmstreset,
output ch0_txmstresetdone,
output ch1_txmstresetdone,
output ch2_txmstresetdone,
output ch3_txmstresetdone
    );


//------{
`ifdef XIL_TIMING
  parameter LOC = "UNPLACED";
`endif

`include "bd_57a1_cpm_0_0_gt_quad_0_rules_output.vh" 

////------}
wire      ch0_txpmaresetdone_int;
wire      ch1_txpmaresetdone_int;
wire      ch2_txpmaresetdone_int;
wire      ch3_txpmaresetdone_int;

wire      ch0_rxpmaresetdone_int;
wire      ch1_rxpmaresetdone_int;
wire      ch2_rxpmaresetdone_int;
wire      ch3_rxpmaresetdone_int;

wire      ch0_txresetdone_int;
wire      ch1_txresetdone_int;
wire      ch2_txresetdone_int;
wire      ch3_txresetdone_int;

wire      ch0_rxresetdone_int;
wire      ch1_rxresetdone_int;
wire      ch2_rxresetdone_int;
wire      ch3_rxresetdone_int;

wire [3:0] mstrxresetdone_int;
wire [3:0] msttxresetdone_int;

wire [15:0] ch0_pcsrsvdout_int;
wire [15:0] ch1_pcsrsvdout_int;
wire [15:0] ch2_pcsrsvdout_int;
wire [15:0] ch3_pcsrsvdout_int;

wire      gtpowergood_int;
assign gtpowergood = gtpowergood_int;
wire apb3_pclk_int;
wire apb3_presetn_int;
wire apb3_psel_int;
wire apb3_pwrite_int;
wire [15:0] apb3_paddr_int;
wire [31:0] apb3_pwdata_int;
wire [31:0] apb3_prdata_int;
wire apb3_pready_int;
wire apb3_pslverr_int;


 
assign apb3_pclk_int = apb3clk;


//------{

  wire  [15:0] ch0_pcsrsvdin_int = ch0_pcsrsvdin;
  wire  [15:0] ch1_pcsrsvdin_int = ch1_pcsrsvdin;
  wire  [15:0] ch2_pcsrsvdin_int = ch2_pcsrsvdin;
  wire  [15:0] ch3_pcsrsvdin_int = ch3_pcsrsvdin;


wire [3:0] msttxreset = {ch3_txmstreset,ch2_txmstreset,ch1_txmstreset,ch0_txmstreset};
wire [3:0] mstrxreset = {ch3_rxmstreset,ch2_rxmstreset,ch1_rxmstreset,ch0_rxmstreset};
wire [3:0] msttxresetdone; 
assign  {ch3_txmstresetdone,ch2_txmstresetdone,ch1_txmstresetdone,ch0_txmstresetdone} = msttxresetdone;
wire [3:0] mstrxresetdone; 
assign {ch3_rxmstresetdone,ch2_rxmstresetdone,ch1_rxmstresetdone,ch0_rxmstresetdone} = mstrxresetdone ;

wire      hsclk0_lcpllgtrefclk0;
wire      hsclk0_lcpllgtrefclk1;
wire      hsclk0_lcpllnorthrefclk0;
wire      hsclk0_lcpllnorthrefclk1;
wire      hsclk0_lcpllsouthrefclk0;
wire      hsclk0_lcpllsouthrefclk1;
wire      hsclk0_rpllgtrefclk0;
wire      hsclk0_rpllgtrefclk1;
wire      hsclk0_rpllnorthrefclk0;
wire      hsclk0_rpllnorthrefclk1;
wire      hsclk0_rpllsouthrefclk0;
wire      hsclk0_rpllsouthrefclk1;
wire      hsclk1_lcpllgtrefclk0;
wire      hsclk1_lcpllgtrefclk1;
wire      hsclk1_lcpllnorthrefclk0;
wire      hsclk1_lcpllnorthrefclk1;
wire      hsclk1_lcpllsouthrefclk0;
wire      hsclk1_lcpllsouthrefclk1;
wire      hsclk1_rpllgtrefclk0;
wire      hsclk1_rpllgtrefclk1;
wire      hsclk1_rpllnorthrefclk0;
wire      hsclk1_rpllnorthrefclk1;
wire      hsclk1_rpllsouthrefclk0;
wire      hsclk1_rpllsouthrefclk1;

wire ch0_gtytxn;
wire ch1_gtytxn;
wire ch2_gtytxn;
wire ch3_gtytxn;
wire ch0_gtytxp;
wire ch1_gtytxp;
wire ch2_gtytxp;
wire ch3_gtytxp;
wire ch0_gtyrxn;
wire ch1_gtyrxn;
wire ch2_gtyrxn;
wire ch3_gtyrxn;
wire ch0_gtyrxp;
wire ch1_gtyrxp;
wire ch2_gtyrxp;
wire ch3_gtyrxp;

assign txn = {ch3_gtytxn,ch2_gtytxn,ch1_gtytxn,ch0_gtytxn};
assign txp = {ch3_gtytxp,ch2_gtytxp,ch1_gtytxp,ch0_gtytxp};
assign  {ch3_gtyrxn,ch2_gtyrxn,ch1_gtyrxn,ch0_gtyrxn} = rxn;
assign  {ch3_gtyrxp,ch2_gtyrxp,ch1_gtyrxp,ch0_gtyrxp} = rxp;
assign {hsclk0_lcpllgtrefclk1,hsclk0_lcpllnorthrefclk0,hsclk0_lcpllnorthrefclk1,hsclk0_lcpllsouthrefclk0,hsclk0_lcpllsouthrefclk1,hsclk1_lcpllgtrefclk0,hsclk1_lcpllgtrefclk1,hsclk1_lcpllnorthrefclk0,hsclk1_lcpllnorthrefclk1,hsclk1_lcpllsouthrefclk0,hsclk1_lcpllsouthrefclk1,hsclk0_rpllgtrefclk0,hsclk0_rpllgtrefclk1,hsclk0_rpllnorthrefclk0,hsclk0_rpllnorthrefclk1,hsclk0_rpllsouthrefclk0,hsclk0_rpllsouthrefclk1,hsclk1_rpllgtrefclk0,hsclk1_rpllgtrefclk1,hsclk1_rpllnorthrefclk0,hsclk1_rpllnorthrefclk1,hsclk1_rpllsouthrefclk0,hsclk1_rpllsouthrefclk1} = 23'd0;
wire refclk_PROT0_R0_156point25_MHz_unique1;
assign {refclk_PROT0_R0_156point25_MHz_unique1} = {GT_REFCLK0};
assign {hsclk0_lcpllgtrefclk0} = {refclk_PROT0_R0_156point25_MHz_unique1};


assign apb3_presetn_int = apb3presetn;
assign apb3_psel_int    = apb3psel;
assign apb3_pen_int     = apb3penable;
assign apb3_pwrite_int  = apb3pwrite;
assign apb3_paddr_int   = apb3paddr;
assign apb3_pwdata_int  = apb3pwdata;
assign apb3prdata       = apb3_prdata_int;
assign apb3pready       = apb3_pready_int;
assign apb3pslverr      = apb3_pslverr_int;







wire [127:0] ch0_txdata_ANLT;
wire [127:0] ch1_txdata_ANLT;
wire [127:0] ch2_txdata_ANLT;
wire [127:0] ch3_txdata_ANLT;
wire [127:0] ch0_rxdata_ANLT;
wire [127:0] ch1_rxdata_ANLT;
wire [127:0] ch2_rxdata_ANLT;
wire [127:0] ch3_rxdata_ANLT;
assign ch0_txdata_ANLT = ch0_txdata;
assign ch1_txdata_ANLT = ch1_txdata;
assign ch2_txdata_ANLT = ch2_txdata;
assign ch3_txdata_ANLT = ch3_txdata;
assign ch0_rxdata = ch0_rxdata_ANLT;
assign ch1_rxdata = ch1_rxdata_ANLT;
assign ch2_rxdata = ch2_rxdata_ANLT;
assign ch3_rxdata = ch3_rxdata_ANLT;

wire [31:0] apb3prdata_quad;
wire apb3pready_quad;
wire apb3pslverr_quad;
wire apb3presetn_quad;
wire [15:0] apb3paddr_quad;
wire apb3penable_quad;
wire apb3sel_quad;
wire [31:0] apb3pwdata_quad;
wire apb3pwrite_quad;

assign apb3_prdata_int = apb3prdata_quad;
assign apb3_pready_int = apb3pready_quad;
assign apb3_pslverr_int = apb3pslverr_quad;

assign apb3presetn_quad = apb3_presetn_int;
assign apb3paddr_quad = apb3_paddr_int;
assign apb3penable_quad = apb3_pen_int;
assign apb3sel_quad = apb3_psel_int;
assign apb3pwdata_quad = apb3_pwdata_int;
assign apb3pwrite_quad = apb3_pwrite_int;

wire [31:0] apb3prdata_quad_int;
wire apb3pready_quad_int;
wire apb3pslverr_quad_int;
wire apb3presetn_quad_int;
wire [15:0] apb3paddr_quad_int;
wire apb3penable_quad_int;
wire apb3sel_quad_int;
wire [31:0] apb3pwdata_quad_int;
wire apb3pwrite_quad_int;

assign apb3paddr_quad_int = apb3paddr_quad;
assign apb3pwdata_quad_int = apb3pwdata_quad;
assign apb3penable_quad_int = apb3penable_quad;
assign apb3pwrite_quad_int = apb3pwrite_quad;
assign apb3sel_quad_int = apb3sel_quad;
assign apb3pready_quad = apb3pready_quad_int;
assign apb3prdata_quad = apb3prdata_quad_int;
assign apb3pslverr_quad = apb3pslverr_quad_int;
assign apb3presetn_quad_int = apb3presetn_quad;

//------{
GTYE5_QUAD #(
  .A_CFG0                           (A_CFG0                             ),                                                            
  .A_CFG1                           (A_CFG1                             ),                                  
  .A_CFG2                           (A_CFG2                             ),                                  
  .A_CFG3                           (A_CFG3                             ),                                  
  .A_CFG4                           (A_CFG4                             ),                                  
  .A_CFG5                           (A_CFG5                             ),                                  
  .CH0_ADAPT_APT_CFG                (CH0_ADAPT_APT_CFG                  ),                                  
  .CH0_ADAPT_CAL_CFG                (CH0_ADAPT_CAL_CFG                  ),                                  
  .CH0_ADAPT_DFE_CFG                (CH0_ADAPT_DFE_CFG                  ),                                  
  .CH0_ADAPT_GC_CFG0                (CH0_ADAPT_GC_CFG0                  ),                                  
  .CH0_ADAPT_GC_CFG1                (CH0_ADAPT_GC_CFG1                  ),                                  
  .CH0_ADAPT_GC_CFG2                (CH0_ADAPT_GC_CFG2                  ),                                  
  .CH0_ADAPT_GC_CFG3                (CH0_ADAPT_GC_CFG3                  ),                                  
  .CH0_ADAPT_GEN_CFG0               (CH0_ADAPT_GEN_CFG0                 ),                                  
  .CH0_ADAPT_GEN_CFG1               (CH0_ADAPT_GEN_CFG1                 ),                                  
  .CH0_ADAPT_GEN_CFG2               (CH0_ADAPT_GEN_CFG2                 ),                                  
  .CH0_ADAPT_GEN_CFG3               (CH0_ADAPT_GEN_CFG3                 ),                                  
  .CH0_ADAPT_H01_CFG                (CH0_ADAPT_H01_CFG                  ),                                  
  .CH0_ADAPT_H23_CFG                (CH0_ADAPT_H23_CFG                  ),                                  
  .CH0_ADAPT_H45_CFG                (CH0_ADAPT_H45_CFG                  ),                                  
  .CH0_ADAPT_H67_CFG                (CH0_ADAPT_H67_CFG                  ),                                  
  .CH0_ADAPT_H89_CFG                (CH0_ADAPT_H89_CFG                  ),                                  
  .CH0_ADAPT_HAB_CFG                (CH0_ADAPT_HAB_CFG                  ),                                  
  .CH0_ADAPT_HCD_CFG                (CH0_ADAPT_HCD_CFG                  ),                                  
  .CH0_ADAPT_HEF_CFG                (CH0_ADAPT_HEF_CFG                  ),                                  
  .CH0_ADAPT_KH_CFG0                (CH0_ADAPT_KH_CFG0                  ),                                  
  .CH0_ADAPT_KH_CFG1                (CH0_ADAPT_KH_CFG1                  ),                                  
  .CH0_ADAPT_KH_CFG2                (CH0_ADAPT_KH_CFG2                  ),                                  
  .CH0_ADAPT_KH_CFG3                (CH0_ADAPT_KH_CFG3                  ),                                  
  .CH0_ADAPT_KH_CFG4                (CH0_ADAPT_KH_CFG4                  ),                                  
  .CH0_ADAPT_KH_CFG5                (CH0_ADAPT_KH_CFG5                  ),                                  
  .CH0_ADAPT_KL_CFG0                (CH0_ADAPT_KL_CFG0                  ),                                  
  .CH0_ADAPT_KL_CFG1                (CH0_ADAPT_KL_CFG1                  ),                                  
  .CH0_ADAPT_LCK_CFG0               (CH0_ADAPT_LCK_CFG0                 ),                                  
  .CH0_ADAPT_LCK_CFG1               (CH0_ADAPT_LCK_CFG1                 ),                                  
  .CH0_ADAPT_LCK_CFG2               (CH0_ADAPT_LCK_CFG2                 ),                                  
  .CH0_ADAPT_LCK_CFG3               (CH0_ADAPT_LCK_CFG3                 ),                                  
  .CH0_ADAPT_LOP_CFG                (CH0_ADAPT_LOP_CFG                  ),                                  
  .CH0_ADAPT_OS_CFG                 (CH0_ADAPT_OS_CFG                   ),                                  
  .CH0_CHCLK_ILO_CFG                (CH0_CHCLK_ILO_CFG                  ),                                  
  .CH0_CHCLK_MISC_CFG               (CH0_CHCLK_MISC_CFG                 ),                                  
  .CH0_CHCLK_RSV_CFG                (CH1_CHCLK_RSV_CFG                  ),                                  
  .CH0_CHCLK_RXCAL_CFG              (CH0_CHCLK_RXCAL_CFG                ),                                  
  .CH0_CHCLK_RXCAL_CFG1             (CH0_CHCLK_RXCAL_CFG1               ),                                  
  .CH0_CHCLK_RXCAL_CFG2             (CH0_CHCLK_RXCAL_CFG2               ),                                  
  .CH0_CHCLK_RXPI_CFG               (CH0_CHCLK_RXPI_CFG                 ),                                  
  .CH0_CHCLK_TXCAL_CFG              (CH0_CHCLK_TXCAL_CFG                ),                                  
  .CH0_CHCLK_TXPI_CFG0              (CH0_CHCLK_TXPI_CFG0                ),                                  
  .CH0_CHL_RSV_CFG0                 (CH0_CHL_RSV_CFG0                   ),                                  
  .CH0_CHL_RSV_CFG1                 (CH0_CHL_RSV_CFG1                   ),                                  
  .CH0_CHL_RSV_CFG2                 (CH0_CHL_RSV_CFG2                   ),                                  
  .CH0_CHL_RSV_CFG3                 (CH0_CHL_RSV_CFG3                   ),                                  
  .CH0_CHL_RSV_CFG4                 (CH0_CHL_RSV_CFG4                   ),                                  
  .CH0_DA_CFG                       (CH0_DA_CFG                         ),
  .CH0_EYESCAN_CFG0                 (CH0_EYESCAN_CFG0                   ),                                  
  .CH0_EYESCAN_CFG1                 (CH0_EYESCAN_CFG1                   ),                                  
  .CH0_EYESCAN_CFG10                (CH0_EYESCAN_CFG10                  ),                                  
  .CH0_EYESCAN_CFG11                (CH0_EYESCAN_CFG11                  ),                                  
  .CH0_EYESCAN_CFG12                (CH0_EYESCAN_CFG12                  ),                                  
  .CH0_EYESCAN_CFG13                (CH0_EYESCAN_CFG13                  ),                                  
  .CH0_EYESCAN_CFG14                (CH0_EYESCAN_CFG14                  ),                                  
  .CH0_EYESCAN_CFG15                (CH0_EYESCAN_CFG15                  ),                                  
  .CH0_EYESCAN_CFG16                (CH0_EYESCAN_CFG16                  ),                                  
  .CH0_EYESCAN_CFG2                 (CH0_EYESCAN_CFG2                   ),                                  
  .CH0_EYESCAN_CFG3                 (CH0_EYESCAN_CFG3                   ),                                  
  .CH0_EYESCAN_CFG4                 (CH0_EYESCAN_CFG4                   ),                                  
  .CH0_EYESCAN_CFG5                 (CH0_EYESCAN_CFG5                   ),                                  
  .CH0_EYESCAN_CFG6                 (CH0_EYESCAN_CFG6                   ),                                  
  .CH0_EYESCAN_CFG7                 (CH0_EYESCAN_CFG7                   ),                                  
  .CH0_EYESCAN_CFG8                 (CH0_EYESCAN_CFG8                   ),                                  
  .CH0_EYESCAN_CFG9                 (CH0_EYESCAN_CFG9                   ),                                  
  //.CH0_FABRIC_INTF_CFG0             ('d4278190079               ),                                  
  .CH0_FABRIC_INTF_CFG0             (CH0_FABRIC_INTF_CFG0               ),                                  
  .CH0_FABRIC_INTF_CFG1             (CH0_FABRIC_INTF_CFG1               ),                                  
  .CH0_FABRIC_INTF_CFG2             (CH0_FABRIC_INTF_CFG2               ),                                  
  .CH0_FABRIC_INTF_CFG3             (CH0_FABRIC_INTF_CFG3               ),                                  
  .CH0_FABRIC_INTF_CFG4             (CH0_FABRIC_INTF_CFG4               ),                                  
  .CH0_FABRIC_INTF_CFG5             (CH0_FABRIC_INTF_CFG5               ),                                  
  .CH0_INSTANTIATED                 (CH0_INSTANTIATED                   ),                                  
  .CH0_MONITOR_CFG                  (CH0_MONITOR_CFG                    ),
  .CH0_PIPE_CTRL_CFG0               (CH0_PIPE_CTRL_CFG0                 ),                                  
  .CH0_PIPE_CTRL_CFG1               (CH0_PIPE_CTRL_CFG1                 ),                                  
  .CH0_PIPE_CTRL_CFG10              (CH0_PIPE_CTRL_CFG10                ),                                  
  .CH0_PIPE_CTRL_CFG2               (CH0_PIPE_CTRL_CFG2                 ),                                  
  .CH0_PIPE_CTRL_CFG3               (CH0_PIPE_CTRL_CFG3                 ),                                  
  .CH0_PIPE_CTRL_CFG4               (CH0_PIPE_CTRL_CFG4                 ),                                  
  .CH0_PIPE_CTRL_CFG5               (CH0_PIPE_CTRL_CFG5                 ),                                  
  .CH0_PIPE_CTRL_CFG6               (CH0_PIPE_CTRL_CFG6                 ),                                  
  .CH0_PIPE_CTRL_CFG7               (CH0_PIPE_CTRL_CFG7                 ),                                  
  .CH0_PIPE_CTRL_CFG8               (CH0_PIPE_CTRL_CFG8                 ),                                  
  .CH0_PIPE_CTRL_CFG9               (CH0_PIPE_CTRL_CFG9                 ),                                  
  .CH0_PIPE_TX_EQ_CFG0              (CH0_PIPE_TX_EQ_CFG0                ),                                  
  .CH0_PIPE_TX_EQ_CFG1              (CH0_PIPE_TX_EQ_CFG1                ),                                  
  .CH0_PIPE_TX_EQ_CFG2              (CH0_PIPE_TX_EQ_CFG2                ),                                  
  .CH0_PIPE_TX_EQ_CFG3              (CH0_PIPE_TX_EQ_CFG3                ),                                  
  .CH0_RESET_BYP_HDSHK_CFG          (CH0_RESET_BYP_HDSHK_CFG            ),                                  
  .CH0_RESET_CFG                    (CH0_RESET_CFG                      ),                                  
  .CH0_RESET_LOOPER_ID_CFG          (CH0_RESET_LOOPER_ID_CFG            ),                                  
  .CH0_RESET_LOOP_ID_CFG0           (CH0_RESET_LOOP_ID_CFG0             ),                                  
  .CH0_RESET_LOOP_ID_CFG1           (CH0_RESET_LOOP_ID_CFG1             ),                                  
  .CH0_RESET_LOOP_ID_CFG2           (CH0_RESET_LOOP_ID_CFG2             ),                                  
  .CH0_RESET_TIME_CFG0              (CH0_RESET_TIME_CFG0                ),                                  
  .CH0_RESET_TIME_CFG1              (CH0_RESET_TIME_CFG1                ),                                  
  .CH0_RESET_TIME_CFG2              (CH0_RESET_TIME_CFG2                ),                                  
  .CH0_RESET_TIME_CFG3              (CH0_RESET_TIME_CFG3                ),                                  
  .CH0_RXOUTCLK_FREQ                (CH0_RXOUTCLK_FREQ                  ),
  .CH0_RXOUTCLK_REF_FREQ            (CH0_RXOUTCLK_REF_FREQ              ),
  .CH0_RXOUTCLK_REF_SOURCE          (CH0_RXOUTCLK_REF_SOURCE            ),                         
  .CH0_RX_CDR_CFG0                  (CH0_RX_CDR_CFG0                    ),                                  
  .CH0_RX_CDR_CFG1                  (CH0_RX_CDR_CFG1                    ),                                  
  .CH0_RX_CDR_CFG2                  (CH0_RX_CDR_CFG2                    ),                                  
  .CH0_RX_CDR_CFG3                  (CH0_RX_CDR_CFG3                    ),                                  
  .CH0_RX_CDR_CFG4                  (CH0_RX_CDR_CFG4                    ),                                  
  .CH0_RX_CRC_CFG0                  (CH0_RX_CRC_CFG0                    ),                                  
  .CH0_RX_CRC_CFG1                  (CH0_RX_CRC_CFG1                    ),                                  
  .CH0_RX_CRC_CFG2                  (CH0_RX_CRC_CFG2                    ),                                  
  .CH0_RX_CRC_CFG3                  (CH0_RX_CRC_CFG3                    ),                                  
  .CH0_RX_CTLE_CFG0                 (CH0_RX_CTLE_CFG0                   ),                                  
  .CH0_RX_CTLE_CFG1                 (CH0_RX_CTLE_CFG1                   ),                                  
  .CH0_RX_DACI2V_CFG0               (CH0_RX_DACI2V_CFG0                 ),                                  
  .CH0_RX_DFE_CFG0                  (CH0_RX_DFE_CFG0                    ),                                  
  .CH0_RX_ELASTIC_BUF_CFG0          (CH0_RX_ELASTIC_BUF_CFG0            ),                                  
  .CH0_RX_ELASTIC_BUF_CFG1          (CH0_RX_ELASTIC_BUF_CFG1            ),                                  
  .CH0_RX_ELASTIC_BUF_CFG2          (CH0_RX_ELASTIC_BUF_CFG2            ),                                  
  .CH0_RX_ELASTIC_BUF_CFG3          (CH0_RX_ELASTIC_BUF_CFG3            ),                                  
  .CH0_RX_ELASTIC_BUF_CFG4          (CH0_RX_ELASTIC_BUF_CFG4            ),                                  
  .CH0_RX_ELASTIC_BUF_CFG5          (CH0_RX_ELASTIC_BUF_CFG5            ),                                  
  .CH0_RX_ELASTIC_BUF_CFG6          (CH0_RX_ELASTIC_BUF_CFG6            ),                                  
  .CH0_RX_ELASTIC_BUF_CFG7          (CH0_RX_ELASTIC_BUF_CFG7            ),                                  
  .CH0_RX_ELASTIC_BUF_CFG8          (CH0_RX_ELASTIC_BUF_CFG8            ),                                  
  .CH0_RX_ELASTIC_BUF_CFG9          (CH0_RX_ELASTIC_BUF_CFG9            ),                                  
  .CH0_RX_MISC_CFG0                 (CH0_RX_MISC_CFG0                   ),                                  
  .CH0_RX_OOB_CFG0                  (CH0_RX_OOB_CFG0                    ),                                  
  .CH0_RX_OOB_CFG1                  (CH0_RX_OOB_CFG1                    ),                                  
  .CH0_RX_PAD_CFG0                  (CH0_RX_PAD_CFG0                    ),                                  
  .CH0_RX_PAD_CFG1                  (CH0_RX_PAD_CFG1                    ),                                  
  .CH0_RX_PCS_CFG0                  (CH0_RX_PCS_CFG0                    ),                                  
  .CH0_RX_PCS_CFG1                  (CH0_RX_PCS_CFG1                    ),                                  
  .CH0_RX_PCS_CFG2                  (CH0_RX_PCS_CFG2                    ),                                  
  .CH0_RX_PCS_CFG3                  (CH0_RX_PCS_CFG3                    ),                                  
  .CH0_RX_PCS_CFG4                  (CH0_RX_PCS_CFG4                    ),                                  
  .CH0_RX_PHALIGN_CFG0              (CH0_RX_PHALIGN_CFG0                ),                                  
  .CH0_RX_PHALIGN_CFG1              (CH0_RX_PHALIGN_CFG1                ),                                  
  .CH0_RX_PHALIGN_CFG2              (CH0_RX_PHALIGN_CFG2                ),                                  
  .CH0_RX_PHALIGN_CFG3              (CH0_RX_PHALIGN_CFG3                ),                                  
  .CH0_RX_PHALIGN_CFG4              (CH0_RX_PHALIGN_CFG4                ),                                  
  .CH0_RX_PHALIGN_CFG5              (CH0_RX_PHALIGN_CFG5                ),                                  
  .CH0_SIM_MODE                     (CH0_SIM_MODE                       ),                                  
  .CH0_SIM_RECEIVER_DETECT_PASS     (CH0_SIM_RECEIVER_DETECT_PASS       ),                                  
  .CH0_SIM_RESET_SPEEDUP            (CH0_SIM_RESET_SPEEDUP              ),                                  
  .CH0_SIM_TX_EIDLE_DRIVE_LEVEL     (CH0_SIM_TX_EIDLE_DRIVE_LEVEL       ),                                  
  .CH0_TXOUTCLK_FREQ                (CH0_TXOUTCLK_FREQ                  ),
  .CH0_TXOUTCLK_REF_FREQ            (CH0_TXOUTCLK_REF_FREQ              ),
  .CH0_TXOUTCLK_REF_SOURCE          (CH0_TXOUTCLK_REF_SOURCE            ),
  .CH0_TX_10G_CFG0                  (CH0_TX_10G_CFG0                    ),                                  
  .CH0_TX_10G_CFG1                  (CH0_TX_10G_CFG1                    ),                                  
  .CH0_TX_10G_CFG2                  (CH0_TX_10G_CFG2                    ),                                  
  .CH0_TX_10G_CFG3                  (CH0_TX_10G_CFG3                    ),                                  
  .CH0_TX_ANA_CFG0                  (CH0_TX_ANA_CFG0                    ),                                  
  .CH0_TX_CRC_CFG0                  (CH0_TX_CRC_CFG0                    ),                                  
  .CH0_TX_CRC_CFG1                  (CH0_TX_CRC_CFG1                    ),                                  
  .CH0_TX_CRC_CFG2                  (CH0_TX_CRC_CFG2                    ),                                  
  .CH0_TX_CRC_CFG3                  (CH0_TX_CRC_CFG3                    ),                                  
  .CH0_TX_DRV_CFG0                  (CH0_TX_DRV_CFG0                    ),                                  
  .CH0_TX_DRV_CFG1                  (CH0_TX_DRV_CFG1                    ),                                  
  .CH0_TX_PCS_CFG0                  (CH0_TX_PCS_CFG0                    ),                                  
  .CH0_TX_PCS_CFG1                  (CH0_TX_PCS_CFG1                    ),                                  
  .CH0_TX_PCS_CFG2                  (CH0_TX_PCS_CFG2                    ),                                  
  .CH0_TX_PCS_CFG3                  (CH0_TX_PCS_CFG3                    ),                                  
  .CH0_TX_PHALIGN_CFG0              (CH0_TX_PHALIGN_CFG0                ),                                  
  .CH0_TX_PHALIGN_CFG1              (CH0_TX_PHALIGN_CFG1                ),                                  
  .CH0_TX_PHALIGN_CFG2              (CH0_TX_PHALIGN_CFG2                ),                                  
  .CH0_TX_PHALIGN_CFG3              (CH0_TX_PHALIGN_CFG3                ),                                  
  .CH0_TX_PHALIGN_CFG4              (CH0_TX_PHALIGN_CFG4                ),                                  
  .CH0_TX_PHALIGN_CFG5              (CH0_TX_PHALIGN_CFG5                ),                                  
  .CH0_TX_PIPPM_CFG                 (CH0_TX_PIPPM_CFG                   ),                                  
  .CH0_TX_SER_CFG0                  (CH0_TX_SER_CFG0                    ),                                  
  .CH1_ADAPT_APT_CFG                (CH1_ADAPT_APT_CFG                  ),                                  
  .CH1_ADAPT_CAL_CFG                (CH1_ADAPT_CAL_CFG                  ),                                  
  .CH1_ADAPT_DFE_CFG                (CH1_ADAPT_DFE_CFG                  ),                                  
  .CH1_ADAPT_GC_CFG0                (CH1_ADAPT_GC_CFG0                  ),                                  
  .CH1_ADAPT_GC_CFG1                (CH1_ADAPT_GC_CFG1                  ),                                  
  .CH1_ADAPT_GC_CFG2                (CH1_ADAPT_GC_CFG2                  ),                                  
  .CH1_ADAPT_GC_CFG3                (CH1_ADAPT_GC_CFG3                  ),                                  
  .CH1_ADAPT_GEN_CFG0               (CH1_ADAPT_GEN_CFG0                 ),                                  
  .CH1_ADAPT_GEN_CFG1               (CH1_ADAPT_GEN_CFG1                 ),                                  
  .CH1_ADAPT_GEN_CFG2               (CH1_ADAPT_GEN_CFG2                 ),                                  
  .CH1_ADAPT_GEN_CFG3               (CH1_ADAPT_GEN_CFG3                 ),                                  
  .CH1_ADAPT_H01_CFG                (CH1_ADAPT_H01_CFG                  ),                                  
  .CH1_ADAPT_H23_CFG                (CH1_ADAPT_H23_CFG                  ),                                  
  .CH1_ADAPT_H45_CFG                (CH1_ADAPT_H45_CFG                  ),                                  
  .CH1_ADAPT_H67_CFG                (CH1_ADAPT_H67_CFG                  ),                                  
  .CH1_ADAPT_H89_CFG                (CH1_ADAPT_H89_CFG                  ),                                  
  .CH1_ADAPT_HAB_CFG                (CH1_ADAPT_HAB_CFG                  ),                                  
  .CH1_ADAPT_HCD_CFG                (CH1_ADAPT_HCD_CFG                  ),                                  
  .CH1_ADAPT_HEF_CFG                (CH1_ADAPT_HEF_CFG                  ),                                  
  .CH1_ADAPT_KH_CFG0                (CH1_ADAPT_KH_CFG0                  ),                                  
  .CH1_ADAPT_KH_CFG1                (CH1_ADAPT_KH_CFG1                  ),                                  
  .CH1_ADAPT_KH_CFG2                (CH1_ADAPT_KH_CFG2                  ),                                  
  .CH1_ADAPT_KH_CFG3                (CH1_ADAPT_KH_CFG3                  ),                                  
  .CH1_ADAPT_KH_CFG4                (CH1_ADAPT_KH_CFG4                  ),                                  
  .CH1_ADAPT_KH_CFG5                (CH1_ADAPT_KH_CFG5                  ),                                  
  .CH1_ADAPT_KL_CFG0                (CH1_ADAPT_KL_CFG0                  ),                                  
  .CH1_ADAPT_KL_CFG1                (CH1_ADAPT_KL_CFG1                  ),                                  
  .CH1_ADAPT_LCK_CFG0               (CH1_ADAPT_LCK_CFG0                 ),                                  
  .CH1_ADAPT_LCK_CFG1               (CH1_ADAPT_LCK_CFG1                 ),                                  
  .CH1_ADAPT_LCK_CFG2               (CH1_ADAPT_LCK_CFG2                 ),                                  
  .CH1_ADAPT_LCK_CFG3               (CH1_ADAPT_LCK_CFG3                 ),                                  
  .CH1_ADAPT_LOP_CFG                (CH1_ADAPT_LOP_CFG                  ),                                  
  .CH1_ADAPT_OS_CFG                 (CH1_ADAPT_OS_CFG                   ),                                  
  .CH1_CHCLK_ILO_CFG                (CH1_CHCLK_ILO_CFG                  ),                                  
  .CH1_CHCLK_MISC_CFG               (CH1_CHCLK_MISC_CFG                 ),                                  
  .CH1_CHCLK_RSV_CFG                (CH1_CHCLK_RSV_CFG                  ),                                  
  .CH1_CHCLK_RXCAL_CFG              (CH1_CHCLK_RXCAL_CFG                ),                                  
  .CH1_CHCLK_RXCAL_CFG1             (CH1_CHCLK_RXCAL_CFG1               ),                                  
  .CH1_CHCLK_RXCAL_CFG2             (CH1_CHCLK_RXCAL_CFG2               ),                                  
  .CH1_CHCLK_RXPI_CFG               (CH1_CHCLK_RXPI_CFG                 ),                                  
  .CH1_CHCLK_TXCAL_CFG              (CH1_CHCLK_TXCAL_CFG                ),                                  
  .CH1_CHCLK_TXPI_CFG0              (CH1_CHCLK_TXPI_CFG0                ),                                  
  .CH1_CHL_RSV_CFG0                 (CH1_CHL_RSV_CFG0                   ),                                  
  .CH1_CHL_RSV_CFG1                 (CH1_CHL_RSV_CFG1                   ),                                  
  .CH1_CHL_RSV_CFG2                 (CH1_CHL_RSV_CFG2                   ),                                  
  .CH1_CHL_RSV_CFG3                 (CH1_CHL_RSV_CFG3                   ),                                  
  .CH1_CHL_RSV_CFG4                 (CH1_CHL_RSV_CFG4                   ),                                  
  .CH1_DA_CFG                       (CH1_DA_CFG                         ),
  .CH1_EYESCAN_CFG0                 (CH1_EYESCAN_CFG0                   ),                                  
  .CH1_EYESCAN_CFG1                 (CH1_EYESCAN_CFG1                   ),                                  
  .CH1_EYESCAN_CFG10                (CH1_EYESCAN_CFG10                  ),                                  
  .CH1_EYESCAN_CFG11                (CH1_EYESCAN_CFG11                  ),                                  
  .CH1_EYESCAN_CFG12                (CH1_EYESCAN_CFG12                  ),                                  
  .CH1_EYESCAN_CFG13                (CH1_EYESCAN_CFG13                  ),                                  
  .CH1_EYESCAN_CFG14                (CH1_EYESCAN_CFG14                  ),                                  
  .CH1_EYESCAN_CFG15                (CH1_EYESCAN_CFG15                  ),                                  
  .CH1_EYESCAN_CFG16                (CH1_EYESCAN_CFG16                  ),                                  
  .CH1_EYESCAN_CFG2                 (CH1_EYESCAN_CFG2                   ),                                  
  .CH1_EYESCAN_CFG3                 (CH1_EYESCAN_CFG3                   ),                                  
  .CH1_EYESCAN_CFG4                 (CH1_EYESCAN_CFG4                   ),                                  
  .CH1_EYESCAN_CFG5                 (CH1_EYESCAN_CFG5                   ),                                  
  .CH1_EYESCAN_CFG6                 (CH1_EYESCAN_CFG6                   ),                                  
  .CH1_EYESCAN_CFG7                 (CH1_EYESCAN_CFG7                   ),                                  
  .CH1_EYESCAN_CFG8                 (CH1_EYESCAN_CFG8                   ),                                  
  .CH1_EYESCAN_CFG9                 (CH1_EYESCAN_CFG9                   ),                                  
  //.CH1_FABRIC_INTF_CFG0             ('d4278190079               ),                                  
  .CH1_FABRIC_INTF_CFG0             ( CH1_FABRIC_INTF_CFG0              ),                                  
  .CH1_FABRIC_INTF_CFG1             (CH1_FABRIC_INTF_CFG1               ),                                  
  .CH1_FABRIC_INTF_CFG2             (CH1_FABRIC_INTF_CFG2               ),                                  
  .CH1_FABRIC_INTF_CFG3             (CH1_FABRIC_INTF_CFG3               ),                                  
  .CH1_FABRIC_INTF_CFG4             (CH1_FABRIC_INTF_CFG4               ),                                  
  .CH1_FABRIC_INTF_CFG5             (CH1_FABRIC_INTF_CFG5               ),                                  
  .CH1_INSTANTIATED                 (CH1_INSTANTIATED                   ),                                  
  .CH1_MONITOR_CFG                  (CH1_MONITOR_CFG                    ),
  .CH1_PIPE_CTRL_CFG0               (CH1_PIPE_CTRL_CFG0                 ),                                  
  .CH1_PIPE_CTRL_CFG1               (CH1_PIPE_CTRL_CFG1                 ),                                  
  .CH1_PIPE_CTRL_CFG10              (CH1_PIPE_CTRL_CFG10                ),                                  
  .CH1_PIPE_CTRL_CFG2               (CH1_PIPE_CTRL_CFG2                 ),                                  
  .CH1_PIPE_CTRL_CFG3               (CH1_PIPE_CTRL_CFG3                 ),                                  
  .CH1_PIPE_CTRL_CFG4               (CH1_PIPE_CTRL_CFG4                 ),                                  
  .CH1_PIPE_CTRL_CFG5               (CH1_PIPE_CTRL_CFG5                 ),                                  
  .CH1_PIPE_CTRL_CFG6               (CH1_PIPE_CTRL_CFG6                 ),                                  
  .CH1_PIPE_CTRL_CFG7               (CH1_PIPE_CTRL_CFG7                 ),                                  
  .CH1_PIPE_CTRL_CFG8               (CH1_PIPE_CTRL_CFG8                 ),                                  
  .CH1_PIPE_CTRL_CFG9               (CH1_PIPE_CTRL_CFG9                 ),                                  
  .CH1_PIPE_TX_EQ_CFG0              (CH1_PIPE_TX_EQ_CFG0                ),                                  
  .CH1_PIPE_TX_EQ_CFG1              (CH1_PIPE_TX_EQ_CFG1                ),                                  
  .CH1_PIPE_TX_EQ_CFG2              (CH1_PIPE_TX_EQ_CFG2                ),                                  
  .CH1_PIPE_TX_EQ_CFG3              (CH1_PIPE_TX_EQ_CFG3                ),                                  
  .CH1_RESET_BYP_HDSHK_CFG          (CH1_RESET_BYP_HDSHK_CFG            ),                                  
  .CH1_RESET_CFG                    (CH1_RESET_CFG                      ),                                  
  .CH1_RESET_LOOPER_ID_CFG          (CH1_RESET_LOOPER_ID_CFG            ),                                  
  .CH1_RESET_LOOP_ID_CFG0           (CH1_RESET_LOOP_ID_CFG0             ),                                  
  .CH1_RESET_LOOP_ID_CFG1           (CH1_RESET_LOOP_ID_CFG1             ),                                  
  .CH1_RESET_LOOP_ID_CFG2           (CH1_RESET_LOOP_ID_CFG2             ),                                  
  .CH1_RESET_TIME_CFG0              (CH1_RESET_TIME_CFG0                ),                                  
  .CH1_RESET_TIME_CFG1              (CH1_RESET_TIME_CFG1                ),                                  
  .CH1_RESET_TIME_CFG2              (CH1_RESET_TIME_CFG2                ),                                  
  .CH1_RESET_TIME_CFG3              (CH1_RESET_TIME_CFG3                ),                                  
  .CH1_RXOUTCLK_FREQ                (CH1_RXOUTCLK_FREQ                  ),
  .CH1_RXOUTCLK_REF_FREQ            (CH1_RXOUTCLK_REF_FREQ              ),
  .CH1_RXOUTCLK_REF_SOURCE          (CH1_RXOUTCLK_REF_SOURCE            ),                         
  .CH1_RX_CDR_CFG0                  (CH1_RX_CDR_CFG0                    ),                                  
  .CH1_RX_CDR_CFG1                  (CH1_RX_CDR_CFG1                    ),                                  
  .CH1_RX_CDR_CFG2                  (CH1_RX_CDR_CFG2                    ),                                  
  .CH1_RX_CDR_CFG3                  (CH1_RX_CDR_CFG3                    ),                                  
  .CH1_RX_CDR_CFG4                  (CH1_RX_CDR_CFG4                    ),                                  
  .CH1_RX_CRC_CFG0                  (CH1_RX_CRC_CFG0                    ),                                  
  .CH1_RX_CRC_CFG1                  (CH1_RX_CRC_CFG1                    ),                                  
  .CH1_RX_CRC_CFG2                  (CH1_RX_CRC_CFG2                    ),                                  
  .CH1_RX_CRC_CFG3                  (CH1_RX_CRC_CFG3                    ),                                  
  .CH1_RX_CTLE_CFG0                 (CH1_RX_CTLE_CFG0                   ),                                  
  .CH1_RX_CTLE_CFG1                 (CH1_RX_CTLE_CFG1                   ),                                  
  .CH1_RX_DACI2V_CFG0               (CH1_RX_DACI2V_CFG0                 ),                                  
  .CH1_RX_DFE_CFG0                  (CH1_RX_DFE_CFG0                    ),                                  
  .CH1_RX_ELASTIC_BUF_CFG0          (CH1_RX_ELASTIC_BUF_CFG0            ),                                  
  .CH1_RX_ELASTIC_BUF_CFG1          (CH1_RX_ELASTIC_BUF_CFG1            ),                                  
  .CH1_RX_ELASTIC_BUF_CFG2          (CH1_RX_ELASTIC_BUF_CFG2            ),                                  
  .CH1_RX_ELASTIC_BUF_CFG3          (CH1_RX_ELASTIC_BUF_CFG3            ),                                  
  .CH1_RX_ELASTIC_BUF_CFG4          (CH1_RX_ELASTIC_BUF_CFG4            ),                                  
  .CH1_RX_ELASTIC_BUF_CFG5          (CH1_RX_ELASTIC_BUF_CFG5            ),                                  
  .CH1_RX_ELASTIC_BUF_CFG6          (CH1_RX_ELASTIC_BUF_CFG6            ),                                  
  .CH1_RX_ELASTIC_BUF_CFG7          (CH1_RX_ELASTIC_BUF_CFG7            ),                                  
  .CH1_RX_ELASTIC_BUF_CFG8          (CH1_RX_ELASTIC_BUF_CFG8            ),                                  
  .CH1_RX_ELASTIC_BUF_CFG9          (CH1_RX_ELASTIC_BUF_CFG9            ),                                  
  .CH1_RX_MISC_CFG0                 (CH1_RX_MISC_CFG0                   ),                                  
  .CH1_RX_OOB_CFG0                  (CH1_RX_OOB_CFG0                    ),                                  
  .CH1_RX_OOB_CFG1                  (CH1_RX_OOB_CFG1                    ),                                  
  .CH1_RX_PAD_CFG0                  (CH1_RX_PAD_CFG0                    ),                                  
  .CH1_RX_PAD_CFG1                  (CH1_RX_PAD_CFG1                    ),                                  
  .CH1_RX_PCS_CFG0                  (CH1_RX_PCS_CFG0                    ),                                  
  .CH1_RX_PCS_CFG1                  (CH1_RX_PCS_CFG1                    ),                                  
  .CH1_RX_PCS_CFG2                  (CH1_RX_PCS_CFG2                    ),                                  
  .CH1_RX_PCS_CFG3                  (CH1_RX_PCS_CFG3                    ),                                  
  .CH1_RX_PCS_CFG4                  (CH1_RX_PCS_CFG4                    ),                                  
  .CH1_RX_PHALIGN_CFG0              (CH1_RX_PHALIGN_CFG0                ),                                  
  .CH1_RX_PHALIGN_CFG1              (CH1_RX_PHALIGN_CFG1                ),                                  
  .CH1_RX_PHALIGN_CFG2              (CH1_RX_PHALIGN_CFG2                ),                                  
  .CH1_RX_PHALIGN_CFG3              (CH1_RX_PHALIGN_CFG3                ),                                  
  .CH1_RX_PHALIGN_CFG4              (CH1_RX_PHALIGN_CFG4                ),                                  
  .CH1_RX_PHALIGN_CFG5              (CH1_RX_PHALIGN_CFG5                ),                                  
  .CH1_SIM_MODE                     (CH1_SIM_MODE                       ),                                  
  .CH1_SIM_RECEIVER_DETECT_PASS     (CH1_SIM_RECEIVER_DETECT_PASS       ),                                  
  .CH1_SIM_RESET_SPEEDUP            (CH1_SIM_RESET_SPEEDUP              ),                                  
  .CH1_SIM_TX_EIDLE_DRIVE_LEVEL     (CH1_SIM_TX_EIDLE_DRIVE_LEVEL       ),                                  
  .CH1_TXOUTCLK_FREQ                (CH1_TXOUTCLK_FREQ                  ),
  .CH1_TXOUTCLK_REF_FREQ            (CH1_TXOUTCLK_REF_FREQ              ),
  .CH1_TXOUTCLK_REF_SOURCE          (CH1_TXOUTCLK_REF_SOURCE            ),
  .CH1_TX_10G_CFG0                  (CH1_TX_10G_CFG0                    ),                                  
  .CH1_TX_10G_CFG1                  (CH1_TX_10G_CFG1                    ),                                  
  .CH1_TX_10G_CFG2                  (CH1_TX_10G_CFG2                    ),                                  
  .CH1_TX_10G_CFG3                  (CH1_TX_10G_CFG3                    ),                                  
  .CH1_TX_ANA_CFG0                  (CH1_TX_ANA_CFG0                    ),                                  
  .CH1_TX_CRC_CFG0                  (CH1_TX_CRC_CFG0                    ),                                  
  .CH1_TX_CRC_CFG1                  (CH1_TX_CRC_CFG1                    ),                                  
  .CH1_TX_CRC_CFG2                  (CH1_TX_CRC_CFG2                    ),                                  
  .CH1_TX_CRC_CFG3                  (CH1_TX_CRC_CFG3                    ),                                  
  .CH1_TX_DRV_CFG0                  (CH1_TX_DRV_CFG0                    ),                                  
  .CH1_TX_DRV_CFG1                  (CH1_TX_DRV_CFG1                    ),                                  
  .CH1_TX_PCS_CFG0                  (CH1_TX_PCS_CFG0                    ),                                  
  .CH1_TX_PCS_CFG1                  (CH1_TX_PCS_CFG1                    ),                                  
  .CH1_TX_PCS_CFG2                  (CH1_TX_PCS_CFG2                    ),                                  
  .CH1_TX_PCS_CFG3                  (CH1_TX_PCS_CFG3                    ),                                  
  .CH1_TX_PHALIGN_CFG0              (CH1_TX_PHALIGN_CFG0                ),                                  
  .CH1_TX_PHALIGN_CFG1              (CH1_TX_PHALIGN_CFG1                ),                                  
  .CH1_TX_PHALIGN_CFG2              (CH1_TX_PHALIGN_CFG2                ),                                  
  .CH1_TX_PHALIGN_CFG3              (CH1_TX_PHALIGN_CFG3                ),                                  
  .CH1_TX_PHALIGN_CFG4              (CH1_TX_PHALIGN_CFG4                ),                                  
  .CH1_TX_PHALIGN_CFG5              (CH1_TX_PHALIGN_CFG5                ),                                  
  .CH1_TX_PIPPM_CFG                 (CH1_TX_PIPPM_CFG                   ),                                  
  .CH1_TX_SER_CFG0                  (CH1_TX_SER_CFG0                    ),                                  
  .CH2_ADAPT_APT_CFG                (CH2_ADAPT_APT_CFG                  ),                                  
  .CH2_ADAPT_CAL_CFG                (CH2_ADAPT_CAL_CFG                  ),                                  
  .CH2_ADAPT_DFE_CFG                (CH2_ADAPT_DFE_CFG                  ),                                  
  .CH2_ADAPT_GC_CFG0                (CH2_ADAPT_GC_CFG0                  ),                                  
  .CH2_ADAPT_GC_CFG1                (CH2_ADAPT_GC_CFG1                  ),                                  
  .CH2_ADAPT_GC_CFG2                (CH2_ADAPT_GC_CFG2                  ),                                  
  .CH2_ADAPT_GC_CFG3                (CH2_ADAPT_GC_CFG3                  ),                                  
  .CH2_ADAPT_GEN_CFG0               (CH2_ADAPT_GEN_CFG0                 ),                                  
  .CH2_ADAPT_GEN_CFG1               (CH2_ADAPT_GEN_CFG1                 ),                                  
  .CH2_ADAPT_GEN_CFG2               (CH2_ADAPT_GEN_CFG2                 ),                                  
  .CH2_ADAPT_GEN_CFG3               (CH2_ADAPT_GEN_CFG3                 ),                                  
  .CH2_ADAPT_H01_CFG                (CH2_ADAPT_H01_CFG                  ),                                  
  .CH2_ADAPT_H23_CFG                (CH2_ADAPT_H23_CFG                  ),                                  
  .CH2_ADAPT_H45_CFG                (CH2_ADAPT_H45_CFG                  ),                                  
  .CH2_ADAPT_H67_CFG                (CH2_ADAPT_H67_CFG                  ),                                  
  .CH2_ADAPT_H89_CFG                (CH2_ADAPT_H89_CFG                  ),                                  
  .CH2_ADAPT_HAB_CFG                (CH2_ADAPT_HAB_CFG                  ),                                  
  .CH2_ADAPT_HCD_CFG                (CH2_ADAPT_HCD_CFG                  ),                                  
  .CH2_ADAPT_HEF_CFG                (CH2_ADAPT_HEF_CFG                  ),                                  
  .CH2_ADAPT_KH_CFG0                (CH2_ADAPT_KH_CFG0                  ),                                  
  .CH2_ADAPT_KH_CFG1                (CH2_ADAPT_KH_CFG1                  ),                                  
  .CH2_ADAPT_KH_CFG2                (CH2_ADAPT_KH_CFG2                  ),                                  
  .CH2_ADAPT_KH_CFG3                (CH2_ADAPT_KH_CFG3                  ),                                  
  .CH2_ADAPT_KH_CFG4                (CH2_ADAPT_KH_CFG4                  ),                                  
  .CH2_ADAPT_KH_CFG5                (CH2_ADAPT_KH_CFG5                  ),                                  
  .CH2_ADAPT_KL_CFG0                (CH2_ADAPT_KL_CFG0                  ),                                  
  .CH2_ADAPT_KL_CFG1                (CH2_ADAPT_KL_CFG1                  ),                                  
  .CH2_ADAPT_LCK_CFG0               (CH2_ADAPT_LCK_CFG0                 ),                                  
  .CH2_ADAPT_LCK_CFG1               (CH2_ADAPT_LCK_CFG1                 ),                                  
  .CH2_ADAPT_LCK_CFG2               (CH2_ADAPT_LCK_CFG2                 ),                                  
  .CH2_ADAPT_LCK_CFG3               (CH2_ADAPT_LCK_CFG3                 ),                                  
  .CH2_ADAPT_LOP_CFG                (CH2_ADAPT_LOP_CFG                  ),                                  
  .CH2_ADAPT_OS_CFG                 (CH2_ADAPT_OS_CFG                   ),                                  
  .CH2_CHCLK_ILO_CFG                (CH2_CHCLK_ILO_CFG                  ),                                  
  .CH2_CHCLK_MISC_CFG               (CH2_CHCLK_MISC_CFG                 ),                                  
  .CH2_CHCLK_RSV_CFG                (CH2_CHCLK_RSV_CFG                  ),                                  
  .CH2_CHCLK_RXCAL_CFG              (CH2_CHCLK_RXCAL_CFG                ),                                  
  .CH2_CHCLK_RXCAL_CFG1             (CH2_CHCLK_RXCAL_CFG1               ),                                  
  .CH2_CHCLK_RXCAL_CFG2             (CH2_CHCLK_RXCAL_CFG2               ),                                  
  .CH2_CHCLK_RXPI_CFG               (CH2_CHCLK_RXPI_CFG                 ),                                  
  .CH2_CHCLK_TXCAL_CFG              (CH2_CHCLK_TXCAL_CFG                ),                                  
  .CH2_CHCLK_TXPI_CFG0              (CH2_CHCLK_TXPI_CFG0                ),                                  
  .CH2_CHL_RSV_CFG0                 (CH2_CHL_RSV_CFG0                   ),                                  
  .CH2_CHL_RSV_CFG1                 (CH2_CHL_RSV_CFG1                   ),                                  
  .CH2_CHL_RSV_CFG2                 (CH2_CHL_RSV_CFG2                   ),                                  
  .CH2_CHL_RSV_CFG3                 (CH2_CHL_RSV_CFG3                   ),                                  
  .CH2_CHL_RSV_CFG4                 (CH2_CHL_RSV_CFG4                   ),                                  
  .CH2_DA_CFG                       (CH2_DA_CFG                         ),
  .CH2_EYESCAN_CFG0                 (CH2_EYESCAN_CFG0                   ),                                  
  .CH2_EYESCAN_CFG1                 (CH2_EYESCAN_CFG1                   ),                                  
  .CH2_EYESCAN_CFG10                (CH2_EYESCAN_CFG10                  ),                                  
  .CH2_EYESCAN_CFG11                (CH2_EYESCAN_CFG11                  ),                                  
  .CH2_EYESCAN_CFG12                (CH2_EYESCAN_CFG12                  ),                                  
  .CH2_EYESCAN_CFG13                (CH2_EYESCAN_CFG13                  ),                                  
  .CH2_EYESCAN_CFG14                (CH2_EYESCAN_CFG14                  ),                                  
  .CH2_EYESCAN_CFG15                (CH2_EYESCAN_CFG15                  ),                                  
  .CH2_EYESCAN_CFG16                (CH2_EYESCAN_CFG16                  ),                                  
  .CH2_EYESCAN_CFG2                 (CH2_EYESCAN_CFG2                   ),                                  
  .CH2_EYESCAN_CFG3                 (CH2_EYESCAN_CFG3                   ),                                  
  .CH2_EYESCAN_CFG4                 (CH2_EYESCAN_CFG4                   ),                                  
  .CH2_EYESCAN_CFG5                 (CH2_EYESCAN_CFG5                   ),                                  
  .CH2_EYESCAN_CFG6                 (CH2_EYESCAN_CFG6                   ),                                  
  .CH2_EYESCAN_CFG7                 (CH2_EYESCAN_CFG7                   ),                                  
  .CH2_EYESCAN_CFG8                 (CH2_EYESCAN_CFG8                   ),                                  
  .CH2_EYESCAN_CFG9                 (CH2_EYESCAN_CFG9                   ),                                  
  //.CH2_FABRIC_INTF_CFG0             ('d4278190079               ),                                  
  .CH2_FABRIC_INTF_CFG0             (CH2_FABRIC_INTF_CFG0               ),                                  
  .CH2_FABRIC_INTF_CFG1             (CH2_FABRIC_INTF_CFG1               ),                                  
  .CH2_FABRIC_INTF_CFG2             (CH2_FABRIC_INTF_CFG2               ),                                  
  .CH2_FABRIC_INTF_CFG3             (CH2_FABRIC_INTF_CFG3               ),                                  
  .CH2_FABRIC_INTF_CFG4             (CH2_FABRIC_INTF_CFG4               ),                                  
  .CH2_FABRIC_INTF_CFG5             (CH2_FABRIC_INTF_CFG5               ),                                  
  .CH2_INSTANTIATED                 (CH2_INSTANTIATED                   ),                                  
  .CH2_MONITOR_CFG                  (CH2_MONITOR_CFG                    ),
  .CH2_PIPE_CTRL_CFG0               (CH2_PIPE_CTRL_CFG0                 ),                                  
  .CH2_PIPE_CTRL_CFG1               (CH2_PIPE_CTRL_CFG1                 ),                                  
  .CH2_PIPE_CTRL_CFG10              (CH2_PIPE_CTRL_CFG10                ),                                  
  .CH2_PIPE_CTRL_CFG2               (CH2_PIPE_CTRL_CFG2                 ),                                  
  .CH2_PIPE_CTRL_CFG3               (CH2_PIPE_CTRL_CFG3                 ),                                  
  .CH2_PIPE_CTRL_CFG4               (CH2_PIPE_CTRL_CFG4                 ),                                  
  .CH2_PIPE_CTRL_CFG5               (CH2_PIPE_CTRL_CFG5                 ),                                  
  .CH2_PIPE_CTRL_CFG6               (CH2_PIPE_CTRL_CFG6                 ),                                  
  .CH2_PIPE_CTRL_CFG7               (CH2_PIPE_CTRL_CFG7                 ),                                  
  .CH2_PIPE_CTRL_CFG8               (CH2_PIPE_CTRL_CFG8                 ),                                  
  .CH2_PIPE_CTRL_CFG9               (CH2_PIPE_CTRL_CFG9                 ),                                  
  .CH2_PIPE_TX_EQ_CFG0              (CH2_PIPE_TX_EQ_CFG0                ),                                  
  .CH2_PIPE_TX_EQ_CFG1              (CH2_PIPE_TX_EQ_CFG1                ),                                  
  .CH2_PIPE_TX_EQ_CFG2              (CH2_PIPE_TX_EQ_CFG2                ),                                  
  .CH2_PIPE_TX_EQ_CFG3              (CH2_PIPE_TX_EQ_CFG3                ),                                  
  .CH2_RESET_BYP_HDSHK_CFG          (CH2_RESET_BYP_HDSHK_CFG            ),                                  
  .CH2_RESET_CFG                    (CH2_RESET_CFG                      ),                                  
  .CH2_RESET_LOOPER_ID_CFG          (CH2_RESET_LOOPER_ID_CFG            ),                                  
  .CH2_RESET_LOOP_ID_CFG0           (CH2_RESET_LOOP_ID_CFG0             ),                                  
  .CH2_RESET_LOOP_ID_CFG1           (CH2_RESET_LOOP_ID_CFG1             ),                                  
  .CH2_RESET_LOOP_ID_CFG2           (CH2_RESET_LOOP_ID_CFG2             ),                                  
  .CH2_RESET_TIME_CFG0              (CH2_RESET_TIME_CFG0                ),                                  
  .CH2_RESET_TIME_CFG1              (CH2_RESET_TIME_CFG1                ),                                  
  .CH2_RESET_TIME_CFG2              (CH2_RESET_TIME_CFG2                ),                                  
  .CH2_RESET_TIME_CFG3              (CH2_RESET_TIME_CFG3                ),                                  
  .CH2_RXOUTCLK_FREQ                (CH2_RXOUTCLK_FREQ                  ),
  .CH2_RXOUTCLK_REF_FREQ            (CH2_RXOUTCLK_REF_FREQ              ),
  .CH2_RXOUTCLK_REF_SOURCE          (CH2_RXOUTCLK_REF_SOURCE            ),                         
  .CH2_RX_CDR_CFG0                  (CH2_RX_CDR_CFG0                    ),                                  
  .CH2_RX_CDR_CFG1                  (CH2_RX_CDR_CFG1                    ),                                  
  .CH2_RX_CDR_CFG2                  (CH2_RX_CDR_CFG2                    ),                                  
  .CH2_RX_CDR_CFG3                  (CH2_RX_CDR_CFG3                    ),                                  
  .CH2_RX_CDR_CFG4                  (CH2_RX_CDR_CFG4                    ),                                  
  .CH2_RX_CRC_CFG0                  (CH2_RX_CRC_CFG0                    ),                                  
  .CH2_RX_CRC_CFG1                  (CH2_RX_CRC_CFG1                    ),                                  
  .CH2_RX_CRC_CFG2                  (CH2_RX_CRC_CFG2                    ),                                  
  .CH2_RX_CRC_CFG3                  (CH2_RX_CRC_CFG3                    ),                                  
  .CH2_RX_CTLE_CFG0                 (CH2_RX_CTLE_CFG0                   ),                                  
  .CH2_RX_CTLE_CFG1                 (CH2_RX_CTLE_CFG1                   ),                                  
  .CH2_RX_DACI2V_CFG0               (CH2_RX_DACI2V_CFG0                 ),                                  
  .CH2_RX_DFE_CFG0                  (CH2_RX_DFE_CFG0                    ),                                  
  .CH2_RX_ELASTIC_BUF_CFG0          (CH2_RX_ELASTIC_BUF_CFG0            ),                                  
  .CH2_RX_ELASTIC_BUF_CFG1          (CH2_RX_ELASTIC_BUF_CFG1            ),                                  
  .CH2_RX_ELASTIC_BUF_CFG2          (CH2_RX_ELASTIC_BUF_CFG2            ),                                  
  .CH2_RX_ELASTIC_BUF_CFG3          (CH2_RX_ELASTIC_BUF_CFG3            ),                                  
  .CH2_RX_ELASTIC_BUF_CFG4          (CH2_RX_ELASTIC_BUF_CFG4            ),                                  
  .CH2_RX_ELASTIC_BUF_CFG5          (CH2_RX_ELASTIC_BUF_CFG5            ),                                  
  .CH2_RX_ELASTIC_BUF_CFG6          (CH2_RX_ELASTIC_BUF_CFG6            ),                                  
  .CH2_RX_ELASTIC_BUF_CFG7          (CH2_RX_ELASTIC_BUF_CFG7            ),                                  
  .CH2_RX_ELASTIC_BUF_CFG8          (CH2_RX_ELASTIC_BUF_CFG8            ),                                  
  .CH2_RX_ELASTIC_BUF_CFG9          (CH2_RX_ELASTIC_BUF_CFG9            ),                                  
  .CH2_RX_MISC_CFG0                 (CH2_RX_MISC_CFG0                   ),                                  
  .CH2_RX_OOB_CFG0                  (CH2_RX_OOB_CFG0                    ),                                  
  .CH2_RX_OOB_CFG1                  (CH2_RX_OOB_CFG1                    ),                                  
  .CH2_RX_PAD_CFG0                  (CH2_RX_PAD_CFG0                    ),                                  
  .CH2_RX_PAD_CFG1                  (CH2_RX_PAD_CFG1                    ),                                  
  .CH2_RX_PCS_CFG0                  (CH2_RX_PCS_CFG0                    ),                                  
  .CH2_RX_PCS_CFG1                  (CH2_RX_PCS_CFG1                    ),                                  
  .CH2_RX_PCS_CFG2                  (CH2_RX_PCS_CFG2                    ),                                  
  .CH2_RX_PCS_CFG3                  (CH2_RX_PCS_CFG3                    ),                                  
  .CH2_RX_PCS_CFG4                  (CH2_RX_PCS_CFG4                    ),                                  
  .CH2_RX_PHALIGN_CFG0              (CH2_RX_PHALIGN_CFG0                ),                                  
  .CH2_RX_PHALIGN_CFG1              (CH2_RX_PHALIGN_CFG1                ),                                  
  .CH2_RX_PHALIGN_CFG2              (CH2_RX_PHALIGN_CFG2                ),                                  
  .CH2_RX_PHALIGN_CFG3              (CH2_RX_PHALIGN_CFG3                ),                                  
  .CH2_RX_PHALIGN_CFG4              (CH2_RX_PHALIGN_CFG4                ),                                  
  .CH2_RX_PHALIGN_CFG5              (CH2_RX_PHALIGN_CFG5                ),                                  
  .CH2_SIM_MODE                     (CH2_SIM_MODE                       ),                                  
  .CH2_SIM_RECEIVER_DETECT_PASS     (CH2_SIM_RECEIVER_DETECT_PASS       ),                                  
  .CH2_SIM_RESET_SPEEDUP            (CH2_SIM_RESET_SPEEDUP              ),                                  
  .CH2_SIM_TX_EIDLE_DRIVE_LEVEL     (CH2_SIM_TX_EIDLE_DRIVE_LEVEL       ),                                  
  .CH2_TXOUTCLK_FREQ                (CH2_TXOUTCLK_FREQ                  ),
  .CH2_TXOUTCLK_REF_FREQ            (CH2_TXOUTCLK_REF_FREQ              ),
  .CH2_TXOUTCLK_REF_SOURCE          (CH2_TXOUTCLK_REF_SOURCE            ),
  .CH2_TX_10G_CFG0                  (CH2_TX_10G_CFG0                    ),                                  
  .CH2_TX_10G_CFG1                  (CH2_TX_10G_CFG1                    ),                                  
  .CH2_TX_10G_CFG2                  (CH2_TX_10G_CFG2                    ),                                  
  .CH2_TX_10G_CFG3                  (CH2_TX_10G_CFG3                    ),                                  
  .CH2_TX_ANA_CFG0                  (CH2_TX_ANA_CFG0                    ),                                  
  .CH2_TX_CRC_CFG0                  (CH2_TX_CRC_CFG0                    ),                                  
  .CH2_TX_CRC_CFG1                  (CH2_TX_CRC_CFG1                    ),                                  
  .CH2_TX_CRC_CFG2                  (CH2_TX_CRC_CFG2                    ),                                  
  .CH2_TX_CRC_CFG3                  (CH2_TX_CRC_CFG3                    ),                                  
  .CH2_TX_DRV_CFG0                  (CH2_TX_DRV_CFG0                    ),                                  
  .CH2_TX_DRV_CFG1                  (CH2_TX_DRV_CFG1                    ),                                  
  .CH2_TX_PCS_CFG0                  (CH2_TX_PCS_CFG0                    ),                                  
  .CH2_TX_PCS_CFG1                  (CH2_TX_PCS_CFG1                    ),                                  
  .CH2_TX_PCS_CFG2                  (CH2_TX_PCS_CFG2                    ),                                  
  .CH2_TX_PCS_CFG3                  (CH2_TX_PCS_CFG3                    ),                                  
  .CH2_TX_PHALIGN_CFG0              (CH2_TX_PHALIGN_CFG0                ),                                  
  .CH2_TX_PHALIGN_CFG1              (CH2_TX_PHALIGN_CFG1                ),                                  
  .CH2_TX_PHALIGN_CFG2              (CH2_TX_PHALIGN_CFG2                ),                                  
  .CH2_TX_PHALIGN_CFG3              (CH2_TX_PHALIGN_CFG3                ),                                  
  .CH2_TX_PHALIGN_CFG4              (CH2_TX_PHALIGN_CFG4                ),                                  
  .CH2_TX_PHALIGN_CFG5              (CH2_TX_PHALIGN_CFG5                ),                                  
  .CH2_TX_PIPPM_CFG                 (CH2_TX_PIPPM_CFG                   ),                                  
  .CH2_TX_SER_CFG0                  (CH2_TX_SER_CFG0                    ),                                  
  .CH3_ADAPT_APT_CFG                (CH3_ADAPT_APT_CFG                  ),                                  
  .CH3_ADAPT_CAL_CFG                (CH3_ADAPT_CAL_CFG                  ),                                  
  .CH3_ADAPT_DFE_CFG                (CH3_ADAPT_DFE_CFG                  ),                                  
  .CH3_ADAPT_GC_CFG0                (CH3_ADAPT_GC_CFG0                  ),                                  
  .CH3_ADAPT_GC_CFG1                (CH3_ADAPT_GC_CFG1                  ),                                  
  .CH3_ADAPT_GC_CFG2                (CH3_ADAPT_GC_CFG2                  ),                                  
  .CH3_ADAPT_GC_CFG3                (CH3_ADAPT_GC_CFG3                  ),                                  
  .CH3_ADAPT_GEN_CFG0               (CH3_ADAPT_GEN_CFG0                 ),                                  
  .CH3_ADAPT_GEN_CFG1               (CH3_ADAPT_GEN_CFG1                 ),                                  
  .CH3_ADAPT_GEN_CFG2               (CH3_ADAPT_GEN_CFG2                 ),                                  
  .CH3_ADAPT_GEN_CFG3               (CH3_ADAPT_GEN_CFG3                 ),                                  
  .CH3_ADAPT_H01_CFG                (CH3_ADAPT_H01_CFG                  ),                                  
  .CH3_ADAPT_H23_CFG                (CH3_ADAPT_H23_CFG                  ),                                  
  .CH3_ADAPT_H45_CFG                (CH3_ADAPT_H45_CFG                  ),                                  
  .CH3_ADAPT_H67_CFG                (CH3_ADAPT_H67_CFG                  ),                                  
  .CH3_ADAPT_H89_CFG                (CH3_ADAPT_H89_CFG                  ),                                  
  .CH3_ADAPT_HAB_CFG                (CH3_ADAPT_HAB_CFG                  ),                                  
  .CH3_ADAPT_HCD_CFG                (CH3_ADAPT_HCD_CFG                  ),                                  
  .CH3_ADAPT_HEF_CFG                (CH3_ADAPT_HEF_CFG                  ),                                  
  .CH3_ADAPT_KH_CFG0                (CH3_ADAPT_KH_CFG0                  ),                                  
  .CH3_ADAPT_KH_CFG1                (CH3_ADAPT_KH_CFG1                  ),                                  
  .CH3_ADAPT_KH_CFG2                (CH3_ADAPT_KH_CFG2                  ),                                  
  .CH3_ADAPT_KH_CFG3                (CH3_ADAPT_KH_CFG3                  ),                                  
  .CH3_ADAPT_KH_CFG4                (CH3_ADAPT_KH_CFG4                  ),                                  
  .CH3_ADAPT_KH_CFG5                (CH3_ADAPT_KH_CFG5                  ),                                  
  .CH3_ADAPT_KL_CFG0                (CH3_ADAPT_KL_CFG0                  ),                                  
  .CH3_ADAPT_KL_CFG1                (CH3_ADAPT_KL_CFG1                  ),                                  
  .CH3_ADAPT_LCK_CFG0               (CH3_ADAPT_LCK_CFG0                 ),                                  
  .CH3_ADAPT_LCK_CFG1               (CH3_ADAPT_LCK_CFG1                 ),                                  
  .CH3_ADAPT_LCK_CFG2               (CH3_ADAPT_LCK_CFG2                 ),                                  
  .CH3_ADAPT_LCK_CFG3               (CH3_ADAPT_LCK_CFG3                 ),                                  
  .CH3_ADAPT_LOP_CFG                (CH3_ADAPT_LOP_CFG                  ),                                  
  .CH3_ADAPT_OS_CFG                 (CH3_ADAPT_OS_CFG                   ),                                  
  .CH3_CHCLK_ILO_CFG                (CH3_CHCLK_ILO_CFG                  ),                                  
  .CH3_CHCLK_MISC_CFG               (CH3_CHCLK_MISC_CFG                 ),                                  
  .CH3_CHCLK_RSV_CFG                (CH3_CHCLK_RSV_CFG                  ),                                  
  .CH3_CHCLK_RXCAL_CFG              (CH3_CHCLK_RXCAL_CFG                ),                                  
  .CH3_CHCLK_RXCAL_CFG1             (CH3_CHCLK_RXCAL_CFG1               ),                                  
  .CH3_CHCLK_RXCAL_CFG2             (CH3_CHCLK_RXCAL_CFG2               ),                                  
  .CH3_CHCLK_RXPI_CFG               (CH3_CHCLK_RXPI_CFG                 ),                                  
  .CH3_CHCLK_TXCAL_CFG              (CH3_CHCLK_TXCAL_CFG                ),                                  
  .CH3_CHCLK_TXPI_CFG0              (CH3_CHCLK_TXPI_CFG0                ),                                  
  .CH3_CHL_RSV_CFG0                 (CH3_CHL_RSV_CFG0                   ),                                  
  .CH3_CHL_RSV_CFG1                 (CH3_CHL_RSV_CFG1                   ),                                  
  .CH3_CHL_RSV_CFG2                 (CH3_CHL_RSV_CFG2                   ),                                  
  .CH3_CHL_RSV_CFG3                 (CH3_CHL_RSV_CFG3                   ),                                  
  .CH3_CHL_RSV_CFG4                 (CH3_CHL_RSV_CFG4                   ),                                  
  .CH3_DA_CFG                       (CH3_DA_CFG                         ),
  .CH3_EYESCAN_CFG0                 (CH3_EYESCAN_CFG0                   ),                                  
  .CH3_EYESCAN_CFG1                 (CH3_EYESCAN_CFG1                   ),                                  
  .CH3_EYESCAN_CFG10                (CH3_EYESCAN_CFG10                  ),                                  
  .CH3_EYESCAN_CFG11                (CH3_EYESCAN_CFG11                  ),                                  
  .CH3_EYESCAN_CFG12                (CH3_EYESCAN_CFG12                  ),                                  
  .CH3_EYESCAN_CFG13                (CH3_EYESCAN_CFG13                  ),                                  
  .CH3_EYESCAN_CFG14                (CH3_EYESCAN_CFG14                  ),                                  
  .CH3_EYESCAN_CFG15                (CH3_EYESCAN_CFG15                  ),                                  
  .CH3_EYESCAN_CFG16                (CH3_EYESCAN_CFG16                  ),                                  
  .CH3_EYESCAN_CFG2                 (CH3_EYESCAN_CFG2                   ),                                  
  .CH3_EYESCAN_CFG3                 (CH3_EYESCAN_CFG3                   ),                                  
  .CH3_EYESCAN_CFG4                 (CH3_EYESCAN_CFG4                   ),                                  
  .CH3_EYESCAN_CFG5                 (CH3_EYESCAN_CFG5                   ),                                  
  .CH3_EYESCAN_CFG6                 (CH3_EYESCAN_CFG6                   ),                                  
  .CH3_EYESCAN_CFG7                 (CH3_EYESCAN_CFG7                   ),                                  
  .CH3_EYESCAN_CFG8                 (CH3_EYESCAN_CFG8                   ),                                  
  .CH3_EYESCAN_CFG9                 (CH3_EYESCAN_CFG9                   ),                                  
  //.CH3_FABRIC_INTF_CFG0             ('d4278190079               ),                                  
  .CH3_FABRIC_INTF_CFG0             (CH3_FABRIC_INTF_CFG0               ),                                  
  .CH3_FABRIC_INTF_CFG1             (CH3_FABRIC_INTF_CFG1               ),                                  
  .CH3_FABRIC_INTF_CFG2             (CH3_FABRIC_INTF_CFG2               ),                                  
  .CH3_FABRIC_INTF_CFG3             (CH3_FABRIC_INTF_CFG3               ),                                  
  .CH3_FABRIC_INTF_CFG4             (CH3_FABRIC_INTF_CFG4               ),                                  
  .CH3_FABRIC_INTF_CFG5             (CH3_FABRIC_INTF_CFG5               ),                                  
  .CH3_INSTANTIATED                 (CH3_INSTANTIATED                   ),                                  
  .CH3_MONITOR_CFG                  (CH3_MONITOR_CFG                    ),
  .CH3_PIPE_CTRL_CFG0               (CH3_PIPE_CTRL_CFG0                 ),                                  
  .CH3_PIPE_CTRL_CFG1               (CH3_PIPE_CTRL_CFG1                 ),                                  
  .CH3_PIPE_CTRL_CFG10              (CH3_PIPE_CTRL_CFG10                ),                                  
  .CH3_PIPE_CTRL_CFG2               (CH3_PIPE_CTRL_CFG2                 ),                                  
  .CH3_PIPE_CTRL_CFG3               (CH3_PIPE_CTRL_CFG3                 ),                                  
  .CH3_PIPE_CTRL_CFG4               (CH3_PIPE_CTRL_CFG4                 ),                                  
  .CH3_PIPE_CTRL_CFG5               (CH3_PIPE_CTRL_CFG5                 ),                                  
  .CH3_PIPE_CTRL_CFG6               (CH3_PIPE_CTRL_CFG6                 ),                                  
  .CH3_PIPE_CTRL_CFG7               (CH3_PIPE_CTRL_CFG7                 ),                                  
  .CH3_PIPE_CTRL_CFG8               (CH3_PIPE_CTRL_CFG8                 ),                                  
  .CH3_PIPE_CTRL_CFG9               (CH3_PIPE_CTRL_CFG9                 ),                                  
  .CH3_PIPE_TX_EQ_CFG0              (CH3_PIPE_TX_EQ_CFG0                ),                                  
  .CH3_PIPE_TX_EQ_CFG1              (CH3_PIPE_TX_EQ_CFG1                ),                                  
  .CH3_PIPE_TX_EQ_CFG2              (CH3_PIPE_TX_EQ_CFG2                ),                                  
  .CH3_PIPE_TX_EQ_CFG3              (CH3_PIPE_TX_EQ_CFG3                ),                                  
  .CH3_RESET_BYP_HDSHK_CFG          (CH3_RESET_BYP_HDSHK_CFG            ),                                  
  .CH3_RESET_CFG                    (CH3_RESET_CFG                      ),                                  
  .CH3_RESET_LOOPER_ID_CFG          (CH3_RESET_LOOPER_ID_CFG            ),                                  
  .CH3_RESET_LOOP_ID_CFG0           (CH3_RESET_LOOP_ID_CFG0             ),                                  
  .CH3_RESET_LOOP_ID_CFG1           (CH3_RESET_LOOP_ID_CFG1             ),                                  
  .CH3_RESET_LOOP_ID_CFG2           (CH3_RESET_LOOP_ID_CFG2             ),                                  
  .CH3_RESET_TIME_CFG0              (CH3_RESET_TIME_CFG0                ),                                  
  .CH3_RESET_TIME_CFG1              (CH3_RESET_TIME_CFG1                ),                                  
  .CH3_RESET_TIME_CFG2              (CH3_RESET_TIME_CFG2                ),                                  
  .CH3_RESET_TIME_CFG3              (CH3_RESET_TIME_CFG3                ),                                  
  .CH3_RXOUTCLK_FREQ                (CH3_RXOUTCLK_FREQ                  ),
  .CH3_RXOUTCLK_REF_FREQ            (CH3_RXOUTCLK_REF_FREQ              ),
  .CH3_RXOUTCLK_REF_SOURCE          (CH3_RXOUTCLK_REF_SOURCE            ),                         
  .CH3_RX_CDR_CFG0                  (CH3_RX_CDR_CFG0                    ),                                  
  .CH3_RX_CDR_CFG1                  (CH3_RX_CDR_CFG1                    ),                                  
  .CH3_RX_CDR_CFG2                  (CH3_RX_CDR_CFG2                    ),                                  
  .CH3_RX_CDR_CFG3                  (CH3_RX_CDR_CFG3                    ),                                  
  .CH3_RX_CDR_CFG4                  (CH3_RX_CDR_CFG4                    ),                                  
  .CH3_RX_CRC_CFG0                  (CH3_RX_CRC_CFG0                    ),                                  
  .CH3_RX_CRC_CFG1                  (CH3_RX_CRC_CFG1                    ),                                  
  .CH3_RX_CRC_CFG2                  (CH3_RX_CRC_CFG2                    ),                                  
  .CH3_RX_CRC_CFG3                  (CH3_RX_CRC_CFG3                    ),                                  
  .CH3_RX_CTLE_CFG0                 (CH3_RX_CTLE_CFG0                   ),                                  
  .CH3_RX_CTLE_CFG1                 (CH3_RX_CTLE_CFG1                   ),                                  
  .CH3_RX_DACI2V_CFG0               (CH3_RX_DACI2V_CFG0                 ),                                  
  .CH3_RX_DFE_CFG0                  (CH3_RX_DFE_CFG0                    ),                                  
  .CH3_RX_ELASTIC_BUF_CFG0          (CH3_RX_ELASTIC_BUF_CFG0            ),                                  
  .CH3_RX_ELASTIC_BUF_CFG1          (CH3_RX_ELASTIC_BUF_CFG1            ),                                  
  .CH3_RX_ELASTIC_BUF_CFG2          (CH3_RX_ELASTIC_BUF_CFG2            ),                                  
  .CH3_RX_ELASTIC_BUF_CFG3          (CH3_RX_ELASTIC_BUF_CFG3            ),                                  
  .CH3_RX_ELASTIC_BUF_CFG4          (CH3_RX_ELASTIC_BUF_CFG4            ),                                  
  .CH3_RX_ELASTIC_BUF_CFG5          (CH3_RX_ELASTIC_BUF_CFG5            ),                                  
  .CH3_RX_ELASTIC_BUF_CFG6          (CH3_RX_ELASTIC_BUF_CFG6            ),                                  
  .CH3_RX_ELASTIC_BUF_CFG7          (CH3_RX_ELASTIC_BUF_CFG7            ),                                  
  .CH3_RX_ELASTIC_BUF_CFG8          (CH3_RX_ELASTIC_BUF_CFG8            ),                                  
  .CH3_RX_ELASTIC_BUF_CFG9          (CH3_RX_ELASTIC_BUF_CFG9            ),                                  
  .CH3_RX_MISC_CFG0                 (CH3_RX_MISC_CFG0                   ),                                  
  .CH3_RX_OOB_CFG0                  (CH3_RX_OOB_CFG0                    ),                                  
  .CH3_RX_OOB_CFG1                  (CH3_RX_OOB_CFG1                    ),                                  
  .CH3_RX_PAD_CFG0                  (CH3_RX_PAD_CFG0                    ),                                  
  .CH3_RX_PAD_CFG1                  (CH3_RX_PAD_CFG1                    ),                                  
  .CH3_RX_PCS_CFG0                  (CH3_RX_PCS_CFG0                    ),                                  
  .CH3_RX_PCS_CFG1                  (CH3_RX_PCS_CFG1                    ),                                  
  .CH3_RX_PCS_CFG2                  (CH3_RX_PCS_CFG2                    ),                                  
  .CH3_RX_PCS_CFG3                  (CH3_RX_PCS_CFG3                    ),                                  
  .CH3_RX_PCS_CFG4                  (CH3_RX_PCS_CFG4                    ),                                  
  .CH3_RX_PHALIGN_CFG0              (CH3_RX_PHALIGN_CFG0                ),                                  
  .CH3_RX_PHALIGN_CFG1              (CH3_RX_PHALIGN_CFG1                ),                                  
  .CH3_RX_PHALIGN_CFG2              (CH3_RX_PHALIGN_CFG2                ),                                  
  .CH3_RX_PHALIGN_CFG3              (CH3_RX_PHALIGN_CFG3                ),                                  
  .CH3_RX_PHALIGN_CFG4              (CH3_RX_PHALIGN_CFG4                ),                                  
  .CH3_RX_PHALIGN_CFG5              (CH3_RX_PHALIGN_CFG5                ),                                  
  .CH3_SIM_MODE                     (CH3_SIM_MODE                       ),                                  
  .CH3_SIM_RECEIVER_DETECT_PASS     (CH3_SIM_RECEIVER_DETECT_PASS       ),                                  
  .CH3_SIM_RESET_SPEEDUP            (CH3_SIM_RESET_SPEEDUP              ),                                  
  .CH3_SIM_TX_EIDLE_DRIVE_LEVEL     (CH3_SIM_TX_EIDLE_DRIVE_LEVEL       ),                                  
  .CH3_TXOUTCLK_FREQ                (CH3_TXOUTCLK_FREQ                  ),
  .CH3_TXOUTCLK_REF_FREQ            (CH3_TXOUTCLK_REF_FREQ              ),
  .CH3_TXOUTCLK_REF_SOURCE          (CH3_TXOUTCLK_REF_SOURCE            ),
  .CH3_TX_10G_CFG0                  (CH3_TX_10G_CFG0                    ),                                  
  .CH3_TX_10G_CFG1                  (CH3_TX_10G_CFG1                    ),                                  
  .CH3_TX_10G_CFG2                  (CH3_TX_10G_CFG2                    ),                                  
  .CH3_TX_10G_CFG3                  (CH3_TX_10G_CFG3                    ),                                  
  .CH3_TX_ANA_CFG0                  (CH3_TX_ANA_CFG0                    ),                                  
  .CH3_TX_CRC_CFG0                  (CH3_TX_CRC_CFG0                    ),                                  
  .CH3_TX_CRC_CFG1                  (CH3_TX_CRC_CFG1                    ),                                  
  .CH3_TX_CRC_CFG2                  (CH3_TX_CRC_CFG2                    ),                                  
  .CH3_TX_CRC_CFG3                  (CH3_TX_CRC_CFG3                    ),                                  
  .CH3_TX_DRV_CFG0                  (CH3_TX_DRV_CFG0                    ),                                  
  .CH3_TX_DRV_CFG1                  (CH3_TX_DRV_CFG1                    ),                                  
  .CH3_TX_PCS_CFG0                  (CH3_TX_PCS_CFG0                    ),                                  
  .CH3_TX_PCS_CFG1                  (CH3_TX_PCS_CFG1                    ),                                  
  .CH3_TX_PCS_CFG2                  (CH3_TX_PCS_CFG2                    ),                                  
  .CH3_TX_PCS_CFG3                  (CH3_TX_PCS_CFG3                    ),                                  
  .CH3_TX_PHALIGN_CFG0              (CH3_TX_PHALIGN_CFG0                ),                                  
  .CH3_TX_PHALIGN_CFG1              (CH3_TX_PHALIGN_CFG1                ),                                  
  .CH3_TX_PHALIGN_CFG2              (CH3_TX_PHALIGN_CFG2                ),                                  
  .CH3_TX_PHALIGN_CFG3              (CH3_TX_PHALIGN_CFG3                ),                                  
  .CH3_TX_PHALIGN_CFG4              (CH3_TX_PHALIGN_CFG4                ),                                  
  .CH3_TX_PHALIGN_CFG5              (CH3_TX_PHALIGN_CFG5                ),                                  
  .CH3_TX_PIPPM_CFG                 (CH3_TX_PIPPM_CFG                   ),                                  
  .CH3_TX_SER_CFG0                  (CH3_TX_SER_CFG0                    ),                                  
  .RCALBG0_CFG0                     (RCALBG0_CFG0                       ),                                  
  .RCALBG0_CFG1                     (RCALBG0_CFG1                       ),                                  
  .RCALBG0_CFG2                     (RCALBG0_CFG2                       ),                                  
  .RCALBG0_CFG3                     (RCALBG0_CFG3                       ),                                  
  .RCALBG0_CFG4                     (RCALBG0_CFG4                       ),                                  
  .RCALBG0_CFG5                     (RCALBG0_CFG5                       ),                                  
  .RCALBG1_CFG0                     (RCALBG1_CFG0                       ),                                  
  .RCALBG1_CFG1                     (RCALBG1_CFG1                       ),                                  
  .RCALBG1_CFG2                     (RCALBG1_CFG2                       ),                                  
  .RCALBG1_CFG3                     (RCALBG1_CFG3                       ),                                  
  .RCALBG1_CFG4                     (RCALBG1_CFG4                       ),                                  
  .RCALBG1_CFG5                     (RCALBG1_CFG5                       ),                                  
  .CTRL_RSV_CFG0                    (CTRL_RSV_CFG0                      ),                                  
  .CTRL_RSV_CFG1                    (CTRL_RSV_CFG1                      ),                                  
  .HS0_LCPLL_IPS_PIN_EN             (HS0_LCPLL_IPS_PIN_EN               ),                                  
  .HS0_LCPLL_IPS_REFCLK_SEL         (HS0_LCPLL_IPS_REFCLK_SEL           ),                                  
  .HS0_LCPLL_REFCLK_MAP0            (HS0_LCPLL_REFCLK_MAP0              ),                                  
  .HS0_LCPLL_REFCLK_MAP1            (HS0_LCPLL_REFCLK_MAP1              ),                                  
  .HS0_LCPLL_REFCLK_MAP2            (HS0_LCPLL_REFCLK_MAP2              ),                                  
  .HS0_LCPLL_REFCLK_MAP3            (HS0_LCPLL_REFCLK_MAP3              ),                                  
  .HS0_LCPLL_REFCLK_MAP4            (HS0_LCPLL_REFCLK_MAP4              ),                                  
  .HS0_LCPLL_REFCLK_MAP5            (HS0_LCPLL_REFCLK_MAP5              ),                                  
  .HS0_LCPLL_REFCLK_MAP6            (HS0_LCPLL_REFCLK_MAP6              ),                                  
  .HS0_LCPLL_REFCLK_MAP7            (HS0_LCPLL_REFCLK_MAP7              ),                                  
  .HS0_RPLL_IPS_PIN_EN              (HS0_RPLL_IPS_PIN_EN                ),                                  
  .HS0_RPLL_IPS_REFCLK_SEL          (HS0_RPLL_IPS_REFCLK_SEL            ),                                  
  .HS0_RPLL_REFCLK_MAP0             (HS0_RPLL_REFCLK_MAP0               ),                                  
  .HS0_RPLL_REFCLK_MAP1             (HS0_RPLL_REFCLK_MAP1               ),                                  
  .HS0_RPLL_REFCLK_MAP2             (HS0_RPLL_REFCLK_MAP2               ),                                  
  .HS0_RPLL_REFCLK_MAP3             (HS0_RPLL_REFCLK_MAP3               ),                                  
  .HS0_RPLL_REFCLK_MAP4             (HS0_RPLL_REFCLK_MAP4               ),                                  
  .HS0_RPLL_REFCLK_MAP5             (HS0_RPLL_REFCLK_MAP5               ),                                  
  .HS0_RPLL_REFCLK_MAP6             (HS0_RPLL_REFCLK_MAP6               ),                                  
  .HS0_RPLL_REFCLK_MAP7             (HS0_RPLL_REFCLK_MAP7               ),                                  
  .HS1_LCPLL_IPS_PIN_EN             (HS1_LCPLL_IPS_PIN_EN               ),                                  
  .HS1_LCPLL_IPS_REFCLK_SEL         (HS1_LCPLL_IPS_REFCLK_SEL           ),                                  
  .HS1_LCPLL_REFCLK_MAP0            (HS1_LCPLL_REFCLK_MAP0              ),                                  
  .HS1_LCPLL_REFCLK_MAP1            (HS1_LCPLL_REFCLK_MAP1              ),                                  
  .HS1_LCPLL_REFCLK_MAP2            (HS1_LCPLL_REFCLK_MAP2              ),                                  
  .HS1_LCPLL_REFCLK_MAP3            (HS1_LCPLL_REFCLK_MAP3              ),                                  
  .HS1_LCPLL_REFCLK_MAP4            (HS1_LCPLL_REFCLK_MAP4              ),                                  
  .HS1_LCPLL_REFCLK_MAP5            (HS1_LCPLL_REFCLK_MAP5              ),                                  
  .HS1_LCPLL_REFCLK_MAP6            (HS1_LCPLL_REFCLK_MAP6              ),                                  
  .HS1_LCPLL_REFCLK_MAP7            (HS1_LCPLL_REFCLK_MAP7              ),                                  
  .HS1_RPLL_IPS_PIN_EN              (HS1_RPLL_IPS_PIN_EN                ),                                  
  .HS1_RPLL_IPS_REFCLK_SEL          (HS1_RPLL_IPS_REFCLK_SEL            ),                                  
  .HS1_RPLL_REFCLK_MAP0             (HS1_RPLL_REFCLK_MAP0               ),                                  
  .HS1_RPLL_REFCLK_MAP1             (HS1_RPLL_REFCLK_MAP1               ),                                  
  .HS1_RPLL_REFCLK_MAP2             (HS1_RPLL_REFCLK_MAP2               ),                                  
  .HS1_RPLL_REFCLK_MAP3             (HS1_RPLL_REFCLK_MAP3               ),                                  
  .HS1_RPLL_REFCLK_MAP4             (HS1_RPLL_REFCLK_MAP4               ),                                  
  .HS1_RPLL_REFCLK_MAP5             (HS1_RPLL_REFCLK_MAP5               ),                                  
  .HS1_RPLL_REFCLK_MAP6             (HS1_RPLL_REFCLK_MAP6               ),                                  
  .HS1_RPLL_REFCLK_MAP7             (HS1_RPLL_REFCLK_MAP7               ),                                  
  .HSCLK0_HSDIST_CFG                (HSCLK0_HSDIST_CFG                  ),                                  
  .HSCLK0_LCPLL_CFG0                (HSCLK0_LCPLL_CFG0                  ),                                  
  .HSCLK0_LCPLL_CFG1                (HSCLK0_LCPLL_CFG1                  ),                                  
  //.HSCLK0_LCPLL_CFG2                ('d36873                  ),                                  
  .HSCLK0_LCPLL_CFG2                (HSCLK0_LCPLL_CFG2                  ),                                  
  .HSCLK0_LCPLL_LGC_CFG0            (HSCLK0_LCPLL_LGC_CFG0              ),                                  
  .HSCLK0_LCPLL_LGC_CFG1            (HSCLK0_LCPLL_LGC_CFG1              ),                                  
  .HSCLK0_LCPLL_LGC_CFG2            (HSCLK0_LCPLL_LGC_CFG2              ),                                  
  .HSCLK0_RPLL_CFG0                 (HSCLK0_RPLL_CFG0                   ),                                  
  .HSCLK0_RPLL_CFG1                 (HSCLK0_RPLL_CFG1                   ),                                  
  .HSCLK0_RPLL_CFG2                 (HSCLK0_RPLL_CFG2                   ),                                  
  .HSCLK0_RPLL_LGC_CFG0             (HSCLK0_RPLL_LGC_CFG0               ),                                  
  .HSCLK0_RPLL_LGC_CFG1             (HSCLK0_RPLL_LGC_CFG1               ),                                  
  .HSCLK0_RPLL_LGC_CFG2             (HSCLK0_RPLL_LGC_CFG2               ),                                  
  .HSCLK1_HSDIST_CFG                (HSCLK1_HSDIST_CFG                  ),                                  
  .HSCLK1_LCPLL_CFG0                (HSCLK1_LCPLL_CFG0                  ),                                  
  .HSCLK1_LCPLL_CFG1                (HSCLK1_LCPLL_CFG1                  ),                                  
  //.HSCLK1_LCPLL_CFG2                ('d36873                  ),                                  
  .HSCLK1_LCPLL_CFG2                (HSCLK1_LCPLL_CFG2                  ),                                  
  .HSCLK1_LCPLL_LGC_CFG0            (HSCLK1_LCPLL_LGC_CFG0              ),                                  
  .HSCLK1_LCPLL_LGC_CFG1            (HSCLK1_LCPLL_LGC_CFG1              ),                                  
  .HSCLK1_LCPLL_LGC_CFG2            (HSCLK1_LCPLL_LGC_CFG2              ),                                  
  .HSCLK1_RPLL_CFG0                 (HSCLK1_RPLL_CFG0                   ),                                  
  .HSCLK1_RPLL_CFG1                 (HSCLK1_RPLL_CFG1                   ),                                  
  .HSCLK1_RPLL_CFG2                 (HSCLK1_RPLL_CFG2                   ),                                  
  .HSCLK1_RPLL_LGC_CFG0             (HSCLK1_RPLL_LGC_CFG0               ),                                  
  .HSCLK1_RPLL_LGC_CFG1             (HSCLK1_RPLL_LGC_CFG1               ),                                  
  .HSCLK1_RPLL_LGC_CFG2             (HSCLK1_RPLL_LGC_CFG2               ),                                  
  .MEMORY_INIT_FILE                 (MEMORY_INIT_FILE                   ),                                  
  .MST_RESET_CFG                    (MST_RESET_CFG                      ),                                  
  //.PIN_CFG0                         ('d117981696                           ),                                  
  .PIN_CFG0                         (PIN_CFG0                           ),                                  
  .POR_CFG                          (POR_CFG                            ),                                  
  .QUAD_INSTANTIATED                (QUAD_INSTANTIATED                  ),                                  
  .QUAD_SIM_MODE                    (QUAD_SIM_MODE                      ),                                  
  .QUAD_SIM_RESET_SPEEDUP           (QUAD_SIM_RESET_SPEEDUP             ),                                  
  .RXRSTDONE_DIST_SEL               (RXRSTDONE_DIST_SEL                 ), 
  .STAT_NPI_REG_LIST                (STAT_NPI_REG_LIST                  ),                                 
//.SIM_DEVICE                       (SIM_DEVICE                         ),                                  
  .SIM_VERSION                      (SIM_VERSION                        ),
  .TERMPROG_CFG                     (TERMPROG_CFG                       ),                                  
  .TXRSTDONE_DIST_SEL               (TXRSTDONE_DIST_SEL                 ),                                  
  .UB_CFG0                          (UB_CFG0                            )                                  
) quad_inst (

.APB3PRDATA (apb3prdata_quad_int),
.APB3PREADY (apb3pready_quad_int),
.APB3PSLVERR(apb3pslverr_quad_int),
.CH0_BUFGTCE(ch0_bufgtce),
.CH0_BUFGTCEMASK(ch0_bufgtcemask),
.CH0_BUFGTDIV(ch0_bufgtdiv),
.CH0_BUFGTRST(ch0_bufgtrst),
.CH0_BUFGTRSTMASK(ch0_bufgtrstmask),
.CH0_CFOKOVRDRDY0(ch0_cfokovrdrdy0),
.CH0_CFOKOVRDRDY1(ch0_cfokovrdrdy1),
.CH0_DMONITOROUT(ch0_dmonitorout),
.CH0_DMONITOROUTCLK(ch0_dmonitoroutclk),
.CH0_EYESCANDATAERROR(ch0_eyescandataerror),
.CH0_GTYTXN(ch0_gtytxn),
.CH0_GTYTXP(ch0_gtytxp),
.CH0_ILORESETDONE(ch0_iloresetdone),
.CH0_PCSRSVDOUT(ch0_pcsrsvdout_int),
.CH0_PHYREADY(ch0_phyready),
.CH0_PHYSTATUS(ch0_phystatus),
.CH0_PINRSVDAS(ch0_pinrsvdas),
.CH0_RESETEXCEPTION(ch0_resetexception),
.CH0_RX10GSTAT(ch0_rx10gstat),
.CH0_RXBUFSTATUS(ch0_rxbufstatus),
.CH0_RXBYTEISALIGNED(ch0_rxbyteisaligned),
.CH0_RXBYTEREALIGN(ch0_rxbyterealign),
.CH0_RXCDRLOCK(ch0_rxcdrlock),
.CH0_RXCDRPHDONE(ch0_rxcdrphdone),
.CH0_RXCHANBONDSEQ(ch0_rxchanbondseq),
.CH0_RXCHANISALIGNED(ch0_rxchanisaligned),
.CH0_RXCHANREALIGN(ch0_rxchanrealign),
.CH0_RXCHBONDO(ch0_rxchbondo),
.CH0_RXCLKCORCNT(ch0_rxclkcorcnt),
.CH0_RXCOMINITDET(ch0_rxcominitdet),
.CH0_RXCOMMADET(ch0_rxcommadet),
.CH0_RXCOMSASDET(ch0_rxcomsasdet),
.CH0_RXCOMWAKEDET(ch0_rxcomwakedet),
.CH0_RXCTRL0(ch0_rxctrl0),
.CH0_RXCTRL1(ch0_rxctrl1),
.CH0_RXCTRL2(ch0_rxctrl2),
.CH0_RXCTRL3(ch0_rxctrl3),
.CH0_RXDATA(ch0_rxdata_ANLT),
.CH0_RXDATAEXTENDRSVD(ch0_rxdataextendrsvd),
.CH0_RXDATAVALID(ch0_rxdatavalid),
.CH0_RXDCCDONE(ch0_rxdccdone),
.CH0_RXDLYALIGNERR(ch0_rxdlyalignerr),
.CH0_RXDLYALIGNPROG(ch0_rxdlyalignprog),
.CH0_RXELECIDLE(ch0_rxelecidle),
.CH0_RXFINEALIGNDONE(ch0_rxfinealigndone),
.CH0_RXHEADER(ch0_rxheader),
.CH0_RXHEADERVALID(ch0_rxheadervalid),
.CH0_RXOSINTDONE(ch0_rxosintdone),
.CH0_RXOSINTSTARTED(ch0_rxosintstarted),
.CH0_RXOSINTSTROBEDONE(ch0_rxosintstrobedone),
.CH0_RXOSINTSTROBESTARTED(ch0_rxosintstrobestarted),
.CH0_RXOUTCLK(ch0_rxoutclk),
.CH0_RXPHALIGNDONE(ch0_rxphaligndone),
.CH0_RXPHALIGNERR(ch0_rxphalignerr),
.CH0_RXPHDLYRESETDONE(ch0_rxphdlyresetdone),
.CH0_RXPHSETINITDONE(ch0_rxphsetinitdone),
.CH0_RXPHSHIFT180DONE(ch0_rxphshift180done),
.CH0_RXPMARESETDONE(ch0_rxpmaresetdone_int),
.CH0_RXPRBSERR(ch0_rxprbserr),
.CH0_RXPRBSLOCKED(ch0_rxprbslocked),
.CH0_RXPROGDIVRESETDONE(ch0_rxprogdivresetdone),
.CH0_RXRESETDONE(ch0_rxresetdone_int),
.CH0_RXSLIDERDY(ch0_rxsliderdy),
.CH0_RXSTARTOFSEQ(ch0_rxstartofseq),
.CH0_RXSTATUS(ch0_rxstatus),
.CH0_RXSYNCDONE(ch0_rxsyncdone),
.CH0_RXVALID(ch0_rxvalid),
.CH0_TX10GSTAT(ch0_tx10gstat),
.CH0_TXBUFSTATUS(ch0_txbufstatus),
.CH0_TXCOMFINISH(ch0_txcomfinish),
.CH0_TXDCCDONE(ch0_txdccdone),
.CH0_TXDLYALIGNERR(ch0_txdlyalignerr),
.CH0_TXDLYALIGNPROG(ch0_txdlyalignprog),
.CH0_TXOUTCLK(ch0_txoutclk),
.CH0_TXPHALIGNDONE(ch0_txphaligndone),
.CH0_TXPHALIGNERR(ch0_txphalignerr),
.CH0_TXPHALIGNOUTRSVD(ch0_txphalignoutrsvd),
.CH0_TXPHDLYRESETDONE(ch0_txphdlyresetdone),
.CH0_TXPHSETINITDONE(ch0_txphsetinitdone),
.CH0_TXPHSHIFT180DONE(ch0_txphshift180done),
.CH0_TXPMARESETDONE(ch0_txpmaresetdone_int),
.CH0_TXPROGDIVRESETDONE(ch0_txprogdivresetdone),
.CH0_TXRESETDONE(ch0_txresetdone_int),
.CH0_TXSYNCDONE(ch0_txsyncdone),
.CH1_BUFGTCE(ch1_bufgtce),
.CH1_BUFGTCEMASK(ch1_bufgtcemask),
.CH1_BUFGTDIV(ch1_bufgtdiv),
.CH1_BUFGTRST(ch1_bufgtrst),
.CH1_BUFGTRSTMASK(ch1_bufgtrstmask),
.CH1_CFOKOVRDRDY0(ch1_cfokovrdrdy0),
.CH1_CFOKOVRDRDY1(ch1_cfokovrdrdy1),
.CH1_DMONITOROUT(ch1_dmonitorout),
.CH1_DMONITOROUTCLK(ch1_dmonitoroutclk),
.CH1_EYESCANDATAERROR(ch1_eyescandataerror),
.CH1_GTYTXN(ch1_gtytxn),
.CH1_GTYTXP(ch1_gtytxp),
.CH1_ILORESETDONE(ch1_iloresetdone),
.CH1_PCSRSVDOUT(ch1_pcsrsvdout_int),
.CH1_PHYREADY(ch1_phyready),
.CH1_PHYSTATUS(ch1_phystatus),
.CH1_PINRSVDAS(ch1_pinrsvdas),
.CH1_RESETEXCEPTION(ch1_resetexception),
.CH1_RX10GSTAT(ch1_rx10gstat),
.CH1_RXBUFSTATUS(ch1_rxbufstatus),
.CH1_RXBYTEISALIGNED(ch1_rxbyteisaligned),
.CH1_RXBYTEREALIGN(ch1_rxbyterealign),
.CH1_RXCDRLOCK(ch1_rxcdrlock),
.CH1_RXCDRPHDONE(ch1_rxcdrphdone),
.CH1_RXCHANBONDSEQ(ch1_rxchanbondseq),
.CH1_RXCHANISALIGNED(ch1_rxchanisaligned),
.CH1_RXCHANREALIGN(ch1_rxchanrealign),
.CH1_RXCHBONDO(ch1_rxchbondo),
.CH1_RXCLKCORCNT(ch1_rxclkcorcnt),
.CH1_RXCOMINITDET(ch1_rxcominitdet),
.CH1_RXCOMMADET(ch1_rxcommadet),
.CH1_RXCOMSASDET(ch1_rxcomsasdet),
.CH1_RXCOMWAKEDET(ch1_rxcomwakedet),
.CH1_RXCTRL0(ch1_rxctrl0),
.CH1_RXCTRL1(ch1_rxctrl1),
.CH1_RXCTRL2(ch1_rxctrl2),
.CH1_RXCTRL3(ch1_rxctrl3),
.CH1_RXDATA(ch1_rxdata_ANLT),
.CH1_RXDATAEXTENDRSVD(ch1_rxdataextendrsvd),
.CH1_RXDATAVALID(ch1_rxdatavalid),
.CH1_RXDCCDONE(ch1_rxdccdone),
.CH1_RXDLYALIGNERR(ch1_rxdlyalignerr),
.CH1_RXDLYALIGNPROG(ch1_rxdlyalignprog),
.CH1_RXELECIDLE(ch1_rxelecidle),
.CH1_RXFINEALIGNDONE(ch1_rxfinealigndone),
.CH1_RXHEADER(ch1_rxheader),
.CH1_RXHEADERVALID(ch1_rxheadervalid),
.CH1_RXOSINTDONE(ch1_rxosintdone),
.CH1_RXOSINTSTARTED(ch1_rxosintstarted),
.CH1_RXOSINTSTROBEDONE(ch1_rxosintstrobedone),
.CH1_RXOSINTSTROBESTARTED(ch1_rxosintstrobestarted),
.CH1_RXOUTCLK(ch1_rxoutclk),
.CH1_RXPHALIGNDONE(ch1_rxphaligndone),
.CH1_RXPHALIGNERR(ch1_rxphalignerr),
.CH1_RXPHDLYRESETDONE(ch1_rxphdlyresetdone),
.CH1_RXPHSETINITDONE(ch1_rxphsetinitdone),
.CH1_RXPHSHIFT180DONE(ch1_rxphshift180done),
.CH1_RXPMARESETDONE(ch1_rxpmaresetdone_int),
.CH1_RXPRBSERR(ch1_rxprbserr),
.CH1_RXPRBSLOCKED(ch1_rxprbslocked),
.CH1_RXPROGDIVRESETDONE(ch1_rxprogdivresetdone),
.CH1_RXRESETDONE(ch1_rxresetdone_int),
.CH1_RXSLIDERDY(ch1_rxsliderdy),
.CH1_RXSTARTOFSEQ(ch1_rxstartofseq),
.CH1_RXSTATUS(ch1_rxstatus),
.CH1_RXSYNCDONE(ch1_rxsyncdone),
.CH1_RXVALID(ch1_rxvalid),
.CH1_TX10GSTAT(ch1_tx10gstat),
.CH1_TXBUFSTATUS(ch1_txbufstatus),
.CH1_TXCOMFINISH(ch1_txcomfinish),
.CH1_TXDCCDONE(ch1_txdccdone),
.CH1_TXDLYALIGNERR(ch1_txdlyalignerr),
.CH1_TXDLYALIGNPROG(ch1_txdlyalignprog),
.CH1_TXOUTCLK(ch1_txoutclk),
.CH1_TXPHALIGNDONE(ch1_txphaligndone),
.CH1_TXPHALIGNERR(ch1_txphalignerr),
.CH1_TXPHALIGNOUTRSVD(ch1_txphalignoutrsvd),
.CH1_TXPHDLYRESETDONE(ch1_txphdlyresetdone),
.CH1_TXPHSETINITDONE(ch1_txphsetinitdone),
.CH1_TXPHSHIFT180DONE(ch1_txphshift180done),
.CH1_TXPMARESETDONE(ch1_txpmaresetdone_int),
.CH1_TXPROGDIVRESETDONE(ch1_txprogdivresetdone),
.CH1_TXRESETDONE(ch1_txresetdone_int),
.CH1_TXSYNCDONE(ch1_txsyncdone),
.CH2_BUFGTCE(ch2_bufgtce),
.CH2_BUFGTCEMASK(ch2_bufgtcemask),
.CH2_BUFGTDIV(ch2_bufgtdiv),
.CH2_BUFGTRST(ch2_bufgtrst),
.CH2_BUFGTRSTMASK(ch2_bufgtrstmask),
.CH2_CFOKOVRDRDY0(ch2_cfokovrdrdy0),
.CH2_CFOKOVRDRDY1(ch2_cfokovrdrdy1),
.CH2_DMONITOROUT(ch2_dmonitorout),
.CH2_DMONITOROUTCLK(ch2_dmonitoroutclk),
.CH2_EYESCANDATAERROR(ch2_eyescandataerror),
.CH2_GTYTXN(ch2_gtytxn),
.CH2_GTYTXP(ch2_gtytxp),
.CH2_ILORESETDONE(ch2_iloresetdone),
.CH2_PCSRSVDOUT(ch2_pcsrsvdout_int),
.CH2_PHYREADY(ch2_phyready),
.CH2_PHYSTATUS(ch2_phystatus),
.CH2_PINRSVDAS(ch2_pinrsvdas),
.CH2_RESETEXCEPTION(ch2_resetexception),
.CH2_RX10GSTAT(ch2_rx10gstat),
.CH2_RXBUFSTATUS(ch2_rxbufstatus),
.CH2_RXBYTEISALIGNED(ch2_rxbyteisaligned),
.CH2_RXBYTEREALIGN(ch2_rxbyterealign),
.CH2_RXCDRLOCK(ch2_rxcdrlock),
.CH2_RXCDRPHDONE(ch2_rxcdrphdone),
.CH2_RXCHANBONDSEQ(ch2_rxchanbondseq),
.CH2_RXCHANISALIGNED(ch2_rxchanisaligned),
.CH2_RXCHANREALIGN(ch2_rxchanrealign),
.CH2_RXCHBONDO(ch2_rxchbondo),
.CH2_RXCLKCORCNT(ch2_rxclkcorcnt),
.CH2_RXCOMINITDET(ch2_rxcominitdet),
.CH2_RXCOMMADET(ch2_rxcommadet),
.CH2_RXCOMSASDET(ch2_rxcomsasdet),
.CH2_RXCOMWAKEDET(ch2_rxcomwakedet),
.CH2_RXCTRL0(ch2_rxctrl0),
.CH2_RXCTRL1(ch2_rxctrl1),
.CH2_RXCTRL2(ch2_rxctrl2),
.CH2_RXCTRL3(ch2_rxctrl3),
.CH2_RXDATA(ch2_rxdata_ANLT),
.CH2_RXDATAEXTENDRSVD(ch2_rxdataextendrsvd),
.CH2_RXDATAVALID(ch2_rxdatavalid),
.CH2_RXDCCDONE(ch2_rxdccdone),
.CH2_RXDLYALIGNERR(ch2_rxdlyalignerr),
.CH2_RXDLYALIGNPROG(ch2_rxdlyalignprog),
.CH2_RXELECIDLE(ch2_rxelecidle),
.CH2_RXFINEALIGNDONE(ch2_rxfinealigndone),
.CH2_RXHEADER(ch2_rxheader),
.CH2_RXHEADERVALID(ch2_rxheadervalid),
.CH2_RXOSINTDONE(ch2_rxosintdone),
.CH2_RXOSINTSTARTED(ch2_rxosintstarted),
.CH2_RXOSINTSTROBEDONE(ch2_rxosintstrobedone),
.CH2_RXOSINTSTROBESTARTED(ch2_rxosintstrobestarted),
.CH2_RXOUTCLK(ch2_rxoutclk),
.CH2_RXPHALIGNDONE(ch2_rxphaligndone),
.CH2_RXPHALIGNERR(ch2_rxphalignerr),
.CH2_RXPHDLYRESETDONE(ch2_rxphdlyresetdone),
.CH2_RXPHSETINITDONE(ch2_rxphsetinitdone),
.CH2_RXPHSHIFT180DONE(ch2_rxphshift180done),
.CH2_RXPMARESETDONE(ch2_rxpmaresetdone_int),
.CH2_RXPRBSERR(ch2_rxprbserr),
.CH2_RXPRBSLOCKED(ch2_rxprbslocked),
.CH2_RXPROGDIVRESETDONE(ch2_rxprogdivresetdone),
.CH2_RXRESETDONE(ch2_rxresetdone_int),
.CH2_RXSLIDERDY(ch2_rxsliderdy),
.CH2_RXSTARTOFSEQ(ch2_rxstartofseq),
.CH2_RXSTATUS(ch2_rxstatus),
.CH2_RXSYNCDONE(ch2_rxsyncdone),
.CH2_RXVALID(ch2_rxvalid),
.CH2_TX10GSTAT(ch2_tx10gstat),
.CH2_TXBUFSTATUS(ch2_txbufstatus),
.CH2_TXCOMFINISH(ch2_txcomfinish),
.CH2_TXDCCDONE(ch2_txdccdone),
.CH2_TXDLYALIGNERR(ch2_txdlyalignerr),
.CH2_TXDLYALIGNPROG(ch2_txdlyalignprog),
.CH2_TXOUTCLK(ch2_txoutclk),
.CH2_TXPHALIGNDONE(ch2_txphaligndone),
.CH2_TXPHALIGNERR(ch2_txphalignerr),
.CH2_TXPHALIGNOUTRSVD(ch2_txphalignoutrsvd),
.CH2_TXPHDLYRESETDONE(ch2_txphdlyresetdone),
.CH2_TXPHSETINITDONE(ch2_txphsetinitdone),
.CH2_TXPHSHIFT180DONE(ch2_txphshift180done),
.CH2_TXPMARESETDONE(ch2_txpmaresetdone_int),
.CH2_TXPROGDIVRESETDONE(ch2_txprogdivresetdone),
.CH2_TXRESETDONE(ch2_txresetdone_int),
.CH2_TXSYNCDONE(ch2_txsyncdone),
.CH3_BUFGTCE(ch3_bufgtce),
.CH3_BUFGTCEMASK(ch3_bufgtcemask),
.CH3_BUFGTDIV(ch3_bufgtdiv),
.CH3_BUFGTRST(ch3_bufgtrst),
.CH3_BUFGTRSTMASK(ch3_bufgtrstmask),
.CH3_CFOKOVRDRDY0(ch3_cfokovrdrdy0),
.CH3_CFOKOVRDRDY1(ch3_cfokovrdrdy1),
.CH3_DMONITOROUT(ch3_dmonitorout),
.CH3_DMONITOROUTCLK(ch3_dmonitoroutclk),
.CH3_EYESCANDATAERROR(ch3_eyescandataerror),
.CH3_GTYTXN(ch3_gtytxn),
.CH3_GTYTXP(ch3_gtytxp),
.CH3_ILORESETDONE(ch3_iloresetdone),
.CH3_PCSRSVDOUT(ch3_pcsrsvdout_int),
.CH3_PHYREADY(ch3_phyready),
.CH3_PHYSTATUS(ch3_phystatus),
.CH3_PINRSVDAS(ch3_pinrsvdas),
.CH3_RESETEXCEPTION(ch3_resetexception),
.CH3_RX10GSTAT(ch3_rx10gstat),
.CH3_RXBUFSTATUS(ch3_rxbufstatus),
.CH3_RXBYTEISALIGNED(ch3_rxbyteisaligned),
.CH3_RXBYTEREALIGN(ch3_rxbyterealign),
.CH3_RXCDRLOCK(ch3_rxcdrlock),
.CH3_RXCDRPHDONE(ch3_rxcdrphdone),
.CH3_RXCHANBONDSEQ(ch3_rxchanbondseq),
.CH3_RXCHANISALIGNED(ch3_rxchanisaligned),
.CH3_RXCHANREALIGN(ch3_rxchanrealign),
.CH3_RXCHBONDO(ch3_rxchbondo),
.CH3_RXCLKCORCNT(ch3_rxclkcorcnt),
.CH3_RXCOMINITDET(ch3_rxcominitdet),
.CH3_RXCOMMADET(ch3_rxcommadet),
.CH3_RXCOMSASDET(ch3_rxcomsasdet),
.CH3_RXCOMWAKEDET(ch3_rxcomwakedet),
.CH3_RXCTRL0(ch3_rxctrl0),
.CH3_RXCTRL1(ch3_rxctrl1),
.CH3_RXCTRL2(ch3_rxctrl2),
.CH3_RXCTRL3(ch3_rxctrl3),
.CH3_RXDATA(ch3_rxdata_ANLT),
.CH3_RXDATAEXTENDRSVD(ch3_rxdataextendrsvd),
.CH3_RXDATAVALID(ch3_rxdatavalid),
.CH3_RXDCCDONE(ch3_rxdccdone),
.CH3_RXDLYALIGNERR(ch3_rxdlyalignerr),
.CH3_RXDLYALIGNPROG(ch3_rxdlyalignprog),
.CH3_RXELECIDLE(ch3_rxelecidle),
.CH3_RXFINEALIGNDONE(ch3_rxfinealigndone),
.CH3_RXHEADER(ch3_rxheader),
.CH3_RXHEADERVALID(ch3_rxheadervalid),
.CH3_RXOSINTDONE(ch3_rxosintdone),
.CH3_RXOSINTSTARTED(ch3_rxosintstarted),
.CH3_RXOSINTSTROBEDONE(ch3_rxosintstrobedone),
.CH3_RXOSINTSTROBESTARTED(ch3_rxosintstrobestarted),
.CH3_RXOUTCLK(ch3_rxoutclk),
.CH3_RXPHALIGNDONE(ch3_rxphaligndone),
.CH3_RXPHALIGNERR(ch3_rxphalignerr),
.CH3_RXPHDLYRESETDONE(ch3_rxphdlyresetdone),
.CH3_RXPHSETINITDONE(ch3_rxphsetinitdone),
.CH3_RXPHSHIFT180DONE(ch3_rxphshift180done),
.CH3_RXPMARESETDONE(ch3_rxpmaresetdone_int),
.CH3_RXPRBSERR(ch3_rxprbserr),
.CH3_RXPRBSLOCKED(ch3_rxprbslocked),
.CH3_RXPROGDIVRESETDONE(ch3_rxprogdivresetdone),
.CH3_RXRESETDONE(ch3_rxresetdone_int),
.CH3_RXSLIDERDY(ch3_rxsliderdy),
.CH3_RXSTARTOFSEQ(ch3_rxstartofseq),
.CH3_RXSTATUS(ch3_rxstatus),
.CH3_RXSYNCDONE(ch3_rxsyncdone),
.CH3_RXVALID(ch3_rxvalid),
.CH3_TX10GSTAT(ch3_tx10gstat),
.CH3_TXBUFSTATUS(ch3_txbufstatus),
.CH3_TXCOMFINISH(ch3_txcomfinish),
.CH3_TXDCCDONE(ch3_txdccdone),
.CH3_TXDLYALIGNERR(ch3_txdlyalignerr),
.CH3_TXDLYALIGNPROG(ch3_txdlyalignprog),
.CH3_TXOUTCLK(ch3_txoutclk),
.CH3_TXPHALIGNDONE(ch3_txphaligndone),
.CH3_TXPHALIGNERR(ch3_txphalignerr),
.CH3_TXPHALIGNOUTRSVD(ch3_txphalignoutrsvd),
.CH3_TXPHDLYRESETDONE(ch3_txphdlyresetdone),
.CH3_TXPHSETINITDONE(ch3_txphsetinitdone),
.CH3_TXPHSHIFT180DONE(ch3_txphshift180done),
.CH3_TXPMARESETDONE(ch3_txpmaresetdone_int),
.CH3_TXPROGDIVRESETDONE(ch3_txprogdivresetdone),
.CH3_TXRESETDONE(ch3_txresetdone_int),
.CH3_TXSYNCDONE(ch3_txsyncdone),
.CORRECTERR(correcterr),
.CTRLRSVDOUT(ctrlrsvdout),
.DEBUGTRACETDATA(debugtracetdata),
.DEBUGTRACETVALID(debugtracetvalid),
.GPO(gpo),
.GTPOWERGOOD(gtpowergood_int),
.HSCLK0_LCPLLFBCLKLOST(hsclk0_lcpllfbclklost),
.HSCLK0_LCPLLLOCK(hsclk0_lcplllock),
.HSCLK0_LCPLLREFCLKLOST(hsclk0_lcpllrefclklost),
.HSCLK0_LCPLLREFCLKMONITOR(hsclk0_lcpllrefclkmonitor),
.HSCLK0_LCPLLRSVDOUT(hsclk0_lcpllrsvdout),
.HSCLK0_RPLLFBCLKLOST(hsclk0_rpllfbclklost),
.HSCLK0_RPLLLOCK(hsclk0_rplllock),
.HSCLK0_RPLLREFCLKLOST(hsclk0_rpllrefclklost),
.HSCLK0_RPLLREFCLKMONITOR(hsclk0_rpllrefclkmonitor),
.HSCLK0_RPLLRSVDOUT(hsclk0_rpllrsvdout),
.HSCLK0_RXRECCLKOUT0(hsclk0_rxrecclkout0),
.HSCLK0_RXRECCLKOUT1(hsclk0_rxrecclkout1),
.HSCLK0_RXRECCLKSEL(hsclk0_rxrecclksel),
.HSCLK1_LCPLLFBCLKLOST(hsclk1_lcpllfbclklost),
.HSCLK1_LCPLLLOCK(hsclk1_lcplllock),
.HSCLK1_LCPLLREFCLKLOST(hsclk1_lcpllrefclklost),
.HSCLK1_LCPLLREFCLKMONITOR(hsclk1_lcpllrefclkmonitor),
.HSCLK1_LCPLLRSVDOUT(hsclk1_lcpllrsvdout),
.HSCLK1_RPLLFBCLKLOST(hsclk1_rpllfbclklost),
.HSCLK1_RPLLLOCK(hsclk1_rplllock),
.HSCLK1_RPLLREFCLKLOST(hsclk1_rpllrefclklost),
.HSCLK1_RPLLREFCLKMONITOR(hsclk1_rpllrefclkmonitor),
.HSCLK1_RPLLRSVDOUT(hsclk1_rpllrsvdout),
.HSCLK1_RXRECCLKOUT0(hsclk1_rxrecclkout0),
.HSCLK1_RXRECCLKOUT1(hsclk1_rxrecclkout1),
.HSCLK1_RXRECCLKSEL(hsclk1_rxrecclksel),
.M0_AXIS_TDATA(m0_axis_tdata),
.M0_AXIS_TLAST(m0_axis_tlast),
.M0_AXIS_TVALID(m0_axis_tvalid),
.M1_AXIS_TDATA(m1_axis_tdata),
.M1_AXIS_TLAST(m1_axis_tlast),
.M1_AXIS_TVALID(m1_axis_tvalid),
.M2_AXIS_TDATA(m2_axis_tdata),
.M2_AXIS_TLAST(m2_axis_tlast),
.M2_AXIS_TVALID(m2_axis_tvalid),
.MSTRXRESETDONE(mstrxresetdone_int),
.MSTTXRESETDONE(msttxresetdone_int),
.PIPENORTHOUT(pipenorthout),
.PIPESOUTHOUT(pipesouthout),
.REFCLK0_CLKTESTSIGINT(refclk0_clktestsigint),
.REFCLK0_GTREFCLKPDINT(refclk0_gtrefclkpdint),
.REFCLK1_CLKTESTSIGINT(refclk1_clktestsigint),
.REFCLK1_GTREFCLKPDINT(refclk1_gtrefclkpdint),
.RESETDONE_NORTHOUT(resetdone_northout),
.RESETDONE_SOUTHOUT(resetdone_southout),
.RXMARGINREQACK(rxmarginreqack),
.RXMARGINRESCMD(rxmarginrescmd),
.RXMARGINRESLANENUM(rxmarginreslanenum),
.RXMARGINRESPAYLD(rxmarginrespayld),
.RXMARGINRESREQ(rxmarginresreq),
.RXPINORTHOUT(rxpinorthout),
.RXPISOUTHOUT(rxpisouthout),
.S0_AXIS_TREADY(s0_axis_tready),
.S1_AXIS_TREADY(s1_axis_tready),
.S2_AXIS_TREADY(s2_axis_tready),
.TRIGACKIN0(trigackin0),
.TRIGOUT0(trigout0),
.TXPINORTHOUT(txpinorthout),
.TXPISOUTHOUT(txpisouthout),
.UBINTERRUPT(ubinterrupt),
.UBTXUART(ubtxuart),
.UNCORRECTERR(uncorrecterr),
.ALTCLK(altclk),
.APB3CLK(apb3_pclk_int),
.APB3PRESETN(apb3presetn_quad_int),
.APB3PADDR  (apb3paddr_quad_int),
.APB3PENABLE(apb3penable_quad_int),
.APB3PSEL   (apb3sel_quad_int),
.APB3PWDATA (apb3pwdata_quad_int),
.APB3PWRITE (apb3pwrite_quad_int),
.AXISCLK(axisclk),
.BGBYPASSB(bgbypassb),
.BGMONITORENB(bgmonitorenb),
.BGPDB(bgpdb),
.BGRCALOVRD(bgrcalovrd),
.BGRCALOVRDENB(bgrcalovrdenb),
.CH0_CDRBMCDRREQ(ch0_cdrbmcdrreq),
.CH0_CDRFREQOS(ch0_cdrfreqos),
.CH0_CDRINCPCTRL(ch0_cdrincpctrl),
.CH0_CDRSTEPDIR(ch0_cdrstepdir),
.CH0_CDRSTEPSQ(ch0_cdrstepsq),
.CH0_CDRSTEPSX(ch0_cdrstepsx),
.CH0_CFOKOVRDFINISH(ch0_cfokovrdfinish),
.CH0_CFOKOVRDPULSE(ch0_cfokovrdpulse),
.CH0_CFOKOVRDSTART(ch0_cfokovrdstart),
.CH0_CLKRSVD0(ch0_clkrsvd0),
.CH0_CLKRSVD1(ch0_clkrsvd1),
.CH0_DMONFIFORESET(ch0_dmonfiforeset),
.CH0_DMONITORCLK(ch0_dmonitorclk),
.CH0_EYESCANRESET(ch0_eyescanreset),
.CH0_EYESCANTRIGGER(ch0_eyescantrigger),
.CH0_GTRSVD(ch0_gtrsvd),
.CH0_GTRXRESET(ch0_gtrxreset),
.CH0_GTTXRESET(ch0_gttxreset),
.CH0_GTYRXN(ch0_gtyrxn),
.CH0_GTYRXP(ch0_gtyrxp),
.CH0_HSDPPCSRESET(ch0_hsdppcsreset),
.CH0_ILORESET(ch0_iloreset),
.CH0_ILORESETMASK(ch0_iloresetmask),
.CH0_LOOPBACK(ch0_loopback),
.CH0_PCIERSTB(ch0_pcierstb),
.CH0_PCSRSVDIN(ch0_pcsrsvdin_int),
.CH0_PHYESMADAPTSAVE(ch0_phyesmadaptsave),
.CH0_RXCDRHOLD(ch0_rxcdrhold),
.CH0_RXCDROVRDEN(ch0_rxcdrovrden),
.CH0_RXCDRRESET(ch0_rxcdrreset),
.CH0_RXCHBONDI(ch0_rxchbondi),
.CH0_RXDAPICODEOVRDEN(ch0_rxdapicodeovrden),
.CH0_RXDAPICODERESET(ch0_rxdapicodereset),
.CH0_RXDLYALIGNREQ(ch0_rxdlyalignreq),
.CH0_RXEQTRAINING(ch0_rxeqtraining),
.CH0_RXGEARBOXSLIP(ch0_rxgearboxslip),
.CH0_RXLATCLK(ch0_rxlatclk),
.CH0_RXLPMEN(ch0_rxlpmen),
.CH0_RXMLDCHAINDONE(ch0_rxmldchaindone),
.CH0_RXMLDCHAINREQ(ch0_rxmldchainreq),
.CH0_RXMLFINEALIGNREQ(ch0_rxmlfinealignreq),
.CH0_RXOOBRESET(ch0_rxoobreset),
.CH0_RXPCSRESETMASK(ch0_rxpcsresetmask),
.CH0_RXPD(ch0_rxpd),
.CH0_RXPHALIGNREQ(ch0_rxphalignreq),
.CH0_RXPHALIGNRESETMASK(ch0_rxphalignresetmask),
.CH0_RXPHDLYPD(ch0_rxphdlypd),
.CH0_RXPHDLYRESET(ch0_rxphdlyreset),
.CH0_RXPHSETINITREQ(ch0_rxphsetinitreq),
.CH0_RXPHSHIFT180(ch0_rxphshift180),
.CH0_RXPMARESETMASK(ch0_rxpmaresetmask),
.CH0_RXPOLARITY(ch0_rxpolarity),
.CH0_RXPRBSCNTRESET(ch0_rxprbscntreset),
.CH0_RXPRBSSEL(ch0_rxprbssel),
.CH0_RXPROGDIVRESET(ch0_rxprogdivreset),
.CH0_RXRATE(ch0_rxrate),
.CH0_RXRESETMODE(ch0_rxresetmode),
.CH0_RXSLIDE(ch0_rxslide),
.CH0_RXSYNCALLIN(ch0_rxsyncallin),
.CH0_RXTERMINATION(ch0_rxtermination),
.CH0_RXUSERRDY(ch0_rxuserrdy),
.CH0_RXUSRCLK(ch0_rxusrclk),
.CH0_TSTCLK0(ch0_tstclk0),
.CH0_TSTCLK1(ch0_tstclk1),
.CH0_TSTIN(ch0_tstin),
.CH0_TXCOMINIT(ch0_txcominit),
.CH0_TXCOMSAS(ch0_txcomsas),
.CH0_TXCOMWAKE(ch0_txcomwake),
.CH0_TXCTRL0(ch0_txctrl0),
.CH0_TXCTRL1(ch0_txctrl1),
.CH0_TXCTRL2(ch0_txctrl2),
.CH0_TXDAPICODEOVRDEN(ch0_txdapicodeovrden),
.CH0_TXDAPICODERESET(ch0_txdapicodereset),
.CH0_TXDATA(ch0_txdata_ANLT),
.CH0_TXDATAEXTENDRSVD(ch0_txdataextendrsvd),
.CH0_TXDEEMPH(ch0_txdeemph),
.CH0_TXDETECTRX(ch0_txdetectrx),
.CH0_TXDIFFCTRL(ch0_txdiffctrl),
.CH0_TXDLYALIGNREQ(ch0_txdlyalignreq),
.CH0_TXELECIDLE(ch0_txelecidle),
.CH0_TXHEADER(ch0_txheader),
.CH0_TXINHIBIT(ch0_txinhibit),
.CH0_TXLATCLK(ch0_txlatclk),
.CH0_TXMAINCURSOR(ch0_txmaincursor),
.CH0_TXMARGIN(ch0_txmargin),
.CH0_TXMLDCHAINDONE(ch0_txmldchaindone),
.CH0_TXMLDCHAINREQ(ch0_txmldchainreq),
.CH0_TXONESZEROS(ch0_txoneszeros),
.CH0_TXPAUSEDELAYALIGN(ch0_txpausedelayalign),
.CH0_TXPCSRESETMASK(ch0_txpcsresetmask),
.CH0_TXPD(ch0_txpd),
.CH0_TXPHALIGNREQ(ch0_txphalignreq),
.CH0_TXPHALIGNRESETMASK(ch0_txphalignresetmask),
.CH0_TXPHDLYPD(ch0_txphdlypd),
.CH0_TXPHDLYRESET(ch0_txphdlyreset),
.CH0_TXPHDLYTSTCLK(ch0_txphdlytstclk),
.CH0_TXPHSETINITREQ(ch0_txphsetinitreq),
.CH0_TXPHSHIFT180(ch0_txphshift180),
.CH0_TXPICODEOVRDEN(ch0_txpicodeovrden),
.CH0_TXPICODERESET(ch0_txpicodereset),
.CH0_TXPIPPMEN(ch0_txpippmen),
.CH0_TXPIPPMSTEPSIZE(ch0_txpippmstepsize),
.CH0_TXPISOPD(ch0_txpisopd),
.CH0_TXPMARESETMASK(ch0_txpmaresetmask),
.CH0_TXPOLARITY(ch0_txpolarity),
.CH0_TXPOSTCURSOR(ch0_txpostcursor),
.CH0_TXPRBSFORCEERR(ch0_txprbsforceerr),
.CH0_TXPRBSSEL(ch0_txprbssel),
.CH0_TXPRECURSOR(ch0_txprecursor),
.CH0_TXPROGDIVRESET(ch0_txprogdivreset),
.CH0_TXRATE(ch0_txrate),
.CH0_TXRESETMODE(ch0_txresetmode),
.CH0_TXSEQUENCE(ch0_txsequence),
.CH0_TXSWING(ch0_txswing),
.CH0_TXSYNCALLIN(ch0_txsyncallin),
.CH0_TXUSERRDY(ch0_txuserrdy),
.CH0_TXUSRCLK(ch0_txusrclk),
.CH1_CDRBMCDRREQ(ch1_cdrbmcdrreq),
.CH1_CDRFREQOS(ch1_cdrfreqos),
.CH1_CDRINCPCTRL(ch1_cdrincpctrl),
.CH1_CDRSTEPDIR(ch1_cdrstepdir),
.CH1_CDRSTEPSQ(ch1_cdrstepsq),
.CH1_CDRSTEPSX(ch1_cdrstepsx),
.CH1_CFOKOVRDFINISH(ch1_cfokovrdfinish),
.CH1_CFOKOVRDPULSE(ch1_cfokovrdpulse),
.CH1_CFOKOVRDSTART(ch1_cfokovrdstart),
.CH1_CLKRSVD0(ch1_clkrsvd0),
.CH1_CLKRSVD1(ch1_clkrsvd1),
.CH1_DMONFIFORESET(ch1_dmonfiforeset),
.CH1_DMONITORCLK(ch1_dmonitorclk),
.CH1_EYESCANRESET(ch1_eyescanreset),
.CH1_EYESCANTRIGGER(ch1_eyescantrigger),
.CH1_GTRSVD(ch1_gtrsvd),
.CH1_GTRXRESET(ch1_gtrxreset),
.CH1_GTTXRESET(ch1_gttxreset),
.CH1_GTYRXN(ch1_gtyrxn),
.CH1_GTYRXP(ch1_gtyrxp),
.CH1_HSDPPCSRESET(ch1_hsdppcsreset),
.CH1_ILORESET(ch1_iloreset),
.CH1_ILORESETMASK(ch1_iloresetmask),
.CH1_LOOPBACK(ch1_loopback),
.CH1_PCIERSTB(ch1_pcierstb),
.CH1_PCSRSVDIN(ch1_pcsrsvdin_int),
.CH1_PHYESMADAPTSAVE(ch1_phyesmadaptsave),
.CH1_RXCDRHOLD(ch1_rxcdrhold),
.CH1_RXCDROVRDEN(ch1_rxcdrovrden),
.CH1_RXCDRRESET(ch1_rxcdrreset),
.CH1_RXCHBONDI(ch1_rxchbondi),
.CH1_RXDAPICODEOVRDEN(ch1_rxdapicodeovrden),
.CH1_RXDAPICODERESET(ch1_rxdapicodereset),
.CH1_RXDLYALIGNREQ(ch1_rxdlyalignreq),
.CH1_RXEQTRAINING(ch1_rxeqtraining),
.CH1_RXGEARBOXSLIP(ch1_rxgearboxslip),
.CH1_RXLATCLK(ch1_rxlatclk),
.CH1_RXLPMEN(ch1_rxlpmen),
.CH1_RXMLDCHAINDONE(ch1_rxmldchaindone),
.CH1_RXMLDCHAINREQ(ch1_rxmldchainreq),
.CH1_RXMLFINEALIGNREQ(ch1_rxmlfinealignreq),
.CH1_RXOOBRESET(ch1_rxoobreset),
.CH1_RXPCSRESETMASK(ch1_rxpcsresetmask),
.CH1_RXPD(ch1_rxpd),
.CH1_RXPHALIGNREQ(ch1_rxphalignreq),
.CH1_RXPHALIGNRESETMASK(ch1_rxphalignresetmask),
.CH1_RXPHDLYPD(ch1_rxphdlypd),
.CH1_RXPHDLYRESET(ch1_rxphdlyreset),
.CH1_RXPHSETINITREQ(ch1_rxphsetinitreq),
.CH1_RXPHSHIFT180(ch1_rxphshift180),
.CH1_RXPMARESETMASK(ch1_rxpmaresetmask),
.CH1_RXPOLARITY(ch1_rxpolarity),
.CH1_RXPRBSCNTRESET(ch1_rxprbscntreset),
.CH1_RXPRBSSEL(ch1_rxprbssel),
.CH1_RXPROGDIVRESET(ch1_rxprogdivreset),
.CH1_RXRATE(ch1_rxrate),
.CH1_RXRESETMODE(ch1_rxresetmode),
.CH1_RXSLIDE(ch1_rxslide),
.CH1_RXSYNCALLIN(ch1_rxsyncallin),
.CH1_RXTERMINATION(ch1_rxtermination),
.CH1_RXUSERRDY(ch1_rxuserrdy),
.CH1_RXUSRCLK(ch1_rxusrclk),
.CH1_TSTCLK0(ch1_tstclk0),
.CH1_TSTCLK1(ch1_tstclk1),
.CH1_TSTIN(ch1_tstin),
.CH1_TXCOMINIT(ch1_txcominit),
.CH1_TXCOMSAS(ch1_txcomsas),
.CH1_TXCOMWAKE(ch1_txcomwake),
.CH1_TXCTRL0(ch1_txctrl0),
.CH1_TXCTRL1(ch1_txctrl1),
.CH1_TXCTRL2(ch1_txctrl2),
.CH1_TXDAPICODEOVRDEN(ch1_txdapicodeovrden),
.CH1_TXDAPICODERESET(ch1_txdapicodereset),
.CH1_TXDATA(ch1_txdata_ANLT),
.CH1_TXDATAEXTENDRSVD(ch1_txdataextendrsvd),
.CH1_TXDEEMPH(ch1_txdeemph),
.CH1_TXDETECTRX(ch1_txdetectrx),
.CH1_TXDIFFCTRL(ch1_txdiffctrl),
.CH1_TXDLYALIGNREQ(ch1_txdlyalignreq),
.CH1_TXELECIDLE(ch1_txelecidle),
.CH1_TXHEADER(ch1_txheader),
.CH1_TXINHIBIT(ch1_txinhibit),
.CH1_TXLATCLK(ch1_txlatclk),
.CH1_TXMAINCURSOR(ch1_txmaincursor),
.CH1_TXMARGIN(ch1_txmargin),
.CH1_TXMLDCHAINDONE(ch1_txmldchaindone),
.CH1_TXMLDCHAINREQ(ch1_txmldchainreq),
.CH1_TXONESZEROS(ch1_txoneszeros),
.CH1_TXPAUSEDELAYALIGN(ch1_txpausedelayalign),
.CH1_TXPCSRESETMASK(ch1_txpcsresetmask),
.CH1_TXPD(ch1_txpd),
.CH1_TXPHALIGNREQ(ch1_txphalignreq),
.CH1_TXPHALIGNRESETMASK(ch1_txphalignresetmask),
.CH1_TXPHDLYPD(ch1_txphdlypd),
.CH1_TXPHDLYRESET(ch1_txphdlyreset),
.CH1_TXPHDLYTSTCLK(ch1_txphdlytstclk),
.CH1_TXPHSETINITREQ(ch1_txphsetinitreq),
.CH1_TXPHSHIFT180(ch1_txphshift180),
.CH1_TXPICODEOVRDEN(ch1_txpicodeovrden),
.CH1_TXPICODERESET(ch1_txpicodereset),
.CH1_TXPIPPMEN(ch1_txpippmen),
.CH1_TXPIPPMSTEPSIZE(ch1_txpippmstepsize),
.CH1_TXPISOPD(ch1_txpisopd),
.CH1_TXPMARESETMASK(ch1_txpmaresetmask),
.CH1_TXPOLARITY(ch1_txpolarity),
.CH1_TXPOSTCURSOR(ch1_txpostcursor),
.CH1_TXPRBSFORCEERR(ch1_txprbsforceerr),
.CH1_TXPRBSSEL(ch1_txprbssel),
.CH1_TXPRECURSOR(ch1_txprecursor),
.CH1_TXPROGDIVRESET(ch1_txprogdivreset),
.CH1_TXRATE(ch1_txrate),
.CH1_TXRESETMODE(ch1_txresetmode),
.CH1_TXSEQUENCE(ch1_txsequence),
.CH1_TXSWING(ch1_txswing),
.CH1_TXSYNCALLIN(ch1_txsyncallin),
.CH1_TXUSERRDY(ch1_txuserrdy),
.CH1_TXUSRCLK(ch1_txusrclk),
.CH2_CDRBMCDRREQ(ch2_cdrbmcdrreq),
.CH2_CDRFREQOS(ch2_cdrfreqos),
.CH2_CDRINCPCTRL(ch2_cdrincpctrl),
.CH2_CDRSTEPDIR(ch2_cdrstepdir),
.CH2_CDRSTEPSQ(ch2_cdrstepsq),
.CH2_CDRSTEPSX(ch2_cdrstepsx),
.CH2_CFOKOVRDFINISH(ch2_cfokovrdfinish),
.CH2_CFOKOVRDPULSE(ch2_cfokovrdpulse),
.CH2_CFOKOVRDSTART(ch2_cfokovrdstart),
.CH2_CLKRSVD0(ch2_clkrsvd0),
.CH2_CLKRSVD1(ch2_clkrsvd1),
.CH2_DMONFIFORESET(ch2_dmonfiforeset),
.CH2_DMONITORCLK(ch2_dmonitorclk),
.CH2_EYESCANRESET(ch2_eyescanreset),
.CH2_EYESCANTRIGGER(ch2_eyescantrigger),
.CH2_GTRSVD(ch2_gtrsvd),
.CH2_GTRXRESET(ch2_gtrxreset),
.CH2_GTTXRESET(ch2_gttxreset),
.CH2_GTYRXN(ch2_gtyrxn),
.CH2_GTYRXP(ch2_gtyrxp),
.CH2_HSDPPCSRESET(ch2_hsdppcsreset),
.CH2_ILORESET(ch2_iloreset),
.CH2_ILORESETMASK(ch2_iloresetmask),
.CH2_LOOPBACK(ch2_loopback),
.CH2_PCIERSTB(ch2_pcierstb),
.CH2_PCSRSVDIN(ch2_pcsrsvdin_int),
.CH2_PHYESMADAPTSAVE(ch2_phyesmadaptsave),
.CH2_RXCDRHOLD(ch2_rxcdrhold),
.CH2_RXCDROVRDEN(ch2_rxcdrovrden),
.CH2_RXCDRRESET(ch2_rxcdrreset),
.CH2_RXCHBONDI(ch2_rxchbondi),
.CH2_RXDAPICODEOVRDEN(ch2_rxdapicodeovrden),
.CH2_RXDAPICODERESET(ch2_rxdapicodereset),
.CH2_RXDLYALIGNREQ(ch2_rxdlyalignreq),
.CH2_RXEQTRAINING(ch2_rxeqtraining),
.CH2_RXGEARBOXSLIP(ch2_rxgearboxslip),
.CH2_RXLATCLK(ch2_rxlatclk),
.CH2_RXLPMEN(ch2_rxlpmen),
.CH2_RXMLDCHAINDONE(ch2_rxmldchaindone),
.CH2_RXMLDCHAINREQ(ch2_rxmldchainreq),
.CH2_RXMLFINEALIGNREQ(ch2_rxmlfinealignreq),
.CH2_RXOOBRESET(ch2_rxoobreset),
.CH2_RXPCSRESETMASK(ch2_rxpcsresetmask),
.CH2_RXPD(ch2_rxpd),
.CH2_RXPHALIGNREQ(ch2_rxphalignreq),
.CH2_RXPHALIGNRESETMASK(ch2_rxphalignresetmask),
.CH2_RXPHDLYPD(ch2_rxphdlypd),
.CH2_RXPHDLYRESET(ch2_rxphdlyreset),
.CH2_RXPHSETINITREQ(ch2_rxphsetinitreq),
.CH2_RXPHSHIFT180(ch2_rxphshift180),
.CH2_RXPMARESETMASK(ch2_rxpmaresetmask),
.CH2_RXPOLARITY(ch2_rxpolarity),
.CH2_RXPRBSCNTRESET(ch2_rxprbscntreset),
.CH2_RXPRBSSEL(ch2_rxprbssel),
.CH2_RXPROGDIVRESET(ch2_rxprogdivreset),
.CH2_RXRATE(ch2_rxrate),
.CH2_RXRESETMODE(ch2_rxresetmode),
.CH2_RXSLIDE(ch2_rxslide),
.CH2_RXSYNCALLIN(ch2_rxsyncallin),
.CH2_RXTERMINATION(ch2_rxtermination),
.CH2_RXUSERRDY(ch2_rxuserrdy),
.CH2_RXUSRCLK(ch2_rxusrclk),
.CH2_TSTCLK0(ch2_tstclk0),
.CH2_TSTCLK1(ch2_tstclk1),
.CH2_TSTIN(ch2_tstin),
.CH2_TXCOMINIT(ch2_txcominit),
.CH2_TXCOMSAS(ch2_txcomsas),
.CH2_TXCOMWAKE(ch2_txcomwake),
.CH2_TXCTRL0(ch2_txctrl0),
.CH2_TXCTRL1(ch2_txctrl1),
.CH2_TXCTRL2(ch2_txctrl2),
.CH2_TXDAPICODEOVRDEN(ch2_txdapicodeovrden),
.CH2_TXDAPICODERESET(ch2_txdapicodereset),
.CH2_TXDATA(ch2_txdata_ANLT),
.CH2_TXDATAEXTENDRSVD(ch2_txdataextendrsvd),
.CH2_TXDEEMPH(ch2_txdeemph),
.CH2_TXDETECTRX(ch2_txdetectrx),
.CH2_TXDIFFCTRL(ch2_txdiffctrl),
.CH2_TXDLYALIGNREQ(ch2_txdlyalignreq),
.CH2_TXELECIDLE(ch2_txelecidle),
.CH2_TXHEADER(ch2_txheader),
.CH2_TXINHIBIT(ch2_txinhibit),
.CH2_TXLATCLK(ch2_txlatclk),
.CH2_TXMAINCURSOR(ch2_txmaincursor),
.CH2_TXMARGIN(ch2_txmargin),
.CH2_TXMLDCHAINDONE(ch2_txmldchaindone),
.CH2_TXMLDCHAINREQ(ch2_txmldchainreq),
.CH2_TXONESZEROS(ch2_txoneszeros),
.CH2_TXPAUSEDELAYALIGN(ch2_txpausedelayalign),
.CH2_TXPCSRESETMASK(ch2_txpcsresetmask),
.CH2_TXPD(ch2_txpd),
.CH2_TXPHALIGNREQ(ch2_txphalignreq),
.CH2_TXPHALIGNRESETMASK(ch2_txphalignresetmask),
.CH2_TXPHDLYPD(ch2_txphdlypd),
.CH2_TXPHDLYRESET(ch2_txphdlyreset),
.CH2_TXPHDLYTSTCLK(ch2_txphdlytstclk),
.CH2_TXPHSETINITREQ(ch2_txphsetinitreq),
.CH2_TXPHSHIFT180(ch2_txphshift180),
.CH2_TXPICODEOVRDEN(ch2_txpicodeovrden),
.CH2_TXPICODERESET(ch2_txpicodereset),
.CH2_TXPIPPMEN(ch2_txpippmen),
.CH2_TXPIPPMSTEPSIZE(ch2_txpippmstepsize),
.CH2_TXPISOPD(ch2_txpisopd),
.CH2_TXPMARESETMASK(ch2_txpmaresetmask),
.CH2_TXPOLARITY(ch2_txpolarity),
.CH2_TXPOSTCURSOR(ch2_txpostcursor),
.CH2_TXPRBSFORCEERR(ch2_txprbsforceerr),
.CH2_TXPRBSSEL(ch2_txprbssel),
.CH2_TXPRECURSOR(ch2_txprecursor),
.CH2_TXPROGDIVRESET(ch2_txprogdivreset),
.CH2_TXRATE(ch2_txrate),
.CH2_TXRESETMODE(ch2_txresetmode),
.CH2_TXSEQUENCE(ch2_txsequence),
.CH2_TXSWING(ch2_txswing),
.CH2_TXSYNCALLIN(ch2_txsyncallin),
.CH2_TXUSERRDY(ch2_txuserrdy),
.CH2_TXUSRCLK(ch2_txusrclk),
.CH3_CDRBMCDRREQ(ch3_cdrbmcdrreq),
.CH3_CDRFREQOS(ch3_cdrfreqos),
.CH3_CDRINCPCTRL(ch3_cdrincpctrl),
.CH3_CDRSTEPDIR(ch3_cdrstepdir),
.CH3_CDRSTEPSQ(ch3_cdrstepsq),
.CH3_CDRSTEPSX(ch3_cdrstepsx),
.CH3_CFOKOVRDFINISH(ch3_cfokovrdfinish),
.CH3_CFOKOVRDPULSE(ch3_cfokovrdpulse),
.CH3_CFOKOVRDSTART(ch3_cfokovrdstart),
.CH3_CLKRSVD0(ch3_clkrsvd0),
.CH3_CLKRSVD1(ch3_clkrsvd1),
.CH3_DMONFIFORESET(ch3_dmonfiforeset),
.CH3_DMONITORCLK(ch3_dmonitorclk),
.CH3_EYESCANRESET(ch3_eyescanreset),
.CH3_EYESCANTRIGGER(ch3_eyescantrigger),
.CH3_GTRSVD(ch3_gtrsvd),
.CH3_GTRXRESET(ch3_gtrxreset),
.CH3_GTTXRESET(ch3_gttxreset),
.CH3_GTYRXN(ch3_gtyrxn),
.CH3_GTYRXP(ch3_gtyrxp),
.CH3_HSDPPCSRESET(ch3_hsdppcsreset),
.CH3_ILORESET(ch3_iloreset),
.CH3_ILORESETMASK(ch3_iloresetmask),
.CH3_LOOPBACK(ch3_loopback),
.CH3_PCIERSTB(ch3_pcierstb),
.CH3_PCSRSVDIN(ch3_pcsrsvdin_int),
.CH3_PHYESMADAPTSAVE(ch3_phyesmadaptsave),
.CH3_RXCDRHOLD(ch3_rxcdrhold),
.CH3_RXCDROVRDEN(ch3_rxcdrovrden),
.CH3_RXCDRRESET(ch3_rxcdrreset),
.CH3_RXCHBONDI(ch3_rxchbondi),
.CH3_RXDAPICODEOVRDEN(ch3_rxdapicodeovrden),
.CH3_RXDAPICODERESET(ch3_rxdapicodereset),
.CH3_RXDLYALIGNREQ(ch3_rxdlyalignreq),
.CH3_RXEQTRAINING(ch3_rxeqtraining),
.CH3_RXGEARBOXSLIP(ch3_rxgearboxslip),
.CH3_RXLATCLK(ch3_rxlatclk),
.CH3_RXLPMEN(ch3_rxlpmen),
.CH3_RXMLDCHAINDONE(ch3_rxmldchaindone),
.CH3_RXMLDCHAINREQ(ch3_rxmldchainreq),
.CH3_RXMLFINEALIGNREQ(ch3_rxmlfinealignreq),
.CH3_RXOOBRESET(ch3_rxoobreset),
.CH3_RXPCSRESETMASK(ch3_rxpcsresetmask),
.CH3_RXPD(ch3_rxpd),
.CH3_RXPHALIGNREQ(ch3_rxphalignreq),
.CH3_RXPHALIGNRESETMASK(ch3_rxphalignresetmask),
.CH3_RXPHDLYPD(ch3_rxphdlypd),
.CH3_RXPHDLYRESET(ch3_rxphdlyreset),
.CH3_RXPHSETINITREQ(ch3_rxphsetinitreq),
.CH3_RXPHSHIFT180(ch3_rxphshift180),
.CH3_RXPMARESETMASK(ch3_rxpmaresetmask),
.CH3_RXPOLARITY(ch3_rxpolarity),
.CH3_RXPRBSCNTRESET(ch3_rxprbscntreset),
.CH3_RXPRBSSEL(ch3_rxprbssel),
.CH3_RXPROGDIVRESET(ch3_rxprogdivreset),
.CH3_RXRATE(ch3_rxrate),
.CH3_RXRESETMODE(ch3_rxresetmode),
.CH3_RXSLIDE(ch3_rxslide),
.CH3_RXSYNCALLIN(ch3_rxsyncallin),
.CH3_RXTERMINATION(ch3_rxtermination),
.CH3_RXUSERRDY(ch3_rxuserrdy),
.CH3_RXUSRCLK(ch3_rxusrclk),
.CH3_TSTCLK0(ch3_tstclk0),
.CH3_TSTCLK1(ch3_tstclk1),
.CH3_TSTIN(ch3_tstin),
.CH3_TXCOMINIT(ch3_txcominit),
.CH3_TXCOMSAS(ch3_txcomsas),
.CH3_TXCOMWAKE(ch3_txcomwake),
.CH3_TXCTRL0(ch3_txctrl0),
.CH3_TXCTRL1(ch3_txctrl1),
.CH3_TXCTRL2(ch3_txctrl2),
.CH3_TXDAPICODEOVRDEN(ch3_txdapicodeovrden),
.CH3_TXDAPICODERESET(ch3_txdapicodereset),
.CH3_TXDATA(ch3_txdata_ANLT),
.CH3_TXDATAEXTENDRSVD(ch3_txdataextendrsvd),
.CH3_TXDEEMPH(ch3_txdeemph),
.CH3_TXDETECTRX(ch3_txdetectrx),
.CH3_TXDIFFCTRL(ch3_txdiffctrl),
.CH3_TXDLYALIGNREQ(ch3_txdlyalignreq),
.CH3_TXELECIDLE(ch3_txelecidle),
.CH3_TXHEADER(ch3_txheader),
.CH3_TXINHIBIT(ch3_txinhibit),
.CH3_TXLATCLK(ch3_txlatclk),
.CH3_TXMAINCURSOR(ch3_txmaincursor),
.CH3_TXMARGIN(ch3_txmargin),
.CH3_TXMLDCHAINDONE(ch3_txmldchaindone),
.CH3_TXMLDCHAINREQ(ch3_txmldchainreq),
.CH3_TXONESZEROS(ch3_txoneszeros),
.CH3_TXPAUSEDELAYALIGN(ch3_txpausedelayalign),
.CH3_TXPCSRESETMASK(ch3_txpcsresetmask),
.CH3_TXPD(ch3_txpd),
.CH3_TXPHALIGNREQ(ch3_txphalignreq),
.CH3_TXPHALIGNRESETMASK(ch3_txphalignresetmask),
.CH3_TXPHDLYPD(ch3_txphdlypd),
.CH3_TXPHDLYRESET(ch3_txphdlyreset),
.CH3_TXPHDLYTSTCLK(ch3_txphdlytstclk),
.CH3_TXPHSETINITREQ(ch3_txphsetinitreq),
.CH3_TXPHSHIFT180(ch3_txphshift180),
.CH3_TXPICODEOVRDEN(ch3_txpicodeovrden),
.CH3_TXPICODERESET(ch3_txpicodereset),
.CH3_TXPIPPMEN(ch3_txpippmen),
.CH3_TXPIPPMSTEPSIZE(ch3_txpippmstepsize),
.CH3_TXPISOPD(ch3_txpisopd),
.CH3_TXPMARESETMASK(ch3_txpmaresetmask),
.CH3_TXPOLARITY(ch3_txpolarity),
.CH3_TXPOSTCURSOR(ch3_txpostcursor),
.CH3_TXPRBSFORCEERR(ch3_txprbsforceerr),
.CH3_TXPRBSSEL(ch3_txprbssel),
.CH3_TXPRECURSOR(ch3_txprecursor),
.CH3_TXPROGDIVRESET(ch3_txprogdivreset),
.CH3_TXRATE(ch3_txrate),
.CH3_TXRESETMODE(ch3_txresetmode),
.CH3_TXSEQUENCE(ch3_txsequence),
.CH3_TXSWING(ch3_txswing),
.CH3_TXSYNCALLIN(ch3_txsyncallin),
.CH3_TXUSERRDY(ch3_txuserrdy),
.CH3_TXUSRCLK(ch3_txusrclk),
.CTRLRSVDIN0(ctrlrsvdin0),
.CTRLRSVDIN1(ctrlrsvdin1),
.DEBUGTRACECLK(debugtraceclk),
.DEBUGTRACEREADY(debugtraceready),
.GPI(gpi),
.HSCLK0_LCPLLCLKRSVD0(hsclk0_lcpllclkrsvd0),
.HSCLK0_LCPLLCLKRSVD1(hsclk0_lcpllclkrsvd1),
.HSCLK0_LCPLLFBDIV(hsclk0_lcpllfbdiv),
.HSCLK0_LCPLLGTGREFCLK(hsclk0_lcpllgtgrefclk),
.HSCLK0_LCPLLGTREFCLK0(hsclk0_lcpllgtrefclk0),
.HSCLK0_LCPLLGTREFCLK1(hsclk0_lcpllgtrefclk1),
.HSCLK0_LCPLLNORTHREFCLK0(hsclk0_lcpllnorthrefclk0),
.HSCLK0_LCPLLNORTHREFCLK1(hsclk0_lcpllnorthrefclk1),
.HSCLK0_LCPLLPD(hsclk0_lcpllpd),
.HSCLK0_LCPLLREFCLKSEL(hsclk0_lcpllrefclksel),
.HSCLK0_LCPLLRESET(hsclk0_lcpllreset),
.HSCLK0_LCPLLRESETBYPASSMODE(hsclk0_lcpllresetbypassmode),
.HSCLK0_LCPLLRESETMASK(hsclk0_lcpllresetmask),
.HSCLK0_LCPLLRSVD0(hsclk0_lcpllrsvd0),
.HSCLK0_LCPLLRSVD1(hsclk0_lcpllrsvd1),
.HSCLK0_LCPLLSDMDATA(hsclk0_lcpllsdmdata),
.HSCLK0_LCPLLSDMTOGGLE(hsclk0_lcpllsdmtoggle),
.HSCLK0_LCPLLSOUTHREFCLK0(hsclk0_lcpllsouthrefclk0),
.HSCLK0_LCPLLSOUTHREFCLK1(hsclk0_lcpllsouthrefclk1),
.HSCLK0_RPLLCLKRSVD0(hsclk0_rpllclkrsvd0),
.HSCLK0_RPLLCLKRSVD1(hsclk0_rpllclkrsvd1),
.HSCLK0_RPLLFBDIV(hsclk0_rpllfbdiv),
.HSCLK0_RPLLGTGREFCLK(hsclk0_rpllgtgrefclk),
.HSCLK0_RPLLGTREFCLK0(hsclk0_rpllgtrefclk0),
.HSCLK0_RPLLGTREFCLK1(hsclk0_rpllgtrefclk1),
.HSCLK0_RPLLNORTHREFCLK0(hsclk0_rpllnorthrefclk0),
.HSCLK0_RPLLNORTHREFCLK1(hsclk0_rpllnorthrefclk1),
.HSCLK0_RPLLPD(hsclk0_rpllpd),
.HSCLK0_RPLLREFCLKSEL(hsclk0_rpllrefclksel),
.HSCLK0_RPLLRESET(hsclk0_rpllreset),
.HSCLK0_RPLLRESETBYPASSMODE(hsclk0_rpllresetbypassmode),
.HSCLK0_RPLLRESETMASK(hsclk0_rpllresetmask),
.HSCLK0_RPLLRSVD0(hsclk0_rpllrsvd0),
.HSCLK0_RPLLRSVD1(hsclk0_rpllrsvd1),
.HSCLK0_RPLLSDMDATA(hsclk0_rpllsdmdata),
.HSCLK0_RPLLSDMTOGGLE(hsclk0_rpllsdmtoggle),
.HSCLK0_RPLLSOUTHREFCLK0(hsclk0_rpllsouthrefclk0),
.HSCLK0_RPLLSOUTHREFCLK1(hsclk0_rpllsouthrefclk1),
.HSCLK1_LCPLLCLKRSVD0(hsclk1_lcpllclkrsvd0),
.HSCLK1_LCPLLCLKRSVD1(hsclk1_lcpllclkrsvd1),
.HSCLK1_LCPLLFBDIV(hsclk1_lcpllfbdiv),
.HSCLK1_LCPLLGTGREFCLK(hsclk1_lcpllgtgrefclk),
.HSCLK1_LCPLLGTREFCLK0(hsclk1_lcpllgtrefclk0),
.HSCLK1_LCPLLGTREFCLK1(hsclk1_lcpllgtrefclk1),
.HSCLK1_LCPLLNORTHREFCLK0(hsclk1_lcpllnorthrefclk0),
.HSCLK1_LCPLLNORTHREFCLK1(hsclk1_lcpllnorthrefclk1),
.HSCLK1_LCPLLPD(hsclk1_lcpllpd),
.HSCLK1_LCPLLREFCLKSEL(hsclk1_lcpllrefclksel),
.HSCLK1_LCPLLRESET(hsclk1_lcpllreset),
.HSCLK1_LCPLLRESETBYPASSMODE(hsclk1_lcpllresetbypassmode),
.HSCLK1_LCPLLRESETMASK(hsclk1_lcpllresetmask),
.HSCLK1_LCPLLRSVD0(hsclk1_lcpllrsvd0),
.HSCLK1_LCPLLRSVD1(hsclk1_lcpllrsvd1),
.HSCLK1_LCPLLSDMDATA(hsclk1_lcpllsdmdata),
.HSCLK1_LCPLLSDMTOGGLE(hsclk1_lcpllsdmtoggle),
.HSCLK1_LCPLLSOUTHREFCLK0(hsclk1_lcpllsouthrefclk0),
.HSCLK1_LCPLLSOUTHREFCLK1(hsclk1_lcpllsouthrefclk1),
.HSCLK1_RPLLCLKRSVD0(hsclk1_rpllclkrsvd0),
.HSCLK1_RPLLCLKRSVD1(hsclk1_rpllclkrsvd1),
.HSCLK1_RPLLFBDIV(hsclk1_rpllfbdiv),
.HSCLK1_RPLLGTGREFCLK(hsclk1_rpllgtgrefclk),
.HSCLK1_RPLLGTREFCLK0(hsclk1_rpllgtrefclk0),
.HSCLK1_RPLLGTREFCLK1(hsclk1_rpllgtrefclk1),
.HSCLK1_RPLLNORTHREFCLK0(hsclk1_rpllnorthrefclk0),
.HSCLK1_RPLLNORTHREFCLK1(hsclk1_rpllnorthrefclk1),
.HSCLK1_RPLLPD(hsclk1_rpllpd),
.HSCLK1_RPLLREFCLKSEL(hsclk1_rpllrefclksel),
.HSCLK1_RPLLRESET(hsclk1_rpllreset),
.HSCLK1_RPLLRESETBYPASSMODE(hsclk1_rpllresetbypassmode),
.HSCLK1_RPLLRESETMASK(hsclk1_rpllresetmask),
.HSCLK1_RPLLRSVD0(hsclk1_rpllrsvd0),
.HSCLK1_RPLLRSVD1(hsclk1_rpllrsvd1),
.HSCLK1_RPLLSDMDATA(hsclk1_rpllsdmdata),
.HSCLK1_RPLLSDMTOGGLE(hsclk1_rpllsdmtoggle),
.HSCLK1_RPLLSOUTHREFCLK0(hsclk1_rpllsouthrefclk0),
.HSCLK1_RPLLSOUTHREFCLK1(hsclk1_rpllsouthrefclk1),
.M0_AXIS_TREADY(m0_axis_tready),
.M1_AXIS_TREADY(m1_axis_tready),
.M2_AXIS_TREADY(m2_axis_tready),
.MSTRXRESET(mstrxreset),
.MSTTXRESET(msttxreset),
.PCIELINKREACHTARGET(pcielinkreachtarget),
.PCIELTSSM(pcieltssm),
.PIPENORTHIN(pipenorthin),
.PIPESOUTHIN(pipesouthin),
.RCALENB(rcalenb),
.REFCLK0_CLKTESTSIG(refclk0_clktestsig),
.REFCLK0_GTREFCLKPD(refclk0_gtrefclkpd),
.REFCLK1_CLKTESTSIG(refclk1_clktestsig),
.REFCLK1_GTREFCLKPD(refclk1_gtrefclkpd),
.RESETDONE_NORTHIN(resetdone_northin),
.RESETDONE_SOUTHIN(resetdone_southin),
.RXMARGINCLK(rxmarginclk),
.RXMARGINREQCMD(rxmarginreqcmd),
.RXMARGINREQLANENUM(rxmarginreqlanenum),
.RXMARGINREQPAYLD(rxmarginreqpayld),
.RXMARGINREQREQ(rxmarginreqreq),
.RXMARGINRESACK(rxmarginresack),
.RXPINORTHIN(rxpinorthin),
.RXPISOUTHIN(rxpisouthin),
.S0_AXIS_TDATA(s0_axis_tdata),
.S0_AXIS_TLAST(s0_axis_tlast),
.S0_AXIS_TVALID(s0_axis_tvalid),
.S1_AXIS_TDATA(s1_axis_tdata),
.S1_AXIS_TLAST(s1_axis_tlast),
.S1_AXIS_TVALID(s1_axis_tvalid),
.S2_AXIS_TDATA(s2_axis_tdata),
.S2_AXIS_TLAST(s2_axis_tlast),
.S2_AXIS_TVALID(s2_axis_tvalid),
.TRIGACKOUT0(trigackout0),
.TRIGIN0(trigin0),
.TXPINORTHIN(txpinorthin),
.TXPISOUTHIN(txpisouthin),
.UBENABLE(ubenable),
.UBINTR(ubintr),
.UBIOLMBRST(ubiolmbrst),
.UBMBRST(ubmbrst),
.UBRXUART(ubrxuart)

);
//------}

bd_57a1_cpm_0_0_gt_quad_0_gtye5_rstdone  u_ch0_txpmaresetdone  ( .freerunclk(apb3_pclk_int),  .rstdone_in(ch0_txpmaresetdone_int), .rstdone_out(ch0_txpmaresetdone));
bd_57a1_cpm_0_0_gt_quad_0_gtye5_rstdone  u_ch1_txpmaresetdone  ( .freerunclk(apb3_pclk_int),  .rstdone_in(ch1_txpmaresetdone_int), .rstdone_out(ch1_txpmaresetdone));
bd_57a1_cpm_0_0_gt_quad_0_gtye5_rstdone  u_ch2_txpmaresetdone  ( .freerunclk(apb3_pclk_int),  .rstdone_in(ch2_txpmaresetdone_int), .rstdone_out(ch2_txpmaresetdone));
bd_57a1_cpm_0_0_gt_quad_0_gtye5_rstdone  u_ch3_txpmaresetdone  ( .freerunclk(apb3_pclk_int),  .rstdone_in(ch3_txpmaresetdone_int), .rstdone_out(ch3_txpmaresetdone));

bd_57a1_cpm_0_0_gt_quad_0_gtye5_rstdone  u_ch0_rxpmaresetdone  ( .freerunclk(apb3_pclk_int),  .rstdone_in(ch0_rxpmaresetdone_int), .rstdone_out(ch0_rxpmaresetdone));
bd_57a1_cpm_0_0_gt_quad_0_gtye5_rstdone  u_ch1_rxpmaresetdone  ( .freerunclk(apb3_pclk_int),  .rstdone_in(ch1_rxpmaresetdone_int), .rstdone_out(ch1_rxpmaresetdone));
bd_57a1_cpm_0_0_gt_quad_0_gtye5_rstdone  u_ch2_rxpmaresetdone  ( .freerunclk(apb3_pclk_int),  .rstdone_in(ch2_rxpmaresetdone_int), .rstdone_out(ch2_rxpmaresetdone));
bd_57a1_cpm_0_0_gt_quad_0_gtye5_rstdone  u_ch3_rxpmaresetdone  ( .freerunclk(apb3_pclk_int),  .rstdone_in(ch3_rxpmaresetdone_int), .rstdone_out(ch3_rxpmaresetdone));

bd_57a1_cpm_0_0_gt_quad_0_gtye5_rstdone  u_ch0_txresetdone  ( .freerunclk(apb3_pclk_int),  .rstdone_in(ch0_txresetdone_int), .rstdone_out(ch0_txresetdone));
bd_57a1_cpm_0_0_gt_quad_0_gtye5_rstdone  u_ch1_txresetdone  ( .freerunclk(apb3_pclk_int),  .rstdone_in(ch1_txresetdone_int), .rstdone_out(ch1_txresetdone));
bd_57a1_cpm_0_0_gt_quad_0_gtye5_rstdone  u_ch2_txresetdone  ( .freerunclk(apb3_pclk_int),  .rstdone_in(ch2_txresetdone_int), .rstdone_out(ch2_txresetdone));
bd_57a1_cpm_0_0_gt_quad_0_gtye5_rstdone  u_ch3_txresetdone  ( .freerunclk(apb3_pclk_int),  .rstdone_in(ch3_txresetdone_int), .rstdone_out(ch3_txresetdone));
bd_57a1_cpm_0_0_gt_quad_0_gtye5_rstdone  u_ch0_rxresetdone  ( .freerunclk(apb3_pclk_int),  .rstdone_in(ch0_rxresetdone_int), .rstdone_out(ch0_rxresetdone));
bd_57a1_cpm_0_0_gt_quad_0_gtye5_rstdone  u_ch1_rxresetdone  ( .freerunclk(apb3_pclk_int),  .rstdone_in(ch1_rxresetdone_int), .rstdone_out(ch1_rxresetdone));
bd_57a1_cpm_0_0_gt_quad_0_gtye5_rstdone  u_ch2_rxresetdone  ( .freerunclk(apb3_pclk_int),  .rstdone_in(ch2_rxresetdone_int), .rstdone_out(ch2_rxresetdone));
bd_57a1_cpm_0_0_gt_quad_0_gtye5_rstdone  u_ch3_rxresetdone  ( .freerunclk(apb3_pclk_int),  .rstdone_in(ch3_rxresetdone_int), .rstdone_out(ch3_rxresetdone));

bd_57a1_cpm_0_0_gt_quad_0_gtye5_rstdone  u_ch0_msttxresetdone  ( .freerunclk(apb3_pclk_int),  .rstdone_in(msttxresetdone_int[0]), .rstdone_out(msttxresetdone[0]));
bd_57a1_cpm_0_0_gt_quad_0_gtye5_rstdone  u_ch1_msttxresetdone  ( .freerunclk(apb3_pclk_int),  .rstdone_in(msttxresetdone_int[1]), .rstdone_out(msttxresetdone[1]));
bd_57a1_cpm_0_0_gt_quad_0_gtye5_rstdone  u_ch2_msttxresetdone  ( .freerunclk(apb3_pclk_int),  .rstdone_in(msttxresetdone_int[2]), .rstdone_out(msttxresetdone[2]));
bd_57a1_cpm_0_0_gt_quad_0_gtye5_rstdone  u_ch3_msttxresetdone  ( .freerunclk(apb3_pclk_int),  .rstdone_in(msttxresetdone_int[3]), .rstdone_out(msttxresetdone[3]));

bd_57a1_cpm_0_0_gt_quad_0_gtye5_rstdone  u_ch0_mstrxresetdone  ( .freerunclk(apb3_pclk_int),  .rstdone_in(mstrxresetdone_int[0]), .rstdone_out(mstrxresetdone[0]));
bd_57a1_cpm_0_0_gt_quad_0_gtye5_rstdone  u_ch1_mstrxresetdone  ( .freerunclk(apb3_pclk_int),  .rstdone_in(mstrxresetdone_int[1]), .rstdone_out(mstrxresetdone[1]));
bd_57a1_cpm_0_0_gt_quad_0_gtye5_rstdone  u_ch2_mstrxresetdone  ( .freerunclk(apb3_pclk_int),  .rstdone_in(mstrxresetdone_int[2]), .rstdone_out(mstrxresetdone[2]));
bd_57a1_cpm_0_0_gt_quad_0_gtye5_rstdone  u_ch3_mstrxresetdone  ( .freerunclk(apb3_pclk_int),  .rstdone_in(mstrxresetdone_int[3]), .rstdone_out(mstrxresetdone[3]));

bd_57a1_cpm_0_0_gt_quad_0_gtye5_rstdone  u_ch0_10_pcsrsvdout  ( .freerunclk(apb3_pclk_int),  .rstdone_in(ch0_pcsrsvdout_int[10]), .rstdone_out(ch0_pcsrsvdout[10]));
bd_57a1_cpm_0_0_gt_quad_0_gtye5_rstdone  u_ch1_10_pcsrsvdout  ( .freerunclk(apb3_pclk_int),  .rstdone_in(ch1_pcsrsvdout_int[10]), .rstdone_out(ch1_pcsrsvdout[10]));
bd_57a1_cpm_0_0_gt_quad_0_gtye5_rstdone  u_ch2_10_pcsrsvdout  ( .freerunclk(apb3_pclk_int),  .rstdone_in(ch2_pcsrsvdout_int[10]), .rstdone_out(ch2_pcsrsvdout[10]));
bd_57a1_cpm_0_0_gt_quad_0_gtye5_rstdone  u_ch3_10_pcsrsvdout  ( .freerunclk(apb3_pclk_int),  .rstdone_in(ch3_pcsrsvdout_int[10]), .rstdone_out(ch3_pcsrsvdout[10]));

bd_57a1_cpm_0_0_gt_quad_0_gtye5_rstdone  u_ch0_11_pcsrsvdout  ( .freerunclk(apb3_pclk_int),  .rstdone_in(ch0_pcsrsvdout_int[11]), .rstdone_out(ch0_pcsrsvdout[11]));
bd_57a1_cpm_0_0_gt_quad_0_gtye5_rstdone  u_ch1_11_pcsrsvdout  ( .freerunclk(apb3_pclk_int),  .rstdone_in(ch1_pcsrsvdout_int[11]), .rstdone_out(ch1_pcsrsvdout[11]));
bd_57a1_cpm_0_0_gt_quad_0_gtye5_rstdone  u_ch2_11_pcsrsvdout  ( .freerunclk(apb3_pclk_int),  .rstdone_in(ch2_pcsrsvdout_int[11]), .rstdone_out(ch2_pcsrsvdout[11]));
bd_57a1_cpm_0_0_gt_quad_0_gtye5_rstdone  u_ch3_11_pcsrsvdout  ( .freerunclk(apb3_pclk_int),  .rstdone_in(ch3_pcsrsvdout_int[11]), .rstdone_out(ch3_pcsrsvdout[11]));

assign ch0_pcsrsvdout[15:12] = ch0_pcsrsvdout_int[15:12];
assign ch0_pcsrsvdout[9:0]   = ch0_pcsrsvdout_int[9:0];
assign ch1_pcsrsvdout[15:12] = ch1_pcsrsvdout_int[15:12];
assign ch1_pcsrsvdout[9:0]   = ch1_pcsrsvdout_int[9:0];
assign ch2_pcsrsvdout[15:12] = ch2_pcsrsvdout_int[15:12];
assign ch2_pcsrsvdout[9:0]   = ch2_pcsrsvdout_int[9:0];
assign ch3_pcsrsvdout[15:12] = ch3_pcsrsvdout_int[15:12];
assign ch3_pcsrsvdout[9:0]   = ch3_pcsrsvdout_int[9:0];

endmodule
//------}

//------{
module bd_57a1_cpm_0_0_gt_quad_0_gtye5_rstdone #(
  parameter SIM_VERSION = "1"
) (
  input  freerunclk,
  input  rstdone_in,
  output rstdone_out
);
  assign rstdone_out = rstdone_in;

endmodule
//------}
