`define AADDR_FIELD_WIDTH 64
`define ALEN_FIELD_WIDTH 8
`define ASIZE_FIELD_WIDTH 3
`define ABURST_FIELD_WIDTH 2
`define ALOCK_FIELD_WIDTH 1
`define ACACHE_FIELD_WIDTH 4
`define APROT_FIELD_WIDTH 3
`define AQOS_FIELD_WIDTH 4
`define AUSER_FIELD_WIDTH 16
`define AID_FIELD_WIDTH 16
`define POISON_WIDTH 1

//data pkt
`define DATA_FIELD_WIDTH 128
`define PERBYTE_FIELD_WIDTH 16

//all packets
`define TYPE_FIELD_WIDTH 4
`define MISCCTRLAST_FIELD_WIDTH 2
`define TAG_FIELD_WIDTH 8
`define SRC_FIELD_WIDTH 12
`define DEST_FIELD_WIDTH 12
`define DP_FIELD_WIDTH 1
`define PRI_FIELD_WIDTH 1
`define FPROT_FIELD_WIDTH 10
`define LAST_FIELD_WIDTH 1

//main configuration
`define FLIT_WIDTH (`DATA_FIELD_WIDTH + `NOC_NPP_PKT_CTRL_WIDTH)
//storage memory and responder memory configuration
`define MEM_WIDTH 128
`define MEM_DEPTH 2**(2+16+4)
`define NOC_NPS_NUM_VC  8

// ********************************************************
// NoC Packet Protocol Common Define
// ********************************************************

// NPP Width
`define NOC_NPP_AXADDR_WIDTH  64
`define NOC_NPP_AXADDR_LOWER_WIDTH  4'd12
`define NOC_NPP_AXADDR_UPPER_WIDTH  (`NOC_NPP_AXADDR_WIDTH-`NOC_NPP_AXADDR_LOWER_WIDTH)
`define NOC_NPP_AXLEN_WIDTH  8
`define NOC_NPP_AXSIZE_WIDTH  3
`define NOC_NPP_AXBURST_WIDTH  2
`define NOC_NPP_AXLOCK_WIDTH  1  // Only support exclusive, no legacy LOCK support
`define NOC_NPP_AXCACHE_WIDTH  4
`define NOC_NPP_AXPROT_WIDTH  3
`define NOC_NPP_AXQOS_WIDTH  4
`define NOC_NPP_AXID_WIDTH  16
`define NOC_NPP_AXUSER_WIDTH  16
`define NOC_NPP_POISON_WIDTH 1
`define NOC_NPP_RSVD_WIDTH 6

`define NOC_NPP_DATA_WIDTH  128

// dummy0 spacers for Request header
`define NOC_NPP_AXRSVD0_WIDTH  (`NOC_NPP_DATA_WIDTH-`NOC_NPP_AXADDR_WIDTH-`NOC_NPP_AXLEN_WIDTH-`NOC_NPP_AXSIZE_WIDTH-`NOC_NPP_AXBURST_WIDTH-`NOC_NPP_AXLOCK_WIDTH-`NOC_NPP_AXCACHE_WIDTH-`NOC_NPP_AXPROT_WIDTH-`NOC_NPP_AXQOS_WIDTH-`NOC_NPP_AXID_WIDTH-`NOC_NPP_AXUSER_WIDTH-`NOC_NPP_POISON_WIDTH)
`define NOC_NPP_AXRSVD1_WIDTH  (`NOC_NPP_DATA_WIDTH-`NOC_NPP_AXUSER_WIDTH)

`define NOC_NPP_PKT_TYPE_WIDTH  4
`define NOC_NPP_MISC_CTRL_WIDTH  2 //xResp
`define NOC_NPP_TAG_WIDTH  8
`define NOC_NPP_SRC_WIDTH  12
`define NOC_NPP_WSTRB_WIDTH  16
`define NOC_NPP_TLAST_WIDTH  1
`define NOC_NPP_DBI_WIDTH  1
`define NOC_NPP_POISON_WIDTH 1
`define NOC_NPP_CTRLRSVD0_WIDTH (`NOC_NPP_TAG_WIDTH+`NOC_NPP_SRC_WIDTH-`NOC_NPP_WSTRB_WIDTH)
`define NOC_NPP_DST_WIDTH  12
`define NOC_NPP_DST_PAR_WIDTH 1
`define NOC_NPP_PRI_WIDTH 1
`define NOC_NPP_LAST_WIDTH  1
`define NOC_NPP_ECC_WIDTH  10
`define NOC_NPP_PKT_CTRL_WIDTH  (`NOC_NPP_PKT_TYPE_WIDTH + `NOC_NPP_MISC_CTRL_WIDTH + `NOC_NPP_TAG_WIDTH + `NOC_NPP_SRC_WIDTH + `NOC_NPP_DST_WIDTH + `NOC_NPP_DST_PAR_WIDTH + `NOC_NPP_PRI_WIDTH + `NOC_NPP_LAST_WIDTH + `NOC_NPP_ECC_WIDTH+ `NOC_NPP_POISON_WIDTH + `NOC_NPP_TLAST_WIDTH + `NOC_NPP_DBI_WIDTH)
`define NOC_NPP_WIDTH  (`NOC_NPP_DATA_WIDTH + `NOC_NPP_PKT_CTRL_WIDTH)
`define NOC_NPP_WIDTH_WO_ECC (`NOC_NPP_WIDTH - `NOC_NPP_ECC_WIDTH)

`define NOC_NPP_TID_WIDTH 6
`define NOC_NPP_TDEST_WIDTH 10
// NPP bit assignment
`define NOC_NPP_AXADDR 63:0
`define NOC_NPP_AXADDR_16B 9:8
`define NOC_NPP_AXADDR_LOWER 11:0
`define NOC_NPP_AXADDR_UPPER 63:12
`define NOC_NPP_AXLEN 71:64
`define NOC_NPP_AXSIZE 74:72
`define NOC_NPP_AXBURST 76:75
`define NOC_NPP_AXLOCK 77:77
`define NOC_NPP_AXCACHE 81:78
`define NOC_NPP_AXPROT 84:82
`define NOC_NPP_AXQOS 88:85
`define NOC_NPP_AXID 104:89
`define NOC_NPP_AXUSER 120:105
`define NOC_NPP_RSVD 127:121
`define NOC_NPP_DATA 127:0
`define NOC_NPP_PKT_TYPE 131:128
`define NOC_NPP_MISC_CTRL 133:132

`define NOC_NPP_TAG 141:134  // FIXME: need to shift after TAG removal in write data flit
`define NOC_NPP_SRC 153:142  // FIXME: need to shift after TAG removal in write data flit
`define NOC_NPP_DST 165:154  // FIXME: need to shift after TAG removal in write data flit
//`define NOC_NPP_DST 145:134
//`define NOC_NPP_SRC 157:146
//`define NOC_NPP_TAG 165:158

`define NOC_NPP_DST_PAR 166:166
`define NOC_NPP_PRI 167:167
//changing this according to the noc protocol picture
`define NOC_NPP_WRSTB 149:134
//`define NOC_NPP_WRSTB 165:146
`define NOC_NPP_POISON 168:168
`define NOC_NPP_TLAST 169:169
`define NOC_NPP_LAST 170:170
`define NOC_NPP_DBI 171:171
`define NOC_NPP_WO_ECC 171:0
`define NOC_NPP_ECC 181:172
`define NOC_NPP_TID_L 153:150
`define NOC_NPP_TID_H 133:132
`define NOC_NPP_SMID 114:105
`define NOC_NPP_TDEST 181:172
// NPP field definition
`define NOC_NPP_PKT_TYPE_READ_REQ 4'd0
`define NOC_NPP_PKT_TYPE_WRITE_REQ 4'd1
`define NOC_NPP_PKT_TYPE_READ_RESP 4'd2
`define NOC_NPP_PKT_TYPE_WRITE_RESP 4'd3
`define NOC_NPP_PKT_TYPE_STRM_WRITE_REQ 4'd4


