/*******************************************************************************
* Copyright (c) 2018 - 2021 Xilinx, Inc.  All rights reserved.
* SPDX-License-Identifier: MIT
*******************************************************************************/


#ifndef __XLPD_XPPU_H__
#define __XLPD_XPPU_H__


#ifdef __cplusplus
extern "C" {
#endif

/**
 *@cond nocomments
 */

/**
 * XlpdXppu Base Address
 */
#define XLPD_XPPU_BASEADDR      0xFF990000UL

/**
 * Register: XlpdXppuCtrl
 */
#define XLPD_XPPU_CTRL    ( ( XLPD_XPPU_BASEADDR ) + 0x00000000UL )
#define XLPD_XPPU_CTRL_RSTVAL   0x00000000UL

#define XLPD_XPPU_CTRL_HIDE_EN_SHIFT   3UL
#define XLPD_XPPU_CTRL_HIDE_EN_WIDTH   1UL
#define XLPD_XPPU_CTRL_HIDE_EN_MASK    0x00000008UL
#define XLPD_XPPU_CTRL_HIDE_EN_DEFVAL  0x0UL

#define XLPD_XPPU_CTRL_APER_PARITY_EN_SHIFT   2UL
#define XLPD_XPPU_CTRL_APER_PARITY_EN_WIDTH   1UL
#define XLPD_XPPU_CTRL_APER_PARITY_EN_MASK    0x00000004UL
#define XLPD_XPPU_CTRL_APER_PARITY_EN_DEFVAL  0x0UL

#define XLPD_XPPU_CTRL_MID_PARITY_EN_SHIFT   1UL
#define XLPD_XPPU_CTRL_MID_PARITY_EN_WIDTH   1UL
#define XLPD_XPPU_CTRL_MID_PARITY_EN_MASK    0x00000002UL
#define XLPD_XPPU_CTRL_MID_PARITY_EN_DEFVAL  0x0UL

#define XLPD_XPPU_CTRL_EN_SHIFT   0UL
#define XLPD_XPPU_CTRL_EN_WIDTH   1UL
#define XLPD_XPPU_CTRL_EN_MASK    0x00000001UL
#define XLPD_XPPU_CTRL_EN_DEFVAL  0x0UL

/**
 * Register: XlpdXppuErrSts1
 */
#define XLPD_XPPU_ERR_STS1    ( ( XLPD_XPPU_BASEADDR ) + 0x00000004UL )
#define XLPD_XPPU_ERR_STS1_RSTVAL   0x00000000UL

#define XLPD_XPPU_ERR_STS1_AXI_ADDR_SHIFT   0UL
#define XLPD_XPPU_ERR_STS1_AXI_ADDR_WIDTH   32UL
#define XLPD_XPPU_ERR_STS1_AXI_ADDR_MASK    0xffffffffUL
#define XLPD_XPPU_ERR_STS1_AXI_ADDR_DEFVAL  0x0UL

/**
 * Register: XlpdXppuErrSts2
 */
#define XLPD_XPPU_ERR_STS2    ( ( XLPD_XPPU_BASEADDR ) + 0x00000008UL )
#define XLPD_XPPU_ERR_STS2_RSTVAL   0x00000000UL

#define XLPD_XPPU_ERR_STS2_AXI_ID_SHIFT   0UL
#define XLPD_XPPU_ERR_STS2_AXI_ID_WIDTH   10UL
#define XLPD_XPPU_ERR_STS2_AXI_ID_MASK    0x000003ffUL
#define XLPD_XPPU_ERR_STS2_AXI_ID_DEFVAL  0x0UL

/**
 * Register: XlpdXppuItr
 */
#define XLPD_XPPU_ITR    ( ( XLPD_XPPU_BASEADDR ) + 0x0000000CUL )
#define XLPD_XPPU_ITR_RSTVAL   0x00000000UL

#define XLPD_XPPU_ITR_APER_PARITY_SHIFT   7UL
#define XLPD_XPPU_ITR_APER_PARITY_WIDTH   1UL
#define XLPD_XPPU_ITR_APER_PARITY_MASK    0x00000080UL
#define XLPD_XPPU_ITR_APER_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_ITR_APER_TZ_SHIFT   6UL
#define XLPD_XPPU_ITR_APER_TZ_WIDTH   1UL
#define XLPD_XPPU_ITR_APER_TZ_MASK    0x00000040UL
#define XLPD_XPPU_ITR_APER_TZ_DEFVAL  0x0UL

#define XLPD_XPPU_ITR_APER_PERM_SHIFT   5UL
#define XLPD_XPPU_ITR_APER_PERM_WIDTH   1UL
#define XLPD_XPPU_ITR_APER_PERM_MASK    0x00000020UL
#define XLPD_XPPU_ITR_APER_PERM_DEFVAL  0x0UL

#define XLPD_XPPU_ITR_MID_PARITY_SHIFT   3UL
#define XLPD_XPPU_ITR_MID_PARITY_WIDTH   1UL
#define XLPD_XPPU_ITR_MID_PARITY_MASK    0x00000008UL
#define XLPD_XPPU_ITR_MID_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_ITR_MID_RO_SHIFT   2UL
#define XLPD_XPPU_ITR_MID_RO_WIDTH   1UL
#define XLPD_XPPU_ITR_MID_RO_MASK    0x00000004UL
#define XLPD_XPPU_ITR_MID_RO_DEFVAL  0x0UL

#define XLPD_XPPU_ITR_MID_MISS_SHIFT   1UL
#define XLPD_XPPU_ITR_MID_MISS_WIDTH   1UL
#define XLPD_XPPU_ITR_MID_MISS_MASK    0x00000002UL
#define XLPD_XPPU_ITR_MID_MISS_DEFVAL  0x0UL

#define XLPD_XPPU_ITR_INV_APB_SHIFT   0UL
#define XLPD_XPPU_ITR_INV_APB_WIDTH   1UL
#define XLPD_XPPU_ITR_INV_APB_MASK    0x00000001UL
#define XLPD_XPPU_ITR_INV_APB_DEFVAL  0x0UL

/**
 * Register: XlpdXppuIsr
 */
#define XLPD_XPPU_ISR    ( ( XLPD_XPPU_BASEADDR ) + 0x00000010UL )
#define XLPD_XPPU_ISR_RSTVAL   0x00000000UL

#define XLPD_XPPU_ISR_APER_PARITY_SHIFT   7UL
#define XLPD_XPPU_ISR_APER_PARITY_WIDTH   1UL
#define XLPD_XPPU_ISR_APER_PARITY_MASK    0x00000080UL
#define XLPD_XPPU_ISR_APER_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_ISR_APER_TZ_SHIFT   6UL
#define XLPD_XPPU_ISR_APER_TZ_WIDTH   1UL
#define XLPD_XPPU_ISR_APER_TZ_MASK    0x00000040UL
#define XLPD_XPPU_ISR_APER_TZ_DEFVAL  0x0UL

#define XLPD_XPPU_ISR_APER_PERM_SHIFT   5UL
#define XLPD_XPPU_ISR_APER_PERM_WIDTH   1UL
#define XLPD_XPPU_ISR_APER_PERM_MASK    0x00000020UL
#define XLPD_XPPU_ISR_APER_PERM_DEFVAL  0x0UL

#define XLPD_XPPU_ISR_MID_PARITY_SHIFT   3UL
#define XLPD_XPPU_ISR_MID_PARITY_WIDTH   1UL
#define XLPD_XPPU_ISR_MID_PARITY_MASK    0x00000008UL
#define XLPD_XPPU_ISR_MID_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_ISR_MID_RO_SHIFT   2UL
#define XLPD_XPPU_ISR_MID_RO_WIDTH   1UL
#define XLPD_XPPU_ISR_MID_RO_MASK    0x00000004UL
#define XLPD_XPPU_ISR_MID_RO_DEFVAL  0x0UL

#define XLPD_XPPU_ISR_MID_MISS_SHIFT   1UL
#define XLPD_XPPU_ISR_MID_MISS_WIDTH   1UL
#define XLPD_XPPU_ISR_MID_MISS_MASK    0x00000002UL
#define XLPD_XPPU_ISR_MID_MISS_DEFVAL  0x0UL

#define XLPD_XPPU_ISR_INV_APB_SHIFT   0UL
#define XLPD_XPPU_ISR_INV_APB_WIDTH   1UL
#define XLPD_XPPU_ISR_INV_APB_MASK    0x00000001UL
#define XLPD_XPPU_ISR_INV_APB_DEFVAL  0x0UL

/**
 * Register: XlpdXppuImr
 */
#define XLPD_XPPU_IMR    ( ( XLPD_XPPU_BASEADDR ) + 0x00000014UL )
#define XLPD_XPPU_IMR_RSTVAL   0x000000efUL

#define XLPD_XPPU_IMR_APER_PARITY_SHIFT   7UL
#define XLPD_XPPU_IMR_APER_PARITY_WIDTH   1UL
#define XLPD_XPPU_IMR_APER_PARITY_MASK    0x00000080UL
#define XLPD_XPPU_IMR_APER_PARITY_DEFVAL  0x1UL

#define XLPD_XPPU_IMR_APER_TZ_SHIFT   6UL
#define XLPD_XPPU_IMR_APER_TZ_WIDTH   1UL
#define XLPD_XPPU_IMR_APER_TZ_MASK    0x00000040UL
#define XLPD_XPPU_IMR_APER_TZ_DEFVAL  0x1UL

#define XLPD_XPPU_IMR_APER_PERM_SHIFT   5UL
#define XLPD_XPPU_IMR_APER_PERM_WIDTH   1UL
#define XLPD_XPPU_IMR_APER_PERM_MASK    0x00000020UL
#define XLPD_XPPU_IMR_APER_PERM_DEFVAL  0x1UL

#define XLPD_XPPU_IMR_MID_PARITY_SHIFT   3UL
#define XLPD_XPPU_IMR_MID_PARITY_WIDTH   1UL
#define XLPD_XPPU_IMR_MID_PARITY_MASK    0x00000008UL
#define XLPD_XPPU_IMR_MID_PARITY_DEFVAL  0x1UL

#define XLPD_XPPU_IMR_MID_RO_SHIFT   2UL
#define XLPD_XPPU_IMR_MID_RO_WIDTH   1UL
#define XLPD_XPPU_IMR_MID_RO_MASK    0x00000004UL
#define XLPD_XPPU_IMR_MID_RO_DEFVAL  0x1UL

#define XLPD_XPPU_IMR_MID_MISS_SHIFT   1UL
#define XLPD_XPPU_IMR_MID_MISS_WIDTH   1UL
#define XLPD_XPPU_IMR_MID_MISS_MASK    0x00000002UL
#define XLPD_XPPU_IMR_MID_MISS_DEFVAL  0x1UL

#define XLPD_XPPU_IMR_INV_APB_SHIFT   0UL
#define XLPD_XPPU_IMR_INV_APB_WIDTH   1UL
#define XLPD_XPPU_IMR_INV_APB_MASK    0x00000001UL
#define XLPD_XPPU_IMR_INV_APB_DEFVAL  0x1UL

/**
 * Register: XlpdXppuIen
 */
#define XLPD_XPPU_IEN    ( ( XLPD_XPPU_BASEADDR ) + 0x00000018UL )
#define XLPD_XPPU_IEN_RSTVAL   0x00000000UL

#define XLPD_XPPU_IEN_APER_PARITY_SHIFT   7UL
#define XLPD_XPPU_IEN_APER_PARITY_WIDTH   1UL
#define XLPD_XPPU_IEN_APER_PARITY_MASK    0x00000080UL
#define XLPD_XPPU_IEN_APER_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_IEN_APER_TZ_SHIFT   6UL
#define XLPD_XPPU_IEN_APER_TZ_WIDTH   1UL
#define XLPD_XPPU_IEN_APER_TZ_MASK    0x00000040UL
#define XLPD_XPPU_IEN_APER_TZ_DEFVAL  0x0UL

#define XLPD_XPPU_IEN_APER_PERM_SHIFT   5UL
#define XLPD_XPPU_IEN_APER_PERM_WIDTH   1UL
#define XLPD_XPPU_IEN_APER_PERM_MASK    0x00000020UL
#define XLPD_XPPU_IEN_APER_PERM_DEFVAL  0x0UL

#define XLPD_XPPU_IEN_MID_PARITY_SHIFT   3UL
#define XLPD_XPPU_IEN_MID_PARITY_WIDTH   1UL
#define XLPD_XPPU_IEN_MID_PARITY_MASK    0x00000008UL
#define XLPD_XPPU_IEN_MID_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_IEN_MID_RO_SHIFT   2UL
#define XLPD_XPPU_IEN_MID_RO_WIDTH   1UL
#define XLPD_XPPU_IEN_MID_RO_MASK    0x00000004UL
#define XLPD_XPPU_IEN_MID_RO_DEFVAL  0x0UL

#define XLPD_XPPU_IEN_MID_MISS_SHIFT   1UL
#define XLPD_XPPU_IEN_MID_MISS_WIDTH   1UL
#define XLPD_XPPU_IEN_MID_MISS_MASK    0x00000002UL
#define XLPD_XPPU_IEN_MID_MISS_DEFVAL  0x0UL

#define XLPD_XPPU_IEN_INV_APB_SHIFT   0UL
#define XLPD_XPPU_IEN_INV_APB_WIDTH   1UL
#define XLPD_XPPU_IEN_INV_APB_MASK    0x00000001UL
#define XLPD_XPPU_IEN_INV_APB_DEFVAL  0x0UL

/**
 * Register: XlpdXppuIds
 */
#define XLPD_XPPU_IDS    ( ( XLPD_XPPU_BASEADDR ) + 0x0000001CUL )
#define XLPD_XPPU_IDS_RSTVAL   0x00000000UL

#define XLPD_XPPU_IDS_APER_PARITY_SHIFT   7UL
#define XLPD_XPPU_IDS_APER_PARITY_WIDTH   1UL
#define XLPD_XPPU_IDS_APER_PARITY_MASK    0x00000080UL
#define XLPD_XPPU_IDS_APER_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_IDS_APER_TZ_SHIFT   6UL
#define XLPD_XPPU_IDS_APER_TZ_WIDTH   1UL
#define XLPD_XPPU_IDS_APER_TZ_MASK    0x00000040UL
#define XLPD_XPPU_IDS_APER_TZ_DEFVAL  0x0UL

#define XLPD_XPPU_IDS_APER_PERM_SHIFT   5UL
#define XLPD_XPPU_IDS_APER_PERM_WIDTH   1UL
#define XLPD_XPPU_IDS_APER_PERM_MASK    0x00000020UL
#define XLPD_XPPU_IDS_APER_PERM_DEFVAL  0x0UL

#define XLPD_XPPU_IDS_MID_PARITY_SHIFT   3UL
#define XLPD_XPPU_IDS_MID_PARITY_WIDTH   1UL
#define XLPD_XPPU_IDS_MID_PARITY_MASK    0x00000008UL
#define XLPD_XPPU_IDS_MID_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_IDS_MID_RO_SHIFT   2UL
#define XLPD_XPPU_IDS_MID_RO_WIDTH   1UL
#define XLPD_XPPU_IDS_MID_RO_MASK    0x00000004UL
#define XLPD_XPPU_IDS_MID_RO_DEFVAL  0x0UL

#define XLPD_XPPU_IDS_MID_MISS_SHIFT   1UL
#define XLPD_XPPU_IDS_MID_MISS_WIDTH   1UL
#define XLPD_XPPU_IDS_MID_MISS_MASK    0x00000002UL
#define XLPD_XPPU_IDS_MID_MISS_DEFVAL  0x0UL

#define XLPD_XPPU_IDS_INV_APB_SHIFT   0UL
#define XLPD_XPPU_IDS_INV_APB_WIDTH   1UL
#define XLPD_XPPU_IDS_INV_APB_MASK    0x00000001UL
#define XLPD_XPPU_IDS_INV_APB_DEFVAL  0x0UL

/**
 * Register: XlpdXppuLock
 */
#define XLPD_XPPU_LOCK    ( ( XLPD_XPPU_BASEADDR ) + 0x00000020UL )
#define XLPD_XPPU_LOCK_RSTVAL   0x00000000UL

#define XLPD_XPPU_LOCK_REGWRDIS_SHIFT   0UL
#define XLPD_XPPU_LOCK_REGWRDIS_WIDTH   1UL
#define XLPD_XPPU_LOCK_REGWRDIS_MASK    0x00000001UL
#define XLPD_XPPU_LOCK_REGWRDIS_DEFVAL  0x0UL

/**
 * Register: XlpdXppuMMasterIds
 */
#define XLPD_XPPU_M_MASTER_IDS    ( ( XLPD_XPPU_BASEADDR ) + 0x0000003CUL )
#define XLPD_XPPU_M_MASTER_IDS_RSTVAL   0x00000014UL

#define XLPD_XPPU_M_MASTER_IDS_NO_SHIFT   0UL
#define XLPD_XPPU_M_MASTER_IDS_NO_WIDTH   32UL
#define XLPD_XPPU_M_MASTER_IDS_NO_MASK    0xffffffffUL
#define XLPD_XPPU_M_MASTER_IDS_NO_DEFVAL  0x14UL

/**
 * Register: XlpdXppuMAperture64kb
 */
#define XLPD_XPPU_M_APERTURE_64KB    ( ( XLPD_XPPU_BASEADDR ) + 0x00000044UL )
#define XLPD_XPPU_M_APERTURE_64KB_RSTVAL   0x00000100UL

#define XLPD_XPPU_M_APERTURE_64KB_NO_SHIFT   0UL
#define XLPD_XPPU_M_APERTURE_64KB_NO_WIDTH   32UL
#define XLPD_XPPU_M_APERTURE_64KB_NO_MASK    0xffffffffUL
#define XLPD_XPPU_M_APERTURE_64KB_NO_DEFVAL  0x100UL

/**
 * Register: XlpdXppuMAperture1mb
 */
#define XLPD_XPPU_M_APERTURE_1MB    ( ( XLPD_XPPU_BASEADDR ) + 0x00000048UL )
#define XLPD_XPPU_M_APERTURE_1MB_RSTVAL   0x00000010UL

#define XLPD_XPPU_M_APERTURE_1MB_NO_SHIFT   0UL
#define XLPD_XPPU_M_APERTURE_1MB_NO_WIDTH   32UL
#define XLPD_XPPU_M_APERTURE_1MB_NO_MASK    0xffffffffUL
#define XLPD_XPPU_M_APERTURE_1MB_NO_DEFVAL  0x10UL

/**
 * Register: XlpdXppuMAperture512mb
 */
#define XLPD_XPPU_M_APERTURE_512MB    ( ( XLPD_XPPU_BASEADDR ) + 0x0000004CUL )
#define XLPD_XPPU_M_APERTURE_512MB_RSTVAL   0x00000001UL

#define XLPD_XPPU_M_APERTURE_512MB_NO_SHIFT   0UL
#define XLPD_XPPU_M_APERTURE_512MB_NO_WIDTH   32UL
#define XLPD_XPPU_M_APERTURE_512MB_NO_MASK    0xffffffffUL
#define XLPD_XPPU_M_APERTURE_512MB_NO_DEFVAL  0x1UL

/**
 * Register: XlpdXppuBase64kb
 */
#define XLPD_XPPU_BASE_64KB    ( ( XLPD_XPPU_BASEADDR ) + 0x00000054UL )
#define XLPD_XPPU_BASE_64KB_RSTVAL   0xff000000UL

#define XLPD_XPPU_BASE_64KB_ADDR_SHIFT   0UL
#define XLPD_XPPU_BASE_64KB_ADDR_WIDTH   32UL
#define XLPD_XPPU_BASE_64KB_ADDR_MASK    0xffffffffUL
#define XLPD_XPPU_BASE_64KB_ADDR_DEFVAL  0xff000000UL

/**
 * Register: XlpdXppuBase1mb
 */
#define XLPD_XPPU_BASE_1MB    ( ( XLPD_XPPU_BASEADDR ) + 0x00000058UL )
#define XLPD_XPPU_BASE_1MB_RSTVAL   0xfe000000UL

#define XLPD_XPPU_BASE_1MB_ADDR_SHIFT   0UL
#define XLPD_XPPU_BASE_1MB_ADDR_WIDTH   32UL
#define XLPD_XPPU_BASE_1MB_ADDR_MASK    0xffffffffUL
#define XLPD_XPPU_BASE_1MB_ADDR_DEFVAL  0xfe000000UL

/**
 * Register: XlpdXppuBase512mb
 */
#define XLPD_XPPU_BASE_512MB    ( ( XLPD_XPPU_BASEADDR ) + 0x0000005CUL )
#define XLPD_XPPU_BASE_512MB_RSTVAL   0xe0000000UL

#define XLPD_XPPU_BASE_512MB_ADDR_SHIFT   0UL
#define XLPD_XPPU_BASE_512MB_ADDR_WIDTH   32UL
#define XLPD_XPPU_BASE_512MB_ADDR_MASK    0xffffffffUL
#define XLPD_XPPU_BASE_512MB_ADDR_DEFVAL  0xe0000000UL

/**
 * Register: XlpdXppuMasterId00
 */
#define XLPD_XPPU_MASTER_ID00    ( ( XLPD_XPPU_BASEADDR ) + 0x00000100UL )
#define XLPD_XPPU_MASTER_ID00_RSTVAL   0x03ff0238UL

#define XLPD_XPPU_MASTER_ID00_MIDP_SHIFT   31UL
#define XLPD_XPPU_MASTER_ID00_MIDP_WIDTH   1UL
#define XLPD_XPPU_MASTER_ID00_MIDP_MASK    0x80000000UL
#define XLPD_XPPU_MASTER_ID00_MIDP_DEFVAL  0x0UL

#define XLPD_XPPU_MASTER_ID00_MIDR_SHIFT   30UL
#define XLPD_XPPU_MASTER_ID00_MIDR_WIDTH   1UL
#define XLPD_XPPU_MASTER_ID00_MIDR_MASK    0x40000000UL
#define XLPD_XPPU_MASTER_ID00_MIDR_DEFVAL  0x0UL

#define XLPD_XPPU_MASTER_ID00_MIDM_SHIFT   16UL
#define XLPD_XPPU_MASTER_ID00_MIDM_WIDTH   10UL
#define XLPD_XPPU_MASTER_ID00_MIDM_MASK    0x03ff0000UL
#define XLPD_XPPU_MASTER_ID00_MIDM_DEFVAL  0x3ffUL

#define XLPD_XPPU_MASTER_ID00_MID_SHIFT   0UL
#define XLPD_XPPU_MASTER_ID00_MID_WIDTH   10UL
#define XLPD_XPPU_MASTER_ID00_MID_MASK    0x000003ffUL
#define XLPD_XPPU_MASTER_ID00_MID_DEFVAL  0x238UL

/**
 * Register: XlpdXppuMasterId01
 */
#define XLPD_XPPU_MASTER_ID01    ( ( XLPD_XPPU_BASEADDR ) + 0x00000104UL )
#define XLPD_XPPU_MASTER_ID01_RSTVAL   0x83ff0200UL

#define XLPD_XPPU_MASTER_ID01_MIDP_SHIFT   31UL
#define XLPD_XPPU_MASTER_ID01_MIDP_WIDTH   1UL
#define XLPD_XPPU_MASTER_ID01_MIDP_MASK    0x80000000UL
#define XLPD_XPPU_MASTER_ID01_MIDP_DEFVAL  0x1UL

#define XLPD_XPPU_MASTER_ID01_MIDR_SHIFT   30UL
#define XLPD_XPPU_MASTER_ID01_MIDR_WIDTH   1UL
#define XLPD_XPPU_MASTER_ID01_MIDR_MASK    0x40000000UL
#define XLPD_XPPU_MASTER_ID01_MIDR_DEFVAL  0x0UL

#define XLPD_XPPU_MASTER_ID01_MIDM_SHIFT   16UL
#define XLPD_XPPU_MASTER_ID01_MIDM_WIDTH   10UL
#define XLPD_XPPU_MASTER_ID01_MIDM_MASK    0x03ff0000UL
#define XLPD_XPPU_MASTER_ID01_MIDM_DEFVAL  0x3ffUL

#define XLPD_XPPU_MASTER_ID01_MID_SHIFT   0UL
#define XLPD_XPPU_MASTER_ID01_MID_WIDTH   10UL
#define XLPD_XPPU_MASTER_ID01_MID_MASK    0x000003ffUL
#define XLPD_XPPU_MASTER_ID01_MID_DEFVAL  0x200UL

/**
 * Register: XlpdXppuMasterId02
 */
#define XLPD_XPPU_MASTER_ID02    ( ( XLPD_XPPU_BASEADDR ) + 0x00000108UL )
#define XLPD_XPPU_MASTER_ID02_RSTVAL   0x03ff0204UL

#define XLPD_XPPU_MASTER_ID02_MIDP_SHIFT   31UL
#define XLPD_XPPU_MASTER_ID02_MIDP_WIDTH   1UL
#define XLPD_XPPU_MASTER_ID02_MIDP_MASK    0x80000000UL
#define XLPD_XPPU_MASTER_ID02_MIDP_DEFVAL  0x0UL

#define XLPD_XPPU_MASTER_ID02_MIDR_SHIFT   30UL
#define XLPD_XPPU_MASTER_ID02_MIDR_WIDTH   1UL
#define XLPD_XPPU_MASTER_ID02_MIDR_MASK    0x40000000UL
#define XLPD_XPPU_MASTER_ID02_MIDR_DEFVAL  0x0UL

#define XLPD_XPPU_MASTER_ID02_MIDM_SHIFT   16UL
#define XLPD_XPPU_MASTER_ID02_MIDM_WIDTH   10UL
#define XLPD_XPPU_MASTER_ID02_MIDM_MASK    0x03ff0000UL
#define XLPD_XPPU_MASTER_ID02_MIDM_DEFVAL  0x3ffUL

#define XLPD_XPPU_MASTER_ID02_MID_SHIFT   0UL
#define XLPD_XPPU_MASTER_ID02_MID_WIDTH   10UL
#define XLPD_XPPU_MASTER_ID02_MID_MASK    0x000003ffUL
#define XLPD_XPPU_MASTER_ID02_MID_DEFVAL  0x204UL

/**
 * Register: XlpdXppuMasterId03
 */
#define XLPD_XPPU_MASTER_ID03    ( ( XLPD_XPPU_BASEADDR ) + 0x0000010CUL )
#define XLPD_XPPU_MASTER_ID03_RSTVAL   0x83f00260UL

#define XLPD_XPPU_MASTER_ID03_MIDP_SHIFT   31UL
#define XLPD_XPPU_MASTER_ID03_MIDP_WIDTH   1UL
#define XLPD_XPPU_MASTER_ID03_MIDP_MASK    0x80000000UL
#define XLPD_XPPU_MASTER_ID03_MIDP_DEFVAL  0x1UL

#define XLPD_XPPU_MASTER_ID03_MIDR_SHIFT   30UL
#define XLPD_XPPU_MASTER_ID03_MIDR_WIDTH   1UL
#define XLPD_XPPU_MASTER_ID03_MIDR_MASK    0x40000000UL
#define XLPD_XPPU_MASTER_ID03_MIDR_DEFVAL  0x0UL

#define XLPD_XPPU_MASTER_ID03_MIDM_SHIFT   16UL
#define XLPD_XPPU_MASTER_ID03_MIDM_WIDTH   10UL
#define XLPD_XPPU_MASTER_ID03_MIDM_MASK    0x03ff0000UL
#define XLPD_XPPU_MASTER_ID03_MIDM_DEFVAL  0x3f0UL

#define XLPD_XPPU_MASTER_ID03_MID_SHIFT   0UL
#define XLPD_XPPU_MASTER_ID03_MID_WIDTH   10UL
#define XLPD_XPPU_MASTER_ID03_MID_MASK    0x000003ffUL
#define XLPD_XPPU_MASTER_ID03_MID_DEFVAL  0x260UL

/**
 * Register: XlpdXppuMasterId04
 */
#define XLPD_XPPU_MASTER_ID04    ( ( XLPD_XPPU_BASEADDR ) + 0x00000110UL )
#define XLPD_XPPU_MASTER_ID04_RSTVAL   0x83ff0260UL

#define XLPD_XPPU_MASTER_ID04_MIDP_SHIFT   31UL
#define XLPD_XPPU_MASTER_ID04_MIDP_WIDTH   1UL
#define XLPD_XPPU_MASTER_ID04_MIDP_MASK    0x80000000UL
#define XLPD_XPPU_MASTER_ID04_MIDP_DEFVAL  0x1UL

#define XLPD_XPPU_MASTER_ID04_MIDR_SHIFT   30UL
#define XLPD_XPPU_MASTER_ID04_MIDR_WIDTH   1UL
#define XLPD_XPPU_MASTER_ID04_MIDR_MASK    0x40000000UL
#define XLPD_XPPU_MASTER_ID04_MIDR_DEFVAL  0x0UL

#define XLPD_XPPU_MASTER_ID04_MIDM_SHIFT   16UL
#define XLPD_XPPU_MASTER_ID04_MIDM_WIDTH   10UL
#define XLPD_XPPU_MASTER_ID04_MIDM_MASK    0x03ff0000UL
#define XLPD_XPPU_MASTER_ID04_MIDM_DEFVAL  0x3ffUL

#define XLPD_XPPU_MASTER_ID04_MID_SHIFT   0UL
#define XLPD_XPPU_MASTER_ID04_MID_WIDTH   10UL
#define XLPD_XPPU_MASTER_ID04_MID_MASK    0x000003ffUL
#define XLPD_XPPU_MASTER_ID04_MID_DEFVAL  0x260UL

/**
 * Register: XlpdXppuMasterId05
 */
#define XLPD_XPPU_MASTER_ID05    ( ( XLPD_XPPU_BASEADDR ) + 0x00000114UL )
#define XLPD_XPPU_MASTER_ID05_RSTVAL   0x03ff0261UL

#define XLPD_XPPU_MASTER_ID05_MIDP_SHIFT   31UL
#define XLPD_XPPU_MASTER_ID05_MIDP_WIDTH   1UL
#define XLPD_XPPU_MASTER_ID05_MIDP_MASK    0x80000000UL
#define XLPD_XPPU_MASTER_ID05_MIDP_DEFVAL  0x0UL

#define XLPD_XPPU_MASTER_ID05_MIDR_SHIFT   30UL
#define XLPD_XPPU_MASTER_ID05_MIDR_WIDTH   1UL
#define XLPD_XPPU_MASTER_ID05_MIDR_MASK    0x40000000UL
#define XLPD_XPPU_MASTER_ID05_MIDR_DEFVAL  0x0UL

#define XLPD_XPPU_MASTER_ID05_MIDM_SHIFT   16UL
#define XLPD_XPPU_MASTER_ID05_MIDM_WIDTH   10UL
#define XLPD_XPPU_MASTER_ID05_MIDM_MASK    0x03ff0000UL
#define XLPD_XPPU_MASTER_ID05_MIDM_DEFVAL  0x3ffUL

#define XLPD_XPPU_MASTER_ID05_MID_SHIFT   0UL
#define XLPD_XPPU_MASTER_ID05_MID_WIDTH   10UL
#define XLPD_XPPU_MASTER_ID05_MID_MASK    0x000003ffUL
#define XLPD_XPPU_MASTER_ID05_MID_DEFVAL  0x261UL

/**
 * Register: XlpdXppuMasterId06
 */
#define XLPD_XPPU_MASTER_ID06    ( ( XLPD_XPPU_BASEADDR ) + 0x00000118UL )
#define XLPD_XPPU_MASTER_ID06_RSTVAL   0x00000000UL

#define XLPD_XPPU_MASTER_ID06_MIDP_SHIFT   31UL
#define XLPD_XPPU_MASTER_ID06_MIDP_WIDTH   1UL
#define XLPD_XPPU_MASTER_ID06_MIDP_MASK    0x80000000UL
#define XLPD_XPPU_MASTER_ID06_MIDP_DEFVAL  0x0UL

#define XLPD_XPPU_MASTER_ID06_MIDR_SHIFT   30UL
#define XLPD_XPPU_MASTER_ID06_MIDR_WIDTH   1UL
#define XLPD_XPPU_MASTER_ID06_MIDR_MASK    0x40000000UL
#define XLPD_XPPU_MASTER_ID06_MIDR_DEFVAL  0x0UL

#define XLPD_XPPU_MASTER_ID06_MIDM_SHIFT   16UL
#define XLPD_XPPU_MASTER_ID06_MIDM_WIDTH   10UL
#define XLPD_XPPU_MASTER_ID06_MIDM_MASK    0x03ff0000UL
#define XLPD_XPPU_MASTER_ID06_MIDM_DEFVAL  0x0UL

#define XLPD_XPPU_MASTER_ID06_MID_SHIFT   0UL
#define XLPD_XPPU_MASTER_ID06_MID_WIDTH   10UL
#define XLPD_XPPU_MASTER_ID06_MID_MASK    0x000003ffUL
#define XLPD_XPPU_MASTER_ID06_MID_DEFVAL  0x0UL

/**
 * Register: XlpdXppuMasterId07
 */
#define XLPD_XPPU_MASTER_ID07    ( ( XLPD_XPPU_BASEADDR ) + 0x0000011CUL )
#define XLPD_XPPU_MASTER_ID07_RSTVAL   0x00000000UL

#define XLPD_XPPU_MASTER_ID07_MIDP_SHIFT   31UL
#define XLPD_XPPU_MASTER_ID07_MIDP_WIDTH   1UL
#define XLPD_XPPU_MASTER_ID07_MIDP_MASK    0x80000000UL
#define XLPD_XPPU_MASTER_ID07_MIDP_DEFVAL  0x0UL

#define XLPD_XPPU_MASTER_ID07_MIDR_SHIFT   30UL
#define XLPD_XPPU_MASTER_ID07_MIDR_WIDTH   1UL
#define XLPD_XPPU_MASTER_ID07_MIDR_MASK    0x40000000UL
#define XLPD_XPPU_MASTER_ID07_MIDR_DEFVAL  0x0UL

#define XLPD_XPPU_MASTER_ID07_MIDM_SHIFT   16UL
#define XLPD_XPPU_MASTER_ID07_MIDM_WIDTH   10UL
#define XLPD_XPPU_MASTER_ID07_MIDM_MASK    0x03ff0000UL
#define XLPD_XPPU_MASTER_ID07_MIDM_DEFVAL  0x0UL

#define XLPD_XPPU_MASTER_ID07_MID_SHIFT   0UL
#define XLPD_XPPU_MASTER_ID07_MID_WIDTH   10UL
#define XLPD_XPPU_MASTER_ID07_MID_MASK    0x000003ffUL
#define XLPD_XPPU_MASTER_ID07_MID_DEFVAL  0x0UL

/**
 * Register: XlpdXppuMasterId08
 */
#define XLPD_XPPU_MASTER_ID08    ( ( XLPD_XPPU_BASEADDR ) + 0x00000120UL )
#define XLPD_XPPU_MASTER_ID08_RSTVAL   0x83ff0247UL

#define XLPD_XPPU_MASTER_ID08_MIDP_SHIFT   31UL
#define XLPD_XPPU_MASTER_ID08_MIDP_WIDTH   1UL
#define XLPD_XPPU_MASTER_ID08_MIDP_MASK    0x80000000UL
#define XLPD_XPPU_MASTER_ID08_MIDP_DEFVAL  0x1UL

#define XLPD_XPPU_MASTER_ID08_MIDR_SHIFT   30UL
#define XLPD_XPPU_MASTER_ID08_MIDR_WIDTH   1UL
#define XLPD_XPPU_MASTER_ID08_MIDR_MASK    0x40000000UL
#define XLPD_XPPU_MASTER_ID08_MIDR_DEFVAL  0x0UL

#define XLPD_XPPU_MASTER_ID08_MIDM_SHIFT   16UL
#define XLPD_XPPU_MASTER_ID08_MIDM_WIDTH   10UL
#define XLPD_XPPU_MASTER_ID08_MIDM_MASK    0x03ff0000UL
#define XLPD_XPPU_MASTER_ID08_MIDM_DEFVAL  0x3ffUL

#define XLPD_XPPU_MASTER_ID08_MID_SHIFT   0UL
#define XLPD_XPPU_MASTER_ID08_MID_WIDTH   10UL
#define XLPD_XPPU_MASTER_ID08_MID_MASK    0x000003ffUL
#define XLPD_XPPU_MASTER_ID08_MID_DEFVAL  0x247UL

/**
 * Register: XlpdXppuMasterId09
 */
#define XLPD_XPPU_MASTER_ID09    ( ( XLPD_XPPU_BASEADDR ) + 0x00000124UL )
#define XLPD_XPPU_MASTER_ID09_RSTVAL   0x00000000UL

#define XLPD_XPPU_MASTER_ID09_MIDP_SHIFT   31UL
#define XLPD_XPPU_MASTER_ID09_MIDP_WIDTH   1UL
#define XLPD_XPPU_MASTER_ID09_MIDP_MASK    0x80000000UL
#define XLPD_XPPU_MASTER_ID09_MIDP_DEFVAL  0x0UL

#define XLPD_XPPU_MASTER_ID09_MIDR_SHIFT   30UL
#define XLPD_XPPU_MASTER_ID09_MIDR_WIDTH   1UL
#define XLPD_XPPU_MASTER_ID09_MIDR_MASK    0x40000000UL
#define XLPD_XPPU_MASTER_ID09_MIDR_DEFVAL  0x0UL

#define XLPD_XPPU_MASTER_ID09_MIDM_SHIFT   16UL
#define XLPD_XPPU_MASTER_ID09_MIDM_WIDTH   10UL
#define XLPD_XPPU_MASTER_ID09_MIDM_MASK    0x03ff0000UL
#define XLPD_XPPU_MASTER_ID09_MIDM_DEFVAL  0x0UL

#define XLPD_XPPU_MASTER_ID09_MID_SHIFT   0UL
#define XLPD_XPPU_MASTER_ID09_MID_WIDTH   10UL
#define XLPD_XPPU_MASTER_ID09_MID_MASK    0x000003ffUL
#define XLPD_XPPU_MASTER_ID09_MID_DEFVAL  0x0UL

/**
 * Register: XlpdXppuMasterId10
 */
#define XLPD_XPPU_MASTER_ID10    ( ( XLPD_XPPU_BASEADDR ) + 0x00000128UL )
#define XLPD_XPPU_MASTER_ID10_RSTVAL   0x00000000UL

#define XLPD_XPPU_MASTER_ID10_MIDP_SHIFT   31UL
#define XLPD_XPPU_MASTER_ID10_MIDP_WIDTH   1UL
#define XLPD_XPPU_MASTER_ID10_MIDP_MASK    0x80000000UL
#define XLPD_XPPU_MASTER_ID10_MIDP_DEFVAL  0x0UL

#define XLPD_XPPU_MASTER_ID10_MIDR_SHIFT   30UL
#define XLPD_XPPU_MASTER_ID10_MIDR_WIDTH   1UL
#define XLPD_XPPU_MASTER_ID10_MIDR_MASK    0x40000000UL
#define XLPD_XPPU_MASTER_ID10_MIDR_DEFVAL  0x0UL

#define XLPD_XPPU_MASTER_ID10_MIDM_SHIFT   16UL
#define XLPD_XPPU_MASTER_ID10_MIDM_WIDTH   10UL
#define XLPD_XPPU_MASTER_ID10_MIDM_MASK    0x03ff0000UL
#define XLPD_XPPU_MASTER_ID10_MIDM_DEFVAL  0x0UL

#define XLPD_XPPU_MASTER_ID10_MID_SHIFT   0UL
#define XLPD_XPPU_MASTER_ID10_MID_WIDTH   10UL
#define XLPD_XPPU_MASTER_ID10_MID_MASK    0x000003ffUL
#define XLPD_XPPU_MASTER_ID10_MID_DEFVAL  0x0UL

/**
 * Register: XlpdXppuMasterId11
 */
#define XLPD_XPPU_MASTER_ID11    ( ( XLPD_XPPU_BASEADDR ) + 0x0000012CUL )
#define XLPD_XPPU_MASTER_ID11_RSTVAL   0x00000000UL

#define XLPD_XPPU_MASTER_ID11_MIDP_SHIFT   31UL
#define XLPD_XPPU_MASTER_ID11_MIDP_WIDTH   1UL
#define XLPD_XPPU_MASTER_ID11_MIDP_MASK    0x80000000UL
#define XLPD_XPPU_MASTER_ID11_MIDP_DEFVAL  0x0UL

#define XLPD_XPPU_MASTER_ID11_MIDR_SHIFT   30UL
#define XLPD_XPPU_MASTER_ID11_MIDR_WIDTH   1UL
#define XLPD_XPPU_MASTER_ID11_MIDR_MASK    0x40000000UL
#define XLPD_XPPU_MASTER_ID11_MIDR_DEFVAL  0x0UL

#define XLPD_XPPU_MASTER_ID11_MIDM_SHIFT   16UL
#define XLPD_XPPU_MASTER_ID11_MIDM_WIDTH   10UL
#define XLPD_XPPU_MASTER_ID11_MIDM_MASK    0x03ff0000UL
#define XLPD_XPPU_MASTER_ID11_MIDM_DEFVAL  0x0UL

#define XLPD_XPPU_MASTER_ID11_MID_SHIFT   0UL
#define XLPD_XPPU_MASTER_ID11_MID_WIDTH   10UL
#define XLPD_XPPU_MASTER_ID11_MID_MASK    0x000003ffUL
#define XLPD_XPPU_MASTER_ID11_MID_DEFVAL  0x0UL

/**
 * Register: XlpdXppuMasterId12
 */
#define XLPD_XPPU_MASTER_ID12    ( ( XLPD_XPPU_BASEADDR ) + 0x00000130UL )
#define XLPD_XPPU_MASTER_ID12_RSTVAL   0x00000000UL

#define XLPD_XPPU_MASTER_ID12_MIDP_SHIFT   31UL
#define XLPD_XPPU_MASTER_ID12_MIDP_WIDTH   1UL
#define XLPD_XPPU_MASTER_ID12_MIDP_MASK    0x80000000UL
#define XLPD_XPPU_MASTER_ID12_MIDP_DEFVAL  0x0UL

#define XLPD_XPPU_MASTER_ID12_MIDR_SHIFT   30UL
#define XLPD_XPPU_MASTER_ID12_MIDR_WIDTH   1UL
#define XLPD_XPPU_MASTER_ID12_MIDR_MASK    0x40000000UL
#define XLPD_XPPU_MASTER_ID12_MIDR_DEFVAL  0x0UL

#define XLPD_XPPU_MASTER_ID12_MIDM_SHIFT   16UL
#define XLPD_XPPU_MASTER_ID12_MIDM_WIDTH   10UL
#define XLPD_XPPU_MASTER_ID12_MIDM_MASK    0x03ff0000UL
#define XLPD_XPPU_MASTER_ID12_MIDM_DEFVAL  0x0UL

#define XLPD_XPPU_MASTER_ID12_MID_SHIFT   0UL
#define XLPD_XPPU_MASTER_ID12_MID_WIDTH   10UL
#define XLPD_XPPU_MASTER_ID12_MID_MASK    0x000003ffUL
#define XLPD_XPPU_MASTER_ID12_MID_DEFVAL  0x0UL

/**
 * Register: XlpdXppuMasterId13
 */
#define XLPD_XPPU_MASTER_ID13    ( ( XLPD_XPPU_BASEADDR ) + 0x00000134UL )
#define XLPD_XPPU_MASTER_ID13_RSTVAL   0x00000000UL

#define XLPD_XPPU_MASTER_ID13_MIDP_SHIFT   31UL
#define XLPD_XPPU_MASTER_ID13_MIDP_WIDTH   1UL
#define XLPD_XPPU_MASTER_ID13_MIDP_MASK    0x80000000UL
#define XLPD_XPPU_MASTER_ID13_MIDP_DEFVAL  0x0UL

#define XLPD_XPPU_MASTER_ID13_MIDR_SHIFT   30UL
#define XLPD_XPPU_MASTER_ID13_MIDR_WIDTH   1UL
#define XLPD_XPPU_MASTER_ID13_MIDR_MASK    0x40000000UL
#define XLPD_XPPU_MASTER_ID13_MIDR_DEFVAL  0x0UL

#define XLPD_XPPU_MASTER_ID13_MIDM_SHIFT   16UL
#define XLPD_XPPU_MASTER_ID13_MIDM_WIDTH   10UL
#define XLPD_XPPU_MASTER_ID13_MIDM_MASK    0x03ff0000UL
#define XLPD_XPPU_MASTER_ID13_MIDM_DEFVAL  0x0UL

#define XLPD_XPPU_MASTER_ID13_MID_SHIFT   0UL
#define XLPD_XPPU_MASTER_ID13_MID_WIDTH   10UL
#define XLPD_XPPU_MASTER_ID13_MID_MASK    0x000003ffUL
#define XLPD_XPPU_MASTER_ID13_MID_DEFVAL  0x0UL

/**
 * Register: XlpdXppuMasterId14
 */
#define XLPD_XPPU_MASTER_ID14    ( ( XLPD_XPPU_BASEADDR ) + 0x00000138UL )
#define XLPD_XPPU_MASTER_ID14_RSTVAL   0x00000000UL

#define XLPD_XPPU_MASTER_ID14_MIDP_SHIFT   31UL
#define XLPD_XPPU_MASTER_ID14_MIDP_WIDTH   1UL
#define XLPD_XPPU_MASTER_ID14_MIDP_MASK    0x80000000UL
#define XLPD_XPPU_MASTER_ID14_MIDP_DEFVAL  0x0UL

#define XLPD_XPPU_MASTER_ID14_MIDR_SHIFT   30UL
#define XLPD_XPPU_MASTER_ID14_MIDR_WIDTH   1UL
#define XLPD_XPPU_MASTER_ID14_MIDR_MASK    0x40000000UL
#define XLPD_XPPU_MASTER_ID14_MIDR_DEFVAL  0x0UL

#define XLPD_XPPU_MASTER_ID14_MIDM_SHIFT   16UL
#define XLPD_XPPU_MASTER_ID14_MIDM_WIDTH   10UL
#define XLPD_XPPU_MASTER_ID14_MIDM_MASK    0x03ff0000UL
#define XLPD_XPPU_MASTER_ID14_MIDM_DEFVAL  0x0UL

#define XLPD_XPPU_MASTER_ID14_MID_SHIFT   0UL
#define XLPD_XPPU_MASTER_ID14_MID_WIDTH   10UL
#define XLPD_XPPU_MASTER_ID14_MID_MASK    0x000003ffUL
#define XLPD_XPPU_MASTER_ID14_MID_DEFVAL  0x0UL

/**
 * Register: XlpdXppuMasterId15
 */
#define XLPD_XPPU_MASTER_ID15    ( ( XLPD_XPPU_BASEADDR ) + 0x0000013CUL )
#define XLPD_XPPU_MASTER_ID15_RSTVAL   0x00000000UL

#define XLPD_XPPU_MASTER_ID15_MIDP_SHIFT   31UL
#define XLPD_XPPU_MASTER_ID15_MIDP_WIDTH   1UL
#define XLPD_XPPU_MASTER_ID15_MIDP_MASK    0x80000000UL
#define XLPD_XPPU_MASTER_ID15_MIDP_DEFVAL  0x0UL

#define XLPD_XPPU_MASTER_ID15_MIDR_SHIFT   30UL
#define XLPD_XPPU_MASTER_ID15_MIDR_WIDTH   1UL
#define XLPD_XPPU_MASTER_ID15_MIDR_MASK    0x40000000UL
#define XLPD_XPPU_MASTER_ID15_MIDR_DEFVAL  0x0UL

#define XLPD_XPPU_MASTER_ID15_MIDM_SHIFT   16UL
#define XLPD_XPPU_MASTER_ID15_MIDM_WIDTH   10UL
#define XLPD_XPPU_MASTER_ID15_MIDM_MASK    0x03ff0000UL
#define XLPD_XPPU_MASTER_ID15_MIDM_DEFVAL  0x0UL

#define XLPD_XPPU_MASTER_ID15_MID_SHIFT   0UL
#define XLPD_XPPU_MASTER_ID15_MID_WIDTH   10UL
#define XLPD_XPPU_MASTER_ID15_MID_MASK    0x000003ffUL
#define XLPD_XPPU_MASTER_ID15_MID_DEFVAL  0x0UL

/**
 * Register: XlpdXppuMasterId16
 */
#define XLPD_XPPU_MASTER_ID16    ( ( XLPD_XPPU_BASEADDR ) + 0x00000140UL )
#define XLPD_XPPU_MASTER_ID16_RSTVAL   0x00000000UL

#define XLPD_XPPU_MASTER_ID16_MIDP_SHIFT   31UL
#define XLPD_XPPU_MASTER_ID16_MIDP_WIDTH   1UL
#define XLPD_XPPU_MASTER_ID16_MIDP_MASK    0x80000000UL
#define XLPD_XPPU_MASTER_ID16_MIDP_DEFVAL  0x0UL

#define XLPD_XPPU_MASTER_ID16_MIDR_SHIFT   30UL
#define XLPD_XPPU_MASTER_ID16_MIDR_WIDTH   1UL
#define XLPD_XPPU_MASTER_ID16_MIDR_MASK    0x40000000UL
#define XLPD_XPPU_MASTER_ID16_MIDR_DEFVAL  0x0UL

#define XLPD_XPPU_MASTER_ID16_MIDM_SHIFT   16UL
#define XLPD_XPPU_MASTER_ID16_MIDM_WIDTH   10UL
#define XLPD_XPPU_MASTER_ID16_MIDM_MASK    0x03ff0000UL
#define XLPD_XPPU_MASTER_ID16_MIDM_DEFVAL  0x0UL

#define XLPD_XPPU_MASTER_ID16_MID_SHIFT   0UL
#define XLPD_XPPU_MASTER_ID16_MID_WIDTH   10UL
#define XLPD_XPPU_MASTER_ID16_MID_MASK    0x000003ffUL
#define XLPD_XPPU_MASTER_ID16_MID_DEFVAL  0x0UL

/**
 * Register: XlpdXppuMasterId17
 */
#define XLPD_XPPU_MASTER_ID17    ( ( XLPD_XPPU_BASEADDR ) + 0x00000144UL )
#define XLPD_XPPU_MASTER_ID17_RSTVAL   0x00000000UL

#define XLPD_XPPU_MASTER_ID17_MIDP_SHIFT   31UL
#define XLPD_XPPU_MASTER_ID17_MIDP_WIDTH   1UL
#define XLPD_XPPU_MASTER_ID17_MIDP_MASK    0x80000000UL
#define XLPD_XPPU_MASTER_ID17_MIDP_DEFVAL  0x0UL

#define XLPD_XPPU_MASTER_ID17_MIDR_SHIFT   30UL
#define XLPD_XPPU_MASTER_ID17_MIDR_WIDTH   1UL
#define XLPD_XPPU_MASTER_ID17_MIDR_MASK    0x40000000UL
#define XLPD_XPPU_MASTER_ID17_MIDR_DEFVAL  0x0UL

#define XLPD_XPPU_MASTER_ID17_MIDM_SHIFT   16UL
#define XLPD_XPPU_MASTER_ID17_MIDM_WIDTH   10UL
#define XLPD_XPPU_MASTER_ID17_MIDM_MASK    0x03ff0000UL
#define XLPD_XPPU_MASTER_ID17_MIDM_DEFVAL  0x0UL

#define XLPD_XPPU_MASTER_ID17_MID_SHIFT   0UL
#define XLPD_XPPU_MASTER_ID17_MID_WIDTH   10UL
#define XLPD_XPPU_MASTER_ID17_MID_MASK    0x000003ffUL
#define XLPD_XPPU_MASTER_ID17_MID_DEFVAL  0x0UL

/**
 * Register: XlpdXppuMasterId18
 */
#define XLPD_XPPU_MASTER_ID18    ( ( XLPD_XPPU_BASEADDR ) + 0x00000148UL )
#define XLPD_XPPU_MASTER_ID18_RSTVAL   0x00000000UL

#define XLPD_XPPU_MASTER_ID18_MIDP_SHIFT   31UL
#define XLPD_XPPU_MASTER_ID18_MIDP_WIDTH   1UL
#define XLPD_XPPU_MASTER_ID18_MIDP_MASK    0x80000000UL
#define XLPD_XPPU_MASTER_ID18_MIDP_DEFVAL  0x0UL

#define XLPD_XPPU_MASTER_ID18_MIDR_SHIFT   30UL
#define XLPD_XPPU_MASTER_ID18_MIDR_WIDTH   1UL
#define XLPD_XPPU_MASTER_ID18_MIDR_MASK    0x40000000UL
#define XLPD_XPPU_MASTER_ID18_MIDR_DEFVAL  0x0UL

#define XLPD_XPPU_MASTER_ID18_MIDM_SHIFT   16UL
#define XLPD_XPPU_MASTER_ID18_MIDM_WIDTH   10UL
#define XLPD_XPPU_MASTER_ID18_MIDM_MASK    0x03ff0000UL
#define XLPD_XPPU_MASTER_ID18_MIDM_DEFVAL  0x0UL

#define XLPD_XPPU_MASTER_ID18_MID_SHIFT   0UL
#define XLPD_XPPU_MASTER_ID18_MID_WIDTH   10UL
#define XLPD_XPPU_MASTER_ID18_MID_MASK    0x000003ffUL
#define XLPD_XPPU_MASTER_ID18_MID_DEFVAL  0x0UL

/**
 * Register: XlpdXppuMasterId19
 */
#define XLPD_XPPU_MASTER_ID19    ( ( XLPD_XPPU_BASEADDR ) + 0x0000014CUL )
#define XLPD_XPPU_MASTER_ID19_RSTVAL   0x00000000UL

#define XLPD_XPPU_MASTER_ID19_MIDP_SHIFT   31UL
#define XLPD_XPPU_MASTER_ID19_MIDP_WIDTH   1UL
#define XLPD_XPPU_MASTER_ID19_MIDP_MASK    0x80000000UL
#define XLPD_XPPU_MASTER_ID19_MIDP_DEFVAL  0x0UL

#define XLPD_XPPU_MASTER_ID19_MIDR_SHIFT   30UL
#define XLPD_XPPU_MASTER_ID19_MIDR_WIDTH   1UL
#define XLPD_XPPU_MASTER_ID19_MIDR_MASK    0x40000000UL
#define XLPD_XPPU_MASTER_ID19_MIDR_DEFVAL  0x0UL

#define XLPD_XPPU_MASTER_ID19_MIDM_SHIFT   16UL
#define XLPD_XPPU_MASTER_ID19_MIDM_WIDTH   10UL
#define XLPD_XPPU_MASTER_ID19_MIDM_MASK    0x03ff0000UL
#define XLPD_XPPU_MASTER_ID19_MIDM_DEFVAL  0x0UL

#define XLPD_XPPU_MASTER_ID19_MID_SHIFT   0UL
#define XLPD_XPPU_MASTER_ID19_MID_WIDTH   10UL
#define XLPD_XPPU_MASTER_ID19_MID_MASK    0x000003ffUL
#define XLPD_XPPU_MASTER_ID19_MID_DEFVAL  0x0UL

/**
 * Register: XlpdXppuEnPermCheckReg00
 */
#define XLPD_XPPU_EN_PERM_CHECK_REG00    ( ( XLPD_XPPU_BASEADDR ) + 0x00000150UL )
#define XLPD_XPPU_EN_PERM_CHECK_REG00_RSTVAL   0xffffffffUL

#define XLPD_XPPU_EN_PERM_CHECK_REG00_SHIFT   0UL
#define XLPD_XPPU_EN_PERM_CHECK_REG00_WIDTH   32UL
#define XLPD_XPPU_EN_PERM_CHECK_REG00_MASK    0xffffffffUL
#define XLPD_XPPU_EN_PERM_CHECK_REG00_DEFVAL  0xffffffffUL

/**
 * Register: XlpdXppuEnPermCheckReg01
 */
#define XLPD_XPPU_EN_PERM_CHECK_REG01    ( ( XLPD_XPPU_BASEADDR ) + 0x00000154UL )
#define XLPD_XPPU_EN_PERM_CHECK_REG01_RSTVAL   0xffffffffUL

#define XLPD_XPPU_EN_PERM_CHECK_REG01_SHIFT   0UL
#define XLPD_XPPU_EN_PERM_CHECK_REG01_WIDTH   32UL
#define XLPD_XPPU_EN_PERM_CHECK_REG01_MASK    0xffffffffUL
#define XLPD_XPPU_EN_PERM_CHECK_REG01_DEFVAL  0xffffffffUL

/**
 * Register: XlpdXppuEnPermCheckReg02
 */
#define XLPD_XPPU_EN_PERM_CHECK_REG02    ( ( XLPD_XPPU_BASEADDR ) + 0x00000158UL )
#define XLPD_XPPU_EN_PERM_CHECK_REG02_RSTVAL   0xffffffffUL

#define XLPD_XPPU_EN_PERM_CHECK_REG02_SHIFT   0UL
#define XLPD_XPPU_EN_PERM_CHECK_REG02_WIDTH   32UL
#define XLPD_XPPU_EN_PERM_CHECK_REG02_MASK    0xffffffffUL
#define XLPD_XPPU_EN_PERM_CHECK_REG02_DEFVAL  0xffffffffUL

/**
 * Register: XlpdXppuEnPermCheckReg03
 */
#define XLPD_XPPU_EN_PERM_CHECK_REG03    ( ( XLPD_XPPU_BASEADDR ) + 0x0000015CUL )
#define XLPD_XPPU_EN_PERM_CHECK_REG03_RSTVAL   0xffffffffUL

#define XLPD_XPPU_EN_PERM_CHECK_REG03_SHIFT   0UL
#define XLPD_XPPU_EN_PERM_CHECK_REG03_WIDTH   32UL
#define XLPD_XPPU_EN_PERM_CHECK_REG03_MASK    0xffffffffUL
#define XLPD_XPPU_EN_PERM_CHECK_REG03_DEFVAL  0xffffffffUL

/**
 * Register: XlpdXppuEnPermCheckReg04
 */
#define XLPD_XPPU_EN_PERM_CHECK_REG04    ( ( XLPD_XPPU_BASEADDR ) + 0x00000160UL )
#define XLPD_XPPU_EN_PERM_CHECK_REG04_RSTVAL   0xffffffffUL

#define XLPD_XPPU_EN_PERM_CHECK_REG04_SHIFT   0UL
#define XLPD_XPPU_EN_PERM_CHECK_REG04_WIDTH   32UL
#define XLPD_XPPU_EN_PERM_CHECK_REG04_MASK    0xffffffffUL
#define XLPD_XPPU_EN_PERM_CHECK_REG04_DEFVAL  0xffffffffUL

/**
 * Register: XlpdXppuEnPermCheckReg05
 */
#define XLPD_XPPU_EN_PERM_CHECK_REG05    ( ( XLPD_XPPU_BASEADDR ) + 0x00000164UL )
#define XLPD_XPPU_EN_PERM_CHECK_REG05_RSTVAL   0xffffffffUL

#define XLPD_XPPU_EN_PERM_CHECK_REG05_SHIFT   0UL
#define XLPD_XPPU_EN_PERM_CHECK_REG05_WIDTH   32UL
#define XLPD_XPPU_EN_PERM_CHECK_REG05_MASK    0xffffffffUL
#define XLPD_XPPU_EN_PERM_CHECK_REG05_DEFVAL  0xffffffffUL

/**
 * Register: XlpdXppuEnPermCheckReg06
 */
#define XLPD_XPPU_EN_PERM_CHECK_REG06    ( ( XLPD_XPPU_BASEADDR ) + 0x00000168UL )
#define XLPD_XPPU_EN_PERM_CHECK_REG06_RSTVAL   0xffffffffUL

#define XLPD_XPPU_EN_PERM_CHECK_REG06_SHIFT   0UL
#define XLPD_XPPU_EN_PERM_CHECK_REG06_WIDTH   32UL
#define XLPD_XPPU_EN_PERM_CHECK_REG06_MASK    0xffffffffUL
#define XLPD_XPPU_EN_PERM_CHECK_REG06_DEFVAL  0xffffffffUL

/**
 * Register: XlpdXppuEnPermCheckReg07
 */
#define XLPD_XPPU_EN_PERM_CHECK_REG07    ( ( XLPD_XPPU_BASEADDR ) + 0x0000016CUL )
#define XLPD_XPPU_EN_PERM_CHECK_REG07_RSTVAL   0xffffffffUL

#define XLPD_XPPU_EN_PERM_CHECK_REG07_SHIFT   0UL
#define XLPD_XPPU_EN_PERM_CHECK_REG07_WIDTH   32UL
#define XLPD_XPPU_EN_PERM_CHECK_REG07_MASK    0xffffffffUL
#define XLPD_XPPU_EN_PERM_CHECK_REG07_DEFVAL  0xffffffffUL

/**
 * Register: XlpdXppuEnPermCheckReg08
 */
#define XLPD_XPPU_EN_PERM_CHECK_REG08    ( ( XLPD_XPPU_BASEADDR ) + 0x00000170UL )
#define XLPD_XPPU_EN_PERM_CHECK_REG08_RSTVAL   0xffffffffUL

#define XLPD_XPPU_EN_PERM_CHECK_REG08_SHIFT   0UL
#define XLPD_XPPU_EN_PERM_CHECK_REG08_WIDTH   32UL
#define XLPD_XPPU_EN_PERM_CHECK_REG08_MASK    0xffffffffUL
#define XLPD_XPPU_EN_PERM_CHECK_REG08_DEFVAL  0xffffffffUL

/**
 * Register: XlpdXppuEnPermCheckReg09
 */
#define XLPD_XPPU_EN_PERM_CHECK_REG09    ( ( XLPD_XPPU_BASEADDR ) + 0x00000174UL )
#define XLPD_XPPU_EN_PERM_CHECK_REG09_RSTVAL   0xffffffffUL

#define XLPD_XPPU_EN_PERM_CHECK_REG09_SHIFT   0UL
#define XLPD_XPPU_EN_PERM_CHECK_REG09_WIDTH   32UL
#define XLPD_XPPU_EN_PERM_CHECK_REG09_MASK    0xffffffffUL
#define XLPD_XPPU_EN_PERM_CHECK_REG09_DEFVAL  0xffffffffUL

/**
 * Register: XlpdXppuEnPermCheckReg10
 */
#define XLPD_XPPU_EN_PERM_CHECK_REG10    ( ( XLPD_XPPU_BASEADDR ) + 0x00000178UL )
#define XLPD_XPPU_EN_PERM_CHECK_REG10_RSTVAL   0xffffffffUL

#define XLPD_XPPU_EN_PERM_CHECK_REG10_SHIFT   0UL
#define XLPD_XPPU_EN_PERM_CHECK_REG10_WIDTH   32UL
#define XLPD_XPPU_EN_PERM_CHECK_REG10_MASK    0xffffffffUL
#define XLPD_XPPU_EN_PERM_CHECK_REG10_DEFVAL  0xffffffffUL

/**
 * Register: XlpdXppuEnPermCheckReg11
 */
#define XLPD_XPPU_EN_PERM_CHECK_REG11    ( ( XLPD_XPPU_BASEADDR ) + 0x0000017CUL )
#define XLPD_XPPU_EN_PERM_CHECK_REG11_RSTVAL   0xffffffffUL

#define XLPD_XPPU_EN_PERM_CHECK_REG11_SHIFT   0UL
#define XLPD_XPPU_EN_PERM_CHECK_REG11_WIDTH   32UL
#define XLPD_XPPU_EN_PERM_CHECK_REG11_MASK    0xffffffffUL
#define XLPD_XPPU_EN_PERM_CHECK_REG11_DEFVAL  0xffffffffUL

/**
 * Register: XlpdXppuEnPermCheckReg12
 */
#define XLPD_XPPU_EN_PERM_CHECK_REG12    ( ( XLPD_XPPU_BASEADDR ) + 0x00000180UL )
#define XLPD_XPPU_EN_PERM_CHECK_REG12_RSTVAL   0x000fffffUL

#define XLPD_XPPU_EN_PERM_CHECK_REG12_SHIFT   0UL
#define XLPD_XPPU_EN_PERM_CHECK_REG12_WIDTH   20UL
#define XLPD_XPPU_EN_PERM_CHECK_REG12_MASK    0x000fffffUL
#define XLPD_XPPU_EN_PERM_CHECK_REG12_DEFVAL  0xfffffUL

/**
 * Register: XlpdXppuAperperm000
 */
#define XLPD_XPPU_APERPERM_000    ( ( XLPD_XPPU_BASEADDR ) + 0x00001000UL )
#define XLPD_XPPU_APERPERM_000_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_000_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_000_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_000_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_000_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_000_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_000_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_000_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_000_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_000_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_000_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_000_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_000_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm001
 */
#define XLPD_XPPU_APERPERM_001    ( ( XLPD_XPPU_BASEADDR ) + 0x00001004UL )
#define XLPD_XPPU_APERPERM_001_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_001_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_001_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_001_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_001_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_001_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_001_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_001_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_001_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_001_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_001_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_001_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_001_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm002
 */
#define XLPD_XPPU_APERPERM_002    ( ( XLPD_XPPU_BASEADDR ) + 0x00001008UL )
#define XLPD_XPPU_APERPERM_002_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_002_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_002_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_002_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_002_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_002_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_002_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_002_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_002_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_002_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_002_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_002_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_002_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm003
 */
#define XLPD_XPPU_APERPERM_003    ( ( XLPD_XPPU_BASEADDR ) + 0x0000100CUL )
#define XLPD_XPPU_APERPERM_003_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_003_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_003_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_003_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_003_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_003_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_003_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_003_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_003_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_003_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_003_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_003_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_003_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm004
 */
#define XLPD_XPPU_APERPERM_004    ( ( XLPD_XPPU_BASEADDR ) + 0x00001010UL )
#define XLPD_XPPU_APERPERM_004_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_004_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_004_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_004_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_004_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_004_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_004_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_004_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_004_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_004_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_004_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_004_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_004_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm005
 */
#define XLPD_XPPU_APERPERM_005    ( ( XLPD_XPPU_BASEADDR ) + 0x00001014UL )
#define XLPD_XPPU_APERPERM_005_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_005_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_005_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_005_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_005_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_005_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_005_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_005_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_005_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_005_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_005_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_005_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_005_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm006
 */
#define XLPD_XPPU_APERPERM_006    ( ( XLPD_XPPU_BASEADDR ) + 0x00001018UL )
#define XLPD_XPPU_APERPERM_006_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_006_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_006_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_006_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_006_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_006_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_006_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_006_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_006_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_006_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_006_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_006_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_006_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm007
 */
#define XLPD_XPPU_APERPERM_007    ( ( XLPD_XPPU_BASEADDR ) + 0x0000101CUL )
#define XLPD_XPPU_APERPERM_007_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_007_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_007_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_007_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_007_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_007_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_007_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_007_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_007_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_007_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_007_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_007_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_007_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm008
 */
#define XLPD_XPPU_APERPERM_008    ( ( XLPD_XPPU_BASEADDR ) + 0x00001020UL )
#define XLPD_XPPU_APERPERM_008_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_008_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_008_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_008_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_008_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_008_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_008_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_008_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_008_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_008_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_008_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_008_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_008_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm009
 */
#define XLPD_XPPU_APERPERM_009    ( ( XLPD_XPPU_BASEADDR ) + 0x00001024UL )
#define XLPD_XPPU_APERPERM_009_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_009_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_009_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_009_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_009_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_009_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_009_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_009_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_009_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_009_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_009_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_009_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_009_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm010
 */
#define XLPD_XPPU_APERPERM_010    ( ( XLPD_XPPU_BASEADDR ) + 0x00001028UL )
#define XLPD_XPPU_APERPERM_010_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_010_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_010_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_010_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_010_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_010_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_010_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_010_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_010_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_010_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_010_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_010_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_010_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm011
 */
#define XLPD_XPPU_APERPERM_011    ( ( XLPD_XPPU_BASEADDR ) + 0x0000102CUL )
#define XLPD_XPPU_APERPERM_011_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_011_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_011_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_011_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_011_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_011_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_011_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_011_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_011_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_011_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_011_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_011_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_011_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm012
 */
#define XLPD_XPPU_APERPERM_012    ( ( XLPD_XPPU_BASEADDR ) + 0x00001030UL )
#define XLPD_XPPU_APERPERM_012_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_012_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_012_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_012_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_012_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_012_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_012_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_012_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_012_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_012_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_012_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_012_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_012_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm013
 */
#define XLPD_XPPU_APERPERM_013    ( ( XLPD_XPPU_BASEADDR ) + 0x00001034UL )
#define XLPD_XPPU_APERPERM_013_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_013_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_013_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_013_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_013_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_013_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_013_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_013_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_013_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_013_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_013_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_013_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_013_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm014
 */
#define XLPD_XPPU_APERPERM_014    ( ( XLPD_XPPU_BASEADDR ) + 0x00001038UL )
#define XLPD_XPPU_APERPERM_014_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_014_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_014_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_014_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_014_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_014_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_014_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_014_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_014_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_014_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_014_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_014_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_014_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm015
 */
#define XLPD_XPPU_APERPERM_015    ( ( XLPD_XPPU_BASEADDR ) + 0x0000103CUL )
#define XLPD_XPPU_APERPERM_015_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_015_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_015_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_015_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_015_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_015_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_015_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_015_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_015_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_015_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_015_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_015_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_015_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm016
 */
#define XLPD_XPPU_APERPERM_016    ( ( XLPD_XPPU_BASEADDR ) + 0x00001040UL )
#define XLPD_XPPU_APERPERM_016_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_016_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_016_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_016_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_016_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_016_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_016_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_016_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_016_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_016_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_016_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_016_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_016_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm017
 */
#define XLPD_XPPU_APERPERM_017    ( ( XLPD_XPPU_BASEADDR ) + 0x00001044UL )
#define XLPD_XPPU_APERPERM_017_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_017_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_017_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_017_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_017_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_017_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_017_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_017_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_017_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_017_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_017_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_017_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_017_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm018
 */
#define XLPD_XPPU_APERPERM_018    ( ( XLPD_XPPU_BASEADDR ) + 0x00001048UL )
#define XLPD_XPPU_APERPERM_018_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_018_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_018_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_018_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_018_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_018_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_018_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_018_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_018_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_018_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_018_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_018_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_018_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm019
 */
#define XLPD_XPPU_APERPERM_019    ( ( XLPD_XPPU_BASEADDR ) + 0x0000104CUL )
#define XLPD_XPPU_APERPERM_019_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_019_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_019_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_019_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_019_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_019_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_019_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_019_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_019_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_019_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_019_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_019_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_019_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm020
 */
#define XLPD_XPPU_APERPERM_020    ( ( XLPD_XPPU_BASEADDR ) + 0x00001050UL )
#define XLPD_XPPU_APERPERM_020_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_020_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_020_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_020_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_020_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_020_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_020_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_020_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_020_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_020_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_020_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_020_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_020_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm021
 */
#define XLPD_XPPU_APERPERM_021    ( ( XLPD_XPPU_BASEADDR ) + 0x00001054UL )
#define XLPD_XPPU_APERPERM_021_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_021_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_021_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_021_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_021_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_021_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_021_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_021_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_021_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_021_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_021_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_021_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_021_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm022
 */
#define XLPD_XPPU_APERPERM_022    ( ( XLPD_XPPU_BASEADDR ) + 0x00001058UL )
#define XLPD_XPPU_APERPERM_022_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_022_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_022_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_022_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_022_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_022_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_022_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_022_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_022_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_022_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_022_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_022_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_022_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm023
 */
#define XLPD_XPPU_APERPERM_023    ( ( XLPD_XPPU_BASEADDR ) + 0x0000105CUL )
#define XLPD_XPPU_APERPERM_023_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_023_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_023_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_023_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_023_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_023_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_023_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_023_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_023_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_023_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_023_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_023_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_023_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm024
 */
#define XLPD_XPPU_APERPERM_024    ( ( XLPD_XPPU_BASEADDR ) + 0x00001060UL )
#define XLPD_XPPU_APERPERM_024_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_024_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_024_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_024_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_024_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_024_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_024_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_024_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_024_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_024_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_024_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_024_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_024_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm025
 */
#define XLPD_XPPU_APERPERM_025    ( ( XLPD_XPPU_BASEADDR ) + 0x00001064UL )
#define XLPD_XPPU_APERPERM_025_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_025_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_025_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_025_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_025_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_025_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_025_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_025_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_025_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_025_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_025_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_025_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_025_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm026
 */
#define XLPD_XPPU_APERPERM_026    ( ( XLPD_XPPU_BASEADDR ) + 0x00001068UL )
#define XLPD_XPPU_APERPERM_026_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_026_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_026_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_026_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_026_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_026_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_026_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_026_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_026_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_026_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_026_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_026_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_026_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm027
 */
#define XLPD_XPPU_APERPERM_027    ( ( XLPD_XPPU_BASEADDR ) + 0x0000106CUL )
#define XLPD_XPPU_APERPERM_027_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_027_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_027_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_027_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_027_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_027_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_027_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_027_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_027_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_027_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_027_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_027_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_027_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm028
 */
#define XLPD_XPPU_APERPERM_028    ( ( XLPD_XPPU_BASEADDR ) + 0x00001070UL )
#define XLPD_XPPU_APERPERM_028_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_028_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_028_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_028_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_028_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_028_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_028_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_028_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_028_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_028_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_028_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_028_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_028_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm029
 */
#define XLPD_XPPU_APERPERM_029    ( ( XLPD_XPPU_BASEADDR ) + 0x00001074UL )
#define XLPD_XPPU_APERPERM_029_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_029_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_029_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_029_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_029_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_029_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_029_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_029_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_029_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_029_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_029_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_029_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_029_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm030
 */
#define XLPD_XPPU_APERPERM_030    ( ( XLPD_XPPU_BASEADDR ) + 0x00001078UL )
#define XLPD_XPPU_APERPERM_030_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_030_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_030_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_030_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_030_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_030_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_030_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_030_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_030_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_030_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_030_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_030_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_030_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm031
 */
#define XLPD_XPPU_APERPERM_031    ( ( XLPD_XPPU_BASEADDR ) + 0x0000107CUL )
#define XLPD_XPPU_APERPERM_031_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_031_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_031_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_031_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_031_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_031_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_031_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_031_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_031_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_031_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_031_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_031_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_031_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm032
 */
#define XLPD_XPPU_APERPERM_032    ( ( XLPD_XPPU_BASEADDR ) + 0x00001080UL )
#define XLPD_XPPU_APERPERM_032_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_032_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_032_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_032_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_032_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_032_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_032_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_032_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_032_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_032_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_032_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_032_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_032_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm033
 */
#define XLPD_XPPU_APERPERM_033    ( ( XLPD_XPPU_BASEADDR ) + 0x00001084UL )
#define XLPD_XPPU_APERPERM_033_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_033_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_033_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_033_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_033_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_033_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_033_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_033_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_033_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_033_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_033_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_033_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_033_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm034
 */
#define XLPD_XPPU_APERPERM_034    ( ( XLPD_XPPU_BASEADDR ) + 0x00001088UL )
#define XLPD_XPPU_APERPERM_034_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_034_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_034_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_034_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_034_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_034_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_034_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_034_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_034_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_034_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_034_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_034_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_034_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm035
 */
#define XLPD_XPPU_APERPERM_035    ( ( XLPD_XPPU_BASEADDR ) + 0x0000108CUL )
#define XLPD_XPPU_APERPERM_035_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_035_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_035_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_035_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_035_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_035_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_035_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_035_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_035_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_035_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_035_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_035_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_035_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm036
 */
#define XLPD_XPPU_APERPERM_036    ( ( XLPD_XPPU_BASEADDR ) + 0x00001090UL )
#define XLPD_XPPU_APERPERM_036_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_036_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_036_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_036_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_036_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_036_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_036_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_036_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_036_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_036_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_036_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_036_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_036_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm037
 */
#define XLPD_XPPU_APERPERM_037    ( ( XLPD_XPPU_BASEADDR ) + 0x00001094UL )
#define XLPD_XPPU_APERPERM_037_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_037_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_037_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_037_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_037_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_037_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_037_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_037_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_037_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_037_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_037_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_037_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_037_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm038
 */
#define XLPD_XPPU_APERPERM_038    ( ( XLPD_XPPU_BASEADDR ) + 0x00001098UL )
#define XLPD_XPPU_APERPERM_038_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_038_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_038_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_038_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_038_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_038_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_038_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_038_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_038_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_038_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_038_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_038_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_038_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm039
 */
#define XLPD_XPPU_APERPERM_039    ( ( XLPD_XPPU_BASEADDR ) + 0x0000109CUL )
#define XLPD_XPPU_APERPERM_039_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_039_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_039_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_039_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_039_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_039_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_039_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_039_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_039_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_039_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_039_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_039_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_039_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm040
 */
#define XLPD_XPPU_APERPERM_040    ( ( XLPD_XPPU_BASEADDR ) + 0x000010A0UL )
#define XLPD_XPPU_APERPERM_040_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_040_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_040_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_040_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_040_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_040_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_040_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_040_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_040_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_040_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_040_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_040_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_040_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm041
 */
#define XLPD_XPPU_APERPERM_041    ( ( XLPD_XPPU_BASEADDR ) + 0x000010A4UL )
#define XLPD_XPPU_APERPERM_041_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_041_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_041_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_041_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_041_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_041_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_041_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_041_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_041_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_041_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_041_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_041_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_041_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm042
 */
#define XLPD_XPPU_APERPERM_042    ( ( XLPD_XPPU_BASEADDR ) + 0x000010A8UL )
#define XLPD_XPPU_APERPERM_042_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_042_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_042_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_042_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_042_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_042_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_042_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_042_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_042_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_042_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_042_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_042_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_042_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm043
 */
#define XLPD_XPPU_APERPERM_043    ( ( XLPD_XPPU_BASEADDR ) + 0x000010ACUL )
#define XLPD_XPPU_APERPERM_043_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_043_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_043_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_043_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_043_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_043_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_043_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_043_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_043_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_043_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_043_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_043_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_043_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm044
 */
#define XLPD_XPPU_APERPERM_044    ( ( XLPD_XPPU_BASEADDR ) + 0x000010B0UL )
#define XLPD_XPPU_APERPERM_044_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_044_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_044_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_044_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_044_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_044_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_044_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_044_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_044_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_044_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_044_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_044_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_044_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm045
 */
#define XLPD_XPPU_APERPERM_045    ( ( XLPD_XPPU_BASEADDR ) + 0x000010B4UL )
#define XLPD_XPPU_APERPERM_045_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_045_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_045_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_045_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_045_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_045_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_045_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_045_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_045_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_045_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_045_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_045_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_045_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm046
 */
#define XLPD_XPPU_APERPERM_046    ( ( XLPD_XPPU_BASEADDR ) + 0x000010B8UL )
#define XLPD_XPPU_APERPERM_046_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_046_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_046_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_046_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_046_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_046_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_046_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_046_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_046_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_046_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_046_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_046_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_046_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm047
 */
#define XLPD_XPPU_APERPERM_047    ( ( XLPD_XPPU_BASEADDR ) + 0x000010BCUL )
#define XLPD_XPPU_APERPERM_047_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_047_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_047_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_047_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_047_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_047_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_047_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_047_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_047_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_047_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_047_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_047_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_047_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm048
 */
#define XLPD_XPPU_APERPERM_048    ( ( XLPD_XPPU_BASEADDR ) + 0x000010C0UL )
#define XLPD_XPPU_APERPERM_048_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_048_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_048_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_048_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_048_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_048_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_048_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_048_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_048_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_048_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_048_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_048_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_048_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm049
 */
#define XLPD_XPPU_APERPERM_049    ( ( XLPD_XPPU_BASEADDR ) + 0x000010C4UL )
#define XLPD_XPPU_APERPERM_049_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_049_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_049_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_049_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_049_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_049_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_049_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_049_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_049_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_049_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_049_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_049_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_049_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm050
 */
#define XLPD_XPPU_APERPERM_050    ( ( XLPD_XPPU_BASEADDR ) + 0x000010C8UL )
#define XLPD_XPPU_APERPERM_050_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_050_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_050_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_050_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_050_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_050_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_050_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_050_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_050_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_050_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_050_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_050_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_050_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm051
 */
#define XLPD_XPPU_APERPERM_051    ( ( XLPD_XPPU_BASEADDR ) + 0x000010CCUL )
#define XLPD_XPPU_APERPERM_051_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_051_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_051_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_051_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_051_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_051_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_051_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_051_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_051_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_051_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_051_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_051_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_051_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm052
 */
#define XLPD_XPPU_APERPERM_052    ( ( XLPD_XPPU_BASEADDR ) + 0x000010D0UL )
#define XLPD_XPPU_APERPERM_052_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_052_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_052_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_052_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_052_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_052_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_052_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_052_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_052_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_052_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_052_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_052_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_052_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm053
 */
#define XLPD_XPPU_APERPERM_053    ( ( XLPD_XPPU_BASEADDR ) + 0x000010D4UL )
#define XLPD_XPPU_APERPERM_053_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_053_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_053_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_053_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_053_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_053_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_053_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_053_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_053_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_053_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_053_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_053_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_053_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm054
 */
#define XLPD_XPPU_APERPERM_054    ( ( XLPD_XPPU_BASEADDR ) + 0x000010D8UL )
#define XLPD_XPPU_APERPERM_054_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_054_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_054_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_054_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_054_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_054_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_054_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_054_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_054_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_054_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_054_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_054_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_054_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm055
 */
#define XLPD_XPPU_APERPERM_055    ( ( XLPD_XPPU_BASEADDR ) + 0x000010DCUL )
#define XLPD_XPPU_APERPERM_055_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_055_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_055_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_055_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_055_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_055_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_055_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_055_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_055_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_055_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_055_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_055_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_055_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm056
 */
#define XLPD_XPPU_APERPERM_056    ( ( XLPD_XPPU_BASEADDR ) + 0x000010E0UL )
#define XLPD_XPPU_APERPERM_056_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_056_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_056_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_056_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_056_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_056_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_056_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_056_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_056_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_056_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_056_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_056_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_056_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm057
 */
#define XLPD_XPPU_APERPERM_057    ( ( XLPD_XPPU_BASEADDR ) + 0x000010E4UL )
#define XLPD_XPPU_APERPERM_057_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_057_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_057_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_057_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_057_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_057_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_057_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_057_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_057_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_057_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_057_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_057_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_057_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm058
 */
#define XLPD_XPPU_APERPERM_058    ( ( XLPD_XPPU_BASEADDR ) + 0x000010E8UL )
#define XLPD_XPPU_APERPERM_058_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_058_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_058_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_058_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_058_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_058_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_058_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_058_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_058_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_058_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_058_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_058_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_058_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm059
 */
#define XLPD_XPPU_APERPERM_059    ( ( XLPD_XPPU_BASEADDR ) + 0x000010ECUL )
#define XLPD_XPPU_APERPERM_059_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_059_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_059_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_059_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_059_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_059_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_059_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_059_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_059_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_059_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_059_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_059_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_059_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm060
 */
#define XLPD_XPPU_APERPERM_060    ( ( XLPD_XPPU_BASEADDR ) + 0x000010F0UL )
#define XLPD_XPPU_APERPERM_060_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_060_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_060_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_060_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_060_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_060_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_060_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_060_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_060_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_060_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_060_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_060_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_060_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm061
 */
#define XLPD_XPPU_APERPERM_061    ( ( XLPD_XPPU_BASEADDR ) + 0x000010F4UL )
#define XLPD_XPPU_APERPERM_061_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_061_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_061_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_061_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_061_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_061_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_061_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_061_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_061_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_061_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_061_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_061_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_061_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm062
 */
#define XLPD_XPPU_APERPERM_062    ( ( XLPD_XPPU_BASEADDR ) + 0x000010F8UL )
#define XLPD_XPPU_APERPERM_062_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_062_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_062_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_062_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_062_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_062_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_062_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_062_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_062_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_062_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_062_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_062_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_062_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm063
 */
#define XLPD_XPPU_APERPERM_063    ( ( XLPD_XPPU_BASEADDR ) + 0x000010FCUL )
#define XLPD_XPPU_APERPERM_063_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_063_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_063_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_063_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_063_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_063_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_063_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_063_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_063_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_063_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_063_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_063_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_063_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm064
 */
#define XLPD_XPPU_APERPERM_064    ( ( XLPD_XPPU_BASEADDR ) + 0x00001100UL )
#define XLPD_XPPU_APERPERM_064_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_064_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_064_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_064_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_064_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_064_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_064_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_064_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_064_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_064_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_064_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_064_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_064_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm065
 */
#define XLPD_XPPU_APERPERM_065    ( ( XLPD_XPPU_BASEADDR ) + 0x00001104UL )
#define XLPD_XPPU_APERPERM_065_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_065_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_065_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_065_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_065_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_065_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_065_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_065_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_065_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_065_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_065_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_065_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_065_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm066
 */
#define XLPD_XPPU_APERPERM_066    ( ( XLPD_XPPU_BASEADDR ) + 0x00001108UL )
#define XLPD_XPPU_APERPERM_066_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_066_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_066_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_066_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_066_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_066_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_066_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_066_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_066_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_066_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_066_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_066_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_066_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm067
 */
#define XLPD_XPPU_APERPERM_067    ( ( XLPD_XPPU_BASEADDR ) + 0x0000110CUL )
#define XLPD_XPPU_APERPERM_067_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_067_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_067_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_067_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_067_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_067_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_067_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_067_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_067_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_067_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_067_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_067_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_067_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm068
 */
#define XLPD_XPPU_APERPERM_068    ( ( XLPD_XPPU_BASEADDR ) + 0x00001110UL )
#define XLPD_XPPU_APERPERM_068_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_068_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_068_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_068_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_068_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_068_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_068_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_068_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_068_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_068_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_068_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_068_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_068_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm069
 */
#define XLPD_XPPU_APERPERM_069    ( ( XLPD_XPPU_BASEADDR ) + 0x00001114UL )
#define XLPD_XPPU_APERPERM_069_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_069_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_069_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_069_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_069_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_069_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_069_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_069_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_069_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_069_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_069_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_069_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_069_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm070
 */
#define XLPD_XPPU_APERPERM_070    ( ( XLPD_XPPU_BASEADDR ) + 0x00001118UL )
#define XLPD_XPPU_APERPERM_070_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_070_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_070_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_070_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_070_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_070_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_070_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_070_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_070_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_070_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_070_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_070_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_070_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm071
 */
#define XLPD_XPPU_APERPERM_071    ( ( XLPD_XPPU_BASEADDR ) + 0x0000111CUL )
#define XLPD_XPPU_APERPERM_071_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_071_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_071_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_071_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_071_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_071_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_071_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_071_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_071_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_071_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_071_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_071_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_071_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm072
 */
#define XLPD_XPPU_APERPERM_072    ( ( XLPD_XPPU_BASEADDR ) + 0x00001120UL )
#define XLPD_XPPU_APERPERM_072_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_072_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_072_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_072_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_072_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_072_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_072_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_072_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_072_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_072_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_072_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_072_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_072_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm073
 */
#define XLPD_XPPU_APERPERM_073    ( ( XLPD_XPPU_BASEADDR ) + 0x00001124UL )
#define XLPD_XPPU_APERPERM_073_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_073_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_073_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_073_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_073_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_073_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_073_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_073_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_073_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_073_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_073_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_073_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_073_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm074
 */
#define XLPD_XPPU_APERPERM_074    ( ( XLPD_XPPU_BASEADDR ) + 0x00001128UL )
#define XLPD_XPPU_APERPERM_074_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_074_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_074_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_074_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_074_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_074_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_074_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_074_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_074_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_074_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_074_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_074_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_074_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm075
 */
#define XLPD_XPPU_APERPERM_075    ( ( XLPD_XPPU_BASEADDR ) + 0x0000112CUL )
#define XLPD_XPPU_APERPERM_075_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_075_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_075_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_075_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_075_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_075_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_075_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_075_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_075_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_075_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_075_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_075_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_075_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm076
 */
#define XLPD_XPPU_APERPERM_076    ( ( XLPD_XPPU_BASEADDR ) + 0x00001130UL )
#define XLPD_XPPU_APERPERM_076_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_076_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_076_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_076_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_076_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_076_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_076_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_076_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_076_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_076_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_076_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_076_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_076_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm077
 */
#define XLPD_XPPU_APERPERM_077    ( ( XLPD_XPPU_BASEADDR ) + 0x00001134UL )
#define XLPD_XPPU_APERPERM_077_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_077_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_077_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_077_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_077_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_077_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_077_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_077_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_077_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_077_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_077_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_077_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_077_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm078
 */
#define XLPD_XPPU_APERPERM_078    ( ( XLPD_XPPU_BASEADDR ) + 0x00001138UL )
#define XLPD_XPPU_APERPERM_078_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_078_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_078_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_078_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_078_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_078_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_078_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_078_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_078_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_078_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_078_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_078_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_078_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm079
 */
#define XLPD_XPPU_APERPERM_079    ( ( XLPD_XPPU_BASEADDR ) + 0x0000113CUL )
#define XLPD_XPPU_APERPERM_079_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_079_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_079_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_079_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_079_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_079_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_079_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_079_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_079_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_079_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_079_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_079_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_079_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm080
 */
#define XLPD_XPPU_APERPERM_080    ( ( XLPD_XPPU_BASEADDR ) + 0x00001140UL )
#define XLPD_XPPU_APERPERM_080_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_080_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_080_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_080_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_080_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_080_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_080_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_080_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_080_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_080_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_080_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_080_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_080_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm081
 */
#define XLPD_XPPU_APERPERM_081    ( ( XLPD_XPPU_BASEADDR ) + 0x00001144UL )
#define XLPD_XPPU_APERPERM_081_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_081_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_081_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_081_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_081_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_081_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_081_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_081_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_081_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_081_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_081_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_081_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_081_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm082
 */
#define XLPD_XPPU_APERPERM_082    ( ( XLPD_XPPU_BASEADDR ) + 0x00001148UL )
#define XLPD_XPPU_APERPERM_082_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_082_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_082_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_082_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_082_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_082_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_082_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_082_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_082_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_082_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_082_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_082_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_082_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm083
 */
#define XLPD_XPPU_APERPERM_083    ( ( XLPD_XPPU_BASEADDR ) + 0x0000114CUL )
#define XLPD_XPPU_APERPERM_083_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_083_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_083_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_083_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_083_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_083_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_083_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_083_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_083_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_083_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_083_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_083_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_083_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm084
 */
#define XLPD_XPPU_APERPERM_084    ( ( XLPD_XPPU_BASEADDR ) + 0x00001150UL )
#define XLPD_XPPU_APERPERM_084_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_084_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_084_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_084_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_084_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_084_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_084_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_084_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_084_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_084_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_084_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_084_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_084_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm085
 */
#define XLPD_XPPU_APERPERM_085    ( ( XLPD_XPPU_BASEADDR ) + 0x00001154UL )
#define XLPD_XPPU_APERPERM_085_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_085_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_085_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_085_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_085_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_085_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_085_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_085_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_085_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_085_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_085_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_085_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_085_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm086
 */
#define XLPD_XPPU_APERPERM_086    ( ( XLPD_XPPU_BASEADDR ) + 0x00001158UL )
#define XLPD_XPPU_APERPERM_086_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_086_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_086_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_086_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_086_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_086_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_086_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_086_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_086_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_086_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_086_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_086_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_086_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm087
 */
#define XLPD_XPPU_APERPERM_087    ( ( XLPD_XPPU_BASEADDR ) + 0x0000115CUL )
#define XLPD_XPPU_APERPERM_087_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_087_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_087_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_087_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_087_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_087_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_087_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_087_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_087_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_087_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_087_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_087_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_087_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm088
 */
#define XLPD_XPPU_APERPERM_088    ( ( XLPD_XPPU_BASEADDR ) + 0x00001160UL )
#define XLPD_XPPU_APERPERM_088_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_088_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_088_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_088_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_088_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_088_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_088_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_088_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_088_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_088_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_088_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_088_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_088_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm089
 */
#define XLPD_XPPU_APERPERM_089    ( ( XLPD_XPPU_BASEADDR ) + 0x00001164UL )
#define XLPD_XPPU_APERPERM_089_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_089_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_089_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_089_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_089_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_089_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_089_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_089_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_089_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_089_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_089_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_089_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_089_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm090
 */
#define XLPD_XPPU_APERPERM_090    ( ( XLPD_XPPU_BASEADDR ) + 0x00001168UL )
#define XLPD_XPPU_APERPERM_090_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_090_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_090_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_090_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_090_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_090_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_090_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_090_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_090_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_090_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_090_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_090_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_090_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm091
 */
#define XLPD_XPPU_APERPERM_091    ( ( XLPD_XPPU_BASEADDR ) + 0x0000116CUL )
#define XLPD_XPPU_APERPERM_091_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_091_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_091_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_091_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_091_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_091_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_091_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_091_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_091_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_091_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_091_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_091_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_091_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm092
 */
#define XLPD_XPPU_APERPERM_092    ( ( XLPD_XPPU_BASEADDR ) + 0x00001170UL )
#define XLPD_XPPU_APERPERM_092_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_092_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_092_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_092_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_092_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_092_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_092_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_092_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_092_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_092_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_092_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_092_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_092_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm093
 */
#define XLPD_XPPU_APERPERM_093    ( ( XLPD_XPPU_BASEADDR ) + 0x00001174UL )
#define XLPD_XPPU_APERPERM_093_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_093_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_093_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_093_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_093_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_093_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_093_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_093_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_093_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_093_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_093_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_093_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_093_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm094
 */
#define XLPD_XPPU_APERPERM_094    ( ( XLPD_XPPU_BASEADDR ) + 0x00001178UL )
#define XLPD_XPPU_APERPERM_094_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_094_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_094_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_094_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_094_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_094_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_094_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_094_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_094_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_094_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_094_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_094_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_094_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm095
 */
#define XLPD_XPPU_APERPERM_095    ( ( XLPD_XPPU_BASEADDR ) + 0x0000117CUL )
#define XLPD_XPPU_APERPERM_095_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_095_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_095_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_095_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_095_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_095_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_095_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_095_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_095_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_095_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_095_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_095_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_095_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm096
 */
#define XLPD_XPPU_APERPERM_096    ( ( XLPD_XPPU_BASEADDR ) + 0x00001180UL )
#define XLPD_XPPU_APERPERM_096_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_096_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_096_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_096_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_096_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_096_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_096_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_096_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_096_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_096_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_096_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_096_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_096_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm097
 */
#define XLPD_XPPU_APERPERM_097    ( ( XLPD_XPPU_BASEADDR ) + 0x00001184UL )
#define XLPD_XPPU_APERPERM_097_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_097_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_097_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_097_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_097_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_097_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_097_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_097_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_097_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_097_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_097_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_097_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_097_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm098
 */
#define XLPD_XPPU_APERPERM_098    ( ( XLPD_XPPU_BASEADDR ) + 0x00001188UL )
#define XLPD_XPPU_APERPERM_098_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_098_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_098_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_098_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_098_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_098_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_098_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_098_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_098_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_098_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_098_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_098_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_098_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm099
 */
#define XLPD_XPPU_APERPERM_099    ( ( XLPD_XPPU_BASEADDR ) + 0x0000118CUL )
#define XLPD_XPPU_APERPERM_099_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_099_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_099_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_099_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_099_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_099_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_099_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_099_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_099_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_099_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_099_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_099_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_099_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm100
 */
#define XLPD_XPPU_APERPERM_100    ( ( XLPD_XPPU_BASEADDR ) + 0x00001190UL )
#define XLPD_XPPU_APERPERM_100_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_100_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_100_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_100_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_100_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_100_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_100_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_100_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_100_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_100_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_100_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_100_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_100_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm101
 */
#define XLPD_XPPU_APERPERM_101    ( ( XLPD_XPPU_BASEADDR ) + 0x00001194UL )
#define XLPD_XPPU_APERPERM_101_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_101_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_101_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_101_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_101_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_101_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_101_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_101_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_101_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_101_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_101_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_101_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_101_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm102
 */
#define XLPD_XPPU_APERPERM_102    ( ( XLPD_XPPU_BASEADDR ) + 0x00001198UL )
#define XLPD_XPPU_APERPERM_102_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_102_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_102_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_102_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_102_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_102_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_102_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_102_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_102_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_102_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_102_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_102_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_102_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm103
 */
#define XLPD_XPPU_APERPERM_103    ( ( XLPD_XPPU_BASEADDR ) + 0x0000119CUL )
#define XLPD_XPPU_APERPERM_103_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_103_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_103_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_103_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_103_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_103_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_103_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_103_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_103_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_103_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_103_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_103_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_103_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm104
 */
#define XLPD_XPPU_APERPERM_104    ( ( XLPD_XPPU_BASEADDR ) + 0x000011A0UL )
#define XLPD_XPPU_APERPERM_104_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_104_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_104_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_104_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_104_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_104_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_104_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_104_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_104_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_104_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_104_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_104_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_104_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm105
 */
#define XLPD_XPPU_APERPERM_105    ( ( XLPD_XPPU_BASEADDR ) + 0x000011A4UL )
#define XLPD_XPPU_APERPERM_105_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_105_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_105_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_105_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_105_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_105_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_105_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_105_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_105_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_105_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_105_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_105_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_105_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm106
 */
#define XLPD_XPPU_APERPERM_106    ( ( XLPD_XPPU_BASEADDR ) + 0x000011A8UL )
#define XLPD_XPPU_APERPERM_106_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_106_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_106_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_106_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_106_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_106_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_106_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_106_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_106_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_106_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_106_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_106_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_106_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm107
 */
#define XLPD_XPPU_APERPERM_107    ( ( XLPD_XPPU_BASEADDR ) + 0x000011ACUL )
#define XLPD_XPPU_APERPERM_107_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_107_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_107_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_107_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_107_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_107_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_107_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_107_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_107_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_107_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_107_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_107_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_107_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm108
 */
#define XLPD_XPPU_APERPERM_108    ( ( XLPD_XPPU_BASEADDR ) + 0x000011B0UL )
#define XLPD_XPPU_APERPERM_108_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_108_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_108_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_108_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_108_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_108_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_108_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_108_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_108_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_108_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_108_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_108_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_108_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm109
 */
#define XLPD_XPPU_APERPERM_109    ( ( XLPD_XPPU_BASEADDR ) + 0x000011B4UL )
#define XLPD_XPPU_APERPERM_109_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_109_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_109_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_109_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_109_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_109_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_109_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_109_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_109_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_109_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_109_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_109_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_109_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm110
 */
#define XLPD_XPPU_APERPERM_110    ( ( XLPD_XPPU_BASEADDR ) + 0x000011B8UL )
#define XLPD_XPPU_APERPERM_110_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_110_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_110_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_110_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_110_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_110_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_110_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_110_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_110_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_110_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_110_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_110_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_110_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm111
 */
#define XLPD_XPPU_APERPERM_111    ( ( XLPD_XPPU_BASEADDR ) + 0x000011BCUL )
#define XLPD_XPPU_APERPERM_111_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_111_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_111_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_111_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_111_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_111_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_111_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_111_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_111_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_111_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_111_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_111_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_111_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm112
 */
#define XLPD_XPPU_APERPERM_112    ( ( XLPD_XPPU_BASEADDR ) + 0x000011C0UL )
#define XLPD_XPPU_APERPERM_112_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_112_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_112_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_112_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_112_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_112_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_112_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_112_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_112_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_112_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_112_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_112_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_112_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm113
 */
#define XLPD_XPPU_APERPERM_113    ( ( XLPD_XPPU_BASEADDR ) + 0x000011C4UL )
#define XLPD_XPPU_APERPERM_113_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_113_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_113_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_113_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_113_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_113_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_113_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_113_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_113_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_113_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_113_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_113_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_113_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm114
 */
#define XLPD_XPPU_APERPERM_114    ( ( XLPD_XPPU_BASEADDR ) + 0x000011C8UL )
#define XLPD_XPPU_APERPERM_114_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_114_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_114_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_114_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_114_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_114_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_114_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_114_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_114_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_114_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_114_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_114_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_114_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm115
 */
#define XLPD_XPPU_APERPERM_115    ( ( XLPD_XPPU_BASEADDR ) + 0x000011CCUL )
#define XLPD_XPPU_APERPERM_115_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_115_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_115_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_115_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_115_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_115_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_115_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_115_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_115_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_115_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_115_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_115_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_115_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm116
 */
#define XLPD_XPPU_APERPERM_116    ( ( XLPD_XPPU_BASEADDR ) + 0x000011D0UL )
#define XLPD_XPPU_APERPERM_116_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_116_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_116_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_116_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_116_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_116_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_116_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_116_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_116_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_116_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_116_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_116_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_116_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm117
 */
#define XLPD_XPPU_APERPERM_117    ( ( XLPD_XPPU_BASEADDR ) + 0x000011D4UL )
#define XLPD_XPPU_APERPERM_117_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_117_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_117_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_117_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_117_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_117_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_117_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_117_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_117_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_117_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_117_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_117_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_117_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm118
 */
#define XLPD_XPPU_APERPERM_118    ( ( XLPD_XPPU_BASEADDR ) + 0x000011D8UL )
#define XLPD_XPPU_APERPERM_118_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_118_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_118_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_118_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_118_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_118_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_118_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_118_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_118_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_118_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_118_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_118_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_118_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm119
 */
#define XLPD_XPPU_APERPERM_119    ( ( XLPD_XPPU_BASEADDR ) + 0x000011DCUL )
#define XLPD_XPPU_APERPERM_119_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_119_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_119_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_119_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_119_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_119_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_119_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_119_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_119_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_119_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_119_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_119_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_119_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm120
 */
#define XLPD_XPPU_APERPERM_120    ( ( XLPD_XPPU_BASEADDR ) + 0x000011E0UL )
#define XLPD_XPPU_APERPERM_120_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_120_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_120_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_120_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_120_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_120_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_120_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_120_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_120_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_120_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_120_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_120_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_120_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm121
 */
#define XLPD_XPPU_APERPERM_121    ( ( XLPD_XPPU_BASEADDR ) + 0x000011E4UL )
#define XLPD_XPPU_APERPERM_121_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_121_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_121_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_121_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_121_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_121_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_121_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_121_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_121_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_121_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_121_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_121_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_121_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm122
 */
#define XLPD_XPPU_APERPERM_122    ( ( XLPD_XPPU_BASEADDR ) + 0x000011E8UL )
#define XLPD_XPPU_APERPERM_122_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_122_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_122_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_122_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_122_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_122_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_122_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_122_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_122_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_122_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_122_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_122_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_122_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm123
 */
#define XLPD_XPPU_APERPERM_123    ( ( XLPD_XPPU_BASEADDR ) + 0x000011ECUL )
#define XLPD_XPPU_APERPERM_123_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_123_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_123_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_123_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_123_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_123_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_123_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_123_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_123_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_123_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_123_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_123_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_123_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm124
 */
#define XLPD_XPPU_APERPERM_124    ( ( XLPD_XPPU_BASEADDR ) + 0x000011F0UL )
#define XLPD_XPPU_APERPERM_124_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_124_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_124_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_124_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_124_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_124_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_124_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_124_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_124_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_124_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_124_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_124_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_124_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm125
 */
#define XLPD_XPPU_APERPERM_125    ( ( XLPD_XPPU_BASEADDR ) + 0x000011F4UL )
#define XLPD_XPPU_APERPERM_125_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_125_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_125_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_125_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_125_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_125_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_125_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_125_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_125_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_125_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_125_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_125_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_125_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm126
 */
#define XLPD_XPPU_APERPERM_126    ( ( XLPD_XPPU_BASEADDR ) + 0x000011F8UL )
#define XLPD_XPPU_APERPERM_126_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_126_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_126_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_126_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_126_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_126_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_126_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_126_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_126_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_126_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_126_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_126_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_126_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm127
 */
#define XLPD_XPPU_APERPERM_127    ( ( XLPD_XPPU_BASEADDR ) + 0x000011FCUL )
#define XLPD_XPPU_APERPERM_127_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_127_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_127_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_127_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_127_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_127_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_127_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_127_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_127_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_127_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_127_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_127_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_127_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm128
 */
#define XLPD_XPPU_APERPERM_128    ( ( XLPD_XPPU_BASEADDR ) + 0x00001200UL )
#define XLPD_XPPU_APERPERM_128_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_128_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_128_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_128_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_128_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_128_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_128_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_128_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_128_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_128_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_128_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_128_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_128_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm129
 */
#define XLPD_XPPU_APERPERM_129    ( ( XLPD_XPPU_BASEADDR ) + 0x00001204UL )
#define XLPD_XPPU_APERPERM_129_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_129_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_129_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_129_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_129_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_129_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_129_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_129_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_129_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_129_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_129_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_129_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_129_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm130
 */
#define XLPD_XPPU_APERPERM_130    ( ( XLPD_XPPU_BASEADDR ) + 0x00001208UL )
#define XLPD_XPPU_APERPERM_130_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_130_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_130_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_130_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_130_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_130_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_130_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_130_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_130_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_130_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_130_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_130_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_130_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm131
 */
#define XLPD_XPPU_APERPERM_131    ( ( XLPD_XPPU_BASEADDR ) + 0x0000120CUL )
#define XLPD_XPPU_APERPERM_131_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_131_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_131_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_131_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_131_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_131_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_131_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_131_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_131_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_131_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_131_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_131_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_131_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm132
 */
#define XLPD_XPPU_APERPERM_132    ( ( XLPD_XPPU_BASEADDR ) + 0x00001210UL )
#define XLPD_XPPU_APERPERM_132_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_132_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_132_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_132_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_132_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_132_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_132_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_132_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_132_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_132_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_132_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_132_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_132_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm133
 */
#define XLPD_XPPU_APERPERM_133    ( ( XLPD_XPPU_BASEADDR ) + 0x00001214UL )
#define XLPD_XPPU_APERPERM_133_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_133_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_133_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_133_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_133_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_133_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_133_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_133_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_133_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_133_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_133_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_133_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_133_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm134
 */
#define XLPD_XPPU_APERPERM_134    ( ( XLPD_XPPU_BASEADDR ) + 0x00001218UL )
#define XLPD_XPPU_APERPERM_134_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_134_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_134_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_134_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_134_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_134_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_134_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_134_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_134_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_134_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_134_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_134_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_134_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm135
 */
#define XLPD_XPPU_APERPERM_135    ( ( XLPD_XPPU_BASEADDR ) + 0x0000121CUL )
#define XLPD_XPPU_APERPERM_135_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_135_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_135_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_135_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_135_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_135_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_135_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_135_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_135_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_135_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_135_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_135_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_135_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm136
 */
#define XLPD_XPPU_APERPERM_136    ( ( XLPD_XPPU_BASEADDR ) + 0x00001220UL )
#define XLPD_XPPU_APERPERM_136_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_136_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_136_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_136_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_136_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_136_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_136_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_136_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_136_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_136_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_136_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_136_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_136_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm137
 */
#define XLPD_XPPU_APERPERM_137    ( ( XLPD_XPPU_BASEADDR ) + 0x00001224UL )
#define XLPD_XPPU_APERPERM_137_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_137_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_137_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_137_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_137_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_137_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_137_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_137_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_137_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_137_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_137_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_137_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_137_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm138
 */
#define XLPD_XPPU_APERPERM_138    ( ( XLPD_XPPU_BASEADDR ) + 0x00001228UL )
#define XLPD_XPPU_APERPERM_138_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_138_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_138_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_138_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_138_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_138_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_138_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_138_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_138_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_138_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_138_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_138_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_138_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm139
 */
#define XLPD_XPPU_APERPERM_139    ( ( XLPD_XPPU_BASEADDR ) + 0x0000122CUL )
#define XLPD_XPPU_APERPERM_139_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_139_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_139_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_139_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_139_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_139_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_139_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_139_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_139_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_139_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_139_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_139_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_139_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm140
 */
#define XLPD_XPPU_APERPERM_140    ( ( XLPD_XPPU_BASEADDR ) + 0x00001230UL )
#define XLPD_XPPU_APERPERM_140_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_140_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_140_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_140_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_140_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_140_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_140_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_140_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_140_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_140_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_140_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_140_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_140_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm141
 */
#define XLPD_XPPU_APERPERM_141    ( ( XLPD_XPPU_BASEADDR ) + 0x00001234UL )
#define XLPD_XPPU_APERPERM_141_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_141_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_141_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_141_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_141_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_141_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_141_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_141_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_141_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_141_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_141_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_141_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_141_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm142
 */
#define XLPD_XPPU_APERPERM_142    ( ( XLPD_XPPU_BASEADDR ) + 0x00001238UL )
#define XLPD_XPPU_APERPERM_142_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_142_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_142_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_142_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_142_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_142_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_142_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_142_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_142_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_142_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_142_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_142_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_142_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm143
 */
#define XLPD_XPPU_APERPERM_143    ( ( XLPD_XPPU_BASEADDR ) + 0x0000123CUL )
#define XLPD_XPPU_APERPERM_143_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_143_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_143_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_143_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_143_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_143_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_143_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_143_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_143_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_143_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_143_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_143_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_143_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm144
 */
#define XLPD_XPPU_APERPERM_144    ( ( XLPD_XPPU_BASEADDR ) + 0x00001240UL )
#define XLPD_XPPU_APERPERM_144_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_144_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_144_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_144_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_144_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_144_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_144_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_144_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_144_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_144_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_144_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_144_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_144_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm145
 */
#define XLPD_XPPU_APERPERM_145    ( ( XLPD_XPPU_BASEADDR ) + 0x00001244UL )
#define XLPD_XPPU_APERPERM_145_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_145_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_145_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_145_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_145_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_145_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_145_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_145_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_145_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_145_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_145_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_145_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_145_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm146
 */
#define XLPD_XPPU_APERPERM_146    ( ( XLPD_XPPU_BASEADDR ) + 0x00001248UL )
#define XLPD_XPPU_APERPERM_146_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_146_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_146_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_146_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_146_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_146_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_146_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_146_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_146_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_146_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_146_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_146_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_146_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm147
 */
#define XLPD_XPPU_APERPERM_147    ( ( XLPD_XPPU_BASEADDR ) + 0x0000124CUL )
#define XLPD_XPPU_APERPERM_147_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_147_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_147_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_147_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_147_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_147_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_147_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_147_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_147_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_147_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_147_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_147_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_147_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm148
 */
#define XLPD_XPPU_APERPERM_148    ( ( XLPD_XPPU_BASEADDR ) + 0x00001250UL )
#define XLPD_XPPU_APERPERM_148_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_148_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_148_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_148_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_148_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_148_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_148_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_148_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_148_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_148_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_148_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_148_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_148_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm149
 */
#define XLPD_XPPU_APERPERM_149    ( ( XLPD_XPPU_BASEADDR ) + 0x00001254UL )
#define XLPD_XPPU_APERPERM_149_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_149_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_149_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_149_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_149_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_149_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_149_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_149_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_149_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_149_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_149_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_149_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_149_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm150
 */
#define XLPD_XPPU_APERPERM_150    ( ( XLPD_XPPU_BASEADDR ) + 0x00001258UL )
#define XLPD_XPPU_APERPERM_150_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_150_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_150_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_150_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_150_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_150_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_150_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_150_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_150_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_150_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_150_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_150_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_150_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm151
 */
#define XLPD_XPPU_APERPERM_151    ( ( XLPD_XPPU_BASEADDR ) + 0x0000125CUL )
#define XLPD_XPPU_APERPERM_151_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_151_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_151_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_151_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_151_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_151_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_151_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_151_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_151_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_151_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_151_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_151_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_151_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm152
 */
#define XLPD_XPPU_APERPERM_152    ( ( XLPD_XPPU_BASEADDR ) + 0x00001260UL )
#define XLPD_XPPU_APERPERM_152_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_152_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_152_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_152_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_152_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_152_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_152_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_152_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_152_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_152_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_152_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_152_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_152_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm153
 */
#define XLPD_XPPU_APERPERM_153    ( ( XLPD_XPPU_BASEADDR ) + 0x00001264UL )
#define XLPD_XPPU_APERPERM_153_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_153_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_153_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_153_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_153_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_153_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_153_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_153_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_153_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_153_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_153_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_153_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_153_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm154
 */
#define XLPD_XPPU_APERPERM_154    ( ( XLPD_XPPU_BASEADDR ) + 0x00001268UL )
#define XLPD_XPPU_APERPERM_154_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_154_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_154_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_154_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_154_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_154_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_154_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_154_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_154_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_154_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_154_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_154_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_154_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm155
 */
#define XLPD_XPPU_APERPERM_155    ( ( XLPD_XPPU_BASEADDR ) + 0x0000126CUL )
#define XLPD_XPPU_APERPERM_155_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_155_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_155_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_155_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_155_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_155_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_155_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_155_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_155_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_155_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_155_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_155_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_155_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm156
 */
#define XLPD_XPPU_APERPERM_156    ( ( XLPD_XPPU_BASEADDR ) + 0x00001270UL )
#define XLPD_XPPU_APERPERM_156_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_156_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_156_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_156_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_156_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_156_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_156_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_156_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_156_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_156_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_156_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_156_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_156_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm157
 */
#define XLPD_XPPU_APERPERM_157    ( ( XLPD_XPPU_BASEADDR ) + 0x00001274UL )
#define XLPD_XPPU_APERPERM_157_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_157_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_157_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_157_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_157_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_157_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_157_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_157_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_157_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_157_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_157_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_157_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_157_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm158
 */
#define XLPD_XPPU_APERPERM_158    ( ( XLPD_XPPU_BASEADDR ) + 0x00001278UL )
#define XLPD_XPPU_APERPERM_158_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_158_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_158_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_158_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_158_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_158_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_158_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_158_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_158_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_158_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_158_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_158_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_158_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm159
 */
#define XLPD_XPPU_APERPERM_159    ( ( XLPD_XPPU_BASEADDR ) + 0x0000127CUL )
#define XLPD_XPPU_APERPERM_159_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_159_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_159_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_159_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_159_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_159_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_159_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_159_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_159_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_159_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_159_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_159_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_159_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm160
 */
#define XLPD_XPPU_APERPERM_160    ( ( XLPD_XPPU_BASEADDR ) + 0x00001280UL )
#define XLPD_XPPU_APERPERM_160_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_160_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_160_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_160_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_160_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_160_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_160_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_160_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_160_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_160_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_160_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_160_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_160_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm161
 */
#define XLPD_XPPU_APERPERM_161    ( ( XLPD_XPPU_BASEADDR ) + 0x00001284UL )
#define XLPD_XPPU_APERPERM_161_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_161_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_161_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_161_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_161_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_161_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_161_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_161_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_161_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_161_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_161_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_161_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_161_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm162
 */
#define XLPD_XPPU_APERPERM_162    ( ( XLPD_XPPU_BASEADDR ) + 0x00001288UL )
#define XLPD_XPPU_APERPERM_162_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_162_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_162_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_162_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_162_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_162_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_162_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_162_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_162_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_162_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_162_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_162_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_162_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm163
 */
#define XLPD_XPPU_APERPERM_163    ( ( XLPD_XPPU_BASEADDR ) + 0x0000128CUL )
#define XLPD_XPPU_APERPERM_163_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_163_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_163_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_163_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_163_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_163_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_163_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_163_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_163_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_163_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_163_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_163_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_163_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm164
 */
#define XLPD_XPPU_APERPERM_164    ( ( XLPD_XPPU_BASEADDR ) + 0x00001290UL )
#define XLPD_XPPU_APERPERM_164_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_164_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_164_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_164_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_164_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_164_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_164_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_164_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_164_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_164_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_164_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_164_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_164_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm165
 */
#define XLPD_XPPU_APERPERM_165    ( ( XLPD_XPPU_BASEADDR ) + 0x00001294UL )
#define XLPD_XPPU_APERPERM_165_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_165_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_165_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_165_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_165_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_165_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_165_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_165_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_165_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_165_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_165_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_165_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_165_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm166
 */
#define XLPD_XPPU_APERPERM_166    ( ( XLPD_XPPU_BASEADDR ) + 0x00001298UL )
#define XLPD_XPPU_APERPERM_166_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_166_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_166_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_166_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_166_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_166_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_166_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_166_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_166_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_166_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_166_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_166_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_166_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm167
 */
#define XLPD_XPPU_APERPERM_167    ( ( XLPD_XPPU_BASEADDR ) + 0x0000129CUL )
#define XLPD_XPPU_APERPERM_167_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_167_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_167_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_167_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_167_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_167_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_167_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_167_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_167_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_167_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_167_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_167_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_167_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm168
 */
#define XLPD_XPPU_APERPERM_168    ( ( XLPD_XPPU_BASEADDR ) + 0x000012A0UL )
#define XLPD_XPPU_APERPERM_168_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_168_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_168_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_168_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_168_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_168_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_168_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_168_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_168_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_168_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_168_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_168_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_168_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm169
 */
#define XLPD_XPPU_APERPERM_169    ( ( XLPD_XPPU_BASEADDR ) + 0x000012A4UL )
#define XLPD_XPPU_APERPERM_169_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_169_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_169_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_169_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_169_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_169_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_169_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_169_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_169_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_169_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_169_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_169_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_169_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm170
 */
#define XLPD_XPPU_APERPERM_170    ( ( XLPD_XPPU_BASEADDR ) + 0x000012A8UL )
#define XLPD_XPPU_APERPERM_170_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_170_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_170_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_170_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_170_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_170_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_170_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_170_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_170_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_170_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_170_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_170_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_170_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm171
 */
#define XLPD_XPPU_APERPERM_171    ( ( XLPD_XPPU_BASEADDR ) + 0x000012ACUL )
#define XLPD_XPPU_APERPERM_171_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_171_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_171_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_171_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_171_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_171_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_171_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_171_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_171_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_171_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_171_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_171_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_171_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm172
 */
#define XLPD_XPPU_APERPERM_172    ( ( XLPD_XPPU_BASEADDR ) + 0x000012B0UL )
#define XLPD_XPPU_APERPERM_172_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_172_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_172_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_172_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_172_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_172_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_172_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_172_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_172_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_172_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_172_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_172_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_172_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm173
 */
#define XLPD_XPPU_APERPERM_173    ( ( XLPD_XPPU_BASEADDR ) + 0x000012B4UL )
#define XLPD_XPPU_APERPERM_173_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_173_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_173_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_173_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_173_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_173_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_173_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_173_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_173_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_173_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_173_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_173_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_173_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm174
 */
#define XLPD_XPPU_APERPERM_174    ( ( XLPD_XPPU_BASEADDR ) + 0x000012B8UL )
#define XLPD_XPPU_APERPERM_174_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_174_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_174_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_174_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_174_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_174_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_174_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_174_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_174_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_174_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_174_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_174_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_174_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm175
 */
#define XLPD_XPPU_APERPERM_175    ( ( XLPD_XPPU_BASEADDR ) + 0x000012BCUL )
#define XLPD_XPPU_APERPERM_175_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_175_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_175_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_175_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_175_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_175_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_175_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_175_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_175_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_175_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_175_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_175_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_175_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm176
 */
#define XLPD_XPPU_APERPERM_176    ( ( XLPD_XPPU_BASEADDR ) + 0x000012C0UL )
#define XLPD_XPPU_APERPERM_176_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_176_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_176_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_176_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_176_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_176_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_176_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_176_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_176_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_176_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_176_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_176_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_176_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm177
 */
#define XLPD_XPPU_APERPERM_177    ( ( XLPD_XPPU_BASEADDR ) + 0x000012C4UL )
#define XLPD_XPPU_APERPERM_177_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_177_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_177_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_177_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_177_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_177_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_177_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_177_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_177_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_177_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_177_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_177_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_177_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm178
 */
#define XLPD_XPPU_APERPERM_178    ( ( XLPD_XPPU_BASEADDR ) + 0x000012C8UL )
#define XLPD_XPPU_APERPERM_178_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_178_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_178_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_178_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_178_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_178_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_178_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_178_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_178_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_178_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_178_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_178_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_178_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm179
 */
#define XLPD_XPPU_APERPERM_179    ( ( XLPD_XPPU_BASEADDR ) + 0x000012CCUL )
#define XLPD_XPPU_APERPERM_179_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_179_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_179_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_179_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_179_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_179_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_179_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_179_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_179_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_179_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_179_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_179_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_179_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm180
 */
#define XLPD_XPPU_APERPERM_180    ( ( XLPD_XPPU_BASEADDR ) + 0x000012D0UL )
#define XLPD_XPPU_APERPERM_180_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_180_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_180_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_180_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_180_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_180_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_180_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_180_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_180_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_180_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_180_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_180_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_180_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm181
 */
#define XLPD_XPPU_APERPERM_181    ( ( XLPD_XPPU_BASEADDR ) + 0x000012D4UL )
#define XLPD_XPPU_APERPERM_181_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_181_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_181_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_181_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_181_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_181_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_181_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_181_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_181_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_181_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_181_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_181_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_181_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm182
 */
#define XLPD_XPPU_APERPERM_182    ( ( XLPD_XPPU_BASEADDR ) + 0x000012D8UL )
#define XLPD_XPPU_APERPERM_182_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_182_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_182_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_182_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_182_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_182_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_182_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_182_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_182_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_182_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_182_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_182_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_182_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm183
 */
#define XLPD_XPPU_APERPERM_183    ( ( XLPD_XPPU_BASEADDR ) + 0x000012DCUL )
#define XLPD_XPPU_APERPERM_183_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_183_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_183_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_183_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_183_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_183_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_183_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_183_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_183_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_183_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_183_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_183_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_183_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm184
 */
#define XLPD_XPPU_APERPERM_184    ( ( XLPD_XPPU_BASEADDR ) + 0x000012E0UL )
#define XLPD_XPPU_APERPERM_184_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_184_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_184_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_184_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_184_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_184_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_184_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_184_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_184_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_184_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_184_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_184_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_184_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm185
 */
#define XLPD_XPPU_APERPERM_185    ( ( XLPD_XPPU_BASEADDR ) + 0x000012E4UL )
#define XLPD_XPPU_APERPERM_185_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_185_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_185_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_185_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_185_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_185_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_185_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_185_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_185_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_185_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_185_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_185_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_185_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm186
 */
#define XLPD_XPPU_APERPERM_186    ( ( XLPD_XPPU_BASEADDR ) + 0x000012E8UL )
#define XLPD_XPPU_APERPERM_186_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_186_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_186_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_186_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_186_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_186_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_186_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_186_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_186_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_186_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_186_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_186_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_186_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm187
 */
#define XLPD_XPPU_APERPERM_187    ( ( XLPD_XPPU_BASEADDR ) + 0x000012ECUL )
#define XLPD_XPPU_APERPERM_187_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_187_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_187_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_187_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_187_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_187_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_187_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_187_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_187_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_187_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_187_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_187_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_187_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm188
 */
#define XLPD_XPPU_APERPERM_188    ( ( XLPD_XPPU_BASEADDR ) + 0x000012F0UL )
#define XLPD_XPPU_APERPERM_188_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_188_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_188_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_188_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_188_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_188_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_188_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_188_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_188_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_188_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_188_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_188_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_188_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm189
 */
#define XLPD_XPPU_APERPERM_189    ( ( XLPD_XPPU_BASEADDR ) + 0x000012F4UL )
#define XLPD_XPPU_APERPERM_189_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_189_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_189_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_189_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_189_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_189_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_189_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_189_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_189_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_189_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_189_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_189_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_189_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm190
 */
#define XLPD_XPPU_APERPERM_190    ( ( XLPD_XPPU_BASEADDR ) + 0x000012F8UL )
#define XLPD_XPPU_APERPERM_190_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_190_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_190_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_190_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_190_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_190_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_190_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_190_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_190_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_190_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_190_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_190_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_190_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm191
 */
#define XLPD_XPPU_APERPERM_191    ( ( XLPD_XPPU_BASEADDR ) + 0x000012FCUL )
#define XLPD_XPPU_APERPERM_191_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_191_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_191_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_191_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_191_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_191_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_191_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_191_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_191_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_191_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_191_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_191_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_191_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm192
 */
#define XLPD_XPPU_APERPERM_192    ( ( XLPD_XPPU_BASEADDR ) + 0x00001300UL )
#define XLPD_XPPU_APERPERM_192_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_192_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_192_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_192_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_192_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_192_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_192_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_192_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_192_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_192_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_192_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_192_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_192_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm193
 */
#define XLPD_XPPU_APERPERM_193    ( ( XLPD_XPPU_BASEADDR ) + 0x00001304UL )
#define XLPD_XPPU_APERPERM_193_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_193_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_193_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_193_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_193_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_193_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_193_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_193_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_193_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_193_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_193_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_193_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_193_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm194
 */
#define XLPD_XPPU_APERPERM_194    ( ( XLPD_XPPU_BASEADDR ) + 0x00001308UL )
#define XLPD_XPPU_APERPERM_194_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_194_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_194_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_194_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_194_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_194_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_194_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_194_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_194_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_194_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_194_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_194_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_194_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm195
 */
#define XLPD_XPPU_APERPERM_195    ( ( XLPD_XPPU_BASEADDR ) + 0x0000130CUL )
#define XLPD_XPPU_APERPERM_195_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_195_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_195_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_195_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_195_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_195_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_195_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_195_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_195_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_195_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_195_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_195_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_195_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm196
 */
#define XLPD_XPPU_APERPERM_196    ( ( XLPD_XPPU_BASEADDR ) + 0x00001310UL )
#define XLPD_XPPU_APERPERM_196_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_196_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_196_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_196_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_196_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_196_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_196_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_196_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_196_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_196_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_196_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_196_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_196_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm197
 */
#define XLPD_XPPU_APERPERM_197    ( ( XLPD_XPPU_BASEADDR ) + 0x00001314UL )
#define XLPD_XPPU_APERPERM_197_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_197_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_197_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_197_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_197_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_197_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_197_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_197_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_197_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_197_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_197_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_197_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_197_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm198
 */
#define XLPD_XPPU_APERPERM_198    ( ( XLPD_XPPU_BASEADDR ) + 0x00001318UL )
#define XLPD_XPPU_APERPERM_198_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_198_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_198_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_198_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_198_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_198_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_198_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_198_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_198_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_198_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_198_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_198_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_198_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm199
 */
#define XLPD_XPPU_APERPERM_199    ( ( XLPD_XPPU_BASEADDR ) + 0x0000131CUL )
#define XLPD_XPPU_APERPERM_199_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_199_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_199_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_199_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_199_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_199_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_199_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_199_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_199_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_199_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_199_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_199_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_199_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm200
 */
#define XLPD_XPPU_APERPERM_200    ( ( XLPD_XPPU_BASEADDR ) + 0x00001320UL )
#define XLPD_XPPU_APERPERM_200_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_200_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_200_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_200_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_200_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_200_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_200_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_200_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_200_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_200_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_200_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_200_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_200_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm201
 */
#define XLPD_XPPU_APERPERM_201    ( ( XLPD_XPPU_BASEADDR ) + 0x00001324UL )
#define XLPD_XPPU_APERPERM_201_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_201_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_201_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_201_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_201_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_201_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_201_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_201_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_201_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_201_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_201_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_201_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_201_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm202
 */
#define XLPD_XPPU_APERPERM_202    ( ( XLPD_XPPU_BASEADDR ) + 0x00001328UL )
#define XLPD_XPPU_APERPERM_202_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_202_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_202_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_202_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_202_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_202_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_202_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_202_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_202_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_202_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_202_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_202_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_202_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm203
 */
#define XLPD_XPPU_APERPERM_203    ( ( XLPD_XPPU_BASEADDR ) + 0x0000132CUL )
#define XLPD_XPPU_APERPERM_203_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_203_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_203_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_203_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_203_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_203_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_203_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_203_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_203_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_203_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_203_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_203_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_203_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm204
 */
#define XLPD_XPPU_APERPERM_204    ( ( XLPD_XPPU_BASEADDR ) + 0x00001330UL )
#define XLPD_XPPU_APERPERM_204_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_204_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_204_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_204_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_204_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_204_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_204_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_204_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_204_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_204_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_204_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_204_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_204_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm205
 */
#define XLPD_XPPU_APERPERM_205    ( ( XLPD_XPPU_BASEADDR ) + 0x00001334UL )
#define XLPD_XPPU_APERPERM_205_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_205_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_205_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_205_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_205_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_205_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_205_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_205_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_205_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_205_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_205_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_205_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_205_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm206
 */
#define XLPD_XPPU_APERPERM_206    ( ( XLPD_XPPU_BASEADDR ) + 0x00001338UL )
#define XLPD_XPPU_APERPERM_206_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_206_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_206_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_206_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_206_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_206_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_206_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_206_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_206_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_206_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_206_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_206_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_206_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm207
 */
#define XLPD_XPPU_APERPERM_207    ( ( XLPD_XPPU_BASEADDR ) + 0x0000133CUL )
#define XLPD_XPPU_APERPERM_207_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_207_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_207_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_207_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_207_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_207_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_207_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_207_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_207_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_207_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_207_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_207_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_207_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm208
 */
#define XLPD_XPPU_APERPERM_208    ( ( XLPD_XPPU_BASEADDR ) + 0x00001340UL )
#define XLPD_XPPU_APERPERM_208_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_208_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_208_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_208_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_208_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_208_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_208_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_208_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_208_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_208_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_208_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_208_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_208_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm209
 */
#define XLPD_XPPU_APERPERM_209    ( ( XLPD_XPPU_BASEADDR ) + 0x00001344UL )
#define XLPD_XPPU_APERPERM_209_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_209_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_209_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_209_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_209_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_209_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_209_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_209_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_209_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_209_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_209_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_209_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_209_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm210
 */
#define XLPD_XPPU_APERPERM_210    ( ( XLPD_XPPU_BASEADDR ) + 0x00001348UL )
#define XLPD_XPPU_APERPERM_210_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_210_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_210_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_210_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_210_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_210_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_210_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_210_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_210_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_210_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_210_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_210_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_210_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm211
 */
#define XLPD_XPPU_APERPERM_211    ( ( XLPD_XPPU_BASEADDR ) + 0x0000134CUL )
#define XLPD_XPPU_APERPERM_211_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_211_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_211_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_211_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_211_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_211_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_211_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_211_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_211_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_211_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_211_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_211_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_211_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm212
 */
#define XLPD_XPPU_APERPERM_212    ( ( XLPD_XPPU_BASEADDR ) + 0x00001350UL )
#define XLPD_XPPU_APERPERM_212_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_212_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_212_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_212_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_212_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_212_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_212_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_212_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_212_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_212_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_212_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_212_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_212_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm213
 */
#define XLPD_XPPU_APERPERM_213    ( ( XLPD_XPPU_BASEADDR ) + 0x00001354UL )
#define XLPD_XPPU_APERPERM_213_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_213_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_213_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_213_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_213_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_213_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_213_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_213_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_213_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_213_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_213_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_213_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_213_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm214
 */
#define XLPD_XPPU_APERPERM_214    ( ( XLPD_XPPU_BASEADDR ) + 0x00001358UL )
#define XLPD_XPPU_APERPERM_214_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_214_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_214_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_214_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_214_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_214_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_214_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_214_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_214_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_214_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_214_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_214_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_214_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm215
 */
#define XLPD_XPPU_APERPERM_215    ( ( XLPD_XPPU_BASEADDR ) + 0x0000135CUL )
#define XLPD_XPPU_APERPERM_215_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_215_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_215_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_215_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_215_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_215_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_215_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_215_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_215_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_215_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_215_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_215_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_215_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm216
 */
#define XLPD_XPPU_APERPERM_216    ( ( XLPD_XPPU_BASEADDR ) + 0x00001360UL )
#define XLPD_XPPU_APERPERM_216_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_216_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_216_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_216_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_216_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_216_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_216_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_216_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_216_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_216_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_216_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_216_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_216_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm217
 */
#define XLPD_XPPU_APERPERM_217    ( ( XLPD_XPPU_BASEADDR ) + 0x00001364UL )
#define XLPD_XPPU_APERPERM_217_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_217_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_217_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_217_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_217_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_217_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_217_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_217_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_217_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_217_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_217_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_217_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_217_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm218
 */
#define XLPD_XPPU_APERPERM_218    ( ( XLPD_XPPU_BASEADDR ) + 0x00001368UL )
#define XLPD_XPPU_APERPERM_218_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_218_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_218_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_218_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_218_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_218_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_218_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_218_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_218_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_218_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_218_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_218_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_218_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm219
 */
#define XLPD_XPPU_APERPERM_219    ( ( XLPD_XPPU_BASEADDR ) + 0x0000136CUL )
#define XLPD_XPPU_APERPERM_219_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_219_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_219_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_219_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_219_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_219_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_219_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_219_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_219_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_219_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_219_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_219_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_219_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm220
 */
#define XLPD_XPPU_APERPERM_220    ( ( XLPD_XPPU_BASEADDR ) + 0x00001370UL )
#define XLPD_XPPU_APERPERM_220_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_220_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_220_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_220_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_220_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_220_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_220_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_220_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_220_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_220_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_220_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_220_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_220_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm221
 */
#define XLPD_XPPU_APERPERM_221    ( ( XLPD_XPPU_BASEADDR ) + 0x00001374UL )
#define XLPD_XPPU_APERPERM_221_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_221_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_221_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_221_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_221_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_221_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_221_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_221_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_221_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_221_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_221_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_221_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_221_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm222
 */
#define XLPD_XPPU_APERPERM_222    ( ( XLPD_XPPU_BASEADDR ) + 0x00001378UL )
#define XLPD_XPPU_APERPERM_222_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_222_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_222_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_222_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_222_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_222_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_222_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_222_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_222_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_222_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_222_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_222_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_222_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm223
 */
#define XLPD_XPPU_APERPERM_223    ( ( XLPD_XPPU_BASEADDR ) + 0x0000137CUL )
#define XLPD_XPPU_APERPERM_223_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_223_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_223_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_223_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_223_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_223_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_223_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_223_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_223_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_223_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_223_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_223_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_223_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm224
 */
#define XLPD_XPPU_APERPERM_224    ( ( XLPD_XPPU_BASEADDR ) + 0x00001380UL )
#define XLPD_XPPU_APERPERM_224_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_224_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_224_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_224_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_224_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_224_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_224_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_224_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_224_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_224_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_224_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_224_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_224_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm225
 */
#define XLPD_XPPU_APERPERM_225    ( ( XLPD_XPPU_BASEADDR ) + 0x00001384UL )
#define XLPD_XPPU_APERPERM_225_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_225_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_225_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_225_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_225_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_225_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_225_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_225_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_225_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_225_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_225_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_225_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_225_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm226
 */
#define XLPD_XPPU_APERPERM_226    ( ( XLPD_XPPU_BASEADDR ) + 0x00001388UL )
#define XLPD_XPPU_APERPERM_226_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_226_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_226_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_226_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_226_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_226_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_226_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_226_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_226_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_226_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_226_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_226_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_226_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm227
 */
#define XLPD_XPPU_APERPERM_227    ( ( XLPD_XPPU_BASEADDR ) + 0x0000138CUL )
#define XLPD_XPPU_APERPERM_227_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_227_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_227_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_227_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_227_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_227_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_227_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_227_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_227_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_227_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_227_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_227_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_227_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm228
 */
#define XLPD_XPPU_APERPERM_228    ( ( XLPD_XPPU_BASEADDR ) + 0x00001390UL )
#define XLPD_XPPU_APERPERM_228_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_228_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_228_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_228_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_228_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_228_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_228_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_228_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_228_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_228_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_228_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_228_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_228_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm229
 */
#define XLPD_XPPU_APERPERM_229    ( ( XLPD_XPPU_BASEADDR ) + 0x00001394UL )
#define XLPD_XPPU_APERPERM_229_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_229_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_229_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_229_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_229_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_229_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_229_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_229_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_229_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_229_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_229_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_229_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_229_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm230
 */
#define XLPD_XPPU_APERPERM_230    ( ( XLPD_XPPU_BASEADDR ) + 0x00001398UL )
#define XLPD_XPPU_APERPERM_230_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_230_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_230_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_230_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_230_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_230_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_230_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_230_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_230_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_230_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_230_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_230_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_230_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm231
 */
#define XLPD_XPPU_APERPERM_231    ( ( XLPD_XPPU_BASEADDR ) + 0x0000139CUL )
#define XLPD_XPPU_APERPERM_231_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_231_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_231_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_231_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_231_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_231_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_231_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_231_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_231_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_231_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_231_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_231_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_231_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm232
 */
#define XLPD_XPPU_APERPERM_232    ( ( XLPD_XPPU_BASEADDR ) + 0x000013A0UL )
#define XLPD_XPPU_APERPERM_232_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_232_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_232_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_232_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_232_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_232_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_232_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_232_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_232_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_232_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_232_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_232_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_232_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm233
 */
#define XLPD_XPPU_APERPERM_233    ( ( XLPD_XPPU_BASEADDR ) + 0x000013A4UL )
#define XLPD_XPPU_APERPERM_233_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_233_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_233_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_233_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_233_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_233_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_233_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_233_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_233_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_233_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_233_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_233_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_233_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm234
 */
#define XLPD_XPPU_APERPERM_234    ( ( XLPD_XPPU_BASEADDR ) + 0x000013A8UL )
#define XLPD_XPPU_APERPERM_234_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_234_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_234_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_234_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_234_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_234_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_234_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_234_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_234_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_234_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_234_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_234_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_234_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm235
 */
#define XLPD_XPPU_APERPERM_235    ( ( XLPD_XPPU_BASEADDR ) + 0x000013ACUL )
#define XLPD_XPPU_APERPERM_235_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_235_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_235_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_235_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_235_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_235_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_235_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_235_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_235_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_235_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_235_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_235_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_235_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm236
 */
#define XLPD_XPPU_APERPERM_236    ( ( XLPD_XPPU_BASEADDR ) + 0x000013B0UL )
#define XLPD_XPPU_APERPERM_236_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_236_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_236_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_236_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_236_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_236_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_236_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_236_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_236_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_236_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_236_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_236_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_236_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm237
 */
#define XLPD_XPPU_APERPERM_237    ( ( XLPD_XPPU_BASEADDR ) + 0x000013B4UL )
#define XLPD_XPPU_APERPERM_237_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_237_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_237_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_237_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_237_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_237_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_237_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_237_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_237_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_237_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_237_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_237_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_237_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm238
 */
#define XLPD_XPPU_APERPERM_238    ( ( XLPD_XPPU_BASEADDR ) + 0x000013B8UL )
#define XLPD_XPPU_APERPERM_238_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_238_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_238_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_238_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_238_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_238_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_238_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_238_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_238_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_238_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_238_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_238_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_238_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm239
 */
#define XLPD_XPPU_APERPERM_239    ( ( XLPD_XPPU_BASEADDR ) + 0x000013BCUL )
#define XLPD_XPPU_APERPERM_239_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_239_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_239_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_239_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_239_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_239_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_239_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_239_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_239_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_239_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_239_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_239_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_239_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm240
 */
#define XLPD_XPPU_APERPERM_240    ( ( XLPD_XPPU_BASEADDR ) + 0x000013C0UL )
#define XLPD_XPPU_APERPERM_240_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_240_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_240_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_240_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_240_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_240_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_240_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_240_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_240_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_240_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_240_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_240_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_240_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm241
 */
#define XLPD_XPPU_APERPERM_241    ( ( XLPD_XPPU_BASEADDR ) + 0x000013C4UL )
#define XLPD_XPPU_APERPERM_241_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_241_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_241_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_241_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_241_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_241_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_241_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_241_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_241_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_241_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_241_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_241_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_241_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm242
 */
#define XLPD_XPPU_APERPERM_242    ( ( XLPD_XPPU_BASEADDR ) + 0x000013C8UL )
#define XLPD_XPPU_APERPERM_242_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_242_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_242_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_242_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_242_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_242_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_242_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_242_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_242_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_242_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_242_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_242_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_242_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm243
 */
#define XLPD_XPPU_APERPERM_243    ( ( XLPD_XPPU_BASEADDR ) + 0x000013CCUL )
#define XLPD_XPPU_APERPERM_243_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_243_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_243_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_243_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_243_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_243_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_243_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_243_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_243_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_243_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_243_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_243_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_243_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm244
 */
#define XLPD_XPPU_APERPERM_244    ( ( XLPD_XPPU_BASEADDR ) + 0x000013D0UL )
#define XLPD_XPPU_APERPERM_244_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_244_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_244_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_244_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_244_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_244_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_244_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_244_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_244_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_244_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_244_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_244_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_244_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm245
 */
#define XLPD_XPPU_APERPERM_245    ( ( XLPD_XPPU_BASEADDR ) + 0x000013D4UL )
#define XLPD_XPPU_APERPERM_245_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_245_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_245_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_245_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_245_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_245_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_245_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_245_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_245_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_245_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_245_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_245_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_245_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm246
 */
#define XLPD_XPPU_APERPERM_246    ( ( XLPD_XPPU_BASEADDR ) + 0x000013D8UL )
#define XLPD_XPPU_APERPERM_246_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_246_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_246_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_246_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_246_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_246_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_246_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_246_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_246_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_246_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_246_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_246_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_246_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm247
 */
#define XLPD_XPPU_APERPERM_247    ( ( XLPD_XPPU_BASEADDR ) + 0x000013DCUL )
#define XLPD_XPPU_APERPERM_247_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_247_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_247_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_247_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_247_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_247_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_247_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_247_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_247_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_247_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_247_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_247_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_247_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm248
 */
#define XLPD_XPPU_APERPERM_248    ( ( XLPD_XPPU_BASEADDR ) + 0x000013E0UL )
#define XLPD_XPPU_APERPERM_248_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_248_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_248_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_248_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_248_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_248_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_248_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_248_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_248_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_248_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_248_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_248_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_248_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm249
 */
#define XLPD_XPPU_APERPERM_249    ( ( XLPD_XPPU_BASEADDR ) + 0x000013E4UL )
#define XLPD_XPPU_APERPERM_249_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_249_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_249_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_249_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_249_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_249_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_249_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_249_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_249_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_249_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_249_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_249_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_249_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm250
 */
#define XLPD_XPPU_APERPERM_250    ( ( XLPD_XPPU_BASEADDR ) + 0x000013E8UL )
#define XLPD_XPPU_APERPERM_250_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_250_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_250_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_250_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_250_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_250_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_250_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_250_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_250_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_250_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_250_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_250_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_250_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm251
 */
#define XLPD_XPPU_APERPERM_251    ( ( XLPD_XPPU_BASEADDR ) + 0x000013ECUL )
#define XLPD_XPPU_APERPERM_251_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_251_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_251_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_251_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_251_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_251_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_251_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_251_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_251_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_251_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_251_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_251_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_251_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm252
 */
#define XLPD_XPPU_APERPERM_252    ( ( XLPD_XPPU_BASEADDR ) + 0x000013F0UL )
#define XLPD_XPPU_APERPERM_252_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_252_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_252_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_252_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_252_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_252_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_252_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_252_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_252_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_252_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_252_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_252_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_252_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm253
 */
#define XLPD_XPPU_APERPERM_253    ( ( XLPD_XPPU_BASEADDR ) + 0x000013F4UL )
#define XLPD_XPPU_APERPERM_253_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_253_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_253_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_253_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_253_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_253_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_253_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_253_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_253_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_253_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_253_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_253_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_253_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm254
 */
#define XLPD_XPPU_APERPERM_254    ( ( XLPD_XPPU_BASEADDR ) + 0x000013F8UL )
#define XLPD_XPPU_APERPERM_254_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_254_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_254_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_254_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_254_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_254_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_254_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_254_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_254_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_254_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_254_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_254_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_254_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm255
 */
#define XLPD_XPPU_APERPERM_255    ( ( XLPD_XPPU_BASEADDR ) + 0x000013FCUL )
#define XLPD_XPPU_APERPERM_255_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_255_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_255_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_255_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_255_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_255_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_255_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_255_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_255_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_255_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_255_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_255_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_255_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm384
 */
#define XLPD_XPPU_APERPERM_384    ( ( XLPD_XPPU_BASEADDR ) + 0x00001600UL )
#define XLPD_XPPU_APERPERM_384_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_384_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_384_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_384_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_384_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_384_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_384_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_384_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_384_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_384_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_384_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_384_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_384_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm385
 */
#define XLPD_XPPU_APERPERM_385    ( ( XLPD_XPPU_BASEADDR ) + 0x00001604UL )
#define XLPD_XPPU_APERPERM_385_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_385_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_385_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_385_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_385_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_385_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_385_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_385_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_385_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_385_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_385_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_385_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_385_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm386
 */
#define XLPD_XPPU_APERPERM_386    ( ( XLPD_XPPU_BASEADDR ) + 0x00001608UL )
#define XLPD_XPPU_APERPERM_386_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_386_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_386_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_386_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_386_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_386_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_386_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_386_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_386_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_386_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_386_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_386_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_386_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm387
 */
#define XLPD_XPPU_APERPERM_387    ( ( XLPD_XPPU_BASEADDR ) + 0x0000160CUL )
#define XLPD_XPPU_APERPERM_387_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_387_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_387_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_387_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_387_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_387_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_387_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_387_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_387_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_387_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_387_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_387_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_387_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm388
 */
#define XLPD_XPPU_APERPERM_388    ( ( XLPD_XPPU_BASEADDR ) + 0x00001610UL )
#define XLPD_XPPU_APERPERM_388_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_388_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_388_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_388_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_388_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_388_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_388_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_388_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_388_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_388_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_388_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_388_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_388_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm389
 */
#define XLPD_XPPU_APERPERM_389    ( ( XLPD_XPPU_BASEADDR ) + 0x00001614UL )
#define XLPD_XPPU_APERPERM_389_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_389_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_389_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_389_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_389_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_389_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_389_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_389_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_389_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_389_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_389_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_389_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_389_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm390
 */
#define XLPD_XPPU_APERPERM_390    ( ( XLPD_XPPU_BASEADDR ) + 0x00001618UL )
#define XLPD_XPPU_APERPERM_390_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_390_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_390_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_390_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_390_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_390_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_390_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_390_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_390_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_390_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_390_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_390_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_390_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm391
 */
#define XLPD_XPPU_APERPERM_391    ( ( XLPD_XPPU_BASEADDR ) + 0x0000161CUL )
#define XLPD_XPPU_APERPERM_391_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_391_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_391_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_391_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_391_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_391_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_391_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_391_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_391_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_391_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_391_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_391_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_391_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm392
 */
#define XLPD_XPPU_APERPERM_392    ( ( XLPD_XPPU_BASEADDR ) + 0x00001620UL )
#define XLPD_XPPU_APERPERM_392_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_392_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_392_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_392_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_392_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_392_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_392_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_392_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_392_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_392_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_392_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_392_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_392_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm393
 */
#define XLPD_XPPU_APERPERM_393    ( ( XLPD_XPPU_BASEADDR ) + 0x00001624UL )
#define XLPD_XPPU_APERPERM_393_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_393_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_393_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_393_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_393_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_393_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_393_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_393_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_393_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_393_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_393_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_393_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_393_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm394
 */
#define XLPD_XPPU_APERPERM_394    ( ( XLPD_XPPU_BASEADDR ) + 0x00001628UL )
#define XLPD_XPPU_APERPERM_394_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_394_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_394_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_394_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_394_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_394_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_394_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_394_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_394_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_394_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_394_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_394_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_394_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm395
 */
#define XLPD_XPPU_APERPERM_395    ( ( XLPD_XPPU_BASEADDR ) + 0x0000162CUL )
#define XLPD_XPPU_APERPERM_395_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_395_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_395_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_395_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_395_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_395_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_395_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_395_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_395_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_395_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_395_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_395_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_395_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm396
 */
#define XLPD_XPPU_APERPERM_396    ( ( XLPD_XPPU_BASEADDR ) + 0x00001630UL )
#define XLPD_XPPU_APERPERM_396_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_396_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_396_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_396_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_396_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_396_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_396_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_396_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_396_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_396_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_396_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_396_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_396_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm397
 */
#define XLPD_XPPU_APERPERM_397    ( ( XLPD_XPPU_BASEADDR ) + 0x00001634UL )
#define XLPD_XPPU_APERPERM_397_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_397_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_397_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_397_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_397_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_397_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_397_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_397_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_397_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_397_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_397_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_397_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_397_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm398
 */
#define XLPD_XPPU_APERPERM_398    ( ( XLPD_XPPU_BASEADDR ) + 0x00001638UL )
#define XLPD_XPPU_APERPERM_398_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_398_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_398_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_398_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_398_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_398_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_398_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_398_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_398_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_398_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_398_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_398_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_398_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm399
 */
#define XLPD_XPPU_APERPERM_399    ( ( XLPD_XPPU_BASEADDR ) + 0x0000163CUL )
#define XLPD_XPPU_APERPERM_399_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_399_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_399_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_399_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_399_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_399_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_399_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_399_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_399_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_399_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_399_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_399_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_399_PERMISSION_DEFVAL  0x0UL

/**
 * Register: XlpdXppuAperperm400
 */
#define XLPD_XPPU_APERPERM_400    ( ( XLPD_XPPU_BASEADDR ) + 0x00001640UL )
#define XLPD_XPPU_APERPERM_400_RSTVAL   0x00000000UL

#define XLPD_XPPU_APERPERM_400_PARITY_SHIFT   28UL
#define XLPD_XPPU_APERPERM_400_PARITY_WIDTH   4UL
#define XLPD_XPPU_APERPERM_400_PARITY_MASK    0xf0000000UL
#define XLPD_XPPU_APERPERM_400_PARITY_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_400_TRUSTZONE_SHIFT   27UL
#define XLPD_XPPU_APERPERM_400_TRUSTZONE_WIDTH   1UL
#define XLPD_XPPU_APERPERM_400_TRUSTZONE_MASK    0x08000000UL
#define XLPD_XPPU_APERPERM_400_TRUSTZONE_DEFVAL  0x0UL

#define XLPD_XPPU_APERPERM_400_PERMISSION_SHIFT   0UL
#define XLPD_XPPU_APERPERM_400_PERMISSION_WIDTH   20UL
#define XLPD_XPPU_APERPERM_400_PERMISSION_MASK    0x000fffffUL
#define XLPD_XPPU_APERPERM_400_PERMISSION_DEFVAL  0x0UL

/**
 *@endcond
 */

#ifdef __cplusplus
}
#endif

#endif /* __XLPD_XPPU_H__ */
