/*******************************************************************************
* Copyright (c) 2018 - 2021 Xilinx, Inc.  All rights reserved.
* SPDX-License-Identifier: MIT
*******************************************************************************/


#ifndef __XOCM_XMPU_H__
#define __XOCM_XMPU_H__


#ifdef __cplusplus
extern "C" {
#endif

/**
 *@cond nocomments
 */

/**
 * XocmXmpu Base Address
 */
#define XOCM_XMPU_BASEADDR      0xFF980000UL

/**
 * Register: XocmXmpuCtrl
 */
#define XOCM_XMPU_CTRL    ( ( XOCM_XMPU_BASEADDR ) + 0x00000000UL )
#define XOCM_XMPU_CTRL_RSTVAL   0x00000013UL

#define XOCM_XMPU_CTRL_DISDEFSREGION_SHIFT   4UL
#define XOCM_XMPU_CTRL_DISDEFSREGION_WIDTH   1UL
#define XOCM_XMPU_CTRL_DISDEFSREGION_MASK    0x00000010UL
#define XOCM_XMPU_CTRL_DISDEFSREGION_DEFVAL  0x1UL

#define XOCM_XMPU_CTRL_ALIGNCFG_SHIFT   3UL
#define XOCM_XMPU_CTRL_ALIGNCFG_WIDTH   1UL
#define XOCM_XMPU_CTRL_ALIGNCFG_MASK    0x00000008UL
#define XOCM_XMPU_CTRL_ALIGNCFG_DEFVAL  0x0UL

#define XOCM_XMPU_CTRL_HIDEALLOWED_SHIFT   2UL
#define XOCM_XMPU_CTRL_HIDEALLOWED_WIDTH   1UL
#define XOCM_XMPU_CTRL_HIDEALLOWED_MASK    0x00000004UL
#define XOCM_XMPU_CTRL_HIDEALLOWED_DEFVAL  0x0UL

#define XOCM_XMPU_CTRL_DEFWRALLOWED_SHIFT   1UL
#define XOCM_XMPU_CTRL_DEFWRALLOWED_WIDTH   1UL
#define XOCM_XMPU_CTRL_DEFWRALLOWED_MASK    0x00000002UL
#define XOCM_XMPU_CTRL_DEFWRALLOWED_DEFVAL  0x1UL

#define XOCM_XMPU_CTRL_DEFRDALLOWED_SHIFT   0UL
#define XOCM_XMPU_CTRL_DEFRDALLOWED_WIDTH   1UL
#define XOCM_XMPU_CTRL_DEFRDALLOWED_MASK    0x00000001UL
#define XOCM_XMPU_CTRL_DEFRDALLOWED_DEFVAL  0x1UL

/**
 * Register: XocmXmpuErrSts1Lo
 */
#define XOCM_XMPU_ERR_STS1_LO    ( ( XOCM_XMPU_BASEADDR ) + 0x00000004UL )
#define XOCM_XMPU_ERR_STS1_LO_RSTVAL   0x00000000UL

#define XOCM_XMPU_ERR_STS1_LO_AXI_ADDR_SHIFT   0UL
#define XOCM_XMPU_ERR_STS1_LO_AXI_ADDR_WIDTH   32UL
#define XOCM_XMPU_ERR_STS1_LO_AXI_ADDR_MASK    0xffffffffUL
#define XOCM_XMPU_ERR_STS1_LO_AXI_ADDR_DEFVAL  0x0UL

/**
 * Register: XocmXmpuErrSts1Hi
 */
#define XOCM_XMPU_ERR_STS1_HI    ( ( XOCM_XMPU_BASEADDR ) + 0x00000008UL )
#define XOCM_XMPU_ERR_STS1_HI_RSTVAL   0x00000000UL

#define XOCM_XMPU_ERR_STS1_HI_AXI_ADDR_SHIFT   0UL
#define XOCM_XMPU_ERR_STS1_HI_AXI_ADDR_WIDTH   12UL
#define XOCM_XMPU_ERR_STS1_HI_AXI_ADDR_MASK    0x00000fffUL
#define XOCM_XMPU_ERR_STS1_HI_AXI_ADDR_DEFVAL  0x0UL

/**
 * Register: XocmXmpuErrSts2
 */
#define XOCM_XMPU_ERR_STS2    ( ( XOCM_XMPU_BASEADDR ) + 0x0000000CUL )
#define XOCM_XMPU_ERR_STS2_RSTVAL   0x00000000UL

#define XOCM_XMPU_ERR_STS2_AXI_ID_SHIFT   0UL
#define XOCM_XMPU_ERR_STS2_AXI_ID_WIDTH   10UL
#define XOCM_XMPU_ERR_STS2_AXI_ID_MASK    0x000003ffUL
#define XOCM_XMPU_ERR_STS2_AXI_ID_DEFVAL  0x0UL

/**
 * Register: XocmXmpuIsr
 */
#define XOCM_XMPU_ISR    ( ( XOCM_XMPU_BASEADDR ) + 0x00000010UL )
#define XOCM_XMPU_ISR_RSTVAL   0x00000000UL

#define XOCM_XMPU_ISR_SECURITYVIO_SHIFT   3UL
#define XOCM_XMPU_ISR_SECURITYVIO_WIDTH   1UL
#define XOCM_XMPU_ISR_SECURITYVIO_MASK    0x00000008UL
#define XOCM_XMPU_ISR_SECURITYVIO_DEFVAL  0x0UL

#define XOCM_XMPU_ISR_WRPERMVIO_SHIFT   2UL
#define XOCM_XMPU_ISR_WRPERMVIO_WIDTH   1UL
#define XOCM_XMPU_ISR_WRPERMVIO_MASK    0x00000004UL
#define XOCM_XMPU_ISR_WRPERMVIO_DEFVAL  0x0UL

#define XOCM_XMPU_ISR_RDPERMVIO_SHIFT   1UL
#define XOCM_XMPU_ISR_RDPERMVIO_WIDTH   1UL
#define XOCM_XMPU_ISR_RDPERMVIO_MASK    0x00000002UL
#define XOCM_XMPU_ISR_RDPERMVIO_DEFVAL  0x0UL

#define XOCM_XMPU_ISR_INV_APB_SHIFT   0UL
#define XOCM_XMPU_ISR_INV_APB_WIDTH   1UL
#define XOCM_XMPU_ISR_INV_APB_MASK    0x00000001UL
#define XOCM_XMPU_ISR_INV_APB_DEFVAL  0x0UL

/**
 * Register: XocmXmpuImr
 */
#define XOCM_XMPU_IMR    ( ( XOCM_XMPU_BASEADDR ) + 0x00000014UL )
#define XOCM_XMPU_IMR_RSTVAL   0x0000000fUL

#define XOCM_XMPU_IMR_SECURITYVIO_SHIFT   3UL
#define XOCM_XMPU_IMR_SECURITYVIO_WIDTH   1UL
#define XOCM_XMPU_IMR_SECURITYVIO_MASK    0x00000008UL
#define XOCM_XMPU_IMR_SECURITYVIO_DEFVAL  0x1UL

#define XOCM_XMPU_IMR_WRPERMVIO_SHIFT   2UL
#define XOCM_XMPU_IMR_WRPERMVIO_WIDTH   1UL
#define XOCM_XMPU_IMR_WRPERMVIO_MASK    0x00000004UL
#define XOCM_XMPU_IMR_WRPERMVIO_DEFVAL  0x1UL

#define XOCM_XMPU_IMR_RDPERMVIO_SHIFT   1UL
#define XOCM_XMPU_IMR_RDPERMVIO_WIDTH   1UL
#define XOCM_XMPU_IMR_RDPERMVIO_MASK    0x00000002UL
#define XOCM_XMPU_IMR_RDPERMVIO_DEFVAL  0x1UL

#define XOCM_XMPU_IMR_INV_APB_SHIFT   0UL
#define XOCM_XMPU_IMR_INV_APB_WIDTH   1UL
#define XOCM_XMPU_IMR_INV_APB_MASK    0x00000001UL
#define XOCM_XMPU_IMR_INV_APB_DEFVAL  0x1UL

/**
 * Register: XocmXmpuIen
 */
#define XOCM_XMPU_IEN    ( ( XOCM_XMPU_BASEADDR ) + 0x00000018UL )
#define XOCM_XMPU_IEN_RSTVAL   0x00000000UL

#define XOCM_XMPU_IEN_SECURITYVIO_SHIFT   3UL
#define XOCM_XMPU_IEN_SECURITYVIO_WIDTH   1UL
#define XOCM_XMPU_IEN_SECURITYVIO_MASK    0x00000008UL
#define XOCM_XMPU_IEN_SECURITYVIO_DEFVAL  0x0UL

#define XOCM_XMPU_IEN_WRPERMVIO_SHIFT   2UL
#define XOCM_XMPU_IEN_WRPERMVIO_WIDTH   1UL
#define XOCM_XMPU_IEN_WRPERMVIO_MASK    0x00000004UL
#define XOCM_XMPU_IEN_WRPERMVIO_DEFVAL  0x0UL

#define XOCM_XMPU_IEN_RDPERMVIO_SHIFT   1UL
#define XOCM_XMPU_IEN_RDPERMVIO_WIDTH   1UL
#define XOCM_XMPU_IEN_RDPERMVIO_MASK    0x00000002UL
#define XOCM_XMPU_IEN_RDPERMVIO_DEFVAL  0x0UL

#define XOCM_XMPU_IEN_INV_APB_SHIFT   0UL
#define XOCM_XMPU_IEN_INV_APB_WIDTH   1UL
#define XOCM_XMPU_IEN_INV_APB_MASK    0x00000001UL
#define XOCM_XMPU_IEN_INV_APB_DEFVAL  0x0UL

/**
 * Register: XocmXmpuIds
 */
#define XOCM_XMPU_IDS    ( ( XOCM_XMPU_BASEADDR ) + 0x0000001CUL )
#define XOCM_XMPU_IDS_RSTVAL   0x00000000UL

#define XOCM_XMPU_IDS_SECURITYVIO_SHIFT   3UL
#define XOCM_XMPU_IDS_SECURITYVIO_WIDTH   1UL
#define XOCM_XMPU_IDS_SECURITYVIO_MASK    0x00000008UL
#define XOCM_XMPU_IDS_SECURITYVIO_DEFVAL  0x0UL

#define XOCM_XMPU_IDS_WRPERMVIO_SHIFT   2UL
#define XOCM_XMPU_IDS_WRPERMVIO_WIDTH   1UL
#define XOCM_XMPU_IDS_WRPERMVIO_MASK    0x00000004UL
#define XOCM_XMPU_IDS_WRPERMVIO_DEFVAL  0x0UL

#define XOCM_XMPU_IDS_RDPERMVIO_SHIFT   1UL
#define XOCM_XMPU_IDS_RDPERMVIO_WIDTH   1UL
#define XOCM_XMPU_IDS_RDPERMVIO_MASK    0x00000002UL
#define XOCM_XMPU_IDS_RDPERMVIO_DEFVAL  0x0UL

#define XOCM_XMPU_IDS_INV_APB_SHIFT   0UL
#define XOCM_XMPU_IDS_INV_APB_WIDTH   1UL
#define XOCM_XMPU_IDS_INV_APB_MASK    0x00000001UL
#define XOCM_XMPU_IDS_INV_APB_DEFVAL  0x0UL

/**
 * Register: XocmXmpuLock
 */
#define XOCM_XMPU_LOCK    ( ( XOCM_XMPU_BASEADDR ) + 0x00000020UL )
#define XOCM_XMPU_LOCK_RSTVAL   0x00000000UL

#define XOCM_XMPU_LOCK_REGWRDIS_SHIFT   0UL
#define XOCM_XMPU_LOCK_REGWRDIS_WIDTH   1UL
#define XOCM_XMPU_LOCK_REGWRDIS_MASK    0x00000001UL
#define XOCM_XMPU_LOCK_REGWRDIS_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR00StartLo
 */
#define XOCM_XMPU_R00_START_LO    ( ( XOCM_XMPU_BASEADDR ) + 0x00000100UL )
#define XOCM_XMPU_R00_START_LO_RSTVAL   0x00000000UL

#define XOCM_XMPU_R00_START_LO_ADDR_SHIFT   0UL
#define XOCM_XMPU_R00_START_LO_ADDR_WIDTH   32UL
#define XOCM_XMPU_R00_START_LO_ADDR_MASK    0xffffffffUL
#define XOCM_XMPU_R00_START_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR00StartHi
 */
#define XOCM_XMPU_R00_START_HI    ( ( XOCM_XMPU_BASEADDR ) + 0x00000104UL )
#define XOCM_XMPU_R00_START_HI_RSTVAL   0x00000000UL

#define XOCM_XMPU_R00_START_HI_ADDR_SHIFT   0UL
#define XOCM_XMPU_R00_START_HI_ADDR_WIDTH   12UL
#define XOCM_XMPU_R00_START_HI_ADDR_MASK    0x00000fffUL
#define XOCM_XMPU_R00_START_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR00EndLo
 */
#define XOCM_XMPU_R00_END_LO    ( ( XOCM_XMPU_BASEADDR ) + 0x00000108UL )
#define XOCM_XMPU_R00_END_LO_RSTVAL   0x00000000UL

#define XOCM_XMPU_R00_END_LO_ADDR_SHIFT   0UL
#define XOCM_XMPU_R00_END_LO_ADDR_WIDTH   32UL
#define XOCM_XMPU_R00_END_LO_ADDR_MASK    0xffffffffUL
#define XOCM_XMPU_R00_END_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR00EndHi
 */
#define XOCM_XMPU_R00_END_HI    ( ( XOCM_XMPU_BASEADDR ) + 0x0000010CUL )
#define XOCM_XMPU_R00_END_HI_RSTVAL   0x00000000UL

#define XOCM_XMPU_R00_END_HI_ADDR_SHIFT   0UL
#define XOCM_XMPU_R00_END_HI_ADDR_WIDTH   12UL
#define XOCM_XMPU_R00_END_HI_ADDR_MASK    0x00000fffUL
#define XOCM_XMPU_R00_END_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR00Master
 */
#define XOCM_XMPU_R00_MASTER    ( ( XOCM_XMPU_BASEADDR ) + 0x00000110UL )
#define XOCM_XMPU_R00_MASTER_RSTVAL   0x00000000UL

#define XOCM_XMPU_R00_MASTER_MSK_SHIFT   16UL
#define XOCM_XMPU_R00_MASTER_MSK_WIDTH   10UL
#define XOCM_XMPU_R00_MASTER_MSK_MASK    0x03ff0000UL
#define XOCM_XMPU_R00_MASTER_MSK_DEFVAL  0x0UL

#define XOCM_XMPU_R00_MASTER_ID_SHIFT   0UL
#define XOCM_XMPU_R00_MASTER_ID_WIDTH   10UL
#define XOCM_XMPU_R00_MASTER_ID_MASK    0x000003ffUL
#define XOCM_XMPU_R00_MASTER_ID_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR00Cfg
 */
#define XOCM_XMPU_R00_CFG    ( ( XOCM_XMPU_BASEADDR ) + 0x00000114UL )
#define XOCM_XMPU_R00_CFG_RSTVAL   0x00000008UL

#define XOCM_XMPU_R00_CFG_NSCHECKTYPE_SHIFT   4UL
#define XOCM_XMPU_R00_CFG_NSCHECKTYPE_WIDTH   1UL
#define XOCM_XMPU_R00_CFG_NSCHECKTYPE_MASK    0x00000010UL
#define XOCM_XMPU_R00_CFG_NSCHECKTYPE_DEFVAL  0x0UL

#define XOCM_XMPU_R00_CFG_REGIONNS_SHIFT   3UL
#define XOCM_XMPU_R00_CFG_REGIONNS_WIDTH   1UL
#define XOCM_XMPU_R00_CFG_REGIONNS_MASK    0x00000008UL
#define XOCM_XMPU_R00_CFG_REGIONNS_DEFVAL  0x1UL

#define XOCM_XMPU_R00_CFG_WRALLOWED_SHIFT   2UL
#define XOCM_XMPU_R00_CFG_WRALLOWED_WIDTH   1UL
#define XOCM_XMPU_R00_CFG_WRALLOWED_MASK    0x00000004UL
#define XOCM_XMPU_R00_CFG_WRALLOWED_DEFVAL  0x0UL

#define XOCM_XMPU_R00_CFG_RDALLOWED_SHIFT   1UL
#define XOCM_XMPU_R00_CFG_RDALLOWED_WIDTH   1UL
#define XOCM_XMPU_R00_CFG_RDALLOWED_MASK    0x00000002UL
#define XOCM_XMPU_R00_CFG_RDALLOWED_DEFVAL  0x0UL

#define XOCM_XMPU_R00_CFG_EN_SHIFT   0UL
#define XOCM_XMPU_R00_CFG_EN_WIDTH   1UL
#define XOCM_XMPU_R00_CFG_EN_MASK    0x00000001UL
#define XOCM_XMPU_R00_CFG_EN_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR01StartLo
 */
#define XOCM_XMPU_R01_START_LO    ( ( XOCM_XMPU_BASEADDR ) + 0x00000118UL )
#define XOCM_XMPU_R01_START_LO_RSTVAL   0x00000000UL

#define XOCM_XMPU_R01_START_LO_ADDR_SHIFT   0UL
#define XOCM_XMPU_R01_START_LO_ADDR_WIDTH   32UL
#define XOCM_XMPU_R01_START_LO_ADDR_MASK    0xffffffffUL
#define XOCM_XMPU_R01_START_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR01StartHi
 */
#define XOCM_XMPU_R01_START_HI    ( ( XOCM_XMPU_BASEADDR ) + 0x0000011CUL )
#define XOCM_XMPU_R01_START_HI_RSTVAL   0x00000000UL

#define XOCM_XMPU_R01_START_HI_ADDR_SHIFT   0UL
#define XOCM_XMPU_R01_START_HI_ADDR_WIDTH   12UL
#define XOCM_XMPU_R01_START_HI_ADDR_MASK    0x00000fffUL
#define XOCM_XMPU_R01_START_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR01EndLo
 */
#define XOCM_XMPU_R01_END_LO    ( ( XOCM_XMPU_BASEADDR ) + 0x00000120UL )
#define XOCM_XMPU_R01_END_LO_RSTVAL   0x00000000UL

#define XOCM_XMPU_R01_END_LO_ADDR_SHIFT   0UL
#define XOCM_XMPU_R01_END_LO_ADDR_WIDTH   32UL
#define XOCM_XMPU_R01_END_LO_ADDR_MASK    0xffffffffUL
#define XOCM_XMPU_R01_END_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR01EndHi
 */
#define XOCM_XMPU_R01_END_HI    ( ( XOCM_XMPU_BASEADDR ) + 0x00000124UL )
#define XOCM_XMPU_R01_END_HI_RSTVAL   0x00000000UL

#define XOCM_XMPU_R01_END_HI_ADDR_SHIFT   0UL
#define XOCM_XMPU_R01_END_HI_ADDR_WIDTH   12UL
#define XOCM_XMPU_R01_END_HI_ADDR_MASK    0x00000fffUL
#define XOCM_XMPU_R01_END_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR01Master
 */
#define XOCM_XMPU_R01_MASTER    ( ( XOCM_XMPU_BASEADDR ) + 0x00000128UL )
#define XOCM_XMPU_R01_MASTER_RSTVAL   0x00000000UL

#define XOCM_XMPU_R01_MASTER_MSK_SHIFT   16UL
#define XOCM_XMPU_R01_MASTER_MSK_WIDTH   10UL
#define XOCM_XMPU_R01_MASTER_MSK_MASK    0x03ff0000UL
#define XOCM_XMPU_R01_MASTER_MSK_DEFVAL  0x0UL

#define XOCM_XMPU_R01_MASTER_ID_SHIFT   0UL
#define XOCM_XMPU_R01_MASTER_ID_WIDTH   10UL
#define XOCM_XMPU_R01_MASTER_ID_MASK    0x000003ffUL
#define XOCM_XMPU_R01_MASTER_ID_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR01Cfg
 */
#define XOCM_XMPU_R01_CFG    ( ( XOCM_XMPU_BASEADDR ) + 0x0000012CUL )
#define XOCM_XMPU_R01_CFG_RSTVAL   0x00000008UL

#define XOCM_XMPU_R01_CFG_NSCHECKTYPE_SHIFT   4UL
#define XOCM_XMPU_R01_CFG_NSCHECKTYPE_WIDTH   1UL
#define XOCM_XMPU_R01_CFG_NSCHECKTYPE_MASK    0x00000010UL
#define XOCM_XMPU_R01_CFG_NSCHECKTYPE_DEFVAL  0x0UL

#define XOCM_XMPU_R01_CFG_REGIONNS_SHIFT   3UL
#define XOCM_XMPU_R01_CFG_REGIONNS_WIDTH   1UL
#define XOCM_XMPU_R01_CFG_REGIONNS_MASK    0x00000008UL
#define XOCM_XMPU_R01_CFG_REGIONNS_DEFVAL  0x1UL

#define XOCM_XMPU_R01_CFG_WRALLOWED_SHIFT   2UL
#define XOCM_XMPU_R01_CFG_WRALLOWED_WIDTH   1UL
#define XOCM_XMPU_R01_CFG_WRALLOWED_MASK    0x00000004UL
#define XOCM_XMPU_R01_CFG_WRALLOWED_DEFVAL  0x0UL

#define XOCM_XMPU_R01_CFG_RDALLOWED_SHIFT   1UL
#define XOCM_XMPU_R01_CFG_RDALLOWED_WIDTH   1UL
#define XOCM_XMPU_R01_CFG_RDALLOWED_MASK    0x00000002UL
#define XOCM_XMPU_R01_CFG_RDALLOWED_DEFVAL  0x0UL

#define XOCM_XMPU_R01_CFG_EN_SHIFT   0UL
#define XOCM_XMPU_R01_CFG_EN_WIDTH   1UL
#define XOCM_XMPU_R01_CFG_EN_MASK    0x00000001UL
#define XOCM_XMPU_R01_CFG_EN_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR02StartLo
 */
#define XOCM_XMPU_R02_START_LO    ( ( XOCM_XMPU_BASEADDR ) + 0x00000130UL )
#define XOCM_XMPU_R02_START_LO_RSTVAL   0x00000000UL

#define XOCM_XMPU_R02_START_LO_ADDR_SHIFT   0UL
#define XOCM_XMPU_R02_START_LO_ADDR_WIDTH   32UL
#define XOCM_XMPU_R02_START_LO_ADDR_MASK    0xffffffffUL
#define XOCM_XMPU_R02_START_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR02StartHi
 */
#define XOCM_XMPU_R02_START_HI    ( ( XOCM_XMPU_BASEADDR ) + 0x00000134UL )
#define XOCM_XMPU_R02_START_HI_RSTVAL   0x00000000UL

#define XOCM_XMPU_R02_START_HI_ADDR_SHIFT   0UL
#define XOCM_XMPU_R02_START_HI_ADDR_WIDTH   12UL
#define XOCM_XMPU_R02_START_HI_ADDR_MASK    0x00000fffUL
#define XOCM_XMPU_R02_START_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR02EndLo
 */
#define XOCM_XMPU_R02_END_LO    ( ( XOCM_XMPU_BASEADDR ) + 0x00000138UL )
#define XOCM_XMPU_R02_END_LO_RSTVAL   0x00000000UL

#define XOCM_XMPU_R02_END_LO_ADDR_SHIFT   0UL
#define XOCM_XMPU_R02_END_LO_ADDR_WIDTH   32UL
#define XOCM_XMPU_R02_END_LO_ADDR_MASK    0xffffffffUL
#define XOCM_XMPU_R02_END_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR02EndHi
 */
#define XOCM_XMPU_R02_END_HI    ( ( XOCM_XMPU_BASEADDR ) + 0x0000013CUL )
#define XOCM_XMPU_R02_END_HI_RSTVAL   0x00000000UL

#define XOCM_XMPU_R02_END_HI_ADDR_SHIFT   0UL
#define XOCM_XMPU_R02_END_HI_ADDR_WIDTH   12UL
#define XOCM_XMPU_R02_END_HI_ADDR_MASK    0x00000fffUL
#define XOCM_XMPU_R02_END_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR02Master
 */
#define XOCM_XMPU_R02_MASTER    ( ( XOCM_XMPU_BASEADDR ) + 0x00000140UL )
#define XOCM_XMPU_R02_MASTER_RSTVAL   0x00000000UL

#define XOCM_XMPU_R02_MASTER_MSK_SHIFT   16UL
#define XOCM_XMPU_R02_MASTER_MSK_WIDTH   10UL
#define XOCM_XMPU_R02_MASTER_MSK_MASK    0x03ff0000UL
#define XOCM_XMPU_R02_MASTER_MSK_DEFVAL  0x0UL

#define XOCM_XMPU_R02_MASTER_ID_SHIFT   0UL
#define XOCM_XMPU_R02_MASTER_ID_WIDTH   10UL
#define XOCM_XMPU_R02_MASTER_ID_MASK    0x000003ffUL
#define XOCM_XMPU_R02_MASTER_ID_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR02Cfg
 */
#define XOCM_XMPU_R02_CFG    ( ( XOCM_XMPU_BASEADDR ) + 0x00000144UL )
#define XOCM_XMPU_R02_CFG_RSTVAL   0x00000008UL

#define XOCM_XMPU_R02_CFG_NSCHECKTYPE_SHIFT   4UL
#define XOCM_XMPU_R02_CFG_NSCHECKTYPE_WIDTH   1UL
#define XOCM_XMPU_R02_CFG_NSCHECKTYPE_MASK    0x00000010UL
#define XOCM_XMPU_R02_CFG_NSCHECKTYPE_DEFVAL  0x0UL

#define XOCM_XMPU_R02_CFG_REGIONNS_SHIFT   3UL
#define XOCM_XMPU_R02_CFG_REGIONNS_WIDTH   1UL
#define XOCM_XMPU_R02_CFG_REGIONNS_MASK    0x00000008UL
#define XOCM_XMPU_R02_CFG_REGIONNS_DEFVAL  0x1UL

#define XOCM_XMPU_R02_CFG_WRALLOWED_SHIFT   2UL
#define XOCM_XMPU_R02_CFG_WRALLOWED_WIDTH   1UL
#define XOCM_XMPU_R02_CFG_WRALLOWED_MASK    0x00000004UL
#define XOCM_XMPU_R02_CFG_WRALLOWED_DEFVAL  0x0UL

#define XOCM_XMPU_R02_CFG_RDALLOWED_SHIFT   1UL
#define XOCM_XMPU_R02_CFG_RDALLOWED_WIDTH   1UL
#define XOCM_XMPU_R02_CFG_RDALLOWED_MASK    0x00000002UL
#define XOCM_XMPU_R02_CFG_RDALLOWED_DEFVAL  0x0UL

#define XOCM_XMPU_R02_CFG_EN_SHIFT   0UL
#define XOCM_XMPU_R02_CFG_EN_WIDTH   1UL
#define XOCM_XMPU_R02_CFG_EN_MASK    0x00000001UL
#define XOCM_XMPU_R02_CFG_EN_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR03StartLo
 */
#define XOCM_XMPU_R03_START_LO    ( ( XOCM_XMPU_BASEADDR ) + 0x00000148UL )
#define XOCM_XMPU_R03_START_LO_RSTVAL   0x00000000UL

#define XOCM_XMPU_R03_START_LO_ADDR_SHIFT   0UL
#define XOCM_XMPU_R03_START_LO_ADDR_WIDTH   32UL
#define XOCM_XMPU_R03_START_LO_ADDR_MASK    0xffffffffUL
#define XOCM_XMPU_R03_START_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR03StartHi
 */
#define XOCM_XMPU_R03_START_HI    ( ( XOCM_XMPU_BASEADDR ) + 0x0000014CUL )
#define XOCM_XMPU_R03_START_HI_RSTVAL   0x00000000UL

#define XOCM_XMPU_R03_START_HI_ADDR_SHIFT   0UL
#define XOCM_XMPU_R03_START_HI_ADDR_WIDTH   12UL
#define XOCM_XMPU_R03_START_HI_ADDR_MASK    0x00000fffUL
#define XOCM_XMPU_R03_START_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR03EndLo
 */
#define XOCM_XMPU_R03_END_LO    ( ( XOCM_XMPU_BASEADDR ) + 0x00000150UL )
#define XOCM_XMPU_R03_END_LO_RSTVAL   0x00000000UL

#define XOCM_XMPU_R03_END_LO_ADDR_SHIFT   0UL
#define XOCM_XMPU_R03_END_LO_ADDR_WIDTH   32UL
#define XOCM_XMPU_R03_END_LO_ADDR_MASK    0xffffffffUL
#define XOCM_XMPU_R03_END_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR03EndHi
 */
#define XOCM_XMPU_R03_END_HI    ( ( XOCM_XMPU_BASEADDR ) + 0x00000154UL )
#define XOCM_XMPU_R03_END_HI_RSTVAL   0x00000000UL

#define XOCM_XMPU_R03_END_HI_ADDR_SHIFT   0UL
#define XOCM_XMPU_R03_END_HI_ADDR_WIDTH   12UL
#define XOCM_XMPU_R03_END_HI_ADDR_MASK    0x00000fffUL
#define XOCM_XMPU_R03_END_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR03Master
 */
#define XOCM_XMPU_R03_MASTER    ( ( XOCM_XMPU_BASEADDR ) + 0x00000158UL )
#define XOCM_XMPU_R03_MASTER_RSTVAL   0x00000000UL

#define XOCM_XMPU_R03_MASTER_MSK_SHIFT   16UL
#define XOCM_XMPU_R03_MASTER_MSK_WIDTH   10UL
#define XOCM_XMPU_R03_MASTER_MSK_MASK    0x03ff0000UL
#define XOCM_XMPU_R03_MASTER_MSK_DEFVAL  0x0UL

#define XOCM_XMPU_R03_MASTER_ID_SHIFT   0UL
#define XOCM_XMPU_R03_MASTER_ID_WIDTH   10UL
#define XOCM_XMPU_R03_MASTER_ID_MASK    0x000003ffUL
#define XOCM_XMPU_R03_MASTER_ID_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR03Cfg
 */
#define XOCM_XMPU_R03_CFG    ( ( XOCM_XMPU_BASEADDR ) + 0x0000015CUL )
#define XOCM_XMPU_R03_CFG_RSTVAL   0x00000008UL

#define XOCM_XMPU_R03_CFG_NSCHECKTYPE_SHIFT   4UL
#define XOCM_XMPU_R03_CFG_NSCHECKTYPE_WIDTH   1UL
#define XOCM_XMPU_R03_CFG_NSCHECKTYPE_MASK    0x00000010UL
#define XOCM_XMPU_R03_CFG_NSCHECKTYPE_DEFVAL  0x0UL

#define XOCM_XMPU_R03_CFG_REGIONNS_SHIFT   3UL
#define XOCM_XMPU_R03_CFG_REGIONNS_WIDTH   1UL
#define XOCM_XMPU_R03_CFG_REGIONNS_MASK    0x00000008UL
#define XOCM_XMPU_R03_CFG_REGIONNS_DEFVAL  0x1UL

#define XOCM_XMPU_R03_CFG_WRALLOWED_SHIFT   2UL
#define XOCM_XMPU_R03_CFG_WRALLOWED_WIDTH   1UL
#define XOCM_XMPU_R03_CFG_WRALLOWED_MASK    0x00000004UL
#define XOCM_XMPU_R03_CFG_WRALLOWED_DEFVAL  0x0UL

#define XOCM_XMPU_R03_CFG_RDALLOWED_SHIFT   1UL
#define XOCM_XMPU_R03_CFG_RDALLOWED_WIDTH   1UL
#define XOCM_XMPU_R03_CFG_RDALLOWED_MASK    0x00000002UL
#define XOCM_XMPU_R03_CFG_RDALLOWED_DEFVAL  0x0UL

#define XOCM_XMPU_R03_CFG_EN_SHIFT   0UL
#define XOCM_XMPU_R03_CFG_EN_WIDTH   1UL
#define XOCM_XMPU_R03_CFG_EN_MASK    0x00000001UL
#define XOCM_XMPU_R03_CFG_EN_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR04StartLo
 */
#define XOCM_XMPU_R04_START_LO    ( ( XOCM_XMPU_BASEADDR ) + 0x00000160UL )
#define XOCM_XMPU_R04_START_LO_RSTVAL   0x00000000UL

#define XOCM_XMPU_R04_START_LO_ADDR_SHIFT   0UL
#define XOCM_XMPU_R04_START_LO_ADDR_WIDTH   32UL
#define XOCM_XMPU_R04_START_LO_ADDR_MASK    0xffffffffUL
#define XOCM_XMPU_R04_START_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR04StartHi
 */
#define XOCM_XMPU_R04_START_HI    ( ( XOCM_XMPU_BASEADDR ) + 0x00000164UL )
#define XOCM_XMPU_R04_START_HI_RSTVAL   0x00000000UL

#define XOCM_XMPU_R04_START_HI_ADDR_SHIFT   0UL
#define XOCM_XMPU_R04_START_HI_ADDR_WIDTH   12UL
#define XOCM_XMPU_R04_START_HI_ADDR_MASK    0x00000fffUL
#define XOCM_XMPU_R04_START_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR04EndLo
 */
#define XOCM_XMPU_R04_END_LO    ( ( XOCM_XMPU_BASEADDR ) + 0x00000168UL )
#define XOCM_XMPU_R04_END_LO_RSTVAL   0x00000000UL

#define XOCM_XMPU_R04_END_LO_ADDR_SHIFT   0UL
#define XOCM_XMPU_R04_END_LO_ADDR_WIDTH   32UL
#define XOCM_XMPU_R04_END_LO_ADDR_MASK    0xffffffffUL
#define XOCM_XMPU_R04_END_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR04EndHi
 */
#define XOCM_XMPU_R04_END_HI    ( ( XOCM_XMPU_BASEADDR ) + 0x0000016CUL )
#define XOCM_XMPU_R04_END_HI_RSTVAL   0x00000000UL

#define XOCM_XMPU_R04_END_HI_ADDR_SHIFT   0UL
#define XOCM_XMPU_R04_END_HI_ADDR_WIDTH   12UL
#define XOCM_XMPU_R04_END_HI_ADDR_MASK    0x00000fffUL
#define XOCM_XMPU_R04_END_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR04Master
 */
#define XOCM_XMPU_R04_MASTER    ( ( XOCM_XMPU_BASEADDR ) + 0x00000170UL )
#define XOCM_XMPU_R04_MASTER_RSTVAL   0x00000000UL

#define XOCM_XMPU_R04_MASTER_MSK_SHIFT   16UL
#define XOCM_XMPU_R04_MASTER_MSK_WIDTH   10UL
#define XOCM_XMPU_R04_MASTER_MSK_MASK    0x03ff0000UL
#define XOCM_XMPU_R04_MASTER_MSK_DEFVAL  0x0UL

#define XOCM_XMPU_R04_MASTER_ID_SHIFT   0UL
#define XOCM_XMPU_R04_MASTER_ID_WIDTH   10UL
#define XOCM_XMPU_R04_MASTER_ID_MASK    0x000003ffUL
#define XOCM_XMPU_R04_MASTER_ID_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR04Cfg
 */
#define XOCM_XMPU_R04_CFG    ( ( XOCM_XMPU_BASEADDR ) + 0x00000174UL )
#define XOCM_XMPU_R04_CFG_RSTVAL   0x00000008UL

#define XOCM_XMPU_R04_CFG_NSCHECKTYPE_SHIFT   4UL
#define XOCM_XMPU_R04_CFG_NSCHECKTYPE_WIDTH   1UL
#define XOCM_XMPU_R04_CFG_NSCHECKTYPE_MASK    0x00000010UL
#define XOCM_XMPU_R04_CFG_NSCHECKTYPE_DEFVAL  0x0UL

#define XOCM_XMPU_R04_CFG_REGIONNS_SHIFT   3UL
#define XOCM_XMPU_R04_CFG_REGIONNS_WIDTH   1UL
#define XOCM_XMPU_R04_CFG_REGIONNS_MASK    0x00000008UL
#define XOCM_XMPU_R04_CFG_REGIONNS_DEFVAL  0x1UL

#define XOCM_XMPU_R04_CFG_WRALLOWED_SHIFT   2UL
#define XOCM_XMPU_R04_CFG_WRALLOWED_WIDTH   1UL
#define XOCM_XMPU_R04_CFG_WRALLOWED_MASK    0x00000004UL
#define XOCM_XMPU_R04_CFG_WRALLOWED_DEFVAL  0x0UL

#define XOCM_XMPU_R04_CFG_RDALLOWED_SHIFT   1UL
#define XOCM_XMPU_R04_CFG_RDALLOWED_WIDTH   1UL
#define XOCM_XMPU_R04_CFG_RDALLOWED_MASK    0x00000002UL
#define XOCM_XMPU_R04_CFG_RDALLOWED_DEFVAL  0x0UL

#define XOCM_XMPU_R04_CFG_EN_SHIFT   0UL
#define XOCM_XMPU_R04_CFG_EN_WIDTH   1UL
#define XOCM_XMPU_R04_CFG_EN_MASK    0x00000001UL
#define XOCM_XMPU_R04_CFG_EN_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR05StartLo
 */
#define XOCM_XMPU_R05_START_LO    ( ( XOCM_XMPU_BASEADDR ) + 0x00000178UL )
#define XOCM_XMPU_R05_START_LO_RSTVAL   0x00000000UL

#define XOCM_XMPU_R05_START_LO_ADDR_SHIFT   0UL
#define XOCM_XMPU_R05_START_LO_ADDR_WIDTH   32UL
#define XOCM_XMPU_R05_START_LO_ADDR_MASK    0xffffffffUL
#define XOCM_XMPU_R05_START_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR05StartHi
 */
#define XOCM_XMPU_R05_START_HI    ( ( XOCM_XMPU_BASEADDR ) + 0x0000017CUL )
#define XOCM_XMPU_R05_START_HI_RSTVAL   0x00000000UL

#define XOCM_XMPU_R05_START_HI_ADDR_SHIFT   0UL
#define XOCM_XMPU_R05_START_HI_ADDR_WIDTH   12UL
#define XOCM_XMPU_R05_START_HI_ADDR_MASK    0x00000fffUL
#define XOCM_XMPU_R05_START_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR05EndLo
 */
#define XOCM_XMPU_R05_END_LO    ( ( XOCM_XMPU_BASEADDR ) + 0x00000180UL )
#define XOCM_XMPU_R05_END_LO_RSTVAL   0x00000000UL

#define XOCM_XMPU_R05_END_LO_ADDR_SHIFT   0UL
#define XOCM_XMPU_R05_END_LO_ADDR_WIDTH   32UL
#define XOCM_XMPU_R05_END_LO_ADDR_MASK    0xffffffffUL
#define XOCM_XMPU_R05_END_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR05EndHi
 */
#define XOCM_XMPU_R05_END_HI    ( ( XOCM_XMPU_BASEADDR ) + 0x00000184UL )
#define XOCM_XMPU_R05_END_HI_RSTVAL   0x00000000UL

#define XOCM_XMPU_R05_END_HI_ADDR_SHIFT   0UL
#define XOCM_XMPU_R05_END_HI_ADDR_WIDTH   12UL
#define XOCM_XMPU_R05_END_HI_ADDR_MASK    0x00000fffUL
#define XOCM_XMPU_R05_END_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR05Master
 */
#define XOCM_XMPU_R05_MASTER    ( ( XOCM_XMPU_BASEADDR ) + 0x00000188UL )
#define XOCM_XMPU_R05_MASTER_RSTVAL   0x00000000UL

#define XOCM_XMPU_R05_MASTER_MSK_SHIFT   16UL
#define XOCM_XMPU_R05_MASTER_MSK_WIDTH   10UL
#define XOCM_XMPU_R05_MASTER_MSK_MASK    0x03ff0000UL
#define XOCM_XMPU_R05_MASTER_MSK_DEFVAL  0x0UL

#define XOCM_XMPU_R05_MASTER_ID_SHIFT   0UL
#define XOCM_XMPU_R05_MASTER_ID_WIDTH   10UL
#define XOCM_XMPU_R05_MASTER_ID_MASK    0x000003ffUL
#define XOCM_XMPU_R05_MASTER_ID_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR05Cfg
 */
#define XOCM_XMPU_R05_CFG    ( ( XOCM_XMPU_BASEADDR ) + 0x0000018CUL )
#define XOCM_XMPU_R05_CFG_RSTVAL   0x00000008UL

#define XOCM_XMPU_R05_CFG_NSCHECKTYPE_SHIFT   4UL
#define XOCM_XMPU_R05_CFG_NSCHECKTYPE_WIDTH   1UL
#define XOCM_XMPU_R05_CFG_NSCHECKTYPE_MASK    0x00000010UL
#define XOCM_XMPU_R05_CFG_NSCHECKTYPE_DEFVAL  0x0UL

#define XOCM_XMPU_R05_CFG_REGIONNS_SHIFT   3UL
#define XOCM_XMPU_R05_CFG_REGIONNS_WIDTH   1UL
#define XOCM_XMPU_R05_CFG_REGIONNS_MASK    0x00000008UL
#define XOCM_XMPU_R05_CFG_REGIONNS_DEFVAL  0x1UL

#define XOCM_XMPU_R05_CFG_WRALLOWED_SHIFT   2UL
#define XOCM_XMPU_R05_CFG_WRALLOWED_WIDTH   1UL
#define XOCM_XMPU_R05_CFG_WRALLOWED_MASK    0x00000004UL
#define XOCM_XMPU_R05_CFG_WRALLOWED_DEFVAL  0x0UL

#define XOCM_XMPU_R05_CFG_RDALLOWED_SHIFT   1UL
#define XOCM_XMPU_R05_CFG_RDALLOWED_WIDTH   1UL
#define XOCM_XMPU_R05_CFG_RDALLOWED_MASK    0x00000002UL
#define XOCM_XMPU_R05_CFG_RDALLOWED_DEFVAL  0x0UL

#define XOCM_XMPU_R05_CFG_EN_SHIFT   0UL
#define XOCM_XMPU_R05_CFG_EN_WIDTH   1UL
#define XOCM_XMPU_R05_CFG_EN_MASK    0x00000001UL
#define XOCM_XMPU_R05_CFG_EN_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR06StartLo
 */
#define XOCM_XMPU_R06_START_LO    ( ( XOCM_XMPU_BASEADDR ) + 0x00000190UL )
#define XOCM_XMPU_R06_START_LO_RSTVAL   0x00000000UL

#define XOCM_XMPU_R06_START_LO_ADDR_SHIFT   0UL
#define XOCM_XMPU_R06_START_LO_ADDR_WIDTH   32UL
#define XOCM_XMPU_R06_START_LO_ADDR_MASK    0xffffffffUL
#define XOCM_XMPU_R06_START_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR06StartHi
 */
#define XOCM_XMPU_R06_START_HI    ( ( XOCM_XMPU_BASEADDR ) + 0x00000194UL )
#define XOCM_XMPU_R06_START_HI_RSTVAL   0x00000000UL

#define XOCM_XMPU_R06_START_HI_ADDR_SHIFT   0UL
#define XOCM_XMPU_R06_START_HI_ADDR_WIDTH   12UL
#define XOCM_XMPU_R06_START_HI_ADDR_MASK    0x00000fffUL
#define XOCM_XMPU_R06_START_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR06EndLo
 */
#define XOCM_XMPU_R06_END_LO    ( ( XOCM_XMPU_BASEADDR ) + 0x00000198UL )
#define XOCM_XMPU_R06_END_LO_RSTVAL   0x00000000UL

#define XOCM_XMPU_R06_END_LO_ADDR_SHIFT   0UL
#define XOCM_XMPU_R06_END_LO_ADDR_WIDTH   32UL
#define XOCM_XMPU_R06_END_LO_ADDR_MASK    0xffffffffUL
#define XOCM_XMPU_R06_END_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR06EndHi
 */
#define XOCM_XMPU_R06_END_HI    ( ( XOCM_XMPU_BASEADDR ) + 0x0000019CUL )
#define XOCM_XMPU_R06_END_HI_RSTVAL   0x00000000UL

#define XOCM_XMPU_R06_END_HI_ADDR_SHIFT   0UL
#define XOCM_XMPU_R06_END_HI_ADDR_WIDTH   12UL
#define XOCM_XMPU_R06_END_HI_ADDR_MASK    0x00000fffUL
#define XOCM_XMPU_R06_END_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR06Master
 */
#define XOCM_XMPU_R06_MASTER    ( ( XOCM_XMPU_BASEADDR ) + 0x000001A0UL )
#define XOCM_XMPU_R06_MASTER_RSTVAL   0x00000000UL

#define XOCM_XMPU_R06_MASTER_MSK_SHIFT   16UL
#define XOCM_XMPU_R06_MASTER_MSK_WIDTH   10UL
#define XOCM_XMPU_R06_MASTER_MSK_MASK    0x03ff0000UL
#define XOCM_XMPU_R06_MASTER_MSK_DEFVAL  0x0UL

#define XOCM_XMPU_R06_MASTER_ID_SHIFT   0UL
#define XOCM_XMPU_R06_MASTER_ID_WIDTH   10UL
#define XOCM_XMPU_R06_MASTER_ID_MASK    0x000003ffUL
#define XOCM_XMPU_R06_MASTER_ID_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR06Cfg
 */
#define XOCM_XMPU_R06_CFG    ( ( XOCM_XMPU_BASEADDR ) + 0x000001A4UL )
#define XOCM_XMPU_R06_CFG_RSTVAL   0x00000008UL

#define XOCM_XMPU_R06_CFG_NSCHECKTYPE_SHIFT   4UL
#define XOCM_XMPU_R06_CFG_NSCHECKTYPE_WIDTH   1UL
#define XOCM_XMPU_R06_CFG_NSCHECKTYPE_MASK    0x00000010UL
#define XOCM_XMPU_R06_CFG_NSCHECKTYPE_DEFVAL  0x0UL

#define XOCM_XMPU_R06_CFG_REGIONNS_SHIFT   3UL
#define XOCM_XMPU_R06_CFG_REGIONNS_WIDTH   1UL
#define XOCM_XMPU_R06_CFG_REGIONNS_MASK    0x00000008UL
#define XOCM_XMPU_R06_CFG_REGIONNS_DEFVAL  0x1UL

#define XOCM_XMPU_R06_CFG_WRALLOWED_SHIFT   2UL
#define XOCM_XMPU_R06_CFG_WRALLOWED_WIDTH   1UL
#define XOCM_XMPU_R06_CFG_WRALLOWED_MASK    0x00000004UL
#define XOCM_XMPU_R06_CFG_WRALLOWED_DEFVAL  0x0UL

#define XOCM_XMPU_R06_CFG_RDALLOWED_SHIFT   1UL
#define XOCM_XMPU_R06_CFG_RDALLOWED_WIDTH   1UL
#define XOCM_XMPU_R06_CFG_RDALLOWED_MASK    0x00000002UL
#define XOCM_XMPU_R06_CFG_RDALLOWED_DEFVAL  0x0UL

#define XOCM_XMPU_R06_CFG_EN_SHIFT   0UL
#define XOCM_XMPU_R06_CFG_EN_WIDTH   1UL
#define XOCM_XMPU_R06_CFG_EN_MASK    0x00000001UL
#define XOCM_XMPU_R06_CFG_EN_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR07StartLo
 */
#define XOCM_XMPU_R07_START_LO    ( ( XOCM_XMPU_BASEADDR ) + 0x000001A8UL )
#define XOCM_XMPU_R07_START_LO_RSTVAL   0x00000000UL

#define XOCM_XMPU_R07_START_LO_ADDR_SHIFT   0UL
#define XOCM_XMPU_R07_START_LO_ADDR_WIDTH   32UL
#define XOCM_XMPU_R07_START_LO_ADDR_MASK    0xffffffffUL
#define XOCM_XMPU_R07_START_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR07StartHi
 */
#define XOCM_XMPU_R07_START_HI    ( ( XOCM_XMPU_BASEADDR ) + 0x000001ACUL )
#define XOCM_XMPU_R07_START_HI_RSTVAL   0x00000000UL

#define XOCM_XMPU_R07_START_HI_ADDR_SHIFT   0UL
#define XOCM_XMPU_R07_START_HI_ADDR_WIDTH   12UL
#define XOCM_XMPU_R07_START_HI_ADDR_MASK    0x00000fffUL
#define XOCM_XMPU_R07_START_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR07EndLo
 */
#define XOCM_XMPU_R07_END_LO    ( ( XOCM_XMPU_BASEADDR ) + 0x000001B0UL )
#define XOCM_XMPU_R07_END_LO_RSTVAL   0x00000000UL

#define XOCM_XMPU_R07_END_LO_ADDR_SHIFT   0UL
#define XOCM_XMPU_R07_END_LO_ADDR_WIDTH   32UL
#define XOCM_XMPU_R07_END_LO_ADDR_MASK    0xffffffffUL
#define XOCM_XMPU_R07_END_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR07EndHi
 */
#define XOCM_XMPU_R07_END_HI    ( ( XOCM_XMPU_BASEADDR ) + 0x000001B4UL )
#define XOCM_XMPU_R07_END_HI_RSTVAL   0x00000000UL

#define XOCM_XMPU_R07_END_HI_ADDR_SHIFT   0UL
#define XOCM_XMPU_R07_END_HI_ADDR_WIDTH   12UL
#define XOCM_XMPU_R07_END_HI_ADDR_MASK    0x00000fffUL
#define XOCM_XMPU_R07_END_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR07Master
 */
#define XOCM_XMPU_R07_MASTER    ( ( XOCM_XMPU_BASEADDR ) + 0x000001B8UL )
#define XOCM_XMPU_R07_MASTER_RSTVAL   0x00000000UL

#define XOCM_XMPU_R07_MASTER_MSK_SHIFT   16UL
#define XOCM_XMPU_R07_MASTER_MSK_WIDTH   10UL
#define XOCM_XMPU_R07_MASTER_MSK_MASK    0x03ff0000UL
#define XOCM_XMPU_R07_MASTER_MSK_DEFVAL  0x0UL

#define XOCM_XMPU_R07_MASTER_ID_SHIFT   0UL
#define XOCM_XMPU_R07_MASTER_ID_WIDTH   10UL
#define XOCM_XMPU_R07_MASTER_ID_MASK    0x000003ffUL
#define XOCM_XMPU_R07_MASTER_ID_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR07Cfg
 */
#define XOCM_XMPU_R07_CFG    ( ( XOCM_XMPU_BASEADDR ) + 0x000001BCUL )
#define XOCM_XMPU_R07_CFG_RSTVAL   0x00000008UL

#define XOCM_XMPU_R07_CFG_NSCHECKTYPE_SHIFT   4UL
#define XOCM_XMPU_R07_CFG_NSCHECKTYPE_WIDTH   1UL
#define XOCM_XMPU_R07_CFG_NSCHECKTYPE_MASK    0x00000010UL
#define XOCM_XMPU_R07_CFG_NSCHECKTYPE_DEFVAL  0x0UL

#define XOCM_XMPU_R07_CFG_REGIONNS_SHIFT   3UL
#define XOCM_XMPU_R07_CFG_REGIONNS_WIDTH   1UL
#define XOCM_XMPU_R07_CFG_REGIONNS_MASK    0x00000008UL
#define XOCM_XMPU_R07_CFG_REGIONNS_DEFVAL  0x1UL

#define XOCM_XMPU_R07_CFG_WRALLOWED_SHIFT   2UL
#define XOCM_XMPU_R07_CFG_WRALLOWED_WIDTH   1UL
#define XOCM_XMPU_R07_CFG_WRALLOWED_MASK    0x00000004UL
#define XOCM_XMPU_R07_CFG_WRALLOWED_DEFVAL  0x0UL

#define XOCM_XMPU_R07_CFG_RDALLOWED_SHIFT   1UL
#define XOCM_XMPU_R07_CFG_RDALLOWED_WIDTH   1UL
#define XOCM_XMPU_R07_CFG_RDALLOWED_MASK    0x00000002UL
#define XOCM_XMPU_R07_CFG_RDALLOWED_DEFVAL  0x0UL

#define XOCM_XMPU_R07_CFG_EN_SHIFT   0UL
#define XOCM_XMPU_R07_CFG_EN_WIDTH   1UL
#define XOCM_XMPU_R07_CFG_EN_MASK    0x00000001UL
#define XOCM_XMPU_R07_CFG_EN_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR08StartLo
 */
#define XOCM_XMPU_R08_START_LO    ( ( XOCM_XMPU_BASEADDR ) + 0x000001C0UL )
#define XOCM_XMPU_R08_START_LO_RSTVAL   0x00000000UL

#define XOCM_XMPU_R08_START_LO_ADDR_SHIFT   0UL
#define XOCM_XMPU_R08_START_LO_ADDR_WIDTH   32UL
#define XOCM_XMPU_R08_START_LO_ADDR_MASK    0xffffffffUL
#define XOCM_XMPU_R08_START_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR08StartHi
 */
#define XOCM_XMPU_R08_START_HI    ( ( XOCM_XMPU_BASEADDR ) + 0x000001C4UL )
#define XOCM_XMPU_R08_START_HI_RSTVAL   0x00000000UL

#define XOCM_XMPU_R08_START_HI_ADDR_SHIFT   0UL
#define XOCM_XMPU_R08_START_HI_ADDR_WIDTH   12UL
#define XOCM_XMPU_R08_START_HI_ADDR_MASK    0x00000fffUL
#define XOCM_XMPU_R08_START_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR08EndLo
 */
#define XOCM_XMPU_R08_END_LO    ( ( XOCM_XMPU_BASEADDR ) + 0x000001C8UL )
#define XOCM_XMPU_R08_END_LO_RSTVAL   0x00000000UL

#define XOCM_XMPU_R08_END_LO_ADDR_SHIFT   0UL
#define XOCM_XMPU_R08_END_LO_ADDR_WIDTH   32UL
#define XOCM_XMPU_R08_END_LO_ADDR_MASK    0xffffffffUL
#define XOCM_XMPU_R08_END_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR08EndHi
 */
#define XOCM_XMPU_R08_END_HI    ( ( XOCM_XMPU_BASEADDR ) + 0x000001CCUL )
#define XOCM_XMPU_R08_END_HI_RSTVAL   0x00000000UL

#define XOCM_XMPU_R08_END_HI_ADDR_SHIFT   0UL
#define XOCM_XMPU_R08_END_HI_ADDR_WIDTH   12UL
#define XOCM_XMPU_R08_END_HI_ADDR_MASK    0x00000fffUL
#define XOCM_XMPU_R08_END_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR08Master
 */
#define XOCM_XMPU_R08_MASTER    ( ( XOCM_XMPU_BASEADDR ) + 0x000001D0UL )
#define XOCM_XMPU_R08_MASTER_RSTVAL   0x00000000UL

#define XOCM_XMPU_R08_MASTER_MSK_SHIFT   16UL
#define XOCM_XMPU_R08_MASTER_MSK_WIDTH   10UL
#define XOCM_XMPU_R08_MASTER_MSK_MASK    0x03ff0000UL
#define XOCM_XMPU_R08_MASTER_MSK_DEFVAL  0x0UL

#define XOCM_XMPU_R08_MASTER_ID_SHIFT   0UL
#define XOCM_XMPU_R08_MASTER_ID_WIDTH   10UL
#define XOCM_XMPU_R08_MASTER_ID_MASK    0x000003ffUL
#define XOCM_XMPU_R08_MASTER_ID_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR08Cfg
 */
#define XOCM_XMPU_R08_CFG    ( ( XOCM_XMPU_BASEADDR ) + 0x000001D4UL )
#define XOCM_XMPU_R08_CFG_RSTVAL   0x00000008UL

#define XOCM_XMPU_R08_CFG_NSCHECKTYPE_SHIFT   4UL
#define XOCM_XMPU_R08_CFG_NSCHECKTYPE_WIDTH   1UL
#define XOCM_XMPU_R08_CFG_NSCHECKTYPE_MASK    0x00000010UL
#define XOCM_XMPU_R08_CFG_NSCHECKTYPE_DEFVAL  0x0UL

#define XOCM_XMPU_R08_CFG_REGIONNS_SHIFT   3UL
#define XOCM_XMPU_R08_CFG_REGIONNS_WIDTH   1UL
#define XOCM_XMPU_R08_CFG_REGIONNS_MASK    0x00000008UL
#define XOCM_XMPU_R08_CFG_REGIONNS_DEFVAL  0x1UL

#define XOCM_XMPU_R08_CFG_WRALLOWED_SHIFT   2UL
#define XOCM_XMPU_R08_CFG_WRALLOWED_WIDTH   1UL
#define XOCM_XMPU_R08_CFG_WRALLOWED_MASK    0x00000004UL
#define XOCM_XMPU_R08_CFG_WRALLOWED_DEFVAL  0x0UL

#define XOCM_XMPU_R08_CFG_RDALLOWED_SHIFT   1UL
#define XOCM_XMPU_R08_CFG_RDALLOWED_WIDTH   1UL
#define XOCM_XMPU_R08_CFG_RDALLOWED_MASK    0x00000002UL
#define XOCM_XMPU_R08_CFG_RDALLOWED_DEFVAL  0x0UL

#define XOCM_XMPU_R08_CFG_EN_SHIFT   0UL
#define XOCM_XMPU_R08_CFG_EN_WIDTH   1UL
#define XOCM_XMPU_R08_CFG_EN_MASK    0x00000001UL
#define XOCM_XMPU_R08_CFG_EN_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR09StartLo
 */
#define XOCM_XMPU_R09_START_LO    ( ( XOCM_XMPU_BASEADDR ) + 0x000001D8UL )
#define XOCM_XMPU_R09_START_LO_RSTVAL   0x00000000UL

#define XOCM_XMPU_R09_START_LO_ADDR_SHIFT   0UL
#define XOCM_XMPU_R09_START_LO_ADDR_WIDTH   32UL
#define XOCM_XMPU_R09_START_LO_ADDR_MASK    0xffffffffUL
#define XOCM_XMPU_R09_START_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR09StartHi
 */
#define XOCM_XMPU_R09_START_HI    ( ( XOCM_XMPU_BASEADDR ) + 0x000001DCUL )
#define XOCM_XMPU_R09_START_HI_RSTVAL   0x00000000UL

#define XOCM_XMPU_R09_START_HI_ADDR_SHIFT   0UL
#define XOCM_XMPU_R09_START_HI_ADDR_WIDTH   12UL
#define XOCM_XMPU_R09_START_HI_ADDR_MASK    0x00000fffUL
#define XOCM_XMPU_R09_START_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR09EndLo
 */
#define XOCM_XMPU_R09_END_LO    ( ( XOCM_XMPU_BASEADDR ) + 0x000001E0UL )
#define XOCM_XMPU_R09_END_LO_RSTVAL   0x00000000UL

#define XOCM_XMPU_R09_END_LO_ADDR_SHIFT   0UL
#define XOCM_XMPU_R09_END_LO_ADDR_WIDTH   32UL
#define XOCM_XMPU_R09_END_LO_ADDR_MASK    0xffffffffUL
#define XOCM_XMPU_R09_END_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR09EndHi
 */
#define XOCM_XMPU_R09_END_HI    ( ( XOCM_XMPU_BASEADDR ) + 0x000001E4UL )
#define XOCM_XMPU_R09_END_HI_RSTVAL   0x00000000UL

#define XOCM_XMPU_R09_END_HI_ADDR_SHIFT   0UL
#define XOCM_XMPU_R09_END_HI_ADDR_WIDTH   12UL
#define XOCM_XMPU_R09_END_HI_ADDR_MASK    0x00000fffUL
#define XOCM_XMPU_R09_END_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR09Master
 */
#define XOCM_XMPU_R09_MASTER    ( ( XOCM_XMPU_BASEADDR ) + 0x000001E8UL )
#define XOCM_XMPU_R09_MASTER_RSTVAL   0x00000000UL

#define XOCM_XMPU_R09_MASTER_MSK_SHIFT   16UL
#define XOCM_XMPU_R09_MASTER_MSK_WIDTH   10UL
#define XOCM_XMPU_R09_MASTER_MSK_MASK    0x03ff0000UL
#define XOCM_XMPU_R09_MASTER_MSK_DEFVAL  0x0UL

#define XOCM_XMPU_R09_MASTER_ID_SHIFT   0UL
#define XOCM_XMPU_R09_MASTER_ID_WIDTH   10UL
#define XOCM_XMPU_R09_MASTER_ID_MASK    0x000003ffUL
#define XOCM_XMPU_R09_MASTER_ID_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR09Cfg
 */
#define XOCM_XMPU_R09_CFG    ( ( XOCM_XMPU_BASEADDR ) + 0x000001ECUL )
#define XOCM_XMPU_R09_CFG_RSTVAL   0x00000008UL

#define XOCM_XMPU_R09_CFG_NSCHECKTYPE_SHIFT   4UL
#define XOCM_XMPU_R09_CFG_NSCHECKTYPE_WIDTH   1UL
#define XOCM_XMPU_R09_CFG_NSCHECKTYPE_MASK    0x00000010UL
#define XOCM_XMPU_R09_CFG_NSCHECKTYPE_DEFVAL  0x0UL

#define XOCM_XMPU_R09_CFG_REGIONNS_SHIFT   3UL
#define XOCM_XMPU_R09_CFG_REGIONNS_WIDTH   1UL
#define XOCM_XMPU_R09_CFG_REGIONNS_MASK    0x00000008UL
#define XOCM_XMPU_R09_CFG_REGIONNS_DEFVAL  0x1UL

#define XOCM_XMPU_R09_CFG_WRALLOWED_SHIFT   2UL
#define XOCM_XMPU_R09_CFG_WRALLOWED_WIDTH   1UL
#define XOCM_XMPU_R09_CFG_WRALLOWED_MASK    0x00000004UL
#define XOCM_XMPU_R09_CFG_WRALLOWED_DEFVAL  0x0UL

#define XOCM_XMPU_R09_CFG_RDALLOWED_SHIFT   1UL
#define XOCM_XMPU_R09_CFG_RDALLOWED_WIDTH   1UL
#define XOCM_XMPU_R09_CFG_RDALLOWED_MASK    0x00000002UL
#define XOCM_XMPU_R09_CFG_RDALLOWED_DEFVAL  0x0UL

#define XOCM_XMPU_R09_CFG_EN_SHIFT   0UL
#define XOCM_XMPU_R09_CFG_EN_WIDTH   1UL
#define XOCM_XMPU_R09_CFG_EN_MASK    0x00000001UL
#define XOCM_XMPU_R09_CFG_EN_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR10StartLo
 */
#define XOCM_XMPU_R10_START_LO    ( ( XOCM_XMPU_BASEADDR ) + 0x000001F0UL )
#define XOCM_XMPU_R10_START_LO_RSTVAL   0x00000000UL

#define XOCM_XMPU_R10_START_LO_ADDR_SHIFT   0UL
#define XOCM_XMPU_R10_START_LO_ADDR_WIDTH   32UL
#define XOCM_XMPU_R10_START_LO_ADDR_MASK    0xffffffffUL
#define XOCM_XMPU_R10_START_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR10StartHi
 */
#define XOCM_XMPU_R10_START_HI    ( ( XOCM_XMPU_BASEADDR ) + 0x000001F4UL )
#define XOCM_XMPU_R10_START_HI_RSTVAL   0x00000000UL

#define XOCM_XMPU_R10_START_HI_ADDR_SHIFT   0UL
#define XOCM_XMPU_R10_START_HI_ADDR_WIDTH   12UL
#define XOCM_XMPU_R10_START_HI_ADDR_MASK    0x00000fffUL
#define XOCM_XMPU_R10_START_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR10EndLo
 */
#define XOCM_XMPU_R10_END_LO    ( ( XOCM_XMPU_BASEADDR ) + 0x000001F8UL )
#define XOCM_XMPU_R10_END_LO_RSTVAL   0x00000000UL

#define XOCM_XMPU_R10_END_LO_ADDR_SHIFT   0UL
#define XOCM_XMPU_R10_END_LO_ADDR_WIDTH   32UL
#define XOCM_XMPU_R10_END_LO_ADDR_MASK    0xffffffffUL
#define XOCM_XMPU_R10_END_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR10EndHi
 */
#define XOCM_XMPU_R10_END_HI    ( ( XOCM_XMPU_BASEADDR ) + 0x000001FCUL )
#define XOCM_XMPU_R10_END_HI_RSTVAL   0x00000000UL

#define XOCM_XMPU_R10_END_HI_ADDR_SHIFT   0UL
#define XOCM_XMPU_R10_END_HI_ADDR_WIDTH   12UL
#define XOCM_XMPU_R10_END_HI_ADDR_MASK    0x00000fffUL
#define XOCM_XMPU_R10_END_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR10Master
 */
#define XOCM_XMPU_R10_MASTER    ( ( XOCM_XMPU_BASEADDR ) + 0x00000200UL )
#define XOCM_XMPU_R10_MASTER_RSTVAL   0x00000000UL

#define XOCM_XMPU_R10_MASTER_MSK_SHIFT   16UL
#define XOCM_XMPU_R10_MASTER_MSK_WIDTH   10UL
#define XOCM_XMPU_R10_MASTER_MSK_MASK    0x03ff0000UL
#define XOCM_XMPU_R10_MASTER_MSK_DEFVAL  0x0UL

#define XOCM_XMPU_R10_MASTER_ID_SHIFT   0UL
#define XOCM_XMPU_R10_MASTER_ID_WIDTH   10UL
#define XOCM_XMPU_R10_MASTER_ID_MASK    0x000003ffUL
#define XOCM_XMPU_R10_MASTER_ID_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR10Cfg
 */
#define XOCM_XMPU_R10_CFG    ( ( XOCM_XMPU_BASEADDR ) + 0x00000204UL )
#define XOCM_XMPU_R10_CFG_RSTVAL   0x00000008UL

#define XOCM_XMPU_R10_CFG_NSCHECKTYPE_SHIFT   4UL
#define XOCM_XMPU_R10_CFG_NSCHECKTYPE_WIDTH   1UL
#define XOCM_XMPU_R10_CFG_NSCHECKTYPE_MASK    0x00000010UL
#define XOCM_XMPU_R10_CFG_NSCHECKTYPE_DEFVAL  0x0UL

#define XOCM_XMPU_R10_CFG_REGIONNS_SHIFT   3UL
#define XOCM_XMPU_R10_CFG_REGIONNS_WIDTH   1UL
#define XOCM_XMPU_R10_CFG_REGIONNS_MASK    0x00000008UL
#define XOCM_XMPU_R10_CFG_REGIONNS_DEFVAL  0x1UL

#define XOCM_XMPU_R10_CFG_WRALLOWED_SHIFT   2UL
#define XOCM_XMPU_R10_CFG_WRALLOWED_WIDTH   1UL
#define XOCM_XMPU_R10_CFG_WRALLOWED_MASK    0x00000004UL
#define XOCM_XMPU_R10_CFG_WRALLOWED_DEFVAL  0x0UL

#define XOCM_XMPU_R10_CFG_RDALLOWED_SHIFT   1UL
#define XOCM_XMPU_R10_CFG_RDALLOWED_WIDTH   1UL
#define XOCM_XMPU_R10_CFG_RDALLOWED_MASK    0x00000002UL
#define XOCM_XMPU_R10_CFG_RDALLOWED_DEFVAL  0x0UL

#define XOCM_XMPU_R10_CFG_EN_SHIFT   0UL
#define XOCM_XMPU_R10_CFG_EN_WIDTH   1UL
#define XOCM_XMPU_R10_CFG_EN_MASK    0x00000001UL
#define XOCM_XMPU_R10_CFG_EN_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR11StartLo
 */
#define XOCM_XMPU_R11_START_LO    ( ( XOCM_XMPU_BASEADDR ) + 0x00000208UL )
#define XOCM_XMPU_R11_START_LO_RSTVAL   0x00000000UL

#define XOCM_XMPU_R11_START_LO_ADDR_SHIFT   0UL
#define XOCM_XMPU_R11_START_LO_ADDR_WIDTH   32UL
#define XOCM_XMPU_R11_START_LO_ADDR_MASK    0xffffffffUL
#define XOCM_XMPU_R11_START_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR11StartHi
 */
#define XOCM_XMPU_R11_START_HI    ( ( XOCM_XMPU_BASEADDR ) + 0x0000020CUL )
#define XOCM_XMPU_R11_START_HI_RSTVAL   0x00000000UL

#define XOCM_XMPU_R11_START_HI_ADDR_SHIFT   0UL
#define XOCM_XMPU_R11_START_HI_ADDR_WIDTH   12UL
#define XOCM_XMPU_R11_START_HI_ADDR_MASK    0x00000fffUL
#define XOCM_XMPU_R11_START_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR11EndLo
 */
#define XOCM_XMPU_R11_END_LO    ( ( XOCM_XMPU_BASEADDR ) + 0x00000210UL )
#define XOCM_XMPU_R11_END_LO_RSTVAL   0x00000000UL

#define XOCM_XMPU_R11_END_LO_ADDR_SHIFT   0UL
#define XOCM_XMPU_R11_END_LO_ADDR_WIDTH   32UL
#define XOCM_XMPU_R11_END_LO_ADDR_MASK    0xffffffffUL
#define XOCM_XMPU_R11_END_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR11EndHi
 */
#define XOCM_XMPU_R11_END_HI    ( ( XOCM_XMPU_BASEADDR ) + 0x00000214UL )
#define XOCM_XMPU_R11_END_HI_RSTVAL   0x00000000UL

#define XOCM_XMPU_R11_END_HI_ADDR_SHIFT   0UL
#define XOCM_XMPU_R11_END_HI_ADDR_WIDTH   12UL
#define XOCM_XMPU_R11_END_HI_ADDR_MASK    0x00000fffUL
#define XOCM_XMPU_R11_END_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR11Master
 */
#define XOCM_XMPU_R11_MASTER    ( ( XOCM_XMPU_BASEADDR ) + 0x00000218UL )
#define XOCM_XMPU_R11_MASTER_RSTVAL   0x00000000UL

#define XOCM_XMPU_R11_MASTER_MSK_SHIFT   16UL
#define XOCM_XMPU_R11_MASTER_MSK_WIDTH   10UL
#define XOCM_XMPU_R11_MASTER_MSK_MASK    0x03ff0000UL
#define XOCM_XMPU_R11_MASTER_MSK_DEFVAL  0x0UL

#define XOCM_XMPU_R11_MASTER_ID_SHIFT   0UL
#define XOCM_XMPU_R11_MASTER_ID_WIDTH   10UL
#define XOCM_XMPU_R11_MASTER_ID_MASK    0x000003ffUL
#define XOCM_XMPU_R11_MASTER_ID_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR11Cfg
 */
#define XOCM_XMPU_R11_CFG    ( ( XOCM_XMPU_BASEADDR ) + 0x0000021CUL )
#define XOCM_XMPU_R11_CFG_RSTVAL   0x00000008UL

#define XOCM_XMPU_R11_CFG_NSCHECKTYPE_SHIFT   4UL
#define XOCM_XMPU_R11_CFG_NSCHECKTYPE_WIDTH   1UL
#define XOCM_XMPU_R11_CFG_NSCHECKTYPE_MASK    0x00000010UL
#define XOCM_XMPU_R11_CFG_NSCHECKTYPE_DEFVAL  0x0UL

#define XOCM_XMPU_R11_CFG_REGIONNS_SHIFT   3UL
#define XOCM_XMPU_R11_CFG_REGIONNS_WIDTH   1UL
#define XOCM_XMPU_R11_CFG_REGIONNS_MASK    0x00000008UL
#define XOCM_XMPU_R11_CFG_REGIONNS_DEFVAL  0x1UL

#define XOCM_XMPU_R11_CFG_WRALLOWED_SHIFT   2UL
#define XOCM_XMPU_R11_CFG_WRALLOWED_WIDTH   1UL
#define XOCM_XMPU_R11_CFG_WRALLOWED_MASK    0x00000004UL
#define XOCM_XMPU_R11_CFG_WRALLOWED_DEFVAL  0x0UL

#define XOCM_XMPU_R11_CFG_RDALLOWED_SHIFT   1UL
#define XOCM_XMPU_R11_CFG_RDALLOWED_WIDTH   1UL
#define XOCM_XMPU_R11_CFG_RDALLOWED_MASK    0x00000002UL
#define XOCM_XMPU_R11_CFG_RDALLOWED_DEFVAL  0x0UL

#define XOCM_XMPU_R11_CFG_EN_SHIFT   0UL
#define XOCM_XMPU_R11_CFG_EN_WIDTH   1UL
#define XOCM_XMPU_R11_CFG_EN_MASK    0x00000001UL
#define XOCM_XMPU_R11_CFG_EN_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR12StartLo
 */
#define XOCM_XMPU_R12_START_LO    ( ( XOCM_XMPU_BASEADDR ) + 0x00000220UL )
#define XOCM_XMPU_R12_START_LO_RSTVAL   0x00000000UL

#define XOCM_XMPU_R12_START_LO_ADDR_SHIFT   0UL
#define XOCM_XMPU_R12_START_LO_ADDR_WIDTH   32UL
#define XOCM_XMPU_R12_START_LO_ADDR_MASK    0xffffffffUL
#define XOCM_XMPU_R12_START_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR12StartHi
 */
#define XOCM_XMPU_R12_START_HI    ( ( XOCM_XMPU_BASEADDR ) + 0x00000224UL )
#define XOCM_XMPU_R12_START_HI_RSTVAL   0x00000000UL

#define XOCM_XMPU_R12_START_HI_ADDR_SHIFT   0UL
#define XOCM_XMPU_R12_START_HI_ADDR_WIDTH   12UL
#define XOCM_XMPU_R12_START_HI_ADDR_MASK    0x00000fffUL
#define XOCM_XMPU_R12_START_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR12EndLo
 */
#define XOCM_XMPU_R12_END_LO    ( ( XOCM_XMPU_BASEADDR ) + 0x00000228UL )
#define XOCM_XMPU_R12_END_LO_RSTVAL   0x00000000UL

#define XOCM_XMPU_R12_END_LO_ADDR_SHIFT   0UL
#define XOCM_XMPU_R12_END_LO_ADDR_WIDTH   32UL
#define XOCM_XMPU_R12_END_LO_ADDR_MASK    0xffffffffUL
#define XOCM_XMPU_R12_END_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR12EndHi
 */
#define XOCM_XMPU_R12_END_HI    ( ( XOCM_XMPU_BASEADDR ) + 0x0000022CUL )
#define XOCM_XMPU_R12_END_HI_RSTVAL   0x00000000UL

#define XOCM_XMPU_R12_END_HI_ADDR_SHIFT   0UL
#define XOCM_XMPU_R12_END_HI_ADDR_WIDTH   12UL
#define XOCM_XMPU_R12_END_HI_ADDR_MASK    0x00000fffUL
#define XOCM_XMPU_R12_END_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR12Master
 */
#define XOCM_XMPU_R12_MASTER    ( ( XOCM_XMPU_BASEADDR ) + 0x00000238UL )
#define XOCM_XMPU_R12_MASTER_RSTVAL   0x00000000UL

#define XOCM_XMPU_R12_MASTER_MSK_SHIFT   16UL
#define XOCM_XMPU_R12_MASTER_MSK_WIDTH   10UL
#define XOCM_XMPU_R12_MASTER_MSK_MASK    0x03ff0000UL
#define XOCM_XMPU_R12_MASTER_MSK_DEFVAL  0x0UL

#define XOCM_XMPU_R12_MASTER_ID_SHIFT   0UL
#define XOCM_XMPU_R12_MASTER_ID_WIDTH   10UL
#define XOCM_XMPU_R12_MASTER_ID_MASK    0x000003ffUL
#define XOCM_XMPU_R12_MASTER_ID_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR12Cfg
 */
#define XOCM_XMPU_R12_CFG    ( ( XOCM_XMPU_BASEADDR ) + 0x0000023CUL )
#define XOCM_XMPU_R12_CFG_RSTVAL   0x00000008UL

#define XOCM_XMPU_R12_CFG_NSCHECKTYPE_SHIFT   4UL
#define XOCM_XMPU_R12_CFG_NSCHECKTYPE_WIDTH   1UL
#define XOCM_XMPU_R12_CFG_NSCHECKTYPE_MASK    0x00000010UL
#define XOCM_XMPU_R12_CFG_NSCHECKTYPE_DEFVAL  0x0UL

#define XOCM_XMPU_R12_CFG_REGIONNS_SHIFT   3UL
#define XOCM_XMPU_R12_CFG_REGIONNS_WIDTH   1UL
#define XOCM_XMPU_R12_CFG_REGIONNS_MASK    0x00000008UL
#define XOCM_XMPU_R12_CFG_REGIONNS_DEFVAL  0x1UL

#define XOCM_XMPU_R12_CFG_WRALLOWED_SHIFT   2UL
#define XOCM_XMPU_R12_CFG_WRALLOWED_WIDTH   1UL
#define XOCM_XMPU_R12_CFG_WRALLOWED_MASK    0x00000004UL
#define XOCM_XMPU_R12_CFG_WRALLOWED_DEFVAL  0x0UL

#define XOCM_XMPU_R12_CFG_RDALLOWED_SHIFT   1UL
#define XOCM_XMPU_R12_CFG_RDALLOWED_WIDTH   1UL
#define XOCM_XMPU_R12_CFG_RDALLOWED_MASK    0x00000002UL
#define XOCM_XMPU_R12_CFG_RDALLOWED_DEFVAL  0x0UL

#define XOCM_XMPU_R12_CFG_EN_SHIFT   0UL
#define XOCM_XMPU_R12_CFG_EN_WIDTH   1UL
#define XOCM_XMPU_R12_CFG_EN_MASK    0x00000001UL
#define XOCM_XMPU_R12_CFG_EN_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR13StartLo
 */
#define XOCM_XMPU_R13_START_LO    ( ( XOCM_XMPU_BASEADDR ) + 0x00000240UL )
#define XOCM_XMPU_R13_START_LO_RSTVAL   0x00000000UL

#define XOCM_XMPU_R13_START_LO_ADDR_SHIFT   0UL
#define XOCM_XMPU_R13_START_LO_ADDR_WIDTH   32UL
#define XOCM_XMPU_R13_START_LO_ADDR_MASK    0xffffffffUL
#define XOCM_XMPU_R13_START_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR13StartHi
 */
#define XOCM_XMPU_R13_START_HI    ( ( XOCM_XMPU_BASEADDR ) + 0x00000244UL )
#define XOCM_XMPU_R13_START_HI_RSTVAL   0x00000000UL

#define XOCM_XMPU_R13_START_HI_ADDR_SHIFT   0UL
#define XOCM_XMPU_R13_START_HI_ADDR_WIDTH   12UL
#define XOCM_XMPU_R13_START_HI_ADDR_MASK    0x00000fffUL
#define XOCM_XMPU_R13_START_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR13EndLo
 */
#define XOCM_XMPU_R13_END_LO    ( ( XOCM_XMPU_BASEADDR ) + 0x00000248UL )
#define XOCM_XMPU_R13_END_LO_RSTVAL   0x00000000UL

#define XOCM_XMPU_R13_END_LO_ADDR_SHIFT   0UL
#define XOCM_XMPU_R13_END_LO_ADDR_WIDTH   32UL
#define XOCM_XMPU_R13_END_LO_ADDR_MASK    0xffffffffUL
#define XOCM_XMPU_R13_END_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR13EndHi
 */
#define XOCM_XMPU_R13_END_HI    ( ( XOCM_XMPU_BASEADDR ) + 0x0000024CUL )
#define XOCM_XMPU_R13_END_HI_RSTVAL   0x00000000UL

#define XOCM_XMPU_R13_END_HI_ADDR_SHIFT   0UL
#define XOCM_XMPU_R13_END_HI_ADDR_WIDTH   12UL
#define XOCM_XMPU_R13_END_HI_ADDR_MASK    0x00000fffUL
#define XOCM_XMPU_R13_END_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR13Master
 */
#define XOCM_XMPU_R13_MASTER    ( ( XOCM_XMPU_BASEADDR ) + 0x00000250UL )
#define XOCM_XMPU_R13_MASTER_RSTVAL   0x00000000UL

#define XOCM_XMPU_R13_MASTER_MSK_SHIFT   16UL
#define XOCM_XMPU_R13_MASTER_MSK_WIDTH   10UL
#define XOCM_XMPU_R13_MASTER_MSK_MASK    0x03ff0000UL
#define XOCM_XMPU_R13_MASTER_MSK_DEFVAL  0x0UL

#define XOCM_XMPU_R13_MASTER_ID_SHIFT   0UL
#define XOCM_XMPU_R13_MASTER_ID_WIDTH   10UL
#define XOCM_XMPU_R13_MASTER_ID_MASK    0x000003ffUL
#define XOCM_XMPU_R13_MASTER_ID_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR13Cfg
 */
#define XOCM_XMPU_R13_CFG    ( ( XOCM_XMPU_BASEADDR ) + 0x00000254UL )
#define XOCM_XMPU_R13_CFG_RSTVAL   0x00000008UL

#define XOCM_XMPU_R13_CFG_NSCHECKTYPE_SHIFT   4UL
#define XOCM_XMPU_R13_CFG_NSCHECKTYPE_WIDTH   1UL
#define XOCM_XMPU_R13_CFG_NSCHECKTYPE_MASK    0x00000010UL
#define XOCM_XMPU_R13_CFG_NSCHECKTYPE_DEFVAL  0x0UL

#define XOCM_XMPU_R13_CFG_REGIONNS_SHIFT   3UL
#define XOCM_XMPU_R13_CFG_REGIONNS_WIDTH   1UL
#define XOCM_XMPU_R13_CFG_REGIONNS_MASK    0x00000008UL
#define XOCM_XMPU_R13_CFG_REGIONNS_DEFVAL  0x1UL

#define XOCM_XMPU_R13_CFG_WRALLOWED_SHIFT   2UL
#define XOCM_XMPU_R13_CFG_WRALLOWED_WIDTH   1UL
#define XOCM_XMPU_R13_CFG_WRALLOWED_MASK    0x00000004UL
#define XOCM_XMPU_R13_CFG_WRALLOWED_DEFVAL  0x0UL

#define XOCM_XMPU_R13_CFG_RDALLOWED_SHIFT   1UL
#define XOCM_XMPU_R13_CFG_RDALLOWED_WIDTH   1UL
#define XOCM_XMPU_R13_CFG_RDALLOWED_MASK    0x00000002UL
#define XOCM_XMPU_R13_CFG_RDALLOWED_DEFVAL  0x0UL

#define XOCM_XMPU_R13_CFG_EN_SHIFT   0UL
#define XOCM_XMPU_R13_CFG_EN_WIDTH   1UL
#define XOCM_XMPU_R13_CFG_EN_MASK    0x00000001UL
#define XOCM_XMPU_R13_CFG_EN_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR14StartLo
 */
#define XOCM_XMPU_R14_START_LO    ( ( XOCM_XMPU_BASEADDR ) + 0x00000258UL )
#define XOCM_XMPU_R14_START_LO_RSTVAL   0x00000000UL

#define XOCM_XMPU_R14_START_LO_ADDR_SHIFT   0UL
#define XOCM_XMPU_R14_START_LO_ADDR_WIDTH   32UL
#define XOCM_XMPU_R14_START_LO_ADDR_MASK    0xffffffffUL
#define XOCM_XMPU_R14_START_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR14StartHi
 */
#define XOCM_XMPU_R14_START_HI    ( ( XOCM_XMPU_BASEADDR ) + 0x0000025CUL )
#define XOCM_XMPU_R14_START_HI_RSTVAL   0x00000000UL

#define XOCM_XMPU_R14_START_HI_ADDR_SHIFT   0UL
#define XOCM_XMPU_R14_START_HI_ADDR_WIDTH   12UL
#define XOCM_XMPU_R14_START_HI_ADDR_MASK    0x00000fffUL
#define XOCM_XMPU_R14_START_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR14EndLo
 */
#define XOCM_XMPU_R14_END_LO    ( ( XOCM_XMPU_BASEADDR ) + 0x00000260UL )
#define XOCM_XMPU_R14_END_LO_RSTVAL   0x00000000UL

#define XOCM_XMPU_R14_END_LO_ADDR_SHIFT   0UL
#define XOCM_XMPU_R14_END_LO_ADDR_WIDTH   32UL
#define XOCM_XMPU_R14_END_LO_ADDR_MASK    0xffffffffUL
#define XOCM_XMPU_R14_END_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR14EndHi
 */
#define XOCM_XMPU_R14_END_HI    ( ( XOCM_XMPU_BASEADDR ) + 0x00000264UL )
#define XOCM_XMPU_R14_END_HI_RSTVAL   0x00000000UL

#define XOCM_XMPU_R14_END_HI_ADDR_SHIFT   0UL
#define XOCM_XMPU_R14_END_HI_ADDR_WIDTH   12UL
#define XOCM_XMPU_R14_END_HI_ADDR_MASK    0x00000fffUL
#define XOCM_XMPU_R14_END_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR14Master
 */
#define XOCM_XMPU_R14_MASTER    ( ( XOCM_XMPU_BASEADDR ) + 0x00000268UL )
#define XOCM_XMPU_R14_MASTER_RSTVAL   0x00000000UL

#define XOCM_XMPU_R14_MASTER_MSK_SHIFT   16UL
#define XOCM_XMPU_R14_MASTER_MSK_WIDTH   10UL
#define XOCM_XMPU_R14_MASTER_MSK_MASK    0x03ff0000UL
#define XOCM_XMPU_R14_MASTER_MSK_DEFVAL  0x0UL

#define XOCM_XMPU_R14_MASTER_ID_SHIFT   0UL
#define XOCM_XMPU_R14_MASTER_ID_WIDTH   10UL
#define XOCM_XMPU_R14_MASTER_ID_MASK    0x000003ffUL
#define XOCM_XMPU_R14_MASTER_ID_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR14Cfg
 */
#define XOCM_XMPU_R14_CFG    ( ( XOCM_XMPU_BASEADDR ) + 0x0000026CUL )
#define XOCM_XMPU_R14_CFG_RSTVAL   0x00000008UL

#define XOCM_XMPU_R14_CFG_NSCHECKTYPE_SHIFT   4UL
#define XOCM_XMPU_R14_CFG_NSCHECKTYPE_WIDTH   1UL
#define XOCM_XMPU_R14_CFG_NSCHECKTYPE_MASK    0x00000010UL
#define XOCM_XMPU_R14_CFG_NSCHECKTYPE_DEFVAL  0x0UL

#define XOCM_XMPU_R14_CFG_REGIONNS_SHIFT   3UL
#define XOCM_XMPU_R14_CFG_REGIONNS_WIDTH   1UL
#define XOCM_XMPU_R14_CFG_REGIONNS_MASK    0x00000008UL
#define XOCM_XMPU_R14_CFG_REGIONNS_DEFVAL  0x1UL

#define XOCM_XMPU_R14_CFG_WRALLOWED_SHIFT   2UL
#define XOCM_XMPU_R14_CFG_WRALLOWED_WIDTH   1UL
#define XOCM_XMPU_R14_CFG_WRALLOWED_MASK    0x00000004UL
#define XOCM_XMPU_R14_CFG_WRALLOWED_DEFVAL  0x0UL

#define XOCM_XMPU_R14_CFG_RDALLOWED_SHIFT   1UL
#define XOCM_XMPU_R14_CFG_RDALLOWED_WIDTH   1UL
#define XOCM_XMPU_R14_CFG_RDALLOWED_MASK    0x00000002UL
#define XOCM_XMPU_R14_CFG_RDALLOWED_DEFVAL  0x0UL

#define XOCM_XMPU_R14_CFG_EN_SHIFT   0UL
#define XOCM_XMPU_R14_CFG_EN_WIDTH   1UL
#define XOCM_XMPU_R14_CFG_EN_MASK    0x00000001UL
#define XOCM_XMPU_R14_CFG_EN_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR15StartLo
 */
#define XOCM_XMPU_R15_START_LO    ( ( XOCM_XMPU_BASEADDR ) + 0x00000270UL )
#define XOCM_XMPU_R15_START_LO_RSTVAL   0x00000000UL

#define XOCM_XMPU_R15_START_LO_ADDR_SHIFT   0UL
#define XOCM_XMPU_R15_START_LO_ADDR_WIDTH   32UL
#define XOCM_XMPU_R15_START_LO_ADDR_MASK    0xffffffffUL
#define XOCM_XMPU_R15_START_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR15StartHi
 */
#define XOCM_XMPU_R15_START_HI    ( ( XOCM_XMPU_BASEADDR ) + 0x00000274UL )
#define XOCM_XMPU_R15_START_HI_RSTVAL   0x00000000UL

#define XOCM_XMPU_R15_START_HI_ADDR_SHIFT   0UL
#define XOCM_XMPU_R15_START_HI_ADDR_WIDTH   12UL
#define XOCM_XMPU_R15_START_HI_ADDR_MASK    0x00000fffUL
#define XOCM_XMPU_R15_START_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR15EndLo
 */
#define XOCM_XMPU_R15_END_LO    ( ( XOCM_XMPU_BASEADDR ) + 0x00000278UL )
#define XOCM_XMPU_R15_END_LO_RSTVAL   0x00000000UL

#define XOCM_XMPU_R15_END_LO_ADDR_SHIFT   0UL
#define XOCM_XMPU_R15_END_LO_ADDR_WIDTH   32UL
#define XOCM_XMPU_R15_END_LO_ADDR_MASK    0xffffffffUL
#define XOCM_XMPU_R15_END_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR15EndHi
 */
#define XOCM_XMPU_R15_END_HI    ( ( XOCM_XMPU_BASEADDR ) + 0x0000027CUL )
#define XOCM_XMPU_R15_END_HI_RSTVAL   0x00000000UL

#define XOCM_XMPU_R15_END_HI_ADDR_SHIFT   0UL
#define XOCM_XMPU_R15_END_HI_ADDR_WIDTH   12UL
#define XOCM_XMPU_R15_END_HI_ADDR_MASK    0x00000fffUL
#define XOCM_XMPU_R15_END_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR15Master
 */
#define XOCM_XMPU_R15_MASTER    ( ( XOCM_XMPU_BASEADDR ) + 0x00000280UL )
#define XOCM_XMPU_R15_MASTER_RSTVAL   0x00000000UL

#define XOCM_XMPU_R15_MASTER_MSK_SHIFT   16UL
#define XOCM_XMPU_R15_MASTER_MSK_WIDTH   10UL
#define XOCM_XMPU_R15_MASTER_MSK_MASK    0x03ff0000UL
#define XOCM_XMPU_R15_MASTER_MSK_DEFVAL  0x0UL

#define XOCM_XMPU_R15_MASTER_ID_SHIFT   0UL
#define XOCM_XMPU_R15_MASTER_ID_WIDTH   10UL
#define XOCM_XMPU_R15_MASTER_ID_MASK    0x000003ffUL
#define XOCM_XMPU_R15_MASTER_ID_DEFVAL  0x0UL

/**
 * Register: XocmXmpuR15Cfg
 */
#define XOCM_XMPU_R15_CFG    ( ( XOCM_XMPU_BASEADDR ) + 0x00000284UL )
#define XOCM_XMPU_R15_CFG_RSTVAL   0x00000008UL

#define XOCM_XMPU_R15_CFG_NSCHECKTYPE_SHIFT   4UL
#define XOCM_XMPU_R15_CFG_NSCHECKTYPE_WIDTH   1UL
#define XOCM_XMPU_R15_CFG_NSCHECKTYPE_MASK    0x00000010UL
#define XOCM_XMPU_R15_CFG_NSCHECKTYPE_DEFVAL  0x0UL

#define XOCM_XMPU_R15_CFG_REGIONNS_SHIFT   3UL
#define XOCM_XMPU_R15_CFG_REGIONNS_WIDTH   1UL
#define XOCM_XMPU_R15_CFG_REGIONNS_MASK    0x00000008UL
#define XOCM_XMPU_R15_CFG_REGIONNS_DEFVAL  0x1UL

#define XOCM_XMPU_R15_CFG_WRALLOWED_SHIFT   2UL
#define XOCM_XMPU_R15_CFG_WRALLOWED_WIDTH   1UL
#define XOCM_XMPU_R15_CFG_WRALLOWED_MASK    0x00000004UL
#define XOCM_XMPU_R15_CFG_WRALLOWED_DEFVAL  0x0UL

#define XOCM_XMPU_R15_CFG_RDALLOWED_SHIFT   1UL
#define XOCM_XMPU_R15_CFG_RDALLOWED_WIDTH   1UL
#define XOCM_XMPU_R15_CFG_RDALLOWED_MASK    0x00000002UL
#define XOCM_XMPU_R15_CFG_RDALLOWED_DEFVAL  0x0UL

#define XOCM_XMPU_R15_CFG_EN_SHIFT   0UL
#define XOCM_XMPU_R15_CFG_EN_WIDTH   1UL
#define XOCM_XMPU_R15_CFG_EN_MASK    0x00000001UL
#define XOCM_XMPU_R15_CFG_EN_DEFVAL  0x0UL

/**
 *@endcond
 */

#ifdef __cplusplus
}
#endif

#endif /* __XOCM_XMPU_H__ */
