#   Copyright (c) 2016, Xilinx, Inc.
#   SPDX-License-Identifier: BSD-3-Clause



import os

from .device import Device
from .global_state import (
    GlobalState,
    global_state_file_exists,
    load_global_state,
    save_global_state,
)
from .hwh_parser import HWH, get_hwh_name

if os.environ.get("XILINX_XRT", False):
    from .embedded_device import EmbeddedDevice
    from .xclbin_parser import XclBin
    from .xrt_device import XrtDevice

if os.environ.get("PYNQ_REMOTE_DEVICES", False):
    from .remote_device import RemoteDevice


